function y=ErbRateToHz(x)

% ERBRATETOHZ Convert ERB rate to Hz.
% 
% SYNTAX
% 
%     Y = ERBRATETOHZ(X)
% 
% 
% DESCRIPTION
% 
% Y = HZTOERBRATE(X) converts the ERB number X to the eqivalent frequency Y
% (in Hz).
% 
% 
% See also HZTOERBRATE

y=(10.^(x/21.4)-1)/4.37e-3;

% Copyright 2010, Chris Hummersone and University of Surrey
% 
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
% EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT 
% OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS 
% BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION 
% OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
% WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.