function zArray = doBf(xArray, fs, BfString, SrcPosString, WorkDir) 
% BfString = {'ds','cvx'}
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  HEADER:  
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
params = [];  % Set parameters. 
%addpath(genpath(pwd)); % Set paths. 

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  DEFINITIONS:  
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
params.Ma.Basic.c                     = 343.57;                                                                      % sound veolcity 
params.Ma.Basic.nBin                  = 2^9;                                                                         % number of bins per frame or frame size (use 2^N)
params.Ma.Basic.dAngleAzim            = 1;                                                                           % angular resolution in azimuth 
params.Ma.Basic.dAngleElev            = 1;                                                                           % angular resolution in elevation 
params.Ma.Basic.AzimArray             = 0 : params.Ma.Basic.dAngleAzim : 360-params.Ma.Basic.dAngleAzim;             % azimuth angles 
params.Ma.Basic.ElevArray             = 0 : params.Ma.Basic.dAngleElev : 180;                                        % elevation angles 
params.Ma.Basic.nAzim                 = length(params.Ma.Basic.AzimArray);                                           % number of azimuth angles 
params.Ma.Basic.nElev                 = length(params.Ma.Basic.ElevArray);                                           % number of elevation angles 
params.Ma.Beam.Type                   = BfString;                                                                    % beamformer  
params.Ma.Array.MicType               = 0; 
params.Ma.Array.nMicTotal             = 6; 
params.Global.Audio.InpFs             = fs;                                                                          % sampling frequency 
params.Global.Audio.OutFs             = fs;                                                                          % sampling frequency of output files  
params.Global.Display.isProgression   = 1;                                                                           % display counter progression in command window
params.Global.Display.isIntermediate  = 1;                                                                           % display intermediate counter progression in command window
params.Global.Audio.df                = (params.Global.Audio.OutFs)*(1/params.Ma.Basic.nBin);
params.Global.Audio.fArray            = params.Global.Audio.df : params.Global.Audio.df : params.Global.Audio.OutFs; % Due to the restriction to fs/2, only the half number of frequency bins have to be considered in weights computation. 

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  DEFINITIONS: Get additional parameters/infos. 
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

MicArray = readMicData([WorkDir '/bf/files/chn.txt']); 
SrcArray = readSrcData([WorkDir '/bf/files/src.txt'],SrcPosString);

MicArray = MicArray / 100; % cm -> m
SrcArray = SrcArray / 100; % cm -> m

nChannel = size(MicArray,2); 

MapArray = MicArray(:,nChannel); 

MicArray = MicArray - MapArray(:,ones(1,nChannel)); 
SrcArray = SrcArray - MapArray; 
 
for iChannel = 1:nChannel
   [params.Ma.Array.Mic.rArray(iChannel,1), params.Ma.Array.Mic.AzimArray(iChannel,1), params.Ma.Array.Mic.ElevArray(iChannel,1)] = computeCartesian2Spherical(MicArray(1,iChannel), MicArray(2,iChannel),MicArray(3,iChannel));     
end

[rSrc, AzimSrc, ElevSrc] = computeCartesian2Spherical(SrcArray(1), SrcArray(2), SrcArray(3));   

params.Ma.Source.Dist = rSrc; 
params.Ma.Source.Elev = ElevSrc; 
params.Ma.Beam.Sd     = [AzimSrc,ElevSrc]; 

[~, params.Ma.Beam.AngleIndexAzim]    = min(abs(params.Ma.Basic.AzimArray - params.Ma.Beam.Sd(1)));                  % indices of azimuth angles  
[~, params.Ma.Beam.AngleIndexElev]    = min(abs(params.Ma.Basic.ElevArray - params.Ma.Beam.Sd(2)));                  % indices of elevation angles 

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  PROCESS: Do beamforming. 
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                  
load([WorkDir '/bf/weights' BfString '/w_' regexprep(SrcPosString,'/','') '.mat']); 

[nSample,nChannel] = size(xArray); 

nBin               = params.Ma.Basic.nBin; 
nBin               = nBin/2;
nFrame             = floor(nSample / nBin);
% Time Domain
SigOut             = zeros(nBin, 1); 
SigOutPre          = zeros(nBin*2, 1); 
% Frequency Domain 
SpecInp            = zeros(nChannel, nBin); 
SpecOut            = zeros(nBin, 1); 
SpecOutPre         = zeros(nBin, 1); 

for iFrame = 1:nFrame-1
    % Compute a sample index. 
    SIdx = (iFrame-1)*nBin+1; 
    
    
    % Determine samples of single/double frame (used for overlap). 
    FrameCurS = SIdx:SIdx+  nBin-1; % single frame (short) 
    FrameCurL = SIdx:SIdx+2*nBin-1; % double frame (long)
    
    
    % Convert Signal into f-Domain:  
    for iChannel = 1:nChannel
        SpecInp(iChannel,:) = cmpSpecSignal(xArray(FrameCurL,iChannel));        
    end
    
    
    % Calculate weights, if beamformer is data-dependent. Therefore, flag
    % has to be set to '1', otherwise '0'. 
    SpecOut(:) = sum(WeightsArray .* SpecInp);

    
    % Convert signal into t-Domain for saving it as a wav-file. 
    [SigOut(FrameCurS), SigOutPre] = cmpTimeSignal(SpecOut, SigOutPre);


    % Save previous spectrum for overlap. 
    SpecOutPre(:) = SpecOut;
end
SigOut(FrameCurS) = SigOutPre(nBin+1:2*nBin);

zArray = SigOut;     

end
