%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  INFOS 
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
% Author: Hannes Pessentheiner 
% Date  : 06. July 2011 
% Update: 22. January 2012
%
% Function: 
%   [spec] = cmpSpecSignal(sig)
%
% Script/Function Description: 
%   This script calculates the weighted short term spectrum of an audio
%   frame. 
%
% Input-Parameters: 
%   (array) sig         ... signal/audio frame in time domain (len: 2N) 
%
% Output-Parameters:
%   (array) spec        ... lower half of the spectrum (len: N) 



function [spec] = cmpSpecSignal(sig)
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  DEFINITIONS 
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
len  = length(sig);

% Calculate FFT of windowed/weighted frame 
n    = (0:len-1)'/(len-1); 
win  = sin(pi*n); 
spec = fft(win .* sig);

% Only return the lower half of the spectrum (spectrum symmetric) 
spec = spec(1:len/2);
