%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  INFOS 
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
% Author: Hannes Pessentheiner 
% Date  : 03. July 2011 
% Update: 14. September 2011 
%
% Function: 
%   [spec] = cmpSTFT(params,sig)
%
% Script/Function Description: 
%   This script calculates the short time Fourier Transformation of an
%   audio signal (mono). 
%
% Input-Parameters: 
%   (struct) params      ... structure containing global parameters 
%   (array)  sig         ... signal/audio frame in time domain (len: 2N) 
%
% Output-Parameters:
%   (array)  spec        ... spectrogram 



function [spec] = cmpSTFT(params, sig)
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  DEFINITIONS 
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
numBins = params.Basic.NumBins; 
win     = window(@hann,numBins); 



%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  PROCESS 
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%Create blocks (Signal,Block-Size,Overlap,'nodelay')
sig  = buffer(sig,numBins,numBins/2,'nodelay'); 
sig  = sig .* repmat(win,1,size(sig,2)); 
SIG  = fft(circshift(sig,numBins/2),numBins); 
%SIG  = fft(circshift(sig,numBins/2),numBins)/sqrt(numBins); 

% Only return the lower half of the spectrum (spectrum symmetric) 
spec = SIG(1:end/2,:); 