function [] = setFigureProperties(FigureType, FigureHandle, FigureVisibleString, FigureColorMapString) 
% FUNCTION DESCRIPTION: 
%   Sets specific style parameters to the current plot. 
% 
% INPUT PARAMETERS: 
%   (string) FigureType             ... figure type (plot, stem, mesh) 
%   (struct) FigureHandle           ... handle of current figure 
%   (string) FigureVisibleString    ... figure visibility (on/off)
%   (string) FigureColorMapString   ... colormap
%
% UPDATE: 09. October 2012, Hannes Pessentheiner 

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  HEADER:   
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
if nargin < 2 
    error('ERROR: Not enough input parameters. Function terminated.');
elseif nargin < 3
    FigureVisibleString  = 'on'; 
    FigureColorMapString = flipud(pink);
elseif nargin < 4
    FigureColorMapString = flipud(pink); 
end

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  PROCESS:   
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ActiveFigureBool = ~isempty(findobj('type','figure')); 

if ActiveFigureBool
    set(gcf,'position', [0 0 650 600])
    set(gcf,'visible',FigureVisibleString)
    set(get(gca,'title' ),'fontsize',20)
    set(get(gca,'xlabel'),'fontsize',18)
    set(get(gca,'ylabel'),'fontsize',18)
    set(get(gca,'zlabel'),'fontsize',18)
    set(gca,'fontsize',16) % Set font size of grid. 
    set(gca,'box','off','tickdir','out','xminortick','on','yminortick','on','zminortick','on','xgrid','on','ygrid','on','zgrid','on','xcolor',[.1 .1 .1], 'ycolor',[.1 .1 .1], 'zcolor',[.1 .1 .1]); 
    set(FigureHandle,'linewidth',2)
        
    if strcmp(FigureType,'plot')
        set(get(gca,'XLabel'),'Position', get(get(gca,'XLabel'),'Position')-[0 0.001 0])
        set(get(gca,'XLabel'),'Units','pixels')
    elseif strcmp(FigureType,'mesh')
        colormap(FigureColorMapString)
        set(FigureHandle,'facecolor','interp')
        set(FigureHandle,'edgecolor','interp')
    elseif strcmp(FigureType,'surf')
        colormap(FigureColorMapString)
        set(FigureHandle,'edgecolor','none')
    elseif strcmp(FigureType,'scatter')
        set(FigureHandle,'MarkerFaceColor','black','MarkerEdgeColor','black'); 
        axis equal; 
    end
else 
    msg = 'No figures set.'; 
    warning(msg);
end

end