function [] = makeScatter(x, y, xab, yab, TitleString, XlabelString, YlabelString) 
% FUNCTION DESCRIPTION: 
%   Generates a scatter plot. 
%
% INPUT PARAMETERS: 
%   (array)  x              ... input data for abscissa (x-coordinate) 
%   (array)  y              ... input data for ordinate (y-coordinate)
%   (array)  xab            ... abscissa interval [a,b]
%   (array)  yab            ... ordinate interval [a,b]
%   (string) TitleString    ... figure title 
%   (string) XlabelString   ... abscissa caption 
%   (string) YlabelString   ... ordinate caption 
%
% UPDATE: 09. October 2012, Hannes Pessentheiner 

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  HEADER:   
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
if nargin < 2
    error('ERROR: Not enough input parameters. Function terminated.');
elseif nargin < 3
    epsy = (max(y)-min(y)) / length(y);
    xab  = [min(x)     , max(x)     ]; 
    yab  = [min(y)-epsy, max(y)+epsy]; 
    TitleString  = ''; 
    XlabelString = '';
    YlabelString = ''; 
elseif nargin < 4
    yab = [min(y), max(y)]; 
    TitleString  = ''; 
    XlabelString = '';
    YlabelString = ''; 
elseif nargin < 5
    TitleString  = ''; 
    XlabelString = '';
    YlabelString = '';     
elseif nargin < 6
    XlabelString = '';
    YlabelString = '';      
elseif nargin < 7
    YlabelString = '';  
end

if isempty(xab) || isempty(yab) 
    epsy = (max(y)-min(y)) / length(y);
    xab  = [min(x)     , max(x)     ]; 
    yab  = [min(y)-epsy, max(y)+epsy]; 
end

if (nargin > 5) && (~isempty(TitleString))
    fprintf(['PLOT ' TitleString ' ... ' ]); 
end

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  PROCESS:   
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
g = figure(1); 
h = scatter(x,y,'filled'); 

xlim(xab); 
ylim(yab); 

title (TitleString); 
xlabel(XlabelString); 
ylabel(YlabelString);

setParametersFigure('scatter',h); 

%close(g); 

end