function [] = makeMesh(x, y, Z, DisplayMode, TitleString, XlabelString, YlabelString, ZlabelString) 
% FUNCTION DESCRIPTION: 
%   Generates a mesh surface. 
%
% INPUT PARAMETERS: 
%   (array)  x            ... input data for x-coordinate 
%   (array)  y            ... input data for y-coordinate
%   (array)  Z            ... input data for z-coordinate
%   (bool)   DisplayMode  ... flatten figure if DisplayMode=0
%   (string) TitleString  ... figure title 
%   (string) XlabelString ... x-coordinate caption 
%   (string) YlabelString ... y-coordinate caption 
%   (string) ZlabelString ... z-coordinate caption 
%
% UPDATE: 09. October 2012, Hannes Pessentheiner 

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  HEADER:   
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
if nargin < 4
    error('ERROR: Not enough input parameters. Function terminated.');
elseif nargin < 5
    TitleString  = ''; 
    XlabelString = '';
    YlabelString = ''; 
    ZlabelString = ''; 
elseif nargin < 6
    XlabelString = '';
    YlabelString = ''; 
    ZlabelString = ''; 
elseif nargin < 7
    YlabelString = '';  
    ZlabelString = ''; 
elseif nargin < 8
    ZlabelString = ''; 
end

if (nargin > 6) && (~isempty(TitleString))
    fprintf(['\nPLOT ' TitleString ' ... ' ]); 
end

OPT_TORAD = pi/180; 

x = squeeze(x); 
y = squeeze(y); 
Z = squeeze(Z); 
W = Z; 

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  PROCESS:   
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
if ~DisplayMode
    [X,Y]     = meshgrid(x,y); 
    OPT_VIEW  = [00 90];
else 
    [AzimArray,ElevArray] = meshgrid(x,y);  
    X = W .* sin(ElevArray * OPT_TORAD) .* cos(AzimArray * OPT_TORAD); 
    Y = W .* sin(ElevArray * OPT_TORAD) .* sin(AzimArray * OPT_TORAD);
    Z = W .* cos(ElevArray * OPT_TORAD); 
    OPT_VIEW  = [65 25];
end

% Create figure. 
g = figure(); 
h = mesh(X,Y,Z,W);
a = colorbar('peer',gca);
set(a,'fontsize',12);
set(get(a,'ylabel'),'string','Gain (dB)'); 
set(get(a,'ylabel'),'fontsize',18); 

if ~DisplayMode
    axis([min(min(X)) max(max(X)) min(min(Y)) max(max(Y)) min(min(Z)) max(max(Z))]); 
else    
    axis([-1 1 -1 1 -1 1]); 
end

title (TitleString);
xlabel(XlabelString); 
ylabel(YlabelString);
zlabel(ZlabelString);
view(OPT_VIEW); 

setFigureProperties('mesh',h); 

%close(g); 

end