function [Paths] = makeDirectories(TmpPathString) 
% FUNCTION DESCRIPTION: 
%   Creates directories and returns corresponding paths. 
% 
% INPUT PARAMETERS: 
%   (string) bf      ... beamformer 
%   (array)  sd      ... steering direction
%   (int)    nMic    ... number of microphones 
%   (int)    MicType ... microphone type 
%
% OUTPUT PARAMETERS: 
%   (string) Paths.Temp       ... path of temporary data 
%   (string) Paths.Data       ... path of data 
%   (string) Paths.CfsErr     ... path of cfs error messages 
%   (string) Paths.CfsOut     ... path of cfs progression messages 
%   (string) Paths.CfsOutData ... path of cfs output data 
%
% UPDATE: 09. October 2012, Hannes Pessentheiner 

warning('off'); 
    mkdir(TmpPathString);
warning('on'); 

Paths.Temp = TmpPathString; 

end
