function [rArray, azimArray, elevArray] = computeCartesian2Spherical(xArray, yArray, zArray)
% FUNCTION DESCRIPTION: 
%   Transforms cartesian into spherical coordinates. 
% 
% INPUT PARAMETERS: 
%   (array) xArray ... x-coordinates  
%   (array) yArray ... y-coordinates
%   (array) zArray ... z-coordinates
%
% OUTPUT PARAMETERS: 
%   (array) rArray    ... radii            (m) 
%   (array) azimArray ... azimuthal angles (deg)
%   (array) elevArray ... elevation angles (deg)  
%
% UPDATE: 12. October 2012, Hannes Pessentheiner 

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  HEADER:   
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
if nargin < 3
    error('ERROR: Not enough input parameters. Function terminated.');
end

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  DEFINITIONS:   
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
OPT_TORAD = pi/180; 
xArray = xArray(:); 
yArray = yArray(:); 
zArray = zArray(:); 

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  PROCESS:   
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
rArray    = sqrt(xArray.^2 + yArray.^2 + zArray.^2); 
azimArray = atan2(yArray, xArray) * 1 / OPT_TORAD; 
azimArray(azimArray<0) = azimArray(azimArray<0) + 360; 

rEpsArray = rArray; 
rEpsArray(rEpsArray < eps) = eps; 
elevArray = acos(zArray ./ rEpsArray) / OPT_TORAD; 

end