function [WeightsArray, isDependent] = computeBeamWeights(params, CapturingResponseLinArray) 
% FUNCTION DESCRIPTION: 
%   Computes the beamformer weights. Core function of this 
%   application and has to be optimized and simplified in 
%   future time to increase processing speed.    
% 
% INPUT PARAMETERS: 
%   (struct) params                    ... structure containing parameters
%   (array)  CapturingResponseLinArray ... array containing linear capturing response 
%
% OUTPUT PARAMETERS: 
%   (array)  WeightsArray ... beamformer weights
%   (bool)   isDependent  ... information about data-dependency of beamformer 
%   
% UPDATE: 08. October 2012, Hannes Pessentheiner 

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  HEADER:  
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
fprintf('\nCOMPUTE Beamformer Weights ... '); 

if nargin < 1
    error('ERROR: Not enough input parameters. Function terminated.');
end

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  DEFINITIONS:  
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
WeightsArray = zeros(params.Ma.Array.nMicTotal, params.Ma.Basic.nBin/2, 'single'); 
% Use single precision to reduce memory requirements and increase
% processing speed. Use double precision for highly accurate 
% experiments only. 

DesiredFrequencyResponseArray = computeDesiredFrequencyResponse(params.Ma.Basic.nBin, params.Global.Audio.OutFs);
% Determine desired frequency response.            

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  PROCESS:  
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
% Compute beamformer weights. Consider one half of bins only due to 
% aliasing and the LP-filtering of the Dfr-Filter. 
for iBin = 1:params.Ma.Basic.nBin/2
    computeProgression(iBin                                , ...
                       params.Ma.Basic.nBin/2              , ...
                       params.Global.Display.isProgression);
                   
    idxStart   = params.Ma.Basic.nElev*(iBin-1)+1;
    idxEnd     = params.Ma.Basic.nElev*(iBin); 
    idx        = idxStart:idxEnd; 
    
    funHandle  = str2func(params.Ma.Beam.Type); 
        
    [WeightsArray(:,iBin), isDependent] = feval(funHandle, params, iBin, CapturingResponseLinArray(idx,:,:));     
    [WeightsArray(:,iBin)             ] = DesiredFrequencyResponseArray(iBin) * squeeze(WeightsArray(:,iBin));
end 

% Store weights. 
save([params.Global.Paths.Temp '/w'],'WeightsArray'); 

end