function xmonoest=BForm(y,pos,do,bn,x,P)
%BeamForming
%y:             noisy signal (multi-channel)
%pos:           speaker position (LO02, LC08, ....)
%do:            dir out where you can write and delete intermediate results
%bn:            basename (for speaker-utterance identification) 
%x:             clean signal (multi-channel, only for comparations)
%P:             parameter structure (FSamp, etc..)
%xmonoest:      enhaced clean signal (mono or single-channel)




WorkDir=[P.SMRoot '/ExtFeat/HannFun'];

if((P.BFormK==0)) 
    xmonoest=y(:,end);
elseif(strcmp(pos,'-1'))
     fprintf('WARNING: not valid position, then xmonoest=y(:,end)\n');
     xmonoest=y(:,end);     
elseif(P.BFormK==1) 
    posh=[pos(1:2) '/' pos(3:4)]; 
    xmonoest = doBf(y, P.FSamp, 'ds', posh, WorkDir); 
elseif (P.BFormK==2) 
    posh=[pos(1:2) '/' pos(3:4)]; 
    xmonoest = doBf(y, P.FSamp, 'cvx', posh, WorkDir); 
else
    fprintf('ERROR: Unkonw KBForm\n');
end





%subplot(211), plot(y(:,6))
%subplot(212), plot(xmonoest)
%pause


