function [pf,xest]=FPitCleanEst(ys, xs, do, bn, P, opt, SFE)
%

%Take monaural noiosy signal (placed in the last column)
y=ys(:,end); x=xs(:,end); 


%Pitch extraction
%pa=AutocPit(x,P.FSamp,P.FSamp*P.FLSec,P.FSamp*P.FSSec,0.7,8,5/4);
%[py px]=YinPitch(x,x,P,P.vf,P.vth,P.veth);
pf=LoadFPit(do,bn,P.FSamp,P.SMRoot);
%pf=RefCleanPit(ys, xs, do, bn, P, opt, SFE, pf, py);



%Clean signal estimation (equal to noisy)
xest=y;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function PSa=LoadFPit(do,bn,FSamp,SMRoot)
%Load Franz Pit
[x, mixingLevel] = fileparts(do); mixingLevel=mixingLevel(1:end-2);
fny=[SMRoot '/ExtFeat/FranzFun/Fun/result_SD_MIXMAX_reverb_all_' mixingLevel '_0_1_5000_UBorLB_1_1.mat'];
fnx=[SMRoot '/ExtFeat/FranzFun/Fun/result_SD_MIXMAX_reverb_all_' 'CleanReverb' '_1_1_5000_UBorLB_1_1.mat'];
fnr=[SMRoot '/ExtFeat/FranzFun/Fun/RefPitch.mat'];
[i,j]=BnFPitCorresp(bn,SMRoot);

S=load(fny); PHz=state2pitch(S.dpTrackResult{i}{j}.trajectory1); nf=length(PHz); PSay=zeros(1,nf); v=PHz~=0; PSay(v)=FSamp./PHz(v);
S=load(fnx); PHz=state2pitch(S.dpTrackResult{i}{j}.trajectory1); nf=length(PHz); PSax=zeros(1,nf); v=PHz~=0; PSax(v)=FSamp./PHz(v);
S=load(fnr); PHz=S.dpTrackRefPitch{i}{j};           nf=length(PHz); PSar=zeros(1,nf); v=PHz~=0; PSar(v)=FSamp./PHz(v);

nf=min([length(PSay) length(PSax), length(PSar)]);
PSa=[PSay(1:nf); PSax(1:nf); PSar(1:nf)];


function [io,jo]=BnFPitCorresp(bn,SMRoot)
%Basename Franz Pitch Correspondences
%BnFPitCorresp('./BnFPitCorresp.txt')
io=-1; jo=-1;
NS=load([SMRoot '/ExtFeat/FranzFun/Fun/DevelSetFileList.mat']);
for i=1:34 
   l=length(NS.DevelSetFileList{i});
   for j=1:l
       b=NS.DevelSetFileList{i}{j};
       if(strcmp(bn,b))
        io=i; jo=j;   
       end
   end
end





    





