function S=ExtFeat(ys, xs, do, bn, P, opt, SFE)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%External Features. Interface to comunicate the FE with your external
%function
%
%INPUTS:
%   ys: Stereo noisy signal. Matrix where ys(:,1) and ys(:,2) 
%       are the 1st and 2nd microphone channels and ys(:,3)=(ys(:,1)+ys(:,2))/2
%       is the monoaural signal.        
%   xs: Stereo clean signal. You can use to compare your e.g. pitch, 
%       clean signals estimates. The real additive noise can be obtained as
%       ns=ys-xs.
%   do: Output dir. Usefull to write your intermediate results 
%       (please, if you delete later).
%       Feature like Cepstrogram, MD mask will be written in. 
%   bn: Base name of the file. E.g. s29_pbiz6p, s28_lgac8s,.. You can use
%       it to identify the speaker.
%   P:  Parameters Structure of the FE. E.g. P.FSamp (Sample Freq) P.FSSec
%       (Frame Shift in seconds),... you can use it to employ the same
%       configuration.
%   opt: Vector of options which directly comunicate to the Reconition Engine. 
%       Usefull for tuning the parameters of your function in term of WAcc
%   SFE: Input Structure of the FE. To take informations from the FE. You can use 
%       the FE noisy spectrogram (SFE.Y), the FE FilterBank (SFE.Fby),... 
%OUTPUTS:
%   S: 	Output Structure. To provide information to 
%       the FE. You can put your pitch (S.py), your clean and noise
%       signal estimations (S.nest and S.xest), your clean spectrogram
%       (S.Xest), your Direction mask (S.DMask), etc..   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
% IMPORTANT OUTPUT NOTATION:
% Pitch estimation: 			S.py 
% Clean temporal est.: 			S.xest
% Noise temporal est.:			S.nest
% Direction Mask est.: 			S.DMask
% Clean Magnitude espectrog. est:	S.Xest


[pit,xestima]=FPitCleanEst(ys, xs, do, bn, P, opt, SFE);


S.py=pit;
S.xest=xestima;
%S.nest=xestima;


