function x_est= softBmapImputation( y, w, gmm, k )

MAX_ITER= 5;
MIN_ERR= 1e-4;

%The MAP estimate is the unconditional mean of the unreliable components
if strcmp(gmm.covar_type,'diag')
    x_est= softMapImputation(y, w, gmm, k);
%BMAP estimation proposed by Raj2004
else
    mu= gmm.centres(k,:)';
    S= gmm.covars(:,:,k);
     
    %1. Initialization of the estimate
%     x_est= y; %Default initialization proposed by Raj
    x_est= min([mu y], [], 2);
    xest_prev= x_est;
   
    %2. Main loop
    i= 0;
    err= Inf;
    while i<MAX_ITER && err>MIN_ERR
        for j= 1:length(y)
            %2a. Compute the MAP estimate for unreliable component j
            %assuming that all the others components are reliable
            m= true(size(y));
            m(j)= false;
            mu_r= mu(m);
            mu_u= mu(j)'; 
            [Sr, Sur, Su]= splitCovariance(S, m);
            z= Sr\(x_est(m)-mu_r); %z= inv(Sr) * (x_est(m)-mu_r)
            x_est(j)= mu_u + Sur*z;

            %2b. Computation of the bounded estimate
            x_est(j)= min(x_est(j), y(j));            
        end
        
        err= sum(abs(x_est-xest_prev));
        %disp( ['It. ' num2str(i) ' error: ' num2str(err)]);
        
        xest_prev= x_est;
        i= i+1;
    end

    x_est= w.*y + (1-w).*x_est;
    %x_est= x_est; %Ning's proposal
end
