function x_est= softBCMImputation2( y, w, gmm, k )
u= gmm.centres(k,:)';
if strcmp(gmm.covar_type,'diag')
    s= sqrt(gmm.covars(:,k));
else
    s= sqrt(diag(gmm.covars(:,:,k)));
end

z= (y-u)./s;
correction= s.*normpdf(z)./normcdf(z);
x_est= w.*y + (1-w).*(u-correction);
x_est= min([x_est y], [], 2); %Bounded imputation: 0<= xu(i) <= y(i)
