function simpleNoiseEstimation ( fileList, nframes, computeVar, byteOrder )

%===================================
%     CHECKING THE ARGUMENTS
%===================================

if nargin < 4
    byteOrder= 'l'; %Big-endian
end

if nargin < 3
    computeVar= 0;
else
    computeVar= str2double( computeVar );
end

if nargin < 2
    nframes= 10;
else
    nframes= str2double( nframes );
end

%===================================
%            MAIN PROGRAM
%===================================

if computeVar
    [listNoisy, listNest, listNvar]= textread( fileList, '%s %s %s' );
else
    [listNoisy, listNest]= textread( fileList, '%s %s' );
%     listNoisy= textread( fileList, '%s' );
end
nfiles= length(listNoisy);

% mse= 0;
for f=1:nfiles
    disp(['File ' num2str(f) '/' num2str(nfiles) ' ...']);
    
    [data, period, sampKind]= readhtk(listNoisy{f}, byteOrder);    
    
    if computeVar
        [nest nvar]= interpNoiseEstimation( data, nframes );
        writehtk(listNvar{f}, nvar, period, 9, byteOrder);
    else
        nest= interpNoiseEstimation( data, nframes );
    end
    
%     [path, name, ext]= fileparts( listNoisy{f} );
%     %cleanFile= ['A4/test_clean_wv1/fbank/' name ext];
%     cleanFile= ['../imputation/Aurora2/fbank/clean1/' name ext];
%     x= readhtk( cleanFile, byteOrder );
%     n= exp(data) - exp(x);    
%     mse= mse + sum( (n(:)-exp(nest(:))).^2 );

   writehtk(listNest{f}, nest, period, sampKind, byteOrder);
end
% log(mse/nfiles)