function out= restoreDataMSE( dataWin, varWin, winIndexes, frames, params )
out= zeros(params, frames);
for t=1:frames
    i= find( winIndexes==t )';
    i2= (i-1)*params+1;
    i3= repmat(i2, params, 1);
    i4= bsxfun(@plus, i3, (0:params-1)');
   
    x_est= dataWin(i4);
    var= varWin(i4);
    
    mse= sum(var)+0.1; %MSE for every reconstruction
    conf= mse/sum(mse);
    if length(i) > 1
        conf= (1-conf)/(length(i)-1);
    end
%     mse= sum(var);
%     conf= exp(-mse)/sum(exp(-mse));

    out(:,t)= sum( bsxfun(@times, x_est, conf), 2 );
end