function mask= ome( data, nest, nvar, gmm_x )

%--------------------------------------------------
% Function definition
%--------------------------------------------------

mask= zeros( size(data) );
[params frames]= size(data);
K= gmm_x.ncentres;
px_y= zeros(params, K); %px(y|k)
Px_y= zeros(params, K); %Px(x<=y|k)
for t= 1:frames
    y= data(:,t);
    n= nest(:,t);
    sn= nvar(:,t);

    %Precompute the probabilities used in the estimation and the partial
    %estimates
    pn_y= probability( y, n, sn );
    Pn_y= cumulativeProb( y, n, sn );
    for k= 1:K
        if strcmp(gmm_x.covar_type,'diag')
            px_y(:,k)= probability( y, gmm_x.centres(k,:)', gmm_x.covars(k,:)' );
            Px_y(:,k)= cumulativeProb( y, gmm_x.centres(k,:)', gmm_x.covars(k,:)' );
        else
            px_y(:,k)= probability( y, gmm_x.centres(k,:)', diag(gmm_x.covars(:,:,k)) );
            Px_y(:,k)= cumulativeProb( y, gmm_x.centres(k,:)', diag(gmm_x.covars(:,:,k)) );
        end
    end
    
    % -- Compute the posteriors P(k|y) for every Gaussian
    %p(y|k)= px(y|k)Pn(n<=y) + pn(y)Px(x<=y)
    py= bsxfun(@times, px_y, Pn_y) + bsxfun(@times, Px_y, pn_y);
    p= prod(py) .* gmm_x.priors;
    p= p/sum(p);

    %MMSE estimation for every Gaussian component
    W= bsxfun(@times, px_y, Pn_y) ./ py; %Weighting matrix
    W(isnan(W) | isinf(W))= 1;
    mask(:,t)= sum(bsxfun(@times, W, p), 2);
end


%--------------------------------------------------------------------------
function p= probability( x, mean, sigma2 )
invs= 1./sqrt(sigma2);
z= invs.*(x-mean);
p= normpdf(z).*invs;


%--------------------------------------------------------------------------
function p= cumulativeProb( x, mean, sigma2 )
z= (x-mean)./sqrt(sigma2);
p= normcdf(z);
