function varargout= mapImputation( y, m, gmm, k )
xr= y(m);
mu_r= gmm.centres(k,m)';
mu_u= gmm.centres(k,~m)';

%The MMSE estimate is the unconditional mean of the unreliable components
if strcmp(gmm.covar_type,'diag')
    xu_est= mu_u;
    S_est= diag( gmm.covars(k,~m) );
%The MMSE estimate is the conditional mean given the reliable components
else
    if isempty(xr)
        xu_est= mu_u;
        if iscell(gmm.covars)
            S_est= full(gmm.covars{k});
        else
            S_est= gmm.covars(:,:,k);
        end
    else
        if iscell( gmm.covars )
            S= gmm.covars{k};
        else
            S= gmm.covars(:,:,k);
        end
        [Sr,Sur,Su]= splitCovariance(S, m);
        A= Sur/Sr;
        xu_est= mu_u + A*(xr-mu_r);

        if nargout > 1
            S_est= full(Su - A*Sur'); %Su - Sur*inv(Sr)*Sru;
        end
    end
end

est= min(xu_est, y(~m)); %Bounded imputation: 0<= xu(i) <= y(i)
varargout{1}= est;
if nargout > 1
    varargout{2}= S_est;
end