function varargout= interpNoiseEstimation( y, nframes )
%function varargout= interpNoiseEstimation( noisy, nframes )

MIN_VAR= 0.05;

% y= exp( noisy);
frames= size( y, 2 );

n_avg1= mean(y(:,1:nframes), 2);
n_avg2= mean(y(:,end-nframes+1:end), 2);
rf= frames-2*nframes;
n_interp= interp1([1 rf+2]', [n_avg1 n_avg2]', 2:rf+1);
n= [y(:,1:nframes) n_interp' y(:,end-nframes+1:end)];
n= min(y, n);

% varargout{1}= log(n);
varargout{1}= n;
if nargout > 1
    v= [y(:,1:nframes) y(:,end-nframes+1:end)];
    nvar= var( v, 0, 2 );
    Mvar= repmat(nvar, 1, frames);
    Mvar(:,1:nframes)= MIN_VAR;
    Mvar(:,end-nframes+1:end)= MIN_VAR;
    varargout{2}= Mvar;
end
