function P= boundedProbability2 ( y, m, gmm, k, logProbs )

LOWER_BOUND= -Inf;

if nargin == 4
    logProbs= false;
end

%Bounded probability assuming diagonal covariance matrices
if strcmp(gmm.covar_type,'diag')
    P= boundedProbabilityDiag( y, m, gmm, k, logProbs );
else
    xr= y(m);
    xu= y(~m);
    u= gmm.centres(k,:)';
    ur= u(m);
    uu= u(~m);
    if iscell( gmm.covars )
        S= gmm.covars{k};
    else
        S= gmm.covars(:,:,k);
    end
    [Sr, Sur, Su]= splitCovariance( S, m );

    %Probability of the reliable components
    if isempty(xr)
        pr= 1;
        u_u_r= uu;
        S_u_r= Su;
%     elseif abs(det(Sr))<1e-8
    elseif ~isempty( find(full(diag(abs(Sr)))<=1e-3, 1) )
        pr= mvnpdf(xr, ur, Sr);
        if ~isempty(xu)
            if isempty( find(full(diag(abs(Sr)))>1e-3, 1) )
                u_u_r= uu;
                S_u_r= Su;
            else
                m2= m & (full(diag(abs(S)))>1e-3);
                xr2= y(m2);
                ur2= gmm.centres(k,m2)';
                
                Sr2= S(m2,m2);
                Sur2= S(~m,m2);

%                 zr= Sr2 \ (xr2-ur2); %z= inv(Sr2) * (xr2-mu_r2)
%                 u_u_r= uu + Sur2*zr; %Mean of the conditional Gaussian distribution of u given r
%                 S_u_r= Su - Sur2*(Sr2\Sur2'); %Covariance of the conditional Gaussian distribution of u given r
                A= Sur2/Sr2;
                u_u_r= uu + A*(xr2-ur2); %Mean of the conditional Gaussian distribution of u given r
                S_u_r= Su - A*Sur2'; %Covariance of the conditional Gaussian distribution of u given r
            end
        end
    else
        pr= mvnpdf(xr, ur, Sr);        
        if ~isempty(xu)
%             zr= Sr \ (xr-ur);
%             u_u_r= uu + Sur*zr;
%             S_u_r= Su - Sur*(Sr\Sur');
            A= Sur/Sr;
            u_u_r= uu + A*(xr-ur);
            S_u_r= Su - A*Sur';
        end
    end

    %Prob of the unreliable components
    pu= 1;
    if ~isempty(xu)
        s_u_r= sqrt(abs(full(diag(S_u_r))));
        zu= (xu-u_u_r)./s_u_r;
        pu= normcdf( zu );
    end

    ck= gmm.priors(k); %Prior of the Gaussian k
    if logProbs
        P= sum( log([ck; pr; pu]) );
    else
        P= prod( [ck; pr; pu] );
    end
end
