function varargout= boundedConditionalMeanImputation2( y, m, gmm, k )

%The MMSE estimate is the unconditional mean of the unreliable components
if strcmp(gmm.covar_type,'diag')
    if nargout == 1
        xu_est= boundedConditionalMeanImputationDiag( y, m, gmm, k );
    else
        [xu_est S_est]= boundedConditionalMeanImputationDiag( y, m, gmm, k );
    end
%The MMSE estimate is the conditional mean given the reliable components
else
    xr= y(m);
    xu= y(~m);
    mu_r= gmm.centres(k,m)';
    mu_u= gmm.centres(k,~m)';
    if iscell( gmm.covars )
        S= gmm.covars{k};
    else
        S= gmm.covars(:,:,k);
    end
    
    [Sr,Sur,Su]= splitCovariance(S, m);
    if isempty(xr)
        mu_u_r= mu_u;
        Su_r= Su;
    %elseif  ~isempty( find(diag(Sr)<=1e-3, 1) ) %<<--- Avoid inversion of singular matrices: cov(fbank(0)) tends to be 0
%    elseif abs(det(Sr))<1e-8 %<<--- Avoid inversion of singular matrices: cov(fbank(0)) tends to be 0
    elseif ~isempty( find(full(abs(diag(Sr)))<=1e-3, 1) )
        if isempty( find(full(abs(diag(Sr)))>1e-3, 1) )
            mu_u_r= mu_u;
            Su_r= Su;
        else
            m2= m & (full(diag(S))>1e-3);
            xr2= y(m2);
            mu_r2= gmm.centres(k,m2)';
            
            Sr2= S(m2,m2);
            Sur2= S(~m,m2);
            
%             zr= Sr2 \ (xr2-mu_r2); %z= inv(Sr) * (xr-mu_r)
%             mu_u_r= mu_u + Sur2*zr; %Mean of the conditional Gaussian distribution of u given r
%             Su_r= Su - Sur2*(Sr2\Sur2'); %Covariance of the conditional Gaussian distribution of u given r
            A= Sur2/Sr2;
            mu_u_r= mu_u + A*(xr2-mu_r2); %Mean of the conditional Gaussian distribution of u given r
            Su_r= Su - A*Sur2'; %Covariance of the conditional Gaussian distribution of u given r
        end
    else
%         zr= Sr \ (xr-mu_r); %z= inv(Sr) * (xr-mu_r)
%         mu_u_r= mu_u + Sur*zr; %Mean of the conditional Gaussian distribution of u given r
%         Su_r= Su - Sur*(Sr\Sur'); %Covariance of the conditional Gaussian distribution of u given r
        A= Sur/Sr;
        mu_u_r= mu_u + A*(xr-mu_r); %Mean of the conditional Gaussian distribution of u given r
        Su_r= Su - A*Sur'; %Covariance of the conditional Gaussian distribution of u given r
    end
    
    su_r= sqrt(abs(full(diag(Su_r)))); %Standard deviation of the unreliable components given the observed ones
    zu= (xu-mu_u_r)./su_r;
    q= -normpdf(zu)./normcdf(zu);
    q(isnan(q) | isinf(q))= 0;
    correction= su_r.*q;
    
    xu_est= mu_u_r + correction;    
    if nargout > 1
        S_est= full( abs(diag(diag(Su_r).*(1 + q.*(zu-q)))) ); %We should also consider the error when approximating the non-diagonal covariance matrix with a diagonal one
    end
end

varargout{1}= min(xu_est, y(~m)); %Bounded imputation: 0<= xu(i) <= y(i)
if nargout > 1
    varargout{2}= S_est;
end
