function varargout= binaryImputation( data, mask, gmm, imputationAlgorithm, probComputation )

VAR_RELIABLE= 0; %Variance of the estimate for the reliable components

switch imputationAlgorithm
    case 'bmap'
        impute= @bmapImputation;
    case 'map'
        impute= @mapImputation;
    case 'faubel'
        impute= @boundedConditionalMeanImputation;
    case 'bcmi'
        impute= @boundedConditionalMeanImputation2;
    case 'eig'
        impute= @boundedConditionalMeanImputationEig;
    case 'svd'
        impute= @boundedConditionalMeanImputationSvd;
end

switch probComputation
    case 'diag'
        probability= @boundedProbabilityDiag;
    case 'faubel'
        probability= @boundedProbabilityFaubel;
    case 'bcp'
        probability= @boundedProbability2;
    case 'eig'
        probability= @boundedProbabilityEig;
    case 'svd'
        probability= @boundedProbabilitySvd;        
end

est= data;
if nargout > 1
    varest= zeros( size(data) ) + VAR_RELIABLE; %Variance of the reliable components
end

frames= size(data,2);
for i=1:frames
    y= data(:,i);
    m= mask(:,i);
    u= length(find(~m));

    %Check if there are any unreliable component
    if u>0        
        %Compute the posteriors for every Gaussian
        p= zeros(gmm.ncentres, 1);
        for k=1:gmm.ncentres
            p(k)= probability( y, m, gmm, k );
        end
        p= p/sum(p);
        
        %Compute the partial estimates
        xest= zeros(u, gmm.ncentres);
        if nargout > 1
            Sest= zeros( u, u, gmm.ncentres );
        end
        for k=1:gmm.ncentres
            if nargout > 1
                [xest(:,k) Sest(:,:,k)]= impute( y, m, gmm, k );
            else
                xest(:,k)= impute( y, m, gmm, k );
            end            
        end
        
        %Combine the partial estimates according to their posterior
        %probabilities
        y(~m)= sum(bsxfun(@times, xest, p'), 2);
        est(:,i)= min([data(:,i) y], [], 2); % -Inf <= xu(i) <= y(i)
        
        %Compute the variance for every estimate
        if nargout > 1
            diff= bsxfun(@minus, xest, y(~m));
            
            Si= zeros( u );
            for k=1:gmm.ncentres
                Si= Si + p(k)*(Sest(:,:,k) + diff(:,k)*diff(:,k)');
            end
            varest(~m,i)= diag(Si); %Variance of the unreliable components            
        end        
    end
end

varargout{1}= est;
if nargout > 1
    varargout{2}= varest;
end