function varargout= bcmiDiagFast ( y, m, gmm_xu, k )
xu= y(~m);
if ~isempty( xu )
    mu= gmm_xu.centres(k,:)';
    if strcmp(gmm_xu.covar_type,'diag')
        var_u= gmm.covars(k,:)';
    else
        if iscell( gmm_xu.covars )
            var_u= full(diag(gmm_xu.covars{k}));
        else
            var_u= diag(gmm_xu.covars(:,:,k));
        end
    end
    std_u= sqrt(var_u);
    zu= (xu-mu)./std_u;
    q= -normpdf(zu)./normcdf(zu);
    q(isnan(q) | isinf(q))= 0;
    correction= std_u.*q; %We assume that the imputation lower bound is -Inf
    xu_est= mu + correction;
    
    est= min([xu_est xu], [], 2); %Bounded imputation: 0<= xu(i) <= y(i)
    if nargout > 1
        varest= diag( var_u.*(1 + q.*(zu-q)) );
    end
else
    est= [];
    varest= [];
end

varargout{1}= est;
if nargout > 1
    varargout{2}= varest;
end