function varargout= bcmi2Fast( y, m, gmm, k )

xu= y(~m);
if ~isempty( xu )    
    %The MMSE estimate is the unconditional mean of the unreliable components
    if strcmp(gmm.covar_type,'diag')
        if nargout <= 1
           est= bcmiDiagFast( y, m, gmm, k );
        else
            [est S_est]= bcmiDiagFast( y, m, gmm, k );
        end
        %The MMSE estimate is the conditional mean given the reliable components
    else
        mu= gmm.centres(k,:)';
        if iscell( gmm.covars )
            S= gmm.covars{k};
        else
            S= gmm.covars(:,:,k);
        end
        s= sqrt(abs(full(diag(S)))); %Standard deviation of the unreliable components given the observed ones
        zu= (xu-mu)./s;
        q= -normpdf(zu)./normcdf(zu);
        q(isnan(q) | isinf(q))= 0;
        correction= s.*q;
        
        xu_est= mu + correction;
        est= min(xu_est, xu); %Bounded imputation: 0<= xu(i) <= y(i)
        if nargout > 1
            S_est= full(abs(diag( diag(S).*(1 + q.*(zu-q))))); %We should also consider the error when approximating the non-diagonal covariance matrix with a diagonal one
        end
    end
else
    est= [];
    S_est= [];
end

varargout{1}= est; 
if nargout > 1
    varargout{2}= S_est;
end
