
function x = read_mask_int16(fname, nchnls, byteorder)
% x = read_mask_int16(fname, nchnls, byteorder);
% Read binary masks

if nargin < 3
  byteorder = 'l';
end
if nargin < 2
  error('The number of channels required');
end

[fid, msg] = fopen(fname, 'r', byteorder);
if (fid < 0)
  fprintf('File not found: %s\n', fname);
else
  x = fread(fid, [nchnls,inf], 'int32');
  fclose(fid);
end

