
function x = read_mask_float32(fname, numchans, byteorder);
% x = read_mask_float32(fname, numchans, byteorder);
%   Use 'float32' for platform independency
% 

if nargin < 3
  byteorder = 'l';
end
if nargin < 2
  error('The number of channels required');
end

[fid, msg] = fopen(fname, 'r', byteorder);
if (fid < 0)
  fprintf('File not found: %s\n', fname);
else
  x = fread(fid, [numchans,inf], 'float32');
  fclose(fid);
end

