%MAKERATEMAP_C: A C implementation of MPC's makeRateMap matlab code
%--------------------------------------------------
%  ratemap = makeRateMap_c(x,fs,lowcf,highcf,numchans,frameshift,ti,compression)
% 
%  x            input signal
%  fs           sampling frequency in Hz (default 8000)
%  lowcf        centre frequency of lowest filter in Hz (default 50)
%  highcf       centre frequency of highest filter in Hz (default 3500)
%  numchans     number of channels in filterbank (default 32)
%  frameshift   interval between successive frames in ms (default 10)
%  ti           temporal integration in ms (default 8)
%  compression  type of compression (default 'cuberoot')
%                 'cuberoot' for pow(rm, 0.3)
%                 'log' for log10(rm)
%                 'none' for no compression
%
%  e.g. ratemap = makeRateMap_c(x,25000,50,8000,64,10,8,'log');
%
%
%  You should compile makeRateMap_c.c before using it.
%  In Matlab command line, type: mex makeRateMap_c.c
%
%  For more detail on this implementation, see
%  http://www.dcs.shef.ac.uk/~ning/resources/ratemap/
%
%  Ning Ma, University of Sheffield
%  n.ma@dcs.shef.ac.uk, 08 Dec 2005
%
