#!/usr/bin/perl

use strict;
use warnings;

use File::Basename;

my $RUN_MATLAB= '/home/jagl/bin/run_matlab.csh';
my $MSG= '/home/jagl/mensajes';
my $TMPDIR= '/home/jagl/temp';

my $FEATROOT= '/home/jagl/databases/Aurora2/speech_data';
my $GMMDIR= '/home/jagl/MD/gmms.matlab/A2';

my $SAMP_KIND= 'fbank';
my $MAX_GAUSSIANS= 32;
#my @COVTYPE= qw( diag mixed );
my @COVTYPE= qw( mixed );

#my @METHODS= qw( Raj BCMI Eig );
my @METHODS= qw( BCMI );
my %IMPUTATION_TYPE= (	'Raj' => 'map',
						'BCMI' => 'bcmi',
						'Eig' => 'eig',
						'SVD' => 'svd' );
my %PROB_COMPUTATION= (	'Raj' => 'diag',
						'BCMI' => 'bcp',
						'Eig' => 'eig',
						'SVD' => 'svd' );

my @SETS= qw( testa testb testc );
#my @SETS= qw( testa );
my %NOISES= (	'testa' => 4,
				'testb' => 4,
				'testc' => 2 );
my @SNRS=	qw( -5 0 5 10 15 20 clean );


#Program starts
foreach my $set ( @SETS )
{
	foreach my $noise ( 1..$NOISES{$set} )
	{
		my $auxDir= "$FEATROOT/$set/clean$noise/$SAMP_KIND";
		my @testFiles= qx( find $auxDir -name "*.$SAMP_KIND" );
		chomp( @testFiles );
		my @fnames= map( basename($_,".$SAMP_KIND"), @testFiles );

		foreach my $snr ( @SNRS )
		{
			my $cond= ($snr eq 'clean') ? "clean$noise":"N$noise\_SNR$snr";
			my $noisyDir= "$FEATROOT/$set/$cond/$SAMP_KIND";
			my $maskDir=  "$FEATROOT/$set/$cond/oracle_mask";

			foreach my $cov ( @COVTYPE )
			{
				for ( my $gauss=$MAX_GAUSSIANS; $gauss<=$MAX_GAUSSIANS; $gauss*= 2 )
				{
					my $gmm= "$GMMDIR/$SAMP_KIND/gmm.$cov.$gauss.mat";				
					foreach my $method ( @METHODS )
					{
						my $it= $IMPUTATION_TYPE{$method};
						my $prob= $PROB_COMPUTATION{$method};

						my $imputedDir= "$FEATROOT/$set/$cond/imputed-$SAMP_KIND-gmm.$cov.$gauss-mask.oracle-prob.$prob-imp.$it";
						qx( mkdir -p $imputedDir );

						#List of test files, mask files, and output files
						my $name= "impute.A2.$method.$set.$cond.$SAMP_KIND.$cov.$gauss.oracle";
						my $tmpList= "$TMPDIR/$name" . time() . '.txt';
						open( FLIST, ">$tmpList" ) or die ( "Couldn't create the file $tmpList!" );
			 			print FLIST join("\n", map { "$noisyDir/$_.$SAMP_KIND $maskDir/$_.mask $imputedDir/$_.$SAMP_KIND" } @fnames), "\n";
						close( FLIST );

						#Matlab imputation script
						qx( qsub -cwd -N $name -e $MSG/Err_$name.txt -o $MSG/Out_$name.txt $RUN_MATLAB "ImputeMissingData(\'$tmpList\',\'$gmm\',\'binary\',\'$it\',\'$prob\',\'l\')" );
					}
				}
			}
		}
	}
}

