#!/usr/bin/perl

use strict;
use warnings;

use File::Basename;

my $RUN_MATLAB= '/home/jagl/bin/run_matlab.csh';
my $MSG= '/home/jagl/mensajes';
my $TMPDIR= '/home/jagl/temp';

my $FEATROOT= '/home/jagl/databases/Aurora2/speech_data';
my $GMMDIR= '/home/jagl/MD/gmms.matlab/A2';

my $SAMP_KIND= 'fbank';
my $MAX_GAUSSIANS= 256;
my @COVTYPE= qw( diag );
my @METHODS= qw( simple );

my @SETS= qw( testa testb testc );
my %NOISES= (	'testa' => 4,
				'testb' => 4,
				'testc' => 2 );
my @SNRS=	qw( -5 0 5 10 15 20 clean );


#Program starts
my %fnames;
foreach my $noise ( 1..4 )
{
	my $cleanDir= "$FEATROOT/testa/clean$noise/$SAMP_KIND";
	my @files= qx( find $cleanDir -name "*.$SAMP_KIND" );
	chomp( @files );
	
	my @names= map( basename($_, ".$SAMP_KIND"), @files );
	$fnames{$noise}= \@names;
}

foreach my $set ( @SETS )
{
	foreach my $noise ( 1..$NOISES{$set} )
	{
		foreach my $snr ( @SNRS )
		{
			my $cond= ($snr eq 'clean') ? "clean$noise":"N$noise\_SNR$snr";
			my $noisyDir= "$FEATROOT/$set/$cond/$SAMP_KIND";
			my $noiseEstDir= "$FEATROOT/$set/$cond/noiseEst-20";

			foreach my $cov ( @COVTYPE )
			{
				for ( my $gauss=$MAX_GAUSSIANS; $gauss<=$MAX_GAUSSIANS; $gauss*= 2 )
				{
					my $gmm= "$GMMDIR/$SAMP_KIND/gmm.$cov.$gauss.mat";				
					foreach my $method ( @METHODS )
					{
						my $estDir= "$FEATROOT/$set/$cond/VTS-$method-$SAMP_KIND-gmm.$cov.$gauss-noise.20";
						qx( mkdir -p $estDir );

						#List of test files, mask files, and output files
						my $name= "VTS.A2.$method.$set.$cond.$cov.$gauss.noise.20";
						my $tmpList= "$TMPDIR/$name." . time() . '.txt';
						open( FLIST, ">$tmpList" ) or die ( "Couldn't create the file $tmpList!" );
			 			print FLIST join("\n", map { "$noisyDir/$_.$SAMP_KIND $noiseEstDir/$_.$SAMP_KIND $noiseEstDir/$_.var $estDir/$_.$SAMP_KIND" } @{$fnames{$noise}}), "\n";
						close( FLIST );

						#Matlab imputation script
						qx( qsub -cwd -N $name -e $MSG/Err_$name.txt -o $MSG/Out_$name.txt $RUN_MATLAB "BoundedVTS(\'$tmpList\',\'$gmm\',\'$method\',\'1\',\'l\')" );
					}
				}
			}
		}
	}
}

