#!/bin/sh 

# Run Matlab in batch mode.
# Invoking Matlab with the -nojvm -nodisplay and
# -nosplash ensures that there is no graphical display.
#
# Ning Ma, 18 March 2007

if [ $# -lt 1 ]
then
    echo "Usage: run_matlab.sh MATLAB_CMD [MATLAB_CMD_DIR]"
    echo "       MATLAB_CMD     - Matlab command with arguments, enclosed by \"\"."
    echo "       MATLAB_CMD_DIR - Directory where the Matlab command can be found. Optional."
    echo ""
    echo "eg. run_matlab.sh \"max([1 3 2])\""
    exit 1
fi

MATLABBIN="/home/soft/matlab/bin/matlab"

CMD=`echo $1 | cut -d'(' -f1 | tr -d " \t"`

MATLABCMDS="if exist('$CMD'); $1; else; fprintf('Undefined function \"$CMD\"\n'); end; exit;"
if [ $# -eq 2 ]
then
    MATLABCMDS="addpath $2; $MATLABCMDS"
fi
MATLABCMDS="addpath(genpath('/home/jagl/matlab)); $MATLABCMDS"
echo $MATLABCMDS

$MATLABBIN -nojvm -nodesktop -nodisplay -r "$MATLABCMDS"

