(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    393853,      10691]*)
(*NotebookOutlinePosition[    394719,      10721]*)
(*  CellTagsIndexPosition[    394675,      10717]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["M\[CapitalEAcute]TODO DE \[Theta]-WILSON NO LINEAL", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Vineta BT",
  FontSize->28,
  FontWeight->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
La diferencia con el m\[EAcute]todo lineal es que en el c\[AAcute]lculo de \
cada paso hay que calcular la rigidez. 
Adem\[AAcute]s para minimizar el error se realizan iteraciones para pasar de \
ui a ui+1, hasta alcanzar una cierta tolerancia.
Se ha utilizado el m\[EAcute]todo de Newton-Raphson, que consiste en calcular \
la rigidez, en cada una de las iteraciones para el paso de ui a ui+1.  Este \
programa s\[OAcute]lo considera el caso de un material elastopl\[AAcute]stico \
perfecto.
El programa da una tabla con los valores del desplazamiento, velocidad y \
aceleraci\[OAcute]n,en cada instante de tiempo junto con su representaci\
\[OAcute]n gr\[AAcute]fica.
\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["WilsonNoLineal", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell[TextData[{
  "Clear[\"Global`*\"]\nposicion;\nvelocidad;\naceleracion;\n\
WilsonNoLineal[ti_,tn_,Inct_,u0_,v0_,k_,m_,c_,p_,\n        \
Parametro_,fc_,ft_,posicion_,velocidad_,aceleracion_]:=\n  \
Block[{n,pa1,pa2,nn,pa,i,tm,u,v,a,\n         \
a0,k2,fs,p1,k1,tol,k1t,kt,uu,vv,aa,fss, \n         \
incrRR,incruu,z,j,l,s,gp,gu,gv,ga,MaximoDesplazamiento,\n\
MinimoDesplazamiento,MaximaVelocidad,MinimaVelocidad,\n\
MaximaAceleracion,MinimaAceleracion},\n\n",
  StyleBox["(*Las variables que hay que introducir son las \n siguientes:\n\
ti=instante inicial.\ntn=instante final.\nInct=incremento de tiempo.\n\
u0=desplazamiento en el instante ti.\nv0=velocidad en el instante ti.\n\
k=rigidez del tramo el\[AAcute]stico.\nm=masa.\nc=coeficiente de \
amortiguamiento.\nParametro = \[CurlyTheta] de Wilson (generalmente 1.4).\n\
fc=valor que provoca la plastificaci\[OAcute]n a compresi\[OAcute]n.\n\
ft=valor que provoca la plastificaci\[OAcute]n a tracci\[OAcute]n.\n\
p=carga.Si la carga se da de forma discreta, hay que dar \nuna lista \
{{t1,p1},{t2,p2},.....,{tn.pn}}, en la que cada \npareja de valores es la \
carga  p ,  que hay en el instante t.\nfc=valor que provoca la plastificaci\
\[OAcute]n a compresi\[OAcute]n.\nft=valor que provoca la plastificaci\
\[OAcute]n a tracci\[OAcute]n.\nEl programa da una tabla con los valores del \
desplazamiento, \nvelocidad y aceleraci\[OAcute]n,en cada instante de tiempo \
junto con \nsu representaci\[OAcute]n gr\[AAcute]fica.*)\n",
    FontColor->RGBColor[0, 0, 1]],
  "\n",
  StyleBox["(* C\[AAcute]lculo del n\[UAcute]mero de puntos en los que se va \
a obtener la respuesta\ny asignaci\[OAcute]n de variables *)",
    FontColor->RGBColor[0, 0, 1]],
  "\n\n\[CapitalDelta]t=Inct;\n\[CurlyTheta]=Parametro;\t\nn=Floor[(tn-ti)/\
\[CapitalDelta]t+1.];\n\n",
  StyleBox["(* Como la soluci\[OAcute]n se va hallando paso a paso para cada \
instante de tiempo,\nhemos de discretizar la carga \"p\", para tener los \
valores de ella en cada\ninstante en el que va a ser calculada la respuesta.\n\
Cuando la carga venga dada como una funci\[OAcute]n continua,\nla \
discretizaci\[OAcute]n consiste simplemente en evaluar la funci\[OAcute]n \
para los instantes\nde tiempo en que vamos a obtener la respuesta.\nSi la \
carga es conocida de forma discreta, o sea, que conocemos la carga de\nforma \
exacta en unos instantes de tiempo determinados, construiremos una \nfunci\
\[OAcute]n \"pa1\", que ser\[AAcute] la que discretizaremos.\nEl siguiente \
programa comprueba si la carga no es una funci\[OAcute]n continua,\nen cuyo \
caso antes de realizar la interpolaci\[OAcute]n, comprueba que la lista tenga \
\nvalores de carga para instantes de tiempo superiores o iguales al instante \
en \nque se quiere obtener la respuesta.Si esto no es as\[IAcute], o sea se \
pide la respuesta \nen un instante \"tn\" que es superior al \[UAcute]ltimo \
instante de tiempo donde se conoce \nla carga, se supone que la carga ha \
dejado de actuar, y se le asigna el valor cero,\npara poder realizar as\
\[IAcute] la interpolaci\[OAcute]n.  *)",
    FontColor->RGBColor[0, 0, 1]],
  "\n\npa1=p;\nIf[Head[p]==List,pa2=p;nn=Length[pa2];\n    If[pa2[[nn,1]]+\
\[CapitalDelta]t/1000<tn,\n        \
AppendTo[pa2,{pa1[[nn,1]]+\[CapitalDelta]t/1000,0.}];\n        \
AppendTo[pa2,{tn,0.}],\n          If[tn>pa2[[nn,1]],AppendTo[pa2,{tn,0.}]]];\n\
          pa1=Interpolation[pa2,InterpolationOrder->1]];\n\
pa=Table[0,{i,1,n}];\nFor[i=1,i<=n,i++,\n     pa[[i]]=N[pa1[(ti+(i-1)\
\[CapitalDelta]t)]]];\ntm=Table[ti+(i-1)*\[CapitalDelta]t,{i,n}];\n\
u=Table[0.,{i,1,n}];\nv=Table[0.,{i,1,n}];\na=Table[0.,{i,1,n}];\n\n\n",
  StyleBox["(* Se inicializan los vectores de desplazamiento \"u\", velocidad \
\"v\" y aceleraci\[OAcute]n \"a\". *)",
    FontColor->RGBColor[0, 0, 1]],
  "\n\na0=(pa[[1]]-c*v0-k*u0)/m;\nu[[1]]=u0;\nv[[1]]=v0;\na[[1]]=a0;\nk2=k;\n\
fs=k2*u[[1]];\n\n",
  StyleBox["(* Para cada paso hay que calcular la rigidez. Aqu\[IAcute] se \
inicializan los datos que \nnecesitar\[AAcute] el \"While\" , que es donde se \
realiza el c\[AAcute]lculo del incremento \nde desplazamiento. *)",
    FontColor->RGBColor[0, 0, 1]],
  "\n\nFor[i=1,i<n,i++,\n      \
p1=pa[[i]]+\[CurlyTheta]*(pa[[i+1]]-pa[[i]])+m*(6*v[[i]]/(\[CurlyTheta]*\
\[CapitalDelta]t)+2*a[[i]])\n  \
+c*(2*v[[i]]+\[CurlyTheta]*\[CapitalDelta]t*a[[i]]/2);\n      k1=k2+6*m/((\
\[CurlyTheta]^2)*(\[CapitalDelta]t^2))+3*c/(\[CurlyTheta]*\[CapitalDelta]t);\n\
      tol=.00005;\n      k1t=k1;\n      kt=k2;\n      uu={u[[i]]};\n      \
fss={fs,0};\n      incrRR={p1};\n      incruu={incrRR[[1]]/k1t};\n      \
uu={u[[i]],u[[i]]+p1/k1t};\n      If[Abs[uu[[2]]]-Abs[uu[[1]]]>0,\n          \
If[fc<fss[[1]]<ft,\n              fss[[2]]=fss[[1]]+k (uu[[2]]-uu[[1]]);\n    \
          If[fc<fss[[2]]<ft,\n                   kt=k,\n                   \
If[fss[[2]]>0,fss[[2]]=ft,fss[[2]]=fc];\n                   kt=0\n            \
     ],\n              If[fss[[2]]>0,fss[[2]]=ft,fss[[2]]=fc];\n              \
kt=0\n            ],\n          fss[[2]]=fss[[1]]+k (uu[[2]]-uu[[1]]);\n      \
    If[fc<fss[[1]]<ft,\n               kt=k,\n               \
If[fss[[2]]>0,fss[[2]]=ft,fss[[2]]=fc];\n               kt=0\n             ]\n\
         ];\n      fss={fss[[1]],fss[[2]]};\n      \
incrff={fss[[2]]-fss[[1]]+(6*m/(\[CurlyTheta]*\[CapitalDelta]t^2)+2*c/\
\[CapitalDelta]t)*incruu[[1]]};\n      incrRR={p1,p1-incrff[[1]]};\n      \n\
",
  StyleBox["(* Para pasar del paso ui al ui+1 se realizan iteraciones hasta \
que \nel incremento de desplazamiento \"incruu\"  conseguido en esa iteraci\
\[OAcute]n\nrespecto al incremento de desplazamiento total  \"s\" obtetido \
hasta esa \niteraci\[OAcute]n sea menor que la tolerancia. Los  \"If\" van \
comprobando si \nestamos en rango el\[AAcute]stico o pl\[AAcute]stico, para \
asignar en cada caso \nla rigidez correspondiente (aplicaci\[OAcute]n del m\
\[EAcute]todo de Newton-Raphson). *)",
    FontColor->RGBColor[0, 0, 1]],
  "\n      \n      z=2*tol;\n      j=2;\n      While[z>tol,\n              \
incruu[[j-1]]=incrRR[[j-1]]/k1t;\n              \
uu[[j]]=uu[[j-1]]+incruu[[j-1]];\n              \
If[Abs[uu[[j]]]-Abs[uu[[j-1]]]>0,\n                   If[fc<fss[[j-1]]<ft,\n  \
                      fss[[j]]=fss[[j-1]]+k*(uu[[j]]-uu[[j-1]]);\n            \
            If[fc<fss[[j]]<ft,\n                             kt=k,\n          \
                   If[fss[[j]]>0,fss[[j]]=ft,fss[[j]]=fc];\n                  \
           kt=0\n                           ],\n                        \
If[fss[[j-1]]>0,fss[[j-1]]=ft,fss[[j-1]]=fc];\n                        kt=0;\n\
                        fss[[j]]=fss[[j-1]]\n                     ],\n        \
           fss[[j]]=fss[[j-1]]+k*(uu[[j]]-uu[[j-1]]);\n                   \
If[fc<fss[[j]]<ft,\n                        kt=k,\n                        \
If[fss[[j]]>0,fss[[j]]=ft,fss[[j]]=fc];\n                        kt=0\n       \
              ]\n                ];\n              \
incrff[[j-1]]=fss[[j]]-fss[[j-1]]+(6*m/(\[CurlyTheta]*\[CapitalDelta]t^2)+2*c/\
\[CapitalDelta]t)*incruu[[j-1]];\n              \
incrRR[[j]]=incrRR[[j-1]]-incrff[[j-1]];\n              l=Length[incruu];\n   \
           s=Sum[incruu[[i]],{i,1,l}];\n              z=Abs[incruu[[l]]/s];\n \
             AppendTo[incruu,0];\n              AppendTo[incrRR,0];\n         \
     AppendTo[incrff,0];\n              AppendTo[uu,0];\n              \
AppendTo[fss,0];\n              j=j+1\n           ];\n\n",
  StyleBox["(* Una vez alcanzada la tolerancia se halla el desplazamiento y \
velocidad. *)",
    FontColor->RGBColor[0, 0, 1]],
  "\n\n      u[[i+1]]=u[[i]]+s;\n      v[[i+1]]=N[3*s/(\[CurlyTheta]*\
\[CapitalDelta]t)-2*v[[i]]-\[CapitalDelta]t*\[CurlyTheta]*a[[i]]/2];\n\n",
  StyleBox["(* Se comprueba si estamos en rango el\[AAcute]stico o \
pl\[AAcute]stico para asignar la rigidez \ncorrespondiente, y aplicar la \
ecuaci\[OAcute]n del movimiento para hallar la aceleraci\[OAcute]n. *)",
    FontColor->RGBColor[0, 0, 1]],
  "\n\n      fs=fs+k*(u[[i+1]]-u[[i]]);\n      If[fc<fs<ft,\n           k2=k,\
\n           If[fs>0,fs=ft,fs=fc];\n           k2=0\n        ];\n      \
a[[i+1]]=N[(pa[[i+1]]-c*v[[i+1]]-fs)/m];\n   \n   \n   \n   Print[\"i = \",i,\
\"  j = \",j,\"  kt = \",kt,\"   fs = \",fs]\n   ];\n\n\n",
  StyleBox["(* C\[AAcute]lculo de los m\[AAcute]ximos y m\[IAcute]nimos de \
cada vector de resultados *)\n\n",
    FontColor->RGBColor[0, 0, 1]],
  "MaximoDesplazamiento=Max[u];\nMinimoDesplazamiento=Min[u];\n\
MaximaVelocidad=Max[v];\nMinimaVelocidad=Min[v];\nMaximaAceleracion=Max[a];\n\
MinimaAceleracion=Min[a];\n\n",
  StyleBox["(* Para \"p\", \"u\", \"v\"  y  \"a\", se construye una matriz en \
la que en la fila \"i\"\naparece el instante de tiempo \"ti\" y la respuesta \
\"pai\", \"ui\",\"vi\" y \"ai\" \nrespectivamente asociada a ese instante. \
*)",
    FontColor->RGBColor[0, 0, 1]],
  "\n\n\nFor[i=1,i<=n,i++,\n       pa[[i]]={tm[[i]],Chop[pa[[i]]]};\n       \
u[[i]]={tm[[i]],Chop[u[[i]]]};\n       v[[i]]={tm[[i]],Chop[v[[i]]]};\n       \
a[[i]]={tm[[i]],Chop[a[[i]]]}];\nposicion=u;\nvelocidad=v;\naceleracion=a;\n\n\
\n",
  StyleBox["(* Se representan gr\[AAcute]ficamente \"u\", \"v\"  y  \"a\". \
*)",
    FontColor->RGBColor[0, 0, 1]],
  "\n\nPrint[\"Carga:\"];\ngp=ListPlot[ Table[pa[[i]],{i,n}],                 \
\n           PlotStyle->{PointSize[0.023],RGBColor[0,1,0]},\n           \
PlotJoined->True,\n           AxesLabel->{t,\"p\"}];\n\n\
Print[\"Desplazamientos:\"];\ngu=ListPlot[ Table[u[[i]],{i,n}],               \
  \n           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},\n           \
PlotJoined->True,\n           AxesLabel->{t,\"u\"}];\nPrint[\"M\[AAcute]ximo \
Desplazamiento: \",MaximoDesplazamiento];\nPrint[\"M\[IAcute]nimo \
Desplazamiento: \",MinimoDesplazamiento];\n\nPrint[\"Velocidades:\"];         \
  \ngv=ListPlot[ Table[v[[i]],{i,n}],                 \n           \
PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},\n           PlotJoined->True,\n\
           AxesLabel->{t,\"v\"}];\nPrint[\"M\[AAcute]xima Velocidad: \
\",MaximaVelocidad];\nPrint[\"M\[IAcute]nima Velocidad: \",MinimaVelocidad];  \
         \n           \nPrint[\"Aceleraciones:\"];           \nga=ListPlot[ \
Table[a[[i]],{i,n}],                 \n           \
PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},\n           PlotJoined->True,\n\
           AxesLabel->{t,\"a\"}];\nPrint[\"M\[AAcute]xima \
Aceleraci\[OAcute]n: \",MaximaAceleracion];\nPrint[\"M\[IAcute]nima Aceleraci\
\[OAcute]n: \",MinimaAceleracion];           \n           \n           \n",
  StyleBox["(* Se realiza una tabla en la que para para cada instante de \
tiempo\n aparecen los valores de \"p\", \"u\", \"v\" y \"a\" asociados a este \
instante. *)",
    FontColor->RGBColor[0, 0, 1]],
  "\n           \nPrint[\"t\" ,  \"         \", \"p        \",\"     u\" ,\n\
\"          v\", \"         a\"]; \n\
Print[\"---------------------------------------------------\"];\n\
Print[TableForm[tm],\"     \",TableForm[Transpose[pa][[2]]],\"    \",\n\
TableForm[Transpose[u][[2]]],\"   \",TableForm[Transpose[v][[2]]],\"  \",\n\
TableForm[Transpose[a][[2]]]]]"
}], "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO
0.2 a( t )  + 0.274 v( t ) + fs ( u,v ) = p( t )
u( 0 ) = 0
v( 0 ) = 0

Hallar la respuesta hasta el instante tn=2 y con un incremento de tiempo
to=0.01,para el m\[EAcute]todo de la aceleraci\[OAcute]n lineal, siendo p( t \
) la carga dada en forma discreta siguiente:

p={{0,0},{.45,20},{1.1,0},{1.2,-10},{1.4,0}};

y siendo el material elastopl\[AAcute]stico perfecto, en el que la \
plastificaci\[OAcute]n a tracci\[OAcute]n se alcanza paran un valor de ft = \
15, y a compresi\[OAcute]n para fc = -15, y la rigidez el\[AAcute]stica es \
12.35. Tomar \[Theta]=1.4.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["\<\
p={{0,0},{.45,20},{1.1,0},{1.2,-10},{1.4,0}};
WilsonNoLineal[0,2,.01,0,0,12.35,.2,.274,p,  
        1.4,-15,15,posicion,velocidad,aceleracion]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]1\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.0008895546706670053`\),
      SequenceForm[ 
      "i = ", 1, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .0008895546706670053],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]2\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.005580159666086866`\),
      SequenceForm[ 
      "i = ", 2, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .0055801596660868657],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]3\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.014584337106657077`\),
      SequenceForm[ 
      "i = ", 3, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .014584337106657077],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]4\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.02795382819594154`\),
      SequenceForm[ 
      "i = ", 4, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .027953828195941541],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]5\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.04567694775080637`\),
      SequenceForm[ 
      "i = ", 5, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .045676947750806371],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]6\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.06773336088179396`\),
      SequenceForm[ 
      "i = ", 6, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .067733360881793964],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]7\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.09410163374202173`\),
      SequenceForm[ 
      "i = ", 7, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .094101633742021726],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]8\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.12476027396633657`\),
      SequenceForm[ 
      "i = ", 8, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .12476027396633657],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]9\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.159687873636625`\),
      SequenceForm[ 
      "i = ", 9, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .15968787363662501],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]10\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.19886312852853738`\),
      SequenceForm[ 
      "i = ", 10, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .19886312852853738],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]11\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.2422648403053397`\),
      SequenceForm[ 
      "i = ", 11, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .24226484030533971],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]12\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.2898719163632414`\),
      SequenceForm[ 
      "i = ", 12, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .28987191636324139],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]13\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.3416633693552488`\),
      SequenceForm[ 
      "i = ", 13, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .34166336935524882],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]14\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.3976183166729727`\),
      SequenceForm[ 
      "i = ", 14, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .3976183166729727],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]15\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.45771597992489743`\),
      SequenceForm[ 
      "i = ", 15, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .45771597992489743],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]16\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.5219356844164096`\),
      SequenceForm[ 
      "i = ", 16, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .52193568441640958],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]17\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.5902568586323056`\),
      SequenceForm[ 
      "i = ", 17, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .59025685863230559],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]18\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.6626590337218656`\),
      SequenceForm[ 
      "i = ", 18, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .66265903372186563],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]19\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.7391218429864953`\),
      SequenceForm[ 
      "i = ", 19, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .7391218429864953],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]20\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.8196250213699239`\),
      SequenceForm[ 
      "i = ", 20, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .81962502136992388],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]21\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.9041484049509467`\),
      SequenceForm[ 
      "i = ", 21, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .90414840495094673],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]22\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.9926719304386995`\),
      SequenceForm[ 
      "i = ", 22, "  j = ", 15, "  kt = ", 12.35, 
        "   fs = ", .9926719304386995],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]23\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]1.0851756346704502`\),
      SequenceForm[ 
      "i = ", 23, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        1.0851756346704502],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]24\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]1.1816396541118994`\),
      SequenceForm[ 
      "i = ", 24, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        1.1816396541118994],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]25\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]1.2820442243599726`\),
      SequenceForm[ 
      "i = ", 25, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        1.2820442243599726],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]26\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]1.3863696796480942`\),
      SequenceForm[ 
      "i = ", 26, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        1.3863696796480942],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]27\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]1.4945964523539323`\),
      SequenceForm[ 
      "i = ", 27, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        1.4945964523539323],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]28\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]1.6067050725095973`\),
      SequenceForm[ 
      "i = ", 28, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        1.6067050725095973],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]29\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]1.7226761673142867`\),
      SequenceForm[ 
      "i = ", 29, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        1.7226761673142867],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]30\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]1.842490460649362`\),
      SequenceForm[ 
      "i = ", 30, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        1.8424904606493619],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]31\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]1.966128772595845`\),
      SequenceForm[ 
      "i = ", 31, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        1.966128772595845],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]32\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]2.0935720189543225`\),
      SequenceForm[ 
      "i = ", 32, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        2.0935720189543225],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]33\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]2.224801210767247`\),
      SequenceForm[ 
      "i = ", 33, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        2.224801210767247],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]34\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]2.359797453843622`\),
      SequenceForm[ 
      "i = ", 34, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        2.3597974538436222],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]35\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]2.4985419482860576`\),
      SequenceForm[ 
      "i = ", 35, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        2.4985419482860576],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]36\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]2.641015988020188`\),
      SequenceForm[ 
      "i = ", 36, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        2.6410159880201882],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]37\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]2.7872009603264383`\),
      SequenceForm[ 
      "i = ", 37, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        2.7872009603264383],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]38\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]2.937078345374124`\),
      SequenceForm[ 
      "i = ", 38, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        2.937078345374124],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]39\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]3.090629715757881`\),
      SequenceForm[ 
      "i = ", 39, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        3.0906297157578808],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]40\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]3.247836736036405`\),
      SequenceForm[ 
      "i = ", 40, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        3.2478367360364051],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]41\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]3.4086811622734965`\),
      SequenceForm[ 
      "i = ", 41, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        3.4086811622734965],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]42\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]3.5731448415813913`\),
      SequenceForm[ 
      "i = ", 42, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        3.5731448415813913],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]43\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]3.7412097116663743`\),
      SequenceForm[ 
      "i = ", 43, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        3.7412097116663743],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]44\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]3.9128578003766608`\),
      SequenceForm[ 
      "i = ", 44, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        3.9128578003766608],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]45\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.088071225252531`\),
      SequenceForm[ 
      "i = ", 45, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.0880712252525306],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]46\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.265326792866814`\),
      SequenceForm[ 
      "i = ", 46, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.2653267928668139],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]47\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.439679652311771`\),
      SequenceForm[ 
      "i = ", 47, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.4396796523117708],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]48\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.610244842400266`\),
      SequenceForm[ 
      "i = ", 48, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.6102448424002658],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]49\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.77691727295014`\),
      SequenceForm[ 
      "i = ", 49, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.7769172729501399],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]50\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.93969927821754`\),
      SequenceForm[ 
      "i = ", 50, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.9396992782175397],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]51\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.098607917462802`\),
      SequenceForm[ 
      "i = ", 51, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.0986079174628021],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]52\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.253662196325625`\),
      SequenceForm[ 
      "i = ", 52, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.2536621963256254],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]53\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.404881305649675`\),
      SequenceForm[ 
      "i = ", 53, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.4048813056496749],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]54\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.552284379111232`\),
      SequenceForm[ 
      "i = ", 54, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.5522843791112324],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]55\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.695890460219905`\),
      SequenceForm[ 
      "i = ", 55, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.6958904602199052],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]56\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.835718498180178`\),
      SequenceForm[ 
      "i = ", 56, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.835718498180178],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]57\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.97178734772952`\),
      SequenceForm[ 
      "i = ", 57, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.9717873477295198],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]58\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.1041157695226325`\),
      SequenceForm[ 
      "i = ", 58, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.1041157695226325],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]59\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.23272243058896`\),
      SequenceForm[ 
      "i = ", 59, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.2327224305889599],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]60\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.3576259047982795`\),
      SequenceForm[ 
      "i = ", 60, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.3576259047982795],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]61\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.478844673325399`\),
      SequenceForm[ 
      "i = ", 61, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.4788446733253986],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]62\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.596397125112724`\),
      SequenceForm[ 
      "i = ", 62, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.5963971251127242],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]63\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.71030155733056`\),
      SequenceForm[ 
      "i = ", 63, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.7103015573305598],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]64\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.820576175835101`\),
      SequenceForm[ 
      "i = ", 64, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.8205761758351011],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]65\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.927239095624148`\),
      SequenceForm[ 
      "i = ", 65, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.9272390956241479],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]66\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.030308341290547`\),
      SequenceForm[ 
      "i = ", 66, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.0303083412905467],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]67\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.129801847473366`\),
      SequenceForm[ 
      "i = ", 67, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.1298018474733658],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]68\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.225737459306817`\),
      SequenceForm[ 
      "i = ", 68, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.2257374593068171],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]69\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.318132932866943`\),
      SequenceForm[ 
      "i = ", 69, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.3181329328669431],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]70\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.407005935616073`\),
      SequenceForm[ 
      "i = ", 70, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.4070059356160733],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]71\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.492374046845057`\),
      SequenceForm[ 
      "i = ", 71, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.4923740468450566],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]72\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.574254758113294`\),
      SequenceForm[ 
      "i = ", 72, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.5742547581132937],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]73\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.65266547368657`\),
      SequenceForm[ 
      "i = ", 73, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.6526654736865698],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]74\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.727623510972706`\),
      SequenceForm[ 
      "i = ", 74, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.7276235109727063],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]75\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.799146100955031`\),
      SequenceForm[ 
      "i = ", 75, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.7991461009550314],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]76\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.867250388623693`\),
      SequenceForm[ 
      "i = ", 76, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.8672503886236926],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]77\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.931953433404816`\),
      SequenceForm[ 
      "i = ", 77, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.9319534334048161],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]78\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.993272209587524`\),
      SequenceForm[ 
      "i = ", 78, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.9932722095875244],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]79\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.051223606748822`\),
      SequenceForm[ 
      "i = ", 79, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.0512236067488221],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]80\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.105824430176357`\),
      SequenceForm[ 
      "i = ", 80, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.1058244301763569],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]81\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.157091401289083`\),
      SequenceForm[ 
      "i = ", 81, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.1570914012890832],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]82\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.205041158055812`\),
      SequenceForm[ 
      "i = ", 82, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.2050411580558116],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]83\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.249690255411679`\),
      SequenceForm[ 
      "i = ", 83, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.2496902554116787],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]84\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.291055165672537`\),
      SequenceForm[ 
      "i = ", 84, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.2910551656725371],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]85\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.329152278947275`\),
      SequenceForm[ 
      "i = ", 85, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.3291522789472747],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]86\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.363997903548078`\),
      SequenceForm[ 
      "i = ", 86, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.3639979035480785],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]87\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.39560826639865`\),
      SequenceForm[ 
      "i = ", 87, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.39560826639865],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]88\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.423999513440386`\),
      SequenceForm[ 
      "i = ", 88, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.4239995134403856],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]89\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.449187710036526`\),
      SequenceForm[ 
      "i = ", 89, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.4491877100365258],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]90\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.471188841374289`\),
      SequenceForm[ 
      "i = ", 90, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.4711888413742891],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]91\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.490018812865003`\),
      SequenceForm[ 
      "i = ", 91, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.4900188128650029],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]92\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.505693450542228`\),
      SequenceForm[ 
      "i = ", 92, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.5056934505422284],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]93\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.518228501457912`\),
      SequenceForm[ 
      "i = ", 93, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.5182285014579122],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]94\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.527639634076547`\),
      SequenceForm[ 
      "i = ", 94, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.5276396340765466],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]95\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.53394243866737`\),
      SequenceForm[ 
      "i = ", 95, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.5339424386673706],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]96\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.537152427694616`\),
      SequenceForm[ 
      "i = ", 96, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.5371524276946165],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]97\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.537285036205796`\),
      SequenceForm[ 
      "i = ", 97, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.5372850362057964],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]98\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.534355622218067`\),
      SequenceForm[ 
      "i = ", 98, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.534355622218067],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]99\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.528379467102654`\),
      SequenceForm[ 
      "i = ", 99, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.5283794671026545],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]100\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.519371775967366`\),
      SequenceForm[ 
      "i = ", 100, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.5193717759673664],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]101\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.507347678037188`\),
      SequenceForm[ 
      "i = ", 101, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.5073476780371884],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]102\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.492322227032993`\),
      SequenceForm[ 
      "i = ", 102, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.492322227032993],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]103\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.47431040154835`\),
      SequenceForm[ 
      "i = ", 103, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.4743104015483492],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]104\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.453327105424451`\),
      SequenceForm[ 
      "i = ", 104, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.4533271054244512],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]105\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.429387168123178`\),
      SequenceForm[ 
      "i = ", 105, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.4293871681231778],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]106\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.402505345098294`\),
      SequenceForm[ 
      "i = ", 106, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.4025053450982945],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]107\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.3726963181648`\),
      SequenceForm[ 
      "i = ", 107, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.3726963181648006],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]108\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.339974695866427`\),
      SequenceForm[ 
      "i = ", 108, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.3399746958664274],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]109\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.30435501384131`\),
      SequenceForm[ 
      "i = ", 109, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.3043550138413096],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]110\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.265851735185825`\),
      SequenceForm[ 
      "i = ", 110, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.2658517351858247],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]111\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.223093598348859`\),
      SequenceForm[ 
      "i = ", 111, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.2230935983488589],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]112\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.171559708043311`\),
      SequenceForm[ 
      "i = ", 112, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.1715597080433113],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]113\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.110465960140786`\),
      SequenceForm[ 
      "i = ", 113, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.110465960140786],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]114\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]8.039745934298121`\),
      SequenceForm[ 
      "i = ", 114, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        8.0397459342981215],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]115\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.959431938217228`\),
      SequenceForm[ 
      "i = ", 115, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.9594319382172278],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]116\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.869569682784513`\),
      SequenceForm[ 
      "i = ", 116, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.8695696827845127],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]117\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.770206520678723`\),
      SequenceForm[ 
      "i = ", 117, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.7702065206787232],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]118\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.66138982603645`\),
      SequenceForm[ 
      "i = ", 118, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.6613898260364497],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]119\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.543166772103985`\),
      SequenceForm[ 
      "i = ", 119, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.5431667721039846],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]120\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.415584301602936`\),
      SequenceForm[ 
      "i = ", 120, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.4155843016029364],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]121\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.2816913706707425`\),
      SequenceForm[ 
      "i = ", 121, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.2816913706707425],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]122\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.1513607532497865`\),
      SequenceForm[ 
      "i = ", 122, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.1513607532497865],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]123\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.026368455674779`\),
      SequenceForm[ 
      "i = ", 123, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        7.0263684556747794],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]124\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.906935117901061`\),
      SequenceForm[ 
      "i = ", 124, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.9069351179010612],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]125\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.793067086194043`\),
      SequenceForm[ 
      "i = ", 125, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.7930670861940428],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]126\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.684741285571276`\),
      SequenceForm[ 
      "i = ", 126, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.6847412855712758],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]127\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.581930704720259`\),
      SequenceForm[ 
      "i = ", 127, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.5819307047202589],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]128\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.484607908615191`\),
      SequenceForm[ 
      "i = ", 128, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.4846079086151907],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]129\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.3927455221538345`\),
      SequenceForm[ 
      "i = ", 129, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.3927455221538345],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]130\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.30631629623853`\),
      SequenceForm[ 
      "i = ", 130, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.3063162962385304],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]131\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.225293116298148`\),
      SequenceForm[ 
      "i = ", 131, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.2252931162981477],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]132\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.1496490028782`\),
      SequenceForm[ 
      "i = ", 132, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.1496490028782],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]133\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.079357111140426`\),
      SequenceForm[ 
      "i = ", 133, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.0793571111404257],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]134\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.014390730214945`\),
      SequenceForm[ 
      "i = ", 134, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        6.0143907302149451],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]135\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.954723282534984`\),
      SequenceForm[ 
      "i = ", 135, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.9547232825349843],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]136\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.9003283231720625`\),
      SequenceForm[ 
      "i = ", 136, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.9003283231720625],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]137\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.851179539174108`\),
      SequenceForm[ 
      "i = ", 137, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.8511795391741082],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]138\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.807250748906826`\),
      SequenceForm[ 
      "i = ", 138, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.8072507489068261],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]139\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.768515901398343`\),
      SequenceForm[ 
      "i = ", 139, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.7685159013983434],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]140\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.734949075687122`\),
      SequenceForm[ 
      "i = ", 140, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.7349490756871218],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]141\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.7055237311686255`\),
      SequenceForm[ 
      "i = ", 141, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.7055237311686255],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]142\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.676938772347884`\),
      SequenceForm[ 
      "i = ", 142, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.6769387723478841],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]143\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.648592077028867`\),
      SequenceForm[ 
      "i = ", 143, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.6485920770288667],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]144\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.6204000289813525`\),
      SequenceForm[ 
      "i = ", 144, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.6204000289813525],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]145\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.5923504934585555`\),
      SequenceForm[ 
      "i = ", 145, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.5923504934585555],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]146\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.564441192798899`\),
      SequenceForm[ 
      "i = ", 146, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.564441192798899],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]147\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.536671211203862`\),
      SequenceForm[ 
      "i = ", 147, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.5366712112038616],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]148\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.509039823617428`\),
      SequenceForm[ 
      "i = ", 148, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.5090398236174281],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]149\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.481546334266741`\),
      SequenceForm[ 
      "i = ", 149, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.4815463342667412],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]150\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.454190054389269`\),
      SequenceForm[ 
      "i = ", 150, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.4541900543892687],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]151\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.426970299147557`\),
      SequenceForm[ 
      "i = ", 151, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.4269702991475572],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]152\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.399886387189148`\),
      SequenceForm[ 
      "i = ", 152, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.3998863871891478],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]153\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.372937640571217`\),
      SequenceForm[ 
      "i = ", 153, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.3729376405712168],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]154\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.346123384735568`\),
      SequenceForm[ 
      "i = ", 154, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.3461233847355683],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]155\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.319442948490644`\),
      SequenceForm[ 
      "i = ", 155, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.3194429484906438],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]156\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.292895663994565`\),
      SequenceForm[ 
      "i = ", 156, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.2928956639945648],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]157\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.266480866738398`\),
      SequenceForm[ 
      "i = ", 157, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.266480866738398],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]158\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.240197895529517`\),
      SequenceForm[ 
      "i = ", 158, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.2401978955295174],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]159\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.214046092475055`\),
      SequenceForm[ 
      "i = ", 159, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.2140460924750549],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]160\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.188024802965431`\),
      SequenceForm[ 
      "i = ", 160, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.1880248029654306],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]161\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.162133375657968`\),
      SequenceForm[ 
      "i = ", 161, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.1621333756579677],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]162\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.136371162460591`\),
      SequenceForm[ 
      "i = ", 162, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.1363711624605912],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]163\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.110737518515601`\),
      SequenceForm[ 
      "i = ", 163, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.1107375185156014],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]164\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.085231802183534`\),
      SequenceForm[ 
      "i = ", 164, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.0852318021835341],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]165\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.0598533750270995`\),
      SequenceForm[ 
      "i = ", 165, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.0598533750270995],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]166\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.034601601795204`\),
      SequenceForm[ 
      "i = ", 166, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.0346016017952042],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]167\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.0094758504070445`\),
      SequenceForm[ 
      "i = ", 167, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        5.0094758504070445],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]168\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.98447549193629`\),
      SequenceForm[ 
      "i = ", 168, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.9844754919362897],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]169\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.959599900595337`\),
      SequenceForm[ 
      "i = ", 169, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.9595999005953368],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]170\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.934848453719647`\),
      SequenceForm[ 
      "i = ", 170, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.9348484537196473],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]171\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.9102205317521594`\),
      SequenceForm[ 
      "i = ", 171, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.9102205317521594],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]172\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.885715518227783`\),
      SequenceForm[ 
      "i = ", 172, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.8857155182277827],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]173\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.861332799757966`\),
      SequenceForm[ 
      "i = ", 173, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.8613327997579656],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]174\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.837071766015342`\),
      SequenceForm[ 
      "i = ", 174, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.8370717660153417],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]175\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.812931809718452`\),
      SequenceForm[ 
      "i = ", 175, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.8129318097184521],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]176\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.788912326616546`\),
      SequenceForm[ 
      "i = ", 176, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.7889123266165461],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]177\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.765012715474454`\),
      SequenceForm[ 
      "i = ", 177, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.7650127154744544],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]178\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.74123237805754`\),
      SequenceForm[ 
      "i = ", 178, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.7412323780575401],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]179\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.717570719116724`\),
      SequenceForm[ 
      "i = ", 179, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.7175707191167238],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]180\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.694027146373585`\),
      SequenceForm[ 
      "i = ", 180, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.6940271463735854],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]181\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.670601070505537`\),
      SequenceForm[ 
      "i = ", 181, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.670601070505537],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]182\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.6472919051310715`\),
      SequenceForm[ 
      "i = ", 182, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.6472919051310715],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]183\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.624099066795086`\),
      SequenceForm[ 
      "i = ", 183, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.6240990667950861],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]184\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.601021974954277`\),
      SequenceForm[ 
      "i = ", 184, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.6010219749542767],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]185\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.578060051962607`\),
      SequenceForm[ 
      "i = ", 185, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.5780600519626073],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]186\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.555212723056848`\),
      SequenceForm[ 
      "i = ", 186, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.5552127230568482],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]187\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.532479416342193`\),
      SequenceForm[ 
      "i = ", 187, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.5324794163421931],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]188\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.509859562777939`\),
      SequenceForm[ 
      "i = ", 188, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.5098595627779394],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]189\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.487352596163249`\),
      SequenceForm[ 
      "i = ", 189, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.487352596163249],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]190\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.464957953122973`\),
      SequenceForm[ 
      "i = ", 190, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.4649579531229726],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]191\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.442675073093548`\),
      SequenceForm[ 
      "i = ", 191, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.4426750730935476],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]192\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.420503398308969`\),
      SequenceForm[ 
      "i = ", 192, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.420503398308969],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]193\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.398442373786826`\),
      SequenceForm[ 
      "i = ", 193, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.3984423737868257],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]194\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.37649144731441`\),
      SequenceForm[ 
      "i = ", 194, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.3764914473144101],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]195\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.354650069434894`\),
      SequenceForm[ 
      "i = ", 195, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.3546500694348937],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]196\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.332917693433576`\),
      SequenceForm[ 
      "i = ", 196, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.3329176934335756],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]197\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.311293775324196`\),
      SequenceForm[ 
      "i = ", 197, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.311293775324196],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]198\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.289777773835322`\),
      SequenceForm[ 
      "i = ", 198, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.289777773835322],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]199\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.268369150396795`\),
      SequenceForm[ 
      "i = ", 199, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.2683691503967953],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]200\[InvisibleSpace]"  j = "\
\[InvisibleSpace]15\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.2470673691262535`\),
      SequenceForm[ 
      "i = ", 200, "  j = ", 15, "  kt = ", 12.35, "   fs = ", 
        4.2470673691262535],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Carga:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.210916 0.0196201 [
[.2619 .19842 -9 -9 ]
[.2619 .19842 9 0 ]
[.5 .19842 -3 -9 ]
[.5 .19842 3 0 ]
[.7381 .19842 -9 -9 ]
[.7381 .19842 9 0 ]
[.97619 .19842 -3 -9 ]
[.97619 .19842 3 0 ]
[1.025 .21092 0 -6.25 ]
[1.025 .21092 10 6.25 ]
[.01131 .01472 -18 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .11282 -12 -4.5 ]
[.01131 .11282 0 4.5 ]
[.01131 .30902 -6 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .40712 -12 -4.5 ]
[.01131 .40712 0 4.5 ]
[.01131 .50522 -12 -4.5 ]
[.01131 .50522 0 4.5 ]
[.01131 .60332 -12 -4.5 ]
[.01131 .60332 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .21092 m
.2619 .21717 L
s
[(0.5)] .2619 .19842 0 1 Mshowa
.5 .21092 m
.5 .21717 L
s
[(1)] .5 .19842 0 1 Mshowa
.7381 .21092 m
.7381 .21717 L
s
[(1.5)] .7381 .19842 0 1 Mshowa
.97619 .21092 m
.97619 .21717 L
s
[(2)] .97619 .19842 0 1 Mshowa
.125 Mabswid
.07143 .21092 m
.07143 .21467 L
s
.11905 .21092 m
.11905 .21467 L
s
.16667 .21092 m
.16667 .21467 L
s
.21429 .21092 m
.21429 .21467 L
s
.30952 .21092 m
.30952 .21467 L
s
.35714 .21092 m
.35714 .21467 L
s
.40476 .21092 m
.40476 .21467 L
s
.45238 .21092 m
.45238 .21467 L
s
.54762 .21092 m
.54762 .21467 L
s
.59524 .21092 m
.59524 .21467 L
s
.64286 .21092 m
.64286 .21467 L
s
.69048 .21092 m
.69048 .21467 L
s
.78571 .21092 m
.78571 .21467 L
s
.83333 .21092 m
.83333 .21467 L
s
.88095 .21092 m
.88095 .21467 L
s
.92857 .21092 m
.92857 .21467 L
s
.25 Mabswid
0 .21092 m
1 .21092 L
s
gsave
1.025 .21092 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .01472 m
.03006 .01472 L
s
[(-10)] .01131 .01472 1 0 Mshowa
.02381 .11282 m
.03006 .11282 L
s
[(-5)] .01131 .11282 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(5)] .01131 .30902 1 0 Mshowa
.02381 .40712 m
.03006 .40712 L
s
[(10)] .01131 .40712 1 0 Mshowa
.02381 .50522 m
.03006 .50522 L
s
[(15)] .01131 .50522 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(20)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03434 m
.02756 .03434 L
s
.02381 .05396 m
.02756 .05396 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .0932 m
.02756 .0932 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .15206 m
.02756 .15206 L
s
.02381 .17168 m
.02756 .17168 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .23054 m
.02756 .23054 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .26978 m
.02756 .26978 L
s
.02381 .2894 m
.02756 .2894 L
s
.02381 .32864 m
.02756 .32864 L
s
.02381 .34826 m
.02756 .34826 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .3875 m
.02756 .3875 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .44636 m
.02756 .44636 L
s
.02381 .46598 m
.02756 .46598 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .52484 m
.02756 .52484 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .56408 m
.02756 .56408 L
s
.02381 .5837 m
.02756 .5837 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 0 r
.5 Mabswid
.02381 .21092 m
.02857 .21964 L
.03333 .22836 L
.0381 .23708 L
.04286 .2458 L
.04762 .25452 L
.05238 .26324 L
.05714 .27196 L
.0619 .28068 L
.06667 .2894 L
.07143 .29812 L
.07619 .30684 L
.08095 .31556 L
.08571 .32428 L
.09048 .333 L
.09524 .34172 L
.1 .35044 L
.10476 .35916 L
.10952 .36788 L
.11429 .3766 L
.11905 .38532 L
.12381 .39404 L
.12857 .40276 L
.13333 .41148 L
.1381 .4202 L
.14286 .42892 L
.14762 .43764 L
.15238 .44636 L
.15714 .45508 L
.1619 .4638 L
.16667 .47252 L
.17143 .48124 L
.17619 .48996 L
.18095 .49868 L
.18571 .5074 L
.19048 .51612 L
.19524 .52484 L
.2 .53356 L
.20476 .54228 L
.20952 .551 L
.21429 .55972 L
.21905 .56844 L
.22381 .57716 L
.22857 .58588 L
.23333 .5946 L
.2381 .60332 L
.24286 .59728 L
.24762 .59124 L
.25238 .58521 L
.25714 .57917 L
Mistroke
.2619 .57313 L
.26667 .5671 L
.27143 .56106 L
.27619 .55502 L
.28095 .54899 L
.28571 .54295 L
.29048 .53691 L
.29524 .53088 L
.3 .52484 L
.30476 .5188 L
.30952 .51276 L
.31429 .50673 L
.31905 .50069 L
.32381 .49465 L
.32857 .48862 L
.33333 .48258 L
.3381 .47654 L
.34286 .47051 L
.34762 .46447 L
.35238 .45843 L
.35714 .45239 L
.3619 .44636 L
.36667 .44032 L
.37143 .43428 L
.37619 .42825 L
.38095 .42221 L
.38571 .41617 L
.39048 .41014 L
.39524 .4041 L
.4 .39806 L
.40476 .39203 L
.40952 .38599 L
.41429 .37995 L
.41905 .37391 L
.42381 .36788 L
.42857 .36184 L
.43333 .3558 L
.4381 .34977 L
.44286 .34373 L
.44762 .33769 L
.45238 .33166 L
.45714 .32562 L
.4619 .31958 L
.46667 .31354 L
.47143 .30751 L
.47619 .30147 L
.48095 .29543 L
.48571 .2894 L
.49048 .28336 L
.49524 .27732 L
Mistroke
.5 .27129 L
.50476 .26525 L
.50952 .25921 L
.51429 .25318 L
.51905 .24714 L
.52381 .2411 L
.52857 .23506 L
.53333 .22903 L
.5381 .22299 L
.54286 .21695 L
.54762 .21092 L
.55238 .1913 L
.55714 .17168 L
.5619 .15206 L
.56667 .13244 L
.57143 .11282 L
.57619 .0932 L
.58095 .07358 L
.58571 .05396 L
.59048 .03434 L
.59524 .01472 L
.6 .02453 L
.60476 .03434 L
.60952 .04415 L
.61429 .05396 L
.61905 .06377 L
.62381 .07358 L
.62857 .08339 L
.63333 .0932 L
.6381 .10301 L
.64286 .11282 L
.64762 .12263 L
.65238 .13244 L
.65714 .14225 L
.6619 .15206 L
.66667 .16187 L
.67143 .17168 L
.67619 .18149 L
.68095 .1913 L
.68571 .20111 L
.69048 .21092 L
.69524 .21092 L
.7 .21092 L
.70476 .21092 L
.70952 .21092 L
.71429 .21092 L
.71905 .21092 L
.72381 .21092 L
.72857 .21092 L
.73333 .21092 L
Mistroke
.7381 .21092 L
.74286 .21092 L
.74762 .21092 L
.75238 .21092 L
.75714 .21092 L
.7619 .21092 L
.76667 .21092 L
.77143 .21092 L
.77619 .21092 L
.78095 .21092 L
.78571 .21092 L
.79048 .21092 L
.79524 .21092 L
.8 .21092 L
.80476 .21092 L
.80952 .21092 L
.81429 .21092 L
.81905 .21092 L
.82381 .21092 L
.82857 .21092 L
.83333 .21092 L
.8381 .21092 L
.84286 .21092 L
.84762 .21092 L
.85238 .21092 L
.85714 .21092 L
.8619 .21092 L
.86667 .21092 L
.87143 .21092 L
.87619 .21092 L
.88095 .21092 L
.88571 .21092 L
.89048 .21092 L
.89524 .21092 L
.9 .21092 L
.90476 .21092 L
.90952 .21092 L
.91429 .21092 L
.91905 .21092 L
.92381 .21092 L
.92857 .21092 L
.93333 .21092 L
.9381 .21092 L
.94286 .21092 L
.94762 .21092 L
.95238 .21092 L
.95714 .21092 L
.9619 .21092 L
.96667 .21092 L
.97143 .21092 L
Mistroke
.97619 .21092 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00O5Goo00<007ooOol0
ogoo2Goo000EOol00`00Oomoo`3oOol9Ool000Moo`D0009oo`8000Eoo`03001oogoo0?moo`Uoo`00
2Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo0?moo`Uoo`002Goo00D007ooOomo
o`00009oo`03001oogoo009oo`<008moo`030n1oogoo07Ioo`0000=oo`0000000P0017oo00D007oo
Oomoo`00009oo`03001oogoo009oo`03001oogoo08moo`030n1oogoo07Ioo`002Goo00D007ooOomo
o`00009oo`03001oogoo009oo`03001oogoo08ioo`030n1oo`?P07Moo`0027oo0P0017oo0P001Goo
00<007ooOol0SWoo00<3h7oo0n00Mgoo000EOol00`00Oomoo`2=Ool01@?POomoogoo0n00MWoo000E
Ool2002>Ool01@?POomoogoo0n00MWoo000EOol00`00Oomoo`2=Ool01@?POomoogoo0n00MWoo000E
Ool00`00Oomoo`2=Ool00`?POomoo`02Ool00`?POomoo`1cOol001Eoo`03001oogoo08aoo`030n1o
ogoo00=oo`030n1oogoo07=oo`005Goo00<007ooOol0S7oo00<3h7ooOol017oo00<3h7ooOol0LWoo
000EOol2002=Ool00`?POomoo`04Ool00`?POomoo`1bOol001Eoo`03001oogoo08aoo`030n1oogoo
00Eoo`030n1oogoo075oo`005Goo00<007ooOol0S7oo00<3h7ooOol01Goo00<3h7ooOol0LGoo000E
Ool00`00Oomoo`2;Ool00`?POomoo`07Ool00`?POomoo`1`Ool001Eoo`03001oogoo08]oo`030n1o
ogoo00Qoo`030n1oogoo06moo`005Goo0P00S7oo00<3h7ooOol027oo00<3h7ooOol0Kgoo000EOol0
0`00Oomoo`2;Ool00`?POomoo`08Ool00`?POomoo`1_Ool001Eoo`03001oogoo08]oo`030n1oogoo
00Uoo`030n1oogoo06ioo`005Goo00<007ooOol0RWoo00<3h7ooOol02Woo00<3h7ooOol0KWoo000E
Ool00`00Oomoo`2:Ool00`?POomoo`0;Ool00`?POomoo`1]Ool001Eoo`8008]oo`030n1oogoo00]o
o`030n1oogoo06eoo`005Goo00<007ooOol0RWoo00<3h7ooOol037oo00<3h7ooOol0K7oo000EOol0
0`00Oomoo`2:Ool00`?POomoo`0<Ool00`?POomoo`1/Ool000ioo`8000Eoo`03001oogoo08Uoo`03
0n1oogoo00ioo`030n1oogoo06]oo`003Goo00@007ooOol000Aoo`03001oogoo08Uoo`030n1oogoo
00moo`030n1oogoo06Yoo`0047oo00<007ooOol00Woo0`00RGoo00<3h7ooOol03goo00<3h7ooOol0
JWoo0007Ool40003Ool20005Ool00`00Oomoo`29Ool00`?POomoo`0?Ool00`?POomoo`1ZOol000io
o`03001oogoo00Aoo`03001oogoo08Qoo`030n1oogoo015oo`030n1oogoo06Uoo`003Woo0`0017oo
00<007ooOol0R7oo00<3h7ooOol04Goo00<3h7ooOol0JGoo000EOol00`00Oomoo`27Ool00`?POomo
o`0COol00`?POomoo`1XOol001Eoo`8008Qoo`030n1oogoo01=oo`030n1oogoo06Qoo`005Goo00<0
07ooOol0Qgoo00<3h7ooOol04goo00<3h7ooOol0J7oo000EOol00`00Oomoo`27Ool00`?POomoo`0D
Ool00`?POomoo`1WOol001Eoo`03001oogoo08Ioo`030n1oogoo01Eoo`030n1oogoo06Moo`005Goo
00<007ooOol0QWoo00<3h7ooOol05Woo00<3h7ooOol0IWoo000EOol20027Ool00`?POomoo`0GOol0
0`?POomoo`1UOol001Eoo`03001oogoo08Ioo`030n1oogoo01Moo`030n1oogoo06Eoo`005Goo00<0
07ooOol0QWoo00<3h7ooOol067oo00<3h7ooOol0I7oo000EOol00`00Oomoo`25Ool00`?POomoo`0I
Ool00`?POomoo`1TOol001Eoo`03001oogoo03=oo`8000Aoo`8000Aoo`8003=oo`D000aoo`030n1o
ogoo01Yoo`030n1oogoo00Ioo`D0009oo`8000Aoo`8003Aoo`@001Ioo`005Goo0P00<goo00@007oo
Ool000Qoo`04001oogoo000dOol00`00Oomoo`0<Ool00`?POomoo`0JOol00`?POomoo`08Ool00`00
Oomoo`07Ool01000Oomoo`00<goo00<007ooOol05goo000EOol00`00Oomoo`0bOol01000Oomoo`00
2goo00<007ooOol0<Woo00<007ooOol037oo00<3h7ooOol06Woo00<3h7ooOol027oo00<007ooOol0
2Woo00<007ooOol0<Woo00<007ooOol05Woo000EOol00`00Oomoo`0bOol01000Oomoo`002Goo0P00
=Goo00<007ooOol037oo00<3h7ooOol06goo00<3h7ooOol01goo00<007ooOol027oo0P00=Woo00<0
07ooOol05Goo000EOol00`00Oomoo`0bOol01000Oomoo`002Goo00<007ooOol0=7oo00<007ooOol0
2goo00<3h7ooOol077oo00<3h7ooOol01goo00<007ooOol027oo00<007ooOol0<goo00@007ooOol0
01Ioo`005Goo00<007ooOol0<goo0P002Woo0`00<goo0P003Goo00<3h7ooOol07Goo00<3h7ooOol0
1Goo0P002Woo0`00=7oo0P005goo000EOol20025Ool00`?POomoo`0MOol00`?POomoo`1QOol001Eo
o`03001oogoo08Aoo`030n1oogoo01ioo`030n1oogoo061oo`005Goo00<007ooOol0Q7oo00<3h7oo
Ool07Woo00<3h7ooOol0H7oo000EOol00`00Oomoo`23Ool00`?POomoo`0POol00`?POomoo`1OOol0
01Eoo`03001oogoo08=oo`030n1oogoo025oo`030n1oogoo05Ioo`8000Ioo`003goo1P0000<3h000
0000P`0000<3h00000008@00BP?P1P0027oo00@007ooOol000Eoo`005Goo00<000?POol02Goo00<0
07ooOol02Goo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<0
07ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<3
h000Ool02Woo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<0
07ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol037oo00<0
07ooOol01Woo000EOol00`000n1oo`0jOol00`00Oomoo`0iOol00`00Oomoo`08Ool00`?POomoo`0_
Ool00`00Oomoo`0jOol00`00Oomoo`0;Ool50005Ool001Eoo`03001oo`?P081oo`030n1oogoo07ao
o`03001oogoo00Ioo`005Goo00@007ooOol3h7moo`030n1oogoo08Eoo`005Goo0P0000=oo`?POol0
OGoo00<3h7ooOol0QWoo000EOol01@00Oomoogoo0n00O7oo00<3h7ooOol0Qgoo000EOol01@00Oomo
ogoo0n00Ngoo00<3h7ooOol0R7oo000EOol00`00Oomoo`02Ool00`?POomoo`1gOol00`?POomoo`29
Ool001Eoo`03001oogoo009oo`030n1oogoo07Ioo`030n1oogoo08Yoo`005Goo0P0017oo00<3h7oo
Ool0MGoo00<3h7ooOol0RWoo000EOol00`00Oomoo`03Ool00`?POomoo`1dOol00`?POomoo`2;Ool0
01Eoo`03001oogoo00Aoo`030n1oogoo079oo`030n1oogoo08aoo`005Goo00<007ooOol017oo00<3
h7ooOol0LWoo00<3h7ooOol0S7oo000EOol00`00Oomoo`05Ool00`?POomoo`1_Ool20n2?Ool001Eo
o`8000Ioo`030n1oogoo06ioo`030n1oogoo08moo`005Goo00<007ooOol01Woo00<3h7ooOol0KGoo
00<3h7ooOol0Sgoo000EOol00`00Oomoo`07Ool00`?POomoo`1[Ool00`?POomoo`2@Ool001Eoo`03
001oogoo00Moo`030n1oogoo06Yoo`030n1oogoo095oo`005Goo00<007ooOol027oo00<3h7ooOol0
JGoo00<3h7ooOol0TGoo000EOol20009Ool00`?POomoo`1XOol00`?POomoo`2BOol001Eoo`03001o
ogoo00Uoo`030n1oogoo06Moo`030n1oogoo099oo`005Goo00<007ooOol02Goo00<3h7ooOol0IGoo
0P?PUGoo000>Ool20005Ool00`00Oomoo`0:Ool00`?POomoo`1SOol00`?POomoo`2EOol000eoo`04
001oogoo0004Ool00`00Oomoo`0;Ool00`?POomoo`1ROol00`?POomoo`2EOol0011oo`03001oogoo
009oo`<000]oo`030n1oogoo065oo`030n1oogoo09Ioo`003Woo0P001Goo00<007ooOol037oo00<3
h7ooOol0Ggoo00<3h7ooOol0Ugoo000>Ool00`00Oomoo`04Ool00`00Oomoo`0<Ool00`?POomoo`1O
Ool00`?POomoo`2GOol000ioo`<000Aoo`03001oogoo00eoo`030n1oogoo05aoo`83h9Yoo`005Goo
00<007ooOol03Goo00<3h7ooOol0Fgoo00<3h7ooOol0VWoo000EOol2000?Ool00`?POomoo`1JOol0
0`?POomoo`2JOol001Eoo`03001oogoo00ioo`030n1oogoo05Uoo`030n1oogoo09]oo`005Goo00<0
07ooOol03goo00<3h7ooOol0Egoo00<3h7ooOol0W7oo000EOol00`00Oomoo`0?Ool00`?POomoo`1G
Ool00`?POomoo`2LOol001Eoo`03001oogoo011oo`030n1oogoo05Eoo`030n1oogoo09eoo`005Goo
0P004Goo00<3h7ooOol0E7oo00<3h7ooOol0WWoo000EOol00`00Oomoo`0AOol00`?POomoo`1BOol0
0`?POomoo`2OOol001Eoo`03001oogoo019oo`030n1oogoo051oo`030n1oogoo0:1oo`005Goo00<0
07ooOol04Woo00<3h7ooOol0Cgoo00<3h7ooOol0XGoo000EOol00`00Oomoo`0COol00`?POomoo`1>
Ool00`?POomoo`2QOol001Eoo`8001Aoo`030n1oogoo04eoo`030n1oogoo0:9oo`005Goo00<007oo
Ool057oo00<3h7ooOol0Bgoo00<3h7ooOol0Xgoo000EOol00`00Oomoo`0DOol00`?POomoo`1;Ool0
0`?POomoo`2SOol001Eoo`03001oogoo01Eoo`030n1oogoo04Uoo`030n1oogoo0:Aoo`005Goo00<0
07ooOol05Goo00<3h7ooOol0B7oo00<3h7ooOol0YGoo000EOol2000GOol00`?POomoo`16Ool00`?P
Oomoo`2VOol001Eoo`03001oogoo01Ioo`030n1oogoo04Eoo`030n1oogoo0:Moo`005Goo00<007oo
Ool05goo00<3h7ooOol0A7oo00<3h7ooOol0Ygoo0007Ool50002Ool20005Ool00`00Oomoo`0HOol0
0`?POomoo`12Ool00`?POomoo`2XOol000Uoo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00
Oomoo`0HOol00`?POomoo`11Ool00`?POomoo`2YOol000Uoo`05001oogooOol00002Ool00`00Oomo
o`02Ool3000IOol00`?POomoo`10Ool00`?POomoo`2YOol000Uoo`05001oogooOol00002Ool00`00
Oomoo`02Ool00`00Oomoo`0IOol00`?POomoo`0nOol20n2/Ool000Uoo`05001oogooOol00002Ool0
0`00Oomoo`02Ool00`00Oomoo`0JOol00`?POomoo`0lOol00`?POomoo`2/Ool000Qoo`8000Aoo`80
00Eoo`03001oogoo01Yoo`030n1oogoo03aoo`030n1oogoo0:aoo`005Goo00<007ooOol06goo00<3
h7ooOol0>Woo00<3h7ooOol0[Goo000EOol2000LOol00`?POomoo`0iOol00`?POomoo`2^Ool001Eo
o`03001oogoo01aoo`030n1oogoo03Qoo`030n1oogoo0:ioo`005Goo00<007ooOol077oo00<3h7oo
Ool0=Woo0P?P/Goo000EOol00`00Oomoo`0MOol00`?POomoo`0dOol00`?POomoo`2aOol001Eoo`03
001oogoo01ioo`030n1oogoo03=oo`030n1oogoo0;5oo`005Goo0P007goo00<3h7ooOol0<Woo00<3
h7ooOol0/Woo000EOol00`00Oomoo`0OOol00`?POomoo`0`Ool00`?POomoo`2cOol001Eoo`03001o
ogoo01moo`030n1oogoo031oo`030n1oogoo0;=oo`005Goo00<007ooOol087oo00<3h7ooOol0;Woo
00<3h7ooOol0]7oo000EOol00`00Oomoo`0POol00`?POomoo`0^Ool00`?POomoo`2dOol001Eoo`80
029oo`030n1oogoo02]oo`83h;Moo`005Goo00<007ooOol08Goo00<3h7ooOol0:Woo00<3h7ooOol0
]goo000EOol00`00Oomoo`0ROol00`?POomoo`0YOol00`?POomoo`2gOol001Eoo`03001oogoo02=o
o`030n1oogoo02Moo`030n1oogoo0;Qoo`005Goo00<007ooOol08goo00<3h7ooOol09Woo00<3h7oo
Ool0^Goo000EOol2000UOol00`?POomoo`0UOol00`?POomoo`2iOol001Eoo`03001oogoo02Aoo`03
0n1oogoo02Aoo`030n1oogoo0;Yoo`005Goo00<007ooOol09Goo00<3h7ooOol08Woo00<3h7ooOol0
^goo0007Ool50002Ool20005Ool00`00Oomoo`0UOol00`?POomoo`0QOol00`?POomoo`2lOol000Uo
o`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`0VOol00`?POomoo`0OOol00`?POomo
o`2mOol000Uoo`03001oogoo00Aoo`03001oogoo009oo`<002Ioo`030n1oogoo01ioo`030n1oogoo
0;ioo`002Goo00<007ooOol00Woo0P001Goo00<007ooOol09goo00<3h7ooOol07Goo00<3h7ooOol0
_Woo0009Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0WOol00`?POomoo`0LOol00`?P
Oomoo`2oOol000Qoo`8000Aoo`<000Aoo`03001oogoo02Qoo`030n1oogoo01Yoo`030n1oogoo0<1o
o`005Goo00<007ooOol0:Goo00<3h7ooOol067oo00<3h7ooOol0`Goo000EOol2000ZOol00`?POomo
o`0GOol00`?POomoo`32Ool001Eoo`03001oogoo02Yoo`030n1oogoo01Eoo`030n1oogoo0<=oo`00
5Goo00<007ooOol0:Woo00<3h7ooOol05Goo00<3h7ooOol0`goo000EOol00`00Oomoo`0[Ool00`?P
Oomoo`0COol00`?POomoo`34Ool001Eoo`03001oogoo02]oo`030n1oogoo01=oo`030n1oogoo0<Ao
o`005Goo0P00;7oo00<3h7ooOol04Woo00<3h7ooOol0aGoo000EOol00`00Oomoo`0/Ool00`?POomo
o`0@Ool00`?POomoo`36Ool001Eoo`03001oogoo02aoo`030n1oogoo00moo`030n1oogoo0<Moo`00
5Goo00<007ooOol0;Goo00<3h7ooOol03Goo00<3h7ooOol0b7oo000EOol00`00Oomoo`0^Ool00`?P
Oomoo`0;Ool00`?POomoo`39Ool001Eoo`80031oo`030n1oogoo00Yoo`030n1oogoo0<Uoo`005Goo
00<007ooOol0;goo00<3h7ooOol02Goo00<3h7ooOol0bWoo000EOol00`00Oomoo`0`Ool00`?POomo
o`07Ool00`?POomoo`3;Ool001Eoo`03001oogoo031oo`030n1oogoo00Moo`030n1oogoo0<]oo`00
5Goo00<007ooOol0<Goo00<3h7ooOol017oo0P?PcWoo000EOol2000bOol00`?POomoo`03Ool00`?P
Oomoo`3>Ool001Eoo`03001oogoo035oo`030n1oogoo00=oo`030n1oogoo0<ioo`005Goo00<007oo
Ool0<Woo00D3h7ooOomoo`?P0=5oo`001goo10000goo0P001Goo00<007ooOol0<Woo00@3h7ooOol3
h=9oo`001goo00<007ooOol00goo00@007ooOol000Aoo`03001oogoo03=oo`030n1oo`?P0=9oo`00
27oo00<007ooOol00Woo00@007ooOol000Aoo`<003Aoo`030n1oogoo0=5oo`002Goo00D007ooOomo
o`00009oo`03001oogoo009oo`03001oogoo0?moo`Uoo`001goo00@007ooOol0009oo`04001oogoo
0004Ool00`00Oomoo`3oOol9Ool000Qoo`8000Aoo`8000Eoo`03001oogoo0?moo`Uoo`005Goo00<0
07ooOol0ogoo2Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo
003oOolQOol00?moob5oo`004Woo0`00ogoo37oo000COol00`00Oomoo`3oOol;Ool001=oo`<00?mo
o`]oo`004goo00@007ooOol00?moo`Yoo`004goo00@007ooOol00?moo`Yoo`004Woo1000ogoo2goo
003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.178731, -10.9009, \
0.00824988, 0.200229}}],

Cell[BoxData[
    \("Desplazamientos:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.851472 [
[.2619 .00222 -9 -9 ]
[.2619 .00222 9 0 ]
[.5 .00222 -3 -9 ]
[.5 .00222 3 0 ]
[.7381 .00222 -9 -9 ]
[.7381 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .09986 -18 -4.5 ]
[.01131 .09986 0 4.5 ]
[.01131 .18501 -18 -4.5 ]
[.01131 .18501 0 4.5 ]
[.01131 .27016 -18 -4.5 ]
[.01131 .27016 0 4.5 ]
[.01131 .3553 -18 -4.5 ]
[.01131 .3553 0 4.5 ]
[.01131 .44045 -18 -4.5 ]
[.01131 .44045 0 4.5 ]
[.01131 .5256 -18 -4.5 ]
[.01131 .5256 0 4.5 ]
[.01131 .61075 -18 -4.5 ]
[.01131 .61075 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(0.5)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(1)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(1.5)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(2)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .09986 m
.03006 .09986 L
s
[(0.1)] .01131 .09986 1 0 Mshowa
.02381 .18501 m
.03006 .18501 L
s
[(0.2)] .01131 .18501 1 0 Mshowa
.02381 .27016 m
.03006 .27016 L
s
[(0.3)] .01131 .27016 1 0 Mshowa
.02381 .3553 m
.03006 .3553 L
s
[(0.4)] .01131 .3553 1 0 Mshowa
.02381 .44045 m
.03006 .44045 L
s
[(0.5)] .01131 .44045 1 0 Mshowa
.02381 .5256 m
.03006 .5256 L
s
[(0.6)] .01131 .5256 1 0 Mshowa
.02381 .61075 m
.03006 .61075 L
s
[(0.7)] .01131 .61075 1 0 Mshowa
.125 Mabswid
.02381 .03174 m
.02756 .03174 L
s
.02381 .04877 m
.02756 .04877 L
s
.02381 .0658 m
.02756 .0658 L
s
.02381 .08283 m
.02756 .08283 L
s
.02381 .11689 m
.02756 .11689 L
s
.02381 .13392 m
.02756 .13392 L
s
.02381 .15095 m
.02756 .15095 L
s
.02381 .16798 m
.02756 .16798 L
s
.02381 .20204 m
.02756 .20204 L
s
.02381 .21907 m
.02756 .21907 L
s
.02381 .2361 m
.02756 .2361 L
s
.02381 .25313 m
.02756 .25313 L
s
.02381 .28719 m
.02756 .28719 L
s
.02381 .30422 m
.02756 .30422 L
s
.02381 .32124 m
.02756 .32124 L
s
.02381 .33827 m
.02756 .33827 L
s
.02381 .37233 m
.02756 .37233 L
s
.02381 .38936 m
.02756 .38936 L
s
.02381 .40639 m
.02756 .40639 L
s
.02381 .42342 m
.02756 .42342 L
s
.02381 .45748 m
.02756 .45748 L
s
.02381 .47451 m
.02756 .47451 L
s
.02381 .49154 m
.02756 .49154 L
s
.02381 .50857 m
.02756 .50857 L
s
.02381 .54263 m
.02756 .54263 L
s
.02381 .55966 m
.02756 .55966 L
s
.02381 .57669 m
.02756 .57669 L
s
.02381 .59372 m
.02756 .59372 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.02857 .01478 L
.03333 .0151 L
.0381 .01572 L
.04286 .01664 L
.04762 .01786 L
.05238 .01938 L
.05714 .0212 L
.0619 .02332 L
.06667 .02572 L
.07143 .02843 L
.07619 .03142 L
.08095 .0347 L
.08571 .03827 L
.09048 .04213 L
.09524 .04627 L
.1 .0507 L
.10476 .05541 L
.10952 .0604 L
.11429 .06567 L
.11905 .07122 L
.12381 .07705 L
.12857 .08315 L
.13333 .08953 L
.1381 .09618 L
.14286 .10311 L
.14762 .1103 L
.15238 .11776 L
.15714 .12549 L
.1619 .13349 L
.16667 .14175 L
.17143 .15027 L
.17619 .15906 L
.18095 .1681 L
.18571 .17741 L
.19048 .18698 L
.19524 .1968 L
.2 .20688 L
.20476 .21721 L
.20952 .2278 L
.21429 .23864 L
.21905 .24973 L
.22381 .26107 L
.22857 .27265 L
.23333 .28449 L
.2381 .29657 L
.24286 .30879 L
.24762 .32081 L
.25238 .33257 L
.25714 .34406 L
Mistroke
.2619 .35528 L
.26667 .36624 L
.27143 .37693 L
.27619 .38736 L
.28095 .39752 L
.28571 .40742 L
.29048 .41706 L
.29524 .42644 L
.3 .43556 L
.30476 .44443 L
.30952 .45304 L
.31429 .4614 L
.31905 .4695 L
.32381 .47736 L
.32857 .48496 L
.33333 .49231 L
.3381 .49942 L
.34286 .50628 L
.34762 .51289 L
.35238 .51926 L
.35714 .52539 L
.3619 .53128 L
.36667 .53692 L
.37143 .54233 L
.37619 .5475 L
.38095 .55243 L
.38571 .55712 L
.39048 .56158 L
.39524 .56581 L
.4 .56981 L
.40476 .57357 L
.40952 .57711 L
.41429 .58041 L
.41905 .58349 L
.42381 .58634 L
.42857 .58897 L
.43333 .59137 L
.4381 .59355 L
.44286 .59551 L
.44762 .59725 L
.45238 .59876 L
.45714 .60006 L
.4619 .60114 L
.46667 .60201 L
.47143 .60265 L
.47619 .60309 L
.48095 .60331 L
.48571 .60332 L
.49048 .60312 L
.49524 .6027 L
Mistroke
.5 .60208 L
.50476 .60125 L
.50952 .60022 L
.51429 .59898 L
.51905 .59753 L
.52381 .59588 L
.52857 .59403 L
.53333 .59197 L
.5381 .58972 L
.54286 .58726 L
.54762 .5846 L
.55238 .58166 L
.55714 .5781 L
.5619 .57389 L
.56667 .56902 L
.57143 .56348 L
.57619 .55728 L
.58095 .55043 L
.58571 .54293 L
.59048 .53478 L
.59524 .52598 L
.6 .51675 L
.60476 .50777 L
.60952 .49915 L
.61429 .49091 L
.61905 .48306 L
.62381 .4756 L
.62857 .46851 L
.63333 .4618 L
.6381 .45546 L
.64286 .4495 L
.64762 .44392 L
.65238 .4387 L
.65714 .43386 L
.6619 .42938 L
.66667 .42526 L
.67143 .42151 L
.67619 .41813 L
.68095 .4151 L
.68571 .41243 L
.69048 .41011 L
.69524 .40808 L
.7 .40611 L
.70476 .40416 L
.70952 .40221 L
.71429 .40028 L
.71905 .39836 L
.72381 .39644 L
.72857 .39454 L
.73333 .39264 L
Mistroke
.7381 .39075 L
.74286 .38888 L
.74762 .38701 L
.75238 .38515 L
.75714 .3833 L
.7619 .38146 L
.76667 .37963 L
.77143 .37781 L
.77619 .376 L
.78095 .3742 L
.78571 .3724 L
.79048 .37062 L
.79524 .36884 L
.8 .36708 L
.80476 .36532 L
.80952 .36357 L
.81429 .36183 L
.81905 .36009 L
.82381 .35837 L
.82857 .35666 L
.83333 .35495 L
.8381 .35325 L
.84286 .35156 L
.84762 .34988 L
.85238 .34821 L
.85714 .34654 L
.8619 .34489 L
.86667 .34324 L
.87143 .3416 L
.87619 .33997 L
.88095 .33835 L
.88571 .33673 L
.89048 .33512 L
.89524 .33352 L
.9 .33193 L
.90476 .33035 L
.90952 .32877 L
.91429 .32721 L
.91905 .32565 L
.92381 .3241 L
.92857 .32255 L
.93333 .32102 L
.9381 .31949 L
.94286 .31797 L
.94762 .31645 L
.95238 .31495 L
.95714 .31345 L
.9619 .31196 L
.96667 .31047 L
.97143 .309 L
Mistroke
.97619 .30753 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo001>Ool2
0004Ool20004Ool2000aOol5000^Ool50002Ool20004Ool2000aOol4000LOol004eoo`04001oogoo
0008Ool01000Oomoo`00<Woo00<007ooOol0<7oo00<007ooOol01goo00@007ooOol0031oo`03001o
ogoo01eoo`00CGoo00@007ooOol000]oo`03001oogoo031oo`03001oogoo031oo`03001oogoo00Yo
o`03001oogoo02moo`03001oogoo01aoo`00CGoo00@007ooOol000Uoo`8003=oo`03001oogoo031o
o`03001oogoo00Qoo`8003=oo`03001oogoo01]oo`00CGoo00@007ooOol000Uoo`03001oogoo039o
o`03001oogoo031oo`03001oogoo00Qoo`03001oogoo031oo`04001oogoo000LOol004ioo`8000Yo
o`<0035oo`80035oo`8000Yoo`<0035oo`8001eoo`00ogoo8Goo000KOol00`00Oomoo`3oOol3Ool0
01]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0m7oo0P0037oo000KOol00`00Oomoo`3cOol0
1000Oomoo`002goo000EOol60007O03W0008Ool00`00Oomoo`0<Ool001]oo`03001oogoo00Aoo`9l
00=oo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo
00Qoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo
00Qoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo
00Uoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo
00]oo`D000]oo`006goo00<007ooOol01Woo0g`0jWoo00<007ooOol037oo000KOol00`00Oomoo`09
Ool00g`0Oomoo`3fOol001]oo`8000]oo`9l0?Ioo`006goo00<007ooOol037oo00=l07ooOol0lgoo
000KOol00`00Oomoo`0=Ool00g`0Oomoo`3bOol001]oo`03001oogoo00ioo`9l0?9oo`006goo0P00
4Goo00=l07ooOol0kgoo000KOol00`00Oomoo`0AOol00g`0Oomoo`3^Ool001]oo`03001oogoo019o
o`03O01oogoo0>eoo`006goo00<007ooOol04Woo00=l07ooOol0kGoo000KOol2000DOol00g`0Oomo
o`3/Ool001]oo`03001oogoo01Aoo`03O01oogoo0>]oo`006goo00<007ooOol05Goo00=l07ooOol0
jWoo000KOol00`00Oomoo`0EOol2O03[Ool001]oo`8001Qoo`03O01oogoo0>Qoo`006goo00<007oo
Ool067oo00=l07ooOol0igoo0008Ool20004Ool20003Ool50003Ool00`00Oomoo`0HOol00g`0Oomo
o`3WOol000Moo`04001oogoo000:Ool00`00Oomoo`03Ool00`00Oomoo`0IOol00g`0Oomoo`3VOol0
00Moo`04001oogoo000:Ool00`00Oomoo`03Ool3000JOol00g`0Oomoo`3UOol000Moo`04001oogoo
000:Ool00`00Oomoo`03Ool00`00Oomoo`0JOol00g`0Oomoo`3UOol000Moo`04001oogoo000:Ool0
0`00Oomoo`03Ool00`00Oomoo`0KOol00g`0Oomoo`3TOol000Qoo`8000Yoo`8000Eoo`03001oogoo
01]oo`03O01oogoo0>Aoo`006goo0P007Goo00=l07ooOol0hgoo000KOol00`00Oomoo`0LOol00g`0
Oomoo`3SOol001]oo`03001oogoo01eoo`03O01oogoo0>9oo`006goo00<007ooOol07Woo00=l07oo
Ool0hGoo000KOol00`00Oomoo`0OOol00g`0Oomoo`3POol001]oo`80025oo`03O01oogoo0=moo`00
6goo00<007ooOol087oo00=l07ooOol0ggoo000KOol00`00Oomoo`0QOol00g`0Oomoo`3NOol001]o
o`03001oogoo025oo`03O01oogoo0=ioo`006goo0P008Woo00=l07ooOol0gWoo000KOol00`00Oomo
o`0ROol00g`0Oomoo`3MOol001]oo`03001oogoo029oo`03O01oogoo0=eoo`006goo00<007ooOol0
8goo00=l07ooOol0g7oo000KOol2000TOol00g`0Oomoo`3LOol001]oo`03001oogoo02Aoo`03O01o
ogoo0=]oo`0027oo0P0017oo0P000goo100017oo00<007ooOol097oo00=l07ooOol0fgoo0007Ool0
1000Oomoo`0027oo00<007ooOol01Goo00<007ooOol09Goo00=l07ooOol0fWoo0007Ool01000Oomo
o`002Goo00<007ooOol017oo0`009Woo00=l07ooOol0fGoo0007Ool01000Oomoo`002Woo00<007oo
Ool00goo00<007ooOol09Woo00=l07ooOol0fGoo0007Ool01000Oomoo`0027oo00@007ooOol000Ao
o`03001oogoo02Moo`03O01oogoo0=Qoo`0027oo0P002Woo0P001Goo00<007ooOol09goo00=l07oo
Ool0f7oo000KOol2000YOol00g`0Oomoo`3GOol001]oo`03001oogoo02Qoo`03O01oogoo0=Moo`00
6goo00<007ooOol0:7oo00=l07ooOol0egoo000KOol00`00Oomoo`0YOol00g`0Oomoo`3FOol001]o
o`8002Yoo`03O01oogoo0=Ioo`006goo00<007ooOol0:Woo00=l07ooOol0eGoo000KOol00`00Oomo
o`0ZOol00g`0Oomoo`3EOol001]oo`03001oogoo02Yoo`03O01oogoo0=Eoo`006goo0P00;7oo00=l
07ooOol0e7oo000KOol00`00Oomoo`0[Ool00g`0Oomoo`3DOol001]oo`03001oogoo02]oo`03O01o
ogoo0=Aoo`006goo00<007ooOol0;7oo00=l07ooOol0dgoo000KOol2000]Ool00g`0Oomoo`3COol0
01]oo`03001oogoo02eoo`03O01oogoo0=9oo`006goo00<007ooOol0;Woo00=l07ooOol0dGoo0008
Ool20004Ool20004Ool20005Ool00`00Oomoo`0^Ool00g`0Oomoo`3AOol000Moo`04001oogoo0008
Ool01000Oomoo`0017oo00<007ooOol0;goo00=l07ooOol0d7oo0007Ool01000Oomoo`002Woo00<0
07ooOol00goo0`00;goo00=l07ooOol0d7oo0007Ool01000Oomoo`002goo00<007ooOol00Woo00<0
07ooOol0;goo00=l07ooOol0d7oo0007Ool01000Oomoo`0027oo00@007ooOol000Aoo`03001oogoo
031oo`03O01oogoo0<moo`0027oo0P002Woo0P001Goo00<007ooOol0<7oo00=l07ooOol0cgoo000K
Ool2000aOol00g`0Oomoo`3?Ool001]oo`03001oogoo035oo`03O01oogoo0<ioo`006goo00<007oo
Ool0<Goo00=l07ooOol0cWoo000KOol00`00Oomoo`0aOol00g`0Oomoo`3>Ool001]oo`8003=oo`03
O01oogoo0<eoo`006goo00<007ooOol0<Woo00=l07ooOol0[Goo0g`07Goo000KOol00`00Oomoo`0b
Ool00g`0Oomoo`2YOol4O00POol001]oo`03001oogoo03=oo`03O01oogoo0:Ioo`9l02Aoo`006goo
0P00=7oo00=l07ooOol0XWoo17`09Woo000KOol00`00Oomoo`0dOol00g`0Oomoo`2NOol3O00ZOol0
01]oo`03001oogoo03Aoo`03O01oogoo09aoo`9l02eoo`006goo00<007ooOol0=Goo00=l07ooOol0
Ugoo17`0;goo000KOol2000gOol00g`0Oomoo`2COol3O00cOol001]oo`03001oogoo03Ioo`03O01o
ogoo091oo`=l03Ioo`0027oo0P0017oo0P001Goo0`000goo00<007ooOol0=Woo00=l07ooOol0SGoo
0g`0>Goo0007Ool01000Oomoo`002goo00<007ooOol00Woo00<007ooOol0=goo00=l07ooOol0RWoo
0W`0?7oo0007Ool01000Oomoo`0027oo1@000goo0`00=goo00=l07ooOol0Qgoo0g`0?Woo0007Ool0
1000Oomoo`0027oo00@007ooOol000Aoo`03001oogoo03Moo`03O01oogoo08Aoo`=l045oo`001goo
00@007ooOol000Uoo`03001oo`0000Aoo`03001oogoo03Qoo`03O01oogoo085oo`9l04Aoo`0027oo
0P002goo0P0017oo00<007ooOol0>7oo00=l07ooOol0OGoo17`0AWoo000KOol2000jOol00g`0Oomo
o`1jOol2O01:Ool001]oo`03001oogoo03Uoo`03O01oogoo07Moo`=l04aoo`006goo00<007ooOol0
>Goo00=l07ooOol0MGoo0W`0Cgoo000KOol00`00Oomoo`0jOol00g`0Oomoo`1aOol3O01AOol001]o
o`8003]oo`03O01oogoo06ioo`=l05Aoo`006goo00<007ooOol0>goo00=l07ooOol0Jgoo0W`0Egoo
000KOol00`00Oomoo`0kOol00g`0Oomoo`1YOol2O01IOol001]oo`03001oogoo03aoo`03O01oogoo
06Eoo`=l05]oo`006goo00<007ooOol0?7oo00=l07ooOol0Hgoo0W`0GWoo000KOol2000nOol00g`0
Oomoo`1OOol3O01POol001]oo`03001oogoo03ioo`03O01oogoo05aoo`9l06=oo`006goo00<007oo
Ool0?Woo00=l07ooOol0FWoo0W`0IGoo000KOol00`00Oomoo`0oOol00g`0Oomoo`1HOol00g`0Oomo
o`1UOol001]oo`80041oo`03O01oogoo05Moo`03O01oogoo06Ioo`006goo00<007ooOol0?goo00=l
07ooOol0EWoo00=l07ooOol0Igoo0008Ool20004Ool20004Ool20005Ool00`00Oomoo`10Ool00g`0
Oomoo`1DOol00g`0Oomoo`1XOol000Moo`04001oogoo0008Ool01000Oomoo`0017oo00<007ooOol0
@7oo00=l07ooOol0Dgoo00=l07ooOol0JGoo0007Ool01000Oomoo`002goo00<007ooOol00Woo0`00
@Goo00=l07ooOol0DGoo00=l07ooOol0JWoo0007Ool01000Oomoo`002Goo0P001Goo00<007ooOol0
@Goo00=l07ooOol0D7oo00=l07ooOol0Jgoo0007Ool01000Oomoo`002Goo00<007ooOol017oo00<0
07ooOol0@Woo00=l07ooOol0CWoo00=l07ooOol0K7oo0008Ool2000:Ool30004Ool00`00Oomoo`12
Ool00g`0Oomoo`1=Ool00g`0Oomoo`1]Ool001]oo`8004Aoo`03O01oogoo04aoo`03O01oogoo06eo
o`006goo00<007ooOol0A7oo00=l07ooOol0BWoo00=l07ooOol0KWoo000KOol00`00Oomoo`15Ool0
0g`0Oomoo`19Ool00g`0Oomoo`1^Ool001]oo`03001oogoo04Eoo`03O01oogoo04Qoo`03O01oogoo
06moo`006goo0P00Agoo00=l07ooOol0AWoo00=l07ooOol0L7oo000KOol00`00Oomoo`16Ool00g`0
Oomoo`15Ool00g`0Oomoo`1aOol001]oo`03001oogoo04Moo`03O01oogoo04=oo`03O01oogoo079o
o`006goo00<007ooOol0Agoo00=l07ooOol0@goo00=l07ooOol0LWoo000KOol20019Ool00g`0Oomo
o`11Ool00g`0Oomoo`1cOol001]oo`03001oogoo04Uoo`03O01oogoo041oo`03O01oogoo07=oo`00
6goo00<007ooOol0BGoo00=l07ooOol0?goo00=l07ooOol0M7oo000KOol00`00Oomoo`1:Ool00g`0
Oomoo`0nOol00g`0Oomoo`1dOol001]oo`8004]oo`9l03ioo`03O01oogoo07Eoo`006goo00<007oo
Ool0C7oo00=l07ooOol0>goo00=l07ooOol0MGoo000KOol00`00Oomoo`1=Ool00g`0Oomoo`0iOol0
0g`0Oomoo`1fOol000Qoo`8000Aoo`8000=oo`<000Eoo`03001oogoo04eoo`03O01oogoo03Uoo`03
O01oogoo07Ioo`001goo00@007ooOol000Qoo`04001oogoo0004Ool00`00Oomoo`1>Ool00g`0Oomo
o`0gOol00g`0Oomoo`1gOol000Moo`04001oogoo0008Ool01000Oomoo`0017oo0`00Cgoo00=l07oo
Ool0=Woo00=l07ooOol0Mgoo0007Ool01000Oomoo`0027oo0`001Goo00<007ooOol0Cgoo00=l07oo
Ool0=Woo00=l07ooOol0Mgoo0007Ool01000Oomoo`002Goo00<007ooOol017oo00<007ooOol0D7oo
00=l07ooOol0=7oo00=l07ooOol0N7oo0008Ool2000:Ool30004Ool00`00Oomoo`1AOol00g`0Oomo
o`0bOol00g`0Oomoo`1iOol001]oo`80059oo`9l039oo`03O01oogoo07Yoo`006goo00<007ooOol0
Dgoo00=l07ooOol0;goo00=l07ooOol0NWoo000KOol00`00Oomoo`1DOol00g`0Oomoo`0]Ool00g`0
Oomoo`1kOol001]oo`03001oogoo05Eoo`03O01oogoo02]oo`03O01oogoo07aoo`006goo0P00Egoo
00=l07ooOol0:Woo00=l07ooOol0O7oo000KOol00`00Oomoo`1GOol00g`0Oomoo`0XOol00g`0Oomo
o`1mOol001]oo`03001oogoo05Qoo`03O01oogoo02Ioo`03O01oogoo07ioo`006goo00<007ooOol0
FGoo0W`097oo0W`0PGoo000KOol2001LOol00g`0Oomoo`0POol00g`0Oomoo`21Ool001]oo`03001o
ogoo05aoo`03O01oogoo01ioo`03O01oogoo089oo`006goo00<007ooOol0GGoo0W`077oo0W`0QGoo
000KOol00`00Oomoo`1OOol3O00HOol00g`0Oomoo`25Ool001]oo`8006=oo`9l01=oo`=l08Qoo`00
6goo00<007ooOol0I7oo0W`03Woo0g`0Rgoo0008Ool20004Ool20005Ool00`00Oomoo`03Ool00`00
Oomoo`1VOol>O02>Ool000Moo`04001oogoo000:Ool00`00Oomoo`03Ool00`00Oomoo`3oOol3Ool0
00Moo`04001oogoo000:Ool00`00Oomoo`03Ool3003oOol3Ool000Moo`04001oogoo000;Ool00`00
Oomoo`02Ool00`00Oomoo`3oOol3Ool000Moo`04001oogoo0008Ool01000Oomoo`0017oo00<007oo
Ool0ogoo0goo0008Ool20009Ool4003oOol:Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol001Yoo`@00?moo`=oo`006Goo
00@007ooOol00?moo`Aoo`006Goo00@007ooOol00?moo`Aoo`0067oo0P0000=oo`000000ogoo17oo
003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.23887, -0.0582547, \
0.0086576, 0.00484181}}],

Cell[BoxData[
    InterpretationBox[\("M\[AAcute]ximo Desplazamiento: \
"\[InvisibleSpace]0.6912781405834654`\),
      SequenceForm[ "M\[AAcute]ximo Desplazamiento: ", .69127814058346537],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[IAcute]nimo Desplazamiento: "\[InvisibleSpace]0\),
      
      SequenceForm[ "M\[IAcute]nimo Desplazamiento: ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Velocidades:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.253239 0.414215 [
[.2619 .24074 -9 -9 ]
[.2619 .24074 9 0 ]
[.5 .24074 -3 -9 ]
[.5 .24074 3 0 ]
[.7381 .24074 -9 -9 ]
[.7381 .24074 9 0 ]
[.97619 .24074 -3 -9 ]
[.97619 .24074 3 0 ]
[1.025 .25324 0 -6.25 ]
[1.025 .25324 10 6.25 ]
[.01131 .00471 -24 -4.5 ]
[.01131 .00471 0 4.5 ]
[.01131 .08755 -24 -4.5 ]
[.01131 .08755 0 4.5 ]
[.01131 .1704 -24 -4.5 ]
[.01131 .1704 0 4.5 ]
[.01131 .33608 -18 -4.5 ]
[.01131 .33608 0 4.5 ]
[.01131 .41893 -18 -4.5 ]
[.01131 .41893 0 4.5 ]
[.01131 .50177 -18 -4.5 ]
[.01131 .50177 0 4.5 ]
[.01131 .58461 -18 -4.5 ]
[.01131 .58461 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .25324 m
.2619 .25949 L
s
[(0.5)] .2619 .24074 0 1 Mshowa
.5 .25324 m
.5 .25949 L
s
[(1)] .5 .24074 0 1 Mshowa
.7381 .25324 m
.7381 .25949 L
s
[(1.5)] .7381 .24074 0 1 Mshowa
.97619 .25324 m
.97619 .25949 L
s
[(2)] .97619 .24074 0 1 Mshowa
.125 Mabswid
.07143 .25324 m
.07143 .25699 L
s
.11905 .25324 m
.11905 .25699 L
s
.16667 .25324 m
.16667 .25699 L
s
.21429 .25324 m
.21429 .25699 L
s
.30952 .25324 m
.30952 .25699 L
s
.35714 .25324 m
.35714 .25699 L
s
.40476 .25324 m
.40476 .25699 L
s
.45238 .25324 m
.45238 .25699 L
s
.54762 .25324 m
.54762 .25699 L
s
.59524 .25324 m
.59524 .25699 L
s
.64286 .25324 m
.64286 .25699 L
s
.69048 .25324 m
.69048 .25699 L
s
.78571 .25324 m
.78571 .25699 L
s
.83333 .25324 m
.83333 .25699 L
s
.88095 .25324 m
.88095 .25699 L
s
.92857 .25324 m
.92857 .25699 L
s
.25 Mabswid
0 .25324 m
1 .25324 L
s
gsave
1.025 .25324 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .00471 m
.03006 .00471 L
s
[(-0.6)] .01131 .00471 1 0 Mshowa
.02381 .08755 m
.03006 .08755 L
s
[(-0.4)] .01131 .08755 1 0 Mshowa
.02381 .1704 m
.03006 .1704 L
s
[(-0.2)] .01131 .1704 1 0 Mshowa
.02381 .33608 m
.03006 .33608 L
s
[(0.2)] .01131 .33608 1 0 Mshowa
.02381 .41893 m
.03006 .41893 L
s
[(0.4)] .01131 .41893 1 0 Mshowa
.02381 .50177 m
.03006 .50177 L
s
[(0.6)] .01131 .50177 1 0 Mshowa
.02381 .58461 m
.03006 .58461 L
s
[(0.8)] .01131 .58461 1 0 Mshowa
.125 Mabswid
.02381 .02542 m
.02756 .02542 L
s
.02381 .04613 m
.02756 .04613 L
s
.02381 .06684 m
.02756 .06684 L
s
.02381 .10826 m
.02756 .10826 L
s
.02381 .12897 m
.02756 .12897 L
s
.02381 .14969 m
.02756 .14969 L
s
.02381 .19111 m
.02756 .19111 L
s
.02381 .21182 m
.02756 .21182 L
s
.02381 .23253 m
.02756 .23253 L
s
.02381 .27395 m
.02756 .27395 L
s
.02381 .29466 m
.02756 .29466 L
s
.02381 .31537 m
.02756 .31537 L
s
.02381 .35679 m
.02756 .35679 L
s
.02381 .3775 m
.02756 .3775 L
s
.02381 .39821 m
.02756 .39821 L
s
.02381 .43964 m
.02756 .43964 L
s
.02381 .46035 m
.02756 .46035 L
s
.02381 .48106 m
.02756 .48106 L
s
.02381 .52248 m
.02756 .52248 L
s
.02381 .54319 m
.02756 .54319 L
s
.02381 .5639 m
.02756 .5639 L
s
.02381 .60532 m
.02756 .60532 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 1 r
.5 Mabswid
.02381 .25324 m
.02857 .25963 L
.03333 .2678 L
.0381 .27617 L
.04286 .28456 L
.04762 .29291 L
.05238 .30124 L
.05714 .30953 L
.0619 .3178 L
.06667 .32603 L
.07143 .33423 L
.07619 .34241 L
.08095 .35055 L
.08571 .35866 L
.09048 .36675 L
.09524 .3748 L
.1 .38282 L
.10476 .39082 L
.10952 .39878 L
.11429 .40672 L
.11905 .41463 L
.12381 .4225 L
.12857 .43035 L
.13333 .43818 L
.1381 .44597 L
.14286 .45373 L
.14762 .46147 L
.15238 .46918 L
.15714 .47686 L
.1619 .48451 L
.16667 .49214 L
.17143 .49974 L
.17619 .50731 L
.18095 .51485 L
.18571 .52237 L
.19048 .52986 L
.19524 .53733 L
.2 .54476 L
.20476 .55217 L
.20952 .55956 L
.21429 .56692 L
.21905 .57425 L
.22381 .58155 L
.22857 .58883 L
.23333 .59609 L
.2381 .60332 L
.24286 .5997 L
.24762 .59307 L
.25238 .58604 L
.25714 .57898 L
Mistroke
.2619 .57195 L
.26667 .56494 L
.27143 .55795 L
.27619 .551 L
.28095 .54407 L
.28571 .53717 L
.29048 .53029 L
.29524 .52345 L
.3 .51663 L
.30476 .50983 L
.30952 .50306 L
.31429 .49632 L
.31905 .48961 L
.32381 .48292 L
.32857 .47626 L
.33333 .46962 L
.3381 .46301 L
.34286 .45642 L
.34762 .44986 L
.35238 .44333 L
.35714 .43682 L
.3619 .43034 L
.36667 .42388 L
.37143 .41744 L
.37619 .41103 L
.38095 .40465 L
.38571 .39829 L
.39048 .39195 L
.39524 .38564 L
.4 .37935 L
.40476 .37309 L
.40952 .36685 L
.41429 .36063 L
.41905 .35444 L
.42381 .34827 L
.42857 .34212 L
.43333 .336 L
.4381 .3299 L
.44286 .32382 L
.44762 .31777 L
.45238 .31174 L
.45714 .30573 L
.4619 .29974 L
.46667 .29378 L
.47143 .28784 L
.47619 .28192 L
.48095 .27603 L
.48571 .27015 L
.49048 .2643 L
.49524 .25847 L
Mistroke
.5 .25266 L
.50476 .24687 L
.50952 .24111 L
.51429 .23536 L
.51905 .22964 L
.52381 .22394 L
.52857 .21826 L
.53333 .2126 L
.5381 .20696 L
.54286 .20134 L
.54762 .19574 L
.55238 .18021 L
.55714 .16194 L
.5619 .14335 L
.56667 .12477 L
.57143 .10626 L
.57619 .08782 L
.58095 .06944 L
.58571 .05113 L
.59048 .03289 L
.59524 .01472 L
.6 .01818 L
.60476 .02769 L
.60952 .038 L
.61429 .04838 L
.61905 .05873 L
.62381 .06905 L
.62857 .07933 L
.63333 .08957 L
.6381 .09978 L
.64286 .10994 L
.64762 .12006 L
.65238 .13015 L
.65714 .14019 L
.6619 .1502 L
.66667 .16017 L
.67143 .17011 L
.67619 .18 L
.68095 .18986 L
.68571 .19968 L
.69048 .20947 L
.69524 .21202 L
.7 .21255 L
.70476 .2128 L
.70952 .21301 L
.71429 .21321 L
.71905 .21341 L
.72381 .21361 L
.72857 .2138 L
.73333 .214 L
Mistroke
.7381 .2142 L
.74286 .21439 L
.74762 .21459 L
.75238 .21478 L
.75714 .21497 L
.7619 .21516 L
.76667 .21535 L
.77143 .21554 L
.77619 .21573 L
.78095 .21592 L
.78571 .2161 L
.79048 .21629 L
.79524 .21647 L
.8 .21666 L
.80476 .21684 L
.80952 .21702 L
.81429 .2172 L
.81905 .21738 L
.82381 .21756 L
.82857 .21774 L
.83333 .21791 L
.8381 .21809 L
.84286 .21827 L
.84762 .21844 L
.85238 .21861 L
.85714 .21879 L
.8619 .21896 L
.86667 .21913 L
.87143 .2193 L
.87619 .21947 L
.88095 .21964 L
.88571 .21981 L
.89048 .21997 L
.89524 .22014 L
.9 .2203 L
.90476 .22047 L
.90952 .22063 L
.91429 .22079 L
.91905 .22096 L
.92381 .22112 L
.92857 .22128 L
.93333 .22144 L
.9381 .2216 L
.94286 .22175 L
.94762 .22191 L
.95238 .22207 L
.95714 .22222 L
.9619 .22238 L
.96667 .22253 L
.97143 .22269 L
Mistroke
.97619 .22284 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool000Qoo`8000Aoo`8000=oo`<00?moo`]oo`001goo00@007ooOol000Qoo`04001oogoo0004Ool0
0`00Oomoo`3oOol3Ool000Moo`04001oogoo0008Ool01000Oomoo`0017oo0P00ogoo17oo00000goo
000000020002Ool01000Oomoo`0027oo0`001Goo00<007ooOol0ogoo0goo0007Ool01000Oomoo`00
2Goo00<007ooOol017oo00<007ooOol0ogoo0goo0008Ool2000:Ool30004Ool00`00Oomoo`2;Ool0
0g`OOomoo`1dOol001]oo`03001oogoo08]oo`9l7gEoo`006goo00<007ooOol0Rgoo00=l7gooO1l0
M7oo000KOol2002;Ool01G`OOomoogooO1l0Lgoo000KOol00`00Oomoo`2:Ool01G`OOomoogooO1l0
Lgoo000KOol00`00Oomoo`2:Ool00g`OOomoo`02Ool00g`OOomoo`1`Ool001]oo`03001oogoo08Yo
o`03O1moogoo009oo`03O1moogoo071oo`006goo00<007ooOol0RGoo00=l7gooOol017oo00=l7goo
Ool0Kgoo000KOol2002:Ool00g`OOomoo`04Ool00g`OOomoo`1_Ool001]oo`03001oogoo08Uoo`03
O1moogoo00Aoo`03O1moogoo06moo`006goo00<007ooOol0RGoo00=l7gooOol01Goo00=l7gooOol0
KWoo000KOol00`00Oomoo`29Ool00g`OOomoo`05Ool00g`OOomoo`1^Ool001]oo`03001oogoo08Qo
o`03O1moogoo00Moo`03O1moogoo06eoo`006goo0P00RGoo00=l7gooOol01goo00=l7gooOol0KGoo
000KOol00`00Oomoo`28Ool00g`OOomoo`08Ool00g`OOomoo`1/Ool001]oo`03001oogoo08Qoo`03
O1moogoo00Qoo`03O1moogoo06aoo`0027oo0P0017oo0P001Goo0`000goo00<007ooOol0Qgoo00=l
7gooOol02Woo00=l7gooOol0Jgoo0007Ool01000Oomoo`002goo00<007ooOol00Woo00<007ooOol0
Qgoo00=l7gooOol02Woo00=l7gooOol0Jgoo0007Ool01000Oomoo`0027oo1@000goo0P00Qgoo00=l
7gooOol037oo00=l7gooOol0JWoo00000goo000000020002Ool01000Oomoo`0027oo00@007ooOol0
00Aoo`03001oogoo08Ioo`03O1moogoo00aoo`03O1moogoo06Yoo`001goo00@007ooOol000Uoo`03
001oo`0000Aoo`03001oogoo08Ioo`03O1moogoo00eoo`03O1moogoo06Uoo`0027oo0P002goo0P00
17oo00<007ooOol0QGoo00=l7gooOol03Woo00=l7gooOol0JGoo000KOol00`00Oomoo`25Ool00g`O
Oomoo`0>Ool00g`OOomoo`1YOol001]oo`8008Ioo`03O1moogoo00moo`03O1moogoo06Qoo`006goo
00<007ooOol0QGoo00=l7gooOol03goo00=l7gooOol0J7oo000KOol00`00Oomoo`25Ool00g`OOomo
o`0@Ool00g`OOomoo`1WOol001]oo`03001oogoo08Aoo`03O1moogoo015oo`03O1moogoo06Moo`00
6goo00<007ooOol0Q7oo00=l7gooOol04Woo00=l7gooOol0IWoo000KOol20025Ool00g`OOomoo`0B
Ool00g`OOomoo`1VOol001]oo`03001oogoo08Aoo`03O1moogoo01=oo`03O1moogoo06Eoo`006goo
00<007ooOol0Pgoo00=l7gooOol05Goo00=l7gooOol0I7oo000KOol00`00Oomoo`23Ool00g`OOomo
o`0EOol00g`OOomoo`1TOol001]oo`03001oogoo08=oo`03O1moogoo01Eoo`03O1moogoo06Aoo`00
6goo00<007ooOol0Pgoo00=l7gooOol05Woo00=l7gooOol0Hgoo000KOol20024Ool00g`OOomoo`0F
Ool00g`OOomoo`1SOol001]oo`03001oogoo089oo`03O1moogoo01Qoo`03O1moogoo069oo`006goo
00<007ooOol0PWoo00=l7gooOol067oo00=l7gooOol0HWoo0008Ool20004Ool20003Ool40004Ool0
0`00Oomoo`22Ool00g`OOomoo`0HOol00g`OOomoo`1ROol000Moo`04001oogoo0008Ool00`00Oomo
o`05Ool00`00Oomoo`22Ool00g`OOomoo`0IOol00g`OOomoo`1QOol000Moo`04001oogoo0009Ool0
0`00Oomoo`04Ool20023Ool00g`OOomoo`0IOol00g`OOomoo`1QOol00003Ool000000080009oo`04
001oogoo000:Ool00`00Oomoo`03Ool00`00Oomoo`21Ool00g`OOomoo`0KOol00g`OOomoo`1POol0
00Moo`04001oogoo0008Ool01000Oomoo`0017oo00<007ooOol0PGoo00=l7gooOol06goo00=l7goo
Ool0H7oo0008Ool2000:Ool20005Ool00`00Oomoo`21Ool00g`OOomoo`0LOol00g`OOomoo`1OOol0
01]oo`03001oogoo081oo`03O1moogoo01eoo`03O1moogoo05moo`006goo0P00PGoo00=l7gooOol0
7Woo00=l7gooOol0GWoo000KOol00`00Oomoo`1oOol00g`OOomoo`0POol00g`OOomoo`1MOol001]o
o`03001oogoo07ioo`03O1moogoo025oo`03O1moogoo05eoo`006goo00<007ooOol0OWoo00=l7goo
Ool08Woo00=l7gooOol0G7oo000KOol00`00Oomoo`0aOol20004Ool20004Ool2000bOol50007Ool0
0g`OOomoo`0SOol017`OOomoogoo1@000Woo0P0017oo0P00<Woo10005Woo000KOol2000aOol01000
Oomoo`0027oo00@007ooOol003=oo`03001oogoo00Ioo`03O1moogoo02Eoo`Ml7`Qoo`04001oogoo
000aOol00`00Oomoo`0GOol001]oo`03001oogoo031oo`04001oogoo000;Ool00`00Oomoo`0aOol0
0`00Oomoo`06Ool00g`OOomoo`0ZOol00`00Ooml7`0IO1lTOol00`00Oomoo`0FOol001]oo`03001o
ogoo031oo`04001oogoo0009Ool2000dOol00`00Oomoo`04Ool2O1l]Ool00`00Oomoo`08Ool2000?
OolLO1l9Ool00`00Oomoo`0EOol001]oo`03001oogoo031oo`04001oogoo0009Ool00`00Oomoo`0c
Ool00`00Oomoo`03Ool00g`OOomoo`0]Ool00`00Oomoo`08Ool00`00Oomoo`0ZOol:O1l00`00Oomo
o`0DOol001]oo`03001oogoo035oo`8000Yoo`<0039oo`8000Eoo`03O1moogoo02aoo`8000Yoo`<0
039oo`8001Moo`006goo0P00NGoo00=l7gooOol0Qgoo000KOol00`00Oomoo`1gOol00g`OOomoo`28
Ool001]oo`03001oogoo07Ioo`03O1moogoo08Uoo`006goo00<007ooOol0MWoo00=l7gooOol0RGoo
000KOol00`00Oomoo`1dOol2O1n5Ool20005Ool001Eoo`H00003O1l0000007<00003O1l0000007/0
00Uoo`04001oogoo0004Ool001]oo`03001l7goo00Uoo`03001oogoo00Qoo`03001oogoo00Uoo`03
001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03
001oogoo00Uoo`03001oogoo00Qoo`03O1moogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03
001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03
001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00eoo`03001oogoo00Eoo`006goo00<007`OOol0
>7oo00<007ooOol0=goo00=l7`00Ool0>Woo00<007ooOol0>7oo00<007ooOol037oo1@0017oo000K
Ool00`00Ooml7`1aOol00g`OOomoo`26Ool00`00Oomoo`05Ool001]oo`03001oog`O075oo`03O1mo
ogoo08ioo`006goo00@007ooOoml7fmoo`03O1moogoo08moo`006goo0P0000=oog`OOol0KGoo00=l
7gooOol0T7oo000KOol01@00OomoogooO1l0KGoo00=l7gooOol0T7oo000KOol01@00OomoogooO1l0
Jgoo0W`OTgoo000KOol00`00Oomoo`02Ool00g`OOomoo`1WOol00g`OOomoo`2COol001]oo`03001o
ogoo00=oo`03O1moogoo06Ioo`03O1moogoo09=oo`006goo0P001Goo00=l7gooOol0I7oo00=l7goo
Ool0U7oo000KOol00`00Oomoo`04Ool00g`OOomoo`1SOol00g`OOomoo`2EOol001]oo`03001oogoo
00Eoo`03O1moogoo069oo`03O1moogoo09Eoo`006goo00<007ooOol01Goo00=l7gooOol0HGoo00=l
7gooOol0UWoo000KOol00`00Oomoo`05Ool00g`OOomoo`1POol00g`OOomoo`2GOol001]oo`8000Mo
o`03O1moogoo05ioo`03O1moogoo09Qoo`006goo00<007ooOol01Woo00=l7gooOol0GGoo00=l7goo
Ool0VGoo000KOol00`00Oomoo`07Ool00g`OOomoo`1KOol00g`OOomoo`2JOol000Qoo`8000Aoo`80
00=oo`@000Aoo`03001oogoo00Moo`03O1moogoo05]oo`03O1moogoo09Yoo`001goo00@007ooOol0
00Qoo`03001oogoo00Eoo`03001oogoo00Qoo`03O1moogoo05Uoo`03O1moogoo09]oo`001goo00@0
07ooOol000Uoo`03001oogoo00Aoo`8000Yoo`03O1moogoo05Moo`03O1moogoo09aoo`001goo00@0
07ooOol000Yoo`03001oogoo00=oo`03001oogoo00Yoo`03O1moogoo05Ioo`03O1moogoo09aoo`00
1goo00@007ooOol000Qoo`04001oogoo0004Ool00`00Oomoo`0:Ool00g`OOomoo`1DOol2O1nOOol0
00Qoo`8000Yoo`8000Eoo`03001oogoo00]oo`03O1moogoo059oo`03O1moogoo09moo`006goo00<0
07ooOol02goo00=l7gooOol0DWoo00=l7gooOol0Wgoo000KOol2000=Ool00g`OOomoo`1@Ool00g`O
Oomoo`2POol001]oo`03001oogoo00aoo`03O1moogoo04moo`03O1moogoo0:5oo`006goo00<007oo
Ool03Goo00=l7gooOol0CWoo00=l7gooOol0XGoo000KOol00`00Oomoo`0=Ool00g`OOomoo`1=Ool0
0g`OOomoo`2ROol001]oo`03001oogoo00ioo`03O1moogoo04]oo`03O1moogoo0:=oo`006goo0P00
3goo00=l7gooOol0Bgoo00=l7gooOol0Xgoo000KOol00`00Oomoo`0?Ool00g`OOomoo`18Ool2O1nV
Ool001]oo`03001oogoo011oo`03O1moogoo04Ioo`03O1moogoo0:Ioo`006goo00<007ooOol04Goo
00=l7gooOol0AGoo00=l7gooOol0YWoo000KOol00`00Oomoo`0AOol00g`OOomoo`14Ool00g`OOomo
o`2WOol001]oo`03001oogoo019oo`03O1moogoo04=oo`03O1moogoo0:Moo`006goo0P004goo00=l
7gooOol0@Woo00=l7gooOol0Z7oo000KOol00`00Oomoo`0COol00g`OOomoo`10Ool00g`OOomoo`2Y
Ool001]oo`03001oogoo01=oo`03O1moogoo041oo`03O1moogoo0:Uoo`0027oo0P0017oo0P001Goo
0`000goo00<007ooOol057oo00=l7gooOol0?Goo0W`O[7oo0007Ool01000Oomoo`002goo00<007oo
Ool00Woo00<007ooOol057oo00=l7gooOol0?7oo00=l7gooOol0[7oo0007Ool01000Oomoo`0027oo
1@000goo0P005Woo00=l7gooOol0>goo00=l7gooOol0[7oo0007Ool01000Oomoo`0027oo00@007oo
Ool000Aoo`03001oogoo01Ioo`03O1moogoo03Uoo`03O1moogoo0:eoo`001goo00@007ooOol000Uo
o`03001oo`0000Aoo`03001oogoo01Moo`03O1moogoo03Qoo`03O1moogoo0:eoo`0027oo0P002goo
0P0017oo00<007ooOol05goo00=l7gooOol0=goo00=l7gooOol0[Woo000KOol00`00Oomoo`0HOol0
0g`OOomoo`0eOol00g`OOomoo`2_Ool001]oo`8001Uoo`03O1moogoo03Eoo`03O1moogoo0:moo`00
6goo00<007ooOol06Goo00=l7gooOol0<Woo0W`O/Woo000KOol00`00Oomoo`0IOol00g`OOomoo`0a
Ool00g`OOomoo`2bOol001]oo`03001oogoo01Yoo`03O1moogoo031oo`03O1moogoo0;9oo`006goo
00<007ooOol06goo00=l7gooOol0;Woo00=l7gooOol0/goo000KOol2000MOol00g`OOomoo`0]Ool0
0g`OOomoo`2cOol001]oo`03001oogoo01eoo`03O1moogoo02]oo`03O1moogoo0;Aoo`006goo00<0
07ooOol07Goo00=l7gooOol0:Woo00=l7gooOol0]Goo000KOol00`00Oomoo`0NOol00g`OOomoo`0Y
Ool00g`OOomoo`2eOol001]oo`03001oogoo01ioo`03O1moogoo02Qoo`03O1moogoo0;Ioo`006goo
0P0087oo00=l7gooOol09Woo00=l7gooOol0]goo000KOol00`00Oomoo`0OOol00g`OOomoo`0UOol0
0g`OOomoo`2hOol001]oo`03001oogoo021oo`03O1moogoo02=oo`03O1moogoo0;Uoo`0027oo0P00
17oo0P000goo0`001Goo00<007ooOol087oo00=l7gooOol08goo00=l7gooOol0^Goo0007Ool01000
Oomoo`0027oo00@007ooOol000Aoo`03001oogoo025oo`03O1moogoo025oo`03O1moogoo0;Yoo`00
1goo00@007ooOol000Qoo`04001oogoo0004Ool2000ROol00g`OOomoo`0QOol00g`OOomoo`2jOol0
00Moo`04001oogoo0008Ool30005Ool00`00Oomoo`0ROol00g`OOomoo`0OOol00g`OOomoo`2kOol0
00Moo`04001oogoo0009Ool00`00Oomoo`04Ool00`00Oomoo`0SOol00g`OOomoo`0MOol00g`OOomo
o`2lOol000Qoo`8000Yoo`<000Aoo`03001oogoo02Aoo`03O1moogoo01aoo`03O1moogoo0;aoo`00
6goo00<007ooOol097oo00=l7gooOol06goo00=l7gooOol0_Goo000KOol00`00Oomoo`0UOol00g`O
Oomoo`0IOol00g`OOomoo`2nOol001]oo`8002Ioo`03O1moogoo01Qoo`03O1moogoo0;moo`006goo
00<007ooOol09Woo00=l7gooOol05goo00=l7gooOol0_goo000KOol00`00Oomoo`0WOol00g`OOomo
o`0EOol00g`OOomoo`30Ool001]oo`03001oogoo02Moo`03O1moogoo01Aoo`03O1moogoo0<5oo`00
6goo00<007ooOol0:7oo00=l7gooOol04goo00=l7gooOol0`Goo000KOol2000ZOol00g`OOomoo`0A
Ool00g`OOomoo`32Ool001]oo`03001oogoo02Yoo`03O1moogoo011oo`03O1moogoo0<9oo`006goo
00<007ooOol0:Woo00=l7gooOol03Woo0W`OaGoo000KOol00`00Oomoo`0[Ool00g`OOomoo`0<Ool0
0g`OOomoo`35Ool001]oo`03001oogoo02]oo`03O1moogoo00aoo`03O1moogoo0<Eoo`006goo0P00
;Goo00=l7gooOol02Woo00=l7gooOol0aWoo000KOol00`00Oomoo`0/Ool00g`OOomoo`0:Ool00g`O
Oomoo`36Ool001]oo`03001oogoo02eoo`03O1moogoo00Qoo`03O1moogoo0<Moo`0027oo0P0017oo
0P0017oo0P001Goo00<007ooOol0;Goo0W`O2Goo00=l7gooOol0agoo0007Ool01000Oomoo`0027oo
00@007ooOol000Aoo`03001oogoo02moo`03O1moogoo00Eoo`03O1moogoo0<Qoo`001goo00@007oo
Ool000Qoo`04001oogoo0004Ool2000aOol00g`OOomoo`03Ool00g`OOomoo`39Ool000Moo`04001o
ogoo0009Ool20005Ool00`00Oomoo`0`Ool00g`OOomoo`02Ool00g`OOomoo`3:Ool000Moo`04001o
ogoo0008Ool01000Oomoo`0017oo00<007ooOol0<Goo00Al7gooOoml7leoo`0027oo0P002Woo0P00
1Goo00<007ooOol0<Goo00Al7gooOoml7leoo`006goo00<007ooOol0<Woo0W`OcWoo000KOol2000c
Ool00g`OOomoo`3=Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol0
0`00Oomoo`3oOol3Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`006Woo0P00ogoo1Goo000JOol2003oOol5
Ool001Uoo`04001oogoo003oOol4Ool001Qoo`80009oo`800?moo`=oo`00ogoo8Goo003oOolQOol0
0?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.228198, -0.646552, \
0.00841412, 0.00967304}}],

Cell[BoxData[
    InterpretationBox[\("M\[AAcute]xima Velocidad: \
"\[InvisibleSpace]0.8451632970752215`\),
      SequenceForm[ "M\[AAcute]xima Velocidad: ", .84516329707522153],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[IAcute]nima Velocidad: \
"\[InvisibleSpace]\(-0.5758460490900473`\)\),
      SequenceForm[ "M\[IAcute]nima Velocidad: ", -.57584604909004733],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Aceleraciones:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.323111 0.00357399 [
[.2619 .31061 -9 -9 ]
[.2619 .31061 9 0 ]
[.5 .31061 -3 -9 ]
[.5 .31061 3 0 ]
[.7381 .31061 -9 -9 ]
[.7381 .31061 9 0 ]
[.97619 .31061 -3 -9 ]
[.97619 .31061 3 0 ]
[1.025 .32311 0 -6.25 ]
[1.025 .32311 10 6.25 ]
[.01131 .05506 -18 -4.5 ]
[.01131 .05506 0 4.5 ]
[.01131 .14441 -18 -4.5 ]
[.01131 .14441 0 4.5 ]
[.01131 .23376 -18 -4.5 ]
[.01131 .23376 0 4.5 ]
[.01131 .41246 -12 -4.5 ]
[.01131 .41246 0 4.5 ]
[.01131 .50181 -12 -4.5 ]
[.01131 .50181 0 4.5 ]
[.01131 .59116 -12 -4.5 ]
[.01131 .59116 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .32311 m
.2619 .32936 L
s
[(0.5)] .2619 .31061 0 1 Mshowa
.5 .32311 m
.5 .32936 L
s
[(1)] .5 .31061 0 1 Mshowa
.7381 .32311 m
.7381 .32936 L
s
[(1.5)] .7381 .31061 0 1 Mshowa
.97619 .32311 m
.97619 .32936 L
s
[(2)] .97619 .31061 0 1 Mshowa
.125 Mabswid
.07143 .32311 m
.07143 .32686 L
s
.11905 .32311 m
.11905 .32686 L
s
.16667 .32311 m
.16667 .32686 L
s
.21429 .32311 m
.21429 .32686 L
s
.30952 .32311 m
.30952 .32686 L
s
.35714 .32311 m
.35714 .32686 L
s
.40476 .32311 m
.40476 .32686 L
s
.45238 .32311 m
.45238 .32686 L
s
.54762 .32311 m
.54762 .32686 L
s
.59524 .32311 m
.59524 .32686 L
s
.64286 .32311 m
.64286 .32686 L
s
.69048 .32311 m
.69048 .32686 L
s
.78571 .32311 m
.78571 .32686 L
s
.83333 .32311 m
.83333 .32686 L
s
.88095 .32311 m
.88095 .32686 L
s
.92857 .32311 m
.92857 .32686 L
s
.25 Mabswid
0 .32311 m
1 .32311 L
s
gsave
1.025 .32311 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .05506 m
.03006 .05506 L
s
[(-75)] .01131 .05506 1 0 Mshowa
.02381 .14441 m
.03006 .14441 L
s
[(-50)] .01131 .14441 1 0 Mshowa
.02381 .23376 m
.03006 .23376 L
s
[(-25)] .01131 .23376 1 0 Mshowa
.02381 .41246 m
.03006 .41246 L
s
[(25)] .01131 .41246 1 0 Mshowa
.02381 .50181 m
.03006 .50181 L
s
[(50)] .01131 .50181 1 0 Mshowa
.02381 .59116 m
.03006 .59116 L
s
[(75)] .01131 .59116 1 0 Mshowa
.125 Mabswid
.02381 .07293 m
.02756 .07293 L
s
.02381 .0908 m
.02756 .0908 L
s
.02381 .10867 m
.02756 .10867 L
s
.02381 .12654 m
.02756 .12654 L
s
.02381 .16228 m
.02756 .16228 L
s
.02381 .18015 m
.02756 .18015 L
s
.02381 .19802 m
.02756 .19802 L
s
.02381 .21589 m
.02756 .21589 L
s
.02381 .25163 m
.02756 .25163 L
s
.02381 .2695 m
.02756 .2695 L
s
.02381 .28737 m
.02756 .28737 L
s
.02381 .30524 m
.02756 .30524 L
s
.02381 .34098 m
.02756 .34098 L
s
.02381 .35885 m
.02756 .35885 L
s
.02381 .37672 m
.02756 .37672 L
s
.02381 .39459 m
.02756 .39459 L
s
.02381 .43033 m
.02756 .43033 L
s
.02381 .4482 m
.02756 .4482 L
s
.02381 .46607 m
.02756 .46607 L
s
.02381 .48394 m
.02756 .48394 L
s
.02381 .51968 m
.02756 .51968 L
s
.02381 .53755 m
.02756 .53755 L
s
.02381 .55542 m
.02756 .55542 L
s
.02381 .57329 m
.02756 .57329 L
s
.02381 .03719 m
.02756 .03719 L
s
.02381 .01932 m
.02756 .01932 L
s
.02381 .00145 m
.02756 .00145 L
s
.02381 .60903 m
.02756 .60903 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .32311 m
.02857 .33096 L
.03333 .33872 L
.0381 .34641 L
.04286 .35401 L
.04762 .36154 L
.05238 .36899 L
.05714 .37636 L
.0619 .38366 L
.06667 .39088 L
.07143 .39802 L
.07619 .40509 L
.08095 .41209 L
.08571 .41901 L
.09048 .42586 L
.09524 .43263 L
.1 .43933 L
.10476 .44595 L
.10952 .45251 L
.11429 .45899 L
.11905 .4654 L
.12381 .47174 L
.12857 .47801 L
.13333 .4842 L
.1381 .49033 L
.14286 .49639 L
.14762 .50237 L
.15238 .50829 L
.15714 .51414 L
.1619 .51992 L
.16667 .52563 L
.17143 .53127 L
.17619 .53685 L
.18095 .54235 L
.18571 .5478 L
.19048 .55317 L
.19524 .55848 L
.2 .56372 L
.20476 .5689 L
.20952 .57401 L
.21429 .57905 L
.21905 .58403 L
.22381 .58895 L
.22857 .5938 L
.23333 .59859 L
.2381 .60332 L
.24286 .5947 L
.24762 .58616 L
.25238 .5777 L
.25714 .5693 L
Mistroke
.2619 .56098 L
.26667 .55272 L
.27143 .54454 L
.27619 .53642 L
.28095 .52837 L
.28571 .52038 L
.29048 .51247 L
.29524 .50462 L
.3 .49684 L
.30476 .48912 L
.30952 .48147 L
.31429 .47389 L
.31905 .46637 L
.32381 .45891 L
.32857 .45152 L
.33333 .44419 L
.3381 .43693 L
.34286 .42973 L
.34762 .4226 L
.35238 .41553 L
.35714 .40852 L
.3619 .40157 L
.36667 .39468 L
.37143 .38786 L
.37619 .3811 L
.38095 .3744 L
.38571 .36776 L
.39048 .36118 L
.39524 .35466 L
.4 .3482 L
.40476 .3418 L
.40952 .33546 L
.41429 .32917 L
.41905 .32295 L
.42381 .31679 L
.42857 .31068 L
.43333 .30463 L
.4381 .29864 L
.44286 .29271 L
.44762 .28683 L
.45238 .28101 L
.45714 .27525 L
.4619 .26954 L
.46667 .26389 L
.47143 .25829 L
.47619 .25275 L
.48095 .24726 L
.48571 .24183 L
.49048 .23645 L
.49524 .23113 L
Mistroke
.5 .22586 L
.50476 .22065 L
.50952 .21548 L
.51429 .21038 L
.51905 .20532 L
.52381 .20032 L
.52857 .19537 L
.53333 .19047 L
.5381 .18562 L
.54286 .18082 L
.54762 .17608 L
.55238 .15916 L
.55714 .14243 L
.5619 .12587 L
.56667 .10948 L
.57143 .09326 L
.57619 .07722 L
.58095 .06134 L
.58571 .04563 L
.59048 .03009 L
.59524 .01472 L
.6 .026 L
.60476 .03715 L
.60952 .0482 L
.61429 .05915 L
.61905 .06999 L
.62381 .08074 L
.62857 .09139 L
.63333 .10195 L
.6381 .1124 L
.64286 .12276 L
.64762 .13303 L
.65238 .14319 L
.65714 .15326 L
.6619 .16324 L
.66667 .17313 L
.67143 .18292 L
.67619 .19261 L
.68095 .20222 L
.68571 .21173 L
.69048 .22115 L
.69524 .22164 L
.7 .22215 L
.70476 .22265 L
.70952 .22315 L
.71429 .22365 L
.71905 .22415 L
.72381 .22464 L
.72857 .22513 L
.73333 .22562 L
Mistroke
.7381 .22611 L
.74286 .22659 L
.74762 .22707 L
.75238 .22755 L
.75714 .22803 L
.7619 .2285 L
.76667 .22898 L
.77143 .22945 L
.77619 .22991 L
.78095 .23038 L
.78571 .23084 L
.79048 .2313 L
.79524 .23176 L
.8 .23222 L
.80476 .23267 L
.80952 .23312 L
.81429 .23357 L
.81905 .23402 L
.82381 .23446 L
.82857 .2349 L
.83333 .23534 L
.8381 .23578 L
.84286 .23622 L
.84762 .23665 L
.85238 .23708 L
.85714 .23751 L
.8619 .23794 L
.86667 .23836 L
.87143 .23879 L
.87619 .23921 L
.88095 .23963 L
.88571 .24004 L
.89048 .24046 L
.89524 .24087 L
.9 .24128 L
.90476 .24169 L
.90952 .2421 L
.91429 .2425 L
.91905 .2429 L
.92381 .2433 L
.92857 .2437 L
.93333 .2441 L
.9381 .24449 L
.94286 .24488 L
.94762 .24527 L
.95238 .24566 L
.95714 .24605 L
.9619 .24643 L
.96667 .24682 L
.97143 .2472 L
Mistroke
.97619 .24758 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00O5Goo0P00ogoo2Woo
000EOol00`00Oomoo`3oOol9Ool001Eoo`03001oogoo0?moo`Uoo`005Goo00<007ooOol0Sgoo00<0
7gooOol0MWoo000EOol00`00Oomoo`2?Ool00`0OOomoo`1fOol001Eoo`8008moo`0301moo`0O07Mo
o`005Goo00<007ooOol0SWoo00<07goo01l0Mgoo000EOol00`00Oomoo`2=Ool0100OOomoo`0OMgoo
000EOol00`00Oomoo`2=Ool01@0OOomoogoo01l0MWoo000EOol2002>Ool01@0OOomoogoo01l0MWoo
000EOol00`00Oomoo`2<Ool00`0OOomoo`02Ool00`0OOomoo`1dOol001Eoo`03001oogoo08aoo`03
01moogoo00=oo`0301moogoo07=oo`002Goo00<007ooOol00Woo0P001Goo00<007ooOol0S7oo00<0
7gooOol00goo00<07gooOol0Lgoo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007oo
Ool0S7oo00<07gooOol017oo00<07gooOol0LWoo0009Ool00`00Oomoo`04Ool00`00Oomoo`02Ool2
002<Ool00`0OOomoo`05Ool00`0OOomoo`1bOol00003Ool00000008000Eoo`04001oogooOol20005
Ool00`00Oomoo`2;Ool00`0OOomoo`06Ool00`0OOomoo`1aOol000Moo`04001oogoo0003Ool00`00
Oomoo`04Ool00`00Oomoo`2;Ool00`0OOomoo`06Ool00`0OOomoo`1aOol000Moo`@000=oo`<000Ao
o`03001oogoo08]oo`0301moogoo00Moo`0301moogoo071oo`005Goo0P00Rgoo00<07gooOol027oo
00<07gooOol0L7oo000EOol00`00Oomoo`2:Ool00`0OOomoo`09Ool00`0OOomoo`1_Ool001Eoo`03
001oogoo08Yoo`0301moogoo00Uoo`0301moogoo06moo`005Goo00<007ooOol0RWoo00<07gooOol0
2Goo00<07gooOol0Kgoo000EOol00`00Oomoo`29Ool00`0OOomoo`0;Ool00`0OOomoo`1^Ool001Eo
o`8008Yoo`0301moogoo00]oo`0301moogoo06ioo`005Goo00<007ooOol0RGoo00<07gooOol02goo
00<07gooOol0KWoo000EOol00`00Oomoo`28Ool00`0OOomoo`0=Ool00`0OOomoo`1]Ool001Eoo`03
001oogoo08Qoo`0301moogoo00eoo`0301moogoo06eoo`005Goo0P00R7oo00<07gooOol03goo00<0
7gooOol0K7oo000EOol00`00Oomoo`27Ool00`0OOomoo`0@Ool00`0OOomoo`1[Ool001Eoo`03001o
ogoo08Moo`0301moogoo011oo`0301moogoo06]oo`005Goo00<007ooOol0Qgoo00<07gooOol04Goo
00<07gooOol0JWoo000EOol00`00Oomoo`26Ool00`0OOomoo`0BOol00`0OOomoo`1ZOol001Eoo`80
08Moo`0301moogoo019oo`0301moogoo06Yoo`005Goo00<007ooOol0QWoo00<07gooOol04goo00<0
7gooOol0JGoo000EOol00`00Oomoo`26Ool00`0OOomoo`0COol00`0OOomoo`1YOol000Qoo`8000Ao
o`8000Eoo`03001oogoo08Eoo`0301moogoo01Eoo`0301moogoo06Qoo`001goo00@007ooOol0009o
o`04001oogoo0004Ool00`00Oomoo`25Ool00`0OOomoo`0EOol00`0OOomoo`1XOol000Yoo`04001o
ogoo0002Ool00`00Oomoo`02Ool20026Ool00`0OOomoo`0FOol00`0OOomoo`1WOol00003Ool00000
008000=oo`8000=oo`04001oogoo0004Ool00`00Oomoo`25Ool00`0OOomoo`0FOol00`0OOomoo`1W
Ool000Qoo`03001oogoo009oo`04001oogoo0004Ool00`00Oomoo`24Ool00`0OOomoo`0HOol00`0O
Oomoo`1VOol000Qoo`<000=oo`8000Eoo`03001oogoo08Aoo`0301moogoo01Uoo`0301moogoo06Eo
o`005Goo0P00QGoo00<07gooOol06Goo00<07gooOol0IGoo000EOol00`00Oomoo`24Ool00`0OOomo
o`0IOol00`0OOomoo`1UOol001Eoo`03001oogoo08=oo`0301moogoo01]oo`0301moogoo06Aoo`00
5Goo00<007ooOol0Pgoo00<07gooOol06goo00<07gooOol0I7oo000EOol00`00Oomoo`22Ool201lN
Ool00`0OOomoo`1SOol001Eoo`80089oo`0301moogoo01ioo`0301moogoo06=oo`005Goo00<007oo
Ool0P7oo00<07gooOol07goo00<07gooOol0Hgoo000EOol00`00Oomoo`1oOol00`0OOomoo`0QOol0
0`0OOomoo`1ROol001Eoo`03001oogoo07moo`0301moogoo025oo`0301moogoo069oo`005Goo0P00
OWoo0P0O9Goo00<07gooOol0HGoo000EOol00`00Oomoo`1lOol00`0OOomoo`0VOol00`0OOomoo`1P
Ool001Eoo`03001oogoo07]oo`0301moogoo02Moo`0301moogoo061oo`005Goo00<007ooOol0NWoo
00<07gooOol0:Goo00<07gooOol0Ggoo000EOol00`00Oomoo`1jOol00`0OOomoo`0YOol00`0OOomo
o`1OOol001Eoo`8007Yoo`0301moogoo02]oo`0301moogoo05ioo`005Goo00<007ooOol0Mgoo0P0O
;Woo100OGGoo0007Ool40003Ool20005Ool00`00Oomoo`1fOol00`0OOomoo`0bOol901mDOol000Mo
o`03001oogoo00=oo`04001oogoo0004Ool00`00Oomoo`1fOol00`0OOomoo`0kOol;01m9Ool000Qo
o`03001oogoo00Eoo`03001oogoo009oo`8007Ioo`0301moogoo04Moo`X07cmoo`0000=oo`000000
0P0017oo00<007ooOol00Woo0P001Goo00<007ooOol0M7oo00<07gooOol0DWoo2`0O=7oo0007Ool0
1000Oomoo`000goo00<007ooOol017oo00<007ooOol0Lgoo00<07gooOol0GWoo300O:7oo0008Ool2
0004Ool30004Ool00`00Oomoo`1bOol00`0OOomoo`1[Ool<01lLOol001Eoo`03001oogoo075oo`03
01moogoo07Qoo`D07aMoo`005Goo0P00LGoo00<07gooOol0UGoo000EOol00`00Oomoo`1`Ool00`0O
Oomoo`2EOol001Eoo`03001oogoo06moo`0301moogoo09Ioo`005Goo00<007ooOol0KWoo00<07goo
Ool0Ugoo000EOol2001^Ool00`0OOomoo`2HOol001Eoo`03001oogoo06aoo`0301moogoo09Uoo`00
5Goo00<007ooOol0Jgoo00<07gooOol0VWoo000EOol00`00Oomoo`0cOol20004Ool20004Ool2000Y
Ool00`0OOomoo`07Ool5000bOol50002Ool20004Ool2000dOol4000FOol001Eoo`03001oogoo039o
o`04001oogoo0008Ool01000Oomoo`00:7oo00<07gooOol02Goo00<007ooOol0=7oo00<007ooOol0
1goo00@007ooOol003=oo`03001oogoo01Moo`005Goo0P00<goo00@007ooOol000]oo`03001oogoo
02Eoo`0301moogoo00Yoo`03001oogoo03Aoo`03001oogoo00Yoo`03001oogoo039oo`03001oogoo
01Ioo`005Goo00<007ooOol0<Woo00@007ooOol000Uoo`8002Moo`0301moogoo00]oo`03001oogoo
03Aoo`03001oogoo00Qoo`8003Ioo`03001oogoo01Eoo`005Goo00<007ooOol0<Woo00@007ooOol0
00Uoo`03001oogoo02Ioo`0301moogoo00]oo`03001oogoo03Aoo`03001oogoo00Qoo`03001oogoo
03=oo`04001oogoo000FOol001Eoo`03001oogoo03=oo`8000Yoo`<002Aoo`807`eoo`8003Eoo`80
00Yoo`<003Aoo`8001Moo`005Goo00<007ooOol0IGoo00<07gooOol0X7oo000EOol2001VOol00`0O
Oomoo`2POol001Eoo`03001oogoo06Aoo`0301moogoo0:5oo`005Goo00<007ooOol0I7oo00<07goo
Ool0XGoo000EOol00`00Oomoo`1SOol00`0OOomoo`2KOol20005Ool000moo`H0000301l000000680
000301l00000098000Uoo`04001oogoo0004Ool001Eoo`0300007goo00Uoo`03001oogoo00Uoo`03
001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Uoo`03
001oogoo00Uoo`04001oogoo01l8Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool0
0`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool0
0`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`0=Ool00`00Oomoo`05Ool0
01Eoo`0300007goo03Yoo`03001oogoo02=oo`0301moogoo01=oo`03001oogoo03Yoo`03001oogoo
03Yoo`03001oogoo00aoo`D000Aoo`005Goo00<007oo01l0Ggoo00<07gooOol0WWoo00<007ooOol0
1Goo000EOol00`00Ool07`1OOol00`0OOomoo`2VOol001Eoo`800003Ool07goo05aoo`0301moogoo
0:Moo`005Goo00@007ooOol07eeoo`0301moogoo0:Moo`005Goo00D007ooOomoo`0O05]oo`0301mo
ogoo0:Qoo`005Goo00<007ooOol00Woo00<07gooOol0Egoo00<07gooOol0ZGoo000EOol20004Ool0
0`0OOomoo`1EOol00`0OOomoo`2ZOol001Eoo`03001oogoo00=oo`0301moogoo05Aoo`0301moogoo
0:]oo`005Goo00<007ooOol017oo00<07gooOol0Dgoo00<07gooOol0Zgoo000EOol00`00Oomoo`04
Ool00`0OOomoo`1BOol00`0OOomoo`2/Ool001Eoo`03001oogoo00Eoo`0301moogoo051oo`0301mo
ogoo0:eoo`005Goo0P001Woo00<07gooOol0D7oo00<07gooOol0[Goo000EOol00`00Oomoo`06Ool0
0`0OOomoo`1>Ool00`0OOomoo`2^Ool001Eoo`03001oogoo00Ioo`0301moogoo04ioo`0301moogoo
0:ioo`005Goo00<007ooOol01goo00<07gooOol0Bgoo0P0O/Goo000EOol20009Ool00`0OOomoo`19
Ool00`0OOomoo`2aOol001Eoo`03001oogoo00Uoo`0301moogoo04Qoo`0301moogoo0;5oo`005Goo
00<007ooOol02Woo00<07gooOol0AWoo00<07gooOol0/Woo0007Ool40003Ool20005Ool00`00Oomo
o`0:Ool00`0OOomoo`16Ool00`0OOomoo`2bOol000Moo`03001oogoo00=oo`04001oogoo0004Ool0
0`00Oomoo`0;Ool00`0OOomoo`14Ool00`0OOomoo`2cOol000Qoo`03001oogoo00Eoo`03001oogoo
009oo`8000aoo`0301moogoo04Aoo`0301moogoo0;=oo`002Goo00<007ooOol00Woo0P001Goo00<0
07ooOol037oo00<07gooOol0@Woo00<07gooOol0]7oo0007Ool01000Oomoo`000goo00<007ooOol0
17oo00<007ooOol03Goo00<07gooOol0@7oo00<07gooOol0]Goo0008Ool20004Ool30004Ool00`00
Oomoo`0>Ool00`0OOomoo`0nOol00`0OOomoo`2fOol001Eoo`03001oogoo00moo`0301moogoo03ao
o`0301moogoo0;Moo`005Goo0P0047oo00<07gooOol0?7oo00<07gooOol0]goo000EOol00`00Oomo
o`0@Ool00`0OOomoo`0jOol00`0OOomoo`2hOol001Eoo`03001oogoo011oo`0301moogoo03Yoo`03
01moogoo0;Qoo`005Goo00<007ooOol04Goo00<07gooOol0>7oo00<07gooOol0^Goo000EOol2000B
Ool201liOol00`0OOomoo`2iOol001Eoo`03001oogoo01=oo`0301moogoo03Eoo`0301moogoo0;Yo
o`005Goo00<007ooOol057oo00<07gooOol0<goo00<07gooOol0^goo000EOol00`00Oomoo`0DOol0
0`0OOomoo`0bOol00`0OOomoo`2lOol001Eoo`03001oogoo01Eoo`0301moogoo035oo`0301moogoo
0;aoo`005Goo0P005Woo00<07gooOol0<7oo00<07gooOol0_Goo000EOol00`00Oomoo`0FOol00`0O
Oomoo`0_Ool00`0OOomoo`2mOol001Eoo`03001oogoo01Moo`0301moogoo02eoo`0301moogoo0;io
o`005Goo00<007ooOol05goo0P0O;Woo00<07gooOol0_Woo000EOol2000JOol00`0OOomoo`0ZOol0
0`0OOomoo`2oOol001Eoo`03001oogoo01Yoo`0301moogoo02Qoo`0301moogoo0<1oo`005Goo00<0
07ooOol06Woo00<07gooOol09goo00<07gooOol0`Goo0008Ool20004Ool20005Ool00`00Oomoo`0K
Ool00`0OOomoo`0VOol00`0OOomoo`31Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo00<0
07ooOol077oo00<07gooOol097oo00<07gooOol0`Woo000:Ool01000Oomoo`000Woo00<007ooOol0
0Woo0P007Goo00<07gooOol097oo00<07gooOol0`Woo0008Ool20003Ool01000Oomoo`0017oo00<0
07ooOol07Goo00<07gooOol08Woo00<07gooOol0`goo0008Ool00`00Oomoo`02Ool01000Oomoo`00
17oo00<007ooOol07Woo00<07gooOol08Goo00<07gooOol0`goo0008Ool30003Ool20005Ool00`00
Oomoo`0OOol00`0OOomoo`0OOol00`0OOomoo`34Ool001Eoo`80025oo`0301moogoo01ioo`0301mo
ogoo0<Aoo`005Goo00<007ooOol08Goo00<07gooOol077oo00<07gooOol0aGoo000EOol00`00Oomo
o`0QOol00`0OOomoo`0KOol00`0OOomoo`36Ool001Eoo`03001oogoo029oo`0301moogoo01Uoo`03
01moogoo0<Moo`005Goo00<007ooOol08goo00<07gooOol067oo00<07gooOol0agoo000EOol2000U
Ool00`0OOomoo`0FOol00`0OOomoo`38Ool001Eoo`03001oogoo02Eoo`0301moogoo01Eoo`0301mo
ogoo0<Qoo`005Goo00<007ooOol09Woo00<07gooOol04goo00<07gooOol0bGoo000EOol00`00Oomo
o`0VOol00`0OOomoo`0COol00`0OOomoo`39Ool001Eoo`03001oogoo02Moo`0301moogoo015oo`03
01moogoo0<Yoo`005Goo0P00:Goo00<07gooOol047oo00<07gooOol0bWoo000EOol00`00Oomoo`0Y
Ool00`0OOomoo`0>Ool00`0OOomoo`3;Ool001Eoo`03001oogoo02Yoo`0301moogoo00aoo`0301mo
ogoo0<aoo`005Goo00<007ooOol0:goo00<07gooOol02Woo00<07gooOol0cGoo000EOol2000]Ool0
0`0OOomoo`09Ool00`0OOomoo`3=Ool001Eoo`03001oogoo02eoo`0301moogoo00Moo`0301moogoo
0<ioo`005Goo00<007ooOol0;Goo0P0O27oo00<07gooOol0cWoo0009Ool00`00Oomoo`02Ool20005
Ool00`00Oomoo`0_Ool00`0OOomoo`04Ool00`0OOomoo`3?Ool000Uoo`05001oogooOol00002Ool0
0`00Oomoo`02Ool00`00Oomoo`0`Ool00`0OOomoo`03Ool00`0OOomoo`3?Ool000Uoo`03001oogoo
00Aoo`03001oogoo009oo`80039oo`0501moogooOol07`3BOol000Yoo`04001oogooOol20005Ool0
0`00Oomoo`0bOol0100OOomoo`0OdWoo0007Ool01000Oomoo`000goo00<007ooOol017oo00<007oo
Ool0<Woo00<07goo01l0dgoo0007Ool40003Ool30004Ool00`00Oomoo`0cOol00`0OOomoo`3BOol0
01Eoo`800?moo`Yoo`005Goo00<007ooOol0ogoo2Goo000EOol00`00Oomoo`3oOol9Ool001Eoo`03
001oogoo0?moo`Uoo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo000COol5003oOol9Ool001=oo`@00?moo`Yo
o`005Woo00<007ooOol0ogoo27oo000DOol3003oOol:Ool00?moob5oo`00ogoo8Goo003oOolQOol0
0?moob5oo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.174205, -90.4849, \
0.0082192, 1.09511}}],

Cell[BoxData[
    InterpretationBox[\("M\[AAcute]xima Aceleraci\[OAcute]n: "\
\[InvisibleSpace]78.40177015674429`\),
      SequenceForm[ 
      "M\[AAcute]xima Aceleraci\[OAcute]n: ", 78.401770156744291],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[IAcute]nima Aceleraci\[OAcute]n: "\
\[InvisibleSpace]\(-86.28901242076132`\)\),
      SequenceForm[ 
      "M\[IAcute]nima Aceleraci\[OAcute]n: ", -86.289012420761324],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("t"\[InvisibleSpace]"         "\[InvisibleSpace]"p    \
    "\[InvisibleSpace]"     u"\[InvisibleSpace]"          \
v"\[InvisibleSpace]"         a"\),
      SequenceForm[ 
      "t", "         ", "p        ", "     u", "          v", "         a"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("---------------------------------------------------"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        InterpretationBox[GridBox[{
              {"0"},
              {"0.01`"},
              {"0.02`"},
              {"0.03`"},
              {"0.04`"},
              {"0.05`"},
              {"0.06`"},
              {"0.07`"},
              {"0.08`"},
              {"0.09`"},
              {"0.1`"},
              {"0.11`"},
              {"0.12`"},
              {"0.13`"},
              {"0.14`"},
              {"0.15`"},
              {"0.16`"},
              {"0.17`"},
              {"0.18`"},
              {"0.19`"},
              {"0.2`"},
              {"0.21`"},
              {"0.22`"},
              {"0.23`"},
              {"0.24`"},
              {"0.25`"},
              {"0.26`"},
              {"0.27`"},
              {"0.28`"},
              {"0.29`"},
              {"0.3`"},
              {"0.31`"},
              {"0.32`"},
              {"0.33`"},
              {"0.34`"},
              {"0.35000000000000003`"},
              {"0.36`"},
              {"0.37`"},
              {"0.38`"},
              {"0.39`"},
              {"0.4`"},
              {"0.41000000000000003`"},
              {"0.42`"},
              {"0.43`"},
              {"0.44`"},
              {"0.45`"},
              {"0.46`"},
              {"0.47000000000000003`"},
              {"0.48`"},
              {"0.49`"},
              {"0.5`"},
              {"0.51`"},
              {"0.52`"},
              {"0.53`"},
              {"0.54`"},
              {"0.55`"},
              {"0.56`"},
              {"0.5700000000000001`"},
              {"0.58`"},
              {"0.59`"},
              {"0.6`"},
              {"0.61`"},
              {"0.62`"},
              {"0.63`"},
              {"0.64`"},
              {"0.65`"},
              {"0.66`"},
              {"0.67`"},
              {"0.68`"},
              {"0.6900000000000001`"},
              {"0.7000000000000001`"},
              {"0.71`"},
              {"0.72`"},
              {"0.73`"},
              {"0.74`"},
              {"0.75`"},
              {"0.76`"},
              {"0.77`"},
              {"0.78`"},
              {"0.79`"},
              {"0.8`"},
              {"0.81`"},
              {"0.8200000000000001`"},
              {"0.8300000000000001`"},
              {"0.84`"},
              {"0.85`"},
              {"0.86`"},
              {"0.87`"},
              {"0.88`"},
              {"0.89`"},
              {"0.9`"},
              {"0.91`"},
              {"0.92`"},
              {"0.93`"},
              {"0.9400000000000001`"},
              {"0.9500000000000001`"},
              {"0.96`"},
              {"0.97`"},
              {"0.98`"},
              {"0.99`"},
              {"1.`"},
              {"1.01`"},
              {"1.02`"},
              {"1.03`"},
              {"1.04`"},
              {"1.05`"},
              {"1.06`"},
              {"1.07`"},
              {"1.08`"},
              {"1.09`"},
              {"1.1`"},
              {"1.11`"},
              {"1.12`"},
              {"1.1300000000000001`"},
              {"1.1400000000000001`"},
              {"1.1500000000000001`"},
              {"1.16`"},
              {"1.17`"},
              {"1.18`"},
              {"1.19`"},
              {"1.2`"},
              {"1.21`"},
              {"1.22`"},
              {"1.23`"},
              {"1.24`"},
              {"1.25`"},
              {"1.26`"},
              {"1.27`"},
              {"1.28`"},
              {"1.29`"},
              {"1.3`"},
              {"1.31`"},
              {"1.32`"},
              {"1.33`"},
              {"1.34`"},
              {"1.35`"},
              {"1.36`"},
              {"1.37`"},
              {"1.3800000000000001`"},
              {"1.3900000000000001`"},
              {"1.4000000000000001`"},
              {"1.41`"},
              {"1.42`"},
              {"1.43`"},
              {"1.44`"},
              {"1.45`"},
              {"1.46`"},
              {"1.47`"},
              {"1.48`"},
              {"1.49`"},
              {"1.5`"},
              {"1.51`"},
              {"1.52`"},
              {"1.53`"},
              {"1.54`"},
              {"1.55`"},
              {"1.56`"},
              {"1.57`"},
              {"1.58`"},
              {"1.59`"},
              {"1.6`"},
              {"1.61`"},
              {"1.62`"},
              {"1.6300000000000001`"},
              {"1.6400000000000001`"},
              {"1.6500000000000001`"},
              {"1.6600000000000001`"},
              {"1.67`"},
              {"1.68`"},
              {"1.69`"},
              {"1.7`"},
              {"1.71`"},
              {"1.72`"},
              {"1.73`"},
              {"1.74`"},
              {"1.75`"},
              {"1.76`"},
              {"1.77`"},
              {"1.78`"},
              {"1.79`"},
              {"1.8`"},
              {"1.81`"},
              {"1.82`"},
              {"1.83`"},
              {"1.84`"},
              {"1.85`"},
              {"1.86`"},
              {"1.87`"},
              {"1.8800000000000001`"},
              {"1.8900000000000001`"},
              {"1.9000000000000001`"},
              {"1.9100000000000001`"},
              {"1.92`"},
              {"1.93`"},
              {"1.94`"},
              {"1.95`"},
              {"1.96`"},
              {"1.97`"},
              {"1.98`"},
              {"1.99`"},
              {"2.`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .01, .02, .029999999999999999, .040000000000000001, \
.050000000000000003, .059999999999999998, .070000000000000007, \
.080000000000000002, .089999999999999997, .10000000000000001, .11, .12, .13, \
.14000000000000001, .14999999999999999, .16, .17000000000000001, \
.17999999999999999, .19, .20000000000000001, .20999999999999999, .22, \
.23000000000000001, .23999999999999999, .25, .26000000000000001, \
.27000000000000002, .28000000000000003, .28999999999999998, \
.29999999999999999, .31, .32000000000000001, .33000000000000002, \
.34000000000000002, .35000000000000003, .35999999999999999, .37, .38, \
.39000000000000001, .40000000000000002, .41000000000000003, \
.41999999999999998, .42999999999999999, .44, .45000000000000001, \
.46000000000000002, .47000000000000003, .47999999999999998, \
.48999999999999999, .5, .51000000000000001, .52000000000000002, \
.53000000000000003, .54000000000000004, .55000000000000004, \
.56000000000000005, .57000000000000006, .57999999999999996, \
.58999999999999997, .59999999999999998, .60999999999999999, .62, .63, \
.64000000000000001, .65000000000000002, .66000000000000003, \
.67000000000000004, .68000000000000005, .69000000000000006, \
.70000000000000007, .70999999999999996, .71999999999999997, \
.72999999999999998, .73999999999999999, .75, .76000000000000001, \
.77000000000000002, .78000000000000003, .79000000000000004, \
.80000000000000004, .81000000000000005, .82000000000000006, \
.83000000000000007, .83999999999999997, .84999999999999998, \
.85999999999999999, .87, .88, .89000000000000001, .90000000000000002, \
.91000000000000003, .92000000000000004, .93000000000000005, \
.94000000000000006, .95000000000000007, .95999999999999996, \
.96999999999999997, .97999999999999998, .98999999999999999, 1.0, 1.01, 1.02, 
            1.03, 1.04, 1.05, 1.0600000000000001, 1.0700000000000001, 
            1.0800000000000001, 1.0900000000000001, 1.1000000000000001, 
            1.1100000000000001, 1.1200000000000001, 1.1300000000000001, 
            1.1400000000000001, 1.1500000000000001, 1.1599999999999999, 
            1.1699999999999999, 1.1799999999999999, 1.1899999999999999, 1.2, 
            1.21, 1.22, 1.23, 1.24, 1.25, 1.26, 1.27, 1.28, 1.29, 1.3, 
            1.3100000000000001, 1.3200000000000001, 1.3300000000000001, 
            1.3400000000000001, 1.3500000000000001, 1.3600000000000001, 
            1.3700000000000001, 1.3800000000000001, 1.3900000000000001, 
            1.4000000000000001, 1.4099999999999999, 1.4199999999999999, 
            1.4299999999999999, 1.4399999999999999, 1.45, 1.46, 1.47, 1.48, 
            1.49, 1.5, 1.51, 1.52, 1.53, 1.54, 1.55, 1.5600000000000001, 
            1.5700000000000001, 1.5800000000000001, 1.5900000000000001, 
            1.6000000000000001, 1.6100000000000001, 1.6200000000000001, 
            1.6300000000000001, 1.6400000000000001, 1.6500000000000001, 
            1.6600000000000001, 1.6699999999999999, 1.6799999999999999, 
            1.6899999999999999, 1.7, 1.71, 1.72, 1.73, 1.74, 1.75, 1.76, 1.77,
             1.78, 1.79, 1.8, 1.8100000000000001, 1.8200000000000001, 
            1.8300000000000001, 1.8400000000000001, 1.8500000000000001, 
            1.8600000000000001, 1.8700000000000001, 1.8800000000000001, 
            1.8900000000000001, 1.9000000000000001, 1.9100000000000001, 
            1.9199999999999999, 1.9299999999999999, 1.9399999999999999, 1.95, 
            1.96, 1.97, 1.98, 1.99, 2.0}]], 
        "\[InvisibleSpace]", "\<\"     \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"0.4444444444444464`"},
              {"0.8888888888888893`"},
              {"1.3333333333333357`"},
              {"1.7777777777777786`"},
              {"2.2222222222222214`"},
              {"2.666666666666668`"},
              {"3.1111111111111107`"},
              {"3.555555555555557`"},
              {"4.`"},
              {"4.444444444444443`"},
              {"4.8888888888888875`"},
              {"5.333333333333334`"},
              {"5.777777777777779`"},
              {"6.222222222222223`"},
              {"6.666666666666668`"},
              {"7.1111111111111125`"},
              {"7.555555555555557`"},
              {"8.`"},
              {"8.444444444444445`"},
              {"8.88888888888889`"},
              {"9.333333333333332`"},
              {"9.777777777777779`"},
              {"10.222222222222223`"},
              {"10.666666666666666`"},
              {"11.11111111111111`"},
              {"11.555555555555555`"},
              {"12.`"},
              {"12.444444444444446`"},
              {"12.888888888888888`"},
              {"13.333333333333332`"},
              {"13.777777777777779`"},
              {"14.222222222222221`"},
              {"14.666666666666668`"},
              {"15.11111111111111`"},
              {"15.555555555555557`"},
              {"16.`"},
              {"16.444444444444443`"},
              {"16.88888888888889`"},
              {"17.333333333333332`"},
              {"17.77777777777778`"},
              {"18.22222222222222`"},
              {"18.666666666666664`"},
              {"19.11111111111111`"},
              {"19.555555555555554`"},
              {"20.`"},
              {"19.692307692307693`"},
              {"19.384615384615383`"},
              {"19.076923076923077`"},
              {"18.76923076923077`"},
              {"18.461538461538463`"},
              {"18.153846153846153`"},
              {"17.846153846153847`"},
              {"17.53846153846154`"},
              {"17.23076923076923`"},
              {"16.923076923076923`"},
              {"16.615384615384613`"},
              {"16.307692307692307`"},
              {"16.000000000000004`"},
              {"15.692307692307693`"},
              {"15.384615384615387`"},
              {"15.076923076923078`"},
              {"14.76923076923077`"},
              {"14.461538461538463`"},
              {"14.153846153846155`"},
              {"13.846153846153847`"},
              {"13.53846153846154`"},
              {"13.23076923076923`"},
              {"12.923076923076923`"},
              {"12.615384615384617`"},
              {"12.307692307692307`"},
              {"12.000000000000004`"},
              {"11.692307692307695`"},
              {"11.384615384615387`"},
              {"11.07692307692308`"},
              {"10.769230769230772`"},
              {"10.461538461538463`"},
              {"10.153846153846155`"},
              {"9.846153846153848`"},
              {"9.53846153846154`"},
              {"9.230769230769232`"},
              {"8.923076923076923`"},
              {"8.615384615384617`"},
              {"8.307692307692308`"},
              {"8.000000000000004`"},
              {"7.692307692307695`"},
              {"7.384615384615389`"},
              {"7.07692307692308`"},
              {"6.769230769230772`"},
              {"6.4615384615384635`"},
              {"6.153846153846157`"},
              {"5.8461538461538485`"},
              {"5.53846153846154`"},
              {"5.2307692307692335`"},
              {"4.923076923076925`"},
              {"4.615384615384617`"},
              {"4.30769230769231`"},
              {"4.0000000000000036`"},
              {"3.6923076923076934`"},
              {"3.384615384615387`"},
              {"3.07692307692308`"},
              {"2.76923076923077`"},
              {"2.4615384615384635`"},
              {"2.153846153846157`"},
              {"1.8461538461538467`"},
              {"1.53846153846154`"},
              {"1.23076923076923`"},
              {"0.9230769230769234`"},
              {"0.6153846153846168`"},
              {"0.3076923076923066`"},
              {"0"},
              {\(-1.0000000000000022`\)},
              {\(-2.0000000000000044`\)},
              {\(-3.0000000000000067`\)},
              {\(-4.000000000000009`\)},
              {\(-5.000000000000011`\)},
              {\(-5.999999999999991`\)},
              {\(-6.999999999999993`\)},
              {\(-7.999999999999996`\)},
              {\(-8.999999999999996`\)},
              {\(-10.`\)},
              {\(-9.5`\)},
              {\(-8.999999999999998`\)},
              {\(-8.499999999999998`\)},
              {\(-7.999999999999998`\)},
              {\(-7.4999999999999964`\)},
              {\(-6.9999999999999964`\)},
              {\(-6.4999999999999964`\)},
              {\(-5.999999999999996`\)},
              {\(-5.499999999999995`\)},
              {\(-4.999999999999994`\)},
              {\(-4.499999999999994`\)},
              {\(-3.999999999999993`\)},
              {\(-3.499999999999992`\)},
              {\(-2.999999999999992`\)},
              {\(-2.499999999999991`\)},
              {\(-1.9999999999999911`\)},
              {\(-1.4999999999999893`\)},
              {\(-0.9999999999999893`\)},
              {\(-0.49999999999998934`\)},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, .44444444444444642, .88888888888888928, 
            1.3333333333333357, 1.7777777777777786, 2.2222222222222214, 
            2.6666666666666679, 3.1111111111111107, 3.5555555555555571, 4.0, 
            4.4444444444444429, 4.8888888888888875, 5.3333333333333339, 
            5.7777777777777786, 6.2222222222222232, 6.6666666666666679, 
            7.1111111111111125, 7.5555555555555571, 8.0, 8.4444444444444446, 
            8.8888888888888893, 9.3333333333333321, 9.7777777777777786, 
            10.222222222222223, 10.666666666666666, 11.111111111111111, 
            11.555555555555555, 12.0, 12.444444444444446, 12.888888888888888, 
            13.333333333333332, 13.777777777777779, 14.222222222222221, 
            14.666666666666668, 15.111111111111111, 15.555555555555557, 16.0, 
            16.444444444444443, 16.888888888888889, 17.333333333333332, 
            17.777777777777779, 18.222222222222221, 18.666666666666664, 
            19.111111111111111, 19.555555555555554, .2*^2, 19.692307692307693,
             19.384615384615383, 19.076923076923077, 18.76923076923077, 
            18.461538461538463, 18.153846153846153, 17.846153846153847, 
            17.53846153846154, 17.23076923076923, 16.923076923076923, 
            16.615384615384613, 16.307692307692307, 16.000000000000004, 
            15.692307692307693, 15.384615384615387, 15.076923076923078, 
            14.76923076923077, 14.461538461538463, 14.153846153846155, 
            13.846153846153847, 13.53846153846154, 13.23076923076923, 
            12.923076923076923, 12.615384615384617, 12.307692307692307, 
            12.000000000000004, 11.692307692307695, 11.384615384615387, 
            11.07692307692308, 10.769230769230772, 10.461538461538463, 
            10.153846153846155, 9.8461538461538485, 9.5384615384615401, 
            9.2307692307692317, 8.9230769230769234, 8.6153846153846168, 
            8.3076923076923084, 8.0000000000000036, 7.6923076923076952, 
            7.3846153846153886, 7.0769230769230802, 6.7692307692307718, 
            6.4615384615384635, 6.1538461538461569, 5.8461538461538485, 
            5.5384615384615401, 5.2307692307692335, 4.9230769230769251, 
            4.6153846153846168, 4.3076923076923102, 4.0000000000000036, 
            3.6923076923076934, 3.3846153846153868, 3.0769230769230802, 
            2.7692307692307701, 2.4615384615384635, 2.1538461538461569, 
            1.8461538461538467, 1.5384615384615401, 
            1.2307692307692299, .92307692307692335, .61538461538461675, \
.3076923076923066, 
            0, -1.0000000000000022, -2.0000000000000044, -3.0000000000000067, \
-4.0000000000000089, -5.0000000000000107, -5.9999999999999911, \
-6.9999999999999929, -7.9999999999999956, -8.9999999999999964, -.1*^2, -9.5, \
-8.9999999999999982, -8.4999999999999982, -7.9999999999999982, \
-7.4999999999999964, -6.9999999999999964, -6.4999999999999964, \
-5.9999999999999956, -5.4999999999999947, -4.9999999999999938, \
-4.4999999999999938, -3.9999999999999929, -3.499999999999992, \
-2.999999999999992, -2.4999999999999911, -1.9999999999999911, \
-1.4999999999999893, -.99999999999998934, -.49999999999998934, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}]], 
        "\[InvisibleSpace]", "\<\"    \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"0.00007202871827263201`"},
              {"0.0004518347907762645`"},
              {"0.0011809179843447026`"},
              {"0.0022634678701167242`"},
              {"0.00369853827941752`"},
              {"0.005484482662493438`"},
              {"0.007619565485183945`"},
              {"0.01010204647500701`"},
              {"0.01293019219729757`"},
              {"0.01610227761364675`"},
              {"0.019616586259541675`"},
              {"0.023471410231841405`"},
              {"0.027665050150222574`"},
              {"0.03219581511522046`"},
              {"0.037062022665983595`"},
              {"0.04226199873817081`"},
              {"0.04779407762204903`"},
              {"0.05365660192079883`"},
              {"0.059847922509027957`"},
              {"0.06636639849149181`"},
              {"0.07321039716201998`"},
              {"0.08037829396264773`"},
              {"0.08786847244295143`"},
              {"0.095679324219587`"},
              {"0.10380924893603016`"},
              {"0.11225665422251775`"},
              {"0.12101995565618885`"},
              {"0.13009757672142488`"},
              {"0.1394879487703876`"},
              {"0.149189510983754`"},
              {"0.15920071033164734`"},
              {"0.16952000153476293`"},
              {"0.180145847025688`"},
              {"0.19107671691041472`"},
              {"0.20231108893004512`"},
              {"0.2138474484226873`"},
              {"0.22568428828554155`"},
              {"0.237820108937176`"},
              {"0.2502534182799903`"},
              {"0.2629827316628668`"},
              {"0.2760065718440078`"},
              {"0.2893234689539588`"},
              {"0.3029319604588157`"},
              {"0.3168305911236162`"},
              {"0.3310179129759134`"},
              {"0.34537059051553143`"},
              {"0.35948823095641863`"},
              {"0.37329917752228864`"},
              {"0.3867949208866509`"},
              {"0.3999756500581003`"},
              {"0.41284274635326323`"},
              {"0.425397748690334`"},
              {"0.4376422109837793`"},
              {"0.4495776825191281`"},
              {"0.46120570528096394`"},
              {"0.47252781361782814`"},
              {"0.4835455342291109`"},
              {"0.4942603861961645`"},
              {"0.504673881019349`"},
              {"0.5147875226557311`"},
              {"0.5246028075567124`"},
              {"0.5341212247054837`"},
              {"0.5433442556542963`"},
              {"0.5522733745615467`"},
              {"0.560910048228676`"},
              {"0.5692557361368864`"},
              {"0.5773118904836734`"},
              {"0.5850799562191755`"},
              {"0.5925613710823436`"},
              {"0.5997575656369291`"},
              {"0.6066699633072921`"},
              {"0.6132999804140319`"},
              {"0.6196490262094388`"},
              {"0.6257185029127698`"},
              {"0.6315098057453467`"},
              {"0.6370243229654812`"},
              {"0.642263435903224`"},
              {"0.6472285189949413`"},
              {"0.6519209398177184`"},
              {"0.6563420591235917`"},
              {"0.66049323087361`"},
              {"0.6643758022717257`"},
              {"0.6679911137985165`"},
              {"0.6713404992447398`"},
              {"0.6744252857447186`"},
              {"0.677246793809561`"},
              {"0.6798063373602146`"},
              {"0.6821052237603551`"},
              {"0.6841447538491113`"},
              {"0.6859262219736266`"},
              {"0.6874509160214577`"},
              {"0.688720117452812`"},
              {"0.6897351013326245`"},
              {"0.6904971363624735`"},
              {"0.6910074849123378`"},
              {"0.6912674030521957`"},
              {"0.6912781405834654`"},
              {"0.6910409410702889`"},
              {"0.6905570418706604`"},
              {"0.6898276741673981`"},
              {"0.6888540629989627`"},
              {"0.687637427290121`"},
              {"0.6861789798824576`"},
              {"0.684479927564733`"},
              {"0.6825414711030914`"},
              {"0.6803648052711171`"},
              {"0.6779511188797411`"},
              {"0.6753015948069984`"},
              {"0.6724174100276366`"},
              {"0.669299735642577`"},
              {"0.665837538327843`"},
              {"0.6616647536877177`"},
              {"0.6567178915093757`"},
              {"0.6509915736273786`"},
              {"0.6444884160499783`"},
              {"0.6372121200635237`"},
              {"0.6291665198930144`"},
              {"0.6203554515009275`"},
              {"0.610782734583319`"},
              {"0.6004521701702786`"},
              {"0.589610637301275`"},
              {"0.5790575508704284`"},
              {"0.568936717058687`"},
              {"0.559266001449479`"},
              {"0.5500459179104492`"},
              {"0.5412745980219661`"},
              {"0.5329498546332198`"},
              {"0.5250694662846312`"},
              {"0.517631216368732`"},
              {"0.5106328984808531`"},
              {"0.5040723171091622`"},
              {"0.4979472876824458`"},
              {"0.49225563652958954`"},
              {"0.4869952008271215`"},
              {"0.4821638285453433`"},
              {"0.4777593783944994`"},
              {"0.4737797197711832`"},
              {"0.47022273270500653`"},
              {"0.46708630780553423`"},
              {"0.46436834620948386`"},
              {"0.4619857272201319`"},
              {"0.45967115565569944`"},
              {"0.4573758766824996`"},
              {"0.4550931197555754`"},
              {"0.4528219023043368`"},
              {"0.4505620399027451`"},
              {"0.4483134583970741`"},
              {"0.44607609907833456`"},
              {"0.4438499056086433`"},
              {"0.44163482221775485`"},
              {"0.4394307934532438`"},
              {"0.4372377641448706`"},
              {"0.4350556793984794`"},
              {"0.43288448459397344`"},
              {"0.43072412538385807`"},
              {"0.42857454769186787`"},
              {"0.42643569771161144`"},
              {"0.42430752190522436`"},
              {"0.422189967002029`"},
              {"0.4200829799972011`"},
              {"0.417986508150443`"},
              {"0.4159004989846635`"},
              {"0.41382490028466434`"},
              {"0.411759660095833`"},
              {"0.40970472672284236`"},
              {"0.4076600487283569`"},
              {"0.40562557493174484`"},
              {"0.4036012544077971`"},
              {"0.40158703648545274`"},
              {"0.3995828707465305`"},
              {"0.3975887070244667`"},
              {"0.3956044954030597`"},
              {"0.3936301862152203`"},
              {"0.39166573004172844`"},
              {"0.3897110777099965`"},
              {"0.38776618029283816`"},
              {"0.38583098910724367`"},
              {"0.38390545571316154`"},
              {"0.38198953191228574`"},
              {"0.3800831697468494`"},
              {"0.3781863214984244`"},
              {"0.3762989396867268`"},
              {"0.37442097706842836`"},
              {"0.3725523866359742`"},
              {"0.3706931216164058`"},
              {"0.3688431354701905`"},
              {"0.36700238189005646`"},
              {"0.3651708147998335`"},
              {"0.36334838835329986`"},
              {"0.36153505693303456`"},
              {"0.3597307751492755`"},
              {"0.3579354978387833`"},
              {"0.356149180063711`"},
              {"0.35437177711047896`"},
              {"0.35260324448865576`"},
              {"0.3508435379298446`"},
              {"0.349092613386575`"},
              {"0.34735042703120056`"},
              {"0.34561693525480164`"},
              {"0.34389209466609383`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .000072028718272632014, .00045183479077626448, \
.0011809179843447026, .0022634678701167242, .0036985382794175199, \
.0054844826624934383, .0076195654851839451, .010102046475007009, \
.012930192197297571, .01610227761364675, .019616586259541675, \
.023471410231841405, .027665050150222574, .032195815115220461, \
.037062022665983595, .042261998738170811, .047794077622049028, \
.053656601920798831, .059847922509027957, .066366398491491813, \
.073210397162019977, .080378293962647729, .087868472442951429, \
.095679324219586998, .10380924893603016, .11225665422251775, \
.12101995565618885, .13009757672142488, .13948794877038759, \
.14918951098375399, .15920071033164734, .16952000153476293, \
.18014584702568801, .19107671691041472, .20231108893004512, \
.2138474484226873, .22568428828554155, .23782010893717601, \
.25025341827999031, .26298273166286679, .27600657184400779, \
.28932346895395877, .30293196045881571, .31683059112361622, \
.33101791297591338, .34537059051553143, .35948823095641863, \
.37329917752228864, .38679492088665091, .39997565005810032, \
.41284274635326323, .42539774869033398, .43764221098377931, \
.44957768251912811, .46120570528096394, .47252781361782814, \
.4835455342291109, .49426038619616453, .50467388101934896, \
.51478752265573113, .5246028075567124, .53412122470548373, \
.54334425565429634, .55227337456154668, .56091004822867596, \
.5692557361368864, .57731189048367337, .58507995621917552, \
.59256137108234364, .59975756563692906, .60666996330729206, \
.61329998041403189, .61964902620943885, .62571850291276976, \
.63150980574534665, .63702432296548117, .64226343590322399, \
.64722851899494127, .65192093981771837, .65634205912359167, .66049323087361, \
.66437580227172566, .6679911137985165, .67134049924473982, \
.67442528574471861, .67724679380956099, .67980633736021456, \
.68210522376035509, .68414475384911133, .68592622197362663, \
.68745091602145769, .68872011745281203, .6897351013326245, \
.69049713636247345, .69100748491233777, .69126740305219569, \
.69127814058346537, .69104094107028891, .69055704187066036, \
.6898276741673981, .68885406299896268, .68763742729012101, \
.68617897988245757, .68447992756473297, .68254147110309138, \
.68036480527111709, .67795111887974113, .67530159480699836, \
.67241741002763655, .66929973564257705, .66583753832784298, \
.66166475368771771, .65671789150937565, .65099157362737858, \
.64448841604997831, .63721212006352368, .62916651989301442, \
.62035545150092752, .610782734583319, .60045217017027863, .58961063730127505, \
.57905755087042843, .56893671705868698, .55926600144947902, \
.55004591791044921, .54127459802196609, .53294985463321976, \
.52506946628463125, .51763121636873199, .51063289848085314, \
.50407231710916223, .49794728768244578, .49225563652958954, \
.4869952008271215, .48216382854534329, .47775937839449939, \
.47377971977118322, .47022273270500653, .46708630780553423, \
.46436834620948386, .46198572722013193, .45967115565569944, \
.45737587668249963, .45509311975557543, .45282190230433678, \
.45056203990274513, .44831345839707409, .44607609907833456, \
.44384990560864329, .44163482221775485, .43943079345324382, \
.43723776414487059, .43505567939847939, .43288448459397344, \
.43072412538385807, .42857454769186787, .42643569771161144, \
.42430752190522436, .42218996700202899, .42008297999720112, \
.41798650815044303, .41590049898466352, .41382490028466434, \
.41175966009583298, .40970472672284236, .40766004872835693, \
.40562557493174484, .40360125440779709, .40158703648545274, \
.39958287074653048, .39758870702446669, .3956044954030597, \
.39363018621522028, .39166573004172844, .38971107770999652, \
.38776618029283816, .38583098910724367, .38390545571316154, \
.38198953191228574, .38008316974684941, .3781863214984244, \
.37629893968672679, .37442097706842836, .37255238663597418, \
.37069312161640577, .36884313547019049, .36700238189005646, \
.36517081479983349, .36334838835329986, .36153505693303456, \
.35973077514927548, .35793549783878331, .35614918006371099, \
.35437177711047896, .35260324448865576, .35084353792984457, \
.34909261338657499, .34735042703120056, .34561693525480164, \
.34389209466609383}]], "\[InvisibleSpace]", "\<\"   \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"0.015434725344135432`"},
              {"0.0351411627221898`"},
              {"0.055370985690850597`"},
              {"0.07560779702571643`"},
              {"0.09578073419399286`"},
              {"0.11588035204841768`"},
              {"0.13590567049623276`"},
              {"0.15585687478461774`"},
              {"0.1757343092094468`"},
              {"0.19553833840138798`"},
              {"0.2152693282114922`"},
              {"0.23492764308408193`"},
              {"0.2545136457024527`"},
              {"0.2740276969478543`"},
              {"0.29347015590161263`"},
              {"0.3128413798531702`"},
              {"0.33214172430889766`"},
              {"0.35137154300097073`"},
              {"0.3705311878962293`"},
              {"0.38962100920497866`"},
              {"0.40864135538976276`"},
              {"0.42759257317408134`"},
              {"0.4464750075510736`"},
              {"0.4652890017921477`"},
              {"0.48403489745558065`"},
              {"0.5027130343950611`"},
              {"0.5213237507682021`"},
              {"0.5398673830450005`"},
              {"0.5583442660162614`"},
              {"0.5767547328019789`"},
              {"0.5950991148596758`"},
              {"0.6133777419926942`"},
              {"0.6315909423584594`"},
              {"0.6497390424766872`"},
              {"0.6678223672375604`"},
              {"0.6858412399098615`"},
              {"0.7037959821490609`"},
              {"0.7216869140053728`"},
              {"0.7395143539317639`"},
              {"0.7572786187919258`"},
              {"0.774980023868205`"},
              {"0.7926188828694949`"},
              {"0.8101955079390922`"},
              {"0.8277102096625015`"},
              {"0.8451632970752215`"},
              {"0.8364347732419339`"},
              {"0.8204161974154881`"},
              {"0.8034511957009018`"},
              {"0.7864139740057321`"},
              {"0.7694247549400195`"},
              {"0.7524998224956567`"},
              {"0.7356411336910131`"},
              {"0.7188486719415164`"},
              {"0.7021221500215034`"},
              {"0.685461244818206`"},
              {"0.6688656296865877`"},
              {"0.6523349789025277`"},
              {"0.6358689682697038`"},
              {"0.6194672751962487`"},
              {"0.6031295786983726`"},
              {"0.5868555593939314`"},
              {"0.5706448994946632`"},
              {"0.5544972827982585`"},
              {"0.538412394680447`"},
              {"0.5223899220871315`"},
              {"0.5064295535265442`"},
              {"0.4905309790614516`"},
              {"0.47469389030139886`"},
              {"0.4589179803949891`"},
              {"0.4432029440221997`"},
              {"0.4275484773867455`"},
              {"0.41195427820846836`"},
              {"0.3964200457157761`"},
              {"0.3809454806381097`"},
              {"0.36553028519845393`"},
              {"0.35017416310588356`"},
              {"0.3348768195481482`"},
              {"0.3196379611842904`"},
              {"0.30445729613730405`"},
              {"0.2893345339868291`"},
              {"0.27426938576188054`"},
              {"0.25926156393361666`"},
              {"0.2443107824081395`"},
              {"0.2294167565193373`"},
              {"0.21457920302175654`"},
              {"0.1997978400835099`"},
              {"0.1850723872792276`"},
              {"0.17040256558303227`"},
              {"0.15578809736155758`"},
              {"0.1412287063669978`"},
              {"0.12672411773019365`"},
              {"0.11227405795375121`"},
              {"0.09787825490519701`"},
              {"0.08353643781016475`"},
              {"0.06924833724561882`"},
              {"0.05501368513311036`"},
              {"0.040832214732065594`"},
              {"0.026703660633110277`"},
              {"0.012627758751426021`"},
              {\(-0.0013957536798604175`\)},
              {\(-0.015367138116254786`\)},
              {\(-0.029286654708438636`\)},
              {\(-0.04315456230878259`\)},
              {\(-0.056971118477824684`\)},
              {\(-0.0707365794907183`\)},
              {\(-0.08445120034364595`\)},
              {\(-0.09811523476020328`\)},
              {\(-0.11172893519774896`\)},
              {\(-0.12529255285372543`\)},
              {\(-0.1388063376719446`\)},
              {\(-0.17631309128874934`\)},
              {\(-0.22042452119544054`\)},
              {\(-0.26530213434488725`\)},
              {\(-0.31014178774447526`\)},
              {\(-0.35483334314085435`\)},
              {\(-0.39936233045312114`\)},
              {\(-0.4437274643401759`\)},
              {\(-0.4879292734975279`\)},
              {\(-0.5319685331711829`\)},
              {\(-0.5758460490900473`\)},
              {\(-0.5674704296610481`\)},
              {\(-0.5445176478777226`\)},
              {\(-0.5196391046399804`\)},
              {\(-0.49457843575804716`\)},
              {\(-0.46957559349125744`\)},
              {\(-0.4446632424743822`\)},
              {\(-0.4198454738543455`\)},
              {\(-0.39512244184647666`\)},
              {\(-0.3704937599869494`\)},
              {\(-0.34595896931161346`\)},
              {\(-0.32151760288645215`\)},
              {\(-0.29716919469329456`\)},
              {\(-0.27291328084469824`\)},
              {\(-0.2487493997414239`\)},
              {\(-0.22467709208419107`\)},
              {\(-0.20069590086539235`\)},
              {\(-0.17680537135810054`\)},
              {\(-0.15300505110474355`\)},
              {\(-0.12929448990578857`\)},
              {\(-0.10567323980847526`\)},
              {\(-0.09950492110775469`\)},
              {\(-0.09823070033683393`\)},
              {\(-0.09763326896748895`\)},
              {\(-0.09713124104502549`\)},
              {\(-0.09664445933407295`\)},
              {\(-0.09616186333831239`\)},
              {\(-0.09568191791719055`\)},
              {\(-0.09520440109620501`\)},
              {\(-0.09472927197848366`\)},
              {\(-0.09425651468092605`\)},
              {\(-0.0937861168198248`\)},
              {\(-0.09331806654475636`\)},
              {\(-0.09285235212943341`\)},
              {\(-0.09238896191504939`\)},
              {\(-0.09192788430221796`\)},
              {\(-0.09146910774961114`\)},
              {\(-0.09101262077352243`\)},
              {\(-0.09055841194756004`\)},
              {\(-0.09010646990235632`\)},
              {\(-0.08965678332528465`\)},
              {\(-0.0892093409601746`\)},
              {\(-0.08876413160703209`\)},
              {\(-0.08832114412175618`\)},
              {\(-0.08788036741586372`\)},
              {\(-0.08744179045620823`\)},
              {\(-0.08700540226470682`\)},
              {\(-0.0865711919180625`\)},
              {\(-0.08613914854749416`\)},
              {\(-0.08570926133846044`\)},
              {\(-0.08528151953039259`\)},
              {\(-0.08485591241642318`\)},
              {\(-0.08443242934311904`\)},
              {\(-0.08401105971021386`\)},
              {\(-0.08359179297034258`\)},
              {\(-0.08317461862877909`\)},
              {\(-0.08275952624317173`\)},
              {\(-0.08234650542328287`\)},
              {\(-0.0819355458307279`\)},
              {\(-0.08152663717871841`\)},
              {\(-0.08111976923180189`\)},
              {\(-0.08071493180560779`\)},
              {\(-0.08031211476659214`\)},
              {\(-0.07991130803178242`\)},
              {\(-0.07951250156852752`\)},
              {\(-0.07911568539424499`\)},
              {\(-0.0787208495761712`\)},
              {\(-0.07832798423111387`\)},
              {\(-0.07793707952520335`\)},
              {\(-0.07754812567364724`\)},
              {\(-0.0771611129404847`\)},
              {\(-0.0767760316383447`\)},
              {\(-0.07639287212820059`\)},
              {\(-0.07601162481913112`\)},
              {\(-0.07563228016807988`\)},
              {\(-0.07525482867961542`\)},
              {\(-0.07487926090569516`\)},
              {\(-0.07450556744542702`\)},
              {\(-0.0741337389448363`\)},
              {\(-0.07376376609662941`\)},
              {\(-0.07339563963996254`\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .015434725344135432, .035141162722189798, .055370985690850597, \
.075607797025716433, .095780734193992856, .11588035204841768, \
.13590567049623276, .15585687478461774, .1757343092094468, \
.19553833840138798, .21526932821149219, .23492764308408193, \
.25451364570245272, .27402769694785428, .29347015590161263, \
.31284137985317018, .33214172430889766, .35137154300097073, \
.3705311878962293, .38962100920497866, .40864135538976276, \
.42759257317408134, .44647500755107361, .46528900179214772, \
.48403489745558065, .5027130343950611, .52132375076820214, \
.53986738304500048, .55834426601626141, .57675473280197886, \
.59509911485967582, .61337774199269424, .63159094235845936, \
.64973904247668723, .66782236723756039, .68584123990986146, \
.70379598214906092, .72168691400537277, .7395143539317639, \
.75727861879192582, .77498002386820497, .79261888286949489, \
.81019550793909223, .82771020966250153, .84516329707522153, \
.83643477324193394, .8204161974154881, .80345119570090184, .7864139740057321, \
.7694247549400195, .75249982249565672, .73564113369101314, \
.71884867194151636, .70212215002150336, .68546124481820603, \
.66886562968658769, .65233497890252767, .63586896826970385, \
.61946727519624867, .60312957869837258, .58685555939393141, \
.57064489949466324, .5544972827982585, .53841239468044699, \
.52238992208713153, .50642955352654417, .4905309790614516, \
.47469389030139886, .4589179803949891, .44320294402219967, \
.42754847738674551, .41195427820846836, .3964200457157761, \
.38094548063810968, .36553028519845393, .35017416310588356, \
.33487681954814819, .31963796118429039, .30445729613730405, \
.28933453398682912, .27426938576188054, .25926156393361666, \
.2443107824081395, .22941675651933729, .21457920302175654, .1997978400835099, \
.18507238727922759, .17040256558303227, .15578809736155758, \
.1412287063669978, .12672411773019365, .11227405795375121, \
.097878254905197012, .083536437810164746, .069248337245618824, \
.055013685133110363, .040832214732065594, .026703660633110277, \
.012627758751426021, -.0013957536798604175, -.015367138116254786, \
-.029286654708438636, -.04315456230878259, -.056971118477824684, \
-.070736579490718293, -.084451200343645949, -.098115234760203285, \
-.11172893519774896, -.12529255285372543, -.13880633767194461, \
-.17631309128874934, -.22042452119544054, -.26530213434488725, \
-.31014178774447526, -.35483334314085435, -.39936233045312114, \
-.4437274643401759, -.4879292734975279, -.53196853317118287, \
-.57584604909004733, -.5674704296610481, -.54451764787772261, \
-.51963910463998042, -.49457843575804716, -.46957559349125744, \
-.44466324247438221, -.41984547385434551, -.39512244184647666, \
-.37049375998694939, -.34595896931161346, -.32151760288645215, \
-.29716919469329456, -.27291328084469824, -.2487493997414239, \
-.22467709208419107, -.20069590086539235, -.17680537135810054, \
-.15300505110474355, -.12929448990578857, -.10567323980847526, \
-.09950492110775469, -.098230700336833926, -.097633268967488945, \
-.09713124104502549, -.096644459334072952, -.096161863338312392, \
-.095681917917190551, -.09520440109620501, -.094729271978483659, \
-.094256514680926051, -.093786116819824794, -.093318066544756356, \
-.092852352129433408, -.092388961915049389, -.09192788430221796, \
-.091469107749611145, -.091012620773522429, -.090558411947560036, \
-.090106469902356323, -.08965678332528465, -.089209340960174605, \
-.088764131607032087, -.088321144121756179, -.087880367415863719, \
-.087441790456208229, -.087005402264706821, -.086571191918062507, \
-.08613914854749416, -.085709261338460435, -.085281519530392591, \
-.084855912416423179, -.084432429343119036, -.084011059710213859, \
-.083591792970342582, -.08317461862877909, -.082759526243171733, \
-.082346505423282867, -.081935545830727902, -.081526637178718414, \
-.081119769231801891, -.080714931805607792, -.080312114766592141, \
-.079911308031782424, -.079512501568527516, -.079115685394244989, \
-.078720849576171203, -.078327984231113867, -.077937079525203345, \
-.077548125673647245, -.077161112940484694, -.076776031638344705, \
-.07639287212820059, -.076011624819131124, -.07563228016807988, \
-.075254828679615415, -.074879260905695161, -.074505567445427023, \
-.074133738944836297, -.073763766096629407, -.07339563963996254}]], 
        "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"2.1966288751474314`"},
              {"4.368400253184612`"},
              {"6.517886730736927`"},
              {"8.645537065983953`"},
              {"10.751506766511305`"},
              {"12.835910446618037`"},
              {"14.898856618265606`"},
              {"16.94045248949118`"},
              {"18.96080462819993`"},
              {"20.960019055969624`"},
              {"22.938201263267995`"},
              {"24.895456213825273`"},
              {"26.831888347500286`"},
              {"28.747601582927693`"},
              {"30.642699320123647`"},
              {"32.51728444307467`"},
              {"34.371459322313065`"},
              {"36.20532581747934`"},
              {"38.01898527987191`"},
              {"39.812538554984`"},
              {"41.58608598502795`"},
              {"43.3397274114469`"},
              {"45.07356217741389`"},
              {"46.78768913031859`"},
              {"48.48220662424154`"},
              {"50.157212522416074`"},
              {"51.812804199677906`"},
              {"53.44907854490259`"},
              {"55.06613196343072`"},
              {"56.66406037948114`"},
              {"58.24295923855192`"},
              {"59.8029235098095`"},
              {"61.34404768846601`"},
              {"62.86642579814438`"},
              {"64.37015139323205`"},
              {"65.85531756122255`"},
              {"67.32201692504582`"},
              {"68.77034164538647`"},
              {"70.20038342299074`"},
              {"71.61223350096193`"},
              {"73.0059826670442`"},
              {"74.38172125589516`"},
              {"75.73953915134712`"},
              {"77.07952578865685`"},
              {"78.40177015674429`"},
              {"75.98898885786295`"},
              {"73.60070847105885`"},
              {"71.23266303450382`"},
              {"68.8841803370153`"},
              {"66.5550840023368`"},
              {"64.24526642509771`"},
              {"61.95462989598441`"},
              {"59.68307848349946`"},
              {"57.430516912760524`"},
              {"55.196850408884146`"},
              {"52.98198467335155`"},
              {"50.78582587871747`"},
              {"48.60828066585736`"},
              {"46.44925614157481`"},
              {"44.30865987626877`"},
              {"42.18639990161872`"},
              {"40.08238470828253`"},
              {"37.9965232436059`"},
              {"35.92872490934306`"},
              {"33.87889955938912`"},
              {"31.846957497523597`"},
              {"29.832809475165135`"},
              {"27.836366689137613`"},
              {"25.857540779447234`"},
              {"23.896243827070755`"},
              {"21.95238835175489`"},
              {"20.025887309826405`"},
              {"18.11665409201347`"},
              {"16.224602521277657`"},
              {"14.349646850656823`"},
              {"12.491701761118797`"},
              {"10.650682359425732`"},
              {"8.826504176009141`"},
              {"7.019083162855484`"},
              {"5.228335691402419`"},
              {"3.4541785504454214`"},
              {"1.6965289440549736`"},
              {\(-0.04469551049600007`\)},
              {\(-1.7695767847941601`\)},
              {\(-3.4781964413377064`\)},
              {\(-5.170635635577856`\)},
              {\(-6.846975117950391`\)},
              {\(-8.507295235896821`\)},
              {\(-10.151675935875645`\)},
              {\(-11.780196765363446`\)},
              {\(-13.392936874846137`\)},
              {\(-14.98997501980008`\)},
              {\(-16.571389562663512`\)},
              {\(-18.137258474798035`\)},
              {\(-19.68765933844027`\)},
              {\(-21.22266934864389`\)},
              {\(-22.742365315211895`\)},
              {\(-24.246823664619228`\)},
              {\(-25.73612044192579`\)},
              {\(-27.21033131268002`\)},
              {\(-28.66953156481282`\)},
              {\(-30.113796110522088`\)},
              {\(-31.54319948814793`\)},
              {\(-32.9578158640384`\)},
              {\(-34.3577190344059`\)},
              {\(-35.74298242717453`\)},
              {\(-37.11367910381791`\)},
              {\(-38.46988176118814`\)},
              {\(-39.81166273333541`\)},
              {\(-41.13909399331856`\)},
              {\(-45.873919056678716`\)},
              {\(-50.55581694617882`\)},
              {\(-55.18886587665147`\)},
              {\(-59.77383542228072`\)},
              {\(-64.31103801098322`\)},
              {\(-68.80072202120174`\)},
              {\(-73.24312597724754`\)},
              {\(-77.63848602549061`\)},
              {\(-81.98703697007538`\)},
              {\(-86.28901242076132`\)},
              {\(-83.13102236471806`\)},
              {\(-80.01081458865644`\)},
              {\(-76.91993670501711`\)},
              {\(-73.85710313251677`\)},
              {\(-70.82201686788719`\)},
              {\(-67.81451778566647`\)},
              {\(-64.83446522442082`\)},
              {\(-61.88172179774625`\)},
              {\(-58.95615115958702`\)},
              {\(-56.05761769323571`\)},
              {\(-53.18598646553626`\)},
              {\(-50.34112321766115`\)},
              {\(-47.52289436094485`\)},
              {\(-44.73116697342894`\)},
              {\(-41.96580879651954`\)},
              {\(-39.226688231674686`\)},
              {\(-36.51367433710989`\)},
              {\(-33.82663682452058`\)},
              {\(-31.16544605582073`\)},
              {\(-28.529973039897996`\)},
              {\(-28.391296913925505`\)},
              {\(-28.250117802277956`\)},
              {\(-28.10920280665887`\)},
              {\(-27.96893034467508`\)},
              {\(-27.8293495580051`\)},
              {\(-27.690464211221006`\)},
              {\(-27.552271828472755`\)},
              {\(-27.414769088585338`\)},
              {\(-27.277952568723187`\)},
              {\(-27.141818846833473`\)},
              {\(-27.006364515694624`\)},
              {\(-26.871586184779424`\)},
              {\(-26.737480480438762`\)},
              {\(-26.604044045854224`\)},
              {\(-26.47127354095918`\)},
              {\(-26.339165642355855`\)},
              {\(-26.207717043232265`\)},
              {\(-26.07692445327943`\)},
              {\(-25.946784598609046`\)},
              {\(-25.81729422167151`\)},
              {\(-25.688450081174402`\)},
              {\(-25.56024895200132`\)},
              {\(-25.4326876251312`\)},
              {\(-25.305762907557934`\)},
              {\(-25.179471622210492`\)},
              {\(-25.053810607873373`\)},
              {\(-24.928776719107475`\)},
              {\(-24.804366826171382`\)},
              {\(-24.680577814942993`\)},
              {\(-24.557406586841598`\)},
              {\(-24.434850058750296`\)},
              {\(-24.312905162938844`\)},
              {\(-24.191568846986836`\)},
              {\(-24.07083807370734`\)},
              {\(-23.95070982107083`\)},
              {\(-23.831181082129586`\)},
              {\(-23.712248864942374`\)},
              {\(-23.593910192499603`\)},
              {\(-23.476162102648775`\)},
              {\(-23.359001648020357`\)},
              {\(-23.242425895954003`\)},
              {\(-23.126431928425127`\)},
              {\(-23.011016841971887`\)},
              {\(-22.896177747622502`\)},
              {\(-22.78191177082292`\)},
              {\(-22.668216051364887`\)},
              {\(-22.55508774331434`\)},
              {\(-22.44252401494017`\)},
              {\(-22.330522048643346`\)},
              {\(-22.2190790408864`\)},
              {\(-22.108192202123206`\)},
              {\(-21.99785875672921`\)},
              {\(-21.888075942931916`\)},
              {\(-21.77884101274178`\)},
              {\(-21.670151231883395`\)},
              {\(-21.562003879727072`\)},
              {\(-21.454396249220746`\)},
              {\(-21.347325646822185`\)},
              {\(-21.240789392431594`\)},
              {\(-21.13478481932452`\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 2.1966288751474314, 4.3684002531846122, 
            6.5178867307369268, 8.6455370659839534, 10.751506766511305, 
            12.835910446618037, 14.898856618265606, 16.940452489491179, 
            18.960804628199931, 20.960019055969624, 22.938201263267995, 
            24.895456213825273, 26.831888347500286, 28.747601582927693, 
            30.642699320123647, 32.517284443074672, 34.371459322313065, 
            36.205325817479341, 38.018985279871913, 39.812538554984002, 
            41.58608598502795, 43.339727411446901, 45.073562177413891, 
            46.78768913031859, 48.482206624241542, 50.157212522416074, 
            51.812804199677906, 53.449078544902591, 55.06613196343072, 
            56.664060379481143, 58.242959238551919, 59.802923509809503, 
            61.344047688466013, 62.866425798144377, 64.370151393232049, 
            65.855317561222549, 67.322016925045816, 68.770341645386466, 
            70.20038342299074, 71.612233500961935, 73.005982667044194, 
            74.381721255895158, 75.739539151347117, 77.079525788656852, 
            78.401770156744291, 75.98898885786295, 73.600708471058852, 
            71.232663034503815, 68.884180337015295, 66.555084002336798, 
            64.245266425097711, 61.954629895984411, 59.683078483499457, 
            57.430516912760524, 55.196850408884146, 52.981984673351548, 
            50.785825878717468, 48.608280665857357, 46.449256141574807, 
            44.30865987626877, 42.186399901618721, 40.082384708282532, 
            37.9965232436059, 35.92872490934306, 33.878899559389119, 
            31.846957497523597, 29.832809475165135, 27.836366689137613, 
            25.857540779447234, 23.896243827070755, 21.952388351754891, 
            20.025887309826405, 18.116654092013469, 16.224602521277657, 
            14.349646850656823, 12.491701761118797, 10.650682359425732, 
            8.8265041760091414, 7.0190831628554839, 5.2283356914024193, 
            3.4541785504454214, 
            1.6965289440549736, -.044695510496000068, -1.7695767847941601, \
-3.4781964413377064, -5.170635635577856, -6.8469751179503913, \
-8.5072952358968212, -10.151675935875645, -11.780196765363446, \
-13.392936874846137, -14.989975019800079, -16.571389562663512, \
-18.137258474798035, -19.68765933844027, -21.22266934864389, \
-22.742365315211895, -24.246823664619228, -25.736120441925792, \
-27.210331312680019, -28.669531564812822, -30.113796110522088, \
-31.543199488147931, -32.957815864038402, -34.357719034405903, \
-35.742982427174532, -37.113679103817908, -38.469881761188141, \
-39.81166273333541, -41.139093993318561, -45.873919056678716, \
-50.555816946178822, -55.188865876651469, -59.773835422280719, \
-64.311038010983225, -68.800722021201736, -73.243125977247544, \
-77.638486025490607, -81.98703697007538, -86.289012420761324, \
-83.131022364718063, -80.010814588656444, -76.919936705017108, \
-73.85710313251677, -70.822016867887186, -67.814517785666467, \
-64.834465224420825, -61.881721797746252, -58.956151159587023, \
-56.057617693235713, -53.18598646553626, -50.341123217661149, \
-47.522894360944854, -44.731166973428941, -41.965808796519539, \
-39.226688231674686, -36.51367433710989, -33.826636824520577, \
-31.16544605582073, -28.529973039897996, -28.391296913925505, \
-28.250117802277956, -28.109202806658871, -27.96893034467508, \
-27.829349558005099, -27.690464211221006, -27.552271828472755, \
-27.414769088585338, -27.277952568723187, -27.141818846833473, \
-27.006364515694624, -26.871586184779424, -26.737480480438762, \
-26.604044045854224, -26.471273540959182, -26.339165642355855, \
-26.207717043232265, -26.076924453279432, -25.946784598609046, \
-25.81729422167151, -25.688450081174402, -25.56024895200132, \
-25.432687625131202, -25.305762907557934, -25.179471622210492, \
-25.053810607873373, -24.928776719107475, -24.804366826171382, \
-24.680577814942993, -24.557406586841598, -24.434850058750296, \
-24.312905162938844, -24.191568846986836, -24.070838073707339, \
-23.950709821070831, -23.831181082129586, -23.712248864942374, \
-23.593910192499603, -23.476162102648775, -23.359001648020357, \
-23.242425895954003, -23.126431928425127, -23.011016841971887, \
-22.896177747622502, -22.781911770822919, -22.668216051364887, \
-22.555087743314338, -22.442524014940169, -22.330522048643346, \
-22.219079040886399, -22.108192202123206, -21.997858756729212, \
-21.888075942931916, -21.778841012741779, -21.670151231883395, \
-21.562003879727072, -21.454396249220746, -21.347325646822185, \
-21.240789392431594, -21.134784819324519}]]}],
      SequenceForm[ 
        TableForm[ {
          0, .01, .02, .029999999999999999, .040000000000000001, \
.050000000000000003, .059999999999999998, .070000000000000007, \
.080000000000000002, .089999999999999997, .10000000000000001, .11, .12, .13, \
.14000000000000001, .14999999999999999, .16, .17000000000000001, \
.17999999999999999, .19, .20000000000000001, .20999999999999999, .22, \
.23000000000000001, .23999999999999999, .25, .26000000000000001, \
.27000000000000002, .28000000000000003, .28999999999999998, \
.29999999999999999, .31, .32000000000000001, .33000000000000002, \
.34000000000000002, .35000000000000003, .35999999999999999, .37, .38, \
.39000000000000001, .40000000000000002, .41000000000000003, \
.41999999999999998, .42999999999999999, .44, .45000000000000001, \
.46000000000000002, .47000000000000003, .47999999999999998, \
.48999999999999999, .5, .51000000000000001, .52000000000000002, \
.53000000000000003, .54000000000000004, .55000000000000004, \
.56000000000000005, .57000000000000006, .57999999999999996, \
.58999999999999997, .59999999999999998, .60999999999999999, .62, .63, \
.64000000000000001, .65000000000000002, .66000000000000003, \
.67000000000000004, .68000000000000005, .69000000000000006, \
.70000000000000007, .70999999999999996, .71999999999999997, \
.72999999999999998, .73999999999999999, .75, .76000000000000001, \
.77000000000000002, .78000000000000003, .79000000000000004, \
.80000000000000004, .81000000000000005, .82000000000000006, \
.83000000000000007, .83999999999999997, .84999999999999998, \
.85999999999999999, .87, .88, .89000000000000001, .90000000000000002, \
.91000000000000003, .92000000000000004, .93000000000000005, \
.94000000000000006, .95000000000000007, .95999999999999996, \
.96999999999999997, .97999999999999998, .98999999999999999, 1.0, 1.01, 1.02, 
          1.03, 1.04, 1.05, 1.0600000000000001, 1.0700000000000001, 
          1.0800000000000001, 1.0900000000000001, 1.1000000000000001, 
          1.1100000000000001, 1.1200000000000001, 1.1300000000000001, 
          1.1400000000000001, 1.1500000000000001, 1.1599999999999999, 
          1.1699999999999999, 1.1799999999999999, 1.1899999999999999, 1.2, 
          1.21, 1.22, 1.23, 1.24, 1.25, 1.26, 1.27, 1.28, 1.29, 1.3, 
          1.3100000000000001, 1.3200000000000001, 1.3300000000000001, 
          1.3400000000000001, 1.3500000000000001, 1.3600000000000001, 
          1.3700000000000001, 1.3800000000000001, 1.3900000000000001, 
          1.4000000000000001, 1.4099999999999999, 1.4199999999999999, 
          1.4299999999999999, 1.4399999999999999, 1.45, 1.46, 1.47, 1.48, 
          1.49, 1.5, 1.51, 1.52, 1.53, 1.54, 1.55, 1.5600000000000001, 
          1.5700000000000001, 1.5800000000000001, 1.5900000000000001, 
          1.6000000000000001, 1.6100000000000001, 1.6200000000000001, 
          1.6300000000000001, 1.6400000000000001, 1.6500000000000001, 
          1.6600000000000001, 1.6699999999999999, 1.6799999999999999, 
          1.6899999999999999, 1.7, 1.71, 1.72, 1.73, 1.74, 1.75, 1.76, 1.77, 
          1.78, 1.79, 1.8, 1.8100000000000001, 1.8200000000000001, 
          1.8300000000000001, 1.8400000000000001, 1.8500000000000001, 
          1.8600000000000001, 1.8700000000000001, 1.8800000000000001, 
          1.8900000000000001, 1.9000000000000001, 1.9100000000000001, 
          1.9199999999999999, 1.9299999999999999, 1.9399999999999999, 1.95, 
          1.96, 1.97, 1.98, 1.99, 2.0}], "     ", 
        TableForm[ {0, .44444444444444642, .88888888888888928, 
          1.3333333333333357, 1.7777777777777786, 2.2222222222222214, 
          2.6666666666666679, 3.1111111111111107, 3.5555555555555571, 4.0, 
          4.4444444444444429, 4.8888888888888875, 5.3333333333333339, 
          5.7777777777777786, 6.2222222222222232, 6.6666666666666679, 
          7.1111111111111125, 7.5555555555555571, 8.0, 8.4444444444444446, 
          8.8888888888888893, 9.3333333333333321, 9.7777777777777786, 
          10.222222222222223, 10.666666666666666, 11.111111111111111, 
          11.555555555555555, 12.0, 12.444444444444446, 12.888888888888888, 
          13.333333333333332, 13.777777777777779, 14.222222222222221, 
          14.666666666666668, 15.111111111111111, 15.555555555555557, 16.0, 
          16.444444444444443, 16.888888888888889, 17.333333333333332, 
          17.777777777777779, 18.222222222222221, 18.666666666666664, 
          19.111111111111111, 19.555555555555554, .2*^2, 19.692307692307693, 
          19.384615384615383, 19.076923076923077, 18.76923076923077, 
          18.461538461538463, 18.153846153846153, 17.846153846153847, 
          17.53846153846154, 17.23076923076923, 16.923076923076923, 
          16.615384615384613, 16.307692307692307, 16.000000000000004, 
          15.692307692307693, 15.384615384615387, 15.076923076923078, 
          14.76923076923077, 14.461538461538463, 14.153846153846155, 
          13.846153846153847, 13.53846153846154, 13.23076923076923, 
          12.923076923076923, 12.615384615384617, 12.307692307692307, 
          12.000000000000004, 11.692307692307695, 11.384615384615387, 
          11.07692307692308, 10.769230769230772, 10.461538461538463, 
          10.153846153846155, 9.8461538461538485, 9.5384615384615401, 
          9.2307692307692317, 8.9230769230769234, 8.6153846153846168, 
          8.3076923076923084, 8.0000000000000036, 7.6923076923076952, 
          7.3846153846153886, 7.0769230769230802, 6.7692307692307718, 
          6.4615384615384635, 6.1538461538461569, 5.8461538461538485, 
          5.5384615384615401, 5.2307692307692335, 4.9230769230769251, 
          4.6153846153846168, 4.3076923076923102, 4.0000000000000036, 
          3.6923076923076934, 3.3846153846153868, 3.0769230769230802, 
          2.7692307692307701, 2.4615384615384635, 2.1538461538461569, 
          1.8461538461538467, 1.5384615384615401, 
          1.2307692307692299, .92307692307692335, .61538461538461675, \
.3076923076923066, 
          0, -1.0000000000000022, -2.0000000000000044, -3.0000000000000067, \
-4.0000000000000089, -5.0000000000000107, -5.9999999999999911, \
-6.9999999999999929, -7.9999999999999956, -8.9999999999999964, -.1*^2, -9.5, \
-8.9999999999999982, -8.4999999999999982, -7.9999999999999982, \
-7.4999999999999964, -6.9999999999999964, -6.4999999999999964, \
-5.9999999999999956, -5.4999999999999947, -4.9999999999999938, \
-4.4999999999999938, -3.9999999999999929, -3.499999999999992, \
-2.999999999999992, -2.4999999999999911, -1.9999999999999911, \
-1.4999999999999893, -.99999999999998934, -.49999999999998934, 0, 0, 0, 0, 0, 
          0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
           0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
          0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}], "    ", 
        TableForm[ {
          0, .000072028718272632014, .00045183479077626448, \
.0011809179843447026, .0022634678701167242, .0036985382794175199, \
.0054844826624934383, .0076195654851839451, .010102046475007009, \
.012930192197297571, .01610227761364675, .019616586259541675, \
.023471410231841405, .027665050150222574, .032195815115220461, \
.037062022665983595, .042261998738170811, .047794077622049028, \
.053656601920798831, .059847922509027957, .066366398491491813, \
.073210397162019977, .080378293962647729, .087868472442951429, \
.095679324219586998, .10380924893603016, .11225665422251775, \
.12101995565618885, .13009757672142488, .13948794877038759, \
.14918951098375399, .15920071033164734, .16952000153476293, \
.18014584702568801, .19107671691041472, .20231108893004512, \
.2138474484226873, .22568428828554155, .23782010893717601, \
.25025341827999031, .26298273166286679, .27600657184400779, \
.28932346895395877, .30293196045881571, .31683059112361622, \
.33101791297591338, .34537059051553143, .35948823095641863, \
.37329917752228864, .38679492088665091, .39997565005810032, \
.41284274635326323, .42539774869033398, .43764221098377931, \
.44957768251912811, .46120570528096394, .47252781361782814, \
.4835455342291109, .49426038619616453, .50467388101934896, \
.51478752265573113, .5246028075567124, .53412122470548373, \
.54334425565429634, .55227337456154668, .56091004822867596, \
.5692557361368864, .57731189048367337, .58507995621917552, \
.59256137108234364, .59975756563692906, .60666996330729206, \
.61329998041403189, .61964902620943885, .62571850291276976, \
.63150980574534665, .63702432296548117, .64226343590322399, \
.64722851899494127, .65192093981771837, .65634205912359167, .66049323087361, \
.66437580227172566, .6679911137985165, .67134049924473982, \
.67442528574471861, .67724679380956099, .67980633736021456, \
.68210522376035509, .68414475384911133, .68592622197362663, \
.68745091602145769, .68872011745281203, .6897351013326245, \
.69049713636247345, .69100748491233777, .69126740305219569, \
.69127814058346537, .69104094107028891, .69055704187066036, \
.6898276741673981, .68885406299896268, .68763742729012101, \
.68617897988245757, .68447992756473297, .68254147110309138, \
.68036480527111709, .67795111887974113, .67530159480699836, \
.67241741002763655, .66929973564257705, .66583753832784298, \
.66166475368771771, .65671789150937565, .65099157362737858, \
.64448841604997831, .63721212006352368, .62916651989301442, \
.62035545150092752, .610782734583319, .60045217017027863, .58961063730127505, \
.57905755087042843, .56893671705868698, .55926600144947902, \
.55004591791044921, .54127459802196609, .53294985463321976, \
.52506946628463125, .51763121636873199, .51063289848085314, \
.50407231710916223, .49794728768244578, .49225563652958954, \
.4869952008271215, .48216382854534329, .47775937839449939, \
.47377971977118322, .47022273270500653, .46708630780553423, \
.46436834620948386, .46198572722013193, .45967115565569944, \
.45737587668249963, .45509311975557543, .45282190230433678, \
.45056203990274513, .44831345839707409, .44607609907833456, \
.44384990560864329, .44163482221775485, .43943079345324382, \
.43723776414487059, .43505567939847939, .43288448459397344, \
.43072412538385807, .42857454769186787, .42643569771161144, \
.42430752190522436, .42218996700202899, .42008297999720112, \
.41798650815044303, .41590049898466352, .41382490028466434, \
.41175966009583298, .40970472672284236, .40766004872835693, \
.40562557493174484, .40360125440779709, .40158703648545274, \
.39958287074653048, .39758870702446669, .3956044954030597, \
.39363018621522028, .39166573004172844, .38971107770999652, \
.38776618029283816, .38583098910724367, .38390545571316154, \
.38198953191228574, .38008316974684941, .3781863214984244, \
.37629893968672679, .37442097706842836, .37255238663597418, \
.37069312161640577, .36884313547019049, .36700238189005646, \
.36517081479983349, .36334838835329986, .36153505693303456, \
.35973077514927548, .35793549783878331, .35614918006371099, \
.35437177711047896, .35260324448865576, .35084353792984457, \
.34909261338657499, .34735042703120056, .34561693525480164, \
.34389209466609383}], "   ", 
        TableForm[ {
          0, .015434725344135432, .035141162722189798, .055370985690850597, \
.075607797025716433, .095780734193992856, .11588035204841768, \
.13590567049623276, .15585687478461774, .1757343092094468, \
.19553833840138798, .21526932821149219, .23492764308408193, \
.25451364570245272, .27402769694785428, .29347015590161263, \
.31284137985317018, .33214172430889766, .35137154300097073, \
.3705311878962293, .38962100920497866, .40864135538976276, \
.42759257317408134, .44647500755107361, .46528900179214772, \
.48403489745558065, .5027130343950611, .52132375076820214, \
.53986738304500048, .55834426601626141, .57675473280197886, \
.59509911485967582, .61337774199269424, .63159094235845936, \
.64973904247668723, .66782236723756039, .68584123990986146, \
.70379598214906092, .72168691400537277, .7395143539317639, \
.75727861879192582, .77498002386820497, .79261888286949489, \
.81019550793909223, .82771020966250153, .84516329707522153, \
.83643477324193394, .8204161974154881, .80345119570090184, .7864139740057321, \
.7694247549400195, .75249982249565672, .73564113369101314, \
.71884867194151636, .70212215002150336, .68546124481820603, \
.66886562968658769, .65233497890252767, .63586896826970385, \
.61946727519624867, .60312957869837258, .58685555939393141, \
.57064489949466324, .5544972827982585, .53841239468044699, \
.52238992208713153, .50642955352654417, .4905309790614516, \
.47469389030139886, .4589179803949891, .44320294402219967, \
.42754847738674551, .41195427820846836, .3964200457157761, \
.38094548063810968, .36553028519845393, .35017416310588356, \
.33487681954814819, .31963796118429039, .30445729613730405, \
.28933453398682912, .27426938576188054, .25926156393361666, \
.2443107824081395, .22941675651933729, .21457920302175654, .1997978400835099, \
.18507238727922759, .17040256558303227, .15578809736155758, \
.1412287063669978, .12672411773019365, .11227405795375121, \
.097878254905197012, .083536437810164746, .069248337245618824, \
.055013685133110363, .040832214732065594, .026703660633110277, \
.012627758751426021, -.0013957536798604175, -.015367138116254786, \
-.029286654708438636, -.04315456230878259, -.056971118477824684, \
-.070736579490718293, -.084451200343645949, -.098115234760203285, \
-.11172893519774896, -.12529255285372543, -.13880633767194461, \
-.17631309128874934, -.22042452119544054, -.26530213434488725, \
-.31014178774447526, -.35483334314085435, -.39936233045312114, \
-.4437274643401759, -.4879292734975279, -.53196853317118287, \
-.57584604909004733, -.5674704296610481, -.54451764787772261, \
-.51963910463998042, -.49457843575804716, -.46957559349125744, \
-.44466324247438221, -.41984547385434551, -.39512244184647666, \
-.37049375998694939, -.34595896931161346, -.32151760288645215, \
-.29716919469329456, -.27291328084469824, -.2487493997414239, \
-.22467709208419107, -.20069590086539235, -.17680537135810054, \
-.15300505110474355, -.12929448990578857, -.10567323980847526, \
-.09950492110775469, -.098230700336833926, -.097633268967488945, \
-.09713124104502549, -.096644459334072952, -.096161863338312392, \
-.095681917917190551, -.09520440109620501, -.094729271978483659, \
-.094256514680926051, -.093786116819824794, -.093318066544756356, \
-.092852352129433408, -.092388961915049389, -.09192788430221796, \
-.091469107749611145, -.091012620773522429, -.090558411947560036, \
-.090106469902356323, -.08965678332528465, -.089209340960174605, \
-.088764131607032087, -.088321144121756179, -.087880367415863719, \
-.087441790456208229, -.087005402264706821, -.086571191918062507, \
-.08613914854749416, -.085709261338460435, -.085281519530392591, \
-.084855912416423179, -.084432429343119036, -.084011059710213859, \
-.083591792970342582, -.08317461862877909, -.082759526243171733, \
-.082346505423282867, -.081935545830727902, -.081526637178718414, \
-.081119769231801891, -.080714931805607792, -.080312114766592141, \
-.079911308031782424, -.079512501568527516, -.079115685394244989, \
-.078720849576171203, -.078327984231113867, -.077937079525203345, \
-.077548125673647245, -.077161112940484694, -.076776031638344705, \
-.07639287212820059, -.076011624819131124, -.07563228016807988, \
-.075254828679615415, -.074879260905695161, -.074505567445427023, \
-.074133738944836297, -.073763766096629407, -.07339563963996254}], "  ", 
        TableForm[ {0, 2.1966288751474314, 4.3684002531846122, 
          6.5178867307369268, 8.6455370659839534, 10.751506766511305, 
          12.835910446618037, 14.898856618265606, 16.940452489491179, 
          18.960804628199931, 20.960019055969624, 22.938201263267995, 
          24.895456213825273, 26.831888347500286, 28.747601582927693, 
          30.642699320123647, 32.517284443074672, 34.371459322313065, 
          36.205325817479341, 38.018985279871913, 39.812538554984002, 
          41.58608598502795, 43.339727411446901, 45.073562177413891, 
          46.78768913031859, 48.482206624241542, 50.157212522416074, 
          51.812804199677906, 53.449078544902591, 55.06613196343072, 
          56.664060379481143, 58.242959238551919, 59.802923509809503, 
          61.344047688466013, 62.866425798144377, 64.370151393232049, 
          65.855317561222549, 67.322016925045816, 68.770341645386466, 
          70.20038342299074, 71.612233500961935, 73.005982667044194, 
          74.381721255895158, 75.739539151347117, 77.079525788656852, 
          78.401770156744291, 75.98898885786295, 73.600708471058852, 
          71.232663034503815, 68.884180337015295, 66.555084002336798, 
          64.245266425097711, 61.954629895984411, 59.683078483499457, 
          57.430516912760524, 55.196850408884146, 52.981984673351548, 
          50.785825878717468, 48.608280665857357, 46.449256141574807, 
          44.30865987626877, 42.186399901618721, 40.082384708282532, 
          37.9965232436059, 35.92872490934306, 33.878899559389119, 
          31.846957497523597, 29.832809475165135, 27.836366689137613, 
          25.857540779447234, 23.896243827070755, 21.952388351754891, 
          20.025887309826405, 18.116654092013469, 16.224602521277657, 
          14.349646850656823, 12.491701761118797, 10.650682359425732, 
          8.8265041760091414, 7.0190831628554839, 5.2283356914024193, 
          3.4541785504454214, 
          1.6965289440549736, -.044695510496000068, -1.7695767847941601, \
-3.4781964413377064, -5.170635635577856, -6.8469751179503913, \
-8.5072952358968212, -10.151675935875645, -11.780196765363446, \
-13.392936874846137, -14.989975019800079, -16.571389562663512, \
-18.137258474798035, -19.68765933844027, -21.22266934864389, \
-22.742365315211895, -24.246823664619228, -25.736120441925792, \
-27.210331312680019, -28.669531564812822, -30.113796110522088, \
-31.543199488147931, -32.957815864038402, -34.357719034405903, \
-35.742982427174532, -37.113679103817908, -38.469881761188141, \
-39.81166273333541, -41.139093993318561, -45.873919056678716, \
-50.555816946178822, -55.188865876651469, -59.773835422280719, \
-64.311038010983225, -68.800722021201736, -73.243125977247544, \
-77.638486025490607, -81.98703697007538, -86.289012420761324, \
-83.131022364718063, -80.010814588656444, -76.919936705017108, \
-73.85710313251677, -70.822016867887186, -67.814517785666467, \
-64.834465224420825, -61.881721797746252, -58.956151159587023, \
-56.057617693235713, -53.18598646553626, -50.341123217661149, \
-47.522894360944854, -44.731166973428941, -41.965808796519539, \
-39.226688231674686, -36.51367433710989, -33.826636824520577, \
-31.16544605582073, -28.529973039897996, -28.391296913925505, \
-28.250117802277956, -28.109202806658871, -27.96893034467508, \
-27.829349558005099, -27.690464211221006, -27.552271828472755, \
-27.414769088585338, -27.277952568723187, -27.141818846833473, \
-27.006364515694624, -26.871586184779424, -26.737480480438762, \
-26.604044045854224, -26.471273540959182, -26.339165642355855, \
-26.207717043232265, -26.076924453279432, -25.946784598609046, \
-25.81729422167151, -25.688450081174402, -25.56024895200132, \
-25.432687625131202, -25.305762907557934, -25.179471622210492, \
-25.053810607873373, -24.928776719107475, -24.804366826171382, \
-24.680577814942993, -24.557406586841598, -24.434850058750296, \
-24.312905162938844, -24.191568846986836, -24.070838073707339, \
-23.950709821070831, -23.831181082129586, -23.712248864942374, \
-23.593910192499603, -23.476162102648775, -23.359001648020357, \
-23.242425895954003, -23.126431928425127, -23.011016841971887, \
-22.896177747622502, -22.781911770822919, -22.668216051364887, \
-22.555087743314338, -22.442524014940169, -22.330522048643346, \
-22.219079040886399, -22.108192202123206, -21.997858756729212, \
-21.888075942931916, -21.778841012741779, -21.670151231883395, \
-21.562003879727072, -21.454396249220746, -21.347325646822185, \
-21.240789392431594, -21.134784819324519}]],
      Editable->False]], "Print"]
}, Open  ]],

Cell["\<\
Veamos ahora el mismo caso anterior, pero en el supuesto de que el material \
no resista a tracci\[OAcute]n (hormig\[OAcute]n). \
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["\<\
p={{0,0},{.45,20},{1.1,0},{1.2,-10},{1.4,0}};
WilsonNoLineal[0,2,.1,0,0,12.35,.2,.274,p,  
        1.4,-15,0,posicion,velocidad,aceleracion] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]1\[InvisibleSpace]"  j = "\
\[InvisibleSpace]9\[InvisibleSpace]"  kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0\),
      SequenceForm[ "i = ", 1, "  j = ", 9, "  kt = ", 0, "   fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]2\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0\),
      SequenceForm[ "i = ", 2, "  j = ", 13, "  kt = ", 0, "   fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]3\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0\),
      SequenceForm[ "i = ", 3, "  j = ", 13, "  kt = ", 0, "   fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]4\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0\),
      SequenceForm[ "i = ", 4, "  j = ", 13, "  kt = ", 0, "   fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]5\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0\),
      SequenceForm[ "i = ", 5, "  j = ", 13, "  kt = ", 0, "   fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]6\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0\),
      SequenceForm[ "i = ", 6, "  j = ", 13, "  kt = ", 0, "   fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]7\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0\),
      SequenceForm[ "i = ", 7, "  j = ", 13, "  kt = ", 0, "   fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]8\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0\),
      SequenceForm[ "i = ", 8, "  j = ", 13, "  kt = ", 0, "   fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]9\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0\),
      SequenceForm[ "i = ", 9, "  j = ", 13, "  kt = ", 0, "   fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]10\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0\),
      SequenceForm[ "i = ", 10, "  j = ", 13, "  kt = ", 0, "   fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]11\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0\),
      SequenceForm[ "i = ", 11, "  j = ", 13, "  kt = ", 0, "   fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]12\[InvisibleSpace]"  j = "\
\[InvisibleSpace]20\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]\(-1.3470034180821981`\)\),
      SequenceForm[ 
      "i = ", 12, "  j = ", 20, "  kt = ", 12.35, 
        "   fs = ", -1.3470034180821981],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]13\[InvisibleSpace]"  j = "\
\[InvisibleSpace]12\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]\(-6.864592913869027`\)\),
      SequenceForm[ 
      "i = ", 13, "  j = ", 12, "  kt = ", 12.35, 
        "   fs = ", -6.8645929138690267],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]14\[InvisibleSpace]"  j = "\
\[InvisibleSpace]12\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]\(-7.124652107092321`\)\),
      SequenceForm[ 
      "i = ", 14, "  j = ", 12, "  kt = ", 12.35, 
        "   fs = ", -7.124652107092321],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]15\[InvisibleSpace]"  j = "\
\[InvisibleSpace]12\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]\(-4.631727409518119`\)\),
      SequenceForm[ 
      "i = ", 15, "  j = ", 12, "  kt = ", 12.35, 
        "   fs = ", -4.6317274095181187],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]16\[InvisibleSpace]"  j = "\
\[InvisibleSpace]12\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]\(-2.9623634028825703`\)\),
      SequenceForm[ 
      "i = ", 16, "  j = ", 12, "  kt = ", 12.35, 
        "   fs = ", -2.9623634028825703],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]17\[InvisibleSpace]"  j = "\
\[InvisibleSpace]12\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]\(-1.8959004388021974`\)\),
      SequenceForm[ 
      "i = ", 17, "  j = ", 12, "  kt = ", 12.35, 
        "   fs = ", -1.8959004388021974],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]18\[InvisibleSpace]"  j = "\
\[InvisibleSpace]12\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]\(-1.213336945377734`\)\),
      SequenceForm[ 
      "i = ", 18, "  j = ", 12, "  kt = ", 12.35, 
        "   fs = ", -1.2133369453777341],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]19\[InvisibleSpace]"  j = "\
\[InvisibleSpace]12\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]\(-0.7765112807482581`\)\),
      SequenceForm[ 
      "i = ", 19, "  j = ", 12, "  kt = ", 12.35, 
        "   fs = ", -.77651128074825815],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]20\[InvisibleSpace]"  j = "\
\[InvisibleSpace]12\[InvisibleSpace]"  kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]\(-0.4969516062565208`\)\),
      SequenceForm[ 
      "i = ", 20, "  j = ", 12, "  kt = ", 12.35, 
        "   fs = ", -.49695160625652079],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Carga:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.221522 0.0206807 [
[.2619 .20902 -9 -9 ]
[.2619 .20902 9 0 ]
[.5 .20902 -3 -9 ]
[.5 .20902 3 0 ]
[.7381 .20902 -9 -9 ]
[.7381 .20902 9 0 ]
[.97619 .20902 -3 -9 ]
[.97619 .20902 3 0 ]
[1.025 .22152 0 -6.25 ]
[1.025 .22152 10 6.25 ]
[.01131 .01472 -18 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .11812 -12 -4.5 ]
[.01131 .11812 0 4.5 ]
[.01131 .32493 -6 -4.5 ]
[.01131 .32493 0 4.5 ]
[.01131 .42833 -12 -4.5 ]
[.01131 .42833 0 4.5 ]
[.01131 .53173 -12 -4.5 ]
[.01131 .53173 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .22152 m
.2619 .22777 L
s
[(0.5)] .2619 .20902 0 1 Mshowa
.5 .22152 m
.5 .22777 L
s
[(1)] .5 .20902 0 1 Mshowa
.7381 .22152 m
.7381 .22777 L
s
[(1.5)] .7381 .20902 0 1 Mshowa
.97619 .22152 m
.97619 .22777 L
s
[(2)] .97619 .20902 0 1 Mshowa
.125 Mabswid
.07143 .22152 m
.07143 .22527 L
s
.11905 .22152 m
.11905 .22527 L
s
.16667 .22152 m
.16667 .22527 L
s
.21429 .22152 m
.21429 .22527 L
s
.30952 .22152 m
.30952 .22527 L
s
.35714 .22152 m
.35714 .22527 L
s
.40476 .22152 m
.40476 .22527 L
s
.45238 .22152 m
.45238 .22527 L
s
.54762 .22152 m
.54762 .22527 L
s
.59524 .22152 m
.59524 .22527 L
s
.64286 .22152 m
.64286 .22527 L
s
.69048 .22152 m
.69048 .22527 L
s
.78571 .22152 m
.78571 .22527 L
s
.83333 .22152 m
.83333 .22527 L
s
.88095 .22152 m
.88095 .22527 L
s
.92857 .22152 m
.92857 .22527 L
s
.25 Mabswid
0 .22152 m
1 .22152 L
s
gsave
1.025 .22152 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .01472 m
.03006 .01472 L
s
[(-10)] .01131 .01472 1 0 Mshowa
.02381 .11812 m
.03006 .11812 L
s
[(-5)] .01131 .11812 1 0 Mshowa
.02381 .32493 m
.03006 .32493 L
s
[(5)] .01131 .32493 1 0 Mshowa
.02381 .42833 m
.03006 .42833 L
s
[(10)] .01131 .42833 1 0 Mshowa
.02381 .53173 m
.03006 .53173 L
s
[(15)] .01131 .53173 1 0 Mshowa
.125 Mabswid
.02381 .0354 m
.02756 .0354 L
s
.02381 .05608 m
.02756 .05608 L
s
.02381 .07676 m
.02756 .07676 L
s
.02381 .09744 m
.02756 .09744 L
s
.02381 .1388 m
.02756 .1388 L
s
.02381 .15948 m
.02756 .15948 L
s
.02381 .18016 m
.02756 .18016 L
s
.02381 .20084 m
.02756 .20084 L
s
.02381 .2422 m
.02756 .2422 L
s
.02381 .26288 m
.02756 .26288 L
s
.02381 .28356 m
.02756 .28356 L
s
.02381 .30424 m
.02756 .30424 L
s
.02381 .34561 m
.02756 .34561 L
s
.02381 .36629 m
.02756 .36629 L
s
.02381 .38697 m
.02756 .38697 L
s
.02381 .40765 m
.02756 .40765 L
s
.02381 .44901 m
.02756 .44901 L
s
.02381 .46969 m
.02756 .46969 L
s
.02381 .49037 m
.02756 .49037 L
s
.02381 .51105 m
.02756 .51105 L
s
.02381 .55241 m
.02756 .55241 L
s
.02381 .57309 m
.02756 .57309 L
s
.02381 .59377 m
.02756 .59377 L
s
.02381 .61445 m
.02756 .61445 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 0 r
.5 Mabswid
.02381 .22152 m
.07143 .31344 L
.11905 .40535 L
.16667 .49726 L
.21429 .58918 L
.2619 .60332 L
.30952 .53969 L
.35714 .47605 L
.40476 .41242 L
.45238 .34879 L
.5 .28515 L
.54762 .22152 L
.59524 .01472 L
.64286 .11812 L
.69048 .22152 L
.7381 .22152 L
.78571 .22152 L
.83333 .22152 L
.88095 .22152 L
.92857 .22152 L
.97619 .22152 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^1000`40O003h00Oogoo:goo000EOol0
0`00Oomoo`3oOolCOol000Moo`D0009oo`8000Eoo`03001oogoo0?mooa=oo`002Goo00D007ooOomo
o`00009oo`03001oogoo009oo`03001oogoo0?mooa=oo`002Goo00D007ooOomoo`00009oo`03001o
ogoo009oo`<009Eoo`030n1oogoo07Yoo`0000=oo`0000000P0017oo00D007ooOomoo`00009oo`03
001oogoo009oo`03001oogoo09Eoo`030n1oogoo07Yoo`002Goo00D007ooOomoo`00009oo`03001o
ogoo009oo`03001oogoo09Eoo`83h7]oo`0027oo0P0017oo0P001Goo00<007ooOol0U7oo00<3h7oo
0n00Ngoo000EOol00`00Oomoo`2DOol010?POomoo`?PNWoo000EOol00`00Oomoo`2DOol010?POomo
o`?PNWoo000EOol2002EOol01@?POomoogoo0n00NGoo000EOol00`00Oomoo`2COol00`?POomoo`02
Ool00`?POomoo`1gOol001Eoo`03001oogoo09=oo`030n1oogoo009oo`030n1oogoo07Moo`005Goo
00<007ooOol0Tgoo00<3h7ooOol00goo00<3h7ooOol0MWoo000EOol00`00Oomoo`2COol00`?POomo
o`03Ool00`?POomoo`1fOol001Eoo`8009=oo`030n1oogoo00Eoo`030n1oogoo07Eoo`005Goo00<0
07ooOol0TWoo00<3h7ooOol01Goo00<3h7ooOol0MGoo000EOol00`00Oomoo`2BOol00`?POomoo`06
Ool00`?POomoo`1dOol001Eoo`03001oogoo099oo`030n1oogoo00Ioo`030n1oogoo07Aoo`005Goo
00<007ooOol0TGoo00<3h7ooOol01goo00<3h7ooOol0M7oo000EOol00`00Oomoo`2AOol00`?POomo
o`08Ool00`?POomoo`1cOol001Eoo`80099oo`030n1oogoo00Qoo`030n1oogoo07=oo`005Goo00<0
07ooOol0TGoo00<3h7ooOol02Goo00<3h7ooOol0LWoo000EOol00`00Oomoo`2AOol00`?POomoo`09
Ool00`?POomoo`1bOol001Eoo`03001oogoo091oo`030n1oogoo00]oo`030n1oogoo075oo`005Goo
00<007ooOol0T7oo00<3h7ooOol02goo00<3h7ooOol0LGoo000EOol2002AOol00`?POomoo`0;Ool0
0`?POomoo`1aOol001Eoo`03001oogoo091oo`030n1oogoo00aoo`030n1oogoo071oo`005Goo00<0
07ooOol0Sgoo00<3h7ooOol03Goo00<3h7ooOol0L7oo000EOol00`00Oomoo`2?Ool00`?POomoo`0>
Ool00`?POomoo`1_Ool000ioo`8000Eoo`03001oogoo08moo`030n1oogoo00ioo`030n1oogoo06mo
o`003Goo00@007ooOol000Aoo`03001oogoo08moo`030n1oogoo00moo`030n1oogoo06ioo`0047oo
00<007ooOol00Woo0`00SWoo00<3h7ooOol047oo00<3h7ooOol0KWoo0007Ool40003Ool20005Ool0
0`00Oomoo`2>Ool00`?POomoo`0@Ool00`?POomoo`1^Ool000ioo`03001oogoo00Aoo`03001oogoo
08ioo`030n1oogoo015oo`030n1oogoo06eoo`003Woo0`0017oo00<007ooOol0SWoo00<3h7ooOol0
4Goo00<3h7ooOol0KGoo000EOol00`00Oomoo`2=Ool00`?POomoo`0COol00`?POomoo`1/Ool001Eo
o`8008ioo`030n1oogoo01=oo`030n1oogoo06aoo`005Goo00<007ooOol0SGoo00<3h7ooOol057oo
00<3h7ooOol0Jgoo000EOol00`00Oomoo`2=Ool00`?POomoo`0DOol00`?POomoo`1[Ool001Eoo`03
001oogoo08aoo`030n1oogoo01Ioo`030n1oogoo06Yoo`005Goo00<007ooOol0S7oo00<3h7ooOol0
5Woo00<3h7ooOol0JWoo000EOol00`00Oomoo`2<Ool00`?POomoo`0GOol00`?POomoo`1YOol001Eo
o`8008eoo`030n1oogoo01Moo`030n1oogoo06Uoo`005Goo00<007ooOol0S7oo00<3h7ooOol067oo
00<3h7ooOol0J7oo000EOol00`00Oomoo`2;Ool00`?POomoo`0IOol00`?POomoo`1XOol001Eoo`03
001oogoo08]oo`030n1oogoo01Yoo`030n1oogoo06Moo`005Goo00<007ooOol0Rgoo00<3h7ooOol0
6Woo00<3h7ooOol0Igoo000EOol2000fOol20004Ool20004Ool2000gOol5000<Ool00`?POomoo`0K
Ool00`?POomoo`07Ool50002Ool20004Ool2000fOol4000FOol001Eoo`03001oogoo03Aoo`04001o
ogoo0008Ool01000Oomoo`00>7oo00<007ooOol02goo00<3h7ooOol077oo00<3h7ooOol02Goo00<0
07ooOol01goo00@007ooOol003Eoo`03001oogoo01Moo`005Goo00<007ooOol0=7oo00@007ooOol0
00]oo`03001oogoo03Ioo`03001oogoo00]oo`030n1oogoo01eoo`030n1oogoo00Qoo`03001oogoo
00Yoo`03001oogoo03Aoo`03001oogoo01Ioo`005Goo00<007ooOol0=7oo00@007ooOol000Uoo`80
03Uoo`03001oogoo00]oo`030n1oogoo01eoo`030n1oogoo00Qoo`03001oogoo00Qoo`8003Qoo`03
001oogoo01Eoo`005Goo00<007ooOol0=7oo00@007ooOol000Uoo`03001oogoo03Qoo`03001oogoo
00]oo`030n1oogoo01ioo`030n1oogoo00Moo`03001oogoo00Qoo`03001oogoo03Eoo`04001oogoo
000FOol001Eoo`03001oogoo03Eoo`8000Yoo`<003Moo`8000aoo`030n1oogoo01moo`030n1oogoo
00Ioo`8000Yoo`<003Ioo`8001Moo`005Goo0P00RWoo00<3h7ooOol087oo00<3h7ooOol0Hgoo000E
Ool00`00Oomoo`29Ool00`?POomoo`0POol00`?POomoo`1SOol001Eoo`03001oogoo08Uoo`030n1o
ogoo025oo`030n1oogoo069oo`005Goo00<007ooOol0R7oo00<3h7ooOol08Woo00<3h7ooOol0HWoo
000EOol00`00Oomoo`28Ool00`?POomoo`0SOol00`?POomoo`1JOol20005Ool000moo`H000030n00
000008P000030n00000002<004d3h0H000Uoo`04001oogoo0004Ool001Eoo`030003h7oo00Yoo`03
001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03
001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Yoo`03001oogoo00Qoo`03
0n0007oo00]oo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Yoo`03001oogoo00Uoo`03
001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Yoo`03001oogoo00eoo`03
001oogoo00Eoo`005Goo00<000?POol0?7oo00<007ooOol0?Goo00<007ooOol027oo00<3h7ooOol0
<Goo00<007ooOol0?7oo00<007ooOol037oo1@0017oo000EOol00`00Ool3h026Ool00`?POomoo`21
Ool00`00Oomoo`05Ool001Eoo`03001oo`?P08Eoo`030n1oogoo08Yoo`005Goo00@007ooOol3h8=o
o`030n1oogoo08]oo`005Goo0P0000=oo`?POol0PWoo00<3h7ooOol0Rgoo000EOol01@00Oomoogoo
0n00PGoo00<3h7ooOol0S7oo000EOol01@00Oomoogoo0n00P7oo00<3h7ooOol0SGoo000EOol00`00
Oomoo`02Ool00`?POomoo`1mOol00`?POomoo`2=Ool001Eoo`03001oogoo009oo`030n1oogoo07ao
o`030n1oogoo08ioo`005Goo0P0017oo00<3h7ooOol0NWoo00<3h7ooOol0Sgoo000EOol00`00Oomo
o`03Ool00`?POomoo`1jOol00`?POomoo`2?Ool001Eoo`03001oogoo00Aoo`030n1oogoo07Qoo`03
0n1oogoo091oo`005Goo00<007ooOol017oo00<3h7ooOol0Mgoo00<3h7ooOol0TGoo000EOol00`00
Oomoo`05Ool00`?POomoo`1eOol00`?POomoo`2BOol001Eoo`03001oogoo00Eoo`030n1oogoo07Eo
o`030n1oogoo099oo`005Goo0P001goo00<3h7ooOol0Lgoo00<3h7ooOol0Tgoo000EOol00`00Oomo
o`06Ool00`?POomoo`1bOol00`?POomoo`2DOol001Eoo`03001oogoo00Moo`030n1oogoo071oo`03
0n1oogoo09Eoo`005Goo00<007ooOol01goo00<3h7ooOol0L7oo00<3h7ooOol0UGoo000EOol00`00
Oomoo`08Ool00`?POomoo`1^Ool00`?POomoo`2FOol001Eoo`8000Uoo`030n1oogoo06eoo`030n1o
ogoo09Moo`005Goo00<007ooOol02Goo00<3h7ooOol0Jgoo00<3h7ooOol0V7oo000EOol00`00Oomo
o`09Ool00`?POomoo`1[Ool00`?POomoo`2HOol001Eoo`03001oogoo00Yoo`030n1oogoo06Uoo`03
0n1oogoo09Uoo`003Woo0P001Goo00<007ooOol02goo00<3h7ooOol0Igoo00<3h7ooOol0VWoo000=
Ool01000Oomoo`0017oo00<007ooOol02goo00<3h7ooOol0IWoo00<3h7ooOol0Vgoo000@Ool00`00
Oomoo`02Ool3000<Ool00`?POomoo`1UOol00`?POomoo`2KOol000ioo`8000Eoo`03001oogoo00ao
o`030n1oogoo06Aoo`030n1oogoo09aoo`003Woo00<007ooOol017oo00<007ooOol03Goo00<3h7oo
Ool0HWoo00<3h7ooOol0WGoo000>Ool30004Ool00`00Oomoo`0=Ool00`?POomoo`1QOol00`?POomo
o`2NOol001Eoo`03001oogoo00ioo`030n1oogoo061oo`030n1oogoo09ioo`005Goo0P003goo00<3
h7ooOol0Ggoo00<3h7ooOol0Wgoo000EOol00`00Oomoo`0?Ool00`?POomoo`1MOol00`?POomoo`2P
Ool001Eoo`03001oogoo00moo`030n1oogoo05aoo`030n1oogoo0:5oo`005Goo00<007ooOol047oo
00<3h7ooOol0FWoo00<3h7ooOol0XWoo000EOol00`00Oomoo`0@Ool00`?POomoo`1JOol00`?POomo
o`2ROol001Eoo`03001oogoo015oo`030n1oogoo05Qoo`030n1oogoo0:=oo`005Goo0P004goo00<3
h7ooOol0EWoo00<3h7ooOol0Y7oo000EOol00`00Oomoo`0BOol00`?POomoo`1EOol00`?POomoo`2U
Ool001Eoo`03001oogoo01=oo`030n1oogoo05Aoo`030n1oogoo0:Eoo`005Goo00<007ooOol04goo
00<3h7ooOol0Dgoo00<3h7ooOol0YWoo000EOol00`00Oomoo`0DOol00`?POomoo`1AOol00`?POomo
o`2WOol001Eoo`8001Eoo`030n1oogoo051oo`030n1oogoo0:Qoo`005Goo00<007ooOol05Goo00<3
h7ooOol0Cgoo00<3h7ooOol0Z7oo000EOol00`00Oomoo`0EOol00`?POomoo`1>Ool00`?POomoo`2Y
Ool001Eoo`03001oogoo01Ioo`030n1oogoo04aoo`030n1oogoo0:Yoo`005Goo00<007ooOol05Woo
00<3h7ooOol0Bgoo00<3h7ooOol0Zgoo000EOol00`00Oomoo`0GOol00`?POomoo`1:Ool00`?POomo
o`2[Ool001Eoo`8001Uoo`030n1oogoo04Qoo`030n1oogoo0:aoo`005Goo00<007ooOol067oo00<3
h7ooOol0Agoo00<3h7ooOol0[Goo000EOol00`00Oomoo`0IOol00`?POomoo`15Ool00`?POomoo`2^
Ool000Moo`D0009oo`8000Eoo`03001oogoo01Uoo`030n1oogoo04Eoo`030n1oogoo0:ioo`002Goo
00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo01Yoo`030n1oogoo04=oo`030n1oogoo
0:moo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`<001Yoo`030n1oogoo049oo`030n1o
ogoo0;1oo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo01]oo`030n1oogoo
041oo`030n1oogoo0;5oo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo01]o
o`030n1oogoo041oo`030n1oogoo0;5oo`0027oo0P0017oo0P001Goo00<007ooOol077oo00<3h7oo
Ool0?Woo00<3h7ooOol0/Woo000EOol00`00Oomoo`0LOol00`?POomoo`0mOol00`?POomoo`2cOol0
01Eoo`03001oogoo01eoo`030n1oogoo03aoo`030n1oogoo0;=oo`005Goo0P007Woo00<3h7ooOol0
>goo00<3h7ooOol0]7oo000EOol00`00Oomoo`0NOol00`?POomoo`0iOol00`?POomoo`2eOol001Eo
o`03001oogoo01ioo`030n1oogoo03Uoo`030n1oogoo0;Eoo`005Goo00<007ooOol07goo00<3h7oo
Ool0=goo00<3h7ooOol0]Woo000EOol00`00Oomoo`0OOol00`?POomoo`0fOol00`?POomoo`2gOol0
01Eoo`80025oo`030n1oogoo03Aoo`030n1oogoo0;Qoo`005Goo00<007ooOol087oo00<3h7ooOol0
=7oo00<3h7ooOol0^7oo000EOol00`00Oomoo`0QOol00`?POomoo`0bOol00`?POomoo`2iOol001Eo
o`03001oogoo025oo`030n1oogoo035oo`030n1oogoo0;Yoo`005Goo00<007ooOol08Woo00<3h7oo
Ool0;goo00<3h7ooOol0^goo000EOol00`00Oomoo`0ROol00`?POomoo`0_Ool00`?POomoo`2kOol0
01Eoo`8002Aoo`030n1oogoo02eoo`030n1oogoo0;aoo`005Goo00<007ooOol08goo00<3h7ooOol0
;7oo00<3h7ooOol0_Goo000EOol00`00Oomoo`0TOol00`?POomoo`0ZOol00`?POomoo`2nOol001Eo
o`03001oogoo02Aoo`030n1oogoo02Yoo`030n1oogoo0;ioo`005Goo00<007ooOol09Goo00<3h7oo
Ool0:7oo00<3h7ooOol0_goo000EOol2000VOol00`?POomoo`0WOol00`?POomoo`30Ool001Eoo`03
001oogoo02Ioo`030n1oogoo02Eoo`030n1oogoo0<5oo`005Goo00<007ooOol09Woo00<3h7ooOol0
9Goo00<3h7ooOol0`Goo000EOol00`00Oomoo`0WOol00`?POomoo`0SOol00`?POomoo`32Ool000Mo
o`D0009oo`8000Eoo`03001oogoo02Moo`030n1oogoo029oo`030n1oogoo0<=oo`002Goo00D007oo
Oomoo`00009oo`03001oogoo009oo`03001oogoo02Qoo`030n1oogoo021oo`030n1oogoo0<Aoo`00
2Goo00<007ooOol017oo00<007ooOol00Woo0`00:7oo00<3h7ooOol087oo00<3h7ooOol0a7oo0009
Ool00`00Oomoo`02Ool20005Ool00`00Oomoo`0YOol00`?POomoo`0NOol00`?POomoo`35Ool000Uo
o`03001oogoo009oo`03001oogoo00Aoo`03001oogoo02Uoo`030n1oogoo01eoo`030n1oogoo0<Io
o`0027oo0P0017oo0`0017oo00<007ooOol0:Woo00<3h7ooOol06goo00<3h7ooOol0agoo000EOol0
0`00Oomoo`0ZOol00`?POomoo`0JOol00`?POomoo`38Ool001Eoo`8002aoo`030n1oogoo01Uoo`03
0n1oogoo0<Qoo`005Goo00<007ooOol0:goo00<3h7ooOol067oo00<3h7ooOol0bGoo000EOol00`00
Oomoo`0/Ool00`?POomoo`0FOol00`?POomoo`3:Ool001Eoo`03001oogoo02aoo`030n1oogoo01Eo
o`030n1oogoo0<]oo`005Goo00<007ooOol0;Goo00<3h7ooOol04goo00<3h7ooOol0c7oo000EOol2
000^Ool00`?POomoo`0COol00`?POomoo`3<Ool001Eoo`03001oogoo02ioo`030n1oogoo015oo`03
0n1oogoo0<eoo`005Goo00<007ooOol0;Woo00<3h7ooOol047oo00<3h7ooOol0cWoo000EOol00`00
Oomoo`0_Ool00`?POomoo`0>Ool00`?POomoo`3?Ool001Eoo`03001oogoo02moo`030n1oogoo00eo
o`030n1oogoo0=1oo`005Goo00<007ooOol0<7oo0`?P2goo00<3h7ooOol0dGoo000EOol2000dOol4
0n07Ool00`?POomoo`3AOol001Eoo`03001oogoo03Moo`@3h09oo`030n1oogoo0=9oo`005Goo00<0
07ooOol0>goo0P?PeGoo000EOol00`00Oomoo`3oOolCOol001Eoo`03001oogoo0?mooa=oo`005Goo
0P00ogoo57oo000EOol00`00Oomoo`3oOolCOol00?moob]oo`00ogoo:goo003oOol[Ool00?moob]o
o`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool0019oo`<00?mooaIoo`004goo
00<007ooOol0ogoo5Goo000COol3003oOolEOol001=oo`04001oogoo003oOolDOol001=oo`04001o
ogoo003oOolDOol0019oo`@00?mooaEoo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo0000
\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.5, 0}} -> {-0.172869, -10.821, \
0.00792472, 0.182473}}],

Cell[BoxData[
    \("Desplazamientos:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.0738166 [
[.2619 .00222 -9 -9 ]
[.2619 .00222 9 0 ]
[.5 .00222 -3 -9 ]
[.5 .00222 3 0 ]
[.7381 .00222 -9 -9 ]
[.7381 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .16235 -6 -4.5 ]
[.01131 .16235 0 4.5 ]
[.01131 .30998 -6 -4.5 ]
[.01131 .30998 0 4.5 ]
[.01131 .45761 -6 -4.5 ]
[.01131 .45761 0 4.5 ]
[.01131 .60525 -6 -4.5 ]
[.01131 .60525 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(0.5)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(1)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(1.5)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(2)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .16235 m
.03006 .16235 L
s
[(2)] .01131 .16235 1 0 Mshowa
.02381 .30998 m
.03006 .30998 L
s
[(4)] .01131 .30998 1 0 Mshowa
.02381 .45761 m
.03006 .45761 L
s
[(6)] .01131 .45761 1 0 Mshowa
.02381 .60525 m
.03006 .60525 L
s
[(8)] .01131 .60525 1 0 Mshowa
.125 Mabswid
.02381 .05162 m
.02756 .05162 L
s
.02381 .08853 m
.02756 .08853 L
s
.02381 .12544 m
.02756 .12544 L
s
.02381 .19926 m
.02756 .19926 L
s
.02381 .23616 m
.02756 .23616 L
s
.02381 .27307 m
.02756 .27307 L
s
.02381 .34689 m
.02756 .34689 L
s
.02381 .3838 m
.02756 .3838 L
s
.02381 .42071 m
.02756 .42071 L
s
.02381 .49452 m
.02756 .49452 L
s
.02381 .53143 m
.02756 .53143 L
s
.02381 .56834 m
.02756 .56834 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.07143 .01975 L
.11905 .04604 L
.16667 .09612 L
.21429 .17025 L
.2619 .26421 L
.30952 .36001 L
.35714 .44179 L
.40476 .50716 L
.45238 .55589 L
.5 .58794 L
.54762 .60332 L
.59524 .59527 L
.64286 .56229 L
.69048 .56073 L
.7381 .57563 L
.78571 .58561 L
.83333 .59199 L
.88095 .59607 L
.92857 .59868 L
.97619 .60035 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^1000`40O003h00Oogoo:goo001;Ool2
0004Ool20004Ool2000cOol5000aOol50002Ool20004Ool2000cOol4000ROol004Yoo`04001oogoo
0008Ool01000Oomoo`00=7oo00<007ooOol0<goo00<007ooOol01goo00@007ooOol0039oo`03001o
ogoo02=oo`00BWoo00@007ooOol000]oo`03001oogoo039oo`03001oogoo03=oo`03001oogoo00Yo
o`03001oogoo035oo`03001oogoo029oo`00BWoo00@007ooOol000Uoo`8003Eoo`03001oogoo03=o
o`03001oogoo00Qoo`8003Eoo`03001oogoo025oo`00BWoo00@007ooOol000Uoo`03001oogoo03Ao
o`03001oogoo03=oo`03001oogoo00Qoo`03001oogoo039oo`04001oogoo000ROol004]oo`8000Yo
o`<003=oo`8003Aoo`8000Yoo`<003=oo`8002=oo`00ogoo:goo000EOol00`00Oomoo`3oOolCOol0
01Eoo`03001oogoo0?mooa=oo`005Goo00<007ooOol0ogoo4goo000EOol00`00Oomoo`3nOol2000B
Ool000moo`H000Ml0?4000Qoo`04001oogoo000AOol001Eoo`03001oogoo00Aoo`Il00]oo`03001o
ogoo00Uoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Uoo`03001o
ogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001o
ogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001o
ogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00aoo`03001oogoo019oo`005Goo
00<007ooOol02Woo0W`0;Woo00<007ooOol0>Goo00<007ooOol0>Goo00<007ooOol0>Goo00<007oo
Ool02goo1@004Goo000EOol00`00Oomoo`0<Ool2O03_Ool00`00Oomoo`0BOol001Eoo`03001oogoo
00ioo`03O01oogoo0?moo`9oo`005Goo00<007ooOol03goo0W`0ogoo0Woo000EOol00`00Oomoo`0A
Ool2O03oOol001Eoo`03001oogoo01=oo`9l0?eoo`005Goo00<007ooOol05Goo00=l07ooOol0nWoo
000EOol2000GOol00g`0Oomoo`3iOol001Eoo`03001oogoo01Moo`03O01oogoo0?Qoo`005Goo00<0
07ooOol067oo00=l07ooOol0mgoo000EOol00`00Oomoo`0IOol00g`0Oomoo`3fOol001Eoo`03001o
ogoo01Yoo`03O01oogoo0?Eoo`005Goo00<007ooOol06goo00=l07ooOol0m7oo000EOol00`00Oomo
o`0KOol00g`0Oomoo`3dOol001Eoo`03001oogoo01aoo`03O01oogoo0?=oo`005Goo00<007ooOol0
7Goo00=l07ooOol0lWoo000EOol00`00Oomoo`0NOol00g`0Oomoo`3aOol001Eoo`80021oo`03O01o
ogoo0?1oo`005Goo00<007ooOol087oo00=l07ooOol0kgoo000EOol00`00Oomoo`0QOol00g`0Oomo
o`3^Ool001Eoo`03001oogoo029oo`03O01oogoo0>eoo`005Goo00<007ooOol08Woo00=l07ooOol0
kGoo000EOol00`00Oomoo`0SOol00g`0Oomoo`3/Ool001Eoo`03001oogoo02Aoo`03O01oogoo0>]o
o`005Goo00<007ooOol097oo00=l07ooOol0jgoo000EOol00`00Oomoo`0UOol00g`0Oomoo`3ZOol0
01Eoo`8002Moo`03O01oogoo0>Uoo`005Goo00<007ooOol09Woo00=l07ooOol0jGoo000EOol00`00
Oomoo`0WOol00g`0Oomoo`3XOol001Eoo`03001oogoo02Qoo`03O01oogoo0>Moo`005Goo00<007oo
Ool0:7oo00=l07ooOol0igoo000EOol00`00Oomoo`0YOol00g`0Oomoo`3VOol001Eoo`03001oogoo
02Yoo`03O01oogoo0>Eoo`003Goo100017oo00<007ooOol0:Woo00=l07ooOol0iGoo000=Ool00`00
Oomoo`05Ool00`00Oomoo`0[Ool00g`0Oomoo`3TOol000ioo`03001oogoo00Aoo`<002aoo`03O01o
ogoo0>=oo`003goo00<007ooOol00goo00<007ooOol0;7oo00=l07ooOol0hgoo000=Ool01000Oomo
o`0017oo00<007ooOol0;Goo00=l07ooOol0hWoo000>Ool20005Ool00`00Oomoo`0^Ool00g`0Oomo
o`3QOol001Eoo`03001oogoo02ioo`03O01oogoo0>5oo`005Goo00<007ooOol0;goo00=l07ooOol0
h7oo000EOol00`00Oomoo`0_Ool00g`0Oomoo`3POol001Eoo`03001oogoo031oo`03O01oogoo0=mo
o`005Goo00<007ooOol0<7oo00=l07ooOol0ggoo000EOol00`00Oomoo`0aOol00g`0Oomoo`3NOol0
01Eoo`80039oo`03O01oogoo0=ioo`005Goo00<007ooOol0<Woo00=l07ooOol0gGoo000EOol00`00
Oomoo`0bOol00g`0Oomoo`3MOol001Eoo`03001oogoo03=oo`03O01oogoo0=aoo`005Goo00<007oo
Ool0<goo00=l07ooOol0g7oo000EOol00`00Oomoo`0dOol00g`0Oomoo`3KOol001Eoo`03001oogoo
03Eoo`03O01oogoo0=Yoo`005Goo00<007ooOol0=Goo00=l07ooOol0fWoo000EOol00`00Oomoo`0f
Ool00g`0Oomoo`3IOol001Eoo`8003Moo`03O01oogoo0=Uoo`005Goo00<007ooOol0=goo00=l07oo
Ool0f7oo000EOol00`00Oomoo`0gOol00g`0Oomoo`3HOol001Eoo`03001oogoo03Qoo`03O01oogoo
0=Moo`005Goo00<007ooOol0>7oo00=l07ooOol0egoo000EOol00`00Oomoo`0iOol00g`0Oomoo`3F
Ool001Eoo`03001oogoo03Uoo`03O01oogoo0=Ioo`005Goo00<007ooOol0>Woo00=l07ooOol0eGoo
000EOol00`00Oomoo`0kOol00g`0Oomoo`3DOol001Eoo`8003aoo`03O01oogoo0=Aoo`005Goo00<0
07ooOol0?7oo00=l07ooOol0dgoo000EOol00`00Oomoo`0lOol00g`0Oomoo`3COol001Eoo`03001o
ogoo03eoo`03O01oogoo0=9oo`005Goo00<007ooOol0?Goo00=l07ooOol0dWoo000EOol00`00Oomo
o`0nOol00g`0Oomoo`3AOol001Eoo`03001oogoo03ioo`03O01oogoo0=5oo`005Goo00<007ooOol0
?goo00=l07ooOol0d7oo000?Ool30003Ool00`00Oomoo`0oOol00g`0Oomoo`3@Ool0011oo`03001o
ogoo009oo`03001oogoo041oo`03O01oogoo0<moo`003Goo1@000goo0`00@7oo00=l07ooOol0cgoo
000=Ool01000Oomoo`0017oo00<007ooOol0@Goo00=l07ooOol0cWoo000>Ool00`00Ool00004Ool0
0`00Oomoo`11Ool00g`0Oomoo`3>Ool000moo`8000Aoo`03001oogoo049oo`03O01oogoo0<eoo`00
5Goo00<007ooOol0@Woo00=l07ooOol0cGoo000EOol00`00Oomoo`13Ool00g`0Oomoo`3<Ool001Eo
o`03001oogoo04=oo`03O01oogoo0<aoo`005Goo00<007ooOol0A7oo00=l07ooOol0bgoo000EOol0
0`00Oomoo`14Ool00g`0Oomoo`3;Ool001Eoo`8004Ioo`03O01oogoo0<Yoo`005Goo00<007ooOol0
AGoo00=l07ooOol0bWoo000EOol00`00Oomoo`16Ool00g`0Oomoo`39Ool001Eoo`03001oogoo04Io
o`03O01oogoo0<Uoo`005Goo00<007ooOol0Agoo00=l07ooOol0b7oo000EOol00`00Oomoo`17Ool0
0g`0Oomoo`38Ool001Eoo`03001oogoo04Qoo`03O01oogoo0<Moo`005Goo00<007ooOol0B7oo00=l
07ooOol0agoo000EOol00`00Oomoo`19Ool00g`0Oomoo`36Ool001Eoo`8004Yoo`03O01oogoo0<Io
o`005Goo00<007ooOol0BWoo00=l07ooOol0aGoo000EOol00`00Oomoo`1;Ool00g`0Oomoo`34Ool0
01Eoo`03001oogoo04]oo`03O01oogoo0<Aoo`005Goo00<007ooOol0C7oo00=l07ooOol0`goo000E
Ool00`00Oomoo`1<Ool00g`0Oomoo`33Ool001Eoo`03001oogoo04eoo`03O01oogoo0<9oo`005Goo
00<007ooOol0CGoo00=l07ooOol0`Woo000EOol00`00Oomoo`1>Ool00g`0Oomoo`31Ool001Eoo`03
001oogoo04moo`03O01oogoo0<1oo`005Goo0P00D7oo00=l07ooOol0`7oo000EOol00`00Oomoo`1@
Ool00g`0Oomoo`2oOol001Eoo`03001oogoo051oo`03O01oogoo0;moo`005Goo00<007ooOol0DGoo
00=l07ooOol0_Woo000EOol00`00Oomoo`1AOol00g`0Oomoo`2nOol001Eoo`03001oogoo059oo`03
O01oogoo0;eoo`005Goo00<007ooOol0Dgoo00=l07ooOol0_7oo000=Ool30005Ool00`00Oomoo`1C
Ool00g`0Oomoo`2lOol000eoo`04001oogoo0004Ool00`00Oomoo`1DOol00g`0Oomoo`2kOol000eo
o`04001oogoo0004Ool3001EOol00g`0Oomoo`2jOol000eoo`<000Eoo`03001oogoo05Ioo`03O01o
ogoo0;Uoo`003Woo00<007ooOol017oo00<007ooOol0EWoo00=l07ooOol0^Goo000>Ool30004Ool0
0`00Oomoo`1GOol00g`0Oomoo`2hOol001Eoo`03001oogoo05Qoo`03O01oogoo0;Moo`005Goo00<0
07ooOol0F7oo00=l07ooOol0]goo000EOol00`00Oomoo`1IOol00g`0Oomoo`2fOol001Eoo`03001o
ogoo05Yoo`03O01oogoo0;Eoo`005Goo00<007ooOol0FWoo00=l07ooOol0]Goo000EOol2001LOol0
0g`0Oomoo`2dOol001Eoo`03001oogoo05aoo`03O01oogoo0;=oo`005Goo00<007ooOol0GGoo00=l
07ooOol0/Woo000EOol00`00Oomoo`1MOol00g`0Oomoo`2bOol001Eoo`03001oogoo05ioo`03O01o
ogoo0;5oo`005Goo00<007ooOol0Ggoo00=l07ooOol0/7oo000EOol00`00Oomoo`1POol00g`0Oomo
o`2_Ool001Eoo`03001oogoo065oo`03O01oogoo0:ioo`005Goo00<007ooOol0HWoo00=l07ooOol0
[Goo000EOol00`00Oomoo`1SOol00g`0Oomoo`2/Ool001Eoo`8006Eoo`03O01oogoo0:]oo`005Goo
00<007ooOol0IGoo00=l07ooOol0ZWoo000EOol00`00Oomoo`1VOol00g`0Oomoo`2YOol001Eoo`03
001oogoo06Moo`03O01oogoo0:Qoo`005Goo00<007ooOol0J7oo00=l07ooOol0Ygoo000EOol00`00
Oomoo`1YOol00g`0Oomoo`2VOol001Eoo`03001oogoo06Yoo`03O01oogoo0:Eoo`005Goo00<007oo
Ool0Jgoo0W`0<goo27`0JWoo000EOol00`00Oomoo`1]Ool00g`0Oomoo`0ZOol6O008Ool3O01WOol0
01Eoo`8006moo`9l02Qoo`9l015oo`=l06Aoo`005Goo00<007ooOol0L7oo00=l07ooOol097oo00=l
07ooOol057oo0g`0HGoo000EOol00`00Oomoo`1aOol2O00ROol2O00JOol5O01LOol001Eoo`03001o
ogoo07=oo`03O01oogoo01ioo`03O01oogoo01moo`Il05Ioo`005Goo00<007ooOol0M7oo0W`077oo
0W`0:7oo1W`0D7oo000EOol00`00Oomoo`1fOol2O00IOol00g`0Oomoo`0^Ool6O01:Ool001Eoo`03
001oogoo07Qoo`=l01Aoo`9l03Moo`Ul045oo`003Woo0P001Goo00<007ooOol0Ngoo0g`03Goo17`0
@Woo37`0=Goo000=Ool01000Oomoo`0017oo00<007ooOol0OWoo0g`017oo1W`0DWoo4W`08goo000=
Ool01000Oomoo`0017oo0`00PGoo17`0SGoo000>Ool20005Ool00`00Oomoo`3oOolCOol000eoo`04
001oogoo0004Ool00`00Oomoo`3oOolCOol000ioo`8000Eoo`03001oogoo0?mooa=oo`005Goo00<0
07ooOol0ogoo4goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo
003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool001Aoo`@00?mooa=oo`004goo00@007ooOol0
0?mooaAoo`004goo00@007ooOol00?mooaAoo`004Woo0P0000=oo`000000ogoo57oo003oOol[Ool0
0?moob]oo`00ogoo:goo003oOol[Ool00001\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.5, 0}} -> {-0.181428, -0.651604, \
0.00830689, 0.0535876}}],

Cell[BoxData[
    InterpretationBox[\("M\[AAcute]ximo Desplazamiento: \
"\[InvisibleSpace]7.973865784744757`\),
      SequenceForm[ "M\[AAcute]ximo Desplazamiento: ", 7.9738657847447572],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[IAcute]nimo Desplazamiento: "\[InvisibleSpace]0\),
      
      SequenceForm[ "M\[IAcute]nimo Desplazamiento: ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Velocidades:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.177891 0.0554976 [
[.2619 .16539 -9 -9 ]
[.2619 .16539 9 0 ]
[.5 .16539 -3 -9 ]
[.5 .16539 3 0 ]
[.7381 .16539 -9 -9 ]
[.7381 .16539 9 0 ]
[.97619 .16539 -3 -9 ]
[.97619 .16539 3 0 ]
[1.025 .17789 0 -6.25 ]
[1.025 .17789 10 6.25 ]
[.01131 .0669 -12 -4.5 ]
[.01131 .0669 0 4.5 ]
[.01131 .28889 -6 -4.5 ]
[.01131 .28889 0 4.5 ]
[.01131 .39988 -6 -4.5 ]
[.01131 .39988 0 4.5 ]
[.01131 .51088 -6 -4.5 ]
[.01131 .51088 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .17789 m
.2619 .18414 L
s
[(0.5)] .2619 .16539 0 1 Mshowa
.5 .17789 m
.5 .18414 L
s
[(1)] .5 .16539 0 1 Mshowa
.7381 .17789 m
.7381 .18414 L
s
[(1.5)] .7381 .16539 0 1 Mshowa
.97619 .17789 m
.97619 .18414 L
s
[(2)] .97619 .16539 0 1 Mshowa
.125 Mabswid
.07143 .17789 m
.07143 .18164 L
s
.11905 .17789 m
.11905 .18164 L
s
.16667 .17789 m
.16667 .18164 L
s
.21429 .17789 m
.21429 .18164 L
s
.30952 .17789 m
.30952 .18164 L
s
.35714 .17789 m
.35714 .18164 L
s
.40476 .17789 m
.40476 .18164 L
s
.45238 .17789 m
.45238 .18164 L
s
.54762 .17789 m
.54762 .18164 L
s
.59524 .17789 m
.59524 .18164 L
s
.64286 .17789 m
.64286 .18164 L
s
.69048 .17789 m
.69048 .18164 L
s
.78571 .17789 m
.78571 .18164 L
s
.83333 .17789 m
.83333 .18164 L
s
.88095 .17789 m
.88095 .18164 L
s
.92857 .17789 m
.92857 .18164 L
s
.25 Mabswid
0 .17789 m
1 .17789 L
s
gsave
1.025 .17789 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .0669 m
.03006 .0669 L
s
[(-2)] .01131 .0669 1 0 Mshowa
.02381 .28889 m
.03006 .28889 L
s
[(2)] .01131 .28889 1 0 Mshowa
.02381 .39988 m
.03006 .39988 L
s
[(4)] .01131 .39988 1 0 Mshowa
.02381 .51088 m
.03006 .51088 L
s
[(6)] .01131 .51088 1 0 Mshowa
.125 Mabswid
.02381 .09464 m
.02756 .09464 L
s
.02381 .12239 m
.02756 .12239 L
s
.02381 .15014 m
.02756 .15014 L
s
.02381 .20564 m
.02756 .20564 L
s
.02381 .23339 m
.02756 .23339 L
s
.02381 .26114 m
.02756 .26114 L
s
.02381 .31664 m
.02756 .31664 L
s
.02381 .34438 m
.02756 .34438 L
s
.02381 .37213 m
.02756 .37213 L
s
.02381 .42763 m
.02756 .42763 L
s
.02381 .45538 m
.02756 .45538 L
s
.02381 .48313 m
.02756 .48313 L
s
.02381 .53863 m
.02756 .53863 L
s
.02381 .56637 m
.02756 .56637 L
s
.02381 .59412 m
.02756 .59412 L
s
.02381 .03915 m
.02756 .03915 L
s
.02381 .0114 m
.02756 .0114 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 1 r
.5 Mabswid
.02381 .17789 m
.07143 .25903 L
.11905 .36057 L
.16667 .46422 L
.21429 .56809 L
.2619 .60332 L
.30952 .55264 L
.35714 .48292 L
.40476 .41122 L
.45238 .33932 L
.5 .26739 L
.54762 .19547 L
.59524 .01472 L
.64286 .12536 L
.69048 .21666 L
.7381 .20574 L
.78571 .19564 L
.83333 .18925 L
.88095 .18516 L
.92857 .18254 L
.97619 .18087 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^1000`40O003h00O4Woo00<007ooOol0
ogoo5Woo000BOol00`00Oomoo`3oOolFOol0019oo`03001oogoo0?mooaIoo`004Woo0P00ogoo5goo
000BOol00`00Oomoo`2EOol00g`OOomoo`1mOol0019oo`03001oogoo09Eoo`03O1moogoo07eoo`00
4Woo00<007ooOol0U7oo00=l7gooO1l0OWoo000BOol00`00Oomoo`2DOol00g`OOoml7`1nOol0019o
o`03001oogoo09Aoo`04O1moogooO1mmOol0019oo`03001oogoo09Aoo`04O1moogooO1mmOol0019o
o`8009Aoo`05O1moogooOoml7`1mOol0019oo`03001oogoo09=oo`03O1moogoo009oo`03O1moogoo
07Yoo`004Woo00<007ooOol0Tgoo00=l7gooOol00Woo00=l7gooOol0NWoo000BOol00`00Oomoo`2C
Ool00g`OOomoo`03Ool00g`OOomoo`1iOol0019oo`03001oogoo099oo`03O1moogoo00Aoo`03O1mo
ogoo07Uoo`004Woo00<007ooOol0TWoo00=l7gooOol01Goo00=l7gooOol0N7oo000:Ool40004Ool0
0`00Oomoo`2BOol00g`OOomoo`05Ool00g`OOomoo`1hOol000Yoo`03001oogoo00Eoo`03001oogoo
095oo`03O1moogoo00Ioo`03O1moogoo07Qoo`002goo00<007ooOol017oo0`00TGoo00=l7gooOol0
1goo00=l7gooOol0Mgoo0004Ool40004Ool00`00Oomoo`03Ool00`00Oomoo`2AOol00g`OOomoo`07
Ool00g`OOomoo`1gOol000Yoo`04001oogoo0004Ool00`00Oomoo`2AOol00g`OOomoo`08Ool00g`O
Oomoo`1fOol000]oo`8000Eoo`03001oogoo091oo`03O1moogoo00Uoo`03O1moogoo07Ioo`004Woo
00<007ooOol0T7oo00=l7gooOol02Goo00=l7gooOol0MWoo000BOol00`00Oomoo`2@Ool00g`OOomo
o`0:Ool00g`OOomoo`1eOol0019oo`03001oogoo091oo`03O1moogoo00Yoo`03O1moogoo07Eoo`00
4Woo0P00T7oo00=l7gooOol037oo00=l7gooOol0M7oo000BOol00`00Oomoo`2?Ool00g`OOomoo`0<
Ool00g`OOomoo`1dOol0019oo`03001oogoo08moo`03O1moogoo00eoo`03O1moogoo07=oo`004Woo
00<007ooOol0Sgoo00=l7gooOol03Goo00=l7gooOol0Lgoo000BOol00`00Oomoo`2>Ool00g`OOomo
o`0>Ool00g`OOomoo`1cOol0019oo`03001oogoo08ioo`03O1moogoo00moo`03O1moogoo079oo`00
4Woo00<007ooOol0SWoo00=l7gooOol03goo00=l7gooOol0LWoo000BOol00`00Oomoo`2=Ool00g`O
Oomoo`0AOol00g`OOomoo`1aOol0019oo`8008ioo`03O1moogoo015oo`03O1moogoo075oo`004Woo
00<007ooOol0SGoo00=l7gooOol04Woo00=l7gooOol0L7oo000BOol00`00Oomoo`2=Ool00g`OOomo
o`0BOol00g`OOomoo`1`Ool0019oo`03001oogoo03Eoo`8000Aoo`8000Aoo`8003Ioo`D000ioo`03
O1moogoo01Aoo`03O1moogoo00eoo`D0009oo`8000Aoo`8003Ioo`@001Uoo`004Woo00<007ooOol0
=7oo00@007ooOol000Qoo`04001oogoo000gOol00`00Oomoo`0>Ool00g`OOomoo`0DOol00g`OOomo
o`0?Ool00`00Oomoo`07Ool01000Oomoo`00=Goo00<007ooOol06Woo000BOol00`00Oomoo`0dOol0
1000Oomoo`002goo00<007ooOol0=Goo00<007ooOol03Woo00=l7gooOol05Goo00=l7gooOol03Woo
00<007ooOol02Woo00<007ooOol0=7oo00<007ooOol06Goo000BOol00`00Oomoo`0dOol01000Oomo
o`002Goo0P00>7oo00<007ooOol03Woo00=l7gooOol05Goo00=l7gooOol03Woo00<007ooOol027oo
0P00>7oo00<007ooOol067oo000BOol2000eOol01000Oomoo`002Goo00<007ooOol0=goo00<007oo
Ool03Goo00=l7gooOol05goo00=l7gooOol03Goo00<007ooOol027oo00<007ooOol0=Goo00@007oo
Ool001Uoo`004Woo00<007ooOol0=Goo0P002Woo0`00=Woo0P003goo00=l7gooOol05goo00=l7goo
Ool037oo0P002Woo0`00=Woo0P006Woo000BOol00`00Oomoo`2;Ool00g`OOomoo`0HOol00g`OOomo
o`1/Ool0019oo`03001oogoo08Yoo`03O1moogoo01Uoo`03O1moogoo06aoo`004Woo00<007ooOol0
RWoo00=l7gooOol06Woo00=l7gooOol0Jgoo000BOol00`00Oomoo`2:Ool00g`OOomoo`0JOol00g`O
Oomoo`1[Ool0019oo`03001oogoo08Yoo`03O1moogoo01]oo`03O1moogoo061oo`8000Qoo`0037oo
1P0000=l7`000000R@0000=l7`000000700000=l7`000000EP002Goo00@007ooOol000Moo`004Woo
00<007`OOol02Woo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol02Goo
00<007ooOol02Woo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol02Goo
00<007ooOol02Woo00<007`OOol02Woo00<007ooOol02Goo00<007ooOol01Goo00=l7gooOol00Woo
00<007ooOol02Woo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol02Goo
00<007ooOol017oo1g`O3goo00<007ooOol027oo000BOol00`00O1moo`0lOol00`00Oomoo`0lOol0
0`00Oomoo`0;Ool00g`OOomoo`0MOol00g`OOomoo`0?Ool00`00Oomoo`0MOolIO1l6Ool00`00Oomo
o`0<Ool50007Ool0019oo`03001oog`O08Uoo`03O1moogoo01ioo`03O1moogoo02Aoo`Yl7bmoo`03
001oogoo00Qoo`004Woo00<007ooO1l0R7oo00=l7gooOol07goo00=l7gooOol07Woo1W`OA7oo000B
Ool01000Oomoog`OQgoo00=l7gooOol087oo00=l7gooOol05goo1W`OBWoo000BOol01@00Oomoogoo
O1l0QGoo00=l7gooOol08Goo00=l7gooOol04goo17`OD7oo000BOol01@00OomoogooO1l0QGoo00=l
7gooOol08Woo00=l7gooOol03Woo17`OE7oo000BOol20003Ool00g`OOomoo`21Ool00g`OOomoo`0S
Ool00g`OOomoo`0:Ool4O1mHOol0019oo`03001oogoo009oo`03O1moogoo081oo`03O1moogoo02Eo
o`03O1moogoo00Eoo`Al7eaoo`004Woo00<007ooOol00goo00=l7gooOol0Ogoo00=l7gooOol09Goo
00Al7gooOomoo`Al7f1oo`004Woo00<007ooOol00goo00=l7gooOol0OWoo00=l7gooOol09goo0g`O
I7oo000BOol00`00Oomoo`04Ool00g`OOomoo`1lOol00g`OOomoo`2?Ool0019oo`03001oogoo00Eo
o`03O1moogoo07]oo`03O1moogoo08moo`004Woo00<007ooOol01Goo00=l7gooOol0NWoo00=l7goo
Ool0T7oo000BOol20007Ool00g`OOomoo`1hOol00g`OOomoo`2AOol0019oo`03001oogoo00Ioo`03
O1moogoo07Moo`03O1moogoo099oo`004Woo00<007ooOol01goo00=l7gooOol0MWoo00=l7gooOol0
TWoo000BOol00`00Oomoo`08Ool00g`OOomoo`1dOol00g`OOomoo`2COol0019oo`03001oogoo00Qo
o`03O1moogoo07=oo`03O1moogoo09Aoo`004Woo00<007ooOol02Goo00=l7gooOol0LWoo00=l7goo
Ool0U7oo000BOol00`00Oomoo`09Ool00g`OOomoo`1aOol00g`OOomoo`2EOol0019oo`8000]oo`03
O1moogoo06moo`03O1moogoo09Ioo`004Woo00<007ooOol02Woo00=l7gooOol0Kgoo00=l7gooOol0
UWoo000BOol00`00Oomoo`0;Ool00g`OOomoo`1]Ool00g`OOomoo`2GOol0019oo`03001oogoo00]o
o`03O1moogoo06aoo`03O1moogoo09Qoo`004Woo00<007ooOol037oo00=l7gooOol0Jgoo00=l7goo
Ool0V7oo000BOol00`00Oomoo`0<Ool00g`OOomoo`1ZOol00g`OOomoo`2IOol000Yoo`@000Aoo`03
001oogoo00eoo`03O1moogoo06Qoo`03O1moogoo09Yoo`002Woo00<007ooOol01Goo00<007ooOol0
3Goo00=l7gooOol0J7oo00=l7gooOol0VWoo000;Ool00`00Oomoo`04Ool3000>Ool00g`OOomoo`1V
Ool00g`OOomoo`2KOol000aoo`03001oogoo00=oo`03001oogoo00ioo`03O1moogoo06Ioo`03O1mo
ogoo09]oo`002Woo00@007ooOol000Aoo`03001oogoo00ioo`03O1moogoo06Eoo`03O1moogoo09ao
o`002goo0P001Goo00<007ooOol03goo00=l7gooOol0Hgoo00=l7gooOol0WGoo000BOol00`00Oomo
o`0?Ool00g`OOomoo`1SOol00g`OOomoo`2MOol0019oo`03001oogoo011oo`03O1moogoo065oo`03
O1moogoo09ioo`004Woo00<007ooOol047oo00=l7gooOol0H7oo00=l7gooOol0Wgoo000BOol2000B
Ool00g`OOomoo`1OOol00g`OOomoo`2OOol0019oo`03001oogoo015oo`03O1moogoo05ioo`03O1mo
ogoo0:1oo`004Woo00<007ooOol04Woo00=l7gooOol0GGoo00=l7gooOol0X7oo000BOol00`00Oomo
o`0BOol00g`OOomoo`1LOol00g`OOomoo`2QOol0019oo`03001oogoo019oo`03O1moogoo05]oo`03
O1moogoo0:9oo`004Woo00<007ooOol04goo00=l7gooOol0FWoo00=l7gooOol0XWoo000BOol00`00
Oomoo`0COol00g`OOomoo`1IOol00g`OOomoo`2SOol0019oo`03001oogoo01Aoo`03O1moogoo05Mo
o`03O1moogoo0:Aoo`004Woo0P005Goo00=l7gooOol0Egoo00=l7gooOol0Y7oo000BOol00`00Oomo
o`0EOol00g`OOomoo`1EOol00g`OOomoo`2UOol0019oo`03001oogoo01Eoo`03O1moogoo05Aoo`03
O1moogoo0:Ioo`004Woo00<007ooOol05Woo00=l7gooOol0Dgoo00=l7gooOol0YWoo000BOol00`00
Oomoo`0FOol00g`OOomoo`1BOol00g`OOomoo`2WOol0019oo`03001oogoo01Ioo`03O1moogoo055o
o`03O1moogoo0:Qoo`004Woo00<007ooOol05goo00=l7gooOol0D7oo00=l7gooOol0Z7oo000BOol2
000HOol00g`OOomoo`1?Ool00g`OOomoo`2YOol0019oo`03001oogoo01Qoo`03O1moogoo04eoo`03
O1moogoo0:Yoo`004Woo00<007ooOol067oo00=l7gooOol0C7oo00=l7gooOol0Zgoo000BOol00`00
Oomoo`0IOol00g`OOomoo`1;Ool00g`OOomoo`2[Ool0019oo`03001oogoo01Uoo`03O1moogoo04Yo
o`03O1moogoo0:aoo`0037oo0`000goo00<007ooOol06Woo00=l7gooOol0B7oo00=l7gooOol0[Goo
000=Ool00`00Oomoo`02Ool00`00Oomoo`0JOol00g`OOomoo`18Ool00g`OOomoo`2]Ool000Yoo`D0
00=oo`<001]oo`03O1moogoo04Ioo`03O1moogoo0:ioo`002Woo00@007ooOol000Aoo`03001oogoo
01]oo`03O1moogoo04Eoo`03O1moogoo0:moo`002goo00<007oo000017oo00<007ooOol077oo00=l
7gooOol0A7oo00=l7gooOol0[goo000<Ool20004Ool00`00Oomoo`0LOol00g`OOomoo`13Ool00g`O
Oomoo`2`Ool0019oo`03001oogoo01eoo`03O1moogoo045oo`03O1moogoo0;5oo`004Woo00<007oo
Ool07Goo00=l7gooOol0@Goo00=l7gooOol0/Goo000BOol00`00Oomoo`0NOol00g`OOomoo`0oOol0
0g`OOomoo`2bOol0019oo`03001oogoo01ioo`03O1moogoo03ioo`03O1moogoo0;=oo`004Woo0P00
87oo00=l7gooOol0?Goo00=l7gooOol0/goo000BOol00`00Oomoo`0OOol00g`OOomoo`0lOol00g`O
Oomoo`2dOol0019oo`03001oogoo021oo`03O1moogoo03Yoo`03O1moogoo0;Eoo`004Woo00<007oo
Ool087oo00=l7gooOol0>Woo00=l7gooOol0]Goo000BOol00`00Oomoo`0QOol00g`OOomoo`0hOol0
0g`OOomoo`2fOol0019oo`03001oogoo025oo`03O1moogoo03Moo`03O1moogoo0;Moo`004Woo00<0
07ooOol08Woo00=l7gooOol0=Goo00=l7gooOol0^7oo000BOol2000SOol00g`OOomoo`0eOol00g`O
Oomoo`2hOol0019oo`03001oogoo02=oo`03O1moogoo03=oo`03O1moogoo0;Uoo`004Woo00<007oo
Ool08goo00=l7gooOol0<Woo00=l7gooOol0^Woo000BOol00`00Oomoo`0SOol00g`OOomoo`0bOol0
0g`OOomoo`2jOol0019oo`03001oogoo02Aoo`03O1moogoo031oo`03O1moogoo0;]oo`004Woo00<0
07ooOol097oo00=l7gooOol0;goo00=l7gooOol0_7oo000BOol00`00Oomoo`0UOol00g`OOomoo`0^
Ool00g`OOomoo`2lOol0019oo`8002Ioo`03O1moogoo02eoo`03O1moogoo0;eoo`004Woo00<007oo
Ool09Woo00=l7gooOol0:goo00=l7gooOol0_Woo000BOol00`00Oomoo`0VOol00g`OOomoo`0[Ool0
0g`OOomoo`2nOol0019oo`03001oogoo02Moo`03O1moogoo02Uoo`03O1moogoo0;moo`004Woo00<0
07ooOol09goo00=l7gooOol0:7oo00=l7gooOol0`7oo000BOol00`00Oomoo`0XOol00g`OOomoo`0W
Ool00g`OOomoo`30Ool000Yoo`<000Eoo`03001oogoo02Qoo`03O1moogoo02Ioo`03O1moogoo0<5o
o`002Woo00@007ooOol000Aoo`03001oogoo02Uoo`03O1moogoo02Eoo`03O1moogoo0<5oo`002Woo
00@007ooOol000Aoo`<002Uoo`03O1moogoo02Aoo`03O1moogoo0<9oo`002Woo0`001Goo00<007oo
Ool0:Goo00=l7gooOol08goo00=l7gooOol0`goo000;Ool00`00Oomoo`04Ool00`00Oomoo`0ZOol0
0g`OOomoo`0ROol00g`OOomoo`33Ool000]oo`<000Aoo`03001oogoo02Yoo`03O1moogoo025oo`03
O1moogoo0<Aoo`004Woo00<007ooOol0:goo00=l7gooOol07goo00=l7gooOol0aGoo000BOol00`00
Oomoo`0[Ool00g`OOomoo`0OOol00g`OOomoo`35Ool0019oo`03001oogoo02aoo`03O1moogoo01eo
o`03O1moogoo0<Ioo`004Woo0P00;Goo00=l7gooOol07Goo00=l7gooOol0aWoo000BOol00`00Oomo
o`0]Ool00g`OOomoo`0KOol00g`OOomoo`37Ool0019oo`03001oogoo02eoo`03O1moogoo01Yoo`03
O1moogoo0<Qoo`004Woo00<007ooOol0;Woo00=l7gooOol06Goo00=l7gooOol0b7oo000BOol00`00
Oomoo`0^Ool00g`OOomoo`0HOol00g`OOomoo`39Ool0019oo`03001oogoo02moo`03O1moogoo01Io
o`03O1moogoo0<Yoo`004Woo00<007ooOol0;goo00=l7gooOol05Goo00=l7gooOol0bgoo000BOol0
0`00Oomoo`0`Ool00g`OOomoo`0COol00g`OOomoo`3<Ool0019oo`80035oo`03O1moogoo019oo`03
O1moogoo0<eoo`004Woo00<007ooOol0<Goo0W`O4Goo00=l7gooOol0cWoo000BOol00`00Oomoo`0c
Ool00g`OOomoo`0=Ool00g`OOomoo`3?Ool0019oo`03001oogoo03Aoo`03O1moogoo00]oo`03O1mo
ogoo0=1oo`004Woo00<007ooOol0=Goo00=l7gooOol02Goo00=l7gooOol0dGoo000BOol00`00Oomo
o`0fOol2O1l8Ool00g`OOomoo`3BOol0019oo`03001oogoo03Qoo`03O1moogoo00Aoo`03O1moogoo
0==oo`004Woo0P00>Woo00=l7gooOol00Woo00=l7gooOol0e7oo000BOol00`00Oomoo`0jOol2O1l0
0gooO1moo`3FOol0019oo`03001oogoo03aoo`03O1moogoo0=Ioo`004Woo00<007ooOol0ogoo5Woo
000BOol00`00Oomoo`3oOolFOol0019oo`03001oogoo0?mooaIoo`004Woo00<007ooOol0ogoo5Woo
003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00?mo
ob]oo`00ogoo:goo003oOol[Ool00?moob]oo`004Goo0P00ogoo67oo000AOol2003oOolHOol0011o
o`04001oogoo003oOolGOol000moo`80009oo`800?mooaIoo`00ogoo:goo003oOol[Ool00?moob]o
o`00ogoo:goo0000\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.5, 0}} -> {-0.144935, -3.20544, \
0.00789695, 0.0677587}}],

Cell[BoxData[
    InterpretationBox[\("M\[AAcute]xima Velocidad: \
"\[InvisibleSpace]7.665695027899351`\),
      SequenceForm[ "M\[AAcute]xima Velocidad: ", 7.6656950278993508],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[IAcute]nima Velocidad: \
"\[InvisibleSpace]\(-2.9402405491037493`\)\),
      SequenceForm[ "M\[IAcute]nima Velocidad: ", -2.9402405491037493],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Aceleraciones:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.205515 0.00486278 [
[.2619 .19302 -9 -9 ]
[.2619 .19302 9 0 ]
[.5 .19302 -3 -9 ]
[.5 .19302 3 0 ]
[.7381 .19302 -9 -9 ]
[.7381 .19302 9 0 ]
[.97619 .19302 -3 -9 ]
[.97619 .19302 3 0 ]
[1.025 .20552 0 -6.25 ]
[1.025 .20552 10 6.25 ]
[.01131 .011 -18 -4.5 ]
[.01131 .011 0 4.5 ]
[.01131 .10826 -18 -4.5 ]
[.01131 .10826 0 4.5 ]
[.01131 .30277 -12 -4.5 ]
[.01131 .30277 0 4.5 ]
[.01131 .40003 -12 -4.5 ]
[.01131 .40003 0 4.5 ]
[.01131 .49728 -12 -4.5 ]
[.01131 .49728 0 4.5 ]
[.01131 .59454 -12 -4.5 ]
[.01131 .59454 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .20552 m
.2619 .21177 L
s
[(0.5)] .2619 .19302 0 1 Mshowa
.5 .20552 m
.5 .21177 L
s
[(1)] .5 .19302 0 1 Mshowa
.7381 .20552 m
.7381 .21177 L
s
[(1.5)] .7381 .19302 0 1 Mshowa
.97619 .20552 m
.97619 .21177 L
s
[(2)] .97619 .19302 0 1 Mshowa
.125 Mabswid
.07143 .20552 m
.07143 .20927 L
s
.11905 .20552 m
.11905 .20927 L
s
.16667 .20552 m
.16667 .20927 L
s
.21429 .20552 m
.21429 .20927 L
s
.30952 .20552 m
.30952 .20927 L
s
.35714 .20552 m
.35714 .20927 L
s
.40476 .20552 m
.40476 .20927 L
s
.45238 .20552 m
.45238 .20927 L
s
.54762 .20552 m
.54762 .20927 L
s
.59524 .20552 m
.59524 .20927 L
s
.64286 .20552 m
.64286 .20927 L
s
.69048 .20552 m
.69048 .20927 L
s
.78571 .20552 m
.78571 .20927 L
s
.83333 .20552 m
.83333 .20927 L
s
.88095 .20552 m
.88095 .20927 L
s
.92857 .20552 m
.92857 .20927 L
s
.25 Mabswid
0 .20552 m
1 .20552 L
s
gsave
1.025 .20552 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .011 m
.03006 .011 L
s
[(-40)] .01131 .011 1 0 Mshowa
.02381 .10826 m
.03006 .10826 L
s
[(-20)] .01131 .10826 1 0 Mshowa
.02381 .30277 m
.03006 .30277 L
s
[(20)] .01131 .30277 1 0 Mshowa
.02381 .40003 m
.03006 .40003 L
s
[(40)] .01131 .40003 1 0 Mshowa
.02381 .49728 m
.03006 .49728 L
s
[(60)] .01131 .49728 1 0 Mshowa
.02381 .59454 m
.03006 .59454 L
s
[(80)] .01131 .59454 1 0 Mshowa
.125 Mabswid
.02381 .03532 m
.02756 .03532 L
s
.02381 .05963 m
.02756 .05963 L
s
.02381 .08395 m
.02756 .08395 L
s
.02381 .13257 m
.02756 .13257 L
s
.02381 .15689 m
.02756 .15689 L
s
.02381 .1812 m
.02756 .1812 L
s
.02381 .22983 m
.02756 .22983 L
s
.02381 .25414 m
.02756 .25414 L
s
.02381 .27846 m
.02756 .27846 L
s
.02381 .32709 m
.02756 .32709 L
s
.02381 .3514 m
.02756 .3514 L
s
.02381 .37571 m
.02756 .37571 L
s
.02381 .42434 m
.02756 .42434 L
s
.02381 .44865 m
.02756 .44865 L
s
.02381 .47297 m
.02756 .47297 L
s
.02381 .5216 m
.02756 .5216 L
s
.02381 .54591 m
.02756 .54591 L
s
.02381 .57022 m
.02756 .57022 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .20552 m
.07143 .30384 L
.11905 .39971 L
.16667 .49533 L
.21429 .59092 L
.2619 .60332 L
.30952 .53459 L
.35714 .46815 L
.40476 .40194 L
.45238 .33576 L
.5 .26958 L
.54762 .20341 L
.59524 .01472 L
.64286 .25716 L
.69048 .37409 L
.7381 .31479 L
.78571 .27541 L
.83333 .25025 L
.88095 .23414 L
.92857 .22384 L
.97619 .21724 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^1000`40O003h00Oogoo:goo003oOol[
Ool000Yoo`<0009oo`8000Eoo`03001oogoo0?mooa9oo`002goo00@007ooOol0009oo`03001oogoo
009oo`03001oogoo0?mooa9oo`0027oo1@0000Eoo`00Oomoo`0000Aoo`<00?mooa9oo`000Woo1000
0Woo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`2DOol00`0OOomoo`1jOol000Uoo`03
001oo`00009oo`04001oogoo0004Ool00`00Oomoo`2DOol00`0OOomoo`1jOol000Yoo`8000=oo`80
00Eoo`03001oogoo09=oo`807gaoo`005Woo00<007ooOol0Tgoo00<07goo01l0Ngoo000FOol00`00
Oomoo`2COol00`0OOol07`1kOol001Ioo`03001oogoo09=oo`0301moo`0O07]oo`005Woo0P00Tgoo
00@07gooOol07g]oo`005Woo00<007ooOol0TWoo00@07gooOol07g]oo`005Woo00<007ooOol0TWoo
00D07gooOomoo`0O07Yoo`005Woo00<007ooOol0TWoo00D07gooOomoo`0O07Yoo`005Woo00<007oo
Ool0TGoo00<07gooOol00Woo00<07gooOol0N7oo000FOol00`00Oomoo`2AOol00`0OOomoo`02Ool0
0`0OOomoo`1hOol001Ioo`80099oo`0301moogoo009oo`0301moogoo07Qoo`005Woo00<007ooOol0
TGoo00<07gooOol00Woo00<07gooOol0N7oo000FOol00`00Oomoo`2@Ool00`0OOomoo`04Ool00`0O
Oomoo`1gOol001Ioo`03001oogoo091oo`0301moogoo00Aoo`0301moogoo07Moo`005Woo00<007oo
Ool0T7oo00<07gooOol017oo00<07gooOol0Mgoo000FOol00`00Oomoo`2@Ool00`0OOomoo`04Ool0
0`0OOomoo`1gOol001Ioo`03001oogoo08moo`0301moogoo00Eoo`0301moogoo07Moo`005Woo0P00
T7oo00<07gooOol01Woo00<07gooOol0MWoo000FOol00`00Oomoo`2?Ool00`0OOomoo`06Ool00`0O
Oomoo`1fOol001Ioo`03001oogoo08moo`0301moogoo00Ioo`0301moogoo07Ioo`005Woo00<007oo
Ool0SWoo00<07gooOol01goo00<07gooOol0MWoo0008Ool40003Ool20005Ool00`00Oomoo`2>Ool0
0`0OOomoo`07Ool00`0OOomoo`1fOol000Qoo`03001oogoo00=oo`04001oogoo0004Ool00`00Oomo
o`2>Ool00`0OOomoo`08Ool00`0OOomoo`1eOol000Uoo`03001oogoo009oo`04001oogoo0004Ool3
002>Ool00`0OOomoo`08Ool00`0OOomoo`1eOol0009oo`@000Aoo`05001oogooOol00002Ool00`00
Oomoo`02Ool00`00Oomoo`2=Ool00`0OOomoo`09Ool00`0OOomoo`1eOol000Qoo`04001oogoo0002
Ool01000Oomoo`0017oo00<007ooOol0SGoo00<07gooOol02Goo00<07gooOol0MGoo0009Ool20004
Ool20005Ool00`00Oomoo`2=Ool00`0OOomoo`09Ool00`0OOomoo`1eOol001Ioo`03001oogoo08ao
o`0301moogoo00Yoo`0301moogoo07Eoo`005Woo00<007ooOol0S7oo00<07gooOol02goo00<07goo
Ool0M7oo000FOol00`00Oomoo`2<Ool00`0OOomoo`0;Ool00`0OOomoo`1dOol001Ioo`8008eoo`03
01moogoo00]oo`0301moogoo07Aoo`005Woo00<007ooOol0Rgoo00<07gooOol037oo00<07gooOol0
M7oo000FOol00`00Oomoo`2;Ool00`0OOomoo`0<Ool00`0OOomoo`1dOol001Ioo`03001oogoo08]o
o`0301moogoo00eoo`0301moogoo07=oo`005Woo00<007ooOol0Rgoo00<07gooOol03Goo00<07goo
Ool0Lgoo000FOol00`00Oomoo`2:Ool00`0OOomoo`0>Ool00`0OOomoo`1cOol001Ioo`8008]oo`03
01moogoo00ioo`0301moogoo07=oo`005Woo00<007ooOol0=Goo0P0017oo0P0017oo0P00=Woo1@00
37oo00<07gooOol03Woo00<07gooOol04goo1@000Woo0P0017oo0P00=Woo10005goo000FOol00`00
Oomoo`0dOol01000Oomoo`0027oo00@007ooOol003Moo`03001oogoo00aoo`0301moogoo00moo`03
01moogoo01Aoo`03001oogoo00Moo`04001oogoo000eOol00`00Oomoo`0HOol001Ioo`03001oogoo
03Aoo`04001oogoo000;Ool00`00Oomoo`0eOol00`00Oomoo`0;Ool00`0OOomoo`0@Ool00`0OOomo
o`0DOol00`00Oomoo`0:Ool00`00Oomoo`0dOol00`00Oomoo`0GOol001Ioo`03001oogoo03Aoo`04
001oogoo0009Ool2000hOol00`00Oomoo`0;Ool00`0OOomoo`0@Ool00`0OOomoo`0DOol00`00Oomo
o`08Ool2000hOol00`00Oomoo`0FOol001Ioo`03001oogoo03Aoo`04001oogoo0009Ool00`00Oomo
o`0gOol00`00Oomoo`0;Ool00`0OOomoo`0@Ool00`0OOomoo`0DOol00`00Oomoo`08Ool00`00Oomo
o`0eOol01000Oomoo`005goo000FOol2000fOol2000:Ool3000fOol2000=Ool00`0OOomoo`0@Ool0
0`0OOomoo`0COol2000:Ool3000fOol2000HOol001Ioo`03001oogoo08Qoo`0301moogoo015oo`03
01moogoo079oo`005Woo00<007ooOol0R7oo00<07gooOol04Woo00<07gooOol0LGoo000FOol00`00
Oomoo`28Ool00`0OOomoo`0BOol00`0OOomoo`1aOol001Ioo`03001oogoo08Qoo`0301moogoo019o
o`0301moogoo075oo`005Woo00<007ooOol0Qgoo00<07gooOol04goo00<07gooOol0JGoo0P001Woo
000FOol00`00Oomoo`27Ool00`0OOomoo`0COol00`0OOomoo`1XOol01000Oomoo`001Goo000@Ool6
00000`0O0000002600000`0O0000000E00000`0O0000001N0009Ool00`00Oomoo`06Ool001Ioo`03
00007goo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03
001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Yoo`03
001oogoo00Qoo`0301l007oo00]oo`03001oogoo00Moo`0301moo`0000aoo`03001oogoo00Uoo`03
001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03
001oogoo00aoo`D000Eoo`005Woo00<0000OOol0QGoo00<07gooOol05Woo00<07gooOol0Igoo00<0
07ooOol01Woo000FOol00`00Ool07`24Ool00`0OOomoo`0GOol00`0OOomoo`1DOol401lHOol001Io
o`03001oo`0O08Aoo`0301moogoo01Moo`0301moogoo04ioo`H07aaoo`005Woo00@007ooOol07h9o
o`0301moogoo01Uoo`0301moogoo04Ioo`L07b9oo`005Woo0P0000=oo`0OOol0P7oo00<07gooOol0
6Woo00<07gooOol0@7oo1P0O:Goo000FOol01@00Oomoogoo01l0P7oo00<07gooOol06Woo00<07goo
Ool0?7oo100O;goo000FOol01@00Oomoogoo01l0Ogoo00<07gooOol06goo00<07gooOol0>Woo0P0O
<goo000FOol00`00Oomoo`02Ool00`0OOomoo`1kOol00`0OOomoo`0LOol00`0OOomoo`0gOol301le
Ool001Ioo`03001oogoo009oo`0301moogoo07]oo`0301moogoo01aoo`0301moogoo03Aoo`<07cQo
o`005Woo00<007ooOol00goo00<07gooOol0NGoo00<07gooOol07Woo00<07gooOol0<Goo0P0O>goo
000FOol00`00Oomoo`03Ool00`0OOomoo`1hOol00`0OOomoo`0OOol00`0OOomoo`0^Ool301lmOol0
01Ioo`8000Eoo`0301moogoo07Moo`0301moogoo01moo`0301moogoo02aoo`807d1oo`005Woo00<0
07ooOol017oo00<07gooOol0MWoo00<07gooOol087oo00<07gooOol0:Woo0P0O@Woo000FOol00`00
Oomoo`05Ool00`0OOomoo`1dOol00`0OOomoo`0ROol00`0OOomoo`0WOol201m4Ool001Ioo`03001o
ogoo00Eoo`0301moogoo07Aoo`0301moogoo029oo`0301moogoo02Eoo`807dIoo`005Woo00<007oo
Ool01Woo00<07gooOol0LWoo00<07gooOol097oo00<07gooOol08Woo0P0OB7oo000FOol00`00Oomo
o`06Ool00`0OOomoo`1aOol00`0OOomoo`0UOol00`0OOomoo`0QOol00`0OOomoo`18Ool001Ioo`80
00Qoo`0301moogoo06moo`0301moogoo02Moo`0301moogoo01moo`0301moogoo04Uoo`005Woo00<0
07ooOol01goo00<07gooOol0Kgoo00<07gooOol09goo00<07gooOol07Woo00<07gooOol0BWoo000F
Ool00`00Oomoo`08Ool00`0OOomoo`1]Ool00`0OOomoo`0XOol00`0OOomoo`0LOol201m=Ool001Io
o`03001oogoo00Qoo`0301moogoo06aoo`0301moogoo02Yoo`0301moogoo01Yoo`0301moogoo04eo
o`0027oo10000goo0P001Goo00<007ooOol02Goo00<07gooOol0JWoo00<07gooOol0:goo00<07goo
Ool06Goo00<07gooOol0CWoo0008Ool00`00Oomoo`03Ool01000Oomoo`0017oo00<007ooOol02Goo
00<07gooOol0JWoo00<07gooOol0;7oo00<07gooOol05goo00<07gooOol0Cgoo0009Ool00`00Oomo
o`02Ool01000Oomoo`0017oo0`002Woo00<07gooOol0J7oo00<07gooOol0;Goo00<07gooOol05Woo
00<07gooOol0D7oo000:Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol02Woo00<0
7gooOol0Igoo00<07gooOol0;Woo00<07gooOol057oo0P0ODgoo0008Ool01000Oomoo`000Woo00@0
07ooOol000Aoo`03001oogoo00Yoo`0301moogoo06Ioo`0301moogoo031oo`0301moogoo019oo`03
01moogoo05=oo`002Goo0P0017oo0P001Goo00<007ooOol02goo00<07gooOol0IGoo00<07gooOol0
<7oo00<07gooOol04Goo00<07gooOol0E7oo000FOol00`00Oomoo`0;Ool00`0OOomoo`1TOol00`0O
Oomoo`0bOol00`0OOomoo`0?Ool00`0OOomoo`1EOol001Ioo`03001oogoo00aoo`0301moogoo069o
o`0301moogoo03=oo`0301moogoo00ioo`0301moogoo05Ioo`005Woo00<007ooOol037oo00<07goo
Ool0HGoo00<07gooOol0=Goo00<07gooOol037oo00<07gooOol0Egoo000FOol2000>Ool00`0OOomo
o`1POol00`0OOomoo`0eOol00`0OOomoo`0<Ool00`0OOomoo`1GOol001Ioo`03001oogoo00eoo`03
01moogoo05moo`0301moogoo03Ioo`0301moogoo00]oo`0301moogoo05Qoo`005Woo00<007ooOol0
3Woo00<07gooOol0GGoo00<07gooOol0>7oo00<07gooOol02Goo00<07gooOol0FGoo000FOol00`00
Oomoo`0>Ool00`0OOomoo`1LOol00`0OOomoo`0iOol00`0OOomoo`08Ool00`0OOomoo`1JOol001Io
o`03001oogoo00moo`0301moogoo05Yoo`0301moogoo03]oo`0301moogoo00Ioo`0301moogoo05]o
o`005Woo00<007ooOol03goo00<07gooOol0FWoo00<07gooOol0>goo00<07gooOol01Woo00<07goo
Ool0Fgoo000FOol2000AOol00`0OOomoo`1HOol00`0OOomoo`0lOol00`0OOomoo`05Ool00`0OOomo
o`1LOol001Ioo`03001oogoo011oo`0301moogoo05Moo`0301moogoo03ioo`0301moogoo00=oo`03
01moogoo05eoo`005Woo00<007ooOol04Goo00<07gooOol0EGoo00<07gooOol0?goo00<07gooOol0
0Woo00<07gooOol0GWoo000FOol00`00Oomoo`0AOol00`0OOomoo`1EOol00`0OOomoo`10Ool0100O
Oomoo`0OHGoo000FOol00`00Oomoo`0BOol00`0OOomoo`1COol00`0OOomoo`11Ool0100OOomoo`0O
HGoo000FOol00`00Oomoo`0BOol00`0OOomoo`1BOol00`0OOomoo`13Ool201mROol001Ioo`03001o
ogoo01=oo`0301moogoo051oo`0301moogoo04Aoo`0301moogoo065oo`005Woo0P0057oo00<07goo
Ool0D7oo00<07gooOol0Z7oo000FOol00`00Oomoo`0DOol00`0OOomoo`1>Ool00`0OOomoo`2YOol0
01Ioo`03001oogoo01Aoo`0301moogoo04eoo`0301moogoo0:Yoo`005Woo00<007ooOol05Goo00<0
7gooOol0Bgoo00<07gooOol0Zgoo000:Ool30002Ool20005Ool00`00Oomoo`0EOol00`0OOomoo`1;
Ool00`0OOomoo`2[Ool000]oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`0FOol00`0O
Oomoo`19Ool00`0OOomoo`2/Ool000Qoo`D00005Ool007ooOol00004Ool3000FOol00`0OOomoo`18
Ool00`0OOomoo`2]Ool000Qoo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol05goo00<0
7gooOol0AWoo00<07gooOol0[Woo0009Ool00`00Ool00002Ool01000Oomoo`0017oo00<007ooOol0
5goo00<07gooOol0AWoo00<07gooOol0[Woo000:Ool20003Ool20005Ool00`00Oomoo`0HOol00`0O
Oomoo`14Ool00`0OOomoo`2_Ool001Ioo`03001oogoo01Qoo`0301moogoo04=oo`0301moogoo0;1o
o`005Woo00<007ooOol06Goo00<07gooOol0@Woo00<07gooOol0/7oo000FOol2000JOol00`0OOomo
o`11Ool00`0OOomoo`2aOol001Ioo`03001oogoo01Yoo`0301moogoo03moo`0301moogoo0;9oo`00
5Woo00<007ooOol06Woo00<07gooOol0?goo00<07gooOol0/Woo000FOol00`00Oomoo`0KOol00`0O
Oomoo`0mOol00`0OOomoo`2cOol001Ioo`03001oogoo01]oo`0301moogoo03aoo`0301moogoo0;Ao
o`005Woo00<007ooOol077oo00<07gooOol0>goo00<07gooOol0]7oo000FOol00`00Oomoo`0LOol0
0`0OOomoo`0jOol00`0OOomoo`2eOol001Ioo`8001ioo`0301moogoo03Qoo`0301moogoo0;Ioo`00
5Woo00<007ooOol07Goo00<07gooOol0>7oo00<07gooOol0]Woo000FOol00`00Oomoo`0NOol00`0O
Oomoo`0fOol00`0OOomoo`2gOol001Ioo`03001oogoo01ioo`0301moogoo03Eoo`0301moogoo0;Qo
o`005Woo00<007ooOol07goo00<07gooOol0=7oo00<07gooOol0^7oo000FOol00`00Oomoo`0OOol0
0`0OOomoo`0cOol00`0OOomoo`2iOol001Ioo`80025oo`0301moogoo035oo`0301moogoo0;Yoo`00
5Woo00<007ooOol087oo00<07gooOol0<7oo00<07gooOol0^goo000FOol00`00Oomoo`0QOol00`0O
Oomoo`0_Ool00`0OOomoo`2kOol001Ioo`03001oogoo025oo`0301moogoo02ioo`0301moogoo0;ao
o`005Woo00<007ooOol08Woo00<07gooOol0;7oo00<07gooOol0_Goo0008Ool30004Ool20005Ool0
0`00Oomoo`0ROol00`0OOomoo`0[Ool00`0OOomoo`2nOol000Qoo`04001oogoo0002Ool01000Oomo
o`0017oo00<007ooOol08goo00<07gooOol0:Woo00<07gooOol0_Woo0008Ool01000Oomoo`000Woo
00@007ooOol000Aoo`<002=oo`0301moogoo02Uoo`0301moogoo0;moo`0027oo0`000goo00@007oo
Ool000Aoo`03001oogoo02Aoo`0301moogoo02Moo`0301moogoo0<1oo`002Goo00<007ooOol00Woo
00@007ooOol000Aoo`03001oogoo02Aoo`0301moogoo02Ioo`0301moogoo0<5oo`002Goo0`000goo
0P001Goo00<007ooOol09Goo00<07gooOol09Goo00<07gooOol0`Goo000FOol00`00Oomoo`0UOol0
0`0OOomoo`0TOol00`0OOomoo`32Ool001Ioo`03001oogoo02Ioo`0301moogoo029oo`0301moogoo
0<=oo`005Woo0P009goo00<07gooOol08Goo00<07gooOol0a7oo000FOol00`00Oomoo`0WOol00`0O
Oomoo`0POol00`0OOomoo`34Ool001Ioo`03001oogoo02Moo`0301moogoo01moo`0301moogoo0<Eo
o`005Woo00<007ooOol0:7oo00<07gooOol07Goo00<07gooOol0aWoo000FOol00`00Oomoo`0XOol0
0`0OOomoo`0LOol00`0OOomoo`37Ool001Ioo`03001oogoo02Uoo`0301moogoo01]oo`0301moogoo
0<Moo`005Woo0P00:Woo00<07gooOol06Woo00<07gooOol0b7oo000FOol00`00Oomoo`0ZOol00`0O
Oomoo`0HOol00`0OOomoo`39Ool001Ioo`03001oogoo02Yoo`0301moogoo01Qoo`0301moogoo0<Uo
o`005Woo00<007ooOol0:goo00<07gooOol05Woo00<07gooOol0bWoo000FOol00`00Oomoo`0[Ool0
0`0OOomoo`0FOol00`0OOomoo`3:Ool001Ioo`03001oogoo02aoo`0301moogoo01Aoo`0301moogoo
0<]oo`005Woo00<007ooOol0;7oo00<07gooOol04goo00<07gooOol0c7oo000FOol2000^Ool00`0O
Oomoo`0BOol00`0OOomoo`3<Ool001Ioo`03001oogoo02eoo`0301moogoo015oo`0301moogoo0<eo
o`005Woo00<007ooOol0;Woo00<07gooOol03goo00<07gooOol0cWoo000FOol00`00Oomoo`0^Ool0
0`0OOomoo`0?Ool00`0OOomoo`3>Ool000Uoo`8000Aoo`8000Eoo`03001oogoo02moo`0301moogoo
00eoo`0301moogoo0<moo`0027oo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`0_Ool2
01l>Ool00`0OOomoo`3?Ool000Qoo`04001oogoo0002Ool01000Oomoo`0017oo0`00<Goo0`0O2Woo
00<07gooOol0d7oo0009Ool20003Ool01000Oomoo`0017oo00<007ooOol0=7oo100O1Goo00<07goo
Ool0dGoo0008Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo03Qoo`<07`9oo`0301mo
ogoo0=5oo`002Goo0P0017oo0P001Goo00<007ooOol0>goo0P0Oe7oo000FOol00`00Oomoo`3oOolB
Ool001Ioo`03001oogoo0?mooa9oo`005Woo00<007ooOol0ogoo4Woo003oOol[Ool00?moob]oo`00
ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[
Ool00?moob]oo`0057oo1@00ogoo4Woo000DOol4003oOolCOol001Moo`03001oogoo0?mooa5oo`00
5Goo0`00ogoo4goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00001\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.5, 0}} -> {-0.180039, -43.5142, \
0.00797164, 0.780626}}],

Cell[BoxData[
    InterpretationBox[\("M\[AAcute]xima Aceleraci\[OAcute]n: "\
\[InvisibleSpace]81.80569011947021`\),
      SequenceForm[ 
      "M\[AAcute]xima Aceleraci\[OAcute]n: ", 81.805690119470214],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[IAcute]nima Aceleraci\[OAcute]n: "\
\[InvisibleSpace]\(-39.23685335731682`\)\),
      SequenceForm[ 
      "M\[IAcute]nima Aceleraci\[OAcute]n: ", -39.236853357316818],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("t"\[InvisibleSpace]"         "\[InvisibleSpace]"p    \
    "\[InvisibleSpace]"     u"\[InvisibleSpace]"          \
v"\[InvisibleSpace]"         a"\),
      SequenceForm[ 
      "t", "         ", "p        ", "     u", "          v", "         a"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("---------------------------------------------------"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        InterpretationBox[GridBox[{
              {"0"},
              {"0.1`"},
              {"0.2`"},
              {"0.30000000000000004`"},
              {"0.4`"},
              {"0.5`"},
              {"0.6000000000000001`"},
              {"0.7000000000000001`"},
              {"0.8`"},
              {"0.9`"},
              {"1.`"},
              {"1.1`"},
              {"1.2000000000000002`"},
              {"1.3`"},
              {"1.4000000000000001`"},
              {"1.5`"},
              {"1.6`"},
              {"1.7000000000000002`"},
              {"1.8`"},
              {"1.9000000000000001`"},
              {"2.`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0, 1.1000000000000001, 
            1.2000000000000002, 1.3, 1.4000000000000001, 1.5, 
            1.6000000000000001, 1.7000000000000002, 1.8, 1.9000000000000001, 
            2.0}]], "\[InvisibleSpace]", "\<\"     \"\>", "\[InvisibleSpace]",
         
        InterpretationBox[GridBox[{
              {"0"},
              {"4.444444444444443`"},
              {"8.88888888888889`"},
              {"13.333333333333336`"},
              {"17.77777777777778`"},
              {"18.461538461538463`"},
              {"15.384615384615383`"},
              {"12.307692307692307`"},
              {"9.230769230769232`"},
              {"6.153846153846157`"},
              {"3.07692307692308`"},
              {"0"},
              {\(-9.99999999999999`\)},
              {\(-4.999999999999994`\)},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 4.4444444444444429, 8.8888888888888893, 
            13.333333333333336, 17.777777777777779, 18.461538461538463, 
            15.384615384615383, 12.307692307692307, 9.2307692307692317, 
            6.1538461538461569, 3.0769230769230802, 
            0, -9.9999999999999893, -4.9999999999999938, 0, 0, 0, 0, 0, 0, 
            0}]], "\[InvisibleSpace]", "\<\"    \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"0.06823050146142433`"},
              {"0.42434830574993077`"},
              {"1.1027818259771442`"},
              {"2.107104678396575`"},
              {"3.379953798385036`"},
              {"4.677770114985308`"},
              {"5.7855642717031595`"},
              {"6.671181899035415`"},
              {"7.331284053922662`"},
              {"7.765524017056568`"},
              {"7.973865784744757`"},
              {"7.864796682066037`"},
              {"7.4180283018403825`"},
              {"7.396970877287889`"},
              {"7.598827128103614`"},
              {"7.733998302729974`"},
              {"7.820351579173729`"},
              {"7.875619878236439`"},
              {"7.91099037739672`"},
              {"7.933626788286739`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, .068230501461424328, .42434830574993077, 
            1.1027818259771442, 2.107104678396575, 3.3799537983850358, 
            4.6777701149853081, 5.7855642717031595, 6.6711818990354148, 
            7.331284053922662, 7.7655240170565678, 7.9738657847447572, 
            7.8647966820660367, 7.4180283018403825, 7.396970877287889, 
            7.5988271281036139, 7.7339983027299741, 7.820351579173729, 
            7.8756198782364386, 7.9109903773967201, 7.9336267882867393}]], 
        "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"1.4620821741733785`"},
              {"3.291589582783196`"},
              {"5.1592343120374125`"},
              {"7.030839260199277`"},
              {"7.665695027899351`"},
              {"6.7525612772727905`"},
              {"5.496278902712024`"},
              {"4.204363619344914`"},
              {"2.908748177791409`"},
              {"1.6127485079763568`"},
              {"0.3167089395003433`"},
              {\(-2.9402405491037493`\)},
              {\(-0.9465473144729222`\)},
              {"0.698482695508878`"},
              {"0.5018819509076176`"},
              {"0.31978715451032613`"},
              {"0.20469344045416893`"},
              {"0.13099876065137495`"},
              {"0.08383659668182092`"},
              {"0.053653735639525135`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 1.4620821741733785, 3.291589582783196, 
            5.1592343120374125, 7.0308392601992766, 7.6656950278993508, 
            6.7525612772727905, 5.4962789027120236, 4.2043636193449139, 
            2.9087481777914088, 
            1.6127485079763568, .31670893950034329, -2.9402405491037493, \
-.94654731447292217, .69848269550887798, .50188195090761756, \
.31978715451032613, .20469344045416893, .13099876065137495, \
.083836596681820919, .053653735639525135}]], 
        "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"20.219169643604683`"},
              {"39.93496671603147`"},
              {"59.598515659175426`"},
              {"79.25663910241587`"},
              {"81.80569011947021`"},
              {"67.67206797321319`"},
              {"54.00855944174606`"},
              {"40.393867995343626`"},
              {"26.784245765656554`"},
              {"13.175149928687793`"},
              {\(-0.43389124711547034`\)},
              {\(-39.23685335731682`\)},
              {"10.61973439017307`"},
              {"34.66633924261444`"},
              {"22.471058774847158`"},
              {"14.373708612733704`"},
              {"9.199072180588775`"},
              {"5.887216424796287`"},
              {"3.7677002662871963`"},
              {"2.4112524134564546`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 20.219169643604683, 39.934966716031468, 
            59.598515659175426, 79.256639102415875, 81.805690119470214, 
            67.672067973213188, 54.008559441746058, 40.393867995343626, 
            26.784245765656554, 
            13.175149928687793, -.43389124711547034, -39.236853357316818, 
            10.61973439017307, 34.666339242614441, 22.471058774847158, 
            14.373708612733704, 9.1990721805887752, 5.8872164247962866, 
            3.7677002662871963, 2.4112524134564546}]]}],
      SequenceForm[ 
        TableForm[ {
          0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0, 1.1000000000000001, 
          1.2000000000000002, 1.3, 1.4000000000000001, 1.5, 
          1.6000000000000001, 1.7000000000000002, 1.8, 1.9000000000000001, 
          2.0}], "     ", 
        TableForm[ {0, 4.4444444444444429, 8.8888888888888893, 
          13.333333333333336, 17.777777777777779, 18.461538461538463, 
          15.384615384615383, 12.307692307692307, 9.2307692307692317, 
          6.1538461538461569, 3.0769230769230802, 
          0, -9.9999999999999893, -4.9999999999999938, 0, 0, 0, 0, 0, 0, 0}], 
        "    ", 
        TableForm[ {0, .068230501461424328, .42434830574993077, 
          1.1027818259771442, 2.107104678396575, 3.3799537983850358, 
          4.6777701149853081, 5.7855642717031595, 6.6711818990354148, 
          7.331284053922662, 7.7655240170565678, 7.9738657847447572, 
          7.8647966820660367, 7.4180283018403825, 7.396970877287889, 
          7.5988271281036139, 7.7339983027299741, 7.820351579173729, 
          7.8756198782364386, 7.9109903773967201, 7.9336267882867393}], "   ",
         
        TableForm[ {0, 1.4620821741733785, 3.291589582783196, 
          5.1592343120374125, 7.0308392601992766, 7.6656950278993508, 
          6.7525612772727905, 5.4962789027120236, 4.2043636193449139, 
          2.9087481777914088, 
          1.6127485079763568, .31670893950034329, -2.9402405491037493, \
-.94654731447292217, .69848269550887798, .50188195090761756, \
.31978715451032613, .20469344045416893, .13099876065137495, \
.083836596681820919, .053653735639525135}], "  ", 
        TableForm[ {0, 20.219169643604683, 39.934966716031468, 
          59.598515659175426, 79.256639102415875, 81.805690119470214, 
          67.672067973213188, 54.008559441746058, 40.393867995343626, 
          26.784245765656554, 
          13.175149928687793, -.43389124711547034, -39.236853357316818, 
          10.61973439017307, 34.666339242614441, 22.471058774847158, 
          14.373708612733704, 9.1990721805887752, 5.8872164247962866, 
          3.7677002662871963, 2.4112524134564546}]],
      Editable->False]], "Print"]
}, Open  ]],

Cell["\<\
EJEMPLO
0.2533 a( t )  + 0.1592 v( t ) + fs ( u,v ) = p( t )
u( 0 ) = 0
v( 0 ) = 0

Hallar la respuesta hasta el instante tn=1 y con un incremento de tiempo
to=0.1,para el m\[EAcute]todo de la aceleraci\[OAcute]n constante, siendo p( \
t ) la carga dada en forma discreta siguiente:

p={{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
    {.7,0},{.8,0},{.9,0},{1,0}};

y siendo el material elastopl\[AAcute]stico perfecto, en el que la \
plastificaci\[OAcute]n a tracci\[OAcute]n se alcanza paran un valor de ft = \
7.5, y a compresi\[OAcute]n para fc = -7.5,
y la rigidez el\[AAcute]stica es 10. Tomar \[Theta]=1.4.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["\<\
p={{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
    {.7,0},{.8,0},{.9,0},{1,0}};
WilsonNoLineal[0,1,.1,0,0,10,.2533,.1592,p,
        1.4,-7.5,7.5,posicion,velocidad,aceleracion]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]1\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]10\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]0.5749943414033176`\),
      SequenceForm[ 
      "i = ", 1, "  j = ", 13, "  kt = ", 10, "   fs = ", .57499434140331762],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]2\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]10\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]3.247545031227596`\),
      SequenceForm[ 
      "i = ", 2, "  j = ", 13, "  kt = ", 10, "   fs = ", 3.2475450312275962],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]3\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]10\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]6.938680411549537`\),
      SequenceForm[ 
      "i = ", 3, "  j = ", 13, "  kt = ", 10, "   fs = ", 6.9386804115495373],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]4\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]10\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.5`\),
      SequenceForm[ "i = ", 4, "  j = ", 13, "  kt = ", 10, "   fs = ", 7.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]5\[InvisibleSpace]"  j = "\
\[InvisibleSpace]18\[InvisibleSpace]"  kt = "\[InvisibleSpace]10\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.5`\),
      SequenceForm[ "i = ", 5, "  j = ", 18, "  kt = ", 10, "   fs = ", 7.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]6\[InvisibleSpace]"  j = "\
\[InvisibleSpace]18\[InvisibleSpace]"  kt = "\[InvisibleSpace]10\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]7.5`\),
      SequenceForm[ "i = ", 6, "  j = ", 18, "  kt = ", 10, "   fs = ", 7.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]7\[InvisibleSpace]"  j = "\
\[InvisibleSpace]19\[InvisibleSpace]"  kt = "\[InvisibleSpace]10\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]5.818260985848555`\),
      SequenceForm[ 
      "i = ", 7, "  j = ", 19, "  kt = ", 10, "   fs = ", 5.8182609858485552],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]8\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]10\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]4.303396549026838`\),
      SequenceForm[ 
      "i = ", 8, "  j = ", 13, "  kt = ", 10, "   fs = ", 4.3033965490268384],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]9\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]10\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]3.1732750068415623`\),
      SequenceForm[ 
      "i = ", 9, "  j = ", 13, "  kt = ", 10, "   fs = ", 3.1732750068415623],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]10\[InvisibleSpace]"  j = "\
\[InvisibleSpace]13\[InvisibleSpace]"  kt = "\[InvisibleSpace]10\
\[InvisibleSpace]"   fs = "\[InvisibleSpace]2.3394693568544254`\),
      SequenceForm[ 
      "i = ", 10, "  j = ", 13, "  kt = ", 10, "   fs = ", 
        2.3394693568544254],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Carga:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.0588604 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .13244 -6 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -6 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -6 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -6 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -12 -4.5 ]
[.01131 .60332 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .13244 m
.03006 .13244 L
s
[(2)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(4)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(6)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(8)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(10)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .16187 m
.02756 .16187 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 0 r
.5 Mabswid
.02381 .01472 m
.11905 .30902 L
.21429 .52445 L
.30952 .60332 L
.40476 .52445 L
.5 .30902 L
.59524 .01472 L
.69048 .01472 L
.78571 .01472 L
.88095 .01472 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.563},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^1000`40O003h00Oogoo:goo0011Ool2
0004Ool20003Ool4000ROol20004Ool20005Ool3000POol20004Ool20003Ool3000ROol20004Ool2
0004Ool2000WOol5000NOol0041oo`04001oogoo0008Ool00`00Oomoo`0ROol01000Oomoo`002goo
00<007ooOol07Woo00@007ooOol000Qoo`04001oogoo000POol01000Oomoo`0027oo00@007ooOol0
02Qoo`03001oogoo01ioo`00@7oo00@007ooOol000Uoo`03001oogoo025oo`04001oogoo0008Ool5
000OOol01000Oomoo`0027oo00@007ooOol0021oo`04001oogoo0008Ool01000Oomoo`00:7oo00<0
07ooOol07Woo0010Ool01000Oomoo`002Woo00<007ooOol087oo00@007ooOol000Qoo`04001oogoo
000POol01000Oomoo`0027oo0`008Goo00@007ooOol000Uoo`8002Uoo`03001oogoo01ioo`00@7oo
00@007ooOol000Qoo`04001oogoo000QOol01000Oomoo`002Goo00<007oo000087oo00@007ooOol0
00Uoo`03001oogoo021oo`04001oogoo0008Ool01000Oomoo`00:7oo00<007ooOol07Woo0011Ool2
000:Ool2000SOol2000;Ool2000QOol2000:Ool3000QOol2000:Ool2000XOol2000POol00?moob]o
o`0067oo00<007ooOol0ogoo47oo000HOol00`00Oomoo`3oOol@Ool001Qoo`03001oogoo0?mooa1o
o`0067oo00<007ooOol0oWoo0P003goo000BOol600000`?P0000002>001Q0n060008Ool01000Oomo
o`003Woo000HOol00`?POomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool0
0`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool0
0`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`?POomoo`09Ool00`00Oomoo`09Ool0
0`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool0
0`00Oomoo`09Ool00`00Oomoo`0<Ool00`00Oomoo`0?Ool001Qoo`030003h7oo02eoo`03001oogoo
02ioo`03001oogoo02aoo`030n0007oo02ioo`03001oogoo02eoo`03001oogoo00]oo`D000ioo`00
67oo00<000?POol0SGoo00<3h7ooOol0KGoo00<007ooOol03goo000HOol00`000n1oo`2=Ool00`?P
Oomoo`1oOol001Qoo`03001oo`?P08aoo`030n1oogoo081oo`0067oo00<007oo0n00S7oo00<3h7oo
Ool0P7oo000HOol00`00Ool3h02<Ool00`?POomoo`20Ool001Qoo`800003Ool3h7oo08Uoo`030n1o
ogoo085oo`0067oo00@007ooOol3h8Yoo`030n1oogoo085oo`0067oo00@007ooOol3h8Yoo`030n1o
ogoo085oo`0067oo00D007ooOomoo`?P08Qoo`030n1oogoo089oo`0067oo00D007ooOomoo`?P08Qo
o`030n1oogoo089oo`0067oo00D007ooOomoo`?P08Qoo`030n1oogoo089oo`0067oo00D007ooOomo
o`?P08Qoo`030n1oogoo089oo`0067oo0P000goo00<3h7ooOol0Q7oo00<3h7ooOol0Pgoo000HOol0
0`00Oomoo`02Ool00`?POomoo`24Ool00`?POomoo`23Ool001Qoo`03001oogoo009oo`030n1oogoo
08Aoo`030n1oogoo08=oo`0067oo00<007ooOol00goo00<3h7ooOol0PWoo00<3h7ooOol0Q7oo000H
Ool00`00Oomoo`03Ool00`?POomoo`22Ool00`?POomoo`24Ool001Qoo`03001oogoo00=oo`030n1o
ogoo089oo`030n1oogoo08Aoo`0067oo00<007ooOol017oo00<3h7ooOol0P7oo00<3h7ooOol0QGoo
000HOol20005Ool00`?POomoo`20Ool00`?POomoo`25Ool001Qoo`03001oogoo00Aoo`030n1oogoo
081oo`030n1oogoo08Eoo`0067oo00<007ooOol01Goo00<3h7ooOol0OWoo00<3h7ooOol0QWoo000H
Ool00`00Oomoo`05Ool00`?POomoo`1nOol00`?POomoo`26Ool001Qoo`03001oogoo00Eoo`030n1o
ogoo07ioo`030n1oogoo08Ioo`0067oo00<007ooOol01Woo00<3h7ooOol0O7oo00<3h7ooOol0Qgoo
000@Ool40004Ool00`00Oomoo`06Ool00`?POomoo`1lOol00`?POomoo`27Ool0011oo`03001oogoo
00Eoo`03001oogoo00Ioo`030n1oogoo07aoo`030n1oogoo08Moo`004Goo00<007ooOol017oo0`00
1goo00<3h7ooOol0NWoo00<3h7ooOol0R7oo000BOol00`00Oomoo`03Ool00`00Oomoo`07Ool00`?P
Oomoo`1jOol00`?POomoo`28Ool0011oo`04001oogoo0004Ool00`00Oomoo`07Ool00`?POomoo`1j
Ool00`?POomoo`28Ool0015oo`8000Eoo`03001oogoo00Qoo`030n1oogoo07Qoo`030n1oogoo08Uo
o`0067oo00<007ooOol027oo00<3h7ooOol0N7oo00<3h7ooOol0RGoo000HOol00`00Oomoo`08Ool0
0`?POomoo`1hOol00`?POomoo`29Ool001Qoo`03001oogoo00Uoo`030n1oogoo07Ioo`030n1oogoo
08Yoo`0067oo0P002Woo00<3h7ooOol0MWoo00<3h7ooOol0RWoo000HOol00`00Oomoo`09Ool00`?P
Oomoo`1fOol00`?POomoo`2:Ool001Qoo`03001oogoo00Uoo`030n1oogoo07Ioo`030n1oogoo08Yo
o`0067oo00<007ooOol02Woo00<3h7ooOol0M7oo00<3h7ooOol0Rgoo000HOol00`00Oomoo`0:Ool0
0`?POomoo`1dOol00`?POomoo`2;Ool001Qoo`03001oogoo00Yoo`030n1oogoo07Aoo`030n1oogoo
08]oo`0067oo00<007ooOol02goo00<3h7ooOol0LWoo00<3h7ooOol0S7oo000HOol00`00Oomoo`0;
Ool00`?POomoo`1bOol00`?POomoo`2<Ool001Qoo`8000aoo`030n1oogoo079oo`030n1oogoo08ao
o`0067oo00<007ooOol037oo00<3h7ooOol0L7oo00<3h7ooOol0SGoo000HOol00`00Oomoo`0<Ool0
0`?POomoo`1`Ool00`?POomoo`2=Ool001Qoo`03001oogoo00aoo`030n1oogoo071oo`030n1oogoo
08eoo`0067oo00<007ooOol03Goo00<3h7ooOol0KWoo00<3h7ooOol0SWoo000HOol00`00Oomoo`0=
Ool00`?POomoo`1^Ool00`?POomoo`2>Ool001Qoo`03001oogoo00eoo`030n1oogoo06ioo`030n1o
ogoo08ioo`0067oo0P003goo00<3h7ooOol0K7oo00<3h7ooOol0Sgoo000HOol00`00Oomoo`0>Ool0
0`?POomoo`1/Ool00`?POomoo`2?Ool001Qoo`03001oogoo00ioo`030n1oogoo06aoo`030n1oogoo
08moo`0067oo00<007ooOol03goo00<3h7ooOol0JWoo00<3h7ooOol0T7oo000HOol00`00Oomoo`0?
Ool00`?POomoo`1ZOol00`?POomoo`2@Ool001Qoo`03001oogoo00moo`030n1oogoo06Yoo`030n1o
ogoo091oo`004Woo0`000goo00<007ooOol047oo00<3h7ooOol0J7oo00<3h7ooOol0TGoo000COol0
0`00Oomoo`02Ool00`00Oomoo`0@Ool00`?POomoo`1XOol00`?POomoo`2AOol0011oo`D000=oo`<0
011oo`030n1oogoo06Qoo`030n1oogoo095oo`0047oo00@007ooOol000Aoo`03001oogoo015oo`03
0n1oogoo06Ioo`030n1oogoo099oo`004Goo00<007oo000017oo00<007ooOol04Goo00<3h7ooOol0
IWoo00<3h7ooOol0TWoo000BOol20004Ool00`00Oomoo`0AOol00`?POomoo`1VOol00`?POomoo`2B
Ool001Qoo`03001oogoo015oo`030n1oogoo06Ioo`030n1oogoo099oo`0067oo00<007ooOol04Woo
00<3h7ooOol0I7oo00<3h7ooOol0Tgoo000HOol00`00Oomoo`0BOol00`?POomoo`1TOol00`?POomo
o`2COol001Qoo`8001=oo`030n1oogoo06Aoo`030n1oogoo09=oo`0067oo00<007ooOol04goo00<3
h7ooOol0HWoo00<3h7ooOol0U7oo000HOol00`00Oomoo`0COol00`?POomoo`1ROol00`?POomoo`2D
Ool001Qoo`03001oogoo01=oo`030n1oogoo069oo`030n1oogoo09Aoo`0067oo00<007ooOol057oo
00<3h7ooOol0H7oo00<3h7ooOol0UGoo000HOol00`00Oomoo`0DOol00`?POomoo`1POol00`?POomo
o`2EOol001Qoo`03001oogoo01Aoo`030n1oogoo061oo`030n1oogoo09Eoo`0067oo00<007ooOol0
5Goo00<3h7ooOol0GWoo00<3h7ooOol0UWoo000HOol2000FOol00`?POomoo`3gOol001Qoo`03001o
ogoo01Eoo`030n1oogoo05ioo`030n1oogoo09Ioo`0067oo00<007ooOol05Woo00<3h7ooOol0G7oo
00<3h7ooOol0Ugoo000HOol00`00Oomoo`0FOol00`?POomoo`1LOol00`?POomoo`2GOol001Qoo`03
001oogoo01Moo`030n1oogoo05Yoo`030n1oogoo09Qoo`0067oo00<007ooOol05goo00<3h7ooOol0
FWoo00<3h7ooOol0V7oo000HOol00`00Oomoo`0HOol00`?POomoo`1HOol00`?POomoo`2IOol001Qo
o`8001Uoo`030n1oogoo05Qoo`030n1oogoo09Uoo`0067oo00<007ooOol06Goo00<3h7ooOol0EWoo
00<3h7ooOol0VWoo000HOol00`00Oomoo`0IOol00`?POomoo`1FOol00`?POomoo`2JOol001Qoo`03
001oogoo01Uoo`030n1oogoo05Ioo`030n1oogoo09Yoo`0067oo00<007ooOol06Woo00<3h7ooOol0
E7oo00<3h7ooOol0Vgoo000@Ool30005Ool00`00Oomoo`0JOol00`?POomoo`1DOol00`?POomoo`2K
Ool0011oo`04001oogoo0004Ool00`00Oomoo`0KOol00`?POomoo`1BOol00`?POomoo`2LOol0011o
o`04001oogoo0004Ool3000KOol00`?POomoo`1BOol00`?POomoo`2LOol0011oo`<000Eoo`03001o
ogoo01aoo`030n1oogoo051oo`030n1oogoo09eoo`004Goo00<007ooOol017oo00<007ooOol077oo
00<3h7ooOol0D7oo00<3h7ooOol0WGoo000AOol30004Ool00`00Oomoo`0MOol00`?POomoo`1>Ool0
0`?POomoo`2NOol001Qoo`03001oogoo01eoo`030n1oogoo04ioo`030n1oogoo09ioo`0067oo00<0
07ooOol07Goo00<3h7ooOol0CWoo00<3h7ooOol0WWoo000HOol00`00Oomoo`0NOol00`?POomoo`1<
Ool00`?POomoo`2OOol001Qoo`03001oogoo01ioo`030n1oogoo04aoo`030n1oogoo09moo`0067oo
0P0087oo00<3h7ooOol0BWoo00<3h7ooOol0X7oo000HOol00`00Oomoo`0OOol00`?POomoo`1:Ool0
0`?POomoo`2POol001Qoo`03001oogoo021oo`030n1oogoo04Qoo`030n1oogoo0:5oo`0067oo00<0
07ooOol087oo00<3h7ooOol0B7oo00<3h7ooOol0XGoo000HOol00`00Oomoo`0QOol00`?POomoo`16
Ool00`?POomoo`2ROol001Qoo`03001oogoo025oo`030n1oogoo04Ioo`030n1oogoo0:9oo`0067oo
00<007ooOol08Goo00<3h7ooOol0AWoo00<3h7ooOol0XWoo000HOol2000SOol00`?POomoo`14Ool0
0`?POomoo`2SOol001Qoo`03001oogoo029oo`030n1oogoo04Aoo`030n1oogoo0:=oo`0067oo00<0
07ooOol08goo00<3h7ooOol0@Woo00<3h7ooOol0Y7oo000HOol00`00Oomoo`0SOol00`?POomoo`12
Ool00`?POomoo`2TOol001Qoo`03001oogoo02Aoo`030n1oogoo041oo`030n1oogoo0:Eoo`0067oo
00<007ooOol097oo00<3h7ooOol0@7oo00<3h7ooOol0YGoo000HOol00`00Oomoo`0UOol00`?POomo
o`0nOol00`?POomoo`2VOol001Qoo`03001oogoo02Eoo`030n1oogoo03ioo`030n1oogoo0:Ioo`00
67oo0P009Woo00<3h7ooOol0?Woo00<3h7ooOol0YWoo000HOol00`00Oomoo`0VOol00`?POomoo`0l
Ool00`?POomoo`2WOol001Qoo`03001oogoo02Ioo`030n1oogoo03aoo`030n1oogoo0:Moo`0067oo
00<007ooOol09goo00<3h7ooOol0>Woo00<3h7ooOol0Z7oo000HOol00`00Oomoo`0WOol00`?POomo
o`0jOol00`?POomoo`2XOol0015oo`8000Eoo`03001oogoo02Qoo`030n1oogoo03Qoo`030n1oogoo
0:Uoo`0047oo00@007ooOol000Aoo`03001oogoo02Qoo`030n1oogoo03Qoo`030n1oogoo0:Uoo`00
47oo00@007ooOol000Aoo`<002Uoo`030n1oogoo03Ioo`030n1oogoo0:Yoo`004Goo0P001Goo00<0
07ooOol0:Goo00<3h7ooOol0=Woo00<3h7ooOol0ZWoo000@Ool01000Oomoo`0017oo00<007ooOol0
:Goo00<3h7ooOol0=Woo00<3h7ooOol0ZWoo000AOol20005Ool00`00Oomoo`0ZOol00`?POomoo`0d
Ool00`?POomoo`2[Ool001Qoo`03001oogoo02Yoo`030n1oogoo03Aoo`030n1oogoo0:]oo`0067oo
00<007ooOol0:goo00<3h7ooOol0<Woo00<3h7ooOol0[7oo000HOol00`00Oomoo`0[Ool00`?POomo
o`0bOol00`?POomoo`2/Ool001Qoo`03001oogoo02aoo`030n1oogoo031oo`030n1oogoo0:eoo`00
67oo0P00;Goo00<3h7ooOol0<7oo00<3h7ooOol0[Goo000HOol00`00Oomoo`0]Ool00`?POomoo`0^
Ool00`?POomoo`2^Ool001Qoo`03001oogoo02eoo`030n1oogoo02ioo`030n1oogoo0:ioo`0067oo
00<007ooOol0;Woo00<3h7ooOol0;7oo00<3h7ooOol0[goo000HOol00`00Oomoo`0_Ool20n0[Ool0
0`?POomoo`2`Ool001Qoo`03001oogoo035oo`030n1oogoo02Ioo`83h;=oo`0067oo00<007ooOol0
<Woo00<3h7ooOol097oo00<3h7ooOol0/goo000HOol2000dOol00`?POomoo`0ROol00`?POomoo`2d
Ool001Qoo`03001oogoo03Aoo`83h25oo`030n1oogoo0;Eoo`0067oo00<007ooOol0=Woo00<3h7oo
Ool07Goo00<3h7ooOol0]Woo000HOol00`00Oomoo`0gOol00`?POomoo`0JOol20n2iOol001Qoo`03
001oogoo03Qoo`030n1oogoo01Qoo`030n1oogoo0;Uoo`0067oo00<007ooOol0>Goo0P?P5goo00<3
h7ooOol0^Woo000HOol00`00Oomoo`0kOol00`?POomoo`0COol00`?POomoo`2kOol001Qoo`03001o
ogoo03aoo`030n1oogoo015oo`030n1oogoo0;aoo`0067oo0P00?Woo00<3h7ooOol03Woo0P?P_goo
000HOol00`00Oomoo`0nOol20n0=Ool00`?POomoo`2oOol001Qoo`03001oogoo041oo`030n1oogoo
00Uoo`030n1oogoo0<1oo`0067oo00<007ooOol0@Goo00<3h7ooOol01goo00<3h7ooOol0`Goo000H
Ool00`00Oomoo`12Ool00`?POomoo`05Ool00`?POomoo`32Ool000Yoo`D0009oo`8000Eoo`03001o
ogoo04=oo`83h0=oo`83h<Eoo`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo
04Eoo`030n1oo`?P0<Moo`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`<004Ioo`030n1o
ogoo0<Ioo`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo0?mooa1oo`0037oo
00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo0?mooa1oo`002goo0P0017oo0P001Goo
00<007ooOol0ogoo47oo000HOol00`00Oomoo`3oOol@Ool00?moob]oo`00ogoo:goo003oOol[Ool0
0?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo000EOol3003oOolCOol001Ioo`03
001oogoo0?mooa9oo`005Woo0`00ogoo4Woo000FOol01000Oomoo`00ogoo4Goo000FOol01000Oomo
o`00ogoo4Goo000EOol4003oOolBOol00?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.563, 0}} -> {-0.102934, -0.816941, \
0.00415184, 0.0671781}}],

Cell[BoxData[
    \("Desplazamientos:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.423264 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .09937 -18 -4.5 ]
[.01131 .09937 0 4.5 ]
[.01131 .18402 -18 -4.5 ]
[.01131 .18402 0 4.5 ]
[.01131 .26867 -18 -4.5 ]
[.01131 .26867 0 4.5 ]
[.01131 .35333 -18 -4.5 ]
[.01131 .35333 0 4.5 ]
[.01131 .43798 -6 -4.5 ]
[.01131 .43798 0 4.5 ]
[.01131 .52263 -18 -4.5 ]
[.01131 .52263 0 4.5 ]
[.01131 .60729 -18 -4.5 ]
[.01131 .60729 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .09937 m
.03006 .09937 L
s
[(0.2)] .01131 .09937 1 0 Mshowa
.02381 .18402 m
.03006 .18402 L
s
[(0.4)] .01131 .18402 1 0 Mshowa
.02381 .26867 m
.03006 .26867 L
s
[(0.6)] .01131 .26867 1 0 Mshowa
.02381 .35333 m
.03006 .35333 L
s
[(0.8)] .01131 .35333 1 0 Mshowa
.02381 .43798 m
.03006 .43798 L
s
[(1)] .01131 .43798 1 0 Mshowa
.02381 .52263 m
.03006 .52263 L
s
[(1.2)] .01131 .52263 1 0 Mshowa
.02381 .60729 m
.03006 .60729 L
s
[(1.4)] .01131 .60729 1 0 Mshowa
.125 Mabswid
.02381 .03588 m
.02756 .03588 L
s
.02381 .05704 m
.02756 .05704 L
s
.02381 .0782 m
.02756 .0782 L
s
.02381 .12053 m
.02756 .12053 L
s
.02381 .14169 m
.02756 .14169 L
s
.02381 .16286 m
.02756 .16286 L
s
.02381 .20518 m
.02756 .20518 L
s
.02381 .22635 m
.02756 .22635 L
s
.02381 .24751 m
.02756 .24751 L
s
.02381 .28984 m
.02756 .28984 L
s
.02381 .311 m
.02756 .311 L
s
.02381 .33216 m
.02756 .33216 L
s
.02381 .37449 m
.02756 .37449 L
s
.02381 .39565 m
.02756 .39565 L
s
.02381 .41682 m
.02756 .41682 L
s
.02381 .45914 m
.02756 .45914 L
s
.02381 .48031 m
.02756 .48031 L
s
.02381 .50147 m
.02756 .50147 L
s
.02381 .5438 m
.02756 .5438 L
s
.02381 .56496 m
.02756 .56496 L
s
.02381 .58612 m
.02756 .58612 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.11905 .03905 L
.21429 .15217 L
.30952 .3084 L
.40476 .459 L
.5 .57716 L
.59524 .60332 L
.69048 .53214 L
.78571 .46802 L
.88095 .42018 L
.97619 .38489 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.563},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^1000`40O003h00Oogoo:goo0014Ool2
0004Ool20003Ool4000ROol20004Ool20005Ool3000POol20004Ool20003Ool3000ROol20004Ool2
0004Ool2000WOol5000KOol004=oo`04001oogoo0008Ool00`00Oomoo`0ROol01000Oomoo`002goo
00<007ooOol07Woo00@007ooOol000Qoo`04001oogoo000POol01000Oomoo`0027oo00@007ooOol0
02Qoo`03001oogoo01]oo`00@goo00@007ooOol000Uoo`03001oogoo025oo`04001oogoo0008Ool5
000OOol01000Oomoo`0027oo00@007ooOol0021oo`04001oogoo0008Ool01000Oomoo`00:7oo00<0
07ooOol06goo0013Ool01000Oomoo`002Woo00<007ooOol087oo00@007ooOol000Qoo`04001oogoo
000POol01000Oomoo`0027oo0`008Goo00@007ooOol000Uoo`8002Uoo`03001oogoo01]oo`00@goo
00@007ooOol000Qoo`04001oogoo000QOol01000Oomoo`002Goo00<007oo000087oo00@007ooOol0
00Uoo`03001oogoo021oo`04001oogoo0008Ool01000Oomoo`00:7oo00<007ooOol06goo0014Ool2
000:Ool2000SOol2000;Ool2000QOol2000:Ool3000QOol2000:Ool2000XOol2000MOol00?moob]o
o`006goo00<007ooOol0ogoo3Goo000KOol00`00Oomoo`3oOol=Ool001]oo`03001oogoo0?moo`eo
o`006goo00<007ooOol0oWoo0P0037oo000EOol60003O03e0008Ool01000Oomoo`002goo000KOol0
0`00Oomoo`04O005Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`0:
Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09
Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09
Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09
Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool001]oo`03001oogoo00Aoo`Al02Eoo`03001oogoo02io
o`03001oogoo02eoo`03001oogoo02eoo`03001oogoo02eoo`03001oogoo00]oo`D000]oo`006goo
00<007ooOol027oo17`0lGoo00<007ooOol037oo000KOol00`00Oomoo`0<Ool4O03lOol001]oo`80
015oo`Al0?Qoo`006goo00<007ooOol057oo0W`0mWoo000KOol00`00Oomoo`0FOol00g`0Oomoo`3c
Ool001]oo`03001oogoo01Moo`03O01oogoo0?9oo`006goo00<007ooOol05goo00=l07ooOol0lWoo
000KOol00`00Oomoo`0HOol00g`0Oomoo`3aOol001]oo`8001Yoo`03O01oogoo0?1oo`006goo00<0
07ooOol06Woo00=l07ooOol0kgoo000KOol00`00Oomoo`0KOol00g`0Oomoo`3^Ool001]oo`03001o
ogoo01aoo`03O01oogoo0>eoo`006goo00<007ooOol077oo00=l07ooOol0kGoo000KOol2000NOol0
0g`0Oomoo`3/Ool001]oo`03001oogoo01ioo`03O01oogoo0>]oo`006goo00<007ooOol07goo00=l
07ooOol0jWoo000KOol00`00Oomoo`0POol00g`0Oomoo`3YOol000Qoo`8000Aoo`8000=oo`@000Ao
o`03001oogoo025oo`03O01oogoo0>Qoo`001goo00@007ooOol000Qoo`03001oogoo00Eoo`03001o
ogoo025oo`03O01oogoo0>Qoo`001goo00@007ooOol000Uoo`03001oogoo00Aoo`<0029oo`03O01o
ogoo0>Moo`001goo00@007ooOol000Yoo`03001oogoo00=oo`03001oogoo02=oo`03O01oogoo0>Io
o`001goo00@007ooOol000Qoo`04001oogoo0004Ool00`00Oomoo`0TOol00g`0Oomoo`3UOol000Qo
o`8000Yoo`8000Eoo`03001oogoo02Eoo`03O01oogoo0>Aoo`006goo00<007ooOol09Woo00=l07oo
Ool0hgoo000KOol2000WOol00g`0Oomoo`3SOol001]oo`03001oogoo02Moo`03O01oogoo0>9oo`00
6goo00<007ooOol0:7oo00=l07ooOol0hGoo000KOol00`00Oomoo`0YOol00g`0Oomoo`3POol001]o
o`03001oogoo02Yoo`03O01oogoo0=moo`006goo0P00;7oo00=l07ooOol0gWoo000KOol00`00Oomo
o`0[Ool00g`0Oomoo`3NOol001]oo`03001oogoo02aoo`03O01oogoo0=eoo`006goo00<007ooOol0
;Goo00=l07ooOol0g7oo000KOol00`00Oomoo`0^Ool00g`0Oomoo`3KOol001]oo`03001oogoo02io
o`03O01oogoo0=]oo`006goo0P00<7oo00=l07ooOol0fWoo000KOol00`00Oomoo`0`Ool00g`0Oomo
o`3IOol001]oo`03001oogoo031oo`03O01oogoo0=Uoo`0027oo0P0017oo0P001Goo0`000goo00<0
07ooOol0<Goo00=l07ooOol0f7oo0007Ool01000Oomoo`002goo00<007ooOol00Woo00<007ooOol0
<Goo00=l07ooOol0f7oo0007Ool01000Oomoo`0027oo1@000goo0`00<Woo00=l07ooOol0egoo0007
Ool01000Oomoo`0027oo00@007ooOol000Aoo`03001oogoo03=oo`03O01oogoo0=Ioo`001goo00@0
07ooOol000Uoo`03001oo`0000Aoo`03001oogoo03=oo`03O01oogoo0=Ioo`0027oo0P002goo0P00
17oo00<007ooOol0=7oo00=l07ooOol0eGoo000KOol00`00Oomoo`0eOol00g`0Oomoo`3DOol001]o
o`8003Ioo`03O01oogoo0=Aoo`006goo00<007ooOol0=Woo00=l07ooOol0dgoo000KOol00`00Oomo
o`0gOol00g`0Oomoo`3BOol001]oo`03001oogoo03Moo`03O01oogoo0=9oo`006goo00<007ooOol0
>7oo00=l07ooOol0dGoo000KOol00`00Oomoo`0iOol00g`0Oomoo`3@Ool001]oo`8003Yoo`03O01o
ogoo0=1oo`006goo00<007ooOol0>Woo00=l07ooOol0cgoo000KOol00`00Oomoo`0jOol00g`0Oomo
o`3?Ool001]oo`03001oogoo03]oo`03O01oogoo0<ioo`006goo00<007ooOol0?7oo00=l07ooOol0
cGoo000KOol2000mOol00g`0Oomoo`3=Ool001]oo`03001oogoo03eoo`03O01oogoo0<aoo`006goo
00<007ooOol0?Woo00=l07ooOol0bgoo0008Ool20004Ool20003Ool30005Ool00`00Oomoo`0nOol0
0g`0Oomoo`3;Ool000Moo`04001oogoo0008Ool01000Oomoo`0017oo00<007ooOol0?goo00=l07oo
Ool0bWoo0007Ool01000Oomoo`0027oo00@007ooOol000Aoo`<0041oo`03O01oogoo0<Uoo`001goo
00@007ooOol000Qoo`<000Eoo`03001oogoo041oo`03O01oogoo0<Uoo`001goo00@007ooOol000Uo
o`03001oogoo00Aoo`03001oogoo045oo`03O01oogoo0<Qoo`0027oo0P002Woo0`0017oo00<007oo
Ool0@Woo00=l07ooOol0agoo000KOol00`00Oomoo`12Ool00g`0Oomoo`37Ool001]oo`03001oogoo
04=oo`03O01oogoo0<Ioo`006goo0P00A7oo00=l07ooOol0aWoo000KOol00`00Oomoo`14Ool00g`0
Oomoo`35Ool001]oo`03001oogoo04Eoo`03O01oogoo0<Aoo`006goo00<007ooOol0AGoo00=l07oo
Ool0a7oo000KOol00`00Oomoo`16Ool00g`0Oomoo`33Ool001]oo`8004Qoo`03O01oogoo0<9oo`00
6goo00<007ooOol0Agoo00=l07ooOol0`Woo000KOol00`00Oomoo`18Ool00g`0Oomoo`31Ool001]o
o`03001oogoo04Uoo`03O01oogoo0<1oo`006goo00<007ooOol0BGoo00=l07ooOol0`7oo000KOol2
001;Ool00g`0Oomoo`2oOol001]oo`03001oogoo04Yoo`03O01oogoo0;moo`006goo00<007ooOol0
Bgoo00=l07ooOol0_Woo000KOol00`00Oomoo`1<Ool00g`0Oomoo`2mOol000Qoo`8000Aoo`8000Ao
o`8000Eoo`03001oogoo04aoo`03O01oogoo0;eoo`001goo00@007ooOol000Qoo`04001oogoo0004
Ool00`00Oomoo`1=Ool00g`0Oomoo`2lOol000Moo`04001oogoo0008Ool01000Oomoo`0017oo0`00
CWoo00=l07ooOol0^goo0007Ool01000Oomoo`002Goo0P001Goo00<007ooOol0CWoo00=l07ooOol0
^goo0007Ool01000Oomoo`0027oo00@007ooOol000Aoo`03001oogoo04moo`03O01oogoo0;Yoo`00
27oo0P002Woo0P001Goo00<007ooOol0Cgoo00=l07ooOol0^Woo000KOol00`00Oomoo`1@Ool00g`0
Oomoo`2iOol001]oo`80059oo`03O01oogoo0;Qoo`006goo00<007ooOol0DGoo00=l07ooOol0^7oo
000KOol00`00Oomoo`1BOol00g`0Oomoo`2gOol001]oo`03001oogoo05=oo`03O01oogoo09Moo`9l
01eoo`006goo00<007ooOol0Dgoo00=l07ooOol0UGoo0W`07goo000KOol2001EOol00g`0Oomoo`2A
Ool3O00QOol001]oo`03001oogoo05Eoo`03O01oogoo08eoo`=l02Aoo`006goo00<007ooOol0EGoo
00=l07ooOol0Rgoo0W`09goo000KOol00`00Oomoo`1FOol00g`0Oomoo`27Ool3O00YOol001]oo`03
001oogoo05Ioo`03O01oogoo08Aoo`=l02aoo`006goo00<007ooOol0Egoo00=l07ooOol0PGoo0W`0
;goo000KOol2001IOol00g`0Oomoo`1mOol3O00aOol001]oo`03001oogoo05Qoo`03O01oogoo07Yo
o`=l03Aoo`006goo00<007ooOol0FGoo00=l07ooOol0Mgoo0W`0=goo000COol50003Ool00`00Oomo
o`1JOol00g`0Oomoo`1dOol2O00iOol001Eoo`03001oogoo00=oo`03001oogoo05Yoo`03O01oogoo
079oo`9l03]oo`005Goo00<007ooOol00goo0`00Fgoo00=l07ooOol0Kgoo0W`0?Goo000EOol00`00
Oomoo`03Ool00`00Oomoo`1KOol00g`0Oomoo`1]Ool2O00oOol001Eoo`03001oogoo00=oo`03001o
ogoo05aoo`03O01oogoo06Yoo`9l045oo`0057oo0P001Goo00<007ooOol0GGoo00=l07ooOol0Igoo
0W`0@goo000KOol00`00Oomoo`1MOol00g`0Oomoo`1UOol2O015Ool001]oo`8005moo`03O01oogoo
069oo`9l04Moo`006goo00<007ooOol0Ggoo00=l07ooOol0Ggoo0W`0BGoo000KOol00`00Oomoo`1P
Ool00g`0Oomoo`1LOol2O01;Ool001]oo`03001oogoo061oo`03O01oogoo05]oo`03O01oogoo04]o
o`006goo00<007ooOol0HGoo00=l07ooOol0F7oo0W`0CWoo000KOol00`00Oomoo`1ROol00g`0Oomo
o`1FOol00g`0Oomoo`1>Ool001]oo`8006Aoo`03O01oogoo05=oo`9l055oo`006goo00<007ooOol0
I7oo00=l07ooOol0DGoo00=l07ooOol0DGoo000KOol00`00Oomoo`1TOol00g`0Oomoo`1?Ool2O01D
Ool001]oo`03001oogoo06Eoo`03O01oogoo04eoo`03O01oogoo05Aoo`006goo00<007ooOol0IWoo
00=l07ooOol0BWoo0W`0Egoo000KOol2001XOol00g`0Oomoo`18Ool00g`0Oomoo`1GOol001]oo`03
001oogoo06Qoo`03O01oogoo04Eoo`9l05Yoo`006goo00<007ooOol0J7oo00=l07ooOol0A7oo00=l
07ooOol0FWoo000KOol00`00Oomoo`1YOol00g`0Oomoo`11Ool2O01MOol000Moo`D0009oo`8000=o
o`@000Aoo`03001oogoo06Yoo`03O01oogoo03moo`03O01oogoo05eoo`002Goo00<007ooOol01goo
00<007ooOol01Goo00<007ooOol0Jgoo00=l07ooOol0?7oo0W`0H7oo0009Ool00`00Oomoo`08Ool0
0`00Oomoo`04Ool3001/Ool00g`0Oomoo`0jOol00g`0Oomoo`1POol000Uoo`03001oogoo00Uoo`03
001oogoo00=oo`03001oogoo06aoo`03O01oogoo03Qoo`9l06=oo`002Goo00<007ooOol01goo00@0
07ooOol000Aoo`03001oogoo06eoo`03O01oogoo03Ioo`03O01oogoo06=oo`0027oo0P002Woo0P00
1Goo00<007ooOol0KWoo00=l07ooOol0=7oo00=l07ooOol0I7oo000KOol00`00Oomoo`1_Ool00g`0
Oomoo`0aOol2O01WOol001]oo`80075oo`03O01oogoo02moo`03O01oogoo06Moo`006goo00<007oo
Ool0L7oo00=l07ooOol0;Woo00=l07ooOol0J7oo000KOol00`00Oomoo`1aOol00g`0Oomoo`0[Ool2
O01[Ool001]oo`03001oogoo079oo`03O01oogoo02Uoo`03O01oogoo06]oo`006goo00<007ooOol0
Lgoo00=l07ooOol09goo00=l07ooOol0K7oo000KOol2001eOol00g`0Oomoo`0TOol2O01_Ool001]o
o`03001oogoo07Aoo`03O01oogoo02=oo`03O01oogoo06moo`006goo00<007ooOol0MGoo00=l07oo
Ool08Goo00=l07ooOol0L7oo000KOol00`00Oomoo`1fOol2O00OOol2O01cOol001]oo`03001oogoo
07Qoo`Al01Yoo`03O01oogoo07=oo`006goo00<007ooOol0O7oo0g`05Woo00=l07ooOol0M7oo000K
Ool20020Ool3O00AOol2O01gOol001]oo`03001oogoo089oo`Al00aoo`03O01oogoo07Moo`006goo
00<007ooOol0QWoo0g`027oo00=l07ooOol0N7oo0007Ool50002Ool20005Ool30003Ool00`00Oomo
o`29Ool4O002Ool2O01kOol000Uoo`03001oogoo00Yoo`03001oogoo009oo`03001oogoo08eoo`9l
07eoo`002Goo00<007ooOol01goo1@000goo0`00ogoo3Goo0009Ool00`00Oomoo`07Ool01000Oomo
o`0017oo00<007ooOol0ogoo3Goo0009Ool00`00Oomoo`08Ool00`00Ool00004Ool00`00Oomoo`3o
Ool=Ool000Qoo`8000]oo`8000Aoo`03001oogoo0?moo`eoo`00ogoo:goo003oOol[Ool00?moob]o
o`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo000J
Ool4003oOol=Ool001Uoo`04001oogoo003oOol>Ool001Uoo`04001oogoo003oOol>Ool001Qoo`80
0003Ool000000?moo`ioo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo0000\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.563, 0}} -> {-0.11539, -0.113606, \
0.00415184, 0.009342}}],

Cell[BoxData[
    InterpretationBox[\("M\[AAcute]ximo Desplazamiento: \
"\[InvisibleSpace]1.3906289327232666`\),
      SequenceForm[ "M\[AAcute]ximo Desplazamiento: ", 1.3906289327232666],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[IAcute]nimo Desplazamiento: "\[InvisibleSpace]0\),
      
      SequenceForm[ "M\[IAcute]nimo Desplazamiento: ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Velocidades:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.136338 0.201459 [
[.21429 .12384 -9 -9 ]
[.21429 .12384 9 0 ]
[.40476 .12384 -9 -9 ]
[.40476 .12384 9 0 ]
[.59524 .12384 -9 -9 ]
[.59524 .12384 9 0 ]
[.78571 .12384 -9 -9 ]
[.78571 .12384 9 0 ]
[.97619 .12384 -3 -9 ]
[.97619 .12384 3 0 ]
[1.025 .13634 0 -6.25 ]
[1.025 .13634 10 6.25 ]
[.01131 .03561 -24 -4.5 ]
[.01131 .03561 0 4.5 ]
[.01131 .23707 -18 -4.5 ]
[.01131 .23707 0 4.5 ]
[.01131 .3378 -6 -4.5 ]
[.01131 .3378 0 4.5 ]
[.01131 .43853 -18 -4.5 ]
[.01131 .43853 0 4.5 ]
[.01131 .53926 -6 -4.5 ]
[.01131 .53926 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .13634 m
.21429 .14259 L
s
[(0.2)] .21429 .12384 0 1 Mshowa
.40476 .13634 m
.40476 .14259 L
s
[(0.4)] .40476 .12384 0 1 Mshowa
.59524 .13634 m
.59524 .14259 L
s
[(0.6)] .59524 .12384 0 1 Mshowa
.78571 .13634 m
.78571 .14259 L
s
[(0.8)] .78571 .12384 0 1 Mshowa
.97619 .13634 m
.97619 .14259 L
s
[(1)] .97619 .12384 0 1 Mshowa
.125 Mabswid
.07143 .13634 m
.07143 .14009 L
s
.11905 .13634 m
.11905 .14009 L
s
.16667 .13634 m
.16667 .14009 L
s
.2619 .13634 m
.2619 .14009 L
s
.30952 .13634 m
.30952 .14009 L
s
.35714 .13634 m
.35714 .14009 L
s
.45238 .13634 m
.45238 .14009 L
s
.5 .13634 m
.5 .14009 L
s
.54762 .13634 m
.54762 .14009 L
s
.64286 .13634 m
.64286 .14009 L
s
.69048 .13634 m
.69048 .14009 L
s
.7381 .13634 m
.7381 .14009 L
s
.83333 .13634 m
.83333 .14009 L
s
.88095 .13634 m
.88095 .14009 L
s
.92857 .13634 m
.92857 .14009 L
s
.25 Mabswid
0 .13634 m
1 .13634 L
s
gsave
1.025 .13634 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .03561 m
.03006 .03561 L
s
[(-0.5)] .01131 .03561 1 0 Mshowa
.02381 .23707 m
.03006 .23707 L
s
[(0.5)] .01131 .23707 1 0 Mshowa
.02381 .3378 m
.03006 .3378 L
s
[(1)] .01131 .3378 1 0 Mshowa
.02381 .43853 m
.03006 .43853 L
s
[(1.5)] .01131 .43853 1 0 Mshowa
.02381 .53926 m
.03006 .53926 L
s
[(2)] .01131 .53926 1 0 Mshowa
.125 Mabswid
.02381 .05575 m
.02756 .05575 L
s
.02381 .0759 m
.02756 .0759 L
s
.02381 .09605 m
.02756 .09605 L
s
.02381 .11619 m
.02756 .11619 L
s
.02381 .15648 m
.02756 .15648 L
s
.02381 .17663 m
.02756 .17663 L
s
.02381 .19678 m
.02756 .19678 L
s
.02381 .21692 m
.02756 .21692 L
s
.02381 .25721 m
.02756 .25721 L
s
.02381 .27736 m
.02756 .27736 L
s
.02381 .29751 m
.02756 .29751 L
s
.02381 .31765 m
.02756 .31765 L
s
.02381 .35794 m
.02756 .35794 L
s
.02381 .37809 m
.02756 .37809 L
s
.02381 .39823 m
.02756 .39823 L
s
.02381 .41838 m
.02756 .41838 L
s
.02381 .45867 m
.02756 .45867 L
s
.02381 .47882 m
.02756 .47882 L
s
.02381 .49896 m
.02756 .49896 L
s
.02381 .51911 m
.02756 .51911 L
s
.02381 .01546 m
.02756 .01546 L
s
.02381 .5594 m
.02756 .5594 L
s
.02381 .57955 m
.02756 .57955 L
s
.02381 .59969 m
.02756 .59969 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 1 r
.5 Mabswid
.02381 .13634 m
.11905 .38456 L
.21429 .55819 L
.30952 .60332 L
.40476 .5884 L
.5 .39272 L
.59524 .04082 L
.69048 .01472 L
.78571 .04419 L
.88095 .06829 L
.97619 .08616 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.563},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^1000`40O003h00Oogoo:goo003oOol[
Ool001]oo`03001oogoo0?moo`eoo`006goo00<007ooOol0ogoo3Goo000KOol00`00Oomoo`3oOol=
Ool001]oo`03001oogoo0?moo`eoo`006goo0P00ZGoo17`OH7oo000KOol00`00Oomoo`2TOol4O1l4
Ool4O1mLOol001]oo`03001oogoo0:1oo`Al7`aoo`=l7eUoo`0027oo0P0017oo0P0017oo0P001Goo
00<007ooOol0W7oo17`O4goo17`OEGoo0007Ool01000Oomoo`0027oo00@007ooOol000Aoo`03001o
ogoo09Qoo`Al7a]oo`Al7e5oo`001goo00@007ooOol000]oo`03001oogoo009oo`8009Eoo`Al7b=o
o`=l7dioo`0000=oo`0000000P000Woo00@007ooOol000Uoo`8000Eoo`03001oogoo095oo`=l7bYo
o`Al7dYoo`001goo00@007ooOol000Uoo`03001oogoo00Aoo`03001oogoo095oo`03O1moogoo02io
o`=l7dMoo`0027oo0P002Woo0`0017oo00<007ooOol0T7oo00=l7gooOol0<Woo17`O@goo000KOol0
0`00Oomoo`2@Ool00g`OOomoo`0fOol3O1m0Ool001]oo`80095oo`03O1moogoo03Uoo`Al7caoo`00
6goo00<007ooOol0T7oo00=l7gooOol0?Goo17`O>7oo000KOol00`00Oomoo`2?Ool00g`OOomoo`12
Ool3O1leOol001]oo`03001oogoo08moo`03O1moogoo04Eoo`Al7c5oo`006goo00<007ooOol0Sgoo
00=l7gooOol0BGoo1G`O;7oo000KOol00`00Oomoo`2?Ool00g`OOomoo`1>Ool6O1lVOol001]oo`80
08moo`03O1moogoo05Eoo`Il7b1oo`006goo00<007ooOol0SWoo00=l7gooOol0Fgoo1W`O6Woo000K
Ool00`00Oomoo`2>Ool00g`OOomoo`1QOol3O1lGOol001]oo`03001oogoo08ioo`03O1moogoo07]o
o`006goo00<007ooOol09goo0P0017oo0P000goo10008goo0P0017oo0P001Goo0`008Goo0P0000Ao
og`OOomoo`8000=oo`<002Aoo`8000Aoo`8000Aoo`8002Qoo`D001Eoo`006goo0P009goo00@007oo
Ool000Qoo`03001oogoo02=oo`04001oogoo000;Ool00`00Oomoo`0OOol01@00Oomoo`00O1l01goo
00@007ooOol0029oo`04001oogoo0008Ool01000Oomoo`00:Goo00<007ooOol05Goo000KOol00`00
Oomoo`0VOol01000Oomoo`002Goo00<007ooOol08Woo00@007ooOol000Qoo`D0021oo`05001oogoo
001l7`07Ool01000Oomoo`008Woo00@007ooOol000Qoo`04001oogoo000YOol00`00Oomoo`0EOol0
01]oo`03001oogoo02Ioo`04001oogoo000:Ool00`00Oomoo`0QOol01000Oomoo`0027oo00@007oo
Ool0025oo`05001oogoo001l7`07Ool3000SOol01000Oomoo`002Goo0P00:Woo00<007ooOol05Goo
000KOol00`00Oomoo`0VOol01000Oomoo`0027oo00@007ooOol0029oo`04001oogoo0009Ool00`00
Ool0000QOol01000Oomoog`O2Goo00<007ooOol08Woo00@007ooOol000Qoo`04001oogoo000YOol0
0`00Oomoo`0EOol001]oo`03001oogoo02Moo`8000Yoo`8002Aoo`8000]oo`80029oo`800003O1mo
ogoo00Moo`<002=oo`8000Yoo`8002Uoo`8001Moo`006goo0P00SGoo00=l7gooOol0OGoo000KOol0
0`00Oomoo`2<Ool00g`OOomoo`1mOol001]oo`03001oogoo08]oo`03O1moogoo07ioo`006goo00<0
07ooOol0Rgoo00=l7gooOol0OWoo000KOol00`00Oomoo`2;Ool00g`OOomoo`1gOol20005Ool001Eo
o`H00003O1l0000008X00003O1l0000006l000Qoo`04001oogoo0004Ool001]oo`03O1moogoo00Uo
o`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uo
o`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uo
o`03001oogoo009oo`03O1moogoo00Aoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Yo
o`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Uo
o`03001oogoo00eoo`03001oogoo00Eoo`006goo00<007`OOol0;Woo00<007ooOol0;goo00<007oo
Ool09goo00=l7gooOol017oo00<007ooOol0;goo00<007ooOol0;Woo00<007ooOol037oo1@0017oo
000KOol00`00O1moo`2:Ool00g`OOomoo`1gOol00`00Oomoo`05Ool001]oo`03001oog`O08Uoo`03
O1moogoo081oo`006goo00<007ooO1l0RGoo00=l7gooOol0P7oo000KOol200000g`OOomoo`27Ool0
0g`OOomoo`20Ool001]oo`04001oogooO1n8Ool00g`OOomoo`20Ool001]oo`04001oogooO1n7Ool0
0g`OOomoo`21Ool001]oo`04001oogooO1n7Ool00g`OOomoo`21Ool001]oo`05001oogooOoml7`26
Ool00g`OOomoo`21Ool001]oo`80009oo`03O1moogoo08Aoo`03O1moogoo085oo`006goo00<007oo
Ool00Woo00=l7gooOol0PWoo00=l7gooOol0PWoo000KOol00`00Oomoo`02Ool00g`OOomoo`22Ool0
0g`OOomoo`22Ool001]oo`03001oogoo009oo`03O1moogoo089oo`03O1moogoo089oo`006goo00<0
07ooOol00goo00=l7gooOol0PGoo00=l7gooOol0PWoo000KOol20004Ool00g`OOomoo`20Ool00g`O
Oomoo`23Ool001]oo`03001oogoo00Aoo`03O1moogoo07moo`03O1moogoo08=oo`006goo00<007oo
Ool017oo00=l7gooOol0Ogoo00=l7gooOol0Pgoo000KOol00`00Oomoo`04Ool00g`OOomoo`1oOol0
0g`OOomoo`23Ool001]oo`03001oogoo00Eoo`03O1moogoo07eoo`03O1moogoo08Aoo`006goo0P00
1Woo00=l7gooOol0OGoo00=l7gooOol0Q7oo000KOol00`00Oomoo`05Ool00g`OOomoo`1mOol00g`O
Oomoo`24Ool001]oo`03001oogoo00Ioo`03O1moogoo07]oo`03O1moogoo08Eoo`006goo00<007oo
Ool01Woo00=l7gooOol0Ngoo00=l7gooOol0QGoo0008Ool20004Ool20004Ool20005Ool00`00Oomo
o`07Ool00g`OOomoo`1jOol00g`OOomoo`25Ool000Moo`04001oogoo0008Ool01000Oomoo`0017oo
00<007ooOol01goo00=l7gooOol0NWoo00=l7gooOol0QGoo0007Ool01000Oomoo`002goo00<007oo
Ool00Woo0P0027oo00=l7gooOol0NGoo00=l7gooOol0QWoo0007Ool01000Oomoo`002Goo0P001Goo
00<007ooOol027oo00=l7gooOol0N7oo00=l7gooOol0QWoo0007Ool01000Oomoo`002Goo00<007oo
Ool017oo00<007ooOol027oo00=l7gooOol0N7oo00=l7gooOol0QWoo0008Ool2000:Ool30004Ool0
0`00Oomoo`09Ool00g`OOomoo`1gOol00g`OOomoo`26Ool001]oo`03001oogoo00Uoo`03O1moogoo
07Ioo`03O1moogoo08Moo`006goo0P002Woo00=l7gooOol0MWoo00=l7gooOol0Qgoo000KOol00`00
Oomoo`0:Ool00g`OOomoo`1eOol00g`OOomoo`27Ool001]oo`03001oogoo00Yoo`03O1moogoo07Eo
o`03O1moogoo08Moo`006goo00<007ooOol02Woo00=l7gooOol0M7oo00=l7gooOol0R7oo000KOol0
0`00Oomoo`0;Ool00g`OOomoo`1cOol00g`OOomoo`28Ool001]oo`8000aoo`03O1moogoo07=oo`03
O1moogoo08Qoo`006goo00<007ooOol037oo00=l7gooOol0LWoo00=l7gooOol0R7oo000KOol00`00
Oomoo`0<Ool00g`OOomoo`1aOol00g`OOomoo`29Ool001]oo`03001oogoo00aoo`03O1moogoo075o
o`03O1moogoo08Uoo`006goo00<007ooOol03Goo00=l7gooOol0L7oo00=l7gooOol0RGoo000KOol2
000>Ool00g`OOomoo`1`Ool00g`OOomoo`29Ool001]oo`03001oogoo00ioo`03O1moogoo06ioo`03
O1moogoo08Yoo`006goo00<007ooOol03Woo00=l7gooOol0KWoo00=l7gooOol0RWoo000KOol00`00
Oomoo`0>Ool00g`OOomoo`1^Ool00g`OOomoo`2:Ool001]oo`03001oogoo00moo`03O1moogoo06ao
o`03O1moogoo08]oo`006goo0P0047oo00=l7gooOol0K7oo00=l7gooOol0Rgoo000KOol00`00Oomo
o`0?Ool00g`OOomoo`1/Ool00g`OOomoo`2;Ool001]oo`03001oogoo011oo`03O1moogoo06]oo`03
O1moogoo08]oo`006goo00<007ooOol047oo00=l7gooOol0JWoo00=l7gooOol0S7oo000COol50003
Ool00`00Oomoo`0AOol00g`OOomoo`1YOol00g`OOomoo`2<Ool001Eoo`03001oogoo00=oo`03001o
ogoo015oo`03O1moogoo06Uoo`03O1moogoo08aoo`005Goo00<007ooOol00goo0P004Woo00=l7goo
Ool0JGoo00=l7gooOol0S7oo000EOol00`00Oomoo`03Ool00`00Oomoo`0BOol00g`OOomoo`1WOol0
0g`OOomoo`2=Ool001Eoo`03001oogoo00=oo`03001oogoo019oo`03O1moogoo06Moo`03O1moogoo
08eoo`0057oo0P001Goo00<007ooOol04goo00=l7gooOol0IWoo00=l7gooOol0SGoo000KOol00`00
Oomoo`0COol00g`OOomoo`1VOol00g`OOomoo`2=Ool001]oo`8001Aoo`03O1moogoo06Eoo`03O1mo
ogoo08ioo`006goo00<007ooOol057oo00=l7gooOol0I7oo00=l7gooOol0SWoo000KOol00`00Oomo
o`0DOol00g`OOomoo`1TOol00g`OOomoo`2>Ool001]oo`03001oogoo01Aoo`03O1moogoo06Aoo`03
O1moogoo08ioo`006goo00<007ooOol05Goo00=l7gooOol0HWoo00=l7gooOol0Sgoo000KOol2000F
Ool00g`OOomoo`1ROol00g`OOomoo`2?Ool001]oo`03001oogoo01Ioo`03O1moogoo065oo`03O1mo
ogoo08moo`006goo00<007ooOol05Woo00=l7gooOol0HGoo00=l7gooOol0Sgoo000KOol00`00Oomo
o`0GOol00g`OOomoo`1OOol00g`OOomoo`2@Ool001]oo`03001oogoo01Moo`03O1moogoo05moo`03
O1moogoo091oo`006goo0P006Goo00=l7gooOol0GWoo00=l7gooOol0T7oo000KOol00`00Oomoo`0H
Ool00g`OOomoo`1MOol00g`OOomoo`2AOol001]oo`03001oogoo01Uoo`03O1moogoo05aoo`03O1mo
ogoo095oo`006goo00<007ooOol06Goo00=l7gooOol0Fgoo00=l7gooOol0TWoo000KOol00`00Oomo
o`0JOol00g`OOomoo`1JOol00g`OOomoo`2BOol001]oo`03001oogoo01Yoo`03O1moogoo05Uoo`03
O1moogoo09=oo`006goo0P0077oo00=l7gooOol0F7oo00=l7gooOol0Tgoo000KOol00`00Oomoo`0K
Ool00g`OOomoo`1GOol00g`OOomoo`2DOol001]oo`03001oogoo01aoo`03O1moogoo05Ioo`03O1mo
ogoo09Aoo`001goo1@000Woo0P0017oo0P001Goo00<007ooOol077oo00=l7gooOol0EGoo00=l7goo
Ool0UGoo0009Ool00`00Oomoo`07Ool01000Oomoo`0017oo00<007ooOol07Goo00=l7gooOol0E7oo
00=l7gooOol0UGoo0009Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool2000NOol00g`OOomoo`1COol0
0g`OOomoo`2FOol000Uoo`03001oogoo00Qoo`8000Eoo`03001oogoo01ioo`03O1moogoo059oo`03
O1moogoo09Ioo`002Goo00<007ooOol027oo00<007ooOol017oo00<007ooOol07goo00=l7gooOol0
D7oo00=l7gooOol0Ugoo0008Ool2000:Ool30004Ool00`00Oomoo`0OOol00g`OOomoo`1@Ool00g`O
Oomoo`2GOol001]oo`03001oogoo021oo`03O1moogoo04ioo`03O1moogoo09Qoo`006goo0P008Goo
00=l7gooOol0CWoo00=l7gooOol0V7oo000KOol00`00Oomoo`0QOol00g`OOomoo`1<Ool00g`OOomo
o`2IOol001]oo`03001oogoo025oo`03O1moogoo04aoo`03O1moogoo09Uoo`006goo00<007ooOol0
8Woo00=l7gooOol0BWoo00=l7gooOol0VWoo000KOol00`00Oomoo`0ROol00g`OOomoo`1:Ool00g`O
Oomoo`2JOol001]oo`8002Aoo`03O1moogoo04Qoo`03O1moogoo09]oo`006goo00<007ooOol08goo
00=l7gooOol0B7oo00=l7gooOol0Vgoo000KOol00`00Oomoo`0TOol00g`OOomoo`16Ool00g`OOomo
o`2LOol001]oo`03001oogoo02Aoo`03O1moogoo04Ioo`03O1moogoo09aoo`006goo00<007ooOol0
9Goo00=l7gooOol0A7oo00=l7gooOol0WGoo000KOol00`00Oomoo`0UOol00g`OOomoo`14Ool00g`O
Oomoo`2MOol001]oo`8002Moo`03O1moogoo049oo`03O1moogoo09ioo`006goo00<007ooOol09goo
00=l7gooOol0@Goo00=l7gooOol0WWoo000KOol00`00Oomoo`0WOol00g`OOomoo`10Ool00g`OOomo
o`2OOol001]oo`03001oogoo02Qoo`03O1moogoo03moo`03O1moogoo09moo`006goo00<007ooOol0
:7oo00=l7gooOol0?Woo00=l7gooOol0X7oo000KOol2000ZOol00g`OOomoo`0mOol00g`OOomoo`2P
Ool001]oo`03001oogoo02Uoo`03O1moogoo03aoo`03O1moogoo0:5oo`006goo00<007ooOol0:Woo
00=l7gooOol0>goo00=l7gooOol0XGoo000COol40004Ool00`00Oomoo`0ZOol00g`OOomoo`0jOol0
0g`OOomoo`2ROol001=oo`03001oogoo00Eoo`03001oogoo02]oo`03O1moogoo03Uoo`03O1moogoo
0:9oo`0057oo00<007ooOol017oo0P00;7oo00=l7gooOol0>7oo00=l7gooOol0Xgoo000EOol00`00
Oomoo`03Ool00`00Oomoo`0/Ool00g`OOomoo`0gOol00g`OOomoo`2SOol001=oo`04001oogoo0004
Ool00`00Oomoo`0/Ool00g`OOomoo`0fOol00g`OOomoo`2TOol001Aoo`8000Eoo`03001oogoo02eo
o`03O1moogoo03Eoo`03O1moogoo0:Aoo`006goo00<007ooOol0;Goo00=l7gooOol0=7oo00=l7goo
Ool0YGoo000KOol2000_Ool2O1ldOol00g`OOomoo`2UOol001]oo`03001oogoo031oo`9l7c5oo`03
O1moogoo0:Ioo`006goo00<007ooOol0<Woo0W`O;goo00=l7gooOol0YWoo000KOol00`00Oomoo`0d
Ool2O1l/Ool00g`OOomoo`2WOol001]oo`03001oogoo03Ioo`9l7bYoo`03O1moogoo0:Moo`006goo
00<007ooOol0>7oo0W`O9goo00=l7gooOol0Z7oo000KOol2000kOol2O1lUOol00g`OOomoo`2XOol0
01]oo`03001oogoo03aoo`9l7b9oo`03O1moogoo0:Uoo`006goo00<007ooOol0?Woo0W`O7Goo17`O
Zgoo000KOol00`00Oomoo`10Ool2O1lEOol6O1n_Ool001]oo`03001oogoo049oo`9l7`eoo`Il7kEo
o`006goo0P00AGoo0W`O1Goo1W`O^goo000KOol00`00Oomoo`16Ool5O1o1Ool001]oo`03001oogoo
0?moo`eoo`006goo00<007ooOol0ogoo3Goo000KOol00`00Oomoo`3oOol=Ool001]oo`03001oogoo
0?moo`eoo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo
:goo003oOol[Ool00?moob]oo`00ogoo:goo000JOol2003oOol?Ool001Yoo`800?moo`moo`006Goo
00@007ooOol00?moo`ioo`0067oo0P000Woo0P00ogoo3Goo003oOol[Ool00?moob]oo`00ogoo:goo
003oOol[Ool00?moob]oo`00ogoo:goo0000\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.563, 0}} -> {-0.11003, -0.71335, \
0.0040375, 0.0190869}}],

Cell[BoxData[
    InterpretationBox[\("M\[AAcute]xima Velocidad: \
"\[InvisibleSpace]2.3179955754695736`\),
      SequenceForm[ "M\[AAcute]xima Velocidad: ", 2.3179955754695736],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[IAcute]nima Velocidad: \
"\[InvisibleSpace]\(-0.6037133796487448`\)\),
      SequenceForm[ "M\[IAcute]nima Velocidad: ", -.60371337964874483],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Aceleraciones:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.364222 0.011924 [
[.21429 .35172 -9 -9 ]
[.21429 .35172 9 0 ]
[.40476 .35172 -9 -9 ]
[.40476 .35172 9 0 ]
[.59524 .35172 -9 -9 ]
[.59524 .35172 9 0 ]
[.78571 .35172 -9 -9 ]
[.78571 .35172 9 0 ]
[.97619 .35172 -3 -9 ]
[.97619 .35172 3 0 ]
[1.025 .36422 0 -6.25 ]
[1.025 .36422 10 6.25 ]
[.01131 .0065 -18 -4.5 ]
[.01131 .0065 0 4.5 ]
[.01131 .12574 -18 -4.5 ]
[.01131 .12574 0 4.5 ]
[.01131 .24498 -18 -4.5 ]
[.01131 .24498 0 4.5 ]
[.01131 .48346 -12 -4.5 ]
[.01131 .48346 0 4.5 ]
[.01131 .6027 -12 -4.5 ]
[.01131 .6027 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .36422 m
.21429 .37047 L
s
[(0.2)] .21429 .35172 0 1 Mshowa
.40476 .36422 m
.40476 .37047 L
s
[(0.4)] .40476 .35172 0 1 Mshowa
.59524 .36422 m
.59524 .37047 L
s
[(0.6)] .59524 .35172 0 1 Mshowa
.78571 .36422 m
.78571 .37047 L
s
[(0.8)] .78571 .35172 0 1 Mshowa
.97619 .36422 m
.97619 .37047 L
s
[(1)] .97619 .35172 0 1 Mshowa
.125 Mabswid
.07143 .36422 m
.07143 .36797 L
s
.11905 .36422 m
.11905 .36797 L
s
.16667 .36422 m
.16667 .36797 L
s
.2619 .36422 m
.2619 .36797 L
s
.30952 .36422 m
.30952 .36797 L
s
.35714 .36422 m
.35714 .36797 L
s
.45238 .36422 m
.45238 .36797 L
s
.5 .36422 m
.5 .36797 L
s
.54762 .36422 m
.54762 .36797 L
s
.64286 .36422 m
.64286 .36797 L
s
.69048 .36422 m
.69048 .36797 L
s
.7381 .36422 m
.7381 .36797 L
s
.83333 .36422 m
.83333 .36797 L
s
.88095 .36422 m
.88095 .36797 L
s
.92857 .36422 m
.92857 .36797 L
s
.25 Mabswid
0 .36422 m
1 .36422 L
s
gsave
1.025 .36422 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .0065 m
.03006 .0065 L
s
[(-30)] .01131 .0065 1 0 Mshowa
.02381 .12574 m
.03006 .12574 L
s
[(-20)] .01131 .12574 1 0 Mshowa
.02381 .24498 m
.03006 .24498 L
s
[(-10)] .01131 .24498 1 0 Mshowa
.02381 .48346 m
.03006 .48346 L
s
[(10)] .01131 .48346 1 0 Mshowa
.02381 .6027 m
.03006 .6027 L
s
[(20)] .01131 .6027 1 0 Mshowa
.125 Mabswid
.02381 .03035 m
.02756 .03035 L
s
.02381 .0542 m
.02756 .0542 L
s
.02381 .07805 m
.02756 .07805 L
s
.02381 .10189 m
.02756 .10189 L
s
.02381 .14959 m
.02756 .14959 L
s
.02381 .17344 m
.02756 .17344 L
s
.02381 .19729 m
.02756 .19729 L
s
.02381 .22113 m
.02756 .22113 L
s
.02381 .26883 m
.02756 .26883 L
s
.02381 .29268 m
.02756 .29268 L
s
.02381 .31653 m
.02756 .31653 L
s
.02381 .34037 m
.02756 .34037 L
s
.02381 .38807 m
.02756 .38807 L
s
.02381 .41192 m
.02756 .41192 L
s
.02381 .43577 m
.02756 .43577 L
s
.02381 .45961 m
.02756 .45961 L
s
.02381 .50731 m
.02756 .50731 L
s
.02381 .53116 m
.02756 .53116 L
s
.02381 .55501 m
.02756 .55501 L
s
.02381 .57885 m
.02756 .57885 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .36422 m
.11905 .56329 L
.21429 .60332 L
.30952 .49096 L
.40476 .40201 L
.5 .237 L
.59524 .01472 L
.69048 .09485 L
.78571 .16507 L
.88095 .21737 L
.97619 .25596 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.563},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^1000`40O003h00Oogoo:goo003oOol[
Ool000Yoo`8000Aoo`800?mooaUoo`002Goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomo
o`3oOolAOol000]oo`05001oogooOol00002Ool00`00Oomoo`02Ool3003oOolAOol000=oo`@000Eo
o`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`3oOolAOol000Uoo`04001oogoo0002Ool0
1000Oomoo`0017oo00<007ooOol0ogoo4Goo000:Ool20004Ool20005Ool00`00Oomoo`2BOol00`0O
Oomoo`1kOol001Moo`03001oogoo099oo`807gaoo`005goo00<007ooOol0TGoo00@07gooOol07g]o
o`005goo00<007ooOol0TGoo00@07gooOomoo`807gUoo`005goo0P00TGoo00<07gooOol017oo00<0
7gooOol0MWoo000GOol00`00Oomoo`2@Ool00`0OOomoo`05Ool00`0OOomoo`1eOol001Moo`03001o
ogoo091oo`0301moogoo00Ioo`0301moogoo07Aoo`005goo00<007ooOol0Sgoo00<07gooOol027oo
00<07gooOol0Lgoo000GOol00`00Oomoo`2?Ool00`0OOomoo`09Ool201mcOol001Moo`03001oogoo
08ioo`0301moogoo00aoo`0301moogoo071oo`005goo0P00Sgoo00<07gooOol03Goo00<07gooOol0
Kgoo000GOol00`00Oomoo`2=Ool00`0OOomoo`0?Ool00`0OOomoo`1^Ool001Moo`03001oogoo08eo
o`0301moogoo011oo`0301moogoo06eoo`005goo00<007ooOol0SGoo00<07gooOol04Goo0P0OKGoo
000GOol00`00Oomoo`2<Ool00`0OOomoo`0DOol00`0OOomoo`1ZOol001Moo`03001oogoo08aoo`03
01moogoo01Eoo`0301moogoo06Uoo`005goo0P00S7oo00<07gooOol05goo00<07gooOol0J7oo000G
Ool00`00Oomoo`2;Ool00`0OOomoo`0HOol00`0OOomoo`1WOol001Moo`03001oogoo08]oo`0301mo
ogoo01Uoo`807fMoo`005goo00<007ooOol0RWoo00<07gooOol077oo00<07gooOol0I7oo000GOol0
0`00Oomoo`2:Ool00`0OOomoo`0MOol00`0OOomoo`1SOol001Moo`03001oogoo08Uoo`0301moogoo
01moo`0301moogoo069oo`005goo0P00RWoo00<07gooOol087oo0P0OHWoo000GOol00`00Oomoo`28
Ool00`0OOomoo`0SOol00`0OOomoo`1OOol001Moo`03001oogoo08Qoo`0301moogoo02Aoo`0301mo
ogoo05ioo`005goo00<007ooOol0R7oo00<07gooOol09Goo0P0OGWoo000GOol00`00Oomoo`27Ool0
0`0OOomoo`0XOol00`0OOomoo`1KOol000Uoo`@000=oo`8000Eoo`03001oogoo08Moo`0301moogoo
02Uoo`807e]oo`002Goo00<007ooOol00goo00@007ooOol000Aoo`03001oogoo08Ioo`0301moogoo
02aoo`0301moogoo05Qoo`002Woo00<007ooOol00Woo00@007ooOol000Aoo`<008Ioo`0301moogoo
02eoo`0301moogoo05Moo`000goo100017oo00D007ooOomoo`00009oo`03001oogoo009oo`03001o
ogoo08Ioo`0301moogoo02ioo`807eMoo`002Goo00@007ooOol0009oo`04001oogoo0004Ool00`00
Oomoo`25Ool00`0OOomoo`0aOol00`0OOomoo`1DOol000Yoo`8000Aoo`8000Eoo`03001oogoo08Eo
o`0301moogoo039oo`0301moogoo05=oo`005goo00<007ooOol0Q7oo00<07gooOol0=7oo0P0ODgoo
000GOol00`00Oomoo`24Ool00`0OOomoo`0fOol00`0OOomoo`1@Ool001Moo`8008Eoo`0301moogoo
03Moo`807e1oo`005goo00<007ooOol0Pgoo00<07gooOol0>Woo00<07gooOol0CGoo000GOol00`00
Oomoo`23Ool00`0OOomoo`0kOol00`0OOomoo`1<Ool001Moo`03001oogoo089oo`0301moogoo03eo
o`807daoo`005goo00<007ooOol0PWoo00<07gooOol0?goo00<07gooOol0BGoo000GOol00`00Oomo
o`21Ool00`0OOomoo`11Ool201m9Ool001Moo`80089oo`0301moogoo04=oo`807dMoo`005goo00<0
07ooOol0PGoo00<07gooOol0AGoo0P0OAGoo000GOol00`00Oomoo`20Ool00`0OOomoo`18Ool201m3
Ool001Moo`03001oogoo081oo`0301moogoo04Yoo`0301moogoo041oo`005goo00<007ooOol0Ogoo
00<07gooOol0C7oo0P0O@7oo000GOol00`00Oomoo`1oOol00`0OOomoo`1>Ool201lnOol001Moo`80
081oo`0301moogoo051oo`807caoo`005goo00<007ooOol0OWoo00<07gooOol0Dgoo00<07gooOol0
>Goo000GOol00`00Oomoo`1nOol00`0OOomoo`1DOol201liOol001Moo`03001oogoo07eoo`0301mo
ogoo05Moo`807cMoo`005goo00<007ooOol0OGoo00<07gooOol0FGoo0P0O=Goo000GOol00`00Oomo
o`1lOol00`0OOomoo`1LOol201lcOol001Moo`03001oogoo07aoo`0301moogoo05ioo`807c5oo`00
5goo0P00OGoo00<07gooOol0H7oo0P0O;goo000GOol00`00Oomoo`1kOol00`0OOomoo`1SOol301l/
Ool001Moo`03001oogoo07]oo`0301moogoo06Ioo`807bYoo`005goo00<007ooOol0NWoo00<07goo
Ool0JGoo0`0O9goo0009Ool50002Ool20005Ool00`00Oomoo`1jOol00`0OOomoo`1/Ool201lUOol0
00]oo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`1iOol00`0OOomoo`1_Ool301lR
Ool000]oo`05001oogooOol00002Ool00`00Oomoo`02Ool3001iOol00`0OOomoo`1bOol201lPOol0
00=oo`@000Aoo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`1hOol00`0OOomoo`1e
Ool301lMOol000]oo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`1hOol00`0OOomo
o`1hOol201lKOol000Yoo`8000Aoo`8000Eoo`03001oogoo07Moo`0301moogoo07]oo`807aUoo`00
5goo00<007ooOol0Mgoo00<07gooOol0UWoo000GOol00`00Oomoo`1fOol00`0OOomoo`2GOol001Mo
o`8007Ioo`0301moogoo09Qoo`005goo00<007ooOol0MGoo00<07gooOol0V7oo000GOol00`00Oomo
o`1dOol00`0OOomoo`2IOol001Moo`03001oogoo07Aoo`0301moogoo09Uoo`005goo00<007ooOol0
Lgoo00<07gooOol0VWoo000GOol00`00Oomoo`1bOol00`0OOomoo`2KOol001Moo`8007=oo`0301mo
ogoo09]oo`005goo00<007ooOol0LGoo00<07gooOol0W7oo000GOol00`00Oomoo`1aOol00`0OOomo
o`2LOol001Moo`03001oogoo071oo`0301moogoo09eoo`005goo00<007ooOol0L7oo00<07gooOol0
WGoo000GOol00`00Oomoo`1_Ool00`0OOomoo`2NOol001Moo`03001oogoo06ioo`0301moogoo09mo
o`005goo0P00Kgoo00<07gooOol0Wgoo000GOol00`00Oomoo`0XOol20004Ool20003Ool4000SOol2
0004Ool20005Ool30003Ool00`0OOomoo`0KOol20004Ool20003Ool3000TOol20004Ool20004Ool2
000YOol5000GOol001Moo`03001oogoo02Moo`04001oogoo0008Ool00`00Oomoo`0SOol01000Oomo
o`002goo00<007ooOol00Woo00<07gooOol06Woo00@007ooOol000Qoo`04001oogoo000ROol01000
Oomoo`0027oo00@007ooOol002Yoo`03001oogoo01Moo`005goo00<007ooOol09goo00@007ooOol0
00Uoo`03001oogoo029oo`04001oogoo0008Ool50002Ool00`0OOomoo`0KOol01000Oomoo`0027oo
00@007ooOol0029oo`04001oogoo0008Ool01000Oomoo`00:Woo00<007ooOol05goo000GOol00`00
Oomoo`0WOol01000Oomoo`002Woo00<007ooOol08Goo00@007ooOol000Qoo`04001oogoo0002Ool0
0`0OOomoo`0LOol01000Oomoo`0027oo0`008goo00@007ooOol000Uoo`8002]oo`03001oogoo01Mo
o`005goo00<007ooOol09goo00@007ooOol000Qoo`04001oogoo000ROol01000Oomoo`002Goo00<0
07oo00000Woo00<07gooOol077oo00@007ooOol000Uoo`03001oogoo029oo`04001oogoo0008Ool0
1000Oomoo`00:Woo00<007ooOol05goo000GOol2000YOol2000:Ool2000TOol2000;Ool200000goo
01moo`0OOol2000:Ool3000SOol2000:Ool2000ZOol2000IOol001Moo`03001oogoo06Yoo`0301mo
ogoo0:=oo`005goo00<007ooOol0JGoo00<07gooOol0Y7oo000GOol00`00Oomoo`1YOol00`0OOomo
o`2TOol001Moo`03001oogoo06Qoo`0301moogoo0:Eoo`005goo00<007ooOol0Igoo00<07gooOol0
WGoo0P001goo000AOol600000`0O0000001W00000`0O0000002C0009Ool01000Oomoo`001Woo000G
Ool00`0OOomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`09
Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool00`0OOomoo`04
Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`09
Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`0:
Ool00`00Oomoo`09Ool00`00Oomoo`0=Ool00`00Oomoo`07Ool001Moo`0300007goo02moo`03001o
ogoo02moo`03001oogoo009oo`0301moogoo02Uoo`03001oogoo02moo`03001oogoo02moo`03001o
ogoo00aoo`D000Ioo`005goo00<0000OOol0IGoo00<07gooOol0WWoo00<007ooOol01goo000GOol0
0`00Ool07`1TOol00`0OOomoo`2YOol001Moo`03001oo`0O06Aoo`0301moogoo0:Uoo`005goo0P00
00=oo`0OOol0HGoo00<07gooOol0ZWoo000GOol01000Oomoo`0OHWoo00<07gooOol0ZWoo000GOol0
1@00Oomoogoo01l0H7oo00<07gooOol0Zgoo000GOol01@00Oomoogoo01l0H7oo00<07gooOol0Zgoo
000GOol00`00Oomoo`02Ool00`0OOomoo`1LOol00`0OOomoo`2/Ool001Moo`03001oogoo009oo`03
01moogoo05]oo`0301moogoo0:eoo`005goo00<007ooOol00goo00<07gooOol0FGoo00<07gooOol0
[Woo000GOol20004Ool00`0OOomoo`1HOol00`0OOomoo`2_Ool001Moo`03001oogoo00Aoo`0301mo
ogoo05Ioo`0301moogoo0;1oo`005goo00<007ooOol017oo00<07gooOol0EGoo00<07gooOol0/Goo
000GOol00`00Oomoo`05Ool00`0OOomoo`1BOol201ndOol001Moo`03001oogoo00Eoo`0301moogoo
055oo`0301moogoo0;Aoo`005goo00<007ooOol01Woo00<07gooOol0Cgoo00<07gooOol0]Goo000G
Ool20007Ool00`0OOomoo`1>Ool00`0OOomoo`2fOol001Moo`03001oogoo00Moo`0301moogoo04ao
o`0301moogoo0;Moo`005goo00<007ooOol01goo00<07gooOol0Bgoo00<07gooOol0^7oo000GOol0
0`00Oomoo`08Ool00`0OOomoo`19Ool00`0OOomoo`2iOol001Moo`03001oogoo00Qoo`0301moogoo
04Qoo`0301moogoo0;Yoo`005goo00<007ooOol02Goo00<07gooOol0AWoo00<07gooOol0^goo000G
Ool2000:Ool00`0OOomoo`15Ool00`0OOomoo`2lOol001Moo`03001oogoo00Uoo`0301moogoo04Ao
o`0301moogoo0;eoo`005goo00<007ooOol02Woo00<07gooOol0@Goo0P0O`7oo000GOol00`00Oomo
o`0:Ool00`0OOomoo`10Ool00`0OOomoo`30Ool000Uoo`D0009oo`8000Eoo`03001oogoo00]oo`03
01moogoo03ioo`0301moogoo0<5oo`002goo00D007ooOomoo`00009oo`03001oogoo009oo`03001o
ogoo00]oo`0301moogoo03eoo`0301moogoo0<9oo`002goo00D007ooOomoo`00009oo`03001oogoo
009oo`<000aoo`0301moogoo03]oo`0301moogoo0<=oo`002goo00D007ooOomoo`00009oo`03001o
ogoo009oo`03001oogoo00aoo`0301moogoo03Yoo`0301moogoo0<Aoo`002goo00D007ooOomoo`00
009oo`03001oogoo009oo`03001oogoo00eoo`0301moogoo03Qoo`0301moogoo0<Eoo`002Woo0P00
17oo0P001Goo00<007ooOol03Goo00<07gooOol0=goo00<07gooOol0aWoo000GOol00`00Oomoo`0>
Ool00`0OOomoo`0eOol00`0OOomoo`37Ool001Moo`03001oogoo00ioo`0301moogoo03Eoo`0301mo
ogoo0<Moo`005goo0P0047oo00<07gooOol0<goo00<07gooOol0b7oo000GOol00`00Oomoo`0?Ool0
0`0OOomoo`0bOol00`0OOomoo`39Ool001Moo`03001oogoo011oo`0301moogoo031oo`0301moogoo
0<Yoo`005goo00<007ooOol047oo00<07gooOol0;goo00<07gooOol0bgoo000GOol00`00Oomoo`0A
Ool00`0OOomoo`0]Ool00`0OOomoo`3<Ool001Moo`03001oogoo015oo`0301moogoo02eoo`0301mo
ogoo0<aoo`005goo00<007ooOol04Woo00<07gooOol0:goo00<07gooOol0cGoo000GOol2000COol0
0`0OOomoo`0ZOol00`0OOomoo`3>Ool001Moo`03001oogoo01=oo`0301moogoo02Qoo`0301moogoo
0<moo`005goo00<007ooOol04goo00<07gooOol09goo00<07gooOol0d7oo000GOol00`00Oomoo`0D
Ool00`0OOomoo`0UOol00`0OOomoo`3AOol001Moo`03001oogoo01Aoo`0301moogoo02Eoo`0301mo
ogoo0=5oo`005goo00<007ooOol05Goo00<07gooOol08goo00<07gooOol0dWoo000GOol2000FOol0
0`0OOomoo`0ROol00`0OOomoo`3COol001Moo`03001oogoo01Ioo`0301moogoo021oo`0301moogoo
0=Aoo`005goo00<007ooOol05Woo0P0O87oo00<07gooOol0eGoo000GOol00`00Oomoo`0HOol201lM
Ool00`0OOomoo`3FOol001Moo`03001oogoo01Yoo`807a]oo`0301moogoo0=Ioo`005goo00<007oo
Ool077oo0P0O67oo00<07gooOol0egoo000GOol2000OOol301lDOol00`0OOomoo`3HOol001Moo`03
001oogoo025oo`807a5oo`0301moogoo0=Uoo`005goo00<007ooOol08goo0P0O3Woo00<07gooOol0
fWoo000GOol00`00Oomoo`0UOol301l:Ool00`0OOomoo`3KOol000Uoo`@000=oo`8000Eoo`03001o
ogoo02Qoo`807`Qoo`0301moogoo0=]oo`002Goo00<007ooOol00goo00@007ooOol000Aoo`03001o
ogoo02Yoo`807`Eoo`0301moogoo0=aoo`002Woo00<007ooOol00Woo00@007ooOol000Aoo`<002ao
o`807`9oo`0301moogoo0=eoo`002goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo
02ioo`807n1oo`002Goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`3oOolAOol000Yo
o`8000Aoo`8000Eoo`03001oogoo0?mooa5oo`005goo00<007ooOol0ogoo4Goo003oOol[Ool00?mo
ob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo
003oOol[Ool00?moob]oo`005Goo1@00ogoo4Goo000EOol4003oOolBOol001Qoo`03001oogoo0?mo
oa1oo`005Woo0`00ogoo4Woo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00001\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.563, 0}} -> {-0.094126, -31.4427, \
0.00401269, 0.320497}}],

Cell[BoxData[
    InterpretationBox[\("M\[AAcute]xima Aceleraci\[OAcute]n: "\
\[InvisibleSpace]20.051690490004056`\),
      SequenceForm[ 
      "M\[AAcute]xima Aceleraci\[OAcute]n: ", 20.051690490004056],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[IAcute]nima Aceleraci\[OAcute]n: "\
\[InvisibleSpace]\(-29.31117580124944`\)\),
      SequenceForm[ 
      "M\[IAcute]nima Aceleraci\[OAcute]n: ", -29.311175801249441],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("t"\[InvisibleSpace]"         "\[InvisibleSpace]"p    \
    "\[InvisibleSpace]"     u"\[InvisibleSpace]"          \
v"\[InvisibleSpace]"         a"\),
      SequenceForm[ 
      "t", "         ", "p        ", "     u", "          v", "         a"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("---------------------------------------------------"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        InterpretationBox[GridBox[{
              {"0"},
              {"0.1`"},
              {"0.2`"},
              {"0.30000000000000004`"},
              {"0.4`"},
              {"0.5`"},
              {"0.6000000000000001`"},
              {"0.7000000000000001`"},
              {"0.8`"},
              {"0.9`"},
              {"1.`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0}]], 
        "\[InvisibleSpace]", "\<\"     \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"5.`"},
              {"8.66`"},
              {"10.`"},
              {"8.66`"},
              {"5.`"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 5.0, 8.6600000000000001, .1*^2, 8.6600000000000001, 
            5.0, 0, 0, 0, 0, 0}]], "\[InvisibleSpace]", "\<\"    \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"0.05749943414033176`"},
              {"0.3247545031227596`"},
              {"0.6938680411549537`"},
              {"1.0496519232419523`"},
              {"1.3288280997276432`"},
              {"1.3906289327232666`"},
              {"1.2224550313081222`"},
              {"1.0709685876259505`"},
              {"0.9579564334074229`"},
              {"0.8745758684087092`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .057499434140331762, .32475450312275961, .69386804115495371, 
            1.0496519232419523, 1.3288280997276432, 1.3906289327232666, 
            1.2224550313081222, 
            1.0709685876259505, .95795643340742287, .87457586840870916}]], 
        "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"1.232130731578538`"},
              {"2.093980952602865`"},
              {"2.3179955754695736`"},
              {"2.243927748393107`"},
              {"1.2726448367372631`"},
              {\(-0.47411538657987273`\)},
              {\(-0.6037133796487448`\)},
              {\(-0.45738290623629996`\)},
              {\(-0.3377929920277023`\)},
              {\(-0.24906032438510006`\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 1.2321307315785379, 2.0939809526028652, 
            2.3179955754695736, 2.2439277483931068, 
            1.2726448367372631, -.47411538657987273, -.60371337964874483, \
-.45738290623629996, -.3377929920277023, -.24906032438510006}]], 
        "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"16.695027422539987`"},
              {"20.051690490004056`"},
              {"10.628877587191889`"},
              {"3.169232935080213`"},
              {\(-10.66958175289606`\)},
              {\(-29.31117580124944`\)},
              {\(-22.590405905284147`\)},
              {\(-16.701860206687797`\)},
              {\(-12.31542977698678`\)},
              {\(-9.079427371544876`\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 16.695027422539987, 20.051690490004056, 
            10.628877587191889, 
            3.1692329350802129, -10.669581752896059, -29.311175801249441, \
-22.590405905284147, -16.701860206687797, -12.315429776986781, \
-9.0794273715448757}]]}],
      SequenceForm[ 
        TableForm[ {
          0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0}], "     ", 
        TableForm[ {0, 5.0, 8.6600000000000001, .1*^2, 8.6600000000000001, 
          5.0, 0, 0, 0, 0, 0}], "    ", 
        TableForm[ {
          0, .057499434140331762, .32475450312275961, .69386804115495371, 
          1.0496519232419523, 1.3288280997276432, 1.3906289327232666, 
          1.2224550313081222, 
          1.0709685876259505, .95795643340742287, .87457586840870916}], "   ",
         
        TableForm[ {0, 1.2321307315785379, 2.0939809526028652, 
          2.3179955754695736, 2.2439277483931068, 
          1.2726448367372631, -.47411538657987273, -.60371337964874483, \
-.45738290623629996, -.3377929920277023, -.24906032438510006}], "  ", 
        TableForm[ {0, 16.695027422539987, 20.051690490004056, 
          10.628877587191889, 
          3.1692329350802129, -10.669581752896059, -29.311175801249441, \
-22.590405905284147, -16.701860206687797, -12.315429776986781, \
-9.0794273715448757}]],
      Editable->False]], "Print"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{732, 500},
WindowMargins->{{-1, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 265, 7, 110, "Title"],
Cell[1985, 58, 761, 15, 215, "Subsection"],
Cell[2749, 75, 117, 3, 121, "Title"],
Cell[2869, 80, 11278, 176, 4582, "Input"],
Cell[14150, 258, 666, 18, 272, "Subsection"],

Cell[CellGroupData[{
Cell[14841, 280, 280, 8, 82, "Input"],
Cell[15124, 290, 376, 7, 25, "Print"],
Cell[15503, 299, 375, 7, 25, "Print"],
Cell[15881, 308, 374, 7, 25, "Print"],
Cell[16258, 317, 373, 7, 25, "Print"],
Cell[16634, 326, 373, 7, 25, "Print"],
Cell[17010, 335, 373, 7, 25, "Print"],
Cell[17386, 344, 373, 7, 25, "Print"],
Cell[17762, 353, 372, 7, 25, "Print"],
Cell[18137, 362, 370, 7, 25, "Print"],
Cell[18510, 371, 374, 7, 25, "Print"],
Cell[18887, 380, 373, 7, 25, "Print"],
Cell[19263, 389, 373, 7, 25, "Print"],
Cell[19639, 398, 373, 7, 25, "Print"],
Cell[20015, 407, 372, 7, 25, "Print"],
Cell[20390, 416, 374, 7, 25, "Print"],
Cell[20767, 425, 373, 7, 25, "Print"],
Cell[21143, 434, 373, 7, 25, "Print"],
Cell[21519, 443, 373, 7, 25, "Print"],
Cell[21895, 452, 372, 7, 25, "Print"],
Cell[22270, 461, 373, 7, 25, "Print"],
Cell[22646, 470, 373, 7, 25, "Print"],
Cell[23022, 479, 372, 7, 25, "Print"],
Cell[23397, 488, 373, 7, 25, "Print"],
Cell[23773, 497, 373, 7, 25, "Print"],
Cell[24149, 506, 373, 7, 25, "Print"],
Cell[24525, 515, 373, 7, 25, "Print"],
Cell[24901, 524, 373, 7, 25, "Print"],
Cell[25277, 533, 373, 7, 25, "Print"],
Cell[25653, 542, 373, 7, 25, "Print"],
Cell[26029, 551, 372, 7, 25, "Print"],
Cell[26404, 560, 371, 7, 25, "Print"],
Cell[26778, 569, 373, 7, 25, "Print"],
Cell[27154, 578, 371, 7, 25, "Print"],
Cell[27528, 587, 372, 7, 25, "Print"],
Cell[27903, 596, 373, 7, 25, "Print"],
Cell[28279, 605, 372, 7, 25, "Print"],
Cell[28654, 614, 373, 7, 25, "Print"],
Cell[29030, 623, 371, 7, 25, "Print"],
Cell[29404, 632, 372, 7, 25, "Print"],
Cell[29779, 641, 372, 7, 25, "Print"],
Cell[30154, 650, 373, 7, 25, "Print"],
Cell[30530, 659, 373, 7, 25, "Print"],
Cell[30906, 668, 373, 7, 25, "Print"],
Cell[31282, 677, 373, 7, 25, "Print"],
Cell[31658, 686, 372, 7, 25, "Print"],
Cell[32033, 695, 372, 7, 25, "Print"],
Cell[32408, 704, 372, 7, 25, "Print"],
Cell[32783, 713, 372, 7, 25, "Print"],
Cell[33158, 722, 371, 7, 25, "Print"],
Cell[33532, 731, 371, 7, 25, "Print"],
Cell[33906, 740, 372, 7, 25, "Print"],
Cell[34281, 749, 372, 7, 25, "Print"],
Cell[34656, 758, 372, 7, 25, "Print"],
Cell[35031, 767, 372, 7, 25, "Print"],
Cell[35406, 776, 372, 7, 25, "Print"],
Cell[35781, 785, 371, 7, 25, "Print"],
Cell[36155, 794, 371, 7, 25, "Print"],
Cell[36529, 803, 373, 7, 25, "Print"],
Cell[36905, 812, 371, 7, 25, "Print"],
Cell[37279, 821, 373, 7, 25, "Print"],
Cell[37655, 830, 372, 7, 25, "Print"],
Cell[38030, 839, 372, 7, 25, "Print"],
Cell[38405, 848, 371, 7, 25, "Print"],
Cell[38779, 857, 372, 7, 25, "Print"],
Cell[39154, 866, 372, 7, 25, "Print"],
Cell[39529, 875, 372, 7, 25, "Print"],
Cell[39904, 884, 372, 7, 25, "Print"],
Cell[40279, 893, 372, 7, 25, "Print"],
Cell[40654, 902, 372, 7, 25, "Print"],
Cell[41029, 911, 372, 7, 25, "Print"],
Cell[41404, 920, 372, 7, 25, "Print"],
Cell[41779, 929, 372, 7, 25, "Print"],
Cell[42154, 938, 371, 7, 25, "Print"],
Cell[42528, 947, 372, 7, 25, "Print"],
Cell[42903, 956, 372, 7, 25, "Print"],
Cell[43278, 965, 372, 7, 25, "Print"],
Cell[43653, 974, 372, 7, 25, "Print"],
Cell[44028, 983, 372, 7, 25, "Print"],
Cell[44403, 992, 372, 7, 25, "Print"],
Cell[44778, 1001, 372, 7, 25, "Print"],
Cell[45153, 1010, 372, 7, 25, "Print"],
Cell[45528, 1019, 372, 7, 25, "Print"],
Cell[45903, 1028, 372, 7, 25, "Print"],
Cell[46278, 1037, 372, 7, 25, "Print"],
Cell[46653, 1046, 372, 7, 25, "Print"],
Cell[47028, 1055, 372, 7, 25, "Print"],
Cell[47403, 1064, 369, 7, 25, "Print"],
Cell[47775, 1073, 372, 7, 25, "Print"],
Cell[48150, 1082, 372, 7, 25, "Print"],
Cell[48525, 1091, 372, 7, 25, "Print"],
Cell[48900, 1100, 372, 7, 25, "Print"],
Cell[49275, 1109, 372, 7, 25, "Print"],
Cell[49650, 1118, 372, 7, 25, "Print"],
Cell[50025, 1127, 372, 7, 25, "Print"],
Cell[50400, 1136, 371, 7, 25, "Print"],
Cell[50774, 1145, 372, 7, 25, "Print"],
Cell[51149, 1154, 372, 7, 25, "Print"],
Cell[51524, 1163, 371, 7, 25, "Print"],
Cell[51898, 1172, 372, 7, 25, "Print"],
Cell[52273, 1181, 374, 7, 25, "Print"],
Cell[52650, 1190, 374, 7, 25, "Print"],
Cell[53027, 1199, 373, 7, 25, "Print"],
Cell[53403, 1208, 373, 7, 25, "Print"],
Cell[53779, 1217, 374, 7, 25, "Print"],
Cell[54156, 1226, 374, 7, 25, "Print"],
Cell[54533, 1235, 374, 7, 25, "Print"],
Cell[54910, 1244, 372, 7, 25, "Print"],
Cell[55285, 1253, 374, 7, 25, "Print"],
Cell[55662, 1262, 373, 7, 25, "Print"],
Cell[56038, 1271, 374, 7, 25, "Print"],
Cell[56415, 1280, 374, 7, 25, "Print"],
Cell[56792, 1289, 374, 7, 25, "Print"],
Cell[57169, 1298, 373, 7, 25, "Print"],
Cell[57545, 1307, 374, 7, 25, "Print"],
Cell[57922, 1316, 374, 7, 25, "Print"],
Cell[58299, 1325, 374, 7, 25, "Print"],
Cell[58676, 1334, 374, 7, 25, "Print"],
Cell[59053, 1343, 373, 7, 25, "Print"],
Cell[59429, 1352, 374, 7, 25, "Print"],
Cell[59806, 1361, 374, 7, 25, "Print"],
Cell[60183, 1370, 375, 7, 25, "Print"],
Cell[60561, 1379, 375, 7, 25, "Print"],
Cell[60939, 1388, 374, 7, 25, "Print"],
Cell[61316, 1397, 374, 7, 25, "Print"],
Cell[61693, 1406, 374, 7, 25, "Print"],
Cell[62070, 1415, 374, 7, 25, "Print"],
Cell[62447, 1424, 374, 7, 25, "Print"],
Cell[62824, 1433, 374, 7, 25, "Print"],
Cell[63201, 1442, 375, 7, 25, "Print"],
Cell[63579, 1451, 373, 7, 25, "Print"],
Cell[63955, 1460, 374, 7, 25, "Print"],
Cell[64332, 1469, 369, 7, 25, "Print"],
Cell[64704, 1478, 374, 7, 25, "Print"],
Cell[65081, 1487, 374, 7, 25, "Print"],
Cell[65458, 1496, 374, 7, 25, "Print"],
Cell[65835, 1505, 375, 7, 25, "Print"],
Cell[66213, 1514, 374, 7, 25, "Print"],
Cell[66590, 1523, 374, 7, 25, "Print"],
Cell[66967, 1532, 374, 7, 25, "Print"],
Cell[67344, 1541, 374, 7, 25, "Print"],
Cell[67721, 1550, 375, 7, 25, "Print"],
Cell[68099, 1559, 374, 7, 25, "Print"],
Cell[68476, 1568, 374, 7, 25, "Print"],
Cell[68853, 1577, 375, 7, 25, "Print"],
Cell[69231, 1586, 375, 7, 25, "Print"],
Cell[69609, 1595, 373, 7, 25, "Print"],
Cell[69985, 1604, 374, 7, 25, "Print"],
Cell[70362, 1613, 374, 7, 25, "Print"],
Cell[70739, 1622, 374, 7, 25, "Print"],
Cell[71116, 1631, 374, 7, 25, "Print"],
Cell[71493, 1640, 374, 7, 25, "Print"],
Cell[71870, 1649, 374, 7, 25, "Print"],
Cell[72247, 1658, 374, 7, 25, "Print"],
Cell[72624, 1667, 374, 7, 25, "Print"],
Cell[73001, 1676, 374, 7, 25, "Print"],
Cell[73378, 1685, 374, 7, 25, "Print"],
Cell[73755, 1694, 373, 7, 25, "Print"],
Cell[74131, 1703, 374, 7, 25, "Print"],
Cell[74508, 1712, 374, 7, 25, "Print"],
Cell[74885, 1721, 374, 7, 25, "Print"],
Cell[75262, 1730, 374, 7, 25, "Print"],
Cell[75639, 1739, 374, 7, 25, "Print"],
Cell[76016, 1748, 374, 7, 25, "Print"],
Cell[76393, 1757, 374, 7, 25, "Print"],
Cell[76770, 1766, 375, 7, 25, "Print"],
Cell[77148, 1775, 374, 7, 25, "Print"],
Cell[77525, 1784, 375, 7, 25, "Print"],
Cell[77903, 1793, 373, 7, 25, "Print"],
Cell[78279, 1802, 374, 7, 25, "Print"],
Cell[78656, 1811, 374, 7, 25, "Print"],
Cell[79033, 1820, 375, 7, 25, "Print"],
Cell[79411, 1829, 374, 7, 25, "Print"],
Cell[79788, 1838, 374, 7, 25, "Print"],
Cell[80165, 1847, 374, 7, 25, "Print"],
Cell[80542, 1856, 374, 7, 25, "Print"],
Cell[80919, 1865, 374, 7, 25, "Print"],
Cell[81296, 1874, 374, 7, 25, "Print"],
Cell[81673, 1883, 373, 7, 25, "Print"],
Cell[82049, 1892, 374, 7, 25, "Print"],
Cell[82426, 1901, 374, 7, 25, "Print"],
Cell[82803, 1910, 373, 7, 25, "Print"],
Cell[83179, 1919, 375, 7, 25, "Print"],
Cell[83557, 1928, 374, 7, 25, "Print"],
Cell[83934, 1937, 374, 7, 25, "Print"],
Cell[84311, 1946, 374, 7, 25, "Print"],
Cell[84688, 1955, 374, 7, 25, "Print"],
Cell[85065, 1964, 374, 7, 25, "Print"],
Cell[85442, 1973, 374, 7, 25, "Print"],
Cell[85819, 1982, 373, 7, 25, "Print"],
Cell[86195, 1991, 374, 7, 25, "Print"],
Cell[86572, 2000, 374, 7, 25, "Print"],
Cell[86949, 2009, 373, 7, 25, "Print"],
Cell[87325, 2018, 374, 7, 25, "Print"],
Cell[87702, 2027, 373, 7, 25, "Print"],
Cell[88078, 2036, 374, 7, 25, "Print"],
Cell[88455, 2045, 374, 7, 25, "Print"],
Cell[88832, 2054, 373, 7, 25, "Print"],
Cell[89208, 2063, 373, 7, 25, "Print"],
Cell[89584, 2072, 374, 7, 25, "Print"],
Cell[89961, 2081, 375, 7, 25, "Print"],
Cell[90339, 2090, 41, 1, 25, "Print"],
Cell[90383, 2093, 18473, 646, 186, 8057, 513, "GraphicsData", "PostScript", \
"Graphics"],
Cell[108859, 2741, 51, 1, 25, "Print"],
Cell[108913, 2744, 17347, 647, 186, 8306, 531, "GraphicsData", "PostScript", \
"Graphics"],
Cell[126263, 3393, 222, 4, 25, "Print"],
Cell[126488, 3399, 192, 4, 25, "Print"],
Cell[126683, 3405, 47, 1, 25, "Print"],
Cell[126733, 3408, 18517, 646, 186, 8110, 513, "GraphicsData", "PostScript", \
"Graphics"],
Cell[145253, 4056, 212, 4, 25, "Print"],
Cell[145468, 4062, 218, 4, 25, "Print"],
Cell[145689, 4068, 49, 1, 25, "Print"],
Cell[145741, 4071, 18333, 655, 186, 8198, 525, "GraphicsData", "PostScript", \
"Graphics"],
Cell[164077, 4728, 238, 5, 25, "Print"],
Cell[164318, 4735, 244, 5, 25, "Print"],
Cell[164565, 4742, 320, 6, 25, "Print"],
Cell[164888, 4750, 86, 1, 25, "Print"],
Cell[164977, 4753, 77260, 1652, 3221, "Print"]
}, Open  ]],
Cell[242252, 6408, 219, 5, 63, "Subsection"],

Cell[CellGroupData[{
Cell[242496, 6417, 279, 8, 82, "Input"],
Cell[242778, 6427, 309, 5, 25, "Print"],
Cell[243090, 6434, 311, 5, 25, "Print"],
Cell[243404, 6441, 311, 5, 25, "Print"],
Cell[243718, 6448, 311, 5, 25, "Print"],
Cell[244032, 6455, 311, 5, 25, "Print"],
Cell[244346, 6462, 311, 5, 25, "Print"],
Cell[244660, 6469, 311, 5, 25, "Print"],
Cell[244974, 6476, 311, 5, 25, "Print"],
Cell[245288, 6483, 311, 5, 25, "Print"],
Cell[245602, 6490, 313, 5, 25, "Print"],
Cell[245918, 6497, 313, 5, 25, "Print"],
Cell[246234, 6504, 379, 7, 25, "Print"],
Cell[246616, 6513, 378, 7, 25, "Print"],
Cell[246997, 6522, 377, 7, 25, "Print"],
Cell[247377, 6531, 378, 7, 25, "Print"],
Cell[247758, 6540, 379, 7, 25, "Print"],
Cell[248140, 6549, 379, 7, 25, "Print"],
Cell[248522, 6558, 378, 7, 25, "Print"],
Cell[248903, 6567, 379, 7, 25, "Print"],
Cell[249285, 6576, 379, 7, 25, "Print"],
Cell[249667, 6585, 41, 1, 25, "Print"],
Cell[249711, 6588, 15734, 460, 193, 5096, 323, "GraphicsData", "PostScript", \
"Graphics"],
Cell[265448, 7050, 51, 1, 25, "Print"],
Cell[265502, 7053, 12494, 384, 193, 4571, 281, "GraphicsData", "PostScript", \
"Graphics"],
Cell[277999, 7439, 221, 4, 25, "Print"],
Cell[278223, 7445, 192, 4, 25, "Print"],
Cell[278418, 7451, 47, 1, 25, "Print"],
Cell[278468, 7454, 15312, 432, 193, 4737, 296, "GraphicsData", "PostScript", \
"Graphics"],
Cell[293783, 7888, 211, 4, 25, "Print"],
Cell[293997, 7894, 218, 4, 25, "Print"],
Cell[294218, 7900, 49, 1, 25, "Print"],
Cell[294270, 7903, 17000, 464, 193, 5001, 311, "GraphicsData", "PostScript", \
"Graphics"],
Cell[311273, 8369, 238, 5, 25, "Print"],
Cell[311514, 8376, 244, 5, 25, "Print"],
Cell[311761, 8383, 320, 6, 25, "Print"],
Cell[312084, 8391, 86, 1, 25, "Print"],
Cell[312173, 8394, 9510, 220, 341, "Print"]
}, Open  ]],
Cell[321698, 8617, 715, 19, 310, "Subsection"],

Cell[CellGroupData[{
Cell[322438, 8640, 326, 9, 100, "Input"],
Cell[322767, 8651, 362, 7, 25, "Print"],
Cell[323132, 8660, 361, 7, 25, "Print"],
Cell[323496, 8669, 361, 7, 25, "Print"],
Cell[323860, 8678, 318, 5, 25, "Print"],
Cell[324181, 8685, 318, 5, 25, "Print"],
Cell[324502, 8692, 318, 5, 25, "Print"],
Cell[324823, 8699, 361, 7, 25, "Print"],
Cell[325187, 8708, 361, 7, 25, "Print"],
Cell[325551, 8717, 362, 7, 25, "Print"],
Cell[325916, 8726, 366, 7, 25, "Print"],
Cell[326285, 8735, 41, 1, 25, "Print"],
Cell[326329, 8738, 15120, 422, 193, 4723, 289, "GraphicsData", "PostScript", \
"Graphics"],
Cell[341452, 9162, 51, 1, 25, "Print"],
Cell[341506, 9165, 14498, 439, 193, 5164, 319, "GraphicsData", "PostScript", \
"Graphics"],
Cell[356007, 9606, 222, 4, 25, "Print"],
Cell[356232, 9612, 192, 4, 25, "Print"],
Cell[356427, 9618, 47, 1, 25, "Print"],
Cell[356477, 9621, 15305, 448, 193, 5032, 316, "GraphicsData", "PostScript", \
"Graphics"],
Cell[371785, 10071, 212, 4, 25, "Print"],
Cell[372000, 10077, 218, 4, 25, "Print"],
Cell[372221, 10083, 49, 1, 25, "Print"],
Cell[372273, 10086, 15205, 436, 193, 4895, 304, "GraphicsData", "PostScript", \
"Graphics"],
Cell[387481, 10524, 239, 5, 25, "Print"],
Cell[387723, 10531, 244, 5, 25, "Print"],
Cell[387970, 10538, 320, 6, 25, "Print"],
Cell[388293, 10546, 86, 1, 25, "Print"],
Cell[388382, 10549, 5455, 139, 181, "Print"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

