(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9740,        205]*)
(*NotebookOutlinePosition[     10394,        228]*)
(*  CellTagsIndexPosition[     10350,        224]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Algoritmo en forma de subrutina", "Section"],

Cell["\<\
\tA continuaci\[OAcute]n se da el algoritmo del m\[EAcute]todo \[CurlyTheta] \
- Wilson en forma de subrutina. Los par\[AAcute]metros de entrada son, por \
este orden,

- rigidez de la estructura
- masa
- amortiguamiento
- carga
- desplazamiento inicial
- velocidad inicial
- tiempo inicial
- tiempo final
- paso de tiempo
- par\[AAcute]metro \[CurlyTheta] de Wilson (en general, \[CurlyTheta] = 1.4 \
)

\tSe recomienda seguir fielmente la llamada al algoritmo de Wilson en la \
forma indicada en los ejemplos, para que el programa no se bloquee, en \
especial en el hecho de no llamar a la carga como \"p\". Por ese mismo motivo \
hemos tenido que cambiar, dentro del algoritmo, alg\[UAcute]n nombre o \
designaci\[OAcute]n de variable para que se ejecute correctamente.\
\>", "Text"],

Cell[BoxData[
    \(Clear["\<Global`*\>"]\)], "Input"],

Cell[BoxData[{
    \(\(posicion;\)\), "\[IndentingNewLine]", 
    \(\(velocidad;\)\), "\[IndentingNewLine]", 
    \(\(aceleracion;\)\), "\[IndentingNewLine]", 
    \(\(\(Wilson\ [k_, m_, c_, Carga_, u0_, v0_, t0_, tfinal_, Inct_, 
        Parametro_, posicion_, velocidad_, 
        aceleracion_]\)\(:=\)\(\ \)\(Block[{p, t, pi\[CurlyTheta], kmod, pa1, 
          pa2, ui\[CurlyTheta], MaximoDesplazamiento, \nMinimoDesplazamiento, 
          MaximaVelocidad, MinimaVelocidad, \nMaximaAceleracion, 
          MinimaAceleracion, nn, NDatos}, \n\n (*\ 
          Asignaci\[OAcute]n\ de\ Variables\ *) \n\n\[CapitalDelta]t = 
          Inct; \n\[CurlyTheta] = Parametro; \t\n
        p = Carga; \n\n (*\ Cabecera\ *) \n
        Print\ ["\<Resoluci\[OAcute]n del problema por el M\[EAcute]todo \
\[CurlyTheta] - Wilson\>"]; \n
        Print\ ["\<-------------------------------------------\>"]; \n
        Print\ ["\< \>"]; \n\n (*\ Salida\ de\ datos\ de\ partida\ *) \n
        Print\ ["\<Los datos de la estructura son:\>"]; \n
        Print["\<  Rigidez = k = \>", k]; \nPrint["\<  Masa = m = \>", m]; \n
        Print["\<  Amortiguamiento = c = \>", c]; \n
        Print\ ["\<Los datos de la carga son \>"]; \n
        Print["\<  Funci\[OAcute]n Carga = p(t) = \>", p[t]]; \n
        Print\ ["\<Los datos iniciales son: \>"]; \n
        Print\ [\*"\"\<  Desplazamiento inicial = \!\(u\_o\) = \>\"", u0]; \n
        Print\ [\*"\"\<  Velocidad inicial = \!\(v\_o\) = \>\"", v0]; \n
        Print\ ["\<Datos para la resoluci\[OAcute]n:\>"]; \n
        Print\ [\*"\"\<  Instante de tiempo inicial = \!\(t\_o\) = \>\"", 
          t0]; \nPrint\ [\*"\"\<  Instante de tiempo final = \!\(t\_final\) = \
\>\"", tfinal]; \n
        Print\ ["\<  Paso de tiempo = \[CapitalDelta]t = \>", \
\[CapitalDelta]t]; \n
        Print\ ["\<  Par\[AAcute]metro \[CurlyTheta] = \>", \[CurlyTheta]]; \n
        Print\ ["\< \>"]; \n\n (*\ 
          C\[AAcute]lculo\ de\ la\ constante\ k\&^\ *) \n
        kmod = \(6\/\(\[CurlyTheta]\^2\ \[CapitalDelta]t\^2\)\) 
              m + \(3\/\(\[CurlyTheta]\ \[CapitalDelta]t\)\) c + 
            k\ ; \n\n (*\ Estudio\ de\ la\ carga\ *) \npa1 = p; \n
        If[Head[p] == List, \n\t\t\tpa2 = p; \n\t\t\tnn = 
            Length[pa2]; \n\t\t\tIf[
            pa2\[LeftDoubleBracket]nn, 
                  1\[RightDoubleBracket] + \[CapitalDelta]t\/1000 < 
              tfinal, \n\t\t\t\t\t\tAppendTo[
              pa2, {pa1\[LeftDoubleBracket]nn, 
                    1\[RightDoubleBracket] + \[CapitalDelta]t\/1000, 
                0. }]; \n\t\t\t\t\t\tAppendTo[
              pa2, {tfinal, 0. }], \n\t\t\t\t\t\tIf[
              tfinal > 
                pa2\[LeftDoubleBracket]nn, 
                  1\[RightDoubleBracket], \n\t\t\t\t\t\tAppendTo[
                pa2, {tfinal, 0. }]\n\t\t\t\t]\n\t\t\t\t\t]; \n\t\t\tpa1 = 
            Interpolation[pa2, InterpolationOrder \[Rule] 1]\n\t\t]; \n
        p = pa1; \n\n (*\ 
          C\[AAcute]lculo\ del\ n\[UAcute]mero\ de\ datos\ y\ \
creaci\[OAcute]n\ de\ los\ vectores\ de\ resultados\ *) \n
        NDatos = Floor[\((tfinal - t0)\)/\[CapitalDelta]t + 1. ]; \n
        t = Table[t0 + i*\[CapitalDelta]t, {i, 0, NDatos - 1}]; \n
        u = Table[0, {i, 1, NDatos}]; \nv = Table[0, {i, 1, NDatos}]; \n
        a = Table[0, {i, 1, NDatos}]; \n\n (*\ 
          Paso\ a\ los\ vectores\ de\ resultados\ de\ las\ condiciones\ \
iniciales\ *) \nu[\([1]\)] = u0; \nv[\([1]\)] = v0; \n
        a[\([1]\)] = \(1\/m\) \((p[t[\([1]\)]] - k\ u[\([1]\)] - 
                c\ v[\([1]\)])\); \n\n
        For[i = 1, 
          i \[LessEqual] NDatos - 1, \(i++\), \n (*\ 
            C\[AAcute]lculo\ de\ la\ carga\ modificada\ p\&^\ *) \n
          pi\[CurlyTheta] = 
            p[t[\([i]\)]] + \[CurlyTheta]\ \((p[t[\([i + 1]\)]] - 
                    p[t[\([i]\)]])\) + 
              m\ \((\(6\/\((\[CurlyTheta]\^2\ \[CapitalDelta]t\^2)\)\) 
                      u[\([i]\)] + \(6\/\(\[CurlyTheta]\ \[CapitalDelta]t\)\) 
                      v[\([i]\)] + 2\ a[\([i]\)])\) + 
              c\ \((\(3\/\(\[CurlyTheta]\ \[CapitalDelta]t\)\) u[\([i]\)] + 
                    2\ v[\([i]\)] + \(\(\[CurlyTheta]\ \
\[CapitalDelta]t\)\/2\) a[\([i]\)])\); \n
          ui\[CurlyTheta] = pi\[CurlyTheta]\/kmod; \n (*\ 
            Actualizaci\[OAcute]n\ de\ variables\ *) \n
          a[\([i + 
                  1]\)] = \(6\/\(\[CurlyTheta]\^3\ \[CapitalDelta]t\^2\)\) \
\((ui\[CurlyTheta] - 
                    u[\([i]\)])\) - \(6\/\(\[CurlyTheta]\^2\ \[CapitalDelta]t\
\)\) v[\([i]\)] + \((1 - 3\/\[CurlyTheta])\) a[\([i]\)]; \n
          v[\([i + 
                  1]\)] = \(3\/\(\[CurlyTheta]\^3\ \[CapitalDelta]t\)\) \((ui\
\[CurlyTheta] - u[\([i]\)])\) + \((1 - 3\/\[CurlyTheta]\^2)\) 
                v[\([i]\)] + \[CapitalDelta]t \((1 - 
                    3\/\(2  \[CurlyTheta]\))\) a[\([i]\)]; \n
          u[\([i + 
                  1]\)] = \(1\/\[CurlyTheta]\^3\) \((ui\[CurlyTheta])\) + \
\((1 - 1\/\[CurlyTheta]\^3)\) 
                u[\([i]\)] + \[CapitalDelta]t \((1 - 1\/\[CurlyTheta]\^2)\) 
                v[\([i]\)] + \(\[CapitalDelta]t\^2\/2\) \((1 + 
                    1\/\(3  \[CurlyTheta]\))\) 
                a[\([i]\)]\n]; \n\[IndentingNewLine]\n (*\ 
          C\[AAcute]lculo\ de\ los\ m\[AAcute]ximos\ y\ m\[IAcute]nimos\ de\ \
cada\ vector\ de\ resultados\ *) \nMaximoDesplazamiento = Max[u]; \n
        MinimoDesplazamiento = Min[u]; \nMaximaVelocidad = Max[v]; \n
        MinimaVelocidad = Min[v]; \nMaximaAceleracion = Max[a]; \n
        MinimaAceleracion = Min[a]; \n\n (*\ 
          Salida\ Gr\[AAcute]fica\ de\ Resultados\ *) \n\n
        Print["\<Desplazamientos:\>"]; \n
        ListPlot[Table[{t[\([i]\)], u[\([i]\)]}, {i, 1, NDatos}], 
          PlotStyle \[Rule] {PointSize[0.023], RGBColor[1, 0, 0]}, 
          PlotJoined \[Rule] True, AxesLabel \[Rule] {"\<t\>", "\<u\>"}]; \n
        Print["\<M\[AAcute]ximo Desplazamiento: \>", MaximoDesplazamiento]; \n
        Print["\<M\[IAcute]nimo Desplazamiento: \>", 
          MinimoDesplazamiento]; \n\nPrint["\<Velocidades:\>"]; \n
        ListPlot[Table[{t[\([i]\)], v[\([i]\)]}, {i, 1, NDatos}], \n
          PlotStyle \[Rule] {PointSize[0.023], RGBColor[1, 0, 1]}, 
          PlotJoined \[Rule] True, AxesLabel \[Rule] {"\<t\>", "\<v\>"}]; \n
        Print["\<M\[AAcute]xima Velocidad: \>", MaximaVelocidad]; \n
        Print["\<M\[IAcute]nima Velocidad: \>", MinimaVelocidad]; \n\n
        Print["\<Aceleraciones:\>"]; \n
        ListPlot[Table[{t[\([i]\)], a[\([i]\)]}, {i, 1, NDatos}], \n\t
          PlotStyle \[Rule] {PointSize[0.023], RGBColor[0, 0, 1]}, 
          PlotJoined \[Rule] True, AxesLabel \[Rule] {"\<t\>", "\<a\>"}]; \n
        Print["\<M\[AAcute]xima Aceleraci\[OAcute]n: \>", 
          MaximaAceleracion]; \n
        Print["\<M\[IAcute]nima Aceleraci\[OAcute]n: \>", 
          MinimaAceleracion]; \n
        posicion = 
          u; \[IndentingNewLine]\(velocidad = 
              v;\)\[IndentingNewLine]\(aceleracion = 
            a\);\[IndentingNewLine]]\)\(\n\)\(\n\)\)\)}], "Input"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{995, 599},
WindowMargins->{{Automatic, 3}, {Automatic, 23}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 50, 0, 53, "Section"],
Cell[1792, 53, 796, 22, 299, "Text"],
Cell[2591, 77, 54, 1, 30, "Input"],
Cell[2648, 80, 7076, 122, 2368, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

