(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    349516,       8892]*)
(*NotebookOutlinePosition[    350168,       8915]*)
(*  CellTagsIndexPosition[    350124,       8911]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    StyleBox[\(M\[CapitalEAcute]TODO\ \[Theta] - WILSON\ para\ el\ caso\ no - 
        lineal\),
      FontSize->18,
      FontColor->RGBColor[1, 0, 0]], "\[IndentingNewLine]", 
    StyleBox[\((Alejandro\ Ruiz\ Padillo, \ 2003)\),
      FontSize->14]}], "Input"],

Cell[TextData[{
  "\t",
  StyleBox["A continuaci\[OAcute]n se da el algoritmo del m\[EAcute]todo \
\[CurlyTheta] - Wilson para el caso no-lineal en forma de subrutina. Los par\
\[AAcute]metros de entrada son, por este orden,\n\t\t- rigidez de la \
estructura en el tramo el\[AAcute]stico\n\t\t- masa\n\t\t- amortiguamiento\n\t\
\t- carga\n\t\t- desplazamiento inicial\n\t\t- velocidad inicial\n\t\t- \
tiempo inicial\n\t\t- tiempo final\n\t\t- paso de tiempo\n\t\t- \
par\[AAcute]metro \[CurlyTheta] de Wilson (en general, \[CurlyTheta] = 1.4 )\n\
\t\t- valor que provoca la plastificacion a compresion.\n\t\t- valor que \
provoca la plastificacion a traccion.\n\tSe recomienda seguir fielmente la \
llamada al algoritmo de Wilson en la forma indicada en los ejemplos, para que \
el programa no se bloquee, en especial en el hecho de no llamar a la carga \
como \"p\". Por ese mismo motivo hemos tenido que cambiar, dentro del \
algoritmo, alg\[UAcute]n nombre o designaci\[OAcute]n de variable para que se \
ejecute correctamente.\n\t Se ha introducido tambi\[EAcute]n en el algoritmo \
que calcula cada punto otro que define el valor de la rigidez tangente, \
dentro del caso elastopl\[AAcute]stico perfecto.\n\t Todo el algoritmo ha \
sido introducido en una funcion Block para que su ejecucion sea solo darle \
valores a la funcion.",
    FontColor->RGBColor[0, 0, 1]]
}], "Text"],

Cell[BoxData[{\(Clear["\<Global`*\>"]\), "\[IndentingNewLine]", \
\(posicion;\), "\[IndentingNewLine]", \(velocidad;\), "\[IndentingNewLine]", \
\(aceleracion;\), "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{
        RowBox[{\(WilsonNoLineal\ [k_, m_, c_, p_, u0_, v0_, t0_, tfinal_, 
            Inct_, Parametro_, fc_, ft_, posicion_, velocidad_, 
            aceleracion_]\), ":=", " ", 
          RowBox[{"Block", "[", 
            
            RowBox[{\({t, pi\[CurlyTheta], kmod, pa1, pa2, ui\[CurlyTheta], 
                MaximoDesplazamiento, \nMinimoDesplazamiento, 
                MaximaVelocidad, MinimaVelocidad, \nMaximaAceleracion, 
                MinimaAceleracion, nn, NDatos, fs, kt, fs1, kt1, fs2, tini}\),
               ",", "\n", "\n", 
              StyleBox[\( (*\ Asignaci\[OAcute]n\ de\ Variables\ *) \),
                FontColor->RGBColor[1, 0, 1]], "\n", "\n", 
              
              RowBox[{\(\[CapitalDelta]t = Inct\), ";", 
                "\n", \(\[CurlyTheta] = Parametro\), ";", "\n", "\n", 
                StyleBox[\( (*\ Cabecera\ *) \),
                  FontColor->RGBColor[1, 0, 1]], 
                "\n", \(Print\ ["\<Resoluci\[OAcute]n del problema por el M\
\[EAcute]todo \[CurlyTheta] - Wilson no-lineal\>"]\), ";", 
                "\n", \(Print\ \
["\<-------------------------------------------\>"]\), ";", 
                "\n", \(Print\ ["\< \>"]\), ";", "\n", "\n", 
                StyleBox[\( (*\ Salida\ de\ datos\ de\ partida\ *) \),
                  FontColor->RGBColor[1, 0, 1]], 
                "\[IndentingNewLine]", \(Print\ ["\<Los datos de la \
estructura son:\>"]\), ";", 
                "\[IndentingNewLine]", \(Print["\<  Rigidez del tramo el\
\[AAcute]stico = k = \>", k]\), ";", 
                "\[IndentingNewLine]", \(Print["\<  Masa = m = \>", m]\), ";",
                 "\[IndentingNewLine]", \(Print["\<  Amortiguamiento = c = \
\>", c]\), ";", 
                "\[IndentingNewLine]", \(Print\ ["\<Los datos de la carga son \
\>"]\), ";", 
                "\[IndentingNewLine]", \(Print["\<  Funci\[OAcute]n Carga = \
p(t) = \>", p[t]]\), ";", 
                "\[IndentingNewLine]", \(Print\ ["\<Los datos iniciales son: \
\>"]\), ";", 
                "\[IndentingNewLine]", \(Print\ [\*"\"\<  Desplazamiento \
inicial = \!\(u\_o\) = \>\"", u0]\), ";", 
                "\[IndentingNewLine]", \(Print\ [\*"\"\<  Velocidad inicial = \
\!\(v\_o\) = \>\"", v0]\), ";", 
                "\[IndentingNewLine]", \(Print\ ["\<Datos para la resolucion:\
\>"]\), ";", 
                "\[IndentingNewLine]", \(Print\ [\*"\"\<  Instante de tiempo \
inicial = \!\(t\_o\) = \>\"", t0]\), ";", 
                "\[IndentingNewLine]", \(Print\ [\*"\"\<  Instante de tiempo \
final = \!\(t\_final\) = \>\"", tfinal]\), ";", "\[IndentingNewLine]", 
                RowBox[{"Print", " ", "[", 
                  RowBox[{"\"\<  Paso\!\(\*
StyleBox[\\\" \\\",\\nFontColor->GrayLevel[0]]\)de tiempo = \[CapitalDelta]t \
= \>\"", 
                    StyleBox[",",
                      FontColor->GrayLevel[0]], 
                    StyleBox["\[CapitalDelta]t",
                      FontColor->GrayLevel[0]]}], 
                  StyleBox["]",
                    FontColor->GrayLevel[0]]}], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
                StyleBox["\n",
                  FontColor->GrayLevel[0]], 
                
                StyleBox[\(Print\ ["\<  Parametro \[CurlyTheta] = \>", \
\[CurlyTheta]]\),
                  FontColor->GrayLevel[0]], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                StyleBox["\n",
                  FontColor->GrayLevel[0]], 
                
                StyleBox[\(Print["\<  Valor que provoca la plastificacion a \
compresion = fc = \>", fc]\),
                  FontColor->GrayLevel[0]], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], 
                
                StyleBox[\(Print["\<  Valor que provoca la plastificacion a \
traccion = ft = \>", ft]\),
                  FontColor->GrayLevel[0]], 
                StyleBox[";",
                  FontColor->GrayLevel[0]], "\n", \(Print\ ["\< \>"]\), ";", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", 
                
                StyleBox[\( (*\ 
                    C\[AAcute]lculo\ del\ n\[UAcute]mero\ de\ datos\ *) \),
                  FontColor->RGBColor[1, 0, 1]], "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(NDatos = 
                  Floor[\((tfinal - t0)\)/\[CapitalDelta]t + 1. ]\), ";", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", "\n", 
                
                StyleBox[\( (*\ 
                    Estudio\ de\ la\ \(carga : \ 
                        hemos\ de\ discretizarla\ de\ la\ carga\ y\ al\ final\
\ la\ representamos\)\ *) \),
                  FontColor->RGBColor[1, 0, 1]], "\[IndentingNewLine]", 
                "\n", \(pa1 = p\), ";", 
                "\[IndentingNewLine]", \(If[Head[p] \[Equal] List, pa2 = p; 
                  nn = Length[pa2]; \[IndentingNewLine]If[
                    pa2[\([nn, 1]\)] + \[CapitalDelta]t/1000 < tfinal, 
                    AppendTo[
                      pa2, {pa1[\([nn, 1]\)] + \[CapitalDelta]t/1000, 
                        0. }]; \[IndentingNewLine]AppendTo[
                      pa2, {tfinal, 0. }], 
                    If[tfinal > pa2[\([nn, 1]\)], 
                      AppendTo[
                        pa2, {tfinal, 0. }]]]; \[IndentingNewLine]pa1 = 
                    Interpolation[pa2, InterpolationOrder \[Rule] 1]]\), ";", 
                "\n", \(pa = Table[0, {i, 1, NDatos}]\), ";", 
                "\[IndentingNewLine]", \(For[i = 1, 
                  i \[LessEqual] NDatos, \(i++\), 
                  pa[\([i]\)] = 
                    N[pa1[\((t0 + \((i - 1)\) \[CapitalDelta]t)\)]]]\), ";", 
                "\[IndentingNewLine]", \(Print["\<Carga\>"]\), ";", 
                "\[IndentingNewLine]", \(Print[
                  Plot[pa1[t], {t, t0, tfinal}, 
                    PlotStyle \[Rule] RGBColor[1, 0, 1], 
                    AxesLabel \[Rule] {t, "\<p\>"}]]\), ";", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", 
                
                StyleBox[\( (*\ 
                    Creaci\[OAcute]n\ de\ los\ vectores\ de\ resultados\ *) \
\),
                  FontColor->RGBColor[1, 0, 1]], "\[IndentingNewLine]", 
                "\n", \(tm = 
                  Table[t0 + \((i - 1)\) \[CapitalDelta]t, {i, NDatos}]\), 
                ";", "\n", \(u = Table[0. , {i, 1, NDatos}]\), ";", 
                "\n", \(v = Table[0. , {i, 1, NDatos}]\), ";", 
                "\n", \(a = Table[0. , {i, 1, NDatos}]\), ";", 
                "\n", \(kt = Table[0. , {i, 1, NDatos}]\), ";", 
                "\[IndentingNewLine]", \(fs = Table[0. , {i, 1, NDatos}]\), 
                ";", "\[IndentingNewLine]", "\[IndentingNewLine]", "\n", 
                
                StyleBox[\( (*\ 
                    Paso\ a\ los\ vectores\ de\ resultados\ de\ las\ \
condiciones\ iniciales\ *) \),
                  FontColor->RGBColor[1, 0, 1]], "\[IndentingNewLine]", 
                "\n", \(u[\([1]\)] = u0\), ";", "\n", \(v[\([1]\)] = v0\), 
                ";", "\n", \(a[\([1]\)] = \((pa[\([1]\)] - k*\ u[\([1]\)] - 
                        c\ *v[\([1]\)])\)/m\), ";", 
                "\[IndentingNewLine]", \(kt[\([1]\)] = k\), ";", 
                "\[IndentingNewLine]", \(fs[\([1]\)] = k*u0\), ";", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", 
                RowBox[{
                  StyleBox["(*",
                    FontColor->RGBColor[1, 0, 1]], 
                  RowBox[{
                    
                    StyleBox[\(A\ continuaci\[OAcute]n\ aparece\ el\ bucle\ \
que\ va\ calculando\ en\ primer\ lugar\ la\ rigidez\ tangente\ y\ luego\ \
halla\ los\ valores\ de\ la\ posici\[OAcute]n\),
                      FontColor->RGBColor[1, 0, 1]], 
                    StyleBox[",",
                      FontColor->RGBColor[1, 0, 1]], 
                    StyleBox[" ",
                      FontColor->RGBColor[1, 0, 1]], 
                    RowBox[{
                      StyleBox["velocidad",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox["y",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox["aceleraci\[OAcute]n",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox["en",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox["cada",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[\(paso . \ Para\),
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox["ello",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox["se",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox["apoya",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox["en",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox["los",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox["valores",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox["de",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox["la",
                        FontColor->RGBColor[1, 0, 1]], " ", 
                      StyleBox["kmod",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox["y",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox["la",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox["carga",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox["modificada",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[" ",
                        FontColor->RGBColor[1, 0, 1]], 
                      StyleBox[\(p\&^\),
                        FontColor->RGBColor[1, 0, 1]]}]}], 
                  StyleBox[" ",
                    FontColor->RGBColor[1, 0, 1]], 
                  StyleBox["*)",
                    FontColor->RGBColor[1, 0, 1]]}], "\[IndentingNewLine]", 
                "\n", \(kmod = 
                  6/\((\[CurlyTheta]^2\ \[CapitalDelta]t^2)\) m + 
                    3/\((\[CurlyTheta]\ \[CapitalDelta]t)\) c + k\), " ", ";",
                 "\[IndentingNewLine]", 
                "\n", \(For[i = 1, 
                  i \[LessEqual] 
                    NDatos - 1, \(i++\), \[IndentingNewLine]pi\[CurlyTheta] = 
                    pa[\([i]\)] + \[CurlyTheta]\ \((pa[\([i + 1]\)] - 
                            pa[\([i]\)])\) + 
                      m\ \((6/\((\[CurlyTheta]^2\ \[CapitalDelta]t^2)\) 
                              u[\([i]\)] + 
                            6/\((\[CurlyTheta]\ \[CapitalDelta]t)\) 
                              v[\([i]\)] + 2\ a[\([i]\)])\) + 
                      c\ \((3/\((\[CurlyTheta]\ \[CapitalDelta]t)\) 
                              u[\([i]\)] + 
                            2\ v[\([i]\)] + \((\[CurlyTheta]\ \
\[CapitalDelta]t)\)/2  a[\([i]\)])\); \[IndentingNewLine]ui\[CurlyTheta] = 
                    pi\[CurlyTheta]/kmod; \n
                  u[\([i + 1]\)] = 
                    1/\[CurlyTheta]^3 \((ui\[CurlyTheta])\) + \((1 - 
                            1/\[CurlyTheta]^3)\) 
                        u[\([i]\)] + \[IndentingNewLine]\[CapitalDelta]t \((1 \
- 1/\[CurlyTheta]^2)\) 
                        v[\([i]\)] + \[CapitalDelta]t^2/
                          2 \((1 + 1/\((3  \[CurlyTheta])\))\) 
                        a[\([i]\)]; \[IndentingNewLine]If[
                    Abs[u[\([i + 1]\)]] - Abs[u[\([i]\)]] > 
                      0, \ \ \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \
If[fc < fs[\([i]\)] < 
                        ft, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ fs[\([i + 1]\)] = 
                        fs[\([i]\)] + 
                          k\ \((u[\([i + 1]\)] - 
                                u[\([i]\)])\); \[IndentingNewLine]\ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ If[
                        fc < fs[\([i + 1]\)] < 
                          ft, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ kt[\([i + 1]\)] = 
                          k, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ If[fs[\([i + 1]\)] > 0, fs[\([i + 1]\)] = ft, 
                          fs[\([i + 1]\)] = 
                            fc]; \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ kt[\([i + 1]\)] = 
                          0\[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ ], \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
If[fs[\([i]\)] > 0, fs[\([i + 1]\)] = ft, 
                        fs[\([i + 1]\)] = 
                          fc]; \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ kt[\([i + 1]\)] = 
                        0\[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
], \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ fs[\([i + 1]\)] = 
                      fs[\([i]\)] + 
                        k\ \((u[\([i + 1]\)] - 
                              u[\([i]\)])\); \[IndentingNewLine]\ \ \ \ \ \ \ \
\ \ \ \ \ \ \ If[fc < fs[\([i + 1]\)] < 
                        ft, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ kt[\([i + 1]\)] = 
                        k, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ If[fs[\([i + 1]\)] > 0, fs[\([i + 1]\)] = ft, 
                        fs[\([i + 1]\)] = 
                          fc]; \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ kt[\([i + 1]\)] = 
                        0\[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
]\[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ ]; \[IndentingNewLine]kmod = 
                    6/\((\[CurlyTheta]^2\ \[CapitalDelta]t^2)\) m + 
                      3/\((\[CurlyTheta]\ \[CapitalDelta]t)\) c + 
                      kt[\([i + 1]\)]\ ; \[IndentingNewLine]pi\[CurlyTheta] = 
                    pa[\([i]\)] + \[CurlyTheta]\ \((pa[\([i + 1]\)] - 
                            pa[\([i]\)])\) + 
                      m\ \((6/\((\[CurlyTheta]^2\ \[CapitalDelta]t^2)\) 
                              u[\([i]\)] + 
                            6/\((\[CurlyTheta]\ \[CapitalDelta]t)\) 
                              v[\([i]\)] + 2\ a[\([i]\)])\) + 
                      c\ \((3/\((\[CurlyTheta]\ \[CapitalDelta]t)\) 
                              u[\([i]\)] + 
                            2\ v[\([i]\)] + \((\[CurlyTheta]\ \
\[CapitalDelta]t)\)/2  a[\([i]\)])\); \[IndentingNewLine]ui\[CurlyTheta] = 
                    pi\[CurlyTheta]/kmod; \[IndentingNewLine]u[\([i + 1]\)] = 
                    1/\[CurlyTheta]^3 \((ui\[CurlyTheta])\) + \((1 - 
                            1/\[CurlyTheta]^3)\) 
                        u[\([i]\)] + \[IndentingNewLine]\[CapitalDelta]t \((1 \
- 1/\[CurlyTheta]^2)\) 
                        v[\([i]\)] + \[CapitalDelta]t^2/
                          2 \((1 + 1/\((3  \[CurlyTheta])\))\) 
                        a[\([i]\)]; \[IndentingNewLine]v[\([i + 1]\)] = 
                    3/\((\[CurlyTheta]^3\ \[CapitalDelta]t)\) \((ui\
\[CurlyTheta] - u[\([i]\)])\) + \((1 - 3/\[CurlyTheta]^2)\) 
                        v[\([i]\)] + \[CapitalDelta]t \((1 - 
                            3/\((2  \[CurlyTheta])\))\) 
                        a[\([i]\)]; \[IndentingNewLine]\ 
                  If[fc < fs[\([i + 1]\)] < 
                      ft, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
fs[\([i + 1]\)] = fs[\([i]\)] + 
                        k\ \((u[\([i + 1]\)] - 
                              u[\([i]\)])\), \[IndentingNewLine]\ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ If[fs[\([i + 1]\)] > 0, fs[\([i + 1]\)] = ft, 
                      fs[\([i + 1]\)] = 
                        fc]\[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ ]; \n\ \ \ \
\ \ \ \ \ \ \ \ a[\([i + 1]\)] = 
                    6/\((\[CurlyTheta]^3\ \[CapitalDelta]t^2)\) \((ui\
\[CurlyTheta] - u[\([i]\)])\) - 
                      6/\((\[CurlyTheta]^2\ \[CapitalDelta]t)\) 
                        v[\([i]\)] + \((1 - 3/\[CurlyTheta])\) 
                        a[\([i]\)];\n]\), ";", "\n", "\[IndentingNewLine]", 
                "\n", 
                
                StyleBox[\( (*\ 
                    C\[AAcute]lculo\ de\ los\ m\[AAcute]ximos\ y\ \
m\[IAcute]nimos\ de\ cada\ vector\ de\ resultados\ *) \),
                  FontColor->RGBColor[1, 0, 1]], "\[IndentingNewLine]", 
                "\n", \(MaximoDesplazamiento = Max[u]\), ";", 
                "\n", \(MinimoDesplazamiento = Min[u]\), ";", 
                "\n", \(MaximaVelocidad = Max[v]\), ";", 
                "\n", \(MinimaVelocidad = Min[v]\), ";", 
                "\n", \(MaximaAceleracion = Max[a]\), ";", 
                "\n", \(MinimaAceleracion = Min[a]\), ";", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", "\n", 
                
                StyleBox[\( (*Preparaci\[OAcute]n\ para\ la\ representaci\
\[OAcute]n\ y\ salida\ de\ datos*) \),
                  FontColor->RGBColor[1, 0, 1]], "\n", 
                "\n", \(posicion1 = Table[0, {i, 1, NDatos}, {j, 1, 2}]\), 
                ";", "\[IndentingNewLine]", \(velocidad1 = 
                  Table[0, {i, 1, NDatos}, {j, 1, 2}]\), ";", 
                "\[IndentingNewLine]", \(aceleracion1 = 
                  Table[0, {i, 1, NDatos}, {j, 1, 2}]\), ";", 
                "\[IndentingNewLine]", \(fs1 = 
                  Table[0, {i, 1, NDatos}, {j, 1, 2}]\), ";", 
                "\[IndentingNewLine]", \(kt1 = 
                  Table[0, {i, 1, NDatos}, {j, 1, 2}]\), ";", 
                "\[IndentingNewLine]", \(tini = t0\), ";", 
                "\[IndentingNewLine]", \(For[i = 1, 
                  i \[LessEqual] NDatos, \(i++\), \[IndentingNewLine]\t
                  posicion1[\([i, 1]\)] = tini; \[IndentingNewLine]\t
                  velocidad1[\([i, 1]\)] = tini; \[IndentingNewLine]\t
                  aceleracion1[\([i, 1]\)] = 
                    tini; \[IndentingNewLine]\ \ \ \ \ \ \ \ \ fs1[\([i, 
                        1]\)] = 
                    tini; \[IndentingNewLine]\ \ \ \ \ \ \ \ \ kt1[\([i, 
                        1]\)] = tini; \[IndentingNewLine]\t
                  tini = tini + \[CapitalDelta]t;\[IndentingNewLine]]\), ";", 
                "\[IndentingNewLine]", \(For[i = 1, 
                  i \[LessEqual] NDatos, \(i++\), \[IndentingNewLine]\t
                  posicion1[\([i, 2]\)] = u[\([i]\)]; \[IndentingNewLine]\t
                  velocidad1[\([i, 2]\)] = v[\([i]\)]; \[IndentingNewLine]\t
                  aceleracion1[\([i, 2]\)] = 
                    a[\([i]\)]; \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \
fs1[\([i, 2]\)] = fs[\([i]\)]; \[IndentingNewLine]\ \ \ \ \ \ \ \ \ kt1[\([i, 
                        2]\)] = kt[\([i]\)]\[IndentingNewLine]]\), ";", 
                "\[IndentingNewLine]", \(posicion = posicion1\), ";", 
                "\[IndentingNewLine]", \(velocidad = velocidad1\), ";", 
                "\[IndentingNewLine]", \(aceleracion = aceleracion1\), ";", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", 
                
                StyleBox[\( (*\ 
                    Salida\ Gr\[AAcute]fica\ de\ Resultados\ *) \),
                  FontColor->RGBColor[1, 0, 1]], "\[IndentingNewLine]", 
                "\n", \(Print["\<Desplazamientos:\>"]\), ";", 
                "\n", \(posicion2 = 
                  Interpolation[posicion1, InterpolationOrder \[Rule] 1]\), 
                ";", "\[IndentingNewLine]", \(Print[
                  Plot[posicion2[t], {t, t0, tfinal}, 
                    PlotStyle \[Rule] RGBColor[1, 0, 0], 
                    AxesLabel \[Rule] {t, "\<u\>"}]]\), ";", 
                "\n", \(Print["\<M\[AAcute]ximo Desplazamiento: \>", 
                  MaximoDesplazamiento]\), ";", 
                "\n", \(Print["\<M\[IAcute]nimo Desplazamiento: \>", 
                  MinimoDesplazamiento]\), ";", "\n", 
                "\n", \(Print["\<Velocidades:\>"]\), ";", 
                "\n", \(velocidad2 = 
                  Interpolation[velocidad1, InterpolationOrder \[Rule] 1]\), 
                ";", "\[IndentingNewLine]", \(Print[
                  Plot[velocidad2[t], {t, t0, tfinal}, 
                    PlotStyle \[Rule] RGBColor[0, 1, 0], 
                    AxesLabel \[Rule] {t, "\<v\>"}]]\), ";", 
                "\n", \(Print["\<M\[AAcute]xima Velocidad: \>", 
                  MaximaVelocidad]\), ";", 
                "\n", \(Print["\<M\[IAcute]nima Velocidad: \>", 
                  MinimaVelocidad]\), ";", "\n", 
                "\n", \(Print["\<Aceleraciones:\>"]\), ";", 
                "\n", \(aceleracion2 = 
                  Interpolation[aceleracion1, InterpolationOrder \[Rule] 1]\),
                 ";", "\[IndentingNewLine]", \(Print[
                  Plot[aceleracion2[t], {t, t0, tfinal}, 
                    PlotStyle \[Rule] RGBColor[0, 0, 1], 
                    AxesLabel \[Rule] {t, "\<a\>"}]]\), ";", 
                "\n", \(Print["\<M\[AAcute]xima Aceleraci\[OAcute]n: \>", 
                  MaximaAceleracion]\), ";", 
                "\n", \(Print["\<M\[IAcute]nima Aceleraci\[OAcute]n: \>", 
                  MinimaAceleracion]\), ";", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Print["\<fs\>"]\), ";", 
                "\n", \(fs2 = 
                  Interpolation[fs1, InterpolationOrder \[Rule] 1]\), ";", 
                "\[IndentingNewLine]", \(Print[
                  Plot[fs2[t], {t, t0, tfinal}, 
                    AxesLabel \[Rule] {t, "\<fs\>"}]]\), ";", 
                "\[IndentingNewLine]", "\[IndentingNewLine]", 
                "\[IndentingNewLine]", 
                
                StyleBox[\( (*\ 
                    Finalmente\ damos\ la\ salida\ de\ las\ listas\ de\ datos\
\ en\ forma\ de\ columnas\ *) \),
                  FontColor->RGBColor[1, 0, 1]], "\[IndentingNewLine]", 
                "\[IndentingNewLine]", \(Print["\<t      p\>", "\<        \
\>", "\<t        u\>", "\<              \>", "\<t        v\>", "\<          \
\>", "\<t       a\>", \ "\<         \>", \ "\<t      kt\>"]\), ";", 
                "\[IndentingNewLine]", \
\(Print["\<-------------------------------------------------------------------\
----------------------------\>"]\), ";", 
                "\[IndentingNewLine]", \(Print[ColumnForm[tm], "\<  \>", 
                  ColumnForm[pa], "\<  \>", ColumnForm[posicion1], "\<  \>", 
                  ColumnForm[velocidad1], "\<  \>", 
                  ColumnForm[aceleracion1], "\<  \>", ColumnForm[kt1]]\)}]}], 
            "\[IndentingNewLine]", "]"}]}], ";"}], "\n"}]}], "Input"],

Cell[CellGroupData[{

Cell["\<\
EJEMPLO
Resolver mediante el modelo \[Theta]-Wilson no-lineal el siguiente problema \
de un material elasto-pl\[AAcute]stico perfecto:
a(t)+fs(u,v)=50 t
u(0)=0
v(0)=0
Hallar la respuesta hasta el instante tn=1 y con un incremento de tiempo \
to=0.1.La rigidez del tramo el\[AAcute]stico es 25, la m\[AAcute]xima tracci\
\[OAcute]n es 15 y la m\[AAcute]xima compresi\[OAcute]n es -15. Tomar \
\[Theta]=1.4.\
\>", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(p[t_] := 50\ t;\)\), "\[IndentingNewLine]", 
    \(WilsonNoLineal[25, 1, 0, p, 0, 0, 0, 1, 0.01, 1.4, \(-15\), 15, 
      posicion, velocidad, aceleracion]\)}], "Input"],

Cell[BoxData[
    \("Resoluci\[OAcute]n del problema por el M\[EAcute]todo \[CurlyTheta] - \
Wilson no-lineal"\)], "Print"],

Cell[BoxData[
    \("-------------------------------------------"\)], "Print"],

Cell[BoxData[
    \(" "\)], "Print"],

Cell[BoxData[
    \("Los datos de la estructura son:"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Rigidez del tramo el\[AAcute]stico = k = "\
\[InvisibleSpace]25\),
      SequenceForm[ "  Rigidez del tramo el\[AAcute]stico = k = ", 25],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Masa = m = "\[InvisibleSpace]1\),
      SequenceForm[ "  Masa = m = ", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Amortiguamiento = c = "\[InvisibleSpace]0\),
      SequenceForm[ "  Amortiguamiento = c = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Los datos de la carga son "\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Funci\[OAcute]n Carga = p(t) = \
"\[InvisibleSpace]\(50\ t\)\),
      SequenceForm[ "  Funci\[OAcute]n Carga = p(t) = ", 
        Times[ 50, t]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Los datos iniciales son: "\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Desplazamiento inicial = \!\(u\_o\) = "\
\[InvisibleSpace]0\),
      SequenceForm[ "  Desplazamiento inicial = \!\(u\_o\) = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Velocidad inicial = \!\(v\_o\) = \
"\[InvisibleSpace]0\),
      SequenceForm[ "  Velocidad inicial = \!\(v\_o\) = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Datos para la resolucion:"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Instante de tiempo inicial = \!\(t\_o\) = "\
\[InvisibleSpace]0\),
      SequenceForm[ "  Instante de tiempo inicial = \!\(t\_o\) = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Instante de tiempo final = \!\(t\_final\) = "\
\[InvisibleSpace]1\),
      SequenceForm[ "  Instante de tiempo final = \!\(t\_final\) = ", 1],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"  Paso\\!\\(\\* StyleBox[\\\" \
\\\",\\nFontColor->GrayLevel[0]]\\)de tiempo = \[CapitalDelta]t = \"\>", 
        "\[InvisibleSpace]", "0.01`"}],
      SequenceForm[ 
      "  Paso\!\(\* StyleBox[\" \",\nFontColor->GrayLevel[0]]\)de tiempo = \
\[CapitalDelta]t = ", .01],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Parametro \[CurlyTheta] = "\[InvisibleSpace]1.4`\),
      
      SequenceForm[ "  Parametro \[CurlyTheta] = ", 1.3999999999999999],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Valor que provoca la plastificacion a compresion = \
fc = "\[InvisibleSpace]\(-15\)\),
      SequenceForm[ 
      "  Valor que provoca la plastificacion a compresion = fc = ", -15],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Valor que provoca la plastificacion a traccion = \
ft = "\[InvisibleSpace]15\),
      SequenceForm[ 
      "  Valor que provoca la plastificacion a traccion = ft = ", 15],
      Editable->False]], "Print"],

Cell[BoxData[
    \(" "\)], "Print"],

Cell[BoxData[
    \("Carga"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.0117721 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .13244 -12 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -12 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -12 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -12 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -12 -4.5 ]
[.01131 .60332 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .13244 m
.03006 .13244 L
s
[(10)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(20)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(30)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(40)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(50)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03826 m
.02756 .03826 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .08535 m
.02756 .08535 L
s
.02381 .10889 m
.02756 .10889 L
s
.02381 .15598 m
.02756 .15598 L
s
.02381 .17952 m
.02756 .17952 L
s
.02381 .20307 m
.02756 .20307 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .2737 m
.02756 .2737 L
s
.02381 .29724 m
.02756 .29724 L
s
.02381 .32079 m
.02756 .32079 L
s
.02381 .34433 m
.02756 .34433 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .41497 m
.02756 .41497 L
s
.02381 .43851 m
.02756 .43851 L
s
.02381 .46205 m
.02756 .46205 L
s
.02381 .50914 m
.02756 .50914 L
s
.02381 .53269 m
.02756 .53269 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57977 m
.02756 .57977 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 1 r
.5 Mabswid
.02381 .01472 m
.06244 .03859 L
.10458 .06463 L
.14415 .08909 L
.18221 .11261 L
.22272 .13765 L
.26171 .16175 L
.30316 .18736 L
.34309 .21204 L
.3815 .23578 L
.42237 .26104 L
.46172 .28536 L
.49955 .30874 L
.53984 .33364 L
.57861 .3576 L
.61984 .38308 L
.65954 .40762 L
.69774 .43123 L
.73838 .45635 L
.77751 .48053 L
.81909 .50623 L
.85916 .53099 L
.89771 .55482 L
.93871 .58016 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo000oOol2
0004Ool20003Ool4000OOol20004Ool20005Ool3000OOol20004Ool20003Ool3000POol20004Ool2
0004Ool2000UOol5000NOol003ioo`04001oogoo0008Ool00`00Oomoo`0OOol01000Oomoo`002goo
00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`0027oo00@007ooOol0
02Ioo`03001oogoo01ioo`00?Woo00@007ooOol000Uoo`03001oogoo01ioo`04001oogoo0008Ool5
000NOol01000Oomoo`0027oo00@007ooOol001ioo`04001oogoo0008Ool01000Oomoo`009Woo00<0
07ooOol07Woo000nOol01000Oomoo`002Woo00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo
000OOol01000Oomoo`0027oo0`007goo00@007ooOol000Uoo`8002Moo`03001oogoo01ioo`00?Woo
00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`002Goo00<007oo00007goo00@007ooOol0
00Uoo`03001oogoo01ioo`04001oogoo0008Ool01000Oomoo`009Woo00<007ooOol07Woo000oOol2
000:Ool2000POol2000;Ool2000POol2000:Ool3000OOol2000:Ool2000VOol2000POol00?moob5o
o`0067oo00<007ooOol0ogoo1Woo000HOol00`00Oomoo`3oOol6Ool001Qoo`03001oogoo0?Aoo`80
00moo`0067oo00<007ooOol0lgoo00@007ooOol000ioo`004Woo1P0000=l7`000000j`0027oo00<0
07ooOol03goo000HOol00`00O1ml7`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08
Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09
Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09
Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09
Ool00`00Oomoo`08Ool00`00Oomoo`0;Ool5000>Ool001Qoo`03001oogoo009l7o5oo`03001oogoo
00moo`0067oo00<007ooOol00Woo0W`Oogoo0Woo000HOol00`00Oomoo`04Ool2O1ooOol001Qoo`80
00Moo`03O1moogoo0?aoo`0067oo00<007ooOol01goo0W`Oo7oo000HOol00`00Oomoo`09Ool00g`O
Oomoo`3iOol001Qoo`03001oogoo00Yoo`9l7oUoo`0067oo00<007ooOol037oo0W`Omgoo000HOol0
0`00Oomoo`0>Ool00g`OOomoo`3dOol001Qoo`80011oo`9l7oAoo`0067oo00<007ooOol04Goo00=l
7gooOol0lGoo000HOol00`00Oomoo`0BOol2O1oaOol001Qoo`03001oogoo01Aoo`03O1moogoo0>io
o`0067oo00<007ooOol05Goo0W`OkWoo000HOol00`00Oomoo`0GOol00g`OOomoo`3[Ool001Qoo`80
01Uoo`9l7n]oo`0067oo00<007ooOol06Woo0W`OjGoo000HOol00`00Oomoo`0LOol2O1oWOol001Qo
o`03001oogoo01ioo`9l7nEoo`0067oo00<007ooOol087oo0W`Ohgoo000HOol2000SOol2O1oQOol0
01Qoo`03001oogoo02Aoo`03O1moogoo0=ioo`0067oo00<007ooOol09Goo0W`OgWoo000HOol00`00
Oomoo`0WOol00g`OOomoo`3KOol000Yoo`D0009oo`8000Eoo`03001oogoo02Qoo`9l7m]oo`0037oo
00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo02Yoo`03O1moogoo0=Qoo`0037oo00D0
07ooOomoo`00009oo`03001oogoo009oo`<002]oo`9l7mQoo`0037oo00D007ooOomoo`00009oo`03
001oogoo009oo`03001oogoo02eoo`03O1moogoo0=Eoo`0037oo00D007ooOomoo`00009oo`03001o
ogoo009oo`03001oogoo02ioo`9l7mEoo`002goo0P0017oo0P001Goo00<007ooOol0<7oo0W`Odgoo
000HOol00`00Oomoo`0bOol00g`OOomoo`3@Ool001Qoo`03001oogoo03=oo`9l7m1oo`0067oo0P00
=Woo0W`OcWoo000HOol00`00Oomoo`0gOol00g`OOomoo`3;Ool001Qoo`03001oogoo03Qoo`9l7l]o
o`0067oo00<007ooOol0>Woo0W`ObGoo000HOol00`00Oomoo`0lOol00g`OOomoo`36Ool001Qoo`03
001oogoo03eoo`9l7lIoo`0067oo0P00@7oo0W`Oa7oo000HOol00`00Oomoo`11Ool00g`OOomoo`31
Ool001Qoo`03001oogoo049oo`9l7l5oo`0067oo00<007ooOol0A7oo0W`O_goo000HOol00`00Oomo
o`16Ool00g`OOomoo`2lOol001Qoo`8004Qoo`9l7kaoo`0067oo00<007ooOol0BGoo0W`O^Woo000H
Ool00`00Oomoo`1;Ool00g`OOomoo`2gOol001Qoo`03001oogoo04aoo`9l7kMoo`0067oo00<007oo
Ool0CWoo00=l7gooOol0]7oo000HOol00`00Oomoo`1?Ool2O1ndOol001Qoo`80059oo`03O1moogoo
0;5oo`0067oo00<007ooOol0DWoo0W`O/Goo000HOol00`00Oomoo`1DOol00g`OOomoo`2^Ool001Qo
o`03001oogoo05Eoo`9l7jioo`002Woo10000goo0P001Goo00<007ooOol0Egoo0W`O[7oo000:Ool0
0`00Oomoo`03Ool01000Oomoo`0017oo00<007ooOol0FGoo00=l7gooOol0ZGoo000;Ool00`00Oomo
o`02Ool01000Oomoo`0017oo0`00FWoo0W`OZGoo000<Ool01@00Oomoogoo00000Woo00<007ooOol0
0Woo00<007ooOol0G7oo0W`OYgoo000:Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo
05ioo`03O1moogoo0:Aoo`002goo0P0017oo0P001Goo00<007ooOol0Ggoo0W`OY7oo000HOol00`00
Oomoo`1QOol00g`OOomoo`2QOol001Qoo`8006=oo`9l7j5oo`0067oo00<007ooOol0I7oo00=l7goo
Ool0WWoo000HOol00`00Oomoo`1UOol2O1nNOol001Qoo`03001oogoo06Moo`03O1moogoo09]oo`00
67oo00<007ooOol0J7oo0W`OVgoo000HOol00`00Oomoo`1ZOol00g`OOomoo`2HOol001Qoo`8006ao
o`9l7iQoo`0067oo00<007ooOol0KGoo00=l7gooOol0UGoo000HOol00`00Oomoo`1^Ool2O1nEOol0
01Qoo`03001oogoo071oo`03O1moogoo099oo`0067oo00<007ooOol0LGoo0W`OTWoo000HOol00`00
Oomoo`1cOol2O1n@Ool001Qoo`8007Ioo`03O1moogoo08eoo`0067oo00<007ooOol0MWoo0W`OSGoo
000HOol00`00Oomoo`1hOol2O1n;Ool001Qoo`03001oogoo07Yoo`03O1moogoo08Qoo`0067oo00<0
07ooOol0Ngoo0W`OR7oo000HOol00`00Oomoo`1mOol2O1n6Ool001Qoo`80081oo`03O1moogoo08=o
o`0067oo00<007ooOol0P7oo0W`OPgoo000HOol00`00Oomoo`22Ool2O1n1Ool000]oo`8000Aoo`80
00Eoo`03001oogoo08Aoo`03O1moogoo07ioo`002Woo00@007ooOol0009oo`04001oogoo0004Ool0
0`00Oomoo`25Ool2O1mnOol000aoo`05001oogooOol00002Ool00`00Oomoo`02Ool30027Ool2O1ml
Ool000eoo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`29Ool00g`OOomoo`1iOol000Yo
o`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol0RWoo0W`ONGoo000;Ool20004Ool20005
Ool00`00Oomoo`2<Ool2O1mgOol001Qoo`03001oogoo08ioo`03O1moogoo07Aoo`0067oo00<007oo
Ool0Sgoo0W`OM7oo000HOol2002BOol00g`OOomoo`1aOol001Qoo`03001oogoo099oo`9l7g5oo`00
67oo00<007ooOol0U7oo00=l7gooOol0KWoo000HOol00`00Oomoo`2EOol2O1m^Ool001Qoo`03001o
ogoo09Moo`03O1moogoo06]oo`0067oo00<007ooOol0V7oo0W`OJgoo000HOol2002KOol2O1mYOol0
01Qoo`03001oogoo09aoo`03O1moogoo06Ioo`0067oo00<007ooOol0WGoo0W`OIWoo000HOol00`00
Oomoo`2OOol2O1mTOol001Qoo`03001oogoo0:5oo`03O1moogoo065oo`0067oo0P00Xgoo0W`OHGoo
000HOol00`00Oomoo`2TOol00g`OOomoo`1NOol001Qoo`03001oogoo0:Eoo`9l7eioo`0067oo00<0
07ooOol0Ygoo00=l7gooOol0Fgoo000HOol00`00Oomoo`2XOol2O1mKOol001Qoo`03001oogoo0:Yo
o`03O1moogoo05Qoo`0067oo0P00[7oo0W`OF7oo000HOol00`00Oomoo`2]Ool2O1mFOol001Qoo`03
001oogoo0:moo`03O1moogoo05=oo`0067oo00<007ooOol0/7oo0W`ODgoo000<Ool30002Ool20005
Ool00`00Oomoo`2bOol2O1mAOol000eoo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`2d
Ool00g`OOomoo`1>Ool000Yoo`D00005Ool007ooOol00004Ool3002eOol2O1m>Ool000Yoo`04001o
ogoo0002Ool01000Oomoo`0017oo00<007ooOol0]goo0W`OC7oo000;Ool00`00Ool00002Ool01000
Oomoo`0017oo00<007ooOol0^Goo00=l7gooOol0BGoo000<Ool20003Ool20005Ool00`00Oomoo`2j
Ool2O1m9Ool001Qoo`03001oogoo0;aoo`9l7dMoo`0067oo00<007ooOol0_Woo00=l7gooOol0A7oo
000HOol20030Ool2O1m4Ool001Qoo`03001oogoo0<5oo`9l7d9oo`0067oo00<007ooOol0`goo00=l
7gooOol0?goo000HOol00`00Oomoo`34Ool2O1loOol001Qoo`03001oogoo0<Ioo`9l7ceoo`0067oo
0P00bGoo00=l7gooOol0>Woo000HOol00`00Oomoo`39Ool2O1ljOol001Qoo`03001oogoo0<]oo`03
O1moogoo03Moo`0067oo00<007ooOol0c7oo0W`O=goo000HOol00`00Oomoo`3>Ool00g`OOomoo`0d
Ool001Qoo`03001oogoo0<moo`9l7cAoo`0067oo0P00dWoo00=l7gooOol0<Goo000HOol00`00Oomo
o`3BOol2O1laOol001Qoo`03001oogoo0=Aoo`9l7bmoo`0067oo00<007ooOol0eWoo00=l7gooOol0
;7oo000HOol00`00Oomoo`3GOol2O1l/Ool001Qoo`03001oogoo0=Uoo`9l7bYoo`0067oo0P00g7oo
00=l7gooOol09goo000HOol00`00Oomoo`3LOol2O1lWOol001Qoo`03001oogoo0=ioo`9l7bEoo`00
2goo0P0017oo0P001Goo00<007ooOol0h7oo0W`O8goo000:Ool01000Oomoo`000Woo00@007ooOol0
00Aoo`03001oogoo0>9oo`9l7b5oo`003Goo00@007ooOol0009oo`03001oogoo009oo`<00>Aoo`03
O1moogoo01ioo`002goo0P000goo00@007ooOol000Aoo`03001oogoo0?moo`Ioo`002goo00<007oo
Ool00Woo00@007ooOol000Aoo`03001oogoo0?moo`Ioo`002goo0`000goo0P001Goo00<007ooOol0
ogoo1Woo000HOol00`00Oomoo`3oOol6Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo000EOol3003oOol9Ool001Ioo`03001oogoo0?mo
o`Qoo`005Woo0`00ogoo27oo000FOol01000Oomoo`00ogoo1goo000FOol01000Oomoo`00ogoo1goo
000EOol4003oOol8Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.106448, -4.21354, \
0.0043288, 0.350206}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[BoxData[
    \("Desplazamientos:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.149884 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .1646 -6 -4.5 ]
[.01131 .1646 0 4.5 ]
[.01131 .31448 -6 -4.5 ]
[.01131 .31448 0 4.5 ]
[.01131 .46437 -6 -4.5 ]
[.01131 .46437 0 4.5 ]
[.01131 .61425 -6 -4.5 ]
[.01131 .61425 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .1646 m
.03006 .1646 L
s
[(1)] .01131 .1646 1 0 Mshowa
.02381 .31448 m
.03006 .31448 L
s
[(2)] .01131 .31448 1 0 Mshowa
.02381 .46437 m
.03006 .46437 L
s
[(3)] .01131 .46437 1 0 Mshowa
.02381 .61425 m
.03006 .61425 L
s
[(4)] .01131 .61425 1 0 Mshowa
.125 Mabswid
.02381 .04469 m
.02756 .04469 L
s
.02381 .07467 m
.02756 .07467 L
s
.02381 .10465 m
.02756 .10465 L
s
.02381 .13462 m
.02756 .13462 L
s
.02381 .19458 m
.02756 .19458 L
s
.02381 .22455 m
.02756 .22455 L
s
.02381 .25453 m
.02756 .25453 L
s
.02381 .28451 m
.02756 .28451 L
s
.02381 .34446 m
.02756 .34446 L
s
.02381 .37444 m
.02756 .37444 L
s
.02381 .40441 m
.02756 .40441 L
s
.02381 .43439 m
.02756 .43439 L
s
.02381 .49434 m
.02756 .49434 L
s
.02381 .52432 m
.02756 .52432 L
s
.02381 .5543 m
.02756 .5543 L
s
.02381 .58428 m
.02756 .58428 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.02846 .01472 L
.03068 .01472 L
.03178 .01472 L
.03279 .01472 L
.03398 .01472 L
.03527 .01472 L
.03754 .01472 L
.04016 .01473 L
.04144 .01473 L
.04262 .01473 L
.04375 .01473 L
.04482 .01474 L
.0472 .01474 L
.04981 .01475 L
.05109 .01476 L
.05224 .01476 L
.05346 .01477 L
.0546 .01477 L
.05712 .01479 L
.05966 .0148 L
.061 .01481 L
.06244 .01482 L
.0651 .01485 L
.06757 .01487 L
.07299 .01493 L
.08269 .01507 L
.09414 .0153 L
.10458 .01559 L
.12366 .01631 L
.13445 .01686 L
.14443 .01746 L
.16309 .01886 L
.18369 .02085 L
.22389 .0263 L
.26258 .03374 L
.30372 .04422 L
.34335 .05688 L
.38145 .07143 L
.42202 .08934 L
.46106 .10875 L
.50256 .13431 L
.54254 .16574 L
.58101 .20282 L
.62193 .25016 L
.66133 .30401 L
.69922 .36397 L
.73956 .43714 L
.77838 .51715 L
.81966 .61313 L
Mistroke
Mfstroke
.81966 .61313 m
.82154 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo000lOol2
0004Ool20003Ool4000OOol20004Ool20005Ool3000OOol20004Ool20003Ool3000POol20004Ool2
0004Ool2000UOol5000QOol003]oo`04001oogoo0008Ool00`00Oomoo`0OOol01000Oomoo`002goo
00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`0027oo00@007ooOol0
02Ioo`03001oogoo025oo`00>goo00@007ooOol000Uoo`03001oogoo01ioo`04001oogoo0008Ool5
000NOol01000Oomoo`0027oo00@007ooOol001ioo`04001oogoo0008Ool01000Oomoo`009Woo00<0
07ooOol08Goo000kOol01000Oomoo`002Woo00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo
000OOol01000Oomoo`0027oo0`007goo00@007ooOol000Uoo`8002Moo`03001oogoo025oo`00>goo
00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`002Goo00<007oo00007goo00@007ooOol0
00Uoo`03001oogoo01ioo`04001oogoo0008Ool01000Oomoo`009Woo00<007ooOol08Goo000lOol2
000:Ool2000POol2000;Ool2000POol2000:Ool3000OOol2000:Ool2000VOol2000SOol00?moob5o
o`005Goo00<007ooOol0ogoo2Goo000EOol00`00Oomoo`3oOol9Ool001Eoo`03001oogoo0?Aoo`80
019oo`005Goo00<007ooOol0lgoo00@007ooOol0015oo`003goo1P0087`0cP0027oo00<007ooOol0
4Woo000EOol00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`06Ool=O0000goo001oo`0:Ool0
0`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09Ool0
0`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool0
0`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`08Ool0
0`00Oomoo`0;Ool5000AOol001Eoo`03001oogoo02Yoo`Ml0<9oo`03001oogoo019oo`005Goo00<0
07ooOol0<Goo17`0dgoo000EOol00`00Oomoo`0eOol4O03?Ool001Eoo`03001oogoo03Uoo`Al0<]o
o`005Goo00<007ooOol0?Goo0g`0b7oo000EOol20011Ool3O035Ool001Eoo`03001oogoo04=oo`Al
0<5oo`005Goo00<007ooOol0Agoo0g`0_Woo000EOol00`00Oomoo`1:Ool3O02kOol001Eoo`03001o
ogoo04eoo`=l0;Qoo`005Goo00<007ooOol0D7oo0g`0]Goo000EOol00`00Oomoo`1COol3O02bOol0
01Eoo`8005Moo`9l0;1oo`005Goo00<007ooOol0F7oo0W`0[Woo000EOol00`00Oomoo`1JOol2O02/
Ool001Eoo`03001oogoo05aoo`9l0:Yoo`005Goo00<007ooOol0GWoo0W`0Z7oo000EOol00`00Oomo
o`1POol2O02VOol001Eoo`03001oogoo069oo`9l0:Aoo`005Goo0P00IGoo0W`0XWoo000EOol00`00
Oomoo`1VOol2O02POol001Eoo`03001oogoo06Qoo`9l09ioo`005Goo00<007ooOol0JWoo00=l07oo
Ool0Vgoo000EOol00`00Oomoo`1[Ool00g`0Oomoo`2JOol001Eoo`03001oogoo06aoo`9l09Yoo`00
5Goo00<007ooOol0KWoo00=l07ooOol0Ugoo000EOol00`00Oomoo`1_Ool2O02GOol001Eoo`80079o
o`03O01oogoo09Aoo`005Goo00<007ooOol0LWoo0W`0U7oo000EOol00`00Oomoo`1dOol00g`0Oomo
o`2AOol001Eoo`03001oogoo07Eoo`03O01oogoo091oo`005Goo00<007ooOol0MWoo0W`0T7oo000=
Ool50003Ool00`00Oomoo`1hOol00g`0Oomoo`2=Ool000moo`03001oogoo00=oo`03001oogoo07Uo
o`9l08eoo`003goo00<007ooOol00goo0`00Ngoo00=l07ooOol0RWoo000?Ool00`00Oomoo`03Ool0
0`00Oomoo`1lOol00g`0Oomoo`29Ool000moo`03001oogoo00=oo`03001oogoo07eoo`03O01oogoo
08Qoo`003Woo0P001Goo00<007ooOol0OWoo00=l07ooOol0Qgoo000EOol00`00Oomoo`1oOol00g`0
Oomoo`26Ool001Eoo`03001oogoo081oo`03O01oogoo08Eoo`005Goo00<007ooOol0PGoo00=l07oo
Ool0Q7oo000EOol20023Ool00g`0Oomoo`23Ool001Eoo`03001oogoo08=oo`03O01oogoo089oo`00
5Goo00<007ooOol0Q7oo00=l07ooOol0PGoo000EOol00`00Oomoo`25Ool00g`0Oomoo`20Ool001Eo
o`03001oogoo08Ioo`03O01oogoo07moo`005Goo00<007ooOol0QWoo00=l07ooOol0Ogoo000EOol0
0`00Oomoo`27Ool00g`0Oomoo`1nOol001Eoo`8008Uoo`03O01oogoo07eoo`005Goo00<007ooOol0
RGoo00=l07ooOol0O7oo000EOol00`00Oomoo`2:Ool00g`0Oomoo`1kOol001Eoo`03001oogoo08]o
o`03O01oogoo07Yoo`005Goo00<007ooOol0Rgoo00=l07ooOol0NWoo000EOol00`00Oomoo`2<Ool0
0g`0Oomoo`1iOol001Eoo`03001oogoo08eoo`03O01oogoo07Qoo`005Goo00<007ooOol0SWoo00=l
07ooOol0Mgoo000EOol2002@Ool00g`0Oomoo`1fOol001Eoo`03001oogoo091oo`03O01oogoo07Eo
o`005Goo00<007ooOol0T7oo00=l07ooOol0MGoo000EOol00`00Oomoo`2AOol00g`0Oomoo`1dOol0
01Eoo`03001oogoo099oo`03O01oogoo07=oo`005Goo00<007ooOol0Tgoo00=l07ooOol0LWoo000E
Ool00`00Oomoo`2COol00g`0Oomoo`1bOol001Eoo`8009Eoo`03O01oogoo075oo`005Goo00<007oo
Ool0UGoo00=l07ooOol0L7oo000EOol00`00Oomoo`2FOol00g`0Oomoo`1_Ool001Eoo`03001oogoo
09Ioo`03O01oogoo06moo`005Goo00<007ooOol0Ugoo00=l07ooOol0KWoo000=Ool40004Ool00`00
Oomoo`2HOol00g`0Oomoo`1]Ool000eoo`03001oogoo00Eoo`03001oogoo09Uoo`03O01oogoo06ao
o`003Woo00<007ooOol017oo0`00VGoo00=l07ooOol0K7oo000?Ool00`00Oomoo`03Ool00`00Oomo
o`2JOol00g`0Oomoo`1[Ool000eoo`04001oogoo0004Ool00`00Oomoo`2KOol00g`0Oomoo`1ZOol0
00ioo`8000Eoo`03001oogoo09]oo`03O01oogoo06Yoo`005Goo00<007ooOol0W7oo00=l07ooOol0
JGoo000EOol00`00Oomoo`2LOol00g`0Oomoo`1YOol001Eoo`03001oogoo09eoo`03O01oogoo06Qo
o`005Goo00<007ooOol0WWoo00=l07ooOol0Igoo000EOol2002OOol00g`0Oomoo`1WOol001Eoo`03
001oogoo09moo`03O01oogoo06Ioo`005Goo00<007ooOol0X7oo00=l07ooOol0IGoo000EOol00`00
Oomoo`2POol00g`0Oomoo`1UOol001Eoo`03001oogoo0:5oo`03O01oogoo06Aoo`005Goo00<007oo
Ool0XWoo00=l07ooOol0Hgoo000EOol00`00Oomoo`2ROol00g`0Oomoo`1SOol001Eoo`800:Aoo`03
O01oogoo069oo`005Goo00<007ooOol0Xgoo00=l07ooOol0HWoo000EOol00`00Oomoo`2TOol00g`0
Oomoo`1QOol001Eoo`03001oogoo0:Aoo`03O01oogoo065oo`005Goo00<007ooOol0YGoo00=l07oo
Ool0H7oo000EOol00`00Oomoo`2UOol00g`0Oomoo`1POol001Eoo`03001oogoo0:Ioo`03O01oogoo
05moo`005Goo0P00Z7oo00=l07ooOol0GWoo000EOol00`00Oomoo`2WOol00g`0Oomoo`1NOol001Eo
o`03001oogoo0:Qoo`03O01oogoo05eoo`005Goo00<007ooOol0Z7oo00=l07ooOol0GGoo000EOol0
0`00Oomoo`2YOol00g`0Oomoo`1LOol001Eoo`03001oogoo0:Uoo`03O01oogoo05aoo`005Goo00<0
07ooOol0ZWoo00=l07ooOol0Fgoo000EOol2002[Ool00g`0Oomoo`1KOol001Eoo`03001oogoo0:]o
o`03O01oogoo05Yoo`005Goo00<007ooOol0Zgoo00=l07ooOol0FWoo000EOol00`00Oomoo`2/Ool0
0g`0Oomoo`1IOol001Eoo`03001oogoo0:aoo`03O01oogoo05Uoo`005Goo00<007ooOol0[Goo00=l
07ooOol0F7oo000>Ool20005Ool00`00Oomoo`2]Ool00g`0Oomoo`1HOol000eoo`04001oogoo0004
Ool00`00Oomoo`2^Ool00g`0Oomoo`1GOol000moo`03001oogoo00=oo`<00:ioo`03O01oogoo05Mo
o`0047oo00<007ooOol00Woo00<007ooOol0[goo00=l07ooOol0EWoo000=Ool01000Oomoo`0017oo
00<007ooOol0[goo00=l07ooOol0EWoo000>Ool20005Ool00`00Oomoo`2`Ool00g`0Oomoo`1EOol0
01Eoo`03001oogoo0;1oo`03O01oogoo05Eoo`005Goo00<007ooOol0/Goo00=l07ooOol0E7oo000E
Ool00`00Oomoo`2aOol00g`0Oomoo`1DOol001Eoo`800;=oo`03O01oogoo05=oo`005Goo00<007oo
Ool0/Woo00=l07ooOol0Dgoo000EOol00`00Oomoo`2cOol00g`0Oomoo`1BOol001Eoo`03001oogoo
0;=oo`03O01oogoo059oo`005Goo00<007ooOol0]7oo00=l07ooOol0DGoo000EOol00`00Oomoo`2d
Ool00g`0Oomoo`1AOol001Eoo`03001oogoo0;Aoo`03O01oogoo055oo`005Goo0P00]Woo00=l07oo
Ool0D7oo000EOol00`00Oomoo`2eOol00g`0Oomoo`1@Ool001Eoo`03001oogoo0;Ioo`03O01oogoo
04moo`005Goo00<007ooOol0]Woo00=l07ooOol0Cgoo000EOol00`00Oomoo`2fOol00g`0Oomoo`1?
Ool001Eoo`03001oogoo0;Moo`03O01oogoo04ioo`005Goo00<007ooOol0]goo00=l07ooOol0CWoo
000EOol2002iOol00g`0Oomoo`1=Ool001Eoo`03001oogoo0;Qoo`03O01oogoo04eoo`005Goo00<0
07ooOol0^Goo00=l07ooOol0C7oo000EOol00`00Oomoo`2iOol00g`0Oomoo`1<Ool001Eoo`03001o
ogoo0;Uoo`03O01oogoo04aoo`005Goo00<007ooOol0^Woo00=l07ooOol0Bgoo000EOol00`00Oomo
o`2jOol00g`0Oomoo`1;Ool001Eoo`03001oogoo0;]oo`03O01oogoo04Yoo`005Goo0P00_7oo00=l
07ooOol0BWoo000EOol00`00Oomoo`2kOol00g`0Oomoo`1:Ool001Eoo`03001oogoo0;aoo`03O01o
ogoo04Uoo`005Goo00<007ooOol0_7oo00=l07ooOol0BGoo000EOol00`00Oomoo`2mOol00g`0Oomo
o`18Ool000moo`<000=oo`03001oogoo0;eoo`03O01oogoo04Qoo`0047oo00<007ooOol00Woo00<0
07ooOol0_Woo00=l07ooOol0Agoo000=Ool50003Ool3002nOol00g`0Oomoo`17Ool000eoo`04001o
ogoo0004Ool00`00Oomoo`2oOol00g`0Oomoo`16Ool000ioo`03001oo`000?mooa1oo`003goo0P00
ogoo47oo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQ
Ool00?moob5oo`0057oo1000ogoo2Goo000COol01000Oomoo`00ogoo2Woo000COol01000Oomoo`00
ogoo2Woo000BOol200000goo0000003oOol:Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5o
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0934619, -0.330938, \
0.0043288, 0.0275057}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[AAcute]ximo Desplazamiento: \
"\[InvisibleSpace]7.171345103975563`\),
      SequenceForm[ "M\[AAcute]ximo Desplazamiento: ", 7.1713451039755629],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[IAcute]nimo Desplazamiento: "\[InvisibleSpace]0\),
      
      SequenceForm[ "M\[IAcute]nimo Desplazamiento: ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Velocidades:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.0255799 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .14261 -6 -4.5 ]
[.01131 .14261 0 4.5 ]
[.01131 .27051 -12 -4.5 ]
[.01131 .27051 0 4.5 ]
[.01131 .39841 -12 -4.5 ]
[.01131 .39841 0 4.5 ]
[.01131 .52631 -12 -4.5 ]
[.01131 .52631 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .14261 m
.03006 .14261 L
s
[(5)] .01131 .14261 1 0 Mshowa
.02381 .27051 m
.03006 .27051 L
s
[(10)] .01131 .27051 1 0 Mshowa
.02381 .39841 m
.03006 .39841 L
s
[(15)] .01131 .39841 1 0 Mshowa
.02381 .52631 m
.03006 .52631 L
s
[(20)] .01131 .52631 1 0 Mshowa
.125 Mabswid
.02381 .0403 m
.02756 .0403 L
s
.02381 .06587 m
.02756 .06587 L
s
.02381 .09145 m
.02756 .09145 L
s
.02381 .11703 m
.02756 .11703 L
s
.02381 .16819 m
.02756 .16819 L
s
.02381 .19377 m
.02756 .19377 L
s
.02381 .21935 m
.02756 .21935 L
s
.02381 .24493 m
.02756 .24493 L
s
.02381 .29609 m
.02756 .29609 L
s
.02381 .32167 m
.02756 .32167 L
s
.02381 .34725 m
.02756 .34725 L
s
.02381 .37283 m
.02756 .37283 L
s
.02381 .42399 m
.02756 .42399 L
s
.02381 .44957 m
.02756 .44957 L
s
.02381 .47515 m
.02756 .47515 L
s
.02381 .50073 m
.02756 .50073 L
s
.02381 .55189 m
.02756 .55189 L
s
.02381 .57747 m
.02756 .57747 L
s
.02381 .60305 m
.02756 .60305 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 0 r
.5 Mabswid
.02381 .01472 m
.02846 .01475 L
.03068 .01476 L
.03178 .01477 L
.03279 .01478 L
.03398 .01479 L
.03527 .01482 L
.03754 .01486 L
.04016 .01492 L
.04144 .01494 L
.04262 .01497 L
.04375 .015 L
.04482 .01504 L
.0472 .01512 L
.05224 .01528 L
.06244 .01577 L
.07289 .01641 L
.08259 .01714 L
.10458 .01925 L
.14371 .02449 L
.18529 .03193 L
.22536 .0406 L
.26391 .04995 L
.30491 .06055 L
.3444 .07095 L
.38237 .0807 L
.4228 .09037 L
.44143 .09447 L
.4465 .09553 L
.45126 .09652 L
.45365 .0972 L
.45623 .09811 L
.45884 .09904 L
.46032 .09956 L
.46105 .09982 L
.4617 .10005 L
.4624 .10039 L
.46306 .10076 L
.46451 .10155 L
.46746 .10318 L
.47274 .10617 L
.48294 .11253 L
.50307 .12578 L
.54153 .15281 L
.58245 .18387 L
.62185 .216 L
.65974 .24896 L
.70008 .28627 L
.7389 .32436 L
.78018 .36719 L
Mistroke
.81994 .41071 L
.85819 .45468 L
.89888 .50372 L
.93807 .55315 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo000oOol2
0004Ool20003Ool4000OOol20004Ool20005Ool3000OOol20004Ool20003Ool3000POol20004Ool2
0004Ool2000UOol5000NOol003ioo`04001oogoo0008Ool00`00Oomoo`0OOol01000Oomoo`002goo
00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`0027oo00@007ooOol0
02Ioo`03001oogoo01ioo`00?Woo00@007ooOol000Uoo`03001oogoo01ioo`04001oogoo0008Ool5
000NOol01000Oomoo`0027oo00@007ooOol001ioo`04001oogoo0008Ool01000Oomoo`009Woo00<0
07ooOol07Woo000nOol01000Oomoo`002Woo00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo
000OOol01000Oomoo`0027oo0`007goo00@007ooOol000Uoo`8002Moo`03001oogoo01ioo`00?Woo
00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`002Goo00<007oo00007goo00@007ooOol0
00Uoo`03001oogoo01ioo`04001oogoo0008Ool01000Oomoo`009Woo00<007ooOol07Woo000oOol2
000:Ool2000POol2000;Ool2000POol2000:Ool3000OOol2000:Ool2000VOol2000POol00?moob5o
o`0067oo00<007ooOol0ogoo1Woo000HOol00`00Oomoo`3oOol6Ool001Qoo`03001oogoo0?Aoo`80
00moo`0067oo00<007ooOol0lgoo00@007ooOol000ioo`004Woo1P004P?Pg00027oo00<007ooOol0
3goo000HOol00`00Oomoo`09Ool00`00Oomoo`03Ool70n0:Ool00`00Oomoo`08Ool00`00Oomoo`09
Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09
Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08
Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`08
Ool00`00Oomoo`0;Ool5000>Ool001Qoo`03001oogoo01Ioo`L3h=Ioo`03001oogoo00moo`0067oo
00<007ooOol07Goo1@?Phgoo000HOol00`00Oomoo`0ROol50n3NOol001Qoo`03001oogoo02Moo`D3
h=Uoo`0067oo0P00;Goo1@?Pe7oo000HOol00`00Oomoo`0aOol40n3@Ool001Qoo`03001oogoo03Eo
o`@3h<aoo`0067oo00<007ooOol0>Goo10?Pb7oo000HOol00`00Oomoo`0mOol30n35Ool001Qoo`03
001oogoo041oo`@3h<5oo`0067oo0P00AGoo1@?P_7oo000HOol00`00Oomoo`19Ool40n2hOol001Qo
o`03001oogoo04eoo`<3h;Eoo`0067oo00<007ooOol0D7oo0`?P/Woo000HOol00`00Oomoo`1COol4
0n2^Ool001Qoo`03001oogoo05Moo`D3h:Uoo`0067oo0P00GGoo1@?PY7oo000HOol00`00Oomoo`1Q
Ool50n2OOol001Qoo`03001oogoo06Eoo`@3h9aoo`0067oo00<007ooOol0J7oo0P?PVgoo000HOol0
0`00Oomoo`1ZOol20n2IOol001Qoo`03001oogoo06aoo`030n1oogoo09Ioo`0067oo0P00KWoo00<3
h7ooOol0UGoo000HOol00`00Oomoo`1^Ool20n2EOol001Qoo`03001oogoo071oo`030n1oogoo099o
o`0067oo00<007ooOol0LGoo00<3h7ooOol0TGoo000HOol00`00Oomoo`1bOol20n2AOol0015oo`80
00Eoo`03001oogoo07Aoo`83h8moo`0047oo00@007ooOol000Aoo`03001oogoo07Ioo`030n1oogoo
08aoo`004goo00<007ooOol00Woo0`00Mgoo0P?PS7oo000AOol20005Ool00`00Oomoo`1iOol20n2:
Ool0015oo`03001oogoo00Aoo`03001oogoo07]oo`030n1oogoo08Moo`004Goo0`0017oo00<007oo
Ool0O7oo00<3h7ooOol0QWoo000HOol00`00Oomoo`1mOol20n26Ool001Qoo`03001oogoo07moo`03
0n1oogoo08=oo`0067oo0P00PGoo00<3h7ooOol0PWoo000HOol00`00Oomoo`21Ool00`?POomoo`21
Ool001Qoo`03001oogoo089oo`83h85oo`0067oo00<007ooOol0Q7oo00<3h7ooOol0OWoo000HOol0
0`00Oomoo`25Ool00`?POomoo`1mOol001Qoo`03001oogoo08Ioo`030n1oogoo07aoo`0067oo0P00
R7oo0P?PO7oo000HOol00`00Oomoo`29Ool00`?POomoo`1iOol001Qoo`03001oogoo08Yoo`030n1o
ogoo07Qoo`0067oo00<007ooOol0Rgoo0P?PN7oo000HOol00`00Oomoo`2=Ool00`?POomoo`1eOol0
01Qoo`03001oogoo08ioo`030n1oogoo07Aoo`0067oo0P00T7oo00<3h7ooOol0Lgoo000HOol00`00
Oomoo`2@Ool00`?POomoo`1bOol001Qoo`03001oogoo095oo`030n1oogoo075oo`0067oo00<007oo
Ool0TWoo0P?PLGoo000HOol00`00Oomoo`2DOol00`?POomoo`1^Ool001Qoo`03001oogoo09Eoo`03
0n1oogoo06eoo`0067oo0P00Ugoo00<3h7ooOol0K7oo000HOol00`00Oomoo`2GOol00`?POomoo`1[
Ool001Qoo`03001oogoo09Qoo`030n1oogoo06Yoo`0067oo00<007ooOol0VGoo00<3h7ooOol0JGoo
000HOol00`00Oomoo`2JOol00`?POomoo`1XOol000Yoo`D0009oo`8000Eoo`03001oogoo09]oo`03
0n1oogoo06Moo`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo09aoo`83h6Mo
o`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`<009ioo`030n1oogoo06Aoo`0037oo00D0
07ooOomoo`00009oo`03001oogoo009oo`03001oogoo09moo`030n1oogoo06=oo`0037oo00D007oo
Oomoo`00009oo`03001oogoo009oo`03001oogoo0:1oo`030n1oogoo069oo`002goo0P0017oo0P00
1Goo00<007ooOol0XGoo00<3h7ooOol0HGoo000HOol00`00Oomoo`2ROol00`?POomoo`1POol001Qo
o`03001oogoo0:=oo`030n1oogoo05moo`0067oo0P00YGoo00<3h7ooOol0GWoo000HOol00`00Oomo
o`2UOol00`?POomoo`1MOol001Qoo`03001oogoo0:Ioo`030n1oogoo05aoo`0067oo00<007ooOol0
Ygoo00<3h7ooOol0Fgoo000HOol00`00Oomoo`2XOol00`?POomoo`1JOol001Qoo`03001oogoo0:Uo
o`030n1oogoo05Uoo`0067oo0P00Zgoo00<3h7ooOol0F7oo000HOol00`00Oomoo`2[Ool00`?POomo
o`1GOol001Qoo`03001oogoo0:aoo`030n1oogoo05Ioo`0067oo00<007ooOol0[Goo00<3h7ooOol0
EGoo000HOol00`00Oomoo`2^Ool00`?POomoo`1DOol001Qoo`03001oogoo0:moo`030n1oogoo05=o
o`0067oo0P00/Goo00<3h7ooOol0DWoo000HOol00`00Oomoo`2aOol00`?POomoo`1AOol001Qoo`03
001oogoo0;9oo`030n1oogoo051oo`0067oo00<007ooOol0/goo00<3h7ooOol0Cgoo000HOol00`00
Oomoo`2dOol00`?POomoo`1>Ool001Qoo`03001oogoo0;Eoo`030n1oogoo04eoo`0067oo0P00]goo
00<3h7ooOol0C7oo000HOol00`00Oomoo`2gOol00`?POomoo`1;Ool001Qoo`03001oogoo0;Moo`03
0n1oogoo04]oo`0067oo00<007ooOol0^7oo00<3h7ooOol0BWoo000HOol00`00Oomoo`2iOol00`?P
Oomoo`19Ool000Yoo`D0009oo`8000Eoo`03001oogoo0;Yoo`030n1oogoo04Qoo`0037oo00D007oo
Oomoo`00009oo`03001oogoo009oo`03001oogoo0;]oo`030n1oogoo04Moo`0037oo00<007ooOol0
17oo00<007ooOol00Woo0`00_7oo00<3h7ooOol0AWoo000<Ool00`00Oomoo`02Ool20005Ool00`00
Oomoo`2lOol00`?POomoo`16Ool000aoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo0;eo
o`030n1oogoo04Eoo`002goo0P0017oo0`0017oo00<007ooOol0_Woo00<3h7ooOol0A7oo000HOol0
0`00Oomoo`2oOol00`?POomoo`13Ool001Qoo`03001oogoo0<1oo`030n1oogoo049oo`0067oo0P00
`Woo00<3h7ooOol0@Goo000HOol00`00Oomoo`32Ool00`?POomoo`10Ool001Qoo`03001oogoo0<9o
o`030n1oogoo041oo`0067oo00<007ooOol0`goo00<3h7ooOol0?goo000HOol00`00Oomoo`34Ool0
0`?POomoo`0nOol001Qoo`03001oogoo0<Eoo`030n1oogoo03eoo`0067oo0P00agoo00<3h7ooOol0
?7oo000HOol00`00Oomoo`37Ool00`?POomoo`0kOol001Qoo`03001oogoo0<Qoo`030n1oogoo03Yo
o`0067oo00<007ooOol0bGoo00<3h7ooOol0>Goo000HOol00`00Oomoo`39Ool00`?POomoo`0iOol0
01Qoo`03001oogoo0<Yoo`030n1oogoo03Qoo`0067oo0P00c7oo00<3h7ooOol0=goo000HOol00`00
Oomoo`3<Ool00`?POomoo`0fOol001Qoo`03001oogoo0<eoo`030n1oogoo03Eoo`0067oo00<007oo
Ool0cWoo00<3h7ooOol0=7oo000HOol00`00Oomoo`3>Ool00`?POomoo`0dOol001Qoo`03001oogoo
0<moo`030n1oogoo03=oo`0067oo0P00dGoo00<3h7ooOol0<Woo000HOol00`00Oomoo`3AOol00`?P
Oomoo`0aOol001Qoo`03001oogoo0=9oo`030n1oogoo031oo`0067oo00<007ooOol0dgoo00<3h7oo
Ool0;goo000HOol00`00Oomoo`3COol00`?POomoo`0_Ool000Yoo`@000=oo`8000Eoo`03001oogoo
0=Aoo`030n1oogoo02ioo`002Woo00<007ooOol00goo00@007ooOol000Aoo`03001oogoo0=Eoo`03
0n1oogoo02eoo`002goo00<007ooOol00Woo00@007ooOol000Aoo`<00=Ioo`030n1oogoo02aoo`00
37oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo0=Moo`030n1oogoo02]oo`002Woo
00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`3HOol00`?POomoo`0ZOol000]oo`8000Ao
o`8000Eoo`03001oogoo0=Qoo`030n1oogoo02Yoo`0067oo00<007ooOol0fGoo00<3h7ooOol0:Goo
000HOol00`00Oomoo`3JOol00`?POomoo`0XOol001Qoo`800=aoo`030n1oogoo02Moo`0067oo00<0
07ooOol0g7oo00<3h7ooOol09Woo000HOol00`00Oomoo`3MOol00`?POomoo`0UOol001Qoo`03001o
ogoo0=eoo`030n1oogoo02Eoo`0067oo00<007ooOol0gWoo00<3h7ooOol097oo000HOol00`00Oomo
o`3OOol00`?POomoo`0SOol001Qoo`800>5oo`030n1oogoo029oo`0067oo00<007ooOol0h7oo00<3
h7ooOol08Woo000HOol00`00Oomoo`3QOol00`?POomoo`0QOol001Qoo`03001oogoo0>9oo`030n1o
ogoo021oo`0067oo00<007ooOol0hgoo00<3h7ooOol07goo000HOol00`00Oomoo`3SOol00`?POomo
o`0OOol001Qoo`800>Eoo`030n1oogoo01ioo`0067oo00<007ooOol0ogoo1Woo000HOol00`00Oomo
o`3oOol6Ool001Qoo`03001oogoo0?moo`Ioo`0067oo00<007ooOol0ogoo1Woo003oOolQOol00?mo
ob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo
003oOolQOol001Moo`800?moo`Qoo`005goo0P00ogoo27oo000FOol01000Oomoo`00ogoo1goo000E
Ool20002Ool2003oOol6Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.106448, -1.93911, \
0.0043288, 0.161168}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[AAcute]xima Velocidad: \
"\[InvisibleSpace]23.01036513847973`\),
      SequenceForm[ "M\[AAcute]xima Velocidad: ", 23.010365138479731],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[IAcute]nima Velocidad: "\[InvisibleSpace]0\),
      SequenceForm[ "M\[IAcute]nima Velocidad: ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Aceleraciones:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 1.24488 0.0147151 0.0117721 [
[.27279 .00222 -9 -9 ]
[.27279 .00222 9 0 ]
[.52176 .00222 -9 -9 ]
[.52176 .00222 9 0 ]
[.77074 .00222 -9 -9 ]
[.77074 .00222 9 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .13244 -12 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -12 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -12 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -12 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -12 -4.5 ]
[.01131 .60332 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.27279 .01472 m
.27279 .02097 L
s
[(0.2)] .27279 .00222 0 1 Mshowa
.52176 .01472 m
.52176 .02097 L
s
[(0.4)] .52176 .00222 0 1 Mshowa
.77074 .01472 m
.77074 .02097 L
s
[(0.6)] .77074 .00222 0 1 Mshowa
.125 Mabswid
.08605 .01472 m
.08605 .01847 L
s
.1483 .01472 m
.1483 .01847 L
s
.21054 .01472 m
.21054 .01847 L
s
.33503 .01472 m
.33503 .01847 L
s
.39727 .01472 m
.39727 .01847 L
s
.45952 .01472 m
.45952 .01847 L
s
.58401 .01472 m
.58401 .01847 L
s
.64625 .01472 m
.64625 .01847 L
s
.70849 .01472 m
.70849 .01847 L
s
.83298 .01472 m
.83298 .01847 L
s
.89523 .01472 m
.89523 .01847 L
s
.95747 .01472 m
.95747 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .13244 m
.03006 .13244 L
s
[(10)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(20)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(30)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(40)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(50)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03826 m
.02756 .03826 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .08535 m
.02756 .08535 L
s
.02381 .10889 m
.02756 .10889 L
s
.02381 .15598 m
.02756 .15598 L
s
.02381 .17952 m
.02756 .17952 L
s
.02381 .20307 m
.02756 .20307 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .2737 m
.02756 .2737 L
s
.02381 .29724 m
.02756 .29724 L
s
.02381 .32079 m
.02756 .32079 L
s
.02381 .34433 m
.02756 .34433 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .41497 m
.02756 .41497 L
s
.02381 .43851 m
.02756 .43851 L
s
.02381 .46205 m
.02756 .46205 L
s
.02381 .50914 m
.02756 .50914 L
s
.02381 .53269 m
.02756 .53269 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57977 m
.02756 .57977 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .01472 m
.07431 .0384 L
.12939 .06296 L
.18111 .08379 L
.23086 .10095 L
.25858 .10903 L
.28381 .11535 L
.31031 .12087 L
.33477 .12488 L
.34668 .12643 L
.3598 .12786 L
.37299 .12897 L
.38021 .12942 L
.38697 .12979 L
.39346 .13004 L
.39522 .13011 L
.39688 .13017 L
.3978 .13019 L
.3988 .13021 L
.40054 .13024 L
.40402 .13029 L
.40722 .13034 L
.40879 .13036 L
.41024 .13037 L
.41176 .13036 L
.41343 .13035 L
.41657 .13032 L
.41955 .1303 L
.42084 .13029 L
.42222 .13028 L
.42372 .13023 L
.42512 .13019 L
.43166 .12998 L
.43765 .12973 L
.4499 .129 L
.4631 .1279 L
.48699 .12512 L
.51173 .12117 L
.53879 .11566 L
.56442 .10935 L
.5718 .10737 L
.57543 .10634 L
.57877 .10539 L
.58181 .10452 L
.58334 .10408 L
.58502 .11463 L
.58671 .13245 L
.58853 .1516 L
.5918 .1862 L
.59513 .22132 L
Mistroke
.59609 .23143 L
.59699 .23708 L
.59868 .24272 L
.60505 .26408 L
.60679 .26994 L
.60842 .27541 L
.61012 .2786 L
.61102 .27976 L
.61199 .28101 L
.61589 .28607 L
.61948 .29072 L
.62113 .29285 L
.62196 .29357 L
.62287 .29422 L
.62478 .29558 L
.62655 .29683 L
.63324 .30156 L
.64576 .30842 L
.69838 .33366 L
.74901 .35761 L
.80286 .38306 L
.85472 .40759 L
.9046 .43117 L
.95769 .45627 L
Mfstroke
.95769 .45627 m
1 .47628 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo001=Ool2
0004Ool20003Ool4000^Ool20004Ool20005Ool3000/Ool20004Ool20003Ool3001<Ool004aoo`04
001oogoo0008Ool00`00Oomoo`0^Ool01000Oomoo`002goo00<007ooOol0:Woo00@007ooOol000Qo
o`04001oogoo001;Ool004aoo`04001oogoo0009Ool00`00Oomoo`0]Ool01000Oomoo`0027oo1@00
:goo00@007ooOol000Qoo`04001oogoo001;Ool004aoo`04001oogoo000:Ool00`00Oomoo`0/Ool0
1000Oomoo`0027oo00@007ooOol002aoo`04001oogoo0008Ool3001<Ool004aoo`04001oogoo0008
Ool01000Oomoo`00;Goo00@007ooOol000Uoo`03001oo`0002aoo`04001oogoo0009Ool00`00Oomo
o`1;Ool004eoo`8000Yoo`8002moo`8000]oo`8002eoo`8000Yoo`<004]oo`00ogoo8Goo000HOol0
0`00Oomoo`3oOol6Ool001Qoo`03001oogoo0?moo`Ioo`0067oo00<007ooOol0m7oo0P003goo000H
Ool00`00Oomoo`3cOol01000Oomoo`003Woo000BOol6000201o/0008Ool00`00Oomoo`0?Ool001Qo
o`04001oo`0O01l;Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0=
Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<
Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0<Ool00`00Oomoo`0=
Ool00`00Oomoo`0?Ool5000>Ool001Qoo`04001oogooOol201o`Ool00`00Oomoo`0?Ool001Qoo`03
001oogoo00=oo`<07omoo`0067oo00<007ooOol01Woo0P0OoGoo000HOol20009Ool301ojOol001Qo
o`03001oogoo00]oo`807oQoo`0067oo00<007ooOol03Goo0P0OmWoo000HOol00`00Oomoo`0?Ool3
01ocOol001Qoo`03001oogoo019oo`807o5oo`0067oo00<007ooOol057oo0P0Okgoo000HOol2000G
Ool301o/Ool001Qoo`03001oogoo01Uoo`807nYoo`0067oo00<007ooOol06goo0P0Oj7oo000HOol0
0`00Oomoo`0MOol301oUOol001Qoo`03001oogoo021oo`807n=oo`0067oo00<007ooOol08Woo0`0O
h7oo000HOol2000VOol201oNOol001Qoo`03001oogoo02Moo`807maoo`0067oo00<007ooOol0:Goo
0`0OfGoo000HOol00`00Oomoo`0/Ool201oGOol001Qoo`03001oogoo02ioo`D07e5oo`807gmoo`00
67oo0P00=7oo1@0OBGoo1@0OOgoo000HOol00`00Oomoo`0hOol301m2Ool401l4Ool00`0OOomoo`1m
Ool001Qoo`03001oogoo03]oo`D07cMoo`H07`Qoo`0301moogoo07eoo`0067oo00<007ooOol0@7oo
1`0O:Goo1`0O3Woo00<07gooOol0OGoo000:Ool50002Ool20005Ool00`00Oomoo`17Ool401lPOol5
01lFOol00`0OOomoo`1lOol000aoo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`1;
Ool:01l<Ool:01lKOol00`0OOomoo`1lOol000aoo`05001oogooOol00002Ool00`00Oomoo`02Ool3
001EOol<01lUOol00`0OOomoo`1lOol000aoo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00
Oomoo`26Ool00`0OOomoo`1lOol000aoo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomo
o`26Ool00`0OOomoo`1lOol000]oo`8000Aoo`8000Eoo`03001oogoo08Ioo`0301moogoo07aoo`00
67oo00<007ooOol0QWoo00<07gooOol0O7oo000HOol00`00Oomoo`26Ool00`0OOomoo`1lOol001Qo
o`8008Moo`0301moogoo07aoo`0067oo00<007ooOol0QWoo00<07gooOol0O7oo000HOol00`00Oomo
o`26Ool00`0OOomoo`1lOol001Qoo`03001oogoo08Moo`0301moogoo07]oo`0067oo00<007ooOol0
Qgoo00<07gooOol0Ngoo000HOol00`00Oomoo`27Ool00`0OOomoo`1kOol001Qoo`8008Qoo`0301mo
ogoo07]oo`0067oo00<007ooOol0Qgoo00<07gooOol0Ngoo000HOol00`00Oomoo`27Ool00`0OOomo
o`1kOol001Qoo`03001oogoo08Moo`0301moogoo07]oo`0067oo00<007ooOol0Qgoo00<07gooOol0
Ngoo000HOol20028Ool00`0OOomoo`1kOol001Qoo`03001oogoo08Qoo`0301moogoo07Yoo`0067oo
00<007ooOol0R7oo00<07gooOol0NWoo000HOol00`00Oomoo`28Ool00`0OOomoo`1jOol001Qoo`03
001oogoo08Qoo`0301moogoo07Yoo`0067oo00<007ooOol0R7oo00<07gooOol0NWoo000HOol20029
Ool00`0OOomoo`1jOol001Qoo`03001oogoo08Qoo`0301moogoo07Yoo`0067oo00<007ooOol0R7oo
00<07gooOol0NWoo000HOol00`00Oomoo`28Ool00`0OOomoo`1jOol000Yoo`@000=oo`8000Eoo`03
001oogoo08Uoo`0301moogoo07Uoo`002Woo00<007ooOol00goo00@007ooOol000Aoo`03001oogoo
08Uoo`0301moogoo07Uoo`002goo00<007ooOol00Woo00@007ooOol000Aoo`<008Uoo`0301moogoo
07Uoo`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo08Yoo`0301moogoo07Qo
o`002Woo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`2:Ool00`0OOomoo`1hOol000]o
o`8000Aoo`8000Eoo`03001oogoo08Yoo`0301moogoo07Qoo`0067oo00<007ooOol0Rgoo00<07goo
Ool0Mgoo000HOol2002<Ool00`0OOomoo`1gOol001Qoo`03001oogoo08]oo`0301moogoo07Moo`00
67oo00<007ooOol0Rgoo0P0ON7oo000HOol00`00Oomoo`2=Ool00`0OOomoo`1eOol001Qoo`03001o
ogoo08ioo`0301moogoo07Aoo`0067oo00<007ooOol0SWoo00<07gooOol0M7oo000HOol2002@Ool2
01mdOol001Qoo`03001oogoo095oo`0301moogoo075oo`0067oo00<007ooOol0TWoo0P0OLGoo000H
Ool00`00Oomoo`2DOol201m_Ool001Qoo`03001oogoo09Ioo`807feoo`0067oo00<007ooOol0V7oo
0P0OJgoo000HOol2002KOol201mYOol001Qoo`03001oogoo09aoo`807fMoo`0067oo00<007ooOol0
WWoo0P0OIGoo000HOol00`00Oomoo`2POol301mROol001Qoo`03001oogoo0:=oo`807f1oo`0067oo
00<007ooOol0YGoo0P0OGWoo000HOol2002XOol201mLOol001Qoo`03001oogoo0:Uoo`807eYoo`00
67oo00<007ooOol0Zgoo0P0OF7oo000;Ool20004Ool20005Ool00`00Oomoo`2]Ool201mFOol000Yo
o`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol0[goo0P0OE7oo000<Ool01@00Oomoogoo
00000Woo00<007ooOol00Woo0`00/Goo0P0ODWoo000=Ool01000Oomoo`000Woo00<007ooOol00Woo
00<007ooOol0/goo0P0OD7oo000:Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo0;Eo
o`807dioo`002goo0P0017oo0P001Goo00<007ooOol0]goo0P0OC7oo000HOol00`00Oomoo`2iOol3
01m9Ool001Qoo`03001oogoo0;aoo`807dMoo`0067oo0P00_goo0P0OAGoo000HOol00`00Oomoo`30
Ool201m3Ool001Qoo`03001oogoo0<9oo`807d5oo`0067oo00<007ooOol0a7oo0P0O?goo000HOol0
0`00Oomoo`36Ool301llOol001Qoo`03001oogoo0<Uoo`807cYoo`0067oo0P00c7oo0P0O>7oo000H
Ool00`00Oomoo`3=Ool201lfOol001Qoo`03001oogoo0<moo`807cAoo`0067oo00<007ooOol0dGoo
0P0O<Woo000HOol00`00Oomoo`3COol201l`Ool001Qoo`800=Ioo`807bioo`0067oo00<007ooOol0
egoo0P0O;7oo000HOol00`00Oomoo`3IOol201lZOol001Qoo`03001oogoo0=]oo`807bQoo`0067oo
00<007ooOol0gGoo0P0O9Woo000HOol00`00Oomoo`3OOol301lSOol001Qoo`800>=oo`807b5oo`00
67oo00<007ooOol0i7oo0P0O7goo000HOol00`00Oomoo`3VOol201lMOol001Qoo`03001oogoo0>Qo
o`807a]oo`0037oo0`000Woo0P001Goo00<007ooOol0jWoo00<07gooOol067oo000=Ool01000Oomo
o`000Woo00<007ooOol00Woo00<007ooOol0ogoo1Woo000:Ool500001Goo001oogoo000017oo0`00
ogoo1Woo000:Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo0?moo`Ioo`002goo00<0
07oo00000Woo00@007ooOol000Aoo`03001oogoo0?moo`Ioo`0037oo0P000goo0P001Goo00<007oo
Ool0ogoo1Woo000HOol00`00Oomoo`3oOol6Ool001Qoo`03001oogoo0?moo`Ioo`0067oo0P00ogoo
1goo000HOol00`00Oomoo`3oOol6Ool001Qoo`03001oogoo0?moo`Ioo`0067oo00<007ooOol0ogoo
1Woo000HOol00`00Oomoo`3oOol6Ool001Qoo`800?moo`Moo`0067oo00<007ooOol0ogoo1Woo000H
Ool00`00Oomoo`3oOol6Ool001Qoo`03001oogoo0?moo`Ioo`0067oo00<007ooOol0ogoo1Woo000H
Ool00`00Oomoo`3oOol6Ool001Qoo`800?moo`Moo`0067oo00<007ooOol0ogoo1Woo000HOol00`00
Oomoo`3oOol6Ool001Qoo`03001oogoo0?moo`Ioo`0067oo00<007ooOol0ogoo1Woo000HOol00`00
Oomoo`3oOol6Ool001Qoo`800?moo`Moo`0067oo00<007ooOol0ogoo1Woo000HOol00`00Oomoo`3o
Ool6Ool000]oo`8000Aoo`8000Eoo`03001oogoo0?moo`Ioo`002Woo00@007ooOol0009oo`04001o
ogoo0004Ool00`00Oomoo`3oOol6Ool000eoo`04001oogoo0002Ool00`00Oomoo`02Ool3003oOol6
Ool000]oo`8000=oo`04001oogoo0004Ool00`00Oomoo`3oOol6Ool000]oo`03001oogoo009oo`04
001oogoo0004Ool00`00Oomoo`3oOol6Ool000]oo`<000=oo`8000Eoo`03001oogoo0?moo`Ioo`00
67oo00<007ooOol0ogoo1Woo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol001Ioo`D00?moo`Ioo`005Woo1000
ogoo1goo000IOol00`00Oomoo`3oOol5Ool001Moo`<00?moo`Moo`00ogoo8Goo003oOolQOol00?mo
ob5oo`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.081437, -4.21354, \
0.0033117, 0.350206}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[AAcute]xima Aceleraci\[OAcute]n: "\
\[InvisibleSpace]50.000000000023135`\),
      SequenceForm[ 
      "M\[AAcute]xima Aceleraci\[OAcute]n: ", 50.000000000023135],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[IAcute]nima Aceleraci\[OAcute]n: "\
\[InvisibleSpace]0.`\),
      SequenceForm[ "M\[IAcute]nima Aceleraci\[OAcute]n: ", 0.0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("fs"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.0392403 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .0932 -6 -4.5 ]
[.01131 .0932 0 4.5 ]
[.01131 .17168 -6 -4.5 ]
[.01131 .17168 0 4.5 ]
[.01131 .25016 -6 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .32864 -6 -4.5 ]
[.01131 .32864 0 4.5 ]
[.01131 .40712 -12 -4.5 ]
[.01131 .40712 0 4.5 ]
[.01131 .4856 -12 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .56408 -12 -4.5 ]
[.01131 .56408 0 4.5 ]
[.02381 .64303 -8 0 ]
[.02381 .64303 8 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .0932 m
.03006 .0932 L
s
[(2)] .01131 .0932 1 0 Mshowa
.02381 .17168 m
.03006 .17168 L
s
[(4)] .01131 .17168 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(6)] .01131 .25016 1 0 Mshowa
.02381 .32864 m
.03006 .32864 L
s
[(8)] .01131 .32864 1 0 Mshowa
.02381 .40712 m
.03006 .40712 L
s
[(10)] .01131 .40712 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(12)] .01131 .4856 1 0 Mshowa
.02381 .56408 m
.03006 .56408 L
s
[(14)] .01131 .56408 1 0 Mshowa
.125 Mabswid
.02381 .03434 m
.02756 .03434 L
s
.02381 .05396 m
.02756 .05396 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .11282 m
.02756 .11282 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .15206 m
.02756 .15206 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .21092 m
.02756 .21092 L
s
.02381 .23054 m
.02756 .23054 L
s
.02381 .26978 m
.02756 .26978 L
s
.02381 .2894 m
.02756 .2894 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .34826 m
.02756 .34826 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .3875 m
.02756 .3875 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .44636 m
.02756 .44636 L
s
.02381 .46598 m
.02756 .46598 L
s
.02381 .50522 m
.02756 .50522 L
s
.02381 .52484 m
.02756 .52484 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .5837 m
.02756 .5837 L
s
.02381 .60332 m
.02756 .60332 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(fs) show
75.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.02846 .01472 L
.03068 .01472 L
.03178 .01472 L
.03279 .01472 L
.03398 .01473 L
.03527 .01474 L
.03754 .01476 L
.04016 .01478 L
.04144 .01479 L
.04262 .0148 L
.04375 .01482 L
.04482 .01485 L
.0472 .0149 L
.04981 .01495 L
.05109 .01498 L
.05224 .015 L
.05346 .01505 L
.0546 .01509 L
.05712 .01519 L
.05966 .01529 L
.061 .01534 L
.06244 .01541 L
.0651 .01557 L
.06757 .01573 L
.07299 .0161 L
.08269 .01703 L
.09414 .01857 L
.10458 .02043 L
.12366 .02519 L
.13445 .02875 L
.14443 .03268 L
.16309 .04183 L
.18369 .05488 L
.22389 .09055 L
.26258 .13924 L
.30372 .20781 L
.34335 .29069 L
.38145 .38592 L
.42202 .50314 L
.44075 .56244 L
.44588 .57922 L
.44869 .58849 L
.45006 .59303 L
.45132 .59717 L
.45247 .6007 L
.45355 .60101 L
.45596 .60167 L
.45864 .60241 L
.4598 .60274 L
Mistroke
.46106 .60309 L
.46238 .60332 L
.46363 .60332 L
.46636 .60332 L
.47127 .60332 L
.48241 .60332 L
.50256 .60332 L
.54361 .60332 L
.58315 .60332 L
.62118 .60332 L
.66165 .60332 L
.70061 .60332 L
.74203 .60332 L
.78193 .60332 L
.82031 .60332 L
.86114 .60332 L
.90046 .60332 L
.93826 .60332 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo000oOol2
0004Ool20003Ool4000OOol20004Ool20005Ool3000OOol20004Ool20003Ool3000POol20004Ool2
0004Ool2000UOol5000NOol003ioo`04001oogoo0008Ool00`00Oomoo`0OOol01000Oomoo`002goo
00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`0027oo00@007ooOol0
02Ioo`03001oogoo01ioo`00?Woo00@007ooOol000Uoo`03001oogoo01ioo`04001oogoo0008Ool5
000NOol01000Oomoo`0027oo00@007ooOol001ioo`04001oogoo0008Ool01000Oomoo`009Woo00<0
07ooOol07Woo000nOol01000Oomoo`002Woo00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo
000OOol01000Oomoo`0027oo0`007goo00@007ooOol000Uoo`8002Moo`03001oogoo01ioo`00?Woo
00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`002Goo00<007oo00007goo00@007ooOol0
00Uoo`03001oogoo01ioo`04001oogoo0008Ool01000Oomoo`009Woo00<007ooOol07Woo000oOol2
000:Ool2000POol2000;Ool2000POol2000:Ool3000OOol2000:Ool2000VOol2000POol00?moob5o
o`0067oo00<007ooOol0ogoo1Woo000HOol00`00Oomoo`3oOol6Ool001Qoo`03001oogoo0?Aoo`80
00moo`0067oo00<007ooOol0lgoo00@007ooOol000ioo`004Woom00027oo00<007ooOol03goo000H
Ool00`00Oomoo`09Ool01000Oomoogoo20002goo00<007ooOol027oo00<007ooOol02Goo00<007oo
Ool027oo00<007ooOol02Goo00<007ooOol027oo00<007ooOol02Goo00<007ooOol02Goo00<007oo
Ool027oo00<007ooOol02Goo00<007ooOol027oo00<007ooOol02Goo00<007ooOol027oo00<007oo
Ool02Goo00<007ooOol027oo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol027oo00<007oo
Ool02goo1@003Woo000HOol00`00Oomoo`0DOol3003LOol00`00Oomoo`0?Ool001Qoo`03001oogoo
01Moo`<00>]oo`0067oo0P006goo0P00jGoo000HOol00`00Oomoo`0LOol2003WOol001Qoo`03001o
ogoo01ioo`800>Eoo`0067oo00<007ooOol087oo0P00hgoo000HOol00`00Oomoo`0ROol2003QOol0
01Qoo`8002Eoo`03001oogoo0=ioo`0067oo00<007ooOol09Goo00<007ooOol0gGoo000HOol00`00
Oomoo`0VOol00`00Oomoo`3LOol001Qoo`03001oogoo02Moo`03001oogoo0=]oo`0067oo00<007oo
Ool0:7oo00<007ooOol0fWoo000HOol2000ZOol2003JOol001Qoo`03001oogoo02]oo`03001oogoo
0=Moo`0067oo00<007ooOol0;7oo00<007ooOol0eWoo000@Ool40004Ool00`00Oomoo`0]Ool00`00
Oomoo`3EOol0011oo`03001oogoo00Eoo`03001oogoo02ioo`03001oogoo0=Aoo`004Goo00<007oo
Ool017oo0`00;goo00<007ooOol0dgoo000BOol00`00Oomoo`03Ool00`00Oomoo`0`Ool00`00Oomo
o`3BOol0011oo`04001oogoo0004Ool00`00Oomoo`0`Ool00`00Oomoo`3BOol0015oo`8000Eoo`03
001oogoo035oo`03001oogoo0=5oo`0067oo0P00<goo00<007ooOol0d7oo000HOol00`00Oomoo`0c
Ool00`00Oomoo`3?Ool001Qoo`03001oogoo03=oo`03001oogoo0<moo`0067oo00<007ooOol0=7oo
00<007ooOol0cWoo000HOol00`00Oomoo`0eOol00`00Oomoo`3=Ool001Qoo`8003Moo`03001oogoo
0<aoo`0067oo00<007ooOol0=Woo00<007ooOol0c7oo000HOol00`00Oomoo`0gOol00`00Oomoo`3;
Ool001Qoo`03001oogoo03Qoo`03001oogoo0<Yoo`0067oo00<007ooOol0>7oo00<007ooOol0bWoo
000HOol2000jOol00`00Oomoo`39Ool001Qoo`03001oogoo03Yoo`03001oogoo0<Qoo`0067oo00<0
07ooOol0>Woo00<007ooOol0b7oo000BOol30003Ool00`00Oomoo`0kOol00`00Oomoo`37Ool001=o
o`03001oogoo009oo`03001oogoo03]oo`03001oogoo0<Moo`0047oo1@000goo0`00?7oo00<007oo
Ool0aWoo000@Ool01000Oomoo`0017oo00<007ooOol0?Goo00<007ooOol0aGoo000AOol00`00Ool0
0004Ool00`00Oomoo`0mOol00`00Oomoo`35Ool0019oo`8000Aoo`03001oogoo03ioo`03001oogoo
0<Aoo`0067oo0P00@7oo00<007ooOol0`goo000HOol00`00Oomoo`0oOol00`00Oomoo`33Ool001Qo
o`03001oogoo041oo`03001oogoo0<9oo`0067oo00<007ooOol0@7oo00<007ooOol0`Woo000HOol0
0`00Oomoo`11Ool00`00Oomoo`31Ool001Qoo`80049oo`03001oogoo0<5oo`0067oo00<007ooOol0
@Woo00<007ooOol0`7oo000HOol00`00Oomoo`12Ool00`00Oomoo`30Ool001Qoo`03001oogoo04=o
o`03001oogoo0;moo`0067oo00<007ooOol0@goo00<007ooOol0_goo000HOol20015Ool00`00Oomo
o`2nOol001Qoo`03001oogoo04Aoo`03001oogoo0;ioo`0067oo00<007ooOol0AGoo00<007ooOol0
_Goo000@Ool30005Ool00`00Oomoo`15Ool00`00Oomoo`2mOol0011oo`04001oogoo0004Ool00`00
Oomoo`16Ool00`00Oomoo`2lOol0011oo`04001oogoo0004Ool30016Ool00`00Oomoo`2lOol0011o
o`<000Eoo`03001oogoo04Moo`03001oogoo0;]oo`004Goo00<007ooOol017oo00<007ooOol0Agoo
00<007ooOol0^goo000AOol30004Ool00`00Oomoo`18Ool00`00Oomoo`2jOol001Qoo`8004Uoo`03
001oogoo0;Yoo`0067oo00<007ooOol0BGoo00<007ooOol0^Goo000HOol00`00Oomoo`19Ool00`00
Oomoo`2iOol001Qoo`03001oogoo04Yoo`03001oogoo0;Qoo`0067oo00<007ooOol0BWoo00<007oo
Ool0^7oo000HOol2001<Ool00`00Oomoo`2gOol001Qoo`03001oogoo04]oo`03001oogoo0;Moo`00
67oo00<007ooOol0Bgoo00<007ooOol0]goo000HOol00`00Oomoo`1<Ool00`00Oomoo`2fOol001Qo
o`03001oogoo04aoo`03001oogoo0;Ioo`0067oo0P00CWoo00<007ooOol0]Goo000HOol00`00Oomo
o`1=Ool00`00Oomoo`2eOol001Qoo`03001oogoo04eoo`03001oogoo0;Eoo`004Goo0P001Goo00<0
07ooOol0CWoo00<007ooOol0]7oo000@Ool01000Oomoo`0017oo00<007ooOol0CWoo00<007ooOol0
]7oo000@Ool01000Oomoo`0017oo0`00Cgoo00<007ooOol0/goo000AOol20005Ool00`00Oomoo`1?
Ool00`00Oomoo`2cOol0011oo`04001oogoo0004Ool00`00Oomoo`1?Ool00`00Oomoo`2cOol0015o
o`8000Eoo`03001oogoo051oo`03001oogoo0;9oo`0067oo0P00DGoo00<007ooOol0/Woo000HOol0
0`00Oomoo`1@Ool00`00Oomoo`2bOol001Qoo`03001oogoo055oo`03001oogoo0;5oo`0067oo00<0
07ooOol0DGoo00<007ooOol0/Goo000HOol00`00Oomoo`1BOol00`00Oomoo`2`Ool001Qoo`8005=o
o`03001oogoo0;1oo`0067oo00<007ooOol0DWoo00<007ooOol0/7oo000HOol00`00Oomoo`1COol0
0`00Oomoo`2_Ool001Qoo`03001oogoo05=oo`03001oogoo0:moo`0067oo00<007ooOol0E7oo00<0
07ooOol0[Woo000HOol2001EOol00`00Oomoo`2^Ool001Qoo`03001oogoo05Aoo`03001oogoo0:io
o`0067oo00<007ooOol0EGoo00<007ooOol0[Goo000:Ool50002Ool20005Ool00`00Oomoo`1EOol0
0`00Oomoo`2]Ool000aoo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`1EOol00`00
Oomoo`2]Ool000aoo`05001oogooOol00002Ool00`00Oomoo`02Ool3001FOol00`00Oomoo`2/Ool0
00aoo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`1FOol00`00Oomoo`2/Ool000ao
o`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`1FOol00`00Oomoo`2/Ool000]oo`80
00Aoo`8000Eoo`03001oogoo05Moo`03001oogoo0:]oo`0067oo00<007ooOol0Egoo00<007ooOol0
Zgoo000HOol2001IOol00`00Oomoo`2ZOol001Qoo`03001oogoo05Qoo`03001oogoo0:Yoo`0067oo
00<007ooOol0F7oo00<007ooOol0ZWoo000HOol00`00Oomoo`1IOol00`00Oomoo`2YOol001Qoo`80
05Yoo`03001oogoo0:Uoo`0067oo00<007ooOol0FGoo00<007ooOol0ZGoo000HOol00`00Oomoo`1J
Ool00`00Oomoo`2XOol001Qoo`03001oogoo05Yoo`03001oogoo0:Qoo`0067oo00<007ooOol0FWoo
00<007ooOol0Z7oo000HOol2001LOol00`00Oomoo`2WOol001Qoo`03001oogoo05]oo`03001oogoo
0:Moo`0067oo00<007ooOol0Fgoo00<007ooOol0Ygoo000:Ool500000goo000000020004Ool00`00
Oomoo`1LOol00`00Oomoo`2VOol000aoo`05001oogooOol00007Ool00`00Oomoo`1LOol00`00Oomo
o`2VOol000aoo`03001oogoo009oo`03001oogoo00Aoo`<005eoo`03001oogoo0:Eoo`0037oo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol0GGoo00<007ooOol0YGoo000<Ool01@00Oomoogoo
00000Woo00<007ooOol00Woo00<007ooOol0GGoo00<007ooOol0YGoo000;Ool20004Ool20005Ool0
0`00Oomoo`1NOol00`00Oomoo`2TOol001Qoo`03001oogoo05ioo`03001oogoo0:Aoo`0067oo0P00
Ggoo00<007ooOol0Y7oo000HOol00`00Oomoo`1OOol00`00Oomoo`2SOol001Qoo`03001oogoo05mo
o`03001oogoo0:=oo`0067oo00<007ooOol0Ggoo00<007ooOol0Xgoo000HOol2001POol00`00Oomo
o`2SOol001Qoo`03001oogoo061oo`03001oogoo0:9oo`0067oo00<007ooOol0H7oo00<007ooOol0
XWoo000HOol00`00Oomoo`1POol00`00Oomoo`2ROol001Qoo`03001oogoo065oo`03001oogoo0:5o
o`0067oo0P00HWoo00<007ooOol0XGoo000HOol00`00Oomoo`1QOol00`00Oomoo`2QOol001Qoo`03
001oogoo065oo`03001oogoo0:5oo`002Woo1@000goo0`000goo00<007ooOol0HWoo00<007ooOol0
X7oo000<Ool00`00Oomoo`04Ool00`00Oomoo`02Ool00`00Oomoo`1ROol00`00Oomoo`2POol000ao
o`04001oogooOol50003Ool3001ROol00`00Oomoo`2POol000aoo`05001oogooOol00002Ool00`00
Oomoo`02Ool00`00Oomoo`1ROol00`00Oomoo`2POol000aoo`03001oogoo009oo`03001oo`0000Ao
o`03001oogoo06=oo`03001oogoo09moo`002goo0P001Goo0P0017oo00<007ooOol0Hgoo00<007oo
Ool0Wgoo000HOol00`00Oomoo`1SOol00`00Oomoo`2OOol001Qoo`8006Eoo`03001oogoo09ioo`00
67oo00<007ooOol0I7oo00<007ooOol0WWoo000HOol00`00Oomoo`1TOol00`00Oomoo`2NOol001Qo
o`03001oogoo06Eoo`03001oogoo09eoo`0067oo0P00IWooP00087oo000HOol00`00Oomoo`3oOol6
Ool001Qoo`03001oogoo0?moo`Ioo`0067oo00<007ooOol0ogoo1Woo000HOol00`00Oomoo`3oOol6
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`004goo10000Woo0`00ogoo1Goo000DOol00`00Oomoo`05Ool0
0`00Oomoo`3oOol2Ool001Aoo`03001oogoo009oo`<00?moo`Eoo`004goo10000Woo1000ogoo17oo
000DOol00`00Oomoo`3oOol:Ool001Eoo`800?moo`Yoo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.106448, -1.26406, \
0.0043288, 0.105062}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("t      p"\[InvisibleSpace]"        \
"\[InvisibleSpace]"t        u"\[InvisibleSpace]"              "\
\[InvisibleSpace]"t        v"\[InvisibleSpace]"          "\[InvisibleSpace]"t \
      a"\[InvisibleSpace]"         "\[InvisibleSpace]"t      kt"\),
      SequenceForm[ 
      "t      p", "        ", "t        u", "              ", "t        v", 
        "          ", "t       a", "         ", "t      kt"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("-----------------------------------------------------------------------\
------------------------"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        InterpretationBox[GridBox[{
              {"0"},
              {"0.01`"},
              {"0.02`"},
              {"0.03`"},
              {"0.04`"},
              {"0.05`"},
              {"0.06`"},
              {"0.07`"},
              {"0.08`"},
              {"0.09`"},
              {"0.1`"},
              {"0.11`"},
              {"0.12`"},
              {"0.13`"},
              {"0.14`"},
              {"0.15`"},
              {"0.16`"},
              {"0.17`"},
              {"0.18`"},
              {"0.19`"},
              {"0.2`"},
              {"0.21`"},
              {"0.22`"},
              {"0.23`"},
              {"0.24`"},
              {"0.25`"},
              {"0.26`"},
              {"0.27`"},
              {"0.28`"},
              {"0.29`"},
              {"0.3`"},
              {"0.31`"},
              {"0.32`"},
              {"0.33`"},
              {"0.34`"},
              {"0.35000000000000003`"},
              {"0.36`"},
              {"0.37`"},
              {"0.38`"},
              {"0.39`"},
              {"0.4`"},
              {"0.41000000000000003`"},
              {"0.42`"},
              {"0.43`"},
              {"0.44`"},
              {"0.45`"},
              {"0.46`"},
              {"0.47000000000000003`"},
              {"0.48`"},
              {"0.49`"},
              {"0.5`"},
              {"0.51`"},
              {"0.52`"},
              {"0.53`"},
              {"0.54`"},
              {"0.55`"},
              {"0.56`"},
              {"0.5700000000000001`"},
              {"0.58`"},
              {"0.59`"},
              {"0.6`"},
              {"0.61`"},
              {"0.62`"},
              {"0.63`"},
              {"0.64`"},
              {"0.65`"},
              {"0.66`"},
              {"0.67`"},
              {"0.68`"},
              {"0.6900000000000001`"},
              {"0.7000000000000001`"},
              {"0.71`"},
              {"0.72`"},
              {"0.73`"},
              {"0.74`"},
              {"0.75`"},
              {"0.76`"},
              {"0.77`"},
              {"0.78`"},
              {"0.79`"},
              {"0.8`"},
              {"0.81`"},
              {"0.8200000000000001`"},
              {"0.8300000000000001`"},
              {"0.84`"},
              {"0.85`"},
              {"0.86`"},
              {"0.87`"},
              {"0.88`"},
              {"0.89`"},
              {"0.9`"},
              {"0.91`"},
              {"0.92`"},
              {"0.93`"},
              {"0.9400000000000001`"},
              {"0.9500000000000001`"},
              {"0.96`"},
              {"0.97`"},
              {"0.98`"},
              {"0.99`"},
              {"1.`"}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {
            0, .01, .02, .029999999999999999, .040000000000000001, \
.050000000000000003, .059999999999999998, .070000000000000007, \
.080000000000000002, .089999999999999997, .10000000000000001, .11, .12, .13, \
.14000000000000001, .14999999999999999, .16, .17000000000000001, \
.17999999999999999, .19, .20000000000000001, .20999999999999999, .22, \
.23000000000000001, .23999999999999999, .25, .26000000000000001, \
.27000000000000002, .28000000000000003, .28999999999999998, \
.29999999999999999, .31, .32000000000000001, .33000000000000002, \
.34000000000000002, .35000000000000003, .35999999999999999, .37, .38, \
.39000000000000001, .40000000000000002, .41000000000000003, \
.41999999999999998, .42999999999999999, .44, .45000000000000001, \
.46000000000000002, .47000000000000003, .47999999999999998, \
.48999999999999999, .5, .51000000000000001, .52000000000000002, \
.53000000000000003, .54000000000000004, .55000000000000004, \
.56000000000000005, .57000000000000006, .57999999999999996, \
.58999999999999997, .59999999999999998, .60999999999999999, .62, .63, \
.64000000000000001, .65000000000000002, .66000000000000003, \
.67000000000000004, .68000000000000005, .69000000000000006, \
.70000000000000007, .70999999999999996, .71999999999999997, \
.72999999999999998, .73999999999999999, .75, .76000000000000001, \
.77000000000000002, .78000000000000003, .79000000000000004, \
.80000000000000004, .81000000000000005, .82000000000000006, \
.83000000000000007, .83999999999999997, .84999999999999998, \
.85999999999999999, .87, .88, .89000000000000001, .90000000000000002, \
.91000000000000003, .92000000000000004, .93000000000000005, \
.94000000000000006, .95000000000000007, .95999999999999996, \
.96999999999999997, .97999999999999998, .98999999999999999, 1.0}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0.`"},
              {"0.5`"},
              {"1.`"},
              {"1.5`"},
              {"2.`"},
              {"2.5`"},
              {"3.`"},
              {"3.5000000000000004`"},
              {"4.`"},
              {"4.5`"},
              {"5.`"},
              {"5.5`"},
              {"6.`"},
              {"6.5`"},
              {"7.000000000000001`"},
              {"7.5`"},
              {"8.`"},
              {"8.5`"},
              {"9.`"},
              {"9.5`"},
              {"10.`"},
              {"10.5`"},
              {"11.`"},
              {"11.5`"},
              {"12.`"},
              {"12.5`"},
              {"13.`"},
              {"13.5`"},
              {"14.000000000000002`"},
              {"14.499999999999998`"},
              {"15.`"},
              {"15.5`"},
              {"16.`"},
              {"16.5`"},
              {"17.`"},
              {"17.5`"},
              {"18.`"},
              {"18.5`"},
              {"19.`"},
              {"19.5`"},
              {"20.`"},
              {"20.5`"},
              {"21.`"},
              {"21.5`"},
              {"22.`"},
              {"22.5`"},
              {"23.`"},
              {"23.5`"},
              {"24.`"},
              {"24.5`"},
              {"25.`"},
              {"25.5`"},
              {"26.`"},
              {"26.5`"},
              {"27.`"},
              {"27.500000000000004`"},
              {"28.000000000000004`"},
              {"28.500000000000004`"},
              {"28.999999999999996`"},
              {"29.5`"},
              {"30.`"},
              {"30.5`"},
              {"31.`"},
              {"31.5`"},
              {"32.`"},
              {"32.5`"},
              {"33.`"},
              {"33.5`"},
              {"34.`"},
              {"34.5`"},
              {"35.`"},
              {"35.5`"},
              {"36.`"},
              {"36.5`"},
              {"37.`"},
              {"37.5`"},
              {"38.`"},
              {"38.5`"},
              {"39.`"},
              {"39.5`"},
              {"40.`"},
              {"40.5`"},
              {"41.`"},
              {"41.5`"},
              {"42.`"},
              {"42.5`"},
              {"43.`"},
              {"43.5`"},
              {"44.`"},
              {"44.5`"},
              {"45.`"},
              {"45.5`"},
              {"46.`"},
              {"46.5`"},
              {"47.`"},
              {"47.5`"},
              {"48.`"},
              {"48.5`"},
              {"49.`"},
              {"49.5`"},
              {"50.`"}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {0.0, .5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5000000000000004, 
            4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0000000000000009, 7.5, 8.0, 8.5, 
            9.0, 9.5, .1*^2, 10.5, 11.0, 11.5, 12.0, 12.5, 13.0, 13.5, 
            14.000000000000002, 14.499999999999998, 15.0, 15.5, 16.0, 16.5, 
            17.0, 17.5, 18.0, 18.5, 19.0, 19.5, .2*^2, 20.5, 21.0, 21.5, 22.0,
             22.5, 23.0, 23.5, 24.0, 24.5, 25.0, 25.5, 26.0, 26.5, 27.0, 
            27.500000000000004, 28.000000000000004, 28.500000000000004, 
            28.999999999999996, 29.5, .3*^2, 30.5, 31.0, 31.5, 32.0, 32.5, 
            33.0, 33.5, 34.0, 34.5, 35.0, 35.5, 36.0, 36.5, 37.0, 37.5, 38.0, 
            38.5, 39.0, 39.5, .4*^2, 40.5, 41.0, 41.5, 42.0, 42.5, 43.0, 43.5,
             44.0, 44.5, 45.0, 45.5, 46.0, 46.5, 47.0, 47.5, 48.0, 48.5, 49.0,
             49.5, .5*^2}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {\({0, 0}\)},
              {\({0.01`, 8.326533331112927`*^-6}\)},
              {\({0.02`, 0.00009037977973227232`}\)},
              {\({0.03`, 0.00029589238659463545`}\)},
              {\({0.04`, 0.0006742307340312988`}\)},
              {\({0.05`, 0.001274270779137127`}\)},
              {\({0.060000000000000005`, 0.0021442760634416184`}\)},
              {\({0.07`, 0.0033317776232154967`}\)},
              {\({0.08`, 0.004883455939378986`}\)},
              {\({0.09`, 0.006845025173612618`}\)},
              {\({0.09999999999999999`, 0.009261119964263122`}\)},
              {\({0.10999999999999999`, 0.01217518505837091`}\)},
              {\({0.11999999999999998`, 0.01562936805143619`}\)},
              {\({0.12999999999999998`, 0.0196644154992226`}\)},
              {\({0.13999999999999999`, 0.024319572657371846`}\)},
              {\({0.15`, 0.0296324870952888`}\)},
              {\({0.16`, 0.03563911642079156`}\)},
              {\({0.17`, 0.04237364034146279`}\)},
              {\({0.18000000000000002`, 0.0498683772775249`}\)},
              {\({0.19000000000000003`, 0.058153705729421454`}\)},
              {\({0.20000000000000004`, 0.06725799059115377`}\)},
              {\({0.21000000000000005`, 0.0772075145878232`}\)},
              {\({0.22000000000000006`, 0.08802641500280046`}\)},
              {\({0.23000000000000007`, 0.09973662584651607`}\)},
              {\({0.24000000000000007`, 0.11235782560507394`}\)},
              {\({0.25000000000000006`, 0.1259073906927687`}\)},
              {\({0.26000000000000006`, 0.14040035471817322`}\)},
              {\({0.2700000000000001`, 0.15584937365878931`}\)},
              {\({0.2800000000000001`, 0.17226469702436503`}\)},
              {\({0.2900000000000001`, 0.1896541450739036`}\)},
              {\({0.3000000000000001`, 0.20802309213617193`}\)},
              {\({0.3100000000000001`, 0.22737445606818993`}\)},
              {\({0.3200000000000001`, 0.24770869387078623`}\)},
              {\({0.3300000000000001`, 0.26902380346488397`}\)},
              {\({0.34000000000000014`, 0.29131533161676415`}\)},
              {\({0.35000000000000014`, 0.31457638798518744`}\)},
              {\({0.36000000000000015`, 0.33879766524797583`}\)},
              {\({0.37000000000000016`, 0.3639674652504969`}\)},
              {\({0.38000000000000017`, 0.3900717311034993`}\)},
              {\({0.3900000000000002`, 0.41709408514295276`}\)},
              {\({0.4000000000000002`, 0.44501587264998643`}\)},
              {\({0.4100000000000002`, 0.47381621121473316`}\)},
              {\({0.4200000000000002`, 0.5034720456139049`}\)},
              {\({0.4300000000000002`, 0.5339582080582889`}\)},
              {\({0.4400000000000002`, 0.5652474836530936`}\)},
              {\({0.45000000000000023`, 0.5973106809012191`}\)},
              {\({0.46000000000000024`, 0.6303080579705225`}\)},
              {\({0.47000000000000025`, 0.665583556149534`}\)},
              {\({0.48000000000000026`, 0.7032198100197546`}\)},
              {\({0.49000000000000027`, 0.743276143747328`}\)},
              {\({0.5000000000000002`, 0.7858052213797232`}\)},
              {\({0.5100000000000002`, 0.8308578040733603`}\)},
              {\({0.5200000000000002`, 0.8784841093015016`}\)},
              {\({0.5300000000000002`, 0.9287341991993651`}\)},
              {\({0.5400000000000003`, 0.9816580915198704`}\)},
              {\({0.5500000000000003`, 1.03730579133528`}\)},
              {\({0.5600000000000003`, 1.0957273000948113`}\)},
              {\({0.5700000000000003`, 1.1569726182125268`}\)},
              {\({0.5800000000000003`, 1.22109174580673`}\)},
              {\({0.5900000000000003`, 1.2881346829112221`}\)},
              {\({0.6000000000000003`, 1.35815142953566`}\)},
              {\({0.6100000000000003`, 1.431191985682803`}\)},
              {\({0.6200000000000003`, 1.50730635135344`}\)},
              {\({0.6300000000000003`, 1.586544526547796`}\)},
              {\({0.6400000000000003`, 1.668956511265936`}\)},
              {\({0.6500000000000004`, 1.7545923055078774`}\)},
              {\({0.6600000000000004`, 1.8435019092736262`}\)},
              {\({0.6700000000000004`, 1.935735322563183`}\)},
              {\({0.6800000000000004`, 2.031342545376549`}\)},
              {\({0.6900000000000004`, 2.1303735777137236`}\)},
              {\({0.7000000000000004`, 2.2328784195747065`}\)},
              {\({0.7100000000000004`, 2.3389070709594986`}\)},
              {\({0.7200000000000004`, 2.4485095318681007`}\)},
              {\({0.7300000000000004`, 2.561735802300512`}\)},
              {\({0.7400000000000004`, 2.6786358822567307`}\)},
              {\({0.7500000000000004`, 2.799259771736759`}\)},
              {\({0.7600000000000005`, 2.923657470740597`}\)},
              {\({0.7700000000000005`, 3.051878979268244`}\)},
              {\({0.7800000000000005`, 3.1839742973197014`}\)},
              {\({0.7900000000000005`, 3.3199934248949683`}\)},
              {\({0.8000000000000005`, 3.459986361994044`}\)},
              {\({0.8100000000000005`, 3.6040031086169284`}\)},
              {\({0.8200000000000005`, 3.752093664763622`}\)},
              {\({0.8300000000000005`, 3.904308030434125`}\)},
              {\({0.8400000000000005`, 4.060696205628438`}\)},
              {\({0.8500000000000005`, 4.22130819034656`}\)},
              {\({0.8600000000000005`, 4.386193984588493`}\)},
              {\({0.8700000000000006`, 4.555403588354234`}\)},
              {\({0.8800000000000006`, 4.728987001643783`}\)},
              {\({0.8900000000000006`, 4.906994224457141`}\)},
              {\({0.9000000000000006`, 5.089475256794308`}\)},
              {\({0.9100000000000006`, 5.276480098655286`}\)},
              {\({0.9200000000000006`, 5.4680587500400755`}\)},
              {\({0.9300000000000006`, 5.664261210948674`}\)},
              {\({0.9400000000000006`, 5.865137481381083`}\)},
              {\({0.9500000000000006`, 6.070737561337303`}\)},
              {\({0.9600000000000006`, 6.281111450817332`}\)},
              {\({0.9700000000000006`, 6.496309149821173`}\)},
              {\({0.9800000000000006`, 6.716380658348827`}\)},
              {\({0.9900000000000007`, 6.941375976400289`}\)},
              {\({1.0000000000000007`, 7.171345103975563`}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 
            
            0}, {.01, .8326533331112927*^-5}, {.02, .000090379779732272317}, \
{.029999999999999999, .00029589238659463545}, {.040000000000000001, \
.0006742307340312988}, {.050000000000000003, .0012742707791371271}, \
{.060000000000000005, .0021442760634416184}, {.070000000000000007, \
.0033317776232154967}, {.080000000000000002, .0048834559393789861}, \
{.089999999999999997, .0068450251736126176}, {.099999999999999992, \
.0092611199642631224}, {.10999999999999999, .01217518505837091}, \
{.11999999999999998, .01562936805143619}, {.12999999999999998, \
.019664415499222598}, {.13999999999999999, .024319572657371846}, \
{.14999999999999999, .0296324870952888}, {.16, .03563911642079156}, \
{.17000000000000001, .042373640341462793}, {.18000000000000002, \
.049868377277524897}, {.19000000000000003, .058153705729421454}, \
{.20000000000000004, .067257990591153768}, {.21000000000000005, \
.077207514587823198}, {.22000000000000006, .088026415002800465}, \
{.23000000000000007, .099736625846516075}, {.24000000000000007, \
.11235782560507394}, {.25000000000000006, .12590739069276871}, \
{.26000000000000006, .14040035471817322}, {.27000000000000007, \
.15584937365878931}, {.28000000000000008, .17226469702436503}, \
{.29000000000000009, .1896541450739036}, {.3000000000000001, \
.20802309213617193}, {.31000000000000011, .22737445606818993}, \
{.32000000000000012, .24770869387078623}, {.33000000000000013, \
.26902380346488397}, {.34000000000000014, .29131533161676415}, \
{.35000000000000014, .31457638798518744}, {.36000000000000015, \
.33879766524797583}, {.37000000000000016, .36396746525049689}, \
{.38000000000000017, .3900717311034993}, {.39000000000000018, \
.41709408514295276}, {.40000000000000019, .44501587264998643}, \
{.4100000000000002, .47381621121473316}, {.42000000000000021, \
.50347204561390491}, {.43000000000000022, .53395820805828886}, \
{.44000000000000022, .56524748365309363}, {.45000000000000023, \
.59731068090121908}, {.46000000000000024, .63030805797052247}, \
{.47000000000000025, .66558355614953402}, {.48000000000000026, \
.70321981001975464}, {.49000000000000027, .74327614374732798}, \
{.50000000000000022, .7858052213797232}, {.51000000000000023, \
.8308578040733603}, {.52000000000000024, .87848410930150156}, \
{.53000000000000025, .92873419919936506}, {.54000000000000026, \
.98165809151987038}, {.55000000000000027, 
            1.0373057913352799}, {.56000000000000028, 
            1.0957273000948113}, {.57000000000000028, 
            1.1569726182125268}, {.58000000000000029, 
            1.2210917458067301}, {.5900000000000003, 
            1.2881346829112221}, {.60000000000000031, 
            1.35815142953566}, {.61000000000000032, 
            1.431191985682803}, {.62000000000000033, 
            1.5073063513534399}, {.63000000000000034, 
            1.586544526547796}, {.64000000000000035, 
            1.6689565112659359}, {.65000000000000036, 
            1.7545923055078774}, {.66000000000000036, 
            1.8435019092736262}, {.67000000000000037, 
            1.935735322563183}, {.68000000000000038, 
            2.0313425453765488}, {.69000000000000039, 
            2.1303735777137236}, {.7000000000000004, 
            2.2328784195747065}, {.71000000000000041, 
            2.3389070709594986}, {.72000000000000042, 
            2.4485095318681007}, {.73000000000000043, 
            2.5617358023005119}, {.74000000000000044, 
            2.6786358822567307}, {.75000000000000044, 
            2.7992597717367591}, {.76000000000000045, 
            2.9236574707405971}, {.77000000000000046, 
            3.0518789792682441}, {.78000000000000047, 
            3.1839742973197014}, {.79000000000000048, 
            3.3199934248949683}, {.80000000000000049, 
            3.4599863619940439}, {.8100000000000005, 
            3.6040031086169284}, {.82000000000000051, 
            3.7520936647636218}, {.83000000000000052, 
            3.9043080304341249}, {.84000000000000052, 
            4.0606962056284379}, {.85000000000000053, 
            4.2213081903465604}, {.86000000000000054, 
            4.386193984588493}, {.87000000000000055, 
            4.5554035883542339}, {.88000000000000056, 
            4.7289870016437829}, {.89000000000000057, 
            4.906994224457141}, {.90000000000000058, 
            5.0894752567943078}, {.91000000000000059, 
            5.276480098655286}, {.9200000000000006, 
            5.4680587500400755}, {.9300000000000006, 
            5.6642612109486743}, {.94000000000000061, 
            5.8651374813810833}, {.95000000000000062, 
            6.0707375613373031}, {.96000000000000063, 
            6.281111450817332}, {.97000000000000064, 
            6.4963091498211734}, {.98000000000000065, 
            6.716380658348827}, {.99000000000000066, 6.9413759764002894}, {
            1.0000000000000007, 7.1713451039755629}}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {\({0, 0}\)},
              {\({0.01`, 0.002497959999333878`}\)},
              {\({0.02`, 0.009985065352820816`}\)},
              {\({0.03`, 0.022439804987048364`}\)},
              {\({0.04`, 0.03982603060518641`}\)},
              {\({0.05`, 0.06209466001741613`}\)},
              {\({0.060000000000000005`, 0.0891842726847314`}\)},
              {\({0.07`, 0.12102140913198266`}\)},
              {\({0.08`, 0.1575208065764016`}\)},
              {\({0.09`, 0.19858563698320703`}\)},
              {\({0.09999999999999999`, 0.24410776607942433`}\)},
              {\({0.10999999999999999`, 0.2939680381373919`}\)},
              {\({0.11999999999999998`, 0.3480365873573073`}\)},
              {\({0.12999999999999998`, 0.40617317548912707`}\)},
              {\({0.13999999999999999`, 0.46822755494739565`}\)},
              {\({0.15`, 0.5340398565175266`}\)},
              {\({0.16`, 0.60344100066518`}\)},
              {\({0.17`, 0.6762531313949401`}\)},
              {\({0.18000000000000002`, 0.7522900715471729`}\)},
              {\({0.19000000000000003`, 0.8313577983690111`}\)},
              {\({0.20000000000000004`, 0.9132549381459077`}\)},
              {\({0.21000000000000005`, 0.997773278633899`}\)},
              {\({0.22000000000000006`, 1.0846982979896787`}\)},
              {\({0.23000000000000007`, 1.1738097088558757`}\)},
              {\({0.24000000000000007`, 1.2648820162225753`}\)},
              {\({0.25000000000000006`, 1.3576850876533266`}\)},
              {\({0.26000000000000006`, 1.4519847344346122`}\)},
              {\({0.2700000000000001`, 1.5475433021821634`}\)},
              {\({0.2800000000000001`, 1.6441202694155674`}\)},
              {\({0.2900000000000001`, 1.7414728525944176`}\)},
              {\({0.3000000000000001`, 1.8393566160949784`}\)},
              {\({0.3100000000000001`, 1.9375260855956855`}\)},
              {\({0.3200000000000001`, 2.0357353633331283`}\)},
              {\({0.3300000000000001`, 2.1337387436873305`}\)},
              {\({0.34000000000000014`, 2.2312913275560753`}\)},
              {\({0.35000000000000014`, 2.3281496339829983`}\)},
              {\({0.36000000000000015`, 2.424072207512788`}\)},
              {\({0.37000000000000016`, 2.5188202197592786`}\)},
              {\({0.38000000000000017`, 2.612158063688586`}\)},
              {\({0.3900000000000002`, 2.703853939139393`}\)},
              {\({0.4000000000000002`, 2.7936804281262364`}\)},
              {\({0.4100000000000002`, 2.8814150584987988`}\)},
              {\({0.4200000000000002`, 2.9668408545610645`}\)},
              {\({0.4300000000000002`, 3.049746873288591`}\)},
              {\({0.4400000000000002`, 3.1299287248196923`}\)},
              {\({0.45000000000000023`, 3.2071890759371304`}\)},
              {\({0.46000000000000024`, 3.338743406324884`}\)},
              {\({0.47000000000000025`, 3.5438303578642287`}\)},
              {\({0.48000000000000026`, 3.773498058304054`}\)},
              {\({0.49000000000000027`, 4.013760258429733`}\)},
              {\({0.5000000000000002`, 4.260620887037076`}\)},
              {\({0.5100000000000002`, 4.512938209496325`}\)},
              {\({0.5200000000000002`, 4.77038601591325`}\)},
              {\({0.5300000000000002`, 5.032871103460936`}\)},
              {\({0.5400000000000003`, 5.300366842760267`}\)},
              {\({0.5500000000000003`, 5.572865625417203`}\)},
              {\({0.5600000000000003`, 5.850365277604868`}\)},
              {\({0.5700000000000003`, 6.132865178229879`}\)},
              {\({0.5800000000000003`, 6.420365149836992`}\)},
              {\({0.5900000000000003`, 6.712865141724703`}\)},
              {\({0.6000000000000003`, 7.0103651394068685`}\)},
              {\({0.6100000000000003`, 7.312865138744602`}\)},
              {\({0.6200000000000003`, 7.62036513855535`}\)},
              {\({0.6300000000000003`, 7.9328651385012625`}\)},
              {\({0.6400000000000003`, 8.250365138485801`}\)},
              {\({0.6500000000000004`, 8.572865138481353`}\)},
              {\({0.6600000000000004`, 8.900365138480035`}\)},
              {\({0.6700000000000004`, 9.232865138479598`}\)},
              {\({0.6800000000000004`, 9.57036513847944`}\)},
              {\({0.6900000000000004`, 9.912865138479349`}\)},
              {\({0.7000000000000004`, 10.260365138479239`}\)},
              {\({0.7100000000000004`, 10.612865138479231`}\)},
              {\({0.7200000000000004`, 10.970365138479256`}\)},
              {\({0.7300000000000004`, 11.332865138479146`}\)},
              {\({0.7400000000000004`, 11.700365138479057`}\)},
              {\({0.7500000000000004`, 12.072865138479035`}\)},
              {\({0.7600000000000005`, 12.450365138478995`}\)},
              {\({0.7700000000000005`, 12.83286513847901`}\)},
              {\({0.7800000000000005`, 13.220365138479043`}\)},
              {\({0.7900000000000005`, 13.612865138479025`}\)},
              {\({0.8000000000000005`, 14.010365138478987`}\)},
              {\({0.8100000000000005`, 14.41286513847891`}\)},
              {\({0.8200000000000005`, 14.820365138478861`}\)},
              {\({0.8300000000000005`, 15.232865138478884`}\)},
              {\({0.8400000000000005`, 15.650365138478923`}\)},
              {\({0.8500000000000005`, 16.072865138478956`}\)},
              {\({0.8600000000000005`, 16.5003651384789`}\)},
              {\({0.8700000000000006`, 16.932865138478803`}\)},
              {\({0.8800000000000006`, 17.37036513847872`}\)},
              {\({0.8900000000000006`, 17.812865138478635`}\)},
              {\({0.9000000000000006`, 18.260365138478647`}\)},
              {\({0.9100000000000006`, 18.712865138478787`}\)},
              {\({0.9200000000000006`, 19.17036513847887`}\)},
              {\({0.9300000000000006`, 19.63286513847891`}\)},
              {\({0.9400000000000006`, 20.100365138479052`}\)},
              {\({0.9500000000000006`, 20.572865138479134`}\)},
              {\({0.9600000000000006`, 21.050365138479187`}\)},
              {\({0.9700000000000006`, 21.532865138479412`}\)},
              {\({0.9800000000000006`, 22.020365138479555`}\)},
              {\({0.9900000000000007`, 22.512865138479576`}\)},
              {\({1.0000000000000007`, 23.01036513847973`}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 
            0}, {.01, .0024979599993338779}, {.02, .0099850653528208155}, \
{.029999999999999999, .022439804987048364}, {.040000000000000001, \
.039826030605186413}, {.050000000000000003, .062094660017416127}, \
{.060000000000000005, .089184272684731405}, {.070000000000000007, \
.12102140913198266}, {.080000000000000002, .15752080657640161}, \
{.089999999999999997, .19858563698320703}, {.099999999999999992, \
.24410776607942433}, {.10999999999999999, .29396803813739192}, \
{.11999999999999998, .3480365873573073}, {.12999999999999998, \
.40617317548912707}, {.13999999999999999, .46822755494739565}, \
{.14999999999999999, .53403985651752661}, {.16, .60344100066518003}, \
{.17000000000000001, .67625313139494014}, {.18000000000000002, \
.75229007154717287}, {.19000000000000003, .83135779836901114}, \
{.20000000000000004, .91325493814590775}, {.21000000000000005, \
.99777327863389897}, {.22000000000000006, 
            1.0846982979896787}, {.23000000000000007, 
            1.1738097088558757}, {.24000000000000007, 
            1.2648820162225753}, {.25000000000000006, 
            1.3576850876533266}, {.26000000000000006, 
            1.4519847344346122}, {.27000000000000007, 
            1.5475433021821634}, {.28000000000000008, 
            1.6441202694155674}, {.29000000000000009, 
            1.7414728525944176}, {.3000000000000001, 
            1.8393566160949784}, {.31000000000000011, 
            1.9375260855956855}, {.32000000000000012, 
            2.0357353633331283}, {.33000000000000013, 
            2.1337387436873305}, {.34000000000000014, 
            2.2312913275560753}, {.35000000000000014, 
            2.3281496339829983}, {.36000000000000015, 
            2.4240722075127881}, {.37000000000000016, 
            2.5188202197592786}, {.38000000000000017, 
            2.6121580636885859}, {.39000000000000018, 
            2.703853939139393}, {.40000000000000019, 
            2.7936804281262364}, {.4100000000000002, 
            2.8814150584987988}, {.42000000000000021, 
            2.9668408545610645}, {.43000000000000022, 
            3.0497468732885911}, {.44000000000000022, 
            3.1299287248196923}, {.45000000000000023, 
            3.2071890759371304}, {.46000000000000024, 
            3.338743406324884}, {.47000000000000025, 
            3.5438303578642287}, {.48000000000000026, 
            3.773498058304054}, {.49000000000000027, 
            4.0137602584297332}, {.50000000000000022, 
            4.2606208870370761}, {.51000000000000023, 
            4.5129382094963253}, {.52000000000000024, 
            4.7703860159132496}, {.53000000000000025, 
            5.0328711034609359}, {.54000000000000026, 
            5.3003668427602673}, {.55000000000000027, 
            5.5728656254172027}, {.56000000000000028, 
            5.850365277604868}, {.57000000000000028, 
            6.1328651782298786}, {.58000000000000029, 
            6.420365149836992}, {.5900000000000003, 
            6.7128651417247029}, {.60000000000000031, 
            7.0103651394068685}, {.61000000000000032, 
            7.312865138744602}, {.62000000000000033, 
            7.6203651385553499}, {.63000000000000034, 
            7.9328651385012625}, {.64000000000000035, 
            8.250365138485801}, {.65000000000000036, 
            8.5728651384813528}, {.66000000000000036, 
            8.9003651384800353}, {.67000000000000037, 
            9.2328651384795979}, {.68000000000000038, 
            9.5703651384794401}, {.69000000000000039, 
            9.9128651384793489}, {.7000000000000004, 
            10.260365138479239}, {.71000000000000041, 
            10.612865138479231}, {.72000000000000042, 
            10.970365138479256}, {.73000000000000043, 
            11.332865138479146}, {.74000000000000044, 
            11.700365138479057}, {.75000000000000044, 
            12.072865138479035}, {.76000000000000045, 
            12.450365138478995}, {.77000000000000046, 
            12.83286513847901}, {.78000000000000047, 
            13.220365138479043}, {.79000000000000048, 
            13.612865138479025}, {.80000000000000049, 
            14.010365138478987}, {.8100000000000005, 
            14.41286513847891}, {.82000000000000051, 
            14.820365138478861}, {.83000000000000052, 
            15.232865138478884}, {.84000000000000052, 
            15.650365138478923}, {.85000000000000053, 
            16.072865138478956}, {.86000000000000054, 
            16.500365138478902}, {.87000000000000055, 
            16.932865138478803}, {.88000000000000056, 
            17.370365138478721}, {.89000000000000057, 
            17.812865138478635}, {.90000000000000058, 
            18.260365138478647}, {.91000000000000059, 
            18.712865138478787}, {.9200000000000006, 
            19.170365138478871}, {.9300000000000006, 
            19.632865138478909}, {.94000000000000061, 
            20.100365138479052}, {.95000000000000062, 
            20.572865138479134}, {.96000000000000063, 
            21.050365138479187}, {.97000000000000064, 
            21.532865138479412}, {.98000000000000065, 
            22.020365138479555}, {.99000000000000066, 22.512865138479576}, {
            1.0000000000000007, 23.010365138479731}}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {\({0, 0.`}\)},
              {\({0.01`, 0.49959199986677555`}\)},
              {\({0.02`, 0.997829070830612`}\)},
              {\({0.03`, 1.4931188560148965`}\)},
              {\({0.04`, 1.9841262676127138`}\)},
              {\({0.05`, 2.469599614833229`}\)},
              {\({0.060000000000000005`, 2.948322918629828`}\)},
              {\({0.07`, 3.4191043708204236`}\)},
              {\({0.08`, 3.8807751180633634`}\)},
              {\({0.09`, 4.33219096329772`}\)},
              {\({0.09999999999999999`, 4.772234855945741`}\)},
              {\({0.10999999999999999`, 5.199819555647774`}\)},
              {\({0.11999999999999998`, 5.6138902883353055`}\)},
              {\({0.12999999999999998`, 6.013427338028655`}\)},
              {\({0.13999999999999999`, 6.397448553625043`}\)},
              {\({0.15`, 6.765011760401137`}\)},
              {\({0.16`, 7.115217069129541`}\)},
              {\({0.17`, 7.44720907682246`}\)},
              {\({0.18000000000000002`, 7.7601789536241075`}\)},
              {\({0.19000000000000003`, 8.05336641074355`}\)},
              {\({0.20000000000000004`, 8.32606154463578`}\)},
              {\({0.21000000000000005`, 8.577606552962484`}\)},
              {\({0.22000000000000006`, 8.807397318193452`}\)},
              {\({0.23000000000000007`, 9.014884855045993`}\)},
              {\({0.24000000000000007`, 9.199576618293966`}\)},
              {\({0.25000000000000006`, 9.361037667856273`}\)},
              {\({0.26000000000000006`, 9.49889168840089`}\)},
              {\({0.2700000000000001`, 9.612821861109326`}\)},
              {\({0.2800000000000001`, 9.702571585571416`}\)},
              {\({0.2900000000000001`, 9.767945050198604`}\)},
              {\({0.3000000000000001`, 9.808807649913549`}\)},
              {\({0.3100000000000001`, 9.825086250227935`}\)},
              {\({0.3200000000000001`, 9.816769297260674`}\)},
              {\({0.3300000000000001`, 9.783906773579723`}\)},
              {\({0.34000000000000014`, 9.726610000169323`}\)},
              {\({0.35000000000000014`, 9.645051285215386`}\)},
              {\({0.36000000000000015`, 9.539463420742504`}\)},
              {\({0.37000000000000016`, 9.41013902855571`}\)},
              {\({0.38000000000000017`, 9.257429757305783`}\)},
              {\({0.3900000000000002`, 9.081745332855677`}\)},
              {\({0.4000000000000002`, 8.88355246451301`}\)},
              {\({0.4100000000000002`, 8.663373609999496`}\)},
              {\({0.4200000000000002`, 8.421785602453806`}\)},
              {\({0.4300000000000002`, 8.159418143051495`}\)},
              {\({0.4400000000000002`, 7.876952163168655`}\)},
              {\({0.45000000000000023`, 7.575118060319058`}\)},
              {\({0.46000000000000024`, 18.735748017231636`}\)},
              {\({0.47000000000000025`, 22.281642290637226`}\)},
              {\({0.48000000000000026`, 23.651897797327848`}\)},
              {\({0.49000000000000027`, 24.400542227807854`}\)},
              {\({0.5000000000000002`, 24.971583493660866`}\)},
              {\({0.5100000000000002`, 25.49188099818882`}\)},
              {\({0.5200000000000002`, 25.997680285196033`}\)},
              {\({0.5300000000000002`, 26.499337224341254`}\)},
              {\({0.5400000000000003`, 26.999810635525193`}\)},
              {\({0.5500000000000003`, 27.499945895861956`}\)},
              {\({0.5600000000000003`, 27.999984541671132`}\)},
              {\({0.5700000000000003`, 28.499995583331213`}\)},
              {\({0.5800000000000003`, 28.999998738091207`}\)},
              {\({0.5900000000000003`, 29.499999639451083`}\)},
              {\({0.6000000000000003`, 29.99999989698184`}\)},
              {\({0.6100000000000003`, 30.499999970565092`}\)},
              {\({0.6200000000000003`, 30.99999999158421`}\)},
              {\({0.6300000000000003`, 31.499999997598294`}\)},
              {\({0.6400000000000003`, 31.999999999309644`}\)},
              {\({0.6500000000000004`, 32.49999999980023`}\)},
              {\({0.6600000000000004`, 32.999999999936556`}\)},
              {\({0.6700000000000004`, 33.499999999975714`}\)},
              {\({0.6800000000000004`, 33.99999999999313`}\)},
              {\({0.6900000000000004`, 34.49999999998856`}\)},
              {\({0.7000000000000004`, 34.99999999998956`}\)},
              {\({0.7100000000000004`, 35.5000000000092`}\)},
              {\({0.7200000000000004`, 35.99999999999618`}\)},
              {\({0.7300000000000004`, 36.49999999998183`}\)},
              {\({0.7400000000000004`, 37.000000000000824`}\)},
              {\({0.7500000000000004`, 37.499999999994905`}\)},
              {\({0.7600000000000005`, 37.99999999999699`}\)},
              {\({0.7700000000000005`, 38.50000000000585`}\)},
              {\({0.7800000000000005`, 39.00000000000014`}\)},
              {\({0.7900000000000005`, 39.499999999996525`}\)},
              {\({0.8000000000000005`, 39.99999999999553`}\)},
              {\({0.8100000000000005`, 40.49999999998926`}\)},
              {\({0.8200000000000005`, 41.000000000000846`}\)},
              {\({0.8300000000000005`, 41.500000000003844`}\)},
              {\({0.8400000000000005`, 42.00000000000483`}\)},
              {\({0.8500000000000005`, 42.500000000001755`}\)},
              {\({0.8600000000000005`, 42.999999999987864`}\)},
              {\({0.8700000000000006`, 43.499999999993605`}\)},
              {\({0.8800000000000006`, 43.99999999999055`}\)},
              {\({0.8900000000000006`, 44.49999999999209`}\)},
              {\({0.9000000000000006`, 45.00000000001021`}\)},
              {\({0.9100000000000006`, 45.500000000017565`}\)},
              {\({0.9200000000000006`, 45.999999999999936`}\)},
              {\({0.9300000000000006`, 46.50000000000813`}\)},
              {\({0.9400000000000006`, 47.000000000020464`}\)},
              {\({0.9500000000000006`, 47.499999999995325`}\)},
              {\({0.9600000000000006`, 48.00000000001392`}\)},
              {\({0.9700000000000006`, 48.50000000003074`}\)},
              {\({0.9800000000000006`, 48.99999999999593`}\)},
              {\({0.9900000000000007`, 49.50000000000829`}\)},
              {\({1.0000000000000007`, 50.000000000023135`}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 
            0.0}, {.01, .49959199986677555}, {.02, .99782907083061201}, \
{.029999999999999999, 1.4931188560148965}, {.040000000000000001, 
            1.9841262676127138}, {.050000000000000003, 
            2.4695996148332289}, {.060000000000000005, 
            2.9483229186298279}, {.070000000000000007, 
            3.4191043708204236}, {.080000000000000002, 
            3.8807751180633634}, {.089999999999999997, 
            4.3321909632977196}, {.099999999999999992, 
            4.772234855945741}, {.10999999999999999, 
            5.1998195556477738}, {.11999999999999998, 
            5.6138902883353055}, {.12999999999999998, 
            6.0134273380286549}, {.13999999999999999, 
            6.3974485536250434}, {.14999999999999999, 
            6.7650117604011371}, {.16, 
            7.1152170691295407}, {.17000000000000001, 
            7.4472090768224604}, {.18000000000000002, 
            7.7601789536241075}, {.19000000000000003, 
            8.0533664107435499}, {.20000000000000004, 
            8.3260615446357793}, {.21000000000000005, 
            8.5776065529624841}, {.22000000000000006, 
            8.807397318193452}, {.23000000000000007, 
            9.0148848550459935}, {.24000000000000007, 
            9.1995766182939658}, {.25000000000000006, 
            9.361037667856273}, {.26000000000000006, 
            9.4988916884008905}, {.27000000000000007, 
            9.6128218611093263}, {.28000000000000008, 
            9.7025715855714161}, {.29000000000000009, 
            9.7679450501986036}, {.3000000000000001, 
            9.8088076499135486}, {.31000000000000011, 
            9.825086250227935}, {.32000000000000012, 
            9.8167692972606737}, {.33000000000000013, 
            9.7839067735797229}, {.34000000000000014, 
            9.7266100001693232}, {.35000000000000014, 
            9.645051285215386}, {.36000000000000015, 
            9.5394634207425035}, {.37000000000000016, 
            9.4101390285557098}, {.38000000000000017, 
            9.2574297573057827}, {.39000000000000018, 
            9.081745332855677}, {.40000000000000019, 
            8.8835524645130093}, {.4100000000000002, 
            8.6633736099994962}, {.42000000000000021, 
            8.4217856024538058}, {.43000000000000022, 
            8.1594181430514947}, {.44000000000000022, 
            7.8769521631686548}, {.45000000000000023, 
            7.575118060319058}, {.46000000000000024, 
            18.735748017231636}, {.47000000000000025, 
            22.281642290637226}, {.48000000000000026, 
            23.651897797327848}, {.49000000000000027, 
            24.400542227807854}, {.50000000000000022, 
            24.971583493660866}, {.51000000000000023, 
            25.491880998188819}, {.52000000000000024, 
            25.997680285196033}, {.53000000000000025, 
            26.499337224341254}, {.54000000000000026, 
            26.999810635525193}, {.55000000000000027, 
            27.499945895861956}, {.56000000000000028, 
            27.999984541671132}, {.57000000000000028, 
            28.499995583331213}, {.58000000000000029, 
            28.999998738091207}, {.5900000000000003, 
            29.499999639451083}, {.60000000000000031, 
            29.999999896981841}, {.61000000000000032, 
            30.499999970565092}, {.62000000000000033, 
            30.999999991584211}, {.63000000000000034, 
            31.499999997598294}, {.64000000000000035, 
            31.999999999309644}, {.65000000000000036, 
            32.499999999800231}, {.66000000000000036, 
            32.999999999936556}, {.67000000000000037, 
            33.499999999975714}, {.68000000000000038, 
            33.999999999993129}, {.69000000000000039, 
            34.49999999998856}, {.7000000000000004, 
            34.999999999989562}, {.71000000000000041, 
            35.500000000009202}, {.72000000000000042, 
            35.999999999996177}, {.73000000000000043, 
            36.499999999981831}, {.74000000000000044, 
            37.000000000000824}, {.75000000000000044, 
            37.499999999994905}, {.76000000000000045, 
            37.999999999996987}, {.77000000000000046, 
            38.500000000005848}, {.78000000000000047, 
            39.000000000000142}, {.79000000000000048, 
            39.499999999996525}, {.80000000000000049, 
            39.999999999995531}, {.8100000000000005, 
            40.499999999989257}, {.82000000000000051, 
            41.000000000000846}, {.83000000000000052, 
            41.500000000003844}, {.84000000000000052, 
            42.000000000004832}, {.85000000000000053, 
            42.500000000001755}, {.86000000000000054, 
            42.999999999987864}, {.87000000000000055, 
            43.499999999993605}, {.88000000000000056, 
            43.99999999999055}, {.89000000000000057, 
            44.499999999992092}, {.90000000000000058, 
            45.00000000001021}, {.91000000000000059, 
            45.500000000017565}, {.9200000000000006, 
            45.999999999999936}, {.9300000000000006, 
            46.500000000008129}, {.94000000000000061, 
            47.000000000020464}, {.95000000000000062, 
            47.499999999995325}, {.96000000000000063, 
            48.00000000001392}, {.97000000000000064, 
            48.500000000030738}, {.98000000000000065, 
            48.999999999995929}, {.99000000000000066, 49.500000000008292}, {
            1.0000000000000007, 50.000000000023135}}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {\({0, 25}\)},
              {\({0.01`, 25}\)},
              {\({0.02`, 25}\)},
              {\({0.03`, 25}\)},
              {\({0.04`, 25}\)},
              {\({0.05`, 25}\)},
              {\({0.060000000000000005`, 25}\)},
              {\({0.07`, 25}\)},
              {\({0.08`, 25}\)},
              {\({0.09`, 25}\)},
              {\({0.09999999999999999`, 25}\)},
              {\({0.10999999999999999`, 25}\)},
              {\({0.11999999999999998`, 25}\)},
              {\({0.12999999999999998`, 25}\)},
              {\({0.13999999999999999`, 25}\)},
              {\({0.15`, 25}\)},
              {\({0.16`, 25}\)},
              {\({0.17`, 25}\)},
              {\({0.18000000000000002`, 25}\)},
              {\({0.19000000000000003`, 25}\)},
              {\({0.20000000000000004`, 25}\)},
              {\({0.21000000000000005`, 25}\)},
              {\({0.22000000000000006`, 25}\)},
              {\({0.23000000000000007`, 25}\)},
              {\({0.24000000000000007`, 25}\)},
              {\({0.25000000000000006`, 25}\)},
              {\({0.26000000000000006`, 25}\)},
              {\({0.2700000000000001`, 25}\)},
              {\({0.2800000000000001`, 25}\)},
              {\({0.2900000000000001`, 25}\)},
              {\({0.3000000000000001`, 25}\)},
              {\({0.3100000000000001`, 25}\)},
              {\({0.3200000000000001`, 25}\)},
              {\({0.3300000000000001`, 25}\)},
              {\({0.34000000000000014`, 25}\)},
              {\({0.35000000000000014`, 25}\)},
              {\({0.36000000000000015`, 25}\)},
              {\({0.37000000000000016`, 25}\)},
              {\({0.38000000000000017`, 25}\)},
              {\({0.3900000000000002`, 25}\)},
              {\({0.4000000000000002`, 25}\)},
              {\({0.4100000000000002`, 25}\)},
              {\({0.4200000000000002`, 25}\)},
              {\({0.4300000000000002`, 25}\)},
              {\({0.4400000000000002`, 25}\)},
              {\({0.45000000000000023`, 25}\)},
              {\({0.46000000000000024`, 0}\)},
              {\({0.47000000000000025`, 0}\)},
              {\({0.48000000000000026`, 0}\)},
              {\({0.49000000000000027`, 0}\)},
              {\({0.5000000000000002`, 0}\)},
              {\({0.5100000000000002`, 0}\)},
              {\({0.5200000000000002`, 0}\)},
              {\({0.5300000000000002`, 0}\)},
              {\({0.5400000000000003`, 0}\)},
              {\({0.5500000000000003`, 0}\)},
              {\({0.5600000000000003`, 0}\)},
              {\({0.5700000000000003`, 0}\)},
              {\({0.5800000000000003`, 0}\)},
              {\({0.5900000000000003`, 0}\)},
              {\({0.6000000000000003`, 0}\)},
              {\({0.6100000000000003`, 0}\)},
              {\({0.6200000000000003`, 0}\)},
              {\({0.6300000000000003`, 0}\)},
              {\({0.6400000000000003`, 0}\)},
              {\({0.6500000000000004`, 0}\)},
              {\({0.6600000000000004`, 0}\)},
              {\({0.6700000000000004`, 0}\)},
              {\({0.6800000000000004`, 0}\)},
              {\({0.6900000000000004`, 0}\)},
              {\({0.7000000000000004`, 0}\)},
              {\({0.7100000000000004`, 0}\)},
              {\({0.7200000000000004`, 0}\)},
              {\({0.7300000000000004`, 0}\)},
              {\({0.7400000000000004`, 0}\)},
              {\({0.7500000000000004`, 0}\)},
              {\({0.7600000000000005`, 0}\)},
              {\({0.7700000000000005`, 0}\)},
              {\({0.7800000000000005`, 0}\)},
              {\({0.7900000000000005`, 0}\)},
              {\({0.8000000000000005`, 0}\)},
              {\({0.8100000000000005`, 0}\)},
              {\({0.8200000000000005`, 0}\)},
              {\({0.8300000000000005`, 0}\)},
              {\({0.8400000000000005`, 0}\)},
              {\({0.8500000000000005`, 0}\)},
              {\({0.8600000000000005`, 0}\)},
              {\({0.8700000000000006`, 0}\)},
              {\({0.8800000000000006`, 0}\)},
              {\({0.8900000000000006`, 0}\)},
              {\({0.9000000000000006`, 0}\)},
              {\({0.9100000000000006`, 0}\)},
              {\({0.9200000000000006`, 0}\)},
              {\({0.9300000000000006`, 0}\)},
              {\({0.9400000000000006`, 0}\)},
              {\({0.9500000000000006`, 0}\)},
              {\({0.9600000000000006`, 0}\)},
              {\({0.9700000000000006`, 0}\)},
              {\({0.9800000000000006`, 0}\)},
              {\({0.9900000000000007`, 0}\)},
              {\({1.0000000000000007`, 0}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 25}, {.01, 25}, {.02, 25}, {.029999999999999999, 
            25}, {.040000000000000001, 25}, {.050000000000000003, 
            25}, {.060000000000000005, 25}, {.070000000000000007, 
            25}, {.080000000000000002, 25}, {.089999999999999997, 
            25}, {.099999999999999992, 25}, {.10999999999999999, 
            25}, {.11999999999999998, 25}, {.12999999999999998, 
            25}, {.13999999999999999, 25}, {.14999999999999999, 25}, {.16, 
            25}, {.17000000000000001, 25}, {.18000000000000002, 
            25}, {.19000000000000003, 25}, {.20000000000000004, 
            25}, {.21000000000000005, 25}, {.22000000000000006, 
            25}, {.23000000000000007, 25}, {.24000000000000007, 
            25}, {.25000000000000006, 25}, {.26000000000000006, 
            25}, {.27000000000000007, 25}, {.28000000000000008, 
            25}, {.29000000000000009, 25}, {.3000000000000001, 
            25}, {.31000000000000011, 25}, {.32000000000000012, 
            25}, {.33000000000000013, 25}, {.34000000000000014, 
            25}, {.35000000000000014, 25}, {.36000000000000015, 
            25}, {.37000000000000016, 25}, {.38000000000000017, 
            25}, {.39000000000000018, 25}, {.40000000000000019, 
            25}, {.4100000000000002, 25}, {.42000000000000021, 
            25}, {.43000000000000022, 25}, {.44000000000000022, 
            25}, {.45000000000000023, 25}, {.46000000000000024, 
            0}, {.47000000000000025, 0}, {.48000000000000026, 
            0}, {.49000000000000027, 0}, {.50000000000000022, 
            0}, {.51000000000000023, 0}, {.52000000000000024, 
            0}, {.53000000000000025, 0}, {.54000000000000026, 
            0}, {.55000000000000027, 0}, {.56000000000000028, 
            0}, {.57000000000000028, 0}, {.58000000000000029, 
            0}, {.5900000000000003, 0}, {.60000000000000031, 
            0}, {.61000000000000032, 0}, {.62000000000000033, 
            0}, {.63000000000000034, 0}, {.64000000000000035, 
            0}, {.65000000000000036, 0}, {.66000000000000036, 
            0}, {.67000000000000037, 0}, {.68000000000000038, 
            0}, {.69000000000000039, 0}, {.7000000000000004, 
            0}, {.71000000000000041, 0}, {.72000000000000042, 
            0}, {.73000000000000043, 0}, {.74000000000000044, 
            0}, {.75000000000000044, 0}, {.76000000000000045, 
            0}, {.77000000000000046, 0}, {.78000000000000047, 
            0}, {.79000000000000048, 0}, {.80000000000000049, 
            0}, {.8100000000000005, 0}, {.82000000000000051, 
            0}, {.83000000000000052, 0}, {.84000000000000052, 
            0}, {.85000000000000053, 0}, {.86000000000000054, 
            0}, {.87000000000000055, 0}, {.88000000000000056, 
            0}, {.89000000000000057, 0}, {.90000000000000058, 
            0}, {.91000000000000059, 0}, {.9200000000000006, 
            0}, {.9300000000000006, 0}, {.94000000000000061, 
            0}, {.95000000000000062, 0}, {.96000000000000063, 
            0}, {.97000000000000064, 0}, {.98000000000000065, 
            0}, {.99000000000000066, 0}, {1.0000000000000007, 0}}],
          Editable->False]}],
      SequenceForm[ 
        ColumnForm[ {
          0, .01, .02, .029999999999999999, .040000000000000001, \
.050000000000000003, .059999999999999998, .070000000000000007, \
.080000000000000002, .089999999999999997, .10000000000000001, .11, .12, .13, \
.14000000000000001, .14999999999999999, .16, .17000000000000001, \
.17999999999999999, .19, .20000000000000001, .20999999999999999, .22, \
.23000000000000001, .23999999999999999, .25, .26000000000000001, \
.27000000000000002, .28000000000000003, .28999999999999998, \
.29999999999999999, .31, .32000000000000001, .33000000000000002, \
.34000000000000002, .35000000000000003, .35999999999999999, .37, .38, \
.39000000000000001, .40000000000000002, .41000000000000003, \
.41999999999999998, .42999999999999999, .44, .45000000000000001, \
.46000000000000002, .47000000000000003, .47999999999999998, \
.48999999999999999, .5, .51000000000000001, .52000000000000002, \
.53000000000000003, .54000000000000004, .55000000000000004, \
.56000000000000005, .57000000000000006, .57999999999999996, \
.58999999999999997, .59999999999999998, .60999999999999999, .62, .63, \
.64000000000000001, .65000000000000002, .66000000000000003, \
.67000000000000004, .68000000000000005, .69000000000000006, \
.70000000000000007, .70999999999999996, .71999999999999997, \
.72999999999999998, .73999999999999999, .75, .76000000000000001, \
.77000000000000002, .78000000000000003, .79000000000000004, \
.80000000000000004, .81000000000000005, .82000000000000006, \
.83000000000000007, .83999999999999997, .84999999999999998, \
.85999999999999999, .87, .88, .89000000000000001, .90000000000000002, \
.91000000000000003, .92000000000000004, .93000000000000005, \
.94000000000000006, .95000000000000007, .95999999999999996, \
.96999999999999997, .97999999999999998, .98999999999999999, 1.0}], "  ", 
        ColumnForm[ {0.0, .5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5000000000000004, 
          4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0000000000000009, 7.5, 8.0, 8.5, 
          9.0, 9.5, .1*^2, 10.5, 11.0, 11.5, 12.0, 12.5, 13.0, 13.5, 
          14.000000000000002, 14.499999999999998, 15.0, 15.5, 16.0, 16.5, 
          17.0, 17.5, 18.0, 18.5, 19.0, 19.5, .2*^2, 20.5, 21.0, 21.5, 22.0, 
          22.5, 23.0, 23.5, 24.0, 24.5, 25.0, 25.5, 26.0, 26.5, 27.0, 
          27.500000000000004, 28.000000000000004, 28.500000000000004, 
          28.999999999999996, 29.5, .3*^2, 30.5, 31.0, 31.5, 32.0, 32.5, 33.0,
           33.5, 34.0, 34.5, 35.0, 35.5, 36.0, 36.5, 37.0, 37.5, 38.0, 38.5, 
          39.0, 39.5, .4*^2, 40.5, 41.0, 41.5, 42.0, 42.5, 43.0, 43.5, 44.0, 
          44.5, 45.0, 45.5, 46.0, 46.5, 47.0, 47.5, 48.0, 48.5, 49.0, 
          49.5, .5*^2}], "  ", 
        ColumnForm[ {{0, 
          0}, {.01, .8326533331112927*^-5}, {.02, .000090379779732272317}, \
{.029999999999999999, .00029589238659463545}, {.040000000000000001, \
.0006742307340312988}, {.050000000000000003, .0012742707791371271}, \
{.060000000000000005, .0021442760634416184}, {.070000000000000007, \
.0033317776232154967}, {.080000000000000002, .0048834559393789861}, \
{.089999999999999997, .0068450251736126176}, {.099999999999999992, \
.0092611199642631224}, {.10999999999999999, .01217518505837091}, \
{.11999999999999998, .01562936805143619}, {.12999999999999998, \
.019664415499222598}, {.13999999999999999, .024319572657371846}, \
{.14999999999999999, .0296324870952888}, {.16, .03563911642079156}, \
{.17000000000000001, .042373640341462793}, {.18000000000000002, \
.049868377277524897}, {.19000000000000003, .058153705729421454}, \
{.20000000000000004, .067257990591153768}, {.21000000000000005, \
.077207514587823198}, {.22000000000000006, .088026415002800465}, \
{.23000000000000007, .099736625846516075}, {.24000000000000007, \
.11235782560507394}, {.25000000000000006, .12590739069276871}, \
{.26000000000000006, .14040035471817322}, {.27000000000000007, \
.15584937365878931}, {.28000000000000008, .17226469702436503}, \
{.29000000000000009, .1896541450739036}, {.3000000000000001, \
.20802309213617193}, {.31000000000000011, .22737445606818993}, \
{.32000000000000012, .24770869387078623}, {.33000000000000013, \
.26902380346488397}, {.34000000000000014, .29131533161676415}, \
{.35000000000000014, .31457638798518744}, {.36000000000000015, \
.33879766524797583}, {.37000000000000016, .36396746525049689}, \
{.38000000000000017, .3900717311034993}, {.39000000000000018, \
.41709408514295276}, {.40000000000000019, .44501587264998643}, \
{.4100000000000002, .47381621121473316}, {.42000000000000021, \
.50347204561390491}, {.43000000000000022, .53395820805828886}, \
{.44000000000000022, .56524748365309363}, {.45000000000000023, \
.59731068090121908}, {.46000000000000024, .63030805797052247}, \
{.47000000000000025, .66558355614953402}, {.48000000000000026, \
.70321981001975464}, {.49000000000000027, .74327614374732798}, \
{.50000000000000022, .7858052213797232}, {.51000000000000023, \
.8308578040733603}, {.52000000000000024, .87848410930150156}, \
{.53000000000000025, .92873419919936506}, {.54000000000000026, \
.98165809151987038}, {.55000000000000027, 
          1.0373057913352799}, {.56000000000000028, 
          1.0957273000948113}, {.57000000000000028, 
          1.1569726182125268}, {.58000000000000029, 
          1.2210917458067301}, {.5900000000000003, 
          1.2881346829112221}, {.60000000000000031, 
          1.35815142953566}, {.61000000000000032, 
          1.431191985682803}, {.62000000000000033, 
          1.5073063513534399}, {.63000000000000034, 
          1.586544526547796}, {.64000000000000035, 
          1.6689565112659359}, {.65000000000000036, 
          1.7545923055078774}, {.66000000000000036, 
          1.8435019092736262}, {.67000000000000037, 
          1.935735322563183}, {.68000000000000038, 
          2.0313425453765488}, {.69000000000000039, 
          2.1303735777137236}, {.7000000000000004, 
          2.2328784195747065}, {.71000000000000041, 
          2.3389070709594986}, {.72000000000000042, 
          2.4485095318681007}, {.73000000000000043, 
          2.5617358023005119}, {.74000000000000044, 
          2.6786358822567307}, {.75000000000000044, 
          2.7992597717367591}, {.76000000000000045, 
          2.9236574707405971}, {.77000000000000046, 
          3.0518789792682441}, {.78000000000000047, 
          3.1839742973197014}, {.79000000000000048, 
          3.3199934248949683}, {.80000000000000049, 
          3.4599863619940439}, {.8100000000000005, 
          3.6040031086169284}, {.82000000000000051, 
          3.7520936647636218}, {.83000000000000052, 
          3.9043080304341249}, {.84000000000000052, 
          4.0606962056284379}, {.85000000000000053, 
          4.2213081903465604}, {.86000000000000054, 
          4.386193984588493}, {.87000000000000055, 
          4.5554035883542339}, {.88000000000000056, 
          4.7289870016437829}, {.89000000000000057, 
          4.906994224457141}, {.90000000000000058, 
          5.0894752567943078}, {.91000000000000059, 
          5.276480098655286}, {.9200000000000006, 
          5.4680587500400755}, {.9300000000000006, 
          5.6642612109486743}, {.94000000000000061, 
          5.8651374813810833}, {.95000000000000062, 
          6.0707375613373031}, {.96000000000000063, 
          6.281111450817332}, {.97000000000000064, 
          6.4963091498211734}, {.98000000000000065, 
          6.716380658348827}, {.99000000000000066, 6.9413759764002894}, {
          1.0000000000000007, 7.1713451039755629}}], "  ", 
        ColumnForm[ {{0, 
          0}, {.01, .0024979599993338779}, {.02, .0099850653528208155}, \
{.029999999999999999, .022439804987048364}, {.040000000000000001, \
.039826030605186413}, {.050000000000000003, .062094660017416127}, \
{.060000000000000005, .089184272684731405}, {.070000000000000007, \
.12102140913198266}, {.080000000000000002, .15752080657640161}, \
{.089999999999999997, .19858563698320703}, {.099999999999999992, \
.24410776607942433}, {.10999999999999999, .29396803813739192}, \
{.11999999999999998, .3480365873573073}, {.12999999999999998, \
.40617317548912707}, {.13999999999999999, .46822755494739565}, \
{.14999999999999999, .53403985651752661}, {.16, .60344100066518003}, \
{.17000000000000001, .67625313139494014}, {.18000000000000002, \
.75229007154717287}, {.19000000000000003, .83135779836901114}, \
{.20000000000000004, .91325493814590775}, {.21000000000000005, \
.99777327863389897}, {.22000000000000006, 
          1.0846982979896787}, {.23000000000000007, 
          1.1738097088558757}, {.24000000000000007, 
          1.2648820162225753}, {.25000000000000006, 
          1.3576850876533266}, {.26000000000000006, 
          1.4519847344346122}, {.27000000000000007, 
          1.5475433021821634}, {.28000000000000008, 
          1.6441202694155674}, {.29000000000000009, 
          1.7414728525944176}, {.3000000000000001, 
          1.8393566160949784}, {.31000000000000011, 
          1.9375260855956855}, {.32000000000000012, 
          2.0357353633331283}, {.33000000000000013, 
          2.1337387436873305}, {.34000000000000014, 
          2.2312913275560753}, {.35000000000000014, 
          2.3281496339829983}, {.36000000000000015, 
          2.4240722075127881}, {.37000000000000016, 
          2.5188202197592786}, {.38000000000000017, 
          2.6121580636885859}, {.39000000000000018, 
          2.703853939139393}, {.40000000000000019, 
          2.7936804281262364}, {.4100000000000002, 
          2.8814150584987988}, {.42000000000000021, 
          2.9668408545610645}, {.43000000000000022, 
          3.0497468732885911}, {.44000000000000022, 
          3.1299287248196923}, {.45000000000000023, 
          3.2071890759371304}, {.46000000000000024, 
          3.338743406324884}, {.47000000000000025, 
          3.5438303578642287}, {.48000000000000026, 
          3.773498058304054}, {.49000000000000027, 
          4.0137602584297332}, {.50000000000000022, 
          4.2606208870370761}, {.51000000000000023, 
          4.5129382094963253}, {.52000000000000024, 
          4.7703860159132496}, {.53000000000000025, 
          5.0328711034609359}, {.54000000000000026, 
          5.3003668427602673}, {.55000000000000027, 
          5.5728656254172027}, {.56000000000000028, 
          5.850365277604868}, {.57000000000000028, 
          6.1328651782298786}, {.58000000000000029, 
          6.420365149836992}, {.5900000000000003, 
          6.7128651417247029}, {.60000000000000031, 
          7.0103651394068685}, {.61000000000000032, 
          7.312865138744602}, {.62000000000000033, 
          7.6203651385553499}, {.63000000000000034, 
          7.9328651385012625}, {.64000000000000035, 
          8.250365138485801}, {.65000000000000036, 
          8.5728651384813528}, {.66000000000000036, 
          8.9003651384800353}, {.67000000000000037, 
          9.2328651384795979}, {.68000000000000038, 
          9.5703651384794401}, {.69000000000000039, 
          9.9128651384793489}, {.7000000000000004, 
          10.260365138479239}, {.71000000000000041, 
          10.612865138479231}, {.72000000000000042, 
          10.970365138479256}, {.73000000000000043, 
          11.332865138479146}, {.74000000000000044, 
          11.700365138479057}, {.75000000000000044, 
          12.072865138479035}, {.76000000000000045, 
          12.450365138478995}, {.77000000000000046, 
          12.83286513847901}, {.78000000000000047, 
          13.220365138479043}, {.79000000000000048, 
          13.612865138479025}, {.80000000000000049, 
          14.010365138478987}, {.8100000000000005, 
          14.41286513847891}, {.82000000000000051, 
          14.820365138478861}, {.83000000000000052, 
          15.232865138478884}, {.84000000000000052, 
          15.650365138478923}, {.85000000000000053, 
          16.072865138478956}, {.86000000000000054, 
          16.500365138478902}, {.87000000000000055, 
          16.932865138478803}, {.88000000000000056, 
          17.370365138478721}, {.89000000000000057, 
          17.812865138478635}, {.90000000000000058, 
          18.260365138478647}, {.91000000000000059, 
          18.712865138478787}, {.9200000000000006, 
          19.170365138478871}, {.9300000000000006, 
          19.632865138478909}, {.94000000000000061, 
          20.100365138479052}, {.95000000000000062, 
          20.572865138479134}, {.96000000000000063, 
          21.050365138479187}, {.97000000000000064, 
          21.532865138479412}, {.98000000000000065, 
          22.020365138479555}, {.99000000000000066, 22.512865138479576}, {
          1.0000000000000007, 23.010365138479731}}], "  ", 
        ColumnForm[ {{0, 
          0.0}, {.01, .49959199986677555}, {.02, .99782907083061201}, \
{.029999999999999999, 1.4931188560148965}, {.040000000000000001, 
          1.9841262676127138}, {.050000000000000003, 
          2.4695996148332289}, {.060000000000000005, 
          2.9483229186298279}, {.070000000000000007, 
          3.4191043708204236}, {.080000000000000002, 
          3.8807751180633634}, {.089999999999999997, 
          4.3321909632977196}, {.099999999999999992, 
          4.772234855945741}, {.10999999999999999, 
          5.1998195556477738}, {.11999999999999998, 
          5.6138902883353055}, {.12999999999999998, 
          6.0134273380286549}, {.13999999999999999, 
          6.3974485536250434}, {.14999999999999999, 6.7650117604011371}, {.16,
           7.1152170691295407}, {.17000000000000001, 
          7.4472090768224604}, {.18000000000000002, 
          7.7601789536241075}, {.19000000000000003, 
          8.0533664107435499}, {.20000000000000004, 
          8.3260615446357793}, {.21000000000000005, 
          8.5776065529624841}, {.22000000000000006, 
          8.807397318193452}, {.23000000000000007, 
          9.0148848550459935}, {.24000000000000007, 
          9.1995766182939658}, {.25000000000000006, 
          9.361037667856273}, {.26000000000000006, 
          9.4988916884008905}, {.27000000000000007, 
          9.6128218611093263}, {.28000000000000008, 
          9.7025715855714161}, {.29000000000000009, 
          9.7679450501986036}, {.3000000000000001, 
          9.8088076499135486}, {.31000000000000011, 
          9.825086250227935}, {.32000000000000012, 
          9.8167692972606737}, {.33000000000000013, 
          9.7839067735797229}, {.34000000000000014, 
          9.7266100001693232}, {.35000000000000014, 
          9.645051285215386}, {.36000000000000015, 
          9.5394634207425035}, {.37000000000000016, 
          9.4101390285557098}, {.38000000000000017, 
          9.2574297573057827}, {.39000000000000018, 
          9.081745332855677}, {.40000000000000019, 
          8.8835524645130093}, {.4100000000000002, 
          8.6633736099994962}, {.42000000000000021, 
          8.4217856024538058}, {.43000000000000022, 
          8.1594181430514947}, {.44000000000000022, 
          7.8769521631686548}, {.45000000000000023, 
          7.575118060319058}, {.46000000000000024, 
          18.735748017231636}, {.47000000000000025, 
          22.281642290637226}, {.48000000000000026, 
          23.651897797327848}, {.49000000000000027, 
          24.400542227807854}, {.50000000000000022, 
          24.971583493660866}, {.51000000000000023, 
          25.491880998188819}, {.52000000000000024, 
          25.997680285196033}, {.53000000000000025, 
          26.499337224341254}, {.54000000000000026, 
          26.999810635525193}, {.55000000000000027, 
          27.499945895861956}, {.56000000000000028, 
          27.999984541671132}, {.57000000000000028, 
          28.499995583331213}, {.58000000000000029, 
          28.999998738091207}, {.5900000000000003, 
          29.499999639451083}, {.60000000000000031, 
          29.999999896981841}, {.61000000000000032, 
          30.499999970565092}, {.62000000000000033, 
          30.999999991584211}, {.63000000000000034, 
          31.499999997598294}, {.64000000000000035, 
          31.999999999309644}, {.65000000000000036, 
          32.499999999800231}, {.66000000000000036, 
          32.999999999936556}, {.67000000000000037, 
          33.499999999975714}, {.68000000000000038, 
          33.999999999993129}, {.69000000000000039, 
          34.49999999998856}, {.7000000000000004, 
          34.999999999989562}, {.71000000000000041, 
          35.500000000009202}, {.72000000000000042, 
          35.999999999996177}, {.73000000000000043, 
          36.499999999981831}, {.74000000000000044, 
          37.000000000000824}, {.75000000000000044, 
          37.499999999994905}, {.76000000000000045, 
          37.999999999996987}, {.77000000000000046, 
          38.500000000005848}, {.78000000000000047, 
          39.000000000000142}, {.79000000000000048, 
          39.499999999996525}, {.80000000000000049, 
          39.999999999995531}, {.8100000000000005, 
          40.499999999989257}, {.82000000000000051, 
          41.000000000000846}, {.83000000000000052, 
          41.500000000003844}, {.84000000000000052, 
          42.000000000004832}, {.85000000000000053, 
          42.500000000001755}, {.86000000000000054, 
          42.999999999987864}, {.87000000000000055, 
          43.499999999993605}, {.88000000000000056, 
          43.99999999999055}, {.89000000000000057, 
          44.499999999992092}, {.90000000000000058, 
          45.00000000001021}, {.91000000000000059, 
          45.500000000017565}, {.9200000000000006, 
          45.999999999999936}, {.9300000000000006, 
          46.500000000008129}, {.94000000000000061, 
          47.000000000020464}, {.95000000000000062, 
          47.499999999995325}, {.96000000000000063, 
          48.00000000001392}, {.97000000000000064, 
          48.500000000030738}, {.98000000000000065, 
          48.999999999995929}, {.99000000000000066, 49.500000000008292}, {
          1.0000000000000007, 50.000000000023135}}], "  ", 
        ColumnForm[ {{0, 25}, {.01, 25}, {.02, 25}, {.029999999999999999, 
          25}, {.040000000000000001, 25}, {.050000000000000003, 
          25}, {.060000000000000005, 25}, {.070000000000000007, 
          25}, {.080000000000000002, 25}, {.089999999999999997, 
          25}, {.099999999999999992, 25}, {.10999999999999999, 
          25}, {.11999999999999998, 25}, {.12999999999999998, 
          25}, {.13999999999999999, 25}, {.14999999999999999, 25}, {.16, 
          25}, {.17000000000000001, 25}, {.18000000000000002, 
          25}, {.19000000000000003, 25}, {.20000000000000004, 
          25}, {.21000000000000005, 25}, {.22000000000000006, 
          25}, {.23000000000000007, 25}, {.24000000000000007, 
          25}, {.25000000000000006, 25}, {.26000000000000006, 
          25}, {.27000000000000007, 25}, {.28000000000000008, 
          25}, {.29000000000000009, 25}, {.3000000000000001, 
          25}, {.31000000000000011, 25}, {.32000000000000012, 
          25}, {.33000000000000013, 25}, {.34000000000000014, 
          25}, {.35000000000000014, 25}, {.36000000000000015, 
          25}, {.37000000000000016, 25}, {.38000000000000017, 
          25}, {.39000000000000018, 25}, {.40000000000000019, 
          25}, {.4100000000000002, 25}, {.42000000000000021, 
          25}, {.43000000000000022, 25}, {.44000000000000022, 
          25}, {.45000000000000023, 25}, {.46000000000000024, 
          0}, {.47000000000000025, 0}, {.48000000000000026, 
          0}, {.49000000000000027, 0}, {.50000000000000022, 
          0}, {.51000000000000023, 0}, {.52000000000000024, 
          0}, {.53000000000000025, 0}, {.54000000000000026, 
          0}, {.55000000000000027, 0}, {.56000000000000028, 
          0}, {.57000000000000028, 0}, {.58000000000000029, 
          0}, {.5900000000000003, 0}, {.60000000000000031, 
          0}, {.61000000000000032, 0}, {.62000000000000033, 
          0}, {.63000000000000034, 0}, {.64000000000000035, 
          0}, {.65000000000000036, 0}, {.66000000000000036, 
          0}, {.67000000000000037, 0}, {.68000000000000038, 
          0}, {.69000000000000039, 0}, {.7000000000000004, 
          0}, {.71000000000000041, 0}, {.72000000000000042, 
          0}, {.73000000000000043, 0}, {.74000000000000044, 
          0}, {.75000000000000044, 0}, {.76000000000000045, 
          0}, {.77000000000000046, 0}, {.78000000000000047, 
          0}, {.79000000000000048, 0}, {.80000000000000049, 
          0}, {.8100000000000005, 0}, {.82000000000000051, 
          0}, {.83000000000000052, 0}, {.84000000000000052, 
          0}, {.85000000000000053, 0}, {.86000000000000054, 
          0}, {.87000000000000055, 0}, {.88000000000000056, 
          0}, {.89000000000000057, 0}, {.90000000000000058, 
          0}, {.91000000000000059, 0}, {.9200000000000006, 
          0}, {.9300000000000006, 0}, {.94000000000000061, 
          0}, {.95000000000000062, 0}, {.96000000000000063, 
          0}, {.97000000000000064, 0}, {.98000000000000065, 
          0}, {.99000000000000066, 0}, {1.0000000000000007, 0}}]],
      Editable->False]], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
EJEMPLO:
Resolver mediante el modelo \[Theta]-Wilson no-lineal el siguiente problema \
de un material elasto-pl\[AAcute]stico perfecto:
0.2533\[CenterDot]a(t)+0.1589\[CenterDot]v(t)+fs(u,v)=p(t)
u(0)=0
v(0)=0
p(t)={{0,0},{.1,5},{.2,10},{.3,15},{.4,10},{.5,
        5},{.6,-5},{.7,-10},{.8,-15},{.9,-20},{1,-25},{1.1,-25},{1.2,-25}};
queremos la respuesta hasta el instante tn=1.2,con un incremento de tiempo de \
to=0.01. La rigidez del tramo el\[AAcute]stico es 10, la m\[AAcute]xima \
tracci\[OAcute]n es 15 y la m\[AAcute]xima compresi\[OAcute]n es -15. Tomar \
\[Theta]=1.4.\
\>", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(p = {{0, 0}, { .1, 5}, { .2, 10}, { .3, 15}, { .4, 10}, { .5, 
            5}, { .6, \(-5\)}, { .7, \(-10\)}, { .8, \(-15\)}, { .9, \
\(-20\)}, {1, \(-25\)}, {1.1, \(-25\)}, {1.2, \(-25\)}};\)\), "\
\[IndentingNewLine]", 
    \(WilsonNoLineal[10, 0.2533, 0.1589, p, 0, 0, 0, 1.2, 0.01, 1.4, \(-15\), 
      15, posicion, velocidad, aceleracion]\)}], "Input"],

Cell[BoxData[
    \("Resoluci\[OAcute]n del problema por el M\[EAcute]todo \[CurlyTheta] - \
Wilson no-lineal"\)], "Print"],

Cell[BoxData[
    \("-------------------------------------------"\)], "Print"],

Cell[BoxData[
    \(" "\)], "Print"],

Cell[BoxData[
    \("Los datos de la estructura son:"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Rigidez del tramo el\[AAcute]stico = k = "\
\[InvisibleSpace]10\),
      SequenceForm[ "  Rigidez del tramo el\[AAcute]stico = k = ", 10],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Masa = m = "\[InvisibleSpace]0.2533`\),
      SequenceForm[ "  Masa = m = ", .25330000000000003],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Amortiguamiento = c = "\[InvisibleSpace]0.1589`\),
      SequenceForm[ "  Amortiguamiento = c = ", .15890000000000001],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Los datos de la carga son "\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Funci\[OAcute]n Carga = p(t) = \
"\[InvisibleSpace]{{0, 0}, {0.1`, 5}, {0.2`, 10}, {0.3`, 15}, {0.4`, 
              10}, {0.5`, 
              5}, {0.6`, \(-5\)}, {0.7`, \(-10\)}, {0.8`, \(-15\)}, {0.9`, \
\(-20\)}, {1, \(-25\)}, {1.1`, \(-25\)}, {1.2`, \(-25\)}}[t]\),
      SequenceForm[ "  Funci\[OAcute]n Carga = p(t) = ", 
        {{0, 0}, {.10000000000000001, 5}, {.20000000000000001, 
        10}, {.29999999999999999, 15}, {.40000000000000002, 10}, {.5, 
        5}, {.59999999999999998, -5}, {.69999999999999996, -10}, \
{.80000000000000004, -15}, {.90000000000000002, -20}, {1, -25}, {
        1.1000000000000001, -25}, {1.2, -25}}[ t]],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Los datos iniciales son: "\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Desplazamiento inicial = \!\(u\_o\) = "\
\[InvisibleSpace]0\),
      SequenceForm[ "  Desplazamiento inicial = \!\(u\_o\) = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Velocidad inicial = \!\(v\_o\) = \
"\[InvisibleSpace]0\),
      SequenceForm[ "  Velocidad inicial = \!\(v\_o\) = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Datos para la resolucion:"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Instante de tiempo inicial = \!\(t\_o\) = "\
\[InvisibleSpace]0\),
      SequenceForm[ "  Instante de tiempo inicial = \!\(t\_o\) = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Instante de tiempo final = \!\(t\_final\) = "\
\[InvisibleSpace]1.2`\),
      SequenceForm[ "  Instante de tiempo final = \!\(t\_final\) = ", 1.2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"  Paso\\!\\(\\* StyleBox[\\\" \
\\\",\\nFontColor->GrayLevel[0]]\\)de tiempo = \[CapitalDelta]t = \"\>", 
        "\[InvisibleSpace]", "0.01`"}],
      SequenceForm[ 
      "  Paso\!\(\* StyleBox[\" \",\nFontColor->GrayLevel[0]]\)de tiempo = \
\[CapitalDelta]t = ", .01],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Parametro \[CurlyTheta] = "\[InvisibleSpace]1.4`\),
      
      SequenceForm[ "  Parametro \[CurlyTheta] = ", 1.3999999999999999],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Valor que provoca la plastificacion a compresion = \
fc = "\[InvisibleSpace]\(-15\)\),
      SequenceForm[ 
      "  Valor que provoca la plastificacion a compresion = fc = ", -15],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("  Valor que provoca la plastificacion a traccion = \
ft = "\[InvisibleSpace]15\),
      SequenceForm[ 
      "  Valor que provoca la plastificacion a traccion = ft = ", 15],
      Editable->False]], "Print"],

Cell[BoxData[
    \(" "\)], "Print"],

Cell[BoxData[
    \("Carga"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.793651 0.382705 0.0147196 [
[.18254 .37021 -9 -9 ]
[.18254 .37021 9 0 ]
[.34127 .37021 -9 -9 ]
[.34127 .37021 9 0 ]
[.5 .37021 -9 -9 ]
[.5 .37021 9 0 ]
[.65873 .37021 -9 -9 ]
[.65873 .37021 9 0 ]
[.81746 .37021 -3 -9 ]
[.81746 .37021 3 0 ]
[.97619 .37021 -9 -9 ]
[.97619 .37021 9 0 ]
[1.025 .38271 0 -6.25 ]
[1.025 .38271 10 6.25 ]
[.01131 .08831 -18 -4.5 ]
[.01131 .08831 0 4.5 ]
[.01131 .23551 -18 -4.5 ]
[.01131 .23551 0 4.5 ]
[.01131 .5299 -12 -4.5 ]
[.01131 .5299 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .38271 m
.18254 .38896 L
s
[(0.2)] .18254 .37021 0 1 Mshowa
.34127 .38271 m
.34127 .38896 L
s
[(0.4)] .34127 .37021 0 1 Mshowa
.5 .38271 m
.5 .38896 L
s
[(0.6)] .5 .37021 0 1 Mshowa
.65873 .38271 m
.65873 .38896 L
s
[(0.8)] .65873 .37021 0 1 Mshowa
.81746 .38271 m
.81746 .38896 L
s
[(1)] .81746 .37021 0 1 Mshowa
.97619 .38271 m
.97619 .38896 L
s
[(1.2)] .97619 .37021 0 1 Mshowa
.125 Mabswid
.06349 .38271 m
.06349 .38646 L
s
.10317 .38271 m
.10317 .38646 L
s
.14286 .38271 m
.14286 .38646 L
s
.22222 .38271 m
.22222 .38646 L
s
.2619 .38271 m
.2619 .38646 L
s
.30159 .38271 m
.30159 .38646 L
s
.38095 .38271 m
.38095 .38646 L
s
.42063 .38271 m
.42063 .38646 L
s
.46032 .38271 m
.46032 .38646 L
s
.53968 .38271 m
.53968 .38646 L
s
.57937 .38271 m
.57937 .38646 L
s
.61905 .38271 m
.61905 .38646 L
s
.69841 .38271 m
.69841 .38646 L
s
.7381 .38271 m
.7381 .38646 L
s
.77778 .38271 m
.77778 .38646 L
s
.85714 .38271 m
.85714 .38646 L
s
.89683 .38271 m
.89683 .38646 L
s
.93651 .38271 m
.93651 .38646 L
s
.25 Mabswid
0 .38271 m
1 .38271 L
s
gsave
1.025 .38271 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .08831 m
.03006 .08831 L
s
[(-20)] .01131 .08831 1 0 Mshowa
.02381 .23551 m
.03006 .23551 L
s
[(-10)] .01131 .23551 1 0 Mshowa
.02381 .5299 m
.03006 .5299 L
s
[(10)] .01131 .5299 1 0 Mshowa
.125 Mabswid
.02381 .11775 m
.02756 .11775 L
s
.02381 .14719 m
.02756 .14719 L
s
.02381 .17663 m
.02756 .17663 L
s
.02381 .20607 m
.02756 .20607 L
s
.02381 .26495 m
.02756 .26495 L
s
.02381 .29439 m
.02756 .29439 L
s
.02381 .32383 m
.02756 .32383 L
s
.02381 .35327 m
.02756 .35327 L
s
.02381 .41214 m
.02756 .41214 L
s
.02381 .44158 m
.02756 .44158 L
s
.02381 .47102 m
.02756 .47102 L
s
.02381 .50046 m
.02756 .50046 L
s
.02381 .05887 m
.02756 .05887 L
s
.02381 .02943 m
.02756 .02943 L
s
.02381 .55934 m
.02756 .55934 L
s
.02381 .58878 m
.02756 .58878 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 1 r
.5 Mabswid
.02381 .38271 m
.06244 .41853 L
.10458 .45761 L
.14415 .4943 L
.18221 .52959 L
.22272 .56716 L
.24141 .5845 L
.25127 .59363 L
.25666 .59863 L
.2593 .60108 L
.26045 .60215 L
.26171 .60332 L
.26301 .60247 L
.26425 .60133 L
.26698 .59879 L
.27279 .59341 L
.28302 .58392 L
.30316 .56525 L
.3438 .52755 L
.38293 .49127 L
.40291 .47274 L
.41341 .463 L
.41618 .46043 L
.41771 .45902 L
.41915 .45768 L
.4198 .45707 L
.4205 .45643 L
.42125 .45515 L
.42196 .45385 L
.42451 .44911 L
.43446 .43066 L
.44538 .41041 L
.46458 .3748 L
.48427 .33828 L
.4929 .32228 L
.49778 .31322 L
.49891 .31114 L
.50012 .30899 L
.50127 .30793 L
.50233 .30695 L
.50472 .30473 L
.50689 .30272 L
.51175 .29821 L
.52168 .28901 L
.54253 .26967 L
.58194 .23313 L
.61982 .19799 L
.66016 .16058 L
.69899 .12458 L
.74026 .0863 L
Mistroke
.78002 .04943 L
.8001 .03082 L
.80883 .02272 L
.81342 .01846 L
.81464 .01733 L
.81593 .01613 L
.81716 .015 L
.81827 .01472 L
.81957 .01472 L
.82079 .01472 L
.82356 .01472 L
.82843 .01472 L
.83798 .01472 L
.85897 .01472 L
.89735 .01472 L
.93818 .01472 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00O5Goo00<007ooOol0
ogoo2Goo000EOol00`00Oomoo`3oOol9Ool001Eoo`03001oogoo0?moo`Uoo`005Goo00<007ooOol0
agoo:W`O5goo000EOol00`00Oomoo`36Ool2O1m0Ool001Eoo`03001oogoo0<Eoo`03O1moogoo041o
o`005Goo00<007ooOol0a7oo00=l7gooOol0@Goo000EOol20035Ool00g`OOomoo`11Ool001Eoo`03
001oogoo0<=oo`03O1moogoo049oo`005Goo00<007ooOol0`Woo00=l7gooOol0@goo000EOol00`00
Oomoo`30Ool2O1m6Ool001Eoo`03001oogoo0;moo`03O1moogoo04Ioo`005Goo00<007ooOol0_Woo
00=l7gooOol0Agoo000EOol00`00Oomoo`2mOol00g`OOomoo`18Ool001Eoo`03001oogoo0;aoo`03
O1moogoo04Uoo`005Goo0P00_7oo00=l7gooOol0BWoo000EOol00`00Oomoo`2jOol00g`OOomoo`1;
Ool001Eoo`03001oogoo0;Uoo`03O1moogoo04aoo`005Goo00<007ooOol0^7oo00=l7gooOol0CGoo
000EOol00`00Oomoo`2gOol00g`OOomoo`1>Ool000Moo`@000=oo`8000Eoo`03001oogoo0;Ioo`03
O1moogoo04moo`001goo00<007ooOol00goo00@007ooOol000Aoo`03001oogoo0;Eoo`03O1moogoo
051oo`0027oo00<007ooOol00Woo00@007ooOol000Aoo`800;Eoo`03O1moogoo055oo`0000=oo`00
00000P0017oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo0;=oo`03O1moogoo059o
o`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`2aOol2O1mEOol000Qoo`8000Ao
o`8000Eoo`03001oogoo0;1oo`03O1moogoo05Eoo`005Goo00<007ooOol0[goo00=l7gooOol0EWoo
000EOol00`00Oomoo`2^Ool00g`OOomoo`1GOol001Eoo`03001oogoo0:eoo`03O1moogoo05Qoo`00
5Goo00<007ooOol0Zgoo0W`OFgoo000EOol2002[Ool00g`OOomoo`1KOol001Eoo`03001oogoo0:Uo
o`03O1moogoo05aoo`005Goo00<007ooOol0Z7oo00=l7gooOol0GGoo000EOol00`00Oomoo`2WOol0
0g`OOomoo`1NOol001Eoo`03001oogoo0:Ioo`03O1moogoo05moo`005Goo00<007ooOol0YGoo00=l
7gooOol0H7oo000EOol00`00Oomoo`2TOol00g`OOomoo`1QOol001Eoo`800:Aoo`03O1moogoo069o
o`005Goo00<007ooOol0XWoo00=l7gooOol0Hgoo000EOol00`00Oomoo`2QOol00g`OOomoo`1TOol0
01Eoo`03001oogoo0:1oo`03O1moogoo06Eoo`005Goo00<007ooOol0Wgoo00=l7gooOol0IWoo000E
Ool00`00Oomoo`2NOol00g`OOomoo`1WOol001Eoo`03001oogoo09eoo`03O1moogoo06Qoo`005Goo
00<007ooOol0W7oo00=l7gooOol0JGoo000EOol2002LOol00g`OOomoo`1ZOol001Eoo`03001oogoo
09Uoo`9l7feoo`005Goo00<007ooOol0V7oo00=l7gooOol0KGoo000EOol00`00Oomoo`2GOol00g`O
Oomoo`1^Ool001Eoo`03001oogoo09Ioo`03O1moogoo06moo`005Goo00<007ooOol0UGoo00=l7goo
Ool0L7oo000EOol00`00Oomoo`2DOol00g`OOomoo`1aOol001Eoo`8009Aoo`03O1moogoo079oo`00
5Goo00<007ooOol0TWoo00=l7gooOol0Lgoo000EOol00`00Oomoo`2AOol00g`OOomoo`1dOol001Eo
o`03001oogoo08moo`9l7gMoo`005Goo00<007ooOol0SWoo00=l7gooOol0Mgoo000EOol00`00Oomo
o`2=Ool00g`OOomoo`1hOol000Moo`D0009oo`8000Eoo`03001oogoo08aoo`03O1moogoo07Uoo`00
2Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo08]oo`03O1moogoo07Yoo`002Goo
00D007ooOomoo`00009oo`03001oogoo009oo`8008]oo`03O1moogoo07]oo`0000=oo`0000000P00
17oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo08Uoo`03O1moogoo07aoo`002Goo
00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo08Qoo`03O1moogoo07eoo`0027oo0P00
17oo0P001Goo00<007ooOol0Qgoo00=l7gooOol0OWoo000EOol00`00Oomoo`26Ool00g`OOomoo`1o
Ool001Eoo`03001oogoo08Eoo`03O1moogoo081oo`005Goo00<007ooOol0Q7oo00=l7gooOol0PGoo
000EOol20024Ool00g`OOomoo`22Ool001Eoo`03001oogoo089oo`03O1moogoo08=oo`005Goo00<0
07ooOol0PGoo00=l7gooOol0Q7oo000EOol00`00Oomoo`20Ool00g`OOomoo`25Ool001Eoo`03001o
ogoo07ioo`9l7hQoo`005Goo00<007ooOol0OGoo00=l7gooOol0R7oo000EOol00`00Oomoo`1lOol0
0g`OOomoo`29Ool001Eoo`03001oogoo07]oo`03O1moogoo08Yoo`005Goo0P00Ngoo00=l7gooOol0
Rgoo000EOol00`00Oomoo`1iOol00g`OOomoo`2<Ool001Eoo`03001oogoo07Qoo`03O1moogoo08eo
o`005Goo00<007ooOol0Mgoo00=l7gooOol0SWoo000EOol00`00Oomoo`1fOol00g`OOomoo`2?Ool0
01Eoo`03001oogoo07Ioo`03O1moogoo08moo`005Goo00<007ooOol0MWoo00=l7gooOol0Sgoo000E
Ool2001fOol00g`OOomoo`2@Ool001Eoo`03001oogoo07Aoo`03O1moogoo095oo`005Goo00<007oo
Ool0M7oo00=l7gooOol0TGoo000EOol00`00Oomoo`1cOol00g`OOomoo`2BOol001Eoo`03001oogoo
01ioo`8000Aoo`8000=oo`@001Yoo`8000Aoo`8000Eoo`<001Qoo`800004Ooml7gooOol20003Ool3
000KOol20004Ool20004Ool2000OOol5000NOol50002Ool20003Ool4000@Ool001Eoo`03001oogoo
01eoo`04001oogoo0008Ool00`00Oomoo`0JOol01000Oomoo`002goo00<007ooOol05Woo00@007oo
Ooml7`Qoo`04001oogoo000IOol01000Oomoo`0027oo00@007ooOol0021oo`03001oogoo021oo`03
001oogoo00Moo`03001oogoo015oo`005Goo00<007ooOol07Goo00@007ooOol000Uoo`03001oogoo
01Uoo`04001oogoo0008Ool5000GOol01000Oomoog`O27oo00@007ooOol001Uoo`04001oogoo0008
Ool01000Oomoo`0087oo00<007ooOol087oo00<007ooOol027oo00<007ooOol047oo000EOol00`00
Oomoo`0MOol01000Oomoo`002Woo00<007ooOol067oo00@007ooOol000Qoo`04001oogoo000HOol0
1000Ooml7`0027oo0`006Woo00@007ooOol000Uoo`80025oo`03001oogoo021oo`03001oogoo00Uo
o`03001oogoo00moo`005Goo0P007Woo00@007ooOol000Qoo`04001oogoo000IOol01000Oomoo`00
2Goo00<007oo000067oo00@007ooO1l000Uoo`03001oogoo01Uoo`04001oogoo0008Ool01000Oomo
o`0087oo00<007ooOol087oo00<007ooOol01goo00@007ooOol0011oo`005Goo00<007ooOol07Woo
0P002Woo0P006goo0P002goo0P006Goo00=l7`00Ool02Goo0`006Woo0P002Woo0P0087oo0P008Goo
0P002Woo0P004Goo000EOol00`00Oomoo`1_Ool00g`OOomoo`2FOol001Eoo`03001oogoo06ioo`03
O1moogoo09Moo`005Goo00<007ooOol0KWoo00=l7gooOol0Ugoo000EOol00`00Oomoo`1]Ool00g`O
Oomoo`2HOol001Eoo`03001oogoo06aoo`03O1moogoo099oo`8000Eoo`003goo1P0000=l7`000000
K00000=l7`000000R0002Goo00@007ooOol000Aoo`005Goo00<007`OOol01goo00<007ooOol01goo
00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol027oo00<007ooOol01goo
00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00=l7`00Ool027oo
00<007ooOol027oo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol027oo00<007ooOol01goo
00<007ooOol01goo00<007ooOol01goo00<007ooOol03Goo00<007ooOol01Goo000EOol00`00Ooml
7`0UOol00`00Oomoo`0VOol00`00Oomoo`0JOol00g`OOomoo`08Ool00`00Oomoo`0VOol00`00Oomo
o`0UOol00`00Oomoo`0VOol00`00Oomoo`0<Ool50004Ool001Eoo`04001oogooO1mYOol00g`OOomo
o`2COol00`00Oomoo`05Ool001Eoo`05001oogooOoml7`1XOol00g`OOomoo`2KOol001Eoo`03001o
ogoo009oo`03O1moogoo06Aoo`03O1moogoo09aoo`005Goo00<007ooOol00goo00=l7gooOol0Hgoo
00=l7gooOol0W7oo000EOol00`00Oomoo`04Ool00g`OOomoo`1QOol00g`OOomoo`2MOol001Eoo`80
00Ioo`03O1moogoo061oo`03O1moogoo09eoo`005Goo00<007ooOol01Woo00=l7gooOol0GWoo00=l
7gooOol0WWoo000EOol00`00Oomoo`07Ool00g`OOomoo`1MOol00g`OOomoo`2NOol001Eoo`03001o
ogoo00Qoo`03O1moogoo05aoo`03O1moogoo09ioo`005Goo00<007ooOol02Goo00=l7gooOol0FWoo
00=l7gooOol0Wgoo000EOol00`00Oomoo`0:Ool00g`OOomoo`1IOol00g`OOomoo`2OOol001Eoo`03
001oogoo00]oo`03O1moogoo05Moo`03O1moogoo0:1oo`005Goo0P003Goo00=l7gooOol0EWoo00=l
7gooOol0X7oo000EOol00`00Oomoo`0=Ool00g`OOomoo`1DOol00g`OOomoo`2QOol001Eoo`03001o
ogoo00ioo`03O1moogoo059oo`03O1moogoo0:9oo`005Goo00<007ooOol03goo00=l7gooOol0DGoo
00=l7gooOol0XWoo000EOol00`00Oomoo`0@Ool00g`OOomoo`1?Ool00g`OOomoo`2SOol001Eoo`03
001oogoo015oo`03O1moogoo04eoo`9l7jEoo`005Goo00<007ooOol04Woo00=l7gooOol0Bgoo00=l
7gooOol0YGoo000EOol00`00Oomoo`0COol00g`OOomoo`19Ool00g`OOomoo`2VOol001Eoo`8001Eo
o`03O1moogoo04Moo`03O1moogoo0:Moo`005Goo00<007ooOol05Goo00=l7gooOol0AGoo00=l7goo
Ool0Z7oo000EOol00`00Oomoo`0FOol2O1m4Ool00g`OOomoo`2YOol001Eoo`03001oogoo01Qoo`03
O1moogoo03moo`9l7jaoo`005Goo00<007ooOol06Goo00=l7gooOol0?Goo00=l7gooOol0[7oo000E
Ool00`00Oomoo`0JOol00g`OOomoo`0kOol00g`OOomoo`2]Ool001Eoo`03001oogoo01]oo`03O1mo
ogoo03Uoo`03O1moogoo0:ioo`005Goo0P007Goo00=l7gooOol0=goo00=l7gooOol0[goo000EOol0
0`00Oomoo`0MOol00g`OOomoo`0eOol00g`OOomoo`2`Ool001Eoo`03001oogoo01ioo`03O1moogoo
03=oo`03O1moogoo0;5oo`005Goo00<007ooOol07goo00=l7gooOol0<7oo0W`O]7oo000EOol00`00
Oomoo`0POol2O1l_Ool00g`OOomoo`2dOol001Eoo`03001oogoo029oo`03O1moogoo02]oo`03O1mo
ogoo0;Eoo`001goo1@000Woo0P001Goo00<007ooOol08goo00=l7gooOol0:Goo00=l7gooOol0]Woo
0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol097oo00=l7gooOol09goo00=l
7gooOol0]goo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo0P009Woo00=l7gooOol09Goo
00=l7gooOol0^7oo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol09Woo00=l
7gooOol08goo00=l7gooOol0^Goo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007oo
Ool09goo00=l7gooOol08Goo00=l7gooOol0^Woo0008Ool20004Ool20005Ool00`00Oomoo`0XOol0
0g`OOomoo`0OOol00g`OOomoo`2kOol001Eoo`03001oogoo02Uoo`03O1moogoo01eoo`03O1moogoo
0;aoo`005Goo00<007ooOol0:Woo0W`O77oo00=l7gooOol0_Goo000EOol00`00Oomoo`0/Ool00g`O
Oomoo`0HOol00g`OOomoo`2nOol001Eoo`03001oogoo02eoo`03O1moogoo01Ioo`03O1moogoo0;mo
o`005Goo0P00;goo00=l7gooOol057oo00=l7gooOol0`7oo000EOol00`00Oomoo`0_Ool00g`OOomo
o`0BOol00g`OOomoo`31Ool001Eoo`03001oogoo031oo`03O1moogoo011oo`03O1moogoo0<9oo`00
5Goo00<007ooOol0<Goo00=l7gooOol03Woo00=l7gooOol0`goo000EOol00`00Oomoo`0bOol00g`O
Oomoo`0<Ool00g`OOomoo`34Ool001Eoo`03001oogoo03=oo`03O1moogoo00Yoo`03O1moogoo0<Eo
o`005Goo00<007ooOol0=7oo00=l7gooOol027oo00=l7gooOol0aWoo000EOol2000fOol2O1l6Ool2
O1o9Ool001Eoo`03001oogoo03Moo`03O1moogoo009oo`03O1moogoo0<Uoo`005Goo00<007ooOol0
>7oo00El7gooOomoog`O0<]oo`005Goo00<007ooOol0>7oo17`Oc7oo000EOol00`00Oomoo`0iOol2
O1o=Ool001Eoo`03001oogoo0?moo`Uoo`005Goo00<007ooOol0ogoo2Goo000EOol00`00Oomoo`3o
Ool9Ool001Eoo`03001oogoo0?moo`Uoo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol00?moob5oo`00ogoo8Goo003oOolQOol0019oo`<00?moo`aoo`004goo00<007ooOol0ogoo
2goo000COol3003oOol;Ool001=oo`04001oogoo003oOol:Ool001=oo`04001oogoo003oOol:Ool0
019oo`@00?moo`]oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.104523, -26.0188, \
0.00493151, 0.265897}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[BoxData[
    \("Desplazamientos:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.793651 0.427617 0.0487128 [
[.18254 .41512 -9 -9 ]
[.18254 .41512 9 0 ]
[.34127 .41512 -9 -9 ]
[.34127 .41512 9 0 ]
[.5 .41512 -9 -9 ]
[.5 .41512 9 0 ]
[.65873 .41512 -9 -9 ]
[.65873 .41512 9 0 ]
[.81746 .41512 -3 -9 ]
[.81746 .41512 3 0 ]
[.97619 .41512 -9 -9 ]
[.97619 .41512 9 0 ]
[1.025 .42762 0 -6.25 ]
[1.025 .42762 10 6.25 ]
[.01131 .03791 -12 -4.5 ]
[.01131 .03791 0 4.5 ]
[.01131 .13534 -12 -4.5 ]
[.01131 .13534 0 4.5 ]
[.01131 .23277 -12 -4.5 ]
[.01131 .23277 0 4.5 ]
[.01131 .33019 -12 -4.5 ]
[.01131 .33019 0 4.5 ]
[.01131 .52504 -6 -4.5 ]
[.01131 .52504 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .42762 m
.18254 .43387 L
s
[(0.2)] .18254 .41512 0 1 Mshowa
.34127 .42762 m
.34127 .43387 L
s
[(0.4)] .34127 .41512 0 1 Mshowa
.5 .42762 m
.5 .43387 L
s
[(0.6)] .5 .41512 0 1 Mshowa
.65873 .42762 m
.65873 .43387 L
s
[(0.8)] .65873 .41512 0 1 Mshowa
.81746 .42762 m
.81746 .43387 L
s
[(1)] .81746 .41512 0 1 Mshowa
.97619 .42762 m
.97619 .43387 L
s
[(1.2)] .97619 .41512 0 1 Mshowa
.125 Mabswid
.06349 .42762 m
.06349 .43137 L
s
.10317 .42762 m
.10317 .43137 L
s
.14286 .42762 m
.14286 .43137 L
s
.22222 .42762 m
.22222 .43137 L
s
.2619 .42762 m
.2619 .43137 L
s
.30159 .42762 m
.30159 .43137 L
s
.38095 .42762 m
.38095 .43137 L
s
.42063 .42762 m
.42063 .43137 L
s
.46032 .42762 m
.46032 .43137 L
s
.53968 .42762 m
.53968 .43137 L
s
.57937 .42762 m
.57937 .43137 L
s
.61905 .42762 m
.61905 .43137 L
s
.69841 .42762 m
.69841 .43137 L
s
.7381 .42762 m
.7381 .43137 L
s
.77778 .42762 m
.77778 .43137 L
s
.85714 .42762 m
.85714 .43137 L
s
.89683 .42762 m
.89683 .43137 L
s
.93651 .42762 m
.93651 .43137 L
s
.25 Mabswid
0 .42762 m
1 .42762 L
s
gsave
1.025 .42762 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .03791 m
.03006 .03791 L
s
[(-8)] .01131 .03791 1 0 Mshowa
.02381 .13534 m
.03006 .13534 L
s
[(-6)] .01131 .13534 1 0 Mshowa
.02381 .23277 m
.03006 .23277 L
s
[(-4)] .01131 .23277 1 0 Mshowa
.02381 .33019 m
.03006 .33019 L
s
[(-2)] .01131 .33019 1 0 Mshowa
.02381 .52504 m
.03006 .52504 L
s
[(2)] .01131 .52504 1 0 Mshowa
.125 Mabswid
.02381 .06227 m
.02756 .06227 L
s
.02381 .08663 m
.02756 .08663 L
s
.02381 .11098 m
.02756 .11098 L
s
.02381 .1597 m
.02756 .1597 L
s
.02381 .18405 m
.02756 .18405 L
s
.02381 .20841 m
.02756 .20841 L
s
.02381 .25712 m
.02756 .25712 L
s
.02381 .28148 m
.02756 .28148 L
s
.02381 .30584 m
.02756 .30584 L
s
.02381 .35455 m
.02756 .35455 L
s
.02381 .3789 m
.02756 .3789 L
s
.02381 .40326 m
.02756 .40326 L
s
.02381 .45197 m
.02756 .45197 L
s
.02381 .47633 m
.02756 .47633 L
s
.02381 .50069 m
.02756 .50069 L
s
.02381 .5494 m
.02756 .5494 L
s
.02381 .57376 m
.02756 .57376 L
s
.02381 .59811 m
.02756 .59811 L
s
.02381 .01356 m
.02756 .01356 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .42762 m
.02605 .42762 L
.02846 .42762 L
.02962 .42762 L
.03072 .42762 L
.03171 .42762 L
.03279 .42762 L
.03527 .42763 L
.0379 .42763 L
.03898 .42763 L
.04014 .42764 L
.04142 .42764 L
.04262 .42765 L
.04516 .42766 L
.0465 .42767 L
.04723 .42767 L
.04793 .42768 L
.0493 .42769 L
.05054 .4277 L
.05297 .42772 L
.05749 .42777 L
.06244 .42784 L
.06757 .42794 L
.07299 .42807 L
.08269 .42837 L
.09401 .42885 L
.10458 .42945 L
.12493 .43108 L
.14349 .43316 L
.16257 .43601 L
.18333 .43993 L
.22412 .45037 L
.26338 .46384 L
.30113 .47924 L
.34134 .49573 L
.38002 .51089 L
.42116 .52979 L
.46079 .54946 L
.4989 .56758 L
.53946 .58392 L
.55819 .59005 L
.5785 .59556 L
.58961 .59798 L
.59985 .59984 L
.60964 .60128 L
.61505 .6019 L
.62 .60239 L
.62484 .60276 L
.62944 .60302 L
.63179 .60312 L
Mistroke
.63307 .60318 L
.63429 .60323 L
.63498 .60325 L
.63573 .60326 L
.63703 .60327 L
.63957 .6033 L
.64064 .60331 L
.64179 .60332 L
.64305 .60332 L
.64422 .60328 L
.64674 .60319 L
.64797 .60314 L
.64912 .6031 L
.65019 .60306 L
.65132 .60296 L
.65245 .60278 L
.65371 .60259 L
.65587 .60225 L
.65789 .60194 L
.65903 .60173 L
.66024 .60139 L
.66282 .60068 L
.66801 .59908 L
.67727 .59508 L
.68821 .58876 L
.69814 .58156 L
.71737 .56345 L
.73818 .53853 L
.77915 .47506 L
.8186 .40113 L
.85654 .32117 L
.89693 .22674 L
.93581 .12706 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00O4Woo00<007ooOol0
ogoo37oo000BOol00`00Oomoo`3oOol<Ool0019oo`03001oogoo0?moo`aoo`004Woo0P00lGoo00=l
07ooOol067oo000BOol00`00Oomoo`3`Ool00g`0Oomoo`0HOol0019oo`03001oogoo0>moo`03O01o
ogoo01Uoo`004Woo00<007ooOol0kgoo00=l07ooOol06Goo000:Ool20006Ool00`00Oomoo`3_Ool0
0g`0Oomoo`0IOol000Uoo`04001oogoo0005Ool00`00Oomoo`3^Ool00g`0Oomoo`0JOol000Uoo`04
001oogoo0005Ool2003_Ool00g`0Oomoo`0JOol000=oo`@000=oo`8000Ioo`03001oogoo0>ioo`03
O01oogoo01Yoo`002Goo00@007ooOol000Eoo`03001oogoo0>eoo`03O01oogoo01]oo`002Woo0P00
1Woo00<007ooOol0kGoo00=l07ooOol06goo000BOol00`00Oomoo`3]Ool00g`0Oomoo`0KOol0019o
o`03001oogoo0>aoo`03O01oogoo01aoo`004Woo0P00kGoo00=l07ooOol077oo000BOol00`00Oomo
o`3/Ool00g`0Oomoo`0LOol0019oo`03001oogoo0>]oo`03O01oogoo01eoo`004Woo00<007ooOol0
jgoo00=l07ooOol07Goo000BOol00`00Oomoo`3ZOol00g`0Oomoo`0NOol0019oo`03001oogoo0>Yo
o`03O01oogoo01ioo`004Woo00<007ooOol0jWoo00=l07ooOol07Woo000BOol2003ZOol00g`0Oomo
o`0OOol0019oo`03001oogoo0>Uoo`03O01oogoo01moo`004Woo00<007ooOol0jGoo00=l07ooOol0
7goo000BOol00`00Oomoo`3XOol00g`0Oomoo`0POol0019oo`03001oogoo0>Qoo`03O01oogoo021o
o`004Woo00<007ooOol0j7oo00=l07ooOol087oo000BOol2003XOol00g`0Oomoo`0QOol0019oo`03
001oogoo0>Moo`03O01oogoo025oo`004Woo00<007ooOol0igoo00=l07ooOol08Goo000BOol00`00
Oomoo`3VOol00g`0Oomoo`0ROol000Uoo`<000Ioo`03001oogoo0>Ioo`03O01oogoo029oo`002Goo
00@007ooOol000Eoo`03001oogoo0>Ioo`03O01oogoo029oo`002Goo00@007ooOol000Eoo`800>Io
o`03O01oogoo02=oo`000goo10000Woo0`001Woo00<007ooOol0iGoo00=l07ooOol08goo000:Ool0
0`00Oomoo`05Ool00`00Oomoo`3TOol00g`0Oomoo`0TOol000Yoo`<000Eoo`03001oogoo0>Aoo`03
O01oogoo02Aoo`004Woo00<007ooOol0i7oo00=l07ooOol097oo000BOol00`00Oomoo`3SOol00g`0
Oomoo`0UOol0019oo`800>Aoo`03O01oogoo02Eoo`004Woo00<007ooOol0hgoo00=l07ooOol09Goo
000BOol00`00Oomoo`3ROol00g`0Oomoo`0VOol0019oo`03001oogoo0>9oo`03O01oogoo02Ioo`00
4Woo00<007ooOol0hGoo00=l07ooOol09goo000BOol00`00Oomoo`3QOol00g`0Oomoo`0WOol0019o
o`03001oogoo0>5oo`03O01oogoo02Moo`004Woo0P00hGoo00=l07ooOol0:7oo000BOol00`00Oomo
o`3POol00g`0Oomoo`0XOol0019oo`03001oogoo0=moo`03O01oogoo02Uoo`004Woo00<007ooOol0
ggoo00=l07ooOol0:Goo000BOol00`00Oomoo`3OOol00g`0Oomoo`0YOol0019oo`03001oogoo0=io
o`03O01oogoo02Yoo`004Woo0P00ggoo00=l07ooOol0:Woo000BOol00`00Oomoo`3NOol00g`0Oomo
o`0ZOol0019oo`03001oogoo0=eoo`03O01oogoo02]oo`004Woo00<007ooOol0gGoo00=l07ooOol0
:goo000;Ool30004Ool00`00Oomoo`3LOol00g`0Oomoo`0/Ool000aoo`03001oogoo00=oo`03001o
ogoo0=aoo`03O01oogoo02aoo`002Goo1@0017oo0P00gGoo00=l07ooOol0;7oo0003Ool40002Ool0
1000Oomoo`001Goo00<007ooOol0fgoo00=l07ooOol0;Goo000:Ool00`00Ool00005Ool00`00Oomo
o`3KOol00g`0Oomoo`0]Ool000]oo`8000Eoo`03001oogoo0=Yoo`03O01oogoo02ioo`004Woo00<0
07ooOol0fWoo00=l07ooOol0;Woo000BOol00`00Oomoo`3JOol00g`0Oomoo`0^Ool0019oo`800=Yo
o`03O01oogoo02moo`004Woo00<007ooOol0fGoo00=l07ooOol0;goo000BOol00`00Oomoo`3HOol0
0g`0Oomoo`0`Ool0019oo`03001oogoo0=Qoo`03O01oogoo031oo`004Woo00<007ooOol0egoo00=l
07ooOol0<Goo000BOol00`00Oomoo`3GOol00g`0Oomoo`0aOol0019oo`03001oogoo0=Moo`03O01o
ogoo035oo`004Woo0P00egoo00=l07ooOol0<Woo000BOol00`00Oomoo`3FOol00g`0Oomoo`0bOol0
019oo`03001oogoo0=Eoo`03O01oogoo03=oo`004Woo00<007ooOol0eGoo00=l07ooOol0<goo000B
Ool00`00Oomoo`3EOol00g`0Oomoo`0cOol0019oo`03001oogoo0=Aoo`03O01oogoo03Aoo`004Woo
0P00eGoo00=l07ooOol0=7oo000BOol00`00Oomoo`3COol00g`0Oomoo`0eOol0019oo`03001oogoo
0==oo`03O01oogoo03Eoo`004Woo00<007ooOol0dWoo00=l07ooOol0=Woo0009Ool40005Ool00`00
Oomoo`3BOol00g`0Oomoo`0fOol000Uoo`03001oogoo00Ioo`03001oogoo0=9oo`03O01oogoo03Io
o`002Woo00<007ooOol01Goo0P00dWoo00=l07ooOol0=goo0003Ool40004Ool00`00Oomoo`04Ool0
0`00Oomoo`3AOol00g`0Oomoo`0gOol000Uoo`04001oogoo0005Ool00`00Oomoo`3@Ool00g`0Oomo
o`0hOol000Yoo`8000Ioo`03001oogoo0=1oo`03O01oogoo03Qoo`004Woo00<007ooOol0cgoo00=l
07ooOol0>Goo000BOol00`00Oomoo`3?Ool00g`0Oomoo`0iOol0019oo`800<moo`03O01oogoo03Yo
o`004Woo00<007ooOol0cWoo00=l07ooOol0>Woo000BOol00`00Oomoo`3=Ool00g`0Oomoo`0kOol0
019oo`03001oogoo0<eoo`03O01oogoo03]oo`004Woo00<007ooOol0c7oo00=l07ooOol0?7oo000B
Ool00`00Oomoo`3<Ool00g`0Oomoo`0lOol0019oo`800<aoo`03O01oogoo03eoo`004Woo00<007oo
Ool0bgoo00=l07ooOol0?Goo000BOol00`00Oomoo`0NOol20004Ool20003Ool4000JOol20004Ool2
0005Ool3000HOol20004Ool20003Ool3000KOol20004Ool20004Ool2000POol400000g`0Oomoo`0K
Ool50002Ool20003Ool4000COol0019oo`03001oogoo01eoo`04001oogoo0008Ool00`00Oomoo`0J
Ool01000Oomoo`002goo00<007ooOol05Woo00@007ooOol000Qoo`04001oogoo000IOol01000Oomo
o`0027oo00@007ooOol0025oo`03001oog`001moo`03001oogoo00Moo`03001oogoo01Aoo`004Woo
00<007ooOol07Goo00@007ooOol000Uoo`03001oogoo01Uoo`04001oogoo0008Ool5000GOol01000
Oomoo`0027oo00@007ooOol001Uoo`04001oogoo0008Ool01000Oomoo`008Goo00<007`0Ool07goo
00<007ooOol027oo00<007ooOol04goo000BOol00`00Oomoo`0MOol01000Oomoo`002Woo00<007oo
Ool067oo00@007ooOol000Qoo`04001oogoo000HOol01000Oomoo`0027oo0`006Woo00@007ooOol0
00Uoo`80029oo`03001l07oo01moo`03001oogoo00Uoo`03001oogoo019oo`004Woo00<007ooOol0
7Goo00@007ooOol000Qoo`04001oogoo000IOol01000Oomoo`002Goo00<007oo000067oo00@007oo
Ool000Uoo`03001oogoo01Uoo`04001oogoo0008Ool01000Oomoo`008Goo00=l07ooOol07goo00<0
07ooOol01goo00@007ooOol001=oo`004Woo0P007goo0P002Woo0P006goo0P002goo0P006Goo0P00
2Woo0`006Woo0P002Woo0P008Goo00=l0000Ool07goo0P002Woo0P0057oo000BOol00`00Oomoo`37
Ool00g`0Oomoo`11Ool0019oo`03001oogoo0<Ioo`03O01oogoo049oo`004Woo00<007ooOol0aWoo
00=l07ooOol0@Woo000BOol00`00Oomoo`35Ool00g`0Oomoo`0iOol20008Ool0019oo`03001oogoo
0<Eoo`03O01oogoo03Qoo`04001oogoo0007Ool000]oo`L001Ml0;000003O0000000030000Uoo`03
001oogoo00Qoo`004Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol02W`01goo00<007oo
Ool01goo00<007ooOol01goo00<007ooOol027oo00<007ooOol01goo00<007ooOol01goo00<007oo
Ool01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol027oo00<007ooOol01goo00<007oo
Ool01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007oo
Ool017oo00El07ooOomoo`0000Uoo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00aoo`D000Moo`004Woo00<007ooOol07Woo1G`00Woo00<007ooOol09Woo00<007ooOol0
9Goo00<007ooOol09Woo00<007ooOol08Goo00=l07ooOol00Woo00<007ooOol09Goo00<007ooOol0
3Goo00<007ooOol027oo000BOol00`00Oomoo`0SOol4O02LOol00g`0Oomoo`15Ool0019oo`03001o
ogoo02Moo`Al09Moo`03O01oogoo04Ioo`004Woo00<007ooOol0:goo17`0Tgoo00=l07ooOol0AWoo
000BOol2000`Ool3O02?Ool00g`0Oomoo`17Ool0019oo`03001oogoo039oo`Al08]oo`03O01oogoo
04Moo`004Woo00<007ooOol0=Woo0g`0Qgoo00=l07ooOol0B7oo000BOol00`00Oomoo`0iOol3O024
Ool00g`0Oomoo`18Ool0019oo`03001oogoo03aoo`9l085oo`03O01oogoo04Uoo`004Woo00<007oo
Ool0?Woo0g`0OWoo00=l07ooOol0BGoo000BOol20012Ool2O01kOol00g`0Oomoo`1:Ool0019oo`03
001oogoo04=oo`=l07Moo`03O01oogoo04]oo`004Woo00<007ooOol0AWoo0W`0MGoo00=l07ooOol0
Bgoo000BOol00`00Oomoo`18Ool3O01aOol00g`0Oomoo`1<Ool0019oo`03001oogoo04]oo`9l06io
o`03O01oogoo04eoo`004Woo00<007ooOol0CGoo0g`0Jgoo00=l07ooOol0CGoo000BOol00`00Oomo
o`1@Ool2O01XOol00g`0Oomoo`1>Ool0019oo`8005=oo`=l06Aoo`03O01oogoo04moo`004Woo00<0
07ooOol0EGoo0W`0HWoo00=l07ooOol0Cgoo000BOol00`00Oomoo`1GOol3O01NOol00g`0Oomoo`1@
Ool0019oo`03001oogoo05Yoo`9l05]oo`03O01oogoo055oo`002Goo10001Goo00<007ooOol0G7oo
0W`0F7oo00=l07ooOol0DWoo0009Ool00`00Oomoo`06Ool00`00Oomoo`1NOol2O01FOol00g`0Oomo
o`1BOol000Yoo`03001oogoo00Eoo`80065oo`9l05=oo`03O01oogoo05=oo`002goo00<007ooOol0
17oo00<007ooOol0HWoo0W`0D7oo00=l07ooOol0E7oo0009Ool01000Oomoo`001Goo00<007ooOol0
I7oo0W`0CWoo00=l07ooOol0E7oo000:Ool20006Ool00`00Oomoo`1VOol2O01;Ool00g`0Oomoo`1E
Ool0019oo`03001oogoo06Qoo`9l04Qoo`03O01oogoo05Ioo`004Woo00<007ooOol0JWoo0W`0AWoo
00=l07ooOol0EWoo000BOol2001]Ool2O013Ool00g`0Oomoo`1GOol0019oo`03001oogoo06ioo`9l
041oo`03O01oogoo05Qoo`004Woo00<007ooOol0L7oo0W`0?Goo00=l07ooOol0FGoo000BOol00`00
Oomoo`1bOol2O00kOol00g`0Oomoo`1IOol0019oo`03001oogoo07Aoo`9l03Qoo`03O01oogoo05Yo
o`004Woo00<007ooOol0MWoo0W`0=Goo00=l07ooOol0Fgoo000BOol2001iOol2O00aOol2O01NOol0
019oo`03001oogoo07Yoo`=l02eoo`03O01oogoo05ioo`004Woo00<007ooOol0OGoo0W`0:Woo00=l
07ooOol0Ggoo000BOol00`00Oomoo`1oOol4O00TOol2O01ROol0019oo`03001oogoo08=oo`Al01mo
o`03O01oogoo069oo`004Woo00<007ooOol0Qgoo0W`077oo00=l07ooOol0Hgoo000BOol00`00Oomo
o`29Ool6O00DOol2O01VOol0019oo`80091oo`Il00Yoo`Al06Qoo`004Woo00<007ooOol0UGoo2W`0
K7oo000BOol00`00Oomoo`3oOol<Ool0019oo`03001oogoo0?moo`aoo`004Woo00<007ooOol0ogoo
37oo000BOol00`00Oomoo`3oOol<Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo
8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`004Goo1000ogoo37oo000@
Ool01000Oomoo`00ogoo3Goo000@Ool01000Oomoo`00ogoo3Goo000?Ool200000goo0000003oOol=
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0891134, -8.7784, \
0.00492726, 0.0802771}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[AAcute]ximo Desplazamiento: \
"\[InvisibleSpace]3.6070324809559384`\),
      SequenceForm[ "M\[AAcute]ximo Desplazamiento: ", 3.6070324809559384],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[IAcute]nimo Desplazamiento: \
"\[InvisibleSpace]\(-8.476254579988822`\)\),
      SequenceForm[ "M\[IAcute]nimo Desplazamiento: ", -8.4762545799888223],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Velocidades:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.793651 0.366554 0.0291489 [
[.18254 .35405 -9 -9 ]
[.18254 .35405 9 0 ]
[.34127 .35405 -9 -9 ]
[.34127 .35405 9 0 ]
[.5 .35405 -9 -9 ]
[.5 .35405 9 0 ]
[.65873 .35405 -9 -9 ]
[.65873 .35405 9 0 ]
[.81746 .35405 -3 -9 ]
[.81746 .35405 3 0 ]
[.97619 .35405 -9 -9 ]
[.97619 .35405 9 0 ]
[1.025 .36655 0 -6.25 ]
[1.025 .36655 10 6.25 ]
[.01131 .07506 -18 -4.5 ]
[.01131 .07506 0 4.5 ]
[.01131 .22081 -12 -4.5 ]
[.01131 .22081 0 4.5 ]
[.01131 .5123 -6 -4.5 ]
[.01131 .5123 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .36655 m
.18254 .3728 L
s
[(0.2)] .18254 .35405 0 1 Mshowa
.34127 .36655 m
.34127 .3728 L
s
[(0.4)] .34127 .35405 0 1 Mshowa
.5 .36655 m
.5 .3728 L
s
[(0.6)] .5 .35405 0 1 Mshowa
.65873 .36655 m
.65873 .3728 L
s
[(0.8)] .65873 .35405 0 1 Mshowa
.81746 .36655 m
.81746 .3728 L
s
[(1)] .81746 .35405 0 1 Mshowa
.97619 .36655 m
.97619 .3728 L
s
[(1.2)] .97619 .35405 0 1 Mshowa
.125 Mabswid
.06349 .36655 m
.06349 .3703 L
s
.10317 .36655 m
.10317 .3703 L
s
.14286 .36655 m
.14286 .3703 L
s
.22222 .36655 m
.22222 .3703 L
s
.2619 .36655 m
.2619 .3703 L
s
.30159 .36655 m
.30159 .3703 L
s
.38095 .36655 m
.38095 .3703 L
s
.42063 .36655 m
.42063 .3703 L
s
.46032 .36655 m
.46032 .3703 L
s
.53968 .36655 m
.53968 .3703 L
s
.57937 .36655 m
.57937 .3703 L
s
.61905 .36655 m
.61905 .3703 L
s
.69841 .36655 m
.69841 .3703 L
s
.7381 .36655 m
.7381 .3703 L
s
.77778 .36655 m
.77778 .3703 L
s
.85714 .36655 m
.85714 .3703 L
s
.89683 .36655 m
.89683 .3703 L
s
.93651 .36655 m
.93651 .3703 L
s
.25 Mabswid
0 .36655 m
1 .36655 L
s
gsave
1.025 .36655 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .07506 m
.03006 .07506 L
s
[(-10)] .01131 .07506 1 0 Mshowa
.02381 .22081 m
.03006 .22081 L
s
[(-5)] .01131 .22081 1 0 Mshowa
.02381 .5123 m
.03006 .5123 L
s
[(5)] .01131 .5123 1 0 Mshowa
.125 Mabswid
.02381 .10421 m
.02756 .10421 L
s
.02381 .13336 m
.02756 .13336 L
s
.02381 .16251 m
.02756 .16251 L
s
.02381 .19166 m
.02756 .19166 L
s
.02381 .24996 m
.02756 .24996 L
s
.02381 .27911 m
.02756 .27911 L
s
.02381 .30826 m
.02756 .30826 L
s
.02381 .3374 m
.02756 .3374 L
s
.02381 .3957 m
.02756 .3957 L
s
.02381 .42485 m
.02756 .42485 L
s
.02381 .454 m
.02756 .454 L
s
.02381 .48315 m
.02756 .48315 L
s
.02381 .04592 m
.02756 .04592 L
s
.02381 .01677 m
.02756 .01677 L
s
.02381 .54145 m
.02756 .54145 L
s
.02381 .5706 m
.02756 .5706 L
s
.02381 .59975 m
.02756 .59975 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 0 r
.5 Mabswid
.02381 .36655 m
.02605 .36663 L
.02846 .36672 L
.02962 .36676 L
.03072 .3668 L
.03171 .36684 L
.03279 .36695 L
.04262 .36822 L
.04762 .36911 L
.05293 .37043 L
.06244 .37326 L
.0728 .37724 L
.0825 .38177 L
.10458 .39464 L
.14335 .42482 L
.18458 .46437 L
.22428 .50565 L
.26248 .54442 L
.27261 .55297 L
.28215 .55908 L
.28743 .56167 L
.29021 .56271 L
.29173 .56328 L
.29315 .56381 L
.29435 .56414 L
.29563 .56439 L
.29834 .56494 L
.30062 .56539 L
.30191 .5656 L
.30312 .56563 L
.30569 .5657 L
.30711 .56574 L
.30841 .56578 L
.30955 .5658 L
.31076 .56563 L
.3133 .56527 L
.31585 .5649 L
.31659 .56479 L
.31728 .56469 L
.31858 .56432 L
.32158 .56338 L
.32436 .56251 L
.3268 .56151 L
.32939 .56027 L
.33402 .55793 L
.33949 .55441 L
.34448 .55068 L
.3468 .54882 L
.34802 .54784 L
.34932 .54687 L
Mistroke
.35058 .54666 L
.35171 .54648 L
.35392 .54612 L
.35514 .54592 L
.35643 .54571 L
.35711 .5456 L
.35785 .54611 L
.35914 .54706 L
.36406 .55067 L
.38237 .56753 L
.40356 .58466 L
.41358 .59128 L
.42285 .59643 L
.43244 .60037 L
.43505 .60121 L
.43633 .60163 L
.4375 .60186 L
.43873 .60208 L
.44005 .60231 L
.44287 .60281 L
.44397 .603 L
.44516 .60311 L
.44627 .60314 L
.44728 .60317 L
.44979 .60325 L
.45089 .60328 L
.4521 .60332 L
.45327 .60323 L
.4545 .60309 L
.4571 .60279 L
.45828 .60265 L
.45954 .60251 L
.46062 .60234 L
.46181 .60204 L
.46431 .60139 L
.46704 .60069 L
.472 .59888 L
.48129 .59442 L
.49207 .58745 L
.5022 .57888 L
.54086 .53739 L
.58196 .47986 L
.60247 .44619 L
.62156 .41184 L
.63102 .39379 L
.63996 .37612 L
.6449 .36231 L
.6475 .35211 L
.64893 .34653 L
.65026 .3413 L
Mistroke
.65138 .33551 L
.65258 .32789 L
.65513 .3117 L
.65963 .28259 L
Mfstroke
.65963 .28259 m
.69979 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00O5Goo00<007ooOol0
ZGoo00<3h7ooOol0G7oo000EOol00`00Oomoo`2YOol00`?POomoo`1LOol001Eoo`03001oogoo0:Uo
o`030n1oogoo05aoo`005Goo00<007ooOol0ZGoo00<3h7ooOol0G7oo000EOol2002YOol00`?POomo
o`1MOol001Eoo`03001oogoo0:Qoo`030n1oogoo05eoo`005Goo00<007ooOol0Z7oo00<3h7ooOol0
GGoo000EOol00`00Oomoo`2XOol00`?POomoo`1MOol001Eoo`03001oogoo0:Qoo`030n1oogoo05eo
o`005Goo00<007ooOol0Z7oo00<3h7ooOol0GGoo000EOol00`00Oomoo`2XOol00`?POomoo`1MOol0
01Eoo`800:Qoo`030n1oogoo05ioo`005Goo00<007ooOol0Ygoo00<3h7ooOol0GWoo000EOol00`00
Oomoo`2WOol00`?POomoo`1NOol001Eoo`03001oogoo0:Moo`030n1oogoo05ioo`005Goo00<007oo
Ool0Ygoo00<3h7ooOol0GWoo000EOol00`00Oomoo`2WOol00`?POomoo`1NOol000Moo`D0009oo`80
00Eoo`03001oogoo0:Moo`030n1oogoo05ioo`002Goo00D007ooOomoo`00009oo`03001oogoo009o
o`03001oogoo0:Moo`030n1oogoo05ioo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`80
0:Moo`030n1oogoo05moo`0000=oo`0000000P0017oo00D007ooOomoo`00009oo`03001oogoo009o
o`03001oogoo0:Ioo`030n1oogoo05moo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`03
001oogoo0:Ioo`030n1oogoo05moo`0027oo0P0017oo0P001Goo00<007ooOol0YWoo00<3h7ooOol0
Ggoo000EOol00`00Oomoo`2VOol00`?POomoo`1OOol001Eoo`03001oogoo0:Ioo`030n1oogoo05mo
o`005Goo00<007ooOol0YWoo00<3h7ooOol0Ggoo000EOol2002VOol00`?POomoo`1POol001Eoo`03
001oogoo0:Eoo`030n1oogoo061oo`005Goo00<007ooOol0YGoo00<3h7ooOol0H7oo000EOol00`00
Oomoo`2UOol00`?POomoo`1POol001Eoo`03001oogoo0:Eoo`030n1oogoo061oo`005Goo00<007oo
Ool0YGoo00<3h7ooOol0H7oo000EOol00`00Oomoo`2UOol00`?POomoo`1POol001Eoo`03001oogoo
0:Aoo`030n1oogoo065oo`005Goo0P00YGoo00<3h7ooOol0HGoo000EOol00`00Oomoo`2TOol00`?P
Oomoo`1QOol001Eoo`03001oogoo0:Aoo`030n1oogoo065oo`005Goo00<007ooOol0Y7oo00<3h7oo
Ool0HGoo000EOol00`00Oomoo`2TOol00`?POomoo`1QOol001Eoo`03001oogoo0:Aoo`030n1oogoo
065oo`005Goo00<007ooOol0Xgoo00<3h7ooOol0HWoo000EOol2002TOol00`?POomoo`1ROol001Eo
o`03001oogoo0:=oo`030n1oogoo069oo`005Goo00<007ooOol0Xgoo00<3h7ooOol0HWoo000EOol0
0`00Oomoo`2SOol00`?POomoo`1ROol001Eoo`03001oogoo0:=oo`030n1oogoo069oo`005Goo00<0
07ooOol0Xgoo00<3h7ooOol0HWoo000EOol00`00Oomoo`2ROol00`?POomoo`1SOol001Eoo`03001o
ogoo0:9oo`030n1oogoo06=oo`005Goo0P00Xgoo00<3h7ooOol0Hgoo000EOol00`00Oomoo`2ROol0
0`?POomoo`1SOol001Eoo`03001oogoo0:9oo`030n1oogoo06=oo`005Goo00<007ooOol0XWoo00<3
h7ooOol0Hgoo000EOol00`00Oomoo`2ROol00`?POomoo`1SOol000ioo`8000Eoo`03001oogoo0:9o
o`030n1oogoo06=oo`003Goo00@007ooOol000Aoo`03001oogoo0:5oo`030n1oogoo06Aoo`0047oo
00<007ooOol00Woo0P00XWoo00<3h7ooOol0I7oo0007Ool40003Ool20005Ool00`00Oomoo`2QOol0
0`?POomoo`1TOol000ioo`03001oogoo00Aoo`03001oogoo0:5oo`030n1oogoo06Aoo`003Woo0`00
17oo00<007ooOol0XGoo00<3h7ooOol0I7oo000EOol00`00Oomoo`2QOol00`?POomoo`1TOol001Eo
o`03001oogoo0:5oo`030n1oogoo06Aoo`005Goo00<007ooOol0X7oo00<3h7ooOol0IGoo000EOol2
002QOol00`?POomoo`1UOol001Eoo`03001oogoo0:1oo`030n1oogoo06Eoo`005Goo00<007ooOol0
X7oo00<3h7ooOol0IGoo000EOol00`00Oomoo`2POol00`?POomoo`1UOol001Eoo`03001oogoo0:1o
o`030n1oogoo06Eoo`005Goo00<007ooOol0X7oo00<3h7ooOol0IGoo000EOol00`00Oomoo`2OOol0
0`?POomoo`1VOol001Eoo`03001oogoo09moo`030n1oogoo06Ioo`005Goo0P00X7oo00<3h7ooOol0
IWoo000EOol00`00Oomoo`2OOol00`?POomoo`1VOol001Eoo`03001oogoo09moo`030n1oogoo06Io
o`005Goo00<007ooOol0Wgoo00<3h7ooOol0IWoo000EOol00`00Oomoo`2OOol00`?POomoo`1VOol0
01Eoo`03001oogoo09ioo`030n1oogoo06Moo`005Goo00<007ooOol0WWoo00<3h7ooOol0Igoo000E
Ool2002OOol00`?POomoo`1WOol001Eoo`03001oogoo09ioo`030n1oogoo06Moo`005Goo00<007oo
Ool0WWoo00<3h7ooOol0Igoo000EOol00`00Oomoo`2NOol00`?POomoo`1WOol001Eoo`03001oogoo
01ioo`8000Aoo`8000=oo`@001Yoo`8000Aoo`8000Eoo`<001Qoo`8000Aoo`8000=oo`<001]oo`80
00=oo`030n00000000Aoo`8001moo`D001ioo`D0009oo`8000=oo`@0011oo`005Goo00<007ooOol0
7Goo00@007ooOol000Qoo`03001oogoo01Yoo`04001oogoo000;Ool00`00Oomoo`0FOol01000Oomo
o`0027oo00@007ooOol001Uoo`04001oogoo0002Ool00`?POomoo`03Ool01000Oomoo`0087oo00<0
07ooOol087oo00<007ooOol01goo00<007ooOol04Goo000EOol00`00Oomoo`0MOol01000Oomoo`00
2Goo00<007ooOol06Goo00@007ooOol000Qoo`D001Moo`04001oogoo0008Ool01000Oomoo`006Goo
00@007ooOol0009oo`030n1oogoo00=oo`04001oogoo000POol00`00Oomoo`0POol00`00Oomoo`08
Ool00`00Oomoo`0@Ool001Eoo`03001oogoo01eoo`04001oogoo000:Ool00`00Oomoo`0HOol01000
Oomoo`0027oo00@007ooOol001Qoo`04001oogoo0008Ool3000JOol01000Oomoo`000Woo00<3h7oo
Ool017oo0P008Goo00<007ooOol087oo00<007ooOol02Goo00<007ooOol03goo000EOol2000NOol0
1000Oomoo`0027oo00@007ooOol001Uoo`04001oogoo0009Ool00`00Ool0000HOol01000Oomoo`00
2Goo00<007ooOol06Goo00@007ooOol0009oo`030n1oogoo00=oo`04001oogoo000POol00`00Oomo
o`0POol00`00Oomoo`07Ool01000Oomoo`0047oo000EOol00`00Oomoo`0NOol2000:Ool2000KOol2
000;Ool2000IOol2000:Ool3000JOol20003Ool00`?POomoo`04Ool2000POol2000QOol2000:Ool2
000AOol001Eoo`03001oogoo09aoo`030n1oogoo06Uoo`005Goo00<007ooOol0W7oo00<3h7ooOol0
JGoo000EOol00`00Oomoo`2LOol00`?POomoo`1YOol001Eoo`03001oogoo09aoo`030n1oogoo06Uo
o`005Goo00<007ooOol0Vgoo00<3h7ooOol0Hgoo0P001Goo000?Ool600040n2J00000`?P0000001I
0009Ool01000Oomoo`0017oo000EOol01000Oomoogoo1@?P00=oo`00Ool027oo00<007ooOol01goo
00<007ooOol01goo00<007ooOol01goo00<007ooOol027oo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol027oo
00<007ooOol01goo00<007ooOol01goo00<007ooOol00goo00D3h7ooOomoo`0000Uoo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00eoo`03001oogoo00Eoo`005Goo00<007ooOol01Woo0`?P
77oo00<007ooOol09Woo00<007ooOol09Goo00<007ooOol08Goo00<3h7ooOol00Woo00<007ooOol0
9Goo00<007ooOol09Woo00<007ooOol037oo1@0017oo000EOol00`00Oomoo`09Ool20n2?Ool00`?P
Oomoo`1SOol00`00Oomoo`05Ool001Eoo`03001oogoo00]oo`83h8eoo`030n1oogoo06]oo`005Goo
00<007ooOol03Goo0P?PRWoo00<3h7ooOol0K7oo000EOol00`00Oomoo`0?Ool20n28Ool00`?POomo
o`1/Ool001Eoo`03001oogoo015oo`030n1oogoo08Aoo`030n1oogoo06eoo`005Goo0P004goo00<3
h7ooOol0PWoo00<3h7ooOol0KWoo000EOol00`00Oomoo`0COol20n22Ool00`?POomoo`1^Ool001Eo
o`03001oogoo01Eoo`030n1oogoo07ioo`030n1oogoo06moo`005Goo00<007ooOol05Woo00<3h7oo
Ool0OGoo00<3h7ooOol0Kgoo000EOol00`00Oomoo`0GOol00`?POomoo`1kOol00`?POomoo`1`Ool0
01Eoo`03001oogoo01Qoo`83h7]oo`030n1oogoo071oo`005Goo00<007ooOol06Woo00<3h7ooOol0
Mgoo00<3h7ooOol0LGoo000EOol2000LOol00`?POomoo`1fOol00`?POomoo`1aOol001Eoo`03001o
ogoo01aoo`030n1oogoo07Aoo`030n1oogoo079oo`005Goo00<007ooOol07Goo00<3h7ooOol0Lgoo
00<3h7ooOol0LWoo000EOol00`00Oomoo`0NOol00`?POomoo`1aOol00`?POomoo`1cOol001Eoo`03
001oogoo01moo`030n1oogoo071oo`030n1oogoo07=oo`005Goo00<007ooOol087oo0P?PKgoo00<3
h7ooOol0M7oo000EOol00`00Oomoo`0ROol00`?POomoo`1/Ool00`?POomoo`1dOol001Eoo`03001o
ogoo02=oo`030n1oogoo06Yoo`030n1oogoo07Eoo`005Goo0P009Goo00<3h7ooOol0JGoo00<3h7oo
Ool0MGoo000EOol00`00Oomoo`0UOol00`?POomoo`1WOol00`?POomoo`1fOol001Eoo`03001oogoo
02Ioo`030n1oogoo06Eoo`030n1oogoo07Moo`005Goo00<007ooOol09goo00<3h7ooOol0Hgoo00<3
h7ooOol0N7oo000EOol00`00Oomoo`0XOol00`?POomoo`1ROol00`?POomoo`1hOol001Eoo`03001o
ogoo02Uoo`030n1oogoo061oo`030n1oogoo07Uoo`005Goo00<007ooOol0:Woo00<3h7ooOol0GWoo
00<3h7ooOol0NWoo000EOol2000/Ool00`?POomoo`1LOol00`?POomoo`1kOol001Eoo`03001oogoo
02]oo`030n1oogoo05aoo`030n1oogoo07]oo`005Goo00<007ooOol0;7oo00<3h7ooOol0FWoo00<3
h7ooOol0O7oo000EOol00`00Oomoo`0]Ool00`?POomoo`1HOol00`?POomoo`1mOol001Eoo`03001o
ogoo02ioo`030n1oogoo05Moo`030n1oogoo07eoo`005Goo00<007ooOol0;goo00<3h7ooOol0EGoo
00<3h7ooOol0OWoo000>Ool20005Ool00`00Oomoo`0`Ool00`?POomoo`1COol00`?POomoo`1oOol0
00eoo`04001oogoo0004Ool00`00Oomoo`0aOol00`?POomoo`1BOol00`?POomoo`1oOol0011oo`03
001oogoo009oo`8003=oo`030n1oogoo051oo`030n1oogoo081oo`003Woo0P001Goo00<007ooOol0
<goo00<3h7ooOol0CWoo00<3h7ooOol0PGoo000>Ool00`00Oomoo`04Ool00`00Oomoo`0dOol00`?P
Oomoo`1=Ool00`?POomoo`21Ool000ioo`<000Aoo`03001oogoo03Eoo`030n1oogoo04]oo`030n1o
ogoo089oo`005Goo00<007ooOol0=Woo00<3h7ooOol0BGoo00<3h7ooOol0Pgoo000EOol00`00Oomo
o`0gOol00`?POomoo`18Ool00`?POomoo`23Ool001Eoo`03001oogoo03Qoo`030n1oogoo04Ioo`03
0n1oogoo08Aoo`005Goo0P00>Woo00<3h7ooOol0A7oo00<3h7ooOol0QGoo000EOol00`00Oomoo`0j
Ool00`?POomoo`0COol40n0[Ool00`?POomoo`26Ool001Eoo`03001oogoo03]oo`030n1oogoo011o
o`<3h0=oo`030n1oogoo02Moo`030n1oogoo08Moo`005Goo00<007ooOol0?7oo0P?P3goo00<3h7oo
Ool01Goo00<3h7ooOol09Goo00<3h7ooOol0R7oo000EOol00`00Oomoo`0nOol20n0<Ool00`?POomo
o`07Ool00`?POomoo`0SOol00`?POomoo`29Ool001Eoo`03001oogoo041oo`83h0Moo`<3h0Yoo`03
0n1oogoo02=oo`030n1oogoo08Uoo`005Goo00<007ooOol0@Goo2@?P3Goo00<3h7ooOol08Goo00<3
h7ooOol0RWoo000EOol2001IOol00`?POomoo`0OOol00`?POomoo`2;Ool001Eoo`03001oogoo05Uo
o`83h1ioo`030n1oogoo08aoo`005Goo00<007ooOol0Fgoo00<3h7ooOol06Woo00<3h7ooOol0SGoo
000EOol00`00Oomoo`1LOol20n0IOol00`?POomoo`2>Ool001Eoo`03001oogoo05ioo`030n1oogoo
01Aoo`83h95oo`005Goo00<007ooOol0Ggoo00<3h7ooOol04Woo00<3h7ooOol0TGoo000EOol00`00
Oomoo`1POol20n0AOol00`?POomoo`2BOol001Eoo`03001oogoo069oo`<3h0aoo`83h9Eoo`005Goo
0P00IWoo0`?P1Goo10?PUgoo000EOol00`00Oomoo`1WOol60n2KOol001Eoo`03001oogoo0?moo`Uo
o`005Goo00<007ooOol0ogoo2Goo000EOol00`00Oomoo`3oOol9Ool001Eoo`03001oogoo0?moo`Uo
o`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol00?moob5oo`00ogoo8Goo000DOol2003oOol;Ool001Aoo`800?moo`]oo`004goo00@007oo
Ool00?moo`Yoo`004Woo0P000Woo0P00ogoo2Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQ
Ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.104523, -12.5849, \
0.00493151, 0.134273}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[AAcute]xima Velocidad: \
"\[InvisibleSpace]8.122899755875176`\),
      SequenceForm[ "M\[AAcute]xima Velocidad: ", 8.1228997558751761],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[IAcute]nima Velocidad: \
"\[InvisibleSpace]\(-46.78032971505769`\)\),
      SequenceForm[ "M\[IAcute]nima Velocidad: ", -46.78032971505769],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Aceleraciones:"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.793651 0.528263 0.00263087 [
[.18254 .51576 -9 -9 ]
[.18254 .51576 9 0 ]
[.34127 .51576 -9 -9 ]
[.34127 .51576 9 0 ]
[.5 .51576 -9 -9 ]
[.5 .51576 9 0 ]
[.65873 .51576 -9 -9 ]
[.65873 .51576 9 0 ]
[.81746 .51576 -3 -9 ]
[.81746 .51576 3 0 ]
[.97619 .51576 -9 -9 ]
[.97619 .51576 9 0 ]
[1.025 .52826 0 -6.25 ]
[1.025 .52826 10 6.25 ]
[.01131 .00209 -24 -4.5 ]
[.01131 .00209 0 4.5 ]
[.01131 .13363 -24 -4.5 ]
[.01131 .13363 0 4.5 ]
[.01131 .26518 -24 -4.5 ]
[.01131 .26518 0 4.5 ]
[.01131 .39672 -18 -4.5 ]
[.01131 .39672 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .52826 m
.18254 .53451 L
s
[(0.2)] .18254 .51576 0 1 Mshowa
.34127 .52826 m
.34127 .53451 L
s
[(0.4)] .34127 .51576 0 1 Mshowa
.5 .52826 m
.5 .53451 L
s
[(0.6)] .5 .51576 0 1 Mshowa
.65873 .52826 m
.65873 .53451 L
s
[(0.8)] .65873 .51576 0 1 Mshowa
.81746 .52826 m
.81746 .53451 L
s
[(1)] .81746 .51576 0 1 Mshowa
.97619 .52826 m
.97619 .53451 L
s
[(1.2)] .97619 .51576 0 1 Mshowa
.125 Mabswid
.06349 .52826 m
.06349 .53201 L
s
.10317 .52826 m
.10317 .53201 L
s
.14286 .52826 m
.14286 .53201 L
s
.22222 .52826 m
.22222 .53201 L
s
.2619 .52826 m
.2619 .53201 L
s
.30159 .52826 m
.30159 .53201 L
s
.38095 .52826 m
.38095 .53201 L
s
.42063 .52826 m
.42063 .53201 L
s
.46032 .52826 m
.46032 .53201 L
s
.53968 .52826 m
.53968 .53201 L
s
.57937 .52826 m
.57937 .53201 L
s
.61905 .52826 m
.61905 .53201 L
s
.69841 .52826 m
.69841 .53201 L
s
.7381 .52826 m
.7381 .53201 L
s
.77778 .52826 m
.77778 .53201 L
s
.85714 .52826 m
.85714 .53201 L
s
.89683 .52826 m
.89683 .53201 L
s
.93651 .52826 m
.93651 .53201 L
s
.25 Mabswid
0 .52826 m
1 .52826 L
s
gsave
1.025 .52826 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .00209 m
.03006 .00209 L
s
[(-200)] .01131 .00209 1 0 Mshowa
.02381 .13363 m
.03006 .13363 L
s
[(-150)] .01131 .13363 1 0 Mshowa
.02381 .26518 m
.03006 .26518 L
s
[(-100)] .01131 .26518 1 0 Mshowa
.02381 .39672 m
.03006 .39672 L
s
[(-50)] .01131 .39672 1 0 Mshowa
.125 Mabswid
.02381 .0284 m
.02756 .0284 L
s
.02381 .05471 m
.02756 .05471 L
s
.02381 .08101 m
.02756 .08101 L
s
.02381 .10732 m
.02756 .10732 L
s
.02381 .15994 m
.02756 .15994 L
s
.02381 .18625 m
.02756 .18625 L
s
.02381 .21256 m
.02756 .21256 L
s
.02381 .23887 m
.02756 .23887 L
s
.02381 .29148 m
.02756 .29148 L
s
.02381 .31779 m
.02756 .31779 L
s
.02381 .3441 m
.02756 .3441 L
s
.02381 .37041 m
.02756 .37041 L
s
.02381 .42303 m
.02756 .42303 L
s
.02381 .44934 m
.02756 .44934 L
s
.02381 .47565 m
.02756 .47565 L
s
.02381 .50195 m
.02756 .50195 L
s
.02381 .55457 m
.02756 .55457 L
s
.02381 .58088 m
.02756 .58088 L
s
.02381 .60719 m
.02756 .60719 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .52826 m
.06244 .55269 L
.10458 .57567 L
.12507 .58475 L
.14415 .59174 L
.16254 .59696 L
.17284 .59923 L
.18221 .60088 L
.18704 .60153 L
.19216 .60214 L
.19654 .60255 L
.20135 .60289 L
.204 .60304 L
.20531 .60312 L
.20652 .60318 L
.2072 .60319 L
.20791 .6032 L
.20943 .60323 L
.21209 .60328 L
.21339 .60331 L
.21412 .60332 L
.2148 .60331 L
.21604 .60329 L
.21736 .60326 L
.21965 .60322 L
.22085 .6032 L
.22214 .60317 L
.22346 .6031 L
.22468 .60304 L
.2271 .6029 L
.23162 .6026 L
.23644 .60215 L
.24178 .60153 L
.25071 .60022 L
.25558 .59937 L
.25795 .5989 L
.26011 .59847 L
.26131 .59824 L
.26244 .5973 L
.26363 .59547 L
.26493 .59349 L
.2702 .5854 L
.27946 .57103 L
.30031 .53841 L
.3198 .50831 L
.33013 .49273 L
.33583 .48431 L
.34123 .47641 L
.34632 .46917 L
.34772 .46718 L
Mistroke
.34848 .46609 L
.3492 .46507 L
.34987 .47372 L
.3506 .48317 L
.35187 .49964 L
.35433 .53166 L
.35568 .54914 L
.35693 .56543 L
.35801 .57092 L
.35915 .5746 L
.36159 .58242 L
.36404 .5903 L
.36472 .59246 L
.36543 .59378 L
.36671 .5943 L
.36921 .59534 L
.37044 .59584 L
.37156 .5963 L
.37257 .59672 L
.37364 .59667 L
.37471 .59625 L
.37587 .5958 L
.37835 .59484 L
.37944 .59442 L
.38063 .59396 L
.38187 .59328 L
.38318 .59247 L
.38594 .59079 L
.39094 .5876 L
.40028 .58125 L
.41125 .5737 L
.41644 .57013 L
.41877 .56853 L
.42005 .56765 L
.42125 .56643 L
.42352 .56339 L
.42604 .56004 L
.43125 .5531 L
.44073 .54055 L
.46164 .51322 L
.48009 .48946 L
.49055 .47614 L
.49566 .46969 L
.49807 .46665 L
.49913 .46531 L
.50029 .46403 L
.50145 .46334 L
.50268 .4626 L
.50527 .46104 L
.50997 .45821 L
Mistroke
.52031 .45204 L
.5414 .43961 L
.58171 .41643 L
.6205 .39481 L
.63062 .38928 L
.63596 .38638 L
.63889 .38479 L
.64033 .38402 L
.64165 .3833 L
.64293 .38019 L
.64357 .35829 L
.64428 .33427 L
.64712 .23761 L
.64845 .19229 L
.64971 .14938 L
.65084 .11208 L
.65207 .10018 L
.65449 .07683 L
.65708 .05181 L
.65825 .04043 L
.6595 .03392 L
.66057 .0313 L
.66175 .0284 L
.6643 .02211 L
.66554 .01904 L
.66667 .01627 L
.66787 .01602 L
.66914 .01575 L
.67185 .01519 L
.67296 .01496 L
.67414 .01472 L
.67542 .01513 L
.67661 .01586 L
.68111 .01865 L
.68358 .02062 L
.68624 .02336 L
.69104 .02848 L
.70197 .04378 L
.72316 .08291 L
.74327 .131 L
.78153 .24581 L
.78391 .25374 L
.78521 .25806 L
.78642 .2643 L
.78773 .27278 L
.78917 .28208 L
.7917 .2984 L
.79294 .30643 L
.79412 .31172 L
.79517 .3133 L
Mistroke
.79632 .31501 L
.79867 .31853 L
.79991 .3204 L
.8006 .32143 L
.80126 .32241 L
.80201 .32294 L
.80269 .32299 L
.80404 .32309 L
.80699 .32332 L
.80821 .32341 L
.80951 .32351 L
.81027 .32327 L
.81095 .32304 L
.81228 .32261 L
.81474 .3218 L
.81604 .32137 L
.81675 .32114 L
.81741 .32092 L
.81861 .32114 L
.81993 .32142 L
.82225 .32191 L
.86114 .32844 L
.90249 .33486 L
.94233 .34086 L
.97619 .34581 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool000Moo`@000=oo`8000Aoo`800?moo`]oo`001goo00<007ooOol00goo00@007ooOol0009oo`04
001oogoo003oOol:Ool000Qoo`03001oogoo009oo`04001oogoo0002Ool01000Oomoo`0017oo0P00
ogoo17oo00000goo000000020004Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo
009oo`03001oogoo0?moo`=oo`001goo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`00
17oo00<007ooOol0ogoo0goo0008Ool20004Ool20004Ool20005Ool00`00Oomoo`2NOol301mQOol0
01]oo`03001oogoo09eoo`0501moogooOol07`1POol001]oo`03001oogoo09aoo`0301moogoo009o
o`807emoo`006goo00<007ooOol0W7oo00<07gooOol017oo00<07gooOol0G7oo000KOol2002MOol0
0`0OOomoo`04Ool00`0OOomoo`1LOol001]oo`03001oogoo09]oo`0301moogoo00Ioo`0301moogoo
05]oo`006goo00<007ooOol0Vgoo00<07gooOol01goo00<07gooOol0FWoo000KOol00`00Oomoo`2K
Ool00`0OOomoo`08Ool00`0OOomoo`1IOol001]oo`03001oogoo09]oo`0301moogoo00Uoo`0301mo
ogoo05Qoo`006goo00<007ooOol0Vgoo00<07gooOol02Goo00<07gooOol0F7oo000KOol2002LOol0
0`0OOomoo`0:Ool00`0OOomoo`1GOol001]oo`03001oogoo09]oo`0301moogoo00Yoo`0301moogoo
05Moo`006goo00<007ooOol0Vgoo00<07gooOol02goo00<07gooOol0EWoo000KOol00`00Oomoo`2J
Ool00`0OOomoo`0<Ool00`0OOomoo`1FOol001]oo`03001oogoo09Yoo`0301moogoo00eoo`0301mo
ogoo05Eoo`006goo00<007ooOol0VWoo00<07gooOol03Goo00<07gooOol0EGoo000KOol00`00Oomo
o`2JOol00`0OOomoo`0>Ool00`0OOomoo`1DOol001]oo`8009]oo`0301moogoo00ioo`0301moogoo
05Aoo`006goo00<007ooOol0VWoo00<07gooOol03Woo00<07gooOol0E7oo000KOol00`00Oomoo`2J
Ool00`0OOomoo`0?Ool00`0OOomoo`1COol001]oo`03001oogoo09Uoo`0301moogoo011oo`0301mo
ogoo05=oo`006goo00<007ooOol0VGoo00<07gooOol04Goo00<07gooOol0DWoo000KOol00`00Oomo
o`2IOol00`0OOomoo`0AOol00`0OOomoo`1BOol001]oo`8009Yoo`0301moogoo015oo`0301moogoo
059oo`006goo00<007ooOol0VGoo00<07gooOol04Woo00<07gooOol0DGoo000KOol00`00Oomoo`2I
Ool00`0OOomoo`0BOol00`0OOomoo`1AOol001]oo`03001oogoo09Uoo`0301moogoo01=oo`0301mo
ogoo051oo`006goo00<007ooOol0VGoo00<07gooOol04goo00<07gooOol0D7oo0007Ool50002Ool2
0004Ool20005Ool00`00Oomoo`2IOol00`0OOomoo`0DOol00`0OOomoo`1?Ool000Uoo`05001oogoo
Ool00002Ool01000Oomoo`000Woo00<007ooOol00Woo00<007ooOol0VGoo00<07gooOol057oo00<0
7gooOol0Cgoo0009Ool00`00Oomoo`04Ool01000Oomoo`000Woo00<007ooOol00Woo0P00VWoo00<0
7gooOol057oo00<07gooOol0Cgoo00000goo000000020004Ool00`00Oomoo`02Ool20003Ool01000
Oomoo`0017oo00<007ooOol0VGoo00<07gooOol05Goo00<07gooOol0CWoo0009Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool01000Oomoo`0017oo00<007ooOol0VGoo00<07gooOol05Goo00<07gooOol0
CWoo0008Ool20004Ool30003Ool20005Ool00`00Oomoo`2IOol00`0OOomoo`0EOol00`0OOomoo`1>
Ool001]oo`03001oogoo09Uoo`0301moogoo01Ioo`0301moogoo04eoo`006goo00<007ooOol0VGoo
00<07gooOol05Woo00<07gooOol0CGoo000KOol2002JOol00`0OOomoo`0FOol00`0OOomoo`1=Ool0
01]oo`03001oogoo09Uoo`0301moogoo01Moo`0301moogoo04aoo`006goo00<007ooOol0VGoo00<0
7gooOol05goo00<07gooOol0C7oo000KOol00`00Oomoo`2IOol00`0OOomoo`0GOol00`0OOomoo`1<
Ool001]oo`03001oogoo09Uoo`0301moogoo01Qoo`0301moogoo04]oo`006goo00<007ooOol0VGoo
00<07gooOol067oo00<07gooOol0Bgoo000KOol00`00Oomoo`2IOol00`0OOomoo`0HOol00`0OOomo
o`1;Ool001]oo`8009Yoo`0301moogoo01Uoo`0301moogoo04Yoo`006goo00<007ooOol0VGoo00<0
7gooOol06Goo00<07gooOol0BWoo000KOol00`00Oomoo`2IOol00`0OOomoo`0JOol00`0OOomoo`19
Ool001]oo`03001oogoo09Uoo`0301moogoo01Yoo`0301moogoo04Uoo`006goo00<007ooOol0VGoo
00<07gooOol06Woo00<07gooOol0BGoo000KOol00`00Oomoo`2IOol00`0OOomoo`0KOol00`0OOomo
o`18Ool001]oo`03001oogoo09Uoo`0301moogoo01]oo`0301moogoo04Qoo`006goo0P00VWoo00<0
7gooOol06goo00<07gooOol0B7oo000KOol00`00Oomoo`2HOol00`0OOomoo`0MOol00`0OOomoo`17
Ool001]oo`03001oogoo09Qoo`0301moogoo01eoo`0301moogoo04Moo`006goo00<007ooOol0V7oo
00<07gooOol07Goo00<07gooOol0Agoo000KOol00`00Oomoo`2HOol00`0OOomoo`0NOol00`0OOomo
o`16Ool001]oo`03001oogoo09Qoo`0301moogoo01ioo`0301moogoo04Ioo`006goo0P00VGoo00<0
7gooOol07Woo00<07gooOol0AWoo000KOol00`00Oomoo`2HOol00`0OOomoo`0OOol00`0OOomoo`15
Ool001]oo`03001oogoo09Qoo`0301moogoo01moo`0301moogoo04Eoo`006goo00<007ooOol0V7oo
00<07gooOol07goo00<07gooOol0AGoo000KOol00`00Oomoo`2HOol00`0OOomoo`0OOol00`0OOomo
o`15Ool000Moo`D0009oo`8000Aoo`8000Eoo`03001oogoo09Qoo`0301moogoo021oo`0301moogoo
04Aoo`002Goo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`2H
Ool00`0OOomoo`0POol00`0OOomoo`14Ool000Uoo`05001oogooOol00002Ool01000Oomoo`000Woo
00<007ooOol00Woo0P00VGoo00<07gooOol087oo00<07gooOol0A7oo00000goo000000020004Ool0
1@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo09Qoo`0301moogoo
021oo`0301moogoo04Aoo`002Goo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`02
Ool00`00Oomoo`2HOol00`0OOomoo`0POol00`0OOomoo`14Ool000Qoo`8000Aoo`8000Aoo`8000Eo
o`03001oogoo09Qoo`0301moogoo025oo`0301moogoo04=oo`006goo00<007ooOol0V7oo00<07goo
Ool08Goo00<07gooOol0@goo000KOol00`00Oomoo`2HOol00`0OOomoo`0QOol00`0OOomoo`13Ool0
01]oo`8009Qoo`0301moogoo029oo`0301moogoo04=oo`006goo00<007ooOol0Ugoo00<07gooOol0
8Woo00<07gooOol0@goo000KOol00`00Oomoo`2GOol00`0OOomoo`0ROol00`0OOomoo`13Ool001]o
o`03001oogoo09Moo`0301moogoo02=oo`0301moogoo049oo`006goo00<007ooOol0Ugoo00<07goo
Ool08goo00<07gooOol0@Woo000KOol00`00Oomoo`2GOol00`0OOomoo`0SOol00`0OOomoo`12Ool0
01]oo`03001oogoo09Moo`0301moogoo02=oo`0301moogoo049oo`006goo0P00V7oo00<07gooOol0
97oo00<07gooOol0@Goo000KOol00`00Oomoo`2GOol00`0OOomoo`0TOol<01lhOol001]oo`03001o
ogoo09Moo`0301moogoo031oo`L07c5oo`006goo00<007ooOol0Ugoo00<07gooOol0=goo1@0O;7oo
000KOol00`00Oomoo`2GOol00`0OOomoo`0lOol501lWOol001]oo`03001oogoo09Moo`0301moogoo
045oo`D07b9oo`006goo0P00V7oo00<07gooOol0AWoo1`0O6goo000KOol00`00Oomoo`2GOol00`0O
Oomoo`1=Ool401lGOol001]oo`03001oogoo09Moo`0301moogoo06Qoo`006goo00<007ooOol0Ugoo
00<07gooOol0J7oo000KOol00`00Oomoo`2GOol00`0OOomoo`1XOol001]oo`03001oogoo09Moo`03
01moogoo06Qoo`006goo00<007ooOol0Ugoo00<07gooOol0J7oo000KOol2002HOol00`0OOomoo`1X
Ool001]oo`03001oogoo09Moo`0301moogoo06Qoo`006goo00<007ooOol0Ugoo00<07gooOol0J7oo
000KOol00`00Oomoo`2FOol201mZOol001]oo`03001oogoo09Eoo`807f]oo`003Woo0P0017oo0P00
1Goo00<007ooOol0Tgoo0P0OKGoo000=Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo
095oo`807fmoo`0047oo00@007ooOol0009oo`03001oogoo009oo`80091oo`807g5oo`001goo1000
0goo0P000goo00@007ooOol000Aoo`03001oogoo08eoo`807g=oo`003Woo00<007ooOol00Woo00@0
07ooOol000Aoo`03001oogoo08]oo`807gEoo`003Woo0`000goo0P001Goo00<007ooOol0RGoo0P0O
Mgoo000KOol00`00Oomoo`28Ool00`0OOomoo`1gOol001]oo`03001oogoo08Ioo`807gYoo`006goo
0P00QGoo0P0OO7oo000KOol00`00Oomoo`23Ool00`0OOomoo`1lOol001]oo`03001oogoo085oo`80
7gmoo`006goo00<007ooOol0Ogoo0P0OPGoo000KOol00`00Oomoo`1nOol00`0OOomoo`21Ool001]o
o`03001oogoo07aoo`807hAoo`006goo00<007ooOol0NWoo0P0OQWoo000KOol2001jOol00`0OOomo
o`26Ool001]oo`03001oogoo07Moo`807hUoo`006goo00<007ooOol0MWoo00<07gooOol0RGoo000K
Ool00`00Oomoo`1dOol201n<Ool001]oo`03001oogoo04eoo`807bAoo`0301moogoo08aoo`006goo
00<007ooOol0CGoo0P0O8goo00<07gooOol0SGoo000KOol2001=Ool00`0OOol07`0ROol00`0OOomo
o`2>Ool001]oo`03001oogoo04aoo`0301moo`0O029oo`0301moogoo08ioo`006goo00<007ooOol0
7Goo0P0017oo0P000goo10006Goo0P0017oo00@07`00Ool07`=oo`<001Moo`80009oo`0401moo`00
0003Ool3000JOol20004Ool20004Ool2000OOol5000LOol50002Ool20003Ool4000@Ool001]oo`03
001oogoo01aoo`04001oogoo0008Ool00`00Oomoo`0IOol01000Oomoo`000Woo00D07gooOomoo`0O
00Aoo`03001oogoo01Eoo`06001oogoo001oo`0O1Woo00@007ooOol001Qoo`04001oogoo0008Ool0
1000Oomoo`0087oo00<007ooOol07Woo00<007ooOol01goo00<007ooOol04Goo000KOol00`00Oomo
o`0LOol01000Oomoo`002Goo00<007ooOol067oo00H007ooOol007oo01l5Ool00`0O00000003000F
Ool01@00Oomoo`0001l01goo00@007ooOol001Qoo`04001oogoo0008Ool01000Oomoo`0087oo00<0
07ooOol07Woo00<007ooOol027oo00<007ooOol047oo000KOol00`00Oomoo`0LOol01000Oomoo`00
2Woo00<007ooOol05goo00H007ooOol007oo01l5Ool01@0O001oogoo00005goo00@007ooOol07`Qo
o`<001Uoo`04001oogoo0009Ool2000QOol00`00Oomoo`0NOol00`00Oomoo`09Ool00`00Oomoo`0?
Ool001]oo`03001oogoo01aoo`04001oogoo0008Ool01000Oomoo`0067oo00D007ooOol0000O00Io
o`0501moo`00Ool0000GOol01000Ool07`002Goo00<007ooOol067oo00@007ooOol000Qoo`04001o
ogoo000POol00`00Oomoo`0NOol00`00Oomoo`07Ool01000Oomoo`0047oo000KOol2000NOol2000:
Ool2000JOol200000goo01moo`05Ool00`0OOomoo`02000HOol00`0001moo`09Ool3000IOol2000:
Ool2000POol2000OOol2000:Ool2000AOol001]oo`03001oogoo04Moo`0301moogoo00Eoo`0301mo
ogoo01Yoo`0301moogoo09=oo`006goo00<007ooOol0AWoo00<07gooOol01Woo00<07gooOol06Goo
00<07gooOol0U7oo000KOol00`00Oomoo`16Ool00`0OOomoo`06Ool00`0OOomoo`0HOol00`0OOomo
o`2EOol001]oo`03001oogoo04Eoo`0301moogoo00Moo`0301moogoo01Moo`0301moogoo09Ioo`00
6goo00<007ooOol0AGoo00<07gooOol01goo00<07gooOol05Woo00<07gooOol0Sgoo0P001Woo000E
Ool600000`0O0000001400000`0O0000000800000`0O0000000F00000`0O000000260008Ool01000
Oomoo`001Goo000KOol00`0001l07`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`0001moo`07Ool01000Oomoo`0O
1Woo00<007ooOol01goo00<007ooOol017oo00@07gooOol000Qoo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00aoo`03001oogoo00Ioo`006goo00@007ooOol07b=oo`03001oogoo01aoo`03
01moogoo00Ioo`04001oogoo01lFOol00`0OOomoo`0:Ool00`00Oomoo`0UOol00`00Oomoo`0UOol0
0`00Oomoo`0TOol00`00Oomoo`0;Ool50005Ool001]oo`04001oogooOol201loOol00`0OOomoo`0:
Ool00`0OOomoo`0COol00`0OOomoo`2AOol00`00Oomoo`06Ool001]oo`03001oogoo00=oo`0301mo
ogoo03]oo`0301moogoo00]oo`0301moogoo019oo`0301moogoo09]oo`006goo00<007ooOol017oo
0P0O>goo00<07gooOol02goo00<07gooOol04Woo00<07gooOol0Vgoo000KOol00`00Oomoo`06Ool0
0`0OOomoo`0gOol00`0OOomoo`0<Ool00`0OOomoo`0AOol00`0OOomoo`2LOol001]oo`8000Qoo`80
7cIoo`0301moogoo00eoo`0301moogoo011oo`0301moogoo09eoo`006goo00<007ooOol02Goo0P0O
<goo00<07gooOol03goo00<07gooOol03Woo00<07gooOol0WWoo000KOol00`00Oomoo`0;Ool201la
Ool00`0OOomoo`0?Ool00`0OOomoo`0=Ool00`0OOomoo`2OOol001]oo`03001oogoo00eoo`807bio
o`0301moogoo011oo`0301moogoo00aoo`807j5oo`006goo00<007ooOol03goo0P0O:goo00<07goo
Ool04Goo00<07gooOol02goo0P0OXWoo000KOol00`00Oomoo`0AOol201lYOol00`0OOomoo`0AOol0
0`0OOomoo`0:Ool00`0OOomoo`2ROol001]oo`8001Aoo`807bIoo`0301moogoo01=oo`0301moogoo
00Qoo`0301moogoo0:=oo`006goo00<007ooOol05Goo0`0O8goo00<07gooOol04goo00<07gooOol0
1Woo0P0OYWoo000KOol00`00Oomoo`0HOol201lPOol00`0OOomoo`0EOol00`0OOomoo`03Ool201nX
Ool001]oo`03001oogoo01Yoo`<07aeoo`0301moogoo01Eoo`0401moogooOol201nZOol001]oo`03
001oogoo01eoo`807aUoo`807aQoo`D07j]oo`006goo00<007ooOol07goo1P0O3goo1@0ObGoo000K
Ool00`00Oomoo`0UOol?01o>Ool001]oo`800?moo`Aoo`006goo00<007ooOol0ogoo0goo000KOol0
0`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo000IOol5
003oOol3Ool001Uoo`@00?moo`Aoo`0077oo00<007ooOol0ogoo0Woo000JOol3003oOol4Ool00?mo
ob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.137063, -206.855, \
0.00504942, 1.52325}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[AAcute]xima Aceleraci\[OAcute]n: "\
\[InvisibleSpace]28.530050915710234`\),
      SequenceForm[ 
      "M\[AAcute]xima Aceleraci\[OAcute]n: ", 28.530050915710234],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("M\[IAcute]nima Aceleraci\[OAcute]n: "\
\[InvisibleSpace]\(-195.23740530278565`\)\),
      SequenceForm[ 
      "M\[IAcute]nima Aceleraci\[OAcute]n: ", -195.23740530278565],
      Editable->False]], "Print"],

Cell[BoxData[
    \("fs"\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.793651 0.309017 0.0196201 [
[.18254 .29652 -9 -9 ]
[.18254 .29652 9 0 ]
[.34127 .29652 -9 -9 ]
[.34127 .29652 9 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -9 -9 ]
[.65873 .29652 9 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[1.025 .30902 0 -6.25 ]
[1.025 .30902 10 6.25 ]
[.01131 .01472 -18 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .11282 -18 -4.5 ]
[.01131 .11282 0 4.5 ]
[.01131 .21092 -12 -4.5 ]
[.01131 .21092 0 4.5 ]
[.01131 .40712 -6 -4.5 ]
[.01131 .40712 0 4.5 ]
[.01131 .50522 -12 -4.5 ]
[.01131 .50522 0 4.5 ]
[.01131 .60332 -12 -4.5 ]
[.01131 .60332 0 4.5 ]
[.02381 .64303 -8 0 ]
[.02381 .64303 8 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .30902 m
.18254 .31527 L
s
[(0.2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(0.4)] .34127 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.6)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(0.8)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1.2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.06349 .30902 m
.06349 .31277 L
s
.10317 .30902 m
.10317 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.22222 .30902 m
.22222 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30159 .30902 m
.30159 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.42063 .30902 m
.42063 .31277 L
s
.46032 .30902 m
.46032 .31277 L
s
.53968 .30902 m
.53968 .31277 L
s
.57937 .30902 m
.57937 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.69841 .30902 m
.69841 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.77778 .30902 m
.77778 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.89683 .30902 m
.89683 .31277 L
s
.93651 .30902 m
.93651 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .01472 m
.03006 .01472 L
s
[(-15)] .01131 .01472 1 0 Mshowa
.02381 .11282 m
.03006 .11282 L
s
[(-10)] .01131 .11282 1 0 Mshowa
.02381 .21092 m
.03006 .21092 L
s
[(-5)] .01131 .21092 1 0 Mshowa
.02381 .40712 m
.03006 .40712 L
s
[(5)] .01131 .40712 1 0 Mshowa
.02381 .50522 m
.03006 .50522 L
s
[(10)] .01131 .50522 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(15)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03434 m
.02756 .03434 L
s
.02381 .05396 m
.02756 .05396 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .0932 m
.02756 .0932 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .15206 m
.02756 .15206 L
s
.02381 .17168 m
.02756 .17168 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .23054 m
.02756 .23054 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .26978 m
.02756 .26978 L
s
.02381 .2894 m
.02756 .2894 L
s
.02381 .32864 m
.02756 .32864 L
s
.02381 .34826 m
.02756 .34826 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .3875 m
.02756 .3875 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .44636 m
.02756 .44636 L
s
.02381 .46598 m
.02756 .46598 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .52484 m
.02756 .52484 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .56408 m
.02756 .56408 L
s
.02381 .5837 m
.02756 .5837 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(fs) show
75.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.02605 .30902 L
.02846 .30902 L
.02962 .30902 L
.03072 .30902 L
.03171 .30902 L
.03279 .30903 L
.03527 .30905 L
.0379 .30907 L
.03898 .30908 L
.04014 .3091 L
.04142 .30912 L
.04262 .30915 L
.04516 .3092 L
.0465 .30922 L
.04723 .30924 L
.04793 .30926 L
.0493 .30931 L
.05054 .30935 L
.05297 .30944 L
.05749 .30965 L
.06244 .30993 L
.06757 .31033 L
.07299 .31083 L
.08269 .31205 L
.09401 .31397 L
.10458 .3164 L
.12493 .32295 L
.14349 .33135 L
.16257 .34281 L
.18333 .35859 L
.22412 .40066 L
.26338 .45492 L
.30113 .51694 L
.32211 .55224 L
.33129 .56732 L
.34134 .58336 L
.34606 .5906 L
.3511 .59732 L
.35355 .59975 L
.35475 .60094 L
.35586 .60204 L
.35687 .60304 L
.35793 .60332 L
.359 .60332 L
.36018 .60332 L
.38002 .60332 L
.42036 .60332 L
.45919 .60332 L
.50046 .60332 L
Mistroke
.54022 .60332 L
.57847 .60332 L
.59983 .60332 L
.61917 .60332 L
.62887 .60332 L
.63397 .60332 L
.63676 .60332 L
.63936 .60332 L
.64053 .60332 L
.64164 .60332 L
.64291 .60331 L
.64408 .60314 L
.64677 .60276 L
.64795 .60259 L
.64925 .6024 L
.65035 .60224 L
.65137 .60182 L
.65245 .60114 L
.65361 .60041 L
.6561 .59886 L
.65718 .59818 L
.65835 .59745 L
.65959 .59626 L
.66076 .59496 L
.66332 .5921 L
.66795 .58633 L
.6734 .5776 L
.67843 .56771 L
.68934 .54174 L
.69954 .51092 L
.71834 .43844 L
.739 .3378 L
.75761 .22937 L
.77787 .09576 L
.78321 .05786 L
.78451 .04865 L
.78519 .04381 L
.78591 .03947 L
.78671 .03691 L
.78744 .03456 L
.78889 .02994 L
.79124 .02242 L
.79253 .01828 L
.79376 .01472 L
.79445 .01472 L
.7952 .01472 L
.79652 .01472 L
.79909 .01472 L
.8192 .01472 L
.86009 .01472 L
Mistroke
.89946 .01472 L
.93731 .01472 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00O5Goo00<007ooOol0
ogoo2Goo000EOol00`00Oomoo`3oOol9Ool000Moo`D0009oo`8000Eoo`03001oogoo0?moo`Uoo`00
2Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo0?moo`Uoo`002Goo00<007ooOol0
17oo00<007ooOol00Woo0`00`Goo<0005goo00000goo000000020004Ool00`00Oomoo`02Ool20005
Ool00`00Oomoo`31Ool00`00Oomoo`14Ool000Uoo`03001oogoo009oo`03001oogoo00Aoo`03001o
ogoo0<5oo`03001oogoo04Aoo`0027oo0P0017oo0`0017oo00<007ooOol0`Goo00<007ooOol0A7oo
000EOol00`00Oomoo`30Ool00`00Oomoo`15Ool001Eoo`800<5oo`03001oogoo04Eoo`005Goo00<0
07ooOol0_goo00<007ooOol0AWoo000EOol00`00Oomoo`2oOol00`00Oomoo`16Ool001Eoo`03001o
ogoo0;moo`03001oogoo04Ioo`005Goo00<007ooOol0_goo00<007ooOol0AWoo000EOol20030Ool0
0`00Oomoo`16Ool001Eoo`03001oogoo0;ioo`03001oogoo04Moo`005Goo00<007ooOol0_Woo00<0
07ooOol0Agoo000EOol00`00Oomoo`2nOol00`00Oomoo`17Ool001Eoo`03001oogoo0;ioo`03001o
ogoo04Moo`005Goo0P00_goo00<007ooOol0Agoo000EOol00`00Oomoo`2nOol00`00Oomoo`17Ool0
01Eoo`03001oogoo0;eoo`03001oogoo04Qoo`005Goo00<007ooOol0_Goo00<007ooOol0B7oo000E
Ool00`00Oomoo`2mOol00`00Oomoo`18Ool001Eoo`800;ioo`03001oogoo04Qoo`005Goo00<007oo
Ool0_Goo00<007ooOol0B7oo000EOol00`00Oomoo`2mOol00`00Oomoo`18Ool000Moo`D0009oo`80
00Eoo`03001oogoo0;eoo`03001oogoo04Qoo`002Goo00D007ooOomoo`00009oo`03001oogoo009o
o`03001oogoo0;eoo`03001oogoo04Qoo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`<0
0;aoo`03001oogoo04Uoo`0000=oo`0000000P0017oo00D007ooOomoo`00009oo`03001oogoo009o
o`03001oogoo0;aoo`03001oogoo04Uoo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`03
001oogoo0;aoo`03001oogoo04Uoo`0027oo0P0017oo0P001Goo00<007ooOol0_7oo00<007ooOol0
BGoo000EOol00`00Oomoo`2lOol00`00Oomoo`19Ool001Eoo`800;eoo`03001oogoo04Uoo`005Goo
00<007ooOol0_7oo00<007ooOol0BGoo000EOol00`00Oomoo`2kOol00`00Oomoo`1:Ool001Eoo`03
001oogoo0;]oo`03001oogoo04Yoo`005Goo00<007ooOol0^goo00<007ooOol0BWoo000EOol2002l
Ool00`00Oomoo`1:Ool001Eoo`03001oogoo0;]oo`03001oogoo04Yoo`005Goo00<007ooOol0^goo
00<007ooOol0BWoo000EOol00`00Oomoo`2kOol00`00Oomoo`1:Ool001Eoo`03001oogoo0;Yoo`03
001oogoo04]oo`005Goo0P00^goo00<007ooOol0Bgoo000EOol00`00Oomoo`2jOol00`00Oomoo`1;
Ool001Eoo`03001oogoo0;Yoo`03001oogoo04]oo`005Goo00<007ooOol0^Woo00<007ooOol0Bgoo
000EOol00`00Oomoo`2jOol00`00Oomoo`1;Ool001Eoo`800;Yoo`03001oogoo04aoo`005Goo00<0
07ooOol0^Goo00<007ooOol0C7oo000EOol00`00Oomoo`2iOol00`00Oomoo`1<Ool000ioo`8000Eo
o`03001oogoo0;Uoo`03001oogoo04aoo`003Goo00@007ooOol000Aoo`03001oogoo0;Uoo`03001o
ogoo04aoo`0047oo00<007ooOol00Woo0`00^Goo00<007ooOol0C7oo0007Ool40003Ool20005Ool0
0`00Oomoo`2iOol00`00Oomoo`1<Ool000ioo`03001oogoo00Aoo`03001oogoo0;Qoo`03001oogoo
04eoo`003Woo0`0017oo00<007ooOol0^7oo00<007ooOol0CGoo000EOol00`00Oomoo`2hOol00`00
Oomoo`1=Ool001Eoo`800;Uoo`03001oogoo04eoo`005Goo00<007ooOol0^7oo00<007ooOol0CGoo
000EOol00`00Oomoo`2hOol00`00Oomoo`1=Ool001Eoo`03001oogoo0;Moo`03001oogoo04ioo`00
5Goo00<007ooOol0]goo00<007ooOol0CWoo000EOol2002hOol00`00Oomoo`1>Ool001Eoo`03001o
ogoo0;Moo`03001oogoo04ioo`005Goo00<007ooOol0]goo00<007ooOol0CWoo000EOol00`00Oomo
o`2gOol00`00Oomoo`1>Ool001Eoo`03001oogoo01moo`8000Aoo`8000=oo`@001Uoo`8000Aoo`80
00Eoo`<001Qoo`8000Aoo`8000=oo`<001]oo`8000Aoo`8000Aoo`80011oo`03001oogoo00aoo`D0
01ioo`D0009oo`8000=oo`@0011oo`005Goo0P007goo00@007ooOol000Qoo`03001oogoo01Uoo`04
001oogoo000;Ool00`00Oomoo`0FOol01000Oomoo`0027oo00@007ooOol001Uoo`04001oogoo0008
Ool01000Oomoo`003goo00<007ooOol03Woo00<007ooOol087oo00<007ooOol01goo00<007ooOol0
4Goo000EOol00`00Oomoo`0NOol01000Oomoo`002Goo00<007ooOol067oo00@007ooOol000Qoo`D0
01Moo`04001oogoo0008Ool01000Oomoo`006Goo00@007ooOol000Qoo`04001oogoo000?Ool00`00
Oomoo`0>Ool00`00Oomoo`0POol00`00Oomoo`08Ool00`00Oomoo`0@Ool001Eoo`03001oogoo01io
o`04001oogoo000:Ool00`00Oomoo`0GOol01000Oomoo`0027oo00@007ooOol001Qoo`04001oogoo
0008Ool3000JOol01000Oomoo`002Goo0P0047oo00<007ooOol03Woo00<007ooOol087oo00<007oo
Ool02Goo00<007ooOol03goo000EOol00`00Oomoo`0NOol01000Oomoo`0027oo00@007ooOol001Qo
o`04001oogoo0009Ool00`00Ool0000HOol01000Oomoo`002Goo00<007ooOol06Goo00@007ooOol0
00Qoo`04001oogoo000?Ool00`00Oomoo`0>Ool00`00Oomoo`0POol00`00Oomoo`07Ool01000Oomo
o`0047oo000EOol00`00Oomoo`0OOol2000:Ool2000JOol2000;Ool2000IOol2000:Ool3000JOol2
000:Ool2000?Ool00`00Oomoo`0>Ool2000QOol2000:Ool2000AOol001Eoo`800;Ioo`03001oogoo
051oo`005Goo00<007ooOol0]Goo00<007ooOol0D7oo000EOol00`00Oomoo`2eOol00`00Oomoo`1@
Ool001Eoo`03001oogoo0;Eoo`03001oogoo04Qoo`8000Ioo`005Goo00<007ooOol0]7oo00<007oo
Ool0B7oo00@007ooOol000Eoo`003gooo`000@0027oo00<007ooOol01Woo000EOol00`00Oomoo`07
Ool00`00Oomoo`02Ool60009Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool20008Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`0;Ool50005Ool001Eoo`03001oogoo015o
o`<0019oo`03001oogoo02Eoo`03001oogoo02Eoo`03001oogoo02Ioo`03001oogoo019oo`03001o
ogoo011oo`03001oogoo02Ioo`03001oogoo00aoo`03001oogoo00Ioo`005Goo00<007ooOol057oo
0P00WWoo00<007ooOol0DGoo000EOol00`00Oomoo`0FOol3002KOol00`00Oomoo`1AOol001Eoo`80
01Yoo`8009Qoo`03001oogoo059oo`005Goo00<007ooOol06goo0P00UWoo00<007ooOol0DWoo000E
Ool00`00Oomoo`0MOol2002DOol00`00Oomoo`1BOol001Eoo`03001oogoo01moo`03001oogoo095o
o`03001oogoo059oo`005Goo00<007ooOol087oo00<007ooOol0T7oo00<007ooOol0DWoo000EOol2
000ROol2002?Ool00`00Oomoo`1COol001Eoo`03001oogoo02=oo`03001oogoo08aoo`03001oogoo
05=oo`005Goo00<007ooOol097oo0P00S7oo00<007ooOol0Dgoo000EOol00`00Oomoo`0VOol00`00
Oomoo`29Ool00`00Oomoo`1COol001Eoo`03001oogoo02Moo`03001oogoo08Qoo`03001oogoo05=o
o`005Goo0P00:Goo00<007ooOol0QWoo00<007ooOol0E7oo000EOol00`00Oomoo`0YOol00`00Oomo
o`25Ool00`00Oomoo`1DOol001Eoo`03001oogoo02Yoo`03001oogoo08Aoo`03001oogoo05Aoo`00
5Goo00<007ooOol0:goo00<007ooOol0Pgoo00<007ooOol0E7oo000EOol00`00Oomoo`0/Ool00`00
Oomoo`22Ool00`00Oomoo`1DOol001Eoo`8002ioo`03001oogoo085oo`03001oogoo05Aoo`005Goo
00<007ooOol0;Woo00<007ooOol0Ogoo00<007ooOol0EGoo000EOol00`00Oomoo`0_Ool00`00Oomo
o`1nOol00`00Oomoo`1EOol000ioo`8000Eoo`03001oogoo031oo`03001oogoo07eoo`03001oogoo
05Eoo`003Goo00@007ooOol000Aoo`03001oogoo035oo`03001oogoo07aoo`03001oogoo05Eoo`00
47oo00<007ooOol00Woo0`00<Goo00<007ooOol0O7oo00<007ooOol0EGoo000>Ool20005Ool00`00
Oomoo`0bOol00`00Oomoo`1jOol00`00Oomoo`1FOol000ioo`03001oogoo00Aoo`03001oogoo03=o
o`03001oogoo07Uoo`03001oogoo05Ioo`003Woo0`0017oo00<007ooOol0=7oo00<007ooOol0N7oo
00<007ooOol0EWoo000EOol00`00Oomoo`0dOol00`00Oomoo`1hOol00`00Oomoo`1FOol001Eoo`80
03Ioo`03001oogoo07Moo`03001oogoo05Ioo`005Goo00<007ooOol0=Woo00<007ooOol0MGoo00<0
07ooOol0Egoo000EOol00`00Oomoo`0fOol00`00Oomoo`1eOol00`00Oomoo`1GOol001Eoo`03001o
ogoo03Moo`03001oogoo07Aoo`03001oogoo05Moo`005Goo00<007ooOol0>7oo00<007ooOol0Lgoo
00<007ooOol0Egoo000EOol2000jOol00`00Oomoo`1aOol00`00Oomoo`1HOol001Eoo`03001oogoo
03Uoo`03001oogoo075oo`03001oogoo05Qoo`005Goo00<007ooOol0>Woo00<007ooOol0L7oo00<0
07ooOol0F7oo000EOol00`00Oomoo`0kOol00`00Oomoo`1_Ool00`00Oomoo`1HOol001Eoo`03001o
ogoo03]oo`03001oogoo06ioo`03001oogoo05Uoo`005Goo0P00?Goo00<007ooOol0KGoo00<007oo
Ool0FGoo000EOol00`00Oomoo`0mOol00`00Oomoo`1/Ool00`00Oomoo`1IOol001Eoo`03001oogoo
03eoo`03001oogoo06aoo`03001oogoo05Uoo`005Goo00<007ooOol0?Woo00<007ooOol0JWoo00<0
07ooOol0FWoo000EOol00`00Oomoo`0nOol00`00Oomoo`1ZOol00`00Oomoo`1JOol001Eoo`80041o
o`03001oogoo06Uoo`03001oogoo05Yoo`005Goo00<007ooOol0@7oo00<007ooOol0Igoo00<007oo
Ool0Fgoo000EOol00`00Oomoo`10Ool00`00Oomoo`1WOol00`00Oomoo`1KOol000Moo`D0009oo`80
00Eoo`03001oogoo045oo`03001oogoo06Ioo`03001oogoo05]oo`002Goo00D007ooOomoo`00009o
o`03001oogoo009oo`03001oogoo049oo`03001oogoo06Eoo`03001oogoo05]oo`002Goo00D007oo
Oomoo`00009oo`03001oogoo009oo`<0049oo`03001oogoo06Aoo`03001oogoo05aoo`002Goo00D0
07ooOomoo`00009oo`03001oogoo009oo`03001oogoo04=oo`03001oogoo06=oo`03001oogoo05ao
o`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo04=oo`03001oogoo06=oo`03
001oogoo05aoo`0027oo0P0017oo0P001Goo00<007ooOol0A7oo00<007ooOol0HWoo00<007ooOol0
G7oo000EOol00`00Oomoo`15Ool00`00Oomoo`1POol00`00Oomoo`1MOol001Eoo`8004Ioo`03001o
ogoo061oo`03001oogoo05eoo`005Goo00<007ooOol0AWoo00<007ooOol0Ggoo00<007ooOol0GGoo
000EOol00`00Oomoo`16Ool00`00Oomoo`1OOol00`00Oomoo`1MOol001Eoo`03001oogoo04Moo`03
001oogoo05eoo`03001oogoo05ioo`005Goo00<007ooOol0Agoo00<007ooOol0GGoo00<007ooOol0
GWoo000EOol20019Ool00`00Oomoo`1LOol00`00Oomoo`1NOol001Eoo`03001oogoo04Qoo`03001o
ogoo05]oo`03001oogoo05moo`005Goo00<007ooOol0BGoo00<007ooOol0FWoo00<007ooOol0Ggoo
000EOol00`00Oomoo`1:Ool00`00Oomoo`1HOol00`00Oomoo`1POol001Eoo`03001oogoo04Yoo`03
001oogoo05Qoo`03001oogoo061oo`005Goo0P00C7oo00<007ooOol0EWoo00<007ooOol0HGoo000E
Ool00`00Oomoo`1;Ool00`00Oomoo`1FOol00`00Oomoo`1QOol001Eoo`03001oogoo04aoo`03001o
ogoo05Eoo`03001oogoo065oo`005Goo00<007ooOol0CGoo00<007ooOol0Dgoo00<007ooOol0HWoo
000EOol00`00Oomoo`1=Ool00`00Oomoo`1BOol00`00Oomoo`1SOol001Eoo`8004moo`03001oogoo
055oo`03001oogoo06=oo`005Goo00<007ooOol0Cgoo00<007ooOol0Cgoo00<007ooOol0I7oo000E
Ool00`00Oomoo`1?Ool00`00Oomoo`1>Ool00`00Oomoo`1UOol000Moo`D0009oo`8000Eoo`03001o
ogoo051oo`03001oogoo04aoo`03001oogoo06Ioo`002Goo00D007ooOomoo`00009oo`03001oogoo
009oo`03001oogoo055oo`03001oogoo04Uoo`8006Uoo`002Goo00<007ooOol017oo00<007ooOol0
0Woo0`00DWooC000JWoo0009Ool00`00Oomoo`02Ool20005Ool00`00Oomoo`3oOol9Ool000Uoo`03
001oogoo009oo`03001oogoo00Aoo`03001oogoo0?moo`Uoo`0027oo0P0017oo0`0017oo00<007oo
Ool0ogoo2Goo000EOol00`00Oomoo`3oOol9Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`0047oo10000Woo
0`00ogoo27oo000AOol00`00Oomoo`05Ool00`00Oomoo`3oOol5Ool0015oo`03001oogoo009oo`<0
0?moo`Qoo`0047oo10000Woo1000ogoo1goo000AOol00`00Oomoo`3oOol=Ool0019oo`800?moo`eo
o`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.107238, -15.901, \
0.00494992, 0.200229}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("t      p"\[InvisibleSpace]"        \
"\[InvisibleSpace]"t        u"\[InvisibleSpace]"              "\
\[InvisibleSpace]"t        v"\[InvisibleSpace]"          "\[InvisibleSpace]"t \
      a"\[InvisibleSpace]"         "\[InvisibleSpace]"t      kt"\),
      SequenceForm[ 
      "t      p", "        ", "t        u", "              ", "t        v", 
        "          ", "t       a", "         ", "t      kt"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("-----------------------------------------------------------------------\
------------------------"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        InterpretationBox[GridBox[{
              {"0"},
              {"0.01`"},
              {"0.02`"},
              {"0.03`"},
              {"0.04`"},
              {"0.05`"},
              {"0.06`"},
              {"0.07`"},
              {"0.08`"},
              {"0.09`"},
              {"0.1`"},
              {"0.11`"},
              {"0.12`"},
              {"0.13`"},
              {"0.14`"},
              {"0.15`"},
              {"0.16`"},
              {"0.17`"},
              {"0.18`"},
              {"0.19`"},
              {"0.2`"},
              {"0.21`"},
              {"0.22`"},
              {"0.23`"},
              {"0.24`"},
              {"0.25`"},
              {"0.26`"},
              {"0.27`"},
              {"0.28`"},
              {"0.29`"},
              {"0.3`"},
              {"0.31`"},
              {"0.32`"},
              {"0.33`"},
              {"0.34`"},
              {"0.35000000000000003`"},
              {"0.36`"},
              {"0.37`"},
              {"0.38`"},
              {"0.39`"},
              {"0.4`"},
              {"0.41000000000000003`"},
              {"0.42`"},
              {"0.43`"},
              {"0.44`"},
              {"0.45`"},
              {"0.46`"},
              {"0.47000000000000003`"},
              {"0.48`"},
              {"0.49`"},
              {"0.5`"},
              {"0.51`"},
              {"0.52`"},
              {"0.53`"},
              {"0.54`"},
              {"0.55`"},
              {"0.56`"},
              {"0.5700000000000001`"},
              {"0.58`"},
              {"0.59`"},
              {"0.6`"},
              {"0.61`"},
              {"0.62`"},
              {"0.63`"},
              {"0.64`"},
              {"0.65`"},
              {"0.66`"},
              {"0.67`"},
              {"0.68`"},
              {"0.6900000000000001`"},
              {"0.7000000000000001`"},
              {"0.71`"},
              {"0.72`"},
              {"0.73`"},
              {"0.74`"},
              {"0.75`"},
              {"0.76`"},
              {"0.77`"},
              {"0.78`"},
              {"0.79`"},
              {"0.8`"},
              {"0.81`"},
              {"0.8200000000000001`"},
              {"0.8300000000000001`"},
              {"0.84`"},
              {"0.85`"},
              {"0.86`"},
              {"0.87`"},
              {"0.88`"},
              {"0.89`"},
              {"0.9`"},
              {"0.91`"},
              {"0.92`"},
              {"0.93`"},
              {"0.9400000000000001`"},
              {"0.9500000000000001`"},
              {"0.96`"},
              {"0.97`"},
              {"0.98`"},
              {"0.99`"},
              {"1.`"},
              {"1.01`"},
              {"1.02`"},
              {"1.03`"},
              {"1.04`"},
              {"1.05`"},
              {"1.06`"},
              {"1.07`"},
              {"1.08`"},
              {"1.09`"},
              {"1.1`"},
              {"1.11`"},
              {"1.12`"},
              {"1.1300000000000001`"},
              {"1.1400000000000001`"},
              {"1.1500000000000001`"},
              {"1.16`"},
              {"1.17`"},
              {"1.18`"},
              {"1.19`"},
              {"1.2`"}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {
            0, .01, .02, .029999999999999999, .040000000000000001, \
.050000000000000003, .059999999999999998, .070000000000000007, \
.080000000000000002, .089999999999999997, .10000000000000001, .11, .12, .13, \
.14000000000000001, .14999999999999999, .16, .17000000000000001, \
.17999999999999999, .19, .20000000000000001, .20999999999999999, .22, \
.23000000000000001, .23999999999999999, .25, .26000000000000001, \
.27000000000000002, .28000000000000003, .28999999999999998, \
.29999999999999999, .31, .32000000000000001, .33000000000000002, \
.34000000000000002, .35000000000000003, .35999999999999999, .37, .38, \
.39000000000000001, .40000000000000002, .41000000000000003, \
.41999999999999998, .42999999999999999, .44, .45000000000000001, \
.46000000000000002, .47000000000000003, .47999999999999998, \
.48999999999999999, .5, .51000000000000001, .52000000000000002, \
.53000000000000003, .54000000000000004, .55000000000000004, \
.56000000000000005, .57000000000000006, .57999999999999996, \
.58999999999999997, .59999999999999998, .60999999999999999, .62, .63, \
.64000000000000001, .65000000000000002, .66000000000000003, \
.67000000000000004, .68000000000000005, .69000000000000006, \
.70000000000000007, .70999999999999996, .71999999999999997, \
.72999999999999998, .73999999999999999, .75, .76000000000000001, \
.77000000000000002, .78000000000000003, .79000000000000004, \
.80000000000000004, .81000000000000005, .82000000000000006, \
.83000000000000007, .83999999999999997, .84999999999999998, \
.85999999999999999, .87, .88, .89000000000000001, .90000000000000002, \
.91000000000000003, .92000000000000004, .93000000000000005, \
.94000000000000006, .95000000000000007, .95999999999999996, \
.96999999999999997, .97999999999999998, .98999999999999999, 1.0, 1.01, 1.02, 
            1.03, 1.04, 1.05, 1.0600000000000001, 1.0700000000000001, 
            1.0800000000000001, 1.0900000000000001, 1.1000000000000001, 
            1.1100000000000001, 1.1200000000000001, 1.1300000000000001, 
            1.1400000000000001, 1.1500000000000001, 1.1599999999999999, 
            1.1699999999999999, 1.1799999999999999, 1.1899999999999999, 1.2}],
          
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0.`"},
              {"0.4999999999999991`"},
              {"1.`"},
              {"1.4999999999999996`"},
              {"1.9999999999999996`"},
              {"2.5`"},
              {"2.9999999999999996`"},
              {"3.5`"},
              {"4.`"},
              {"4.5`"},
              {"5.`"},
              {"5.499999999999999`"},
              {"5.999999999999999`"},
              {"6.5`"},
              {"7.`"},
              {"7.499999999999999`"},
              {"8.`"},
              {"8.5`"},
              {"9.`"},
              {"9.5`"},
              {"10.`"},
              {"10.5`"},
              {"11.`"},
              {"11.5`"},
              {"12.`"},
              {"12.5`"},
              {"13.`"},
              {"13.500000000000002`"},
              {"14.000000000000002`"},
              {"14.5`"},
              {"15.`"},
              {"14.5`"},
              {"14.`"},
              {"13.5`"},
              {"12.999999999999998`"},
              {"12.499999999999998`"},
              {"12.`"},
              {"11.5`"},
              {"11.`"},
              {"10.5`"},
              {"10.`"},
              {"9.5`"},
              {"9.000000000000002`"},
              {"8.500000000000002`"},
              {"8.`"},
              {"7.5`"},
              {"7.`"},
              {"6.499999999999999`"},
              {"6.000000000000001`"},
              {"5.500000000000001`"},
              {"5.`"},
              {"4.`"},
              {"2.9999999999999982`"},
              {"1.9999999999999973`"},
              {"0.9999999999999956`"},
              {\(-5.329070518200751`*^-15\)},
              {\(-1.0000000000000062`\)},
              {\(-2.0000000000000075`\)},
              {\(-2.999999999999998`\)},
              {\(-3.999999999999999`\)},
              {\(-5.`\)},
              {\(-5.500000000000001`\)},
              {\(-6.000000000000001`\)},
              {\(-6.500000000000002`\)},
              {\(-7.000000000000002`\)},
              {\(-7.5000000000000036`\)},
              {\(-8.000000000000004`\)},
              {\(-8.500000000000004`\)},
              {\(-9.000000000000004`\)},
              {\(-9.500000000000005`\)},
              {\(-10.000000000000005`\)},
              {\(-10.5`\)},
              {\(-11.`\)},
              {\(-11.5`\)},
              {\(-12.`\)},
              {\(-12.5`\)},
              {\(-13.`\)},
              {\(-13.5`\)},
              {\(-14.`\)},
              {\(-14.5`\)},
              {\(-15.`\)},
              {\(-15.5`\)},
              {\(-16.`\)},
              {\(-16.5`\)},
              {\(-16.999999999999996`\)},
              {\(-17.499999999999996`\)},
              {\(-17.999999999999996`\)},
              {\(-18.5`\)},
              {\(-19.`\)},
              {\(-19.5`\)},
              {\(-20.`\)},
              {\(-20.5`\)},
              {\(-21.`\)},
              {\(-21.5`\)},
              {\(-22.000000000000004`\)},
              {\(-22.500000000000004`\)},
              {\(-22.999999999999996`\)},
              {\(-23.5`\)},
              {\(-24.`\)},
              {\(-24.5`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)},
              {\(-25.`\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {0.0, .49999999999999911, 1.0, 1.4999999999999996, 
            1.9999999999999996, 2.5, 2.9999999999999996, 3.5, 4.0, 4.5, 5.0, 
            5.4999999999999991, 5.9999999999999991, 6.5, 7.0, 
            7.4999999999999991, 8.0, 8.5, 9.0, 9.5, .1*^2, 10.5, 11.0, 11.5, 
            12.0, 12.5, 13.0, 13.500000000000002, 14.000000000000002, 14.5, 
            15.0, 14.5, 14.0, 13.5, 12.999999999999998, 12.499999999999998, 
            12.0, 11.5, 11.0, 10.5, .1*^2, 9.5, 9.0000000000000018, 
            8.5000000000000018, 8.0, 7.5, 7.0, 6.4999999999999991, 
            6.0000000000000009, 5.5000000000000009, 5.0, 4.0, 
            2.9999999999999982, 
            1.9999999999999973, .99999999999999556, -.53290705182007514*^-14, \
-1.0000000000000062, -2.0000000000000075, -2.9999999999999978, \
-3.9999999999999991, -5.0, -5.5000000000000009, -6.0000000000000009, \
-6.5000000000000018, -7.0000000000000018, -7.5000000000000036, \
-8.0000000000000036, -8.5000000000000036, -9.0000000000000036, \
-9.5000000000000053, -10.000000000000005, -10.5, -11.0, -11.5, -12.0, -12.5, \
-13.0, -13.5, -14.0, -14.5, -15.0, -15.5, -16.0, -16.5, -16.999999999999996, \
-17.499999999999996, -17.999999999999996, -18.5, -19.0, -19.5, -.2*^2, -20.5, \
-21.0, -21.5, -22.000000000000004, -22.500000000000004, -22.999999999999996, \
-23.5, -24.0, -24.5, -25.0, -25.0, -25.0, -25.0, -25.0, -25.0, -25.0, -25.0, \
-25.0, -25.0, -25.0, -25.0, -25.0, -25.0, -25.0, -25.0, -25.0, -25.0, -25.0, \
-25.0, -25.0}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {\({0, 0}\)},
              {\({0.01`, 0.000032713225787076884`}\)},
              {\({0.02`, 0.0003548578336049603`}\)},
              {\({0.03`, 0.0011597470561214905`}\)},
              {\({0.04`, 0.0026372397821016755`}\)},
              {\({0.05`, 0.004973009223890921`}\)},
              {\({0.060000000000000005`, 0.008347842193515984`}\)},
              {\({0.07`, 0.012936965672485456`}\)},
              {\({0.08`, 0.018909401427441314`}\)},
              {\({0.09`, 0.026427350502431418`}\)},
              {\({0.09999999999999999`, 0.03564560963043684`}\)},
              {\({0.10999999999999999`, 0.046711021563722435`}\)},
              {\({0.11999999999999998`, 0.05976196120134043`}\)},
              {\({0.12999999999999998`, 0.07492785924410529`}\)},
              {\({0.13999999999999999`, 0.09232876494786607`}\)},
              {\({0.15`, 0.1120749493798267`}\)},
              {\({0.16`, 0.13426655041191626`}\)},
              {\({0.17`, 0.15899326051084703`}\)},
              {\({0.18000000000000002`, 0.18633405820733576`}\)},
              {\({0.19000000000000003`, 0.21635698394775013`}\)},
              {\({0.20000000000000004`, 0.24911896085090987`}\)},
              {\({0.21000000000000005`, 0.2846656607116456`}\)},
              {\({0.22000000000000006`, 0.32303141541171493`}\)},
              {\({0.23000000000000007`, 0.36423917371851`}\)},
              {\({0.24000000000000007`, 0.4083005032733623`}\)},
              {\({0.25000000000000006`, 0.45521563739485454`}\)},
              {\({0.26000000000000006`, 0.5049735661490576`}\)},
              {\({0.2700000000000001`, 0.557552170968692`}\)},
              {\({0.2800000000000001`, 0.6129184019374954`}\)},
              {\({0.2900000000000001`, 0.6710284966951858`}\)},
              {\({0.3000000000000001`, 0.7318282397629494`}\)},
              {\({0.3100000000000001`, 0.7951878344883168`}\)},
              {\({0.3200000000000001`, 0.8605196556107341`}\)},
              {\({0.3300000000000001`, 0.9273534408945808`}\)},
              {\({0.34000000000000014`, 0.9952167960880032`}\)},
              {\({0.35000000000000014`, 1.0636370960221144`}\)},
              {\({0.36000000000000015`, 1.1321433548196431`}\)},
              {\({0.37000000000000016`, 1.2002680697502475`}\)},
              {\({0.38000000000000017`, 1.267549035041346`}\)},
              {\({0.3900000000000002`, 1.3335311197112214`}\)},
              {\({0.4000000000000002`, 1.3977680029922086`}\)},
              {\({0.4100000000000002`, 1.4598238609325465`}\)},
              {\({0.4200000000000002`, 1.5199974337812243`}\)},
              {\({0.4300000000000002`, 1.583061034203217`}\)},
              {\({0.4400000000000002`, 1.6489298881143382`}\)},
              {\({0.45000000000000023`, 1.7174269554599617`}\)},
              {\({0.46000000000000024`, 1.7883497066262786`}\)},
              {\({0.47000000000000025`, 1.8614892555491362`}\)},
              {\({0.48000000000000026`, 1.936635837602791`}\)},
              {\({0.49000000000000027`, 2.0135803737428155`}\)},
              {\({0.5000000000000002`, 2.092114912949904`}\)},
              {\({0.5100000000000002`, 2.1719999979854654`}\)},
              {\({0.5200000000000002`, 2.2527730175744916`}\)},
              {\({0.5300000000000002`, 2.3340348697380744`}\)},
              {\({0.5400000000000003`, 2.4153889415167797`}\)},
              {\({0.5500000000000003`, 2.4964410982731984`}\)},
              {\({0.5600000000000003`, 2.576799669588637`}\)},
              {\({0.5700000000000003`, 2.6560754342526534`}\)},
              {\({0.5800000000000003`, 2.7338816050611876`}\)},
              {\({0.5900000000000003`, 2.8098338136279963`}\)},
              {\({0.6000000000000003`, 2.8835500952676325`}\)},
              {\({0.6100000000000003`, 2.9546836291959733`}\)},
              {\({0.6200000000000003`, 3.023114400297346`}\)},
              {\({0.6300000000000003`, 3.088662523474383`}\)},
              {\({0.6400000000000003`, 3.1511492441803814`}\)},
              {\({0.6500000000000004`, 3.210396927345294`}\)},
              {\({0.6600000000000004`, 3.2662290492273316`}\)},
              {\({0.6700000000000004`, 3.318470190134193`}\)},
              {\({0.6800000000000004`, 3.3669460274244507`}\)},
              {\({0.6900000000000004`, 3.41148332861997`}\)},
              {\({0.7000000000000004`, 3.451909944580658`}\)},
              {\({0.7100000000000004`, 3.4880548027274356`}\)},
              {\({0.7200000000000004`, 3.5197479003091656`}\)},
              {\({0.7300000000000004`, 3.5468202977121455`}\)},
              {\({0.7400000000000004`, 3.569104111811564`}\)},
              {\({0.7500000000000004`, 3.5864325093645775`}\)},
              {\({0.7600000000000005`, 3.5986397004447146`}\)},
              {\({0.7700000000000005`, 3.6055609319173443`}\)},
              {\({0.7800000000000005`, 3.6070324809559384`}\)},
              {\({0.7900000000000005`, 3.6012076936482904`}\)},
              {\({0.8000000000000005`, 3.575918502989104`}\)},
              {\({0.8100000000000005`, 3.530885097039065`}\)},
              {\({0.8200000000000005`, 3.466150052473586`}\)},
              {\({0.8300000000000005`, 3.3819030406121535`}\)},
              {\({0.8400000000000005`, 3.278429175947473`}\)},
              {\({0.8500000000000005`, 3.1560927938252124`}\)},
              {\({0.8600000000000005`, 3.0153312445521654`}\)},
              {\({0.8700000000000006`, 2.856651388583499`}\)},
              {\({0.8800000000000006`, 2.6806266930584`}\)},
              {\({0.8900000000000006`, 2.4878943335195793`}\)},
              {\({0.9000000000000006`, 2.2791521385106415`}\)},
              {\({0.9100000000000006`, 2.055155340314133`}\)},
              {\({0.9200000000000006`, 1.8167131317808907`}\)},
              {\({0.9300000000000006`, 1.5646850402315742`}\)},
              {\({0.9400000000000006`, 1.2999771330009642`}\)},
              {\({0.9500000000000006`, 1.0235380705929822`}\)},
              {\({0.9600000000000006`, 0.7363550241307252`}\)},
              {\({0.9700000000000006`, 0.4396014894025991`}\)},
              {\({0.9800000000000006`, 0.13526916637994277`}\)},
              {\({0.9900000000000007`, \(-0.17672527413606767`\)}\)},
              {\({1.0000000000000007`, \(-0.4965117629774368`\)}\)},
              {\({1.0100000000000007`, \(-0.8242001692628306`\)}\)},
              {\({1.0200000000000007`, \(-1.1596789092854465`\)}\)},
              {\({1.0300000000000007`, \(-1.5028988271508898`\)}\)},
              {\({1.0400000000000007`, \(-1.8538113867525852`\)}\)},
              {\({1.0500000000000007`, \(-2.2123684450454872`\)}\)},
              {\({1.0600000000000007`, \(-2.578522185715884`\)}\)},
              {\({1.0700000000000007`, \(-2.9522250988314642`\)}\)},
              {\({1.0800000000000007`, \(-3.3334299736783595`\)}\)},
              {\({1.0900000000000007`, \(-3.722089895386084`\)}\)},
              {\({1.1000000000000008`, \(-4.118158242646409`\)}\)},
              {\({1.1100000000000008`, \(-4.52158868575399`\)}\)},
              {\({1.1200000000000008`, \(-4.932335184747373`\)}\)},
              {\({1.1300000000000008`, \(-5.350351987586894`\)}\)},
              {\({1.1400000000000008`, \(-5.775593628351206`\)}\)},
              {\({1.1500000000000008`, \(-6.208014925447166`\)}\)},
              {\({1.1600000000000008`, \(-6.647570979831508`\)}\)},
              {\({1.1700000000000008`, \(-7.094217173243799`\)}\)},
              {\({1.1800000000000008`, \(-7.547909166450504`\)}\)},
              {\({1.1900000000000008`, \(-8.008602897500058`\)}\)},
              {\({1.2000000000000008`, \(-8.476254579988822`\)}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 
            0}, {.01, .000032713225787076884}, {.02, .00035485783360496032}, \
{.029999999999999999, .0011597470561214905}, {.040000000000000001, \
.0026372397821016755}, {.050000000000000003, .004973009223890921}, \
{.060000000000000005, .0083478421935159839}, {.070000000000000007, \
.012936965672485456}, {.080000000000000002, .018909401427441314}, \
{.089999999999999997, .026427350502431418}, {.099999999999999992, \
.035645609630436843}, {.10999999999999999, .046711021563722435}, \
{.11999999999999998, .059761961201340433}, {.12999999999999998, \
.074927859244105291}, {.13999999999999999, .092328764947866071}, \
{.14999999999999999, .1120749493798267}, {.16, .13426655041191626}, \
{.17000000000000001, .15899326051084703}, {.18000000000000002, \
.18633405820733576}, {.19000000000000003, .21635698394775013}, \
{.20000000000000004, .24911896085090987}, {.21000000000000005, \
.28466566071164562}, {.22000000000000006, .32303141541171493}, \
{.23000000000000007, .36423917371851}, {.24000000000000007, \
.40830050327336231}, {.25000000000000006, .45521563739485454}, \
{.26000000000000006, .50497356614905764}, {.27000000000000007, \
.55755217096869203}, {.28000000000000008, .61291840193749536}, \
{.29000000000000009, .67102849669518583}, {.3000000000000001, \
.73182823976294942}, {.31000000000000011, .79518783448831676}, \
{.32000000000000012, .86051965561073407}, {.33000000000000013, \
.92735344089458083}, {.34000000000000014, .99521679608800317}, \
{.35000000000000014, 1.0636370960221144}, {.36000000000000015, 
            1.1321433548196431}, {.37000000000000016, 
            1.2002680697502475}, {.38000000000000017, 
            1.2675490350413461}, {.39000000000000018, 
            1.3335311197112214}, {.40000000000000019, 
            1.3977680029922086}, {.4100000000000002, 
            1.4598238609325465}, {.42000000000000021, 
            1.5199974337812243}, {.43000000000000022, 
            1.583061034203217}, {.44000000000000022, 
            1.6489298881143382}, {.45000000000000023, 
            1.7174269554599617}, {.46000000000000024, 
            1.7883497066262786}, {.47000000000000025, 
            1.8614892555491362}, {.48000000000000026, 
            1.936635837602791}, {.49000000000000027, 
            2.0135803737428155}, {.50000000000000022, 
            2.0921149129499041}, {.51000000000000023, 
            2.1719999979854654}, {.52000000000000024, 
            2.2527730175744916}, {.53000000000000025, 
            2.3340348697380744}, {.54000000000000026, 
            2.4153889415167797}, {.55000000000000027, 
            2.4964410982731984}, {.56000000000000028, 
            2.5767996695886368}, {.57000000000000028, 
            2.6560754342526534}, {.58000000000000029, 
            2.7338816050611876}, {.5900000000000003, 
            2.8098338136279963}, {.60000000000000031, 
            2.8835500952676325}, {.61000000000000032, 
            2.9546836291959733}, {.62000000000000033, 
            3.023114400297346}, {.63000000000000034, 
            3.0886625234743832}, {.64000000000000035, 
            3.1511492441803814}, {.65000000000000036, 
            3.2103969273452941}, {.66000000000000036, 
            3.2662290492273316}, {.67000000000000037, 
            3.3184701901341929}, {.68000000000000038, 
            3.3669460274244507}, {.69000000000000039, 
            3.4114833286199699}, {.7000000000000004, 
            3.4519099445806578}, {.71000000000000041, 
            3.4880548027274356}, {.72000000000000042, 
            3.5197479003091656}, {.73000000000000043, 
            3.5468202977121455}, {.74000000000000044, 
            3.5691041118115638}, {.75000000000000044, 
            3.5864325093645775}, {.76000000000000045, 
            3.5986397004447146}, {.77000000000000046, 
            3.6055609319173443}, {.78000000000000047, 
            3.6070324809559384}, {.79000000000000048, 
            3.6012076936482904}, {.80000000000000049, 
            3.5759185029891039}, {.8100000000000005, 
            3.5308850970390648}, {.82000000000000051, 
            3.4661500524735862}, {.83000000000000052, 
            3.3819030406121535}, {.84000000000000052, 
            3.2784291759474731}, {.85000000000000053, 
            3.1560927938252124}, {.86000000000000054, 
            3.0153312445521654}, {.87000000000000055, 
            2.856651388583499}, {.88000000000000056, 
            2.6806266930584002}, {.89000000000000057, 
            2.4878943335195793}, {.90000000000000058, 
            2.2791521385106415}, {.91000000000000059, 
            2.0551553403141329}, {.9200000000000006, 
            1.8167131317808907}, {.9300000000000006, 
            1.5646850402315742}, {.94000000000000061, 
            1.2999771330009642}, {.95000000000000062, 
            1.0235380705929822}, {.96000000000000063, .73635502413072518}, \
{.97000000000000064, .43960148940259908}, {.98000000000000065, \
.13526916637994277}, {.99000000000000066, -.17672527413606767}, {
            1.0000000000000007, -.49651176297743682}, {
            1.0100000000000007, -.82420016926283057}, {
            1.0200000000000007, -1.1596789092854465}, {
            1.0300000000000007, -1.5028988271508898}, {
            1.0400000000000007, -1.8538113867525852}, {
            1.0500000000000007, -2.2123684450454872}, {
            1.0600000000000007, -2.578522185715884}, {
            1.0700000000000007, -2.9522250988314642}, {
            1.0800000000000007, -3.3334299736783595}, {
            1.0900000000000007, -3.7220898953860839}, {
            1.1000000000000008, -4.118158242646409}, {
            1.1100000000000008, -4.52158868575399}, {
            1.1200000000000008, -4.9323351847473731}, {
            1.1300000000000008, -5.3503519875868939}, {
            1.1400000000000008, -5.7755936283512064}, {
            1.1500000000000008, -6.2080149254471664}, {
            1.1600000000000008, -6.6475709798315084}, {
            1.1700000000000008, -7.0942171732437993}, {
            1.1800000000000008, -7.5479091664505038}, {
            1.1900000000000008, -8.008602897500058}, {
            1.2000000000000008, -8.4762545799888223}}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {\({0, 0}\)},
              {\({0.01`, 0.009813967736123065`}\)},
              {\({0.02`, 0.039161571319501355`}\)},
              {\({0.03`, 0.0877996001336862`}\)},
              {\({0.04`, 0.15538881608281158`}\)},
              {\({0.05`, 0.24151174029696681`}\)},
              {\({0.060000000000000005`, 0.34567944839888437`}\)},
              {\({0.07`, 0.46733537753752036`}\)},
              {\({0.08`, 0.6058584426611017`}\)},
              {\({0.09`, 0.7605661147344857`}\)},
              {\({0.09999999999999999`, 0.9307176390899455`}\)},
              {\({0.10999999999999999`, 1.1155174348488663`}\)},
              {\({0.11999999999999998`, 1.3141186763316042`}\)},
              {\({0.12999999999999998`, 1.5256270454174632`}\)},
              {\({0.13999999999999999`, 1.749104639996635`}\)},
              {\({0.15`, 1.9835740222290739`}\)},
              {\({0.16`, 2.2280223896380145`}\)},
              {\({0.17`, 2.4814058516422786`}\)},
              {\({0.18000000000000002`, 2.7426537938351077`}\)},
              {\({0.19000000000000003`, 3.010673312108707`}\)},
              {\({0.20000000000000004`, 3.2843536985920196`}\)},
              {\({0.21000000000000005`, 3.562570961310972`}\)},
              {\({0.22000000000000006`, 3.8441923594942997`}\)},
              {\({0.23000000000000007`, 4.1280809365330375`}\)},
              {\({0.24000000000000007`, 4.413100032757064`}\)},
              {\({0.25000000000000006`, 4.69811776041627`}\)},
              {\({0.26000000000000006`, 4.982011423545841`}\)},
              {\({0.2700000000000001`, 5.263671865752844`}\)},
              {\({0.2800000000000001`, 5.542007729382705`}\)},
              {\({0.2900000000000001`, 5.815949610007745`}\)},
              {\({0.3000000000000001`, 6.084454090722424`}\)},
              {\({0.3100000000000001`, 6.326879705857063`}\)},
              {\({0.3200000000000001`, 6.522807225514338`}\)},
              {\({0.3300000000000001`, 6.671780400658286`}\)},
              {\({0.34000000000000014`, 6.773575671764754`}\)},
              {\({0.35000000000000014`, 6.828169818809963`}\)},
              {\({0.36000000000000015`, 6.83572939521538`}\)},
              {\({0.37000000000000016`, 6.796605929038693`}\)},
              {\({0.38000000000000017`, 6.711332287074161`}\)},
              {\({0.3900000000000002`, 6.580618887998478`}\)},
              {\({0.4000000000000002`, 6.405349400692675`}\)},
              {\({0.4100000000000002`, 6.186575839359173`}\)},
              {\({0.4200000000000002`, 6.142243796671119`}\)},
              {\({0.4300000000000002`, 6.3422639342662315`}\)},
              {\({0.4400000000000002`, 6.596950658783495`}\)},
              {\({0.45000000000000023`, 6.85203345185961`}\)},
              {\({0.46000000000000024`, 7.092053107142732`}\)},
              {\({0.47000000000000025`, 7.312673702655791`}\)},
              {\({0.48000000000000026`, 7.512746816579064`}\)},
              {\({0.49000000000000027`, 7.692037020779603`}\)},
              {\({0.5000000000000002`, 7.85056997814927`}\)},
              {\({0.5100000000000002`, 7.978619032647799`}\)},
              {\({0.5200000000000002`, 8.06653083721147`}\)},
              {\({0.5300000000000002`, 8.114542559821407`}\)},
              {\({0.5400000000000003`, 8.122899755875176`}\)},
              {\({0.5500000000000003`, 8.091849274204323`}\)},
              {\({0.5600000000000003`, 8.021637230781524`}\)},
              {\({0.5700000000000003`, 7.912508434857059`}\)},
              {\({0.5800000000000003`, 7.7647062313397415`}\)},
              {\({0.5900000000000003`, 7.578472462436371`}\)},
              {\({0.6000000000000003`, 7.354047463429314`}\)},
              {\({0.6100000000000003`, 7.101496637116784`}\)},
              {\({0.6200000000000003`, 6.830831286481988`}\)},
              {\({0.6300000000000003`, 6.542176073720423`}\)},
              {\({0.6400000000000003`, 6.235646762865533`}\)},
              {\({0.6500000000000004`, 5.911356067104479`}\)},
              {\({0.6600000000000004`, 5.56941532783317`}\)},
              {\({0.6700000000000004`, 5.2099349990078005`}\)},
              {\({0.6800000000000004`, 4.8330247890582285`}\)},
              {\({0.6900000000000004`, 4.4387937046339525`}\)},
              {\({0.7000000000000004`, 4.027350066194549`}\)},
              {\({0.7100000000000004`, 3.598801515511674`}\)},
              {\({0.7200000000000004`, 3.1532550208336487`}\)},
              {\({0.7300000000000004`, 2.6908168813610582`}\)},
              {\({0.7400000000000004`, 2.2115927315061614`}\)},
              {\({0.7500000000000004`, 1.7156875450721358`}\)},
              {\({0.7600000000000005`, 1.2032056393906059`}\)},
              {\({0.7700000000000005`, 0.6742506794285362`}\)},
              {\({0.7800000000000005`, 0.1289256818683275`}\)},
              {\({0.7900000000000005`, \(-0.937853466017493`\)}\)},
              {\({0.8000000000000005`, \(-2.6637647853178006`\)}\)},
              {\({0.8100000000000005`, \(-4.572691177478099`\)}\)},
              {\({0.8200000000000005`, \(-6.521930253252821`\)}\)},
              {\({0.8300000000000005`, \(-8.464950235370438`\)}\)},
              {\({0.8400000000000005`, \(-10.383046099906254`\)}\)},
              {\({0.8500000000000005`, \(-12.265665502413219`\)}\)},
              {\({0.8600000000000005`, \(-14.104758730442018`\)}\)},
              {\({0.8700000000000006`, \(-15.89316906825059`\)}\)},
              {\({0.8800000000000006`, \(-17.624186622374978`\)}\)},
              {\({0.8900000000000006`, \(-19.291436521069947`\)}\)},
              {\({0.9000000000000006`, \(-20.88886251854435`\)}\)},
              {\({0.9100000000000006`, \(-22.41073708788835`\)}\)},
              {\({0.9200000000000006`, \(-23.85167809355899`\)}\)},
              {\({0.9300000000000006`, \(-25.206666260727157`\)}\)},
              {\({0.9400000000000006`, \(-26.471061734172622`\)}\)},
              {\({0.9500000000000006`, \(-27.640619198601417`\)}\)},
              {\({0.9600000000000006`, \(-28.71150137698252`\)}\)},
              {\({0.9700000000000006`, \(-29.634686283780272`\)}\)},
              {\({0.9800000000000006`, \(-30.437839650851785`\)}\)},
              {\({0.9900000000000007`, \(-31.21726026849402`\)}\)},
              {\({1.0000000000000007`, \(-32.00048203197957`\)}\)},
              {\({1.0100000000000007`, \(-32.785503674515`\)}\)},
              {\({1.0200000000000007`, \(-33.564728183690704`\)}\)},
              {\({1.0300000000000007`, \(-34.3388252166379`\)}\)},
              {\({1.0400000000000007`, \(-35.10800838147869`\)}\)},
              {\({1.0500000000000007`, \(-35.87236044056716`\)}\)},
              {\({1.0600000000000007`, \(-36.63192651927517`\)}\)},
              {\({1.0700000000000007`, \(-37.38674082181666`\)}\)},
              {\({1.0800000000000007`, \(-38.1368342892252`\)}\)},
              {\({1.0900000000000007`, \(-38.882236795072664`\)}\)},
              {\({1.1000000000000008`, \(-39.622977775620555`\)}\)},
              {\({1.1100000000000008`, \(-40.359086411251646`\)}\)},
              {\({1.1200000000000008`, \(-41.090591679287535`\)}\)},
              {\({1.1300000000000008`, \(-41.817522369938196`\)}\)},
              {\({1.1400000000000008`, \(-42.53990709167928`\)}\)},
              {\({1.1500000000000008`, \(-43.25777427359486`\)}\)},
              {\({1.1600000000000008`, \(-43.97115216684447`\)}\)},
              {\({1.1700000000000008`, \(-44.6800688458748`\)}\)},
              {\({1.1800000000000008`, \(-45.384552209553796`\)}\)},
              {\({1.1900000000000008`, \(-46.08462998227634`\)}\)},
              {\({1.2000000000000008`, \(-46.78032971505769`\)}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 
            0}, {.01, .0098139677361230651}, {.02, .039161571319501355}, \
{.029999999999999999, .087799600133686206}, {.040000000000000001, \
.15538881608281158}, {.050000000000000003, .24151174029696681}, \
{.060000000000000005, .34567944839888437}, {.070000000000000007, \
.46733537753752036}, {.080000000000000002, .60585844266110167}, \
{.089999999999999997, .76056611473448565}, {.099999999999999992, \
.93071763908994554}, {.10999999999999999, 
            1.1155174348488663}, {.11999999999999998, 
            1.3141186763316042}, {.12999999999999998, 
            1.5256270454174632}, {.13999999999999999, 
            1.749104639996635}, {.14999999999999999, 
            1.9835740222290739}, {.16, 
            2.2280223896380145}, {.17000000000000001, 
            2.4814058516422786}, {.18000000000000002, 
            2.7426537938351077}, {.19000000000000003, 
            3.010673312108707}, {.20000000000000004, 
            3.2843536985920196}, {.21000000000000005, 
            3.5625709613109722}, {.22000000000000006, 
            3.8441923594942997}, {.23000000000000007, 
            4.1280809365330375}, {.24000000000000007, 
            4.4131000327570638}, {.25000000000000006, 
            4.6981177604162703}, {.26000000000000006, 
            4.982011423545841}, {.27000000000000007, 
            5.2636718657528441}, {.28000000000000008, 
            5.5420077293827053}, {.29000000000000009, 
            5.8159496100077446}, {.3000000000000001, 
            6.0844540907224243}, {.31000000000000011, 
            6.3268797058570634}, {.32000000000000012, 
            6.5228072255143381}, {.33000000000000013, 
            6.6717804006582861}, {.34000000000000014, 
            6.7735756717647542}, {.35000000000000014, 
            6.8281698188099629}, {.36000000000000015, 
            6.8357293952153801}, {.37000000000000016, 
            6.7966059290386927}, {.38000000000000017, 
            6.7113322870741614}, {.39000000000000018, 
            6.5806188879984777}, {.40000000000000019, 
            6.4053494006926748}, {.4100000000000002, 
            6.1865758393591728}, {.42000000000000021, 
            6.142243796671119}, {.43000000000000022, 
            6.3422639342662315}, {.44000000000000022, 
            6.596950658783495}, {.45000000000000023, 
            6.8520334518596098}, {.46000000000000024, 
            7.092053107142732}, {.47000000000000025, 
            7.3126737026557906}, {.48000000000000026, 
            7.5127468165790638}, {.49000000000000027, 
            7.6920370207796029}, {.50000000000000022, 
            7.8505699781492702}, {.51000000000000023, 
            7.9786190326477993}, {.52000000000000024, 
            8.0665308372114701}, {.53000000000000025, 
            8.1145425598214072}, {.54000000000000026, 
            8.1228997558751761}, {.55000000000000027, 
            8.0918492742043231}, {.56000000000000028, 
            8.0216372307815238}, {.57000000000000028, 
            7.9125084348570587}, {.58000000000000029, 
            7.7647062313397415}, {.5900000000000003, 
            7.5784724624363706}, {.60000000000000031, 
            7.354047463429314}, {.61000000000000032, 
            7.1014966371167842}, {.62000000000000033, 
            6.8308312864819882}, {.63000000000000034, 
            6.5421760737204231}, {.64000000000000035, 
            6.2356467628655334}, {.65000000000000036, 
            5.9113560671044789}, {.66000000000000036, 
            5.5694153278331697}, {.67000000000000037, 
            5.2099349990078005}, {.68000000000000038, 
            4.8330247890582285}, {.69000000000000039, 
            4.4387937046339525}, {.7000000000000004, 
            4.0273500661945487}, {.71000000000000041, 
            3.5988015155116742}, {.72000000000000042, 
            3.1532550208336487}, {.73000000000000043, 
            2.6908168813610582}, {.74000000000000044, 
            2.2115927315061614}, {.75000000000000044, 
            1.7156875450721358}, {.76000000000000045, 
            1.2032056393906059}, {.77000000000000046, .67425067942853623}, \
{.78000000000000047, .12892568186832751}, {.79000000000000048, \
-.93785346601749298}, {.80000000000000049, -2.6637647853178006}, \
{.8100000000000005, -4.5726911774780987}, {.82000000000000051, \
-6.5219302532528207}, {.83000000000000052, -8.4649502353704378}, \
{.84000000000000052, -10.383046099906254}, {.85000000000000053, \
-12.265665502413219}, {.86000000000000054, -14.104758730442018}, \
{.87000000000000055, -15.89316906825059}, {.88000000000000056, \
-17.624186622374978}, {.89000000000000057, -19.291436521069947}, \
{.90000000000000058, -20.88886251854435}, {.91000000000000059, \
-22.41073708788835}, {.9200000000000006, -23.851678093558991}, \
{.9300000000000006, -25.206666260727157}, {.94000000000000061, \
-26.471061734172622}, {.95000000000000062, -27.640619198601417}, \
{.96000000000000063, -28.711501376982518}, {.97000000000000064, \
-29.634686283780272}, {.98000000000000065, -30.437839650851785}, \
{.99000000000000066, -31.217260268494019}, {
            1.0000000000000007, -32.000482031979573}, {
            1.0100000000000007, -32.785503674514999}, {
            1.0200000000000007, -33.564728183690704}, {
            1.0300000000000007, -34.3388252166379}, {
            1.0400000000000007, -35.10800838147869}, {
            1.0500000000000007, -35.872360440567157}, {
            1.0600000000000007, -36.631926519275169}, {
            1.0700000000000007, -37.386740821816659}, {
            1.0800000000000007, -38.136834289225199}, {
            1.0900000000000007, -38.882236795072664}, {
            1.1000000000000008, -39.622977775620555}, {
            1.1100000000000008, -40.359086411251646}, {
            1.1200000000000008, -41.090591679287535}, {
            1.1300000000000008, -41.817522369938196}, {
            1.1400000000000008, -42.539907091679282}, {
            1.1500000000000008, -43.257774273594862}, {
            1.1600000000000008, -43.971152166844469}, {
            1.1700000000000008, -44.6800688458748}, {
            1.1800000000000008, -45.384552209553796}, {
            1.1900000000000008, -46.08462998227634}, {
            1.2000000000000008, -46.78032971505769}}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {\({0, 0.`}\)},
              {\({0.01`, 1.9627935472246127`}\)},
              {\({0.02`, 3.906727169451045`}\)},
              {\({0.03`, 5.820878593385925`}\)},
              {\({0.04`, 7.696964596439152`}\)},
              {\({0.05`, 9.527620246391892`}\)},
              {\({0.060000000000000005`, 11.305921373991628`}\)},
              {\({0.07`, 13.02526445373557`}\)},
              {\({0.08`, 14.67934857098071`}\)},
              {\({0.09`, 16.262185843696088`}\)},
              {\({0.09999999999999999`, 17.76811902739586`}\)},
              {\({0.10999999999999999`, 19.191840124388328`}\)},
              {\({0.11999999999999998`, 20.528408172159256`}\)},
              {\({0.12999999999999998`, 21.773265645012565`}\)},
              {\({0.13999999999999999`, 22.922253270821727`}\)},
              {\({0.15`, 23.97162317566605`}\)},
              {\({0.16`, 24.91805030612198`}\)},
              {\({0.17`, 25.758642094730806`}\)},
              {\({0.18000000000000002`, 26.490946343835013`}\)},
              {\({0.19000000000000003`, 27.11295731088476`}\)},
              {\({0.20000000000000004`, 27.623119985777805`}\)},
              {\({0.21000000000000005`, 28.02033255801275`}\)},
              {\({0.22000000000000006`, 28.30394707865284`}\)},
              {\({0.23000000000000007`, 28.47376832909481`}\)},
              {\({0.24000000000000007`, 28.530050915710234`}\)},
              {\({0.25000000000000006`, 28.47349461613112`}\)},
              {\({0.26000000000000006`, 28.305238009782997`}\)},
              {\({0.2700000000000001`, 28.026850431617554`}\)},
              {\({0.2800000000000001`, 27.64032229435427`}\)},
              {\({0.2900000000000001`, 27.148053830653577`}\)},
              {\({0.3000000000000001`, 26.552842312282195`}\)},
              {\({0.3100000000000001`, 21.932280714645653`}\)},
              {\({0.3200000000000001`, 17.253223216809086`}\)},
              {\({0.3300000000000001`, 12.541411811980623`}\)},
              {\({0.34000000000000014`, 7.817642409313132`}\)},
              {\({0.35000000000000014`, 3.1011869997285846`}\)},
              {\({0.36000000000000015`, \(-1.5892717186454792`\)}\)},
              {\({0.37000000000000016`, \(-6.235421516692374`\)}\)},
              {\({0.38000000000000017`, \(-10.819306876213703`\)}\)},
              {\({0.3900000000000002`, \(-15.323372938923299`\)}\)},
              {\({0.4000000000000002`, \(-19.73052452223726`\)}\)},
              {\({0.4100000000000002`, \(-24.024187744462974`\)}\)},
              {\({0.4200000000000002`, 15.15777920685247`}\)},
              {\({0.4300000000000002`, 24.846248312169983`}\)},
              {\({0.4400000000000002`, 26.0910965912826`}\)},
              {\({0.45000000000000023`, 24.925462023940383`}\)},
              {\({0.46000000000000024`, 23.078469032683774`}\)},
              {\({0.47000000000000025`, 21.045650069927675`}\)},
              {\({0.48000000000000026`, 18.96897271472652`}\)},
              {\({0.49000000000000027`, 16.889068125381026`}\)},
              {\({0.5000000000000002`, 14.817523348552498`}\)},
              {\({0.5100000000000002`, 10.792287551153194`}\)},
              {\({0.5200000000000002`, 6.7900733615811895`}\)},
              {\({0.5300000000000002`, 2.812271160406425`}\)},
              {\({0.5400000000000003`, \(-1.1408319496525952`\)}\)},
              {\({0.5500000000000003`, \(-5.0692643845181085`\)}\)},
              {\({0.5600000000000003`, \(-8.973144300041861`\)}\)},
              {\({0.5700000000000003`, \(-12.852614884851365`\)}\)},
              {\({0.5800000000000003`, \(-16.707825818611937`\)}\)},
              {\({0.5900000000000003`, \(-20.538927962062434`\)}\)},
              {\({0.6000000000000003`, \(-24.346071839348674`\)}\)},
              {\({0.6100000000000003`, \(-26.16409342315721`\)}\)},
              {\({0.6200000000000003`, \(-27.96897670380195`\)}\)},
              {\({0.6300000000000003`, \(-29.76206584851084`\)}\)},
              {\({0.6400000000000003`, \(-31.543796322467067`\)}\)},
              {\({0.6500000000000004`, \(-33.3143428297442`\)}\)},
              {\({0.6600000000000004`, \(-35.073805024517625`\)}\)},
              {\({0.6700000000000004`, \(-36.822260740556224`\)}\)},
              {\({0.6800000000000004`, \(-38.55978124935799`\)}\)},
              {\({0.6900000000000004`, \(-40.2864356354973`\)}\)},
              {\({0.7000000000000004`, \(-42.00229205238335`\)}\)},
              {\({0.7100000000000004`, \(-43.70741808419163`\)}\)},
              {\({0.7200000000000004`, \(-45.401880851413374`\)}\)},
              {\({0.7300000000000004`, \(-47.085747043104654`\)}\)},
              {\({0.7400000000000004`, \(-48.75908292787474`\)}\)},
              {\({0.7500000000000004`, \(-50.421954358930314`\)}\)},
              {\({0.7600000000000005`, \(-52.0744267773757`\)}\)},
              {\({0.7700000000000005`, \(-53.71656521503819`\)}\)},
              {\({0.7800000000000005`, \(-55.34843429700354`\)}\)},
              {\({0.7900000000000005`, \(-158.0073952801605`\)}\)},
              {\({0.8000000000000005`, \(-187.174868579901`\)}\)},
              {\({0.8100000000000005`, \(-194.61040985215868`\)}\)},
              {\({0.8200000000000005`, \(-195.23740530278565`\)}\)},
              {\({0.8300000000000005`, \(-193.36659112073818`\)}\)},
              {\({0.8400000000000005`, \(-190.25258178642514`\)}\)},
              {\({0.8500000000000005`, \(-186.27129871496763`\)}\)},
              {\({0.8600000000000005`, \(-181.5473468907921`\)}\)},
              {\({0.8700000000000006`, \(-176.1347206709221`\)}\)},
              {\({0.8800000000000006`, \(-170.06879015395526`\)}\)},
              {\({0.8900000000000006`, \(-163.38118958503824`\)}\)},
              {\({0.9000000000000006`, \(-156.10400990984283`\)}\)},
              {\({0.9100000000000006`, \(-148.27090395895604`\)}\)},
              {\({0.9200000000000006`, \(-139.91729717517194`\)}\)},
              {\({0.9300000000000006`, \(-131.08033625846164`\)}\)},
              {\({0.9400000000000006`, \(-121.79875843063192`\)}\)},
              {\({0.9500000000000006`, \(-112.11273445512816`\)}\)},
              {\({0.9600000000000006`, \(-102.06370122109271`\)}\)},
              {\({0.9700000000000006`, \(-82.57328013845866`\)}\)},
              {\({0.9800000000000006`, \(-78.05739327584257`\)}\)},
              {\({0.9900000000000007`, \(-77.82673025260654`\)}\)},
              {\({1.0000000000000007`, \(-78.81762244450347`\)}\)},
              {\({1.0100000000000007`, \(-78.18670606258253`\)}\)},
              {\({1.0200000000000007`, \(-77.65819577256089`\)}\)},
              {\({1.0300000000000007`, \(-77.16121081687956`\)}\)},
              {\({1.0400000000000007`, \(-76.67542215127668`\)}\)},
              {\({1.0500000000000007`, \(-76.19498966641842`\)}\)},
              {\({1.0600000000000007`, \(-75.71822607518571`\)}\)},
              {\({1.0700000000000007`, \(-75.24463443311303`\)}\)},
              {\({1.0800000000000007`, \(-74.77405904859431`\)}\)},
              {\({1.0900000000000007`, \(-74.30644212089915`\)}\)},
              {\({1.1000000000000008`, \(-73.84175398867909`\)}\)},
              {\({1.1100000000000008`, \(-73.37997313753972`\)}\)},
              {\({1.1200000000000008`, \(-72.92108046963773`\)}\)},
              {\({1.1300000000000008`, \(-72.46505766049391`\)}\)},
              {\({1.1400000000000008`, \(-72.01188668772363`\)}\)},
              {\({1.1500000000000008`, \(-71.5615496953894`\)}\)},
              {\({1.1600000000000008`, \(-71.11402895453288`\)}\)},
              {\({1.1700000000000008`, \(-70.66930685153234`\)}\)},
              {\({1.1800000000000008`, \(-70.22736588426628`\)}\)},
              {\({1.1900000000000008`, \(-69.78818866024231`\)}\)},
              {\({1.2000000000000008`, \(-69.35175789602715`\)}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 0.0}, {.01, 1.9627935472246127}, {.02, 
            3.9067271694510448}, {.029999999999999999, 
            5.8208785933859248}, {.040000000000000001, 
            7.6969645964391518}, {.050000000000000003, 
            9.5276202463918924}, {.060000000000000005, 
            11.305921373991628}, {.070000000000000007, 
            13.02526445373557}, {.080000000000000002, 
            14.679348570980711}, {.089999999999999997, 
            16.262185843696088}, {.099999999999999992, 
            17.768119027395858}, {.10999999999999999, 
            19.191840124388328}, {.11999999999999998, 
            20.528408172159256}, {.12999999999999998, 
            21.773265645012565}, {.13999999999999999, 
            22.922253270821727}, {.14999999999999999, 
            23.97162317566605}, {.16, 24.91805030612198}, {.17000000000000001,
             25.758642094730806}, {.18000000000000002, 
            26.490946343835013}, {.19000000000000003, 
            27.112957310884759}, {.20000000000000004, 
            27.623119985777805}, {.21000000000000005, 
            28.02033255801275}, {.22000000000000006, 
            28.30394707865284}, {.23000000000000007, 
            28.47376832909481}, {.24000000000000007, 
            28.530050915710234}, {.25000000000000006, 
            28.47349461613112}, {.26000000000000006, 
            28.305238009782997}, {.27000000000000007, 
            28.026850431617554}, {.28000000000000008, 
            27.64032229435427}, {.29000000000000009, 
            27.148053830653577}, {.3000000000000001, 
            26.552842312282195}, {.31000000000000011, 
            21.932280714645653}, {.32000000000000012, 
            17.253223216809086}, {.33000000000000013, 
            12.541411811980623}, {.34000000000000014, 
            7.817642409313132}, {.35000000000000014, 
            3.1011869997285846}, {.36000000000000015, -1.5892717186454792}, \
{.37000000000000016, -6.2354215166923739}, {.38000000000000017, \
-10.819306876213703}, {.39000000000000018, -15.323372938923299}, \
{.40000000000000019, -19.73052452223726}, {.4100000000000002, \
-24.024187744462974}, {.42000000000000021, 
            15.157779206852471}, {.43000000000000022, 
            24.846248312169983}, {.44000000000000022, 
            26.0910965912826}, {.45000000000000023, 
            24.925462023940383}, {.46000000000000024, 
            23.078469032683774}, {.47000000000000025, 
            21.045650069927675}, {.48000000000000026, 
            18.968972714726519}, {.49000000000000027, 
            16.889068125381026}, {.50000000000000022, 
            14.817523348552498}, {.51000000000000023, 
            10.792287551153194}, {.52000000000000024, 
            6.7900733615811895}, {.53000000000000025, 
            2.812271160406425}, {.54000000000000026, -1.1408319496525952}, \
{.55000000000000027, -5.0692643845181085}, {.56000000000000028, \
-8.9731443000418611}, {.57000000000000028, -12.852614884851365}, \
{.58000000000000029, -16.707825818611937}, {.5900000000000003, \
-20.538927962062434}, {.60000000000000031, -24.346071839348674}, \
{.61000000000000032, -26.164093423157212}, {.62000000000000033, \
-27.96897670380195}, {.63000000000000034, -29.76206584851084}, \
{.64000000000000035, -31.543796322467067}, {.65000000000000036, \
-33.314342829744199}, {.66000000000000036, -35.073805024517625}, \
{.67000000000000037, -36.822260740556224}, {.68000000000000038, \
-38.559781249357989}, {.69000000000000039, -40.286435635497298}, \
{.7000000000000004, -42.002292052383353}, {.71000000000000041, \
-43.70741808419163}, {.72000000000000042, -45.401880851413374}, \
{.73000000000000043, -47.085747043104654}, {.74000000000000044, \
-48.759082927874744}, {.75000000000000044, -50.421954358930314}, \
{.76000000000000045, -52.074426777375699}, {.77000000000000046, \
-53.716565215038187}, {.78000000000000047, -55.348434297003543}, \
{.79000000000000048, -158.00739528016049}, {.80000000000000049, \
-187.17486857990099}, {.8100000000000005, -194.61040985215868}, \
{.82000000000000051, -195.23740530278565}, {.83000000000000052, \
-193.36659112073818}, {.84000000000000052, -190.25258178642514}, \
{.85000000000000053, -186.27129871496763}, {.86000000000000054, \
-181.54734689079211}, {.87000000000000055, -176.13472067092209}, \
{.88000000000000056, -170.06879015395526}, {.89000000000000057, \
-163.38118958503824}, {.90000000000000058, -156.10400990984283}, \
{.91000000000000059, -148.27090395895604}, {.9200000000000006, \
-139.91729717517194}, {.9300000000000006, -131.08033625846164}, \
{.94000000000000061, -121.79875843063192}, {.95000000000000062, \
-112.11273445512816}, {.96000000000000063, -102.06370122109271}, \
{.97000000000000064, -82.573280138458657}, {.98000000000000065, \
-78.057393275842571}, {.99000000000000066, -77.826730252606538}, {
            1.0000000000000007, -78.817622444503471}, {
            1.0100000000000007, -78.18670606258253}, {
            1.0200000000000007, -77.658195772560887}, {
            1.0300000000000007, -77.16121081687956}, {
            1.0400000000000007, -76.675422151276678}, {
            1.0500000000000007, -76.194989666418422}, {
            1.0600000000000007, -75.718226075185711}, {
            1.0700000000000007, -75.244634433113035}, {
            1.0800000000000007, -74.77405904859431}, {
            1.0900000000000007, -74.306442120899149}, {
            1.1000000000000008, -73.841753988679088}, {
            1.1100000000000008, -73.379973137539722}, {
            1.1200000000000008, -72.921080469637729}, {
            1.1300000000000008, -72.465057660493912}, {
            1.1400000000000008, -72.011886687723631}, {
            1.1500000000000008, -71.561549695389402}, {
            1.1600000000000008, -71.114028954532884}, {
            1.1700000000000008, -70.66930685153234}, {
            1.1800000000000008, -70.227365884266277}, {
            1.1900000000000008, -69.788188660242312}, {
            1.2000000000000008, -69.351757896027152}}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {\({0, 10}\)},
              {\({0.01`, 10}\)},
              {\({0.02`, 10}\)},
              {\({0.03`, 10}\)},
              {\({0.04`, 10}\)},
              {\({0.05`, 10}\)},
              {\({0.060000000000000005`, 10}\)},
              {\({0.07`, 10}\)},
              {\({0.08`, 10}\)},
              {\({0.09`, 10}\)},
              {\({0.09999999999999999`, 10}\)},
              {\({0.10999999999999999`, 10}\)},
              {\({0.11999999999999998`, 10}\)},
              {\({0.12999999999999998`, 10}\)},
              {\({0.13999999999999999`, 10}\)},
              {\({0.15`, 10}\)},
              {\({0.16`, 10}\)},
              {\({0.17`, 10}\)},
              {\({0.18000000000000002`, 10}\)},
              {\({0.19000000000000003`, 10}\)},
              {\({0.20000000000000004`, 10}\)},
              {\({0.21000000000000005`, 10}\)},
              {\({0.22000000000000006`, 10}\)},
              {\({0.23000000000000007`, 10}\)},
              {\({0.24000000000000007`, 10}\)},
              {\({0.25000000000000006`, 10}\)},
              {\({0.26000000000000006`, 10}\)},
              {\({0.2700000000000001`, 10}\)},
              {\({0.2800000000000001`, 10}\)},
              {\({0.2900000000000001`, 10}\)},
              {\({0.3000000000000001`, 10}\)},
              {\({0.3100000000000001`, 10}\)},
              {\({0.3200000000000001`, 10}\)},
              {\({0.3300000000000001`, 10}\)},
              {\({0.34000000000000014`, 10}\)},
              {\({0.35000000000000014`, 10}\)},
              {\({0.36000000000000015`, 10}\)},
              {\({0.37000000000000016`, 10}\)},
              {\({0.38000000000000017`, 10}\)},
              {\({0.3900000000000002`, 10}\)},
              {\({0.4000000000000002`, 10}\)},
              {\({0.4100000000000002`, 10}\)},
              {\({0.4200000000000002`, 0}\)},
              {\({0.4300000000000002`, 0}\)},
              {\({0.4400000000000002`, 0}\)},
              {\({0.45000000000000023`, 0}\)},
              {\({0.46000000000000024`, 0}\)},
              {\({0.47000000000000025`, 0}\)},
              {\({0.48000000000000026`, 0}\)},
              {\({0.49000000000000027`, 0}\)},
              {\({0.5000000000000002`, 0}\)},
              {\({0.5100000000000002`, 0}\)},
              {\({0.5200000000000002`, 0}\)},
              {\({0.5300000000000002`, 0}\)},
              {\({0.5400000000000003`, 0}\)},
              {\({0.5500000000000003`, 0}\)},
              {\({0.5600000000000003`, 0}\)},
              {\({0.5700000000000003`, 0}\)},
              {\({0.5800000000000003`, 0}\)},
              {\({0.5900000000000003`, 0}\)},
              {\({0.6000000000000003`, 0}\)},
              {\({0.6100000000000003`, 0}\)},
              {\({0.6200000000000003`, 0}\)},
              {\({0.6300000000000003`, 0}\)},
              {\({0.6400000000000003`, 0}\)},
              {\({0.6500000000000004`, 0}\)},
              {\({0.6600000000000004`, 0}\)},
              {\({0.6700000000000004`, 0}\)},
              {\({0.6800000000000004`, 0}\)},
              {\({0.6900000000000004`, 0}\)},
              {\({0.7000000000000004`, 0}\)},
              {\({0.7100000000000004`, 0}\)},
              {\({0.7200000000000004`, 0}\)},
              {\({0.7300000000000004`, 0}\)},
              {\({0.7400000000000004`, 0}\)},
              {\({0.7500000000000004`, 0}\)},
              {\({0.7600000000000005`, 0}\)},
              {\({0.7700000000000005`, 0}\)},
              {\({0.7800000000000005`, 0}\)},
              {\({0.7900000000000005`, 10}\)},
              {\({0.8000000000000005`, 10}\)},
              {\({0.8100000000000005`, 10}\)},
              {\({0.8200000000000005`, 10}\)},
              {\({0.8300000000000005`, 10}\)},
              {\({0.8400000000000005`, 10}\)},
              {\({0.8500000000000005`, 10}\)},
              {\({0.8600000000000005`, 10}\)},
              {\({0.8700000000000006`, 10}\)},
              {\({0.8800000000000006`, 10}\)},
              {\({0.8900000000000006`, 10}\)},
              {\({0.9000000000000006`, 10}\)},
              {\({0.9100000000000006`, 10}\)},
              {\({0.9200000000000006`, 10}\)},
              {\({0.9300000000000006`, 10}\)},
              {\({0.9400000000000006`, 10}\)},
              {\({0.9500000000000006`, 10}\)},
              {\({0.9600000000000006`, 10}\)},
              {\({0.9700000000000006`, 0}\)},
              {\({0.9800000000000006`, 0}\)},
              {\({0.9900000000000007`, 0}\)},
              {\({1.0000000000000007`, 0}\)},
              {\({1.0100000000000007`, 0}\)},
              {\({1.0200000000000007`, 0}\)},
              {\({1.0300000000000007`, 0}\)},
              {\({1.0400000000000007`, 0}\)},
              {\({1.0500000000000007`, 0}\)},
              {\({1.0600000000000007`, 0}\)},
              {\({1.0700000000000007`, 0}\)},
              {\({1.0800000000000007`, 0}\)},
              {\({1.0900000000000007`, 0}\)},
              {\({1.1000000000000008`, 0}\)},
              {\({1.1100000000000008`, 0}\)},
              {\({1.1200000000000008`, 0}\)},
              {\({1.1300000000000008`, 0}\)},
              {\({1.1400000000000008`, 0}\)},
              {\({1.1500000000000008`, 0}\)},
              {\({1.1600000000000008`, 0}\)},
              {\({1.1700000000000008`, 0}\)},
              {\({1.1800000000000008`, 0}\)},
              {\({1.1900000000000008`, 0}\)},
              {\({1.2000000000000008`, 0}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 10}, {.01, 10}, {.02, 10}, {.029999999999999999, 
            10}, {.040000000000000001, 10}, {.050000000000000003, 
            10}, {.060000000000000005, 10}, {.070000000000000007, 
            10}, {.080000000000000002, 10}, {.089999999999999997, 
            10}, {.099999999999999992, 10}, {.10999999999999999, 
            10}, {.11999999999999998, 10}, {.12999999999999998, 
            10}, {.13999999999999999, 10}, {.14999999999999999, 10}, {.16, 
            10}, {.17000000000000001, 10}, {.18000000000000002, 
            10}, {.19000000000000003, 10}, {.20000000000000004, 
            10}, {.21000000000000005, 10}, {.22000000000000006, 
            10}, {.23000000000000007, 10}, {.24000000000000007, 
            10}, {.25000000000000006, 10}, {.26000000000000006, 
            10}, {.27000000000000007, 10}, {.28000000000000008, 
            10}, {.29000000000000009, 10}, {.3000000000000001, 
            10}, {.31000000000000011, 10}, {.32000000000000012, 
            10}, {.33000000000000013, 10}, {.34000000000000014, 
            10}, {.35000000000000014, 10}, {.36000000000000015, 
            10}, {.37000000000000016, 10}, {.38000000000000017, 
            10}, {.39000000000000018, 10}, {.40000000000000019, 
            10}, {.4100000000000002, 10}, {.42000000000000021, 
            0}, {.43000000000000022, 0}, {.44000000000000022, 
            0}, {.45000000000000023, 0}, {.46000000000000024, 
            0}, {.47000000000000025, 0}, {.48000000000000026, 
            0}, {.49000000000000027, 0}, {.50000000000000022, 
            0}, {.51000000000000023, 0}, {.52000000000000024, 
            0}, {.53000000000000025, 0}, {.54000000000000026, 
            0}, {.55000000000000027, 0}, {.56000000000000028, 
            0}, {.57000000000000028, 0}, {.58000000000000029, 
            0}, {.5900000000000003, 0}, {.60000000000000031, 
            0}, {.61000000000000032, 0}, {.62000000000000033, 
            0}, {.63000000000000034, 0}, {.64000000000000035, 
            0}, {.65000000000000036, 0}, {.66000000000000036, 
            0}, {.67000000000000037, 0}, {.68000000000000038, 
            0}, {.69000000000000039, 0}, {.7000000000000004, 
            0}, {.71000000000000041, 0}, {.72000000000000042, 
            0}, {.73000000000000043, 0}, {.74000000000000044, 
            0}, {.75000000000000044, 0}, {.76000000000000045, 
            0}, {.77000000000000046, 0}, {.78000000000000047, 
            0}, {.79000000000000048, 10}, {.80000000000000049, 
            10}, {.8100000000000005, 10}, {.82000000000000051, 
            10}, {.83000000000000052, 10}, {.84000000000000052, 
            10}, {.85000000000000053, 10}, {.86000000000000054, 
            10}, {.87000000000000055, 10}, {.88000000000000056, 
            10}, {.89000000000000057, 10}, {.90000000000000058, 
            10}, {.91000000000000059, 10}, {.9200000000000006, 
            10}, {.9300000000000006, 10}, {.94000000000000061, 
            10}, {.95000000000000062, 10}, {.96000000000000063, 
            10}, {.97000000000000064, 0}, {.98000000000000065, 
            0}, {.99000000000000066, 0}, {1.0000000000000007, 0}, {
            1.0100000000000007, 0}, {1.0200000000000007, 0}, {
            1.0300000000000007, 0}, {1.0400000000000007, 0}, {
            1.0500000000000007, 0}, {1.0600000000000007, 0}, {
            1.0700000000000007, 0}, {1.0800000000000007, 0}, {
            1.0900000000000007, 0}, {1.1000000000000008, 0}, {
            1.1100000000000008, 0}, {1.1200000000000008, 0}, {
            1.1300000000000008, 0}, {1.1400000000000008, 0}, {
            1.1500000000000008, 0}, {1.1600000000000008, 0}, {
            1.1700000000000008, 0}, {1.1800000000000008, 0}, {
            1.1900000000000008, 0}, {1.2000000000000008, 0}}],
          Editable->False]}],
      SequenceForm[ 
        ColumnForm[ {
          0, .01, .02, .029999999999999999, .040000000000000001, \
.050000000000000003, .059999999999999998, .070000000000000007, \
.080000000000000002, .089999999999999997, .10000000000000001, .11, .12, .13, \
.14000000000000001, .14999999999999999, .16, .17000000000000001, \
.17999999999999999, .19, .20000000000000001, .20999999999999999, .22, \
.23000000000000001, .23999999999999999, .25, .26000000000000001, \
.27000000000000002, .28000000000000003, .28999999999999998, \
.29999999999999999, .31, .32000000000000001, .33000000000000002, \
.34000000000000002, .35000000000000003, .35999999999999999, .37, .38, \
.39000000000000001, .40000000000000002, .41000000000000003, \
.41999999999999998, .42999999999999999, .44, .45000000000000001, \
.46000000000000002, .47000000000000003, .47999999999999998, \
.48999999999999999, .5, .51000000000000001, .52000000000000002, \
.53000000000000003, .54000000000000004, .55000000000000004, \
.56000000000000005, .57000000000000006, .57999999999999996, \
.58999999999999997, .59999999999999998, .60999999999999999, .62, .63, \
.64000000000000001, .65000000000000002, .66000000000000003, \
.67000000000000004, .68000000000000005, .69000000000000006, \
.70000000000000007, .70999999999999996, .71999999999999997, \
.72999999999999998, .73999999999999999, .75, .76000000000000001, \
.77000000000000002, .78000000000000003, .79000000000000004, \
.80000000000000004, .81000000000000005, .82000000000000006, \
.83000000000000007, .83999999999999997, .84999999999999998, \
.85999999999999999, .87, .88, .89000000000000001, .90000000000000002, \
.91000000000000003, .92000000000000004, .93000000000000005, \
.94000000000000006, .95000000000000007, .95999999999999996, \
.96999999999999997, .97999999999999998, .98999999999999999, 1.0, 1.01, 1.02, 
          1.03, 1.04, 1.05, 1.0600000000000001, 1.0700000000000001, 
          1.0800000000000001, 1.0900000000000001, 1.1000000000000001, 
          1.1100000000000001, 1.1200000000000001, 1.1300000000000001, 
          1.1400000000000001, 1.1500000000000001, 1.1599999999999999, 
          1.1699999999999999, 1.1799999999999999, 1.1899999999999999, 1.2}], 
        "  ", 
        ColumnForm[ {0.0, .49999999999999911, 1.0, 1.4999999999999996, 
          1.9999999999999996, 2.5, 2.9999999999999996, 3.5, 4.0, 4.5, 5.0, 
          5.4999999999999991, 5.9999999999999991, 6.5, 7.0, 
          7.4999999999999991, 8.0, 8.5, 9.0, 9.5, .1*^2, 10.5, 11.0, 11.5, 
          12.0, 12.5, 13.0, 13.500000000000002, 14.000000000000002, 14.5, 
          15.0, 14.5, 14.0, 13.5, 12.999999999999998, 12.499999999999998, 
          12.0, 11.5, 11.0, 10.5, .1*^2, 9.5, 9.0000000000000018, 
          8.5000000000000018, 8.0, 7.5, 7.0, 6.4999999999999991, 
          6.0000000000000009, 5.5000000000000009, 5.0, 4.0, 
          2.9999999999999982, 
          1.9999999999999973, .99999999999999556, -.53290705182007514*^-14, \
-1.0000000000000062, -2.0000000000000075, -2.9999999999999978, \
-3.9999999999999991, -5.0, -5.5000000000000009, -6.0000000000000009, \
-6.5000000000000018, -7.0000000000000018, -7.5000000000000036, \
-8.0000000000000036, -8.5000000000000036, -9.0000000000000036, \
-9.5000000000000053, -10.000000000000005, -10.5, -11.0, -11.5, -12.0, -12.5, \
-13.0, -13.5, -14.0, -14.5, -15.0, -15.5, -16.0, -16.5, -16.999999999999996, \
-17.499999999999996, -17.999999999999996, -18.5, -19.0, -19.5, -.2*^2, -20.5, \
-21.0, -21.5, -22.000000000000004, -22.500000000000004, -22.999999999999996, \
-23.5, -24.0, -24.5, -25.0, -25.0, -25.0, -25.0, -25.0, -25.0, -25.0, -25.0, \
-25.0, -25.0, -25.0, -25.0, -25.0, -25.0, -25.0, -25.0, -25.0, -25.0, -25.0, \
-25.0, -25.0}], "  ", 
        ColumnForm[ {{0, 
          0}, {.01, .000032713225787076884}, {.02, .00035485783360496032}, \
{.029999999999999999, .0011597470561214905}, {.040000000000000001, \
.0026372397821016755}, {.050000000000000003, .004973009223890921}, \
{.060000000000000005, .0083478421935159839}, {.070000000000000007, \
.012936965672485456}, {.080000000000000002, .018909401427441314}, \
{.089999999999999997, .026427350502431418}, {.099999999999999992, \
.035645609630436843}, {.10999999999999999, .046711021563722435}, \
{.11999999999999998, .059761961201340433}, {.12999999999999998, \
.074927859244105291}, {.13999999999999999, .092328764947866071}, \
{.14999999999999999, .1120749493798267}, {.16, .13426655041191626}, \
{.17000000000000001, .15899326051084703}, {.18000000000000002, \
.18633405820733576}, {.19000000000000003, .21635698394775013}, \
{.20000000000000004, .24911896085090987}, {.21000000000000005, \
.28466566071164562}, {.22000000000000006, .32303141541171493}, \
{.23000000000000007, .36423917371851}, {.24000000000000007, \
.40830050327336231}, {.25000000000000006, .45521563739485454}, \
{.26000000000000006, .50497356614905764}, {.27000000000000007, \
.55755217096869203}, {.28000000000000008, .61291840193749536}, \
{.29000000000000009, .67102849669518583}, {.3000000000000001, \
.73182823976294942}, {.31000000000000011, .79518783448831676}, \
{.32000000000000012, .86051965561073407}, {.33000000000000013, \
.92735344089458083}, {.34000000000000014, .99521679608800317}, \
{.35000000000000014, 1.0636370960221144}, {.36000000000000015, 
          1.1321433548196431}, {.37000000000000016, 
          1.2002680697502475}, {.38000000000000017, 
          1.2675490350413461}, {.39000000000000018, 
          1.3335311197112214}, {.40000000000000019, 
          1.3977680029922086}, {.4100000000000002, 
          1.4598238609325465}, {.42000000000000021, 
          1.5199974337812243}, {.43000000000000022, 
          1.583061034203217}, {.44000000000000022, 
          1.6489298881143382}, {.45000000000000023, 
          1.7174269554599617}, {.46000000000000024, 
          1.7883497066262786}, {.47000000000000025, 
          1.8614892555491362}, {.48000000000000026, 
          1.936635837602791}, {.49000000000000027, 
          2.0135803737428155}, {.50000000000000022, 
          2.0921149129499041}, {.51000000000000023, 
          2.1719999979854654}, {.52000000000000024, 
          2.2527730175744916}, {.53000000000000025, 
          2.3340348697380744}, {.54000000000000026, 
          2.4153889415167797}, {.55000000000000027, 
          2.4964410982731984}, {.56000000000000028, 
          2.5767996695886368}, {.57000000000000028, 
          2.6560754342526534}, {.58000000000000029, 
          2.7338816050611876}, {.5900000000000003, 
          2.8098338136279963}, {.60000000000000031, 
          2.8835500952676325}, {.61000000000000032, 
          2.9546836291959733}, {.62000000000000033, 
          3.023114400297346}, {.63000000000000034, 
          3.0886625234743832}, {.64000000000000035, 
          3.1511492441803814}, {.65000000000000036, 
          3.2103969273452941}, {.66000000000000036, 
          3.2662290492273316}, {.67000000000000037, 
          3.3184701901341929}, {.68000000000000038, 
          3.3669460274244507}, {.69000000000000039, 
          3.4114833286199699}, {.7000000000000004, 
          3.4519099445806578}, {.71000000000000041, 
          3.4880548027274356}, {.72000000000000042, 
          3.5197479003091656}, {.73000000000000043, 
          3.5468202977121455}, {.74000000000000044, 
          3.5691041118115638}, {.75000000000000044, 
          3.5864325093645775}, {.76000000000000045, 
          3.5986397004447146}, {.77000000000000046, 
          3.6055609319173443}, {.78000000000000047, 
          3.6070324809559384}, {.79000000000000048, 
          3.6012076936482904}, {.80000000000000049, 
          3.5759185029891039}, {.8100000000000005, 
          3.5308850970390648}, {.82000000000000051, 
          3.4661500524735862}, {.83000000000000052, 
          3.3819030406121535}, {.84000000000000052, 
          3.2784291759474731}, {.85000000000000053, 
          3.1560927938252124}, {.86000000000000054, 
          3.0153312445521654}, {.87000000000000055, 
          2.856651388583499}, {.88000000000000056, 
          2.6806266930584002}, {.89000000000000057, 
          2.4878943335195793}, {.90000000000000058, 
          2.2791521385106415}, {.91000000000000059, 
          2.0551553403141329}, {.9200000000000006, 
          1.8167131317808907}, {.9300000000000006, 
          1.5646850402315742}, {.94000000000000061, 
          1.2999771330009642}, {.95000000000000062, 
          1.0235380705929822}, {.96000000000000063, .73635502413072518}, \
{.97000000000000064, .43960148940259908}, {.98000000000000065, \
.13526916637994277}, {.99000000000000066, -.17672527413606767}, {
          1.0000000000000007, -.49651176297743682}, {
          1.0100000000000007, -.82420016926283057}, {
          1.0200000000000007, -1.1596789092854465}, {
          1.0300000000000007, -1.5028988271508898}, {
          1.0400000000000007, -1.8538113867525852}, {
          1.0500000000000007, -2.2123684450454872}, {
          1.0600000000000007, -2.578522185715884}, {
          1.0700000000000007, -2.9522250988314642}, {
          1.0800000000000007, -3.3334299736783595}, {
          1.0900000000000007, -3.7220898953860839}, {
          1.1000000000000008, -4.118158242646409}, {
          1.1100000000000008, -4.52158868575399}, {
          1.1200000000000008, -4.9323351847473731}, {
          1.1300000000000008, -5.3503519875868939}, {
          1.1400000000000008, -5.7755936283512064}, {
          1.1500000000000008, -6.2080149254471664}, {
          1.1600000000000008, -6.6475709798315084}, {
          1.1700000000000008, -7.0942171732437993}, {
          1.1800000000000008, -7.5479091664505038}, {
          1.1900000000000008, -8.008602897500058}, {
          1.2000000000000008, -8.4762545799888223}}], "  ", 
        ColumnForm[ {{0, 
          0}, {.01, .0098139677361230651}, {.02, .039161571319501355}, \
{.029999999999999999, .087799600133686206}, {.040000000000000001, \
.15538881608281158}, {.050000000000000003, .24151174029696681}, \
{.060000000000000005, .34567944839888437}, {.070000000000000007, \
.46733537753752036}, {.080000000000000002, .60585844266110167}, \
{.089999999999999997, .76056611473448565}, {.099999999999999992, \
.93071763908994554}, {.10999999999999999, 
          1.1155174348488663}, {.11999999999999998, 
          1.3141186763316042}, {.12999999999999998, 
          1.5256270454174632}, {.13999999999999999, 
          1.749104639996635}, {.14999999999999999, 1.9835740222290739}, {.16, 
          2.2280223896380145}, {.17000000000000001, 
          2.4814058516422786}, {.18000000000000002, 
          2.7426537938351077}, {.19000000000000003, 
          3.010673312108707}, {.20000000000000004, 
          3.2843536985920196}, {.21000000000000005, 
          3.5625709613109722}, {.22000000000000006, 
          3.8441923594942997}, {.23000000000000007, 
          4.1280809365330375}, {.24000000000000007, 
          4.4131000327570638}, {.25000000000000006, 
          4.6981177604162703}, {.26000000000000006, 
          4.982011423545841}, {.27000000000000007, 
          5.2636718657528441}, {.28000000000000008, 
          5.5420077293827053}, {.29000000000000009, 
          5.8159496100077446}, {.3000000000000001, 
          6.0844540907224243}, {.31000000000000011, 
          6.3268797058570634}, {.32000000000000012, 
          6.5228072255143381}, {.33000000000000013, 
          6.6717804006582861}, {.34000000000000014, 
          6.7735756717647542}, {.35000000000000014, 
          6.8281698188099629}, {.36000000000000015, 
          6.8357293952153801}, {.37000000000000016, 
          6.7966059290386927}, {.38000000000000017, 
          6.7113322870741614}, {.39000000000000018, 
          6.5806188879984777}, {.40000000000000019, 
          6.4053494006926748}, {.4100000000000002, 
          6.1865758393591728}, {.42000000000000021, 
          6.142243796671119}, {.43000000000000022, 
          6.3422639342662315}, {.44000000000000022, 
          6.596950658783495}, {.45000000000000023, 
          6.8520334518596098}, {.46000000000000024, 
          7.092053107142732}, {.47000000000000025, 
          7.3126737026557906}, {.48000000000000026, 
          7.5127468165790638}, {.49000000000000027, 
          7.6920370207796029}, {.50000000000000022, 
          7.8505699781492702}, {.51000000000000023, 
          7.9786190326477993}, {.52000000000000024, 
          8.0665308372114701}, {.53000000000000025, 
          8.1145425598214072}, {.54000000000000026, 
          8.1228997558751761}, {.55000000000000027, 
          8.0918492742043231}, {.56000000000000028, 
          8.0216372307815238}, {.57000000000000028, 
          7.9125084348570587}, {.58000000000000029, 
          7.7647062313397415}, {.5900000000000003, 
          7.5784724624363706}, {.60000000000000031, 
          7.354047463429314}, {.61000000000000032, 
          7.1014966371167842}, {.62000000000000033, 
          6.8308312864819882}, {.63000000000000034, 
          6.5421760737204231}, {.64000000000000035, 
          6.2356467628655334}, {.65000000000000036, 
          5.9113560671044789}, {.66000000000000036, 
          5.5694153278331697}, {.67000000000000037, 
          5.2099349990078005}, {.68000000000000038, 
          4.8330247890582285}, {.69000000000000039, 
          4.4387937046339525}, {.7000000000000004, 
          4.0273500661945487}, {.71000000000000041, 
          3.5988015155116742}, {.72000000000000042, 
          3.1532550208336487}, {.73000000000000043, 
          2.6908168813610582}, {.74000000000000044, 
          2.2115927315061614}, {.75000000000000044, 
          1.7156875450721358}, {.76000000000000045, 
          1.2032056393906059}, {.77000000000000046, .67425067942853623}, \
{.78000000000000047, .12892568186832751}, {.79000000000000048, \
-.93785346601749298}, {.80000000000000049, -2.6637647853178006}, \
{.8100000000000005, -4.5726911774780987}, {.82000000000000051, \
-6.5219302532528207}, {.83000000000000052, -8.4649502353704378}, \
{.84000000000000052, -10.383046099906254}, {.85000000000000053, \
-12.265665502413219}, {.86000000000000054, -14.104758730442018}, \
{.87000000000000055, -15.89316906825059}, {.88000000000000056, \
-17.624186622374978}, {.89000000000000057, -19.291436521069947}, \
{.90000000000000058, -20.88886251854435}, {.91000000000000059, \
-22.41073708788835}, {.9200000000000006, -23.851678093558991}, \
{.9300000000000006, -25.206666260727157}, {.94000000000000061, \
-26.471061734172622}, {.95000000000000062, -27.640619198601417}, \
{.96000000000000063, -28.711501376982518}, {.97000000000000064, \
-29.634686283780272}, {.98000000000000065, -30.437839650851785}, \
{.99000000000000066, -31.217260268494019}, {
          1.0000000000000007, -32.000482031979573}, {
          1.0100000000000007, -32.785503674514999}, {
          1.0200000000000007, -33.564728183690704}, {
          1.0300000000000007, -34.3388252166379}, {
          1.0400000000000007, -35.10800838147869}, {
          1.0500000000000007, -35.872360440567157}, {
          1.0600000000000007, -36.631926519275169}, {
          1.0700000000000007, -37.386740821816659}, {
          1.0800000000000007, -38.136834289225199}, {
          1.0900000000000007, -38.882236795072664}, {
          1.1000000000000008, -39.622977775620555}, {
          1.1100000000000008, -40.359086411251646}, {
          1.1200000000000008, -41.090591679287535}, {
          1.1300000000000008, -41.817522369938196}, {
          1.1400000000000008, -42.539907091679282}, {
          1.1500000000000008, -43.257774273594862}, {
          1.1600000000000008, -43.971152166844469}, {
          1.1700000000000008, -44.6800688458748}, {
          1.1800000000000008, -45.384552209553796}, {
          1.1900000000000008, -46.08462998227634}, {
          1.2000000000000008, -46.78032971505769}}], "  ", 
        ColumnForm[ {{0, 0.0}, {.01, 1.9627935472246127}, {.02, 
          3.9067271694510448}, {.029999999999999999, 
          5.8208785933859248}, {.040000000000000001, 
          7.6969645964391518}, {.050000000000000003, 
          9.5276202463918924}, {.060000000000000005, 
          11.305921373991628}, {.070000000000000007, 
          13.02526445373557}, {.080000000000000002, 
          14.679348570980711}, {.089999999999999997, 
          16.262185843696088}, {.099999999999999992, 
          17.768119027395858}, {.10999999999999999, 
          19.191840124388328}, {.11999999999999998, 
          20.528408172159256}, {.12999999999999998, 
          21.773265645012565}, {.13999999999999999, 
          22.922253270821727}, {.14999999999999999, 23.97162317566605}, {.16, 
          24.91805030612198}, {.17000000000000001, 
          25.758642094730806}, {.18000000000000002, 
          26.490946343835013}, {.19000000000000003, 
          27.112957310884759}, {.20000000000000004, 
          27.623119985777805}, {.21000000000000005, 
          28.02033255801275}, {.22000000000000006, 
          28.30394707865284}, {.23000000000000007, 
          28.47376832909481}, {.24000000000000007, 
          28.530050915710234}, {.25000000000000006, 
          28.47349461613112}, {.26000000000000006, 
          28.305238009782997}, {.27000000000000007, 
          28.026850431617554}, {.28000000000000008, 
          27.64032229435427}, {.29000000000000009, 
          27.148053830653577}, {.3000000000000001, 
          26.552842312282195}, {.31000000000000011, 
          21.932280714645653}, {.32000000000000012, 
          17.253223216809086}, {.33000000000000013, 
          12.541411811980623}, {.34000000000000014, 
          7.817642409313132}, {.35000000000000014, 
          3.1011869997285846}, {.36000000000000015, -1.5892717186454792}, \
{.37000000000000016, -6.2354215166923739}, {.38000000000000017, \
-10.819306876213703}, {.39000000000000018, -15.323372938923299}, \
{.40000000000000019, -19.73052452223726}, {.4100000000000002, \
-24.024187744462974}, {.42000000000000021, 
          15.157779206852471}, {.43000000000000022, 
          24.846248312169983}, {.44000000000000022, 
          26.0910965912826}, {.45000000000000023, 
          24.925462023940383}, {.46000000000000024, 
          23.078469032683774}, {.47000000000000025, 
          21.045650069927675}, {.48000000000000026, 
          18.968972714726519}, {.49000000000000027, 
          16.889068125381026}, {.50000000000000022, 
          14.817523348552498}, {.51000000000000023, 
          10.792287551153194}, {.52000000000000024, 
          6.7900733615811895}, {.53000000000000025, 
          2.812271160406425}, {.54000000000000026, -1.1408319496525952}, \
{.55000000000000027, -5.0692643845181085}, {.56000000000000028, \
-8.9731443000418611}, {.57000000000000028, -12.852614884851365}, \
{.58000000000000029, -16.707825818611937}, {.5900000000000003, \
-20.538927962062434}, {.60000000000000031, -24.346071839348674}, \
{.61000000000000032, -26.164093423157212}, {.62000000000000033, \
-27.96897670380195}, {.63000000000000034, -29.76206584851084}, \
{.64000000000000035, -31.543796322467067}, {.65000000000000036, \
-33.314342829744199}, {.66000000000000036, -35.073805024517625}, \
{.67000000000000037, -36.822260740556224}, {.68000000000000038, \
-38.559781249357989}, {.69000000000000039, -40.286435635497298}, \
{.7000000000000004, -42.002292052383353}, {.71000000000000041, \
-43.70741808419163}, {.72000000000000042, -45.401880851413374}, \
{.73000000000000043, -47.085747043104654}, {.74000000000000044, \
-48.759082927874744}, {.75000000000000044, -50.421954358930314}, \
{.76000000000000045, -52.074426777375699}, {.77000000000000046, \
-53.716565215038187}, {.78000000000000047, -55.348434297003543}, \
{.79000000000000048, -158.00739528016049}, {.80000000000000049, \
-187.17486857990099}, {.8100000000000005, -194.61040985215868}, \
{.82000000000000051, -195.23740530278565}, {.83000000000000052, \
-193.36659112073818}, {.84000000000000052, -190.25258178642514}, \
{.85000000000000053, -186.27129871496763}, {.86000000000000054, \
-181.54734689079211}, {.87000000000000055, -176.13472067092209}, \
{.88000000000000056, -170.06879015395526}, {.89000000000000057, \
-163.38118958503824}, {.90000000000000058, -156.10400990984283}, \
{.91000000000000059, -148.27090395895604}, {.9200000000000006, \
-139.91729717517194}, {.9300000000000006, -131.08033625846164}, \
{.94000000000000061, -121.79875843063192}, {.95000000000000062, \
-112.11273445512816}, {.96000000000000063, -102.06370122109271}, \
{.97000000000000064, -82.573280138458657}, {.98000000000000065, \
-78.057393275842571}, {.99000000000000066, -77.826730252606538}, {
          1.0000000000000007, -78.817622444503471}, {
          1.0100000000000007, -78.18670606258253}, {
          1.0200000000000007, -77.658195772560887}, {
          1.0300000000000007, -77.16121081687956}, {
          1.0400000000000007, -76.675422151276678}, {
          1.0500000000000007, -76.194989666418422}, {
          1.0600000000000007, -75.718226075185711}, {
          1.0700000000000007, -75.244634433113035}, {
          1.0800000000000007, -74.77405904859431}, {
          1.0900000000000007, -74.306442120899149}, {
          1.1000000000000008, -73.841753988679088}, {
          1.1100000000000008, -73.379973137539722}, {
          1.1200000000000008, -72.921080469637729}, {
          1.1300000000000008, -72.465057660493912}, {
          1.1400000000000008, -72.011886687723631}, {
          1.1500000000000008, -71.561549695389402}, {
          1.1600000000000008, -71.114028954532884}, {
          1.1700000000000008, -70.66930685153234}, {
          1.1800000000000008, -70.227365884266277}, {
          1.1900000000000008, -69.788188660242312}, {
          1.2000000000000008, -69.351757896027152}}], "  ", 
        ColumnForm[ {{0, 10}, {.01, 10}, {.02, 10}, {.029999999999999999, 
          10}, {.040000000000000001, 10}, {.050000000000000003, 
          10}, {.060000000000000005, 10}, {.070000000000000007, 
          10}, {.080000000000000002, 10}, {.089999999999999997, 
          10}, {.099999999999999992, 10}, {.10999999999999999, 
          10}, {.11999999999999998, 10}, {.12999999999999998, 
          10}, {.13999999999999999, 10}, {.14999999999999999, 10}, {.16, 
          10}, {.17000000000000001, 10}, {.18000000000000002, 
          10}, {.19000000000000003, 10}, {.20000000000000004, 
          10}, {.21000000000000005, 10}, {.22000000000000006, 
          10}, {.23000000000000007, 10}, {.24000000000000007, 
          10}, {.25000000000000006, 10}, {.26000000000000006, 
          10}, {.27000000000000007, 10}, {.28000000000000008, 
          10}, {.29000000000000009, 10}, {.3000000000000001, 
          10}, {.31000000000000011, 10}, {.32000000000000012, 
          10}, {.33000000000000013, 10}, {.34000000000000014, 
          10}, {.35000000000000014, 10}, {.36000000000000015, 
          10}, {.37000000000000016, 10}, {.38000000000000017, 
          10}, {.39000000000000018, 10}, {.40000000000000019, 
          10}, {.4100000000000002, 10}, {.42000000000000021, 
          0}, {.43000000000000022, 0}, {.44000000000000022, 
          0}, {.45000000000000023, 0}, {.46000000000000024, 
          0}, {.47000000000000025, 0}, {.48000000000000026, 
          0}, {.49000000000000027, 0}, {.50000000000000022, 
          0}, {.51000000000000023, 0}, {.52000000000000024, 
          0}, {.53000000000000025, 0}, {.54000000000000026, 
          0}, {.55000000000000027, 0}, {.56000000000000028, 
          0}, {.57000000000000028, 0}, {.58000000000000029, 
          0}, {.5900000000000003, 0}, {.60000000000000031, 
          0}, {.61000000000000032, 0}, {.62000000000000033, 
          0}, {.63000000000000034, 0}, {.64000000000000035, 
          0}, {.65000000000000036, 0}, {.66000000000000036, 
          0}, {.67000000000000037, 0}, {.68000000000000038, 
          0}, {.69000000000000039, 0}, {.7000000000000004, 
          0}, {.71000000000000041, 0}, {.72000000000000042, 
          0}, {.73000000000000043, 0}, {.74000000000000044, 
          0}, {.75000000000000044, 0}, {.76000000000000045, 
          0}, {.77000000000000046, 0}, {.78000000000000047, 
          0}, {.79000000000000048, 10}, {.80000000000000049, 
          10}, {.8100000000000005, 10}, {.82000000000000051, 
          10}, {.83000000000000052, 10}, {.84000000000000052, 
          10}, {.85000000000000053, 10}, {.86000000000000054, 
          10}, {.87000000000000055, 10}, {.88000000000000056, 
          10}, {.89000000000000057, 10}, {.90000000000000058, 
          10}, {.91000000000000059, 10}, {.9200000000000006, 
          10}, {.9300000000000006, 10}, {.94000000000000061, 
          10}, {.95000000000000062, 10}, {.96000000000000063, 
          10}, {.97000000000000064, 0}, {.98000000000000065, 
          0}, {.99000000000000066, 0}, {1.0000000000000007, 0}, {
          1.0100000000000007, 0}, {1.0200000000000007, 0}, {
          1.0300000000000007, 0}, {1.0400000000000007, 0}, {
          1.0500000000000007, 0}, {1.0600000000000007, 0}, {
          1.0700000000000007, 0}, {1.0800000000000007, 0}, {
          1.0900000000000007, 0}, {1.1000000000000008, 0}, {
          1.1100000000000008, 0}, {1.1200000000000008, 0}, {
          1.1300000000000008, 0}, {1.1400000000000008, 0}, {
          1.1500000000000008, 0}, {1.1600000000000008, 0}, {
          1.1700000000000008, 0}, {1.1800000000000008, 0}, {
          1.1900000000000008, 0}, {1.2000000000000008, 0}}]],
      Editable->False]], "Print"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{792, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 277, 6, 53, "Input"],
Cell[1997, 57, 1384, 21, 375, "Text"],
Cell[3384, 80, 24894, 458, 3930, "Input"],

Cell[CellGroupData[{
Cell[28303, 542, 435, 11, 161, "Subsection"],

Cell[CellGroupData[{
Cell[28763, 557, 192, 3, 50, "Input"],
Cell[28958, 562, 123, 2, 25, "Print"],
Cell[29084, 566, 78, 1, 25, "Print"],
Cell[29165, 569, 36, 1, 25, "Print"],
Cell[29204, 572, 66, 1, 25, "Print"],
Cell[29273, 575, 213, 4, 25, "Print"],
Cell[29489, 581, 149, 3, 25, "Print"],
Cell[29641, 586, 171, 3, 25, "Print"],
Cell[29815, 591, 61, 1, 25, "Print"],
Cell[29879, 594, 220, 5, 25, "Print"],
Cell[30102, 601, 60, 1, 25, "Print"],
Cell[30165, 604, 205, 4, 25, "Print"],
Cell[30373, 610, 195, 4, 25, "Print"],
Cell[30571, 616, 60, 1, 25, "Print"],
Cell[30634, 619, 213, 4, 25, "Print"],
Cell[30850, 625, 217, 4, 25, "Print"],
Cell[31070, 631, 361, 8, 25, "Print"],
Cell[31434, 641, 206, 4, 25, "Print"],
Cell[31643, 647, 256, 5, 25, "Print"],
Cell[31902, 654, 246, 5, 25, "Print"],
Cell[32151, 661, 36, 1, 25, "Print"],
Cell[32190, 664, 40, 1, 25, "Print"],
Cell[32233, 667, 12640, 415, 186, 5125, 318, "GraphicsData", "PostScript", \
"Graphics"],
Cell[44876, 1084, 129, 3, 25, "Print"],
Cell[45008, 1089, 51, 1, 25, "Print"],
Cell[45062, 1092, 12850, 427, 186, 5311, 329, "GraphicsData", "PostScript", \
"Graphics"],
Cell[57915, 1521, 129, 3, 25, "Print"],
Cell[58047, 1526, 221, 4, 25, "Print"],
Cell[58271, 1532, 192, 4, 25, "Print"],
Cell[58466, 1538, 47, 1, 25, "Print"],
Cell[58516, 1541, 13146, 439, 186, 5465, 340, "GraphicsData", "PostScript", \
"Graphics"],
Cell[71665, 1982, 129, 3, 25, "Print"],
Cell[71797, 1987, 211, 4, 25, "Print"],
Cell[72011, 1993, 175, 3, 25, "Print"],
Cell[72189, 1998, 49, 1, 25, "Print"],
Cell[72241, 2001, 12693, 442, 186, 5627, 350, "GraphicsData", "PostScript", \
"Graphics"],
Cell[84937, 2445, 129, 3, 25, "Print"],
Cell[85069, 2450, 239, 5, 25, "Print"],
Cell[85311, 2457, 201, 4, 25, "Print"],
Cell[85515, 2463, 37, 1, 25, "Print"],
Cell[85555, 2466, 14233, 487, 186, 6143, 383, "GraphicsData", "PostScript", \
"Graphics"],
Cell[99791, 2955, 129, 3, 25, "Print"],
Cell[99923, 2960, 482, 8, 25, "Print"],
Cell[100408, 2970, 132, 2, 25, "Print"],
Cell[100543, 2974, 72324, 1377, 1627, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[172916, 4357, 608, 13, 199, "Subsection"],

Cell[CellGroupData[{
Cell[173549, 4374, 381, 6, 90, "Input"],
Cell[173933, 4382, 123, 2, 25, "Print"],
Cell[174059, 4386, 78, 1, 25, "Print"],
Cell[174140, 4389, 36, 1, 25, "Print"],
Cell[174179, 4392, 66, 1, 25, "Print"],
Cell[174248, 4395, 213, 4, 25, "Print"],
Cell[174464, 4401, 172, 3, 25, "Print"],
Cell[174639, 4406, 194, 3, 25, "Print"],
Cell[174836, 4411, 61, 1, 25, "Print"],
Cell[174900, 4414, 723, 12, 44, "Print"],
Cell[175626, 4428, 60, 1, 25, "Print"],
Cell[175689, 4431, 205, 4, 25, "Print"],
Cell[175897, 4437, 195, 4, 25, "Print"],
Cell[176095, 4443, 60, 1, 25, "Print"],
Cell[176158, 4446, 213, 4, 25, "Print"],
Cell[176374, 4452, 222, 4, 25, "Print"],
Cell[176599, 4458, 361, 8, 25, "Print"],
Cell[176963, 4468, 206, 4, 25, "Print"],
Cell[177172, 4474, 256, 5, 25, "Print"],
Cell[177431, 4481, 246, 5, 25, "Print"],
Cell[177680, 4488, 36, 1, 25, "Print"],
Cell[177719, 4491, 40, 1, 25, "Print"],
Cell[177762, 4494, 14858, 470, 186, 5641, 352, "GraphicsData", "PostScript", \
"Graphics"],
Cell[192623, 4966, 129, 3, 25, "Print"],
Cell[192755, 4971, 51, 1, 25, "Print"],
Cell[192809, 4974, 14876, 501, 186, 6241, 390, "GraphicsData", "PostScript", \
"Graphics"],
Cell[207688, 5477, 129, 3, 25, "Print"],
Cell[207820, 5482, 222, 4, 25, "Print"],
Cell[208045, 5488, 227, 4, 25, "Print"],
Cell[208275, 5494, 47, 1, 25, "Print"],
Cell[208325, 5497, 15581, 516, 186, 6258, 396, "GraphicsData", "PostScript", \
"Graphics"],
Cell[223909, 6015, 129, 3, 25, "Print"],
Cell[224041, 6020, 211, 4, 25, "Print"],
Cell[224255, 6026, 216, 4, 25, "Print"],
Cell[224474, 6032, 49, 1, 25, "Print"],
Cell[224526, 6035, 18395, 615, 186, 7583, 477, "GraphicsData", "PostScript", \
"Graphics"],
Cell[242924, 6652, 129, 3, 25, "Print"],
Cell[243056, 6657, 239, 5, 25, "Print"],
Cell[243298, 6664, 245, 5, 25, "Print"],
Cell[243546, 6671, 37, 1, 25, "Print"],
Cell[243586, 6674, 16730, 557, 186, 6821, 430, "GraphicsData", "PostScript", \
"Graphics"],
Cell[260319, 7233, 129, 3, 25, "Print"],
Cell[260451, 7238, 482, 8, 25, "Print"],
Cell[260936, 7248, 132, 2, 25, "Print"],
Cell[261071, 7252, 88417, 1636, 1947, "Print"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

