(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    363765,       9397]*)
(*NotebookOutlinePosition[    364634,       9427]*)
(*  CellTagsIndexPosition[    364590,       9423]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["M\[CapitalEAcute]TODO DE NEWMARK NO LINEAL", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Vineta BT",
  FontSize->28,
  FontWeight->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
La diferencia con el m\[EAcute]todo lineal es que en el c\[AAcute]lculo de \
cada paso hay que calcular la rigidez. 
Adem\[AAcute]s para minimizar el error se realizan iteraciones para pasar de \
ui a ui+1, hasta alcanzar una cierta tolerancia.
Se ha utilizado el m\[EAcute]todo de Newton-Raphson, que consiste en calcular \
la rigidez, en cada una de las iteraciones para el paso de ui a ui+1.  Este \
programa s\[OAcute]lo considera el caso de un material elastopl\[AAcute]stico \
perfecto.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Explicaci\[OAcute]n del programa", "Subtitle",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Vineta BT",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[1]],

Cell["\<\
Las variables que hay que introducir son las siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo.
u0=desplazamiento en el instante ti.
v0=velocidad en el instante ti.
k=rigidez del tramo el\[AAcute]stico.
m=masa.
c=coeficiente de amortiguamiento.
g  y b son unos par\[AAcute]metros con los que podemos elegir que tipo de m\
\[EAcute]todo vamos a emplear.
Hay dos casos particulares:
       1)  M\[EAcute]todo de la aceleraci\[OAcute]n constante    g=0.5   \
b=0.25.
        2) M\[EAcute]todo de la aceleraci\[OAcute]n lineal           g=0.5   \
b=1/6.       
p=carga..Si la carga se da de forma discreta, hay que dar una lista \
{{t1,p1},{t2,p2},.....,{tn.pn}}, en la que cada pareja de valores es la carga \
 p ,  que hay en el instante  t .
fc=valor que provoca la plastificaci\[OAcute]n a compresi\[OAcute]n.
ft=valor que provoca la plastificaci\[OAcute]n a tracci\[OAcute]n.
El programa da una tabla con los valores del desplazamiento, velocidad y \
aceleraci\[OAcute]n,en cada instante de tiempo junto con su representaci\
\[OAcute]n gr\[AAcute]fica.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\

 C\[AAcute]lculo del n\[UAcute]mero de puntos en los que se va a obtener la \
respuesta\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["n=Floor[(tn-ti)/to+1.];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
 Como la soluci\[OAcute]n se va hallando paso a paso  para cada instante de \
tiempo, hemos de discretizar la carga \"p\",  para tener los valores de ella \
en cada instante en el que va a ser calculada la respuesta.
Cuando la carga venga dada como una funci\[OAcute]n contin\[UAcute]a,  la \
discretizaci\[OAcute]n consiste simplemente en evaluar la funci\[OAcute]n \
para los instantes de tiempo en que vamos a obtener la respuesta.
Si la carga es conocida de forma discreta, o sea , que conocemos la carga de \
forma exacta en unos instantes de tiempo determinados, construiremos una \
funci\[OAcute]n \"pa1\", que ser\[AAcute] la que discretizaremos.
El siguiente programa comprueba si la carga no es una funci\[OAcute]n \
continua, en cuyo caso antes de realizar la interpolaci\[OAcute]n, comprueba \
que la lista tenga valores de carga para instantes de tiempo superiores o \
iguales al instante en que se quiere obtener la respuesta.Si esto no es as\
\[IAcute], o sea se pide la respuesta en un instante \"tn\" que es superior \
al \[UAcute]ltimo instante de tiempo donde se conoce la carga, se supone que \
la carga ha dejado de actuar, y se le asigna el valor cero, para poder \
realizar as\[IAcute] la interpolaci\[OAcute]n.  \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
pa1=p;
If[Head[p]==List,pa2=p;nn=Length[pa2];
    If[pa2[[nn,1]]+to/1000<tn,
        AppendTo[pa2,{pa1[[nn,1]]+to/1000,0.}];
        AppendTo[pa2,{tn,0.}],
          If[tn>pa2[[nn,1]],AppendTo[pa2,{tn,0.}]]];
          pa1=Interpolation[pa2,InterpolationOrder->1]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Discretizaci\[OAcute]n de la carga.", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
pa=Table[0,{i,1,n}];
For[i=1,i<=n,i++,
     pa[[i]]=N[pa1[(ti+(i-1)to)]]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Discretizaci\[OAcute]n del tiempo en los instantes en que quiero la \
respuesta.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["tm=Table[ti+(i-1) to,{i,n}];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
A continuaci\[OAcute]n se calculan una serie de t\[EAcute]rminos que ser\
\[AAcute] necesarios para obtener la soluci\[OAcute]n,
que se han tomado del libro Dynamics of Structures de Anil k. Chopra.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
a1=m/(b to)+g c/b;
b1=m/(2 b)+c to (g/(2 b)-1);\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se inicializan los vectores de desplazamiento  \"u\", velocidad  \"v\"  y \
aceleraci\[OAcute]n \"a\".\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
u=Table[0.,{i,1,n}];
v=Table[0.,{i,1,n}];
a=Table[0.,{i,1,n}];
a0=(pa[[1]]-c v0-k u0)/m;
u[[1]]=u0;
v[[1]]=v0;
a[[1]]=a0;\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Tolerancia  en el error de las iteraciones en el paso de ui a ui+1.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["tol=.00005;", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Para cada paso hay que calcular la rigidez.Aqu\[IAcute] se inicializan los \
datos que necesitar\[AAcute] el           \" While \" , que es donde se \
realiza el c\[AAcute]lculo del incremento de desplazamiento.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
k2=k;
aa=g c/(b to)+m/(b to^2);
fs=k2 u[[1]];
 For[i=1,i<n,i++,
      p1=pa[[i+1]]-pa[[i]]+a1 v[[i]]+b1 a[[i]];
      k1=k2+g c/(b to)+m/(b to^2);
  k1t=k1;
  kt=k2;
  uu={u[[i]]};
  fss={fs,0};
  incrRR={p1};
  incruu={incrRR[[1]]/k1t};
  uu={u[[i]],u[[i]]+p1/k1t};
If[Abs[uu[[2]]]-Abs[uu[[1]]]>0,
     If[fc<fss[[1]]<ft,
        fss[[2]]=fss[[1]]+k (uu[[2]]-uu[[1]]);
        If[fc<fss[[2]]<ft,kt=k,
           If[fss[[2]]>0,fss[[2]]=ft,
                fss[[2]]=fc];kt=0],
     If[fss[[2]]>0,fss[[2]]=ft,
                fss[[2]]=fc];kt=0],
    fss[[2]]=fss[[1]]+k (uu[[2]]-uu[[1]]);
    If[fc<fss[[1]]<ft,kt=k,
           If[fss[[2]]>0,fss[[2]]=ft,
                fss[[2]]=fc];kt=0]];
  fss={fss[[1]],fss[[2]]};
  incrff={fss[[2]]-fss[[1]]+aa incruu[[1]]};
  incrRR={p1,p1-incrff[[1]]};\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Para pasar del paso ui al ui+1 se realizan iteraciones hasta que el \
incremento de desplazamiento \" incruu \"  conseguido en esa \
iteraci\[OAcute]n  respecto al incremento de desplazamiento total  \" s \" \
obtetido hasta esa iteraci\[OAcute]n sea menor que la tolerancia.
Los  \" If \" van comprobando si estamos en rango el\[AAcute]stico o pl\
\[AAcute]stico, para asignar en cada caso la rigidez correspondiente ( \
aplicaci\[OAcute]n del m\[EAcute]todo de Newton-Raphson ).\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\

  z=2 tol;
  j=2;
    While[z>tol,
      incruu[[j-1]]=incrRR[[j-1]]/k1t;
      uu[[j]]=uu[[j-1]]+incruu[[j-1]];
  If[Abs[uu[[j]]]-Abs[uu[[j-1]]]>0,
     If[fc<fss[[j-1]]<ft,
        fss[[j]]=fss[[j-1]]+k (uu[[j]]-uu[[j-1]]);
        If[fc<fss[[j]]<ft,kt=k,
           If[fss[[j]]>0,fss[[j]]=ft,
                fss[[j]]=fc];kt=0],
        If[fss[[j-1]]>0,fss[[j-1]]=ft,
                fss[[j-1]]=fc];kt=0;
           fss[[j]]=fss[[j-1]]],
    fss[[j]]=fss[[j-1]]+k (uu[[j]]-uu[[j-1]]);
    If[fc<fss[[j]]<ft,kt=k,
           If[fss[[j]]>0,fss[[j]]=ft,
                fss[[j]]=fc];kt=0]];
     incrff[[j-1]]=fss[[j]]-fss[[j-1]]+
         aa incruu[[j-1]];
      incrRR[[j]]=incrRR[[j-1]]-incrff[[j-1]];
      l=Length[incruu];
      s=Sum[incruu[[i]],{i,1,l}];
      z=Abs[incruu[[l]]/s];
      AppendTo[incruu,0];
      AppendTo[incrRR,0];
      AppendTo[incrff,0];
      AppendTo[uu,0];
      AppendTo[fss,0];
      j=j+1];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Una vez alcanzada la tolerancia se halla el desplazamiento y velocidad.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
u[[i+1]]=u[[i]]+s;
  v[[i+1]]=N[v[[i]]+g(u[[i+1]]-u[[i]])/(b to)-
             g v[[i]]/b+to a[[i]]*(1-g/(2 b))];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
 Se comprueba si estamos en rango el\[AAcute]stico o pl\[AAcute]stico para \
asignar la rigidez correspondiente, y aplicar la ecuaci\[OAcute]n del \
movimiento para hallar la aceleraci\[OAcute]n.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
fs=fs+k (u[[i+1]]-u[[i]]);
    If[fc<fs<ft,
        k2=k,
       If[fs>0,fs=ft,
             fs=fc];k2=0];
a[[i+1]]=N[(pa[[i+1]]-c v[[i+1]]-fs)/m]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Para \"u\", \"v\"  y  \"a\", se construye una matriz en la que en la fila \"i\
\" aparece el instante de tiempo \"ti\" y la respuesta \"ui\",\"vi\" y \"ai\" \
respectivamente asociada a ese instante. \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Se representan gr\[AAcute]ficamente \"u\", \"v\"  y  \"a\".", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
gu=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
ga=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se realiza una tabla en la que para para cada instante de tiempo aparecen los \
valores de \"u\", \"v\" y \"a\" asociados a este instante.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"]; 
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["NewmarkNoLineal", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
posicion;
velocidad;
aceleracion;
NewmarkNoLineal[ti_,tn_,to_,u0_,v0_,k_,m_,c_,p_,
        g_,b_,fc_,ft_,posicion_,velocidad_,aceleracion_]:=
  Block[{n,pa1,pa2,nn,pa,i,tm,a1,b1,u,v,a,
         a0,k2,aa,fs,p1,k1,tol,k1t,kt,uu,fss, 
         incrRR,incruu,z,j,l,s,gv,ga},
(*Las variables que hay que introducir son las 
 siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo.
u0=desplazamiento en el instante ti.
v0=velocidad en el instante ti.
k=rigidez del tramo el\[AAcute]stico.
m=masa.
c=coeficiente de amortiguamiento.
g  y b son unos par\[AAcute]metros con los que podemos elegir 
que tipo de m\[EAcute]todo vamos a emplear.
Hay dos casos particulares:
 1)M\[EAcute]todo de la aceleraci\[OAcute]n constante g=0.5 b=0.25.
 2)M\[EAcute]todo de la aceleraci\[OAcute]n lineal    g=0.5 b=1/6.       
p=carga.Si la carga se da de forma discreta, hay que dar 
una lista {{t1,p1},{t2,p2},.....,{tn.pn}}, en la que cada 
pareja de valores es la carga  p ,  que hay en el instante t.
fc=valor que provoca la plastificaci\[OAcute]n a compresi\[OAcute]n.
ft=valor que provoca la plastificaci\[OAcute]n a tracci\[OAcute]n.
El programa da una tabla con los valores del desplazamiento, 
velocidad y aceleraci\[OAcute]n,en cada instante de tiempo junto con 
su representaci\[OAcute]n gr\[AAcute]fica.*)
n=Floor[(tn-ti)/to+1.];
pa1=p;
If[Head[p]==List,pa2=p;nn=Length[pa2];
    If[pa2[[nn,1]]+to/1000<tn,
        AppendTo[pa2,{pa1[[nn,1]]+to/1000,0.}];
        AppendTo[pa2,{tn,0.}],
          If[tn>pa2[[nn,1]],AppendTo[pa2,{tn,0.}]]];
          pa1=Interpolation[pa2,InterpolationOrder->1]];
pa=Table[0,{i,1,n}];
For[i=1,i<=n,i++,
     pa[[i]]=N[pa1[(ti+(i-1)to)]]];
tm=Table[ti+(i-1) to,{i,n}];
a1=m/(b to)+g c/b;
b1=m/(2 b)+c to (g/(2 b)-1);
u=Table[0.,{i,1,n}];
v=Table[0.,{i,1,n}];
a=Table[0.,{i,1,n}];
a0=(pa[[1]]-c v0-k u0)/m;
u[[1]]=u0;
v[[1]]=v0;
a[[1]]=a0;
k2=k;
aa=g c/(b to)+m/(b to^2);
fs=k2 u[[1]];
 For[i=1,i<n,i++,
      p1=pa[[i+1]]-pa[[i]]+a1 v[[i]]+b1 a[[i]];
      k1=k2+g c/(b to)+m/(b to^2);
  tol=.00005;
  k1t=k1;
  kt=k2;
  uu={u[[i]]};
  fss={fs,0};
  incrRR={p1};
  incruu={incrRR[[1]]/k1t};
  uu={u[[i]],u[[i]]+p1/k1t};
If[Abs[uu[[2]]]-Abs[uu[[1]]]>0,
     If[fc<fss[[1]]<ft,
        fss[[2]]=fss[[1]]+k (uu[[2]]-uu[[1]]);
        If[fc<fss[[2]]<ft,kt=k,
           If[fss[[2]]>0,fss[[2]]=ft,
                fss[[2]]=fc];kt=0],
     If[fss[[2]]>0,fss[[2]]=ft,
                fss[[2]]=fc];kt=0],
    fss[[2]]=fss[[1]]+k (uu[[2]]-uu[[1]]);
    If[fc<fss[[1]]<ft,kt=k,
           If[fss[[2]]>0,fss[[2]]=ft,
                fss[[2]]=fc];kt=0]];
  fss={fss[[1]],fss[[2]]};
  incrff={fss[[2]]-fss[[1]]+aa incruu[[1]]};
  incrRR={p1,p1-incrff[[1]]};
  z=2 tol;
  j=2;
    While[z>tol,
      incruu[[j-1]]=incrRR[[j-1]]/k1t;
      uu[[j]]=uu[[j-1]]+incruu[[j-1]];
  If[Abs[uu[[j]]]-Abs[uu[[j-1]]]>0,
     If[fc<fss[[j-1]]<ft,
        fss[[j]]=fss[[j-1]]+k (uu[[j]]-uu[[j-1]]);
        If[fc<fss[[j]]<ft,kt=k,
           If[fss[[j]]>0,fss[[j]]=ft,
                fss[[j]]=fc];kt=0],
        If[fss[[j-1]]>0,fss[[j-1]]=ft,
                fss[[j-1]]=fc];kt=0;
           fss[[j]]=fss[[j-1]]],
    fss[[j]]=fss[[j-1]]+k (uu[[j]]-uu[[j-1]]);
    If[fc<fss[[j]]<ft,kt=k,
           If[fss[[j]]>0,fss[[j]]=ft,
                fss[[j]]=fc];kt=0]];
     incrff[[j-1]]=fss[[j]]-fss[[j-1]]+
         aa incruu[[j-1]];
      incrRR[[j]]=incrRR[[j-1]]-incrff[[j-1]];
      l=Length[incruu];
      s=Sum[incruu[[i]],{i,1,l}];
      z=Abs[incruu[[l]]/s];
      AppendTo[incruu,0];
      AppendTo[incrRR,0];
      AppendTo[incrff,0];
      AppendTo[uu,0];
      AppendTo[fss,0];
      j=j+1];
  u[[i+1]]=u[[i]]+s;
  v[[i+1]]=N[v[[i]]+g(u[[i+1]]-u[[i]])/(b to)-
             g v[[i]]/b+to a[[i]]*(1-g/(2 b))];
fs=fs+k (u[[i+1]]-u[[i]]);
    If[fc<fs<ft,
        k2=k,
       If[fs>0,fs=ft,
             fs=fc];k2=0];
a[[i+1]]=N[(pa[[i+1]]-c v[[i+1]]-fs)/m]];
 For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];
posicion=u;
velocidad=v;
aceleracion=a;
gu=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
ga=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"]; 
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO
0.2 a( t )  + 0.274 v( t ) + fs ( u,v ) = p( t )
u( 0 ) = 0
v( 0 ) = 0

Hallar la respuesta hasta el instante tn=2 y con un incremento de tiempo
to=0.1,para el m\[EAcute]todo de la aceleraci\[OAcute]n lineal, siendo p( t ) \
la carga dada en forma discreta siguiente:

p={{0,0},{.45,20},{1.1,0},{1.2,-10},{1.4,0}};

y siendo el material elastopl\[AAcute]stico perfecto, en el que la \
plastificaci\[OAcute]n a tracci\[OAcute]n se alcanza paran un valor de ft = \
15, y a compresi\[OAcute]n para fc = -15, y la rigidez el\[AAcute]stica es \
12.35. \
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["p={{0,0},{.45,20},{1.1,0},{1.2,-10},{1.4,0}};", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["\<\
NewmarkNoLineal[0,2,.1,0,0,12.35,.2,.274,p,  
        .5,1/6,-15,15,posicion,velocidad,aceleracion]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.151239 [
[.2619 .00222 -9 -9 ]
[.2619 .00222 9 0 ]
[.5 .00222 -3 -9 ]
[.5 .00222 3 0 ]
[.7381 .00222 -9 -9 ]
[.7381 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.4375 ]
[1.025 .01472 10 6.4375 ]
[.01131 .16595 -6 -4.5 ]
[.01131 .16595 0 4.5 ]
[.01131 .31719 -6 -4.5 ]
[.01131 .31719 0 4.5 ]
[.01131 .46843 -6 -4.5 ]
[.01131 .46843 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(0.5)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(1)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(1.5)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(2)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .16595 m
.03006 .16595 L
s
[(1)] .01131 .16595 1 0 Mshowa
.02381 .31719 m
.03006 .31719 L
s
[(2)] .01131 .31719 1 0 Mshowa
.02381 .46843 m
.03006 .46843 L
s
[(3)] .01131 .46843 1 0 Mshowa
.125 Mabswid
.02381 .04496 m
.02756 .04496 L
s
.02381 .07521 m
.02756 .07521 L
s
.02381 .10546 m
.02756 .10546 L
s
.02381 .13571 m
.02756 .13571 L
s
.02381 .1962 m
.02756 .1962 L
s
.02381 .22645 m
.02756 .22645 L
s
.02381 .2567 m
.02756 .2567 L
s
.02381 .28695 m
.02756 .28695 L
s
.02381 .34744 m
.02756 .34744 L
s
.02381 .37769 m
.02756 .37769 L
s
.02381 .40794 m
.02756 .40794 L
s
.02381 .43818 m
.02756 .43818 L
s
.02381 .49868 m
.02756 .49868 L
s
.02381 .52893 m
.02756 .52893 L
s
.02381 .55917 m
.02756 .55917 L
s
.02381 .58942 m
.02756 .58942 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.07143 .0195 L
.11905 .04989 L
.16667 .11557 L
.21429 .20725 L
.2619 .31038 L
.30952 .42035 L
.35714 .51894 L
.40476 .58583 L
.45238 .60332 L
.5 .56012 L
.54762 .46778 L
.59524 .3534 L
.64286 .2389 L
.69048 .19739 L
.7381 .26118 L
.78571 .39154 L
.83333 .50114 L
.88095 .53464 L
.92857 .48327 L
.97619 .38405 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00B03oool2000000@0oooo0P0000040?ooo`800000<@3oool5000002h0oooo1@0000020?oo
o`800000103oool200000340oooo1000000R0?ooo`00A`3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo00000380oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`07
0?ooo`040000003oool0oooo00000300oooo00<000000?ooo`3oool08`3oool004L0oooo00@00000
0?ooo`3oool000002`3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo0300oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo0280oooo0017
0?ooo`040000003oool0oooo000000T0oooo0P00000c0?ooo`030000003oool0oooo0300oooo00<0
00000?ooo`3oool0203oool2000003<0oooo00<000000?ooo`3oool08@3oool004L0oooo00@00000
0?ooo`3oool000002@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo0300oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0`0?ooo`040000003oool0oooo00000280oooo
00180?ooo`8000002P3oool300000340oooo0P00000a0?ooo`8000002P3oool300000340oooo0P00
000S0?ooo`00o`3ooolQ0?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`03
0000003oool0oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0m03oool200000180oooo
000E0?ooo`030000003oool0oooo0?<0oooo00@000000?ooo`3oool000004@3oool00100oooo1@00
00060?l00>P00000203oool00`000000oooo0?ooo`0B0?ooo`005@3oool00`000000oooo0?ooo`03
0?ooo`L0o`00;@3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo03H0oooo00<00000
0?ooo`3oool0=`3oool00`000000oooo0?ooo`0;0?ooo`D000004@3oool001D0oooo00<000000?oo
o`3oool02P3oool20?l00>L0oooo00<000000?ooo`3oool04P3oool001D0oooo00<000000?ooo`3o
ool0303oool00`3o0000oooo0?ooo`3i0?ooo`005@3oool00`000000oooo0?ooo`0=0?ooo`80o`00
n@3oool001D0oooo00<000000?ooo`3oool03`3oool20?l00?L0oooo000E0?ooo`030000003oool0
oooo0140oooo00<0o`000?ooo`3oool0m03oool001D0oooo0P00000C0?ooo`80o`00m03oool001D0
oooo00<000000?ooo`3oool0503oool00`3o0000oooo0?ooo`3a0?ooo`005@3oool00`000000oooo
0?ooo`0E0?ooo`030?l0003oool0oooo0?00oooo000E0?ooo`030000003oool0oooo01D0oooo00<0
o`000?ooo`3oool0l03oool001D0oooo00<000000?ooo`3oool05P3oool00`3o0000oooo0?ooo`3_
0?ooo`005@3oool00`000000oooo0?ooo`0G0?ooo`030?l0003oool0oooo0>h0oooo000E0?ooo`03
0000003oool0oooo01P0oooo00<0o`000?ooo`3oool0k@3oool001D0oooo0P00000I0?ooo`030?l0
003oool0oooo0>d0oooo000E0?ooo`030000003oool0oooo01T0oooo00<0o`000?ooo`3oool0k03o
ool001D0oooo00<000000?ooo`3oool06P3oool00`3o0000oooo0?ooo`3[0?ooo`005@3oool00`00
0000oooo0?ooo`0K0?ooo`030?l0003oool0oooo0>X0oooo000E0?ooo`030000003oool0oooo01/0
oooo00<0o`000?ooo`3oool0jP3oool001D0oooo00<000000?ooo`3oool0703oool00`3o0000oooo
0?ooo`3Y0?ooo`005@3oool00`000000oooo0?ooo`0M0?ooo`030?l0003oool0oooo0>P0oooo000E
0?ooo`030000003oool0oooo01h0oooo00<0o`000?ooo`3oool0i`3oool001D0oooo0P00000O0?oo
o`030?l0003oool0oooo0>L0oooo000E0?ooo`030000003oool0oooo01l0oooo00<0o`000?ooo`3o
ool0iP3oool001D0oooo00<000000?ooo`3oool0803oool00`3o0000oooo0?ooo`3U0?ooo`005@3o
ool00`000000oooo0?ooo`0P0?ooo`030?l0003oool0oooo0>D0oooo000E0?ooo`030000003oool0
oooo0240oooo00<0o`000?ooo`3oool0i03oool001D0oooo00<000000?ooo`3oool08@3oool00`3o
0000oooo0?ooo`3T0?ooo`005@3oool00`000000oooo0?ooo`0R0?ooo`030?l0003oool0oooo0><0
oooo000E0?ooo`8000008`3oool00`3o0000oooo0?ooo`3S0?ooo`005@3oool00`000000oooo0?oo
o`0S0?ooo`030?l0003oool0oooo0>80oooo000E0?ooo`030000003oool0oooo02<0oooo00<0o`00
0?ooo`3oool0hP3oool001D0oooo00<000000?ooo`3oool0903oool00`3o0000oooo0?ooo`3Q0?oo
o`005@3oool00`000000oooo0?ooo`0T0?ooo`030?l0003oool0oooo0>40oooo000=0?ooo`D00000
0`3oool00`000000oooo0?ooo`0U0?ooo`030?l0003oool0oooo0>00oooo000?0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool09@3oool00`3o0000oooo0?ooo`3P0?ooo`003`3oool0
0`000000oooo0?ooo`030?ooo`<000009P3oool00`3o0000oooo0?ooo`3O0?ooo`003`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo02H0oooo00<0o`000?ooo`3oool0g`3oool000l0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0W0?ooo`030?l0003oool0oooo0=h0
oooo000>0?ooo`8000001@3oool00`000000oooo0?ooo`0W0?ooo`030?l0003oool0oooo0=h0oooo
000E0?ooo`030000003oool0oooo02P0oooo00<0o`000?ooo`3oool0g@3oool001D0oooo00<00000
0?ooo`3oool0:03oool00`3o0000oooo0?ooo`3M0?ooo`005@3oool00`000000oooo0?ooo`0Y0?oo
o`030?l0003oool0oooo0=`0oooo000E0?ooo`800000:P3oool00`3o0000oooo0?ooo`3L0?ooo`00
5@3oool00`000000oooo0?ooo`0Z0?ooo`030?l0003oool0oooo0780oooo00<0o`000?ooo`3oool0
IP3oool001D0oooo00<000000?ooo`3oool0:P3oool00`3o0000oooo0?ooo`1a0?ooo`030?l0003o
ool0o`0006L0oooo000E0?ooo`030000003oool0oooo02/0oooo00<0o`000?ooo`3oool0K`3oool0
103o0000oooo0?ooo`3o001W0?ooo`005@3oool00`000000oooo0?ooo`0[0?ooo`030?l0003oool0
oooo06d0oooo0P3o00040?ooo`030?l0003oool0oooo06@0oooo000E0?ooo`030000003oool0oooo
02`0oooo00<0o`000?ooo`3oool0J`3oool00`3o0000oooo0?ooo`050?ooo`030?l0003oool0oooo
06<0oooo000E0?ooo`030000003oool0oooo02`0oooo00<0o`000?ooo`3oool0JP3oool00`3o0000
oooo0?ooo`070?ooo`030?l0003oool0oooo0680oooo000E0?ooo`030000003oool0oooo02d0oooo
00<0o`000?ooo`3oool0J03oool00`3o0000oooo0?ooo`080?ooo`030?l0003oool0oooo0680oooo
000E0?ooo`800000;P3oool00`3o0000oooo0?ooo`1W0?ooo`030?l0003oool0oooo00X0oooo00<0
o`000?ooo`3oool0H@3oool001D0oooo00<000000?ooo`3oool0;P3oool00`3o0000oooo0?ooo`1T
0?ooo`80o`003P3oool00`3o0000oooo0?ooo`1P0?ooo`005@3oool00`000000oooo0?ooo`0^0?oo
o`030?l0003oool0oooo06<0oooo00<0o`000?ooo`3oool03`3oool00`3o0000oooo0?ooo`1O0?oo
o`005@3oool00`000000oooo0?ooo`0_0?ooo`030?l0003oool0oooo0640oooo00<0o`000?ooo`3o
ool0403oool00`3o0000oooo0?ooo`1O0?ooo`005@3oool00`000000oooo0?ooo`0_0?ooo`030?l0
003oool0oooo0640oooo00<0o`000?ooo`3oool04@3oool00`3o0000oooo0?ooo`1N0?ooo`005@3o
ool00`000000oooo0?ooo`0`0?ooo`030?l0003oool0oooo05l0oooo00<0o`000?ooo`3oool04`3o
ool00`3o0000oooo0?ooo`1M0?ooo`005@3oool00`000000oooo0?ooo`0`0?ooo`030?l0003oool0
oooo05l0oooo00<0o`000?ooo`3oool0503oool00`3o0000oooo0?ooo`1L0?ooo`005@3oool20000
0380oooo00<0o`000?ooo`3oool0G@3oool00`3o0000oooo0?ooo`0E0?ooo`030?l0003oool0oooo
05`0oooo000E0?ooo`030000003oool0oooo0340oooo00<0o`000?ooo`3oool0G@3oool00`3o0000
oooo0?ooo`0F0?ooo`030?l0003oool0oooo05/0oooo000E0?ooo`030000003oool0oooo0380oooo
00<0o`000?ooo`3oool0G03oool00`3o0000oooo0?ooo`0F0?ooo`030?l0003oool0oooo05/0oooo
000E0?ooo`030000003oool0oooo0380oooo00<0o`000?ooo`3oool0F`3oool00`3o0000oooo0?oo
o`0H0?ooo`030?l0003oool0oooo05X0oooo000E0?ooo`030000003oool0oooo03<0oooo00<0o`00
0?ooo`3oool0FP3oool00`3o0000oooo0?ooo`0H0?ooo`030?l0003oool0oooo05X0oooo000E0?oo
o`030000003oool0oooo03<0oooo00<0o`000?ooo`3oool0F@3oool00`3o0000oooo0?ooo`0I0?oo
o`030?l0003oool0oooo05X0oooo000E0?ooo`030000003oool0oooo03@0oooo00<0o`000?ooo`3o
ool0F03oool00`3o0000oooo0?ooo`0J0?ooo`030?l0003oool0oooo05T0oooo000E0?ooo`800000
=@3oool00`3o0000oooo0?ooo`1H0?ooo`030?l0003oool0oooo01X0oooo00<0o`000?ooo`3oool0
F@3oool001D0oooo00<000000?ooo`3oool0=@3oool00`3o0000oooo0?ooo`1F0?ooo`030?l0003o
ool0oooo01`0oooo00<0o`000?ooo`3oool0F03oool001D0oooo00<000000?ooo`3oool0=@3oool0
0`3o0000oooo0?ooo`1F0?ooo`030?l0003oool0oooo01`0oooo00<0o`000?ooo`3oool0F03oool0
01D0oooo00<000000?ooo`3oool0=P3oool00`3o0000oooo0?ooo`1D0?ooo`030?l0003oool0oooo
01d0oooo00<0o`000?ooo`3oool0F03oool001D0oooo00<000000?ooo`3oool0=P3oool00`3o0000
oooo0?ooo`1D0?ooo`030?l0003oool0oooo01h0oooo00<0o`000?ooo`3oool0E`3oool001D0oooo
00<000000?ooo`3oool0=`3oool00`3o0000oooo0?ooo`1C0?ooo`030?l0003oool0oooo01h0oooo
00<0o`000?ooo`3oool0E`3oool000d0oooo100000040?ooo`030000003oool0oooo03L0oooo00<0
o`000?ooo`3oool0DP3oool00`3o0000oooo0?ooo`0O0?ooo`030?l0003oool0oooo05L0oooo000=
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0=`3oool00`3o0000oooo0?ooo`1B
0?ooo`030?l0003oool0oooo0200oooo00<0o`000?ooo`3oool0EP3oool000h0oooo00<000000?oo
o`3oool0103oool3000003P0oooo00<0o`000?ooo`3oool0D@3oool00`3o0000oooo0?ooo`0P0?oo
o`030?l0003oool0oooo05H0oooo000?0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0>03oool00`3o0000oooo0?ooo`1@0?ooo`030?l0003oool0oooo0280oooo00<0o`000?ooo`3o
ool0E@3oool000d0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0i0?ooo`03
0?l0003oool0oooo04l0oooo00<0o`000?ooo`3oool08P3oool00`3o0000oooo0?ooo`1E0?ooo`00
3P3oool2000000D0oooo00<000000?ooo`3oool0>@3oool00`3o0000oooo0?ooo`1>0?ooo`030?l0
003oool0oooo02<0oooo00<0o`000?ooo`3oool0E@3oool001D0oooo00<000000?ooo`3oool0>P3o
ool00`3o0000oooo0?ooo`1=0?ooo`030?l0003oool0oooo02@0oooo00<0o`000?ooo`3oool0E03o
ool001D0oooo00<000000?ooo`3oool0>P3oool00`3o0000oooo0?ooo`1=0?ooo`030?l0003oool0
oooo02@0oooo00<0o`000?ooo`3oool0E03oool001D0oooo00<000000?ooo`3oool0>`3oool00`3o
0000oooo0?ooo`1;0?ooo`030?l0003oool0oooo02D0oooo00<0o`000?ooo`3oool0E03oool001D0
oooo0P00000l0?ooo`030?l0003oool0oooo04/0oooo00<0o`000?ooo`3oool09P3oool00`3o0000
oooo0?ooo`1C0?ooo`005@3oool00`000000oooo0?ooo`0k0?ooo`030?l0003oool0oooo04X0oooo
00<0o`000?ooo`3oool09`3oool00`3o0000oooo0?ooo`1C0?ooo`005@3oool00`000000oooo0?oo
o`0l0?ooo`030?l0003oool0oooo04T0oooo00<0o`000?ooo`3oool0:03oool00`3o0000oooo0?oo
o`1B0?ooo`005@3oool00`000000oooo0?ooo`0l0?ooo`030?l0003oool0oooo04T0oooo00<0o`00
0?ooo`3oool0:03oool00`3o0000oooo0?ooo`1B0?ooo`005@3oool00`000000oooo0?ooo`0m0?oo
o`030?l0003oool0oooo04L0oooo00<0o`000?ooo`3oool0:@3oool00`3o0000oooo0?ooo`1B0?oo
o`005@3oool00`000000oooo0?ooo`0m0?ooo`030?l0003oool0oooo04L0oooo00<0o`000?ooo`3o
ool0:P3oool00`3o0000oooo0?ooo`1A0?ooo`005@3oool00`000000oooo0?ooo`0n0?ooo`030?l0
003oool0oooo04D0oooo00<0o`000?ooo`3oool0:`3oool00`3o0000oooo0?ooo`1A0?ooo`005@3o
ool2000003l0oooo00<0o`000?ooo`3oool0A@3oool00`3o0000oooo0?ooo`0[0?ooo`030?l0003o
ool0oooo0540oooo000E0?ooo`030000003oool0oooo03l0oooo00<0o`000?ooo`3oool0@`3oool0
0`3o0000oooo0?ooo`0]0?ooo`030?l0003oool0oooo0500oooo000E0?ooo`030000003oool0oooo
03l0oooo00<0o`000?ooo`3oool0@`3oool00`3o0000oooo0?ooo`0]0?ooo`030?l0003oool0oooo
02`0oooo00<0o`000?ooo`3oool08@3oool001D0oooo00<000000?ooo`3oool0?`3oool00`3o0000
oooo0?ooo`120?ooo`030?l0003oool0oooo02l0oooo00<0o`000?ooo`3oool0:P3oool00`3o0000
oooo0?ooo`0R0?ooo`005@3oool00`000000oooo0?ooo`100?ooo`030?l0003oool0oooo0440oooo
00<0o`000?ooo`3oool0;`3oool00`3o0000oooo0?ooo`0Z0?ooo`030?l0003oool0oooo0280oooo
000E0?ooo`030000003oool0oooo0400oooo00<0o`000?ooo`3oool0@@3oool00`3o0000oooo0?oo
o`0_0?ooo`030?l0003oool0oooo02T0oooo00<0o`000?ooo`3oool08`3oool001D0oooo00<00000
0?ooo`3oool0@@3oool00`3o0000oooo0?ooo`0o0?ooo`030?l0003oool0oooo0340oooo00<0o`00
0?ooo`3oool0:03oool00`3o0000oooo0?ooo`0S0?ooo`005@3oool00`000000oooo0?ooo`110?oo
o`030?l0003oool0oooo03l0oooo00<0o`000?ooo`3oool0<@3oool00`3o0000oooo0?ooo`0W0?oo
o`030?l0003oool0oooo02@0oooo000E0?ooo`800000@`3oool00`3o0000oooo0?ooo`0m0?ooo`03
0?l0003oool0oooo03<0oooo00<0o`000?ooo`3oool09P3oool00`3o0000oooo0?ooo`0T0?ooo`00
5@3oool00`000000oooo0?ooo`120?ooo`030?l0003oool0oooo03d0oooo00<0o`000?ooo`3oool0
<`3oool00`3o0000oooo0?ooo`0U0?ooo`030?l0003oool0oooo02D0oooo000E0?ooo`030000003o
ool0oooo04<0oooo00<0o`000?ooo`3oool0>`3oool00`3o0000oooo0?ooo`0e0?ooo`030?l0003o
ool0oooo02@0oooo00<0o`000?ooo`3oool09@3oool001D0oooo00<000000?ooo`3oool0@`3oool0
0`3o0000oooo0?ooo`0k0?ooo`030?l0003oool0oooo03D0oooo00<0o`000?ooo`3oool08`3oool0
0`3o0000oooo0?ooo`0V0?ooo`005@3oool00`000000oooo0?ooo`130?ooo`030?l0003oool0oooo
03X0oooo00<0o`000?ooo`3oool0=P3oool00`3o0000oooo0?ooo`0S0?ooo`030?l0003oool0oooo
02H0oooo000E0?ooo`030000003oool0oooo04@0oooo00<0o`000?ooo`3oool0>@3oool00`3o0000
oooo0?ooo`0g0?ooo`030?l0003oool0oooo0240oooo00<0o`000?ooo`3oool09`3oool001D0oooo
00<000000?ooo`3oool0A03oool00`3o0000oooo0?ooo`0i0?ooo`030?l0003oool0oooo03L0oooo
00<0o`000?ooo`3oool08@3oool00`3o0000oooo0?ooo`0W0?ooo`005@3oool2000004H0oooo00<0
o`000?ooo`3oool0=`3oool00`3o0000oooo0?ooo`0i0?ooo`030?l0003oool0oooo01l0oooo00<0
o`000?ooo`3oool0:03oool001D0oooo00<000000?ooo`3oool0A@3oool00`3o0000oooo0?ooo`0g
0?ooo`030?l0003oool0oooo03T0oooo00<0o`000?ooo`3oool07`3oool00`3o0000oooo0?ooo`0X
0?ooo`005@3oool00`000000oooo0?ooo`160?ooo`030?l0003oool0oooo03D0oooo00<0o`000?oo
o`3oool0>P3oool00`3o0000oooo0?ooo`0N0?ooo`030?l0003oool0oooo02T0oooo000E0?ooo`03
0000003oool0oooo04H0oooo00<0o`000?ooo`3oool0=@3oool00`3o0000oooo0?ooo`0k0?ooo`03
0?l0003oool0oooo01d0oooo00<0o`000?ooo`3oool0:@3oool001D0oooo00<000000?ooo`3oool0
A`3oool00`3o0000oooo0?ooo`0c0?ooo`030?l0003oool0oooo03`0oooo00<0o`000?ooo`3oool0
703oool00`3o0000oooo0?ooo`0Z0?ooo`003P3oool2000000D0oooo00<000000?ooo`3oool0A`3o
ool00`3o0000oooo0?ooo`0c0?ooo`030?l0003oool0oooo03d0oooo00<0o`000?ooo`3oool06`3o
ool00`3o0000oooo0?ooo`0Z0?ooo`003@3oool010000000oooo0?ooo`0000040?ooo`030000003o
ool0oooo04P0oooo00<0o`000?ooo`3oool0<@3oool00`3o0000oooo0?ooo`0n0?ooo`030?l0003o
ool0oooo01X0oooo00<0o`000?ooo`3oool0:`3oool000l0oooo00<000000?ooo`3oool00`3oool3
000004P0oooo00<0o`000?ooo`3oool0<@3oool00`3o0000oooo0?ooo`0o0?ooo`030?l0003oool0
oooo01T0oooo00<0o`000?ooo`3oool0:`3oool00100oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`180?ooo`030?l0003oool0oooo0340oooo00<0o`000?ooo`3oool0?`3oool00`3o
0000oooo0?ooo`0H0?ooo`030?l0003oool0oooo02`0oooo000=0?ooo`040000003oool0oooo0000
00@0oooo00<000000?ooo`3oool0B@3oool00`3o0000oooo0?ooo`0_0?ooo`030?l0003oool0oooo
0400oooo00<0o`000?ooo`3oool0603oool00`3o0000oooo0?ooo`0/0?ooo`003P3oool2000000D0
oooo00<000000?ooo`3oool0B@3oool00`3o0000oooo0?ooo`0_0?ooo`030?l0003oool0oooo0440
oooo00<0o`000?ooo`3oool05P3oool00`3o0000oooo0?ooo`0]0?ooo`005@3oool00`000000oooo
0?ooo`1:0?ooo`030?l0003oool0oooo02d0oooo00<0o`000?ooo`3oool0@P3oool00`3o0000oooo
0?ooo`0F0?ooo`030?l0003oool0oooo02d0oooo000E0?ooo`030000003oool0oooo04X0oooo00<0
o`000?ooo`3oool0;@3oool00`3o0000oooo0?ooo`130?ooo`030?l0003oool0oooo01@0oooo00<0
o`000?ooo`3oool0;P3oool001D0oooo00<000000?ooo`3oool0B`3oool00`3o0000oooo0?ooo`0[
0?ooo`030?l0003oool0oooo04@0oooo00<0o`000?ooo`3oool04`3oool00`3o0000oooo0?ooo`0_
0?ooo`005@3oool00`000000oooo0?ooo`1;0?ooo`030?l0003oool0oooo02/0oooo00<0o`000?oo
o`3oool0A@3oool00`3o0000oooo0?ooo`0A0?ooo`030?l0003oool0oooo0300oooo000E0?ooo`80
0000C@3oool00`3o0000oooo0?ooo`0Y0?ooo`030?l0003oool0oooo04H0oooo00<0o`000?ooo`3o
ool0403oool00`3o0000oooo0?ooo`0a0?ooo`005@3oool00`000000oooo0?ooo`1<0?ooo`030?l0
003oool0oooo02T0oooo00<0o`000?ooo`3oool0A`3oool20?l000l0oooo00<0o`000?ooo`3oool0
<P3oool001D0oooo00<000000?ooo`3oool0C@3oool00`3o0000oooo0?ooo`0W0?ooo`030?l0003o
ool0oooo04X0oooo00<0o`000?ooo`3oool02`3oool00`3o0000oooo0?ooo`0c0?ooo`005@3oool0
0`000000oooo0?ooo`1=0?ooo`030?l0003oool0oooo02L0oooo00<0o`000?ooo`3oool0B`3oool2
0?l000/0oooo00<0o`000?ooo`3oool0<`3oool001D0oooo00<000000?ooo`3oool0CP3oool00`3o
0000oooo0?ooo`0U0?ooo`030?l0003oool0oooo04h0oooo00<0o`000?ooo`3oool01`3oool00`3o
0000oooo0?ooo`0d0?ooo`005@3oool00`000000oooo0?ooo`1>0?ooo`030?l0003oool0oooo02D0
oooo00<0o`000?ooo`3oool0C`3oool20?l000H0oooo00<0o`000?ooo`3oool0=@3oool001D0oooo
00<000000?ooo`3oool0C`3oool00`3o0000oooo0?ooo`0S0?ooo`030?l0003oool0oooo0580oooo
00<0o`000?ooo`3oool00P3oool00`3o0000oooo0?ooo`0f0?ooo`005@3oool200000500oooo00<0
o`000?ooo`3oool08`3oool00`3o0000oooo0?ooo`1C0?ooo`80o`0000<0oooo0?l0003oool0>03o
ool001D0oooo00<000000?ooo`3oool0D03oool00`3o0000oooo0?ooo`0Q0?ooo`030?l0003oool0
oooo05H0oooo00<0o`000?ooo`3oool0>03oool001D0oooo00<000000?ooo`3oool0D@3oool00`3o
0000oooo0?ooo`0P0?ooo`030?l0003oool0oooo0940oooo000E0?ooo`030000003oool0oooo0580
oooo00<0o`000?ooo`3oool07P3oool00`3o0000oooo0?ooo`2B0?ooo`005@3oool00`000000oooo
0?ooo`1B0?ooo`030?l0003oool0oooo01h0oooo00<0o`000?ooo`3oool0TP3oool001D0oooo00<0
00000?ooo`3oool0D`3oool00`3o0000oooo0?ooo`0L0?ooo`030?l0003oool0oooo09<0oooo000E
0?ooo`030000003oool0oooo05@0oooo00<0o`000?ooo`3oool06`3oool00`3o0000oooo0?ooo`2C
0?ooo`005@3oool2000005H0oooo00<0o`000?ooo`3oool06@3oool00`3o0000oooo0?ooo`2D0?oo
o`005@3oool00`000000oooo0?ooo`1E0?ooo`030?l0003oool0oooo01T0oooo00<0o`000?ooo`3o
ool0U03oool001D0oooo00<000000?ooo`3oool0EP3oool00`3o0000oooo0?ooo`0G0?ooo`030?l0
003oool0oooo09D0oooo000E0?ooo`030000003oool0oooo05L0oooo00<0o`000?ooo`3oool05@3o
ool00`3o0000oooo0?ooo`2F0?ooo`005@3oool00`000000oooo0?ooo`1H0?ooo`030?l0003oool0
oooo0180oooo0P3o002I0?ooo`005@3oool00`000000oooo0?ooo`1H0?ooo`030?l0003oool0oooo
0140oooo00<0o`000?ooo`3oool0V@3oool001D0oooo00<000000?ooo`3oool0F@3oool00`3o0000
oooo0?ooo`0?0?ooo`030?l0003oool0oooo09X0oooo000E0?ooo`030000003oool0oooo05X0oooo
0P3o000>0?ooo`030?l0003oool0oooo09/0oooo000E0?ooo`800000G@3oool30?l000X0oooo00<0
o`000?ooo`3oool0W03oool001D0oooo00<000000?ooo`3oool0G`3oool20?l000H0oooo0P3o002O
0?ooo`005@3oool00`000000oooo0?ooo`1Q0?ooo`<0o`000P3oool00`3o0000oooo0?ooo`2O0?oo
o`005@3oool00`000000oooo0?ooo`1T0?ooo`80o`00XP3oool001D0oooo00<000000?ooo`3oool0
o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo000E0?ooo`030000003oool0
oooo0?l0oooo2@3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`00o`3ooolQ0?ooo`00
o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00
o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00503oool400000?l0oooo2@3oool001<0
oooo00@000000?ooo`3oool00000o`3oool:0?ooo`004`3oool010000000oooo0?ooo`00003o0?oo
o`X0oooo000B0?ooo`80000000<0oooo000000000000o`3oool:0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.189887, -0.328566, \
0.00867854, 0.0273252}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.298584 0.0349424 [
[.2619 .28608 -9 -9 ]
[.2619 .28608 9 0 ]
[.5 .28608 -3 -9 ]
[.5 .28608 3 0 ]
[.7381 .28608 -9 -9 ]
[.7381 .28608 9 0 ]
[.97619 .28608 -3 -9 ]
[.97619 .28608 3 0 ]
[1.025 .29858 0 -6.4375 ]
[1.025 .29858 10 6.4375 ]
[.01131 .03652 -24 -4.5 ]
[.01131 .03652 0 4.5 ]
[.01131 .12387 -12 -4.5 ]
[.01131 .12387 0 4.5 ]
[.01131 .21123 -24 -4.5 ]
[.01131 .21123 0 4.5 ]
[.01131 .38594 -18 -4.5 ]
[.01131 .38594 0 4.5 ]
[.01131 .4733 -6 -4.5 ]
[.01131 .4733 0 4.5 ]
[.01131 .56065 -18 -4.5 ]
[.01131 .56065 0 4.5 ]
[.02381 .64303 -5.03125 0 ]
[.02381 .64303 5.03125 12.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .29858 m
.2619 .30483 L
s
[(0.5)] .2619 .28608 0 1 Mshowa
.5 .29858 m
.5 .30483 L
s
[(1)] .5 .28608 0 1 Mshowa
.7381 .29858 m
.7381 .30483 L
s
[(1.5)] .7381 .28608 0 1 Mshowa
.97619 .29858 m
.97619 .30483 L
s
[(2)] .97619 .28608 0 1 Mshowa
.125 Mabswid
.07143 .29858 m
.07143 .30233 L
s
.11905 .29858 m
.11905 .30233 L
s
.16667 .29858 m
.16667 .30233 L
s
.21429 .29858 m
.21429 .30233 L
s
.30952 .29858 m
.30952 .30233 L
s
.35714 .29858 m
.35714 .30233 L
s
.40476 .29858 m
.40476 .30233 L
s
.45238 .29858 m
.45238 .30233 L
s
.54762 .29858 m
.54762 .30233 L
s
.59524 .29858 m
.59524 .30233 L
s
.64286 .29858 m
.64286 .30233 L
s
.69048 .29858 m
.69048 .30233 L
s
.78571 .29858 m
.78571 .30233 L
s
.83333 .29858 m
.83333 .30233 L
s
.88095 .29858 m
.88095 .30233 L
s
.92857 .29858 m
.92857 .30233 L
s
.25 Mabswid
0 .29858 m
1 .29858 L
s
gsave
1.025 .29858 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .03652 m
.03006 .03652 L
s
[(-7.5)] .01131 .03652 1 0 Mshowa
.02381 .12387 m
.03006 .12387 L
s
[(-5)] .01131 .12387 1 0 Mshowa
.02381 .21123 m
.03006 .21123 L
s
[(-2.5)] .01131 .21123 1 0 Mshowa
.02381 .38594 m
.03006 .38594 L
s
[(2.5)] .01131 .38594 1 0 Mshowa
.02381 .4733 m
.03006 .4733 L
s
[(5)] .01131 .4733 1 0 Mshowa
.02381 .56065 m
.03006 .56065 L
s
[(7.5)] .01131 .56065 1 0 Mshowa
.125 Mabswid
.02381 .05399 m
.02756 .05399 L
s
.02381 .07146 m
.02756 .07146 L
s
.02381 .08893 m
.02756 .08893 L
s
.02381 .1064 m
.02756 .1064 L
s
.02381 .14134 m
.02756 .14134 L
s
.02381 .15881 m
.02756 .15881 L
s
.02381 .17629 m
.02756 .17629 L
s
.02381 .19376 m
.02756 .19376 L
s
.02381 .2287 m
.02756 .2287 L
s
.02381 .24617 m
.02756 .24617 L
s
.02381 .26364 m
.02756 .26364 L
s
.02381 .28111 m
.02756 .28111 L
s
.02381 .31605 m
.02756 .31605 L
s
.02381 .33353 m
.02756 .33353 L
s
.02381 .351 m
.02756 .351 L
s
.02381 .36847 m
.02756 .36847 L
s
.02381 .40341 m
.02756 .40341 L
s
.02381 .42088 m
.02756 .42088 L
s
.02381 .43835 m
.02756 .43835 L
s
.02381 .45582 m
.02756 .45582 L
s
.02381 .49077 m
.02756 .49077 L
s
.02381 .50824 m
.02756 .50824 L
s
.02381 .52571 m
.02756 .52571 L
s
.02381 .54318 m
.02756 .54318 L
s
.02381 .01904 m
.02756 .01904 L
s
.02381 .00157 m
.02756 .00157 L
s
.02381 .57812 m
.02756 .57812 L
s
.02381 .59559 m
.02756 .59559 L
s
.02381 .61307 m
.02756 .61307 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66.0313 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 1 r
.5 Mabswid
.02381 .29858 m
.07143 .33173 L
.11905 .40981 L
.16667 .48642 L
.21429 .52672 L
.2619 .54848 L
.30952 .54788 L
.35714 .49705 L
.40476 .40243 L
.45238 .26962 L
.5 .13238 L
.54762 .0529 L
.59524 .01472 L
.64286 .09334 L
.69048 .32207 L
.7381 .56433 L
.78571 .60332 L
.83333 .47711 L
.88095 .27156 L
.92857 .10429 L
.97619 .059 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`800000o`3oool40?ooo`00
6`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0oooo0`3o
ool001/0oooo00<000000?ooo`3oool0R`3oool00`3o0?l0oooo0?ooo`1d0?ooo`006`3oool20000
08/0oooo00<0o`3o0?ooo`3o0?l0M@3oool001/0oooo00<000000?ooo`3oool0R@3oool0103o0?l0
oooo0?ooo`3o0?me0?ooo`002@3oool00`000000oooo0?ooo`020?ooo`800000103oool2000000D0
oooo00<000000?ooo`3oool0Q`3oool20?l0o`@0oooo00<0o`3o0?ooo`3oool0LP3oool000T0oooo
00<000000?ooo`3oool01`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo08H0
oooo00<0o`3o0?ooo`3oool0103oool00`3o0?l0oooo0?ooo`1b0?ooo`002@3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo0080oooo0P0000260?ooo`030?l0o`3oool0oooo00H0oooo
00<0o`3o0?ooo`3oool0L@3oool000030?ooo`0000000000008000001@3oool00`000000oooo0?oo
o`070?ooo`8000001@3oool00`000000oooo0?ooo`240?ooo`030?l0o`3oool0oooo00P0oooo00<0
o`3o0?ooo`3oool0L03oool000L0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo08<0oooo00<0o`3o0?ooo`3oool02@3oool00`3o0?l0oooo0?oo
o`1`0?ooo`001`3oool4000000T0oooo0`0000040?ooo`030000003oool0oooo0840oooo0P3o0?l=
0?ooo`030?l0o`3oool0oooo06l0oooo000K0?ooo`030000003oool0oooo0800oooo00<0o`3o0?oo
o`3oool03@3oool00`3o0?l0oooo0?ooo`1_0?ooo`006`3oool200000800oooo00<0o`3o0?ooo`3o
ool03`3oool00`3o0?l0oooo0?ooo`1^0?ooo`006`3oool00`000000oooo0?ooo`1n0?ooo`030?l0
o`3oool0oooo0140oooo00<0o`3o0?ooo`3oool0E@3oool00`3o0?l0oooo0?ooo`0E0?ooo`006`3o
ool00`000000oooo0?ooo`1n0?ooo`030?l0o`3oool0oooo0140oooo00<0o`3o0?ooo`3oool0E03o
ool00`3o0?l0oooo0?ooo`0F0?ooo`006`3oool00`000000oooo0?ooo`1m0?ooo`030?l0o`3oool0
oooo01<0oooo00<0o`3o0?ooo`3oool0DP3oool00`3o0?l0oooo0?ooo`0G0?ooo`006`3oool20000
07d0oooo00<0o`3o0?ooo`3oool0503oool00`3o0?l0oooo0?ooo`1A0?ooo`030?l0o`3oool0oooo
01P0oooo000K0?ooo`030000003oool0oooo07`0oooo00<0o`3o0?ooo`3oool05@3oool00`3o0?l0
oooo0?ooo`1?0?ooo`030?l0o`3oool0oooo01T0oooo000K0?ooo`030000003oool0oooo07/0oooo
00<0o`3o0?ooo`3oool05`3oool00`3o0?l0oooo0?ooo`1=0?ooo`030?l0o`3oool0oooo01X0oooo
000K0?ooo`030000003oool0oooo07/0oooo00<0o`3o0?ooo`3oool05`3oool00`3o0?l0oooo0?oo
o`1;0?ooo`80o`3o7@3oool001/0oooo00<000000?ooo`3oool0NP3oool00`3o0?l0oooo0?ooo`0I
0?ooo`030?l0o`3oool0oooo04T0oooo00<0o`3o0?ooo`3oool07@3oool001/0oooo0P00001j0?oo
o`030?l0o`3oool0oooo01X0oooo00<0o`3o0?ooo`3oool0B03oool00`3o0?l0oooo0?ooo`0N0?oo
o`006`3oool00`000000oooo0?ooo`1i0?ooo`030?l0o`3oool0oooo01/0oooo00<0o`3o0?ooo`3o
ool0AP3oool00`3o0?l0oooo0?ooo`0O0?ooo`006`3oool00`000000oooo0?ooo`1h0?ooo`030?l0
o`3oool0oooo01`0oooo00<0o`3o0?ooo`3oool0A@3oool00`3o0?l0oooo0?ooo`0P0?ooo`006`3o
ool00`000000oooo0?ooo`1g0?ooo`030?l0o`3oool0oooo01d0oooo00<0o`3o0?ooo`3oool0A03o
ool00`3o0?l0oooo0?ooo`0Q0?ooo`006`3oool2000007P0oooo00<0o`3o0?ooo`3oool07P3oool0
0`3o0?l0oooo0?ooo`130?ooo`030?l0o`3oool0oooo0240oooo000K0?ooo`030000003oool0oooo
07H0oooo00<0o`3o0?ooo`3oool07`3oool00`3o0?l0oooo0?ooo`120?ooo`030?l0o`3oool0oooo
0280oooo000D0?ooo`8000001@3oool00`000000oooo0?ooo`1f0?ooo`030?l0o`3oool0oooo01l0
oooo00<0o`3o0?ooo`3oool0@P3oool00`3o0?l0oooo0?ooo`0R0?ooo`004`3oool010000000oooo
0?ooo`0000040?ooo`030000003oool0oooo07D0oooo00<0o`3o0?ooo`3oool0803oool00`3o0?l0
oooo0?ooo`120?ooo`030?l0o`3oool0oooo0280oooo000F0?ooo`030000003oool0oooo0080oooo
0P00001e0?ooo`030?l0o`3oool0oooo0240oooo00<0o`3o0?ooo`3oool0@P3oool00`3o0?l0oooo
0?ooo`0R0?ooo`003@3oool4000000<0oooo0P0000050?ooo`030000003oool0oooo07@0oooo00<0
o`3o0?ooo`3oool08P3oool00`3o0?l0oooo0?ooo`100?ooo`030?l0o`3oool0oooo02<0oooo000D
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0L`3oool00`3o0?l0oooo0?ooo`0S
0?ooo`030?l0o`3oool0oooo0400oooo00<0o`3o0?ooo`3oool08`3oool001@0oooo0`0000040?oo
o`030000003oool0oooo07<0oooo00<0o`3o0?ooo`3oool08`3oool00`3o0?l0oooo0?ooo`100?oo
o`030?l0o`3oool0oooo02<0oooo000K0?ooo`030000003oool0oooo0780oooo00<0o`3o0?ooo`3o
ool0903oool00`3o0?l0oooo0?ooo`100?ooo`030?l0o`3oool0oooo02<0oooo000K0?ooo`800000
L`3oool00`3o0?l0oooo0?ooo`0U0?ooo`030?l0o`3oool0oooo03h0oooo00<0o`3o0?ooo`3oool0
903oool001/0oooo00<000000?ooo`3oool0LP3oool00`3o0?l0oooo0?ooo`0U0?ooo`030?l0o`3o
ool0oooo03h0oooo00<0o`3o0?ooo`3oool0903oool001/0oooo00<000000?ooo`3oool0L@3oool0
0`3o0?l0oooo0?ooo`0V0?ooo`030?l0o`3oool0oooo03h0oooo00<0o`3o0?ooo`3oool0903oool0
01/0oooo00<000000?ooo`3oool0L@3oool00`3o0?l0oooo0?ooo`0V0?ooo`030?l0o`3oool0oooo
03h0oooo00<0o`3o0?ooo`3oool0903oool001/0oooo0P00001b0?ooo`030?l0o`3oool0oooo02H0
oooo00<0o`3o0?ooo`3oool0?@3oool00`3o0?l0oooo0?ooo`0U0?ooo`006`3oool00`000000oooo
0?ooo`1`0?ooo`030?l0o`3oool0oooo02P0oooo00<0o`3o0?ooo`3oool0?03oool00`3o0?l0oooo
0?ooo`0U0?ooo`006`3oool00`000000oooo0?ooo`1`0?ooo`030?l0o`3oool0oooo02P0oooo00<0
o`3o0?ooo`3oool0?03oool00`3o0?l0oooo0?ooo`0U0?ooo`006`3oool00`000000oooo0?ooo`1`
0?ooo`030?l0o`3oool0oooo02P0oooo00<0o`3o0?ooo`3oool0?03oool00`3o0?l0oooo0?ooo`0U
0?ooo`006`3oool200000740oooo00<0o`3o0?ooo`3oool0:03oool00`3o0?l0oooo0?ooo`0k0?oo
o`030?l0o`3oool0oooo02H0oooo000K0?ooo`030000003oool0oooo06l0oooo00<0o`3o0?ooo`3o
ool0:@3oool00`3o0?l0oooo0?ooo`0k0?ooo`030?l0o`3oool0oooo02H0oooo000K0?ooo`030000
003oool0oooo06l0oooo00<0o`3o0?ooo`3oool0:P3oool00`3o0?l0oooo0?ooo`0j0?ooo`030?l0
o`3oool0oooo02H0oooo000K0?ooo`030000003oool0oooo06l0oooo00<0o`3o0?ooo`3oool0:P3o
ool00`3o0?l0oooo0?ooo`0i0?ooo`030?l0o`3oool0oooo02L0oooo000K0?ooo`030000003oool0
oooo06h0oooo00<0o`3o0?ooo`3oool0:`3oool00`3o0?l0oooo0?ooo`0i0?ooo`030?l0o`3oool0
oooo02L0oooo000K0?ooo`800000K`3oool00`3o0?l0oooo0?ooo`0[0?ooo`030?l0o`3oool0oooo
03T0oooo00<0o`3o0?ooo`3oool09`3oool001/0oooo00<000000?ooo`3oool0KP3oool00`3o0?l0
oooo0?ooo`0[0?ooo`030?l0o`3oool0oooo03T0oooo00<0o`3o0?ooo`3oool09`3oool000L0oooo
100000030?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool0K@3oool00`3o0?l0oooo
0?ooo`0]0?ooo`030?l0o`3oool0oooo03L0oooo00<0o`3o0?ooo`3oool0:03oool000L0oooo00<0
00000?ooo`3oool02@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo06d0oooo
00<0o`3o0?ooo`3oool0;@3oool00`3o0?l0oooo0?ooo`0g0?ooo`030?l0o`3oool0oooo02P0oooo
00080?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool00P3oool2000006h0oooo00<0
o`3o0?ooo`3oool0;@3oool00`3o0?l0oooo0?ooo`0g0?ooo`030?l0o`3oool0oooo02P0oooo0000
0`3oool0000000000002000000@0oooo00<000000?ooo`3oool0203oool2000000D0oooo00<00000
0?ooo`3oool0K03oool00`3o0?l0oooo0?ooo`0^0?ooo`030?l0o`3oool0oooo03L0oooo00<0o`3o
0?ooo`3oool0:03oool000L0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo06`0oooo00<0o`3o0?ooo`3oool0;`3oool00`3o0?l0oooo0?ooo`0e
0?ooo`030?l0o`3oool0oooo02T0oooo00080?ooo`8000002P3oool3000000@0oooo00<000000?oo
o`3oool0K03oool00`3o0?l0oooo0?ooo`0_0?ooo`030?l0o`3oool0oooo03D0oooo00<0o`3o0?oo
o`3oool0:@3oool001/0oooo0P00001/0?ooo`030?l0o`3oool0oooo0300oooo00<0o`3o0?ooo`3o
ool0=@3oool00`3o0?l0oooo0?ooo`0Y0?ooo`006`3oool00`000000oooo0?ooo`1[0?ooo`030?l0
o`3oool0oooo0300oooo00<0o`3o0?ooo`3oool0=@3oool00`3o0?l0oooo0?ooo`0Y0?ooo`006`3o
ool00`000000oooo0?ooo`1[0?ooo`030?l0o`3oool0oooo0300oooo00<0o`3o0?ooo`3oool0=03o
ool00`3o0?l0oooo0?ooo`0Z0?ooo`006`3oool00`000000oooo0?ooo`1[0?ooo`030?l0o`3oool0
oooo0340oooo00<0o`3o0?ooo`3oool0<`3oool00`3o0?l0oooo0?ooo`0Z0?ooo`006`3oool00`00
0000oooo0?ooo`1Z0?ooo`030?l0o`3oool0oooo0380oooo00<0o`3o0?ooo`3oool0<`3oool00`3o
0?l0oooo0?ooo`0Z0?ooo`006`3oool2000006/0oooo00<0o`3o0?ooo`3oool0<P3oool00`3o0?l0
oooo0?ooo`0c0?ooo`030?l0o`3oool0oooo02X0oooo000K0?ooo`030000003oool0oooo06X0oooo
00<0o`3o0?ooo`3oool0<P3oool00`3o0?l0oooo0?ooo`0b0?ooo`030?l0o`3oool0oooo02/0oooo
000K0?ooo`030000003oool0oooo0340oooo0P0000040?ooo`800000103oool2000002X0oooo00<0
o`3o0?ooo`3oool01@3oool5000002T0oooo00<0o`3o0?ooo`3oool01@3oool500000080oooo0P00
00040?ooo`8000007P3oool00`3o0?l0oooo0?ooo`0A0?ooo`@000005P3oool001/0oooo00<00000
0?ooo`3oool0<03oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000002T0oooo
00<0o`3o0?ooo`3oool01`3oool00`000000oooo0?ooo`0Z0?ooo`030?l0o`3oool0oooo00H0oooo
00<000000?ooo`3oool01`3oool010000000oooo0?ooo`00000M0?ooo`030?l0o`3oool0oooo0140
oooo00<000000?ooo`3oool05`3oool001/0oooo0P00000a0?ooo`040000003oool0oooo000000/0
oooo00<000000?ooo`3oool09`3oool00`3o0?l0oooo0?ooo`070?ooo`030000003oool0oooo02X0
oooo00<0o`3o0?ooo`3oool01P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01/0
oooo00<0o`3o0?ooo`3oool04P3oool00`000000oooo0?ooo`0F0?ooo`006`3oool00`000000oooo
0?ooo`0`0?ooo`040000003oool0oooo000000T0oooo0P00000Y0?ooo`030?l0o`3oool0oooo00P0
oooo00<000000?ooo`3oool0:P3oool00`3o0?l0oooo0?ooo`060?ooo`030000003oool0oooo00P0
oooo0P00000M0?ooo`030?l0o`3oool0oooo01@0oooo00<000000?ooo`3oool05@3oool001/0oooo
00<000000?ooo`3oool0<03oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo02P0
oooo00<0o`3o0?ooo`3oool0203oool00`000000oooo0?ooo`0Z0?ooo`030?l0o`3oool0oooo00H0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0L0?ooo`030?l0o`3oool0oooo0180
oooo00@000000?ooo`3oool000005P3oool001/0oooo00<000000?ooo`3oool0<@3oool2000000X0
oooo0`00000X0?ooo`030?l0o`3oool0oooo00L0oooo0P00000/0?ooo`030?l0o`3oool0oooo00D0
oooo0P00000:0?ooo`<00000703oool00`3o0?l0oooo0?ooo`0C0?ooo`8000005`3oool001/0oooo
00<000000?ooo`3oool0I`3oool00`3o0?l0oooo0?ooo`0g0?ooo`030?l0o`3oool0oooo02l0oooo
00<0o`3o0?ooo`3oool0;03oool001/0oooo0P00001X0?ooo`030?l0o`3oool0oooo03L0oooo00<0
o`3o0?ooo`3oool0;P3oool00`3o0?l0oooo0?ooo`0]0?ooo`006`3oool00`000000oooo0?ooo`1W
0?ooo`030?l0o`3oool0oooo03L0oooo00<0o`3o0?ooo`3oool0;P3oool00`3o0?l0oooo0?ooo`0]
0?ooo`006`3oool00`000000oooo0?ooo`1V0?ooo`030?l0o`3oool0oooo03P0oooo00<0o`3o0?oo
o`3oool0;P3oool00`3o0?l0oooo0?ooo`0V0?ooo`8000001@3oool001/0oooo00<000000?ooo`3o
ool0IP3oool00`3o0?l0oooo0?ooo`0i0?ooo`030?l0o`3oool0oooo02d0oooo00<0o`3o0?ooo`3o
ool09@3oool010000000oooo0?ooo`0000040?ooo`005@3oool6000000030?l0o`000000000006D0
000000<0o`3o000000000000>P0000000`3o0?l000000000000/000000030?l0o`000000000001d0
00002@3oool00`000000oooo0?ooo`050?ooo`006`3oool00`000000o`3o0?l0o`090?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool01P3oool0103o0?l0oooo0?ooo`00000:0?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00P0oooo00<0o`3o0000003oool02P3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool01`3oool00`3o0?l0oooo0000000:0?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool0303oool5000000@0oooo000K0?ooo`040000
003oool0oooo0?l0of@0oooo00<0o`3o0?ooo`3oool0>P3oool00`3o0?l0oooo0?ooo`0/0?ooo`03
0?l0o`3oool0oooo02H0oooo00<000000?ooo`3oool01@3oool001/0oooo00@000000?ooo`3oool0
oooo0P3o0?mQ0?ooo`030?l0o`3oool0oooo03/0oooo00<0o`3o0?ooo`3oool0;03oool00`3o0?l0
oooo0?ooo`0^0?ooo`006`3oool2000000@0oooo00<0o`3o0?ooo`3oool0GP3oool00`3o0?l0oooo
0?ooo`0l0?ooo`030?l0o`3oool0oooo02X0oooo00<0o`3o0?ooo`3oool0;`3oool001/0oooo00<0
00000?ooo`3oool0103oool20?l0oeh0oooo00<0o`3o0?ooo`3oool0?03oool00`3o0?l0oooo0?oo
o`0Z0?ooo`030?l0o`3oool0oooo02l0oooo000K0?ooo`030000003oool0oooo00H0oooo00<0o`3o
0?ooo`3oool0FP3oool00`3o0?l0oooo0?ooo`0m0?ooo`030?l0o`3oool0oooo02X0oooo00<0o`3o
0?ooo`3oool0;`3oool001/0oooo00<000000?ooo`3oool01`3oool20?l0oeX0oooo00<0o`3o0?oo
o`3oool0?@3oool00`3o0?l0oooo0?ooo`0Z0?ooo`030?l0o`3oool0oooo02l0oooo000K0?ooo`03
0000003oool0oooo00T0oooo00<0o`3o0?ooo`3oool0E`3oool00`3o0?l0oooo0?ooo`0m0?ooo`03
0?l0o`3oool0oooo02T0oooo00<0o`3o0?ooo`3oool0<03oool001/0oooo0P00000;0?ooo`030?l0
o`3oool0oooo05D0oooo00<0o`3o0?ooo`3oool0?`3oool00`3o0?l0oooo0?ooo`0X0?ooo`030?l0
o`3oool0oooo0300oooo000K0?ooo`030000003oool0oooo00X0oooo00<0o`3o0?ooo`3oool0E@3o
ool00`3o0?l0oooo0?ooo`0o0?ooo`030?l0o`3oool0oooo02P0oooo00<0o`3o0?ooo`3oool0<03o
ool001/0oooo00<000000?ooo`3oool02`3oool00`3o0?l0oooo0?ooo`1C0?ooo`030?l0o`3oool0
oooo0400oooo00<0o`3o0?ooo`3oool0:03oool00`3o0?l0oooo0?ooo`0`0?ooo`006`3oool00`00
0000oooo0?ooo`0;0?ooo`030?l0o`3oool0oooo05<0oooo00<0o`3o0?ooo`3oool0@03oool00`3o
0?l0oooo0?ooo`0X0?ooo`030?l0o`3oool0oooo0300oooo000K0?ooo`8000003@3oool00`3o0?l0
oooo0?ooo`1B0?ooo`030?l0o`3oool0oooo0400oooo00<0o`3o0?ooo`3oool09`3oool00`3o0?l0
oooo0?ooo`0a0?ooo`006`3oool00`000000oooo0?ooo`0<0?ooo`030?l0o`3oool0oooo0540oooo
00<0o`3o0?ooo`3oool0@P3oool00`3o0?l0oooo0?ooo`0V0?ooo`030?l0o`3oool0oooo0340oooo
000K0?ooo`030000003oool0oooo00d0oooo00<0o`3o0?ooo`3oool0D03oool00`3o0?l0oooo0?oo
o`120?ooo`030?l0o`3oool0oooo02H0oooo00<0o`3o0?ooo`3oool0<@3oool001/0oooo00<00000
0?ooo`3oool03@3oool00`3o0?l0oooo0?ooo`1@0?ooo`030?l0o`3oool0oooo0480oooo00<0o`3o
0?ooo`3oool09P3oool00`3o0?l0oooo0?ooo`0a0?ooo`006`3oool2000000l0oooo00<0o`3o0?oo
o`3oool0CP3oool00`3o0?l0oooo0?ooo`130?ooo`030?l0o`3oool0oooo02D0oooo00<0o`3o0?oo
o`3oool0<P3oool001/0oooo00<000000?ooo`3oool03P3oool00`3o0?l0oooo0?ooo`1>0?ooo`03
0?l0o`3oool0oooo04<0oooo00<0o`3o0?ooo`3oool09@3oool00`3o0?l0oooo0?ooo`0b0?ooo`00
6`3oool00`000000oooo0?ooo`0?0?ooo`030?l0o`3oool0oooo04d0oooo00<0o`3o0?ooo`3oool0
A03oool00`3o0?l0oooo0?ooo`0T0?ooo`030?l0o`3oool0oooo0380oooo00070?ooo`@000000`3o
ool2000000@0oooo0P0000050?ooo`030000003oool0oooo0100oooo00<0o`3o0?ooo`3oool0B`3o
ool00`3o0?l0oooo0?ooo`150?ooo`030?l0o`3oool0oooo02@0oooo00<0o`3o0?ooo`3oool0<P3o
ool000L0oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`0000040?ooo`030000003o
ool0oooo0100oooo00<0o`3o0?ooo`3oool0B`3oool00`3o0?l0oooo0?ooo`150?ooo`030?l0o`3o
ool0oooo02<0oooo00<0o`3o0?ooo`3oool0<`3oool000P0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`020?ooo`8000004P3oool00`3o0?l0oooo0?ooo`190?ooo`030?l0o`3oool0
oooo04H0oooo00<0o`3o0?ooo`3oool08`3oool00`3o0?l0oooo0?ooo`0c0?ooo`002@3oool00`00
0000oooo0?ooo`080?ooo`8000001@3oool00`000000oooo0?ooo`0A0?ooo`030?l0o`3oool0oooo
04T0oooo00<0o`3o0?ooo`3oool0AP3oool00`3o0?l0oooo0?ooo`0S0?ooo`030?l0o`3oool0oooo
03<0oooo00070?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0B0?ooo`030?l0o`3oool0oooo04P0oooo00<0o`3o0?ooo`3oool0A`3oool00`3o
0?l0oooo0?ooo`0R0?ooo`030?l0o`3oool0oooo03<0oooo00080?ooo`8000002P3oool3000000@0
oooo00<000000?ooo`3oool04P3oool00`3o0?l0oooo0?ooo`170?ooo`030?l0o`3oool0oooo04P0
oooo00<0o`3o0?ooo`3oool08@3oool00`3o0?l0oooo0?ooo`0d0?ooo`006`3oool2000001@0oooo
00<0o`3o0?ooo`3oool0AP3oool00`3o0?l0oooo0?ooo`180?ooo`030?l0o`3oool0oooo0240oooo
00<0o`3o0?ooo`3oool0=03oool001/0oooo00<000000?ooo`3oool04`3oool00`3o0?l0oooo0?oo
o`150?ooo`030?l0o`3oool0oooo04T0oooo00<0o`3o0?ooo`3oool08@3oool00`3o0?l0oooo0?oo
o`0d0?ooo`006`3oool00`000000oooo0?ooo`0D0?ooo`030?l0o`3oool0oooo04@0oooo00<0o`3o
0?ooo`3oool0B@3oool00`3o0?l0oooo0?ooo`0Q0?ooo`030?l0o`3oool0oooo03@0oooo000K0?oo
o`030000003oool0oooo01D0oooo00<0o`3o0?ooo`3oool0@P3oool00`3o0?l0oooo0?ooo`1;0?oo
o`030?l0o`3oool0oooo0200oooo00<0o`3o0?ooo`3oool0=03oool001/0oooo0P00000F0?ooo`03
0?l0o`3oool0oooo0480oooo00<0o`3o0?ooo`3oool0B`3oool00`3o0?l0oooo0?ooo`0O0?ooo`03
0?l0o`3oool0oooo03D0oooo000K0?ooo`030000003oool0oooo01H0oooo00<0o`3o0?ooo`3oool0
@03oool00`3o0?l0oooo0?ooo`1<0?ooo`030?l0o`3oool0oooo01l0oooo00<0o`3o0?ooo`3oool0
=@3oool001/0oooo00<000000?ooo`3oool05`3oool00`3o0?l0oooo0?ooo`0o0?ooo`030?l0o`3o
ool0oooo04`0oooo00<0o`3o0?ooo`3oool07`3oool00`3o0?l0oooo0?ooo`0e0?ooo`006`3oool0
0`000000oooo0?ooo`0G0?ooo`030?l0o`3oool0oooo03h0oooo00<0o`3o0?ooo`3oool0C@3oool0
0`3o0?l0oooo0?ooo`0O0?ooo`030?l0o`3oool0oooo03D0oooo000K0?ooo`030000003oool0oooo
01P0oooo00<0o`3o0?ooo`3oool0?@3oool00`3o0?l0oooo0?ooo`1>0?ooo`030?l0o`3oool0oooo
01d0oooo00<0o`3o0?ooo`3oool0=P3oool001/0oooo0P00000I0?ooo`030?l0o`3oool0oooo03`0
oooo00<0o`3o0?ooo`3oool0C`3oool00`3o0?l0oooo0?ooo`0M0?ooo`030?l0o`3oool0oooo03H0
oooo000K0?ooo`030000003oool0oooo01T0oooo00<0o`3o0?ooo`3oool0>`3oool00`3o0?l0oooo
0?ooo`1?0?ooo`030?l0o`3oool0oooo01d0oooo00<0o`3o0?ooo`3oool0=P3oool001/0oooo00<0
00000?ooo`3oool06P3oool00`3o0?l0oooo0?ooo`0i0?ooo`030?l0o`3oool0oooo0500oooo00<0
o`3o0?ooo`3oool07@3oool00`3o0?l0oooo0?ooo`0f0?ooo`006`3oool00`000000oooo0?ooo`0J
0?ooo`030?l0o`3oool0oooo03T0oooo00<0o`3o0?ooo`3oool0D03oool00`3o0?l0oooo0?ooo`0L
0?ooo`030?l0o`3oool0oooo03L0oooo000K0?ooo`800000703oool00`3o0?l0oooo0?ooo`0g0?oo
o`030?l0o`3oool0oooo0580oooo00<0o`3o0?ooo`3oool06`3oool00`3o0?l0oooo0?ooo`0g0?oo
o`006`3oool00`000000oooo0?ooo`0L0?ooo`030?l0o`3oool0oooo03H0oooo00<0o`3o0?ooo`3o
ool0DP3oool00`3o0?l0oooo0?ooo`0K0?ooo`030?l0o`3oool0oooo03L0oooo000D0?ooo`800000
1@3oool00`000000oooo0?ooo`0L0?ooo`030?l0o`3oool0oooo03D0oooo00<0o`3o0?ooo`3oool0
D`3oool00`3o0?l0oooo0?ooo`0K0?ooo`030?l0o`3oool0oooo03L0oooo000C0?ooo`040000003o
ool0oooo000000@0oooo00<000000?ooo`3oool07@3oool00`3o0?l0oooo0?ooo`0d0?ooo`030?l0
o`3oool0oooo05<0oooo00<0o`3o0?ooo`3oool06P3oool00`3o0?l0oooo0?ooo`0h0?ooo`005P3o
ool00`000000oooo0?ooo`020?ooo`8000007P3oool00`3o0?l0oooo0?ooo`0c0?ooo`030?l0o`3o
ool0oooo05@0oooo00<0o`3o0?ooo`3oool06P3oool00`3o0?l0oooo0?ooo`0h0?ooo`00503oool2
000000D0oooo00<000000?ooo`3oool07P3oool00`3o0?l0oooo0?ooo`0b0?ooo`030?l0o`3oool0
oooo05D0oooo00<0o`3o0?ooo`3oool06@3oool00`3o0?l0oooo0?ooo`0h0?ooo`00503oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo01l0oooo00<0o`3o0?ooo`3oool0<03oool00`3o
0?l0oooo0?ooo`1F0?ooo`030?l0o`3oool0oooo01T0oooo00<0o`3o0?ooo`3oool0>03oool001@0
oooo0`0000040?ooo`030000003oool0oooo01l0oooo00<0o`3o0?ooo`3oool0<03oool00`3o0?l0
oooo0?ooo`1F0?ooo`030?l0o`3oool0oooo01P0oooo00<0o`3o0?ooo`3oool0>@3oool001/0oooo
00<000000?ooo`3oool0803oool00`3o0?l0oooo0?ooo`0^0?ooo`030?l0o`3oool0oooo05L0oooo
00<0o`3o0?ooo`3oool0603oool00`3o0?l0oooo0?ooo`0i0?ooo`006`3oool200000280oooo00<0
o`3o0?ooo`3oool0;@3oool00`3o0?l0oooo0?ooo`1G0?ooo`030?l0o`3oool0oooo01L0oooo00<0
o`3o0?ooo`3oool0>P3oool001/0oooo00<000000?ooo`3oool08P3oool00`3o0?l0oooo0?ooo`0[
0?ooo`030?l0o`3oool0oooo05T0oooo00<0o`3o0?ooo`3oool05P3oool00`3o0?l0oooo0?ooo`0j
0?ooo`006`3oool00`000000oooo0?ooo`0S0?ooo`80o`3o:P3oool00`3o0?l0oooo0?ooo`1J0?oo
o`030?l0o`3oool0oooo01H0oooo00<0o`3o0?ooo`3oool0>P3oool001/0oooo00<000000?ooo`3o
ool09@3oool00`3o0?l0oooo0?ooo`0V0?ooo`030?l0o`3oool0oooo05/0oooo00<0o`3o0?ooo`3o
ool05@3oool00`3o0?l0oooo0?ooo`0k0?ooo`006`3oool2000002L0oooo00<0o`3o0?ooo`3oool0
903oool00`3o0?l0oooo0?ooo`1L0?ooo`030?l0o`3oool0oooo01D0oooo00<0o`3o0?ooo`3oool0
>`3oool001/0oooo00<000000?ooo`3oool09`3oool00`3o0?l0oooo0?ooo`0R0?ooo`030?l0o`3o
ool0oooo05d0oooo00<0o`3o0?ooo`3oool05@3oool00`3o0?l0oooo0?ooo`0k0?ooo`006`3oool0
0`000000oooo0?ooo`0X0?ooo`030?l0o`3oool0oooo0200oooo00<0o`3o0?ooo`3oool0G`3oool0
0`3o0?l0oooo0?ooo`0C0?ooo`030?l0o`3oool0oooo03`0oooo000K0?ooo`030000003oool0oooo
02T0oooo0P3o0?lO0?ooo`030?l0o`3oool0oooo0600oooo00<0o`3o0?ooo`3oool04`3oool00`3o
0?l0oooo0?ooo`0l0?ooo`006`3oool00`000000oooo0?ooo`0[0?ooo`030?l0o`3oool0oooo01`0
oooo00<0o`3o0?ooo`3oool0H03oool00`3o0?l0oooo0?ooo`0B0?ooo`030?l0o`3oool0oooo03d0
oooo000K0?ooo`800000;@3oool20?l0oa/0oooo00<0o`3o0?ooo`3oool0H@3oool00`3o0?l0oooo
0?ooo`0B0?ooo`030?l0o`3oool0oooo03d0oooo000K0?ooo`030000003oool0oooo02h0oooo0P3o
0?lH0?ooo`030?l0o`3oool0oooo0680oooo00<0o`3o0?ooo`3oool04P3oool00`3o0?l0oooo0?oo
o`0m0?ooo`006`3oool00`000000oooo0?ooo`0`0?ooo`80o`3o5@3oool00`3o0?l0oooo0?ooo`1T
0?ooo`030?l0o`3oool0oooo0100oooo00<0o`3o0?ooo`3oool0?P3oool001/0oooo00<000000?oo
o`3oool0<P3oool30?l0oa40oooo00<0o`3o0?ooo`3oool0I@3oool00`3o0?l0oooo0?ooo`0@0?oo
o`030?l0o`3oool0oooo03h0oooo000K0?ooo`800000=P3oool20?l0o`h0oooo00<0o`3o0?ooo`3o
ool0IP3oool00`3o0?l0oooo0?ooo`0@0?ooo`030?l0o`3oool0oooo03h0oooo000K0?ooo`030000
003oool0oooo03L0oooo3P3o0?mY0?ooo`030?l0o`3oool0oooo00l0oooo00<0o`3o0?ooo`3oool0
?`3oool000T0oooo00<000000?ooo`3oool00P3oool2000000@0oooo0P0000050?ooo`030000003o
ool0oooo0:h0oooo00<0o`3o0?ooo`3oool03`3oool00`3o0?l0oooo0?ooo`0o0?ooo`002@3oool0
0`000000oooo0?ooo`070?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0[`3o
ool00`3o0?l0oooo0?ooo`0=0?ooo`030?l0o`3oool0oooo0400oooo00090?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool00P3oool200000;00oooo00<0o`3o0?ooo`3oool03@3oool0
0`3o0?l0oooo0?ooo`100?ooo`002P3oool00`000000oooo0?ooo`070?ooo`8000001@3oool00`00
0000oooo0?ooo`2_0?ooo`030?l0o`3oool0oooo00d0oooo00<0o`3o0?ooo`3oool0@03oool000L0
oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
0;00oooo00<0o`3o0?ooo`3oool02`3oool00`3o0?l0oooo0?ooo`110?ooo`001`3oool4000000T0
oooo0`0000040?ooo`030000003oool0oooo0;40oooo00<0o`3o0?ooo`3oool02P3oool00`3o0?l0
oooo0?ooo`110?ooo`006`3oool00`000000oooo0?ooo`2b0?ooo`80o`3o2P3oool00`3o0?l0oooo
0?ooo`110?ooo`006`3oool200000;D0oooo00<0o`3o0?ooo`3oool01P3oool00`3o0?l0oooo0?oo
o`120?ooo`006`3oool00`000000oooo0?ooo`2e0?ooo`030?l0o`3oool0oooo00D0oooo00<0o`3o
0?ooo`3oool0@P3oool001/0oooo00<000000?ooo`3oool0]P3oool00`3o0?l0oooo0?ooo`030?oo
o`030?l0o`3oool0oooo04<0oooo000K0?ooo`030000003oool0oooo0;L0oooo00<0o`3o0?ooo`3o
ool00P3oool00`3o0?l0oooo0?ooo`130?ooo`006`3oool200000;T0oooo0P3o0?l20?ooo`030?l0
o`3oool0oooo04<0oooo000K0?ooo`030000003oool0oooo0;X0oooo0P3o0?m60?ooo`006`3oool0
0`000000oooo0?ooo`2k0?ooo`030?l0o`3oool0oooo04@0oooo000K0?ooo`030000003oool0oooo
0?l0oooo0`3oool001/0oooo0P00003o0?ooo`@0oooo000K0?ooo`030000003oool0oooo0?l0oooo
0`3oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`006P3oool200000?l0oooo1@3oool0
01X0oooo0P00003o0?ooo`D0oooo000I0?ooo`040000003oool0oooo00000?l0oooo103oool001P0
oooo0P0000020?ooo`800000o`3oool30?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.228198, -8.74998, \
0.00841412, 0.114666}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.282032 0.00433708 [
[.2619 .26953 -9 -9 ]
[.2619 .26953 9 0 ]
[.5 .26953 -3 -9 ]
[.5 .26953 3 0 ]
[.7381 .26953 -9 -9 ]
[.7381 .26953 9 0 ]
[.97619 .26953 -3 -9 ]
[.97619 .26953 3 0 ]
[1.025 .28203 0 -6.4375 ]
[1.025 .28203 10 6.4375 ]
[.01131 .02181 -18 -4.5 ]
[.01131 .02181 0 4.5 ]
[.01131 .10855 -18 -4.5 ]
[.01131 .10855 0 4.5 ]
[.01131 .19529 -18 -4.5 ]
[.01131 .19529 0 4.5 ]
[.01131 .36877 -12 -4.5 ]
[.01131 .36877 0 4.5 ]
[.01131 .45551 -12 -4.5 ]
[.01131 .45551 0 4.5 ]
[.01131 .54226 -12 -4.5 ]
[.01131 .54226 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .28203 m
.2619 .28828 L
s
[(0.5)] .2619 .26953 0 1 Mshowa
.5 .28203 m
.5 .28828 L
s
[(1)] .5 .26953 0 1 Mshowa
.7381 .28203 m
.7381 .28828 L
s
[(1.5)] .7381 .26953 0 1 Mshowa
.97619 .28203 m
.97619 .28828 L
s
[(2)] .97619 .26953 0 1 Mshowa
.125 Mabswid
.07143 .28203 m
.07143 .28578 L
s
.11905 .28203 m
.11905 .28578 L
s
.16667 .28203 m
.16667 .28578 L
s
.21429 .28203 m
.21429 .28578 L
s
.30952 .28203 m
.30952 .28578 L
s
.35714 .28203 m
.35714 .28578 L
s
.40476 .28203 m
.40476 .28578 L
s
.45238 .28203 m
.45238 .28578 L
s
.54762 .28203 m
.54762 .28578 L
s
.59524 .28203 m
.59524 .28578 L
s
.64286 .28203 m
.64286 .28578 L
s
.69048 .28203 m
.69048 .28578 L
s
.78571 .28203 m
.78571 .28578 L
s
.83333 .28203 m
.83333 .28578 L
s
.88095 .28203 m
.88095 .28578 L
s
.92857 .28203 m
.92857 .28578 L
s
.25 Mabswid
0 .28203 m
1 .28203 L
s
gsave
1.025 .28203 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .02181 m
.03006 .02181 L
s
[(-60)] .01131 .02181 1 0 Mshowa
.02381 .10855 m
.03006 .10855 L
s
[(-40)] .01131 .10855 1 0 Mshowa
.02381 .19529 m
.03006 .19529 L
s
[(-20)] .01131 .19529 1 0 Mshowa
.02381 .36877 m
.03006 .36877 L
s
[(20)] .01131 .36877 1 0 Mshowa
.02381 .45551 m
.03006 .45551 L
s
[(40)] .01131 .45551 1 0 Mshowa
.02381 .54226 m
.03006 .54226 L
s
[(60)] .01131 .54226 1 0 Mshowa
.125 Mabswid
.02381 .04349 m
.02756 .04349 L
s
.02381 .06518 m
.02756 .06518 L
s
.02381 .08686 m
.02756 .08686 L
s
.02381 .13023 m
.02756 .13023 L
s
.02381 .15192 m
.02756 .15192 L
s
.02381 .17361 m
.02756 .17361 L
s
.02381 .21698 m
.02756 .21698 L
s
.02381 .23866 m
.02756 .23866 L
s
.02381 .26035 m
.02756 .26035 L
s
.02381 .30372 m
.02756 .30372 L
s
.02381 .3254 m
.02756 .3254 L
s
.02381 .34709 m
.02756 .34709 L
s
.02381 .39046 m
.02756 .39046 L
s
.02381 .41214 m
.02756 .41214 L
s
.02381 .43383 m
.02756 .43383 L
s
.02381 .4772 m
.02756 .4772 L
s
.02381 .49889 m
.02756 .49889 L
s
.02381 .52057 m
.02756 .52057 L
s
.02381 .00012 m
.02756 .00012 L
s
.02381 .56394 m
.02756 .56394 L
s
.02381 .58563 m
.02756 .58563 L
s
.02381 .60731 m
.02756 .60731 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .28203 m
.07143 .36431 L
.11905 .39359 L
.16667 .36064 L
.21429 .30348 L
.2619 .3146 L
.30952 .24798 L
.35714 .1899 L
.40476 .13927 L
.45238 .09512 L
.5 .12823 L
.54762 .23855 L
.59524 .23072 L
.64286 .52854 L
.69048 .60332 L
.7381 .44917 L
.78571 .2117 L
.83333 .03907 L
.88095 .01472 L
.92857 .13412 L
.97619 .31753 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003o5@3oool2
00000?l0oooo2P3oool001D0oooo00<000000?ooo`3oool0o`3oool90?ooo`005@3oool00`000000
oooo0?ooo`3o0?ooo`T0oooo00070?ooo`<00000103oool2000000D0oooo00<000000?ooo`3oool0
f03oool00`000?l0oooo0?ooo`0]0?ooo`001`3oool010000000oooo0?ooo`0000020?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool0eP3oool30000obl0oooo00070?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool200000=D0oooo0P000?l30?oo
o`030000o`3oool0oooo02`0oooo00000`3oool000000000000200000080oooo0`0000030?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool0dP3oool20000o`D0oooo00<0003o0?oo
o`3oool0;03oool000P0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?oo
o`030000003oool0oooo0=00oooo0P000?l80?ooo`030000o`3oool0oooo02/0oooo00080?ooo`<0
00000`3oool2000000D0oooo00<000000?ooo`3oool0cP3oool20000o`X0oooo00<0003o0?ooo`3o
ool0:`3oool001D0oooo00<000000?ooo`3oool0c03oool20000o``0oooo00<0003o0?ooo`3oool0
:`3oool001D0oooo00<000000?ooo`3oool0b`3oool00`000?l0oooo0?ooo`0=0?ooo`030000o`3o
ool0oooo02X0oooo000E0?ooo`800000c03oool00`000?l0oooo0?ooo`0=0?ooo`030000o`3oool0
oooo02X0oooo000E0?ooo`030000003oool0oooo0<X0oooo00<0003o0?ooo`3oool03P3oool00`00
0?l0oooo0?ooo`0Z0?ooo`005@3oool00`000000oooo0?ooo`3:0?ooo`030000o`3oool0oooo00l0
oooo00<0003o0?ooo`3oool0:@3oool001D0oooo00<000000?ooo`3oool0bP3oool00`000?l0oooo
0?ooo`0?0?ooo`030000o`3oool0oooo02T0oooo000E0?ooo`030000003oool0oooo0<X0oooo00<0
003o0?ooo`3oool0403oool00`000?l0oooo0?ooo`0X0?ooo`005@3oool200000<X0oooo00<0003o
0?ooo`3oool04@3oool00`000?l0oooo0?ooo`0X0?ooo`005@3oool00`000000oooo0?ooo`390?oo
o`030000o`3oool0oooo0140oooo00<0003o0?ooo`3oool0:03oool001D0oooo00<000000?ooo`3o
ool0b@3oool00`000?l0oooo0?ooo`0B0?ooo`030000o`3oool0oooo02L0oooo000E0?ooo`030000
003oool0oooo0<T0oooo00<0003o0?ooo`3oool04P3oool00`000?l0oooo0?ooo`0W0?ooo`005@3o
ool00`000000oooo0?ooo`380?ooo`030000o`3oool0oooo01@0oooo00<0003o0?ooo`3oool09P3o
ool001D0oooo00<000000?ooo`3oool0b03oool00`000?l0oooo0?ooo`0D0?ooo`030000o`3oool0
oooo02H0oooo000E0?ooo`800000b@3oool00`000?l0oooo0?ooo`0D0?ooo`030000o`3oool0oooo
02H0oooo000E0?ooo`030000003oool0oooo0<L0oooo00<0003o0?ooo`3oool05P3oool00`000?l0
oooo0?ooo`0U0?ooo`005@3oool00`000000oooo0?ooo`1Z0?ooo`030000o`3oool0oooo05X0oooo
00<0003o0?ooo`3oool05P3oool00`000?l0oooo0?ooo`0U0?ooo`002@3oool300000080oooo0P00
00050?ooo`030000003oool0oooo06T0oooo00@0003o0?ooo`000?l0003oFP3oool00`000?l0oooo
0?ooo`0G0?ooo`030000o`3oool0oooo02@0oooo000:0?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1X0?ooo`030000o`3oool0oooo0080oooo
00<0003o0?ooo`3oool0E`3oool00`000?l0oooo0?ooo`0G0?ooo`030000o`3oool0oooo02@0oooo
00070?ooo`D0000000D0oooo0000003oool0oooo000000040?ooo`800000J03oool00`000?l0oooo
0?ooo`040?ooo`80003oEP3oool00`000?l0oooo0?ooo`0H0?ooo`030000o`3oool0oooo02@0oooo
00000`3oool000000000000200000080oooo00@000000?ooo`3oool000000P3oool010000000oooo
0?ooo`0000040?ooo`030000003oool0oooo06H0oooo00<0003o0?ooo`3oool01`3oool00`000?l0
oooo0?ooo`1C0?ooo`030000o`3oool0oooo01T0oooo00<0003o0?ooo`3oool08`3oool000P0oooo
00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo06D0
oooo00<0003o0?ooo`3oool02@3oool20000oe<0oooo00<0003o0?ooo`3oool06@3oool00`000?l0
oooo0?ooo`0S0?ooo`002@3oool2000000<0oooo0P0000050?ooo`030000003oool0oooo06<0oooo
0P000?l>0?ooo`030000o`3oool0oooo0500oooo00<0003o0?ooo`3oool06@3oool00`000?l0oooo
0?ooo`0S0?ooo`005@3oool00`000000oooo0?ooo`1R0?ooo`030000o`3oool0oooo00l0oooo0P00
0?m?0?ooo`030000o`3oool0oooo01/0oooo00<0003o0?ooo`3oool08P3oool001D0oooo00<00000
0?ooo`3oool0H@3oool00`000?l0oooo0?ooo`0B0?ooo`030000o`3oool0oooo04`0oooo00<0003o
0?ooo`3oool06`3oool00`000?l0oooo0?ooo`0R0?ooo`005@3oool200000640oooo00<0003o0?oo
o`3oool04`3oool00`000?l0oooo0?ooo`1<0?ooo`030000o`3oool0oooo01`0oooo00<0003o0?oo
o`3oool08@3oool001D0oooo00<000000?ooo`3oool0G`3oool00`000?l0oooo0?ooo`0E0?ooo`03
0000o`3oool0oooo04X0oooo00<0003o0?ooo`3oool07@3oool00`000?l0oooo0?ooo`0Q0?ooo`00
5@3oool00`000000oooo0?ooo`1N0?ooo`030000o`3oool0oooo01H0oooo00<0003o0?ooo`3oool0
BP3oool00`000?l0oooo0?ooo`0M0?ooo`030000o`3oool0oooo0240oooo000E0?ooo`030000003o
ool0oooo05d0oooo00<0003o0?ooo`3oool0603oool00`000?l0oooo0?ooo`190?ooo`030000o`3o
ool0oooo01h0oooo00<0003o0?ooo`3oool0803oool001D0oooo00<000000?ooo`3oool0G03oool0
0`000?l0oooo0?ooo`0I0?ooo`030000o`3oool0oooo04T0oooo00<0003o0?ooo`3oool07P3oool0
0`000?l0oooo0?ooo`0P0?ooo`005@3oool2000005`0oooo00<0003o0?ooo`3oool06`3oool00`00
0?l0oooo0?ooo`170?ooo`030000o`3oool0oooo01l0oooo00<0003o0?ooo`3oool0803oool001D0
oooo00<000000?ooo`3oool0FP3oool00`000?l0oooo0?ooo`0L0?ooo`030000o`3oool0oooo04L0
oooo00<0003o0?ooo`3oool07`3oool00`000?l0oooo0?ooo`0P0?ooo`005@3oool00`000000oooo
0?ooo`1I0?ooo`030000o`3oool0oooo01h0oooo00<0003o0?ooo`3oool0AP3oool00`000?l0oooo
0?ooo`0P0?ooo`030000o`3oool0oooo01l0oooo000E0?ooo`030000003oool0oooo05P0oooo00<0
003o0?ooo`3oool07`3oool00`000?l0oooo0?ooo`160?ooo`030000o`3oool0oooo0200oooo00<0
003o0?ooo`3oool07`3oool001D0oooo00<000000?ooo`3oool0F03oool00`000?l0oooo0?ooo`0P
0?ooo`030000o`3oool0oooo04@0oooo00<0003o0?ooo`3oool08@3oool00`000?l0oooo0?ooo`0O
0?ooo`005@3oool00`000000oooo0?ooo`1G0?ooo`030000o`3oool0oooo0240oooo00<0003o0?oo
o`3oool0A03oool00`000?l0oooo0?ooo`0Q0?ooo`030000o`3oool0oooo01l0oooo000E0?ooo`80
0000E`3oool00`000?l0oooo0?ooo`0S0?ooo`030000o`3oool0oooo04<0oooo00<0003o0?ooo`3o
ool08P3oool00`000?l0oooo0?ooo`0N0?ooo`005@3oool00`000000oooo0?ooo`1E0?ooo`030000
o`3oool0oooo02@0oooo00<0003o0?ooo`3oool0@P3oool00`000?l0oooo0?ooo`0S0?ooo`030000
o`3oool0oooo01h0oooo000E0?ooo`030000003oool0oooo05@0oooo00<0003o0?ooo`3oool09@3o
ool00`000?l0oooo0?ooo`120?ooo`030000o`3oool0oooo02<0oooo00<0003o0?ooo`3oool07P3o
ool000L0oooo100000030?ooo`8000001@3oool00`000000oooo0?ooo`1C0?ooo`030000o`3oool0
oooo02L0oooo00<0003o0?ooo`3oool0@@3oool00`000?l0oooo0?ooo`0S0?ooo`030000o`3oool0
oooo01h0oooo00070?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000103oool0
0`000000oooo0?ooo`1B0?ooo`030000o`3oool0oooo02P0oooo00<0003o0?ooo`3oool0@@3oool0
0`000?l0oooo0?ooo`0T0?ooo`030000o`3oool0oooo01d0oooo00080?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool00000103oool200000580oooo00<0003o0?ooo`3oool0:P3oool0
0`000?l0oooo0?ooo`0o0?ooo`030000o`3oool0oooo02D0oooo00<0003o0?ooo`3oool07@3oool0
00030?ooo`000000000000800000103oool01@000000oooo0?ooo`3oool000000080oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`1@0?ooo`030000o`3oool0oooo02/0oooo00<0003o
0?ooo`3oool0?`3oool00`000?l0oooo0?ooo`0U0?ooo`030000o`3oool0oooo01d0oooo00070?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?oo
o`1@0?ooo`030000o`3oool0oooo02`0oooo00<0003o0?ooo`3oool0?P3oool00`000?l0oooo0?oo
o`0U0?ooo`030000o`3oool0oooo01d0oooo00080?ooo`800000103oool2000000D0oooo00<00000
0?ooo`3oool0C`3oool00`000?l0oooo0?ooo`0]0?ooo`030000o`3oool0oooo03h0oooo00<0003o
0?ooo`3oool09P3oool00`000?l0oooo0?ooo`0L0?ooo`005@3oool00`000000oooo0?ooo`1>0?oo
o`030000o`3oool0oooo02l0oooo00<0003o0?ooo`3oool0?03oool00`000?l0oooo0?ooo`0W0?oo
o`030000o`3oool0oooo01`0oooo000E0?ooo`030000003oool0oooo04d0oooo00<0003o0?ooo`3o
ool0<03oool00`000?l0oooo0?ooo`0l0?ooo`030000o`3oool0oooo02L0oooo00<0003o0?ooo`3o
ool0703oool001D0oooo0P00001=0?ooo`030000o`3oool0oooo0380oooo00<0003o0?ooo`3oool0
>`3oool00`000?l0oooo0?ooo`0W0?ooo`030000o`3oool0oooo01`0oooo000E0?ooo`030000003o
ool0oooo04`0oooo00<0003o0?ooo`3oool0<P3oool00`000?l0oooo0?ooo`0k0?ooo`030000o`3o
ool0oooo02P0oooo00<0003o0?ooo`3oool06`3oool001D0oooo00<000000?ooo`3oool0B`3oool0
0`000?l0oooo0?ooo`0d0?ooo`030000o`3oool0oooo03T0oooo00<0003o0?ooo`3oool0:@3oool0
0`000?l0oooo0?ooo`0K0?ooo`005@3oool00`000000oooo0?ooo`1:0?ooo`030000o`3oool0oooo
03D0oooo00<0003o0?ooo`3oool0203oool30000obh0oooo00<0003o0?ooo`3oool0:@3oool00`00
0?l0oooo0?ooo`0K0?ooo`005@3oool00`000000oooo0?ooo`190?ooo`030000o`3oool0oooo03L0
oooo00@0003o0?ooo`3oool0oooo1P000?l20?ooo`030000o`3oool0oooo02`0oooo00<0003o0?oo
o`3oool0:@3oool00`000?l0oooo0?ooo`0K0?ooo`005@3oool2000003@0oooo0P0000040?ooo`80
0000103oool2000000L0oooo00<0003o0?ooo`3oool0:@3oool5000000X0oooo10000?l80?ooo`03
0000o`3oool0oooo01T0oooo1@0000020?ooo`800000103oool2000000@0oooo00<0003o0?ooo`3o
ool0:P3oool00`000?l0oooo0?ooo`04000001H0oooo000E0?ooo`030000003oool0oooo0380oooo
00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000060?ooo`030000o`3oool0oooo
02/0oooo00<000000?ooo`3oool05P3oool00`000?l0oooo0?ooo`0K0?ooo`030000003oool0oooo
00L0oooo00@000000?ooo`3oool000000`3oool00`000?l0oooo0?ooo`0Z0?ooo`040000o`3oool0
oooo000001T0oooo000E0?ooo`030000003oool0oooo0380oooo00@000000?ooo`3oool000002`3o
ool00`000000oooo0?ooo`030?ooo`030000o`3oool0oooo02`0oooo00<000000?ooo`3oool05`3o
ool00`000?l0oooo0?ooo`0J0?ooo`030000003oool0oooo00X0oooo00@000000?ooo`3oool0003o
;@3oool01@000?l0oooo0?ooo`3oool0000001P0oooo000E0?ooo`030000003oool0oooo0380oooo
00@000000?ooo`3oool000002@3oool2000000D0oooo00<0003o0?ooo`3oool0;@3oool00`000000
oooo0?ooo`0G0?ooo`030000o`3oool0oooo01X0oooo00<000000?ooo`3oool0203oool2000000<0
oooo00<0003o0?ooo`3oool0:`3oool00`000?l0oooo0?ooo`020?ooo`030000003oool0oooo01D0
oooo000E0?ooo`030000003oool0oooo0380oooo00@000000?ooo`3oool000002@3oool00`000000
oooo0?ooo`030?ooo`030000o`3oool0oooo02h0oooo00<000000?ooo`3oool05`3oool00`000?l0
oooo0?ooo`0J0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00P3oool00`000?l0
oooo0?ooo`0/0?ooo`030000o`3oool000000080oooo00<000000?ooo`3oool0503oool001D0oooo
00<000000?ooo`3oool0<`3oool2000000X0oooo0`0000030?ooo`030000o`3oool0oooo02d0oooo
0P00000I0?ooo`030000o`3oool0oooo01T0oooo0P00000:0?ooo`<000000P3oool00`000?l0oooo
0?ooo`0/0?ooo`030000o`3oool0oooo008000005`3oool001D0oooo0P0000150?ooo`030000o`3o
ool0oooo04T0oooo00<0003o0?ooo`3oool0:P3oool00`000?l0oooo0?ooo`0/0?ooo`030000o`3o
ool0oooo01T0oooo000E0?ooo`030000003oool0oooo04<0oooo00<0003o0?ooo`3oool0BP3oool0
0`000?l0oooo0?ooo`0Y0?ooo`030000o`3oool0oooo02d0oooo00<0003o0?ooo`3oool06@3oool0
01D0oooo00<000000?ooo`3oool0@P3oool00`000?l0oooo0?ooo`1<0?ooo`030000o`3oool0oooo
02P0oooo00<0003o0?ooo`3oool0;P3oool00`000?l0oooo0?ooo`0H0?ooo`005@3oool00`000000
oooo0?ooo`120?ooo`030000o`3oool0oooo04`0oooo00<0003o0?ooo`3oool0:03oool00`000?l0
oooo0?ooo`0^0?ooo`030000o`3oool0oooo01P0oooo000E0?ooo`030000003oool0oooo0440oooo
00<0003o0?ooo`3oool0C@3oool00`000?l0oooo0?ooo`0X0?ooo`030000o`3oool0oooo02h0oooo
00<0003o0?ooo`3oool0403oool2000000H0oooo000E0?ooo`030000003oool0oooo0400oooo00<0
003o0?ooo`3oool0CP3oool00`000?l0oooo0?ooo`0X0?ooo`030000o`3oool0oooo02h0oooo00<0
003o0?ooo`3oool03`3oool010000000oooo0?ooo`0000050?ooo`003`3oool6000000030000o`00
000000000400000000<0003o000000000000CP0000000`000?l000000000000W000000030000o`00
000000000300000000<0003o0000000000001P0000080?ooo`030000003oool0oooo00H0oooo000E
0?ooo`03000000000?l0oooo03X0oooo00<000000?ooo`3oool00P3oool00`000?l0oooo0?ooo`0d
0?ooo`030000003oool0oooo01P0oooo00<0003o0?ooo`3oool07`3oool00`000000oooo0?ooo`05
0?ooo`030000o`3oool0oooo0300oooo00<0003o0?ooo`0000003@3oool5000000D0oooo000E0?oo
o`03000000000?l0oooo03h0oooo00<0003o0?ooo`3oool0D@3oool00`000?l0oooo0?ooo`0V0?oo
o`030000o`3oool0oooo0300oooo00<0003o0?ooo`3oool03P3oool00`000000oooo0?ooo`060?oo
o`005@3oool00`000000oooo0000o`0n0?ooo`030000o`3oool0oooo0540oooo00<0003o0?ooo`3o
ool09P3oool00`000?l0oooo0?ooo`0`0?ooo`030000o`3oool0oooo01L0oooo000E0?ooo`030000
003oool0003o03d0oooo00<0003o0?ooo`3oool0DP3oool00`000?l0oooo0?ooo`0V0?ooo`030000
o`3oool0oooo0340oooo00<0003o0?ooo`3oool05P3oool001D0oooo0P0000000`3oool0003o0?oo
o`0[0?ooo`<0003o303oool00`000?l0oooo0?ooo`1C0?ooo`030000o`3oool0oooo02D0oooo00<0
003o0?ooo`3oool0<P3oool00`000?l0oooo0?ooo`0F0?ooo`005@3oool010000000oooo0?ooo`00
0?l[0?ooo`040000o`3oool0oooo0?ooo`@0003o1`3oool00`000?l0oooo0?ooo`1D0?ooo`030000
o`3oool0oooo02D0oooo00<0003o0?ooo`3oool0<P3oool00`000?l0oooo0?ooo`0F0?ooo`005@3o
ool01@000000oooo0?ooo`3oool0003o02T0oooo00<0003o0?ooo`3oool01P3oool40000o`<0oooo
00<0003o0?ooo`3oool0E03oool00`000?l0oooo0?ooo`0U0?ooo`030000o`3oool0oooo0380oooo
00<0003o0?ooo`3oool05P3oool001D0oooo00<000000?ooo`3oool00P3oool00`000?l0oooo0?oo
o`0V0?ooo`030000o`3oool0oooo00X0oooo0`000?mG0?ooo`030000o`3oool0oooo02D0oooo00<0
003o0?ooo`3oool0<`3oool00`000?l0oooo0?ooo`0E0?ooo`005@3oool00`000000oooo0?ooo`02
0?ooo`030000o`3oool0oooo02D0oooo00<0003o0?ooo`3oool0IP3oool00`000?l0oooo0?ooo`0T
0?ooo`030000o`3oool0oooo03<0oooo00<0003o0?ooo`3oool05@3oool001D0oooo00<000000?oo
o`3oool00`3oool00`000?l0oooo0?ooo`0S0?ooo`030000o`3oool0oooo06L0oooo00<0003o0?oo
o`3oool08`3oool00`000?l0oooo0?ooo`1<0?ooo`005@3oool2000000@0oooo00<0003o0?ooo`3o
ool08P3oool00`000?l0oooo0?ooo`1X0?ooo`030000o`3oool0oooo02<0oooo00<0003o0?ooo`3o
ool0C03oool001D0oooo00<000000?ooo`3oool0103oool00`000?l0oooo0?ooo`0P0?ooo`030000
o`3oool0oooo06T0oooo00<0003o0?ooo`3oool08`3oool00`000?l0oooo0?ooo`1<0?ooo`005@3o
ool00`000000oooo0?ooo`040?ooo`030000o`3oool0oooo0200oooo00<0003o0?ooo`3oool0J@3o
ool00`000?l0oooo0?ooo`0S0?ooo`030000o`3oool0oooo04`0oooo000E0?ooo`030000003oool0
oooo00D0oooo00<0003o0?ooo`3oool07P3oool00`000?l0oooo0?ooo`1Z0?ooo`030000o`3oool0
oooo02<0oooo00<0003o0?ooo`3oool0C03oool001D0oooo00<000000?ooo`3oool01P3oool00`00
0?l0oooo0?ooo`0L0?ooo`030000o`3oool0oooo06`0oooo00<0003o0?ooo`3oool08@3oool00`00
0?l0oooo0?ooo`1=0?ooo`005@3oool2000000L0oooo00<0003o0?ooo`3oool06`3oool00`000?l0
oooo0?ooo`1]0?ooo`030000o`3oool0oooo0240oooo00<0003o0?ooo`3oool0C@3oool001D0oooo
00<000000?ooo`3oool01`3oool00`000?l0oooo0?ooo`0I0?ooo`030000o`3oool0oooo06h0oooo
00<0003o0?ooo`3oool08@3oool00`000?l0oooo0?ooo`1=0?ooo`005@3oool00`000000oooo0?oo
o`070?ooo`030000o`3oool0oooo01T0oooo00<0003o0?ooo`3oool0KP3oool00`000?l0oooo0?oo
o`0Q0?ooo`030000o`3oool0oooo04d0oooo000E0?ooo`030000003oool0oooo00P0oooo00<0003o
0?ooo`3oool05`3oool00`000?l0oooo0?ooo`1_0?ooo`030000o`3oool0oooo0240oooo00<0003o
0?ooo`3oool0C@3oool000L0oooo100000030?ooo`8000001@3oool00`000000oooo0?ooo`080?oo
o`030000o`3oool0oooo01H0oooo00<0003o0?ooo`3oool0L03oool00`000?l0oooo0?ooo`0P0?oo
o`030000o`3oool0oooo04h0oooo00070?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3o
ool00000103oool00`000000oooo0?ooo`090?ooo`030000o`3oool0oooo01<0oooo0P000?md0?oo
o`030000o`3oool0oooo01l0oooo00<0003o0?ooo`3oool0CP3oool000P0oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000040?ooo`8000002`3oool20000oa80oooo00<0003o0?oo
o`3oool0M03oool00`000?l0oooo0?ooo`0O0?ooo`030000o`3oool0oooo04h0oooo00090?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00`0oooo0P000?l>0?ooo`80003oM`3oool00`000?l0oooo0?ooo`0O0?ooo`030000o`3oool0oooo
04h0oooo00070?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool0
0`000000oooo0?ooo`0>0?ooo`030000o`3oool0oooo00X0oooo00<0003o0?ooo`3oool0M`3oool0
0`000?l0oooo0?ooo`0O0?ooo`030000o`3oool0oooo04h0oooo00080?ooo`800000103oool20000
00D0oooo00<000000?ooo`3oool03`3oool20000o`P0oooo0P000?mj0?ooo`030000o`3oool0oooo
01h0oooo00<0003o0?ooo`3oool0C`3oool001D0oooo00<000000?ooo`3oool04@3oool20000o`D0
oooo00<0003o0?ooo`3oool0NP3oool00`000?l0oooo0?ooo`0N0?ooo`030000o`3oool0oooo04l0
oooo000E0?ooo`800000503oool20000o`030?ooo`000?l0003o07d0oooo00<0003o0?ooo`3oool0
7P3oool00`000?l0oooo0?ooo`1?0?ooo`005@3oool00`000000oooo0?ooo`0E0?ooo`030000o`3o
ool0oooo07h0oooo00<0003o0?ooo`3oool07@3oool00`000?l0oooo0?ooo`1?0?ooo`005@3oool0
0`000000oooo0?ooo`2F0?ooo`030000o`3oool0oooo01d0oooo00<0003o0?ooo`3oool0C`3oool0
01D0oooo00<000000?ooo`3oool0UP3oool00`000?l0oooo0?ooo`0L0?ooo`030000o`3oool0oooo
0500oooo000E0?ooo`030000003oool0oooo09H0oooo00<0003o0?ooo`3oool0703oool00`000?l0
oooo0?ooo`1@0?ooo`005@3oool00`000000oooo0?ooo`2F0?ooo`030000o`3oool0oooo01`0oooo
00<0003o0?ooo`3oool0D03oool001D0oooo0P00002G0?ooo`030000o`3oool0oooo01`0oooo00<0
003o0?ooo`3oool0D03oool001D0oooo00<000000?ooo`3oool0U`3oool00`000?l0oooo0?ooo`0K
0?ooo`030000o`3oool0oooo0500oooo000E0?ooo`030000003oool0oooo09L0oooo00<0003o0?oo
o`3oool06P3oool00`000?l0oooo0?ooo`1A0?ooo`005@3oool00`000000oooo0?ooo`2G0?ooo`03
0000o`3oool0oooo01X0oooo00<0003o0?ooo`3oool0D@3oool001D0oooo00<000000?ooo`3oool0
U`3oool00`000?l0oooo0?ooo`0J0?ooo`030000o`3oool0oooo0540oooo000E0?ooo`800000V03o
ool00`000?l0oooo0?ooo`0J0?ooo`030000o`3oool0oooo0540oooo000E0?ooo`030000003oool0
oooo09L0oooo00<0003o0?ooo`3oool06P3oool00`000?l0oooo0?ooo`1A0?ooo`005@3oool00`00
0000oooo0?ooo`2H0?ooo`030000o`3oool0oooo01P0oooo00<0003o0?ooo`3oool0DP3oool001D0
oooo00<000000?ooo`3oool0V03oool00`000?l0oooo0?ooo`0H0?ooo`030000o`3oool0oooo0580
oooo00090?ooo`<000000P3oool2000000D0oooo00<000000?ooo`3oool0V03oool00`000?l0oooo
0?ooo`0H0?ooo`030000o`3oool0oooo0580oooo000:0?ooo`040000003oool0oooo00000080oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`2H0?ooo`030000o`3oool0oooo01P0oooo
00<0003o0?ooo`3oool0DP3oool000L0oooo1@0000001@3oool000000?ooo`3oool0000000@0oooo
0P00002I0?ooo`030000o`3oool0oooo01L0oooo00<0003o0?ooo`3oool0D`3oool000L0oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo09P0
oooo00<0003o0?ooo`3oool05`3oool00`000?l0oooo0?ooo`1C0?ooo`00203oool00`000000oooo
000000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0V03oool00`000?l0
oooo0?ooo`0G0?ooo`030000o`3oool0oooo05<0oooo00090?ooo`8000000`3oool2000000D0oooo
00<000000?ooo`3oool0V@3oool00`000?l0oooo0?ooo`0E0?ooo`030000o`3oool0oooo05@0oooo
000E0?ooo`030000003oool0oooo09T0oooo00<0003o0?ooo`3oool05@3oool00`000?l0oooo0?oo
o`1D0?ooo`005@3oool2000009X0oooo00<0003o0?ooo`3oool05@3oool00`000?l0oooo0?ooo`1D
0?ooo`005@3oool00`000000oooo0?ooo`2I0?ooo`030000o`3oool0oooo01D0oooo00<0003o0?oo
o`3oool0E03oool001D0oooo00<000000?ooo`3oool0V@3oool00`000?l0oooo0?ooo`0D0?ooo`03
0000o`3oool0oooo05D0oooo000E0?ooo`030000003oool0oooo09T0oooo00<0003o0?ooo`3oool0
503oool00`000?l0oooo0?ooo`1E0?ooo`005@3oool00`000000oooo0?ooo`2J0?ooo`030000o`3o
ool0oooo01<0oooo00<0003o0?ooo`3oool0E@3oool001D0oooo00<000000?ooo`3oool0VP3oool0
0`000?l0oooo0?ooo`0B0?ooo`030000o`3oool0oooo05H0oooo000E0?ooo`800000V`3oool00`00
0?l0oooo0?ooo`0B0?ooo`030000o`3oool0oooo05H0oooo000E0?ooo`030000003oool0oooo09X0
oooo00<0003o0?ooo`3oool04P3oool00`000?l0oooo0?ooo`1F0?ooo`005@3oool00`000000oooo
0?ooo`2J0?ooo`030000o`3oool0oooo0140oooo00<0003o0?ooo`3oool0E`3oool001D0oooo00<0
00000?ooo`3oool0VP3oool00`000?l0oooo0?ooo`0A0?ooo`030000o`3oool0oooo05L0oooo000E
0?ooo`030000003oool0oooo09/0oooo00<0003o0?ooo`3oool0403oool00`000?l0oooo0?ooo`1G
0?ooo`005@3oool2000009`0oooo00<0003o0?ooo`3oool03`3oool00`000?l0oooo0?ooo`1H0?oo
o`005@3oool00`000000oooo0?ooo`2K0?ooo`030000o`3oool0oooo00l0oooo00<0003o0?ooo`3o
ool0F03oool001D0oooo00<000000?ooo`3oool0V`3oool00`000?l0oooo0?ooo`0?0?ooo`030000
o`3oool0oooo05P0oooo000E0?ooo`030000003oool0oooo09`0oooo00<0003o0?ooo`3oool03P3o
ool00`000?l0oooo0?ooo`1H0?ooo`001`3oool3000000@0oooo0P0000050?ooo`030000003oool0
oooo09`0oooo00<0003o0?ooo`3oool03@3oool00`000?l0oooo0?ooo`1I0?ooo`001`3oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0W@3o
ool00`000?l0oooo0?ooo`0<0?ooo`030000o`3oool0oooo05T0oooo00070?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool00000103oool2000009l0oooo00<0003o0?ooo`3oool0
2`3oool00`000?l0oooo0?ooo`1I0?ooo`001`3oool3000000<0oooo00@000000?ooo`3oool00000
103oool00`000000oooo0?ooo`2N0?ooo`030000o`3oool0oooo00X0oooo00<0003o0?ooo`3oool0
FP3oool000P0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`030000
003oool0oooo09l0oooo00<0003o0?ooo`3oool02@3oool00`000?l0oooo0?ooo`1J0?ooo`00203o
ool3000000<0oooo0P0000050?ooo`030000003oool0oooo09l0oooo00<0003o0?ooo`3oool02@3o
ool00`000?l0oooo0?ooo`1J0?ooo`005@3oool00`000000oooo0?ooo`2P0?ooo`030000o`3oool0
oooo00L0oooo00<0003o0?ooo`3oool0F`3oool001D0oooo0P00002R0?ooo`030000o`3oool0oooo
00H0oooo00<0003o0?ooo`3oool0F`3oool001D0oooo00<000000?ooo`3oool0X@3oool00`000?l0
oooo0?ooo`060?ooo`030000o`3oool0oooo05/0oooo000E0?ooo`030000003oool0oooo0:80oooo
00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`1L0?ooo`005@3oool00`000000oooo0?oo
o`2S0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool0G03oool001D0oooo00<00000
0?ooo`3oool0X`3oool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0oooo05`0oooo000E0?oo
o`030000003oool0oooo0:@0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0?ooo`1L0?oo
o`005@3oool200000:D0oooo00D0003o0?ooo`3oool0oooo0000o`1O0?ooo`005@3oool00`000000
oooo0?ooo`2U0?ooo`040000o`3oool0oooo0000oel0oooo000E0?ooo`030000003oool0oooo0:H0
oooo00<0003o0?ooo`000?l0G`3oool001D0oooo00<000000?ooo`3oool0YP3oool20000of00oooo
000E0?ooo`030000003oool0oooo0:L0oooo00<0003o0?ooo`3oool0GP3oool001D0oooo00<00000
0?ooo`3oool0o`3oool90?ooo`005@3oool200000?l0oooo2P3oool001D0oooo00<000000?ooo`3o
ool0o`3oool90?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`T0oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o
0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo000C0?ooo`D00000o`3o
ool90?ooo`004`3oool400000?l0oooo2P3oool001H0oooo00<000000?ooo`3oool0o`3oool80?oo
o`00503oool300000?l0oooo2P3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool0
0?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.175927, -65.0288, \
0.00823087, 0.903709}}],

Cell[BoxData[
    InterpretationBox[\("t"\[InvisibleSpace]"      "\[InvisibleSpace]"   u"\
\[InvisibleSpace]"          v"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]" \
        a"\),
      SequenceForm[ "t", "      ", "   u", "          v", "", "         a"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("------------------------------------"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        InterpretationBox[GridBox[{
              {"0"},
              {"0.1`"},
              {"0.2`"},
              {"0.30000000000000004`"},
              {"0.4`"},
              {"0.5`"},
              {"0.6000000000000001`"},
              {"0.7000000000000001`"},
              {"0.8`"},
              {"0.9`"},
              {"1.`"},
              {"1.1`"},
              {"1.2000000000000002`"},
              {"1.3`"},
              {"1.4000000000000001`"},
              {"1.5`"},
              {"1.6`"},
              {"1.7000000000000002`"},
              {"1.8`"},
              {"1.9000000000000001`"},
              {"2.`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0, 1.1000000000000001, 
            1.2000000000000002, 1.3, 1.4000000000000001, 1.5, 
            1.6000000000000001, 1.7000000000000002, 1.8, 1.9000000000000001, 
            2.0}]], "\[InvisibleSpace]", "\<\"     \"\>", "\[InvisibleSpace]",
         
        InterpretationBox[GridBox[{
              {"0"},
              {"0.03161730415056159`"},
              {"0.23257398333758056`"},
              {"0.6668370106940812`"},
              {"1.273043881174821`"},
              {"1.9549365189039194`"},
              {"2.6820501209465464`"},
              {"3.3339332183105856`"},
              {"3.7762483522172`"},
              {"3.8918824268755743`"},
              {"3.606250256772874`"},
              {"2.9956749058140515`"},
              {"2.2394337595741947`"},
              {"1.482332192840744`"},
              {"1.2078876795060158`"},
              {"1.6296671734601467`"},
              {"2.4916061837453736`"},
              {"3.216291025337241`"},
              {"3.4377638962250887`"},
              {"3.0981295489562917`"},
              {"2.442045505044069`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .03161730415056159, .23257398333758056, .66683701069408119, 
            1.273043881174821, 1.9549365189039194, 2.6820501209465464, 
            3.3339332183105856, 3.7762483522172001, 3.8918824268755743, 
            3.6062502567728738, 2.9956749058140515, 2.2394337595741947, 
            1.482332192840744, 1.2078876795060158, 1.6296671734601467, 
            2.4916061837453736, 3.2162910253372412, 3.4377638962250887, 
            3.0981295489562917, 2.442045505044069}]], 
        "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"0.9485191245168477`"},
              {"3.183143002060026`"},
              {"5.375500063548635`"},
              {"6.528953678862647`"},
              {"7.151660656705305`"},
              {"7.1345908874678985`"},
              {"5.679876775623086`"},
              {"2.9718489481593675`"},
              {\(-0.8287963113109009`\)},
              {\(-4.756606566245549`\)},
              {\(-7.030995040484249`\)},
              {\(-8.123908187777833`\)},
              {\(-5.873653597603649`\)},
              {"0.6721401761470633`"},
              {"7.605146068395873`"},
              {"8.721074865033561`"},
              {"5.109270027782722`"},
              {\(-0.7734236017729947`\)},
              {\(-5.560419912119235`\)},
              {\(-6.856448485180653`\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, .94851912451684772, 3.1831430020600262, 
            5.3755000635486354, 6.5289536788626474, 7.1516606567053049, 
            7.1345908874678985, 5.6798767756230859, 
            2.9718489481593675, -.82879631131090092, -4.7566065662455488, \
-7.0309950404842487, -8.1239081877778325, -5.8736535976036492, \
.67214017614706334, 7.6051460683958734, 8.721074865033561, 
            5.1092700277827223, -.77342360177299474, -5.5604199121192348, \
-6.8564484851806533}]], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"18.970382490336956`"},
              {"25.722095060526616`"},
              {"18.125046169245536`"},
              {"4.944222348847065`"},
              {"7.509917208006041`"},
              {\(-7.851312592754107`\)},
              {\(-21.2429696441421`\)},
              {\(-32.91758690513218`\)},
              {\(-43.09531828427328`\)},
              {\(-35.46104711578644`\)},
              {\(-10.02672236898755`\)},
              {\(-11.831540576884127`\)},
              {"56.836632380367796`"},
              {"74.07916795867852`"},
              {"38.53606613463007`"},
              {\(-16.21749020187632`\)},
              {\(-56.01860654314049`\)},
              {\(-61.635266047973744`\)},
              {\(-34.10466015895118`\)},
              {"8.184088697722713`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 18.970382490336956, 25.722095060526616, 
            18.125046169245536, 4.9442223488470649, 
            7.5099172080060406, -7.8513125927541072, -21.2429696441421, \
-32.917586905132183, -43.095318284273283, -35.461047115786442, \
-10.026722368987549, -11.831540576884127, 56.836632380367796, 
            74.079167958678525, 
            
            38.536066134630069, -16.21749020187632, -56.018606543140493, \
-61.635266047973744, -34.104660158951177, 8.1840886977227125}]]}],
      SequenceForm[ 
        TableForm[ {
          0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0, 1.1000000000000001, 
          1.2000000000000002, 1.3, 1.4000000000000001, 1.5, 
          1.6000000000000001, 1.7000000000000002, 1.8, 1.9000000000000001, 
          2.0}], "     ", 
        TableForm[ {
          0, .03161730415056159, .23257398333758056, .66683701069408119, 
          1.273043881174821, 1.9549365189039194, 2.6820501209465464, 
          3.3339332183105856, 3.7762483522172001, 3.8918824268755743, 
          3.6062502567728738, 2.9956749058140515, 2.2394337595741947, 
          1.482332192840744, 1.2078876795060158, 1.6296671734601467, 
          2.4916061837453736, 3.2162910253372412, 3.4377638962250887, 
          3.0981295489562917, 2.442045505044069}], "   ", 
        TableForm[ {0, .94851912451684772, 3.1831430020600262, 
          5.3755000635486354, 6.5289536788626474, 7.1516606567053049, 
          7.1345908874678985, 5.6798767756230859, 
          2.9718489481593675, -.82879631131090092, -4.7566065662455488, \
-7.0309950404842487, -8.1239081877778325, -5.8736535976036492, \
.67214017614706334, 7.6051460683958734, 8.721074865033561, 
          5.1092700277827223, -.77342360177299474, -5.5604199121192348, \
-6.8564484851806533}], "  ", 
        TableForm[ {0, 18.970382490336956, 25.722095060526616, 
          18.125046169245536, 4.9442223488470649, 
          7.5099172080060406, -7.8513125927541072, -21.2429696441421, \
-32.917586905132183, -43.095318284273283, -35.461047115786442, \
-10.026722368987549, -11.831540576884127, 56.836632380367796, 
          74.079167958678525, 
          38.536066134630069, -16.21749020187632, -56.018606543140493, \
-61.635266047973744, -34.104660158951177, 8.1840886977227125}]],
      Editable->False]], "Print"]
}, Open  ]],

Cell["\<\
Veamos ahora el mismo caso anterior, pero en el supuesto de que el material \
sea totalmente el\[AAcute]stico. Para ello damos unos valores muy altos de fc \
y ft.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["\<\
NewmarkNoLineal[0,2,.1,0,0,12.35,.2,.274,p,   
        .5,1/6,-15000000,150000000,posicion,velocidad,aceleracion]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.151837 0.20836 [
[.2619 .13934 -9 -9 ]
[.2619 .13934 9 0 ]
[.5 .13934 -3 -9 ]
[.5 .13934 3 0 ]
[.7381 .13934 -9 -9 ]
[.7381 .13934 9 0 ]
[.97619 .13934 -3 -9 ]
[.97619 .13934 3 0 ]
[1.025 .15184 0 -6.4375 ]
[1.025 .15184 10 6.4375 ]
[.01131 .04766 -24 -4.5 ]
[.01131 .04766 0 4.5 ]
[.01131 .25602 -18 -4.5 ]
[.01131 .25602 0 4.5 ]
[.01131 .3602 -6 -4.5 ]
[.01131 .3602 0 4.5 ]
[.01131 .46438 -18 -4.5 ]
[.01131 .46438 0 4.5 ]
[.01131 .56856 -6 -4.5 ]
[.01131 .56856 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .15184 m
.2619 .15809 L
s
[(0.5)] .2619 .13934 0 1 Mshowa
.5 .15184 m
.5 .15809 L
s
[(1)] .5 .13934 0 1 Mshowa
.7381 .15184 m
.7381 .15809 L
s
[(1.5)] .7381 .13934 0 1 Mshowa
.97619 .15184 m
.97619 .15809 L
s
[(2)] .97619 .13934 0 1 Mshowa
.125 Mabswid
.07143 .15184 m
.07143 .15559 L
s
.11905 .15184 m
.11905 .15559 L
s
.16667 .15184 m
.16667 .15559 L
s
.21429 .15184 m
.21429 .15559 L
s
.30952 .15184 m
.30952 .15559 L
s
.35714 .15184 m
.35714 .15559 L
s
.40476 .15184 m
.40476 .15559 L
s
.45238 .15184 m
.45238 .15559 L
s
.54762 .15184 m
.54762 .15559 L
s
.59524 .15184 m
.59524 .15559 L
s
.64286 .15184 m
.64286 .15559 L
s
.69048 .15184 m
.69048 .15559 L
s
.78571 .15184 m
.78571 .15559 L
s
.83333 .15184 m
.83333 .15559 L
s
.88095 .15184 m
.88095 .15559 L
s
.92857 .15184 m
.92857 .15559 L
s
.25 Mabswid
0 .15184 m
1 .15184 L
s
gsave
1.025 .15184 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .04766 m
.03006 .04766 L
s
[(-0.5)] .01131 .04766 1 0 Mshowa
.02381 .25602 m
.03006 .25602 L
s
[(0.5)] .01131 .25602 1 0 Mshowa
.02381 .3602 m
.03006 .3602 L
s
[(1)] .01131 .3602 1 0 Mshowa
.02381 .46438 m
.03006 .46438 L
s
[(1.5)] .01131 .46438 1 0 Mshowa
.02381 .56856 m
.03006 .56856 L
s
[(2)] .01131 .56856 1 0 Mshowa
.125 Mabswid
.02381 .06849 m
.02756 .06849 L
s
.02381 .08933 m
.02756 .08933 L
s
.02381 .11016 m
.02756 .11016 L
s
.02381 .131 m
.02756 .131 L
s
.02381 .17267 m
.02756 .17267 L
s
.02381 .19351 m
.02756 .19351 L
s
.02381 .21434 m
.02756 .21434 L
s
.02381 .23518 m
.02756 .23518 L
s
.02381 .27685 m
.02756 .27685 L
s
.02381 .29769 m
.02756 .29769 L
s
.02381 .31852 m
.02756 .31852 L
s
.02381 .33936 m
.02756 .33936 L
s
.02381 .38103 m
.02756 .38103 L
s
.02381 .40187 m
.02756 .40187 L
s
.02381 .4227 m
.02756 .4227 L
s
.02381 .44354 m
.02756 .44354 L
s
.02381 .48521 m
.02756 .48521 L
s
.02381 .50605 m
.02756 .50605 L
s
.02381 .52688 m
.02756 .52688 L
s
.02381 .54772 m
.02756 .54772 L
s
.02381 .02682 m
.02756 .02682 L
s
.02381 .00598 m
.02756 .00598 L
s
.02381 .58939 m
.02756 .58939 L
s
.02381 .61023 m
.02756 .61023 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .15184 m
.07143 .15842 L
.11905 .2003 L
.16667 .29078 L
.21429 .41602 L
.2619 .53988 L
.30952 .60332 L
.35714 .55817 L
.40476 .41356 L
.45238 .23 L
.5 .08143 L
.54762 .01472 L
.59524 .01783 L
.64286 .02451 L
.69048 .05307 L
.7381 .12294 L
.78571 .19987 L
.83333 .24248 L
.88095 .23233 L
.92857 .18093 L
.97619 .12021 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.563},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oo`3oool[
0?ooo`00o`3oool[0?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`d0oooo000K0?ooo`800000
o`3oool>0?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`d0oooo000K0?ooo`030000003oool0
oooo08D0oooo1P3o00210?ooo`006`3oool00`000000oooo0?ooo`240?ooo`030?l0003oool0oooo
00@0oooo2P3o001g0?ooo`006`3oool00`000000oooo0?ooo`240?ooo`030?l0003oool0oooo00h0
oooo1P3o001a0?ooo`006`3oool00`000000oooo0?ooo`230?ooo`030?l0003oool0oooo01D0oooo
103o001]0?ooo`006`3oool2000008<0oooo00<0o`000?ooo`3oool06P3oool20?l006/0oooo000K
0?ooo`030000003oool0oooo0880oooo00<0o`000?ooo`3oool0703oool20?l006T0oooo000K0?oo
o`030000003oool0oooo0840oooo00<0o`000?ooo`3oool07`3oool00`3o0000oooo0?ooo`1V0?oo
o`00203oool2000000@0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`200?ooo`03
0?l0003oool0oooo0240oooo0P3o001V0?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool0P03oool00`3o0000oooo0?ooo`0S0?oo
o`80o`00I03oool000L0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`020?oo
o`800000P03oool00`3o0000oooo0?ooo`0V0?ooo`80o`00HP3oool000030?ooo`00000000000080
00000P3oool010000000oooo0?ooo`0000090?ooo`8000001@3oool00`000000oooo0?ooo`1n0?oo
o`030?l0003oool0oooo02T0oooo00<0o`000?ooo`3oool0G`3oool000L0oooo00@000000?ooo`3o
ool000002@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo07h0oooo00<0o`000?oo
o`3oool0:P3oool00`3o0000oooo0?ooo`1N0?ooo`00203oool2000000X0oooo0`0000040?ooo`03
0000003oool0oooo07d0oooo00<0o`000?ooo`3oool0:`3oool00`3o0000oooo0?ooo`1N0?ooo`00
6`3oool00`000000oooo0?ooo`1l0?ooo`030?l0003oool0oooo02d0oooo00<0o`000?ooo`3oool0
G@3oool001/0oooo0P00001m0?ooo`030?l0003oool0oooo02h0oooo00<0o`000?ooo`3oool0G03o
ool001/0oooo00<000000?ooo`3oool0N`3oool00`3o0000oooo0?ooo`0_0?ooo`030?l0003oool0
oooo05`0oooo000K0?ooo`030000003oool0oooo07X0oooo00<0o`000?ooo`3oool0<@3oool00`3o
0000oooo0?ooo`1K0?ooo`006`3oool00`000000oooo0?ooo`1j0?ooo`030?l0003oool0oooo0380
oooo00<0o`000?ooo`3oool0FP3oool001/0oooo00<000000?ooo`3oool0N@3oool00`3o0000oooo
0?ooo`0c0?ooo`030?l0003oool0oooo05X0oooo000K0?ooo`030000003oool0oooo07T0oooo00<0
o`000?ooo`3oool0=03oool00`3o0000oooo0?ooo`1I0?ooo`006`3oool2000007T0oooo00<0o`00
0?ooo`3oool0=P3oool00`3o0000oooo0?ooo`1H0?ooo`006`3oool00`000000oooo0?ooo`1h0?oo
o`030?l0003oool0oooo03L0oooo00<0o`000?ooo`3oool0E`3oool001/0oooo00<000000?ooo`3o
ool0N03oool00`3o0000oooo0?ooo`0g0?ooo`030?l0003oool0oooo05L0oooo000K0?ooo`030000
003oool0oooo07L0oooo00<0o`000?ooo`3oool0>@3oool00`3o0000oooo0?ooo`1F0?ooo`006`3o
ool00`000000oooo0?ooo`1g0?ooo`030?l0003oool0oooo03X0oooo00<0o`000?ooo`3oool0E@3o
ool001/0oooo0P00000e0?ooo`800000103oool2000000@0oooo0P00000e0?ooo`030?l000000000
000000800000<`3oool5000000040?l0003oool00000000000@0oooo0P00000d0?ooo`@000005P3o
ool001/0oooo00<000000?ooo`3oool0<`3oool010000000oooo0?ooo`0000080?ooo`040000003o
ool0oooo000003<0oooo00@0o`000?ooo`3oool00000=`3oool01@000000oooo0?ooo`3oool0o`00
00D0oooo00@000000?ooo`3oool00000<`3oool00`000000oooo0?ooo`0G0?ooo`006`3oool00`00
0000oooo0?ooo`0c0?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3oool0<@3oool0
103o0000oooo0?ooo`00000g0?ooo`030000003oool0oooo0080oooo00<0o`000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01H0oooo000K0?ooo`030000003oool0
oooo03<0oooo00@000000?ooo`3oool000002@3oool2000003@0oooo00@0o`000?ooo`3oool00000
=`3oool00`000000oooo0?ooo`020?ooo`030?l0003oool0oooo00<0oooo0P00000f0?ooo`030?l0
003oool0oooo01D0oooo000K0?ooo`030000003oool0oooo03<0oooo00@000000?ooo`3oool00000
2@3oool00`000000oooo0?ooo`0b0?ooo`050?l0003oool0oooo0?ooo`000000=`3oool00`000000
oooo0?ooo`030?ooo`030?l0003oool0oooo0080oooo00<000000?ooo`3oool0<`3oool010000000
o`000?ooo`00000F0?ooo`006`3oool00`000000oooo0?ooo`0d0?ooo`8000002P3oool300000380
oooo00<0o`000?ooo`3oool00P00000f0?ooo`8000001P3oool0103o0000oooo0?ooo`3oool30000
03<0oooo00<0o`000000000000005`3oool001/0oooo0P00001f0?ooo`030?l0003oool0oooo0400
oooo00<0o`000?ooo`3oool0=`3oool00`3o0000oooo0?ooo`0G0?ooo`006`3oool00`000000oooo
0?ooo`1d0?ooo`030?l0003oool0oooo0480oooo00<0o`000?ooo`3oool0=@3oool00`3o0000oooo
0?ooo`0H0?ooo`006`3oool00`000000oooo0?ooo`1d0?ooo`030?l0003oool0oooo0480oooo00<0
o`000?ooo`3oool0=03oool00`3o0000oooo0?ooo`0I0?ooo`006`3oool00`000000oooo0?ooo`1d
0?ooo`030?l0003oool0oooo04<0oooo00<0o`000?ooo`3oool0<P3oool00`3o0000oooo0?ooo`0J
0?ooo`006`3oool00`000000oooo0?ooo`1c0?ooo`030?l0003oool0oooo04D0oooo00<0o`000?oo
o`3oool0<@3oool00`3o0000oooo0?ooo`0C0?ooo`8000001@3oool001D0oooo1P0000030?l007<0
000000<0o`00000000000000A@0000000`3o000000000000000`000000030?l000000000000000/0
0000203oool010000000oooo0?ooo`0000040?ooo`006`3oool00`000000oooo0?ooo`060?l000<0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0
oooo00<0o`000?ooo`3oool0103oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool00P3oool00`3o0000oooo0?ooo`040?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0080
oooo00<0o`000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00D0
oooo000K0?ooo`030000003oool0oooo00H0oooo103o000a0?ooo`030000003oool0oooo03@0oooo
00<0o`000?ooo`3oool0103oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo0080oooo
00<0o`000?ooo`3oool0;@3oool00`3o0000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo
1@0000040?ooo`006`3oool00`000000oooo0?ooo`0:0?ooo`030?l0003oool0oooo06D0oooo00<0
o`000?ooo`3oool0B03oool00`3o0000oooo0?ooo`0/0?ooo`030?l0003oool0oooo01D0oooo00<0
00000?ooo`3oool01@3oool001/0oooo00<000000?ooo`3oool02`3oool00`3o0000oooo0?ooo`1S
0?ooo`030?l0003oool0oooo04X0oooo00<0o`000?ooo`3oool0:P3oool00`3o0000oooo0?ooo`0N
0?ooo`006`3oool00`000000oooo0?ooo`0<0?ooo`80o`00H`3oool00`3o0000oooo0?ooo`1:0?oo
o`030?l0003oool0oooo02T0oooo00<0o`000?ooo`3oool07`3oool001/0oooo0P00000?0?ooo`03
0?l0003oool0oooo0600oooo00<0o`000?ooo`3oool0B`3oool00`3o0000oooo0?ooo`0W0?ooo`03
0?l0003oool0oooo0200oooo000K0?ooo`030000003oool0oooo00l0oooo00<0o`000?ooo`3oool0
GP3oool00`3o0000oooo0?ooo`1<0?ooo`030?l0003oool0oooo02L0oooo00<0o`000?ooo`3oool0
803oool001/0oooo00<000000?ooo`3oool0403oool00`3o0000oooo0?ooo`1M0?ooo`030?l0003o
ool0oooo04d0oooo00<0o`000?ooo`3oool09@3oool00`3o0000oooo0?ooo`0Q0?ooo`006`3oool0
0`000000oooo0?ooo`0A0?ooo`030?l0003oool0oooo05`0oooo00<0o`000?ooo`3oool0CP3oool0
0`3o0000oooo0?ooo`0S0?ooo`030?l0003oool0oooo0280oooo000K0?ooo`030000003oool0oooo
0180oooo0P3o001K0?ooo`030?l0003oool0oooo04l0oooo00<0o`000?ooo`3oool08P3oool00`3o
0000oooo0?ooo`0S0?ooo`006`3oool2000001D0oooo00<0o`000?ooo`3oool0F03oool00`3o0000
oooo0?ooo`1@0?ooo`030?l0003oool0oooo0200oooo00<0o`000?ooo`3oool0903oool001/0oooo
00<000000?ooo`3oool05@3oool00`3o0000oooo0?ooo`1G0?ooo`030?l0003oool0oooo0500oooo
00<0o`000?ooo`3oool07`3oool00`3o0000oooo0?ooo`0U0?ooo`006`3oool00`000000oooo0?oo
o`0F0?ooo`030?l0003oool0oooo05D0oooo00<0o`000?ooo`3oool0DP3oool00`3o0000oooo0?oo
o`0M0?ooo`030?l0003oool0oooo02H0oooo000K0?ooo`030000003oool0oooo01L0oooo00<0o`00
0?ooo`3oool0E03oool00`3o0000oooo0?ooo`1C0?ooo`030?l0003oool0oooo01/0oooo00<0o`00
0?ooo`3oool09`3oool001/0oooo00<000000?ooo`3oool05`3oool00`3o0000oooo0?ooo`1D0?oo
o`030?l0003oool0oooo05@0oooo00<0o`000?ooo`3oool06P3oool00`3o0000oooo0?ooo`0W0?oo
o`006`3oool2000001T0oooo00<0o`000?ooo`3oool0DP3oool00`3o0000oooo0?ooo`1F0?ooo`03
0?l0003oool0oooo01P0oooo00<0o`000?ooo`3oool0:03oool001/0oooo00<000000?ooo`3oool0
603oool00`3o0000oooo0?ooo`1B0?ooo`030?l0003oool0oooo05L0oooo00<0o`000?ooo`3oool0
5P3oool00`3o0000oooo0?ooo`0Y0?ooo`006`3oool00`000000oooo0?ooo`0I0?ooo`030?l0003o
ool0oooo0540oooo00<0o`000?ooo`3oool0F03oool00`3o0000oooo0?ooo`0D0?ooo`030?l0003o
ool0oooo02X0oooo000K0?ooo`030000003oool0oooo01T0oooo00<0o`000?ooo`3oool0D03oool0
0`3o0000oooo0?ooo`1J0?ooo`80o`004`3oool00`3o0000oooo0?ooo`0[0?ooo`006`3oool00`00
0000oooo0?ooo`0J0?ooo`030?l0003oool0oooo04l0oooo00<0o`000?ooo`3oool0G03oool00`3o
0000oooo0?ooo`0?0?ooo`030?l0003oool0oooo02`0oooo000K0?ooo`030000003oool0oooo01X0
oooo00<0o`000?ooo`3oool0C`3oool00`3o0000oooo0?ooo`1M0?ooo`030?l0003oool0oooo00/0
oooo0`3o000_0?ooo`006`3oool2000001`0oooo00<0o`000?ooo`3oool0C@3oool00`3o0000oooo
0?ooo`1O0?ooo`030?l0003oool0oooo00H0oooo103o000b0?ooo`006`3oool00`000000oooo0?oo
o`0K0?ooo`030?l0003oool0oooo04d0oooo00<0o`000?ooo`3oool0H03oool0103o0000oooo0?oo
o`3oool40?l003H0oooo000K0?ooo`030000003oool0oooo01`0oooo00<0o`000?ooo`3oool0C03o
ool00`3o0000oooo0?ooo`1Q0?ooo`<0o`00>P3oool000P0oooo0P0000040?ooo`800000103oool2
000000D0oooo00<000000?ooo`3oool0703oool00`3o0000oooo0?ooo`1<0?ooo`030?l0003oool0
oooo09h0oooo00070?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000103o
ool00`000000oooo0?ooo`0M0?ooo`030?l0003oool0oooo04X0oooo00<0o`000?ooo`3oool0W`3o
ool000L0oooo00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`020?ooo`8000007P3o
ool00`3o0000oooo0?ooo`1:0?ooo`030?l0003oool0oooo09l0oooo00070?ooo`040000003oool0
oooo000000T0oooo0P0000050?ooo`030000003oool0oooo01h0oooo00<0o`000?ooo`3oool0B@3o
ool00`3o0000oooo0?ooo`2O0?ooo`001`3oool010000000oooo0?ooo`0000090?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool07P3oool00`3o0000oooo0?ooo`190?ooo`030?l0003o
ool0oooo09l0oooo00080?ooo`8000002P3oool3000000@0oooo00<000000?ooo`3oool07`3oool0
0`3o0000oooo0?ooo`170?ooo`030?l0003oool0oooo0:00oooo000K0?ooo`030000003oool0oooo
01l0oooo00<0o`000?ooo`3oool0A`3oool00`3o0000oooo0?ooo`2P0?ooo`006`3oool00`000000
oooo0?ooo`0P0?ooo`030?l0003oool0oooo04H0oooo00<0o`000?ooo`3oool0X03oool001/0oooo
0P00000Q0?ooo`030?l0003oool0oooo04H0oooo00<0o`000?ooo`3oool0X03oool001/0oooo00<0
00000?ooo`3oool08@3oool00`3o0000oooo0?ooo`140?ooo`030?l0003oool0oooo0:40oooo000K
0?ooo`030000003oool0oooo0240oooo00<0o`000?ooo`3oool0A03oool00`3o0000oooo0?ooo`2Q
0?ooo`006`3oool00`000000oooo0?ooo`0R0?ooo`030?l0003oool0oooo04<0oooo00<0o`000?oo
o`3oool0X@3oool001/0oooo00<000000?ooo`3oool08P3oool00`3o0000oooo0?ooo`130?ooo`03
0?l0003oool0oooo0:40oooo000K0?ooo`800000903oool00`3o0000oooo0?ooo`110?ooo`030?l0
003oool0oooo0:80oooo000K0?ooo`030000003oool0oooo02<0oooo00<0o`000?ooo`3oool0@@3o
ool00`3o0000oooo0?ooo`2R0?ooo`006`3oool00`000000oooo0?ooo`0S0?ooo`030?l0003oool0
oooo0440oooo00<0o`000?ooo`3oool0XP3oool001/0oooo00<000000?ooo`3oool0903oool00`3o
0000oooo0?ooo`100?ooo`030?l0003oool0oooo0:80oooo000K0?ooo`030000003oool0oooo02@0
oooo00<0o`000?ooo`3oool0?`3oool00`3o0000oooo0?ooo`2S0?ooo`006`3oool00`000000oooo
0?ooo`0U0?ooo`030?l0003oool0oooo03h0oooo00<0o`000?ooo`3oool0X`3oool001/0oooo0P00
000V0?ooo`030?l0003oool0oooo03h0oooo00<0o`000?ooo`3oool0X`3oool001/0oooo00<00000
0?ooo`3oool09@3oool00`3o0000oooo0?ooo`0n0?ooo`030?l0003oool0oooo0:<0oooo000K0?oo
o`030000003oool0oooo02H0oooo00<0o`000?ooo`3oool0?03oool00`3o0000oooo0?ooo`2T0?oo
o`006`3oool00`000000oooo0?ooo`0V0?ooo`030?l0003oool0oooo03`0oooo00<0o`000?ooo`3o
ool0Y03oool001/0oooo00<000000?ooo`3oool09P3oool00`3o0000oooo0?ooo`0l0?ooo`030?l0
003oool0oooo0:@0oooo000K0?ooo`800000:03oool00`3o0000oooo0?ooo`0k0?ooo`030?l0003o
ool0oooo0:@0oooo000K0?ooo`030000003oool0oooo02L0oooo00<0o`000?ooo`3oool0>P3oool0
0`3o0000oooo0?ooo`2U0?ooo`006`3oool00`000000oooo0?ooo`0W0?ooo`030?l0003oool0oooo
03X0oooo00<0o`000?ooo`3oool0Y@3oool001<0oooo1@0000030?ooo`030000003oool0oooo02P0
oooo00<0o`000?ooo`3oool0>@3oool00`3o0000oooo0?ooo`2U0?ooo`005@3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo02P0oooo00<0o`000?ooo`3oool0>@3oool00`3o0000oooo
0?ooo`2U0?ooo`005@3oool00`000000oooo0?ooo`030?ooo`800000:P3oool00`3o0000oooo0?oo
o`0g0?ooo`030?l0003oool0oooo0:H0oooo000E0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0:@3oool00`3o0000oooo0?ooo`0g0?ooo`030?l0003oool0oooo0:H0oooo000E0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0:@3oool00`3o0000oooo0?ooo`0g0?oo
o`030?l0003oool0oooo0:H0oooo000D0?ooo`8000001@3oool00`000000oooo0?ooo`0Z0?ooo`03
0?l0003oool0oooo03H0oooo00<0o`000?ooo`3oool0YP3oool001/0oooo00<000000?ooo`3oool0
:P3oool00`3o0000oooo0?ooo`0e0?ooo`030?l0003oool0oooo0:L0oooo000K0?ooo`030000003o
ool0oooo02X0oooo00<0o`000?ooo`3oool0=@3oool00`3o0000oooo0?ooo`2W0?ooo`006`3oool2
000002`0oooo00<0o`000?ooo`3oool0=03oool00`3o0000oooo0?ooo`2W0?ooo`006`3oool00`00
0000oooo0?ooo`0[0?ooo`030?l0003oool0oooo03@0oooo00<0o`000?ooo`3oool0Y`3oool001/0
oooo00<000000?ooo`3oool0:`3oool00`3o0000oooo0?ooo`0c0?ooo`030?l0003oool0oooo0:P0
oooo000K0?ooo`030000003oool0oooo02`0oooo00<0o`000?ooo`3oool0<P3oool00`3o0000oooo
0?ooo`2X0?ooo`006`3oool00`000000oooo0?ooo`0/0?ooo`030?l0003oool0oooo0380oooo00<0
o`000?ooo`3oool0Z03oool001/0oooo0P00000^0?ooo`030?l0003oool0oooo0340oooo00<0o`00
0?ooo`3oool0Z03oool001/0oooo00<000000?ooo`3oool0;@3oool00`3o0000oooo0?ooo`0`0?oo
o`030?l0003oool0oooo0:T0oooo000K0?ooo`030000003oool0oooo02d0oooo00<0o`000?ooo`3o
ool0<03oool00`3o0000oooo0?ooo`2Y0?ooo`006`3oool00`000000oooo0?ooo`0^0?ooo`030?l0
003oool0oooo02l0oooo00<0o`000?ooo`3oool0Z@3oool001/0oooo00<000000?ooo`3oool0;P3o
ool00`3o0000oooo0?ooo`0_0?ooo`030?l0003oool0oooo0:T0oooo000K0?ooo`030000003oool0
oooo02h0oooo00<0o`000?ooo`3oool0;P3oool00`3o0000oooo0?ooo`2Z0?ooo`006`3oool20000
0300oooo00<0o`000?ooo`3oool0;@3oool00`3o0000oooo0?ooo`2Z0?ooo`006`3oool00`000000
oooo0?ooo`0_0?ooo`030?l0003oool0oooo02d0oooo00<0o`000?ooo`3oool0ZP3oool001/0oooo
00<000000?ooo`3oool0<03oool00`3o0000oooo0?ooo`0[0?ooo`030?l0003oool0oooo0:/0oooo
000K0?ooo`030000003oool0oooo0300oooo00<0o`000?ooo`3oool0:`3oool00`3o0000oooo0?oo
o`2[0?ooo`006`3oool00`000000oooo0?ooo`0`0?ooo`030?l0003oool0oooo02/0oooo00<0o`00
0?ooo`3oool0Z`3oool001/0oooo0P00000b0?ooo`030?l0003oool0oooo02T0oooo00<0o`000?oo
o`3oool0[03oool001/0oooo00<000000?ooo`3oool0<@3oool00`3o0000oooo0?ooo`0Y0?ooo`03
0?l0003oool0oooo0:`0oooo000K0?ooo`030000003oool0oooo0380oooo00<0o`000?ooo`3oool0
:03oool00`3o0000oooo0?ooo`2/0?ooo`001`3oool500000080oooo0P0000040?ooo`8000001@3o
ool00`000000oooo0?ooo`0b0?ooo`030?l0003oool0oooo02L0oooo00<0o`000?ooo`3oool0[@3o
ool000T0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`0000040?ooo`030000003o
ool0oooo0380oooo00<0o`000?ooo`3oool09`3oool00`3o0000oooo0?ooo`2]0?ooo`002@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo0P00000d0?ooo`030?l0003oool0
oooo02H0oooo00<0o`000?ooo`3oool0[@3oool000T0oooo00<000000?ooo`3oool0203oool20000
00D0oooo00<000000?ooo`3oool0<`3oool00`3o0000oooo0?ooo`0U0?ooo`030?l0003oool0oooo
0:h0oooo00090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0d0?ooo`030?l0003oool0oooo02@0oooo00<0o`000?ooo`3oool0[P3oool000P0oooo
0P00000:0?ooo`<00000103oool00`000000oooo0?ooo`0d0?ooo`030?l0003oool0oooo02@0oooo
00<0o`000?ooo`3oool0[P3oool001/0oooo00<000000?ooo`3oool0=03oool00`3o0000oooo0?oo
o`0S0?ooo`030?l0003oool0oooo0:l0oooo000K0?ooo`030000003oool0oooo03D0oooo00<0o`00
0?ooo`3oool08P3oool00`3o0000oooo0?ooo`2_0?ooo`006`3oool2000003H0oooo00<0o`000?oo
o`3oool08@3oool00`3o0000oooo0?ooo`2`0?ooo`006`3oool00`000000oooo0?ooo`0f0?ooo`03
0?l0003oool0oooo0200oooo00<0o`000?ooo`3oool0/03oool001/0oooo00<000000?ooo`3oool0
=P3oool00`3o0000oooo0?ooo`0P0?ooo`030?l0003oool0oooo0;00oooo000K0?ooo`030000003o
ool0oooo03L0oooo00<0o`000?ooo`3oool07P3oool00`3o0000oooo0?ooo`2a0?ooo`006`3oool0
0`000000oooo0?ooo`0g0?ooo`030?l0003oool0oooo01h0oooo00<0o`000?ooo`3oool0/@3oool0
01/0oooo0P00000h0?ooo`030?l0003oool0oooo01h0oooo00<0o`000?ooo`3oool0/@3oool001/0
oooo00<000000?ooo`3oool0>03oool00`3o0000oooo0?ooo`0L0?ooo`030?l0003oool0oooo0;80
oooo000K0?ooo`030000003oool0oooo03P0oooo00<0o`000?ooo`3oool0703oool00`3o0000oooo
0?ooo`2b0?ooo`006`3oool00`000000oooo0?ooo`0i0?ooo`030?l0003oool0oooo01/0oooo00<0
o`000?ooo`3oool0/P3oool001/0oooo00<000000?ooo`3oool0>@3oool00`3o0000oooo0?ooo`0J
0?ooo`030?l0003oool0oooo0;<0oooo000K0?ooo`030000003oool0oooo03T0oooo00<0o`000?oo
o`3oool06P3oool00`3o0000oooo0?ooo`2c0?ooo`006`3oool2000003/0oooo00<0o`000?ooo`3o
ool06@3oool00`3o0000oooo0?ooo`2c0?ooo`006`3oool00`000000oooo0?ooo`0j0?ooo`030?l0
003oool0oooo01P0oooo00<0o`000?ooo`3oool0]03oool001/0oooo00<000000?ooo`3oool0>`3o
ool00`3o0000oooo0?ooo`0G0?ooo`030?l0003oool0oooo0;@0oooo000K0?ooo`030000003oool0
oooo03/0oooo00<0o`000?ooo`3oool05`3oool00`3o0000oooo0?ooo`2d0?ooo`006`3oool00`00
0000oooo0?ooo`0l0?ooo`030?l0003oool0oooo01D0oooo00<0o`000?ooo`3oool0]@3oool001/0
oooo0P00000m0?ooo`030?l0003oool0oooo01D0oooo00<0o`000?ooo`3oool0]@3oool001/0oooo
00<000000?ooo`3oool0?@3oool00`3o0000oooo0?ooo`0D0?ooo`030?l0003oool0oooo0;D0oooo
000K0?ooo`030000003oool0oooo03h0oooo00<0o`000?ooo`3oool04P3oool00`3o0000oooo0?oo
o`2f0?ooo`006`3oool00`000000oooo0?ooo`0o0?ooo`030?l0003oool0oooo0140oooo00<0o`00
0?ooo`3oool0]P3oool001<0oooo100000040?ooo`030000003oool0oooo03l0oooo00<0o`000?oo
o`3oool0403oool00`3o0000oooo0?ooo`2g0?ooo`004`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0400oooo00<0o`000?ooo`3oool03P3oool00`3o0000oooo0?ooo`2h0?ooo`00
503oool00`000000oooo0?ooo`040?ooo`800000@P3oool00`3o0000oooo0?ooo`0<0?ooo`030?l0
003oool0oooo0;T0oooo000E0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0@@3o
ool00`3o0000oooo0?ooo`0;0?ooo`030?l0003oool0oooo0;X0oooo000C0?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool0@P3oool00`3o0000oooo0?ooo`090?ooo`030?l0003o
ool0oooo0;/0oooo000D0?ooo`8000001@3oool00`000000oooo0?ooo`130?ooo`030?l0003oool0
oooo00L0oooo00<0o`000?ooo`3oool0_03oool001/0oooo00<000000?ooo`3oool0@`3oool00`3o
0000oooo0?ooo`060?ooo`030?l0003oool0oooo0;d0oooo000K0?ooo`800000A@3oool00`3o0000
oooo0?ooo`040?ooo`030?l0003oool0oooo0;h0oooo000K0?ooo`030000003oool0oooo04D0oooo
00<0o`000?ooo`3oool00P3oool00`3o0000oooo0?ooo`2o0?ooo`006`3oool00`000000oooo0?oo
o`160?ooo`040?l0003oool0oooo0?l00<80oooo000K0?ooo`030000003oool0oooo04H0oooo00<0
o`000?ooo`3o0000``3oool001/0oooo00<000000?ooo`3oool0A`3oool00`3o0000oooo0?ooo`32
0?ooo`006`3oool200000?l0oooo3P3oool001/0oooo00<000000?ooo`3oool0o`3oool=0?ooo`00
6`3oool00`000000oooo0?ooo`3o0?ooo`d0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?oo
ob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?oo
ob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo000J0?ooo`@00000o`3oool=
0?ooo`006@3oool010000000oooo0?ooo`00003o0?ooo`h0oooo000I0?ooo`040000003oool0oooo
00000?l0oooo3P3oool001P0oooo0P0000000`3oool000000000003o0?ooo`h0oooo003o0?ooob/0
oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0
oooo0000\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.563, 0}} -> {-0.22006, -0.760649, \
0.008075, 0.0184548}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.351037 0.0395745 [
[.2619 .33854 -9 -9 ]
[.2619 .33854 9 0 ]
[.5 .33854 -3 -9 ]
[.5 .33854 3 0 ]
[.7381 .33854 -9 -9 ]
[.7381 .33854 9 0 ]
[.97619 .33854 -3 -9 ]
[.97619 .33854 3 0 ]
[1.025 .35104 0 -6.4375 ]
[1.025 .35104 10 6.4375 ]
[.01131 .03444 -12 -4.5 ]
[.01131 .03444 0 4.5 ]
[.01131 .11359 -12 -4.5 ]
[.01131 .11359 0 4.5 ]
[.01131 .19274 -12 -4.5 ]
[.01131 .19274 0 4.5 ]
[.01131 .27189 -12 -4.5 ]
[.01131 .27189 0 4.5 ]
[.01131 .43019 -6 -4.5 ]
[.01131 .43019 0 4.5 ]
[.01131 .50934 -6 -4.5 ]
[.01131 .50934 0 4.5 ]
[.01131 .58848 -6 -4.5 ]
[.01131 .58848 0 4.5 ]
[.02381 .64303 -5.03125 0 ]
[.02381 .64303 5.03125 12.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .35104 m
.2619 .35729 L
s
[(0.5)] .2619 .33854 0 1 Mshowa
.5 .35104 m
.5 .35729 L
s
[(1)] .5 .33854 0 1 Mshowa
.7381 .35104 m
.7381 .35729 L
s
[(1.5)] .7381 .33854 0 1 Mshowa
.97619 .35104 m
.97619 .35729 L
s
[(2)] .97619 .33854 0 1 Mshowa
.125 Mabswid
.07143 .35104 m
.07143 .35479 L
s
.11905 .35104 m
.11905 .35479 L
s
.16667 .35104 m
.16667 .35479 L
s
.21429 .35104 m
.21429 .35479 L
s
.30952 .35104 m
.30952 .35479 L
s
.35714 .35104 m
.35714 .35479 L
s
.40476 .35104 m
.40476 .35479 L
s
.45238 .35104 m
.45238 .35479 L
s
.54762 .35104 m
.54762 .35479 L
s
.59524 .35104 m
.59524 .35479 L
s
.64286 .35104 m
.64286 .35479 L
s
.69048 .35104 m
.69048 .35479 L
s
.78571 .35104 m
.78571 .35479 L
s
.83333 .35104 m
.83333 .35479 L
s
.88095 .35104 m
.88095 .35479 L
s
.92857 .35104 m
.92857 .35479 L
s
.25 Mabswid
0 .35104 m
1 .35104 L
s
gsave
1.025 .35104 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .03444 m
.03006 .03444 L
s
[(-8)] .01131 .03444 1 0 Mshowa
.02381 .11359 m
.03006 .11359 L
s
[(-6)] .01131 .11359 1 0 Mshowa
.02381 .19274 m
.03006 .19274 L
s
[(-4)] .01131 .19274 1 0 Mshowa
.02381 .27189 m
.03006 .27189 L
s
[(-2)] .01131 .27189 1 0 Mshowa
.02381 .43019 m
.03006 .43019 L
s
[(2)] .01131 .43019 1 0 Mshowa
.02381 .50934 m
.03006 .50934 L
s
[(4)] .01131 .50934 1 0 Mshowa
.02381 .58848 m
.03006 .58848 L
s
[(6)] .01131 .58848 1 0 Mshowa
.125 Mabswid
.02381 .05423 m
.02756 .05423 L
s
.02381 .07402 m
.02756 .07402 L
s
.02381 .0938 m
.02756 .0938 L
s
.02381 .13338 m
.02756 .13338 L
s
.02381 .15317 m
.02756 .15317 L
s
.02381 .17295 m
.02756 .17295 L
s
.02381 .21253 m
.02756 .21253 L
s
.02381 .23231 m
.02756 .23231 L
s
.02381 .2521 m
.02756 .2521 L
s
.02381 .29168 m
.02756 .29168 L
s
.02381 .31146 m
.02756 .31146 L
s
.02381 .33125 m
.02756 .33125 L
s
.02381 .37082 m
.02756 .37082 L
s
.02381 .39061 m
.02756 .39061 L
s
.02381 .4104 m
.02756 .4104 L
s
.02381 .44997 m
.02756 .44997 L
s
.02381 .46976 m
.02756 .46976 L
s
.02381 .48955 m
.02756 .48955 L
s
.02381 .52912 m
.02756 .52912 L
s
.02381 .54891 m
.02756 .54891 L
s
.02381 .5687 m
.02756 .5687 L
s
.02381 .01465 m
.02756 .01465 L
s
.02381 .60827 m
.02756 .60827 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66.0313 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 1 r
.5 Mabswid
.02381 .35104 m
.07143 .38857 L
.11905 .47701 L
.16667 .56377 L
.21429 .60332 L
.2619 .54857 L
.30952 .37588 L
.35714 .15832 L
.40476 .01582 L
.45238 .01472 L
.5 .13906 L
.54762 .30862 L
.59524 .37027 L
.64286 .37234 L
.69048 .4474 L
.7381 .50511 L
.78571 .47485 L
.83333 .38287 L
.88095 .28486 L
.92857 .2332 L
.97619 .2497 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.563},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003o4P3oool0
0`000000oooo0?ooo`3o0?oooaH0oooo000B0?ooo`030000003oool0oooo0?l0oooo5P3oool00180
oooo00<000000?ooo`3oool0o`3ooolF0?ooo`004P3oool00`000000oooo0?ooo`3o0?oooaH0oooo
000B0?ooo`800000H`3oool>0?l0ojD0oooo000B0?ooo`030000003oool0oooo0680oooo00<0o`3o
0?ooo`3oool02P3oool00`3o0?l0oooo0?ooo`2S0?ooo`004P3oool00`000000oooo0?ooo`1Q0?oo
o`030?l0o`3oool0oooo00`0oooo00<0o`3o0?ooo`3oool0XP3oool000/0oooo0P0000050?ooo`03
0000003oool0oooo0640oooo00<0o`3o0?ooo`3oool0303oool00`3o0?l0oooo0?ooo`2R0?ooo`00
2P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0640oooo00<0o`3o0?ooo`3o
ool0303oool00`3o0?l0oooo0?ooo`2R0?ooo`002P3oool010000000oooo0?ooo`0000040?ooo`<0
0000H03oool00`3o0?l0oooo0?ooo`0>0?ooo`030?l0o`3oool0oooo0:40oooo00040?ooo`@00000
0`3oool2000000D0oooo00<000000?ooo`3oool0H03oool00`3o0?l0oooo0?ooo`0>0?ooo`030?l0
o`3oool0oooo0:40oooo000:0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0
H03oool00`3o0?l0oooo0?ooo`0?0?ooo`030?l0o`3oool0oooo0:00oooo000;0?ooo`8000001@3o
ool00`000000oooo0?ooo`1O0?ooo`030?l0o`3oool0oooo0100oooo00<0o`3o0?ooo`3oool0X03o
ool00180oooo00<000000?ooo`3oool0G`3oool00`3o0?l0oooo0?ooo`0@0?ooo`030?l0o`3oool0
oooo0:00oooo000B0?ooo`800000H03oool00`3o0?l0oooo0?ooo`0A0?ooo`030?l0o`3oool0oooo
09l0oooo000B0?ooo`030000003oool0oooo05l0oooo00<0o`3o0?ooo`3oool04@3oool00`3o0?l0
oooo0?ooo`2O0?ooo`004P3oool00`000000oooo0?ooo`1N0?ooo`030?l0o`3oool0oooo0180oooo
00<0o`3o0?ooo`3oool0W`3oool00180oooo00<000000?ooo`3oool0GP3oool00`3o0?l0oooo0?oo
o`0C0?ooo`030?l0o`3oool0oooo09h0oooo000B0?ooo`030000003oool0oooo05h0oooo00<0o`3o
0?ooo`3oool04`3oool00`3o0?l0oooo0?ooo`2N0?ooo`004P3oool00`000000oooo0?ooo`1M0?oo
o`030?l0o`3oool0oooo01@0oooo00<0o`3o0?ooo`3oool0WP3oool00180oooo0P00001N0?ooo`03
0?l0o`3oool0oooo01D0oooo00<0o`3o0?ooo`3oool0W@3oool00180oooo00<000000?ooo`3oool0
G@3oool00`3o0?l0oooo0?ooo`0E0?ooo`030?l0o`3oool0oooo09d0oooo000B0?ooo`030000003o
ool0oooo05`0oooo00<0o`3o0?ooo`3oool05`3oool00`3o0?l0oooo0?ooo`2L0?ooo`004P3oool0
0`000000oooo0?ooo`1L0?ooo`030?l0o`3oool0oooo01L0oooo00<0o`3o0?ooo`3oool0W03oool0
0180oooo00<000000?ooo`3oool0G03oool00`3o0?l0oooo0?ooo`0G0?ooo`030?l0o`3oool0oooo
09`0oooo000B0?ooo`800000G03oool00`3o0?l0oooo0?ooo`0I0?ooo`030?l0o`3oool0oooo09/0
oooo000B0?ooo`030000003oool0oooo05/0oooo00<0o`3o0?ooo`3oool06@3oool00`3o0?l0oooo
0?ooo`2K0?ooo`004P3oool00`000000oooo0?ooo`1K0?ooo`030?l0o`3oool0oooo01T0oooo00<0
o`3o0?ooo`3oool0V`3oool000X0oooo0`0000050?ooo`030000003oool0oooo05X0oooo00<0o`3o
0?ooo`3oool06`3oool00`3o0?l0oooo0?ooo`2J0?ooo`002P3oool010000000oooo0?ooo`000004
0?ooo`030000003oool0oooo05X0oooo00<0o`3o0?ooo`3oool06`3oool00`3o0?l0oooo0?ooo`2J
0?ooo`002P3oool010000000oooo0?ooo`0000040?ooo`<00000FP3oool00`3o0?l0oooo0?ooo`0K
0?ooo`030?l0o`3oool0oooo09X0oooo00040?ooo`@000000P3oool3000000D0oooo00<000000?oo
o`3oool0F@3oool00`3o0?l0oooo0?ooo`0M0?ooo`030?l0o`3oool0oooo09T0oooo000;0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0F@3oool00`3o0?l0oooo0?ooo`0M0?ooo`03
0?l0o`3oool0oooo09T0oooo000;0?ooo`<00000103oool00`000000oooo0?ooo`1I0?ooo`030?l0
o`3oool0oooo01h0oooo00<0o`3o0?ooo`3oool0V03oool00180oooo00<000000?ooo`3oool0F@3o
ool00`3o0?l0oooo0?ooo`0N0?ooo`030?l0o`3oool0oooo09P0oooo000B0?ooo`800000F@3oool0
0`3o0?l0oooo0?ooo`0O0?ooo`030?l0o`3oool0oooo09P0oooo000B0?ooo`030000003oool0oooo
05P0oooo00<0o`3o0?ooo`3oool0803oool00`3o0?l0oooo0?ooo`2G0?ooo`004P3oool00`000000
oooo0?ooo`1H0?ooo`030?l0o`3oool0oooo0200oooo00<0o`3o0?ooo`3oool0U`3oool00180oooo
00<000000?ooo`3oool0E`3oool00`3o0?l0oooo0?ooo`0Q0?ooo`030?l0o`3oool0oooo09L0oooo
000B0?ooo`030000003oool0oooo05L0oooo00<0o`3o0?ooo`3oool08P3oool00`3o0?l0oooo0?oo
o`2F0?ooo`004P3oool00`000000oooo0?ooo`1G0?ooo`030?l0o`3oool0oooo0280oooo00<0o`3o
0?ooo`3oool0UP3oool00180oooo0P00001G0?ooo`030?l0o`3oool0oooo02<0oooo00<0o`3o0?oo
o`3oool0UP3oool00180oooo00<000000?ooo`3oool0EP3oool00`3o0?l0oooo0?ooo`0S0?ooo`03
0?l0o`3oool0oooo09H0oooo000B0?ooo`030000003oool0oooo05H0oooo00<0o`3o0?ooo`3oool0
903oool00`3o0?l0oooo0?ooo`2E0?ooo`004P3oool00`000000oooo0?ooo`1F0?ooo`030?l0o`3o
ool0oooo02@0oooo00<0o`3o0?ooo`3oool0U@3oool00180oooo00<000000?ooo`3oool0E@3oool0
0`3o0?l0oooo0?ooo`0U0?ooo`030?l0o`3oool0oooo09D0oooo000B0?ooo`800000EP3oool00`3o
0?l0oooo0?ooo`0V0?ooo`030?l0o`3oool0oooo09@0oooo000B0?ooo`030000003oool0oooo05D0
oooo00<0o`3o0?ooo`3oool09P3oool00`3o0?l0oooo0?ooo`2D0?ooo`004P3oool00`000000oooo
0?ooo`1E0?ooo`030?l0o`3oool0oooo02H0oooo00<0o`3o0?ooo`3oool0U03oool000`0oooo0`00
00030?ooo`030000003oool0oooo05@0oooo00<0o`3o0?ooo`3oool09`3oool00`3o0?l0oooo0?oo
o`2D0?ooo`003@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo05@0oooo00<0o`3o
0?ooo`3oool0:03oool00`3o0?l0oooo0?ooo`2C0?ooo`002P3oool5000000<0oooo0`00001D0?oo
o`030?l0o`3oool0oooo02P0oooo00<0o`3o0?ooo`3oool0T`3oool000@0oooo100000020?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool0E03oool00`3o0?l0oooo0?ooo`0X0?oo
o`030?l0o`3oool0oooo09<0oooo000;0?ooo`030000003oool0000000@0oooo00<000000?ooo`3o
ool0E03oool00`3o0?l0oooo0?ooo`0Y0?ooo`030?l0o`3oool0oooo0980oooo000<0?ooo`800000
103oool00`000000oooo0?ooo`1C0?ooo`030?l0o`3oool0oooo02X0oooo00<0o`3o0?ooo`3oool0
TP3oool00180oooo00<000000?ooo`3oool0D`3oool00`3o0?l0oooo0?ooo`0Z0?ooo`030?l0o`3o
ool0oooo0980oooo000B0?ooo`800000E03oool00`3o0?l0oooo0?ooo`0Z0?ooo`030?l0o`3oool0
oooo0980oooo000B0?ooo`030000003oool0oooo05<0oooo00<0o`3o0?ooo`3oool0:`3oool00`3o
0?l0oooo0?ooo`2A0?ooo`004P3oool00`000000oooo0?ooo`1B0?ooo`030?l0o`3oool0oooo02`0
oooo00<0o`3o0?ooo`3oool0T@3oool00180oooo00<000000?ooo`3oool0DP3oool00`3o0?l0oooo
0?ooo`0/0?ooo`030?l0o`3oool0oooo0940oooo000B0?ooo`030000003oool0oooo0580oooo00<0
o`3o0?ooo`3oool0;@3oool00`3o0?l0oooo0?ooo`2@0?ooo`004P3oool00`000000oooo0?ooo`1B
0?ooo`030?l0o`3oool0oooo02d0oooo00<0o`3o0?ooo`3oool0T03oool00180oooo0P00001C0?oo
o`030?l0o`3oool0oooo02d0oooo00<0o`3o0?ooo`3oool0J03oool20?l0obH0oooo000B0?ooo`03
0000003oool0oooo0540oooo00<0o`3o0?ooo`3oool0;`3oool00`3o0?l0oooo0?ooo`1V0?ooo`03
0?l0o`3oool0oooo00<0o`3o8`3oool00180oooo00<000000?ooo`3oool0D@3oool00`3o0?l0oooo
0?ooo`0_0?ooo`030?l0o`3oool0oooo06D0oooo00<0o`3o0?ooo`3oool0103oool40?l0oal0oooo
000B0?ooo`030000003oool0oooo0540oooo00<0o`3o0?ooo`3oool0;`3oool00`3o0?l0oooo0?oo
o`1T0?ooo`030?l0o`3oool0oooo00T0oooo0`3o0?lL0?ooo`004P3oool00`000000oooo0?ooo`1A
0?ooo`030?l0o`3oool0oooo02l0oooo00<0o`3o0?ooo`3oool0I03oool00`3o0?l0oooo0?ooo`0<
0?ooo`80o`3o6P3oool00180oooo0P00001A0?ooo`030?l0o`3oool0oooo0340oooo00<0o`3o0?oo
o`3oool0HP3oool00`3o0?l0oooo0?ooo`0Y0?ooo`004P3oool00`000000oooo0?ooo`1@0?ooo`03
0?l0o`3oool0oooo0340oooo00<0o`3o0?ooo`3oool0H@3oool00`3o0?l0oooo0?ooo`0Z0?ooo`00
4P3oool00`000000oooo0?ooo`1@0?ooo`030?l0o`3oool0oooo0340oooo00<0o`3o0?ooo`3oool0
H03oool00`3o0?l0oooo0?ooo`0[0?ooo`002P3oool4000000@0oooo00<000000?ooo`3oool0D03o
ool00`3o0?l0oooo0?ooo`0b0?ooo`030?l0o`3oool0oooo05h0oooo00<0o`3o0?ooo`3oool0;03o
ool000X0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1?0?ooo`030?l0o`3oool0
oooo03<0oooo00<0o`3o0?ooo`3oool0G@3oool00`3o0?l0oooo0?ooo`0]0?ooo`002`3oool00`00
0000oooo0?ooo`040?ooo`<00000C`3oool00`3o0?l0oooo0?ooo`0c0?ooo`030?l0o`3oool0oooo
05`0oooo00<0o`3o0?ooo`3oool0;P3oool000@0oooo100000040?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0C`3oool00`3o0?l0oooo0?ooo`0c0?ooo`030?l0o`3oool0oooo05`0
oooo00<0o`3o0?ooo`3oool0;P3oool000X0oooo00@000000?ooo`3oool00000103oool00`000000
oooo0?ooo`1?0?ooo`030?l0o`3oool0oooo03@0oooo00<0o`3o0?ooo`3oool0FP3oool00`3o0?l0
oooo0?ooo`0_0?ooo`002`3oool2000000D0oooo00<000000?ooo`3oool0C`3oool00`3o0?l0oooo
0?ooo`0d0?ooo`030?l0o`3oool0oooo05T0oooo00<0o`3o0?ooo`3oool0<03oool00180oooo00<0
00000?ooo`3oool0CP3oool00`3o0?l0oooo0?ooo`0e0?ooo`030?l0o`3oool0oooo05P0oooo00<0
o`3o0?ooo`3oool0<@3oool00180oooo0P00001?0?ooo`030?l0o`3oool0oooo03H0oooo00<0o`3o
0?ooo`3oool0EP3oool00`3o0?l0oooo0?ooo`0b0?ooo`004P3oool00`000000oooo0?ooo`1>0?oo
o`030?l0o`3oool0oooo03H0oooo00<0o`3o0?ooo`3oool0EP3oool00`3o0?l0oooo0?ooo`0b0?oo
o`004P3oool00`000000oooo0?ooo`1>0?ooo`030?l0o`3oool0oooo03H0oooo00<0o`3o0?ooo`3o
ool0E@3oool00`3o0?l0oooo0?ooo`0c0?ooo`004P3oool00`000000oooo0?ooo`1=0?ooo`030?l0
o`3oool0oooo03L0oooo00<0o`3o0?ooo`3oool0E@3oool00`3o0?l0oooo0?ooo`0c0?ooo`004P3o
ool00`000000oooo0?ooo`1=0?ooo`030?l0o`3oool0oooo03P0oooo00<0o`3o0?ooo`3oool0D`3o
ool00`3o0?l0oooo0?ooo`0d0?ooo`004P3oool00`000000oooo0?ooo`0e0?ooo`800000103oool2
000000@0oooo0P00000:0?ooo`030?l0o`3oool0oooo02T0oooo1@00000:0?ooo`030?l0o`3oool0
oooo02P0oooo1@0000020?ooo`800000103oool2000001`0oooo00<0o`3o0?ooo`3oool05`3oool4
000001T0oooo000B0?ooo`800000=@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0
oooo000000T0oooo00<0o`3o0?ooo`3oool0:`3oool00`000000oooo0?ooo`0;0?ooo`030?l0o`3o
ool0oooo02T0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`00000J0?ooo`030?l0
o`3oool0oooo01P0oooo00<000000?ooo`3oool06P3oool00180oooo00<000000?ooo`3oool0=03o
ool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo00L0oooo00<0o`3o0?ooo`3oool0
:`3oool00`000000oooo0?ooo`0<0?ooo`030?l0o`3oool0oooo02P0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0H0?ooo`030?l0o`3oool0oooo01T0oooo00<000000?ooo`3oool0
6@3oool00180oooo00<000000?ooo`3oool0=03oool010000000oooo0?ooo`0000090?ooo`800000
2@3oool00`3o0?l0oooo0?ooo`0/0?ooo`030000003oool0oooo00`0oooo00<0o`3o0?ooo`3oool0
:03oool00`000000oooo0?ooo`080?ooo`8000006P3oool00`3o0?l0oooo0?ooo`0K0?ooo`030000
003oool0oooo01P0oooo000B0?ooo`030000003oool0oooo03@0oooo00@000000?ooo`3oool00000
2@3oool00`000000oooo0?ooo`080?ooo`030?l0o`3oool0oooo02`0oooo00<000000?ooo`3oool0
3@3oool00`3o0?l0oooo0?ooo`0W0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
6@3oool00`3o0?l0oooo0?ooo`0I0?ooo`040000003oool0oooo000001T0oooo000B0?ooo`030000
003oool0oooo03D0oooo0P00000:0?ooo`<00000203oool00`3o0?l0oooo0?ooo`0[0?ooo`800000
403oool00`3o0?l0oooo0?ooo`0U0?ooo`8000002P3oool3000001P0oooo00<0o`3o0?ooo`3oool0
6`3oool2000001X0oooo000B0?ooo`800000C@3oool00`3o0?l0oooo0?ooo`0n0?ooo`030?l0o`3o
ool0oooo04/0oooo00<0o`3o0?ooo`3oool0=`3oool00180oooo00<000000?ooo`3oool0B`3oool0
0`3o0?l0oooo0?ooo`100?ooo`030?l0o`3oool0oooo04T0oooo00<0o`3o0?ooo`3oool0>03oool0
0180oooo00<000000?ooo`3oool0B`3oool00`3o0?l0oooo0?ooo`100?ooo`030?l0o`3oool0oooo
04T0oooo00<0o`3o0?ooo`3oool0>03oool00180oooo00<000000?ooo`3oool0B`3oool00`3o0?l0
oooo0?ooo`110?ooo`030?l0o`3oool0oooo04L0oooo00<0o`3o0?ooo`3oool0>@3oool00180oooo
00<000000?ooo`3oool0B`3oool00`3o0?l0oooo0?ooo`120?ooo`030?l0o`3oool0oooo04H0oooo
00<0o`3o0?ooo`3oool0;`3oool2000000P0oooo000<0?ooo`H0000000<0o`3o000000000000B`00
00000`3o0?l0000000000013000000030?l0o`000000000004@0000000<0o`3o0000000000009P00
00090?ooo`040000003oool0oooo000000L0oooo000B0?ooo`030000003o0?l0oooo00X0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003o0?l0oooo00X0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`070?ooo`040?l0o`3oool0oooo000000/0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool02P3oool01@000000oooo0?ooo`3oool0o`3o00P0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0203oool00180oooo00@000000?ooo`3o0?l0o`3o>`3oool00`000000oooo0?ooo`0;0?ooo`03
0?l0o`3oool0oooo02h0oooo00<000000?ooo`3oool05@3oool00`3o0?l0oooo0?ooo`0U0?ooo`03
0000003oool0oooo01T0oooo00<0o`3o0?ooo`3oool0803oool00`000000oooo0?ooo`0<0?ooo`D0
00001`3oool00180oooo00D000000?ooo`3oool0oooo0?l0o`180?ooo`030?l0o`3oool0oooo04H0
oooo00<0o`3o0?ooo`3oool0@@3oool00`3o0?l0oooo0?ooo`0`0?ooo`030000003oool0oooo00P0
oooo000B0?ooo`030000003oool0oooo0080oooo00<0o`3o0?ooo`3oool0A@3oool00`3o0?l0oooo
0?ooo`170?ooo`030?l0o`3oool0oooo03l0oooo00<0o`3o0?ooo`3oool0?03oool00180oooo0P00
00040?ooo`80o`3oA03oool00`3o0?l0oooo0?ooo`190?ooo`H0o`3o>`3oool00`3o0?l0oooo0?oo
o`0l0?ooo`004P3oool00`000000oooo0?ooo`050?ooo`030?l0o`3oool0oooo0440oooo00<0o`3o
0?ooo`3oool0C`3oool70?l0oc<0oooo00<0o`3o0?ooo`3oool0?@3oool00180oooo00<000000?oo
o`3oool01P3oool00`3o0?l0oooo0?ooo`100?ooo`030?l0o`3oool0oooo05H0oooo00<0o`3o0?oo
o`3oool0<03oool00`3o0?l0oooo0?ooo`0m0?ooo`004P3oool00`000000oooo0?ooo`070?ooo`80
o`3o@03oool00`3o0?l0oooo0?ooo`1F0?ooo`030?l0o`3oool0oooo02l0oooo00<0o`3o0?ooo`3o
ool0?P3oool00180oooo00<000000?ooo`3oool02@3oool00`3o0?l0oooo0?ooo`0l0?ooo`030?l0
o`3oool0oooo05P0oooo00<0o`3o0?ooo`3oool0;P3oool00`3o0?l0oooo0?ooo`0n0?ooo`004P3o
ool00`000000oooo0?ooo`0:0?ooo`030?l0o`3oool0oooo03/0oooo00<0o`3o0?ooo`3oool0F@3o
ool00`3o0?l0oooo0?ooo`0/0?ooo`030?l0o`3oool0oooo03l0oooo000B0?ooo`8000002`3oool0
0`3o0?l0oooo0?ooo`0k0?ooo`030?l0o`3oool0oooo05T0oooo00<0o`3o0?ooo`3oool0;03oool0
0`3o0?l0oooo0?ooo`0o0?ooo`004P3oool00`000000oooo0?ooo`0;0?ooo`030?l0o`3oool0oooo
03X0oooo00<0o`3o0?ooo`3oool0FP3oool00`3o0?l0oooo0?ooo`0Z0?ooo`030?l0o`3oool0oooo
0400oooo000B0?ooo`030000003oool0oooo00/0oooo00<0o`3o0?ooo`3oool0>@3oool00`3o0?l0
oooo0?ooo`1L0?ooo`030?l0o`3oool0oooo02T0oooo00<0o`3o0?ooo`3oool0@03oool00180oooo
00<000000?ooo`3oool0303oool00`3o0?l0oooo0?ooo`0h0?ooo`030?l0o`3oool0oooo05`0oooo
00<0o`3o0?ooo`3oool0:03oool00`3o0?l0oooo0?ooo`110?ooo`004P3oool00`000000oooo0?oo
o`0<0?ooo`030?l0o`3oool0oooo03P0oooo00<0o`3o0?ooo`3oool0G@3oool00`3o0?l0oooo0?oo
o`0W0?ooo`030?l0o`3oool0oooo0440oooo000B0?ooo`8000003P3oool00`3o0?l0oooo0?ooo`0f
0?ooo`030?l0o`3oool0oooo05h0oooo00<0o`3o0?ooo`3oool09P3oool00`3o0?l0oooo0?ooo`12
0?ooo`004P3oool00`000000oooo0?ooo`0=0?ooo`030?l0o`3oool0oooo03H0oooo00<0o`3o0?oo
o`3oool0G`3oool00`3o0?l0oooo0?ooo`0U0?ooo`030?l0o`3oool0oooo0480oooo000B0?ooo`03
0000003oool0oooo00h0oooo00<0o`3o0?ooo`3oool0=@3oool00`3o0?l0oooo0?ooo`1P0?ooo`03
0?l0o`3oool0oooo02<0oooo00<0o`3o0?ooo`3oool0@`3oool000X0oooo100000040?ooo`030000
003oool0oooo00h0oooo00<0o`3o0?ooo`3oool0=@3oool00`3o0?l0oooo0?ooo`1P0?ooo`030?l0
o`3oool0oooo02<0oooo00<0o`3o0?ooo`3oool0@`3oool000X0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0?0?ooo`030?l0o`3oool0oooo03<0oooo00<0o`3o0?ooo`3oool0HP3o
ool00`3o0?l0oooo0?ooo`0Q0?ooo`030?l0o`3oool0oooo04@0oooo000;0?ooo`030000003oool0
oooo00@0oooo0`00000?0?ooo`030?l0o`3oool0oooo03<0oooo00<0o`3o0?ooo`3oool0H`3oool0
0`3o0?l0oooo0?ooo`0O0?ooo`030?l0o`3oool0oooo04D0oooo000<0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0403oool00`3o0?l0oooo0?ooo`0b0?ooo`030?l0o`3oool0oooo
06<0oooo00<0o`3o0?ooo`3oool07`3oool00`3o0?l0oooo0?ooo`150?ooo`002P3oool010000000
oooo0?ooo`0000040?ooo`030000003oool0oooo0100oooo00<0o`3o0?ooo`3oool0<@3oool00`3o
0?l0oooo0?ooo`1U0?ooo`030?l0o`3oool0oooo01d0oooo00<0o`3o0?ooo`3oool0AP3oool000/0
oooo0P0000050?ooo`030000003oool0oooo0140oooo00<0o`3o0?ooo`3oool0<03oool00`3o0?l0
oooo0?ooo`1V0?ooo`030?l0o`3oool0oooo01`0oooo00<0o`3o0?ooo`3oool0AP3oool00180oooo
00<000000?ooo`3oool04@3oool00`3o0?l0oooo0?ooo`0`0?ooo`030?l0o`3oool0oooo06H0oooo
00<0o`3o0?ooo`3oool06`3oool00`3o0?l0oooo0?ooo`170?ooo`004P3oool2000001<0oooo00<0
o`3o0?ooo`3oool0;`3oool00`3o0?l0oooo0?ooo`1W0?ooo`030?l0o`3oool0oooo01X0oooo00<0
o`3o0?ooo`3oool0A`3oool00180oooo00<000000?ooo`3oool04P3oool00`3o0?l0oooo0?ooo`0^
0?ooo`030?l0o`3oool0oooo06T0oooo00<0o`3o0?ooo`3oool0603oool00`3o0?l0oooo0?ooo`18
0?ooo`004P3oool00`000000oooo0?ooo`0C0?ooo`030?l0o`3oool0oooo02d0oooo00<0o`3o0?oo
o`3oool0JP3oool00`3o0?l0oooo0?ooo`0G0?ooo`030?l0o`3oool0oooo04P0oooo000B0?ooo`03
0000003oool0oooo01<0oooo00<0o`3o0?ooo`3oool0;@3oool00`3o0?l0oooo0?ooo`1[0?ooo`03
0?l0o`3oool0oooo01D0oooo00<0o`3o0?ooo`3oool0B@3oool00180oooo00<000000?ooo`3oool0
503oool00`3o0?l0oooo0?ooo`0[0?ooo`030?l0o`3oool0oooo06`0oooo00<0o`3o0?ooo`3oool0
5@3oool00`3o0?l0oooo0?ooo`190?ooo`004P3oool00`000000oooo0?ooo`0D0?ooo`030?l0o`3o
ool0oooo02/0oooo00<0o`3o0?ooo`3oool0K@3oool00`3o0?l0oooo0?ooo`0C0?ooo`030?l0o`3o
ool0oooo04X0oooo000B0?ooo`8000005P3oool00`3o0?l0oooo0?ooo`0Z0?ooo`030?l0o`3oool0
oooo06h0oooo00<0o`3o0?ooo`3oool04P3oool00`3o0?l0oooo0?ooo`1:0?ooo`004P3oool00`00
0000oooo0?ooo`0E0?ooo`030?l0o`3oool0oooo02X0oooo00<0o`3o0?ooo`3oool0K`3oool00`3o
0?l0oooo0?ooo`0@0?ooo`030?l0o`3oool0oooo04/0oooo000B0?ooo`030000003oool0oooo01H0
oooo00<0o`3o0?ooo`3oool0:03oool00`3o0?l0oooo0?ooo`1a0?ooo`030?l0o`3oool0oooo00d0
oooo0P3o0?m>0?ooo`004P3oool00`000000oooo0?ooo`0G0?ooo`030?l0o`3oool0oooo02L0oooo
00<0o`3o0?ooo`3oool0LP3oool00`3o0?l0oooo0?ooo`0;0?ooo`030?l0o`3oool0oooo04h0oooo
000B0?ooo`030000003oool0oooo01L0oooo00<0o`3o0?ooo`3oool09`3oool00`3o0?l0oooo0?oo
o`1c0?ooo`030?l0o`3oool0oooo00P0oooo0P3o0?mA0?ooo`004P3oool2000001T0oooo00<0o`3o
0?ooo`3oool09P3oool00`3o0?l0oooo0?ooo`1d0?ooo`030?l0o`3oool0oooo00H0oooo00<0o`3o
0?ooo`3oool0D@3oool00180oooo00<000000?ooo`3oool0603oool00`3o0?l0oooo0?ooo`0U0?oo
o`030?l0o`3oool0oooo07D0oooo00<0o`3o0?ooo`3oool0103oool20?l0oe@0oooo000B0?ooo`03
0000003oool0oooo01T0oooo00<0o`3o0?ooo`3oool0903oool00`3o0?l0oooo0?ooo`1f0?ooo`03
0?l0o`3oool0oooo0080oooo00<0o`3o0?ooo`3oool0E03oool000`0oooo0`0000030?ooo`030000
003oool0oooo01T0oooo00<0o`3o0?ooo`3oool0903oool00`3o0?l0oooo0?ooo`1g0?ooo`040?l0
o`3oool0o`3o0?l0oeL0oooo000=0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
6P3oool00`3o0?l0oooo0?ooo`0R0?ooo`030?l0o`3oool0oooo07T0oooo00<0o`3o0?ooo`3oool0
E`3oool000X0oooo1@0000030?ooo`<000006`3oool00`3o0?l0oooo0?ooo`0Q0?ooo`030?l0o`3o
ool0oooo0=<0oooo000:0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool06`3o
ool00`3o0?l0oooo0?ooo`0Q0?ooo`030?l0o`3oool0oooo0=<0oooo000;0?ooo`030000003oool0
000000@0oooo00<000000?ooo`3oool0703oool00`3o0?l0oooo0?ooo`0P0?ooo`030?l0o`3oool0
oooo0=<0oooo000<0?ooo`800000103oool00`000000oooo0?ooo`0L0?ooo`030?l0o`3oool0oooo
01l0oooo00<0o`3o0?ooo`3oool0e03oool00180oooo00<000000?ooo`3oool07@3oool00`3o0?l0
oooo0?ooo`0N0?ooo`030?l0o`3oool0oooo0=@0oooo000B0?ooo`8000007P3oool00`3o0?l0oooo
0?ooo`0N0?ooo`030?l0o`3oool0oooo0=@0oooo000B0?ooo`030000003oool0oooo01h0oooo00<0
o`3o0?ooo`3oool0703oool00`3o0?l0oooo0?ooo`3E0?ooo`004P3oool00`000000oooo0?ooo`0N
0?ooo`030?l0o`3oool0oooo01`0oooo00<0o`3o0?ooo`3oool0e@3oool00180oooo00<000000?oo
o`3oool07`3oool00`3o0?l0oooo0?ooo`0K0?ooo`030?l0o`3oool0oooo0=D0oooo000B0?ooo`03
0000003oool0oooo0200oooo00<0o`3o0?ooo`3oool06P3oool00`3o0?l0oooo0?ooo`3E0?ooo`00
4P3oool00`000000oooo0?ooo`0P0?ooo`030?l0o`3oool0oooo01T0oooo00<0o`3o0?ooo`3oool0
eP3oool00180oooo0P00000R0?ooo`030?l0o`3oool0oooo01P0oooo00<0o`3o0?ooo`3oool0eP3o
ool00180oooo00<000000?ooo`3oool08@3oool00`3o0?l0oooo0?ooo`0G0?ooo`030?l0o`3oool0
oooo0=L0oooo000B0?ooo`030000003oool0oooo0280oooo00<0o`3o0?ooo`3oool05@3oool00`3o
0?l0oooo0?ooo`3H0?ooo`004P3oool00`000000oooo0?ooo`0R0?ooo`030?l0o`3oool0oooo01@0
oooo00<0o`3o0?ooo`3oool0f@3oool00180oooo00<000000?ooo`3oool08`3oool00`3o0?l0oooo
0?ooo`0C0?ooo`030?l0o`3oool0oooo0=T0oooo000B0?ooo`8000009@3oool00`3o0?l0oooo0?oo
o`0A0?ooo`030?l0o`3oool0oooo0=X0oooo000B0?ooo`030000003oool0oooo02D0oooo0P3o0?l@
0?ooo`030?l0o`3oool0oooo0=/0oooo000B0?ooo`030000003oool0oooo02L0oooo00<0o`3o0?oo
o`3oool0303oool00`3o0?l0oooo0?ooo`3L0?ooo`002P3oool3000000D0oooo00<000000?ooo`3o
ool0:03oool00`3o0?l0oooo0?ooo`0:0?ooo`030?l0o`3oool0oooo0=d0oooo000:0?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool0:@3oool20?l0o`T0oooo00<0o`3o0?ooo`3o
ool0gP3oool000X0oooo00@000000?ooo`3oool00000103oool3000002/0oooo00<0o`3o0?ooo`3o
ool01@3oool00`3o0?l0oooo0?ooo`3O0?ooo`002P3oool3000000D0oooo00<000000?ooo`3oool0
;03oool00`3o0?l0oooo0?ooo`040?ooo`030?l0o`3oool0oooo0=l0oooo000;0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0;@3oool20?l0o`<0oooo00<0o`3o0?ooo`3oool0h03o
ool000/0oooo0`0000040?ooo`030000003oool0oooo02l0oooo00<0o`3o0?ooo`3o0?l0h`3oool0
0180oooo00<000000?ooo`3oool0<03oool00`3o0?l0oooo0?ooo`3R0?ooo`004P3oool200000?l0
oooo5`3oool00180oooo00<000000?ooo`3oool0o`3ooolF0?ooo`004P3oool00`000000oooo0?oo
o`3o0?oooaH0oooo000B0?ooo`030000003oool0oooo0?l0oooo5P3oool00?l0oooo:`3oool00?l0
oooo:`3oool00?l0oooo:`3oool00?l0oooo:`3oool00?l0oooo:`3oool00?l0oooo:`3oool00?l0
oooo:`3oool00?l0oooo:`3oool00?l0oooo:`3oool00?l0oooo:`3oool00140oooo0P00003o0?oo
oaP0oooo000A0?ooo`800000o`3ooolH0?ooo`00403oool010000000oooo0?ooo`00003o0?oooaL0
oooo000?0?ooo`8000000P3oool200000?l0oooo5P3oool00?l0oooo:`3oool00?l0oooo:`3oool0
0?l0oooo:`3oool00?l0oooo:`3oool00?l0oooo:`3oool00001\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.563, 0}} -> {-0.147101, -8.87036, \
0.0079114, 0.0951959}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.350113 0.00580884 [
[.2619 .33761 -9 -9 ]
[.2619 .33761 9 0 ]
[.5 .33761 -3 -9 ]
[.5 .33761 3 0 ]
[.7381 .33761 -9 -9 ]
[.7381 .33761 9 0 ]
[.97619 .33761 -3 -9 ]
[.97619 .33761 3 0 ]
[1.025 .35011 0 -6.4375 ]
[1.025 .35011 10 6.4375 ]
[.01131 .00158 -18 -4.5 ]
[.01131 .00158 0 4.5 ]
[.01131 .11776 -18 -4.5 ]
[.01131 .11776 0 4.5 ]
[.01131 .23394 -18 -4.5 ]
[.01131 .23394 0 4.5 ]
[.01131 .46629 -12 -4.5 ]
[.01131 .46629 0 4.5 ]
[.01131 .58247 -12 -4.5 ]
[.01131 .58247 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .35011 m
.2619 .35636 L
s
[(0.5)] .2619 .33761 0 1 Mshowa
.5 .35011 m
.5 .35636 L
s
[(1)] .5 .33761 0 1 Mshowa
.7381 .35011 m
.7381 .35636 L
s
[(1.5)] .7381 .33761 0 1 Mshowa
.97619 .35011 m
.97619 .35636 L
s
[(2)] .97619 .33761 0 1 Mshowa
.125 Mabswid
.07143 .35011 m
.07143 .35386 L
s
.11905 .35011 m
.11905 .35386 L
s
.16667 .35011 m
.16667 .35386 L
s
.21429 .35011 m
.21429 .35386 L
s
.30952 .35011 m
.30952 .35386 L
s
.35714 .35011 m
.35714 .35386 L
s
.40476 .35011 m
.40476 .35386 L
s
.45238 .35011 m
.45238 .35386 L
s
.54762 .35011 m
.54762 .35386 L
s
.59524 .35011 m
.59524 .35386 L
s
.64286 .35011 m
.64286 .35386 L
s
.69048 .35011 m
.69048 .35386 L
s
.78571 .35011 m
.78571 .35386 L
s
.83333 .35011 m
.83333 .35386 L
s
.88095 .35011 m
.88095 .35386 L
s
.92857 .35011 m
.92857 .35386 L
s
.25 Mabswid
0 .35011 m
1 .35011 L
s
gsave
1.025 .35011 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .00158 m
.03006 .00158 L
s
[(-60)] .01131 .00158 1 0 Mshowa
.02381 .11776 m
.03006 .11776 L
s
[(-40)] .01131 .11776 1 0 Mshowa
.02381 .23394 m
.03006 .23394 L
s
[(-20)] .01131 .23394 1 0 Mshowa
.02381 .46629 m
.03006 .46629 L
s
[(20)] .01131 .46629 1 0 Mshowa
.02381 .58247 m
.03006 .58247 L
s
[(40)] .01131 .58247 1 0 Mshowa
.125 Mabswid
.02381 .03063 m
.02756 .03063 L
s
.02381 .05967 m
.02756 .05967 L
s
.02381 .08872 m
.02756 .08872 L
s
.02381 .1468 m
.02756 .1468 L
s
.02381 .17585 m
.02756 .17585 L
s
.02381 .20489 m
.02756 .20489 L
s
.02381 .26298 m
.02756 .26298 L
s
.02381 .29202 m
.02756 .29202 L
s
.02381 .32107 m
.02756 .32107 L
s
.02381 .37916 m
.02756 .37916 L
s
.02381 .4082 m
.02756 .4082 L
s
.02381 .43725 m
.02756 .43725 L
s
.02381 .49533 m
.02756 .49533 L
s
.02381 .52438 m
.02756 .52438 L
s
.02381 .55342 m
.02756 .55342 L
s
.02381 .61151 m
.02756 .61151 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .35011 m
.07143 .46031 L
.11905 .49953 L
.16667 .4554 L
.21429 .36093 L
.2619 .17856 L
.30952 .01472 L
.35714 .04683 L
.40476 .23506 L
.45238 .46193 L
.5 .60332 L
.54762 .5947 L
.59524 .28651 L
.64286 .4198 L
.69048 .50077 L
.7381 .36888 L
.78571 .24253 L
.83333 .18766 L
.88095 .22485 L
.92857 .32372 L
.97619 .42494 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.563},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oo`3oool[
0?ooo`00o`3oool[0?ooo`002P3oool3000000@0oooo0P00003o0?oooaP0oooo000:0?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool00000o`3ooolG0?ooo`002P3oool010000000
oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo0`00003o0?oooa00oooo00040?oo
o`@000000P3oool3000000<0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3o
0?oooa00oooo000;0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000103oool0
0`000000oooo0?ooo`3o0?oooa00oooo000;0?ooo`<000000`3oool2000000D0oooo00<000000?oo
o`3oool0o`3oool@0?ooo`00603oool00`000000oooo0?ooo`170?ooo`030000o`3oool0oooo0<D0
oooo000H0?ooo`030000003oool0oooo04L0oooo0`000?o50?ooo`00603oool00`000000oooo0?oo
o`160?ooo`040000o`3oool0oooo0?ooo`80003o``3oool001P0oooo00<000000?ooo`3oool0AP3o
ool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0oooo0<00oooo000H0?ooo`800000A`3oool0
0`000?l0oooo0?ooo`040?ooo`80003o`03oool001P0oooo00<000000?ooo`3oool0AP3oool00`00
0?l0oooo0?ooo`060?ooo`030000o`3oool0oooo0;d0oooo000H0?ooo`030000003oool0oooo04D0
oooo00<0003o0?ooo`3oool0203oool20000okd0oooo000H0?ooo`030000003oool0oooo04D0oooo
00<0003o0?ooo`3oool02P3oool20000ok/0oooo000H0?ooo`030000003oool0oooo04D0oooo00<0
003o0?ooo`3oool0303oool00`000?l0oooo0?ooo`2h0?ooo`00603oool00`000000oooo0?ooo`14
0?ooo`030000o`3oool0oooo00d0oooo00<0003o0?ooo`3oool0^03oool001P0oooo00<000000?oo
o`3oool0A03oool00`000?l0oooo0?ooo`0=0?ooo`030000o`3oool0oooo0;P0oooo000H0?ooo`80
0000A@3oool00`000?l0oooo0?ooo`0>0?ooo`030000o`3oool0oooo0;L0oooo000H0?ooo`030000
003oool0oooo04@0oooo00<0003o0?ooo`3oool03P3oool00`000?l0oooo0?ooo`2g0?ooo`00603o
ool00`000000oooo0?ooo`130?ooo`030000o`3oool0oooo00l0oooo00<0003o0?ooo`3oool0]`3o
ool001P0oooo00<000000?ooo`3oool0@`3oool00`000?l0oooo0?ooo`0?0?ooo`030000o`3oool0
oooo0;L0oooo000H0?ooo`030000003oool0oooo04<0oooo00<0003o0?ooo`3oool0403oool00`00
0?l0oooo0?ooo`2f0?ooo`00603oool00`000000oooo0?ooo`120?ooo`030000o`3oool0oooo0140
oooo00<0003o0?ooo`3oool0]P3oool001P0oooo00<000000?ooo`3oool0@P3oool00`000?l0oooo
0?ooo`0A0?ooo`030000o`3oool0oooo0;H0oooo000H0?ooo`030000003oool0oooo0480oooo00<0
003o0?ooo`3oool04@3oool00`000?l0oooo0?ooo`2f0?ooo`00603oool2000004<0oooo00<0003o
0?ooo`3oool04P3oool00`000?l0oooo0?ooo`2e0?ooo`00603oool00`000000oooo0?ooo`110?oo
o`030000o`3oool0oooo01<0oooo00<0003o0?ooo`3oool0]@3oool001P0oooo00<000000?ooo`3o
ool0@@3oool00`000?l0oooo0?ooo`0C0?ooo`030000o`3oool0oooo0;D0oooo000H0?ooo`030000
003oool0oooo0440oooo00<0003o0?ooo`3oool04`3oool00`000?l0oooo0?ooo`2e0?ooo`00603o
ool00`000000oooo0?ooo`100?ooo`030000o`3oool0oooo01D0oooo00<0003o0?ooo`3oool0]03o
ool001P0oooo00<000000?ooo`3oool0@03oool00`000?l0oooo0?ooo`0E0?ooo`030000o`3oool0
oooo0;@0oooo000<0?ooo`<000000P3oool2000000D0oooo00<000000?ooo`3oool0@03oool00`00
0?l0oooo0?ooo`0E0?ooo`030000o`3oool0oooo0;@0oooo000=0?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`100?ooo`030000o`3oool0oooo
01D0oooo00<0003o0?ooo`3oool0]03oool000X0oooo1@0000001@3oool000000?ooo`3oool00000
00@0oooo0`00000o0?ooo`030000o`3oool0oooo01L0oooo00<0003o0?ooo`3oool0/`3oool000@0
oooo100000020?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool0
0`000000oooo0?ooo`0o0?ooo`030000o`3oool0oooo01L0oooo00<0003o0?ooo`3oool0/`3oool0
00/0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo03l0oooo00<0003o0?ooo`3oool05`3oool00`000?l0oooo0?ooo`2c0?ooo`00303oool20000
00<0oooo0P0000050?ooo`030000003oool0oooo03h0oooo00<0003o0?ooo`3oool0603oool00`00
0?l0oooo0?ooo`2c0?ooo`00603oool00`000000oooo0?ooo`0n0?ooo`030000o`3oool0oooo01T0
oooo00<0003o0?ooo`3oool0/P3oool001P0oooo00<000000?ooo`3oool0?P3oool00`000?l0oooo
0?ooo`0I0?ooo`030000o`3oool0oooo0;80oooo000H0?ooo`030000003oool0oooo03h0oooo00<0
003o0?ooo`3oool06@3oool00`000?l0oooo0?ooo`2b0?ooo`00603oool2000003h0oooo00<0003o
0?ooo`3oool06P3oool00`000?l0oooo0?ooo`2b0?ooo`00603oool00`000000oooo0?ooo`0m0?oo
o`030000o`3oool0oooo01/0oooo00<0003o0?ooo`3oool0/@3oool001P0oooo00<000000?ooo`3o
ool0?@3oool00`000?l0oooo0?ooo`0K0?ooo`030000o`3oool0oooo0;40oooo000H0?ooo`030000
003oool0oooo03`0oooo00<0003o0?ooo`3oool0703oool00`000?l0oooo0?ooo`2a0?ooo`00603o
ool00`000000oooo0?ooo`0l0?ooo`030000o`3oool0oooo01`0oooo00<0003o0?ooo`3oool0/@3o
ool001P0oooo00<000000?ooo`3oool0?03oool00`000?l0oooo0?ooo`0M0?ooo`030000o`3oool0
oooo0;00oooo000H0?ooo`030000003oool0oooo03`0oooo00<0003o0?ooo`3oool07@3oool00`00
0?l0oooo0?ooo`2`0?ooo`00603oool00`000000oooo0?ooo`0k0?ooo`030000o`3oool0oooo01h0
oooo00<0003o0?ooo`3oool0/03oool001P0oooo0P00000l0?ooo`030000o`3oool0oooo01h0oooo
00<0003o0?ooo`3oool0/03oool001P0oooo00<000000?ooo`3oool0>`3oool00`000?l0oooo0?oo
o`0O0?ooo`030000o`3oool0oooo0:l0oooo000H0?ooo`030000003oool0oooo03X0oooo00<0003o
0?ooo`3oool0803oool00`000?l0oooo0?ooo`2_0?ooo`00603oool00`000000oooo0?ooo`0j0?oo
o`030000o`3oool0oooo0200oooo00<0003o0?ooo`3oool0K`3oool00`000?l0oooo0?ooo`0m0?oo
o`00603oool00`000000oooo0?ooo`0j0?ooo`030000o`3oool0oooo0200oooo00<0003o0?ooo`3o
ool0KP3oool00`000?l0oooo0000o`0n0?ooo`00603oool00`000000oooo0?ooo`0j0?ooo`030000
o`3oool0oooo0240oooo00<0003o0?ooo`3oool0K03oool010000?l0oooo0?ooo`3oool20000oc`0
oooo000H0?ooo`030000003oool0oooo03T0oooo00<0003o0?ooo`3oool08P3oool00`000?l0oooo
0?ooo`1[0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool0>@3oool001P0oooo0P00
000j0?ooo`030000o`3oool0oooo0280oooo00<0003o0?ooo`3oool0J`3oool00`000?l0oooo0?oo
o`050?ooo`030000o`3oool0oooo03P0oooo000H0?ooo`030000003oool0oooo03T0oooo00<0003o
0?ooo`3oool08P3oool00`000?l0oooo0?ooo`1Z0?ooo`030000o`3oool0oooo00L0oooo0P000?lh
0?ooo`00603oool00`000000oooo0?ooo`0i0?ooo`030000o`3oool0oooo02<0oooo00<0003o0?oo
o`3oool0J03oool00`000?l0oooo0?ooo`0:0?ooo`030000o`3oool0oooo03D0oooo000H0?ooo`03
0000003oool0oooo03P0oooo00<0003o0?ooo`3oool0903oool00`000?l0oooo0?ooo`1W0?ooo`03
0000o`3oool0oooo00`0oooo00<0003o0?ooo`3oool0=03oool001P0oooo00<000000?ooo`3oool0
>03oool00`000?l0oooo0?ooo`0T0?ooo`030000o`3oool0oooo06H0oooo00<0003o0?ooo`3oool0
3P3oool20000oc@0oooo000H0?ooo`030000003oool0oooo03P0oooo00<0003o0?ooo`3oool0903o
ool00`000?l0oooo0?ooo`1U0?ooo`030000o`3oool0oooo0140oooo00<0003o0?ooo`3oool0<@3o
ool000X0oooo100000030?ooo`8000001@3oool00`000000oooo0?ooo`0h0?ooo`030000o`3oool0
oooo02D0oooo00<0003o0?ooo`3oool0H`3oool00`000?l0oooo0?ooo`0B0?ooo`030000o`3oool0
oooo0340oooo000:0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000103oool0
0`000000oooo0?ooo`0g0?ooo`030000o`3oool0oooo02H0oooo00<0003o0?ooo`3oool0H`3oool0
0`000?l0oooo0?ooo`0C0?ooo`030000o`3oool0oooo0300oooo000;0?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool00000103oool3000003L0oooo00<0003o0?ooo`3oool09P3oool0
0`000?l0oooo0?ooo`1R0?ooo`030000o`3oool0oooo01@0oooo00<0003o0?ooo`3oool0<03oool0
00@0oooo100000040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo03L0oooo00<0003o0?ooo`3oool09P3oool00`000?l0oooo0?ooo`1Q
0?ooo`030000o`3oool0oooo01H0oooo00<0003o0?ooo`3oool0;`3oool000X0oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo03L0oooo00<0
003o0?ooo`3oool09P3oool00`000?l0oooo0?ooo`1P0?ooo`030000o`3oool0oooo01L0oooo00<0
003o0?ooo`3oool0;`3oool000/0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`0f
0?ooo`030000o`3oool0oooo02P0oooo00<0003o0?ooo`3oool0G`3oool00`000?l0oooo0?ooo`0H
0?ooo`030000o`3oool0oooo02h0oooo000H0?ooo`030000003oool0oooo03H0oooo00<0003o0?oo
o`3oool0:03oool00`000?l0oooo0?ooo`1N0?ooo`030000o`3oool0oooo01T0oooo00<0003o0?oo
o`3oool0;P3oool001P0oooo00<000000?ooo`3oool0=P3oool00`000?l0oooo0?ooo`0X0?ooo`03
0000o`3oool0oooo05h0oooo00<0003o0?ooo`3oool06P3oool00`000?l0oooo0?ooo`0]0?ooo`00
603oool00`000000oooo0?ooo`0f0?ooo`030000o`3oool0oooo02P0oooo00<0003o0?ooo`3oool0
G@3oool00`000?l0oooo0?ooo`0K0?ooo`030000o`3oool0oooo02d0oooo000H0?ooo`800000=P3o
ool00`000?l0oooo0?ooo`0Y0?ooo`030000o`3oool0oooo05d0oooo00<0003o0?ooo`3oool0703o
ool00`000?l0oooo0?ooo`0/0?ooo`00603oool00`000000oooo0?ooo`0e0?ooo`030000o`3oool0
oooo02X0oooo00<0003o0?ooo`3oool0G03oool00`000?l0oooo0?ooo`0L0?ooo`030000o`3oool0
oooo02`0oooo000H0?ooo`030000003oool0oooo03D0oooo00<0003o0?ooo`3oool0:P3oool00`00
0?l0oooo0?ooo`1K0?ooo`030000o`3oool0oooo01h0oooo00<0003o0?ooo`3oool0:`3oool001P0
oooo00<000000?ooo`3oool0=@3oool00`000?l0oooo0?ooo`0Z0?ooo`030000o`3oool0oooo05/0
oooo00<0003o0?ooo`3oool07P3oool00`000?l0oooo0?ooo`0[0?ooo`00603oool00`000000oooo
0?ooo`0d0?ooo`030000o`3oool0oooo02/0oooo00<0003o0?ooo`3oool0FP3oool00`000?l0oooo
0?ooo`0P0?ooo`030000o`3oool0oooo02X0oooo000H0?ooo`030000003oool0oooo03@0oooo00<0
003o0?ooo`3oool0:`3oool00`000?l0oooo0?ooo`1J0?ooo`030000o`3oool0oooo0200oooo00<0
003o0?ooo`3oool0:P3oool001P0oooo00<000000?ooo`3oool0=03oool00`000?l0oooo0?ooo`0/
0?ooo`030000o`3oool0oooo02/0oooo00<0003o0?ooo`3oool0:`3oool00`000?l0oooo0?ooo`0Q
0?ooo`030000o`3oool0oooo02T0oooo000H0?ooo`030000003oool0oooo03@0oooo00<0003o0?oo
o`3oool0;03oool00`000?l0oooo0?ooo`0[0?ooo`030000o`3oool0oooo02X0oooo00<0003o0?oo
o`3oool08P3oool00`000?l0oooo0?ooo`0Y0?ooo`00603oool2000003@0oooo00<0003o0?ooo`3o
ool0;@3oool00`000?l0oooo0?ooo`0[0?ooo`80003o:`3oool00`000?l0oooo0?ooo`0S0?ooo`03
0000o`3oool0oooo02P0oooo000H0?ooo`030000003oool0oooo03<0oooo00<0003o0?ooo`3oool0
;@3oool00`000?l0oooo0?ooo`0[0?ooo`80003o:P3oool00`000?l0oooo0?ooo`0T0?ooo`030000
o`3oool0oooo02P0oooo000H0?ooo`030000003oool0oooo03<0oooo00<0003o0?ooo`3oool0;@3o
ool00`000?l0oooo0?ooo`0Z0?ooo`030000o`3oool0003o02X0oooo00<0003o0?ooo`3oool09@3o
ool00`000?l0oooo0?ooo`0W0?ooo`00603oool00`000000oooo0?ooo`0c0?ooo`030000o`000000
000000@0oooo0P0000040?ooo`8000008P3oool00`000?l0oooo0?ooo`0@0?ooo`D00000503oool0
10000?l0oooo0?ooo`000?lJ0?ooo`D000000P3oool2000000@0oooo0P0000000`000?l0oooo0?oo
o`0U0?ooo`030000o`3oool0oooo00X0oooo1000000I0?ooo`00603oool00`000000oooo0?ooo`0b
0?ooo`050000o`000000oooo0?ooo`000000203oool010000000oooo0?ooo`00000Q0?ooo`030000
o`3oool0oooo0180oooo00<000000?ooo`3oool0503oool010000?l0oooo0?ooo`000?lL0?ooo`03
0000003oool0oooo00L0oooo00@000000?ooo`000?l00000:03oool00`000?l0oooo0?ooo`090?oo
o`030000003oool0oooo01X0oooo000H0?ooo`030000003oool0oooo0380oooo00D0003o0000003o
ool0oooo0000000;0?ooo`030000003oool0oooo01l0oooo00<0003o0?ooo`3oool04P3oool00`00
0000oooo0?ooo`0D0?ooo`050000o`3oool0oooo0?ooo`000?l06`3oool00`000000oooo0?ooo`09
0?ooo`030000o`000000oooo02L0oooo00<0003o0?ooo`3oool02P3oool00`000000oooo0?ooo`0I
0?ooo`00603oool00`000000oooo0?ooo`0b0?ooo`050000o`000000oooo0?ooo`0000002@3oool2
00000280oooo00<0003o0?ooo`3oool04P3oool00`000000oooo0?ooo`0D0?ooo`050000o`3oool0
oooo0?ooo`000?l06`3oool00`000000oooo0?ooo`080?ooo`03000000000?l0oooo02T0oooo00<0
003o0?ooo`3oool02P3oool00`000000oooo0?ooo`0H0?ooo`00603oool2000003<0oooo00D0003o
0000003oool0oooo000000090?ooo`030000003oool0oooo0240oooo00<0003o0?ooo`3oool04P3o
ool00`000000oooo0?ooo`0D0?ooo`050000o`3oool0oooo0?ooo`000?l06`3oool00`000000oooo
0?ooo`080?ooo`030000o`3oool0oooo02T0oooo00<0003o0?ooo`3oool0203oool010000000oooo
0?ooo`00000I0?ooo`00603oool00`000000oooo0?ooo`0a0?ooo`030000o`3oool0oooo00800000
2P3oool300000280oooo00<0003o0?ooo`3oool0403oool2000001D0oooo00<0003o0?ooo`3oool0
0`3oool00`000?l0oooo0?ooo`0G0?ooo`8000002P3oool00`000?l000000000000Z0?ooo`030000
o`3oool0oooo00P0oooo0P00000J0?ooo`00603oool00`000000oooo0?ooo`0a0?ooo`030000o`3o
ool0oooo0340oooo00<0003o0?ooo`3oool09`3oool00`000?l0oooo0?ooo`030?ooo`030000o`3o
ool0oooo0280oooo00<0003o0?ooo`3oool0:`3oool00`000?l0oooo0?ooo`0T0?ooo`00603oool0
0`000000oooo0?ooo`0a0?ooo`030000o`3oool0oooo0340oooo00<0003o0?ooo`3oool09`3oool0
0`000?l0oooo0?ooo`030?ooo`030000o`3oool0oooo0280oooo00<0003o0?ooo`3oool0;03oool0
0`000?l0oooo0?ooo`0S0?ooo`00603oool00`000000oooo0?ooo`0a0?ooo`030000o`3oool0oooo
0340oooo00<0003o0?ooo`3oool09`3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo
0240oooo00<0003o0?ooo`3oool0;03oool00`000?l0oooo0?ooo`0S0?ooo`00603oool00`000000
oooo0?ooo`0`0?ooo`030000o`3oool0oooo0380oooo00<0003o0?ooo`3oool09`3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo0200oooo00<0003o0?ooo`3oool0;P3oool00`000?l0
oooo0?ooo`0R0?ooo`00603oool00`000000oooo0?ooo`0`0?ooo`030000o`3oool0oooo03<0oooo
00<0003o0?ooo`3oool09P3oool00`000?l0oooo0?ooo`050?ooo`030000o`3oool0oooo01l0oooo
00<0003o0?ooo`3oool0;P3oool00`000?l0oooo0?ooo`0H0?ooo`800000203oool001P0oooo00<0
00000?ooo`3oool0<03oool00`000?l0oooo0?ooo`0c0?ooo`030000o`3oool0oooo02H0oooo00<0
003o0?ooo`3oool01@3oool00`000?l0oooo0?ooo`0N0?ooo`030000o`3oool0oooo0300oooo00<0
003o0?ooo`3oool05P3oool010000000oooo0?ooo`0000070?ooo`004P3oool6000000030000o`00
000000000300000000<0003o000000000000<`0000000`000?l000000000000U000000030000o`00
0000000000H0000000<0003o0000000000007P0000000`000?l000000000000`000000030000o`00
0000000000d000002@3oool00`000000oooo0?ooo`080?ooo`00603oool00`000?l0oooo0?ooo`0:
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:
0?ooo`030000o`3oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00`3oool00`000?l0oooo0?ooo`03
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`06
0?ooo`040000o`3oool0oooo000000H0oooo00<0003o0?ooo`3oool00`3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`000?l02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool01@000000oooo0?oo
o`3oool0003o00L0oooo00<000000?ooo`3oool0303oool5000000L0oooo000H0?ooo`0300000000
0?l0oooo02l0oooo00<0003o0?ooo`3oool0=@3oool00`000?l0oooo0?ooo`0T0?ooo`030000o`3o
ool0oooo00L0oooo00<0003o0?ooo`3oool0703oool00`000?l0oooo0?ooo`0b0?ooo`030000o`3o
ool0oooo01D0oooo00<000000?ooo`3oool0203oool001P0oooo00<000000000o`3oool0;`3oool0
0`000?l0oooo0?ooo`0e0?ooo`030000o`3oool0oooo02@0oooo00<0003o0?ooo`3oool01`3oool0
0`000?l0oooo0?ooo`0L0?ooo`030000o`3oool0oooo03<0oooo00<0003o0?ooo`3oool07`3oool0
01P0oooo00<000000?ooo`000?l0;P3oool00`000?l0oooo0?ooo`0f0?ooo`030000o`3oool0oooo
02@0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`0J0?ooo`030000o`3oool0oooo
03@0oooo00<0003o0?ooo`3oool07`3oool001P0oooo00<000000?ooo`000?l0;P3oool00`000?l0
oooo0?ooo`0f0?ooo`030000o`3oool0oooo02@0oooo00<0003o0?ooo`3oool0203oool00`000?l0
oooo0?ooo`0J0?ooo`030000o`3oool0oooo03D0oooo00<0003o0?ooo`3oool07P3oool001P0oooo
00@000000?ooo`3oool0003o;03oool00`000?l0oooo0?ooo`0g0?ooo`030000o`3oool0oooo02@0
oooo00<0003o0?ooo`3oool02@3oool00`000?l0oooo0?ooo`0I0?ooo`030000o`3oool0oooo03D0
oooo00<0003o0?ooo`3oool07P3oool001P0oooo0P0000000`3oool0003o0?ooo`0[0?ooo`030000
o`3oool0oooo03P0oooo00<0003o0?ooo`3oool08P3oool00`000?l0oooo0?ooo`0:0?ooo`030000
o`3oool0oooo01P0oooo00<0003o0?ooo`3oool0=P3oool00`000?l0oooo0?ooo`0N0?ooo`00603o
ool01@000000oooo0?ooo`3oool0003o02X0oooo00<0003o0?ooo`3oool0>@3oool00`000?l0oooo
0?ooo`0R0?ooo`030000o`3oool0oooo00X0oooo00<0003o0?ooo`3oool0603oool00`000?l0oooo
0?ooo`0g0?ooo`030000o`3oool0oooo01d0oooo000H0?ooo`050000003oool0oooo0?ooo`000?l0
:P3oool00`000?l0oooo0?ooo`0i0?ooo`030000o`3oool0oooo0280oooo00<0003o0?ooo`3oool0
2`3oool00`000?l0oooo0?ooo`0G0?ooo`030000o`3oool0oooo03L0oooo00<0003o0?ooo`3oool0
7@3oool001P0oooo00<000000?ooo`3oool00P3oool00`000?l0oooo0?ooo`0V0?ooo`030000o`3o
ool0oooo03X0oooo00<0003o0?ooo`3oool08P3oool00`000?l0oooo0?ooo`0;0?ooo`030000o`3o
ool0oooo01H0oooo00<0003o0?ooo`3oool0>@3oool00`000?l0oooo0?ooo`0L0?ooo`00603oool0
0`000000oooo0?ooo`020?ooo`030000o`3oool0oooo02H0oooo00<0003o0?ooo`3oool0>P3oool0
0`000?l0oooo0?ooo`0R0?ooo`030000o`3oool0oooo00/0oooo00<0003o0?ooo`3oool05P3oool0
0`000?l0oooo0?ooo`0i0?ooo`030000o`3oool0oooo01`0oooo000H0?ooo`030000003oool0oooo
00<0oooo00<0003o0?ooo`3oool0903oool00`000?l0oooo0?ooo`0l0?ooo`030000o`3oool0oooo
0240oooo00<0003o0?ooo`3oool0303oool00`000?l0oooo0?ooo`0E0?ooo`030000o`3oool0oooo
03X0oooo00<0003o0?ooo`3oool06`3oool001P0oooo00<000000?ooo`3oool00`3oool00`000?l0
oooo0?ooo`0T0?ooo`030000o`3oool0oooo03`0oooo00<0003o0?ooo`3oool0803oool00`000?l0
oooo0?ooo`0=0?ooo`030000o`3oool0oooo01@0oooo00<0003o0?ooo`3oool0>`3oool00`000?l0
oooo0?ooo`0K0?ooo`00603oool00`000000oooo0?ooo`030?ooo`030000o`3oool0oooo02<0oooo
00<0003o0?ooo`3oool0?@3oool00`000?l0oooo0?ooo`0P0?ooo`030000o`3oool0oooo00h0oooo
00<0003o0?ooo`3oool04`3oool00`000?l0oooo0?ooo`0l0?ooo`030000o`3oool0oooo01X0oooo
000H0?ooo`8000001@3oool00`000?l0oooo0?ooo`0Q0?ooo`030000o`3oool0oooo03h0oooo00<0
003o0?ooo`3oool0803oool00`000?l0oooo0?ooo`0>0?ooo`030000o`3oool0oooo0180oooo00<0
003o0?ooo`3oool0?@3oool00`000?l0oooo0?ooo`0J0?ooo`00603oool00`000000oooo0?ooo`04
0?ooo`030000o`3oool0oooo0240oooo00<0003o0?ooo`3oool0?P3oool00`000?l0oooo0?ooo`0P
0?ooo`030000o`3oool0oooo00h0oooo00<0003o0?ooo`3oool04P3oool00`000?l0oooo0?ooo`0n
0?ooo`030000o`3oool0oooo01T0oooo000H0?ooo`030000003oool0oooo00D0oooo00<0003o0?oo
o`3oool07`3oool00`000?l0oooo0?ooo`100?ooo`030000o`3oool0oooo01l0oooo00<0003o0?oo
o`3oool03`3oool00`000?l0oooo0?ooo`0A0?ooo`030000o`3oool0oooo03h0oooo00<0003o0?oo
o`3oool06@3oool001P0oooo00<000000?ooo`3oool01@3oool00`000?l0oooo0?ooo`0O0?ooo`03
0000o`3oool0oooo0400oooo00<0003o0?ooo`3oool07`3oool00`000?l0oooo0?ooo`0?0?ooo`03
0000o`3oool0oooo0100oooo00<0003o0?ooo`3oool0@03oool00`000?l0oooo0?ooo`0H0?ooo`00
603oool00`000000oooo0?ooo`060?ooo`030000o`3oool0oooo01d0oooo00<0003o0?ooo`3oool0
@@3oool00`000?l0oooo0?ooo`0O0?ooo`030000o`3oool0oooo0100oooo00<0003o0?ooo`3oool0
3`3oool00`000?l0oooo0?ooo`100?ooo`030000o`3oool0oooo01P0oooo000H0?ooo`030000003o
ool0oooo00H0oooo00<0003o0?ooo`3oool07@3oool00`000?l0oooo0?ooo`110?ooo`030000o`3o
ool0oooo01h0oooo00<0003o0?ooo`3oool04@3oool00`000?l0oooo0?ooo`0?0?ooo`030000o`3o
ool0oooo05/0oooo000H0?ooo`030000003oool0oooo00L0oooo00<0003o0?ooo`3oool06`3oool0
0`000?l0oooo0?ooo`120?ooo`030000o`3oool0oooo01h0oooo00<0003o0?ooo`3oool04P3oool0
0`000?l0oooo0?ooo`0=0?ooo`030000o`3oool0oooo05`0oooo000H0?ooo`800000203oool00`00
0?l0oooo0?ooo`0K0?ooo`030000o`3oool0oooo04<0oooo00<0003o0?ooo`3oool07@3oool00`00
0?l0oooo0?ooo`0B0?ooo`030000o`3oool0oooo00d0oooo00<0003o0?ooo`3oool0G03oool001P0
oooo00<000000?ooo`3oool0203oool00`000?l0oooo0?ooo`0I0?ooo`030000o`3oool0oooo04@0
oooo00<0003o0?ooo`3oool07@3oool00`000?l0oooo0?ooo`0C0?ooo`030000o`3oool0oooo00`0
oooo00<0003o0?ooo`3oool0G03oool001P0oooo00<000000?ooo`3oool0203oool00`000?l0oooo
0?ooo`0I0?ooo`030000o`3oool0oooo04@0oooo00<0003o0?ooo`3oool07@3oool00`000?l0oooo
0?ooo`0C0?ooo`030000o`3oool0oooo00/0oooo00<0003o0?ooo`3oool0G@3oool001P0oooo00<0
00000?ooo`3oool02@3oool00`000?l0oooo0?ooo`0G0?ooo`030000o`3oool0oooo04D0oooo00<0
003o0?ooo`3oool07@3oool00`000?l0oooo0?ooo`0D0?ooo`030000o`3oool0oooo00X0oooo00<0
003o0?ooo`3oool0G@3oool001P0oooo00<000000?ooo`3oool02@3oool00`000?l0oooo0?ooo`0G
0?ooo`030000o`3oool0oooo04D0oooo00<0003o0?ooo`3oool07@3oool00`000?l0oooo0?ooo`0E
0?ooo`030000o`3oool0oooo00T0oooo00<0003o0?ooo`3oool0G@3oool001P0oooo00<000000?oo
o`3oool02P3oool00`000?l0oooo0?ooo`0E0?ooo`030000o`3oool0oooo04L0oooo00<0003o0?oo
o`3oool06`3oool00`000?l0oooo0?ooo`0F0?ooo`030000o`3oool0oooo00P0oooo00<0003o0?oo
o`3oool0GP3oool000X0oooo100000030?ooo`8000001@3oool00`000000oooo0?ooo`0:0?ooo`03
0000o`3oool0oooo01@0oooo00<0003o0?ooo`3oool0B03oool00`000?l0oooo0?ooo`0K0?ooo`03
0000o`3oool0oooo01L0oooo00<0003o0?ooo`3oool01`3oool00`000?l0oooo0?ooo`1N0?ooo`00
2P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool02`3oool00`000?l0oooo0?ooo`0B0?ooo`030000o`3oool0oooo04T0oooo00<0003o0?ooo`3o
ool06`3oool00`000?l0oooo0?ooo`0G0?ooo`030000o`3oool0oooo00L0oooo00<0003o0?ooo`3o
ool0GP3oool000/0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000040?ooo`<0
0000303oool00`000?l0oooo0?ooo`0@0?ooo`030000o`3oool0oooo04X0oooo00<0003o0?ooo`3o
ool06`3oool00`000?l0oooo0?ooo`0H0?ooo`030000o`3oool0oooo00D0oooo00<0003o0?ooo`3o
ool0G`3oool000`0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool03@3oool20000o`l0oooo00<0003o0?ooo`3oool0C03oool00`000?l0
oooo0?ooo`0J0?ooo`030000o`3oool0oooo01P0oooo00<0003o0?ooo`3oool01@3oool00`000?l0
oooo0?ooo`1O0?ooo`002P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
00@0oooo00<000000?ooo`3oool03`3oool00`000?l0oooo0?ooo`0;0?ooo`030000o`3oool0oooo
04d0oooo00<0003o0?ooo`3oool06P3oool00`000?l0oooo0?ooo`0I0?ooo`030000o`3oool0oooo
00<0oooo00<0003o0?ooo`3oool0H03oool000/0oooo0P0000040?ooo`8000001@3oool00`000000
oooo0?ooo`0@0?ooo`030000o`3oool0oooo00P0oooo0P000?m@0?ooo`030000o`3oool0oooo01T0
oooo00<0003o0?ooo`3oool06`3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0oooo0600
oooo000H0?ooo`030000003oool0oooo0140oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo
0?ooo`1A0?ooo`030000o`3oool0oooo01P0oooo00<0003o0?ooo`3oool06`3oool00`000?l0oooo
0?ooo`020?ooo`030000o`3oool0oooo0600oooo000H0?ooo`030000003oool0oooo0180oooo00<0
003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`1B0?ooo`030000o`3oool0oooo01P0oooo00<0
003o0?ooo`3oool0703oool010000?l0oooo0?ooo`000?mS0?ooo`00603oool00`000000oooo0?oo
o`0C0?ooo`80003o0`3oool00`000?l0oooo0?ooo`1D0?ooo`030000o`3oool0oooo01L0oooo00<0
003o0?ooo`3oool0703oool010000?l0oooo0?ooo`000?mS0?ooo`00603oool2000001H0oooo00<0
003o0?ooo`000?l0E`3oool00`000?l0oooo0?ooo`0G0?ooo`030000o`3oool0oooo01d0oooo00<0
003o0?ooo`000?l0H`3oool001P0oooo00<000000?ooo`3oool05P3oool00`000?l0oooo0?ooo`1F
0?ooo`030000o`3oool0oooo01L0oooo00<0003o0?ooo`3oool07@3oool20000of@0oooo000H0?oo
o`030000003oool0oooo0700oooo00<0003o0?ooo`3oool05P3oool00`000?l0oooo0?ooo`0N0?oo
o`030000o`3oool0oooo0680oooo000H0?ooo`030000003oool0oooo0700oooo00<0003o0?ooo`3o
ool05@3oool00`000?l0oooo0?ooo`240?ooo`00603oool00`000000oooo0?ooo`1`0?ooo`030000
o`3oool0oooo01D0oooo00<0003o0?ooo`3oool0Q03oool001P0oooo00<000000?ooo`3oool0L@3o
ool00`000?l0oooo0?ooo`0D0?ooo`030000o`3oool0oooo08@0oooo000H0?ooo`030000003oool0
oooo0740oooo00<0003o0?ooo`3oool0503oool00`000?l0oooo0?ooo`240?ooo`00603oool00`00
0000oooo0?ooo`1a0?ooo`030000o`3oool0oooo01@0oooo00<0003o0?ooo`3oool0Q03oool001P0
oooo0P00001c0?ooo`030000o`3oool0oooo01<0oooo00<0003o0?ooo`3oool0Q03oool001P0oooo
00<000000?ooo`3oool0LP3oool00`000?l0oooo0?ooo`0C0?ooo`030000o`3oool0oooo08@0oooo
000H0?ooo`030000003oool0oooo0780oooo00<0003o0?ooo`3oool04P3oool00`000?l0oooo0?oo
o`250?ooo`00603oool00`000000oooo0?ooo`1c0?ooo`030000o`3oool0oooo0140oooo00<0003o
0?ooo`3oool0Q@3oool001P0oooo00<000000?ooo`3oool0L`3oool00`000?l0oooo0?ooo`0A0?oo
o`030000o`3oool0oooo08D0oooo000H0?ooo`030000003oool0oooo07@0oooo00<0003o0?ooo`3o
ool0403oool00`000?l0oooo0?ooo`250?ooo`00603oool00`000000oooo0?ooo`1d0?ooo`030000
o`3oool0oooo0100oooo00<0003o0?ooo`3oool0Q@3oool001P0oooo0P00001e0?ooo`030000o`3o
ool0oooo0100oooo00<0003o0?ooo`3oool0Q@3oool001P0oooo00<000000?ooo`3oool0M@3oool0
0`000?l0oooo0?ooo`0>0?ooo`030000o`3oool0oooo08H0oooo000H0?ooo`030000003oool0oooo
07D0oooo00<0003o0?ooo`3oool03P3oool00`000?l0oooo0?ooo`260?ooo`00603oool00`000000
oooo0?ooo`1e0?ooo`030000o`3oool0oooo00h0oooo00<0003o0?ooo`3oool0QP3oool001P0oooo
00<000000?ooo`3oool0MP3oool00`000?l0oooo0?ooo`0=0?ooo`030000o`3oool0oooo08H0oooo
000H0?ooo`030000003oool0oooo07H0oooo00<0003o0?ooo`3oool03@3oool00`000?l0oooo0?oo
o`260?ooo`00303oool300000080oooo0P0000050?ooo`030000003oool0oooo07H0oooo00<0003o
0?ooo`3oool03@3oool00`000?l0oooo0?ooo`260?ooo`003@3oool010000000oooo0?ooo`000002
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0M`3oool00`000?l0oooo0?ooo`0<
0?ooo`030000o`3oool0oooo08H0oooo000:0?ooo`D0000000D0oooo0000003oool0oooo00000004
0?ooo`<00000M`3oool00`000?l0oooo0?ooo`0;0?ooo`030000o`3oool0oooo08L0oooo000:0?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?oo
o`1h0?ooo`030000o`3oool0oooo00X0oooo00<0003o0?ooo`3oool0Q`3oool000/0oooo00<00000
0?ooo`0000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo07P0oooo00<0
003o0?ooo`3oool02P3oool00`000?l0oooo0?ooo`270?ooo`00303oool2000000<0oooo0P000005
0?ooo`030000003oool0oooo07P0oooo00<0003o0?ooo`3oool0203oool30000ohT0oooo000H0?oo
o`030000003oool0oooo07T0oooo00@0003o0?ooo`3oool0oooo1P000?n<0?ooo`00603oool00`00
0000oooo0?ooo`1i0?ooo`@0003oTP3oool001P0oooo00<000000?ooo`3oool0o`3oool@0?ooo`00
603oool200000?l0oooo4@3oool001P0oooo00<000000?ooo`3oool0o`3oool@0?ooo`00603oool0
0`000000oooo0?ooo`3o0?oooa00oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo
003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo
003o0?ooob/0oooo003o0?ooob/0oooo000F0?ooo`D00000o`3oool@0?ooo`005P3oool400000?l0
oooo4@3oool001T0oooo00<000000?ooo`3oool0o`3oool?0?ooo`005`3oool300000?l0oooo4@3o
ool00?l0oooo:`3oool00?l0oooo:`3oool00?l0oooo:`3oool00?l0oooo:`3oool00?l0oooo:`3o
ool00001\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.563, 0}} -> {-0.20052, -62.9911, \
0.00810566, 0.664476}}],

Cell[BoxData[
    InterpretationBox[\("t"\[InvisibleSpace]"      "\[InvisibleSpace]"   u"\
\[InvisibleSpace]"          v"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]" \
        a"\),
      SequenceForm[ "t", "      ", "   u", "          v", "", "         a"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("------------------------------------"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        InterpretationBox[GridBox[{
              {"0"},
              {"0.1`"},
              {"0.2`"},
              {"0.30000000000000004`"},
              {"0.4`"},
              {"0.5`"},
              {"0.6000000000000001`"},
              {"0.7000000000000001`"},
              {"0.8`"},
              {"0.9`"},
              {"1.`"},
              {"1.1`"},
              {"1.2000000000000002`"},
              {"1.3`"},
              {"1.4000000000000001`"},
              {"1.5`"},
              {"1.6`"},
              {"1.7000000000000002`"},
              {"1.8`"},
              {"1.9000000000000001`"},
              {"2.`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0, 1.1000000000000001, 
            1.2000000000000002, 1.3, 1.4000000000000001, 1.5, 
            1.6000000000000001, 1.7000000000000002, 1.8, 1.9000000000000001, 
            2.0}]], "\[InvisibleSpace]", "\<\"     \"\>", "\[InvisibleSpace]",
         
        InterpretationBox[GridBox[{
              {"0"},
              {"0.03161730415056159`"},
              {"0.23257398333758056`"},
              {"0.6668370106940812`"},
              {"1.2679072752834746`"},
              {"1.8623791096077174`"},
              {"2.1668398322461417`"},
              {"1.9501333531920106`"},
              {"1.2561125602037242`"},
              {"0.37511287065320453`"},
              {\(-0.3379217616028356`\)},
              {\(-0.6580999497342547`\)},
              {\(-0.6431720784994365`\)},
              {\(-0.6110738521838194`\)},
              {\(-0.47402522673472913`\)},
              {\(-0.1386968125778037`\)},
              {"0.23052670496729427`"},
              {"0.4350489102372417`"},
              {"0.38632028458154677`"},
              {"0.13964590605032376`"},
              {\(-0.15179218348093967`\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .03161730415056159, .23257398333758056, .66683701069408119, 
            1.2679072752834746, 1.8623791096077174, 2.1668398322461417, 
            1.9501333531920106, 
            1.2561125602037242, .37511287065320453, -.3379217616028356, \
-.65809994973425467, -.64317207849943647, -.61107385218381938, \
-.47402522673472913, -.1386968125778037, .23052670496729427, \
.43504891023724168, .38632028458154677, .13964590605032376, \
-.15179218348093967}]], "\[InvisibleSpace]", "\<\"   \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"0.9485191245168477`"},
              {"3.183143002060026`"},
              {"5.375500063548635`"},
              {"6.374855502122253`"},
              {"4.991340895371431`"},
              {"0.6277576252720225`"},
              {\(-4.869744088930728`\)},
              {\(-8.470599430821636`\)},
              {\(-8.498472663946915`\)},
              {\(-5.356539567587506`\)},
              {\(-1.0717536773268286`\)},
              {"0.4860447699968038`"},
              {"0.5383575238526732`"},
              {"2.434930687533725`"},
              {"3.893230914192898`"},
              {"3.1287036067553884`"},
              {"0.804326343236911`"},
              {\(-1.6722015912754573`\)},
              {\(-2.9776101037426193`\)},
              {\(-2.5607320356286594`\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, .94851912451684772, 3.1831430020600262, 
            5.3755000635486354, 6.3748555021222533, 
            4.9913408953714313, .6277576252720225, -4.8697440889307284, \
-8.4705994308216361, -8.4984726639469148, -5.3565395675875056, \
-1.0717536773268286, .48604476999680379, .53835752385267321, 
            2.4349306875337251, 3.8932309141928978, 
            3.1287036067553884, .80432634323691099, -1.6722015912754573, \
-2.9776101037426193, -2.5607320356286594}]], 
        "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"18.970382490336956`"},
              {"25.722095060526616`"},
              {"18.125046169245536`"},
              {"1.8620626022268638`"},
              {\(-29.53235473724307`\)},
              {\(-57.739310664745`\)},
              {\(-52.210723619310016`\)},
              {\(-19.80638321850816`\)},
              {"19.248918556002685`"},
              {"43.58974337118539`"},
              {"42.105974434027985`"},
              {\(-10.950005487555359`\)},
              {"11.99626056467272`"},
              {"25.935202708948324`"},
              {"3.230801824235112`"},
              {\(-18.521347972985296`\)},
              {\(-27.966197297384237`\)},
              {\(-21.56436139286313`\)},
              {\(-4.543808856480095`\)},
              {"12.881370218759297`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 18.970382490336956, 25.722095060526616, 
            18.125046169245536, 
            1.8620626022268638, -29.532354737243072, -57.739310664744998, \
-52.210723619310016, -19.806383218508159, 19.248918556002685, 
            43.589743371185392, 42.105974434027985, -10.950005487555359, 
            11.996260564672721, 25.935202708948324, 
            3.2308018242351122, -18.521347972985296, -27.966197297384237, \
-21.56436139286313, -4.5438088564800951, 12.881370218759297}]]}],
      SequenceForm[ 
        TableForm[ {
          0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0, 1.1000000000000001, 
          1.2000000000000002, 1.3, 1.4000000000000001, 1.5, 
          1.6000000000000001, 1.7000000000000002, 1.8, 1.9000000000000001, 
          2.0}], "     ", 
        TableForm[ {
          0, .03161730415056159, .23257398333758056, .66683701069408119, 
          1.2679072752834746, 1.8623791096077174, 2.1668398322461417, 
          1.9501333531920106, 
          1.2561125602037242, .37511287065320453, -.3379217616028356, \
-.65809994973425467, -.64317207849943647, -.61107385218381938, \
-.47402522673472913, -.1386968125778037, .23052670496729427, \
.43504891023724168, .38632028458154677, .13964590605032376, \
-.15179218348093967}], "   ", 
        TableForm[ {0, .94851912451684772, 3.1831430020600262, 
          5.3755000635486354, 6.3748555021222533, 
          4.9913408953714313, .6277576252720225, -4.8697440889307284, \
-8.4705994308216361, -8.4984726639469148, -5.3565395675875056, \
-1.0717536773268286, .48604476999680379, .53835752385267321, 
          2.4349306875337251, 3.8932309141928978, 
          3.1287036067553884, .80432634323691099, -1.6722015912754573, \
-2.9776101037426193, -2.5607320356286594}], "  ", 
        TableForm[ {0, 18.970382490336956, 25.722095060526616, 
          18.125046169245536, 
          1.8620626022268638, -29.532354737243072, -57.739310664744998, \
-52.210723619310016, -19.806383218508159, 19.248918556002685, 
          43.589743371185392, 42.105974434027985, -10.950005487555359, 
          11.996260564672721, 25.935202708948324, 
          3.2308018242351122, -18.521347972985296, -27.966197297384237, \
-21.56436139286313, -4.5438088564800951, 12.881370218759297}]],
      Editable->False]], "Print"]
}, Open  ]],

Cell["\<\
 La respuesta para el caso el\[AAcute]stico ( negro ), junto con la elastopl\
\[AAcute]stica        ( rojo ), se muestra a continuaci\[OAcute]n.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0998495 0.129364 [
[(0.5)] .2619 .09985 0 2 Msboxa
[(1)] .5 .09985 0 2 Msboxa
[(1.5)] .7381 .09985 0 2 Msboxa
[(2)] .97619 .09985 0 2 Msboxa
[(t)] 1.025 .09985 -1 0 Msboxa
[(1)] .01131 .22921 1 0 Msboxa
[(2)] .01131 .35858 1 0 Msboxa
[(3)] .01131 .48794 1 0 Msboxa
[(4)] .01131 .61731 1 0 Msboxa
[(u)] .02381 .61803 0 -4 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.2619 .09985 m
.2619 .1061 L
s
P
[(0.5)] .2619 .09985 0 2 Mshowa
p
.002 w
.5 .09985 m
.5 .1061 L
s
P
[(1)] .5 .09985 0 2 Mshowa
p
.002 w
.7381 .09985 m
.7381 .1061 L
s
P
[(1.5)] .7381 .09985 0 2 Mshowa
p
.002 w
.97619 .09985 m
.97619 .1061 L
s
P
[(2)] .97619 .09985 0 2 Mshowa
p
.001 w
.07143 .09985 m
.07143 .1036 L
s
P
p
.001 w
.11905 .09985 m
.11905 .1036 L
s
P
p
.001 w
.16667 .09985 m
.16667 .1036 L
s
P
p
.001 w
.21429 .09985 m
.21429 .1036 L
s
P
p
.001 w
.30952 .09985 m
.30952 .1036 L
s
P
p
.001 w
.35714 .09985 m
.35714 .1036 L
s
P
p
.001 w
.40476 .09985 m
.40476 .1036 L
s
P
p
.001 w
.45238 .09985 m
.45238 .1036 L
s
P
p
.001 w
.54762 .09985 m
.54762 .1036 L
s
P
p
.001 w
.59524 .09985 m
.59524 .1036 L
s
P
p
.001 w
.64286 .09985 m
.64286 .1036 L
s
P
p
.001 w
.69048 .09985 m
.69048 .1036 L
s
P
p
.001 w
.78571 .09985 m
.78571 .1036 L
s
P
p
.001 w
.83333 .09985 m
.83333 .1036 L
s
P
p
.001 w
.88095 .09985 m
.88095 .1036 L
s
P
p
.001 w
.92857 .09985 m
.92857 .1036 L
s
P
[(t)] 1.025 .09985 -1 0 Mshowa
p
.002 w
0 .09985 m
1 .09985 L
s
P
p
.002 w
.02381 .22921 m
.03006 .22921 L
s
P
[(1)] .01131 .22921 1 0 Mshowa
p
.002 w
.02381 .35858 m
.03006 .35858 L
s
P
[(2)] .01131 .35858 1 0 Mshowa
p
.002 w
.02381 .48794 m
.03006 .48794 L
s
P
[(3)] .01131 .48794 1 0 Mshowa
p
.002 w
.02381 .61731 m
.03006 .61731 L
s
P
[(4)] .01131 .61731 1 0 Mshowa
p
.001 w
.02381 .12572 m
.02756 .12572 L
s
P
p
.001 w
.02381 .1516 m
.02756 .1516 L
s
P
p
.001 w
.02381 .17747 m
.02756 .17747 L
s
P
p
.001 w
.02381 .20334 m
.02756 .20334 L
s
P
p
.001 w
.02381 .25509 m
.02756 .25509 L
s
P
p
.001 w
.02381 .28096 m
.02756 .28096 L
s
P
p
.001 w
.02381 .30683 m
.02756 .30683 L
s
P
p
.001 w
.02381 .3327 m
.02756 .3327 L
s
P
p
.001 w
.02381 .38445 m
.02756 .38445 L
s
P
p
.001 w
.02381 .41032 m
.02756 .41032 L
s
P
p
.001 w
.02381 .4362 m
.02756 .4362 L
s
P
p
.001 w
.02381 .46207 m
.02756 .46207 L
s
P
p
.001 w
.02381 .51381 m
.02756 .51381 L
s
P
p
.001 w
.02381 .53969 m
.02756 .53969 L
s
P
p
.001 w
.02381 .56556 m
.02756 .56556 L
s
P
p
.001 w
.02381 .59143 m
.02756 .59143 L
s
P
p
.001 w
.02381 .07398 m
.02756 .07398 L
s
P
p
.001 w
.02381 .0481 m
.02756 .0481 L
s
P
p
.001 w
.02381 .02223 m
.02756 .02223 L
s
P
[(u)] .02381 .61803 0 -4 Mshowa
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
0 0 0 r
.004 w
.02381 .09985 m
.07143 .10394 L
.11905 .12994 L
.16667 .18611 L
.21429 .26387 L
.2619 .34077 L
.30952 .38016 L
.35714 .35213 L
.40476 .26235 L
.45238 .14838 L
.5 .05613 L
.54762 .01472 L
.59524 .01665 L
.64286 .0208 L
.69048 .03853 L
.7381 .08191 L
.78571 .12967 L
.83333 .15613 L
.88095 .14983 L
.92857 .11791 L
.97619 .08021 L
s
P
p
1 0 0 r
.004 w
.02381 .09985 m
.07143 .10394 L
.11905 .12994 L
.16667 .18611 L
.21429 .26454 L
.2619 .35275 L
.30952 .44681 L
.35714 .53114 L
.40476 .58836 L
.45238 .60332 L
.5 .56637 L
.54762 .48738 L
.59524 .38955 L
.64286 .29161 L
.69048 .25611 L
.7381 .31067 L
.78571 .42217 L
.83333 .51592 L
.88095 .54457 L
.92857 .50064 L
.97619 .41576 L
s
P
P
% End of Graphics
MathPictureEnd\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{299, 185},
  ImageMargins->{{100, Inherited}, {Inherited, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^B000`400?l00000o`00003oo`3oool/
0?ooo`006P3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000J0?ooo`030000003oool0oooo0?l0
oooo3`3oool001X0oooo00<000000?ooo`3oool0o`3oool?0?ooo`006P3oool00`000000oooo0?oo
o`1o0?ooo`H00000R@3oool001X0oooo00<000000?ooo`3oool0OP3oool00`000000oooo0?ooo`04
0?ooo``00000O@3oool001X0oooo00<000000?ooo`3oool0O@3oool00`000000oooo0?ooo`0A0?oo
o`P00000M@3oool001X0oooo00<000000?ooo`3oool0O03oool00`000000oooo0?ooo`0J0?ooo`<0
0000LP3oool001X0oooo00<000000?ooo`3oool0N`3oool00`000000oooo0?ooo`0N0?ooo`800000
L03oool001X0oooo00<000000?ooo`3oool0NP3oool00`000000oooo0?ooo`0Q0?ooo`<00000K@3o
ool001X0oooo00<000000?ooo`3oool0N03oool2000002L0oooo0P00001[0?ooo`006P3oool00`00
0000oooo0?ooo`1g0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0J03oool001X0
oooo00<000000?ooo`3oool0<@3oool2000000@0oooo0P0000040?ooo`800000<P3oool6000002d0
oooo00<000000?ooo`000000100000020?ooo`800000103oool200000380oooo1000000S0?ooo`00
6P3oool00`000000oooo0?ooo`0`0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3o
ool00000<`3oool00`000000oooo0000000_0?ooo`040000003oool0oooo000000T0oooo00@00000
0?ooo`3oool00000<@3oool00`000000oooo0?ooo`0T0?ooo`006P3oool00`000000oooo0?ooo`0`
0?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3oool0<@3oool200000340oooo00<0
00000?ooo`000000303oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo02<0oooo000J
0?ooo`030000003oool0oooo0300oooo00@000000?ooo`3oool000002@3oool2000003@0oooo00<0
00000?ooo`3oool0<@3oool2000000X0oooo0P00000d0?ooo`030000003oool0oooo0280oooo000J
0?ooo`030000003oool0oooo0300oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?oo
o`0b0?ooo`800000=03oool2000000T0oooo00<000000?ooo`3oool0<@3oool010000000oooo0?oo
o`00000S0?ooo`006P3oool00`000000oooo0?ooo`0a0?ooo`8000002P3oool300000380oooo0P00
000c0?ooo`80000000<0oooo0000003oool01`3oool300000380oooo0P00000T0?ooo`006P3oool0
0`000000oooo0?ooo`1a0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0H03oool0
01X0oooo00<000000?ooo`3oool0L@3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo
05l0oooo000J0?ooo`030000003oool0oooo0700oooo00<000000?ooo`3oool0>P3oool00`000000
oooo0?ooo`1N0?ooo`006P3oool00`000000oooo0?ooo`1`0?ooo`030000003oool0oooo03/0oooo
00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0R0?ooo`006P3oool00`000000oooo0?oo
o`1_0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?oo
o`0S0?ooo`006P3oool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo03h0oooo00<00000
0?ooo`3oool0<`3oool2000002H0oooo000J0?ooo`030000003oool0oooo06h0oooo00<000000?oo
o`3oool0@03oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo0100oooo0P00000D0?oo
o`006P3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3o
ool0;`3oool00`000000oooo0?ooo`0@0?ooo`040000003oool0oooo000001<0oooo000D0?ooo`H0
00001P3o003]000000L0oooo00<000000?ooo`3oool0503oool001X0oooo00<000000?ooo`3oool0
0`3oool60?l000/0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0000000H0
oooo00<000000?ooo`3oool02P3oool5000001<0oooo000J0?ooo`030000003oool0oooo00T0oooo
0P3o001Q0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0:03oool2000001D0oooo
00<000000?ooo`3oool0503oool001X0oooo00<000000?ooo`3oool02`3oool20?l005l0oooo00<0
00000?ooo`3oool0A`3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02`0oooo000J
0?ooo`030000003oool0oooo00d0oooo0P3o001L0?ooo`030000003oool0oooo04T0oooo00<00000
0?ooo`3oool0903oool00`000000oooo0?ooo`0]0?ooo`006P3oool00`000000oooo0?ooo`0?0?oo
o`80o`00FP3oool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo0240oooo0P00000`0?oo
o`006P3oool00`000000oooo0?ooo`0A0?ooo`80o`00E`3oool00`000000oooo0?ooo`1<0?ooo`03
0000003oool0oooo01l0oooo00<000000?ooo`3oool0<03oool001X0oooo00<000000?ooo`3oool0
4`3oool20?l005D0oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`0L0?ooo`800000
<`3oool001X0oooo00<000000?ooo`3oool05@3oool00`3o0000oooo0?ooo`1A0?ooo`030000003o
ool0oooo04l0oooo0P00000K0?ooo`030000003oool0oooo03<0oooo000J0?ooo`030000003oool0
oooo01H0oooo00<0o`000?ooo`3oool0D03oool00`000000oooo0?ooo`1A0?ooo`8000005`3oool2
000003H0oooo000J0?ooo`030000003oool0oooo01L0oooo00<0o`000?ooo`3oool0CP3oool00`00
0000oooo0?ooo`1D0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0=P3oool001X0
oooo00<000000?ooo`3oool05`3oool00`3o0000oooo0?ooo`1>0?ooo`030000003oool0oooo05D0
oooo0P00000A0?ooo`800000>@3oool001X0oooo00<000000?ooo`3oool0603oool00`3o0000oooo
0?ooo`1<0?ooo`030000003oool0oooo05P0oooo0P00000<0?ooo`<00000>`3oool001X0oooo00<0
00000?ooo`3oool06@3oool00`3o0000oooo0?ooo`1;0?ooo`030000003oool0oooo05X0oooo0P00
00040?ooo`H00000?P3oool001X0oooo00<000000?ooo`3oool06P3oool00`3o0000oooo0?ooo`19
0?ooo`030000003oool0oooo05d0oooo100000140?ooo`006P3oool00`000000oooo0?ooo`0K0?oo
o`030?l0003oool0oooo04P0oooo00<000000?ooo`3oool0Y@3oool001X0oooo00<000000?ooo`3o
ool0703oool00`3o0000oooo0?ooo`160?ooo`030000003oool0oooo0:H0oooo000J0?ooo`030000
003oool0oooo01d0oooo00<0o`000?ooo`3oool0A@3oool00`000000oooo0?ooo`2V0?ooo`006P3o
ool00`000000oooo0?ooo`0M0?ooo`030?l0003oool0oooo04@0oooo00<000000?ooo`3oool0Y`3o
ool001X0oooo00<000000?ooo`3oool07P3oool00`3o0000oooo0?ooo`130?ooo`030000003oool0
oooo0:L0oooo000J0?ooo`030000003oool0oooo01l0oooo00<0o`000?ooo`3oool0@P3oool00`00
0000oooo0?ooo`2W0?ooo`006P3oool00`000000oooo0?ooo`0P0?ooo`030?l0003oool0oooo0400
oooo00<000000?ooo`3oool0Z03oool001X0oooo00<000000?ooo`3oool08@3oool00`3o0000oooo
0?ooo`0o0?ooo`030000003oool0oooo0:P0oooo000J0?ooo`030000003oool0oooo0240oooo00<0
o`000?ooo`3oool0?P3oool00`000000oooo0?ooo`2Y0?ooo`006P3oool00`000000oooo0?ooo`0R
0?ooo`030?l0003oool0oooo03d0oooo00<000000?ooo`3oool0Z@3oool001X0oooo00<000000?oo
o`3oool08P3oool00`3o000000000?ooo`0l0?ooo`030000003oool0oooo0:X0oooo000J0?ooo`03
0000003oool0oooo02<0oooo00<0o`000?ooo`3oool0>`3oool00`000000oooo0?ooo`2Z0?ooo`00
6P3oool00`000000oooo0?ooo`0T0?ooo`030?l0003oool0oooo03X0oooo00<000000?ooo`3oool0
ZP3oool001X0oooo00<000000?ooo`3oool0903oool00`3o0000oooo0?ooo`0i0?ooo`030000003o
ool0oooo0:/0oooo000J0?ooo`030000003oool0oooo02D0oooo00<0o`000?ooo`3oool0>03oool0
0`000000oooo0?ooo`2[0?ooo`004@3oool5000000@0oooo00<000000?ooo`3oool09@3oool00`3o
000000000?ooo`0g0?ooo`030000003oool0oooo0:`0oooo000C0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool09P3oool00`3o0000oooo0?ooo`0f0?ooo`030000003oool0oooo0:`0
oooo000C0?ooo`030000003oool0oooo00@0oooo0P00000X0?ooo`030?l0003oool0oooo03@0oooo
00<000000?ooo`3oool0[@3oool001<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`0W0?ooo`030?l000000000oooo03@0oooo00<000000?ooo`3oool0[@3oool001<0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0X0?ooo`030?l0003oool0oooo03<0oooo00<00000
0?ooo`3oool0[@3oool00180oooo0P0000060?ooo`030000003oool0oooo02P0oooo00<0o`000000
003oool0<P3oool00`000000oooo0?ooo`2^0?ooo`006P3oool00`000000oooo0?ooo`0Y0?ooo`03
0?l0003oool0oooo0340oooo00<000000?ooo`3oool0[P3oool001X0oooo00<000000?ooo`3oool0
:P3oool00`3o0000oooo0?ooo`0_0?ooo`030000003oool0oooo0:l0oooo000J0?ooo`030000003o
ool0oooo02X0oooo00<0o`000000003oool0;`3oool00`000000oooo0?ooo`130?ooo`030?l0003o
ool0oooo06T0oooo000J0?ooo`030000003oool0oooo02/0oooo00<0o`000?ooo`3oool0;@3oool0
0`000000oooo0?ooo`130?ooo`030?l0003oool0o`0006X0oooo000J0?ooo`030000003oool0oooo
02/0oooo00<0o`000000003oool0;@3oool00`000000oooo0?ooo`110?ooo`80o`000`3oool00`3o
0000oooo0?ooo`1W0?ooo`006P3oool00`000000oooo0?ooo`0/0?ooo`030?l000000000oooo02/0
oooo00<000000?ooo`3oool0@@3oool00`3o0000oooo0?ooo`040?ooo`030?l0003oool0oooo06H0
oooo000J0?ooo`030000003oool0oooo02d0oooo00<0o`000?ooo`3oool0:P3oool00`000000oooo
0?ooo`100?ooo`030?l0003oool0oooo00D0oooo00<0o`000?ooo`3oool0IP3oool001X0oooo00<0
00000?ooo`3oool0;@3oool00`3o000000000?ooo`0Y0?ooo`030000003oool0oooo0400oooo00<0
o`000?ooo`3oool01`3oool00`3o0000oooo0?ooo`1U0?ooo`006P3oool00`000000oooo0?ooo`0^
0?ooo`030?l0003oool0oooo02P0oooo00<000000?ooo`3oool0?`3oool00`3o0000oooo0?ooo`09
0?ooo`030?l0003oool0oooo06@0oooo000J0?ooo`030000003oool0oooo02h0oooo00<0o`000000
003oool09`3oool00`000000oooo0?ooo`0n0?ooo`80o`003@3oool00`3o0000oooo0?ooo`1S0?oo
o`006P3oool00`000000oooo0?ooo`0_0?ooo`030?l000000000oooo02H0oooo00<000000?ooo`3o
ool0?@3oool00`3o0000oooo0?ooo`0>0?ooo`030?l0003oool0oooo0680oooo000J0?ooo`030000
003oool0oooo02l0oooo00<0o`000000003oool09@3oool00`000000oooo0?ooo`0m0?ooo`030?l0
003oool0oooo0100oooo00<0o`000?ooo`3oool0H@3oool001X0oooo00<000000?ooo`3oool0<03o
ool00`3o000000000?ooo`0T0?ooo`030000003oool0oooo03d0oooo00<0o`000?ooo`3oool04@3o
ool00`3o0000oooo0?ooo`1P0?ooo`006P3oool00`000000oooo0?ooo`0`0?ooo`030?l000000000
oooo02<0oooo00<000000?ooo`3oool0?@3oool00`3o0000oooo0?ooo`0B0?ooo`030?l0003oool0
oooo0600oooo000J0?ooo`030000003oool0oooo0340oooo00<0o`000000003oool08P3oool00`00
0000oooo0?ooo`0m0?ooo`030?l0003oool0oooo01<0oooo00<0o`000?ooo`3oool0G`3oool001X0
oooo00<000000?ooo`3oool0<@3oool00`3o0000oooo0000000Q0?ooo`030000003oool0oooo03d0
oooo00<0o`000?ooo`3oool05@3oool00`3o0000oooo0?ooo`1N0?ooo`006P3oool00`000000oooo
0?ooo`0b0?ooo`030?l000000000oooo01l0oooo00<000000?ooo`3oool0?P3oool00`3o0000oooo
0?ooo`0F0?ooo`030?l0003oool0oooo05d0oooo000J0?ooo`030000003oool0oooo03<0oooo00<0
o`000000003oool07P3oool00`000000oooo0?ooo`0m0?ooo`030?l0003oool0oooo01L0oooo00<0
o`000?ooo`3oool0G@3oool001X0oooo00<000000?ooo`3oool0<`3oool00`3o000000000?ooo`0M
0?ooo`030000003oool0oooo03h0oooo00<0o`000?ooo`3oool0603oool00`3o0000oooo0?ooo`1L
0?ooo`006P3oool00`000000oooo0?ooo`0d0?ooo`030?l000000000oooo01`0oooo00<000000?oo
o`3oool0?@3oool00`3o0000oooo0?ooo`0I0?ooo`030?l0003oool0oooo05`0oooo000J0?ooo`03
0000003oool0oooo03@0oooo00<0o`000?ooo`0000006`3oool00`000000oooo0?ooo`0n0?ooo`03
0?l0003oool0oooo01X0oooo00<0o`000?ooo`3oool0F`3oool001X0oooo00<000000?ooo`3oool0
=@3oool00`3o000000000?ooo`0J0?ooo`030000003oool0oooo03d0oooo00<0o`000?ooo`3oool0
6`3oool00`3o0000oooo0?ooo`1K0?ooo`006P3oool00`000000oooo0?ooo`0e0?ooo`030?l0003o
ool0000001T0oooo00<000000?ooo`3oool0?P3oool00`3o0000oooo0?ooo`0L0?ooo`030?l0003o
ool0oooo05X0oooo000J0?ooo`030000003oool0oooo03H0oooo00<0o`000000003oool0603oool0
0`000000oooo0?ooo`0m0?ooo`030?l0003oool0oooo01d0oooo00<0o`000?ooo`3oool0FP3oool0
01X0oooo00<000000?ooo`3oool0=P3oool00`3o0000oooo0000000G0?ooo`030000003oool0oooo
03h0oooo00<0o`000?ooo`3oool07@3oool00`3o0000oooo0?ooo`1J0?ooo`006P3oool00`000000
oooo0?ooo`0g0?ooo`030?l0003oool0000001H0oooo00<000000?ooo`3oool0?@3oool00`3o0000
oooo0?ooo`0O0?ooo`030?l0003oool0oooo05T0oooo000A0?ooo`@000001@3oool00`000000oooo
0?ooo`0g0?ooo`030?l0003oool0oooo008000004`3oool00`000000oooo0?ooo`0n0?ooo`030?l0
003oool0oooo01l0oooo00<0o`000?ooo`3oool0F@3oool00140oooo00<000000?ooo`3oool01P3o
ool00`000000oooo0?ooo`0h0?ooo`050?l0003oool0oooo0?ooo`000000403oool200000400oooo
00<0o`000?ooo`3oool08@3oool00`3o0000oooo0?ooo`1H0?ooo`004P3oool00`000000oooo0?oo
o`050?ooo`800000>P3oool01@3o0000oooo0?ooo`3oool0000000h0oooo00<000000?ooo`3oool0
@03oool00`3o0000oooo0?ooo`0Q0?ooo`030?l0003oool0oooo05P0oooo000C0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0>@3oool00`3o0000oooo0?ooo`020?ooo`8000002P3o
ool200000480oooo00<0o`000?ooo`3oool08`3oool00`3o0000oooo0?ooo`1G0?ooo`004@3oool0
10000000oooo0?ooo`0000050?ooo`030000003oool0oooo03X0oooo00<0o`000?ooo`3oool00`3o
ool00`000000oooo0?ooo`050?ooo`800000A03oool00`3o0000oooo0?ooo`0S0?ooo`030?l0003o
ool0oooo05L0oooo000B0?ooo`8000001P3oool00`000000oooo0?ooo`0j0?ooo`030?l0003oool0
oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`130?ooo`030?l0003oool0
oooo02@0oooo00<0o`000?ooo`3oool0E`3oool001X0oooo00<000000?ooo`3oool0>`3oool00`3o
0000oooo0?ooo`040?ooo`80000000<0oooo000000000000AP3oool00`3o0000oooo0?ooo`0U0?oo
o`030?l0003oool0oooo05H0oooo000J0?ooo`030000003oool0oooo03/0oooo00<0o`000?ooo`3o
ool01P3oool00`000000oooo0?ooo`150?ooo`030?l0003oool0oooo02H0oooo00<0o`000?ooo`3o
ool0EP3oool001X0oooo00<000000?ooo`3oool0?03oool00`3o0000oooo0?ooo`1=0?ooo`030?l0
003oool0oooo02L0oooo00<0o`000?ooo`3oool0E@3oool001X0oooo00<000000?ooo`3oool0?03o
ool00`3o0000oooo0?ooo`1<0?ooo`030?l0003oool0oooo02P0oooo00<0o`000?ooo`3oool0E@3o
ool001X0oooo00<000000?ooo`3oool0?@3oool00`3o0000oooo0?ooo`1;0?ooo`030?l0003oool0
oooo02T0oooo00<0o`000?ooo`3oool0E03oool001X0oooo00<000000?ooo`3oool0?@3oool00`3o
0000oooo0?ooo`1:0?ooo`030?l0003oool0oooo02X0oooo00<0o`000?ooo`3oool0E03oool001X0
oooo00<000000?ooo`3oool0?P3oool00`3o0000oooo0?ooo`190?ooo`030?l0003oool0oooo02X0
oooo00<0o`000?ooo`3oool0E03oool001X0oooo00<000000?ooo`3oool0?P3oool00`3o0000oooo
0?ooo`180?ooo`030?l0003oool0oooo02`0oooo00<0o`000?ooo`3oool0D`3oool001X0oooo00<0
00000?ooo`3oool0?`3oool00`3o0000oooo0?ooo`170?ooo`030?l0003oool0oooo02`0oooo00<0
o`000?ooo`3oool0D`3oool001X0oooo00<000000?ooo`3oool0?`3oool00`3o0000oooo0?ooo`16
0?ooo`030?l0003oool0oooo02h0oooo00<0o`000?ooo`3oool0DP3oool001X0oooo00<000000?oo
o`3oool0@03oool00`3o0000oooo0?ooo`150?ooo`030?l0003oool0oooo02h0oooo00<0o`000?oo
o`3oool0;@3oool00`3o0000oooo0?ooo`0R0?ooo`006P3oool00`000000oooo0?ooo`100?ooo`03
0?l0003oool0oooo04@0oooo00<0o`000?ooo`3oool0<03oool00`3o0000oooo0?ooo`0[0?ooo`03
0?l0003oool0oooo02<0oooo000J0?ooo`030000003oool0oooo0440oooo00<0o`000?ooo`3oool0
@`3oool00`3o0000oooo0?ooo`0`0?ooo`030?l0003oool0oooo02/0oooo00<0o`000?ooo`3oool0
8`3oool001X0oooo00<000000?ooo`3oool0@@3oool00`3o0000oooo0?ooo`120?ooo`030?l0003o
ool0oooo0380oooo00<0o`000?ooo`3oool0:@3oool00`3o0000oooo0?ooo`0T0?ooo`006P3oool0
0`000000oooo0?ooo`120?ooo`030?l0003oool0oooo0440oooo00<0o`000?ooo`3oool0<P3oool0
0`3o0000oooo0?ooo`0Y0?ooo`030?l0003oool0oooo02@0oooo000J0?ooo`030000003oool0oooo
0480oooo00<0o`000?ooo`3oool0@03oool00`3o0000oooo0?ooo`0d0?ooo`030?l0003oool0oooo
02L0oooo00<0o`000?ooo`3oool09@3oool001X0oooo00<000000?ooo`3oool0@`3oool00`3o0000
oooo0?ooo`0o0?ooo`030?l0003oool0oooo03@0oooo00<0o`000?ooo`3oool09`3oool00`3o0000
oooo0?ooo`0U0?ooo`006P3oool00`000000oooo0?ooo`130?ooo`030?l0003oool0oooo03h0oooo
00<0o`000?ooo`3oool0=P3oool00`3o0000oooo0?ooo`0U0?ooo`030?l0003oool0oooo02H0oooo
000J0?ooo`030000003oool0oooo04@0oooo00<0o`000?ooo`3oool0?@3oool00`3o0000oooo0?oo
o`0f0?ooo`030?l0003oool0oooo02D0oooo00<0o`000?ooo`3oool09P3oool001X0oooo00<00000
0?ooo`3oool0A@3oool00`3o0000oooo0?ooo`0k0?ooo`030?l0003oool0oooo03P0oooo00<0o`00
0?ooo`3oool08`3oool00`3o0000oooo0?ooo`0W0?ooo`006P3oool00`000000oooo0?ooo`150?oo
o`030?l0003oool0oooo03/0oooo00<0o`000?ooo`3oool0>03oool00`3o0000oooo0?ooo`0S0?oo
o`030?l0003oool0oooo02L0oooo000J0?ooo`030000003oool0oooo04H0oooo00<0o`000?ooo`3o
ool0>@3oool00`3o0000oooo0?ooo`0j0?ooo`030?l0003oool0oooo0240oooo00<0o`000?ooo`3o
ool0:03oool001X0oooo00<000000?ooo`3oool0AP3oool00`3o0000oooo0?ooo`0i0?ooo`030?l0
003oool0oooo03X0oooo00<0o`000?ooo`3oool08@3oool00`3o0000oooo0?ooo`0X0?ooo`006P3o
ool00`000000oooo0?ooo`170?ooo`030?l0003oool0oooo03L0oooo00<0o`000?ooo`3oool0?03o
ool00`3o0000oooo0?ooo`0O0?ooo`030?l0003oool0oooo02T0oooo000J0?ooo`030000003oool0
oooo04L0oooo00<0o`000?ooo`3oool0=`3oool00`3o0000oooo0?ooo`0l0?ooo`030?l0003oool0
oooo01l0oooo00<0o`000?ooo`3oool0:@3oool001X0oooo00<000000?ooo`3oool0B03oool00`3o
0000oooo0?ooo`0e0?ooo`030?l0003oool0oooo03h0oooo00<0o`000?ooo`3oool07@3oool00`3o
0000oooo0?ooo`0Z0?ooo`004P3oool2000000H0oooo00<000000?ooo`3oool0B03oool00`3o0000
oooo0?ooo`0e0?ooo`030?l0003oool0oooo03h0oooo00<0o`000?ooo`3oool07@3oool00`3o0000
oooo0?ooo`0Z0?ooo`004@3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo04T0
oooo00<0o`000?ooo`3oool0<`3oool00`3o0000oooo0?ooo`100?ooo`030?l0003oool0oooo01/0
oooo00<0o`000?ooo`3oool0:`3oool001<0oooo00<000000?ooo`3oool0103oool2000004X0oooo
00<0o`000?ooo`3oool0<`3oool00`3o0000oooo0?ooo`100?ooo`030?l0003oool0oooo01/0oooo
00<0o`000?ooo`3oool0:`3oool001@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`1:0?ooo`030?l0003oool0oooo0340oooo00<0o`000?ooo`3oool0@P3oool00`3o0000oooo0?oo
o`0I0?ooo`030?l0003oool0oooo02`0oooo000A0?ooo`040000003oool0oooo000000D0oooo00<0
00000?ooo`3oool0BP3oool00`3o0000oooo0?ooo`0a0?ooo`030?l0003oool0oooo0480oooo00<0
o`000?ooo`3oool06@3oool00`3o0000oooo0?ooo`0/0?ooo`004P3oool2000000H0oooo00<00000
0?ooo`3oool0B`3oool00`3o0000oooo0?ooo`0_0?ooo`030?l0003oool0oooo04@0oooo00<0o`00
0?ooo`3oool05`3oool00`3o0000oooo0?ooo`0]0?ooo`006P3oool00`000000oooo0?ooo`1;0?oo
o`030?l0003oool0oooo02l0oooo00<0o`000?ooo`3oool0A03oool00`3o0000oooo0?ooo`0F0?oo
o`030?l0003oool0oooo02h0oooo000J0?ooo`030000003oool0oooo04`0oooo00<0o`000?ooo`3o
ool0;@3oool00`3o0000oooo0?ooo`160?ooo`030?l0003oool0oooo01@0oooo00<0o`000?ooo`3o
ool0;`3oool001X0oooo00<000000?ooo`3oool0C03oool00`3o0000oooo0?ooo`0/0?ooo`030?l0
003oool0oooo04L0oooo00<0o`000?ooo`3oool04`3oool00`3o0000oooo0?ooo`0`0?ooo`006P3o
ool00`000000oooo0?ooo`1=0?ooo`030?l0003oool0oooo02/0oooo00<0o`000?ooo`3oool0B03o
ool00`3o0000oooo0?ooo`0A0?ooo`030?l0003oool0oooo0340oooo000J0?ooo`030000003oool0
oooo04d0oooo00<0o`000?ooo`3oool0:P3oool00`3o0000oooo0?ooo`1:0?ooo`80o`00403oool0
0`3o0000oooo0?ooo`0b0?ooo`006P3oool00`000000oooo0?ooo`1>0?ooo`030?l0003oool0oooo
02T0oooo00<0o`000?ooo`3oool0C03oool20?l000`0oooo0P3o000e0?ooo`006P3oool00`000000
oooo0?ooo`1>0?ooo`030?l0003oool0oooo02P0oooo00<0o`000?ooo`3oool0C`3oool00`3o0000
oooo0?ooo`080?ooo`030?l0003oool0oooo03D0oooo000J0?ooo`030000003oool0oooo04l0oooo
00<0o`000?ooo`3oool09P3oool00`3o0000oooo0?ooo`1A0?ooo`80o`001`3oool00`3o0000oooo
0?ooo`0f0?ooo`006P3oool00`000000oooo0?ooo`1@0?ooo`030?l0003oool0oooo02D0oooo00<0
o`000?ooo`3oool0D`3oool20?l000@0oooo00<0o`000?ooo`3oool0=`3oool001X0oooo00<00000
0?ooo`3oool0D@3oool00`3o0000oooo0?ooo`0S0?ooo`030?l0003oool0oooo05H0oooo0P3o0000
0`3oool0o`000?ooo`0i0?ooo`006P3oool00`000000oooo0?ooo`1B0?ooo`030?l0003oool0oooo
0280oooo00<0o`000?ooo`3oool0F03oool00`3o0000oooo0?ooo`0i0?ooo`006P3oool00`000000
oooo0?ooo`1B0?ooo`030?l0003oool0oooo0240oooo00<0o`000?ooo`3oool0U@3oool001X0oooo
00<000000?ooo`3oool0D`3oool00`3o0000oooo0?ooo`0O0?ooo`030?l0003oool0oooo09H0oooo
000J0?ooo`030000003oool0oooo05@0oooo00<0o`000?ooo`3oool07P3oool00`3o0000oooo0?oo
o`2F0?ooo`006P3oool00`000000oooo0?ooo`1E0?ooo`030?l0003oool0oooo01`0oooo00<0o`00
0?ooo`3oool0U`3oool001X0oooo00<000000?ooo`3oool0EP3oool00`3o0000oooo0?ooo`0K0?oo
o`030?l0003oool0oooo09L0oooo000J0?ooo`030000003oool0oooo05L0oooo00<0o`000?ooo`3o
ool06@3oool00`3o0000oooo0?ooo`2H0?ooo`006P3oool00`000000oooo0?ooo`1H0?ooo`030?l0
003oool0oooo01L0oooo00<0o`000?ooo`3oool0V@3oool001X0oooo00<000000?ooo`3oool0F03o
ool00`3o0000oooo0?ooo`0E0?ooo`80o`00W03oool001X0oooo00<000000?ooo`3oool0F@3oool0
0`3o0000oooo0?ooo`0C0?ooo`030?l0003oool0oooo09`0oooo000J0?ooo`030000003oool0oooo
05X0oooo00<0o`000?ooo`3oool04@3oool00`3o0000oooo0?ooo`2M0?ooo`006P3oool00`000000
oooo0?ooo`1K0?ooo`80o`003`3oool20?l00:00oooo000J0?ooo`030000003oool0oooo05d0oooo
0`3o000;0?ooo`030?l0003oool0oooo0:00oooo000J0?ooo`030000003oool0oooo0600oooo0`3o
00070?ooo`030?l0003oool0oooo0:40oooo000J0?ooo`030000003oool0oooo06<0oooo0`3o0002
0?ooo`80o`00Y03oool001X0oooo00<000000?ooo`3oool0IP3oool20?l00:H0oooo000C0?ooo`<0
0000103oool00`000000oooo0?ooo`3o0?ooo`l0oooo000D0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0o`3oool?0?ooo`004@3oool5000000@0oooo0P00003o0?oooa00oooo000A
0?ooo`040000003oool0oooo00000?l0oooo5`3oool00180oooo00<000000?ooo`000000o`3ooolG
0?ooo`004`3oool200000?l0oooo5`3oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03o
ool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03o
ool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03o
ool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03o
ool001T0oooo1000003o0?ooo`l0oooo000H0?ooo`040000003oool0oooo00000?l0oooo403oool0
01P0oooo00@000000?ooo`3oool00000o`3oool@0?ooo`005`3oool2000000030?ooo`0000000000
0?l0oooo403oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool0
0?l0oooo;03oool00001\
\>"],
  ImageRangeCache->{{{0, 298}, {184, 0}} -> {-0.219644, -0.779603, \
0.00844141, 0.0310729}}],

Cell["\<\
Veamos ahora el mismo caso anterior, pero en el supuesto de que el material \
no resista a tracci\[OAcute]n ( hormig\[OAcute]n ). \
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["\<\
NewmarkNoLineal[0,2,.1,0,0,12.35,.2,.274,p,  
        .5,1/6,-15,0,posicion,velocidad,aceleracion] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.0191247 [
[.2619 .00222 -9 -9 ]
[.2619 .00222 9 0 ]
[.5 .00222 -3 -9 ]
[.5 .00222 3 0 ]
[.7381 .00222 -9 -9 ]
[.7381 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.4375 ]
[1.025 .01472 10 6.4375 ]
[.01131 .11034 -6 -4.5 ]
[.01131 .11034 0 4.5 ]
[.01131 .20596 -12 -4.5 ]
[.01131 .20596 0 4.5 ]
[.01131 .30159 -12 -4.5 ]
[.01131 .30159 0 4.5 ]
[.01131 .39721 -12 -4.5 ]
[.01131 .39721 0 4.5 ]
[.01131 .49283 -12 -4.5 ]
[.01131 .49283 0 4.5 ]
[.01131 .58846 -12 -4.5 ]
[.01131 .58846 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(0.5)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(1)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(1.5)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(2)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .11034 m
.03006 .11034 L
s
[(5)] .01131 .11034 1 0 Mshowa
.02381 .20596 m
.03006 .20596 L
s
[(10)] .01131 .20596 1 0 Mshowa
.02381 .30159 m
.03006 .30159 L
s
[(15)] .01131 .30159 1 0 Mshowa
.02381 .39721 m
.03006 .39721 L
s
[(20)] .01131 .39721 1 0 Mshowa
.02381 .49283 m
.03006 .49283 L
s
[(25)] .01131 .49283 1 0 Mshowa
.02381 .58846 m
.03006 .58846 L
s
[(30)] .01131 .58846 1 0 Mshowa
.125 Mabswid
.02381 .03384 m
.02756 .03384 L
s
.02381 .05296 m
.02756 .05296 L
s
.02381 .07209 m
.02756 .07209 L
s
.02381 .09121 m
.02756 .09121 L
s
.02381 .12946 m
.02756 .12946 L
s
.02381 .14859 m
.02756 .14859 L
s
.02381 .16771 m
.02756 .16771 L
s
.02381 .18684 m
.02756 .18684 L
s
.02381 .22509 m
.02756 .22509 L
s
.02381 .24421 m
.02756 .24421 L
s
.02381 .26334 m
.02756 .26334 L
s
.02381 .28246 m
.02756 .28246 L
s
.02381 .32071 m
.02756 .32071 L
s
.02381 .33984 m
.02756 .33984 L
s
.02381 .35896 m
.02756 .35896 L
s
.02381 .37808 m
.02756 .37808 L
s
.02381 .41633 m
.02756 .41633 L
s
.02381 .43546 m
.02756 .43546 L
s
.02381 .45458 m
.02756 .45458 L
s
.02381 .47371 m
.02756 .47371 L
s
.02381 .51196 m
.02756 .51196 L
s
.02381 .53108 m
.02756 .53108 L
s
.02381 .55021 m
.02756 .55021 L
s
.02381 .56933 m
.02756 .56933 L
s
.02381 .60758 m
.02756 .60758 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.07143 .01538 L
.11905 .01993 L
.16667 .03186 L
.21429 .05419 L
.2619 .089 L
.30952 .13532 L
.35714 .18946 L
.40476 .24768 L
.45238 .30669 L
.5 .36364 L
.54762 .41604 L
.59524 .4607 L
.64286 .49291 L
.69048 .51652 L
.7381 .53636 L
.78571 .55365 L
.83333 .56873 L
.88095 .58187 L
.92857 .59333 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.813, 184.688},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oo`3oool[
0?ooo`00CP3oool2000000@0oooo0P0000040?ooo`800000<`3oool500000340oooo1@0000020?oo
o`800000103oool2000003<0oooo1000000O0?ooo`00C@3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo000003@0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`07
0?ooo`040000003oool0oooo00000380oooo00<000000?ooo`3oool0803oool004d0oooo00@00000
0?ooo`3oool000002`3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo03<0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo01l0oooo001=
0?ooo`040000003oool0oooo000000T0oooo0P00000e0?ooo`030000003oool0oooo03<0oooo00<0
00000?ooo`3oool0203oool2000003D0oooo00<000000?ooo`3oool07P3oool004d0oooo00@00000
0?ooo`3oool000002@3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo03<0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0b0?ooo`040000003oool0oooo000001l0oooo
001>0?ooo`8000002P3oool3000003<0oooo0P00000d0?ooo`8000002P3oool3000003<0oooo0P00
000P0?ooo`00o`3oool[0?ooo`006@3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000I0?ooo`03
0000003oool0oooo0?l0oooo3`3oool001T0oooo00<000000?ooo`3oool0o@3oool2000000l0oooo
000I0?ooo`030000003oool0oooo0?`0oooo00@000000?ooo`3oool000003P3oool001<0oooo1P00
000B0?l00>D00000203oool00`000000oooo0?ooo`0?0?ooo`006@3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00<0oooo203o000:0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`D000003P3oool001T0oooo00<000000?oo
o`3oool05`3oool40?l001h0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0i0?oo
o`030000003oool0oooo03T0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0?0?oo
o`006@3oool00`000000oooo0?ooo`0K0?ooo`@0o`00k`3oool001T0oooo00<000000?ooo`3oool0
7`3oool30?l00>`0oooo000I0?ooo`8000008`3oool20?l00>X0oooo000I0?ooo`030000003oool0
oooo02@0oooo0P3o003X0?ooo`006@3oool00`000000oooo0?ooo`0V0?ooo`80o`00iP3oool001T0
oooo00<000000?ooo`3oool0:03oool20?l00>@0oooo000I0?ooo`030000003oool0oooo02X0oooo
0P3o003R0?ooo`006@3oool2000002d0oooo0P3o003P0?ooo`006@3oool00`000000oooo0?ooo`0^
0?ooo`030?l0003oool0oooo0=d0oooo000I0?ooo`030000003oool0oooo02l0oooo0P3o003M0?oo
o`006@3oool00`000000oooo0?ooo`0a0?ooo`030?l0003oool0oooo0=X0oooo000I0?ooo`800000
<`3oool00`3o0000oooo0?ooo`3I0?ooo`006@3oool00`000000oooo0?ooo`0c0?ooo`80o`00f@3o
ool001T0oooo00<000000?ooo`3oool0=@3oool00`3o0000oooo0?ooo`3F0?ooo`006@3oool00`00
0000oooo0?ooo`0f0?ooo`030?l0003oool0oooo0=D0oooo000I0?ooo`030000003oool0oooo03L0
oooo0P3o003E0?ooo`006@3oool2000003X0oooo00<0o`000?ooo`3oool0dP3oool001T0oooo00<0
00000?ooo`3oool0>P3oool00`3o0000oooo0?ooo`3A0?ooo`006@3oool00`000000oooo0?ooo`0k
0?ooo`030?l0003oool0oooo0=00oooo000A0?ooo`8000001P3oool00`000000oooo0?ooo`0l0?oo
o`030?l0003oool0oooo0<l0oooo000@0?ooo`040000003oool0oooo000000D0oooo00<000000?oo
o`3oool0?@3oool00`3o0000oooo0?ooo`3>0?ooo`004`3oool00`000000oooo0?ooo`030?ooo`80
0000?`3oool00`3o0000oooo0?ooo`3=0?ooo`004@3oool2000000H0oooo00<000000?ooo`3oool0
?`3oool20?l00<d0oooo000A0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0@@3o
ool00`3o0000oooo0?ooo`3:0?ooo`004@3oool3000000D0oooo00<000000?ooo`3oool0@P3oool0
0`3o0000oooo0?ooo`390?ooo`006@3oool00`000000oooo0?ooo`130?ooo`030?l0003oool0oooo
0<P0oooo000I0?ooo`800000A@3oool00`3o0000oooo0?ooo`370?ooo`006@3oool00`000000oooo
0?ooo`150?ooo`030?l0003oool0oooo0<H0oooo000I0?ooo`030000003oool0oooo04H0oooo00<0
o`000?ooo`3oool0a@3oool001T0oooo00<000000?ooo`3oool0A`3oool00`3o0000oooo0?ooo`34
0?ooo`006@3oool00`000000oooo0?ooo`180?ooo`030?l0003oool0oooo0<<0oooo000I0?ooo`80
0000B@3oool00`3o0000oooo0?ooo`330?ooo`006@3oool00`000000oooo0?ooo`190?ooo`030?l0
003oool0oooo0<80oooo000I0?ooo`030000003oool0oooo04X0oooo00<0o`000?ooo`3oool0`@3o
ool001T0oooo00<000000?ooo`3oool0B`3oool00`3o0000oooo0?ooo`300?ooo`006@3oool00`00
0000oooo0?ooo`1<0?ooo`030?l0003oool0oooo0;l0oooo000I0?ooo`800000CP3oool00`3o0000
oooo0?ooo`2n0?ooo`006@3oool00`000000oooo0?ooo`1>0?ooo`030?l0003oool0oooo0;d0oooo
000I0?ooo`030000003oool0oooo04h0oooo00<0o`000?ooo`3oool0_@3oool001T0oooo00<00000
0?ooo`3oool0C`3oool00`3o0000oooo0?ooo`2l0?ooo`006@3oool200000540oooo00<0o`000?oo
o`3oool0^`3oool001T0oooo00<000000?ooo`3oool0D@3oool00`3o0000oooo0?ooo`2j0?ooo`00
6@3oool00`000000oooo0?ooo`1B0?ooo`030?l0003oool0oooo0;T0oooo000:0?ooo`D000000P3o
ool2000000H0oooo00<000000?ooo`3oool0D`3oool00`3o0000oooo0?ooo`2h0?ooo`00303oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`1C0?ooo`030?l0003oool0oooo0;P0oooo000<0?ooo`050000003oool0oooo0?ooo`0000000P3o
ool00`000000oooo0?ooo`030?ooo`800000E@3oool00`3o0000oooo0?ooo`2g0?ooo`00303oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`1E0?ooo`030?l0003oool0oooo0;H0oooo000<0?ooo`050000003oool0oooo0?ooo`0000000P3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo05H0oooo00<0o`000?ooo`3oool0]@3o
ool000/0oooo0P0000040?ooo`8000001P3oool00`000000oooo0?ooo`1G0?ooo`030?l0003oool0
oooo0;@0oooo000I0?ooo`030000003oool0oooo05L0oooo00<0o`000?ooo`3oool0]03oool001T0
oooo0P00001I0?ooo`030?l0003oool0oooo0;<0oooo000I0?ooo`030000003oool0oooo05T0oooo
00<0o`000?ooo`3oool0/P3oool001T0oooo00<000000?ooo`3oool0FP3oool00`3o0000oooo0?oo
o`2a0?ooo`006@3oool00`000000oooo0?ooo`1K0?ooo`030?l0003oool0oooo0;00oooo000I0?oo
o`030000003oool0oooo05/0oooo00<0o`000?ooo`3oool0/03oool001T0oooo0P00001M0?ooo`03
0?l0003oool0oooo0:l0oooo000I0?ooo`030000003oool0oooo05d0oooo00<0o`000?ooo`3oool0
[P3oool001T0oooo00<000000?ooo`3oool0GP3oool00`3o0000oooo0?ooo`2]0?ooo`006@3oool0
0`000000oooo0?ooo`1O0?ooo`030?l0003oool0oooo0:`0oooo000I0?ooo`030000003oool0oooo
05l0oooo00<0o`000?ooo`3oool0[03oool001T0oooo0P00001Q0?ooo`030?l0003oool0oooo0:/0
oooo000I0?ooo`030000003oool0oooo0640oooo00<0o`000?ooo`3oool0ZP3oool001T0oooo00<0
00000?ooo`3oool0HP3oool00`3o0000oooo0?ooo`2Y0?ooo`006@3oool00`000000oooo0?ooo`1S
0?ooo`030?l0003oool0oooo0:P0oooo000I0?ooo`030000003oool0oooo06<0oooo00<0o`000?oo
o`3oool0Z03oool001T0oooo0P00001U0?ooo`030?l0003oool0oooo0:L0oooo000I0?ooo`030000
003oool0oooo06D0oooo00<0o`000?ooo`3oool0YP3oool000X0oooo1@0000020?ooo`8000001P3o
ool00`000000oooo0?ooo`1V0?ooo`030?l0003oool0oooo0:D0oooo000<0?ooo`050000003oool0
oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo06L0oooo00<0
o`000?ooo`3oool0Y03oool000`0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`03
0?ooo`800000J03oool00`3o0000oooo0?ooo`2T0?ooo`00303oool00`000000oooo0?ooo`020?oo
o`8000001P3oool00`000000oooo0?ooo`1X0?ooo`030?l0003oool0oooo0:<0oooo000<0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1Y0?ooo`03
0?l0003oool0oooo0:80oooo000;0?ooo`800000103oool3000000D0oooo00<000000?ooo`3oool0
JP3oool00`3o0000oooo0?ooo`2Q0?ooo`006@3oool00`000000oooo0?ooo`1[0?ooo`030?l0003o
ool0oooo0:00oooo000I0?ooo`800000K@3oool00`3o0000oooo0?ooo`2O0?ooo`006@3oool00`00
0000oooo0?ooo`1/0?ooo`030?l0003oool0oooo09l0oooo000I0?ooo`030000003oool0oooo06d0
oooo00<0o`000?ooo`3oool0WP3oool001T0oooo00<000000?ooo`3oool0KP3oool00`3o0000oooo
0?ooo`2M0?ooo`006@3oool00`000000oooo0?ooo`1_0?ooo`030?l0003oool0oooo09`0oooo000I
0?ooo`800000L@3oool00`3o0000oooo0?ooo`2K0?ooo`006@3oool00`000000oooo0?ooo`1a0?oo
o`030?l0003oool0oooo09X0oooo000I0?ooo`030000003oool0oooo0780oooo00<0o`000?ooo`3o
ool0V@3oool001T0oooo00<000000?ooo`3oool0LP3oool00`3o0000oooo0?ooo`2I0?ooo`006@3o
ool00`000000oooo0?ooo`1c0?ooo`030?l0003oool0oooo09P0oooo000I0?ooo`800000M@3oool0
0`3o0000oooo0?ooo`2G0?ooo`006@3oool00`000000oooo0?ooo`1e0?ooo`030?l0003oool0oooo
09H0oooo000I0?ooo`030000003oool0oooo07H0oooo00<0o`000?ooo`3oool0U@3oool001T0oooo
00<000000?ooo`3oool0M`3oool00`3o0000oooo0?ooo`2D0?ooo`006@3oool00`000000oooo0?oo
o`1h0?ooo`030?l0003oool0oooo09<0oooo000I0?ooo`800000NP3oool00`3o0000oooo0?ooo`2B
0?ooo`006@3oool00`000000oooo0?ooo`1j0?ooo`030?l0003oool0oooo0940oooo000I0?ooo`03
0000003oool0oooo07/0oooo00<0o`000?ooo`3oool0T03oool000X0oooo100000030?ooo`800000
1P3oool00`000000oooo0?ooo`1k0?ooo`030?l0003oool0oooo0900oooo000:0?ooo`030000003o
ool0oooo00<0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`1l0?ooo`030?l0
003oool0oooo08l0oooo000;0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000
1@3oool2000007h0oooo00<0o`000?ooo`3oool0SP3oool000`0oooo00D000000?ooo`3oool0oooo
000000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0OP3oool00`3o0000oooo
0?ooo`2=0?ooo`002P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000D0
oooo00<000000?ooo`3oool0O`3oool00`3o0000oooo0?ooo`2<0?ooo`002`3oool2000000@0oooo
0P0000060?ooo`030000003oool0oooo0800oooo00<0o`000?ooo`3oool0R`3oool001T0oooo0P00
00220?ooo`030?l0003oool0oooo08X0oooo000I0?ooo`030000003oool0oooo0880oooo00<0o`00
0?ooo`3oool0R@3oool001T0oooo00<000000?ooo`3oool0P`3oool00`3o0000oooo0?ooo`280?oo
o`006@3oool00`000000oooo0?ooo`240?ooo`030?l0003oool0oooo08L0oooo000I0?ooo`030000
003oool0oooo08D0oooo00<0o`000?ooo`3oool0QP3oool001T0oooo0P0000270?ooo`030?l0003o
ool0oooo08D0oooo000I0?ooo`030000003oool0oooo08L0oooo00<0o`000?ooo`3oool0Q03oool0
01T0oooo00<000000?ooo`3oool0R03oool00`3o0000oooo0?ooo`230?ooo`006@3oool00`000000
oooo0?ooo`290?ooo`030?l0003oool0oooo0880oooo000I0?ooo`030000003oool0oooo08X0oooo
00<0o`000?ooo`3oool0P@3oool001T0oooo0P00002<0?ooo`030?l0003oool0oooo0800oooo000I
0?ooo`030000003oool0oooo08`0oooo00<0o`000?ooo`3oool0O`3oool001T0oooo00<000000?oo
o`3oool0S@3oool00`3o0000oooo0?ooo`1n0?ooo`006@3oool00`000000oooo0?ooo`2>0?ooo`80
o`00OP3oool001T0oooo00<000000?ooo`3oool0T03oool00`3o0000oooo0?ooo`1k0?ooo`006@3o
ool200000980oooo0P3o001k0?ooo`006@3oool00`000000oooo0?ooo`2C0?ooo`030?l0003oool0
oooo07P0oooo000I0?ooo`030000003oool0oooo09@0oooo0P3o001h0?ooo`002P3oool4000000<0
oooo0P0000060?ooo`030000003oool0oooo09H0oooo00<0o`000?ooo`3oool0M@3oool000X0oooo
00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo09L0
oooo0P3o001e0?ooo`002`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo
0P00002J0?ooo`030?l0003oool0oooo0780oooo000<0?ooo`030000003oool0oooo0080oooo0P00
00060?ooo`030000003oool0oooo09X0oooo0P3o001b0?ooo`002P3oool010000000oooo0?ooo`00
00030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0W03oool20?l00700oooo000;
0?ooo`800000103oool3000000D0oooo00<000000?ooo`3oool0WP3oool20?l006h0oooo000I0?oo
o`030000003oool0oooo0:00oooo0P3o001/0?ooo`006@3oool200000:<0oooo0P3o001Z0?ooo`00
6@3oool00`000000oooo0?ooo`2T0?ooo`<0o`00I`3oool001T0oooo00<000000?ooo`3oool0Y`3o
ool20?l006D0oooo000I0?ooo`030000003oool0oooo0:T0oooo0P3o001S0?ooo`006@3oool20000
0:`0oooo0`3o001P0?ooo`006@3oool00`000000oooo0?ooo`2^0?ooo`80o`00GP3oool001T0oooo
00<000000?ooo`3oool0/03oool30?l005/0oooo000I0?ooo`030000003oool0oooo0;<0oooo0`3o
001H0?ooo`006@3oool00`000000oooo0?ooo`2f0?ooo`<0o`00E@3oool001T0oooo0P00002j0?oo
o`<0o`00DP3oool001T0oooo00<000000?ooo`3oool0_03oool30?l004l0oooo000I0?ooo`030000
003oool0oooo0;l0oooo0`3o001<0?ooo`006@3oool00`000000oooo0?ooo`320?ooo`<0o`00B@3o
ool001T0oooo00<000000?ooo`3oool0a@3oool30?l004H0oooo000I0?ooo`800000b@3oool30?l0
04<0oooo000I0?ooo`030000003oool0oooo0</0oooo103o000o0?ooo`006@3oool00`000000oooo
0?ooo`3?0?ooo`@0o`00>`3oool000/0oooo0P0000040?ooo`8000001P3oool00`000000oooo0?oo
o`3C0?ooo`@0o`00=`3oool000X0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000050?ooo`030000003oool0oooo0=L0oooo103o000c0?ooo`00303oool01@000000oooo0?oo
o`3oool000000080oooo00<000000?ooo`3oool00`3oool200000=`0oooo103o000_0?ooo`003@3o
ool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
g`3oool40?l002/0oooo000:0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool0
00001@3oool00`000000oooo0?ooo`3S0?ooo`@0o`009`3oool000/0oooo0P0000040?ooo`800000
1P3oool00`000000oooo0?ooo`3W0?ooo`@0o`008`3oool001T0oooo00<000000?ooo`3oool0j`3o
ool30?l00200oooo000I0?ooo`800000o`3oool@0?ooo`006@3oool00`000000oooo0?ooo`3o0?oo
o`l0oooo000I0?ooo`030000003oool0oooo0?l0oooo3`3oool00?l0oooo:`3oool00?l0oooo:`3o
ool00?l0oooo:`3oool00?l0oooo:`3oool00?l0oooo:`3oool00?l0oooo:`3oool00?l0oooo:`3o
ool00?l0oooo:`3oool00?l0oooo:`3oool00?l0oooo:`3oool001P0oooo1000003o0?ooo`l0oooo
000G0?ooo`040000003oool0oooo00000?l0oooo403oool001L0oooo00@000000?ooo`3oool00000
o`3oool@0?ooo`005P3oool2000000030?ooo`00000000000?l0oooo403oool00?l0oooo:`3oool0
0?l0oooo:`3oool00?l0oooo:`3oool00?l0oooo:`3oool00?l0oooo:`3oool00001\
\>"],
  ImageRangeCache->{{{0, 297.813}, {183.688, 0}} -> {-0.208571, -2.51719, \
0.00831651, 0.207075}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.0190398 [
[.2619 .00222 -9 -9 ]
[.2619 .00222 9 0 ]
[.5 .00222 -3 -9 ]
[.5 .00222 3 0 ]
[.7381 .00222 -9 -9 ]
[.7381 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.4375 ]
[1.025 .01472 10 6.4375 ]
[.01131 .10991 -6 -4.5 ]
[.01131 .10991 0 4.5 ]
[.01131 .20511 -12 -4.5 ]
[.01131 .20511 0 4.5 ]
[.01131 .30031 -12 -4.5 ]
[.01131 .30031 0 4.5 ]
[.01131 .39551 -12 -4.5 ]
[.01131 .39551 0 4.5 ]
[.01131 .49071 -12 -4.5 ]
[.01131 .49071 0 4.5 ]
[.01131 .58591 -12 -4.5 ]
[.01131 .58591 0 4.5 ]
[.02381 .64303 -5.03125 0 ]
[.02381 .64303 5.03125 12.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(0.5)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(1)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(1.5)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(2)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .10991 m
.03006 .10991 L
s
[(5)] .01131 .10991 1 0 Mshowa
.02381 .20511 m
.03006 .20511 L
s
[(10)] .01131 .20511 1 0 Mshowa
.02381 .30031 m
.03006 .30031 L
s
[(15)] .01131 .30031 1 0 Mshowa
.02381 .39551 m
.03006 .39551 L
s
[(20)] .01131 .39551 1 0 Mshowa
.02381 .49071 m
.03006 .49071 L
s
[(25)] .01131 .49071 1 0 Mshowa
.02381 .58591 m
.03006 .58591 L
s
[(30)] .01131 .58591 1 0 Mshowa
.125 Mabswid
.02381 .03375 m
.02756 .03375 L
s
.02381 .05279 m
.02756 .05279 L
s
.02381 .07183 m
.02756 .07183 L
s
.02381 .09087 m
.02756 .09087 L
s
.02381 .12895 m
.02756 .12895 L
s
.02381 .14799 m
.02756 .14799 L
s
.02381 .16703 m
.02756 .16703 L
s
.02381 .18607 m
.02756 .18607 L
s
.02381 .22415 m
.02756 .22415 L
s
.02381 .24319 m
.02756 .24319 L
s
.02381 .26223 m
.02756 .26223 L
s
.02381 .28127 m
.02756 .28127 L
s
.02381 .31935 m
.02756 .31935 L
s
.02381 .33839 m
.02756 .33839 L
s
.02381 .35743 m
.02756 .35743 L
s
.02381 .37647 m
.02756 .37647 L
s
.02381 .41455 m
.02756 .41455 L
s
.02381 .43359 m
.02756 .43359 L
s
.02381 .45263 m
.02756 .45263 L
s
.02381 .47167 m
.02756 .47167 L
s
.02381 .50975 m
.02756 .50975 L
s
.02381 .52879 m
.02756 .52879 L
s
.02381 .54783 m
.02756 .54783 L
s
.02381 .56687 m
.02756 .56687 L
s
.02381 .60495 m
.02756 .60495 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66.0313 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 1 r
.5 Mabswid
.02381 .01472 m
.07143 .03451 L
.11905 .09137 L
.16667 .18054 L
.21429 .29787 L
.2619 .423 L
.30952 .52143 L
.35714 .57983 L
.40476 .60332 L
.45238 .59639 L
.5 .56293 L
.54762 .50634 L
.59524 .39876 L
.64286 .2827 L
.69048 .22606 L
.7381 .19896 L
.78571 .17534 L
.83333 .15475 L
.88095 .13679 L
.92857 .12114 L
.97619 .10749 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.813, 184.688},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oo`3oool[
0?ooo`00CP3oool2000000@0oooo0P0000040?ooo`800000<`3oool500000340oooo1@0000020?oo
o`800000103oool2000003<0oooo1000000O0?ooo`00C@3oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo000003@0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`07
0?ooo`040000003oool0oooo00000380oooo00<000000?ooo`3oool0803oool004d0oooo00@00000
0?ooo`3oool000002`3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo03<0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo01l0oooo001=
0?ooo`040000003oool0oooo000000T0oooo0P00000e0?ooo`030000003oool0oooo03<0oooo00<0
00000?ooo`3oool0203oool2000003D0oooo00<000000?ooo`3oool07P3oool004d0oooo00@00000
0?ooo`3oool000002@3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo03<0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0b0?ooo`040000003oool0oooo000001l0oooo
001>0?ooo`8000002P3oool3000003<0oooo0P00000d0?ooo`8000002P3oool3000003<0oooo0P00
000P0?ooo`00o`3oool[0?ooo`006@3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000I0?ooo`03
0000003oool0oooo0?l0oooo3`3oool001T0oooo00<000000?ooo`3oool0o@3oool2000000l0oooo
000I0?ooo`030000003oool0oooo0?`0oooo00@000000?ooo`3oool000003P3oool001<0oooo1P00
00020?l0ooD00000203oool00`000000oooo0?ooo`0?0?ooo`006@3oool010000000oooo0?l0o`3o
0?l80?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02`3oool5000000h0oooo000I
0?ooo`040000003oool0oooo0?ooo`80o`3o=P3oool00`000000oooo0?ooo`0i0?ooo`030000003o
ool0oooo03T0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00l0oooo000I0?ooo`030000003oool0oooo00<0oooo0`3o0?oo0?ooo`T0oooo000I0?oo
o`030000003oool0oooo00H0oooo0P3o0?oo0?ooo`L0oooo000I0?ooo`8000002@3oool20?l0ool0
oooo1@3oool001T0oooo00<000000?ooo`3oool02P3oool00`3o0?l0oooo0?ooo`3o0?ooo`80oooo
000I0?ooo`030000003oool0oooo00/0oooo00<0o`3o0?ooo`3oool0o`3oool10?ooo`006@3oool0
0`000000oooo0?ooo`0<0?ooo`030?l0o`3oool0oooo0?l0oooo000I0?ooo`030000003oool0oooo
00`0oooo00<0o`3o0?ooo`3oool0o`3oool001T0oooo0P00000>0?ooo`030?l0o`3oool0oooo0?h0
oooo000I0?ooo`030000003oool0oooo00h0oooo00<0o`3o0?ooo`3oool0o@3oool001T0oooo00<0
00000?ooo`3oool03`3oool00`3o0?l0oooo0?ooo`3l0?ooo`006@3oool00`000000oooo0?ooo`0@
0?ooo`030?l0o`3oool0oooo0?/0oooo000I0?ooo`8000004P3oool00`3o0?l0oooo0?ooo`3j0?oo
o`006@3oool00`000000oooo0?ooo`0B0?ooo`030?l0o`3oool0oooo0?T0oooo000I0?ooo`030000
003oool0oooo0180oooo00<0o`3o0?ooo`3oool0n@3oool001T0oooo00<000000?ooo`3oool04`3o
ool00`3o0?l0oooo0?ooo`3h0?ooo`006@3oool00`000000oooo0?ooo`0D0?ooo`030?l0o`3oool0
oooo0?L0oooo000I0?ooo`8000005P3oool00`3o0?l0oooo0?ooo`3f0?ooo`006@3oool00`000000
oooo0?ooo`0F0?ooo`030?l0o`3oool0oooo0?D0oooo000I0?ooo`030000003oool0oooo01H0oooo
00<0o`3o0?ooo`3oool0m@3oool00140oooo0P0000060?ooo`030000003oool0oooo01L0oooo00<0
o`3o0?ooo`3oool0m03oool00100oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?oo
o`0G0?ooo`030?l0o`3oool0oooo0=80oooo0P3o0?lP0?ooo`004`3oool00`000000oooo0?ooo`03
0?ooo`8000006@3oool00`3o0?l0oooo0?ooo`3>0?ooo`<0o`3o8P3oool00140oooo0P0000060?oo
o`030000003oool0oooo01P0oooo00<0o`3o0?ooo`3oool0b`3oool30?l0obD0oooo000A0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool06@3oool00`3o0?l0oooo0?ooo`370?ooo`<0
o`3o:03oool00140oooo0`0000050?ooo`030000003oool0oooo01T0oooo00<0o`3o0?ooo`3oool0
a03oool30?l0ob/0oooo000I0?ooo`030000003oool0oooo01X0oooo00<0o`3o0?ooo`3oool0`03o
ool30?l0obh0oooo000I0?ooo`8000006`3oool00`3o0?l0oooo0?ooo`2m0?ooo`<0o`3o<@3oool0
01T0oooo00<000000?ooo`3oool06`3oool00`3o0?l0oooo0?ooo`2i0?ooo`<0o`3o=03oool001T0
oooo00<000000?ooo`3oool06`3oool00`3o0?l0oooo0?ooo`2f0?ooo`<0o`3o=`3oool001T0oooo
00<000000?ooo`3oool0703oool00`3o0?l0oooo0?ooo`2b0?ooo`<0o`3o>P3oool001T0oooo00<0
00000?ooo`3oool0703oool00`3o0?l0oooo0?ooo`2_0?ooo`<0o`3o?@3oool001T0oooo0P00000N
0?ooo`030?l0o`3oool0oooo0:/0oooo0`3o0?m00?ooo`006@3oool00`000000oooo0?ooo`0M0?oo
o`030?l0o`3oool0oooo0:T0oooo0P3o0?m30?ooo`006@3oool00`000000oooo0?ooo`0N0?ooo`03
0?l0o`3oool0oooo0:H0oooo0P3o0?m50?ooo`006@3oool00`000000oooo0?ooo`0N0?ooo`030?l0
o`3oool0oooo0:@0oooo0P3o0?m70?ooo`006@3oool200000200oooo00<0o`3o0?ooo`3oool0X@3o
ool20?l0odT0oooo000I0?ooo`030000003oool0oooo01l0oooo00<0o`3o0?ooo`3oool0W`3oool2
0?l0od/0oooo000I0?ooo`030000003oool0oooo0200oooo00<0o`3o0?ooo`3oool0W03oool20?l0
odd0oooo000I0?ooo`030000003oool0oooo0200oooo00<0o`3o0?ooo`3oool0V@3oool30?l0odl0
oooo000I0?ooo`030000003oool0oooo0240oooo00<0o`3o0?ooo`3oool0UP3oool20?l0oe80oooo
000I0?ooo`8000008P3oool00`3o0?l0oooo0?ooo`2D0?ooo`80o`3oE03oool001T0oooo00<00000
0?ooo`3oool08P3oool00`3o0?l0oooo0?ooo`2@0?ooo`<0o`3oEP3oool001T0oooo00<000000?oo
o`3oool08P3oool00`3o0?l0oooo0?ooo`2>0?ooo`80o`3oF@3oool000X0oooo1@0000020?ooo`80
00001P3oool00`000000oooo0?ooo`0S0?ooo`030?l0o`3oool0oooo08/0oooo0P3o0?mK0?ooo`00
303oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0S0?ooo`030?l0o`3oool0oooo08T0oooo0P3o0?mM0?ooo`00303oool01@000000oooo
0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool2000002@0oooo00<0o`3o0?ooo`3o
ool0Q`3oool20?l0oel0oooo000<0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo02@0oooo00<0o`3o0?ooo`3oool0Q@3oool00`3o0?l0
oooo0?ooo`1O0?ooo`00303oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0T0?ooo`030?l0o`3oool0oooo08<0oooo0P3o0?mR0?ooo`00
2`3oool2000000@0oooo0P0000060?ooo`030000003oool0oooo02D0oooo00<0o`3o0?ooo`3oool0
P03oool20?l0of@0oooo000I0?ooo`030000003oool0oooo02D0oooo00<0o`3o0?ooo`3oool0OP3o
ool20?l0ofH0oooo000I0?ooo`8000009`3oool00`3o0?l0oooo0?ooo`1l0?ooo`030?l0o`3oool0
oooo06H0oooo000I0?ooo`030000003oool0oooo02H0oooo00<0o`3o0?ooo`3oool0N`3oool00`3o
0?l0oooo0?ooo`1W0?ooo`006@3oool00`000000oooo0?ooo`0V0?ooo`030?l0o`3oool0oooo07X0
oooo00<0o`3o0?ooo`3oool0J03oool001T0oooo00<000000?ooo`3oool09`3oool00`3o0?l0oooo
0?ooo`1i0?ooo`030?l0o`3oool0oooo06P0oooo000I0?ooo`030000003oool0oooo02L0oooo00<0
o`3o0?ooo`3oool0N03oool00`3o0?l0oooo0?ooo`1Y0?ooo`006@3oool2000002T0oooo00<0o`3o
0?ooo`3oool0MP3oool00`3o0?l0oooo0?ooo`1Z0?ooo`006@3oool00`000000oooo0?ooo`0X0?oo
o`030?l0o`3oool0oooo07D0oooo00<0o`3o0?ooo`3oool0J`3oool001T0oooo00<000000?ooo`3o
ool0:03oool00`3o0?l0oooo0?ooo`1d0?ooo`030?l0o`3oool0oooo06`0oooo000I0?ooo`030000
003oool0oooo02T0oooo00<0o`3o0?ooo`3oool0L`3oool00`3o0?l0oooo0?ooo`1/0?ooo`006@3o
ool2000002X0oooo00<0o`3o0?ooo`3oool0LP3oool00`3o0?l0oooo0?ooo`1]0?ooo`006@3oool0
0`000000oooo0?ooo`0Z0?ooo`030?l0o`3oool0oooo0700oooo00<0o`3o0?ooo`3oool0KP3oool0
01T0oooo00<000000?ooo`3oool0:P3oool00`3o0?l0oooo0?ooo`1_0?ooo`030?l0o`3oool0oooo
06l0oooo000I0?ooo`030000003oool0oooo02/0oooo00<0o`3o0?ooo`3oool0K@3oool00`3o0?l0
oooo0?ooo`1`0?ooo`006@3oool00`000000oooo0?ooo`0[0?ooo`030?l0o`3oool0oooo06d0oooo
00<0o`3o0?ooo`3oool0L03oool001T0oooo0P00000/0?ooo`030?l0o`3oool0oooo06`0oooo00<0
o`3o0?ooo`3oool0L@3oool001T0oooo00<000000?ooo`3oool0;03oool00`3o0?l0oooo0?ooo`1Z
0?ooo`030?l0o`3oool0oooo0780oooo000I0?ooo`030000003oool0oooo02`0oooo00<0o`3o0?oo
o`3oool0JP3oool00`3o0?l0oooo0?ooo`1b0?ooo`002P3oool500000080oooo0P0000060?ooo`03
0000003oool0oooo02d0oooo00<0o`3o0?ooo`3oool0J03oool00`3o0?l0oooo0?ooo`1c0?ooo`00
303oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0]0?ooo`030?l0o`3oool0oooo06P0oooo00<0o`3o0?ooo`3oool0L`3oool000`0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`800000;P3oool00`3o0?l0oooo
0?ooo`1W0?ooo`030?l0o`3oool0oooo07@0oooo000<0?ooo`030000003oool0oooo0080oooo0P00
00060?ooo`030000003oool0oooo02h0oooo00<0o`3o0?ooo`3oool0IP3oool00`3o0?l0oooo0?oo
o`1d0?ooo`00303oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0;P3oool00`3o0?l0oooo0?ooo`1V0?ooo`030?l0o`3oool0oooo07@0oooo000;0?oo
o`800000103oool3000000D0oooo00<000000?ooo`3oool0;P3oool00`3o0?l0oooo0?ooo`1U0?oo
o`030?l0o`3oool0oooo07D0oooo000I0?ooo`030000003oool0oooo02l0oooo00<0o`3o0?ooo`3o
ool0I03oool00`3o0?l0oooo0?ooo`1e0?ooo`006@3oool200000300oooo00<0o`3o0?ooo`3oool0
H`3oool00`3o0?l0oooo0?ooo`1f0?ooo`006@3oool00`000000oooo0?ooo`0`0?ooo`030?l0o`3o
ool0oooo0680oooo00<0o`3o0?ooo`3oool0MP3oool001T0oooo00<000000?ooo`3oool0<03oool0
0`3o0?l0oooo0?ooo`1Q0?ooo`030?l0o`3oool0oooo07L0oooo000I0?ooo`030000003oool0oooo
0300oooo00<0o`3o0?ooo`3oool0H@3oool00`3o0?l0oooo0?ooo`1g0?ooo`006@3oool00`000000
oooo0?ooo`0a0?ooo`030?l0o`3oool0oooo0600oooo00<0o`3o0?ooo`3oool0M`3oool001T0oooo
0P00000b0?ooo`030?l0o`3oool0oooo05l0oooo00<0o`3o0?ooo`3oool0N03oool001T0oooo00<0
00000?ooo`3oool0<@3oool00`3o0?l0oooo0?ooo`1O0?ooo`030?l0o`3oool0oooo07P0oooo000I
0?ooo`030000003oool0oooo0380oooo00<0o`3o0?ooo`3oool0G@3oool00`3o0?l0oooo0?ooo`1i
0?ooo`006@3oool00`000000oooo0?ooo`0b0?ooo`030?l0o`3oool0oooo05d0oooo00<0o`3o0?oo
o`3oool0N@3oool001T0oooo00<000000?ooo`3oool0<`3oool00`3o0?l0oooo0?ooo`1L0?ooo`03
0?l0o`3oool0oooo07T0oooo000I0?ooo`800000=03oool00`3o0?l0oooo0?ooo`1K0?ooo`030?l0
o`3oool0oooo07X0oooo000I0?ooo`030000003oool0oooo03<0oooo00<0o`3o0?ooo`3oool0F`3o
ool00`3o0?l0oooo0?ooo`1j0?ooo`006@3oool00`000000oooo0?ooo`0d0?ooo`030?l0o`3oool0
oooo05T0oooo00<0o`3o0?ooo`3oool0N`3oool001T0oooo00<000000?ooo`3oool0=03oool00`3o
0?l0oooo0?ooo`1I0?ooo`030?l0o`3oool0oooo07/0oooo000I0?ooo`800000=@3oool00`3o0?l0
oooo0?ooo`1H0?ooo`030?l0o`3oool0oooo07`0oooo000I0?ooo`030000003oool0oooo03D0oooo
00<0o`3o0?ooo`3oool0E`3oool00`3o0?l0oooo0?ooo`1l0?ooo`006@3oool00`000000oooo0?oo
o`0e0?ooo`030?l0o`3oool0oooo05L0oooo00<0o`3o0?ooo`3oool0O03oool000X0oooo10000003
0?ooo`8000001P3oool00`000000oooo0?ooo`0f0?ooo`030?l0o`3oool0oooo05D0oooo00<0o`3o
0?ooo`3oool0O@3oool000X0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`000005
0?ooo`030000003oool0oooo03H0oooo00<0o`3o0?ooo`3oool0E@3oool00`3o0?l0oooo0?ooo`1m
0?ooo`002`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000D0oooo0P00000g
0?ooo`030?l0o`3oool0oooo05@0oooo00<0o`3o0?ooo`3oool0OP3oool000`0oooo00D000000?oo
o`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0=`3oool0
0`3o0?l0oooo0?ooo`1C0?ooo`030?l0o`3oool0oooo07h0oooo000:0?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`0g0?ooo`030?l0o`3o
ool0oooo05<0oooo00<0o`3o0?ooo`3oool0OP3oool000/0oooo0P0000040?ooo`8000001P3oool0
0`000000oooo0?ooo`0g0?ooo`030?l0o`3oool0oooo0580oooo00<0o`3o0?ooo`3oool0O`3oool0
01T0oooo00<000000?ooo`3oool0>03oool00`3o0?l0oooo0?ooo`1A0?ooo`030?l0o`3oool0oooo
07l0oooo000I0?ooo`800000>@3oool00`3o0?l0oooo0?ooo`1@0?ooo`030?l0o`3oool0oooo0800
oooo000I0?ooo`030000003oool0oooo03T0oooo00<0o`3o0?ooo`3oool0C`3oool00`3o0?l0oooo
0?ooo`200?ooo`006@3oool00`000000oooo0?ooo`0i0?ooo`030?l0o`3oool0oooo04h0oooo00<0
o`3o0?ooo`3oool0P@3oool001T0oooo00<000000?ooo`3oool0>@3oool00`3o0?l0oooo0?ooo`1>
0?ooo`030?l0o`3oool0oooo0840oooo000I0?ooo`030000003oool0oooo03X0oooo00<0o`3o0?oo
o`3oool0C03oool00`3o0?l0oooo0?ooo`220?ooo`006@3oool2000003/0oooo00<0o`3o0?ooo`3o
ool0C03oool00`3o0?l0oooo0?ooo`220?ooo`006@3oool00`000000oooo0?ooo`0k0?ooo`030?l0
o`3oool0oooo04/0oooo00<0o`3o0?ooo`3oool0PP3oool001T0oooo00<000000?ooo`3oool0>`3o
ool00`3o0?l0oooo0?ooo`1:0?ooo`030?l0o`3oool0oooo08<0oooo000I0?ooo`030000003oool0
oooo03`0oooo00<0o`3o0?ooo`3oool0B@3oool00`3o0?l0oooo0?ooo`230?ooo`006@3oool00`00
0000oooo0?ooo`0l0?ooo`030?l0o`3oool0oooo04P0oooo00<0o`3o0?ooo`3oool0Q03oool001T0
oooo0P00000n0?ooo`030?l0o`3oool0oooo04L0oooo00<0o`3o0?ooo`3oool0Q03oool001T0oooo
00<000000?ooo`3oool0?@3oool00`3o0?l0oooo0?ooo`160?ooo`030?l0o`3oool0oooo08D0oooo
000I0?ooo`030000003oool0oooo03h0oooo00<0o`3o0?ooo`3oool0A@3oool00`3o0?l0oooo0?oo
o`250?ooo`006@3oool00`000000oooo0?ooo`0n0?ooo`030?l0o`3oool0oooo04@0oooo00<0o`3o
0?ooo`3oool0QP3oool001T0oooo0P0000100?ooo`030?l0o`3oool0oooo04<0oooo00<0o`3o0?oo
o`3oool0QP3oool001T0oooo00<000000?ooo`3oool0?`3oool00`3o0?l0oooo0?ooo`130?ooo`03
0?l0o`3oool0oooo08H0oooo000I0?ooo`030000003oool0oooo0400oooo00<0o`3o0?ooo`3oool0
@@3oool00`3o0?l0oooo0?ooo`270?ooo`002P3oool4000000<0oooo0P0000060?ooo`030000003o
ool0oooo0400oooo00<0o`3o0?ooo`3oool0@@3oool00`3o0?l0oooo0?ooo`270?ooo`002P3oool0
0`000000oooo0?ooo`030?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0@@3o
ool00`3o0?l0oooo0?ooo`0o0?ooo`030?l0o`3oool0oooo08P0oooo000;0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool00`3oool200000480oooo00<0o`3o0?ooo`3oool0?`3oool0
0`3o0?l0oooo0?ooo`280?ooo`00303oool00`000000oooo0?ooo`020?ooo`8000001P3oool00`00
0000oooo0?ooo`120?ooo`030?l0o`3oool0oooo03d0oooo00<0o`3o0?ooo`3oool0R@3oool000X0
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0480oooo00<0o`3o0?ooo`3oool0?@3oool00`3o0?l0oooo0?ooo`290?ooo`002`3oool2000000@0
oooo0`0000050?ooo`030000003oool0oooo04<0oooo00<0o`3o0?ooo`3oool0>`3oool00`3o0?l0
oooo0?ooo`2:0?ooo`006@3oool00`000000oooo0?ooo`130?ooo`030?l0o`3oool0oooo03/0oooo
00<0o`3o0?ooo`3oool0RP3oool001T0oooo0P0000150?ooo`030?l0o`3oool0oooo03T0oooo00<0
o`3o0?ooo`3oool0R`3oool001T0oooo00<000000?ooo`3oool0A03oool00`3o0?l0oooo0?ooo`0h
0?ooo`030?l0o`3oool0oooo08`0oooo000I0?ooo`030000003oool0oooo04D0oooo00<0o`3o0?oo
o`3oool0=P3oool00`3o0?l0oooo0?ooo`2=0?ooo`006@3oool00`000000oooo0?ooo`150?ooo`03
0?l0o`3oool0oooo03H0oooo00<0o`3o0?ooo`3oool0S@3oool001T0oooo00<000000?ooo`3oool0
AP3oool00`3o0?l0oooo0?ooo`0d0?ooo`030?l0o`3oool0oooo08h0oooo000I0?ooo`800000B03o
ool00`3o0?l0oooo0?ooo`0b0?ooo`030?l0o`3oool0oooo08l0oooo000I0?ooo`030000003oool0
oooo04L0oooo00<0o`3o0?ooo`3oool0<@3oool00`3o0?l0oooo0?ooo`2@0?ooo`006@3oool00`00
0000oooo0?ooo`180?ooo`030?l0o`3oool0oooo02l0oooo00<0o`3o0?ooo`3oool0T@3oool001T0
oooo00<000000?ooo`3oool0B@3oool00`3o0?l0oooo0?ooo`0]0?ooo`030?l0o`3oool0oooo0980
oooo000I0?ooo`030000003oool0oooo04X0oooo00<0o`3o0?ooo`3oool0:`3oool00`3o0?l0oooo
0?ooo`2C0?ooo`006@3oool2000004`0oooo00<0o`3o0?ooo`3oool0:P3oool00`3o0?l0oooo0?oo
o`2C0?ooo`006@3oool00`000000oooo0?ooo`1;0?ooo`030?l0o`3oool0oooo02T0oooo00<0o`3o
0?ooo`3oool0U03oool001T0oooo00<000000?ooo`3oool0C03oool00`3o0?l0oooo0?ooo`0W0?oo
o`030?l0o`3oool0oooo09D0oooo000I0?ooo`030000003oool0oooo04d0oooo00<0o`3o0?ooo`3o
ool09@3oool00`3o0?l0oooo0?ooo`2F0?ooo`006@3oool2000004l0oooo00<0o`3o0?ooo`3oool0
8`3oool00`3o0?l0oooo0?ooo`2G0?ooo`006@3oool00`000000oooo0?ooo`1?0?ooo`030?l0o`3o
ool0oooo0200oooo0P3o0?nJ0?ooo`006@3oool00`000000oooo0?ooo`1?0?ooo`030?l0o`3oool0
oooo01l0oooo00<0o`3o0?ooo`3oool0VP3oool000/0oooo0P0000040?ooo`8000001P3oool00`00
0000oooo0?ooo`1@0?ooo`030?l0o`3oool0oooo01d0oooo00<0o`3o0?ooo`3oool0V`3oool000X0
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0
oooo0540oooo00<0o`3o0?ooo`3oool06P3oool20?l0oih0oooo000<0?ooo`050000003oool0oooo
0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`800000D`3oool20?l0oaT0oooo00<0o`3o
0?ooo`3oool0WP3oool000d0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo05@0oooo0P3o0?lF0?ooo`030?l0o`3oool0oooo09l0oooo000:0?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?oo
o`1F0?ooo`80o`3o4P3oool20?l0oj80oooo000;0?ooo`800000103oool2000000H0oooo00<00000
0?ooo`3oool0F03oool20?l0o`d0oooo0`3o0?nT0?ooo`006@3oool00`000000oooo0?ooo`1J0?oo
o`80o`3o1@3oool60?l0ojL0oooo000I0?ooo`800000G@3oool50?l0ojd0oooo000I0?ooo`030000
003oool0oooo0?l0oooo3`3oool001T0oooo00<000000?ooo`3oool0o`3oool?0?ooo`006@3oool0
0`000000oooo0?ooo`3o0?ooo`l0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo
003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo
003o0?ooob/0oooo003o0?ooob/0oooo000H0?ooo`800000o`3ooolA0?ooo`00603oool200000?l0
oooo4@3oool001L0oooo00@000000?ooo`3oool00000o`3oool@0?ooo`005P3oool200000080oooo
0P00003o0?ooo`l0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0
oooo003o0?ooob/0oooo0000\
\>"],
  ImageRangeCache->{{{0, 297.813}, {183.688, 0}} -> {-0.208571, -2.52841, \
0.00831651, 0.207998}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.327381 0.00402744 [
[.2619 .31488 -9 -9 ]
[.2619 .31488 9 0 ]
[.5 .31488 -3 -9 ]
[.5 .31488 3 0 ]
[.7381 .31488 -9 -9 ]
[.7381 .31488 9 0 ]
[.97619 .31488 -3 -9 ]
[.97619 .31488 3 0 ]
[1.025 .32738 0 -6.4375 ]
[1.025 .32738 10 6.4375 ]
[.01131 .00519 -18 -4.5 ]
[.01131 .00519 0 4.5 ]
[.01131 .08573 -18 -4.5 ]
[.01131 .08573 0 4.5 ]
[.01131 .16628 -18 -4.5 ]
[.01131 .16628 0 4.5 ]
[.01131 .24683 -18 -4.5 ]
[.01131 .24683 0 4.5 ]
[.01131 .40793 -12 -4.5 ]
[.01131 .40793 0 4.5 ]
[.01131 .48848 -12 -4.5 ]
[.01131 .48848 0 4.5 ]
[.01131 .56903 -12 -4.5 ]
[.01131 .56903 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .32738 m
.2619 .33363 L
s
[(0.5)] .2619 .31488 0 1 Mshowa
.5 .32738 m
.5 .33363 L
s
[(1)] .5 .31488 0 1 Mshowa
.7381 .32738 m
.7381 .33363 L
s
[(1.5)] .7381 .31488 0 1 Mshowa
.97619 .32738 m
.97619 .33363 L
s
[(2)] .97619 .31488 0 1 Mshowa
.125 Mabswid
.07143 .32738 m
.07143 .33113 L
s
.11905 .32738 m
.11905 .33113 L
s
.16667 .32738 m
.16667 .33113 L
s
.21429 .32738 m
.21429 .33113 L
s
.30952 .32738 m
.30952 .33113 L
s
.35714 .32738 m
.35714 .33113 L
s
.40476 .32738 m
.40476 .33113 L
s
.45238 .32738 m
.45238 .33113 L
s
.54762 .32738 m
.54762 .33113 L
s
.59524 .32738 m
.59524 .33113 L
s
.64286 .32738 m
.64286 .33113 L
s
.69048 .32738 m
.69048 .33113 L
s
.78571 .32738 m
.78571 .33113 L
s
.83333 .32738 m
.83333 .33113 L
s
.88095 .32738 m
.88095 .33113 L
s
.92857 .32738 m
.92857 .33113 L
s
.25 Mabswid
0 .32738 m
1 .32738 L
s
gsave
1.025 .32738 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .00519 m
.03006 .00519 L
s
[(-80)] .01131 .00519 1 0 Mshowa
.02381 .08573 m
.03006 .08573 L
s
[(-60)] .01131 .08573 1 0 Mshowa
.02381 .16628 m
.03006 .16628 L
s
[(-40)] .01131 .16628 1 0 Mshowa
.02381 .24683 m
.03006 .24683 L
s
[(-20)] .01131 .24683 1 0 Mshowa
.02381 .40793 m
.03006 .40793 L
s
[(20)] .01131 .40793 1 0 Mshowa
.02381 .48848 m
.03006 .48848 L
s
[(40)] .01131 .48848 1 0 Mshowa
.02381 .56903 m
.03006 .56903 L
s
[(60)] .01131 .56903 1 0 Mshowa
.125 Mabswid
.02381 .02532 m
.02756 .02532 L
s
.02381 .04546 m
.02756 .04546 L
s
.02381 .0656 m
.02756 .0656 L
s
.02381 .10587 m
.02756 .10587 L
s
.02381 .12601 m
.02756 .12601 L
s
.02381 .14615 m
.02756 .14615 L
s
.02381 .18642 m
.02756 .18642 L
s
.02381 .20656 m
.02756 .20656 L
s
.02381 .22669 m
.02756 .22669 L
s
.02381 .26697 m
.02756 .26697 L
s
.02381 .28711 m
.02756 .28711 L
s
.02381 .30724 m
.02756 .30724 L
s
.02381 .34752 m
.02756 .34752 L
s
.02381 .36766 m
.02756 .36766 L
s
.02381 .38779 m
.02756 .38779 L
s
.02381 .42807 m
.02756 .42807 L
s
.02381 .4482 m
.02756 .4482 L
s
.02381 .46834 m
.02756 .46834 L
s
.02381 .50862 m
.02756 .50862 L
s
.02381 .52875 m
.02756 .52875 L
s
.02381 .54889 m
.02756 .54889 L
s
.02381 .58916 m
.02756 .58916 L
s
.02381 .6093 m
.02756 .6093 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.875 translate 1 -1 scale
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .32738 m
.07143 .41114 L
.11905 .48416 L
.16667 .54782 L
.21429 .60332 L
.2619 .58083 L
.30952 .49034 L
.35714 .41146 L
.40476 .34269 L
.45238 .28274 L
.5 .23047 L
.54762 .18491 L
.59524 .01472 L
.64286 .14904 L
.69048 .26613 L
.7381 .27399 L
.78571 .28083 L
.83333 .2868 L
.88095 .292 L
.92857 .29654 L
.97619 .30049 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.813, 184.688},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^2000`400?l00000o`00003oo`3oool[
0?ooo`00o`3oool[0?ooo`002P3oool2000000@0oooo0P00003o0?oooaT0oooo00090?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`3o0?oo
oa00oooo00090?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000001@3oool2
00000?l0oooo4@3oool000<0oooo100000030?ooo`8000000`3oool010000000oooo0?ooo`000005
0?ooo`030000003oool0oooo0?l0oooo403oool000T0oooo00@000000?ooo`3oool000000P3oool0
10000000oooo0?ooo`0000050?ooo`030000003oool0oooo0?l0oooo403oool000X0oooo0P000004
0?ooo`8000001P3oool00`000000oooo0?ooo`2B0?ooo`030000o`3oool0oooo07X0oooo000H0?oo
o`030000003oool0oooo0980oooo00<0003o0?ooo`3oool0NP3oool001P0oooo00<000000?ooo`3o
ool0T@3oool00`000?l0oooo0000o`1k0?ooo`00603oool00`000000oooo0?ooo`2A0?ooo`030000
o`3oool0003o07/0oooo000H0?ooo`030000003oool0oooo0940oooo00<0003o0?ooo`000?l0N`3o
ool001P0oooo00<000000?ooo`3oool0T@3oool010000?l0oooo0?ooo`000?mj0?ooo`00603oool0
0`000000oooo0?ooo`2@0?ooo`050000o`3oool0oooo0?ooo`000?l0NP3oool001P0oooo00<00000
0?ooo`3oool0T03oool01@000?l0oooo0?ooo`3oool0003o07X0oooo000H0?ooo`030000003oool0
oooo0900oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0?ooo`1g0?ooo`00603oool00`00
0000oooo0?ooo`2?0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool0M`3oool001P0
oooo00<000000?ooo`3oool0S`3oool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0oooo07L0
oooo000H0?ooo`030000003oool0oooo08l0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo
0?ooo`1f0?ooo`00603oool00`000000oooo0?ooo`2>0?ooo`030000o`3oool0oooo00D0oooo00<0
003o0?ooo`3oool0MP3oool001P0oooo00<000000?ooo`3oool0SP3oool00`000?l0oooo0?ooo`05
0?ooo`030000o`3oool0oooo07H0oooo000H0?ooo`030000003oool0oooo08h0oooo00<0003o0?oo
o`3oool01P3oool00`000?l0oooo0?ooo`1e0?ooo`00603oool00`000000oooo0?ooo`2>0?ooo`03
0000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool0M@3oool000T0oooo0`0000040?ooo`800000
1P3oool00`000000oooo0?ooo`2=0?ooo`030000o`3oool0oooo00L0oooo00<0003o0?ooo`3oool0
M@3oool000T0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`03
0000003oool0oooo08d0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`1d0?ooo`00
2@3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000D0oooo0P00002>0?oo
o`030000o`3oool0oooo00P0oooo00<0003o0?ooo`3oool0M03oool000<0oooo100000020?ooo`<0
00000`3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo08`0oooo00<0003o0?oo
o`3oool02P3oool00`000?l0oooo0?ooo`1c0?ooo`002P3oool00`000000oooo0?ooo`020?ooo`04
0000003oool0oooo000000D0oooo00<000000?ooo`3oool0S03oool00`000?l0oooo0?ooo`0:0?oo
o`030000o`3oool0oooo07<0oooo000:0?ooo`<000000`3oool2000000H0oooo00<000000?ooo`3o
ool0S03oool00`000?l0oooo0?ooo`0:0?ooo`030000o`3oool0oooo07<0oooo000H0?ooo`030000
003oool0oooo08/0oooo00<0003o0?ooo`3oool0303oool00`000?l0oooo0?ooo`1b0?ooo`00603o
ool00`000000oooo0?ooo`2;0?ooo`030000o`3oool0oooo00`0oooo00<0003o0?ooo`3oool0LP3o
ool001P0oooo00<000000?ooo`3oool0R`3oool00`000?l0oooo0?ooo`0<0?ooo`030000o`3oool0
oooo0780oooo000H0?ooo`030000003oool0oooo08/0oooo00<0003o0?ooo`3oool03@3oool00`00
0?l0oooo0?ooo`1a0?ooo`00603oool00`000000oooo0?ooo`2:0?ooo`030000o`3oool0oooo00h0
oooo00<0003o0?ooo`3oool0L@3oool001P0oooo00<000000?ooo`3oool0RP3oool00`000?l0oooo
0?ooo`0>0?ooo`030000o`3oool0oooo0740oooo000H0?ooo`030000003oool0oooo08X0oooo00<0
003o0?ooo`3oool03`3oool00`000?l0oooo0?ooo`1`0?ooo`00603oool00`000000oooo0?ooo`29
0?ooo`030000o`3oool0oooo0100oooo00<0003o0?ooo`3oool0L03oool001P0oooo00<000000?oo
o`3oool0R@3oool00`000?l0oooo0?ooo`0@0?ooo`030000o`3oool0oooo0700oooo000H0?ooo`03
0000003oool0oooo08T0oooo00<0003o0?ooo`3oool04@3oool00`000?l0oooo0?ooo`1_0?ooo`00
603oool00`000000oooo0?ooo`290?ooo`030000o`3oool0oooo0140oooo00<0003o0?ooo`3oool0
K`3oool001P0oooo00<000000?ooo`3oool0R03oool00`000?l0oooo0?ooo`0B0?ooo`030000o`3o
ool0oooo06l0oooo000H0?ooo`030000003oool0oooo08P0oooo00<0003o0?ooo`3oool04`3oool0
0`000?l0oooo0?ooo`1^0?ooo`00603oool00`000000oooo0?ooo`280?ooo`030000o`3oool0oooo
01<0oooo00<0003o0?ooo`3oool0KP3oool001P0oooo00<000000?ooo`3oool0Q`3oool00`000?l0
oooo0?ooo`0D0?ooo`030000o`3oool0oooo06h0oooo000;0?ooo`<000000P3oool2000000H0oooo
00<000000?ooo`3oool0Q`3oool00`000?l0oooo0?ooo`0E0?ooo`030000o`3oool0oooo06d0oooo
000<0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`270?ooo`030000o`3oool0oooo01D0oooo00<0003o0?ooo`3oool0K@3oool000T0oooo1@00
00001@3oool000000?ooo`3oool0000000D0oooo0P0000270?ooo`030000o`3oool0oooo01L0oooo
00<0003o0?ooo`3oool0K03oool000<0oooo100000020?ooo`040000003oool0oooo00000080oooo
00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`260?ooo`030000o`3oool0oooo01L0
oooo00<0003o0?ooo`3oool0K03oool000X0oooo00<000000?ooo`0000000P3oool010000000oooo
0?ooo`0000050?ooo`030000003oool0oooo08H0oooo00<0003o0?ooo`3oool05`3oool00`000?l0
oooo0?ooo`1/0?ooo`002`3oool2000000<0oooo0P0000060?ooo`030000003oool0oooo08H0oooo
00<0003o0?ooo`3oool0603oool00`000?l0oooo0?ooo`1[0?ooo`00603oool00`000000oooo0?oo
o`250?ooo`030000o`3oool0oooo01T0oooo00<0003o0?ooo`3oool0J`3oool001P0oooo00<00000
0?ooo`3oool0Q@3oool00`000?l0oooo0?ooo`0J0?ooo`030000o`3oool0oooo06X0oooo000H0?oo
o`030000003oool0oooo08@0oooo00<0003o0?ooo`3oool06`3oool00`000?l0oooo0?ooo`1Z0?oo
o`00603oool00`000000oooo0?ooo`230?ooo`030000o`3oool0oooo01`0oooo00<0003o0?ooo`3o
ool0JP3oool001P0oooo00<000000?ooo`3oool0PP3oool00`000?l0oooo0?ooo`0N0?ooo`030000
o`3oool0oooo06T0oooo000H0?ooo`030000003oool0oooo0840oooo00<0003o0?ooo`3oool07`3o
ool00`000?l0oooo0?ooo`1Y0?ooo`00603oool00`000000oooo0?ooo`200?ooo`030000o`3oool0
oooo0240oooo00<0003o0?ooo`3oool0J03oool001P0oooo00<000000?ooo`3oool0O`3oool00`00
0?l0oooo0?ooo`0R0?ooo`030000o`3oool0oooo06P0oooo000H0?ooo`030000003oool0oooo07h0
oooo00<0003o0?ooo`3oool08`3oool00`000?l0oooo0?ooo`1X0?ooo`00603oool00`000000oooo
0?ooo`1m0?ooo`030000o`3oool0oooo02D0oooo00<0003o0?ooo`3oool0I`3oool001P0oooo00<0
00000?ooo`3oool0O03oool00`000?l0oooo0?ooo`0V0?ooo`030000o`3oool0oooo06L0oooo000H
0?ooo`030000003oool0oooo07/0oooo00<0003o0?ooo`3oool0:03oool00`000?l0oooo0?ooo`1V
0?ooo`00603oool00`000000oooo0?ooo`1j0?ooo`030000o`3oool0oooo02T0oooo00<0003o0?oo
o`3oool0IP3oool001P0oooo00<000000?ooo`3oool0N@3oool00`000?l0oooo0?ooo`0Z0?ooo`03
0000o`3oool0oooo06H0oooo000H0?ooo`030000003oool0oooo07P0oooo00<0003o0?ooo`3oool0
;03oool00`000?l0oooo0?ooo`1U0?ooo`002@3oool4000000<0oooo0P0000060?ooo`030000003o
ool0oooo07L0oooo00<0003o0?ooo`3oool0;@3oool00`000?l0oooo0?ooo`1U0?ooo`002@3oool0
0`000000oooo0?ooo`030?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0MP3o
ool00`000?l0oooo0?ooo`0_0?ooo`030000o`3oool0oooo06@0oooo000:0?ooo`030000003oool0
oooo0080oooo00@000000?ooo`3oool000001@3oool2000007H0oooo00<0003o0?ooo`3oool0<03o
ool00`000?l0oooo0?ooo`1T0?ooo`000`3oool4000000@0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0M03oool00`000?l0oooo0?oo
o`0a0?ooo`030000o`3oool0oooo06@0oooo00090?ooo`040000003oool0oooo00000080oooo00@0
00000?ooo`3oool000001@3oool00`000000oooo0?ooo`1c0?ooo`030000o`3oool0oooo03<0oooo
00<0003o0?ooo`3oool0H`3oool000X0oooo0P0000040?ooo`8000001P3oool00`000000oooo0?oo
o`1b0?ooo`030000o`3oool0oooo03@0oooo00<0003o0?ooo`3oool0H`3oool001P0oooo00<00000
0?ooo`3oool0LP3oool00`000?l0oooo0?ooo`0e0?ooo`030000o`3oool0oooo0680oooo000H0?oo
o`030000003oool0oooo0740oooo00<0003o0?ooo`3oool0=P3oool40000of40oooo000H0?ooo`03
0000003oool0oooo0700oooo00<0003o0?ooo`3oool0>`3oool60000oe/0oooo000H0?ooo`030000
003oool0oooo06l0oooo00<0003o0?ooo`3oool0@P3oool60000oeD0oooo000H0?ooo`030000003o
ool0oooo06h0oooo00<0003o0?ooo`3oool0B@3oool60000odl0oooo000H0?ooo`030000003oool0
oooo06d0oooo00<0003o0?ooo`3oool0D03oool70000odP0oooo000H0?ooo`030000003oool0oooo
03@0oooo0P0000040?ooo`800000103oool2000002X0oooo00<0003o0?ooo`3oool0203oool50000
03<0oooo1@0000020?ooo`800000103oool2000000T0oooo1P000?lV0?ooo`@00000603oool001P0
oooo00<000000?ooo`3oool0<`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo
000002P0oooo00<0003o0?ooo`3oool02`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0
oooo00L0oooo00@000000?ooo`3oool000003P3oool90000oad0oooo00<000000?ooo`3oool06@3o
ool001P0oooo00<000000?ooo`3oool0<`3oool010000000oooo0?ooo`00000;0?ooo`030000003o
ool0oooo02D0oooo00<0003o0?ooo`3oool0303oool00`000000oooo0?ooo`0e0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool05@3oool<0000oa80oooo00<000000?ooo`3oool0603o
ool001P0oooo00<000000?ooo`3oool0<`3oool010000000oooo0?ooo`0000090?ooo`800000:03o
ool00`000?l0oooo0?ooo`0<0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0203o
ool2000002@0oooo3@000?l60?ooo`030000003oool0oooo01L0oooo000H0?ooo`030000003oool0
oooo03<0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`0V0?ooo`030000o`3o
ool0oooo00d0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo0300oooo1`000?l00`000000oooo0?ooo`0F0?ooo`00603oool00`000000oooo0?ooo`0d
0?ooo`8000002P3oool3000002D0oooo00<0003o0?ooo`3oool03@3oool2000003H0oooo0P00000:
0?ooo`<00000=@3oool2000001T0oooo000H0?ooo`030000003oool0oooo06L0oooo00<0003o0?oo
o`3oool0Y@3oool001P0oooo00<000000?ooo`3oool0IP3oool00`000?l0oooo0?ooo`2V0?ooo`00
603oool00`000000oooo0?ooo`1V0?ooo`030000o`3oool0oooo0:H0oooo000H0?ooo`030000003o
ool0oooo06D0oooo00<0003o0?ooo`3oool0Y`3oool001P0oooo00<000000?ooo`3oool0I03oool0
0`000?l0oooo0?ooo`2O0?ooo`8000001`3oool00140oooo1`0000000`000?l000000000001S0000
00030000o`000000000009H000002@3oool010000000oooo0?ooo`0000060?ooo`00603oool00`00
0000003o0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`000?l02@3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`070?ooo`00603oool00`000000003o0?ooo`0k0?ooo`030000003oool0oooo02@0
oooo00<0003o0?ooo`3oool0503oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo03/0
oooo00<000000?ooo`3oool0303oool5000000H0oooo000H0?ooo`030000003oool0003o0640oooo
00<0003o0?ooo`3oool0X@3oool00`000000oooo0?ooo`070?ooo`00603oool00`000000oooo0000
o`1P0?ooo`030000o`3oool0oooo0:`0oooo000H0?ooo`040000003oool0oooo0000oeh0oooo00<0
003o0?ooo`3oool0[@3oool001P0oooo00@000000?ooo`3oool0003oGP3oool00`000?l0oooo0?oo
o`2]0?ooo`00603oool01@000000oooo0?ooo`3oool0003o05`0oooo00<0003o0?ooo`3oool0[P3o
ool001P0oooo00D000000?ooo`3oool0oooo0000o`1K0?ooo`030000o`3oool0oooo0:l0oooo000H
0?ooo`030000003oool0oooo0080oooo00<0003o0?ooo`3oool0E`3oool00`000?l0oooo0?ooo`2`
0?ooo`00603oool00`000000oooo0?ooo`020?ooo`030000o`3oool0oooo05L0oooo00<0003o0?oo
o`3oool0/03oool001P0oooo00<000000?ooo`3oool00`3oool00`000?l0oooo0?ooo`1E0?ooo`03
0000o`3oool0oooo0;40oooo000H0?ooo`030000003oool0oooo00@0oooo00<0003o0?ooo`3oool0
D`3oool00`000?l0oooo0?ooo`2b0?ooo`00603oool00`000000oooo0?ooo`040?ooo`030000o`3o
ool0oooo0580oooo00<0003o0?ooo`3oool0/`3oool001P0oooo00<000000?ooo`3oool01@3oool0
0`000?l0oooo0?ooo`1A0?ooo`030000o`3oool0oooo0;<0oooo000H0?ooo`030000003oool0oooo
00D0oooo00<0003o0?ooo`3oool0D03oool00`000?l0oooo0?ooo`2d0?ooo`00603oool00`000000
oooo0?ooo`060?ooo`030000o`3oool0oooo04h0oooo00<0003o0?ooo`3oool0]@3oool001P0oooo
00<000000?ooo`3oool01P3oool00`000?l0oooo0?ooo`1>0?ooo`030000o`3oool0oooo0;D0oooo
000H0?ooo`030000003oool0oooo00L0oooo00<0003o0?ooo`3oool0C03oool00`000?l0oooo0?oo
o`2f0?ooo`002@3oool4000000<0oooo0P0000060?ooo`030000003oool0oooo00L0oooo00<0003o
0?ooo`3oool0B`3oool00`000?l0oooo0?ooo`2g0?ooo`002@3oool00`000000oooo0?ooo`030?oo
o`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0203oool00`000?l0oooo0?ooo`19
0?ooo`030000o`3oool0oooo0;P0oooo000:0?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool000001@3oool2000000T0oooo00<0003o0?ooo`3oool0B@3oool00`000?l0oooo0?ooo`2h
0?ooo`002`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`090?ooo`030000o`3oool0oooo04L0oooo00<0003o0?ooo`3oool0^@3oool0
00T0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`030000003o
ool0oooo00X0oooo00<0003o0?ooo`3oool0A@3oool00`000?l0oooo0?ooo`2j0?ooo`002P3oool2
000000@0oooo0P0000060?ooo`030000003oool0oooo00X0oooo00<0003o0?ooo`3oool0A@3oool0
0`000?l0oooo0?ooo`2j0?ooo`00603oool00`000000oooo0?ooo`0;0?ooo`030000o`3oool0oooo
04<0oooo00<0003o0?ooo`3oool0^`3oool001P0oooo00<000000?ooo`3oool0303oool00`000?l0
oooo0?ooo`120?ooo`030000o`3oool0oooo0;/0oooo000H0?ooo`030000003oool0oooo00`0oooo
00<0003o0?ooo`3oool0@@3oool00`000?l0oooo0?ooo`2l0?ooo`00603oool00`000000oooo0?oo
o`0=0?ooo`030000o`3oool0oooo0400oooo00<0003o0?ooo`3oool0_03oool001P0oooo00<00000
0?ooo`3oool03@3oool00`000?l0oooo0?ooo`0o0?ooo`030000o`3oool0oooo0;d0oooo000H0?oo
o`030000003oool0oooo00h0oooo00<0003o0?ooo`3oool0?@3oool00`000?l0oooo0?ooo`2n0?oo
o`00603oool00`000000oooo0?ooo`0?0?ooo`030000o`3oool0oooo03`0oooo00<0003o0?ooo`3o
ool0_P3oool001P0oooo00<000000?ooo`3oool03`3oool00`000?l0oooo0?ooo`0k0?ooo`030000
o`3oool0oooo0;l0oooo000H0?ooo`030000003oool0oooo0100oooo00<0003o0?ooo`3oool0>P3o
ool00`000?l0oooo0?ooo`2o0?ooo`00603oool00`000000oooo0?ooo`0A0?ooo`030000o`3oool0
oooo03P0oooo00<0003o0?ooo`3oool0`03oool001P0oooo00<000000?ooo`3oool04@3oool00`00
0?l0oooo0?ooo`0h0?ooo`030000o`3oool0oooo0<00oooo000H0?ooo`030000003oool0oooo0180
oooo00<0003o0?ooo`3oool0=P3oool00`000?l0oooo0?ooo`310?ooo`00603oool00`000000oooo
0?ooo`0B0?ooo`030000o`3oool0oooo03D0oooo00<0003o0?ooo`3oool0`P3oool001P0oooo00<0
00000?ooo`3oool04`3oool00`000?l0oooo0?ooo`0d0?ooo`030000o`3oool0oooo0<80oooo000H
0?ooo`030000003oool0oooo01@0oooo00<0003o0?ooo`3oool0<P3oool00`000?l0oooo0?ooo`33
0?ooo`002`3oool300000080oooo0P0000060?ooo`030000003oool0oooo01@0oooo00<0003o0?oo
o`3oool0<P3oool00`000?l0oooo0?ooo`330?ooo`00303oool010000000oooo0?ooo`0000020?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool05@3oool00`000?l0oooo0?ooo`0`0?oo
o`030000o`3oool0oooo0<@0oooo00090?ooo`D0000000D0oooo0000003oool0oooo000000050?oo
o`8000005`3oool00`000?l0oooo0?ooo`0_0?ooo`030000o`3oool0oooo0<@0oooo00090?ooo`04
0000003oool0oooo00000080oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`0G
0?ooo`030000o`3oool0oooo02d0oooo00<0003o0?ooo`3oool0a@3oool000X0oooo00<000000?oo
o`0000000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo01L0oooo00<0003o
0?ooo`3oool0;03oool00`000?l0oooo0?ooo`360?ooo`002`3oool2000000<0oooo0P0000060?oo
o`030000003oool0oooo01P0oooo00<0003o0?ooo`3oool0:`3oool00`000?l0oooo0?ooo`360?oo
o`00603oool00`000000oooo0?ooo`0I0?ooo`030000o`3oool0oooo02T0oooo00<0003o0?ooo`3o
ool0a`3oool001P0oooo00<000000?ooo`3oool06P3oool00`000?l0oooo0?ooo`0X0?ooo`030000
o`3oool0oooo0<L0oooo000H0?ooo`030000003oool0oooo01X0oooo00<0003o0?ooo`3oool09`3o
ool00`000?l0oooo0?ooo`380?ooo`00603oool00`000000oooo0?ooo`0K0?ooo`030000o`3oool0
oooo02H0oooo00<0003o0?ooo`3oool0b03oool001P0oooo00<000000?ooo`3oool0703oool00`00
0?l0oooo0?ooo`0T0?ooo`030000o`3oool0oooo0<T0oooo000H0?ooo`030000003oool0oooo01d0
oooo00<0003o0?ooo`3oool08`3oool00`000?l0oooo0?ooo`390?ooo`00603oool00`000000oooo
0?ooo`0M0?ooo`030000o`3oool0oooo0280oooo00<0003o0?ooo`3oool0bP3oool001P0oooo00<0
00000?ooo`3oool07P3oool00`000?l0oooo0?ooo`0Q0?ooo`030000o`3oool0oooo0<X0oooo000H
0?ooo`030000003oool0oooo01l0oooo00<0003o0?ooo`3oool07`3oool00`000?l0oooo0?ooo`3;
0?ooo`00603oool00`000000oooo0?ooo`0P0?ooo`030000o`3oool0oooo01h0oooo00<0003o0?oo
o`3oool0b`3oool001P0oooo00<000000?ooo`3oool0803oool00`000?l0oooo0?ooo`0M0?ooo`03
0000o`3oool0oooo0<`0oooo000H0?ooo`030000003oool0oooo0240oooo00<0003o0?ooo`3oool0
703oool00`000?l0oooo0?ooo`3<0?ooo`00603oool00`000000oooo0?ooo`0R0?ooo`030000o`3o
ool0oooo01X0oooo00<0003o0?ooo`3oool0c@3oool001P0oooo00<000000?ooo`3oool08`3oool0
0`000?l0oooo0?ooo`0I0?ooo`030000o`3oool0oooo0<d0oooo000H0?ooo`030000003oool0oooo
02@0oooo00<0003o0?ooo`3oool05`3oool00`000?l0oooo0?ooo`3>0?ooo`002@3oool3000000@0
oooo0P0000060?ooo`030000003oool0oooo02D0oooo00<0003o0?ooo`3oool05P3oool00`000?l0
oooo0?ooo`3>0?ooo`002@3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
00D0oooo00<000000?ooo`3oool09@3oool00`000?l0oooo0?ooo`0E0?ooo`030000o`3oool0oooo
0<l0oooo00090?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool000001@3oool2
000002L0oooo00<0003o0?ooo`3oool0503oool00`000?l0oooo0?ooo`3?0?ooo`002@3oool30000
00<0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`0W0?ooo`030000o`3oool0
oooo0180oooo00<0003o0?ooo`3oool0d03oool000X0oooo00<000000?ooo`3oool00P3oool01000
0000oooo0?ooo`0000050?ooo`030000003oool0oooo02P0oooo00<0003o0?ooo`3oool04@3oool0
0`000?l0oooo0?ooo`3@0?ooo`002P3oool3000000<0oooo0P0000060?ooo`030000003oool0oooo
02T0oooo00<0003o0?ooo`3oool03P3oool20000om<0oooo000H0?ooo`030000003oool0oooo02X0
oooo00<0003o0?ooo`3oool02`3oool20000omD0oooo000H0?ooo`030000003oool0oooo02/0oooo
00<0003o0?ooo`3oool0203oool20000omL0oooo000H0?ooo`030000003oool0oooo02/0oooo00<0
003o0?ooo`3oool01P3oool20000omT0oooo000H0?ooo`030000003oool0oooo02`0oooo00<0003o
0?ooo`3oool00`3oool20000om/0oooo000H0?ooo`030000003oool0oooo02d0oooo00<0003o0?oo
o`3oool00P000?oM0?ooo`00603oool00`000000oooo0?ooo`0^0?ooo`80003og`3oool001P0oooo
00<000000?ooo`3oool0o`3oool@0?ooo`00603oool00`000000oooo0?ooo`3o0?oooa00oooo000H
0?ooo`030000003oool0oooo0?l0oooo403oool001P0oooo00<000000?ooo`3oool0o`3oool@0?oo
o`00o`3oool[0?ooo`00o`3oool[0?ooo`00o`3oool[0?ooo`00o`3oool[0?ooo`00o`3oool[0?oo
o`00o`3oool[0?ooo`00o`3oool[0?ooo`00o`3oool[0?ooo`00o`3oool[0?ooo`00o`3oool[0?oo
o`005P3oool500000?l0oooo403oool001H0oooo1000003o0?oooa40oooo000I0?ooo`030000003o
ool0oooo0?l0oooo3`3oool001L0oooo0`00003o0?oooa40oooo003o0?ooob/0oooo003o0?ooob/0
oooo003o0?ooob/0oooo003o0?ooob/0oooo003o0?ooob/0oooo0000\
\>"],
  ImageRangeCache->{{{0, 297.813}, {183.688, 0}} -> {-0.193378, -84.285, \
0.00805399, 0.952274}}],

Cell[BoxData[
    InterpretationBox[\("t"\[InvisibleSpace]"      "\[InvisibleSpace]"   u"\
\[InvisibleSpace]"          v"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]" \
        a"\),
      SequenceForm[ "t", "      ", "   u", "          v", "", "         a"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("------------------------------------"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        InterpretationBox[GridBox[{
              {"0"},
              {"0.1`"},
              {"0.2`"},
              {"0.30000000000000004`"},
              {"0.4`"},
              {"0.5`"},
              {"0.6000000000000001`"},
              {"0.7000000000000001`"},
              {"0.8`"},
              {"0.9`"},
              {"1.`"},
              {"1.1`"},
              {"1.2000000000000002`"},
              {"1.3`"},
              {"1.4000000000000001`"},
              {"1.5`"},
              {"1.6`"},
              {"1.7000000000000002`"},
              {"1.8`"},
              {"1.9000000000000001`"},
              {"2.`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0, 1.1000000000000001, 
            1.2000000000000002, 1.3, 1.4000000000000001, 1.5, 
            1.6000000000000001, 1.7000000000000002, 1.8, 1.9000000000000001, 
            2.0}]], "\[InvisibleSpace]", "\<\"     \"\>", "\[InvisibleSpace]",
         
        InterpretationBox[GridBox[{
              {"0"},
              {"0.03466262985904664`"},
              {"0.27285676091882105`"},
              {"0.8964620744673697`"},
              {"2.064038130842793`"},
              {"3.8844845080665316`"},
              {"6.306088337848285`"},
              {"9.137117571982559`"},
              {"12.181093563541467`"},
              {"15.266729593186374`"},
              {"18.244700832593523`"},
              {"20.984828453888717`"},
              {"23.31963104775317`"},
              {"25.0041126726336`"},
              {"26.23864204425374`"},
              {"27.275888130353408`"},
              {"28.180141503495047`"},
              {"28.96845410722124`"},
              {"29.65569153386696`"},
              {"30.254813352229608`"},
              {"30.777117492430644`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .03466262985904664, .27285676091882105, .8964620744673697, 
            2.0640381308427931, 3.8844845080665316, 6.3060883378482853, 
            9.137117571982559, 12.181093563541467, 15.266729593186374, 
            18.244700832593523, 20.984828453888717, 23.31963104775317, 
            25.0041126726336, 26.238642044253741, 27.275888130353408, 
            28.180141503495047, 28.968454107221241, 29.65569153386696, 
            30.254813352229608, 30.777117492430644}]], 
        "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"1.0398788957713991`"},
              {"4.026186733499664`"},
              {"8.709357508479638`"},
              {"14.87182433030095`"},
              {"21.444018178291433`"},
              {"26.61360916669809`"},
              {"29.680537072397012`"},
              {"30.914399314509325`"},
              {"30.550226305680166`"},
              {"28.792913534331685`"},
              {"25.82108537806341`"},
              {"20.170651408204105`"},
              {"14.074835551466668`"},
              {"11.100336280946365`"},
              {"9.67708305634212`"},
              {"8.43631527092437`"},
              {"7.354635165995392`"},
              {"6.411644976251476`"},
              {"5.589562279249693`"},
              {"4.872884663660315`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          TableForm[ {0, 1.0398788957713991, 4.0261867334996637, 
            8.7093575084796377, 14.871824330300949, 21.444018178291433, 
            26.61360916669809, 29.680537072397012, 30.914399314509325, 
            30.550226305680166, 28.792913534331685, 25.821085378063412, 
            20.170651408204105, 14.074835551466668, 11.100336280946365, 
            9.67708305634212, 8.4363152709243696, 7.3546351659953917, 
            6.411644976251476, 5.5895622792496926, 4.8728846636603151}]], 
        "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"20.7975881350154`"},
              {"38.92856861954991`"},
              {"54.734846880049574`"},
              {"68.51448955637659`"},
              {"62.929387403433054`"},
              {"40.46243236470053`"},
              {"20.876125749277623`"},
              {"3.8011190929683814`"},
              {\(-11.084579269551043`\)},
              {\(-24.061676157419008`\)},
              {\(-35.37488696794688`\)},
              {\(-77.63379242923958`\)},
              {\(-44.2825247055093`\)},
              {\(-15.207460704896523`\)},
              {\(-13.257603787188705`\)},
              {\(-11.557751921166389`\)},
              {\(-10.075850177413688`\)},
              {\(-8.783953617464523`\)},
              {\(-7.657700322572079`\)},
              {\(-6.675851989214632`\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 20.797588135015399, 38.928568619549907, 
            54.734846880049574, 68.514489556376589, 62.929387403433054, 
            40.462432364700533, 20.876125749277623, 
            3.8011190929683814, -11.084579269551043, -24.061676157419008, \
-35.374886967946878, -77.633792429239577, -44.282524705509303, \
-15.207460704896523, -13.257603787188705, -11.557751921166389, \
-10.075850177413688, -8.7839536174645225, -7.6577003225720794, \
-6.6758519892146317}]]}],
      SequenceForm[ 
        TableForm[ {
          0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0, 1.1000000000000001, 
          1.2000000000000002, 1.3, 1.4000000000000001, 1.5, 
          1.6000000000000001, 1.7000000000000002, 1.8, 1.9000000000000001, 
          2.0}], "     ", 
        TableForm[ {
          0, .03466262985904664, .27285676091882105, .8964620744673697, 
          2.0640381308427931, 3.8844845080665316, 6.3060883378482853, 
          9.137117571982559, 12.181093563541467, 15.266729593186374, 
          18.244700832593523, 20.984828453888717, 23.31963104775317, 
          25.0041126726336, 26.238642044253741, 27.275888130353408, 
          28.180141503495047, 28.968454107221241, 29.65569153386696, 
          30.254813352229608, 30.777117492430644}], "   ", 
        TableForm[ {0, 1.0398788957713991, 4.0261867334996637, 
          8.7093575084796377, 14.871824330300949, 21.444018178291433, 
          26.61360916669809, 29.680537072397012, 30.914399314509325, 
          30.550226305680166, 28.792913534331685, 25.821085378063412, 
          20.170651408204105, 14.074835551466668, 11.100336280946365, 
          9.67708305634212, 8.4363152709243696, 7.3546351659953917, 
          6.411644976251476, 5.5895622792496926, 4.8728846636603151}], "  ", 
        TableForm[ {0, 20.797588135015399, 38.928568619549907, 
          54.734846880049574, 68.514489556376589, 62.929387403433054, 
          40.462432364700533, 20.876125749277623, 
          3.8011190929683814, -11.084579269551043, -24.061676157419008, \
-35.374886967946878, -77.633792429239577, -44.282524705509303, \
-15.207460704896523, -13.257603787188705, -11.557751921166389, \
-10.075850177413688, -8.7839536174645225, -7.6577003225720794, \
-6.6758519892146317}]],
      Editable->False]], "Print"]
}, Open  ]],

Cell["\<\
A continuaci\[OAcute]n se tiene la representaci\[OAcute]n de los tres casos \
conjuntanente:
El\[AAcute]stico ( negro ).
Elastopl\[AAcute]stico ( rojo ).
Elastopl\[AAcute]stico sin resistenencia a tracci\[OAcute]n.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0270376 0.0187243 [
[(0.5)] .2619 .02704 0 2 Msboxa
[(1)] .5 .02704 0 2 Msboxa
[(1.5)] .7381 .02704 0 2 Msboxa
[(2)] .97619 .02704 0 2 Msboxa
[(t)] 1.025 .02704 -1 0 Msboxa
[(5)] .01131 .12066 1 0 Msboxa
[(10)] .01131 .21428 1 0 Msboxa
[(15)] .01131 .3079 1 0 Msboxa
[(20)] .01131 .40152 1 0 Msboxa
[(25)] .01131 .49515 1 0 Msboxa
[(30)] .01131 .58877 1 0 Msboxa
[(u)] .02381 .61803 0 -4 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.2619 .02704 m
.2619 .03329 L
s
P
[(0.5)] .2619 .02704 0 2 Mshowa
p
.002 w
.5 .02704 m
.5 .03329 L
s
P
[(1)] .5 .02704 0 2 Mshowa
p
.002 w
.7381 .02704 m
.7381 .03329 L
s
P
[(1.5)] .7381 .02704 0 2 Mshowa
p
.002 w
.97619 .02704 m
.97619 .03329 L
s
P
[(2)] .97619 .02704 0 2 Mshowa
p
.001 w
.07143 .02704 m
.07143 .03079 L
s
P
p
.001 w
.11905 .02704 m
.11905 .03079 L
s
P
p
.001 w
.16667 .02704 m
.16667 .03079 L
s
P
p
.001 w
.21429 .02704 m
.21429 .03079 L
s
P
p
.001 w
.30952 .02704 m
.30952 .03079 L
s
P
p
.001 w
.35714 .02704 m
.35714 .03079 L
s
P
p
.001 w
.40476 .02704 m
.40476 .03079 L
s
P
p
.001 w
.45238 .02704 m
.45238 .03079 L
s
P
p
.001 w
.54762 .02704 m
.54762 .03079 L
s
P
p
.001 w
.59524 .02704 m
.59524 .03079 L
s
P
p
.001 w
.64286 .02704 m
.64286 .03079 L
s
P
p
.001 w
.69048 .02704 m
.69048 .03079 L
s
P
p
.001 w
.78571 .02704 m
.78571 .03079 L
s
P
p
.001 w
.83333 .02704 m
.83333 .03079 L
s
P
p
.001 w
.88095 .02704 m
.88095 .03079 L
s
P
p
.001 w
.92857 .02704 m
.92857 .03079 L
s
P
[(t)] 1.025 .02704 -1 0 Mshowa
p
.002 w
0 .02704 m
1 .02704 L
s
P
p
.002 w
.02381 .12066 m
.03006 .12066 L
s
P
[(5)] .01131 .12066 1 0 Mshowa
p
.002 w
.02381 .21428 m
.03006 .21428 L
s
P
[(10)] .01131 .21428 1 0 Mshowa
p
.002 w
.02381 .3079 m
.03006 .3079 L
s
P
[(15)] .01131 .3079 1 0 Mshowa
p
.002 w
.02381 .40152 m
.03006 .40152 L
s
P
[(20)] .01131 .40152 1 0 Mshowa
p
.002 w
.02381 .49515 m
.03006 .49515 L
s
P
[(25)] .01131 .49515 1 0 Mshowa
p
.002 w
.02381 .58877 m
.03006 .58877 L
s
P
[(30)] .01131 .58877 1 0 Mshowa
p
.001 w
.02381 .04576 m
.02756 .04576 L
s
P
p
.001 w
.02381 .06449 m
.02756 .06449 L
s
P
p
.001 w
.02381 .08321 m
.02756 .08321 L
s
P
p
.001 w
.02381 .10193 m
.02756 .10193 L
s
P
p
.001 w
.02381 .13938 m
.02756 .13938 L
s
P
p
.001 w
.02381 .15811 m
.02756 .15811 L
s
P
p
.001 w
.02381 .17683 m
.02756 .17683 L
s
P
p
.001 w
.02381 .19556 m
.02756 .19556 L
s
P
p
.001 w
.02381 .23301 m
.02756 .23301 L
s
P
p
.001 w
.02381 .25173 m
.02756 .25173 L
s
P
p
.001 w
.02381 .27045 m
.02756 .27045 L
s
P
p
.001 w
.02381 .28918 m
.02756 .28918 L
s
P
p
.001 w
.02381 .32663 m
.02756 .32663 L
s
P
p
.001 w
.02381 .34535 m
.02756 .34535 L
s
P
p
.001 w
.02381 .36408 m
.02756 .36408 L
s
P
p
.001 w
.02381 .3828 m
.02756 .3828 L
s
P
p
.001 w
.02381 .42025 m
.02756 .42025 L
s
P
p
.001 w
.02381 .43897 m
.02756 .43897 L
s
P
p
.001 w
.02381 .4577 m
.02756 .4577 L
s
P
p
.001 w
.02381 .47642 m
.02756 .47642 L
s
P
p
.001 w
.02381 .51387 m
.02756 .51387 L
s
P
p
.001 w
.02381 .53259 m
.02756 .53259 L
s
P
p
.001 w
.02381 .55132 m
.02756 .55132 L
s
P
p
.001 w
.02381 .57004 m
.02756 .57004 L
s
P
p
.001 w
.02381 .00831 m
.02756 .00831 L
s
P
p
.001 w
.02381 .60749 m
.02756 .60749 L
s
P
[(u)] .02381 .61803 0 -4 Mshowa
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.3 1 1 r
.004 w
.02381 .02704 m
.07143 .02769 L
.11905 .03215 L
.16667 .04382 L
.21429 .06569 L
.2619 .09977 L
.30952 .14511 L
.35714 .19812 L
.40476 .25512 L
.45238 .3129 L
.5 .36866 L
.54762 .41996 L
.59524 .46368 L
.64286 .49522 L
.69048 .51834 L
.7381 .53776 L
.78571 .55469 L
.83333 .56945 L
.88095 .58232 L
.92857 .59354 L
.97619 .60332 L
s
P
p
0 0 0 r
.004 w
.02381 .02704 m
.07143 .02763 L
.11905 .03139 L
.16667 .03952 L
.21429 .05078 L
.2619 .06191 L
.30952 .06761 L
.35714 .06355 L
.40476 .05056 L
.45238 .03406 L
.5 .02071 L
.54762 .01472 L
.59524 .01499 L
.64286 .0156 L
.69048 .01816 L
.7381 .02444 L
.78571 .03135 L
.83333 .03518 L
.88095 .03427 L
.92857 .02965 L
.97619 .0242 L
s
P
p
1 0 0 r
.004 w
.02381 .02704 m
.07143 .02763 L
.11905 .03139 L
.16667 .03952 L
.21429 .05087 L
.2619 .06364 L
.30952 .07726 L
.35714 .08946 L
.40476 .09775 L
.45238 .09991 L
.5 .09456 L
.54762 .08313 L
.59524 .06897 L
.64286 .05479 L
.69048 .04965 L
.7381 .05755 L
.78571 .07369 L
.83333 .08726 L
.88095 .09141 L
.92857 .08505 L
.97619 .07276 L
s
P
P
% End of Graphics
MathPictureEnd\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{299, 185},
  ImageMargins->{{100, Inherited}, {Inherited, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^B000`400?l00000o`00003oo`3oool/
0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00EP3oool2000000@0oooo0P00
00040?ooo`800000;@3oool5000002`0oooo1@0000020?ooo`800000103oool2000002h0oooo1000
000X0?ooo`00E@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000002h0oooo
00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000002d0
oooo00<000000?ooo`3oool0:@3oool005D0oooo00@000000?ooo`3oool000002`3oool00`000000
oooo0?ooo`0/0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0/0?ooo`030000003oool0oooo02P0oooo001E0?ooo`040000003oool0oooo000000T0
oooo0P00000_0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0203oool200000300
oooo00<000000?ooo`3oool09`3oool005D0oooo00@000000?ooo`3oool000002@3oool00`000000
oooo0?ooo`0^0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0]0?ooo`040000003oool0oooo000002P0oooo001F0?ooo`8000002P3oool3000002d0
oooo0P00000_0?ooo`8000002P3oool3000002h0oooo0P00000Y0?ooo`00o`3oool/0?ooo`00o`3o
ool/0?ooo`009P3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000V0?ooo`030000003oool0oooo
0?l0oooo0`3oool002H0oooo0P00003o0?ooo`@0oooo000V0?ooo`030000003oool0oooo0?l0oooo
0`3oool002H0oooo00<000000?ooo`3oool0L03ooolY000004`0oooo0P00000K0?ooo`009P3oool0
0`000000oooo0?ooo`1Y0?ooo`L00000:@3oool6000004D0oooo00@000000?ooo`3oool000006P3o
ool00200oooo1P0000060?l00=/000001P3oool00`000000oooo0?ooo`0K0?ooo`009P3oool00`00
0000oooo0?ooo`030?oooa<0o`00203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0203oool00`000000oooo00000003000000D0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00<0oooo2`0000050?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool00`3oool;000000D0oooo00<000000?oo
o`3oool0203oool5000001X0oooo000V0?ooo`030000003oool0oooo00h0oooo201<ool60?l001P0
oooo00<000000?ooo`3oool09`3oool3000000T0oooo00<000000?ooo`3oool0=03oool00`000000
oooo0?ooo`0>0?oooaH00000403oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01/0
oooo000V0?ooo`030000003oool0oooo01H0oooo1P1<ool40?l003/0oooo0`00002T0?ooo`009P3o
ool00`000000oooo0?ooo`0L0?ooo`@0C?oo103o000e0?ooo`800000Y`3oool002H0oooo0P00000Q
0?ooo`80C?oo0P3oool40?l002h0oooo0`00002Y0?ooo`009P3oool00`000000oooo0?ooo`0R0?oo
o`80C?oo103oool30?l002P0oooo0`00000k0?ooo`P0o`00J@3oool002H0oooo00<000000?ooo`3o
ool0903oool204coo`D0oooo103o000P0?ooo`@00000=`3oool70?l000P0oooo1P3o001S0?ooo`00
9P3oool00`000000oooo0?ooo`0V0?ooo`80C?oo1`3oool40?l001P0oooo1000000g0?ooo`@0o`00
5@3oool40?l005l0oooo000V0?ooo`800000:@3oool204coo`T0oooo0`3o0003000000/0oooo1`00
000g0?ooo`@0o`007@3oool40?l005/0oooo000V0?ooo`030000003oool0oooo02X0oooo0P1<ool:
0?ooo`<0o`002`00000k0?ooo`<0o`009@3oool40?l005L0oooo000V0?ooo`030000003oool0oooo
02`0oooo00<0C?oo0?ooo`3oool02P3oool40?l003h0oooo103o000/0?ooo`<0o`00:@3oool20?l0
02T0oooo000V0?ooo`030000003oool0oooo02d0oooo00<0C?oo0?ooo`3oool03@3oool30?l003L0
oooo103o000c0?ooo`@0o`008@3oool40?l002/0oooo000V0?ooo`800000;`3oool204cooa00oooo
103o000`0?ooo`<0o`00>`3oool40?l001T0oooo103o000_0?ooo`009P3oool00`000000oooo0?oo
o`0`0?ooo`0304coo`3oool0oooo0140oooo103o000X0?ooo`@0o`00@P3oool70?l000/0oooo1`3o
000c0?ooo`009P3oool00`000000oooo0?ooo`0a0?ooo`0304coo`3oool0oooo01@0oooo103o000P
0?ooo`@0o`00C@3oool;0?l003X0oooo000V0?ooo`030000003oool0oooo0380oooo0P1<oolH0?oo
o`H0o`004`3oool70?l009H0oooo000V0?ooo`030000003oool0oooo03@0oooo00<0C?oo0?ooo`3o
ool06`3ooolC0?l009d0oooo000V0?ooo`800000=P3oool00`1<ool0oooo0?ooo`3:0?ooo`009P3o
ool00`000000oooo0?ooo`0f0?ooo`0304coo`3oool0oooo0<T0oooo000O0?ooo`8000001@3oool0
0`000000oooo0?ooo`0g0?ooo`0304coo`3oool0oooo0<P0oooo000N0?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool0>03oool00`1<ool0oooo0?ooo`370?ooo`008@3oool00`00
0000oooo0?ooo`020?ooo`800000>P3oool00`1<ool0oooo0?ooo`360?ooo`007`3oool2000000D0
oooo00<000000?ooo`3oool0>@3oool00`1<ool0oooo0?ooo`360?ooo`007`3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo03X0oooo00<0C?oo0?ooo`3oool0a@3oool001l0oooo0`00
00040?ooo`030000003oool0oooo03/0oooo00<0C?oo0?ooo`3oool0a03oool002H0oooo0P00000m
0?ooo`0304coo`3oool0oooo0<<0oooo000V0?ooo`030000003oool0oooo03d0oooo00<0C?oo0?oo
o`3oool0`P3oool002H0oooo00<000000?ooo`3oool0?P3oool00`1<ool0oooo0?ooo`310?ooo`00
9P3oool00`000000oooo0?ooo`0o0?ooo`0304coo`3oool0oooo0<00oooo000V0?ooo`030000003o
ool0oooo0400oooo00<0C?oo0?ooo`3oool0_`3oool002H0oooo0P0000120?ooo`0304coo`3oool0
oooo0;h0oooo000V0?ooo`030000003oool0oooo0480oooo00<0C?oo0?ooo`3oool0_@3oool002H0
oooo00<000000?ooo`3oool0@`3oool00`1<ool0oooo0?ooo`2l0?ooo`009P3oool00`000000oooo
0?ooo`130?ooo`0304coo`3oool0oooo0;`0oooo000V0?ooo`800000A@3oool00`1<ool0oooo0?oo
o`2k0?ooo`009P3oool00`000000oooo0?ooo`150?ooo`0304coo`3oool0oooo0;X0oooo000V0?oo
o`030000003oool0oooo04H0oooo00<0C?oo0?ooo`3oool0^@3oool002H0oooo00<000000?ooo`3o
ool0A`3oool00`1<ool0oooo0?ooo`2h0?ooo`009P3oool2000004T0oooo00<0C?oo0?ooo`3oool0
]`3oool002H0oooo00<000000?ooo`3oool0B@3oool00`1<ool0oooo0?ooo`2f0?ooo`009P3oool0
0`000000oooo0?ooo`1:0?ooo`0304coo`3oool0oooo0;D0oooo000H0?ooo`D000000P3oool20000
00D0oooo00<000000?ooo`3oool0B`3oool00`1<ool0oooo0?ooo`2d0?ooo`006P3oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1<0?oo
o`0304coo`3oool0oooo0;<0oooo000J0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo0?ooo`020?ooo`800000C@3oool00`1<ool0oooo0?ooo`2c0?ooo`006P3oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1=0?oo
o`0304coo`3oool0oooo0;80oooo000J0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo04h0oooo00<0C?oo0?ooo`3oool0/@3oool001T0
oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`1?0?ooo`0304coo`3oool0oooo0;00
oooo000V0?ooo`800000D@3oool00`1<ool0oooo0?ooo`2_0?ooo`009P3oool00`000000oooo0?oo
o`1A0?ooo`0304coo`3oool0oooo0:h0oooo000V0?ooo`030000003oool0oooo0540oooo00<0C?oo
0?ooo`3oool0[P3oool002H0oooo00<000000?ooo`3oool0DP3oool00`1<ool0oooo0?ooo`2]0?oo
o`009P3oool2000005@0oooo00<0C?oo0?ooo`3oool0[03oool002H0oooo00<000000?ooo`3oool0
E03oool00`1<ool0oooo0?ooo`2[0?ooo`009P3oool00`000000oooo0?ooo`1E0?ooo`0304coo`3o
ool0oooo0:X0oooo000V0?ooo`030000003oool0oooo05H0oooo00<0C?oo0?ooo`3oool0Z@3oool0
02H0oooo00<000000?ooo`3oool0E`3oool00`1<ool0oooo0?ooo`2X0?ooo`009P3oool2000005P0
oooo00<0C?oo0?ooo`3oool0Z03oool002H0oooo00<000000?ooo`3oool0F03oool00`1<ool0oooo
0?ooo`2W0?ooo`009P3oool00`000000oooo0?ooo`1I0?ooo`0304coo`3oool0oooo0:H0oooo000V
0?ooo`030000003oool0oooo05X0oooo00<0C?oo0?ooo`3oool0Y@3oool002H0oooo0P00001L0?oo
o`0304coo`3oool0oooo0:@0oooo000V0?ooo`030000003oool0oooo05`0oooo00<0C?oo0?ooo`3o
ool0X`3oool001P0oooo1@0000020?ooo`8000001@3oool00`000000oooo0?ooo`1L0?ooo`0304co
o`3oool0oooo0:<0oooo000J0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo05d0oooo00<0C?oo0?ooo`3oool0XP3oool001X0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`800000G`3oool00`1<ool0oooo0?oo
o`2Q0?ooo`006P3oool00`000000oooo0?ooo`020?ooo`8000001@3oool00`000000oooo0?ooo`1O
0?ooo`0304coo`3oool0oooo0:00oooo000J0?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`1P0?ooo`0304coo`3oool0oooo09l0oooo000I0?ooo`80
0000103oool3000000@0oooo00<000000?ooo`3oool0H@3oool00`1<ool0oooo0?ooo`2N0?ooo`00
9P3oool2000006<0oooo00<0C?oo0?ooo`3oool0W@3oool002H0oooo00<000000?ooo`3oool0HP3o
ool00`1<ool0oooo0?ooo`2M0?ooo`009P3oool00`000000oooo0?ooo`1S0?ooo`0304coo`3oool0
oooo09`0oooo000V0?ooo`030000003oool0oooo06@0oooo00<0C?oo0?ooo`3oool0V`3oool002H0
oooo00<000000?ooo`3oool0I@3oool00`1<ool0oooo0?ooo`2J0?ooo`009P3oool2000006L0oooo
00<0C?oo0?ooo`3oool0V@3oool002H0oooo00<000000?ooo`3oool0I`3oool00`1<ool0oooo0?oo
o`2H0?ooo`009P3oool00`000000oooo0?ooo`1W0?ooo`0304coo`3oool0oooo09P0oooo000V0?oo
o`030000003oool0oooo06P0oooo00<0C?oo0?ooo`3oool0U`3oool002H0oooo0P00001Z0?ooo`03
04coo`3oool0oooo09H0oooo000V0?ooo`030000003oool0oooo06X0oooo00<0C?oo0?ooo`3oool0
U@3oool002H0oooo00<000000?ooo`3oool0J`3oool00`1<ool0oooo0?ooo`2D0?ooo`009P3oool0
0`000000oooo0?ooo`1/0?ooo`0304coo`3oool0oooo09<0oooo000V0?ooo`800000KP3oool00`1<
ool0oooo0?ooo`2B0?ooo`009P3oool00`000000oooo0?ooo`1^0?ooo`0304coo`3oool0oooo0940
oooo000V0?ooo`030000003oool0oooo06l0oooo00<0C?oo0?ooo`3oool0T03oool001P0oooo1000
00030?ooo`8000001@3oool00`000000oooo0?ooo`1_0?ooo`0304coo`3oool0oooo0900oooo000H
0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?oo
o`1`0?ooo`0304coo`3oool0oooo08l0oooo000I0?ooo`030000003oool0oooo0080oooo00@00000
0?ooo`3oool00000103oool200000780oooo00<0C?oo0?ooo`3oool0SP3oool001X0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0LP3o
ool00`1<ool0oooo0?ooo`2=0?ooo`00603oool010000000oooo0?ooo`0000020?ooo`040000003o
ool0oooo000000@0oooo00<000000?ooo`3oool0L`3oool00`1<ool0oooo0?ooo`2<0?ooo`006@3o
ool2000000@0oooo0P0000050?ooo`030000003oool0oooo07@0oooo00<0C?oo0?ooo`3oool0R`3o
ool002H0oooo0P00001f0?ooo`0304coo`3oool0oooo08X0oooo000V0?ooo`030000003oool0oooo
07H0oooo00<0C?oo0?ooo`3oool0R@3oool002H0oooo00<000000?ooo`3oool0M`3oool00`1<ool0
oooo0?ooo`280?ooo`009P3oool00`000000oooo0?ooo`1h0?ooo`0304coo`3oool0oooo08L0oooo
000V0?ooo`800000NP3oool00`1<ool0oooo0?ooo`260?ooo`009P3oool00`000000oooo0?ooo`1j
0?ooo`80C?ooQP3oool002H0oooo00<000000?ooo`3oool0O03oool00`1<ool0oooo0?ooo`230?oo
o`009P3oool00`000000oooo0?ooo`1m0?ooo`0304coo`3oool0oooo0880oooo000V0?ooo`030000
003oool0oooo07h0oooo00<0C?oo0?ooo`3oool0P@3oool002H0oooo0P0000200?ooo`0304coo`3o
ool0oooo0800oooo000V0?ooo`030000003oool0oooo0800oooo00<0C?oo0?ooo`3oool0O`3oool0
02H0oooo00<000000?ooo`3oool0P@3oool204coogl0oooo000V0?ooo`030000003oool0oooo08<0
oooo00<0C?oo0?ooo`3oool0O03oool002H0oooo0P0000250?ooo`80C?ooO03oool002H0oooo00<0
00000?ooo`3oool0QP3oool204coogX0oooo000H0?ooo`@000000`3oool2000000D0oooo00<00000
0?ooo`3oool0R03oool00`1<ool0oooo0?ooo`1g0?ooo`00603oool00`000000oooo0?ooo`030?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0R@3oool204coogL0oooo000I0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool2000008`0oooo00<0C?oo0?oo
o`3oool0M03oool001X0oooo00<000000?ooo`3oool00P3oool2000000D0oooo00<000000?ooo`3o
ool0S03oool204coog@0oooo000H0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`2>0?ooo`80C?ooLP3oool001T0oooo0P0000040?ooo`<00000
103oool00`000000oooo0?ooo`2@0?ooo`80C?ooL03oool002H0oooo00<000000?ooo`3oool0TP3o
ool204coofh0oooo000V0?ooo`800000U@3oool204coof`0oooo000V0?ooo`030000003oool0oooo
09H0oooo0P1<oomZ0?ooo`009P3oool00`000000oooo0?ooo`2H0?ooo`<0C?ooI`3oool002H0oooo
00<000000?ooo`3oool0V`3oool204coofD0oooo000V0?ooo`800000WP3oool304coof80oooo000V
0?ooo`030000003oool0oooo0:00oooo0`1<oomO0?ooo`009P3oool00`000000oooo0?ooo`2S0?oo
o`<0C?ooG03oool002H0oooo00<000000?ooo`3oool0YP3oool204cooeX0oooo000V0?ooo`800000
Z@3oool304cooeL0oooo000V0?ooo`030000003oool0oooo0:/0oooo0`1<oomD0?ooo`009P3oool0
0`000000oooo0?ooo`2^0?ooo`@0C?ooD03oool002H0oooo00<000000?ooo`3oool0/P3oool404co
od`0oooo000V0?ooo`800000]`3oool304coodT0oooo000V0?ooo`030000003oool0oooo0;T0oooo
101<oom50?ooo`009P3oool00`000000oooo0?ooo`2m0?ooo`@0C?oo@@3oool001T0oooo0P000004
0?ooo`8000001@3oool00`000000oooo0?ooo`310?ooo`<0C?oo?P3oool001P0oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0<@0oooo101<
oolj0?ooo`006P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3o
ool200000<T0oooo101<oolf0?ooo`006`3oool010000000oooo0?ooo`0000020?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0c03oool404cooc80oooo000H0?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`3@0?ooo`H0C?oo
;03oool001T0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`3F0?ooo`<0C?oo:@3o
ool002H0oooo0P00003o0?ooo`@0oooo000V0?ooo`030000003oool0oooo0?l0oooo0`3oool002H0
oooo00<000000?ooo`3oool0o`3oool30?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00o`3oool/
0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00o`3oool/
0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00o`3oool/
0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00o`3oool/
0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`009@3oool400000?l0oooo0`3o
ool002@0oooo00@000000?ooo`3oool00000o`3oool40?ooo`00903oool010000000oooo0?ooo`00
003o0?ooo`@0oooo000S0?ooo`80000000<0oooo000000000000o`3oool40?ooo`00o`3oool/0?oo
o`00o`3oool/0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 298}, {184, 0}} -> {-0.348977, -4.17749, 0.00912568, \
0.232081}}],

Cell["\<\
EJEMPLO
0.2533 a( t )  + 0.1592 v( t ) + fs ( u,v ) = p( t )
u( 0 ) = 0
v( 0 ) = 0

Hallar la respuesta hasta el instante tn=1 y con un incremento de tiempo
to=0.1,para el m\[EAcute]todo de la aceleraci\[OAcute]n constante, siendo p( \
t ) la carga dada en forma discreta siguiente:

p={{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
    {.7,0},{.8,0},{.9,0},{1,0}};

y siendo el material elastopl\[AAcute]stico perfecto, en el que la \
plastificaci\[OAcute]n a tracci\[OAcute]n se alcanza paran un valor de ft = \
7.5, y a compresi\[OAcute]n para fc = -7.5,
y la rigidez el\[AAcute]stica es 10. \
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
p={{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
    {.7,0},{.8,0},{.9,0},{1,0}};\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["\<\
NewmarkNoLineal[0,1,.1,0,0,10,.2533,.1592,p,
        .5,.25,-7.5,7.5,posicion,velocidad,aceleracion]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.280948 [
[(0.2)] .21429 .01472 0 2 Msboxa
[(0.4)] .40476 .01472 0 2 Msboxa
[(0.6)] .59524 .01472 0 2 Msboxa
[(0.8)] .78571 .01472 0 2 Msboxa
[(1)] .97619 .01472 0 2 Msboxa
[(t)] 1.025 .01472 -1 0 Msboxa
[(0.5)] .01131 .15519 1 0 Msboxa
[(1)] .01131 .29566 1 0 Msboxa
[(1.5)] .01131 .43614 1 0 Msboxa
[(2)] .01131 .57661 1 0 Msboxa
[(u)] .02381 .61803 0 -4 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.21429 .01472 m
.21429 .02097 L
s
P
[(0.2)] .21429 .01472 0 2 Mshowa
p
.002 w
.40476 .01472 m
.40476 .02097 L
s
P
[(0.4)] .40476 .01472 0 2 Mshowa
p
.002 w
.59524 .01472 m
.59524 .02097 L
s
P
[(0.6)] .59524 .01472 0 2 Mshowa
p
.002 w
.78571 .01472 m
.78571 .02097 L
s
P
[(0.8)] .78571 .01472 0 2 Mshowa
p
.002 w
.97619 .01472 m
.97619 .02097 L
s
P
[(1)] .97619 .01472 0 2 Mshowa
p
.001 w
.0619 .01472 m
.0619 .01847 L
s
P
p
.001 w
.1 .01472 m
.1 .01847 L
s
P
p
.001 w
.1381 .01472 m
.1381 .01847 L
s
P
p
.001 w
.17619 .01472 m
.17619 .01847 L
s
P
p
.001 w
.25238 .01472 m
.25238 .01847 L
s
P
p
.001 w
.29048 .01472 m
.29048 .01847 L
s
P
p
.001 w
.32857 .01472 m
.32857 .01847 L
s
P
p
.001 w
.36667 .01472 m
.36667 .01847 L
s
P
p
.001 w
.44286 .01472 m
.44286 .01847 L
s
P
p
.001 w
.48095 .01472 m
.48095 .01847 L
s
P
p
.001 w
.51905 .01472 m
.51905 .01847 L
s
P
p
.001 w
.55714 .01472 m
.55714 .01847 L
s
P
p
.001 w
.63333 .01472 m
.63333 .01847 L
s
P
p
.001 w
.67143 .01472 m
.67143 .01847 L
s
P
p
.001 w
.70952 .01472 m
.70952 .01847 L
s
P
p
.001 w
.74762 .01472 m
.74762 .01847 L
s
P
p
.001 w
.82381 .01472 m
.82381 .01847 L
s
P
p
.001 w
.8619 .01472 m
.8619 .01847 L
s
P
p
.001 w
.9 .01472 m
.9 .01847 L
s
P
p
.001 w
.9381 .01472 m
.9381 .01847 L
s
P
[(t)] 1.025 .01472 -1 0 Mshowa
p
.002 w
0 .01472 m
1 .01472 L
s
P
p
.002 w
.02381 .15519 m
.03006 .15519 L
s
P
[(0.5)] .01131 .15519 1 0 Mshowa
p
.002 w
.02381 .29566 m
.03006 .29566 L
s
P
[(1)] .01131 .29566 1 0 Mshowa
p
.002 w
.02381 .43614 m
.03006 .43614 L
s
P
[(1.5)] .01131 .43614 1 0 Mshowa
p
.002 w
.02381 .57661 m
.03006 .57661 L
s
P
[(2)] .01131 .57661 1 0 Mshowa
p
.001 w
.02381 .04281 m
.02756 .04281 L
s
P
p
.001 w
.02381 .0709 m
.02756 .0709 L
s
P
p
.001 w
.02381 .099 m
.02756 .099 L
s
P
p
.001 w
.02381 .12709 m
.02756 .12709 L
s
P
p
.001 w
.02381 .18328 m
.02756 .18328 L
s
P
p
.001 w
.02381 .21138 m
.02756 .21138 L
s
P
p
.001 w
.02381 .23947 m
.02756 .23947 L
s
P
p
.001 w
.02381 .26757 m
.02756 .26757 L
s
P
p
.001 w
.02381 .32376 m
.02756 .32376 L
s
P
p
.001 w
.02381 .35185 m
.02756 .35185 L
s
P
p
.001 w
.02381 .37995 m
.02756 .37995 L
s
P
p
.001 w
.02381 .40804 m
.02756 .40804 L
s
P
p
.001 w
.02381 .46423 m
.02756 .46423 L
s
P
p
.001 w
.02381 .49233 m
.02756 .49233 L
s
P
p
.001 w
.02381 .52042 m
.02756 .52042 L
s
P
p
.001 w
.02381 .54852 m
.02756 .54852 L
s
P
p
.001 w
.02381 .6047 m
.02756 .6047 L
s
P
[(u)] .02381 .61803 0 -4 Mshowa
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
1 0 0 r
.004 w
.02381 .01472 m
.11905 .02698 L
.21429 .08007 L
.30952 .18667 L
.40476 .32778 L
.5 .47024 L
.59524 .57353 L
.69048 .60332 L
.78571 .55524 L
.88095 .45302 L
.97619 .33538 L
s
P
% End of Graphics
MathPictureEnd\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{299, 185},
  ImageMargins->{{100, Inherited}, {Inherited, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^B000`400?l00000o`00003oo`3oool/
0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00C`3oool2000000@0oooo0P00
00030?ooo`@00000703oool2000000@0oooo0P0000050?ooo`<000006`3oool2000000@0oooo0P00
00030?ooo`<000007@3oool2000000@0oooo0P0000040?ooo`8000008P3oool5000002H0oooo001>
0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool0703oool010000000oooo0?oo
o`00000;0?ooo`030000003oool0oooo01T0oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`00000K0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000008`3o
ool00`000000oooo0?ooo`0V0?ooo`00CP3oool010000000oooo0?ooo`0000090?ooo`030000003o
ool0oooo01/0oooo00@000000?ooo`3oool00000203oool5000001X0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`00000K0?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool000008`3oool00`000000oooo0?ooo`0V0?ooo`00CP3oool010000000oooo0?ooo`00
000:0?ooo`030000003oool0oooo01X0oooo00@000000?ooo`3oool00000203oool010000000oooo
0?ooo`00000K0?ooo`040000003oool0oooo000000P0oooo0`00000L0?ooo`040000003oool0oooo
000000T0oooo0P00000T0?ooo`030000003oool0oooo02H0oooo001>0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool000006`3oool010000000oooo0?ooo`0000090?ooo`030000
003oool0000001/0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`0K0?ooo`04
0000003oool0oooo000000P0oooo00@000000?ooo`3oool000008`3oool00`000000oooo0?ooo`0V
0?ooo`00C`3oool2000000X0oooo0P00000M0?ooo`8000002`3oool2000001`0oooo0P00000:0?oo
o`<00000703oool2000000X0oooo0P00000S0?ooo`800000:03oool00?l0oooo;03oool00?l0oooo
;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool002/0oooo00<000000?ooo`3o
ool0o@3oool002/0oooo00<000000?ooo`3oool0h@3oool2000001X0oooo000[0?ooo`030000003o
ool0oooo0>00oooo00@000000?ooo`3oool000006@3oool002H0oooo1@0000040?l00=T000001P3o
ool00`000000oooo0?ooo`0J0?ooo`00:`3oool010000000oooo0?ooo`3oool70?l000H0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00P0oooo1@00
000I0?ooo`00:`3oool00`000000oooo0?ooo`080?ooo`P0o`00603oool00`000000oooo0?ooo`0X
0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0X
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool06P3oool002/0oooo00<000000?oo
o`3oool0403oool40?l00>T0oooo000[0?ooo`030000003oool0oooo01@0oooo0P3o003W0?ooo`00
:`3oool00`000000oooo0?ooo`0F0?ooo`80o`00i@3oool002/0oooo00<000000?ooo`3oool0603o
ool20?l00><0oooo000[0?ooo`8000006`3oool00`3o0000oooo0?ooo`3P0?ooo`00:`3oool00`00
0000oooo0?ooo`0K0?ooo`80o`00h03oool002/0oooo00<000000?ooo`3oool07@3oool20?l00=h0
oooo000[0?ooo`030000003oool0oooo01l0oooo0P3o003L0?ooo`00:`3oool00`000000oooo0?oo
o`0Q0?ooo`030?l0003oool0oooo0=T0oooo000[0?ooo`030000003oool0oooo0280oooo0P3o003I
0?ooo`00:`3oool2000002D0oooo0P3o003G0?ooo`00:`3oool00`000000oooo0?ooo`0V0?ooo`80
o`00e@3oool002/0oooo00<000000?ooo`3oool0:03oool00`3o0000oooo0?ooo`3B0?ooo`00:`3o
ool00`000000oooo0?ooo`0Y0?ooo`030?l0003oool0oooo0=40oooo000[0?ooo`030000003oool0
oooo02X0oooo00<0o`000?ooo`3oool0d03oool002/0oooo00<000000?ooo`3oool0:`3oool00`3o
0000oooo0?ooo`3?0?ooo`00:`3oool2000002`0oooo00<0o`000?ooo`3oool0c`3oool002/0oooo
00<000000?ooo`3oool0;03oool00`3o0000oooo0?ooo`3>0?ooo`00:`3oool00`000000oooo0?oo
o`0]0?ooo`030?l0003oool0oooo0<d0oooo000[0?ooo`030000003oool0oooo02h0oooo00<0o`00
0?ooo`3oool0c03oool002/0oooo00<000000?ooo`3oool0;`3oool00`3o0000oooo0?ooo`3;0?oo
o`00:`3oool00`000000oooo0?ooo`0`0?ooo`030?l0003oool0oooo0<X0oooo000[0?ooo`030000
003oool0oooo0340oooo00<0o`000?ooo`3oool0b@3oool002/0oooo0P00000c0?ooo`030?l0003o
ool0oooo0<P0oooo000[0?ooo`030000003oool0oooo0380oooo00<0o`000?ooo`3oool0b03oool0
02/0oooo00<000000?ooo`3oool0<`3oool00`3o0000oooo0?ooo`370?ooo`00:`3oool00`000000
oooo0?ooo`0d0?ooo`030?l0003oool0oooo0<H0oooo000H0?ooo`800000103oool2000000@0oooo
0P0000050?ooo`030000003oool0oooo03D0oooo00<0o`000?ooo`3oool0a@3oool001L0oooo00@0
00000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo03H0
oooo00<0o`000?ooo`3oool0a03oool001L0oooo00@000000?ooo`3oool000002`3oool00`000000
oooo0?ooo`020?ooo`800000>03oool00`3o0000oooo0?ooo`330?ooo`005`3oool010000000oooo
0?ooo`0000090?ooo`8000001@3oool00`000000oooo0?ooo`0h0?ooo`030?l0003oool0oooo0<80
oooo000G0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0i0?ooo`030?l0003oool0oooo0<40oooo000H0?ooo`8000002P3oool3000000@0oooo
00<000000?ooo`3oool0>@3oool00`3o0000oooo0?ooo`310?ooo`00:`3oool00`000000oooo0?oo
o`0j0?ooo`030?l0003oool0oooo0<00oooo000[0?ooo`030000003oool0oooo03/0oooo00<0o`00
0?ooo`3oool0_`3oool002/0oooo0P00000m0?ooo`030?l0003oool0oooo0;h0oooo000[0?ooo`03
0000003oool0oooo03d0oooo00<0o`000?ooo`3oool0_@3oool002/0oooo00<000000?ooo`3oool0
?P3oool00`3o0000oooo0?ooo`2l0?ooo`00:`3oool00`000000oooo0?ooo`0n0?ooo`030?l0003o
ool0oooo0;`0oooo000[0?ooo`030000003oool0oooo03l0oooo00<0o`000?ooo`3oool0^`3oool0
02/0oooo00<000000?ooo`3oool0@03oool00`3o0000oooo0?ooo`2j0?ooo`00:`3oool00`000000
oooo0?ooo`100?ooo`030?l0003oool0oooo0;X0oooo000[0?ooo`800000@P3oool00`3o0000oooo
0?ooo`2i0?ooo`00:`3oool00`000000oooo0?ooo`120?ooo`030?l0003oool0oooo0;P0oooo000[
0?ooo`030000003oool0oooo0480oooo00<0o`000?ooo`3oool0^03oool002/0oooo00<000000?oo
o`3oool0@`3oool00`3o0000oooo0?ooo`2g0?ooo`00:`3oool00`000000oooo0?ooo`140?ooo`03
0?l0003oool0oooo0;H0oooo000[0?ooo`030000003oool0oooo04D0oooo00<0o`000?ooo`3oool0
]@3oool002/0oooo0P0000160?ooo`030?l0003oool0oooo0;D0oooo000[0?ooo`030000003oool0
oooo04H0oooo00<0o`000?ooo`3oool0]03oool002/0oooo00<000000?ooo`3oool0A`3oool00`3o
0000oooo0?ooo`2c0?ooo`00:`3oool00`000000oooo0?ooo`170?ooo`030?l0003oool0oooo0;<0
oooo000[0?ooo`030000003oool0oooo04P0oooo00<0o`000?ooo`3oool0/P3oool002/0oooo00<0
00000?ooo`3oool0B@3oool00`3o0000oooo0?ooo`2a0?ooo`00:`3oool2000004X0oooo00<0o`00
0?ooo`3oool0/@3oool002/0oooo00<000000?ooo`3oool0BP3oool00`3o0000oooo0?ooo`2`0?oo
o`00:`3oool00`000000oooo0?ooo`1;0?ooo`030?l0003oool0oooo0:l0oooo000[0?ooo`030000
003oool0oooo04/0oooo00<0o`000?ooo`3oool0[`3oool002/0oooo00<000000?ooo`3oool0C03o
ool00`3o0000oooo0?ooo`2^0?ooo`008`3oool5000000<0oooo00<000000?ooo`3oool0C@3oool0
0`3o0000oooo0?ooo`2]0?ooo`009@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
04d0oooo00<0o`000?ooo`3oool0[@3oool002D0oooo00<000000?ooo`3oool00`3oool2000004l0
oooo00<0o`000?ooo`3oool0[03oool002D0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`1?0?ooo`030?l0003oool0oooo0:/0oooo000U0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0D03oool00`3o0000oooo0?ooo`2Z0?ooo`00903oool2000000D0oooo00<00000
0?ooo`3oool0D03oool00`3o0000oooo0?ooo`2Z0?ooo`00:`3oool00`000000oooo0?ooo`1A0?oo
o`030?l0003oool0oooo0:T0oooo000[0?ooo`030000003oool0oooo0580oooo00<0o`000?ooo`3o
ool0Z03oool002/0oooo0P00001C0?ooo`030?l0003oool0oooo0:P0oooo000[0?ooo`030000003o
ool0oooo05<0oooo00<0o`000?ooo`3oool0Y`3oool002/0oooo00<000000?ooo`3oool0E03oool0
0`3o0000oooo0?ooo`2V0?ooo`00:`3oool00`000000oooo0?ooo`1D0?ooo`030?l0003oool0oooo
07d0oooo00<0o`000?ooo`3oool09P3oool002/0oooo00<000000?ooo`3oool0E@3oool00`3o0000
oooo0?ooo`1k0?ooo`030?l0003oool0oooo02L0oooo000[0?ooo`030000003oool0oooo05H0oooo
00<0o`000?ooo`3oool0N@3oool00`3o0000oooo0?ooo`0X0?ooo`00:`3oool2000005L0oooo00<0
o`000?ooo`3oool0N03oool00`3o0000oooo0?ooo`0Y0?ooo`00:`3oool00`000000oooo0?ooo`1G
0?ooo`030?l0003oool0oooo07L0oooo00<0o`000?ooo`3oool0:@3oool002/0oooo00<000000?oo
o`3oool0F03oool00`3o0000oooo0?ooo`1e0?ooo`030?l0003oool0oooo02X0oooo000[0?ooo`03
0000003oool0oooo05P0oooo00<0o`000?ooo`3oool0M03oool00`3o0000oooo0?ooo`0[0?ooo`00
:`3oool00`000000oooo0?ooo`1I0?ooo`030?l0003oool0oooo0780oooo00<0o`000?ooo`3oool0
;03oool002/0oooo00<000000?ooo`3oool0FP3oool00`3o0000oooo0?ooo`1`0?ooo`030?l0003o
ool0oooo02d0oooo000[0?ooo`030000003oool0oooo05X0oooo00<0o`000?ooo`3oool0K`3oool0
0`3o0000oooo0?ooo`0^0?ooo`00:`3oool2000005`0oooo00<0o`000?ooo`3oool0KP3oool00`3o
0000oooo0?ooo`0^0?ooo`00:`3oool00`000000oooo0?ooo`1L0?ooo`030?l0003oool0oooo06`0
oooo00<0o`000?ooo`3oool0;`3oool002/0oooo00<000000?ooo`3oool0G03oool00`3o0000oooo
0?ooo`1[0?ooo`030?l0003oool0oooo0300oooo000[0?ooo`030000003oool0oooo05d0oooo00<0
o`000?ooo`3oool0J@3oool00`3o0000oooo0?ooo`0a0?ooo`00:`3oool00`000000oooo0?ooo`1M
0?ooo`030?l0003oool0oooo06P0oooo00<0o`000?ooo`3oool0<P3oool002/0oooo00<000000?oo
o`3oool0GP3oool00`3o0000oooo0?ooo`1V0?ooo`030?l0003oool0oooo03<0oooo000[0?ooo`80
0000H03oool00`3o0000oooo0?ooo`1T0?ooo`030?l0003oool0oooo03@0oooo000[0?ooo`030000
003oool0oooo05l0oooo00<0o`000?ooo`3oool0I03oool00`3o0000oooo0?ooo`0d0?ooo`00:`3o
ool00`000000oooo0?ooo`1P0?ooo`030?l0003oool0oooo0680oooo00<0o`000?ooo`3oool0=@3o
ool002/0oooo00<000000?ooo`3oool0H@3oool00`3o0000oooo0?ooo`1P0?ooo`030?l0003oool0
oooo03H0oooo000G0?ooo`D000000P3oool2000000@0oooo0P0000050?ooo`030000003oool0oooo
0640oooo00<0o`000?ooo`3oool0G`3oool00`3o0000oooo0?ooo`0g0?ooo`006@3oool00`000000
oooo0?ooo`070?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0HP3oool00`3o
0000oooo0?ooo`1M0?ooo`030?l0003oool0oooo03P0oooo000I0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool00P3oool2000006@0oooo00<0o`000?ooo`3oool0F`3oool00`3o0000
oooo0?ooo`0i0?ooo`006@3oool00`000000oooo0?ooo`080?ooo`8000001@3oool00`000000oooo
0?ooo`1S0?ooo`030?l0003oool0oooo05/0oooo00<0o`000?ooo`3oool0>@3oool001T0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo06@0oooo00<0
o`000?ooo`3oool0F@3oool00`3o0000oooo0?ooo`0j0?ooo`00603oool2000000X0oooo0`000004
0?ooo`030000003oool0oooo06D0oooo00<0o`000?ooo`3oool0E`3oool00`3o0000oooo0?ooo`0k
0?ooo`00:`3oool00`000000oooo0?ooo`1U0?ooo`030?l0003oool0oooo05H0oooo00<0o`000?oo
o`3oool0?03oool002/0oooo00<000000?ooo`3oool0IP3oool00`3o0000oooo0?ooo`1D0?ooo`03
0?l0003oool0oooo03d0oooo000[0?ooo`030000003oool0oooo06L0oooo00<0o`000?ooo`3oool0
DP3oool00`3o0000oooo0?ooo`0n0?ooo`00:`3oool2000006P0oooo00<0o`000?ooo`3oool0D@3o
ool00`3o0000oooo0?ooo`0o0?ooo`00:`3oool00`000000oooo0?ooo`1X0?ooo`030?l0003oool0
oooo04l0oooo00<0o`000?ooo`3oool0@03oool002/0oooo00<000000?ooo`3oool0J@3oool00`3o
0000oooo0?ooo`1=0?ooo`030?l0003oool0oooo0440oooo000[0?ooo`030000003oool0oooo06X0
oooo00<0o`000?ooo`3oool0C03oool00`3o0000oooo0?ooo`110?ooo`00:`3oool00`000000oooo
0?ooo`1[0?ooo`030?l0003oool0oooo04X0oooo00<0o`000?ooo`3oool0@P3oool002/0oooo00<0
00000?ooo`3oool0K03oool00`3o0000oooo0?ooo`180?ooo`030?l0003oool0oooo04<0oooo000[
0?ooo`800000KP3oool00`3o0000oooo0?ooo`160?ooo`030?l0003oool0oooo04@0oooo000[0?oo
o`030000003oool0oooo06h0oooo00<0o`000?ooo`3oool0A03oool00`3o0000oooo0?ooo`150?oo
o`00:`3oool00`000000oooo0?ooo`1_0?ooo`030?l0003oool0oooo0480oooo00<0o`000?ooo`3o
ool0AP3oool002/0oooo00<000000?ooo`3oool0L03oool00`3o0000oooo0?ooo`100?ooo`030?l0
003oool0oooo04L0oooo000[0?ooo`030000003oool0oooo0740oooo00<0o`000?ooo`3oool0?P3o
ool00`3o0000oooo0?ooo`180?ooo`00:`3oool00`000000oooo0?ooo`1b0?ooo`030?l0003oool0
oooo03`0oooo00<0o`000?ooo`3oool0B@3oool002/0oooo0P00001d0?ooo`030?l0003oool0oooo
03X0oooo00<0o`000?ooo`3oool0BP3oool002/0oooo00<000000?ooo`3oool0L`3oool00`3o0000
oooo0?ooo`0i0?ooo`030?l0003oool0oooo04/0oooo000[0?ooo`030000003oool0oooo07@0oooo
00<0o`000?ooo`3oool0=`3oool00`3o0000oooo0?ooo`1<0?ooo`00:`3oool00`000000oooo0?oo
o`1e0?ooo`030?l0003oool0oooo03H0oooo00<0o`000?ooo`3oool0C03oool002/0oooo00<00000
0?ooo`3oool0MP3oool00`3o0000oooo0?ooo`0d0?ooo`030?l0003oool0oooo04d0oooo000[0?oo
o`030000003oool0oooo07L0oooo00<0o`000?ooo`3oool0<P3oool00`3o0000oooo0?ooo`1>0?oo
o`00:`3oool00`000000oooo0?ooo`1h0?ooo`030?l0003oool0oooo0300oooo00<0o`000?ooo`3o
ool0C`3oool002/0oooo0P00001j0?ooo`030?l0003oool0oooo02h0oooo00<0o`000?ooo`3oool0
D03oool002/0oooo00<000000?ooo`3oool0NP3oool00`3o0000oooo0?ooo`0/0?ooo`030?l0003o
ool0oooo0540oooo000[0?ooo`030000003oool0oooo07/0oooo00<0o`000?ooo`3oool0:@3oool2
0?l005@0oooo000[0?ooo`030000003oool0oooo07`0oooo00<0o`000?ooo`3oool09P3oool20?l0
05H0oooo000S0?ooo`@00000103oool00`000000oooo0?ooo`1m0?ooo`030?l0003oool0oooo02<0
oooo0P3o001H0?ooo`008`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo07h0oooo
0P3o000Q0?ooo`80o`00FP3oool002@0oooo00<000000?ooo`3oool0103oool200000840oooo0`3o
000L0?ooo`80o`00G03oool002D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`23
0?ooo`<0o`005`3oool20?l005h0oooo000S0?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`3oool0QP3oool30?l00180oooo0P3o001P0?ooo`00903oool2000000D0oooo00<000000?oo
o`3oool0R@3oool30?l000d0oooo0P3o001R0?ooo`00:`3oool00`000000oooo0?ooo`2<0?ooo`<0
o`00203oool20?l006@0oooo000[0?ooo`030000003oool0oooo08l0oooo0`3o00030?ooo`80o`00
IP3oool002/0oooo0P00002C0?ooo`<0o`00J03oool002/0oooo00<000000?ooo`3oool0o@3oool0
02/0oooo00<000000?ooo`3oool0o@3oool002/0oooo00<000000?ooo`3oool0o@3oool00?l0oooo
;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo
;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo
;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo
;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo
;03oool002X0oooo1000003m0?ooo`00:@3oool010000000oooo0?ooo`00003n0?ooo`00:@3oool0
10000000oooo0?ooo`00003n0?ooo`00:03oool2000000030?ooo`00000000000?h0oooo003o0?oo
ob`0oooo003o0?ooob`0oooo003o0?ooob`0oooo003o0?ooob`0oooo003o0?ooob`0oooo0000\
\>"],
  ImageRangeCache->{{{0, 298}, {184, 0}} -> {-0.20292, -0.284212, 0.00465795, \
0.0157899}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.276917 0.0608705 [
[(0.2)] .21429 .27692 0 2 Msboxa
[(0.4)] .40476 .27692 0 2 Msboxa
[(0.6)] .59524 .27692 0 2 Msboxa
[(0.8)] .78571 .27692 0 2 Msboxa
[(1)] .97619 .27692 0 2 Msboxa
[(t)] 1.025 .27692 -1 0 Msboxa
[(-4)] .01131 .03344 1 0 Msboxa
[(-2)] .01131 .15518 1 0 Msboxa
[(2)] .01131 .39866 1 0 Msboxa
[(4)] .01131 .5204 1 0 Msboxa
[(v)] .02381 .61803 0 -4 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.21429 .27692 m
.21429 .28317 L
s
P
[(0.2)] .21429 .27692 0 2 Mshowa
p
.002 w
.40476 .27692 m
.40476 .28317 L
s
P
[(0.4)] .40476 .27692 0 2 Mshowa
p
.002 w
.59524 .27692 m
.59524 .28317 L
s
P
[(0.6)] .59524 .27692 0 2 Mshowa
p
.002 w
.78571 .27692 m
.78571 .28317 L
s
P
[(0.8)] .78571 .27692 0 2 Mshowa
p
.002 w
.97619 .27692 m
.97619 .28317 L
s
P
[(1)] .97619 .27692 0 2 Mshowa
p
.001 w
.0619 .27692 m
.0619 .28067 L
s
P
p
.001 w
.1 .27692 m
.1 .28067 L
s
P
p
.001 w
.1381 .27692 m
.1381 .28067 L
s
P
p
.001 w
.17619 .27692 m
.17619 .28067 L
s
P
p
.001 w
.25238 .27692 m
.25238 .28067 L
s
P
p
.001 w
.29048 .27692 m
.29048 .28067 L
s
P
p
.001 w
.32857 .27692 m
.32857 .28067 L
s
P
p
.001 w
.36667 .27692 m
.36667 .28067 L
s
P
p
.001 w
.44286 .27692 m
.44286 .28067 L
s
P
p
.001 w
.48095 .27692 m
.48095 .28067 L
s
P
p
.001 w
.51905 .27692 m
.51905 .28067 L
s
P
p
.001 w
.55714 .27692 m
.55714 .28067 L
s
P
p
.001 w
.63333 .27692 m
.63333 .28067 L
s
P
p
.001 w
.67143 .27692 m
.67143 .28067 L
s
P
p
.001 w
.70952 .27692 m
.70952 .28067 L
s
P
p
.001 w
.74762 .27692 m
.74762 .28067 L
s
P
p
.001 w
.82381 .27692 m
.82381 .28067 L
s
P
p
.001 w
.8619 .27692 m
.8619 .28067 L
s
P
p
.001 w
.9 .27692 m
.9 .28067 L
s
P
p
.001 w
.9381 .27692 m
.9381 .28067 L
s
P
[(t)] 1.025 .27692 -1 0 Mshowa
p
.002 w
0 .27692 m
1 .27692 L
s
P
p
.002 w
.02381 .03344 m
.03006 .03344 L
s
P
[(-4)] .01131 .03344 1 0 Mshowa
p
.002 w
.02381 .15518 m
.03006 .15518 L
s
P
[(-2)] .01131 .15518 1 0 Mshowa
p
.002 w
.02381 .39866 m
.03006 .39866 L
s
P
[(2)] .01131 .39866 1 0 Mshowa
p
.002 w
.02381 .5204 m
.03006 .5204 L
s
P
[(4)] .01131 .5204 1 0 Mshowa
p
.001 w
.02381 .05778 m
.02756 .05778 L
s
P
p
.001 w
.02381 .08213 m
.02756 .08213 L
s
P
p
.001 w
.02381 .10648 m
.02756 .10648 L
s
P
p
.001 w
.02381 .13083 m
.02756 .13083 L
s
P
p
.001 w
.02381 .17952 m
.02756 .17952 L
s
P
p
.001 w
.02381 .20387 m
.02756 .20387 L
s
P
p
.001 w
.02381 .22822 m
.02756 .22822 L
s
P
p
.001 w
.02381 .25257 m
.02756 .25257 L
s
P
p
.001 w
.02381 .30127 m
.02756 .30127 L
s
P
p
.001 w
.02381 .32561 m
.02756 .32561 L
s
P
p
.001 w
.02381 .34996 m
.02756 .34996 L
s
P
p
.001 w
.02381 .37431 m
.02756 .37431 L
s
P
p
.001 w
.02381 .42301 m
.02756 .42301 L
s
P
p
.001 w
.02381 .44735 m
.02756 .44735 L
s
P
p
.001 w
.02381 .4717 m
.02756 .4717 L
s
P
p
.001 w
.02381 .49605 m
.02756 .49605 L
s
P
p
.001 w
.02381 .00909 m
.02756 .00909 L
s
P
p
.001 w
.02381 .54475 m
.02756 .54475 L
s
P
p
.001 w
.02381 .5691 m
.02756 .5691 L
s
P
p
.001 w
.02381 .59344 m
.02756 .59344 L
s
P
p
.001 w
.02381 .61779 m
.02756 .61779 L
s
P
[(v)] .02381 .61803 0 -4 Mshowa
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
1 0 1 r
.004 w
.02381 .27692 m
.11905 .33008 L
.21429 .45378 L
.30952 .56199 L
.40476 .60332 L
.5 .56782 L
.59524 .4336 L
.69048 .24931 L
.78571 .09619 L
.88095 .01472 L
.97619 .02937 L
s
P
% End of Graphics
MathPictureEnd\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{299, 185},
  ImageMargins->{{100, Inherited}, {Inherited, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^B000`400?l00000o`00003oo`3oool/
0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooo``0oooo000M0?ooo`030000003oool0oooo0?l0
oooo303oool001d0oooo00<000000?ooo`3oool0o`3oool<0?ooo`007@3oool00`000000oooo0?oo
o`3B0?ooo`<0o`3o=P3oool001d0oooo00<000000?ooo`3oool0d@3oool0103o0?l0oooo0?ooo`3o
ool60?l0oc00oooo000M0?ooo`030000003oool0oooo0=00oooo00<0o`3o0?ooo`3oool0203oool6
0?l0obX0oooo000F0?ooo`<00000103oool00`000000oooo0?ooo`3?0?ooo`030?l0o`3oool0oooo
00l0oooo1P3o0?lT0?ooo`005`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0<d0
oooo0P3o0?lH0?ooo`<0o`3o8@3oool001@0oooo1@0000040?ooo`800000c@3oool00`3o0?l0oooo
0?ooo`0l0?ooo`003P3oool400000080oooo00@000000?ooo`3oool000001@3oool00`000000oooo
0?ooo`3;0?ooo`030?l0o`3oool0oooo03d0oooo000E0?ooo`030000003oool0000000D0oooo00<0
00000?ooo`3oool0bP3oool00`3o0?l0oooo0?ooo`0n0?ooo`005P3oool2000000D0oooo00<00000
0?ooo`3oool0b@3oool00`3o0?l0oooo0?ooo`0o0?ooo`007@3oool00`000000oooo0?ooo`380?oo
o`030?l0o`3oool0oooo0400oooo000M0?ooo`030000003oool0oooo0<L0oooo00<0o`3o0?ooo`3o
ool0@@3oool001d0oooo00<000000?ooo`3oool0a@3oool20?l0od@0oooo000M0?ooo`030000003o
ool0oooo0<@0oooo00<0o`3o0?ooo`3oool0A03oool001d0oooo00<000000?ooo`3oool0``3oool0
0`3o0?l0oooo0?ooo`150?ooo`007@3oool00`000000oooo0?ooo`320?ooo`030?l0o`3oool0oooo
04H0oooo000M0?ooo`030000003oool0oooo0<40oooo00<0o`3o0?ooo`3oool0A`3oool001d0oooo
00<000000?ooo`3oool0`03oool00`3o0?l0oooo0?ooo`180?ooo`007@3oool00`000000oooo0?oo
o`2o0?ooo`030?l0o`3oool0oooo04T0oooo000M0?ooo`030000003oool0oooo0;d0oooo0P3o0?m<
0?ooo`007@3oool00`000000oooo0?ooo`2l0?ooo`030?l0o`3oool0oooo04`0oooo000M0?ooo`03
0000003oool0oooo0;/0oooo00<0o`3o0?ooo`3oool0C@3oool001d0oooo00<000000?ooo`3oool0
^P3oool00`3o0?l0oooo0?ooo`1>0?ooo`007@3oool00`000000oooo0?ooo`2i0?ooo`030?l0o`3o
ool0oooo04l0oooo000M0?ooo`030000003oool0oooo0;T0oooo00<0o`3o0?ooo`3oool0C`3oool0
01d0oooo00<000000?ooo`3oool0^03oool00`3o0?l0oooo0?ooo`1@0?ooo`007@3oool00`000000
oooo0?ooo`2g0?ooo`030?l0o`3oool0oooo0540oooo000M0?ooo`030000003oool0oooo0;L0oooo
00<0o`3o0?ooo`3oool0D@3oool001d0oooo00<000000?ooo`3oool0]P3oool00`3o0?l0oooo0?oo
o`1B0?ooo`007@3oool00`000000oooo0?ooo`2f0?ooo`030?l0o`3oool0oooo0580oooo000M0?oo
o`030000003oool0oooo0;D0oooo00<0o`3o0?ooo`3oool0D`3oool001d0oooo00<000000?ooo`3o
ool0]03oool00`3o0?l0oooo0?ooo`1D0?ooo`007@3oool00`000000oooo0?ooo`2d0?ooo`030?l0
o`3oool0oooo05@0oooo000M0?ooo`030000003oool0oooo0;<0oooo00<0o`3o0?ooo`3oool0E@3o
ool001@0oooo100000050?ooo`030000003oool0oooo0;80oooo00<0o`3o0?ooo`3oool0EP3oool0
01@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2b0?ooo`030?l0o`3oool0oooo
05H0oooo000E0?ooo`030000003oool0oooo00D0oooo0P00002b0?ooo`030?l0o`3oool0oooo05L0
oooo000>0?ooo`@00000103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0;40oooo
00<0o`3o0?ooo`3oool0E`3oool001@0oooo00@000000?ooo`3oool000001@3oool00`000000oooo
0?ooo`2`0?ooo`030?l0o`3oool0oooo05P0oooo000E0?ooo`8000001P3oool00`000000oooo0?oo
o`2_0?ooo`030?l0o`3oool0oooo05T0oooo000M0?ooo`030000003oool0oooo0:l0oooo00<0o`3o
0?ooo`3oool0F@3oool001d0oooo00<000000?ooo`3oool0[P3oool00`3o0?l0oooo0?ooo`1J0?oo
o`007@3oool00`000000oooo0?ooo`2]0?ooo`030?l0o`3oool0oooo05/0oooo000M0?ooo`030000
003oool0oooo0:d0oooo00<0o`3o0?ooo`3oool0F`3oool001d0oooo00<000000?ooo`3oool0[03o
ool00`3o0?l0oooo0?ooo`1L0?ooo`007@3oool00`000000oooo0?ooo`2[0?ooo`030?l0o`3oool0
oooo05d0oooo000M0?ooo`030000003oool0oooo0:/0oooo00<0o`3o0?ooo`3oool0G@3oool001d0
oooo00<000000?ooo`3oool0ZP3oool00`3o0?l0oooo0?ooo`1N0?ooo`007@3oool00`000000oooo
0?ooo`2Z0?ooo`030?l0o`3oool0oooo05h0oooo000M0?ooo`030000003oool0oooo0:T0oooo00<0
o`3o0?ooo`3oool0G`3oool001d0oooo00<000000?ooo`3oool0Z03oool00`3o0?l0oooo0?ooo`1P
0?ooo`007@3oool00`000000oooo0?ooo`2X0?ooo`030?l0o`3oool0oooo0600oooo000M0?ooo`03
0000003oool0oooo0:L0oooo00<0o`3o0?ooo`3oool0H@3oool001d0oooo00<000000?ooo`3oool0
9@3oool2000000@0oooo0P0000030?ooo`@00000803oool2000000@0oooo0P0000050?ooo`<00000
803oool2000000@0oooo0P0000030?ooo`<00000503oool00`3o0?l0oooo0?ooo`0:0?ooo`800000
103oool2000000@0oooo0P00000V0?ooo`D000007`3oool001d0oooo00<000000?ooo`3oool0903o
ool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo0200oooo00@000000?ooo`3oool0
00002`3oool00`000000oooo0?ooo`0N0?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool000004`3oool00`3o0?l0oooo0?ooo`090?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool000009`3oool00`000000oooo0?ooo`0O0?ooo`007@3oool00`000000oooo0?oo
o`0T0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool07`3oool010000000oooo
0?ooo`0000080?ooo`D000007`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo
00000180oooo00<0o`3o0?ooo`3oool02P3oool010000000oooo0?ooo`0000080?ooo`040000003o
ool0oooo000002L0oooo00<000000?ooo`3oool07`3oool001d0oooo00<000000?ooo`3oool0903o
ool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo01h0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`00000P0?ooo`040000003oool0oooo000000P0oooo0`00000C
0?ooo`030?l0o`3oool0oooo00X0oooo00@000000?ooo`3oool000002@3oool2000002P0oooo00<0
00000?ooo`3oool07`3oool001d0oooo00<000000?ooo`3oool0903oool010000000oooo0?ooo`00
00080?ooo`040000003oool0oooo000001l0oooo00@000000?ooo`3oool000002@3oool00`000000
oooo0000000P0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool04@3oool00`3o
0?l0oooo0?ooo`0;0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000009`3o
ool00`000000oooo0?ooo`0O0?ooo`007@3oool00`000000oooo0?ooo`0U0?ooo`8000002P3oool2
00000240oooo0P00000;0?ooo`8000008@3oool2000000X0oooo0`00000@0?ooo`030?l0o`3oool0
oooo00d0oooo0P00000:0?ooo`8000009`3oool200000240oooo000M0?ooo`030000003oool0oooo
0:<0oooo00<0o`3o0?ooo`3oool0I@3oool001d0oooo00<000000?ooo`3oool0XP3oool00`3o0?l0
oooo0?ooo`1V0?ooo`007@3oool00`000000oooo0?ooo`2Q0?ooo`030?l0o`3oool0oooo06L0oooo
000M0?ooo`030000003oool0oooo0:40oooo00<0o`3o0?ooo`3oool0I`3oool001d0oooo00<00000
0?ooo`3oool0X03oool00`3o0?l0oooo0?ooo`1X0?ooo`007@3oool00`000000oooo0?ooo`2P0?oo
o`030?l0o`3oool0oooo06P0oooo000M0?ooo`030000003oool0oooo09l0oooo00<0o`3o0?ooo`3o
ool0EP3oool200000140oooo000M0?ooo`030000003oool0oooo09l0oooo00<0o`3o0?ooo`3oool0
E@3oool010000000oooo0?ooo`00000@0?ooo`005`3oool6000000030?l0o`000000000009h00000
00<0o`3o000000000000C`0000070?ooo`030000003oool0oooo0140oooo000M0?ooo`030000003o
0?l0o`3o00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`3o0?l0oooo0?ooo`060?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool02P3oool500000100oooo000M0?ooo`030000003oool0
oooo0080o`3oV`3oool00`3o0?l0oooo0?ooo`1G0?ooo`030000003oool0oooo0140oooo000M0?oo
o`030000003oool0oooo0080oooo0P3o0?nI0?ooo`030?l0o`3oool0oooo06/0oooo000M0?ooo`03
0000003oool0oooo00@0oooo00<0o`3o0?ooo`3oool0U@3oool00`3o0?l0oooo0?ooo`1/0?ooo`00
7@3oool00`000000oooo0?ooo`050?ooo`80o`3oU@3oool00`3o0?l0oooo0?ooo`1/0?ooo`007@3o
ool00`000000oooo0?ooo`070?ooo`80o`3oTP3oool00`3o0?l0oooo0?ooo`1]0?ooo`007@3oool0
0`000000oooo0?ooo`090?ooo`80o`3oT03oool00`3o0?l0oooo0?ooo`1]0?ooo`007@3oool00`00
0000oooo0?ooo`0;0?ooo`80o`3oS@3oool00`3o0?l0oooo0?ooo`1^0?ooo`007@3oool00`000000
oooo0?ooo`0=0?ooo`030?l0o`3oool0oooo08X0oooo00<0o`3o0?ooo`3oool0KP3oool001d0oooo
00<000000?ooo`3oool03P3oool20?l0ohT0oooo00<0o`3o0?ooo`3oool0K`3oool001d0oooo00<0
00000?ooo`3oool0403oool20?l0ohL0oooo00<0o`3o0?ooo`3oool0K`3oool001d0oooo00<00000
0?ooo`3oool04P3oool20?l0oh@0oooo00<0o`3o0?ooo`3oool0L03oool001d0oooo00<000000?oo
o`3oool0503oool00`3o0?l0oooo0?ooo`210?ooo`030?l0o`3oool0oooo0700oooo000M0?ooo`03
0000003oool0oooo01D0oooo00<0o`3o0?ooo`3oool0O`3oool00`3o0?l0oooo0?ooo`1a0?ooo`00
7@3oool00`000000oooo0?ooo`0F0?ooo`030?l0o`3oool0oooo07h0oooo00<0o`3o0?ooo`3oool0
L@3oool001d0oooo00<000000?ooo`3oool05P3oool00`3o0?l0oooo0?ooo`1m0?ooo`030?l0o`3o
ool0oooo0780oooo000M0?ooo`030000003oool0oooo01L0oooo00<0o`3o0?ooo`3oool0O03oool0
0`3o0?l0oooo0?ooo`1b0?ooo`007@3oool00`000000oooo0?ooo`0H0?ooo`030?l0o`3oool0oooo
07X0oooo00<0o`3o0?ooo`3oool0L`3oool001d0oooo00<000000?ooo`3oool06@3oool00`3o0?l0
oooo0?ooo`1i0?ooo`030?l0o`3oool0oooo07<0oooo000M0?ooo`030000003oool0oooo01T0oooo
00<0o`3o0?ooo`3oool0N03oool00`3o0?l0oooo0?ooo`1d0?ooo`007@3oool00`000000oooo0?oo
o`0J0?ooo`030?l0o`3oool0oooo07L0oooo00<0o`3o0?ooo`3oool0M03oool001d0oooo00<00000
0?ooo`3oool06`3oool00`3o0?l0oooo0?ooo`1e0?ooo`030?l0o`3oool0oooo07D0oooo000M0?oo
o`030000003oool0oooo01`0oooo00<0o`3o0?ooo`3oool0M03oool00`3o0?l0oooo0?ooo`1e0?oo
o`007@3oool00`000000oooo0?ooo`0M0?ooo`030?l0o`3oool0oooo0780oooo00<0o`3o0?ooo`3o
ool0MP3oool001d0oooo00<000000?ooo`3oool07@3oool00`3o0?l0oooo0?ooo`1b0?ooo`030?l0
o`3oool0oooo07H0oooo000M0?ooo`030000003oool0oooo01h0oooo00<0o`3o0?ooo`3oool0L03o
ool00`3o0?l0oooo0?ooo`1g0?ooo`007@3oool00`000000oooo0?ooo`0O0?ooo`030?l0o`3oool0
oooo06l0oooo00<0o`3o0?ooo`3oool0M`3oool001@0oooo100000050?ooo`030000003oool0oooo
0200oooo00<0o`3o0?ooo`3oool0K@3oool00`3o0?l0oooo0?ooo`1h0?ooo`00503oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo0200oooo00<0o`3o0?ooo`3oool0K@3oool00`3o0?l0
oooo0?ooo`1h0?ooo`005@3oool00`000000oooo0?ooo`050?ooo`8000008P3oool00`3o0?l0oooo
0?ooo`1[0?ooo`030?l0o`3oool0oooo07T0oooo000F0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool08P3oool00`3o0?l0oooo0?ooo`1Z0?ooo`030?l0o`3oool0oooo07T0oooo000D
0?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool08`3oool00`3o0?l0oooo0?oo
o`1X0?ooo`030?l0o`3oool0oooo07X0oooo000E0?ooo`8000001P3oool00`000000oooo0?ooo`0S
0?ooo`030?l0o`3oool0oooo06P0oooo00<0o`3o0?ooo`3oool0NP3oool001d0oooo00<000000?oo
o`3oool0903oool00`3o0?l0oooo0?ooo`1V0?ooo`030?l0o`3oool0oooo07/0oooo000M0?ooo`03
0000003oool0oooo02D0oooo00<0o`3o0?ooo`3oool0I@3oool00`3o0?l0oooo0?ooo`1k0?ooo`00
7@3oool00`000000oooo0?ooo`0V0?ooo`030?l0o`3oool0oooo06<0oooo00<0o`3o0?ooo`3oool0
O03oool001d0oooo00<000000?ooo`3oool09`3oool00`3o0?l0oooo0?ooo`1R0?ooo`030?l0o`3o
ool0oooo07`0oooo000M0?ooo`030000003oool0oooo02L0oooo00<0o`3o0?ooo`3oool0H@3oool0
0`3o0?l0oooo0?ooo`1m0?ooo`007@3oool00`000000oooo0?ooo`0X0?ooo`030?l0o`3oool0oooo
0600oooo00<0o`3o0?ooo`3oool0O@3oool001d0oooo00<000000?ooo`3oool0:@3oool00`3o0?l0
oooo0?ooo`1N0?ooo`030?l0o`3oool0oooo07h0oooo000M0?ooo`030000003oool0oooo02X0oooo
00<0o`3o0?ooo`3oool0G@3oool00`3o0?l0oooo0?ooo`1n0?ooo`007@3oool00`000000oooo0?oo
o`0Z0?ooo`030?l0o`3oool0oooo05`0oooo00<0o`3o0?ooo`3oool0O`3oool001d0oooo00<00000
0?ooo`3oool0:`3oool00`3o0?l0oooo0?ooo`1J0?ooo`030?l0o`3oool0oooo0800oooo000M0?oo
o`030000003oool0oooo02`0oooo00<0o`3o0?ooo`3oool0F03oool00`3o0?l0oooo0?ooo`210?oo
o`007@3oool00`000000oooo0?ooo`0]0?ooo`030?l0o`3oool0oooo05L0oooo00<0o`3o0?ooo`3o
ool0P@3oool001d0oooo00<000000?ooo`3oool0;P3oool00`3o0?l0oooo0?ooo`1E0?ooo`030?l0
o`3oool0oooo0880oooo000M0?ooo`030000003oool0oooo02l0oooo00<0o`3o0?ooo`3oool0D`3o
ool00`3o0?l0oooo0?ooo`230?ooo`007@3oool00`000000oooo0?ooo`0`0?ooo`030?l0o`3oool0
oooo0540oooo00<0o`3o0?ooo`3oool0Q03oool001d0oooo00<000000?ooo`3oool0<03oool00`3o
0?l0oooo0?ooo`1A0?ooo`030?l0o`3oool0oooo08@0oooo000M0?ooo`030000003oool0oooo0340
oooo00<0o`3o0?ooo`3oool0C`3oool00`3o0?l0oooo0?ooo`250?ooo`007@3oool00`000000oooo
0?ooo`0b0?ooo`030?l0o`3oool0oooo04d0oooo00<0o`3o0?ooo`3oool0QP3oool001d0oooo00<0
00000?ooo`3oool0<`3oool00`3o0?l0oooo0?ooo`1<0?ooo`030?l0o`3oool0oooo08H0oooo000M
0?ooo`030000003oool0oooo03@0oooo00<0o`3o0?ooo`3oool0BP3oool00`3o0?l0oooo0?ooo`27
0?ooo`007@3oool00`000000oooo0?ooo`0e0?ooo`030?l0o`3oool0oooo04P0oooo00<0o`3o0?oo
o`3oool0R03oool001d0oooo00<000000?ooo`3oool0=P3oool00`3o0?l0oooo0?ooo`160?ooo`03
0?l0o`3oool0oooo08T0oooo000M0?ooo`030000003oool0oooo03L0oooo00<0o`3o0?ooo`3oool0
A@3oool00`3o0?l0oooo0?ooo`290?ooo`007@3oool00`000000oooo0?ooo`0h0?ooo`030?l0o`3o
ool0oooo04<0oooo00<0o`3o0?ooo`3oool0RP3oool001H0oooo0`0000040?ooo`030000003oool0
oooo03P0oooo00<0o`3o0?ooo`3oool0@P3oool00`3o0?l0oooo0?ooo`2;0?ooo`005`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo03T0oooo00<0o`3o0?ooo`3oool0@03oool00`3o
0?l0oooo0?ooo`2<0?ooo`00503oool5000000@0oooo0P00000k0?ooo`030?l0o`3oool0oooo03l0
oooo00<0o`3o0?ooo`3oool0S03oool001@0oooo00@000000?ooo`3oool000001@3oool00`000000
oooo0?ooo`0k0?ooo`030?l0o`3oool0oooo03d0oooo00<0o`3o0?ooo`3oool0S@3oool001D0oooo
00<000000?ooo`0000001@3oool00`000000oooo0?ooo`0l0?ooo`030?l0o`3oool0oooo03/0oooo
00<0o`3o0?ooo`3oool0SP3oool001H0oooo0P0000050?ooo`030000003oool0oooo03d0oooo00<0
o`3o0?ooo`3oool0>P3oool00`3o0?l0oooo0?ooo`2>0?ooo`007@3oool00`000000oooo0?ooo`0n
0?ooo`030?l0o`3oool0oooo03P0oooo00<0o`3o0?ooo`3oool0S`3oool001d0oooo00<000000?oo
o`3oool0?`3oool00`3o0?l0oooo0?ooo`0f0?ooo`030?l0o`3oool0oooo0900oooo000M0?ooo`03
0000003oool0oooo0400oooo00<0o`3o0?ooo`3oool0=03oool00`3o0?l0oooo0?ooo`2A0?ooo`00
7@3oool00`000000oooo0?ooo`100?ooo`030?l0o`3oool0oooo03@0oooo00<0o`3o0?ooo`3oool0
T@3oool001d0oooo00<000000?ooo`3oool0@@3oool00`3o0?l0oooo0?ooo`0b0?ooo`030?l0o`3o
ool0oooo0980oooo000M0?ooo`030000003oool0oooo0480oooo00<0o`3o0?ooo`3oool0<03oool0
0`3o0?l0oooo0?ooo`2C0?ooo`007@3oool00`000000oooo0?ooo`130?ooo`030?l0o`3oool0oooo
02h0oooo00<0o`3o0?ooo`3oool0U03oool001d0oooo00<000000?ooo`3oool0A03oool20?l0obh0
oooo00<0o`3o0?ooo`3oool0U03oool001d0oooo00<000000?ooo`3oool0AP3oool20?l0obX0oooo
0P3o0?nG0?ooo`007@3oool00`000000oooo0?ooo`180?ooo`80o`3o9P3oool20?l0oiT0oooo000M
0?ooo`030000003oool0oooo04X0oooo0`3o0?lP0?ooo`<0o`3oV`3oool001d0oooo00<000000?oo
o`3oool0C@3oool20?l0oa/0oooo0`3o0?nN0?ooo`007@3oool00`000000oooo0?ooo`1?0?ooo`80
o`3o5`3oool20?l0oj40oooo000M0?ooo`030000003oool0oooo0540oooo0P3o0?lB0?ooo`<0o`3o
X`3oool001d0oooo00<000000?ooo`3oool0D`3oool30?l0o``0oooo0`3o0?nV0?ooo`007@3oool0
0`000000oooo0?ooo`1F0?ooo`80o`3o203oool20?l0ojT0oooo000M0?ooo`030000003oool0oooo
05P0oooo0P3o0?l30?ooo`<0o`3oZ`3oool001d0oooo00<000000?ooo`3oool0FP3oool30?l0ojh0
oooo000M0?ooo`030000003oool0oooo0?l0oooo303oool001d0oooo00<000000?ooo`3oool0o`3o
ool<0?ooo`007@3oool00`000000oooo0?ooo`3o0?ooo``0oooo003o0?ooob`0oooo003o0?ooob`0
oooo003o0?ooob`0oooo003o0?ooob`0oooo003o0?ooob`0oooo003o0?ooob`0oooo003o0?ooob`0
oooo003o0?ooob`0oooo003o0?ooob`0oooo003o0?ooob`0oooo003o0?ooob`0oooo003o0?ooob`0
oooo003o0?ooob`0oooo003o0?ooob`0oooo003o0?ooob`0oooo003o0?ooob`0oooo003o0?ooob`0
oooo003o0?ooob`0oooo003o0?ooob`0oooo003o0?ooob`0oooo003o0?ooob`0oooo000L0?ooo`80
0000o`3oool>0?ooo`00703oool200000?l0oooo3P3oool001/0oooo00@000000?ooo`3oool00000
o`3oool=0?ooo`006P3oool200000080oooo0P00003o0?ooo``0oooo003o0?ooob`0oooo003o0?oo
ob`0oooo003o0?ooob`0oooo003o0?ooob`0oooo003o0?ooob`0oooo0000\
\>"],
  ImageRangeCache->{{{0, 298}, {184, 0}} -> {-0.122484, -4.56576, 0.0042207, \
0.0660372}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.35255 0.0108187 [
[(0.2)] .21429 .35255 0 2 Msboxa
[(0.4)] .40476 .35255 0 2 Msboxa
[(0.6)] .59524 .35255 0 2 Msboxa
[(0.8)] .78571 .35255 0 2 Msboxa
[(1)] .97619 .35255 0 2 Msboxa
[(t)] 1.025 .35255 -1 0 Msboxa
[(-30)] .01131 .02799 1 0 Msboxa
[(-20)] .01131 .13618 1 0 Msboxa
[(-10)] .01131 .24436 1 0 Msboxa
[(10)] .01131 .46074 1 0 Msboxa
[(20)] .01131 .56892 1 0 Msboxa
[(a)] .02381 .61803 0 -4 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.21429 .35255 m
.21429 .3588 L
s
P
[(0.2)] .21429 .35255 0 2 Mshowa
p
.002 w
.40476 .35255 m
.40476 .3588 L
s
P
[(0.4)] .40476 .35255 0 2 Mshowa
p
.002 w
.59524 .35255 m
.59524 .3588 L
s
P
[(0.6)] .59524 .35255 0 2 Mshowa
p
.002 w
.78571 .35255 m
.78571 .3588 L
s
P
[(0.8)] .78571 .35255 0 2 Mshowa
p
.002 w
.97619 .35255 m
.97619 .3588 L
s
P
[(1)] .97619 .35255 0 2 Mshowa
p
.001 w
.0619 .35255 m
.0619 .3563 L
s
P
p
.001 w
.1 .35255 m
.1 .3563 L
s
P
p
.001 w
.1381 .35255 m
.1381 .3563 L
s
P
p
.001 w
.17619 .35255 m
.17619 .3563 L
s
P
p
.001 w
.25238 .35255 m
.25238 .3563 L
s
P
p
.001 w
.29048 .35255 m
.29048 .3563 L
s
P
p
.001 w
.32857 .35255 m
.32857 .3563 L
s
P
p
.001 w
.36667 .35255 m
.36667 .3563 L
s
P
p
.001 w
.44286 .35255 m
.44286 .3563 L
s
P
p
.001 w
.48095 .35255 m
.48095 .3563 L
s
P
p
.001 w
.51905 .35255 m
.51905 .3563 L
s
P
p
.001 w
.55714 .35255 m
.55714 .3563 L
s
P
p
.001 w
.63333 .35255 m
.63333 .3563 L
s
P
p
.001 w
.67143 .35255 m
.67143 .3563 L
s
P
p
.001 w
.70952 .35255 m
.70952 .3563 L
s
P
p
.001 w
.74762 .35255 m
.74762 .3563 L
s
P
p
.001 w
.82381 .35255 m
.82381 .3563 L
s
P
p
.001 w
.8619 .35255 m
.8619 .3563 L
s
P
p
.001 w
.9 .35255 m
.9 .3563 L
s
P
p
.001 w
.9381 .35255 m
.9381 .3563 L
s
P
[(t)] 1.025 .35255 -1 0 Mshowa
p
.002 w
0 .35255 m
1 .35255 L
s
P
p
.002 w
.02381 .02799 m
.03006 .02799 L
s
P
[(-30)] .01131 .02799 1 0 Mshowa
p
.002 w
.02381 .13618 m
.03006 .13618 L
s
P
[(-20)] .01131 .13618 1 0 Mshowa
p
.002 w
.02381 .24436 m
.03006 .24436 L
s
P
[(-10)] .01131 .24436 1 0 Mshowa
p
.002 w
.02381 .46074 m
.03006 .46074 L
s
P
[(10)] .01131 .46074 1 0 Mshowa
p
.002 w
.02381 .56892 m
.03006 .56892 L
s
P
[(20)] .01131 .56892 1 0 Mshowa
p
.001 w
.02381 .04963 m
.02756 .04963 L
s
P
p
.001 w
.02381 .07126 m
.02756 .07126 L
s
P
p
.001 w
.02381 .0929 m
.02756 .0929 L
s
P
p
.001 w
.02381 .11454 m
.02756 .11454 L
s
P
p
.001 w
.02381 .15781 m
.02756 .15781 L
s
P
p
.001 w
.02381 .17945 m
.02756 .17945 L
s
P
p
.001 w
.02381 .20109 m
.02756 .20109 L
s
P
p
.001 w
.02381 .22273 m
.02756 .22273 L
s
P
p
.001 w
.02381 .266 m
.02756 .266 L
s
P
p
.001 w
.02381 .28764 m
.02756 .28764 L
s
P
p
.001 w
.02381 .30928 m
.02756 .30928 L
s
P
p
.001 w
.02381 .33091 m
.02756 .33091 L
s
P
p
.001 w
.02381 .37419 m
.02756 .37419 L
s
P
p
.001 w
.02381 .39583 m
.02756 .39583 L
s
P
p
.001 w
.02381 .41746 m
.02756 .41746 L
s
P
p
.001 w
.02381 .4391 m
.02756 .4391 L
s
P
p
.001 w
.02381 .48237 m
.02756 .48237 L
s
P
p
.001 w
.02381 .50401 m
.02756 .50401 L
s
P
p
.001 w
.02381 .52565 m
.02756 .52565 L
s
P
p
.001 w
.02381 .54729 m
.02756 .54729 L
s
P
p
.001 w
.02381 .00635 m
.02756 .00635 L
s
P
p
.001 w
.02381 .59056 m
.02756 .59056 L
s
P
p
.001 w
.02381 .6122 m
.02756 .6122 L
s
P
[(a)] .02381 .61803 0 -4 Mshowa
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
0 0 1 r
.004 w
.02381 .35255 m
.11905 .54152 L
.21429 .60332 L
.30952 .4864 L
.40476 .36563 L
.5 .21328 L
.59524 .01472 L
.69048 .0353 L
.78571 .1255 L
.88095 .29 L
.97619 .4672 L
s
P
% End of Graphics
MathPictureEnd\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{299, 185},
  ImageMargins->{{100, Inherited}, {Inherited, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^B000`400?l00000o`00003oo`3oool/
0?ooo`00803oool00`000000oooo0?ooo`3o0?ooo`T0oooo000P0?ooo`030000003oool0oooo0?l0
oooo2@3oool00200oooo00<000000?ooo`3oool0o`3oool90?ooo`00803oool00`000000oooo0?oo
o`2;0?ooo`80003oN`3oool00200oooo00<000000?ooo`3oool0R`3oool00`000?l0oooo0000o`03
0000ogL0oooo000B0?ooo`800000103oool2000000H0oooo00<000000?ooo`3oool0RP3oool00`00
0?l0oooo0?ooo`040?ooo`@0003oL`3oool00140oooo00@000000?ooo`3oool000000P3oool01000
0000oooo0?ooo`0000050?ooo`030000003oool0oooo08X0oooo00<0003o0?ooo`3oool0203oool4
0000ofl0oooo000C0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`03
0?ooo`800000RP3oool00`000?l0oooo0?ooo`0=0?ooo`@0003oJ`3oool000/0oooo100000050?oo
o`040000003oool0oooo00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`29
0?ooo`030000o`3oool0oooo0140oooo10000?mW0?ooo`004@3oool010000000oooo0?ooo`000002
0?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0R03oool00`000?l0oooo0?oo
o`0F0?ooo`80003oI@3oool00180oooo0P0000040?ooo`8000001P3oool00`000000oooo0?ooo`28
0?ooo`030000o`3oool0oooo01P0oooo00<0003o0?ooo`3oool0HP3oool00200oooo00<000000?oo
o`3oool0Q`3oool00`000?l0oooo0?ooo`0J0?ooo`030000o`3oool0oooo0640oooo000P0?ooo`03
0000003oool0oooo08L0oooo00<0003o0?ooo`3oool06`3oool00`000?l0oooo0?ooo`1P0?ooo`00
803oool00`000000oooo0?ooo`260?ooo`030000o`3oool0oooo01d0oooo00<0003o0?ooo`3oool0
G`3oool00200oooo00<000000?ooo`3oool0QP3oool00`000?l0oooo0?ooo`0N0?ooo`030000o`3o
ool0oooo05h0oooo000P0?ooo`030000003oool0oooo08D0oooo00<0003o0?ooo`3oool0803oool2
0000oeh0oooo000P0?ooo`030000003oool0oooo08D0oooo00<0003o0?ooo`3oool08P3oool00`00
0?l0oooo0?ooo`1K0?ooo`00803oool00`000000oooo0?ooo`240?ooo`030000o`3oool0oooo02@0
oooo00<0003o0?ooo`3oool0FP3oool00200oooo00<000000?ooo`3oool0Q03oool00`000?l0oooo
0?ooo`0U0?ooo`030000o`3oool0oooo05T0oooo000P0?ooo`030000003oool0oooo08<0oooo00<0
003o0?ooo`3oool09`3oool00`000?l0oooo0?ooo`1H0?ooo`00803oool00`000000oooo0?ooo`23
0?ooo`030000o`3oool0oooo02P0oooo00<0003o0?ooo`3oool0E`3oool00200oooo00<000000?oo
o`3oool0PP3oool00`000?l0oooo0?ooo`0Z0?ooo`030000o`3oool0oooo05H0oooo000P0?ooo`03
0000003oool0oooo0880oooo00<0003o0?ooo`3oool0:`3oool00`000?l0oooo0?ooo`1E0?ooo`00
803oool00`000000oooo0?ooo`210?ooo`030000o`3oool0oooo02d0oooo00<0003o0?ooo`3oool0
E03oool00200oooo00<000000?ooo`3oool0P@3oool00`000?l0oooo0?ooo`0^0?ooo`030000o`3o
ool0oooo05<0oooo000P0?ooo`030000003oool0oooo0800oooo00<0003o0?ooo`3oool0<03oool0
0`000?l0oooo0?ooo`1B0?ooo`00803oool00`000000oooo0?ooo`200?ooo`030000o`3oool0oooo
0340oooo0P000?mB0?ooo`00803oool00`000000oooo0?ooo`1o0?ooo`030000o`3oool0oooo03@0
oooo00<0003o0?ooo`3oool0C`3oool00200oooo00<000000?ooo`3oool0O`3oool00`000?l0oooo
0?ooo`0e0?ooo`030000o`3oool0oooo04h0oooo000P0?ooo`030000003oool0oooo07l0oooo00<0
003o0?ooo`3oool0=P3oool00`000?l0oooo0?ooo`1=0?ooo`00803oool00`000000oooo0?ooo`1n
0?ooo`030000o`3oool0oooo03P0oooo00<0003o0?ooo`3oool0C03oool00200oooo00<000000?oo
o`3oool0OP3oool00`000?l0oooo0?ooo`0i0?ooo`030000o`3oool0oooo04/0oooo000A0?ooo`@0
00000`3oool2000000H0oooo00<000000?ooo`3oool0O@3oool00`000?l0oooo0?ooo`0k0?ooo`03
0000o`3oool0oooo04X0oooo000A0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool0
00001@3oool00`000000oooo0?ooo`1m0?ooo`030000o`3oool0oooo03/0oooo00<0003o0?ooo`3o
ool0BP3oool00180oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000050?ooo`80
0000O@3oool00`000?l0oooo0?ooo`0m0?ooo`030000o`3oool0oooo04T0oooo000;0?ooo`@00000
103oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`1l0?ooo`030000o`3oool0oooo03d0oooo00<0003o0?ooo`3oool0B@3oool00140oooo
00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo
07/0oooo00<0003o0?ooo`3oool0?`3oool00`000?l0oooo0?ooo`180?ooo`004P3oool2000000@0
oooo0P0000060?ooo`030000003oool0oooo07/0oooo00<0003o0?ooo`3oool0@03oool00`000?l0
oooo0?ooo`170?ooo`00803oool00`000000oooo0?ooo`1j0?ooo`030000o`3oool0oooo0440oooo
00<0003o0?ooo`3oool0A`3oool00200oooo00<000000?ooo`3oool0NP3oool00`000?l0oooo0?oo
o`120?ooo`030000o`3oool0oooo04H0oooo000P0?ooo`030000003oool0oooo07T0oooo00<0003o
0?ooo`3oool0@`3oool00`000?l0oooo0?ooo`160?ooo`00803oool00`000000oooo0?ooo`1i0?oo
o`030000o`3oool0oooo04@0oooo00<0003o0?ooo`3oool0A@3oool00200oooo00<000000?ooo`3o
ool0N03oool00`000?l0oooo0?ooo`150?ooo`030000o`3oool0oooo04D0oooo000P0?ooo`030000
003oool0oooo07P0oooo00<0003o0?ooo`3oool0AP3oool00`000?l0oooo0?ooo`140?ooo`00803o
ool00`000000oooo0?ooo`1g0?ooo`030000o`3oool0oooo04P0oooo00<0003o0?ooo`3oool0@`3o
ool00200oooo00<000000?ooo`3oool0M`3oool00`000?l0oooo0?ooo`180?ooo`030000o`3oool0
oooo04<0oooo000P0?ooo`030000003oool0oooo07H0oooo00<0003o0?ooo`3oool0BP3oool00`00
0?l0oooo0?ooo`120?ooo`00803oool00`000000oooo0?ooo`1f0?ooo`030000o`3oool0oooo04X0
oooo00<0003o0?ooo`3oool0@P3oool00200oooo00<000000?ooo`3oool0M@3oool00`000?l0oooo
0?ooo`1<0?ooo`030000o`3oool0oooo0440oooo000P0?ooo`030000003oool0oooo07D0oooo00<0
003o0?ooo`3oool0C@3oool00`000?l0oooo0?ooo`100?ooo`00803oool00`000000oooo0?ooo`1d
0?ooo`030000o`3oool0oooo04h0oooo00<0003o0?ooo`3oool0@03oool00200oooo00<000000?oo
o`3oool0M03oool00`000?l0oooo0?ooo`1?0?ooo`030000o`3oool0oooo03l0oooo000P0?ooo`03
0000003oool0oooo07<0oooo00<0003o0?ooo`3oool0D03oool00`000?l0oooo0?ooo`0o0?ooo`00
803oool00`000000oooo0?ooo`1c0?ooo`030000o`3oool0oooo0540oooo00<0003o0?ooo`3oool0
?P3oool00200oooo00<000000?ooo`3oool0LP3oool00`000?l0oooo0?ooo`1B0?ooo`030000o`3o
ool0oooo03h0oooo000P0?ooo`030000003oool0oooo0780oooo00<0003o0?ooo`3oool0D`3oool0
0`000?l0oooo0?ooo`0m0?ooo`00803oool00`000000oooo0?ooo`1a0?ooo`030000o`3oool0oooo
05D0oooo00<0003o0?ooo`3oool0?03oool00200oooo00<000000?ooo`3oool0L03oool00`000?l0
oooo0?ooo`1F0?ooo`030000o`3oool0oooo03`0oooo000P0?ooo`030000003oool0oooo0700oooo
00<0003o0?ooo`3oool0E`3oool00`000?l0oooo0?ooo`0k0?ooo`004@3oool500000080oooo0P00
00060?ooo`030000003oool0oooo06l0oooo00<0003o0?ooo`3oool0F03oool00`000?l0oooo0?oo
o`0k0?ooo`004`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`1_0?ooo`030000o`3oool0oooo05T0oooo00<0003o0?ooo`3oool0>P3o
ool001<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo0P00
001_0?ooo`030000o`3oool0oooo05/0oooo00<0003o0?ooo`3oool0>@3oool000/0oooo10000004
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo06d0oooo00<0003o0?ooo`3oool0G03oool00`000?l0oooo0?ooo`0i0?ooo`004`3oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`1]0?ooo`030000o`3oool0oooo05d0oooo00<0003o0?ooo`3oool0>03oool00180oooo0P000004
0?ooo`8000001P3oool00`000000oooo0?ooo`1/0?ooo`030000o`3oool0oooo05h0oooo00<0003o
0?ooo`3oool0>03oool00200oooo00<000000?ooo`3oool0J`3oool00`000?l0oooo0?ooo`1P0?oo
o`030000o`3oool0oooo03L0oooo000P0?ooo`030000003oool0oooo06/0oooo00<0003o0?ooo`3o
ool0H03oool00`000?l0oooo0?ooo`0g0?ooo`00803oool00`000000oooo0?ooo`1Z0?ooo`030000
o`3oool0oooo0680oooo00<0003o0?ooo`3oool0=P3oool00200oooo00<000000?ooo`3oool0JP3o
ool00`000?l0oooo0?ooo`1S0?ooo`030000o`3oool0oooo03D0oooo000P0?ooo`030000003oool0
oooo06T0oooo00<0003o0?ooo`3oool0I03oool00`000?l0oooo0?ooo`0e0?ooo`00803oool00`00
0000oooo0?ooo`1X0?ooo`030000o`3oool0oooo06H0oooo00<0003o0?ooo`3oool0=03oool00200
oooo00<000000?ooo`3oool0J03oool00`000?l0oooo0?ooo`1V0?ooo`030000o`3oool0oooo03@0
oooo000P0?ooo`030000003oool0oooo06L0oooo00<0003o0?ooo`3oool0J03oool00`000?l0oooo
0?ooo`0c0?ooo`00803oool00`000000oooo0?ooo`0U0?ooo`800000103oool2000000<0oooo1000
000P0?ooo`800000103oool2000000D0oooo0`0000020?ooo`030000o`3oool0oooo01/0oooo0P00
00040?ooo`8000000`3oool300000240oooo0P0000040?ooo`800000103oool200000180oooo00<0
003o0?ooo`3oool04@3oool5000001`0oooo000P0?ooo`030000003oool0oooo02@0oooo00@00000
0?ooo`3oool00000203oool00`000000oooo0?ooo`0P0?ooo`040000003oool0oooo000000/0oooo
00D000000?ooo`3oool0oooo0000o`0L0?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool000007`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000140oooo
00<0003o0?ooo`3oool04`3oool00`000000oooo0?ooo`0L0?ooo`00803oool00`000000oooo0?oo
o`0T0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool07`3oool010000000oooo
0?ooo`0000080?ooo`D0000000<0oooo0000o`3oool0703oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo000001l0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`00000B0?ooo`030000o`3oool0oooo0180oooo00<000000?ooo`3oool0703oool00200oooo00<0
00000?ooo`3oool0903oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo01h0oooo
00@000000?ooo`3oool00000203oool01P000000oooo0?ooo`000000oooo0000oah0oooo00@00000
0?ooo`3oool00000203oool300000200oooo00@000000?ooo`3oool000002@3oool2000001<0oooo
00<0003o0?ooo`3oool04P3oool00`000000oooo0?ooo`0L0?ooo`00803oool00`000000oooo0?oo
o`0T0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000007`3oool010000000
oooo0?ooo`0000090?ooo`050000003oool000000?ooo`000?l07P3oool010000000oooo0?ooo`00
00090?ooo`030000003oool0oooo01l0oooo00@000000?ooo`3oool00000203oool010000000oooo
0?ooo`00000C0?ooo`030000o`3oool0oooo0140oooo00<000000?ooo`3oool0703oool00200oooo
00<000000?ooo`3oool09@3oool2000000X0oooo0P00000Q0?ooo`8000002`3oool2000000030000
o`3oool0oooo01h0oooo0P00000:0?ooo`<00000803oool2000000X0oooo0P00000D0?ooo`030000
o`3oool0oooo0100oooo0P00000N0?ooo`00803oool00`000000oooo0?ooo`1S0?ooo`030000o`3o
ool0oooo0700oooo00<0003o0?ooo`3oool0;`3oool00200oooo00<000000?ooo`3oool0HP3oool0
0`000?l0oooo0?ooo`1a0?ooo`030000o`3oool0oooo02l0oooo000P0?ooo`030000003oool0oooo
0640oooo00<0003o0?ooo`3oool0L`3oool00`000?l0oooo0?ooo`0^0?ooo`00803oool00`000000
oooo0?ooo`1Q0?ooo`030000o`3oool0oooo07<0oooo00<0003o0?ooo`3oool0;P3oool00200oooo
00<000000?ooo`3oool0H03oool00`000?l0oooo0?ooo`1e0?ooo`030000o`3oool0oooo02d0oooo
000P0?ooo`030000003oool0oooo05l0oooo00<0003o0?ooo`3oool0MP3oool00`000?l0oooo0?oo
o`0]0?ooo`00803oool00`000000oooo0?ooo`1O0?ooo`030000o`3oool0oooo07L0oooo00<0003o
0?ooo`3oool0703oool2000000h0oooo000P0?ooo`030000003oool0oooo05h0oooo00<0003o0?oo
o`3oool0N03oool00`000?l0oooo0?ooo`0K0?ooo`040000003oool0oooo000000d0oooo000J0?oo
o`H0000000<0003o000000000000GP0000000`000?l000000000001i000000030000o`0000000000
01<000001`3oool00`000000oooo0?ooo`0>0?ooo`00803oool00`000?l0oooo0?ooo`060?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0003o00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00H0oooo00D000000?ooo`3oool0oooo0000o`050?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool02P3oool5000000d0oooo000P0?ooo`03000000000?l0oooo02`0
oooo00<000000?ooo`3oool0;03oool00`000000003o0?ooo`0]0?ooo`030000003oool0oooo02`0
oooo00<000000?ooo`3oool07P3oool00`000?l0oooo0?ooo`0;0?ooo`030000003oool0oooo00/0
oooo00<000000?ooo`3oool03P3oool00200oooo00<000000000o`3oool0G03oool00`000?l0oooo
0?ooo`1l0?ooo`030000o`3oool0oooo02X0oooo000P0?ooo`030000003oool0003o05/0oooo00<0
003o0?ooo`3oool0OP3oool00`000?l0oooo0?ooo`0Y0?ooo`00803oool00`000000oooo0000o`1J
0?ooo`030000o`3oool0oooo07l0oooo00<0003o0?ooo`3oool0:@3oool00200oooo00@000000?oo
o`3oool0003oF03oool00`000?l0oooo0?ooo`210?ooo`030000o`3oool0oooo02P0oooo000P0?oo
o`040000003oool0oooo0000oeP0oooo00<0003o0?ooo`3oool0P@3oool00`000?l0oooo0?ooo`0X
0?ooo`00803oool01@000000oooo0?ooo`3oool0003o05H0oooo00<0003o0?ooo`3oool0P`3oool0
0`000?l0oooo0?ooo`0W0?ooo`00803oool01@000000oooo0?ooo`3oool0003o05D0oooo00<0003o
0?ooo`3oool0Q@3oool00`000?l0oooo0?ooo`0V0?ooo`00803oool00`000000oooo0?ooo`020?oo
o`030000o`3oool0oooo0540oooo00<0003o0?ooo`3oool0QP3oool00`000?l0oooo0?ooo`0V0?oo
o`00803oool00`000000oooo0?ooo`020?ooo`030000o`3oool0oooo0540oooo00<0003o0?ooo`3o
ool0Q`3oool00`000?l0oooo0?ooo`0U0?ooo`00803oool00`000000oooo0?ooo`030?ooo`030000
o`3oool0oooo04l0oooo00<0003o0?ooo`3oool0R03oool00`000?l0oooo0?ooo`0U0?ooo`00803o
ool00`000000oooo0?ooo`030?ooo`030000o`3oool0oooo04h0oooo00<0003o0?ooo`3oool0RP3o
ool00`000?l0oooo0?ooo`0T0?ooo`00803oool00`000000oooo0?ooo`040?ooo`030000o`3oool0
oooo04`0oooo00<0003o0?ooo`3oool0R`3oool00`000?l0oooo0?ooo`0T0?ooo`00803oool00`00
0000oooo0?ooo`040?ooo`030000o`3oool0oooo04`0oooo00<0003o0?ooo`3oool0S03oool00`00
0?l0oooo0?ooo`0S0?ooo`00803oool00`000000oooo0?ooo`050?ooo`030000o`3oool0oooo04X0
oooo00<0003o0?ooo`3oool0S@3oool00`000?l0oooo0?ooo`0S0?ooo`00803oool00`000000oooo
0?ooo`050?ooo`030000o`3oool0oooo04T0oooo00<0003o0?ooo`3oool0S`3oool00`000?l0oooo
0?ooo`0R0?ooo`00803oool00`000000oooo0?ooo`060?ooo`030000o`3oool0oooo04L0oooo00<0
003o0?ooo`3oool0T03oool00`000?l0oooo0?ooo`0R0?ooo`00803oool00`000000oooo0?ooo`06
0?ooo`030000o`3oool0oooo04H0oooo00<0003o0?ooo`3oool0TP3oool00`000?l0oooo0?ooo`0Q
0?ooo`00803oool00`000000oooo0?ooo`070?ooo`030000o`3oool0oooo04D0oooo00<0003o0?oo
o`3oool0TP3oool00`000?l0oooo0?ooo`0Q0?ooo`00803oool00`000000oooo0?ooo`070?ooo`03
0000o`3oool0oooo04@0oooo00<0003o0?ooo`3oool0U03oool00`000?l0oooo0?ooo`0P0?ooo`00
803oool00`000000oooo0?ooo`080?ooo`030000o`3oool0oooo0480oooo00<0003o0?ooo`3oool0
U@3oool00`000?l0oooo0?ooo`0P0?ooo`00803oool00`000000oooo0?ooo`080?ooo`030000o`3o
ool0oooo0440oooo00<0003o0?ooo`3oool0U`3oool00`000?l0oooo0?ooo`0O0?ooo`00803oool0
0`000000oooo0?ooo`090?ooo`030000o`3oool0oooo0400oooo00<0003o0?ooo`3oool0U`3oool0
0`000?l0oooo0?ooo`0O0?ooo`004@3oool500000080oooo0P0000060?ooo`030000003oool0oooo
00T0oooo00<0003o0?ooo`3oool0?`3oool00`000?l0oooo0?ooo`2I0?ooo`030000o`3oool0oooo
01h0oooo000C0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00X0oooo00<0003o0?ooo`3oool0?@3oool00`000?l0oooo0?ooo`2J0?oo
o`030000o`3oool0oooo01h0oooo000C0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`00
0000oooo0?ooo`030?ooo`8000002`3oool00`000?l0oooo0?ooo`0l0?ooo`030000o`3oool0oooo
09`0oooo00<0003o0?ooo`3oool07@3oool001<0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool02`3oool00`000?l0oooo0?ooo`0k0?oo
o`030000o`3oool0oooo09`0oooo00<0003o0?ooo`3oool07@3oool001<0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool02`3oool00`00
0?l0oooo0?ooo`0j0?ooo`030000o`3oool0oooo09h0oooo00<0003o0?ooo`3oool0703oool00180
oooo0P0000040?ooo`8000001P3oool00`000000oooo0?ooo`0<0?ooo`030000o`3oool0oooo03P0
oooo00<0003o0?ooo`3oool0_P3oool00200oooo00<000000?ooo`3oool0303oool00`000?l0oooo
0?ooo`0g0?ooo`030000o`3oool0oooo0;l0oooo000P0?ooo`030000003oool0oooo00d0oooo00<0
003o0?ooo`3oool0=P3oool00`000?l0oooo0?ooo`2o0?ooo`00803oool00`000000oooo0?ooo`0=
0?ooo`030000o`3oool0oooo03D0oooo00<0003o0?ooo`3oool0`03oool00200oooo00<000000?oo
o`3oool03P3oool00`000?l0oooo0?ooo`0c0?ooo`030000o`3oool0oooo0<40oooo000P0?ooo`03
0000003oool0oooo00h0oooo00<0003o0?ooo`3oool0<P3oool00`000?l0oooo0?ooo`320?ooo`00
803oool00`000000oooo0?ooo`0?0?ooo`030000o`3oool0oooo0300oooo00<0003o0?ooo`3oool0
``3oool00200oooo00<000000?ooo`3oool03`3oool00`000?l0oooo0?ooo`0`0?ooo`030000o`3o
ool0oooo0<<0oooo000P0?ooo`030000003oool0oooo0100oooo00<0003o0?ooo`3oool0;P3oool0
0`000?l0oooo0?ooo`340?ooo`00803oool00`000000oooo0?ooo`0@0?ooo`030000o`3oool0oooo
02d0oooo00<0003o0?ooo`3oool0a@3oool00200oooo00<000000?ooo`3oool04@3oool00`000?l0
oooo0?ooo`0[0?ooo`030000o`3oool0oooo0<H0oooo000P0?ooo`030000003oool0oooo0140oooo
00<0003o0?ooo`3oool0:P3oool00`000?l0oooo0?ooo`370?ooo`00803oool00`000000oooo0?oo
o`0B0?ooo`030000o`3oool0oooo02P0oooo00<0003o0?ooo`3oool0b03oool00200oooo00<00000
0?ooo`3oool04P3oool00`000?l0oooo0?ooo`0X0?ooo`030000o`3oool0oooo0<P0oooo000P0?oo
o`030000003oool0oooo01<0oooo00<0003o0?ooo`3oool09P3oool00`000?l0oooo0?ooo`390?oo
o`00803oool00`000000oooo0?ooo`0C0?ooo`030000o`3oool0oooo02D0oooo00<0003o0?ooo`3o
ool0bP3oool00200oooo00<000000?ooo`3oool0503oool00`000?l0oooo0?ooo`0S0?ooo`030000
o`3oool0oooo0</0oooo000P0?ooo`030000003oool0oooo01@0oooo00<0003o0?ooo`3oool08P3o
ool00`000?l0oooo0?ooo`3<0?ooo`00803oool00`000000oooo0?ooo`0E0?ooo`80003o8@3oool0
0`000?l0oooo0?ooo`3=0?ooo`00803oool00`000000oooo0?ooo`0G0?ooo`030000o`3oool0oooo
01h0oooo00<0003o0?ooo`3oool0c@3oool00200oooo00<000000?ooo`3oool0603oool20000oad0
oooo00<0003o0?ooo`3oool0cP3oool00200oooo00<000000?ooo`3oool06P3oool00`000?l0oooo
0?ooo`0I0?ooo`030000o`3oool0oooo0<l0oooo000A0?ooo`@000000`3oool2000000H0oooo00<0
00000?ooo`3oool06`3oool20000oaP0oooo00<0003o0?ooo`3oool0d03oool00140oooo00<00000
0?ooo`3oool00`3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo01d0oooo00<0
003o0?ooo`3oool0503oool00`000?l0oooo0?ooo`3A0?ooo`004P3oool00`000000oooo0?ooo`02
0?ooo`040000003oool0oooo000000D0oooo0P00000O0?ooo`80003o4`3oool00`000?l0oooo0?oo
o`3B0?ooo`004`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0P0?ooo`030000o`3oool0oooo0100oooo00<0003o0?ooo`3oool0dP3o
ool00140oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000050?ooo`030000
003oool0oooo0240oooo0P000?l?0?ooo`030000o`3oool0oooo0=<0oooo000B0?ooo`800000103o
ool2000000H0oooo00<000000?ooo`3oool08`3oool00`000?l0oooo0?ooo`0;0?ooo`030000o`3o
ool0oooo0=@0oooo000P0?ooo`030000003oool0oooo02@0oooo0P000?l:0?ooo`030000o`3oool0
oooo0=D0oooo000P0?ooo`030000003oool0oooo02H0oooo00<0003o0?ooo`3oool01P3oool00`00
0?l0oooo0?ooo`3F0?ooo`00803oool00`000000oooo0?ooo`0W0?ooo`80003o1@3oool00`000?l0
oooo0?ooo`3G0?ooo`00803oool00`000000oooo0?ooo`0Y0?ooo`030000o`3oool0oooo0080oooo
00<0003o0?ooo`3oool0e`3oool00200oooo00<000000?ooo`3oool0:P3oool20000o`030?ooo`00
0?l0oooo0=T0oooo000P0?ooo`030000003oool0oooo02`0oooo00<0003o0?ooo`3oool0f@3oool0
0200oooo00<000000?ooo`3oool0o`3oool90?ooo`00803oool00`000000oooo0?ooo`3o0?ooo`T0
oooo000P0?ooo`030000003oool0oooo0?l0oooo2@3oool00?l0oooo;03oool00?l0oooo;03oool0
0?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool0
0?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool0
0?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool0
0?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool00?l0oooo;03oool001h0oooo1@00003o
0?ooo`T0oooo000N0?ooo`@00000o`3oool:0?ooo`008@3oool00`000000oooo0?ooo`3o0?ooo`P0
oooo000O0?ooo`<00000o`3oool:0?ooo`00o`3oool/0?ooo`00o`3oool/0?ooo`00o`3oool/0?oo
o`00o`3oool/0?ooo`00o`3oool/0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 298}, {184, 0}} -> {-0.135146, -32.6798, 0.0042207, \
0.371553}}],

Cell[OutputFormData["\<\
No Input Form Generated

\
\>", "\<\
t         u          v         a
------------------------------------
0       0           0          0

0.1     0.0436666   0.873332   17.4666

0.2     0.232614    2.90562    23.1792

0.3     0.612055    4.68319    12.3722

0.4     1.11433     5.36223    1.20937

0.5     1.62139     4.77903    -12.8734

0.6     1.98904     2.57402    -31.2269

0.7     2.09507     -0.453534  -29.3241

0.8     1.92394     -2.96909   -20.987

0.9     1.5601      -4.30754   -5.78213

1.      1.14139     -4.0668    10.597\
\>"], "Print",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{984, 599},
WindowMargins->{{-2, Automatic}, {Automatic, -13}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 257, 7, 116, "Title"],
Cell[1977, 58, 583, 11, 120, "Subsection"],
Cell[2563, 71, 220, 6, 85, "Subtitle"],
Cell[2786, 79, 1236, 29, 353, "Text"],
Cell[4025, 110, 245, 8, 68, "Text"],
Cell[4273, 120, 153, 4, 46, "Input"],
Cell[4429, 126, 1393, 22, 182, "Text"],
Cell[5825, 150, 403, 12, 154, "Input"],
Cell[6231, 164, 184, 4, 49, "Text"],
Cell[6418, 170, 212, 8, 82, "Input"],
Cell[6633, 180, 237, 7, 49, "Text"],
Cell[6873, 189, 158, 4, 46, "Input"],
Cell[7034, 195, 355, 8, 68, "Text"],
Cell[7392, 205, 185, 7, 64, "Input"],
Cell[7580, 214, 259, 7, 49, "Text"],
Cell[7842, 223, 259, 12, 154, "Input"],
Cell[8104, 237, 224, 6, 49, "Text"],
Cell[8331, 245, 141, 4, 46, "Input"],
Cell[8475, 251, 368, 8, 49, "Text"],
Cell[8846, 261, 929, 33, 532, "Input"],
Cell[9778, 296, 637, 12, 87, "Text"],
Cell[10418, 310, 1066, 36, 586, "Input"],
Cell[11487, 348, 228, 6, 49, "Text"],
Cell[11718, 356, 251, 8, 82, "Input"],
Cell[11972, 366, 352, 8, 49, "Text"],
Cell[12327, 376, 286, 11, 136, "Input"],
Cell[12616, 389, 357, 8, 49, "Text"],
Cell[12976, 399, 270, 9, 100, "Input"],
Cell[13249, 410, 208, 4, 49, "Text"],
Cell[13460, 416, 653, 17, 244, "Input"],
Cell[14116, 435, 295, 7, 49, "Text"],
Cell[14414, 444, 399, 11, 136, "Input"],
Cell[14816, 457, 118, 3, 121, "Title"],
Cell[14937, 462, 4968, 150, 2638, "Input"],
Cell[19908, 614, 646, 18, 272, "Subsection"],
Cell[20557, 634, 175, 4, 46, "Input"],

Cell[CellGroupData[{
Cell[20757, 642, 237, 7, 64, "Input"],
Cell[20997, 651, 21510, 500, 186, 4600, 287, "GraphicsData", "PostScript", \
"Graphics"],
Cell[42510, 1153, 26845, 613, 186, 5405, 344, "GraphicsData", "PostScript", \
"Graphics"],
Cell[69358, 1768, 26093, 586, 186, 5159, 323, "GraphicsData", "PostScript", \
"Graphics"],
Cell[95454, 2356, 295, 5, 25, "Print"],
Cell[95752, 2363, 71, 1, 25, "Print"],
Cell[95826, 2366, 7913, 182, 341, "Print"]
}, Open  ]],
Cell[103754, 2551, 254, 6, 63, "Subsection"],

Cell[CellGroupData[{
Cell[104033, 2561, 251, 7, 64, "Input"],
Cell[104287, 2570, 23524, 556, 193, 5098, 323, "GraphicsData", "PostScript", \
"Graphics"],
Cell[127814, 3128, 25483, 586, 193, 5311, 332, "GraphicsData", "PostScript", \
"Graphics"],
Cell[153300, 3716, 29179, 605, 193, 4840, 299, "GraphicsData", "PostScript", \
"Graphics"],
Cell[182482, 4323, 295, 5, 25, "Print"],
Cell[182780, 4330, 71, 1, 25, "Print"],
Cell[182854, 4333, 7917, 183, 341, "Print"]
}, Open  ]],
Cell[190786, 4519, 235, 5, 63, "Subsection"],
Cell[191024, 4526, 23812, 626, 193, 3751, 373, "GraphicsData", "PostScript", \
"Graphics"],
Cell[214839, 5154, 221, 5, 63, "Subsection"],

Cell[CellGroupData[{
Cell[215085, 5163, 237, 7, 64, "Input"],
Cell[215325, 5172, 17996, 494, 193, 5260, 332, "GraphicsData", "PostScript", \
"Graphics"],
Cell[233324, 5668, 21452, 537, 193, 5277, 332, "GraphicsData", "PostScript", \
"Graphics"],
Cell[254779, 6207, 23052, 556, 193, 5307, 332, "GraphicsData", "PostScript", \
"Graphics"],
Cell[277834, 6765, 295, 5, 25, "Print"],
Cell[278132, 6772, 71, 1, 25, "Print"],
Cell[278206, 6775, 7867, 178, 341, "Print"]
}, Open  ]],
Cell[286088, 6956, 305, 8, 120, "Subsection"],
Cell[286396, 6966, 17397, 619, 193, 4661, 457, "GraphicsData", "PostScript", \
"Graphics"],
Cell[303796, 7587, 696, 19, 291, "Subsection"],
Cell[304495, 7608, 229, 7, 64, "Input"],

Cell[CellGroupData[{
Cell[304749, 7619, 238, 7, 64, "Input"],
Cell[304990, 7628, 17271, 530, 193, 3473, 355, "GraphicsData", "PostScript", \
"Graphics"],
Cell[322264, 8160, 18563, 568, 193, 3648, 379, "GraphicsData", "PostScript", \
"Graphics"],
Cell[340830, 8730, 22277, 632, 193, 3823, 399, "GraphicsData", "PostScript", \
"Graphics"],
Cell[363110, 9364, 639, 30, 243, "Print"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

