(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     18721,        591]*)
(*NotebookOutlinePosition[     19588,        621]*)
(*  CellTagsIndexPosition[     19544,        617]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["M\[CapitalEAcute]TODO DE NEWMARK ", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Vineta BT",
  FontSize->28,
  FontWeight->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
     Este m\[EAcute]todo est\[AAcute] basado en los m\[EAcute]todos \
integrales, que consisten en aproximar la aceleraci\[OAcute]n.La soluci\
\[OAcute]n se obtiene pues, simplemente integrando esta. El m\[EAcute]todo de \
Newmark propone una f\[OAcute]rmula final que 
depende de unos par\[AAcute]metros, que seg\[UAcute]n el valor que tengan nos \
dar\[AAcute] distintos m\[EAcute]todos.La soluci\[OAcute]n ser\[IAcute]a la \
siguiente:

ui+1 = ui + ( pi+1 - pi ) + a1\[CenterDot]vi + b1\[CenterDot]ai )/k1 
vi+1 = vi + g\[CenterDot]( ui+1-ui )/( b\[CenterDot]( ti+1 - ti ))-( g\
\[CenterDot]ui/b )+
                ai\[CenterDot]( ti+1 - ti ) \[CenterDot]( 1 - ( g/( 2\
\[CenterDot]b )))
ai+1 = ( pi+1 - c\[CenterDot]vi+1 - k\[CenterDot]ui+1 )/m

Si g=0.5 y b=0.25 tenemos el m\[EAcute]todo de la aceleraci\[OAcute]n \
constante.
Si g=0.5 y b=1/6 tenemos el m\[EAcute]todo de la aceleraci\[OAcute]n lineal.
Los t\[EAcute]rminos a1, b1, k1 aparecen calculados en el programa.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Explicaci\[OAcute]n del programa", "Subtitle",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Vineta BT",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[1]],

Cell["\<\

Las variables que hay que introducir son las siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo.
u0=desplazamiento en el instante ti.
v0=velocidad en el instante ti.
k=rigidez.
m=masa.
c=coeficiente de amortiguamiento.
g  y b son unos par\[AAcute]metros con los que podemos elegir que tipo de m\
\[EAcute]todo vamos a emplear.
Hay dos casos particulares:
       1)  M\[EAcute]todo de la aceleraci\[OAcute]n constante    g=0.5   \
b=0.25.
        2) M\[EAcute]todo de la aceleraci\[OAcute]n lineal           g=0.5   \
b=1/6.       
p=carga..Si la carga se da de forma discreta, hay que dar una lista \
{{t1,p1},{t2,p2},.....,{tn.pn}}, en la que cada pareja de valores es la carga \
 p ,  que hay en el instante  t .
El programa da una tabla con los valores del desplazamiento, velocidad y \
aceleraci\[OAcute]n,en cada instante de tiempo junto con su representaci\
\[OAcute]n gr\[AAcute]fica.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\

 C\[AAcute]lculo del n\[UAcute]mero de puntos en los que se va a obtener la \
respuesta\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["n=Floor[(tn-ti)/to+1.];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
 Como la soluci\[OAcute]n se va hallando paso a paso  para cada instante de \
tiempo, hemos de discretizar la carga \"p\",  para tener los valores de ella \
en cada instante en el que va a ser calculada la respuesta.
Cuando la carga venga dada como una funci\[OAcute]n contin\[UAcute]a,  la \
discretizaci\[OAcute]n consiste simplemente en evaluar la funci\[OAcute]n \
para los instantes de tiempo en que vamos a obtener la respuesta.
Si la carga es conocida de forma discreta, o sea , que conocemos la carga de \
forma exacta en unos instantes de tiempo determinados, construiremos una \
funci\[OAcute]n \"pa1\", que ser\[AAcute] la que discretizaremos.
El siguiente programa comprueba si la carga no es una funci\[OAcute]n \
continua, en cuyo caso antes de realizar la interpolaci\[OAcute]n, comprueba \
que la lista tenga valores de carga para instantes de tiempo superiores o \
iguales al instante en que se quiere obtener la respuesta.Si esto no es as\
\[IAcute], o sea se pide la respuesta en un instante \"tn\" que es superior \
al \[UAcute]ltimo instante de tiempo donde se conoce la carga, se supone que \
la carga ha dejado de actuar, y se le asigna el valor cero, para poder \
realizar as\[IAcute] la interpolaci\[OAcute]n.  \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
pa1=p;
If[Head[p]==List,pa2=p;nn=Length[pa2];
    If[pa2[[nn,1]]+to/1000<tn,
        AppendTo[pa2,{pa1[[nn,1]]+to/1000,0.}];
        AppendTo[pa2,{tn,0.}],
          If[tn>pa2[[nn,1]],AppendTo[pa2,{tn,0.}]]];
          pa1=Interpolation[pa2,InterpolationOrder->1]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Discretizaci\[OAcute]n de la carga.", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
pa=Table[0,{i,1,n}];
For[i=1,i<=n,i++,
     pa[[i]]=N[pa1[(ti+(i-1)to)]]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
A continuaci\[OAcute]n se calculan una serie de t\[EAcute]rminos que ser\
\[AAcute] necesarios para obtener la soluci\[OAcute]n,
que se han tomado del libro Dynamics of Structures de Anil k. Chopra.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
k1=k+g c/(b to)+m/(b to^2);
a1=m/(b to)+g c/b;
b1=m/(2 b)+c to (g/(2 b)-1);\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se inicializan los vectores de desplazamiento  \"u\", velocidad  \"v\"  y \
aceleraci\[OAcute]n \"a\".\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
u=Table[u0,{i,1,n}];
v=Table[v0,{i,1,n}];
a=Table[0.,{i,1,n}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
 A trav\[EAcute]s de la ecuaci\[OAcute]n del movimiento se calcula la \
aceleraci\[OAcute]n para el instante inicial \"ti\".\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["a[[1]]=(pa[[1]]-k u[[1]]-c v[[1]])/m;", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Discretizaci\[OAcute]n del tiempo en los instantes en que quiero la \
respuesta.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["tm=Table[ti+(i-1) to,{i,n}];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["C\[AAcute]lculo de \"u\", \"v\"  y  \"a\".", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
 For[i=1,i<n,i++,
      p1=pa[[i+1]]-pa[[i]]+a1 v[[i]]+b1 a[[i]];
      u[[i+1]]=N[u[[i]]+p1/k1];
      v[[i+1]]=N[v[[i]]+g(u[[i+1]]-u[[i]])/(b to)-
                 g v[[i]]/b+to a[[i]]*(1-g/(2 b))];
      a[[i+1]]=N[a[[i]]+(u[[i+1]]-u[[i]])/(b to^2)-
                 v[[i]]/(b to)-a[[i]]/(2 b)]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Para \"u\", \"v\"  y  \"a\", se construye una matriz en la que en la fila \"i\
\" aparece el instante de tiempo \"ti\" y la respuesta \"ui\",\"vi\" y \"ai\" \
respectivamente asociada a ese instante. \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Se representan gr\[AAcute]ficamente \"u\", \"v\"  y  \"a\".", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
gu=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
ga=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se realiza una tabla en la que para para cada instante de tiempo aparecen los \
valores de \"u\", \"v\" y \"a\" asociados a este instante.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"]; 
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
El programa anterior se introduce dentro de la orden Block por lo que el \
programa a ejecutar cuando queramos utilizar el m\[EAcute]todo de Newmark es:\
\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["Newmark", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
posicion;
velocidad;
aceleracion;
Newmark[ti_,tn_,to_,u0_,v0_,k_,m_,c_,p_,g_,b_,posicion_,velocidad_,\
aceleracion_]:= 
  Block[{n,pa1,pa2,nn,pa,i,a0,k1,a1,b1,
         u,v,a,tm,p1,gu,gv,ga},
(*Las variables que hay que introducir son las 
  siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo.
u0=desplazamiento en el instante ti.
v0=velocidad en el instante ti.
k=rigidez.
m=masa.
c=coeficiente de amortiguamiento.
p=carga.Si la carga se da de forma discreta, hay 
que dar una lista {{t1,p1},{t2,p2},.....,{tn.pn}},
en la que cada pareja de valores es la carga  p ,
que hay en el instante  t .
g  y b son unos par\[AAcute]metros con los que podemos elegir 
que tipo de m\[EAcute]todo vamos a emplear.
Hay dos casos particulares:
 1)M\[EAcute]todo de la aceleraci\[OAcute]n constante g=0.5  b=0.25.
 2)M\[EAcute]todo de la aceleraci\[OAcute]n lineal    g=0.5  b=1/6.       

El programa da una tabla con los valores del 
desplazamiento, velocidad y aceleraci\[OAcute]n,en cada instante
de tiempo junto con su representaci\[OAcute]n gr\[AAcute]fica.*)
n=Floor[(tn-ti)/to+1.];
pa1=p;
If[Head[p]==List,pa2=p;nn=Length[pa2];
    If[pa2[[nn,1]]+to/1000<tn,
        AppendTo[pa2,{pa1[[nn,1]]+to/1000,0.}];
        AppendTo[pa2,{tn,0.}],
          If[tn>pa2[[nn,1]],AppendTo[pa2,{tn,0.}]]];
          pa1=Interpolation[pa2,InterpolationOrder->1]];
pa=Table[0,{i,1,n}];
For[i=1,i<=n,i++,
     pa[[i]]=N[pa1[(ti+(i-1)to)]]];
a0=(pa[[1]]-c v0-k u0)/m;
k1=k+g c/(b to)+m/(b to^2);
a1=m/(b to)+g c/b;
b1=m/(2 b)+c to (g/(2 b)-1);
u=Table[u0,{i,1,n}];
v=Table[v0,{i,1,n}];
a=Table[a0,{i,1,n}];
tm=Table[ti+(i-1) to,{i,n}];
   For[i=1,i<n,i++,
      p1=pa[[i+1]]-pa[[i]]+a1 v[[i]]+b1 a[[i]];
      u[[i+1]]=N[u[[i]]+p1/k1];
      v[[i+1]]=N[v[[i]]+g(u[[i+1]]-u[[i]])/(b to)-
                 g v[[i]]/b+to a[[i]]*(1-g/(2 b))];
      a[[i+1]]=N[a[[i]]+(u[[i+1]]-u[[i]])/(b to^2)-
                 v[[i]]/(b to)-a[[i]]/(2 b)]];
    For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];
posicion=u;
velocidad=v;
aceleracion=a;
gu=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
ga=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"]; 
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO:

0.2533\[CenterDot]a( t ) +0.1589\[CenterDot] v( t ) +10\[CenterDot] u( t ) = \
p( t )  
u( 0 )=0
v( 0 )=0
p( t ) = {{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
              {.7,0},{.8,0},{.9,0},{1,0}}

queremos la respuesta hasta el instante tn=1, con un incremento de tiempo de \
to=0.1, utilizando el m\[EAcute]todo de la aceleraci\[OAcute]n lineal.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
Este es un caso donde la carga me la dan discretizada,y as\[IAcute] conocemos \
la carga para unos instantes determinados de tiempo.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Clear[\"Global`*\"] ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
p={{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
    {.7,0},{.8,0},{.9,0},{1,0}};\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Newmark[0,1,0.1,0,0,10,0.2533,0.1589,p,0.5,1/6,posicion,velocidad,aceleracion]\
\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\

La soluci\[OAcute]n exacta del desplazamiento es:

uexac = { 0.,0.0328,0.2332,0.6487,1.1605,1.5241,1.4814,
       0.9245,0.0593,-0.7751,-1.2718 }; 

La representaci\[OAcute]n de ambas funciones se muestra a \
continuaci\[OAcute]n.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
For[i=1,i<=n,i++,
       uexac[[i]]={tm[[i]],Chop[uexac[[i]]]}]; \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
guexac=Graphics[ListPlot[ Table[uexac[[i]],{i,n}],                 
           PlotJoined->True,
           DisplayFunction->Identity,
           AxesLabel->{t,\"p\"}]]; \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Show[gu,guexac]; ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
EJEMPLO

a( t )  +  u( t ) = 5 t
u( 0 ) = 0
v( 0 ) = 0

Hallar la respuesta hasta el instante tn=1 y con un incremento de tiempo \
to=0.1, utilizando el m\[EAcute]todo de la aceleraci\[OAcute]n lineal.
La soluci\[OAcute]n exacta es
 
u( t ) = 5\[CenterDot]t - 5\[CenterDot]Sin ( t )\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Clear[\"Global`*\"] ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["p[t_]:=5 t;", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
Newmark[0,1,0.1,0,0,1,1,0,p,0.5,1/6,posicion,velocidad,aceleracion]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Representaci\[OAcute]n de la soluci\[OAcute]n exacta ( negra ),con la \
aproximada (roja).\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]]
}, Open  ]],

Cell["\<\
exacta=Plot[5 t-5 Sin[t],{t,0,1},
              DisplayFunction->Identity];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Show[gu,exacta];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{991, 599},
WindowMargins->{{-3, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 248, 7, 116, "Title"],
Cell[1968, 58, 1068, 22, 272, "Subsection"],
Cell[3039, 82, 220, 6, 85, "Subtitle"],
Cell[3262, 90, 1074, 28, 334, "Text"],
Cell[4339, 120, 245, 8, 68, "Text"],
Cell[4587, 130, 153, 4, 46, "Input"],
Cell[4743, 136, 1393, 22, 182, "Text"],
Cell[6139, 160, 403, 12, 154, "Input"],
Cell[6545, 174, 184, 4, 49, "Text"],
Cell[6732, 180, 212, 8, 82, "Input"],
Cell[6947, 190, 355, 8, 68, "Text"],
Cell[7305, 200, 213, 8, 82, "Input"],
Cell[7521, 210, 259, 7, 49, "Text"],
Cell[7783, 219, 200, 8, 82, "Input"],
Cell[7986, 229, 281, 7, 49, "Text"],
Cell[8270, 238, 167, 4, 46, "Input"],
Cell[8440, 244, 237, 7, 49, "Text"],
Cell[8680, 253, 158, 4, 46, "Input"],
Cell[8841, 259, 191, 4, 49, "Text"],
Cell[9035, 265, 437, 12, 154, "Input"],
Cell[9475, 279, 357, 8, 49, "Text"],
Cell[9835, 289, 270, 9, 100, "Input"],
Cell[10108, 300, 208, 4, 49, "Text"],
Cell[10319, 306, 653, 17, 244, "Input"],
Cell[10975, 325, 295, 7, 49, "Text"],
Cell[11273, 334, 399, 11, 136, "Input"],
Cell[11675, 347, 311, 8, 49, "Text"],
Cell[11989, 357, 110, 3, 121, "Title"],
Cell[12102, 362, 3030, 86, 1468, "Input"],
Cell[15135, 450, 465, 14, 215, "Subsection"],
Cell[15603, 466, 223, 5, 63, "Subsection"],
Cell[15829, 473, 150, 4, 46, "Input"],
Cell[15982, 479, 229, 7, 64, "Input"],
Cell[16214, 488, 218, 7, 46, "Input"],
Cell[16435, 497, 322, 11, 177, "Subsection"],
Cell[16760, 510, 203, 7, 64, "Input"],
Cell[16966, 519, 308, 9, 100, "Input"],
Cell[17277, 530, 90, 2, 30, "Input"],
Cell[17370, 534, 373, 14, 234, "Subsection"],
Cell[17746, 550, 150, 4, 46, "Input"],
Cell[17899, 556, 84, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[18008, 562, 205, 6, 46, "Input"],
Cell[18216, 570, 181, 5, 63, "Subsection"]
}, Open  ]],
Cell[18412, 578, 213, 7, 64, "Input"],
Cell[18628, 587, 89, 2, 30, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

