(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21957,        702]*)
(*NotebookOutlinePosition[     22825,        732]*)
(*  CellTagsIndexPosition[     22781,        728]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["M\[CapitalEAcute]TODO BASADO EN LA INTERPOLACI\[CapitalOAcute]N DE LA \
CARGA", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Vineta BT",
  FontWeight->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
     En este m\[EAcute]todo para hallar la soluci\[OAcute]n en el instante \
i+1,partimos de la soluci\[OAcute]n en el instante i,que ya es conocida. \
Hacemos la suposici\[OAcute]n
de que la carga var\[IAcute]a de forma lineal entre los instantes i e i+1.As\
\[IAcute] la ecuaci\[OAcute]n del movimiento es f\[AAcute]cil de resolver \
pues estar\[IAcute]a sometida a una 
carga lineal:
         
   m\[CenterDot]a( t ) + c\[CenterDot]v( t ) + k\[CenterDot]u( t ) = pi + ( \
pi+1 - pi )( t - ti )/( ti+1 - ti ) 
        
donde ti<t<ti+1.
     Para resolver la ecuaci\[OAcute]n se hace el cambio de variable \
tau=t-ti. La respuesta ser\[AAcute] la suma de la debida a la carga constante \
pi, mas la 
correspondiente a la carga lineal ( pi+1 - pi )tau/( ti+1 - ti ).
     Particularizando para tau = ti+1 - ti, se obtiene la soluci\[OAcute]n \
para el instante i+1, en funci\[OAcute]n de lo ocurrido en el instante i.La \
aceleraci\[OAcute]n la 
obtengo con la ecuaci\[OAcute]n del movimiento: 

ui+1 = a2\[CenterDot]ui + b\[CenterDot]vi + c2\[CenterDot]pi + \
d\[CenterDot]pi+1
vi+1 = a1\[CenterDot]ui + b1\[CenterDot]vi + c1\[CenterDot]pi + \
d1\[CenterDot]pi+1
ai+1 = ( pi+1 - k\[CenterDot]ui+1 - c\[CenterDot]vi+1 )/m\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Explicaci\[OAcute]n del programa", "Subtitle",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Vineta BT",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[1]],

Cell["\<\
Las variables que hay que introducir son las siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo.
u0=desplazamiento en el instante ti.
v0=velocidad en el instante ti.
k=rigidez.
m=masa.
c=coeficiente de amortiguamiento.
p=carga..Si la carga se da de forma discreta, hay que dar una lista \
{{t1,p1},{t2,p2},.....,{tn.pn}}, en la que cada pareja de valores es la carga \
 p ,  que hay en el instante  t .\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
El programa da una tabla con los valores del desplazamiento, velocidad y \
aceleraci\[OAcute]n,en cada instante de tiempo junto con su representaci\
\[OAcute]n gr\[AAcute]fica\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\

 C\[AAcute]lculo del n\[UAcute]mero de puntos en los que se va a obtener la \
respuesta\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["n=Floor[(tn-ti)/to+1.];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
 Como la soluci\[OAcute]n se va hallando paso a paso  para cada instante de \
tiempo, hemos de discretizar la carga \"p\",  para tener los valores de ella \
en cada instante en el que va a ser calculada la respuesta.
Cuando la carga venga dada como una funci\[OAcute]n contin\[UAcute]a,  la \
discretizaci\[OAcute]n consiste simplemente en evaluar la funci\[OAcute]n \
para los instantes de tiempo en que vamos a obtener la respuesta.
Si la carga es conocida de forma discreta, o sea , que conocemos la carga de \
forma exacta en unos instantes de tiempo determinados, construiremos una \
funci\[OAcute]n \"pa1\", que ser\[AAcute] la que discretizaremos.
El siguiente programa comprueba si la carga no es una funci\[OAcute]n \
continua, en cuyo caso antes de realizar la interpolaci\[OAcute]n, comprueba \
que la lista tenga valores de carga para instantes de tiempo superiores o \
iguales al instante en que se quiere obtener la respuesta.Si esto no es as\
\[IAcute], o sea se pide la respuesta en un instante \"tn\" que es superior \
al \[UAcute]ltimo instante de tiempo donde se conoce la carga, se supone que \
la carga ha dejado de actuar, y se le asigna el valor cero, para poder \
realizar as\[IAcute] la interpolaci\[OAcute]n.  \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
pa1=p;
If[Head[p]==List,pa2=p;nn=Length[pa2];
    If[pa2[[nn,1]]+to/1000<tn,
        AppendTo[pa2,{pa1[[nn,1]]+to/1000,0.}];
        AppendTo[pa2,{tn,0.}],
          If[tn>pa2[[nn,1]],AppendTo[pa2,{tn,0.}]]];
          pa1=Interpolation[pa2,InterpolationOrder->1]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Discretizaci\[OAcute]n de la carga.", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
pa=Table[0,{i,1,n}];
For[i=1,i<=n,i++,
     pa[[i]]=N[pa1[(ti+(i-1)to)]]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
A continuaci\[OAcute]n se calculan una serie de t\[EAcute]rminos que ser\
\[AAcute] necesarios para obtener la soluci\[OAcute]n,
que se han tomado del libro Dynamics of Structures de Anil k. Chopra.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
s=c/(2 Sqrt[m k]);
wn=Sqrt[k/m];
wd=wn Sqrt[1-s^2];
a2=N[Exp[-s wn to]*((s Sin[wd to]/Sqrt[1-s^2])+
                     Cos[wd to])];
b=N[Exp[-s wn to]*(Sin[wd to]/wd)];
c2=N[((2 s/(wn to))+Exp[-s wn to]*
                        ((((1-2 s^2)/(wd to))-
 s/Sqrt[1-s^2]) Sin[wd to]-(1+2 s/(wn to))*
                         Cos[wd to]))/k];
d=N[(1-2 s/(wn to)+Exp[-s wn to]*
    ((2 s^2 -1) Sin[wd to]/(wd to)+
      2 s Cos[wd to]/(wn to)))/k];
a1=N[-Exp[-s wn to]*(wn Sin[wd to]/Sqrt[1-s^2])];
b1=N[Exp[-s wn to]*(Cos[wd to]-s*
                    Sin[wd to]/Sqrt[1-s^2])];
c1=N[(-1/to+Exp[-s wn to]*(((wn/Sqrt[1-s^2])+
     s/(to Sqrt[1-s^2])) Sin[wd to]+Cos[wd to]/to))/k];
d1=N[(1-Exp[-s wn to]*((s Sin[wd to]/Sqrt[1-s^2])+
      Cos[wd to]))/(k to)];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se inicializan los vectores de desplazamiento  \"u\", velocidad  \"v\"  y \
aceleraci\[OAcute]n \"a\".\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
u=Table[u0,{i,1,n}];
v=Table[v0,{i,1,n}];
a=Table[0.,{i,1,n}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
 A trav\[EAcute]s de la ecuaci\[OAcute]n del movimiento se calcula la \
aceleraci\[OAcute]n para el instante inicial \"ti\".\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["a[[1]]=(pa[[1]]-k u[[1]]-c v[[1]])/m;", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Discretizaci\[OAcute]n del tiempo en los instantes en que quiero la \
respuesta.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["tm=Table[ti+(i-1) to,{i,n}];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["C\[AAcute]lculo de \"u\", \"v\"  y  \"a\".", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
 For[i=1,i<n,i++,
          u[[i+1]]=N[a2 u[[i]]+b v[[i]]+
                     c2 pa[[i]]+d pa[[i+1]]];
          v[[i+1]]=N[a1 u[[i]]+b1 v[[i]]+
                     c1 pa[[i]]+d1 pa[[i+1]]];
          a[[i+1]]=N[(pa[[i+1]]-k u[[i+1]]-
                      c v[[i+1]])/m]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Para \"u\", \"v\"  y  \"a\", se construye una matriz en la que en la fila \"i\
\" aparece el instante de tiempo \"ti\" y la respuesta \"ui\",\"vi\" y \"ai\" \
respectivamente asociada a ese instante. \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Se representan gr\[AAcute]ficamente \"u\", \"v\"  y  \"a\".", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
gu=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
ga=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se realiza una tabla en la que para para cada instante de tiempo aparecen los \
valores de \"u\", \"v\" y \"a\" asociados a este instante.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"]; 
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
El programa anterior se introduce dentro de la orden Block quedando :\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["InterpolacionCarga", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
posicion;
velocidad;
aceleracion;
InterpolacionLinealCarga[ti_,tn_,to_,u0_,v0_,k_,m_,c_,p_,posicion_,velocidad_,\
aceleracion_]:=
  Block[{n,pa1,pa2,nn,pa,i,s,wn,wd,a2,b,c2,d,a1,
         b1,c1,d1,u,v,a,tm,gu,gv,ga},
(*Las variables que hay que introducir son 
  las siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo.
u0=desplazamiento en el instante ti.
v0=velocidad en el instante ti.
k=rigidez.
m=masa.
c=coeficiente de amortiguamiento.
p=carga.Si la carga se da de forma discreta, hay 
que dar una lista {{t1,p1},{t2,p2},.....,{tn.pn}},
en la que cada pareja de valores es la carga  p ,
que hay en el instante  t .
El programa da una tabla con los valores del 
desplazamiento, velocidad y aceleraci\[OAcute]n,en cada instante
de tiempo junto con su representaci\[OAcute]n gr\[AAcute]fica *)
n=Floor[(tn-ti)/to+1.];
pa1=p;
If[Head[p]==List,pa2=p;nn=Length[pa2];
    If[pa2[[nn,1]]+to/1000<tn,
        AppendTo[pa2,{pa1[[nn,1]]+to/1000,0.}];
        AppendTo[pa2,{tn,0.}],
          If[tn>pa2[[nn,1]],AppendTo[pa2,{tn,0.}]]];
          pa1=Interpolation[pa2,InterpolationOrder->1]];
pa=Table[0,{i,1,n}];
For[i=1,i<=n,i++,
     pa[[i]]=N[pa1[(ti+(i-1)to)]]];
s=c/(2 Sqrt[m k]);
wn=Sqrt[k/m];
wd=wn Sqrt[1-s^2];
a2=N[Exp[-s wn to]*((s Sin[wd to]/Sqrt[1-s^2])+Cos[wd to])];
b=N[Exp[-s wn to]*(Sin[wd to]/wd)];
c2=N[((2 s/(wn to))+Exp[-s wn to]*((((1-2 s^2)/(wd to))-
 s/Sqrt[1-s^2]) Sin[wd to]-(1+2 s/(wn to)) Cos[wd to]))/k];
d=N[(1-2 s/(wn to)+Exp[-s wn to]*
 ((2 s^2 -1) Sin[wd to]/(wd to)+2 s Cos[wd to]/(wn to)))/k];
a1=N[-Exp[-s wn to]*(wn Sin[wd to]/Sqrt[1-s^2])];
b1=N[Exp[-s wn to]*(Cos[wd to]-s Sin[wd to]/Sqrt[1-s^2])];
c1=N[(-1/to+Exp[-s wn to]*(((wn/Sqrt[1-s^2])+
     s/(to Sqrt[1-s^2])) Sin[wd to]+Cos[wd to]/to))/k];
d1=N[(1-Exp[-s wn to]*((s Sin[wd to]/Sqrt[1-s^2])+
      Cos[wd to]))/(k to)];
u=Table[u0,{i,1,n}];
v=Table[v0,{i,1,n}];
a=Table[0.,{i,1,n}];
a[[1]]=(pa[[1]]-k u[[1]]-c v[[1]])/m;
tm=Table[ti+(i-1) to,{i,n}];
  For[i=1,i<n,i++,
          u[[i+1]]=N[a2 u[[i]]+b v[[i]]+
                     c2 pa[[i]]+d pa[[i+1]]];
          v[[i+1]]=N[a1 u[[i]]+b1 v[[i]]+
                     c1 pa[[i]]+d1 pa[[i+1]]];
          a[[i+1]]=N[(pa[[i+1]]-k u[[i+1]]-
                      c v[[i+1]])/m]];
    For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];
posicion=u;
velocidad=v;
aceleracion=a;
gu=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
ga=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"]; 
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO

a( t ) + 0.25 v( t ) + u( t ) = Sin( t )
u(0)=0
v(0)=0

y queremos la respuesta hasta el instante tn=50, con un incremento de tiempo \
de to=0.2.
\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
   Este es un caso de resonancia con amortiguamiento,por lo que la soluci\
\[OAcute]n real crecer\[AAcute] oscilando,asint\[OAcute]ticamente,quedando \
acotada por 
los valores  1/(2 s)  y  -1/(2 s), donde   s = c/(2 Sqrt[m k]), siendo pues \
las as\[IAcute]ntotas u=4, u= -4.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Clear[\"Global`*\"] ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["p[x_]:=Sin[x]; ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
InterpolacionLinealCarga[0,50,.2,0,0,1,1,0.25,p,posicion,velocidad,\
aceleracion] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO

a + u = 0
u(0)=10
v(0)=0

y queremos la respuesta hasta el instante tn=10, con un incremento de tiempo \
de to=0.25.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
Este es un sencillo caso de vibraciones libres sin amortiguamiento para el \
que la soluci\[OAcute]n exacta es :
u( t ) = 10 Cos( t ).\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["p[x_]:=0;  ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
InterpolacionLinealCarga[0,10,.25,10,0,1,1,0.,p,posicion,velocidad,\
acelereacion]  \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Para ver el grado de aproximaci\[OAcute]n dibujamos la aproximaci\[OAcute]n y \
la soluci\[OAcute]n exacta conjuntamente.La aproximaci\[OAcute]n est\[AAcute] \
pintada en rojo y en negro la 
soluci\[OAcute]n real. \
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
exacta=Plot[10 Cos[t],{t,0,10},
              DisplayFunction->Identity];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Show[gu,exacta];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
EJEMPLO:

0.2533\[CenterDot]a( t ) +0.1589\[CenterDot] v( t ) +10\[CenterDot] u( t ) = \
p( t )  
u( 0 )=0
v( 0 )=0
p( t ) = {{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
              {.7,0},{.8,0},{.9,0},{1,0}}

queremos la respuesta hasta el instante tn=1, con un incremento de tiempo de \
to=0.1.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
Este es un caso donde la carga me la dan discretizada,y as\[IAcute] conocemos \
la carga para unos instantes determinados de tiempo.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
p={{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
    {.7,0},{.8,0},{.9,0},{1,0}};    \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
InterpolacionLinealCarga[0,1,0.1,0,0,10,0.2533,0.1589,p,posicion,velocidad,\
aceleracion] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
La soluci\[OAcute]n exacta del desplazamiento es:

uexac = { 0.,0.0328,0.2332,0.6487,1.1605,1.5241,1.4814,
       0.9245,0.0593,-0.7751,-1.2718 }; 

La representaci\[OAcute]n de ambas funciones se muestra a \
continuaci\[OAcute]n.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
uexac = { 0.,0.0328,0.2332,0.6487,1.1605,1.5241,1.4814, 
           0.9245,0.0593,-0.7751,-1.2718 };     \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
For[i=1,i<=n,i++,
       uexac[[i]]={tm[[i]],Chop[uexac[[i]]]}];      \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
guexac=Graphics[ListPlot[ Table[uexac[[i]],{i,n}],                 
           PlotJoined->True, 
           DisplayFunction->Identity,
           AxesLabel->{t,\"p\"}]];     \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Show[gu,guexac];      ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO

a + 0.25 v +10 u =10
u(0)=0
v(0)=0

y queremos la respuesta hasta el instante tn=40, con un incremento de tiempo \
de to=1.23\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
La soluci\[OAcute]n de esta ecuaci\[OAcute]n tiende a u(t)=(p/k)=1, una vez \
que la homog\[EAcute]nea se halla amortiguado.La velocidad y aceleraci\
\[OAcute]n tienden a cero v(t)=a(t)=0.Para observar este fen\[OAcute]meno \
veamos la respuesta en un tiempo lo suficientemente largo.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["p[x_]:=10; ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
InterpolacionLinealCarga[0,40,1.23,0,0,10,1,0.25,p,posicion,velocidad,\
aceleracion] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{866, 599},
WindowMargins->{{-3, Automatic}, {Automatic, 23}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 276, 7, 226, "Title"],
Cell[1996, 58, 1312, 29, 405, "Subsection"],
Cell[3311, 89, 220, 6, 85, "Subtitle"],
Cell[3534, 97, 584, 17, 220, "Text"],
Cell[4121, 116, 332, 8, 49, "Text"],
Cell[4456, 126, 245, 8, 68, "Text"],
Cell[4704, 136, 153, 4, 46, "Input"],
Cell[4860, 142, 1393, 22, 201, "Text"],
Cell[6256, 166, 403, 12, 154, "Input"],
Cell[6662, 180, 184, 4, 49, "Text"],
Cell[6849, 186, 212, 8, 82, "Input"],
Cell[7064, 196, 355, 8, 68, "Text"],
Cell[7422, 206, 892, 25, 388, "Input"],
Cell[8317, 233, 259, 7, 49, "Text"],
Cell[8579, 242, 200, 8, 82, "Input"],
Cell[8782, 252, 281, 7, 49, "Text"],
Cell[9066, 261, 167, 4, 46, "Input"],
Cell[9236, 267, 237, 7, 49, "Text"],
Cell[9476, 276, 158, 4, 46, "Input"],
Cell[9637, 282, 191, 4, 49, "Text"],
Cell[9831, 288, 414, 12, 154, "Input"],
Cell[10248, 302, 357, 8, 68, "Text"],
Cell[10608, 312, 270, 9, 100, "Input"],
Cell[10881, 323, 208, 4, 49, "Text"],
Cell[11092, 329, 653, 17, 244, "Input"],
Cell[11748, 348, 295, 7, 49, "Text"],
Cell[12046, 357, 399, 11, 136, "Input"],
Cell[12448, 370, 226, 6, 49, "Text"],
Cell[12677, 378, 121, 3, 121, "Title"],
Cell[12801, 383, 3338, 92, 1576, "Input"],
Cell[16142, 477, 218, 11, 180, "Subsection"],
Cell[16363, 490, 367, 8, 101, "Subsection"],
Cell[16733, 500, 150, 4, 46, "Input"],
Cell[16886, 506, 88, 2, 30, "Input"],
Cell[16977, 510, 220, 7, 46, "Input"],
Cell[17200, 519, 216, 11, 177, "Subsection"],
Cell[17419, 532, 225, 6, 82, "Subsection"],
Cell[17647, 540, 141, 4, 46, "Input"],
Cell[17791, 546, 222, 7, 46, "Input"],
Cell[18016, 555, 305, 7, 101, "Subsection"],
Cell[18324, 564, 211, 7, 64, "Input"],
Cell[18538, 573, 89, 2, 30, "Input"],
Cell[18630, 577, 402, 14, 215, "Subsection"],
Cell[19035, 593, 223, 5, 63, "Subsection"],
Cell[19261, 600, 233, 7, 64, "Input"],
Cell[19497, 609, 228, 7, 46, "Input"],
Cell[19728, 618, 321, 10, 158, "Subsection"],
Cell[20052, 630, 243, 7, 64, "Input"],
Cell[20298, 639, 208, 7, 64, "Input"],
Cell[20509, 648, 313, 9, 100, "Input"],
Cell[20825, 659, 152, 4, 46, "Input"],
Cell[20980, 665, 225, 11, 177, "Subsection"],
Cell[21208, 678, 375, 7, 82, "Subsection"],
Cell[21586, 687, 141, 4, 46, "Input"],
Cell[21730, 693, 223, 7, 46, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

