(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     22749,        739]*)
(*NotebookOutlinePosition[     23616,        769]*)
(*  CellTagsIndexPosition[     23572,        765]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["M\[CapitalEAcute]TODO DE HOUBOLT", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Vineta BT",
  FontSize->28,
  FontWeight->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
 Houbolt propone hallar ui+1 en funci\[OAcute]n de ui, ui-1 y ui-1.Para ello \
supone que estos cuatro puntos pasan por la par\[AAcute]bola c\[UAcute]bica
       
         u(tau)=A\[CenterDot]tau^3 + B\[CenterDot]tau^2 +C\[CenterDot]tau + D \
  siendo
         
tau=t-ti
A=(1/(6\[CenterDot]to^3))\[CenterDot](-ui-2 + 3\[CenterDot]ui-1 - 3\
\[CenterDot]ui + ui+1)
B=(1/(2\[CenterDot]to^2))\[CenterDot](ui-1 - 2\[CenterDot]ui + ui+1)
C=(1/(6\[CenterDot]to))\[CenterDot](ui-2 - 6\[CenterDot]ui-1 + \
3\[CenterDot]ui + 2\[CenterDot]ui+1)
to=ti+1 - ti
                     
    Derivando una y dos veces la cubica y particularizando para tau=to se \
obtienen la velocidad y aceleraci\[OAcute]n para el instante i+1.
            
       vi+1=(1/(6\[CenterDot]to))\[CenterDot](11\[CenterDot]ui+1 - 18\
\[CenterDot]ui + 9\[CenterDot]ui-1 - 2\[CenterDot]ui-2)
       ai+1=(1/(to^2))\[CenterDot](2\[CenterDot]ui+1 - 5\[CenterDot]ui + 4\
\[CenterDot]ui-1 - ui-2)
                 
   Sustituyendo ambas en la ecuaci\[OAcute]n del movimiento 
                
        m\[CenterDot]ai+1 + c\[CenterDot]vi+1 + k\[CenterDot]ui+1=pi+1
                   
se obtiene el desplazamiento ui+1
                  
        ui+1=(pi+1 + a1\[CenterDot]ui  +b1\[CenterDot]ui-1 + \
c1\[CenterDot]ui-2)/k1 
                    
a1=5\[CenterDot]m/(to^2) + 3\[CenterDot]c/to
b1=(-4\[CenterDot]m/to^2) - 1.5\[CenterDot]c/to
c1=(m/to^2) + c/(3 to)
k1=k + 2\[CenterDot]m/to^2 + 11\[CenterDot]c/(6 to)
                      \
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Explicaci\[OAcute]n del programa", "Subtitle",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Vineta BT",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[1]],

Cell["\<\
Las variables que hay que introducir son las siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo.
u0=desplazamiento en el instante ti.
v0=desplazamiento en el instante ti.
k=rigidez.
m=masa.
c=coeficiente de amortiguamiento.
p=carga.Si la carga se da de forma discreta, hay que dar una lista \
{{t1,p1},{t2,p2},.....,{tn.pn}}, en la que cada pareja de valores es la carga \
 p ,  que hay en el instante  t .
El programa da una tabla con los valores del desplazamiento, velocidad y \
aceleraci\[OAcute]n,en cada instante de tiempo junto con su representaci\
\[OAcute]n gr\[AAcute]fica.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\

 C\[AAcute]lculo del n\[UAcute]mero de puntos en los que se va a obtener la \
respuesta\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["n=Floor[(tn-ti)/to+1.];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
 Como la soluci\[OAcute]n se va hallando paso a paso  para cada instante de \
tiempo, hemos de discretizar la carga \"p\",  para tener los valores de ella \
en cada instante en el que va a ser calculada la respuesta.
Cuando la carga venga dada como una funci\[OAcute]n contin\[UAcute]a,  la \
discretizaci\[OAcute]n consiste simplemente en evaluar la funci\[OAcute]n \
para los instantes de tiempo en que vamos a obtener la respuesta.
Si la carga es conocida de forma discreta, o sea , que conocemos la carga de \
forma exacta en unos instantes de tiempo determinados, construiremos una \
funci\[OAcute]n \"pa1\", que ser\[AAcute] la que discretizaremos.
El siguiente programa comprueba si la carga no es una funci\[OAcute]n \
continua, en cuyo caso antes de realizar la interpolaci\[OAcute]n, comprueba \
que la lista tenga valores de carga para instantes de tiempo superiores o \
iguales al instante en que se quiere obtener la respuesta.Si esto no es as\
\[IAcute], o sea se pide la respuesta en un instante \"tn\" que es superior \
al \[UAcute]ltimo instante de tiempo donde se conoce la carga, se supone que \
la carga ha dejado de actuar, y se le asigna el valor cero, para poder \
realizar as\[IAcute] la interpolaci\[OAcute]n.  \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
pa1=p;
If[Head[p]==List,pa2=p;nn=Length[pa2];
    If[pa2[[nn,1]]+to/1000<tn,
        AppendTo[pa2,{pa1[[nn,1]]+to/1000,0.}];
        AppendTo[pa2,{tn,0.}],
          If[tn>pa2[[nn,1]],AppendTo[pa2,{tn,0.}]]];
          pa1=Interpolation[pa2,InterpolationOrder->1]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Discretizaci\[OAcute]n de la carga.", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
pa=Table[0,{i,1,n}];
For[i=1,i<=n,i++,
     pa[[i]]=N[pa1[(ti+(i-1)to)]]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
 A trav\[EAcute]s de la ecuaci\[OAcute]n del movimiento se calcula la \
aceleraci\[OAcute]n para el instante inicial \"ti\".\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["a0=N[(pa[[1]]-c v0-k u0)/m];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se inicializan los vectores de desplazamiento  \"u\", velocidad  \"v\"  y \
aceleraci\[OAcute]n \"a\".\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
u=Table[u0,{i,1,n}];
v=Table[v0,{i,1,n}];
a=Table[a0,{i,1,n}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Mediante el m\[EAcute]todo de las diferencias centrales se calculan los \
desplazamientos
segundo y tercero, pues Houbolt necesita  los tres primeros desplazamientos.
Aplicando diferencias finitas hacia delante calculo los dos desplazamientos 
anteriores al inicial y la velocidad anterior a la inicial que son necesarias \
para
iniciar el m\[EAcute]todo de la sdiferencias centrales. \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
uo=N[u[[1]]-v0 to];(*desplaz.anterior al inicial*)
vo=N[(u[[1]]-uo)/to];(*veloc. anterior a la inicial*)
uoo=N[(uo-vo to)];(*desplaz.anterior a uo*)
u[[2]]=N[(pa[[1]]-(m/(to^2)-(c/(2 to)))uo-
        (k-2 m/(to^2)) u[[1]])/(m/(to^2)+c/(2 to))];
u[[3]]=N[(pa[[2]]-(m/(to^2)-(c/(2 to)))uo-
        (k-2 m/(to^2)) u[[2]])/(m/(to^2)+c/(2 to))];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Discretizaci\[OAcute]n del tiempo en los instantes en que quiero la \
respuesta.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["tm=Table[ti+(i-1) to,{i,n}];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["C\[AAcute]lculo de \"u\".", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
a1=N[5 m/(to^2)+3 c/to];
b1=N[(-4 m/to^2)-1.5 c/to];
c1=N[(m/to^2)+c/(3 to)];
k1=N[k+2 m/to^2+11 c/(6 to)];
    For[i=3,i<n,i++,  
        u[[i+1]]=N[(pa[[i+1]]+a1 u[[i]]+b1 u[[i-1]]+
                            c1 u[[i-2]])/k1]]; \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["C\[AAcute]lculo de  \"v\" .", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
v[[2]]=N[(1/(6 to))*(11 u[[2]]-18 u[[1]]+
                   9 uo-2 uo)];
v[[3]]=N[(1/(6 to))*(11 u[[3]]-18 u[[2]]+
                  9 u[[1]]-2 vo)]; 
   For[i=3,i<n,i++,  
        v[[i+1]]=N[(1/(6 to))*(11 u[[i+1]]-18 u[[i]]+
                  9 u[[i-1]]-2 u[[i-2]])]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["C\[AAcute]lculo de \"a\".", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
 For[i=1,i<n,i++,
        a[[i+1]]=N[(pa[[i+1]]-c v[[i+1]]-k u[[i+1]])/m]];   \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Para \"u\", \"v\"  y  \"a\", se construye una matriz en la que en la fila \"i\
\" aparece el instante de tiempo \"ti\" y la respuesta \"ui\",\"vi\" y \"ai\" \
respectivamente asociada a ese instante. \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Se representan gr\[AAcute]ficamente \"u\", \"v\"  y  \"a\".", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
gu=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
ga=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se realiza una tabla en la que para para cada instante de tiempo aparecen los \
valores de \"u\", \"v\" y \"a\" asociados a este instante.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"]; 
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
El programa anterior se introduce dentro de la orden Block quedando :\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["HouboltLineal", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
posicion;
velocidad;
aceleracion;
HouboltLineal[ti_,tn_,to_,u0_,v0_,k_,m_,c_,p_,posicion_,velocidad_,\
aceleracion_]:=
  Block[{n,pa2,pa1,pa,nn,i,a0,u,v,a,uo,
         vo,uoo,tm,a1,b1,c1,k1,gu,gv,ga},
(*Las variables que hay que introducir son las 
  siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo.
u0=desplazamiento en el instante ti.
v0=desplazamiento en el instante ti.
k=rigidez.
m=masa.
c=coeficiente de amortiguamiento.
p=carga.Si la carga se da de forma discreta, hay que 
dar una lista {{t1,p1},{t2,p2},.....,{tn.pn}}, en la 
que cada pareja de valores es la carga  p ,  que hay 
en el instante  t .
El programa da una tabla con los valores del 
desplazamiento, velocidad y aceleraci\[OAcute]n,en cada 
instante de tiempo junto con su representaci\[OAcute]n gr\[AAcute]fica.*)
n=Floor[(tn-ti)/to+1.];
pa1=p;
If[Head[p]==List,pa2=p;nn=Length[pa2];
    If[pa2[[nn,1]]+to/1000<tn,
        AppendTo[pa2,{pa1[[nn,1]]+to/1000,0.}];
        AppendTo[pa2,{tn,0.}],
          If[tn>pa2[[nn,1]],AppendTo[pa2,{tn,0.}]]];
          pa1=Interpolation[pa2,InterpolationOrder->1]];
pa=Table[0,{i,1,n}];
For[i=1,i<=n,i++,
     pa[[i]]=N[pa1[(ti+(i-1)to)]]];
a0=N[(pa[[1]]-c v0-k u0)/m];
u=Table[u0,{i,1,n}];
v=Table[v0,{i,1,n}];
a=Table[a0,{i,1,n}];
uo=N[u[[1]]-v0 to];
vo=N[(u[[1]]-uo)/to];
uoo=N[(uo-vo to)];
u[[2]]=N[(pa[[1]]-(m/(to^2)-(c/(2 to)))uo-
        (k-2 m/(to^2)) u[[1]])/(m/(to^2)+c/(2 to))];
u[[3]]=N[(pa[[2]]-(m/(to^2)-(c/(2 to)))uo-
        (k-2 m/(to^2)) u[[2]])/(m/(to^2)+c/(2 to))];
tm=Table[ti+(i-1) to,{i,n}];
a1=N[5 m/(to^2)+3 c/to];
b1=N[(-4 m/to^2)-1.5 c/to];
c1=N[(m/to^2)+c/(3 to)];
k1=N[k+2 m/to^2+11 c/(6 to)];
    For[i=3,i<n,i++,  
        u[[i+1]]=N[(pa[[i+1]]+a1 u[[i]]+b1 u[[i-1]]+
                            c1 u[[i-2]])/k1]]; 
v[[2]]=N[(1/(6 to))*(11 u[[2]]-18 u[[1]]+
                   9 uo-2 uoo)];
v[[3]]=N[(1/(6 to))*(11 u[[3]]-18 u[[2]]+
                  9 u[[1]]-2 uo)]; 
   For[i=3,i<n,i++,  
        v[[i+1]]=N[(1/(6 to))*(11 u[[i+1]]-18 u[[i]]+
                  9 u[[i-1]]-2 u[[i-2]])]];
   For[i=1,i<n,i++,
        a[[i+1]]=N[(pa[[i+1]]-c v[[i+1]]-k u[[i+1]])/m]];   
  For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];
posicion=u;
velocidad=v;
aceleracion=a;
gu=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
ga=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"];  
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Clear[\"Global`*\"]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO

a( t )  +25  u( t ) = 50 t
u( 0 ) = 0
v( 0 ) = 0

Hallar la respuesta hasta el instante tn=1 y con un incremento de tiempo \
to=0.1.
La soluci\[OAcute]n exacta es
 
u( t ) = 2\[CenterDot]t - 2\[CenterDot]Sin (5  t )/5\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Clear[\"Global`*\"]  ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["p[t_]:=50 t; ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
HouboltLineal[0,1,0.1,0,0,25,1,0,p, posicion,velocidad,aceleracion] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Representaci\[OAcute]n de la soluci\[OAcute]n exacta ( negra ),
con la aproximada ( roja ).\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
exacta=Plot[2 t-2 Sin[5 t]/5,{t,0,1},
              DisplayFunction->Identity]; \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Show[gu,exacta];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO

Veamos el mismo caso con un incremento de tiempo m\[AAcute]s
peque\[NTilde]o, to=0.05, para comprobar que se acerca m\[AAcute]s a la 
soluci\[OAcute]n exacta.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
HouboltLineal[0,1,0.05,0,0,25,1,0,p,posicion,velocidad,aceleracion] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Show[gu,exacta]; ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO
0.2533 a( t )  + 0.1592 v( t ) + 10  u( t ) = p( t )
u( 0 ) = 0
v( 0 ) = 0

Hallar la respuesta hasta el instante tn=1 y con un incremento de tiempo
to=0.1, siendo p( t ) la carga dada en forma discreta siguiente:\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
p={{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
    {.7,0},{.8,0},{.9,0},{1,0}}; \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
HouboltLineal[0,1,.1,0,0,10,.2533,.1592,p,posicion,velocidad,aceleracion] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO:

0.2533\[CenterDot]a( t ) +0.1589\[CenterDot] v( t ) +10\[CenterDot] u( t ) = \
p( t )  
u( 0 )=0
v( 0 )=0
p( t ) = {{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
              {.7,0},{.8,0},{.9,0},{1,0}}

queremos la respuesta hasta el instante tn=1, con un incremento de tiempo de \
to=0.1.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
Este es un caso donde la carga me la dan discretizada,y as\[IAcute] conocemos \
la carga para unos instantes determinados de tiempo.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
p={{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
    {.7,0},{.8,0},{.9,0},{1,0}};    \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
HouboltLineal[0,1,.1,0,0,10,0.2533,0.1589,p,posicion,velocidad,aceleracion] \
\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\

La soluci\[OAcute]n exacta del desplazamiento es:

uexac = { 0.,0.0328,0.2332,0.6487,1.1605,1.5241,1.4814,
       0.9245,0.0593,-0.7751,-1.2718 }; 

La representaci\[OAcute]n de ambas funciones se muestra a \
continuaci\[OAcute]n.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
uexac = { 0.,0.0328,0.2332,0.6487,1.1605,1.5241,1.4814, 
           0.9245,0.0593,-0.7751,-1.2718 };    \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
For[i=1,i<=n,i++,
       uexac[[i]]={tm[[i]],Chop[uexac[[i]]]}];     \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
guexac=Graphics[ListPlot[ Table[uexac[[i]],{i,n}],                 
           PlotJoined->True, 
           DisplayFunction->Identity,
           AxesLabel->{t,\"p\"}]];    \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Show[gu,guexac];     ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
La soluci\[OAcute]n aproximada no es muy buena, pero si hacemos el incremento \
de tiempo m\[AAcute]s peque\[NTilde]o coseguiremos una mejor aproximaci\
\[OAcute]n.Tomamos ahora to=0.01.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["\<\
HouboltLineal[0,1,0.01,0,0,10,0.2533,0.1589,p,posicion,velocidad,aceleracion] \
\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Show[gu,guexac];     ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{915, 651},
WindowMargins->{{-2, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 247, 7, 116, "Title"],
Cell[1967, 58, 1581, 39, 576, "Subsection"],
Cell[3551, 99, 220, 6, 85, "Subtitle"],
Cell[3774, 107, 765, 20, 239, "Text"],
Cell[4542, 129, 245, 8, 68, "Text"],
Cell[4790, 139, 153, 4, 46, "Input"],
Cell[4946, 145, 1393, 22, 201, "Text"],
Cell[6342, 169, 403, 12, 154, "Input"],
Cell[6748, 183, 184, 4, 49, "Text"],
Cell[6935, 189, 212, 8, 82, "Input"],
Cell[7150, 199, 281, 7, 49, "Text"],
Cell[7434, 208, 158, 4, 46, "Input"],
Cell[7595, 214, 259, 7, 49, "Text"],
Cell[7857, 223, 200, 8, 82, "Input"],
Cell[8060, 233, 542, 12, 125, "Text"],
Cell[8605, 247, 478, 12, 154, "Input"],
Cell[9086, 261, 237, 7, 49, "Text"],
Cell[9326, 270, 158, 4, 46, "Input"],
Cell[9487, 276, 174, 4, 49, "Text"],
Cell[9664, 282, 369, 12, 154, "Input"],
Cell[10036, 296, 176, 4, 49, "Text"],
Cell[10215, 302, 409, 12, 154, "Input"],
Cell[10627, 316, 174, 4, 49, "Text"],
Cell[10804, 322, 216, 7, 64, "Input"],
Cell[11023, 331, 357, 8, 49, "Text"],
Cell[11383, 341, 270, 9, 100, "Input"],
Cell[11656, 352, 208, 4, 49, "Text"],
Cell[11867, 358, 653, 17, 244, "Input"],
Cell[12523, 377, 295, 7, 49, "Text"],
Cell[12821, 386, 399, 11, 136, "Input"],
Cell[13223, 399, 226, 6, 49, "Text"],
Cell[13452, 407, 116, 3, 121, "Title"],
Cell[13571, 412, 3231, 93, 1594, "Input"],
Cell[16805, 507, 149, 4, 46, "Input"],
Cell[16957, 513, 317, 14, 234, "Subsection"],
Cell[17277, 529, 151, 4, 46, "Input"],
Cell[17431, 535, 143, 4, 46, "Input"],
Cell[17577, 541, 206, 6, 46, "Input"],
Cell[17786, 549, 182, 5, 82, "Subsection"],
Cell[17971, 556, 218, 7, 64, "Input"],
Cell[18192, 565, 146, 4, 46, "Input"],
Cell[18341, 571, 258, 8, 139, "Subsection"],
Cell[18602, 581, 206, 6, 46, "Input"],
Cell[18811, 589, 147, 4, 46, "Input"],
Cell[18961, 595, 312, 10, 177, "Subsection"],
Cell[19276, 607, 230, 7, 64, "Input"],
Cell[19509, 616, 212, 6, 46, "Input"],
Cell[19724, 624, 402, 14, 215, "Subsection"],
Cell[20129, 640, 223, 5, 63, "Subsection"],
Cell[20355, 647, 233, 7, 64, "Input"],
Cell[20591, 656, 216, 7, 46, "Input"],
Cell[20810, 665, 322, 11, 177, "Subsection"],
Cell[21135, 678, 242, 7, 64, "Input"],
Cell[21380, 687, 207, 7, 64, "Input"],
Cell[21590, 696, 312, 9, 100, "Input"],
Cell[21905, 707, 151, 4, 46, "Input"],
Cell[22059, 713, 277, 6, 82, "Subsection"],

Cell[CellGroupData[{
Cell[22361, 723, 218, 7, 46, "Input"],
Cell[22582, 732, 151, 4, 46, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

