(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    340598,       9353]*)
(*NotebookOutlinePosition[    341463,       9383]*)
(*  CellTagsIndexPosition[    341419,       9379]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["M\[CapitalEAcute]TODO DE HILBERG, HUGHES Y TAYLOR NO LINEAL", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Vineta BT",
  FontSize->28,
  FontWeight->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[TextData[{
  Cell[BoxData[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["Este",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["problema",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["esta",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["basado",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["en",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["el",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["m\[EAcute]todo",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["de",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[\(NEWMARK . \ El\),
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["problema",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["parte",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["de",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["las",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["siguientes",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            RowBox[{
              StyleBox["ecuaciones",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox[":",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox["\[IndentingNewLine]",
                "Text"], 
              StyleBox["\[IndentingNewLine]",
                "Text"], 
              StyleBox[\(vi + 1\),
                "Text"]}]}], 
          StyleBox["=",
            "Text"], 
          
          StyleBox[\(\((\[Gamma]\/\(\[CapitalDelta]t*\[Beta]\))\)*\((ui + 1 - 
                    ui)\) + \
\[Gamma]*\[CapitalDelta]t*\((\((1\/\[CapitalDelta]t)\)*\((1\/\[Gamma] - 
                          1\/\[Beta])\)*
                      vi + \((1\/\[Gamma] - 1\/\(2*\[Beta]\))\)*ai)\)\),
            "Text"]}], 
        StyleBox[";",
          "Text"]}], "\n", 
      StyleBox[\(ai + 
              1 = \((1\/\(\[CapitalDelta]t\^2*\[Beta]\))\)*\((ui + 1 - 
                    ui)\) + \((\(-1\)\/\(\[CapitalDelta]t*\[Beta]\))\)*
                vi + \((1 - 1\/\(2*\[Beta]\))\)*ai;\),
        "Text"], "\n", 
      RowBox[{
        StyleBox[
          StyleBox[
            RowBox[{
              StyleBox["         ",
                "Text"], "\t"}]],
          "Text"], 
        RowBox[{
          
          StyleBox[\(Como\ se\ sabe\ estas\ dos\ ecuaciones\ se\ cumplen\ \
siempre\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[",",
            FontColor->RGBColor[0, 0, 1]], 
          RowBox[{
            StyleBox["ya",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["que",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["han",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["sido",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["obtenidas",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["mediante",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            RowBox[{
              StyleBox["integracion",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox[".",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox["\[IndentingNewLine]",
                "Text",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox["Para",
                FontColor->RGBColor[0, 0, 1]]}], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["resolver",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["el",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["problema",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["nos",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["hace",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["falta",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["otra",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["ecuacion",
              FontColor->RGBColor[0, 0, 1]]}], 
          StyleBox[",",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[" ",
            FontColor->RGBColor[0, 0, 1]], 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["que",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox[" ",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["sera",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox[" ",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["la",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox[" ",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["de",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox[" ",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["equilibrio",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox[" ",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["dinamico",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox[" ",
                  FontColor->RGBColor[0, 0, 1]], 
                RowBox[{
                  StyleBox["modificada",
                    FontColor->RGBColor[0, 0, 1]], 
                  StyleBox[":",
                    FontColor->RGBColor[0, 0, 1]], 
                  StyleBox["\[IndentingNewLine]",
                    "Text"], 
                  
                  StyleBox[\(m*\((ai + 1)\) + 
                      c*\((vi + 1)\) + \((1 + \[Alpha])\)*
                        k*\((ui + 1)\) - \[Alpha]*k*ui\),
                    "Text"]}]}], 
              StyleBox["=",
                "Text"], 
              StyleBox[\(pi + 1\),
                "Text"]}], 
            StyleBox[";",
              "Text"]}]}], 
        StyleBox["\[IndentingNewLine]",
          "Text"]}], "\n", 
      RowBox[{
        StyleBox["         ",
          "Text"], 
        StyleBox[\(\((m\/\(\[CapitalDelta]t\^2*\[Beta]\) + \(c*\[Gamma]\)\/\(\
\[CapitalDelta]t*\[Beta]\) + \((1 + \[Alpha])\)*k)\)*ui + 
                1 = \((pi + 
                    1)\) + \((m\/\(\[CapitalDelta]t\^2*\[Beta]\) + \(c*\
\[Gamma]\)\/\(\[CapitalDelta]t*\[Beta]\) + \[Alpha]*k)\) 
                  ui + \((m\/\(\[CapitalDelta]t*\[Beta]\) + 
                      c*\((\[Gamma]\/\[Beta] - 1)\))\)*
                  vi + \ \((m*\((1\/\(2*\[Beta]\) - 1)\) 
                      c*\[CapitalDelta]t*\((\[Gamma]\/\(2*\[Beta]\) - 1)\))\) 
                  ai;\),
          "Text"]}]}]],
  "\n\n",
  StyleBox["La diferencia con el m\[EAcute]todo lineal es que en el \
c\[AAcute]lculo de cada paso hay que calcular la rigidez. \nAdem\[AAcute]s \
para minimizar el error se realizan iteraciones para pasar de ui a ui+1, \
hasta alcanzar una cierta tolerancia.\nSe ha utilizado el m\[EAcute]todo de \
Newton-Raphson, que consiste en calcular la rigidez, en cada una de las \
iteraciones para el paso de ui a ui+1.  Este programa s\[OAcute]lo considera \
el caso de un material elastopl\[AAcute]stico perfecto.",
    FontColor->RGBColor[0, 0, 1]]
}], "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["HilbergNoLineal", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell[TextData[{
  "Clear[\"Global`*\"];\nposicion;\nvelocidad;\naceleracion;\n\
HilbergNoLineal[ti_,tn_,to_,u0_,v0_,k_,m_,c_,p_,\n        \
g_,b_,al_,fc_,ft_,posicion_,velocidad_,aceleracion_]:=\n  \
Block[{n,pa1,pa2,nn,pa,i,tm,u,v,a,\n         \
a0,k2,fs,p1,k1,tol,k1t,kt,uu,fss, \n         incrRR,incruu,z,j,l,s,gu,gv,ga},\
\n\n",
  StyleBox["(* Todo el algoritmo ha sido introducido en una funcion Block \
para que su \nejecucion sea solo darle valores a la funcion.\n        \n  \
Variables del modelo:\n        ti=instante inicial;\n\t\ttn=tiempo hasta el \
que se desea conocer la respuesta;\n\t\tto=incremento de tiempo;\n\t\t\
tfc=tiempo en que finaliza la carga;\n\t\tu0=posicion inicial;\n\t\t\
v0=velocidad inicial;\n\t\tk=rigidez del tramo el\[AAcute]stico;\n\t\tm= masa \
en kg;\n\t\tc=amortiguamiento;\t\n\t\t\[Beta]=0.25;\n\t\t\[Gamma]=0.5;\n\t\t\
\[Alpha]=valor comprendido entre -0.333333333 y 0;\n\t\tp=carga.Si la carga \
se da de forma discreta, hay que dar \nuna lista \
{{t1,p1},{t2,p2},.....,{tn.pn}}, en la que cada \npareja de valores es la \
carga  p ,  que hay en el instante t.\nfc=valor que provoca la plastificaci\
\[OAcute]n a compresi\[OAcute]n.\nft=valor que provoca la plastificaci\
\[OAcute]n a tracci\[OAcute]n.\nEl programa da una tabla con los valores del \
desplazamiento, \nvelocidad y aceleraci\[OAcute]n,en cada instante de tiempo \
junto con \nsu representaci\[OAcute]n gr\[AAcute]fica.*)\n\n\n(*",
    FontColor->RGBColor[0, 0, 1]],
  " ",
  StyleBox["C\[AAcute]lculo del n\[UAcute]mero de puntos en los que se va a \
obtener la respuesta *)\n",
    FontColor->RGBColor[0, 0, 1]],
  "\nn=Floor[(tn-ti)/to+1.];\n\n\n",
  StyleBox["(* Como la soluci\[OAcute]n se va hallando paso a paso para cada \
instante de tiempo, \nhemos de discretizar la carga \"p\", para tener los \
valores de ella en cada \ninstante en el que va a ser calculada la respuesta.\
\nCuando la carga venga dada como una funci\[OAcute]n contin\[UAcute]a, la \
discretizaci\[OAcute]n \nconsiste simplemente en evaluar la funci\[OAcute]n \
para los instantes de tiempo \nen que vamos a obtener la respuesta.\nSi la \
carga es conocida de forma discreta, o sea, que conocemos la carga \nde forma \
exacta en unos instantes de tiempo determinados, construiremos \nuna funci\
\[OAcute]n \"pa1\", que ser\[AAcute] la que discretizaremos.\nEl siguiente \
programa comprueba si la carga no es una funci\[OAcute]n continua, \nen cuyo \
caso antes de realizar la interpolaci\[OAcute]n, comprueba que la lista \n\
tenga valores de carga para instantes de tiempo superiores o iguales \nal \
instante en que se quiere obtener la respuesta. Si esto no es as\[IAcute], \n\
o sea se pide la respuesta en un instante \"tn\" que es superior al \
\[UAcute]ltimo instante \nde tiempo donde se conoce la carga, se supone que \
la carga ha dejado de actuar, \ny se le asigna el valor cero, para poder \
realizar as\[IAcute] la interpolaci\[OAcute]n.  *)",
    FontColor->RGBColor[0, 0, 1]],
  "\n\npa1=p;\nIf[Head[p]==List,pa2=p;nn=Length[pa2];\n    \
If[pa2[[nn,1]]+to/1000<tn,\n        AppendTo[pa2,{pa1[[nn,1]]+to/1000,0.}];\n \
       AppendTo[pa2,{tn,0.}],\n          \
If[tn>pa2[[nn,1]],AppendTo[pa2,{tn,0.}]]];\n          \
pa1=Interpolation[pa2,InterpolationOrder->1]];\npa=Table[0,{i,1,n}];\n\
For[i=1,i<=n,i++,pa[[i]]=N[pa1[(ti+(i-1)to)]]];\n\n\n",
  StyleBox["(* Se inicializan los vectores de tiempo \"tm\", desplazamiento \
\"u\", \nvelocidad \"v\" y aceleraci\[OAcute]n \"a\". *)",
    FontColor->RGBColor[0, 0, 1]],
  "\n\ntm=Table[ti+(i-1) to,{i,n}];\nu=Table[0.,{i,1,n}];\n\
v=Table[0.,{i,1,n}];\na=Table[0.,{i,1,n}];\na0=(pa[[1]]-c*v0-k*u0)/m;\n\
u[[1]]=u0;\nv[[1]]=v0;\na[[1]]=a0;\n\n\n",
  StyleBox["(* Para cada paso hay que calcular la rigidez. \nAqu\[IAcute] se \
inicializan los datos que necesitar\[AAcute] el \"While\",\nque es donde se \
realiza el c\[AAcute]lculo del incremento de desplazamiento. *)",
    FontColor->RGBColor[0, 0, 1]],
  "\n\nk2=k;\nfs=k2*u[[1]];\n\nFor[i=1,i<n,i++,\n      \
p1=pa[[i+1]]-pa[[i]]+(m/(b*to)+c*g/b)*v[[i]]\n  \
+(m/(2*b)+c*to*(g/(2*b)-1))*a[[i]];\n      \
k1=(1+al)*k2+g*c/(b*to)+m/(b*(to^2));\n      tol=.00005;\n      k1t=k1;\n     \
 kt=k2;\n      uu={u[[i]]};\n      fss={fs,0};\n      incrRR={p1};\n      \
incruu={incrRR[[1]]/k1t};\n      uu={u[[i]],u[[i]]+p1/k1t};\n      \
If[Abs[uu[[2]]]-Abs[uu[[1]]]>0,\n           If[fc<fss[[1]]<ft,\n              \
  fss[[2]]=fss[[1]]+k*(uu[[2]]-uu[[1]]);\n                If[fc<fss[[2]]<ft,\n\
                     kt=k,\n                     \
If[fss[[2]]>0,fss[[2]]=ft,fss[[2]]=fc];\n                     kt=0\n          \
        ],\n                If[fss[[2]]>0,fss[[2]]=ft,fss[[2]]=fc];\n         \
       kt=0\n             ],\n           \
fss[[2]]=fss[[1]]+k*(uu[[2]]-uu[[1]]);\n           If[fc<fss[[1]]<ft,\n       \
         kt=k,\n                If[fss[[2]]>0,fss[[2]]=ft,fss[[2]]=fc];\n     \
           kt=0\n             ]\n        ];\n      fss={fss[[1]],fss[[2]]};\n \
     incrff={fss[[2]]-fss[[1]]+(al*k2+m/(b*(to^2))+c*g/(to*b))*incruu[[1]]};\n\
      incrRR={p1,p1-incrff[[1]]};\n      \n      \n",
  StyleBox["(* Para pasar del paso ui al ui+1 se realizan iteraciones hasta \
que el incremento \nde desplazamiento \"incruu\"  conseguido en esa iteraci\
\[OAcute]n  respecto al incremento de \ndesplazamiento total \"s\" obtetido \
hasta esa iteraci\[OAcute]n sea menor que la tolerancia.\nLos \"If\" van \
comprobando si estamos en rango el\[AAcute]stico o pl\[AAcute]stico, para \
asignar en \ncada caso la rigidez correspondiente (aplicaci\[OAcute]n del m\
\[EAcute]todo de Newton-Raphson). *)",
    FontColor->RGBColor[0, 0, 1]],
  "\n      \n      z=2*tol;\n      j=2;\n      While[z>tol,\n             \
incruu[[j-1]]=incrRR[[j-1]]/k1t;\n             \
uu[[j]]=uu[[j-1]]+incruu[[j-1]];\n             \
If[Abs[uu[[j]]]-Abs[uu[[j-1]]]>0,\n                  If[fc<fss[[j-1]]<ft,\n   \
                    fss[[j]]=fss[[j-1]]+k*(uu[[j]]-uu[[j-1]]);\n              \
         If[fc<fss[[j]]<ft,\n                            kt=k,\n              \
              If[fss[[j]]>0,fss[[j]]=ft,fss[[j]]=fc];\n                       \
     kt=0\n                         ],\n                       \
If[fss[[j-1]]>0,fss[[j-1]]=ft,fss[[j-1]]=fc];\n                       kt=0;\n \
                      fss[[j]]=fss[[j-1]]\n                    ],\n           \
       fss[[j]]=fss[[j-1]]+k*(uu[[j]]-uu[[j-1]]);\n                  \
If[fc<fss[[j]]<ft,\n                       kt=k,\n                       \
If[fss[[j]]>0,fss[[j]]=ft,fss[[j]]=fc];\n                       kt=0\n        \
            ]\n               ];\n             \
incrff[[j-1]]=fss[[j]]-fss[[j-1]]+\n         \
(al*k2+m/(b*(to^2))+c*g/(to*b))*incruu[[j-1]];\n             \
incrRR[[j]]=incrRR[[j-1]]-incrff[[j-1]];\n             l=Length[incruu];\n    \
         s=Sum[incruu[[i]],{i,1,l}];\n             z=Abs[incruu[[l]]/s];\n    \
         AppendTo[incruu,0];\n             AppendTo[incrRR,0];\n             \
AppendTo[incrff,0];\n             AppendTo[uu,0];\n             \
AppendTo[fss,0];\n             j=j+1\n        ];\n        \n        \n",
  StyleBox["(* Una vez alcanzada la tolerancia se halla el desplazamiento y \
velocidad. *)",
    FontColor->RGBColor[0, 0, 1]],
  "\n        \n      u[[i+1]]=u[[i]]+s;\n      \
v[[i+1]]=N[g*s/(b*to)+(1-g/b)*v[[i]]+(1-g/(2*b))*to*a[[i]]];\n   \n      \n",
  StyleBox["(* Se comprueba si estamos en rango el\[AAcute]stico o \
pl\[AAcute]stico para asignar la rigidez \ncorrespondiente, y aplicar la \
ecuaci\[OAcute]n del movimiento para hallar la aceleraci\[OAcute]n. *)",
    FontColor->RGBColor[0, 0, 1]],
  "\n      \n      fs=fs+k*(u[[i+1]]-u[[i]]);\n      If[fc<fs<ft,\n           \
k2=k,\n           If[fs>0,fs=ft,fs=fc];\n           k2=0\n        ];\n      \
a[[i+1]]=N[(pa[[i+1]]-c*v[[i+1]]-fs)/m];\n             Print[\"i = \",i,\"    \
 j = \",j-1,\"      kt = \",kt,\"      fs = \",fs];\n   ];\n\n\n",
  StyleBox["(* Para \"p\", \"u\", \"v\" y \"a\", se construye una matriz en \
la que en la fila \"i\" aparece \nel instante de tiempo \"ti\" y la respuesta \
\"pai\", \"ui\",\"vi\" y \"ai\" respectivamente \nasociada a ese instante. \
*)",
    FontColor->RGBColor[0, 0, 1]],
  "\n\nFor[i=1,i<=n,i++,\n       pa[[i]]={tm[[i]],Chop[pa[[i]]]};\n       \
u[[i]]={tm[[i]],Chop[u[[i]]]};\n       v[[i]]={tm[[i]],Chop[v[[i]]]};\n       \
a[[i]]={tm[[i]],Chop[a[[i]]]}];\nposicion=u;\nvelocidad=v;\naceleracion=a;\n\n\
\n",
  StyleBox["(* Se representan gr\[AAcute]ficamente \"p\", \"u\", \"v\"  y  \
\"a\". *)",
    FontColor->RGBColor[0, 0, 1]],
  "\n\ngp=ListPlot[ Table[pa[[i]],{i,n}],                 \n           \
PlotStyle->{PointSize[0.023],RGBColor[0,1,0]},\n           PlotJoined->True,\n\
           AxesLabel->{t,\"p\"}];\ngu=ListPlot[ Table[u[[i]],{i,n}],          \
       \n           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},\n          \
 PlotJoined->True,\n           AxesLabel->{t,\"u\"}];\ngv=ListPlot[ \
Table[v[[i]],{i,n}],                 \n           \
PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},\n           PlotJoined->True,\n\
           AxesLabel->{t,\"v\"}];\nga=ListPlot[ Table[a[[i]],{i,n}],          \
       \n           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},\n          \
 PlotJoined->True,\n           AxesLabel->{t,\"a\"}];\n\n\n",
  StyleBox["(* Se realiza una tabla en la que para para cada instante de \
tiempo \naparecen los valores de \"p\", \"u\", \"v\" y \"a\" asociados a este \
instante. *)",
    FontColor->RGBColor[0, 0, 1]],
  "\n\nPrint[\"t\" ,  \"         \", \"p         \",\"u\" ,\n\"          v\",\
\"\", \"         a\"]; \n\
Print[\"----------------------------------------------------\"];\n\
Print[TableForm[tm],\"     \",TableForm[Transpose[pa][[2]]],\n\
TableForm[Transpose[u][[2]]],\"   \",TableForm[Transpose[v][[2]]],\"  \",\n\
TableForm[Transpose[a][[2]]]]]"
}], "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[BoxData[""], "Input"],

Cell["\<\
EJEMPLO
0.2 a( t )  + 0.274 v( t ) + fs ( u,v ) = p( t )
u( 0 ) = 0
v( 0 ) = 0

Hallar la respuesta hasta el instante tn=2 y con un incremento de tiempo
to=0.1,para el m\[EAcute]todo de la aceleraci\[OAcute]n lineal, siendo p( t ) \
la carga dada en forma discreta siguiente:

p={{0,0},{.45,20},{1.1,0},{1.2,-10},{1.4,0}};

y siendo el material elastopl\[AAcute]stico perfecto, en el que la \
plastificaci\[OAcute]n a tracci\[OAcute]n se alcanza paran un valor de ft = \
15, y a compresi\[OAcute]n para fc = -15, y la rigidez el\[AAcute]stica es \
12.35. \
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["\<\
p={{0,0},{.45,20},{1.1,0},{1.2,-10},{1.4,0}};
HilbergNoLineal[0,2,.1,0,0,12.35,.2,.274,p,  
       0.5,0.1666666667,-0.1,-15,15,posicion,velocidad,aceleracion]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]1\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0.3939346818745536`\),
      SequenceForm[ 
      "i = ", 1, "     j = ", 3, "      kt = ", 12.35, 
        "      fs = ", .3939346818745536],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]2\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]2.905734145310178`\),
      SequenceForm[ 
      "i = ", 2, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        2.9057341453101779],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]3\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]8.36834645814292`\),
      SequenceForm[ 
      "i = ", 3, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        8.3683464581429199],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]4\[InvisibleSpace]"     j = "\
\[InvisibleSpace]6\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]15\),
      SequenceForm[ 
      "i = ", 4, "     j = ", 6, "      kt = ", 0, "      fs = ", 15],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]5\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]15\),
      SequenceForm[ 
      "i = ", 5, "     j = ", 3, "      kt = ", 0, "      fs = ", 15],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]6\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]15\),
      SequenceForm[ 
      "i = ", 6, "     j = ", 3, "      kt = ", 0, "      fs = ", 15],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]7\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]15\),
      SequenceForm[ 
      "i = ", 7, "     j = ", 3, "      kt = ", 0, "      fs = ", 15],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]8\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]15\),
      SequenceForm[ 
      "i = ", 8, "     j = ", 3, "      kt = ", 0, "      fs = ", 15],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]9\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]15\),
      SequenceForm[ 
      "i = ", 9, "     j = ", 3, "      kt = ", 0, "      fs = ", 15],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]10\[InvisibleSpace]"     j = "\
\[InvisibleSpace]7\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]11.615607127946838`\),
      SequenceForm[ 
      "i = ", 10, "     j = ", 7, "      kt = ", 12.35, "      fs = ", 
        11.615607127946838],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]11\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]4.059569939504972`\),
      SequenceForm[ 
      "i = ", 11, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        4.0595699395049722],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]12\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]\(-5.573825967702455`\)\),
      SequenceForm[ 
      "i = ", 12, "     j = ", 3, "      kt = ", 12.35, 
        "      fs = ", -5.5738259677024553],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]13\[InvisibleSpace]"     j = "\
\[InvisibleSpace]5\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]\(-15\)\),
      SequenceForm[ 
      "i = ", 13, "     j = ", 5, "      kt = ", 0, "      fs = ", -15],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]14\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]\(-15\)\),
      SequenceForm[ 
      "i = ", 14, "     j = ", 3, "      kt = ", 0, "      fs = ", -15],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]15\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]\(-10.177087980830738`\)\),
      SequenceForm[ 
      "i = ", 15, "     j = ", 3, "      kt = ", 0, 
        "      fs = ", -10.177087980830738],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]16\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0.35749523354695434`\),
      SequenceForm[ 
      "i = ", 16, "     j = ", 3, "      kt = ", 12.35, 
        "      fs = ", .35749523354695434],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]17\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]9.732717817490997`\),
      SequenceForm[ 
      "i = ", 17, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        9.7327178174909967],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]18\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]13.069393229070496`\),
      SequenceForm[ 
      "i = ", 18, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        13.069393229070496],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]19\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]9.14861807889255`\),
      SequenceForm[ 
      "i = ", 19, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        9.1486180788925502],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]20\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0.7232328858483221`\),
      SequenceForm[ 
      "i = ", 20, "     j = ", 3, "      kt = ", 12.35, 
        "      fs = ", .72323288584832213],
      Editable->False]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.221522 0.0206807 [
[.2619 .20902 -9 -9 ]
[.2619 .20902 9 0 ]
[.5 .20902 -3 -9 ]
[.5 .20902 3 0 ]
[.7381 .20902 -9 -9 ]
[.7381 .20902 9 0 ]
[.97619 .20902 -3 -9 ]
[.97619 .20902 3 0 ]
[1.025 .22152 0 -6.25 ]
[1.025 .22152 10 6.25 ]
[.01131 .01472 -18 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .11812 -12 -4.5 ]
[.01131 .11812 0 4.5 ]
[.01131 .32493 -6 -4.5 ]
[.01131 .32493 0 4.5 ]
[.01131 .42833 -12 -4.5 ]
[.01131 .42833 0 4.5 ]
[.01131 .53173 -12 -4.5 ]
[.01131 .53173 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .22152 m
.2619 .22777 L
s
[(0.5)] .2619 .20902 0 1 Mshowa
.5 .22152 m
.5 .22777 L
s
[(1)] .5 .20902 0 1 Mshowa
.7381 .22152 m
.7381 .22777 L
s
[(1.5)] .7381 .20902 0 1 Mshowa
.97619 .22152 m
.97619 .22777 L
s
[(2)] .97619 .20902 0 1 Mshowa
.125 Mabswid
.07143 .22152 m
.07143 .22527 L
s
.11905 .22152 m
.11905 .22527 L
s
.16667 .22152 m
.16667 .22527 L
s
.21429 .22152 m
.21429 .22527 L
s
.30952 .22152 m
.30952 .22527 L
s
.35714 .22152 m
.35714 .22527 L
s
.40476 .22152 m
.40476 .22527 L
s
.45238 .22152 m
.45238 .22527 L
s
.54762 .22152 m
.54762 .22527 L
s
.59524 .22152 m
.59524 .22527 L
s
.64286 .22152 m
.64286 .22527 L
s
.69048 .22152 m
.69048 .22527 L
s
.78571 .22152 m
.78571 .22527 L
s
.83333 .22152 m
.83333 .22527 L
s
.88095 .22152 m
.88095 .22527 L
s
.92857 .22152 m
.92857 .22527 L
s
.25 Mabswid
0 .22152 m
1 .22152 L
s
gsave
1.025 .22152 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .01472 m
.03006 .01472 L
s
[(-10)] .01131 .01472 1 0 Mshowa
.02381 .11812 m
.03006 .11812 L
s
[(-5)] .01131 .11812 1 0 Mshowa
.02381 .32493 m
.03006 .32493 L
s
[(5)] .01131 .32493 1 0 Mshowa
.02381 .42833 m
.03006 .42833 L
s
[(10)] .01131 .42833 1 0 Mshowa
.02381 .53173 m
.03006 .53173 L
s
[(15)] .01131 .53173 1 0 Mshowa
.125 Mabswid
.02381 .0354 m
.02756 .0354 L
s
.02381 .05608 m
.02756 .05608 L
s
.02381 .07676 m
.02756 .07676 L
s
.02381 .09744 m
.02756 .09744 L
s
.02381 .1388 m
.02756 .1388 L
s
.02381 .15948 m
.02756 .15948 L
s
.02381 .18016 m
.02756 .18016 L
s
.02381 .20084 m
.02756 .20084 L
s
.02381 .2422 m
.02756 .2422 L
s
.02381 .26288 m
.02756 .26288 L
s
.02381 .28356 m
.02756 .28356 L
s
.02381 .30424 m
.02756 .30424 L
s
.02381 .34561 m
.02756 .34561 L
s
.02381 .36629 m
.02756 .36629 L
s
.02381 .38697 m
.02756 .38697 L
s
.02381 .40765 m
.02756 .40765 L
s
.02381 .44901 m
.02756 .44901 L
s
.02381 .46969 m
.02756 .46969 L
s
.02381 .49037 m
.02756 .49037 L
s
.02381 .51105 m
.02756 .51105 L
s
.02381 .55241 m
.02756 .55241 L
s
.02381 .57309 m
.02756 .57309 L
s
.02381 .59377 m
.02756 .59377 L
s
.02381 .61445 m
.02756 .61445 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 0 r
.5 Mabswid
.02381 .22152 m
.07143 .31344 L
.11905 .40535 L
.16667 .49726 L
.21429 .58918 L
.2619 .60332 L
.30952 .53969 L
.35714 .47605 L
.40476 .41242 L
.45238 .34879 L
.5 .28515 L
.54762 .22152 L
.59524 .01472 L
.64286 .11812 L
.69048 .22152 L
.7381 .22152 L
.78571 .22152 L
.83333 .22152 L
.88095 .22152 L
.92857 .22152 L
.97619 .22152 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00O5Goo00<007ooOol0
ogoo2Goo000EOol00`00Oomoo`3oOol9Ool000Moo`D0009oo`8000Eoo`03001oogoo0?moo`Uoo`00
2Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo0?moo`Uoo`002Goo00D007ooOomo
o`00009oo`03001oogoo009oo`<008moo`030n1oogoo07Ioo`0000=oo`0000000P0017oo00D007oo
Oomoo`00009oo`03001oogoo009oo`03001oogoo08moo`030n1oogoo07Ioo`002Goo00D007ooOomo
o`00009oo`03001oogoo009oo`03001oogoo08moo`83h7Moo`0027oo0P0017oo0P001Goo00<007oo
Ool0SWoo00<3h7oo0n00Mgoo000EOol00`00Oomoo`2>Ool010?POomoo`?PMWoo000EOol2002?Ool0
10?POomoo`?PMWoo000EOol00`00Oomoo`2>Ool01@?POomoogoo0n00MGoo000EOol00`00Oomoo`2=
Ool00`?POomoo`02Ool00`?POomoo`1cOol001Eoo`03001oogoo08eoo`030n1oogoo00=oo`030n1o
ogoo079oo`005Goo00<007ooOol0SGoo00<3h7ooOol00goo00<3h7ooOol0LWoo000EOol00`00Oomo
o`2=Ool00`?POomoo`04Ool00`?POomoo`1aOol001Eoo`8008ioo`030n1oogoo00Aoo`030n1oogoo
075oo`005Goo00<007ooOol0S7oo00<3h7ooOol01Woo00<3h7ooOol0L7oo000EOol00`00Oomoo`2<
Ool00`?POomoo`06Ool00`?POomoo`1`Ool001Eoo`03001oogoo08aoo`030n1oogoo00Ioo`030n1o
ogoo071oo`005Goo00<007ooOol0S7oo00<3h7ooOol01goo00<3h7ooOol0Kgoo000EOol2002<Ool0
0`?POomoo`08Ool00`?POomoo`1_Ool001Eoo`03001oogoo08]oo`030n1oogoo00Uoo`030n1oogoo
06ioo`005Goo00<007ooOol0Rgoo00<3h7ooOol02Goo00<3h7ooOol0KWoo000EOol00`00Oomoo`2;
Ool00`?POomoo`0:Ool00`?POomoo`1]Ool001Eoo`03001oogoo08Yoo`030n1oogoo00]oo`030n1o
ogoo06eoo`005Goo0P00Rgoo00<3h7ooOol037oo00<3h7ooOol0K7oo000EOol00`00Oomoo`2:Ool0
0`?POomoo`0<Ool00`?POomoo`1/Ool001Eoo`03001oogoo08Yoo`030n1oogoo00eoo`030n1oogoo
06]oo`003Woo0P001Goo00<007ooOol0RWoo00<3h7ooOol03Goo00<3h7ooOol0Jgoo000=Ool01000
Oomoo`0017oo00<007ooOol0RGoo00<3h7ooOol03goo00<3h7ooOol0JWoo000@Ool00`00Oomoo`02
Ool30029Ool00`?POomoo`0?Ool00`?POomoo`1ZOol000Moo`@000=oo`8000Eoo`03001oogoo08Uo
o`030n1oogoo00moo`030n1oogoo06Yoo`003Woo00<007ooOol017oo00<007ooOol0RGoo00<3h7oo
Ool047oo00<3h7ooOol0JGoo000>Ool30004Ool00`00Oomoo`28Ool00`?POomoo`0AOol00`?POomo
o`1YOol001Eoo`03001oogoo08Qoo`030n1oogoo019oo`030n1oogoo06Qoo`005Goo00<007ooOol0
R7oo00<3h7ooOol04Woo00<3h7ooOol0J7oo000EOol20029Ool00`?POomoo`0COol00`?POomoo`1W
Ool001Eoo`03001oogoo08Qoo`030n1oogoo01=oo`030n1oogoo06Moo`005Goo00<007ooOol0Qgoo
00<3h7ooOol05Goo00<3h7ooOol0IWoo000EOol00`00Oomoo`27Ool00`?POomoo`0EOol00`?POomo
o`1VOol001Eoo`03001oogoo08Moo`030n1oogoo01Eoo`030n1oogoo06Ioo`005Goo0P00R7oo00<3
h7ooOol05Woo00<3h7ooOol0IGoo000EOol00`00Oomoo`26Ool00`?POomoo`0GOol00`?POomoo`1U
Ool001Eoo`03001oogoo08Ioo`030n1oogoo01Qoo`030n1oogoo06Aoo`005Goo00<007ooOol0QWoo
00<3h7ooOol067oo00<3h7ooOol0I7oo000EOol00`00Oomoo`26Ool00`?POomoo`0IOol00`?POomo
o`1SOol001Eoo`8003Aoo`8000Aoo`8000Aoo`8003=oo`D000aoo`030n1oogoo01Yoo`030n1oogoo
00Ioo`D0009oo`8000Aoo`8003Aoo`@001Ioo`005Goo00<007ooOol0<Woo00@007ooOol000Qoo`04
001oogoo000dOol00`00Oomoo`0<Ool00`?POomoo`0KOol00`?POomoo`07Ool00`00Oomoo`07Ool0
1000Oomoo`00<goo00<007ooOol05goo000EOol00`00Oomoo`0bOol01000Oomoo`002goo00<007oo
Ool0<Woo00<007ooOol037oo00<3h7ooOol06goo00<3h7ooOol01goo00<007ooOol02Woo00<007oo
Ool0<Woo00<007ooOol05Woo000EOol00`00Oomoo`0bOol01000Oomoo`002Goo0P00=Goo00<007oo
Ool037oo00<3h7ooOol06goo00<3h7ooOol01goo00<007ooOol027oo0P00=Woo00<007ooOol05Goo
000EOol00`00Oomoo`0bOol01000Oomoo`002Goo00<007ooOol0=7oo00<007ooOol037oo00<3h7oo
Ool077oo00<3h7ooOol01Woo00<007ooOol027oo00<007ooOol0<goo00@007ooOol001Ioo`005Goo
0P00=7oo0P002Woo0`00<goo0P003Goo00<3h7ooOol07Goo00<3h7ooOol01Goo0P002Woo0`00=7oo
0P005goo000EOol00`00Oomoo`24Ool00`?POomoo`0NOol00`?POomoo`1POol001Eoo`03001oogoo
08Aoo`030n1oogoo01ioo`030n1oogoo061oo`005Goo00<007ooOol0Q7oo00<3h7ooOol07goo00<3
h7ooOol0Ggoo000EOol00`00Oomoo`23Ool00`?POomoo`0POol00`?POomoo`1GOol20006Ool001Eo
o`03001oogoo08=oo`030n1oogoo025oo`030n1oogoo05Eoo`04001oogoo0005Ool000moo`H00003
0n00000008<000030n000000024004X3h0H000Qoo`03001oogoo00Ioo`005Goo00<000?POol02Goo
00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo
00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo
00<3h000Ool02Woo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo
00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02goo
1@001Goo000EOol00`000n1oo`21Ool00`?POomoo`1kOol00`00Oomoo`06Ool001Eoo`03001oo`?P
085oo`030n1oogoo08Aoo`005Goo00<007oo0n00P7oo00<3h7ooOol0QGoo000EOol200000goo0n1o
o`1mOol00`?POomoo`26Ool001Eoo`04001oogoo0n1mOol00`?POomoo`27Ool001Eoo`05001oogoo
Ool3h01kOol00`?POomoo`28Ool001Eoo`05001oogooOol3h01jOol00`?POomoo`29Ool001Eoo`03
001oogoo009oo`030n1oogoo07Moo`030n1oogoo08Uoo`005Goo0P000goo00<3h7ooOol0MWoo00<3
h7ooOol0RWoo000EOol00`00Oomoo`03Ool00`?POomoo`1dOol00`?POomoo`2;Ool001Eoo`03001o
ogoo00=oo`030n1oogoo07=oo`030n1oogoo08aoo`005Goo00<007ooOol017oo00<3h7ooOol0LGoo
00<3h7ooOol0SGoo000EOol00`00Oomoo`04Ool00`?POomoo`1aOol00`?POomoo`2=Ool001Eoo`80
00Ioo`030n1oogoo06moo`030n1oogoo08ioo`005Goo00<007ooOol01Goo00<3h7ooOol0KWoo00<3
h7ooOol0Sgoo000EOol00`00Oomoo`06Ool00`?POomoo`1/Ool00`?POomoo`2@Ool001Eoo`03001o
ogoo00Ioo`030n1oogoo06]oo`030n1oogoo095oo`005Goo00<007ooOol01goo00<3h7ooOol0JWoo
00<3h7ooOol0TGoo000EOol00`00Oomoo`07Ool00`?POomoo`1YOol00`?POomoo`2BOol001Eoo`80
00Uoo`030n1oogoo06Moo`030n1oogoo09=oo`005Goo00<007ooOol027oo00<3h7ooOol0IWoo00<3
h7ooOol0U7oo000EOol00`00Oomoo`09Ool00`?POomoo`1UOol00`?POomoo`2DOol000ioo`8000Eo
o`03001oogoo00Yoo`030n1oogoo06=oo`030n1oogoo09Eoo`003Goo00@007ooOol000Aoo`03001o
ogoo00Yoo`030n1oogoo069oo`030n1oogoo09Ioo`0047oo00<007ooOol00Woo0`002goo00<3h7oo
Ool0H7oo00<3h7ooOol0Ugoo000>Ool20005Ool00`00Oomoo`0;Ool00`?POomoo`1POol00`?POomo
o`2GOol000ioo`03001oogoo00Aoo`03001oogoo00aoo`030n1oogoo05ioo`030n1oogoo09Qoo`00
3Woo0`0017oo00<007ooOol037oo00<3h7ooOol0GGoo00<3h7ooOol0VGoo000EOol00`00Oomoo`0=
Ool00`?POomoo`1KOol00`?POomoo`2JOol001Eoo`8000ioo`030n1oogoo05]oo`030n1oogoo09Yo
o`005Goo00<007ooOol03Woo00<3h7ooOol0FGoo00<3h7ooOol0Vgoo000EOol00`00Oomoo`0>Ool0
0`?POomoo`1HOol00`?POomoo`2LOol001Eoo`03001oogoo00moo`030n1oogoo05Ioo`030n1oogoo
09eoo`005Goo00<007ooOol03goo00<3h7ooOol0EWoo00<3h7ooOol0WGoo000EOol00`00Oomoo`0@
Ool00`?POomoo`1DOol00`?POomoo`2NOol001Eoo`80015oo`030n1oogoo05=oo`030n1oogoo09mo
o`005Goo00<007ooOol04Goo00<3h7ooOol0DGoo00<3h7ooOol0X7oo000EOol00`00Oomoo`0AOol0
0`?POomoo`1AOol00`?POomoo`2POol001Eoo`03001oogoo019oo`030n1oogoo04moo`030n1oogoo
0:5oo`005Goo00<007ooOol04Woo00<3h7ooOol0CWoo00<3h7ooOol0XWoo000EOol2000DOol00`?P
Oomoo`1<Ool00`?POomoo`2SOol001Eoo`03001oogoo01=oo`030n1oogoo04aoo`030n1oogoo0:=o
o`005Goo00<007ooOol057oo00<3h7ooOol0BWoo00<3h7ooOol0Y7oo000EOol00`00Oomoo`0DOol0
0`?POomoo`19Ool00`?POomoo`2UOol001Eoo`03001oogoo01Eoo`030n1oogoo04Moo`030n1oogoo
0:Ioo`005Goo0P005goo00<3h7ooOol0AWoo00<3h7ooOol0YWoo000EOol00`00Oomoo`0FOol00`?P
Oomoo`15Ool00`?POomoo`2WOol001Eoo`03001oogoo01Moo`030n1oogoo04=oo`030n1oogoo0:Qo
o`001goo1@000Woo0P001Goo00<007ooOol05goo00<3h7ooOol0@Woo00<3h7ooOol0ZGoo0009Ool0
1@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol067oo00<3h7ooOol0@Goo00<3h7ooOol0
ZGoo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo0`0067oo00<3h7ooOol0@7oo00<3h7oo
Ool0ZWoo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol06Goo00<3h7ooOol0
?Woo00<3h7ooOol0Zgoo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol06Goo
00<3h7ooOol0?Goo00<3h7ooOol0[7oo0008Ool20004Ool20005Ool00`00Oomoo`0JOol00`?POomo
o`0lOol00`?POomoo`2/Ool001Eoo`03001oogoo01Yoo`030n1oogoo03]oo`030n1oogoo0:eoo`00
5Goo00<007ooOol06goo00<3h7ooOol0>Goo00<3h7ooOol0[Woo000EOol2000MOol00`?POomoo`0g
Ool00`?POomoo`2_Ool001Eoo`03001oogoo01aoo`030n1oogoo03Moo`030n1oogoo0:moo`005Goo
00<007ooOol07Goo00<3h7ooOol0=Goo00<3h7ooOol0/7oo000EOol00`00Oomoo`0MOol00`?POomo
o`0dOol00`?POomoo`2aOol001Eoo`03001oogoo01ioo`030n1oogoo039oo`030n1oogoo0;9oo`00
5Goo0P007goo00<3h7ooOol0<Woo00<3h7ooOol0/Woo000EOol00`00Oomoo`0OOol00`?POomoo`0`
Ool00`?POomoo`2cOol001Eoo`03001oogoo01moo`030n1oogoo02moo`030n1oogoo0;Aoo`005Goo
00<007ooOol087oo00<3h7ooOol0;Woo00<3h7ooOol0]7oo000EOol00`00Oomoo`0POol00`?POomo
o`0]Ool00`?POomoo`2eOol001Eoo`80029oo`030n1oogoo02]oo`030n1oogoo0;Ioo`005Goo00<0
07ooOol08Goo00<3h7ooOol0:Woo00<3h7ooOol0]goo000EOol00`00Oomoo`0ROol00`?POomoo`0Y
Ool00`?POomoo`2gOol001Eoo`03001oogoo02=oo`030n1oogoo02Moo`030n1oogoo0;Qoo`005Goo
00<007ooOol08goo00<3h7ooOol09Woo00<3h7ooOol0^Goo000EOol2000UOol00`?POomoo`0UOol0
0`?POomoo`2iOol001Eoo`03001oogoo02Aoo`030n1oogoo02Aoo`030n1oogoo0;Yoo`005Goo00<0
07ooOol09Goo00<3h7ooOol08Woo00<3h7ooOol0^goo000EOol00`00Oomoo`0UOol00`?POomoo`0R
Ool00`?POomoo`2kOol000Moo`D0009oo`8000Eoo`03001oogoo02Ioo`030n1oogoo021oo`030n1o
ogoo0;aoo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo02Ioo`030n1oogoo
01moo`030n1oogoo0;eoo`002Goo00<007ooOol017oo00<007ooOol00Woo0`009goo00<3h7ooOol0
7Goo00<3h7ooOol0_Woo0009Ool00`00Oomoo`02Ool20005Ool00`00Oomoo`0WOol00`?POomoo`0M
Ool00`?POomoo`2nOol000Uoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo02Qoo`030n1o
ogoo01]oo`030n1oogoo0;moo`0027oo0P0017oo0`0017oo00<007ooOol0:7oo00<3h7ooOol06Woo
00<3h7ooOol0`7oo000EOol00`00Oomoo`0YOol00`?POomoo`0HOol00`?POomoo`31Ool001Eoo`80
02Yoo`030n1oogoo01Qoo`030n1oogoo0<5oo`005Goo00<007ooOol0:Woo00<3h7ooOol05Woo00<3
h7ooOol0`Woo000EOol00`00Oomoo`0ZOol00`?POomoo`0EOol00`?POomoo`33Ool001Eoo`03001o
ogoo02]oo`030n1oogoo01=oo`030n1oogoo0<Aoo`005Goo00<007ooOol0:goo00<3h7ooOol04goo
00<3h7ooOol0a7oo000EOol2000]Ool00`?POomoo`0AOol00`?POomoo`35Ool001Eoo`03001oogoo
02aoo`030n1oogoo011oo`030n1oogoo0<Ioo`005Goo00<007ooOol0;Goo00<3h7ooOol03Woo00<3
h7ooOol0agoo000EOol00`00Oomoo`0]Ool00`?POomoo`0>Ool00`?POomoo`37Ool001Eoo`03001o
ogoo02ioo`83h0eoo`030n1oogoo0<Qoo`005Goo0P00<Goo0`?P2Goo00<3h7ooOol0bGoo000EOol0
0`00Oomoo`0cOol30n05Ool00`?POomoo`3:Ool001Eoo`03001oogoo03Ioo`<3h09oo`030n1oogoo
0<Yoo`005Goo00<007ooOol0>Goo0P?PcGoo000EOol00`00Oomoo`3oOol9Ool001Eoo`03001oogoo
0?moo`Uoo`005Goo0P00ogoo2Woo000EOol00`00Oomoo`3oOol9Ool00?moob5oo`00ogoo8Goo003o
OolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo000BOol3003oOol<Ool0
01=oo`03001oogoo0?moo`]oo`004goo0`00ogoo2goo000COol01000Oomoo`00ogoo2Woo000COol0
1000Oomoo`00ogoo2Woo000BOol4003oOol;Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5o
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.178731, -10.8547, \
0.00824988, 0.18996}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.146521 [
[.2619 .00222 -9 -9 ]
[.2619 .00222 9 0 ]
[.5 .00222 -3 -9 ]
[.5 .00222 3 0 ]
[.7381 .00222 -9 -9 ]
[.7381 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .16124 -6 -4.5 ]
[.01131 .16124 0 4.5 ]
[.01131 .30776 -6 -4.5 ]
[.01131 .30776 0 4.5 ]
[.01131 .45428 -6 -4.5 ]
[.01131 .45428 0 4.5 ]
[.01131 .6008 -6 -4.5 ]
[.01131 .6008 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(0.5)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(1)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(1.5)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(2)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .16124 m
.03006 .16124 L
s
[(1)] .01131 .16124 1 0 Mshowa
.02381 .30776 m
.03006 .30776 L
s
[(2)] .01131 .30776 1 0 Mshowa
.02381 .45428 m
.03006 .45428 L
s
[(3)] .01131 .45428 1 0 Mshowa
.02381 .6008 m
.03006 .6008 L
s
[(4)] .01131 .6008 1 0 Mshowa
.125 Mabswid
.02381 .04402 m
.02756 .04402 L
s
.02381 .07332 m
.02756 .07332 L
s
.02381 .10263 m
.02756 .10263 L
s
.02381 .13193 m
.02756 .13193 L
s
.02381 .19054 m
.02756 .19054 L
s
.02381 .21984 m
.02756 .21984 L
s
.02381 .24915 m
.02756 .24915 L
s
.02381 .27845 m
.02756 .27845 L
s
.02381 .33706 m
.02756 .33706 L
s
.02381 .36636 m
.02756 .36636 L
s
.02381 .39567 m
.02756 .39567 L
s
.02381 .42497 m
.02756 .42497 L
s
.02381 .48358 m
.02756 .48358 L
s
.02381 .51288 m
.02756 .51288 L
s
.02381 .54219 m
.02756 .54219 L
s
.02381 .57149 m
.02756 .57149 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.07143 .01939 L
.11905 .04919 L
.16667 .114 L
.21429 .20529 L
.2619 .3089 L
.30952 .41866 L
.35714 .51698 L
.40476 .58424 L
.45238 .60332 L
.5 .56317 L
.54762 .47352 L
.59524 .35923 L
.64286 .2429 L
.69048 .19712 L
.7381 .25434 L
.78571 .37932 L
.83333 .49055 L
.88095 .53014 L
.92857 .48362 L
.97619 .38366 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo0018Ool2
0004Ool20004Ool2000aOol5000^Ool50002Ool20004Ool2000aOol4000ROol004Moo`04001oogoo
0008Ool01000Oomoo`00<Woo00<007ooOol0<7oo00<007ooOol01goo00@007ooOol0031oo`03001o
ogoo02=oo`00Agoo00@007ooOol000]oo`03001oogoo031oo`03001oogoo031oo`03001oogoo00Yo
o`03001oogoo02moo`03001oogoo029oo`00Agoo00@007ooOol000Uoo`8003=oo`03001oogoo031o
o`03001oogoo00Qoo`8003=oo`03001oogoo025oo`00Agoo00@007ooOol000Uoo`03001oogoo039o
o`03001oogoo031oo`03001oogoo00Qoo`03001oogoo031oo`04001oogoo000ROol004Qoo`8000Yo
o`<0035oo`80035oo`8000Yoo`<0035oo`8002=oo`00ogoo8Goo000EOol00`00Oomoo`3oOol9Ool0
01Eoo`03001oogoo0?moo`Uoo`005Goo00<007ooOol0m7oo0P004Woo000EOol00`00Oomoo`3cOol0
1000Oomoo`004Goo000?Ool60006O03X0008Ool00`00Oomoo`0BOol001Eoo`03001oogoo00=oo`Ml
00Yoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo
00Uoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo
00Uoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo
00Qoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00]oo`D0015oo`00
5Goo00<007ooOol02Woo0W`0igoo00<007ooOol04Woo000EOol00`00Oomoo`0<Ool00g`0Oomoo`3i
Ool001Eoo`03001oogoo00eoo`9l0?Uoo`005Goo00<007ooOol03goo0W`0mgoo000EOol00`00Oomo
o`0AOol00g`0Oomoo`3dOol001Eoo`8001=oo`9l0?Aoo`005Goo00<007ooOol057oo00=l07ooOol0
lGoo000EOol00`00Oomoo`0EOol00g`0Oomoo`3`Ool001Eoo`03001oogoo01Ioo`03O01oogoo0>mo
o`005Goo00<007ooOol05Woo00=l07ooOol0kgoo000EOol00`00Oomoo`0GOol00g`0Oomoo`3^Ool0
01Eoo`03001oogoo01Qoo`03O01oogoo0>eoo`005Goo0P006Woo00=l07ooOol0k7oo000EOol00`00
Oomoo`0IOol00g`0Oomoo`3/Ool001Eoo`03001oogoo01Yoo`03O01oogoo0>]oo`005Goo00<007oo
Ool06goo00=l07ooOol0jWoo000EOol00`00Oomoo`0LOol00g`0Oomoo`3YOol001Eoo`03001oogoo
01aoo`03O01oogoo0>Uoo`005Goo00<007ooOol07Goo00=l07ooOol0j7oo000EOol2000OOol00g`0
Oomoo`3WOol001Eoo`03001oogoo01moo`03O01oogoo0>Ioo`005Goo00<007ooOol07goo00=l07oo
Ool0iWoo000EOol00`00Oomoo`0POol00g`0Oomoo`3UOol001Eoo`03001oogoo025oo`03O01oogoo
0>Aoo`005Goo00<007ooOol08Goo00=l07ooOol0i7oo000EOol00`00Oomoo`0ROol00g`0Oomoo`3S
Ool001Eoo`8002=oo`03O01oogoo0>=oo`005Goo00<007ooOol08goo00=l07ooOol0hWoo000EOol0
0`00Oomoo`0SOol00g`0Oomoo`3ROol001Eoo`03001oogoo02Aoo`03O01oogoo0>5oo`005Goo00<0
07ooOol097oo00=l07ooOol0hGoo000=Ool50003Ool00`00Oomoo`0UOol00g`0Oomoo`3POol000mo
o`03001oogoo00=oo`03001oogoo02Eoo`03O01oogoo0>1oo`003goo00<007ooOol00goo0`009Woo
00=l07ooOol0ggoo000?Ool00`00Oomoo`03Ool00`00Oomoo`0VOol00g`0Oomoo`3OOol000moo`03
001oogoo00=oo`03001oogoo02Moo`03O01oogoo0=ioo`003Woo0P001Goo00<007ooOol09goo00=l
07ooOol0gWoo000EOol00`00Oomoo`0XOol00g`0Oomoo`3MOol001Eoo`03001oogoo02Qoo`03O01o
ogoo0=eoo`005Goo00<007ooOol0:Goo00=l07ooOol0g7oo000EOol2000ZOol00g`0Oomoo`3LOol0
01Eoo`03001oogoo02Yoo`03O01oogoo0=]oo`005Goo00<007ooOol0:Woo00=l07ooOol0LWoo00=l
07ooOol0IWoo000EOol00`00Oomoo`0[Ool00g`0Oomoo`1`Ool00g`0Ooml001WOol001Eoo`03001o
ogoo02]oo`03O01oogoo06moo`05O01oogooOoml001VOol001Eoo`03001oogoo02]oo`03O01oogoo
06ioo`03O01oogoo009oo`03O01oogoo06Aoo`005Goo00<007ooOol0;7oo00=l07ooOol0K7oo00=l
07ooOol017oo00=l07ooOol0Hgoo000EOol2000]Ool00g`0Oomoo`1[Ool00g`0Oomoo`06Ool00g`0
Oomoo`1ROol001Eoo`03001oogoo02eoo`03O01oogoo06Qoo`9l00Yoo`03O01oogoo065oo`005Goo
00<007ooOol0;Goo00=l07ooOol0Igoo00=l07ooOol02goo00=l07ooOol0H7oo000EOol00`00Oomo
o`0^Ool00g`0Oomoo`1UOol00g`0Oomoo`0<Ool00g`0Oomoo`1POol001Eoo`03001oogoo02ioo`03
O01oogoo06Aoo`03O01oogoo00ioo`03O01oogoo05moo`005Goo00<007ooOol0;goo00=l07ooOol0
HWoo00=l07ooOol047oo00=l07ooOol0GWoo000EOol00`00Oomoo`0_Ool00g`0Oomoo`1QOol00g`0
Oomoo`0BOol00g`0Oomoo`1MOol001Eoo`80035oo`03O01oogoo061oo`03O01oogoo019oo`03O01o
ogoo05eoo`005Goo00<007ooOol0<7oo00=l07ooOol0Ggoo00=l07ooOol057oo00=l07ooOol0G7oo
000EOol00`00Oomoo`0aOol00g`0Oomoo`1NOol00g`0Oomoo`0EOol00g`0Oomoo`1KOol001Eoo`03
001oogoo035oo`03O01oogoo05eoo`03O01oogoo01Ioo`03O01oogoo05]oo`005Goo00<007ooOol0
<Woo00=l07ooOol0G7oo00=l07ooOol05goo00=l07ooOol0FWoo000EOol00`00Oomoo`0bOol00g`0
Oomoo`1LOol00g`0Oomoo`0GOol00g`0Oomoo`1JOol001Eoo`03001oogoo03=oo`03O01oogoo05Yo
o`03O01oogoo01Uoo`03O01oogoo05Uoo`005Goo00<007ooOol0<goo00=l07ooOol0FWoo00=l07oo
Ool06Goo00=l07ooOol0FGoo000EOol2000eOol00g`0Oomoo`1HOol00g`0Oomoo`0JOol00g`0Oomo
o`1IOol001Eoo`03001oogoo03Aoo`03O01oogoo05Qoo`03O01oogoo01]oo`03O01oogoo05Qoo`00
5Goo00<007ooOol0=Goo00=l07ooOol0Egoo00=l07ooOol06goo00=l07ooOol0F7oo000EOol00`00
Oomoo`0eOol00g`0Oomoo`1FOol00g`0Oomoo`0MOol00g`0Oomoo`1GOol001Eoo`03001oogoo03Io
o`03O01oogoo05Eoo`03O01oogoo01eoo`03O01oogoo05Moo`003Goo100017oo00<007ooOol0=Woo
00=l07ooOol0E7oo00=l07ooOol07Woo00=l07ooOol0Egoo000=Ool00`00Oomoo`05Ool00`00Oomo
o`0gOol00g`0Oomoo`1COol00g`0Oomoo`0OOol00g`0Oomoo`1FOol000ioo`03001oogoo00Aoo`<0
03Moo`03O01oogoo05=oo`03O01oogoo01moo`03O01oogoo05Ioo`003goo00<007ooOol00goo00<0
07ooOol0=goo00=l07ooOol0DWoo00=l07ooOol08Goo00=l07ooOol0EGoo000=Ool01000Oomoo`00
17oo00<007ooOol0>7oo00=l07ooOol0DGoo00=l07ooOol08Goo00=l07ooOol0EGoo000>Ool20005
Ool00`00Oomoo`0hOol00g`0Oomoo`1AOol00g`0Oomoo`0QOol00g`0Oomoo`1EOol001Eoo`03001o
ogoo03Uoo`03O01oogoo04moo`03O01oogoo02=oo`03O01oogoo05Aoo`005Goo00<007ooOol0>Goo
00=l07ooOol0Cgoo00=l07ooOol08goo00=l07ooOol0E7oo000EOol00`00Oomoo`0iOol00g`0Oomo
o`1>Ool00g`0Oomoo`0UOol00g`0Oomoo`1COol001Eoo`8003]oo`03O01oogoo04eoo`03O01oogoo
02Eoo`03O01oogoo05=oo`005Goo00<007ooOol0>Woo00=l07ooOol0CGoo00=l07ooOol09Goo00=l
07ooOol0Dgoo000EOol00`00Oomoo`0kOol00g`0Oomoo`1;Ool00g`0Oomoo`0WOol00g`0Oomoo`1B
Ool001Eoo`03001oogoo03]oo`03O01oogoo04]oo`03O01oogoo02Moo`03O01oogoo059oo`005Goo
00<007ooOol0>goo00=l07ooOol0BWoo00=l07ooOol0:Goo00=l07ooOol0DGoo000EOol00`00Oomo
o`0lOol00g`0Oomoo`19Ool00g`0Oomoo`0YOol00g`0Oomoo`1AOol001Eoo`03001oogoo03aoo`03
O01oogoo04Uoo`03O01oogoo02Uoo`03O01oogoo055oo`005Goo0P00?Woo00=l07ooOol0Agoo00=l
07ooOol0:goo00=l07ooOol0D7oo000EOol00`00Oomoo`0mOol00g`0Oomoo`17Ool00g`0Oomoo`0[
Ool00g`0Oomoo`1@Ool001Eoo`03001oogoo03ioo`03O01oogoo04Eoo`03O01oogoo02eoo`03O01o
ogoo04moo`005Goo00<007ooOol0?Woo00=l07ooOol0AGoo00=l07ooOol0;Goo00=l07ooOol0Cgoo
000EOol00`00Oomoo`0nOol00g`0Oomoo`14Ool00g`0Oomoo`0^Ool00g`0Oomoo`0[Ool00g`0Oomo
o`0QOol001Eoo`03001oogoo03moo`03O01oogoo04=oo`03O01oogoo02moo`03O01oogoo02Yoo`03
O01oogoo025oo`005Goo00<007ooOol0?goo00=l07ooOol0@goo00=l07ooOol0;goo00=l07ooOol0
:Goo00=l07ooOol08Woo000EOol20011Ool00g`0Oomoo`11Ool00g`0Oomoo`0aOol00g`0Oomoo`0X
Ool00g`0Oomoo`0ROol001Eoo`03001oogoo041oo`03O01oogoo045oo`03O01oogoo035oo`03O01o
ogoo02Moo`03O01oogoo02=oo`005Goo00<007ooOol0@7oo00=l07ooOol0@7oo00=l07ooOol0<Woo
00=l07ooOol09goo00=l07ooOol08goo000EOol00`00Oomoo`11Ool00g`0Oomoo`0oOol00g`0Oomo
o`0cOol00g`0Oomoo`0UOol00g`0Oomoo`0TOol001Eoo`03001oogoo045oo`03O01oogoo03ioo`03
O01oogoo03Aoo`03O01oogoo02Eoo`03O01oogoo02Aoo`005Goo00<007ooOol0@Woo00=l07ooOol0
?Goo00=l07ooOol0=Goo00=l07ooOol08goo00=l07ooOol09Goo000EOol00`00Oomoo`12Ool00g`0
Oomoo`0mOol00g`0Oomoo`0eOol00g`0Oomoo`0SOol00g`0Oomoo`0UOol001Eoo`8004Aoo`03O01o
ogoo03]oo`03O01oogoo03Ioo`03O01oogoo029oo`03O01oogoo02Ioo`005Goo00<007ooOol0@goo
00=l07ooOol0>goo00=l07ooOol0=goo00=l07ooOol08Goo00=l07ooOol09Woo000EOol00`00Oomo
o`14Ool00g`0Oomoo`0iOol00g`0Oomoo`0hOol00g`0Oomoo`0POol00g`0Oomoo`0WOol001Eoo`03
001oogoo04Aoo`03O01oogoo03Uoo`03O01oogoo03Uoo`03O01oogoo01moo`03O01oogoo02Moo`00
5Goo00<007ooOol0AGoo00=l07ooOol0=goo00=l07ooOol0>Woo00=l07ooOol07goo00=l07ooOol0
9goo000>Ool20005Ool00`00Oomoo`15Ool00g`0Oomoo`0gOol00g`0Oomoo`0kOol00g`0Oomoo`0M
Ool00g`0Oomoo`0XOol000eoo`04001oogoo0004Ool00`00Oomoo`16Ool00g`0Oomoo`0fOol00g`0
Oomoo`0kOol00g`0Oomoo`0MOol00g`0Oomoo`0XOol000moo`03001oogoo00=oo`<004Ioo`03O01o
ogoo03Eoo`03O01oogoo03aoo`03O01oogoo01aoo`03O01oogoo02Uoo`0047oo00<007ooOol00Woo
00<007ooOol0Agoo00=l07ooOol0=7oo00=l07ooOol0?Goo00=l07ooOol06goo00=l07ooOol0:Goo
000=Ool01000Oomoo`0017oo00<007ooOol0Agoo00=l07ooOol0<goo00=l07ooOol0?Woo00=l07oo
Ool06Woo00=l07ooOol0:Woo000>Ool20005Ool00`00Oomoo`18Ool00g`0Oomoo`0bOol00g`0Oomo
o`0oOol00g`0Oomoo`0IOol00g`0Oomoo`0ZOol001Eoo`03001oogoo04Qoo`03O01oogoo035oo`03
O01oogoo041oo`03O01oogoo01Qoo`03O01oogoo02]oo`005Goo00<007ooOol0BGoo00=l07ooOol0
<7oo00=l07ooOol0@7oo00=l07ooOol067oo00=l07ooOol0:goo000EOol00`00Oomoo`19Ool00g`0
Oomoo`0_Ool00g`0Oomoo`12Ool00g`0Oomoo`0FOol00g`0Oomoo`0/Ool001Eoo`8004]oo`03O01o
ogoo02ioo`03O01oogoo049oo`03O01oogoo01Ioo`03O01oogoo02aoo`005Goo00<007ooOol0BWoo
00=l07ooOol0;Goo00=l07ooOol0A7oo00=l07ooOol057oo00=l07ooOol0;Goo000EOol00`00Oomo
o`1;Ool00g`0Oomoo`0/Ool00g`0Oomoo`14Ool00g`0Oomoo`0COol00g`0Oomoo`0^Ool001Eoo`03
001oogoo04]oo`03O01oogoo02]oo`03O01oogoo04Ioo`03O01oogoo015oo`03O01oogoo02moo`00
5Goo00<007ooOol0C7oo00=l07ooOol0:Woo00=l07ooOol0Agoo00=l07ooOol03goo00=l07ooOol0
<7oo000EOol00`00Oomoo`1<Ool00g`0Oomoo`0YOol00g`0Oomoo`19Ool2O00>Ool00g`0Oomoo`0a
Ool001Eoo`03001oogoo04eoo`03O01oogoo02Qoo`03O01oogoo04]oo`03O01oogoo00Yoo`03O01o
ogoo039oo`005Goo0P00CWoo00=l07ooOol09goo00=l07ooOol0CGoo00=l07ooOol027oo00=l07oo
Ool0<goo000EOol00`00Oomoo`1>Ool00g`0Oomoo`0VOol00g`0Oomoo`1>Ool00g`0Oomoo`06Ool0
0g`0Oomoo`0dOol001Eoo`03001oogoo04moo`03O01oogoo02Aoo`03O01oogoo051oo`03O01oogoo
00Aoo`03O01oogoo03Eoo`005Goo00<007ooOol0Cgoo00=l07ooOol097oo00=l07ooOol0DGoo0W`0
0goo00=l07ooOol0=Woo000EOol00`00Oomoo`1@Ool00g`0Oomoo`0ROol00g`0Oomoo`1DOol00g`0
Ooml000iOol001Eoo`03001oogoo055oo`03O01oogoo025oo`03O01oogoo05Eoo`03O01oogoo03Qo
o`005Goo00<007ooOol0DGoo00=l07ooOol087oo00=l07ooOol0TGoo000EOol00`00Oomoo`1BOol0
0g`0Oomoo`0OOol00g`0Oomoo`2AOol001Eoo`8005Aoo`03O01oogoo01eoo`03O01oogoo099oo`00
5Goo00<007ooOol0Dgoo00=l07ooOol07Goo00=l07ooOol0TWoo000EOol00`00Oomoo`1DOol00g`0
Oomoo`0KOol00g`0Oomoo`2COol001Eoo`03001oogoo05Aoo`03O01oogoo01]oo`03O01oogoo09=o
o`005Goo00<007ooOol0EGoo00=l07ooOol06Goo00=l07ooOol0U7oo000EOol00`00Oomoo`1FOol0
0g`0Oomoo`0HOol00g`0Oomoo`2DOol001Eoo`03001oogoo05Ioo`03O01oogoo01Moo`03O01oogoo
09Eoo`005Goo0P00F7oo00=l07ooOol057oo0W`0V7oo000EOol00`00Oomoo`1HOol00g`0Oomoo`0B
Ool00g`0Oomoo`2HOol001Eoo`03001oogoo05Qoo`03O01oogoo015oo`03O01oogoo09Uoo`005Goo
00<007ooOol0FGoo0W`03goo0W`0W7oo000EOol00`00Oomoo`1KOol3O00;Ool00g`0Oomoo`2LOol0
00moo`<000=oo`03001oogoo05ioo`=l00Moo`03O01oogoo09eoo`0047oo00<007ooOol00Woo00<0
07ooOol0HGoo0g`00Woo0W`0X7oo000=Ool50003Ool3001TOol2O02ROol000eoo`04001oogoo0004
Ool00`00Oomoo`3oOol9Ool000ioo`03001oo`0000Aoo`03001oogoo0?moo`Uoo`003goo0P0017oo
00<007ooOol0ogoo2Goo000EOol00`00Oomoo`3oOol9Ool00?moob5oo`00ogoo8Goo003oOolQOol0
0?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`0057oo
1000ogoo2Goo000COol01000Oomoo`00ogoo2Woo000COol01000Oomoo`00ogoo2Woo000BOol20000
0goo0000003oOol:Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.186924, -0.338534, \
0.0086576, 0.028137}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.301666 0.0338184 [
[.2619 .28917 -9 -9 ]
[.2619 .28917 9 0 ]
[.5 .28917 -3 -9 ]
[.5 .28917 3 0 ]
[.7381 .28917 -9 -9 ]
[.7381 .28917 9 0 ]
[.97619 .28917 -3 -9 ]
[.97619 .28917 3 0 ]
[1.025 .30167 0 -6.25 ]
[1.025 .30167 10 6.25 ]
[.01131 .04803 -24 -4.5 ]
[.01131 .04803 0 4.5 ]
[.01131 .13257 -12 -4.5 ]
[.01131 .13257 0 4.5 ]
[.01131 .21712 -24 -4.5 ]
[.01131 .21712 0 4.5 ]
[.01131 .38621 -18 -4.5 ]
[.01131 .38621 0 4.5 ]
[.01131 .47076 -6 -4.5 ]
[.01131 .47076 0 4.5 ]
[.01131 .5553 -18 -4.5 ]
[.01131 .5553 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .30167 m
.2619 .30792 L
s
[(0.5)] .2619 .28917 0 1 Mshowa
.5 .30167 m
.5 .30792 L
s
[(1)] .5 .28917 0 1 Mshowa
.7381 .30167 m
.7381 .30792 L
s
[(1.5)] .7381 .28917 0 1 Mshowa
.97619 .30167 m
.97619 .30792 L
s
[(2)] .97619 .28917 0 1 Mshowa
.125 Mabswid
.07143 .30167 m
.07143 .30542 L
s
.11905 .30167 m
.11905 .30542 L
s
.16667 .30167 m
.16667 .30542 L
s
.21429 .30167 m
.21429 .30542 L
s
.30952 .30167 m
.30952 .30542 L
s
.35714 .30167 m
.35714 .30542 L
s
.40476 .30167 m
.40476 .30542 L
s
.45238 .30167 m
.45238 .30542 L
s
.54762 .30167 m
.54762 .30542 L
s
.59524 .30167 m
.59524 .30542 L
s
.64286 .30167 m
.64286 .30542 L
s
.69048 .30167 m
.69048 .30542 L
s
.78571 .30167 m
.78571 .30542 L
s
.83333 .30167 m
.83333 .30542 L
s
.88095 .30167 m
.88095 .30542 L
s
.92857 .30167 m
.92857 .30542 L
s
.25 Mabswid
0 .30167 m
1 .30167 L
s
gsave
1.025 .30167 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .04803 m
.03006 .04803 L
s
[(-7.5)] .01131 .04803 1 0 Mshowa
.02381 .13257 m
.03006 .13257 L
s
[(-5)] .01131 .13257 1 0 Mshowa
.02381 .21712 m
.03006 .21712 L
s
[(-2.5)] .01131 .21712 1 0 Mshowa
.02381 .38621 m
.03006 .38621 L
s
[(2.5)] .01131 .38621 1 0 Mshowa
.02381 .47076 m
.03006 .47076 L
s
[(5)] .01131 .47076 1 0 Mshowa
.02381 .5553 m
.03006 .5553 L
s
[(7.5)] .01131 .5553 1 0 Mshowa
.125 Mabswid
.02381 .06494 m
.02756 .06494 L
s
.02381 .08185 m
.02756 .08185 L
s
.02381 .09876 m
.02756 .09876 L
s
.02381 .11566 m
.02756 .11566 L
s
.02381 .14948 m
.02756 .14948 L
s
.02381 .16639 m
.02756 .16639 L
s
.02381 .1833 m
.02756 .1833 L
s
.02381 .20021 m
.02756 .20021 L
s
.02381 .23403 m
.02756 .23403 L
s
.02381 .25094 m
.02756 .25094 L
s
.02381 .26785 m
.02756 .26785 L
s
.02381 .28476 m
.02756 .28476 L
s
.02381 .31858 m
.02756 .31858 L
s
.02381 .33548 m
.02756 .33548 L
s
.02381 .35239 m
.02756 .35239 L
s
.02381 .3693 m
.02756 .3693 L
s
.02381 .40312 m
.02756 .40312 L
s
.02381 .42003 m
.02756 .42003 L
s
.02381 .43694 m
.02756 .43694 L
s
.02381 .45385 m
.02756 .45385 L
s
.02381 .48767 m
.02756 .48767 L
s
.02381 .50458 m
.02756 .50458 L
s
.02381 .52149 m
.02756 .52149 L
s
.02381 .53839 m
.02756 .53839 L
s
.02381 .03112 m
.02756 .03112 L
s
.02381 .01421 m
.02756 .01421 L
s
.02381 .57221 m
.02756 .57221 L
s
.02381 .58912 m
.02756 .58912 L
s
.02381 .60603 m
.02756 .60603 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 1 r
.5 Mabswid
.02381 .30167 m
.07143 .33403 L
.11905 .41126 L
.16667 .48816 L
.21429 .5316 L
.2619 .55149 L
.30952 .54989 L
.35714 .4998 L
.40476 .40745 L
.45238 .27824 L
.5 .14368 L
.54762 .05827 L
.59524 .01472 L
.64286 .08785 L
.69048 .31308 L
.7381 .549 L
.78571 .60332 L
.83333 .49222 L
.88095 .29 L
.92857 .1126 L
.97619 .05206 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3
Ool001]oo`8008aoo`03O1moogoo07Aoo`006goo00<007ooOol0RWoo00=l7gooO1l0MGoo000KOol0
0`00Oomoo`29Ool017`OOomoog`OMGoo000KOol00`00Oomoo`28Ool00g`OOomoo`02Ool00g`OOomo
o`1bOol001]oo`8008Qoo`03O1moogoo00Aoo`03O1moogoo075oo`006goo00<007ooOol0QWoo00=l
7gooOol01Goo00=l7gooOol0LGoo000KOol00`00Oomoo`24Ool2O1l9Ool00g`OOomoo`1`Ool000Uo
o`03001oogoo009oo`8000Aoo`8000Eoo`03001oogoo08=oo`03O1moogoo00Yoo`03O1moogoo06mo
o`002Goo00<007ooOol01goo00@007ooOol000Aoo`03001oogoo089oo`03O1moogoo00]oo`03O1mo
ogoo06moo`002Goo00<007ooOol02Woo00<007ooOol00Woo0P00PWoo00=l7gooOol03Goo00=l7goo
Ool0KWoo00000goo000000020005Ool00`00Oomoo`07Ool20005Ool00`00Oomoo`20Ool00g`OOomo
o`0?Ool00g`OOomoo`1EOol00g`OOomoo`0EOol000Moo`04001oogoo0009Ool00`00Oomoo`04Ool0
0`00Oomoo`1oOol00g`OOomoo`0@Ool00g`OOomoo`1DOol00g`OOomoo`0FOol000Moo`@000Uoo`<0
00Aoo`03001oogoo07ioo`03O1moogoo019oo`03O1moogoo059oo`03O1moogoo01Moo`006goo0P00
Ogoo00=l7gooOol04goo00=l7gooOol0DGoo00=l7gooOol05goo000KOol00`00Oomoo`1mOol00g`O
Oomoo`0DOol00g`OOomoo`1@Ool00g`OOomoo`0HOol001]oo`03001oogoo07eoo`03O1moogoo01Eo
o`03O1moogoo04ioo`03O1moogoo01Uoo`006goo00<007ooOol0O7oo00=l7gooOol05goo00=l7goo
Ool0C7oo00=l7gooOol06Woo000KOol2001mOol00g`OOomoo`0GOol00g`OOomoo`1;Ool00g`OOomo
o`0KOol001]oo`03001oogoo07]oo`03O1moogoo01Uoo`03O1moogoo04Yoo`03O1moogoo01]oo`00
6goo00<007ooOol0NWoo00=l7gooOol06Woo00=l7gooOol0BGoo00=l7gooOol077oo000KOol00`00
Oomoo`1jOol00g`OOomoo`0JOol00g`OOomoo`18Ool00g`OOomoo`0MOol001]oo`8007Yoo`03O1mo
ogoo01aoo`03O1moogoo04Ioo`03O1moogoo01ioo`006goo00<007ooOol0NGoo00=l7gooOol077oo
00=l7gooOol0AGoo00=l7gooOol07goo000KOol00`00Oomoo`1hOol00g`OOomoo`0MOol00g`OOomo
o`15Ool00g`OOomoo`0OOol001]oo`03001oogoo07Qoo`03O1moogoo01eoo`03O1moogoo04Aoo`03
O1moogoo021oo`006goo0P00N7oo00=l7gooOol07Woo00=l7gooOol0@goo00=l7gooOol08Goo000K
Ool00`00Oomoo`1fOol00g`OOomoo`0POol00g`OOomoo`12Ool00g`OOomoo`0QOol001]oo`03001o
ogoo07Ioo`03O1moogoo021oo`03O1moogoo045oo`03O1moogoo029oo`0057oo0P001Goo00<007oo
Ool0MGoo00=l7gooOol08Goo00=l7gooOol0@Goo00=l7gooOol08Woo000COol01000Oomoo`0017oo
00<007ooOol0MGoo00=l7gooOol08Goo00=l7gooOol0@Goo00=l7gooOol08Woo000FOol00`00Oomo
o`02Ool2001eOol00g`OOomoo`0SOol00g`OOomoo`10Ool00g`OOomoo`0ROol000eoo`@000=oo`80
00Eoo`03001oogoo07Aoo`03O1moogoo02=oo`03O1moogoo03moo`03O1moogoo02=oo`0057oo00<0
07ooOol017oo00<007ooOol0Lgoo00=l7gooOol097oo00=l7gooOol0?goo00=l7gooOol08goo000D
Ool30004Ool00`00Oomoo`1cOol00g`OOomoo`0TOol00g`OOomoo`0oOol00g`OOomoo`0SOol001]o
o`8007=oo`03O1moogoo02Eoo`03O1moogoo03moo`03O1moogoo02=oo`006goo00<007ooOol0LWoo
00=l7gooOol09Woo00=l7gooOol0?Goo00=l7gooOol097oo000KOol00`00Oomoo`1bOol00g`OOomo
o`0VOol00g`OOomoo`0mOol00g`OOomoo`0TOol001]oo`03001oogoo075oo`03O1moogoo02Moo`03
O1moogoo03eoo`03O1moogoo02Aoo`006goo0P00LWoo00=l7gooOol09goo00=l7gooOol0?Goo00=l
7gooOol097oo000KOol00`00Oomoo`1aOol00g`OOomoo`0WOol00g`OOomoo`0lOol00g`OOomoo`0U
Ool001]oo`03001oogoo071oo`03O1moogoo02Uoo`03O1moogoo03]oo`03O1moogoo02Eoo`006goo
00<007ooOol0L7oo00=l7gooOol0:Goo00=l7gooOol0>goo00=l7gooOol09Goo000KOol2001aOol0
0g`OOomoo`0YOol00g`OOomoo`0kOol00g`OOomoo`0UOol001]oo`03001oogoo06moo`03O1moogoo
02Yoo`03O1moogoo03Yoo`03O1moogoo02Ioo`006goo00<007ooOol0Kgoo00=l7gooOol0:Woo00=l
7gooOol0>Woo00=l7gooOol09Woo000KOol00`00Oomoo`1_Ool00g`OOomoo`0[Ool00g`OOomoo`0i
Ool00g`OOomoo`0VOol001]oo`03001oogoo06ioo`03O1moogoo02aoo`03O1moogoo03Uoo`03O1mo
ogoo02Ioo`006goo0P00Kgoo00=l7gooOol0;7oo00=l7gooOol0>7oo00=l7gooOol09goo000KOol0
0`00Oomoo`1^Ool00g`OOomoo`0/Ool00g`OOomoo`0hOol00g`OOomoo`0WOol000Moo`@000=oo`80
00Aoo`8000Eoo`03001oogoo06eoo`03O1moogoo02ioo`03O1moogoo03Moo`03O1moogoo02Moo`00
1goo00<007ooOol02Goo00@007ooOol000Aoo`03001oogoo06eoo`03O1moogoo02ioo`03O1moogoo
03Moo`03O1moogoo02Moo`0027oo00<007ooOol02goo00<007ooOol00Woo0P00KWoo00=l7gooOol0
;Woo00=l7gooOol0=Woo00=l7gooOol0:7oo00000goo000000020004Ool00`00Oomoo`08Ool20005
Ool00`00Oomoo`1]Ool00g`OOomoo`0^Ool00g`OOomoo`0fOol00g`OOomoo`0XOol000Moo`04001o
ogoo0009Ool00`00Oomoo`04Ool00`00Oomoo`1/Ool00g`OOomoo`0_Ool00g`OOomoo`0fOol00g`O
Oomoo`0XOol000Qoo`8000Yoo`<000Aoo`03001oogoo06aoo`03O1moogoo031oo`03O1moogoo03Eo
o`03O1moogoo02Qoo`006goo0P00KGoo00=l7gooOol0<7oo00=l7gooOol0=7oo00=l7gooOol0:Goo
000KOol00`00Oomoo`1[Ool00g`OOomoo`0aOol00g`OOomoo`0dOol00g`OOomoo`0YOol001]oo`03
001oogoo06]oo`03O1moogoo035oo`03O1moogoo03Aoo`03O1moogoo02Uoo`006goo00<007ooOol0
Jgoo00=l7gooOol0<Goo00=l7gooOol0=7oo00=l7gooOol0:Goo000KOol2001[Ool00g`OOomoo`0c
Ool00g`OOomoo`0bOol00g`OOomoo`0ZOol001]oo`03001oogoo06Yoo`03O1moogoo03=oo`03O1mo
ogoo039oo`03O1moogoo02Yoo`006goo00<007ooOol0<Goo0P0017oo0P0017oo0P00:goo00=l7goo
Ool017oo1@00:Woo00=l7gooOol017oo1@000Woo0P0017oo0P007goo00=l7gooOol047oo10005Woo
000KOol00`00Oomoo`0`Ool01000Oomoo`0027oo00@007ooOol002Uoo`03O1moogoo00Moo`03001o
ogoo02Yoo`03O1moogoo00Ioo`03001oogoo00Moo`04001oogoo000NOol00g`OOomoo`0@Ool00`00
Oomoo`0GOol001]oo`80035oo`04001oogoo000;Ool00`00Oomoo`0WOol00g`OOomoo`07Ool00`00
Oomoo`0ZOol00g`OOomoo`06Ool00`00Oomoo`0:Ool00`00Oomoo`0KOol00g`OOomoo`0BOol00`00
Oomoo`0FOol001]oo`03001oogoo031oo`04001oogoo0009Ool2000ZOol00g`OOomoo`07Ool00`00
Oomoo`0[Ool00g`OOomoo`05Ool00`00Oomoo`08Ool2000NOol00g`OOomoo`0COol00`00Oomoo`0E
Ool001]oo`03001oogoo031oo`04001oogoo0009Ool00`00Oomoo`0XOol00g`OOomoo`08Ool00`00
Oomoo`0[Ool00g`OOomoo`05Ool00`00Oomoo`08Ool00`00Oomoo`0MOol00g`OOomoo`0AOol01000
Oomoo`005Woo000KOol00`00Oomoo`0aOol2000:Ool3000XOol00g`OOomoo`07Ool2000]Ool00g`O
Oomoo`04Ool2000:Ool3000MOol00g`OOomoo`0BOol2000GOol001]oo`03001oogoo06Qoo`03O1mo
ogoo03Ioo`03O1moogoo02moo`03O1moogoo02aoo`006goo0P00J7oo00=l7gooOol0>7oo00=l7goo
Ool0;Woo00=l7gooOol0;7oo000KOol00`00Oomoo`1WOol00g`OOomoo`0hOol00g`OOomoo`0^Ool0
0g`OOomoo`0/Ool001]oo`03001oogoo06Ioo`03O1moogoo03Uoo`03O1moogoo02ioo`03O1moogoo
02Eoo`8000Eoo`006goo00<007ooOol0IWoo00=l7gooOol0>Goo00=l7gooOol0;Woo00=l7gooOol0
97oo00@007ooOol000Aoo`005Goo1P0000=l7`000000IP0000=l7`000000>@0000=l7`000000;@00
00=l7`00000070002Goo00<007ooOol01Goo000KOol00`00O1ml7`09Ool00`00Oomoo`08Ool00`00
Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00
Oomoo`09Ool00`00Oomoo`06Ool017`OOomoo`002Woo00<007ooOol02Goo00<007ooOol02Goo00<0
07ooOol02Goo00<007ooOol02Goo00=l7gooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<0
07ooOol027oo00=l7`00Ool02Goo00<007ooOol02Goo00<007ooOol037oo1@0017oo000KOol01000
Oomoog`OI7oo00=l7gooOol0>goo00=l7gooOol0;7oo00=l7gooOol09Goo00<007ooOol01Goo000K
Ool01000Oomoogoo0W`OHWoo00=l7gooOol0>goo00=l7gooOol0;7oo00=l7gooOol0;Goo000KOol2
0004Ool00g`OOomoo`1NOol00g`OOomoo`0lOol00g`OOomoo`0[Ool00g`OOomoo`0^Ool001]oo`03
001oogoo00Aoo`9l7eioo`03O1moogoo03aoo`03O1moogoo02]oo`03O1moogoo02ioo`006goo00<0
07ooOol01Woo00=l7gooOol0FWoo00=l7gooOol0?Woo00=l7gooOol0:Woo00=l7gooOol0;Woo000K
Ool00`00Oomoo`07Ool2O1mJOol00g`OOomoo`0nOol00g`OOomoo`0ZOol00g`OOomoo`0^Ool001]o
o`8000Yoo`03O1moogoo05Moo`03O1moogoo03ioo`03O1moogoo02Uoo`03O1moogoo02moo`006goo
00<007ooOol02Woo00=l7gooOol0EGoo00=l7gooOol0?goo00=l7gooOol0:Goo00=l7gooOol0;goo
000KOol00`00Oomoo`0:Ool00g`OOomoo`1EOol00g`OOomoo`0oOol00g`OOomoo`0YOol00g`OOomo
o`0_Ool001]oo`03001oogoo00]oo`03O1moogoo05Aoo`03O1moogoo041oo`03O1moogoo02Qoo`03
O1moogoo02moo`006goo0P0037oo00=l7gooOol0Dgoo00=l7gooOol0@Goo00=l7gooOol09goo00=l
7gooOol0<7oo000KOol00`00Oomoo`0<Ool00g`OOomoo`1BOol00g`OOomoo`11Ool00g`OOomoo`0W
Ool00g`OOomoo`0`Ool001]oo`03001oogoo00aoo`03O1moogoo055oo`03O1moogoo049oo`03O1mo
ogoo02Moo`03O1moogoo031oo`006goo00<007ooOol03Goo00=l7gooOol0D7oo00=l7gooOol0@Woo
00=l7gooOol09goo00=l7gooOol0<7oo000KOol00`00Oomoo`0>Ool00g`OOomoo`1?Ool00g`OOomo
o`13Ool00g`OOomoo`0UOol00g`OOomoo`0aOol001]oo`8000moo`03O1moogoo04ioo`03O1moogoo
04Aoo`03O1moogoo02Eoo`03O1moogoo035oo`006goo00<007ooOol03goo00=l7gooOol0CGoo00=l
7gooOol0A7oo00=l7gooOol09Goo00=l7gooOol0<Goo0007Ool40003Ool20004Ool20005Ool00`00
Oomoo`0?Ool00g`OOomoo`1=Ool00g`OOomoo`14Ool00g`OOomoo`0UOol00g`OOomoo`0aOol000Mo
o`03001oogoo00Uoo`04001oogoo0004Ool00`00Oomoo`0@Ool00g`OOomoo`1;Ool00g`OOomoo`15
Ool00g`OOomoo`0TOol00g`OOomoo`0bOol000Qoo`03001oogoo00]oo`03001oogoo009oo`80019o
o`03O1moogoo04Yoo`03O1moogoo04Ioo`03O1moogoo02=oo`03O1moogoo039oo`002Goo00<007oo
Ool027oo0P001Goo00<007ooOol04Goo00=l7gooOol0BGoo00=l7gooOol0Agoo00=l7gooOol08goo
00=l7gooOol0<Woo0007Ool01000Oomoo`002Goo00<007ooOol017oo00<007ooOol04Woo00=l7goo
Ool0B7oo00=l7gooOol0Agoo00=l7gooOol08goo00=l7gooOol0<Woo0008Ool2000:Ool30004Ool0
0`00Oomoo`0BOol00g`OOomoo`18Ool00g`OOomoo`17Ool00g`OOomoo`0SOol00g`OOomoo`0bOol0
01]oo`8001Aoo`03O1moogoo04Ioo`03O1moogoo04Qoo`03O1moogoo029oo`03O1moogoo03=oo`00
6goo00<007ooOol04goo00=l7gooOol0AWoo00=l7gooOol0BGoo00=l7gooOol08Goo00=l7gooOol0
<goo000KOol00`00Oomoo`0DOol00g`OOomoo`14Ool00g`OOomoo`1:Ool00g`OOomoo`0QOol00g`O
Oomoo`0cOol001]oo`03001oogoo01Eoo`03O1moogoo04=oo`03O1moogoo04Yoo`03O1moogoo025o
o`03O1moogoo03=oo`006goo0P005Woo00=l7gooOol0@Woo00=l7gooOol0Bgoo00=l7gooOol087oo
00=l7gooOol0=7oo000KOol00`00Oomoo`0FOol00g`OOomoo`11Ool00g`OOomoo`1;Ool00g`OOomo
o`0POol00g`OOomoo`0dOol001]oo`03001oogoo01Moo`03O1moogoo03moo`03O1moogoo04eoo`03
O1moogoo01moo`03O1moogoo03Aoo`006goo00<007ooOol05goo00=l7gooOol0?goo00=l7gooOol0
CGoo00=l7gooOol07goo00=l7gooOol0=7oo000KOol00`00Oomoo`0HOol00g`OOomoo`0mOol00g`O
Oomoo`1>Ool00g`OOomoo`0NOol00g`OOomoo`0eOol001]oo`8001Uoo`03O1moogoo03eoo`03O1mo
ogoo04ioo`03O1moogoo01ioo`03O1moogoo03Eoo`006goo00<007ooOol06Goo00=l7gooOol0>goo
00=l7gooOol0D7oo00=l7gooOol07Goo00=l7gooOol0=Goo000KOol00`00Oomoo`0JOol00g`OOomo
o`0jOol00g`OOomoo`1@Ool00g`OOomoo`0MOol00g`OOomoo`0eOol001]oo`03001oogoo01Yoo`03
O1moogoo03Uoo`03O1moogoo055oo`03O1moogoo01aoo`03O1moogoo03Ioo`006goo0P0077oo00=l
7gooOol0>7oo00=l7gooOol0DGoo00=l7gooOol077oo00=l7gooOol0=Woo000KOol00`00Oomoo`0L
Ool00g`OOomoo`0fOol00g`OOomoo`1BOol00g`OOomoo`0LOol00g`OOomoo`0fOol001Aoo`8000Eo
o`03001oogoo01aoo`03O1moogoo03Ioo`03O1moogoo05=oo`03O1moogoo01]oo`03O1moogoo03Io
o`004goo00@007ooOol000Aoo`03001oogoo01eoo`03O1moogoo03Aoo`03O1moogoo05Aoo`03O1mo
ogoo01Yoo`03O1moogoo03Moo`005Woo00<007ooOol00Woo0P007Woo00=l7gooOol0=7oo00=l7goo
Ool0E7oo00=l7gooOol06Woo00=l7gooOol0=goo000DOol20005Ool00`00Oomoo`0NOol00g`OOomo
o`0bOol00g`OOomoo`1EOol00g`OOomoo`0JOol00g`OOomoo`0gOol001Aoo`03001oogoo00Aoo`03
001oogoo01moo`03O1moogoo035oo`03O1moogoo05Eoo`03O1moogoo01Yoo`03O1moogoo03Moo`00
57oo0`0017oo00<007ooOol07goo00=l7gooOol0<7oo00=l7gooOol0Egoo00=l7gooOol067oo00=l
7gooOol0>7oo000KOol2000QOol00g`OOomoo`0_Ool00g`OOomoo`1GOol00g`OOomoo`0HOol00g`O
Oomoo`0hOol001]oo`03001oogoo025oo`03O1moogoo02eoo`03O1moogoo05Qoo`03O1moogoo01Qo
o`03O1moogoo03Qoo`006goo00<007ooOol08Woo00=l7gooOol0;7oo00=l7gooOol0F7oo00=l7goo
Ool067oo00=l7gooOol0>7oo000KOol00`00Oomoo`0SOol00g`OOomoo`0ZOol00g`OOomoo`1IOol0
0g`OOomoo`0GOol00g`OOomoo`0iOol001]oo`8002Eoo`03O1moogoo02Qoo`03O1moogoo05]oo`03
O1moogoo01Ioo`03O1moogoo03Uoo`006goo00<007ooOol09Goo00=l7gooOol09Woo00=l7gooOol0
G7oo00=l7gooOol05Goo00=l7gooOol0>Woo000KOol00`00Oomoo`0VOol2O1lUOol00g`OOomoo`1M
Ool00g`OOomoo`0EOol00g`OOomoo`0jOol001]oo`03001oogoo02Qoo`03O1moogoo025oo`03O1mo
ogoo05ioo`03O1moogoo01Aoo`03O1moogoo03]oo`006goo00<007ooOol0:Goo00=l7gooOol07goo
00=l7gooOol0Ggoo00=l7gooOol057oo00=l7gooOol0>goo000KOol2000[Ool00g`OOomoo`0MOol0
0g`OOomoo`1QOol00g`OOomoo`0COol00g`OOomoo`0kOol001]oo`03001oogoo02]oo`03O1moogoo
01aoo`03O1moogoo065oo`03O1moogoo019oo`03O1moogoo03aoo`006goo00<007ooOol0;7oo0W`O
6goo00=l7gooOol0HWoo00=l7gooOol04Woo00=l7gooOol0?7oo000KOol00`00Oomoo`0^Ool2O1lH
Ool00g`OOomoo`1SOol00g`OOomoo`0AOol00g`OOomoo`0mOol001]oo`80035oo`9l7aEoo`03O1mo
ogoo06Aoo`03O1moogoo015oo`03O1moogoo03eoo`006goo00<007ooOol0<Woo0g`O4Goo00=l7goo
Ool0IWoo00=l7gooOol03goo00=l7gooOol0?Woo0009Ool00`00Oomoo`02Ool20004Ool20005Ool0
0`00Oomoo`0eOol2O1l>Ool00g`OOomoo`1WOol00g`OOomoo`0?Ool00g`OOomoo`0nOol000Uoo`03
001oogoo00Moo`04001oogoo0004Ool00`00Oomoo`0gOol>O1mZOol00g`OOomoo`0?Ool00g`OOomo
o`0nOol000Uoo`03001oogoo00Yoo`03001oogoo009oo`800;5oo`03O1moogoo00eoo`03O1moogoo
03moo`002Woo00<007ooOol01goo0P001Goo00<007ooOol0/Goo00=l7gooOol037oo00=l7gooOol0
?goo0007Ool01000Oomoo`002Goo00<007ooOol017oo00<007ooOol0/Woo00=l7gooOol02Woo00=l
7gooOol0@7oo0007Ool40009Ool30004Ool00`00Oomoo`2cOol00g`OOomoo`09Ool00g`OOomoo`10
Ool001]oo`800;Eoo`03O1moogoo00Moo`03O1moogoo045oo`006goo00<007ooOol0]Goo00=l7goo
Ool01Woo00=l7gooOol0@Goo000KOol00`00Oomoo`2eOol00g`OOomoo`06Ool00g`OOomoo`11Ool0
01]oo`03001oogoo0;Ioo`03O1moogoo00Aoo`03O1moogoo049oo`006goo00<007ooOol0]goo00=l
7gooOol00goo00=l7gooOol0@Woo000KOol2002iOol01G`OOomoogooO1l0AGoo000KOol00`00Oomo
o`2iOol017`OOomoog`OAGoo000KOol00`00Oomoo`2jOol2O1m6Ool001]oo`03001oogoo0;]oo`03
O1moogoo04Aoo`006goo0P00ogoo17oo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?mo
o`=oo`006goo00<007ooOol0ogoo0goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?mo
ob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol001Yoo`800?moo`Eoo`00
6Woo0P00ogoo1Goo000IOol01000Oomoo`00ogoo17oo000HOol20002Ool2003oOol3Ool00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.228198, -9.15414, \
0.00841412, 0.118478}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.288618 0.00422204 [
[.2619 .27612 -9 -9 ]
[.2619 .27612 9 0 ]
[.5 .27612 -3 -9 ]
[.5 .27612 3 0 ]
[.7381 .27612 -9 -9 ]
[.7381 .27612 9 0 ]
[.97619 .27612 -3 -9 ]
[.97619 .27612 3 0 ]
[1.025 .28862 0 -6.25 ]
[1.025 .28862 10 6.25 ]
[.01131 .0353 -18 -4.5 ]
[.01131 .0353 0 4.5 ]
[.01131 .11974 -18 -4.5 ]
[.01131 .11974 0 4.5 ]
[.01131 .20418 -18 -4.5 ]
[.01131 .20418 0 4.5 ]
[.01131 .37306 -12 -4.5 ]
[.01131 .37306 0 4.5 ]
[.01131 .4575 -12 -4.5 ]
[.01131 .4575 0 4.5 ]
[.01131 .54194 -12 -4.5 ]
[.01131 .54194 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .28862 m
.2619 .29487 L
s
[(0.5)] .2619 .27612 0 1 Mshowa
.5 .28862 m
.5 .29487 L
s
[(1)] .5 .27612 0 1 Mshowa
.7381 .28862 m
.7381 .29487 L
s
[(1.5)] .7381 .27612 0 1 Mshowa
.97619 .28862 m
.97619 .29487 L
s
[(2)] .97619 .27612 0 1 Mshowa
.125 Mabswid
.07143 .28862 m
.07143 .29237 L
s
.11905 .28862 m
.11905 .29237 L
s
.16667 .28862 m
.16667 .29237 L
s
.21429 .28862 m
.21429 .29237 L
s
.30952 .28862 m
.30952 .29237 L
s
.35714 .28862 m
.35714 .29237 L
s
.40476 .28862 m
.40476 .29237 L
s
.45238 .28862 m
.45238 .29237 L
s
.54762 .28862 m
.54762 .29237 L
s
.59524 .28862 m
.59524 .29237 L
s
.64286 .28862 m
.64286 .29237 L
s
.69048 .28862 m
.69048 .29237 L
s
.78571 .28862 m
.78571 .29237 L
s
.83333 .28862 m
.83333 .29237 L
s
.88095 .28862 m
.88095 .29237 L
s
.92857 .28862 m
.92857 .29237 L
s
.25 Mabswid
0 .28862 m
1 .28862 L
s
gsave
1.025 .28862 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .0353 m
.03006 .0353 L
s
[(-60)] .01131 .0353 1 0 Mshowa
.02381 .11974 m
.03006 .11974 L
s
[(-40)] .01131 .11974 1 0 Mshowa
.02381 .20418 m
.03006 .20418 L
s
[(-20)] .01131 .20418 1 0 Mshowa
.02381 .37306 m
.03006 .37306 L
s
[(20)] .01131 .37306 1 0 Mshowa
.02381 .4575 m
.03006 .4575 L
s
[(40)] .01131 .4575 1 0 Mshowa
.02381 .54194 m
.03006 .54194 L
s
[(60)] .01131 .54194 1 0 Mshowa
.125 Mabswid
.02381 .05641 m
.02756 .05641 L
s
.02381 .07752 m
.02756 .07752 L
s
.02381 .09863 m
.02756 .09863 L
s
.02381 .14085 m
.02756 .14085 L
s
.02381 .16196 m
.02756 .16196 L
s
.02381 .18307 m
.02756 .18307 L
s
.02381 .22529 m
.02756 .22529 L
s
.02381 .2464 m
.02756 .2464 L
s
.02381 .26751 m
.02756 .26751 L
s
.02381 .30973 m
.02756 .30973 L
s
.02381 .33084 m
.02756 .33084 L
s
.02381 .35195 m
.02756 .35195 L
s
.02381 .39417 m
.02756 .39417 L
s
.02381 .41528 m
.02756 .41528 L
s
.02381 .43639 m
.02756 .43639 L
s
.02381 .47861 m
.02756 .47861 L
s
.02381 .49972 m
.02756 .49972 L
s
.02381 .52083 m
.02756 .52083 L
s
.02381 .01419 m
.02756 .01419 L
s
.02381 .56305 m
.02756 .56305 L
s
.02381 .58416 m
.02756 .58416 L
s
.02381 .60527 m
.02756 .60527 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .28862 m
.07143 .36859 L
.11905 .39618 L
.16667 .36153 L
.21429 .30793 L
.2619 .31896 L
.30952 .25428 L
.35714 .19789 L
.40476 .14874 L
.45238 .10588 L
.5 .13539 L
.54762 .24455 L
.59524 .24426 L
.64286 .53629 L
.69048 .60332 L
.7381 .46116 L
.78571 .22948 L
.83333 .05057 L
.88095 .01472 L
.92857 .12783 L
.97619 .31604 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00O5Goo00<007ooOol0
ogoo2Goo000EOol00`00Oomoo`3oOol9Ool001Eoo`03001oogoo0?moo`Uoo`005Goo0P00fGoo00<0
7gooOol0;Goo000EOol00`00Oomoo`3GOol201l_Ool001Eoo`03001oogoo0=Ioo`0401moogoo01l^
Ool001Eoo`03001oogoo0=Aoo`807`=oo`0301moogoo02aoo`001goo0`0017oo0P001Goo00<007oo
Ool0dgoo00<07gooOol017oo00<07gooOol0:goo0007Ool01000Oomoo`000Woo00@007ooOol000Ao
o`03001oogoo0=9oo`0301moogoo00Eoo`0301moogoo02]oo`001goo00@007ooOol0009oo`04001o
ogoo0004Ool2003BOol00`0OOomoo`06Ool00`0OOomoo`0[Ool00003Ool000000080009oo`<000=o
o`04001oogoo0004Ool00`00Oomoo`3@Ool00`0OOomoo`08Ool00`0OOomoo`0ZOol000Qoo`03001o
ogoo009oo`04001oogoo0004Ool00`00Oomoo`3>Ool201l;Ool00`0OOomoo`0ZOol000Qoo`<000=o
o`8000Eoo`03001oogoo0<eoo`0301moogoo00aoo`0301moogoo02Uoo`005Goo00<007ooOol0c7oo
00<07gooOol03Goo00<07gooOol0:Goo000EOol2003=Ool00`0OOomoo`0>Ool00`0OOomoo`0XOol0
01Eoo`03001oogoo0<]oo`0301moogoo00moo`0301moogoo02Qoo`005Goo00<007ooOol0bgoo00<0
7gooOol03goo00<07gooOol0:7oo000EOol00`00Oomoo`3;Ool00`0OOomoo`0@Ool00`0OOomoo`0W
Ool001Eoo`03001oogoo0<]oo`0301moogoo011oo`0301moogoo02Moo`005Goo0P00bgoo00<07goo
Ool04Woo00<07gooOol09Woo000EOol00`00Oomoo`3:Ool00`0OOomoo`0BOol00`0OOomoo`0VOol0
01Eoo`03001oogoo0<Yoo`0301moogoo019oo`0301moogoo02Ioo`005Goo00<007ooOol0bGoo00<0
7gooOol057oo00<07gooOol09Goo000EOol00`00Oomoo`39Ool00`0OOomoo`0DOol00`0OOomoo`0U
Ool001Eoo`03001oogoo0<Uoo`0301moogoo01Eoo`0301moogoo02Aoo`005Goo0P00bWoo00<07goo
Ool05Goo00<07gooOol097oo000EOol00`00Oomoo`38Ool00`0OOomoo`0GOol00`0OOomoo`0SOol0
01Eoo`03001oogoo06Yoo`0301moogoo05]oo`0301moogoo01Moo`0301moogoo02=oo`002Goo0`00
0Woo0P001Goo00<007ooOol0JGoo00@07goo01l07e]oo`0301moogoo01Moo`0301moogoo02=oo`00
2Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo06Qoo`0301moogoo009oo`807eQoo`03
01moogoo01Uoo`0301moogoo029oo`001goo1@0000Eoo`00Oomoo`0000Aoo`8006Qoo`0301moogoo
00Eoo`0301moogoo05Eoo`0301moogoo01Uoo`0301moogoo029oo`0000=oo`0000000P000Woo00@0
07ooOol0009oo`04001oogoo0004Ool00`00Oomoo`1VOol00`0OOomoo`07Ool201mEOol00`0OOomo
o`0JOol00`0OOomoo`0QOol000Qoo`03001oo`00009oo`04001oogoo0004Ool00`00Oomoo`1UOol0
0`0OOomoo`0:Ool201mCOol00`0OOomoo`0JOol00`0OOomoo`0QOol000Uoo`8000=oo`8000Eoo`03
001oogoo06=oo`807`moo`807e1oo`0301moogoo01]oo`0301moogoo025oo`005Goo00<007ooOol0
HWoo00<07gooOol04Goo00<07gooOol0CGoo00<07gooOol077oo00<07gooOol087oo000EOol00`00
Oomoo`1QOol00`0OOomoo`0BOol00`0OOomoo`1=Ool00`0OOomoo`0LOol00`0OOomoo`0POol001Eo
o`80065oo`0301moogoo01Aoo`0301moogoo04]oo`0301moogoo01eoo`0301moogoo021oo`005Goo
00<007ooOol0Ggoo00<07gooOol05Goo00<07gooOol0Bgoo00<07gooOol07Goo00<07gooOol087oo
000EOol00`00Oomoo`1NOol00`0OOomoo`0GOol00`0OOomoo`1:Ool00`0OOomoo`0NOol00`0OOomo
o`0OOol001Eoo`03001oogoo05eoo`0301moogoo01Qoo`0301moogoo04Uoo`0301moogoo01moo`03
01moogoo01moo`005Goo00<007ooOol0G7oo00<07gooOol06Woo00<07gooOol0B7oo00<07gooOol0
7goo00<07gooOol07goo000EOol2001LOol00`0OOomoo`0KOol00`0OOomoo`18Ool00`0OOomoo`0O
Ool00`0OOomoo`0OOol001Eoo`03001oogoo05Yoo`0301moogoo01eoo`0301moogoo04Moo`0301mo
ogoo021oo`0301moogoo01ioo`005Goo00<007ooOol0FGoo00<07gooOol07Woo00<07gooOol0AWoo
00<07gooOol08Goo00<07gooOol07Woo000EOol00`00Oomoo`1HOol00`0OOomoo`0POol00`0OOomo
o`15Ool00`0OOomoo`0QOol00`0OOomoo`0NOol001Eoo`03001oogoo05Moo`0301moogoo025oo`03
01moogoo04Eoo`0301moogoo025oo`0301moogoo01ioo`005Goo0P00Egoo00<07gooOol08goo00<0
7gooOol0@goo00<07gooOol08goo00<07gooOol07Goo000EOol00`00Oomoo`1EOol00`0OOomoo`0T
Ool00`0OOomoo`13Ool00`0OOomoo`0SOol00`0OOomoo`0MOol001Eoo`03001oogoo05Aoo`0301mo
ogoo02Ioo`0301moogoo049oo`0301moogoo02=oo`0301moogoo01eoo`005Goo00<007ooOol0Dgoo
00<07gooOol09goo00<07gooOol0@Woo00<07gooOol08goo00<07gooOol07Goo0007Ool40003Ool2
0005Ool00`00Oomoo`1BOol00`0OOomoo`0XOol00`0OOomoo`11Ool00`0OOomoo`0UOol00`0OOomo
o`0LOol000Moo`03001oogoo00=oo`04001oogoo0004Ool00`00Oomoo`1AOol00`0OOomoo`0ZOol0
0`0OOomoo`10Ool00`0OOomoo`0UOol00`0OOomoo`0LOol000Qoo`03001oogoo009oo`04001oogoo
0004Ool2001AOol00`0OOomoo`0[Ool00`0OOomoo`10Ool00`0OOomoo`0UOol00`0OOomoo`0LOol0
0003Ool00000008000Aoo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`1@Ool00`0O
Oomoo`0/Ool00`0OOomoo`0nOol00`0OOomoo`0VOol00`0OOomoo`0LOol000Moo`04001oogoo0002
Ool01000Oomoo`0017oo00<007ooOol0Cgoo00<07gooOol0;Goo00<07gooOol0?Woo00<07gooOol0
9goo00<07gooOol06goo0008Ool20004Ool20005Ool00`00Oomoo`1>Ool00`0OOomoo`0_Ool00`0O
Oomoo`0mOol00`0OOomoo`0WOol00`0OOomoo`0KOol001Eoo`03001oogoo04eoo`0301moogoo031o
o`0301moogoo03eoo`0301moogoo02Moo`0301moogoo01]oo`005Goo0P00CGoo00<07gooOol0<Woo
00<07gooOol0>goo00<07gooOol0:7oo00<07gooOol06goo000EOol00`00Oomoo`1<Ool00`0OOomo
o`0bOol00`0OOomoo`0kOol00`0OOomoo`0YOol00`0OOomoo`0JOol001Eoo`03001oogoo04]oo`03
01moogoo03Aoo`0301moogoo03Yoo`0301moogoo02Uoo`0301moogoo01Yoo`005Goo00<007ooOol0
BWoo00<07gooOol0=Goo00<07gooOol0>Woo00<07gooOol0:Goo00<07gooOol06Woo000EOol00`00
Oomoo`19Ool00`0OOomoo`0gOol00`0OOomoo`0hOol00`0OOomoo`0ZOol00`0OOomoo`0JOol001Eo
o`03001oogoo03=oo`8000Aoo`8000Aoo`8000Moo`0301moogoo02Uoo`D000Yoo`d07a]oo`D0009o
o`8000Aoo`8000Aoo`0301moogoo02]oo`0301moo`0000<001Ioo`005Goo0P00<goo00@007ooOol0
00Qoo`04001oogoo0006Ool00`0OOomoo`0[Ool00`00Oomoo`0FOol00`0OOomoo`0KOol00`00Oomo
o`07Ool01000Oomoo`000goo00<07gooOol0:goo00<07goo00006Goo000EOol00`00Oomoo`0bOol0
1000Oomoo`002goo00<007ooOol00goo00<07gooOol0;7oo00<007ooOol05Woo00<07gooOol06goo
00<007ooOol02Woo00D007ooOomoo`0O02eoo`0401moogoo000HOol001Eoo`03001oogoo039oo`04
001oogoo0009Ool20005Ool00`0OOomoo`0]Ool00`00Oomoo`0FOol00`0OOomoo`0KOol00`00Oomo
o`08Ool20004Ool00`0OOomoo`0[Ool01@0OOomoogoo00005goo000EOol00`00Oomoo`0bOol01000
Oomoo`002Goo00<007ooOol00goo00<07gooOol0;Woo00<007ooOol05goo00<07gooOol06Woo00<0
07ooOol027oo00<007ooOol00Woo00<07gooOol0;Goo00D07`00Oomoo`0001Ioo`005Goo00<007oo
Ool0<goo0P002Woo0`000Woo00<07gooOol0;Woo0P006Goo00<07gooOol06Goo0P002Woo0`000Woo
00<07gooOol0;Goo00@07goo000001Moo`005Goo0P00AGoo00<07gooOol0BGoo00<07gooOol0:Woo
00<07gooOol0;Goo00<07gooOol067oo000EOol00`00Oomoo`13Ool00`0OOomoo`1:Ool00`0OOomo
o`0ZOol00`0OOomoo`0]Ool00`0OOomoo`0HOol001Eoo`03001oogoo049oo`0301moogoo04]oo`03
01moogoo02Yoo`0301moogoo02ioo`0301moogoo01Moo`005Goo00<007ooOol0@Goo00<07gooOol0
C7oo00<07gooOol0:Goo00<07gooOol0;goo00<07gooOol05goo000EOol00`00Oomoo`11Ool00`0O
Oomoo`1=Ool00`0OOomoo`0XOol00`0OOomoo`0_Ool00`0OOomoo`0@Ool20005Ool000moo`H00003
01l000000400000301l0000004h0000301l0000002P0000301l0000002l0000301l0000000H000Uo
o`04001oogoo0004Ool001Eoo`0300007goo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001o
ogoo00Uoo`03001oogoo00Yoo`03001oogoo009oo`0301moogoo00Aoo`03001oogoo00Uoo`03001o
ogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001o
o`0O00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Ioo`0401moogoo000<Ool00`00
Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`0O001oo`0>Ool00`00Oomoo`05Ool001Eo
o`0300007goo03Yoo`05001oogooOol07`0gOol00`00Oomoo`0HOol00`0OOomoo`0OOol00`00Oomo
o`06Ool00`0OOomoo`0`Ool00`0O001oo`0=Ool50004Ool001Eoo`03001oo`0O03ioo`0301moogoo
051oo`0301moogoo02Moo`0301moogoo035oo`0301moogoo00ioo`03001oogoo00Eoo`005Goo00<0
07oo01l0?Goo00<07gooOol0DGoo00<07gooOol09goo00<07gooOol0<Goo00<07gooOol05Woo000E
Ool01000Oomoo`0O;7oo0`0O37oo00<07gooOol0Dgoo00<07gooOol09Woo00<07gooOol0<Woo00<0
7gooOol05Goo000EOol200000goo01moo`0ZOol0100OOomoogoo100O1goo00<07gooOol0E7oo00<0
7gooOol09Woo00<07gooOol0<Woo00<07gooOol05Goo000EOol01@00Oomoogoo01l0:Goo00<07goo
Ool01Woo100O0goo00<07gooOol0E7oo00<07gooOol09Woo00<07gooOol0<Woo00<07gooOol05Goo
000EOol00`00Oomoo`02Ool00`0OOomoo`0UOol00`0OOomoo`0;Ool301mGOol00`0OOomoo`0UOol0
0`0OOomoo`1;Ool001Eoo`03001oogoo009oo`0301moogoo02Eoo`0301moogoo06Eoo`0301moogoo
02Eoo`0301moogoo04]oo`005Goo00<007ooOol00goo00<07gooOol08goo00<07gooOol0IWoo00<0
7gooOol09Goo00<07gooOol0Bgoo000EOol20004Ool00`0OOomoo`0ROol00`0OOomoo`1XOol00`0O
Oomoo`0TOol00`0OOomoo`1;Ool001Eoo`03001oogoo00Aoo`0301moogoo021oo`0301moogoo06Uo
o`0301moogoo02Aoo`0301moogoo04]oo`005Goo00<007ooOol017oo00<07gooOol07goo00<07goo
Ool0JWoo00<07gooOol08goo00<07gooOol0C7oo000EOol00`00Oomoo`05Ool00`0OOomoo`0MOol0
0`0OOomoo`1[Ool00`0OOomoo`0SOol00`0OOomoo`1<Ool001Eoo`03001oogoo00Ioo`0301moogoo
01]oo`0301moogoo06aoo`0301moogoo02=oo`0301moogoo04aoo`005Goo00<007ooOol01Woo00<0
7gooOol06goo00<07gooOol0K7oo00<07gooOol08goo00<07gooOol0C7oo000EOol20008Ool00`0O
Oomoo`0IOol00`0OOomoo`1]Ool00`0OOomoo`0ROol00`0OOomoo`1=Ool001Eoo`03001oogoo00Mo
o`0301moogoo01Qoo`0301moogoo06moo`0301moogoo025oo`0301moogoo04eoo`005Goo00<007oo
Ool027oo00<07gooOol05Woo00<07gooOol0L7oo00<07gooOol08Goo00<07gooOol0CGoo0007Ool4
0003Ool20005Ool00`00Oomoo`08Ool00`0OOomoo`0EOol00`0OOomoo`1aOol00`0OOomoo`0QOol0
0`0OOomoo`1=Ool000Moo`03001oogoo00=oo`04001oogoo0004Ool00`00Oomoo`09Ool00`0OOomo
o`0BOol201mdOol00`0OOomoo`0QOol00`0OOomoo`1=Ool000Qoo`03001oogoo009oo`04001oogoo
0004Ool2000;Ool201lAOol00`0OOomoo`1dOol00`0OOomoo`0POol00`0OOomoo`1>Ool000Uoo`05
001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`0<Ool201l>Ool00`0OOomoo`1eOol00`0O
Oomoo`0POol00`0OOomoo`1>Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol0
3Woo00<07gooOol02Goo0P0ONGoo00<07gooOol07goo00<07gooOol0CWoo0008Ool20004Ool20005
Ool00`00Oomoo`0?Ool201l8Ool00`0OOomoo`1iOol00`0OOomoo`0OOol00`0OOomoo`1>Ool001Eo
o`03001oogoo015oo`807`Eoo`0301moogoo07Yoo`0301moogoo01moo`0301moogoo04ioo`005Goo
0P0057oo0P0O00=oo`0O01l0OGoo00<07gooOol07Woo00<07gooOol0Cgoo000EOol00`00Oomoo`0E
Ool00`0OOomoo`1mOol00`0OOomoo`0NOol00`0OOomoo`1?Ool001Eoo`03001oogoo09Eoo`0301mo
ogoo01ioo`0301moogoo04moo`005Goo00<007ooOol0UWoo00<07gooOol07Goo00<07gooOol0Cgoo
000EOol00`00Oomoo`2FOol00`0OOomoo`0MOol00`0OOomoo`1?Ool001Eoo`03001oogoo09Ioo`03
01moogoo01aoo`0301moogoo051oo`005Goo0P00Ugoo00<07gooOol077oo00<07gooOol0D7oo000E
Ool00`00Oomoo`2FOol00`0OOomoo`0LOol00`0OOomoo`1@Ool001Eoo`03001oogoo09Ioo`0301mo
ogoo01aoo`0301moogoo051oo`005Goo00<007ooOol0Ugoo00<07gooOol06goo00<07gooOol0D7oo
000EOol00`00Oomoo`2GOol00`0OOomoo`0JOol00`0OOomoo`1AOol001Eoo`8009Qoo`0301moogoo
01Yoo`0301moogoo055oo`005Goo00<007ooOol0Ugoo00<07gooOol06Woo00<07gooOol0DGoo000E
Ool00`00Oomoo`2GOol00`0OOomoo`0JOol00`0OOomoo`1AOol001Eoo`03001oogoo09Moo`0301mo
ogoo01Yoo`0301moogoo055oo`002Goo0`000Woo0P001Goo00<007ooOol0Ugoo00<07gooOol06Goo
00<07gooOol0DWoo000:Ool01000Oomoo`000Woo00<007ooOol00Woo00<007ooOol0V7oo00<07goo
Ool067oo00<07gooOol0DWoo0007Ool500001Goo001oogoo000017oo0P00VGoo00<07gooOol067oo
00<07gooOol0DWoo0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo09Qoo`0301mo
ogoo01Qoo`0301moogoo059oo`0027oo00<007oo00000Woo00@007ooOol000Aoo`03001oogoo09Qo
o`0301moogoo01Moo`0301moogoo05=oo`002Goo0P000goo0P001Goo00<007ooOol0V7oo00<07goo
Ool05goo00<07gooOol0Dgoo000EOol00`00Oomoo`2HOol00`0OOomoo`0GOol00`0OOomoo`1COol0
01Eoo`8009Yoo`0301moogoo01Eoo`0301moogoo05Aoo`005Goo00<007ooOol0VGoo00<07gooOol0
5Goo00<07gooOol0E7oo000EOol00`00Oomoo`2IOol00`0OOomoo`0EOol00`0OOomoo`1DOol001Eo
o`03001oogoo09Uoo`0301moogoo01Aoo`0301moogoo05Eoo`005Goo00<007ooOol0VGoo00<07goo
Ool057oo00<07gooOol0EGoo000EOol2002JOol00`0OOomoo`0DOol00`0OOomoo`1EOol001Eoo`03
001oogoo09Yoo`0301moogoo019oo`0301moogoo05Ioo`005Goo00<007ooOol0VWoo00<07gooOol0
4Woo00<07gooOol0EWoo000EOol00`00Oomoo`2JOol00`0OOomoo`0BOol00`0OOomoo`1FOol001Eo
o`03001oogoo09Yoo`0301moogoo015oo`0301moogoo05Moo`005Goo00<007ooOol0VWoo00<07goo
Ool04Goo00<07gooOol0Egoo000EOol2002KOol00`0OOomoo`0AOol00`0OOomoo`1GOol001Eoo`03
001oogoo09]oo`0301moogoo00moo`0301moogoo05Qoo`005Goo00<007ooOol0Vgoo00<07gooOol0
3goo00<07gooOol0F7oo0007Ool30004Ool20005Ool00`00Oomoo`2KOol00`0OOomoo`0?Ool00`0O
Oomoo`1HOol000Moo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol0Vgoo00<07gooOol0
3goo00<07gooOol0F7oo0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`8009eoo`0301moogoo
00eoo`0301moogoo05Uoo`001goo0`000goo00@007ooOol000Aoo`03001oogoo09aoo`0301moogoo
00eoo`0301moogoo05Uoo`0027oo00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo09eoo`03
01moogoo00aoo`0301moogoo05Uoo`0027oo0`000goo0P001Goo00<007ooOol0WWoo00<07gooOol0
2Woo00<07gooOol0FWoo000EOol00`00Oomoo`2OOol00`0OOomoo`09Ool00`0OOomoo`1JOol001Eo
o`800:1oo`0301moogoo00Uoo`0301moogoo05Yoo`005Goo00<007ooOol0X7oo00<07gooOol01goo
00<07gooOol0Fgoo000EOol00`00Oomoo`2QOol00`0OOomoo`06Ool00`0OOomoo`1KOol001Eoo`03
001oogoo0:5oo`0301moogoo00Ioo`0301moogoo05]oo`005Goo00<007ooOol0XWoo00<07gooOol0
17oo00<07gooOol0G7oo000EOol00`00Oomoo`2SOol00`0OOomoo`03Ool00`0OOomoo`1LOol001Eo
o`800:Aoo`0301moogoo00=oo`0301moogoo05aoo`005Goo00<007ooOol0Y7oo00D07gooOomoo`0O
05moo`005Goo00<007ooOol0YGoo00@07gooOol07emoo`005Goo00<007ooOol0YWoo00<07goo01l0
Ggoo000EOol00`00Oomoo`2VOol201mPOol001Eoo`800:Qoo`0301moogoo05ioo`005Goo00<007oo
Ool0ogoo2Goo000EOol00`00Oomoo`3oOol9Ool001Eoo`03001oogoo0?moo`Uoo`005Goo00<007oo
Ool0ogoo2Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol00?moob5oo`00ogoo8Goo003oOolQOol001=oo`D00?moo`Uoo`004goo1000ogoo2Woo000F
Ool00`00Oomoo`3oOol8Ool001Aoo`<00?moo`Yoo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo
8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.174205, -68.4264, \
0.0082192, 0.927016}}],

Cell[BoxData[
    InterpretationBox[\("t"\[InvisibleSpace]"         "\[InvisibleSpace]"p    \
     "\[InvisibleSpace]"u"\[InvisibleSpace]"          \
v"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]"         a"\),
      SequenceForm[ 
      "t", "         ", "p         ", "u", "          v", "", "         a"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("----------------------------------------------------"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        InterpretationBox[GridBox[{
              {"0"},
              {"0.1`"},
              {"0.2`"},
              {"0.30000000000000004`"},
              {"0.4`"},
              {"0.5`"},
              {"0.6000000000000001`"},
              {"0.7000000000000001`"},
              {"0.8`"},
              {"0.9`"},
              {"1.`"},
              {"1.1`"},
              {"1.2000000000000002`"},
              {"1.3`"},
              {"1.4000000000000001`"},
              {"1.5`"},
              {"1.6`"},
              {"1.7000000000000002`"},
              {"1.8`"},
              {"1.9000000000000001`"},
              {"2.`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0, 1.1000000000000001, 
            1.2000000000000002, 1.3, 1.4000000000000001, 1.5, 
            1.6000000000000001, 1.7000000000000002, 1.8, 1.9000000000000001, 
            2.0}]], "\[InvisibleSpace]", "\<\"     \"\>", "\[InvisibleSpace]",
         
        InterpretationBox[GridBox[{
              {"0"},
              {"4.444444444444443`"},
              {"8.88888888888889`"},
              {"13.333333333333336`"},
              {"17.77777777777778`"},
              {"18.461538461538463`"},
              {"15.384615384615383`"},
              {"12.307692307692307`"},
              {"9.230769230769232`"},
              {"6.153846153846157`"},
              {"3.07692307692308`"},
              {"0"},
              {\(-9.99999999999999`\)},
              {\(-4.999999999999994`\)},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 4.4444444444444429, 8.8888888888888893, 
            13.333333333333336, 17.777777777777779, 18.461538461538463, 
            15.384615384615383, 12.307692307692307, 9.2307692307692317, 
            6.1538461538461569, 3.0769230769230802, 
            0, -9.9999999999999893, -4.9999999999999938, 0, 0, 0, 0, 0, 0, 
            0}]], "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"0.031897545091056974`"},
              {"0.2352821170291642`"},
              {"0.6775989034933538`"},
              {"1.3006496117364232`"},
              {"2.007780760066904`"},
              {"2.7568968633906916`"},
              {"3.427961364538916`"},
              {"3.886998517748263`"},
              {"4.017210562439858`"},
              {"3.7431706537715854`"},
              {"3.1313457802135396`"},
              {"2.3513137229497802`"},
              {"1.5573876731802119`"},
              {"1.2449200651837589`"},
              {"1.6354392570193266`"},
              {"2.4884419464426215`"},
              {"3.2475692811749326`"},
              {"3.5177454278615317`"},
              {"3.2002737557823457`"},
              {"2.5180563312443516`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .031897545091056974, .23528211702916421, .67759890349335383, 
            1.3006496117364232, 2.007780760066904, 2.7568968633906916, 
            3.4279613645389162, 3.8869985177482631, 4.0172105624398577, 
            3.7431706537715854, 3.1313457802135396, 2.3513137229497802, 
            1.5573876731802119, 1.2449200651837589, 1.6354392570193266, 
            2.4884419464426215, 3.2475692811749326, 3.5177454278615317, 
            3.2002737557823457, 2.5180563312443516}]], 
        "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"0.9569263525403239`"},
              {"3.2406064674912045`"},
              {"5.5144835161264965`"},
              {"6.799049617184637`"},
              {"7.387125669851715`"},
              {"7.33986525316363`"},
              {"5.8588314519409`"},
              {"3.1278585700499164`"},
              {\(-0.6927897948943877`\)},
              {\(-4.6715353097410794`\)},
              {\(-7.197004743441315`\)},
              {\(-8.485054571030787`\)},
              {\(-6.322355081709364`\)},
              {"0.3376006002692833`"},
              {"7.313500195742478`"},
              {"8.919783059910632`"},
              {"5.634632870515561`"},
              {\(-0.3448295343618515`\)},
              {\(-5.590763609736337`\)},
              {\(-7.3808083046146225`\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, .95692635254032388, 3.2406064674912045, 
            5.5144835161264965, 6.7990496171846369, 7.3871256698517147, 
            7.3398652531636301, 5.8588314519409002, 
            3.1278585700499164, -.69278979489438774, -4.6715353097410794, \
-7.1970047434413154, -8.485054571030787, -6.3223550817093637, \
.33760060026928329, 7.3135001957424777, 8.9197830599106318, 
            5.6346328705155608, -.34482953436185149, -5.5907636097363369, \
-7.3808083046146225}]], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"18.941559709869203`"},
              {"25.47614285743061`"},
              {"17.270091958858778`"},
              {"4.574190913345939`"},
              {"7.187330139995467`"},
              {\(-8.132538473757256`\)},
              {\(-21.488137550697502`\)},
              {\(-33.131320087122226`\)},
              {\(-43.28164721176391`\)},
              {\(-36.293416880773506`\)},
              {\(-10.43795319901026`\)},
              {\(-10.50634539917549`\)},
              {"58.661626461941864`"},
              {"74.53748717763108`"},
              {"40.865944635986494`"},
              {\(-14.007578959812339`\)},
              {\(-56.3830361200613`\)},
              {\(-64.87454968327674`\)},
              {\(-38.08374424912397`\)},
              {"6.495542948080423`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 18.941559709869203, 25.476142857430609, 
            17.270091958858778, 4.5741909133459391, 
            7.187330139995467, -8.1325384737572559, -21.488137550697502, \
-33.131320087122226, -43.281647211763911, -36.293416880773506, \
-10.437953199010259, -10.50634539917549, 58.661626461941864, 
            74.537487177631078, 
            40.865944635986494, -14.007578959812339, -56.383036120061298, \
-64.87454968327674, -38.083744249123967, 6.4955429480804234}]]}],
      SequenceForm[ 
        TableForm[ {
          0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0, 1.1000000000000001, 
          1.2000000000000002, 1.3, 1.4000000000000001, 1.5, 
          1.6000000000000001, 1.7000000000000002, 1.8, 1.9000000000000001, 
          2.0}], "     ", 
        TableForm[ {0, 4.4444444444444429, 8.8888888888888893, 
          13.333333333333336, 17.777777777777779, 18.461538461538463, 
          15.384615384615383, 12.307692307692307, 9.2307692307692317, 
          6.1538461538461569, 3.0769230769230802, 
          0, -9.9999999999999893, -4.9999999999999938, 0, 0, 0, 0, 0, 0, 0}], 
        
        TableForm[ {
          0, .031897545091056974, .23528211702916421, .67759890349335383, 
          1.3006496117364232, 2.007780760066904, 2.7568968633906916, 
          3.4279613645389162, 3.8869985177482631, 4.0172105624398577, 
          3.7431706537715854, 3.1313457802135396, 2.3513137229497802, 
          1.5573876731802119, 1.2449200651837589, 1.6354392570193266, 
          2.4884419464426215, 3.2475692811749326, 3.5177454278615317, 
          3.2002737557823457, 2.5180563312443516}], "   ", 
        TableForm[ {0, .95692635254032388, 3.2406064674912045, 
          5.5144835161264965, 6.7990496171846369, 7.3871256698517147, 
          7.3398652531636301, 5.8588314519409002, 
          3.1278585700499164, -.69278979489438774, -4.6715353097410794, \
-7.1970047434413154, -8.485054571030787, -6.3223550817093637, \
.33760060026928329, 7.3135001957424777, 8.9197830599106318, 
          5.6346328705155608, -.34482953436185149, -5.5907636097363369, \
-7.3808083046146225}], "  ", 
        TableForm[ {0, 18.941559709869203, 25.476142857430609, 
          17.270091958858778, 4.5741909133459391, 
          7.187330139995467, -8.1325384737572559, -21.488137550697502, \
-33.131320087122226, -43.281647211763911, -36.293416880773506, \
-10.437953199010259, -10.50634539917549, 58.661626461941864, 
          74.537487177631078, 
          40.865944635986494, -14.007578959812339, -56.383036120061298, \
-64.87454968327674, -38.083744249123967, 6.4955429480804234}]],
      Editable->False]], "Print"]
}, Open  ]],

Cell["\<\
Veamos ahora el mismo caso anterior, pero en el supuesto de que el material \
sea totalmente el\[AAcute]stico. Para ello damos unos valores muy altos de fc \
y ft.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["\<\
p={{0,0},{.45,20},{1.1,0},{1.2,-10},{1.4,0}};
HilbergNoLineal[0,2,.1,0,0,12.35,.2,.274,p,   
        0.5,0.1666666667,-0.1,-15000000,150000000,posicion,velocidad,\
aceleracion]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]1\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0.3939346818745536`\),
      SequenceForm[ 
      "i = ", 1, "     j = ", 3, "      kt = ", 12.35, 
        "      fs = ", .3939346818745536],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]2\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]2.905734145310178`\),
      SequenceForm[ 
      "i = ", 2, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        2.9057341453101779],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]3\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]8.36834645814292`\),
      SequenceForm[ 
      "i = ", 3, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        8.3683464581429199],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]4\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]15.9688066648859`\),
      SequenceForm[ 
      "i = ", 4, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        15.9688066648859],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]5\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]23.498684995910345`\),
      SequenceForm[ 
      "i = ", 5, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        23.498684995910345],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]6\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]27.32362908880436`\),
      SequenceForm[ 
      "i = ", 6, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        27.32362908880436],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]7\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]24.447348369581672`\),
      SequenceForm[ 
      "i = ", 7, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        24.447348369581672],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]8\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]15.379688936791748`\),
      SequenceForm[ 
      "i = ", 8, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        15.379688936791748],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]9\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]3.8762365875363596`\),
      SequenceForm[ 
      "i = ", 9, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        3.8762365875363596],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]10\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]\(-5.357574265784741`\)\),
      SequenceForm[ 
      "i = ", 10, "     j = ", 3, "      kt = ", 12.35, 
        "      fs = ", -5.3575742657847414],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]11\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]\(-9.256257609053206`\)\),
      SequenceForm[ 
      "i = ", 11, "     j = ", 3, "      kt = ", 12.35, 
        "      fs = ", -9.2562576090532058],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]12\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]\(-8.487282144097675`\)\),
      SequenceForm[ 
      "i = ", 12, "     j = ", 3, "      kt = ", 12.35, 
        "      fs = ", -8.4872821440976747],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]13\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]\(-7.264008398267999`\)\),
      SequenceForm[ 
      "i = ", 13, "     j = ", 3, "      kt = ", 12.35, 
        "      fs = ", -7.2640083982679986],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]14\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]\(-4.949256235275222`\)\),
      SequenceForm[ 
      "i = ", 14, "     j = ", 3, "      kt = ", 12.35, 
        "      fs = ", -4.9492562352752216],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]15\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]\(-0.6585777366495593`\)\),
      SequenceForm[ 
      "i = ", 15, "     j = ", 3, "      kt = ", 12.35, 
        "      fs = ", -.65857773664955932],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]16\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]3.5875738228128755`\),
      SequenceForm[ 
      "i = ", 16, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        3.5875738228128755],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]17\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]5.5351415793436285`\),
      SequenceForm[ 
      "i = ", 17, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        5.5351415793436285],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]18\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]4.359868515082353`\),
      SequenceForm[ 
      "i = ", 18, "     j = ", 3, "      kt = ", 12.35, "      fs = ", 
        4.3598685150823533],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]19\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0.9740975190285841`\),
      SequenceForm[ 
      "i = ", 19, "     j = ", 3, "      kt = ", 12.35, 
        "      fs = ", .9740975190285841],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]20\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]12.35`\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]\(-2.61820022739724`\)\),
      SequenceForm[ 
      "i = ", 20, "     j = ", 3, "      kt = ", 12.35, 
        "      fs = ", -2.61820022739724],
      Editable->False]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.221522 0.0206807 [
[.2619 .20902 -9 -9 ]
[.2619 .20902 9 0 ]
[.5 .20902 -3 -9 ]
[.5 .20902 3 0 ]
[.7381 .20902 -9 -9 ]
[.7381 .20902 9 0 ]
[.97619 .20902 -3 -9 ]
[.97619 .20902 3 0 ]
[1.025 .22152 0 -6.25 ]
[1.025 .22152 10 6.25 ]
[.01131 .01472 -18 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .11812 -12 -4.5 ]
[.01131 .11812 0 4.5 ]
[.01131 .32493 -6 -4.5 ]
[.01131 .32493 0 4.5 ]
[.01131 .42833 -12 -4.5 ]
[.01131 .42833 0 4.5 ]
[.01131 .53173 -12 -4.5 ]
[.01131 .53173 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .22152 m
.2619 .22777 L
s
[(0.5)] .2619 .20902 0 1 Mshowa
.5 .22152 m
.5 .22777 L
s
[(1)] .5 .20902 0 1 Mshowa
.7381 .22152 m
.7381 .22777 L
s
[(1.5)] .7381 .20902 0 1 Mshowa
.97619 .22152 m
.97619 .22777 L
s
[(2)] .97619 .20902 0 1 Mshowa
.125 Mabswid
.07143 .22152 m
.07143 .22527 L
s
.11905 .22152 m
.11905 .22527 L
s
.16667 .22152 m
.16667 .22527 L
s
.21429 .22152 m
.21429 .22527 L
s
.30952 .22152 m
.30952 .22527 L
s
.35714 .22152 m
.35714 .22527 L
s
.40476 .22152 m
.40476 .22527 L
s
.45238 .22152 m
.45238 .22527 L
s
.54762 .22152 m
.54762 .22527 L
s
.59524 .22152 m
.59524 .22527 L
s
.64286 .22152 m
.64286 .22527 L
s
.69048 .22152 m
.69048 .22527 L
s
.78571 .22152 m
.78571 .22527 L
s
.83333 .22152 m
.83333 .22527 L
s
.88095 .22152 m
.88095 .22527 L
s
.92857 .22152 m
.92857 .22527 L
s
.25 Mabswid
0 .22152 m
1 .22152 L
s
gsave
1.025 .22152 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .01472 m
.03006 .01472 L
s
[(-10)] .01131 .01472 1 0 Mshowa
.02381 .11812 m
.03006 .11812 L
s
[(-5)] .01131 .11812 1 0 Mshowa
.02381 .32493 m
.03006 .32493 L
s
[(5)] .01131 .32493 1 0 Mshowa
.02381 .42833 m
.03006 .42833 L
s
[(10)] .01131 .42833 1 0 Mshowa
.02381 .53173 m
.03006 .53173 L
s
[(15)] .01131 .53173 1 0 Mshowa
.125 Mabswid
.02381 .0354 m
.02756 .0354 L
s
.02381 .05608 m
.02756 .05608 L
s
.02381 .07676 m
.02756 .07676 L
s
.02381 .09744 m
.02756 .09744 L
s
.02381 .1388 m
.02756 .1388 L
s
.02381 .15948 m
.02756 .15948 L
s
.02381 .18016 m
.02756 .18016 L
s
.02381 .20084 m
.02756 .20084 L
s
.02381 .2422 m
.02756 .2422 L
s
.02381 .26288 m
.02756 .26288 L
s
.02381 .28356 m
.02756 .28356 L
s
.02381 .30424 m
.02756 .30424 L
s
.02381 .34561 m
.02756 .34561 L
s
.02381 .36629 m
.02756 .36629 L
s
.02381 .38697 m
.02756 .38697 L
s
.02381 .40765 m
.02756 .40765 L
s
.02381 .44901 m
.02756 .44901 L
s
.02381 .46969 m
.02756 .46969 L
s
.02381 .49037 m
.02756 .49037 L
s
.02381 .51105 m
.02756 .51105 L
s
.02381 .55241 m
.02756 .55241 L
s
.02381 .57309 m
.02756 .57309 L
s
.02381 .59377 m
.02756 .59377 L
s
.02381 .61445 m
.02756 .61445 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 0 r
.5 Mabswid
.02381 .22152 m
.07143 .31344 L
.11905 .40535 L
.16667 .49726 L
.21429 .58918 L
.2619 .60332 L
.30952 .53969 L
.35714 .47605 L
.40476 .41242 L
.45238 .34879 L
.5 .28515 L
.54762 .22152 L
.59524 .01472 L
.64286 .11812 L
.69048 .22152 L
.7381 .22152 L
.78571 .22152 L
.83333 .22152 L
.88095 .22152 L
.92857 .22152 L
.97619 .22152 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00O5Goo00<007ooOol0
ogoo2Goo000EOol00`00Oomoo`3oOol9Ool000Moo`D0009oo`8000Eoo`03001oogoo0?moo`Uoo`00
2Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo0?moo`Uoo`002Goo00D007ooOomo
o`00009oo`03001oogoo009oo`<008moo`030n1oogoo07Ioo`0000=oo`0000000P0017oo00D007oo
Oomoo`00009oo`03001oogoo009oo`03001oogoo08moo`030n1oogoo07Ioo`002Goo00D007ooOomo
o`00009oo`03001oogoo009oo`03001oogoo08moo`83h7Moo`0027oo0P0017oo0P001Goo00<007oo
Ool0SWoo00<3h7oo0n00Mgoo000EOol00`00Oomoo`2>Ool010?POomoo`?PMWoo000EOol2002?Ool0
10?POomoo`?PMWoo000EOol00`00Oomoo`2>Ool01@?POomoogoo0n00MGoo000EOol00`00Oomoo`2=
Ool00`?POomoo`02Ool00`?POomoo`1cOol001Eoo`03001oogoo08eoo`030n1oogoo00=oo`030n1o
ogoo079oo`005Goo00<007ooOol0SGoo00<3h7ooOol00goo00<3h7ooOol0LWoo000EOol00`00Oomo
o`2=Ool00`?POomoo`04Ool00`?POomoo`1aOol001Eoo`8008ioo`030n1oogoo00Aoo`030n1oogoo
075oo`005Goo00<007ooOol0S7oo00<3h7ooOol01Woo00<3h7ooOol0L7oo000EOol00`00Oomoo`2<
Ool00`?POomoo`06Ool00`?POomoo`1`Ool001Eoo`03001oogoo08aoo`030n1oogoo00Ioo`030n1o
ogoo071oo`005Goo00<007ooOol0S7oo00<3h7ooOol01goo00<3h7ooOol0Kgoo000EOol2002<Ool0
0`?POomoo`08Ool00`?POomoo`1_Ool001Eoo`03001oogoo08]oo`030n1oogoo00Uoo`030n1oogoo
06ioo`005Goo00<007ooOol0Rgoo00<3h7ooOol02Goo00<3h7ooOol0KWoo000EOol00`00Oomoo`2;
Ool00`?POomoo`0:Ool00`?POomoo`1]Ool001Eoo`03001oogoo08Yoo`030n1oogoo00]oo`030n1o
ogoo06eoo`005Goo0P00Rgoo00<3h7ooOol037oo00<3h7ooOol0K7oo000EOol00`00Oomoo`2:Ool0
0`?POomoo`0<Ool00`?POomoo`1/Ool001Eoo`03001oogoo08Yoo`030n1oogoo00eoo`030n1oogoo
06]oo`003Woo0P001Goo00<007ooOol0RWoo00<3h7ooOol03Goo00<3h7ooOol0Jgoo000=Ool01000
Oomoo`0017oo00<007ooOol0RGoo00<3h7ooOol03goo00<3h7ooOol0JWoo000@Ool00`00Oomoo`02
Ool30029Ool00`?POomoo`0?Ool00`?POomoo`1ZOol000Moo`@000=oo`8000Eoo`03001oogoo08Uo
o`030n1oogoo00moo`030n1oogoo06Yoo`003Woo00<007ooOol017oo00<007ooOol0RGoo00<3h7oo
Ool047oo00<3h7ooOol0JGoo000>Ool30004Ool00`00Oomoo`28Ool00`?POomoo`0AOol00`?POomo
o`1YOol001Eoo`03001oogoo08Qoo`030n1oogoo019oo`030n1oogoo06Qoo`005Goo00<007ooOol0
R7oo00<3h7ooOol04Woo00<3h7ooOol0J7oo000EOol20029Ool00`?POomoo`0COol00`?POomoo`1W
Ool001Eoo`03001oogoo08Qoo`030n1oogoo01=oo`030n1oogoo06Moo`005Goo00<007ooOol0Qgoo
00<3h7ooOol05Goo00<3h7ooOol0IWoo000EOol00`00Oomoo`27Ool00`?POomoo`0EOol00`?POomo
o`1VOol001Eoo`03001oogoo08Moo`030n1oogoo01Eoo`030n1oogoo06Ioo`005Goo0P00R7oo00<3
h7ooOol05Woo00<3h7ooOol0IGoo000EOol00`00Oomoo`26Ool00`?POomoo`0GOol00`?POomoo`1U
Ool001Eoo`03001oogoo08Ioo`030n1oogoo01Qoo`030n1oogoo06Aoo`005Goo00<007ooOol0QWoo
00<3h7ooOol067oo00<3h7ooOol0I7oo000EOol00`00Oomoo`26Ool00`?POomoo`0IOol00`?POomo
o`1SOol001Eoo`8003Aoo`8000Aoo`8000Aoo`8003=oo`D000aoo`030n1oogoo01Yoo`030n1oogoo
00Ioo`D0009oo`8000Aoo`8003Aoo`@001Ioo`005Goo00<007ooOol0<Woo00@007ooOol000Qoo`04
001oogoo000dOol00`00Oomoo`0<Ool00`?POomoo`0KOol00`?POomoo`07Ool00`00Oomoo`07Ool0
1000Oomoo`00<goo00<007ooOol05goo000EOol00`00Oomoo`0bOol01000Oomoo`002goo00<007oo
Ool0<Woo00<007ooOol037oo00<3h7ooOol06goo00<3h7ooOol01goo00<007ooOol02Woo00<007oo
Ool0<Woo00<007ooOol05Woo000EOol00`00Oomoo`0bOol01000Oomoo`002Goo0P00=Goo00<007oo
Ool037oo00<3h7ooOol06goo00<3h7ooOol01goo00<007ooOol027oo0P00=Woo00<007ooOol05Goo
000EOol00`00Oomoo`0bOol01000Oomoo`002Goo00<007ooOol0=7oo00<007ooOol037oo00<3h7oo
Ool077oo00<3h7ooOol01Woo00<007ooOol027oo00<007ooOol0<goo00@007ooOol001Ioo`005Goo
0P00=7oo0P002Woo0`00<goo0P003Goo00<3h7ooOol07Goo00<3h7ooOol01Goo0P002Woo0`00=7oo
0P005goo000EOol00`00Oomoo`24Ool00`?POomoo`0NOol00`?POomoo`1POol001Eoo`03001oogoo
08Aoo`030n1oogoo01ioo`030n1oogoo061oo`005Goo00<007ooOol0Q7oo00<3h7ooOol07goo00<3
h7ooOol0Ggoo000EOol00`00Oomoo`23Ool00`?POomoo`0POol00`?POomoo`1GOol20006Ool001Eo
o`03001oogoo08=oo`030n1oogoo025oo`030n1oogoo05Eoo`04001oogoo0005Ool000moo`H00003
0n00000008<000030n000000024004X3h0H000Qoo`03001oogoo00Ioo`005Goo00<000?POol02Goo
00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo
00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo
00<3h000Ool02Woo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo
00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02goo
1@001Goo000EOol00`000n1oo`21Ool00`?POomoo`1kOol00`00Oomoo`06Ool001Eoo`03001oo`?P
085oo`030n1oogoo08Aoo`005Goo00<007oo0n00P7oo00<3h7ooOol0QGoo000EOol200000goo0n1o
o`1mOol00`?POomoo`26Ool001Eoo`04001oogoo0n1mOol00`?POomoo`27Ool001Eoo`05001oogoo
Ool3h01kOol00`?POomoo`28Ool001Eoo`05001oogooOol3h01jOol00`?POomoo`29Ool001Eoo`03
001oogoo009oo`030n1oogoo07Moo`030n1oogoo08Uoo`005Goo0P000goo00<3h7ooOol0MWoo00<3
h7ooOol0RWoo000EOol00`00Oomoo`03Ool00`?POomoo`1dOol00`?POomoo`2;Ool001Eoo`03001o
ogoo00=oo`030n1oogoo07=oo`030n1oogoo08aoo`005Goo00<007ooOol017oo00<3h7ooOol0LGoo
00<3h7ooOol0SGoo000EOol00`00Oomoo`04Ool00`?POomoo`1aOol00`?POomoo`2=Ool001Eoo`80
00Ioo`030n1oogoo06moo`030n1oogoo08ioo`005Goo00<007ooOol01Goo00<3h7ooOol0KWoo00<3
h7ooOol0Sgoo000EOol00`00Oomoo`06Ool00`?POomoo`1/Ool00`?POomoo`2@Ool001Eoo`03001o
ogoo00Ioo`030n1oogoo06]oo`030n1oogoo095oo`005Goo00<007ooOol01goo00<3h7ooOol0JWoo
00<3h7ooOol0TGoo000EOol00`00Oomoo`07Ool00`?POomoo`1YOol00`?POomoo`2BOol001Eoo`80
00Uoo`030n1oogoo06Moo`030n1oogoo09=oo`005Goo00<007ooOol027oo00<3h7ooOol0IWoo00<3
h7ooOol0U7oo000EOol00`00Oomoo`09Ool00`?POomoo`1UOol00`?POomoo`2DOol000ioo`8000Eo
o`03001oogoo00Yoo`030n1oogoo06=oo`030n1oogoo09Eoo`003Goo00@007ooOol000Aoo`03001o
ogoo00Yoo`030n1oogoo069oo`030n1oogoo09Ioo`0047oo00<007ooOol00Woo0`002goo00<3h7oo
Ool0H7oo00<3h7ooOol0Ugoo000>Ool20005Ool00`00Oomoo`0;Ool00`?POomoo`1POol00`?POomo
o`2GOol000ioo`03001oogoo00Aoo`03001oogoo00aoo`030n1oogoo05ioo`030n1oogoo09Qoo`00
3Woo0`0017oo00<007ooOol037oo00<3h7ooOol0GGoo00<3h7ooOol0VGoo000EOol00`00Oomoo`0=
Ool00`?POomoo`1KOol00`?POomoo`2JOol001Eoo`8000ioo`030n1oogoo05]oo`030n1oogoo09Yo
o`005Goo00<007ooOol03Woo00<3h7ooOol0FGoo00<3h7ooOol0Vgoo000EOol00`00Oomoo`0>Ool0
0`?POomoo`1HOol00`?POomoo`2LOol001Eoo`03001oogoo00moo`030n1oogoo05Ioo`030n1oogoo
09eoo`005Goo00<007ooOol03goo00<3h7ooOol0EWoo00<3h7ooOol0WGoo000EOol00`00Oomoo`0@
Ool00`?POomoo`1DOol00`?POomoo`2NOol001Eoo`80015oo`030n1oogoo05=oo`030n1oogoo09mo
o`005Goo00<007ooOol04Goo00<3h7ooOol0DGoo00<3h7ooOol0X7oo000EOol00`00Oomoo`0AOol0
0`?POomoo`1AOol00`?POomoo`2POol001Eoo`03001oogoo019oo`030n1oogoo04moo`030n1oogoo
0:5oo`005Goo00<007ooOol04Woo00<3h7ooOol0CWoo00<3h7ooOol0XWoo000EOol2000DOol00`?P
Oomoo`1<Ool00`?POomoo`2SOol001Eoo`03001oogoo01=oo`030n1oogoo04aoo`030n1oogoo0:=o
o`005Goo00<007ooOol057oo00<3h7ooOol0BWoo00<3h7ooOol0Y7oo000EOol00`00Oomoo`0DOol0
0`?POomoo`19Ool00`?POomoo`2UOol001Eoo`03001oogoo01Eoo`030n1oogoo04Moo`030n1oogoo
0:Ioo`005Goo0P005goo00<3h7ooOol0AWoo00<3h7ooOol0YWoo000EOol00`00Oomoo`0FOol00`?P
Oomoo`15Ool00`?POomoo`2WOol001Eoo`03001oogoo01Moo`030n1oogoo04=oo`030n1oogoo0:Qo
o`001goo1@000Woo0P001Goo00<007ooOol05goo00<3h7ooOol0@Woo00<3h7ooOol0ZGoo0009Ool0
1@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol067oo00<3h7ooOol0@Goo00<3h7ooOol0
ZGoo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo0`0067oo00<3h7ooOol0@7oo00<3h7oo
Ool0ZWoo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol06Goo00<3h7ooOol0
?Woo00<3h7ooOol0Zgoo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol06Goo
00<3h7ooOol0?Goo00<3h7ooOol0[7oo0008Ool20004Ool20005Ool00`00Oomoo`0JOol00`?POomo
o`0lOol00`?POomoo`2/Ool001Eoo`03001oogoo01Yoo`030n1oogoo03]oo`030n1oogoo0:eoo`00
5Goo00<007ooOol06goo00<3h7ooOol0>Goo00<3h7ooOol0[Woo000EOol2000MOol00`?POomoo`0g
Ool00`?POomoo`2_Ool001Eoo`03001oogoo01aoo`030n1oogoo03Moo`030n1oogoo0:moo`005Goo
00<007ooOol07Goo00<3h7ooOol0=Goo00<3h7ooOol0/7oo000EOol00`00Oomoo`0MOol00`?POomo
o`0dOol00`?POomoo`2aOol001Eoo`03001oogoo01ioo`030n1oogoo039oo`030n1oogoo0;9oo`00
5Goo0P007goo00<3h7ooOol0<Woo00<3h7ooOol0/Woo000EOol00`00Oomoo`0OOol00`?POomoo`0`
Ool00`?POomoo`2cOol001Eoo`03001oogoo01moo`030n1oogoo02moo`030n1oogoo0;Aoo`005Goo
00<007ooOol087oo00<3h7ooOol0;Woo00<3h7ooOol0]7oo000EOol00`00Oomoo`0POol00`?POomo
o`0]Ool00`?POomoo`2eOol001Eoo`80029oo`030n1oogoo02]oo`030n1oogoo0;Ioo`005Goo00<0
07ooOol08Goo00<3h7ooOol0:Woo00<3h7ooOol0]goo000EOol00`00Oomoo`0ROol00`?POomoo`0Y
Ool00`?POomoo`2gOol001Eoo`03001oogoo02=oo`030n1oogoo02Moo`030n1oogoo0;Qoo`005Goo
00<007ooOol08goo00<3h7ooOol09Woo00<3h7ooOol0^Goo000EOol2000UOol00`?POomoo`0UOol0
0`?POomoo`2iOol001Eoo`03001oogoo02Aoo`030n1oogoo02Aoo`030n1oogoo0;Yoo`005Goo00<0
07ooOol09Goo00<3h7ooOol08Woo00<3h7ooOol0^goo000EOol00`00Oomoo`0UOol00`?POomoo`0R
Ool00`?POomoo`2kOol000Moo`D0009oo`8000Eoo`03001oogoo02Ioo`030n1oogoo021oo`030n1o
ogoo0;aoo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo02Ioo`030n1oogoo
01moo`030n1oogoo0;eoo`002Goo00<007ooOol017oo00<007ooOol00Woo0`009goo00<3h7ooOol0
7Goo00<3h7ooOol0_Woo0009Ool00`00Oomoo`02Ool20005Ool00`00Oomoo`0WOol00`?POomoo`0M
Ool00`?POomoo`2nOol000Uoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo02Qoo`030n1o
ogoo01]oo`030n1oogoo0;moo`0027oo0P0017oo0`0017oo00<007ooOol0:7oo00<3h7ooOol06Woo
00<3h7ooOol0`7oo000EOol00`00Oomoo`0YOol00`?POomoo`0HOol00`?POomoo`31Ool001Eoo`80
02Yoo`030n1oogoo01Qoo`030n1oogoo0<5oo`005Goo00<007ooOol0:Woo00<3h7ooOol05Woo00<3
h7ooOol0`Woo000EOol00`00Oomoo`0ZOol00`?POomoo`0EOol00`?POomoo`33Ool001Eoo`03001o
ogoo02]oo`030n1oogoo01=oo`030n1oogoo0<Aoo`005Goo00<007ooOol0:goo00<3h7ooOol04goo
00<3h7ooOol0a7oo000EOol2000]Ool00`?POomoo`0AOol00`?POomoo`35Ool001Eoo`03001oogoo
02aoo`030n1oogoo011oo`030n1oogoo0<Ioo`005Goo00<007ooOol0;Goo00<3h7ooOol03Woo00<3
h7ooOol0agoo000EOol00`00Oomoo`0]Ool00`?POomoo`0>Ool00`?POomoo`37Ool001Eoo`03001o
ogoo02ioo`83h0eoo`030n1oogoo0<Qoo`005Goo0P00<Goo0`?P2Goo00<3h7ooOol0bGoo000EOol0
0`00Oomoo`0cOol30n05Ool00`?POomoo`3:Ool001Eoo`03001oogoo03Ioo`<3h09oo`030n1oogoo
0<Yoo`005Goo00<007ooOol0>Goo0P?PcGoo000EOol00`00Oomoo`3oOol9Ool001Eoo`03001oogoo
0?moo`Uoo`005Goo0P00ogoo2Woo000EOol00`00Oomoo`3oOol9Ool00?moob5oo`00ogoo8Goo003o
OolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo000BOol3003oOol<Ool0
01=oo`03001oogoo0?moo`]oo`004goo0`00ogoo2goo000COol01000Oomoo`00ogoo2Woo000COol0
1000Oomoo`00ogoo2Woo000BOol4003oOol;Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5o
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.178731, -10.8547, \
0.00824988, 0.18996}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.163657 0.198723 [
[.2619 .15116 -9 -9 ]
[.2619 .15116 9 0 ]
[.5 .15116 -3 -9 ]
[.5 .15116 3 0 ]
[.7381 .15116 -9 -9 ]
[.7381 .15116 9 0 ]
[.97619 .15116 -3 -9 ]
[.97619 .15116 3 0 ]
[1.025 .16366 0 -6.25 ]
[1.025 .16366 10 6.25 ]
[.01131 .0643 -24 -4.5 ]
[.01131 .0643 0 4.5 ]
[.01131 .26302 -18 -4.5 ]
[.01131 .26302 0 4.5 ]
[.01131 .36238 -6 -4.5 ]
[.01131 .36238 0 4.5 ]
[.01131 .46174 -18 -4.5 ]
[.01131 .46174 0 4.5 ]
[.01131 .5611 -6 -4.5 ]
[.01131 .5611 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .16366 m
.2619 .16991 L
s
[(0.5)] .2619 .15116 0 1 Mshowa
.5 .16366 m
.5 .16991 L
s
[(1)] .5 .15116 0 1 Mshowa
.7381 .16366 m
.7381 .16991 L
s
[(1.5)] .7381 .15116 0 1 Mshowa
.97619 .16366 m
.97619 .16991 L
s
[(2)] .97619 .15116 0 1 Mshowa
.125 Mabswid
.07143 .16366 m
.07143 .16741 L
s
.11905 .16366 m
.11905 .16741 L
s
.16667 .16366 m
.16667 .16741 L
s
.21429 .16366 m
.21429 .16741 L
s
.30952 .16366 m
.30952 .16741 L
s
.35714 .16366 m
.35714 .16741 L
s
.40476 .16366 m
.40476 .16741 L
s
.45238 .16366 m
.45238 .16741 L
s
.54762 .16366 m
.54762 .16741 L
s
.59524 .16366 m
.59524 .16741 L
s
.64286 .16366 m
.64286 .16741 L
s
.69048 .16366 m
.69048 .16741 L
s
.78571 .16366 m
.78571 .16741 L
s
.83333 .16366 m
.83333 .16741 L
s
.88095 .16366 m
.88095 .16741 L
s
.92857 .16366 m
.92857 .16741 L
s
.25 Mabswid
0 .16366 m
1 .16366 L
s
gsave
1.025 .16366 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .0643 m
.03006 .0643 L
s
[(-0.5)] .01131 .0643 1 0 Mshowa
.02381 .26302 m
.03006 .26302 L
s
[(0.5)] .01131 .26302 1 0 Mshowa
.02381 .36238 m
.03006 .36238 L
s
[(1)] .01131 .36238 1 0 Mshowa
.02381 .46174 m
.03006 .46174 L
s
[(1.5)] .01131 .46174 1 0 Mshowa
.02381 .5611 m
.03006 .5611 L
s
[(2)] .01131 .5611 1 0 Mshowa
.125 Mabswid
.02381 .08417 m
.02756 .08417 L
s
.02381 .10404 m
.02756 .10404 L
s
.02381 .12391 m
.02756 .12391 L
s
.02381 .14378 m
.02756 .14378 L
s
.02381 .18353 m
.02756 .18353 L
s
.02381 .2034 m
.02756 .2034 L
s
.02381 .22327 m
.02756 .22327 L
s
.02381 .24315 m
.02756 .24315 L
s
.02381 .28289 m
.02756 .28289 L
s
.02381 .30276 m
.02756 .30276 L
s
.02381 .32263 m
.02756 .32263 L
s
.02381 .34251 m
.02756 .34251 L
s
.02381 .38225 m
.02756 .38225 L
s
.02381 .40212 m
.02756 .40212 L
s
.02381 .422 m
.02756 .422 L
s
.02381 .44187 m
.02756 .44187 L
s
.02381 .48161 m
.02756 .48161 L
s
.02381 .50149 m
.02756 .50149 L
s
.02381 .52136 m
.02756 .52136 L
s
.02381 .54123 m
.02756 .54123 L
s
.02381 .04442 m
.02756 .04442 L
s
.02381 .02455 m
.02756 .02455 L
s
.02381 .00468 m
.02756 .00468 L
s
.02381 .58097 m
.02756 .58097 L
s
.02381 .60085 m
.02756 .60085 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .16366 m
.07143 .17 L
.11905 .21041 L
.16667 .29831 L
.21429 .42061 L
.2619 .54177 L
.30952 .60332 L
.35714 .55704 L
.40476 .41113 L
.45238 .22603 L
.5 .07745 L
.54762 .01472 L
.59524 .02709 L
.64286 .04677 L
.69048 .08402 L
.7381 .15306 L
.78571 .22138 L
.83333 .25272 L
.88095 .23381 L
.92857 .17933 L
.97619 .12153 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool001]oo`03001oogoo0?moo`=oo`006goo0P00ogoo17oo000KOol00`00Oomoo`3oOol3Ool001]o
o`03001oogoo07moo`9l085oo`006goo00<007ooOol0OWoo00=l07ooOol017`0OGoo000KOol00`00
Oomoo`1mOol00g`0Oomoo`05Ool4O01iOol001]oo`8007ioo`03O01oogoo00Uoo`Al07Eoo`006goo
00<007ooOol0O7oo00=l07ooOol03Woo0W`0Lgoo000KOol00`00Oomoo`1kOol00g`0Oomoo`0AOol2
O01aOol001]oo`03001oogoo07Yoo`03O01oogoo01Aoo`=l06ioo`006goo00<007ooOol0NWoo00=l
07ooOol05goo0W`0K7oo000KOol2001jOol00g`0Oomoo`0JOol2O01ZOol001]oo`03001oogoo07Qo
o`03O01oogoo01eoo`03O01oogoo06Moo`006goo00<007ooOol0Mgoo00=l07ooOol07goo00=l07oo
Ool0IWoo0008Ool20004Ool20004Ool20005Ool00`00Oomoo`1gOol00g`0Oomoo`0POol2O01VOol0
00Moo`04001oogoo0008Ool01000Oomoo`0017oo00<007ooOol0MWoo00=l07ooOol08goo00=l07oo
Ool0Hgoo0007Ool01000Oomoo`002goo00<007ooOol00Woo0P00MWoo00=l07ooOol09Goo00=l07oo
Ool0HWoo00000goo000000020002Ool01000Oomoo`002Goo0P001Goo00<007ooOol0M7oo00=l07oo
Ool09goo00=l07ooOol0HGoo0007Ool01000Oomoo`002Goo00<007ooOol017oo00<007ooOol0M7oo
00=l07ooOol0:7oo00=l07ooOol0H7oo0008Ool2000:Ool30004Ool00`00Oomoo`1cOol00g`0Oomo
o`0ZOol2O01POol001]oo`03001oogoo07=oo`03O01oogoo02aoo`03O01oogoo05eoo`006goo0P00
Lgoo00=l07ooOol0;Woo00=l07ooOol0G7oo000KOol00`00Oomoo`1bOol00g`0Oomoo`0_Ool00g`0
Oomoo`1KOol001]oo`03001oogoo079oo`03O01oogoo02moo`03O01oogoo05]oo`006goo00<007oo
Ool0LWoo00=l07ooOol0<7oo00=l07ooOol0FWoo000KOol00`00Oomoo`1aOol00g`0Oomoo`0bOol0
0g`0Oomoo`1IOol001]oo`80079oo`03O01oogoo03=oo`03O01oogoo05Qoo`006goo00<007ooOol0
LGoo00=l07ooOol0<goo00=l07ooOol0F7oo000KOol00`00Oomoo`1`Ool00g`0Oomoo`0eOol00g`0
Oomoo`1GOol001]oo`03001oogoo035oo`8000Aoo`8000Aoo`80035oo`03O000000000<0035oo`80
0003O0000000009oo`8000Aoo`80039oo`@001Ioo`006goo0P00<Goo00@007ooOol000Qoo`04001o
ogoo000`Ool017`0Oomoo`00=Goo00=l07ooOol01goo00@007ooOol0035oo`03001oog`001Moo`00
6goo00<007ooOol0<7oo00@007ooOol000]oo`03001oogoo02eoo`05O01oogooOol0000eOol00`00
O01oo`0:Ool00`00Oomoo`0`Ool00g`0Oomoo`0FOol001]oo`03001oogoo031oo`04001oogoo0009
Ool2000`Ool01G`0Oomoogoo0000=Goo00<007ooO00027oo0P00<Woo00=l07oo00005goo000KOol0
0`00Oomoo`0`Ool01000Oomoo`002Goo00<007ooOol0;goo00El07ooOomoo`0003Eoo`03001oog`0
00Qoo`03001oogoo031oo`05O00007ooOol0000FOol001]oo`03001oogoo035oo`8000Yoo`<002mo
o`03O01oogoo008003Aoo`80009oo`03O01oogoo00Eoo`<0031oo`04O01oo`00000GOol001]oo`80
06moo`03O01oogoo03aoo`03O01oogoo03Ioo`03O01oogoo01Uoo`006goo00<007ooOol0KWoo00=l
07ooOol0?Goo00=l07ooOol0=7oo00=l07ooOol06Woo000KOol00`00Oomoo`1^Ool00g`0Oomoo`0m
Ool00g`0Oomoo`0cOol00g`0Oomoo`0KOol001]oo`03001oogoo06eoo`03O01oogoo03moo`03O01o
ogoo035oo`03O01oogoo01aoo`006goo00<007ooOol0KGoo00=l07ooOol0@7oo00=l07ooOol0;goo
00=l07ooOol05Woo0P001Goo000EOol60003O01]00000g`00000001000000g`00000000^00000g`0
0000000=0009Ool01000Oomoo`0017oo000KOol00`00Oomoo`06O003Ool00`00Oomoo`08Ool00`00
Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00
Oomoo`09Ool00`00Oomoo`09Ool01@00OomoogooO0001Woo00<007ooOol02Goo00<007ooOol02Goo
00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooO0002Goo00<007ooOol02Goo
00<007ooOol02Goo00<007ooOol027oo00@007ooOoml00Qoo`03001oogoo00eoo`03001oogoo00Eo
o`006goo00<007ooOol01Woo17`0;Woo00<007ooOol0<Goo00=l07ooOol017oo00<007ooOol0>Goo
00@007ooOoml02eoo`03O01oogoo00Moo`03001oogoo00aoo`D000Aoo`006goo00<007ooOol02Woo
00=l07ooOol0Ggoo00=l07ooOol0A7oo00=l07ooOol0:Goo00=l07ooOol067oo00<007ooOol01Goo
000KOol00`00Oomoo`0;Ool00g`0Oomoo`1NOol00g`0Oomoo`14Ool00g`0Oomoo`0XOol00g`0Oomo
o`0QOol001]oo`8000eoo`03O01oogoo05aoo`03O01oogoo04Ioo`03O01oogoo02Ioo`03O01oogoo
029oo`006goo00<007ooOol03Goo00=l07ooOol0Fgoo00=l07ooOol0Agoo00=l07ooOol097oo00=l
07ooOol08goo000KOol00`00Oomoo`0>Ool2O01KOol00g`0Oomoo`17Ool00g`0Oomoo`0TOol00g`0
Oomoo`0SOol001]oo`03001oogoo011oo`03O01oogoo05Moo`03O01oogoo04Uoo`03O01oogoo029o
o`03O01oogoo02Aoo`006goo00<007ooOol04Goo00=l07ooOol0EWoo00=l07ooOol0BWoo00=l07oo
Ool087oo00=l07ooOol09Goo000KOol2000COol00g`0Oomoo`1EOol00g`0Oomoo`1:Ool00g`0Oomo
o`0OOol00g`0Oomoo`0VOol001]oo`03001oogoo01=oo`03O01oogoo05=oo`03O01oogoo04aoo`03
O01oogoo01eoo`03O01oogoo02Moo`006goo00<007ooOol057oo00=l07ooOol0DWoo00=l07ooOol0
CGoo00=l07ooOol077oo00=l07ooOol09goo000KOol00`00Oomoo`0EOol00g`0Oomoo`1AOol00g`0
Oomoo`1>Ool00g`0Oomoo`0JOol00g`0Oomoo`0XOol001]oo`03001oogoo01Eoo`03O01oogoo055o
o`03O01oogoo04ioo`03O01oogoo01Uoo`03O01oogoo02Uoo`006goo0P005goo00=l07ooOol0Cgoo
00=l07ooOol0D7oo00=l07ooOol05goo00=l07ooOol0:Woo000KOol00`00Oomoo`0FOol00g`0Oomo
o`1?Ool00g`0Oomoo`1AOol2O00GOol00g`0Oomoo`0ZOol001]oo`03001oogoo01Moo`03O01oogoo
04ioo`03O01oogoo05=oo`03O01oogoo01=oo`03O01oogoo02]oo`006goo00<007ooOol05goo00=l
07ooOol0CGoo00=l07ooOol0EGoo0W`04Goo0W`0;Woo000KOol00`00Oomoo`0HOol00g`0Oomoo`1<
Ool00g`0Oomoo`1GOol00g`0Oomoo`0<Ool2O00`Ool001]oo`8001Uoo`03O01oogoo04aoo`03O01o
ogoo05Qoo`9l00Yoo`9l039oo`006goo00<007ooOol06Goo00=l07ooOol0Bgoo00=l07ooOol0FWoo
00=l07ooOol017oo0g`0=7oo000KOol00`00Oomoo`0IOol00g`0Oomoo`1:Ool00g`0Oomoo`1LOol2
O002Ool2O00gOol000Qoo`8000Aoo`8000Aoo`8000Eoo`03001oogoo01Yoo`03O01oogoo04Uoo`03
O01oogoo05ioo`9l03Uoo`001goo00@007ooOol000Qoo`04001oogoo0004Ool00`00Oomoo`0KOol0
0g`0Oomoo`18Ool00g`0Oomoo`2IOol000Moo`04001oogoo000;Ool00`00Oomoo`02Ool2000LOol0
0g`0Oomoo`18Ool00g`0Oomoo`2IOol000Moo`04001oogoo0009Ool20005Ool00`00Oomoo`0LOol0
0g`0Oomoo`16Ool00g`0Oomoo`2JOol000Moo`04001oogoo0009Ool00`00Oomoo`04Ool00`00Oomo
o`0LOol00g`0Oomoo`16Ool00g`0Oomoo`2JOol000Qoo`8000Yoo`<000Aoo`03001oogoo01eoo`03
O01oogoo04Eoo`03O01oogoo09Yoo`006goo00<007ooOol07Goo00=l07ooOol0AGoo00=l07ooOol0
VWoo000KOol2000OOol00g`0Oomoo`13Ool00g`0Oomoo`2KOol001]oo`03001oogoo01ioo`03O01o
ogoo04=oo`03O01oogoo09]oo`006goo00<007ooOol07goo00=l07ooOol0@Woo00=l07ooOol0Vgoo
000KOol00`00Oomoo`0OOol00g`0Oomoo`12Ool00g`0Oomoo`2KOol001]oo`03001oogoo021oo`03
O01oogoo041oo`03O01oogoo09aoo`006goo0P008Goo00=l07ooOol0@7oo00=l07ooOol0W7oo000K
Ool00`00Oomoo`0QOol00g`0Oomoo`0oOol00g`0Oomoo`2LOol001]oo`03001oogoo025oo`03O01o
ogoo03moo`03O01oogoo09aoo`006goo00<007ooOol08Woo00=l07ooOol0?Goo00=l07ooOol0WGoo
000KOol00`00Oomoo`0ROol00g`0Oomoo`0mOol00g`0Oomoo`2MOol001]oo`8002=oo`03O01oogoo
03eoo`03O01oogoo09eoo`006goo00<007ooOol08goo00=l07ooOol0>goo00=l07ooOol0WWoo000K
Ool00`00Oomoo`0SOol00g`0Oomoo`0kOol00g`0Oomoo`2NOol001]oo`03001oogoo02=oo`03O01o
ogoo03]oo`03O01oogoo09ioo`006goo00<007ooOol097oo00=l07ooOol0>Woo00=l07ooOol0WWoo
000KOol2000UOol00g`0Oomoo`0iOol00g`0Oomoo`2OOol001]oo`03001oogoo02Eoo`03O01oogoo
03Qoo`03O01oogoo09moo`006goo00<007ooOol09Goo00=l07ooOol0>7oo00=l07ooOol0Wgoo000C
Ool50003Ool00`00Oomoo`0UOol00g`0Oomoo`0hOol00g`0Oomoo`2OOol001Eoo`03001oogoo00=o
o`03001oogoo02Ioo`03O01oogoo03Ioo`03O01oogoo0:1oo`005Goo00<007ooOol00goo0P009goo
00=l07ooOol0=Woo00=l07ooOol0X7oo000EOol00`00Oomoo`03Ool00`00Oomoo`0WOol00g`0Oomo
o`0eOol00g`0Oomoo`2POol001Eoo`03001oogoo00=oo`03001oogoo02Moo`03O01oogoo03Eoo`03
O01oogoo0:1oo`0057oo0P001Goo00<007ooOol09goo00=l07ooOol0=7oo00=l07ooOol0XGoo000K
Ool00`00Oomoo`0XOol00g`0Oomoo`0cOol00g`0Oomoo`2QOol001]oo`8002Uoo`03O01oogoo03=o
o`03O01oogoo0:5oo`006goo00<007ooOol0:Goo00=l07ooOol0<Woo00=l07ooOol0XGoo000KOol0
0`00Oomoo`0YOol00g`0Oomoo`0aOol00g`0Oomoo`2ROol001]oo`03001oogoo02Uoo`03O01oogoo
035oo`03O01oogoo0:9oo`006goo00<007ooOol0:Woo00=l07ooOol0<7oo00=l07ooOol0XWoo000K
Ool2000[Ool00g`0Oomoo`0`Ool00g`0Oomoo`2ROol001]oo`03001oogoo02Yoo`03O01oogoo02mo
o`03O01oogoo0:=oo`006goo00<007ooOol0:goo00=l07ooOol0;Woo00=l07ooOol0Xgoo000KOol0
0`00Oomoo`0[Ool00g`0Oomoo`0^Ool00g`0Oomoo`2SOol001]oo`03001oogoo02aoo`03O01oogoo
02aoo`03O01oogoo0:Aoo`006goo0P00;Goo00=l07ooOol0;7oo00=l07ooOol0Y7oo000KOol00`00
Oomoo`0/Ool00g`0Oomoo`0/Ool00g`0Oomoo`2TOol001]oo`03001oogoo02eoo`03O01oogoo02Yo
o`03O01oogoo0:Eoo`006goo00<007ooOol0;Goo00=l07ooOol0:Woo00=l07ooOol0YGoo000KOol0
0`00Oomoo`0^Ool00g`0Oomoo`0YOol00g`0Oomoo`2UOol001]oo`8002moo`03O01oogoo02Qoo`03
O01oogoo0:Ioo`006goo00<007ooOol0;Woo00=l07ooOol0:7oo00=l07ooOol0YWoo000KOol00`00
Oomoo`0_Ool00g`0Oomoo`0WOol00g`0Oomoo`2VOol000Moo`D0009oo`8000Aoo`8000Eoo`03001o
ogoo02moo`03O01oogoo02Ioo`03O01oogoo0:Moo`002Goo00<007ooOol01goo00@007ooOol000Ao
o`03001oogoo031oo`03O01oogoo02Eoo`03O01oogoo0:Moo`002Goo00<007ooOol02Woo00<007oo
Ool00Woo0P00<Goo00=l07ooOol09Goo00=l07ooOol0Ygoo0009Ool00`00Oomoo`08Ool20005Ool0
0`00Oomoo`0`Ool00g`0Oomoo`0TOol00g`0Oomoo`2XOol000Uoo`03001oogoo00Qoo`03001oogoo
00Aoo`03001oogoo035oo`03O01oogoo02=oo`03O01oogoo0:Qoo`0027oo0P002Woo0`0017oo00<0
07ooOol0<Goo00=l07ooOol08goo00=l07ooOol0Z7oo000KOol00`00Oomoo`0bOol00g`0Oomoo`0Q
Ool00g`0Oomoo`2YOol001]oo`8003=oo`03O01oogoo025oo`03O01oogoo0:Uoo`006goo00<007oo
Ool0<Woo00=l07ooOol08Goo00=l07ooOol0ZGoo000KOol00`00Oomoo`0cOol00g`0Oomoo`0POol0
0g`0Oomoo`2YOol001]oo`03001oogoo03=oo`03O01oogoo01moo`03O01oogoo0:Yoo`006goo00<0
07ooOol0=7oo00=l07ooOol07Woo00=l07ooOol0ZWoo000KOol2000eOol00g`0Oomoo`0NOol00g`0
Oomoo`2ZOol001]oo`03001oogoo03Aoo`03O01oogoo01eoo`03O01oogoo0:]oo`006goo00<007oo
Ool0=Goo00=l07ooOol077oo00=l07ooOol0Zgoo000KOol00`00Oomoo`0eOol00g`0Oomoo`0LOol0
0g`0Oomoo`2[Ool001]oo`03001oogoo03Ioo`03O01oogoo01Yoo`03O01oogoo0:aoo`006goo0P00
=goo00=l07ooOol06Woo00=l07ooOol0[7oo000KOol00`00Oomoo`0fOol00g`0Oomoo`0JOol00g`0
Oomoo`2/Ool001]oo`03001oogoo03Moo`03O01oogoo01Qoo`03O01oogoo0:eoo`006goo00<007oo
Ool0=goo00=l07ooOol067oo00=l07ooOol0[Goo000KOol00`00Oomoo`0hOol00g`0Oomoo`0GOol0
0g`0Oomoo`2]Ool001]oo`8003Uoo`03O01oogoo01Ioo`03O01oogoo0:ioo`006goo00<007ooOol0
>Goo00=l07ooOol05Goo00=l07ooOol0[Woo000KOol00`00Oomoo`0jOol00g`0Oomoo`0DOol00g`0
Oomoo`2^Ool001=oo`@000Aoo`03001oogoo03Yoo`03O01oogoo01=oo`03O01oogoo0:moo`004goo
00<007ooOol01Goo00<007ooOol0>goo00=l07ooOol04Woo00=l07ooOol0[goo000DOol00`00Oomo
o`04Ool2000mOol00g`0Oomoo`0@Ool00g`0Oomoo`2`Ool001Eoo`03001oogoo00=oo`03001oogoo
03eoo`03O01oogoo00ioo`03O01oogoo0;5oo`004goo00@007ooOol000Aoo`03001oogoo03ioo`03
O01oogoo00aoo`03O01oogoo0;9oo`0057oo0P001Goo00<007ooOol0?Woo00=l07ooOol02goo00=l
07ooOol0/goo000KOol00`00Oomoo`0oOol00g`0Oomoo`09Ool00g`0Oomoo`2dOol001]oo`80045o
o`03O01oogoo00Ioo`9l0;Moo`006goo00<007ooOol0@Goo00=l07ooOol017oo00=l07ooOol0]goo
000KOol00`00Oomoo`12Ool00g`0Oomoo`02Ool00g`0Oomoo`2hOol001]oo`03001oogoo049oo`05
O01oogooOoml002kOol001]oo`8004Aoo`03O01oog`00;aoo`006goo00<007ooOol0A7oo00=l07oo
Ool0^goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0
ogoo0goo000KOol00`00Oomoo`3oOol3Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`006Woo1000ogoo0goo
000IOol01000Oomoo`00ogoo17oo000IOol01000Oomoo`00ogoo17oo000HOol200000goo0000003o
Ool4Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.228198, -0.86336, \
0.00841412, 0.0201623}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.355288 0.037751 [
[.2619 .34279 -9 -9 ]
[.2619 .34279 9 0 ]
[.5 .34279 -3 -9 ]
[.5 .34279 3 0 ]
[.7381 .34279 -9 -9 ]
[.7381 .34279 9 0 ]
[.97619 .34279 -3 -9 ]
[.97619 .34279 3 0 ]
[1.025 .35529 0 -6.25 ]
[1.025 .35529 10 6.25 ]
[.01131 .07216 -24 -4.5 ]
[.01131 .07216 0 4.5 ]
[.01131 .16653 -12 -4.5 ]
[.01131 .16653 0 4.5 ]
[.01131 .26091 -24 -4.5 ]
[.01131 .26091 0 4.5 ]
[.01131 .44967 -18 -4.5 ]
[.01131 .44967 0 4.5 ]
[.01131 .54404 -6 -4.5 ]
[.01131 .54404 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .35529 m
.2619 .36154 L
s
[(0.5)] .2619 .34279 0 1 Mshowa
.5 .35529 m
.5 .36154 L
s
[(1)] .5 .34279 0 1 Mshowa
.7381 .35529 m
.7381 .36154 L
s
[(1.5)] .7381 .34279 0 1 Mshowa
.97619 .35529 m
.97619 .36154 L
s
[(2)] .97619 .34279 0 1 Mshowa
.125 Mabswid
.07143 .35529 m
.07143 .35904 L
s
.11905 .35529 m
.11905 .35904 L
s
.16667 .35529 m
.16667 .35904 L
s
.21429 .35529 m
.21429 .35904 L
s
.30952 .35529 m
.30952 .35904 L
s
.35714 .35529 m
.35714 .35904 L
s
.40476 .35529 m
.40476 .35904 L
s
.45238 .35529 m
.45238 .35904 L
s
.54762 .35529 m
.54762 .35904 L
s
.59524 .35529 m
.59524 .35904 L
s
.64286 .35529 m
.64286 .35904 L
s
.69048 .35529 m
.69048 .35904 L
s
.78571 .35529 m
.78571 .35904 L
s
.83333 .35529 m
.83333 .35904 L
s
.88095 .35529 m
.88095 .35904 L
s
.92857 .35529 m
.92857 .35904 L
s
.25 Mabswid
0 .35529 m
1 .35529 L
s
gsave
1.025 .35529 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .07216 m
.03006 .07216 L
s
[(-7.5)] .01131 .07216 1 0 Mshowa
.02381 .16653 m
.03006 .16653 L
s
[(-5)] .01131 .16653 1 0 Mshowa
.02381 .26091 m
.03006 .26091 L
s
[(-2.5)] .01131 .26091 1 0 Mshowa
.02381 .44967 m
.03006 .44967 L
s
[(2.5)] .01131 .44967 1 0 Mshowa
.02381 .54404 m
.03006 .54404 L
s
[(5)] .01131 .54404 1 0 Mshowa
.125 Mabswid
.02381 .09103 m
.02756 .09103 L
s
.02381 .10991 m
.02756 .10991 L
s
.02381 .12878 m
.02756 .12878 L
s
.02381 .14766 m
.02756 .14766 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .20428 m
.02756 .20428 L
s
.02381 .22316 m
.02756 .22316 L
s
.02381 .24204 m
.02756 .24204 L
s
.02381 .27979 m
.02756 .27979 L
s
.02381 .29866 m
.02756 .29866 L
s
.02381 .31754 m
.02756 .31754 L
s
.02381 .33641 m
.02756 .33641 L
s
.02381 .37416 m
.02756 .37416 L
s
.02381 .39304 m
.02756 .39304 L
s
.02381 .41191 m
.02756 .41191 L
s
.02381 .43079 m
.02756 .43079 L
s
.02381 .46854 m
.02756 .46854 L
s
.02381 .48742 m
.02756 .48742 L
s
.02381 .50629 m
.02756 .50629 L
s
.02381 .52517 m
.02756 .52517 L
s
.02381 .05328 m
.02756 .05328 L
s
.02381 .0344 m
.02756 .0344 L
s
.02381 .01553 m
.02756 .01553 L
s
.02381 .56292 m
.02756 .56292 L
s
.02381 .58179 m
.02756 .58179 L
s
.02381 .60067 m
.02756 .60067 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 1 r
.5 Mabswid
.02381 .35529 m
.07143 .39141 L
.11905 .47762 L
.16667 .56347 L
.21429 .60332 L
.2619 .54965 L
.30952 .37817 L
.35714 .16001 L
.40476 .0155 L
.45238 .01472 L
.5 .14484 L
.54762 .32464 L
.59524 .39764 L
.64286 .39993 L
.69048 .45996 L
.7381 .49986 L
.78571 .45921 L
.83333 .36702 L
.88095 .27708 L
.92857 .23701 L
.97619 .26352 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3
Ool001]oo`8005eoo`el7iUoo`006goo00<007ooOol0G7oo00=l7gooOol02Goo00=l7gooOol0Ugoo
000KOol00`00Oomoo`1KOol00g`OOomoo`0;Ool00g`OOomoo`2FOol001]oo`03001oogoo05]oo`03
O1moogoo00]oo`03O1moogoo09Ioo`006goo00<007ooOol0Fgoo00=l7gooOol02goo00=l7gooOol0
UWoo000KOol2001KOol00g`OOomoo`0=Ool00g`OOomoo`2EOol001]oo`03001oogoo05Yoo`03O1mo
ogoo00eoo`03O1moogoo09Eoo`006goo00<007ooOol0FWoo00=l7gooOol03Goo00=l7gooOol0UGoo
000KOol00`00Oomoo`1IOol00g`OOomoo`0?Ool00g`OOomoo`2DOol001]oo`03001oogoo05Uoo`03
O1moogoo00moo`03O1moogoo09Aoo`006goo0P00FWoo00=l7gooOol03goo00=l7gooOol0U7oo000K
Ool00`00Oomoo`1HOol00g`OOomoo`0AOol00g`OOomoo`2COol001]oo`03001oogoo05Qoo`03O1mo
ogoo015oo`03O1moogoo09=oo`002Goo00<007ooOol00Woo0P0017oo0P001Goo00<007ooOol0F7oo
00=l7gooOol04Goo00=l7gooOol0Tgoo0009Ool00`00Oomoo`07Ool01000Oomoo`0017oo00<007oo
Ool0Egoo00=l7gooOol04goo00=l7gooOol0TWoo0009Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool2
001HOol00g`OOomoo`0COol00g`OOomoo`2BOol00003Ool00000008000Eoo`03001oogoo00Moo`80
00Eoo`03001oogoo05Moo`03O1moogoo01=oo`03O1moogoo099oo`001goo00@007ooOol000Uoo`03
001oogoo00Aoo`03001oogoo05Ioo`03O1moogoo01Eoo`03O1moogoo095oo`001goo10002Goo0`00
17oo00<007ooOol0EWoo00=l7gooOol05Goo00=l7gooOol0TGoo000KOol2001GOol00g`OOomoo`0E
Ool00g`OOomoo`2AOol001]oo`03001oogoo05Eoo`03O1moogoo01Moo`03O1moogoo091oo`006goo
00<007ooOol0EGoo00=l7gooOol05goo00=l7gooOol0T7oo000KOol00`00Oomoo`1EOol00g`OOomo
o`0GOol00g`OOomoo`2@Ool001]oo`03001oogoo05Aoo`03O1moogoo01Uoo`03O1moogoo08moo`00
6goo0P00EGoo00=l7gooOol06Goo00=l7gooOol0Sgoo000KOol00`00Oomoo`1DOol00g`OOomoo`0I
Ool00g`OOomoo`2?Ool001]oo`03001oogoo05=oo`03O1moogoo01]oo`03O1moogoo08ioo`006goo
00<007ooOol0Dgoo00=l7gooOol06goo00=l7gooOol0SWoo000KOol00`00Oomoo`1COol00g`OOomo
o`0KOol00g`OOomoo`2>Ool001]oo`8005=oo`03O1moogoo01eoo`03O1moogoo08eoo`006goo00<0
07ooOol0DWoo00=l7gooOol07Goo00=l7gooOol0SGoo000KOol00`00Oomoo`1BOol00g`OOomoo`0M
Ool00g`OOomoo`2=Ool001]oo`03001oogoo055oo`03O1moogoo01moo`03O1moogoo08aoo`006goo
0P00DWoo00=l7gooOol07goo00=l7gooOol0S7oo000KOol00`00Oomoo`1AOol00g`OOomoo`0OOol0
0g`OOomoo`2<Ool001]oo`03001oogoo051oo`03O1moogoo025oo`03O1moogoo08]oo`0057oo0P00
1Goo00<007ooOol0D7oo00=l7gooOol08Goo00=l7gooOol0Rgoo000COol01000Oomoo`0017oo00<0
07ooOol0D7oo00=l7gooOol08Goo00=l7gooOol0Rgoo000FOol00`00Oomoo`02Ool2001AOol00g`O
Oomoo`0QOol00g`OOomoo`2;Ool000eoo`@000=oo`8000Eoo`03001oogoo04moo`03O1moogoo02=o
o`03O1moogoo08Yoo`0057oo00<007ooOol017oo00<007ooOol0Cgoo00=l7gooOol08goo00=l7goo
Ool0RWoo000DOol30004Ool00`00Oomoo`1?Ool00g`OOomoo`0SOol00g`OOomoo`2:Ool001]oo`03
001oogoo04moo`03O1moogoo02=oo`03O1moogoo08Yoo`006goo0P00Cgoo00=l7gooOol09Goo00=l
7gooOol0RGoo000KOol00`00Oomoo`1>Ool00g`OOomoo`0UOol00g`OOomoo`29Ool001]oo`03001o
ogoo04ioo`03O1moogoo02Eoo`03O1moogoo08Uoo`006goo00<007ooOol0CWoo00=l7gooOol09Goo
00=l7gooOol0RGoo000KOol00`00Oomoo`1>Ool00g`OOomoo`0VOol00g`OOomoo`28Ool001]oo`80
04ioo`03O1moogoo02Moo`03O1moogoo08Qoo`006goo00<007ooOol0CGoo00=l7gooOol09goo00=l
7gooOol0R7oo000KOol00`00Oomoo`1=Ool00g`OOomoo`0XOol00g`OOomoo`27Ool001]oo`03001o
ogoo04eoo`03O1moogoo02Qoo`03O1moogoo08Moo`006goo0P00CWoo00=l7gooOol0:7oo00=l7goo
Ool0Qgoo000KOol00`00Oomoo`1<Ool00g`OOomoo`0YOol00g`OOomoo`27Ool001]oo`03001oogoo
04aoo`03O1moogoo02Yoo`03O1moogoo08Ioo`006goo00<007ooOol0C7oo00=l7gooOol0:Woo00=l
7gooOol0QWoo000KOol00`00Oomoo`1<Ool00g`OOomoo`0ZOol00g`OOomoo`1ROol00g`OOomoo`0Q
Ool001]oo`8004aoo`03O1moogoo02]oo`03O1moogoo065oo`04O1moog`OO1lQOol001]oo`03001o
ogoo04]oo`03O1moogoo02aoo`03O1moogoo05moo`03O1moogoo009oo`9l7amoo`006goo00<007oo
Ool0Bgoo00=l7gooOol0;7oo00=l7gooOol0GWoo00=l7gooOol01Goo0W`O7Goo0007Ool40003Ool2
0004Ool20005Ool00`00Oomoo`1;Ool00g`OOomoo`0/Ool00g`OOomoo`1MOol00g`OOomoo`08Ool2
O1lKOol000Moo`03001oogoo00Uoo`04001oogoo0004Ool00`00Oomoo`1;Ool00g`OOomoo`0/Ool0
0g`OOomoo`1KOol2O1l=Ool2O1lIOol000Qoo`03001oogoo00]oo`03001oogoo009oo`8004]oo`03
O1moogoo02ioo`03O1moogoo05Uoo`03O1moogoo00moo`9l7aMoo`0000=oo`0000000P0017oo00<0
07ooOol027oo0P001Goo00<007ooOol0BWoo00=l7gooOol0;Woo00=l7gooOol0F7oo00=l7gooOol0
:Goo0007Ool01000Oomoo`002Goo00<007ooOol017oo00<007ooOol0BWoo00=l7gooOol0;Woo00=l
7gooOol0Egoo00=l7gooOol0:Woo0008Ool2000:Ool30004Ool00`00Oomoo`1:Ool00g`OOomoo`0_
Ool00g`OOomoo`1EOol00g`OOomoo`0[Ool001]oo`8004Yoo`03O1moogoo031oo`03O1moogoo05Ao
o`03O1moogoo02aoo`006goo00<007ooOol0BGoo00=l7gooOol0<7oo00=l7gooOol0Dgoo00=l7goo
Ool0;Goo000KOol00`00Oomoo`19Ool00g`OOomoo`0`Ool00g`OOomoo`1COol00g`OOomoo`0]Ool0
01]oo`03001oogoo04Uoo`03O1moogoo035oo`03O1moogoo055oo`03O1moogoo02ioo`006goo00<0
07ooOol0BGoo00=l7gooOol0<Goo00=l7gooOol0DGoo00=l7gooOol0;Woo000KOol20019Ool00g`O
Oomoo`0bOol00g`OOomoo`1@Ool00g`OOomoo`0_Ool001]oo`03001oogoo04Qoo`03O1moogoo039o
o`03O1moogoo051oo`03O1moogoo02moo`006goo00<007ooOol0B7oo00=l7gooOol0<goo00=l7goo
Ool0CWoo00=l7gooOol0<7oo000KOol00`00Oomoo`0aOol20004Ool20004Ool20009Ool00g`OOomo
o`0VOol50008Ool00g`OOomoo`0VOol50002Ool20004Ool2000IOol00g`OOomoo`0FOol4000FOol0
01]oo`03001oogoo031oo`04001oogoo0008Ool01000Oomoo`001goo00=l7gooOol0:Goo00<007oo
Ool027oo00=l7gooOol0:7oo00<007ooOol01goo00@007ooOol001Moo`03O1moogoo01Moo`03001o
ogoo01Moo`006goo0P00<Goo00@007ooOol000]oo`03001oogoo00Eoo`03O1moogoo02Uoo`03001o
ogoo00Qoo`03O1moogoo02Qoo`03001oogoo00Yoo`03001oogoo01Eoo`03O1moogoo01Qoo`03001o
ogoo01Ioo`006goo00<007ooOol0<7oo00@007ooOol000Uoo`8000Qoo`03O1moogoo02Uoo`03001o
ogoo00Uoo`03O1moogoo02Moo`03001oogoo00Qoo`8001Moo`03O1moogoo01Yoo`03001oogoo01Eo
o`006goo00<007ooOol0<7oo00@007ooOol000Uoo`03001oogoo00Moo`03O1moogoo02Uoo`03001o
ogoo00Uoo`03O1moogoo02Moo`03001oogoo00Qoo`03001oogoo01Eoo`03O1moogoo01Uoo`04001o
ogoo000FOol001]oo`03001oogoo035oo`8000Yoo`<000Moo`03O1moogoo02Qoo`8000aoo`03O1mo
ogoo02Eoo`8000Yoo`<001Eoo`03O1moogoo01Yoo`8001Moo`006goo0P00Agoo00=l7gooOol0=goo
00=l7gooOol0B7oo00=l7gooOol0=7oo000KOol00`00Oomoo`16Ool00g`OOomoo`0hOol00g`OOomo
o`17Ool00g`OOomoo`0dOol001]oo`03001oogoo04Ioo`03O1moogoo03Uoo`03O1moogoo04Eoo`03
O1moogoo03Eoo`006goo00<007ooOol0AWoo00=l7gooOol0>Goo00=l7gooOol0AGoo00=l7gooOol0
=Goo000KOol00`00Oomoo`16Ool00g`OOomoo`0jOol00g`OOomoo`13Ool00g`OOomoo`0_Ool20005
Ool001Eoo`H00003O1l0000004D00003O1l0000003`00003O1l0000004800003O1l0000002D000Uo
o`04001oogoo0004Ool001]oo`03001l7goo00Uoo`03001oogoo00Qoo`03001oogoo00Uoo`03001o
ogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001l7goo00Uoo`03001oogoo00Uoo`03001o
ogoo00Uoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo009oo`03O1moogoo00Aoo`03001o
ogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001l
7goo00Uoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00eoo`03001oogoo00Eoo`006goo
00@007ooO1ml7cMoo`03001oogoo00Yoo`03O1moogoo02]oo`03001oogoo00moo`03O1moogoo02Mo
o`03001oogoo01Ioo`03O1moogoo01moo`03001oogoo00aoo`D000Aoo`006goo00D007ooOomoog`O
04=oo`03O1moogoo03ioo`03O1moogoo03ioo`03O1moogoo031oo`03001oogoo00Eoo`006goo00<0
07ooOol00Woo00=l7gooOol0?goo00=l7gooOol0?goo00=l7gooOol0?Goo00=l7gooOol0>Goo000K
Ool20004Ool2O1loOol00g`OOomoo`10Ool00g`OOomoo`0lOol00g`OOomoo`0iOol001]oo`03001o
ogoo00Eoo`03O1moogoo03aoo`03O1moogoo045oo`03O1moogoo03Yoo`03O1moogoo03Yoo`006goo
00<007ooOol01Woo00=l7gooOol0>goo00=l7gooOol0@Goo00=l7gooOol0>Woo00=l7gooOol0>Woo
000KOol00`00Oomoo`07Ool2O1ljOol00g`OOomoo`13Ool00g`OOomoo`0hOol00g`OOomoo`0kOol0
01]oo`03001oogoo00Uoo`03O1moogoo03Moo`03O1moogoo04Aoo`03O1moogoo03Moo`03O1moogoo
03]oo`006goo0P002goo00=l7gooOol0=Woo00=l7gooOol0A7oo00=l7gooOol0=Woo00=l7gooOol0
?7oo000KOol00`00Oomoo`0:Ool00g`OOomoo`0fOol00g`OOomoo`15Ool=O1l[Ool00g`OOomoo`0l
Ool001]oo`03001oogoo00]oo`03O1moogoo03Aoo`03O1moogoo05=oo`03O1moogoo02Moo`03O1mo
ogoo03eoo`006goo00<007ooOol02goo00=l7gooOol0=7oo00=l7gooOol0E7oo00=l7gooOol09Woo
00=l7gooOol0?Goo000KOol2000=Ool00g`OOomoo`0cOol00g`OOomoo`1DOol00g`OOomoo`0UOol0
0g`OOomoo`0nOol001]oo`03001oogoo00aoo`03O1moogoo039oo`03O1moogoo05Ioo`03O1moogoo
02Aoo`03O1moogoo03ioo`006goo00<007ooOol03Goo00=l7gooOol0<Goo00=l7gooOol0Egoo00=l
7gooOol08Woo00=l7gooOol0?goo000KOol00`00Oomoo`0=Ool00g`OOomoo`0aOol00g`OOomoo`1H
Ool00g`OOomoo`0QOol00g`OOomoo`0oOol001]oo`03001oogoo00ioo`03O1moogoo031oo`03O1mo
ogoo05Uoo`03O1moogoo01moo`03O1moogoo041oo`006goo0P003goo00=l7gooOol0;goo00=l7goo
Ool0FWoo00=l7gooOol07goo00=l7gooOol0@7oo000KOol00`00Oomoo`0?Ool00g`OOomoo`0^Ool0
0g`OOomoo`1KOol00g`OOomoo`0MOol00g`OOomoo`11Ool001]oo`03001oogoo00moo`03O1moogoo
02ioo`03O1moogoo05aoo`03O1moogoo01aoo`03O1moogoo045oo`001goo10000goo0P0017oo0P00
1Goo00<007ooOol047oo00=l7gooOol0;Goo00=l7gooOol0GGoo00=l7gooOol06Woo00=l7gooOol0
@Woo0007Ool00`00Oomoo`09Ool01000Oomoo`0017oo00<007ooOol047oo00=l7gooOol0;7oo00=l
7gooOol0Ggoo00=l7gooOol06Goo00=l7gooOol0@Woo0008Ool00`00Oomoo`0;Ool00`00Oomoo`02
Ool2000BOol00g`OOomoo`0[Ool00g`OOomoo`1OOol00g`OOomoo`0HOol00g`OOomoo`13Ool000Uo
o`03001oogoo00Qoo`8000Eoo`03001oogoo015oo`03O1moogoo02]oo`03O1moogoo061oo`03O1mo
ogoo01Moo`03O1moogoo04=oo`001goo00@007ooOol000Uoo`03001oogoo00Aoo`03001oogoo019o
o`03O1moogoo02Uoo`03O1moogoo069oo`03O1moogoo01Eoo`03O1moogoo04Aoo`0027oo0P002Woo
0`0017oo00<007ooOol04Woo00=l7gooOol0:Goo00=l7gooOol0Hgoo00=l7gooOol04goo00=l7goo
Ool0AGoo000KOol2000DOol00g`OOomoo`0XOol00g`OOomoo`1TOol00g`OOomoo`0AOol00g`OOomo
o`16Ool001]oo`03001oogoo01=oo`03O1moogoo02Qoo`03O1moogoo06Eoo`9l7`moo`9l7dUoo`00
6goo00<007ooOol057oo00=l7gooOol09Woo00=l7gooOol0J7oo00=l7gooOol02goo00=l7gooOol0
BGoo000KOol00`00Oomoo`0DOol00g`OOomoo`0VOol00g`OOomoo`1YOol00g`OOomoo`09Ool00g`O
Oomoo`1:Ool001]oo`03001oogoo01Eoo`03O1moogoo02Eoo`03O1moogoo06Yoo`03O1moogoo00Mo
o`03O1moogoo04]oo`006goo0P005Woo00=l7gooOol097oo00=l7gooOol0K7oo00=l7gooOol01Goo
00=l7gooOol0C7oo000KOol00`00Oomoo`0FOol00g`OOomoo`0SOol00g`OOomoo`1]Ool2O1l3Ool2
O1m?Ool001]oo`03001oogoo01Ioo`03O1moogoo02=oo`03O1moogoo06moo`03O1moog`O055oo`00
6goo00<007ooOol05goo00=l7gooOol08Woo00=l7gooOol0L7oo00=l7gooOol0D7oo000KOol00`00
Oomoo`0GOol00g`OOomoo`0QOol00g`OOomoo`34Ool001]oo`8001Uoo`03O1moogoo021oo`03O1mo
ogoo0<Aoo`006goo00<007ooOol06Goo00=l7gooOol07goo00=l7gooOol0a7oo000KOol00`00Oomo
o`0IOol00g`OOomoo`0OOol00g`OOomoo`34Ool001]oo`03001oogoo01Yoo`03O1moogoo01eoo`03
O1moogoo0<Eoo`006goo00<007ooOol06Woo00=l7gooOol07Goo00=l7gooOol0aGoo000KOol2000L
Ool00g`OOomoo`0LOol00g`OOomoo`35Ool001]oo`03001oogoo01]oo`03O1moogoo01]oo`03O1mo
ogoo0<Ioo`0057oo0P001Goo00<007ooOol077oo00=l7gooOol06Woo00=l7gooOol0aWoo000COol0
1000Oomoo`0017oo00<007ooOol07Goo00=l7gooOol06Goo00=l7gooOol0aWoo000FOol00`00Oomo
o`02Ool2000NOol00g`OOomoo`0IOol00g`OOomoo`36Ool001Aoo`8000Eoo`03001oogoo01ioo`03
O1moogoo01Moo`03O1moogoo0<Moo`0057oo00<007ooOol017oo00<007ooOol07Woo00=l7gooOol0
5goo00=l7gooOol0agoo000DOol30004Ool00`00Oomoo`0OOol00g`OOomoo`0EOol00g`OOomoo`38
Ool001]oo`03001oogoo01moo`03O1moogoo01Aoo`03O1moogoo0<Uoo`006goo0P008Goo00=l7goo
Ool04Woo00=l7gooOol0bWoo000KOol00`00Oomoo`0QOol00g`OOomoo`0@Ool00g`OOomoo`3;Ool0
01]oo`03001oogoo029oo`03O1moogoo00ioo`03O1moogoo0<aoo`006goo00<007ooOol08goo0W`O
3Goo00=l7gooOol0cGoo000KOol00`00Oomoo`0UOol00g`OOomoo`0:Ool00g`OOomoo`3=Ool001]o
o`8002Moo`03O1moogoo00Qoo`03O1moogoo0<ioo`006goo00<007ooOol09goo00=l7gooOol01Woo
00=l7gooOol0cgoo000KOol00`00Oomoo`0XOol00g`OOomoo`04Ool00g`OOomoo`3@Ool001]oo`03
001oogoo02Uoo`9l7`=oo`03O1moogoo0=5oo`006goo0P00;7oo00=l7gooO1l0e7oo000KOol00`00
Oomoo`0/Ool00g`OOomoo`3COol001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo
000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?moo`=oo`00ogoo8Goo003oOolQOol00?mo
ob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo
000JOol2003oOol5Ool001Yoo`800?moo`Eoo`006Goo00@007ooOol00?moo`Aoo`0067oo0P000Woo
0P00ogoo0goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.228198, -9.62095, \
0.00841412, 0.106135}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.3376 0.0053347 [
[.2619 .3251 -9 -9 ]
[.2619 .3251 9 0 ]
[.5 .3251 -3 -9 ]
[.5 .3251 3 0 ]
[.7381 .3251 -9 -9 ]
[.7381 .3251 9 0 ]
[.97619 .3251 -3 -9 ]
[.97619 .3251 3 0 ]
[1.025 .3376 0 -6.25 ]
[1.025 .3376 10 6.25 ]
[.01131 .01752 -18 -4.5 ]
[.01131 .01752 0 4.5 ]
[.01131 .12421 -18 -4.5 ]
[.01131 .12421 0 4.5 ]
[.01131 .23091 -18 -4.5 ]
[.01131 .23091 0 4.5 ]
[.01131 .44429 -12 -4.5 ]
[.01131 .44429 0 4.5 ]
[.01131 .55099 -12 -4.5 ]
[.01131 .55099 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .3376 m
.2619 .34385 L
s
[(0.5)] .2619 .3251 0 1 Mshowa
.5 .3376 m
.5 .34385 L
s
[(1)] .5 .3251 0 1 Mshowa
.7381 .3376 m
.7381 .34385 L
s
[(1.5)] .7381 .3251 0 1 Mshowa
.97619 .3376 m
.97619 .34385 L
s
[(2)] .97619 .3251 0 1 Mshowa
.125 Mabswid
.07143 .3376 m
.07143 .34135 L
s
.11905 .3376 m
.11905 .34135 L
s
.16667 .3376 m
.16667 .34135 L
s
.21429 .3376 m
.21429 .34135 L
s
.30952 .3376 m
.30952 .34135 L
s
.35714 .3376 m
.35714 .34135 L
s
.40476 .3376 m
.40476 .34135 L
s
.45238 .3376 m
.45238 .34135 L
s
.54762 .3376 m
.54762 .34135 L
s
.59524 .3376 m
.59524 .34135 L
s
.64286 .3376 m
.64286 .34135 L
s
.69048 .3376 m
.69048 .34135 L
s
.78571 .3376 m
.78571 .34135 L
s
.83333 .3376 m
.83333 .34135 L
s
.88095 .3376 m
.88095 .34135 L
s
.92857 .3376 m
.92857 .34135 L
s
.25 Mabswid
0 .3376 m
1 .3376 L
s
gsave
1.025 .3376 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .01752 m
.03006 .01752 L
s
[(-60)] .01131 .01752 1 0 Mshowa
.02381 .12421 m
.03006 .12421 L
s
[(-40)] .01131 .12421 1 0 Mshowa
.02381 .23091 m
.03006 .23091 L
s
[(-20)] .01131 .23091 1 0 Mshowa
.02381 .44429 m
.03006 .44429 L
s
[(20)] .01131 .44429 1 0 Mshowa
.02381 .55099 m
.03006 .55099 L
s
[(40)] .01131 .55099 1 0 Mshowa
.125 Mabswid
.02381 .04419 m
.02756 .04419 L
s
.02381 .07086 m
.02756 .07086 L
s
.02381 .09754 m
.02756 .09754 L
s
.02381 .15089 m
.02756 .15089 L
s
.02381 .17756 m
.02756 .17756 L
s
.02381 .20423 m
.02756 .20423 L
s
.02381 .25758 m
.02756 .25758 L
s
.02381 .28425 m
.02756 .28425 L
s
.02381 .31093 m
.02756 .31093 L
s
.02381 .36427 m
.02756 .36427 L
s
.02381 .39095 m
.02756 .39095 L
s
.02381 .41762 m
.02756 .41762 L
s
.02381 .47097 m
.02756 .47097 L
s
.02381 .49764 m
.02756 .49764 L
s
.02381 .52431 m
.02756 .52431 L
s
.02381 .57766 m
.02756 .57766 L
s
.02381 .60433 m
.02756 .60433 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .3376 m
.07143 .43865 L
.11905 .47351 L
.16667 .42973 L
.21429 .33783 L
.2619 .16561 L
.30952 .01472 L
.35714 .0516 L
.40476 .23937 L
.45238 .46429 L
.5 .60332 L
.54762 .59043 L
.59524 .28905 L
.64286 .38935 L
.69048 .44935 L
.7381 .32718 L
.78571 .22179 L
.83333 .18769 L
.88095 .23645 L
.92857 .33452 L
.97619 .4252 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00O5Goo00<007ooOol0
ogoo2Goo000EOol00`00Oomoo`3oOol9Ool000Moo`<000Aoo`8000Eoo`03001oogoo0?moo`Uoo`00
1goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`16Ool00`0OOomoo`2oOol000Moo`04
001oogoo0002Ool01000Oomoo`0017oo0P00Agoo0P0O`7oo00000goo000000020002Ool30003Ool0
1000Oomoo`0017oo00<007ooOol0AGoo00@07gooOol07kmoo`0027oo00<007ooOol00Woo00@007oo
Ool000Aoo`03001oogoo04Eoo`0401moogooOol201nmOol000Qoo`<000=oo`8000Eoo`03001oogoo
04Eoo`0301moogoo00=oo`0301moogoo0;Yoo`005Goo00<007ooOol0A7oo00<07gooOol01Goo00<0
7gooOol0^Goo000EOol00`00Oomoo`14Ool00`0OOomoo`06Ool00`0OOomoo`2hOol001Eoo`03001o
ogoo04Aoo`0301moogoo00Moo`0301moogoo0;Moo`005Goo0P00AGoo00<07gooOol027oo0P0O]goo
000EOol00`00Oomoo`13Ool00`0OOomoo`0;Ool00`0OOomoo`2dOol001Eoo`03001oogoo04=oo`03
01moogoo00aoo`0301moogoo0;=oo`005Goo00<007ooOol0@goo00<07gooOol037oo00<07gooOol0
/goo000EOol00`00Oomoo`12Ool00`0OOomoo`0>Ool00`0OOomoo`2bOol001Eoo`03001oogoo049o
o`0301moogoo00ioo`0301moogoo0;9oo`005Goo00<007ooOol0@Woo00<07gooOol03Woo00<07goo
Ool0/Woo000EOol20012Ool00`0OOomoo`0?Ool00`0OOomoo`2bOol001Eoo`03001oogoo045oo`03
01moogoo011oo`0301moogoo0;5oo`005Goo00<007ooOol0@Goo00<07gooOol047oo00<07gooOol0
/Goo000EOol00`00Oomoo`10Ool00`0OOomoo`0AOol00`0OOomoo`2aOol001Eoo`03001oogoo041o
o`0301moogoo015oo`0301moogoo0;5oo`005Goo00<007ooOol0@7oo00<07gooOol04Woo00<07goo
Ool0/7oo000EOol00`00Oomoo`10Ool00`0OOomoo`0BOol00`0OOomoo`2`Ool001Eoo`80041oo`03
01moogoo01=oo`0301moogoo0;1oo`005Goo00<007ooOol0?goo00<07gooOol04goo00<07gooOol0
/7oo000EOol00`00Oomoo`0oOol00`0OOomoo`0DOol00`0OOomoo`2_Ool001Eoo`03001oogoo03io
o`0301moogoo01Eoo`0301moogoo0:moo`002Goo0`000Woo0P001Goo00<007ooOol0?Woo00<07goo
Ool05Goo00<07gooOol0[goo000:Ool01000Oomoo`000Woo00<007ooOol00Woo00<007ooOol0?Woo
00<07gooOol05Goo00<07gooOol0[goo0007Ool500001Goo001oogoo000017oo0P00?Woo00<07goo
Ool05goo00<07gooOol0[Woo00000goo000000020002Ool01000Oomoo`000Woo00@007ooOol000Ao
o`03001oogoo03eoo`0301moogoo01Moo`0301moogoo0:ioo`0027oo00<007oo00000Woo00@007oo
Ool000Aoo`03001oogoo03eoo`0301moogoo01Moo`0301moogoo0:ioo`002Goo0P000goo0P001Goo
00<007ooOol0?7oo00<07gooOol067oo00<07gooOol0[Woo000EOol00`00Oomoo`0lOol00`0OOomo
o`0IOol00`0OOomoo`2]Ool001Eoo`03001oogoo03aoo`0301moogoo01Uoo`0301moogoo0:eoo`00
5Goo00<007ooOol0?7oo00<07gooOol06Goo00<07gooOol0[Goo000EOol2000lOol00`0OOomoo`0J
Ool00`0OOomoo`2]Ool001Eoo`03001oogoo03]oo`0301moogoo01]oo`0301moogoo0:aoo`005Goo
00<007ooOol0>goo00<07gooOol06goo00<07gooOol0[7oo000EOol00`00Oomoo`0jOol00`0OOomo
o`0LOol00`0OOomoo`2/Ool001Eoo`03001oogoo03Yoo`0301moogoo01aoo`0301moogoo0:aoo`00
5Goo00<007ooOol0>Woo00<07gooOol07Goo00<07gooOol0Zgoo000EOol00`00Oomoo`0iOol00`0O
Oomoo`0NOol00`0OOomoo`2[Ool001Eoo`8003Yoo`0301moogoo01ioo`0301moogoo0:]oo`005Goo
00<007ooOol0>Goo00<07gooOol07Woo00<07gooOol0Zgoo000EOol00`00Oomoo`0iOol00`0OOomo
o`0OOol00`0OOomoo`2ZOol001Eoo`03001oogoo03Qoo`0301moogoo021oo`0301moogoo06ioo`03
01moogoo03Uoo`005Goo00<007ooOol0>7oo00<07gooOol087oo00<07gooOol0K7oo0P0O00=oo`0O
Ool0>Goo000EOol00`00Oomoo`0hOol00`0OOomoo`0POol00`0OOomoo`1ZOol201l4Ool00`0OOomo
o`0gOol001Eoo`03001oogoo03Moo`0301moogoo029oo`0301moogoo06Qoo`0301moogoo00Eoo`03
01moogoo03Ioo`005Goo0P00>7oo00<07gooOol08Woo00<07gooOol0IWoo0P0O2Goo00<07gooOol0
=Goo000EOol00`00Oomoo`0gOol00`0OOomoo`0ROol00`0OOomoo`1UOol00`0OOomoo`0:Ool00`0O
Oomoo`0dOol001Eoo`03001oogoo03Ioo`0301moogoo02=oo`0301moogoo06=oo`807`ioo`0301mo
ogoo03=oo`005Goo00<007ooOol0=Woo00<07gooOol097oo00<07gooOol0H7oo0P0O4Goo00<07goo
Ool0<Woo000EOol00`00Oomoo`0fOol00`0OOomoo`0TOol00`0OOomoo`1OOol00`0OOomoo`0BOol0
0`0OOomoo`0aOol000Moo`@000=oo`8000Eoo`03001oogoo03Ioo`0301moogoo02Aoo`0301moogoo
05moo`0301moogoo01=oo`0301moogoo031oo`001goo00<007ooOol00goo00@007ooOol000Aoo`03
001oogoo03Eoo`0301moogoo02Eoo`0301moogoo05ioo`0301moogoo01Eoo`0301moogoo02moo`00
27oo00<007ooOol00Woo00@007ooOol000Aoo`8003Ioo`0301moogoo02Ioo`0301moogoo05eoo`03
01moogoo01Ioo`0301moogoo02ioo`0000=oo`0000000P0017oo00D007ooOomoo`00009oo`03001o
ogoo009oo`03001oogoo03Eoo`0301moogoo02Ioo`0301moogoo05aoo`0301moogoo01Qoo`0301mo
ogoo02eoo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`0dOol00`0OOomoo`0W
Ool00`0OOomoo`1LOol00`0OOomoo`0HOol00`0OOomoo`0]Ool000Qoo`8000Aoo`8000Eoo`03001o
ogoo03Aoo`0301moogoo02Moo`0301moogoo05]oo`0301moogoo01Yoo`0301moogoo02aoo`005Goo
00<007ooOol0=7oo00<07gooOol09goo00<07gooOol0Fgoo00<07gooOol06Woo00<07gooOol0;7oo
000EOol00`00Oomoo`0cOol00`0OOomoo`0YOol00`0OOomoo`1IOol00`0OOomoo`0LOol00`0OOomo
o`0[Ool001Eoo`8003Aoo`0301moogoo02Uoo`0301moogoo05Uoo`0301moogoo01aoo`0301moogoo
02]oo`005Goo00<007ooOol0<goo00<07gooOol0:Goo00<07gooOol0FGoo00<07gooOol07Goo00<0
7gooOol0:Woo000EOol00`00Oomoo`0cOol00`0OOomoo`0YOol00`0OOomoo`1HOol00`0OOomoo`0N
Ool00`0OOomoo`0ZOol001Eoo`03001oogoo039oo`0301moogoo02Yoo`0301moogoo05Qoo`0301mo
ogoo01moo`0301moogoo02Uoo`005Goo00<007ooOol0<Woo00<07gooOol0:goo00<07gooOol0EWoo
00<07gooOol087oo00<07gooOol0:Goo000EOol00`00Oomoo`0bOol00`0OOomoo`0[Ool00`0OOomo
o`1FOol00`0OOomoo`0QOol00`0OOomoo`0XOol001Eoo`03001oogoo035oo`0301moogoo02aoo`03
01moogoo05Eoo`0301moogoo029oo`0301moogoo02Qoo`005Goo0P00<Woo00<07gooOol0;7oo00<0
7gooOol0EGoo00<07gooOol08goo00<07gooOol09goo000EOol00`00Oomoo`0aOol00`0OOomoo`0]
Ool00`0OOomoo`0[Ool00`0OOomoo`0UOol00`0OOomoo`0TOol00`0OOomoo`0WOol001Eoo`03001o
ogoo035oo`0301moogoo02eoo`0301moogoo02]oo`0301moogoo02Eoo`0301moogoo02Eoo`0301mo
ogoo02Ioo`005Goo00<007ooOol0<7oo00<07gooOol00P0017oo0P0017oo0P0087oo00<07gooOol0
47oo1@005Woo0P0O6Woo1@000Woo0P000goo00<07`0000009Goo00<07gooOol037oo10005Woo000E
Ool00`00Oomoo`0`Ool00`0OOol00002Ool00`00Oomoo`06Ool01000Oomoo`007goo00<07gooOol0
4Woo00<007ooOol05Woo0P0O77oo00<007ooOol01Woo00D07`00Oomoo`0002Eoo`0301moogoo00]o
o`03001oogoo01Moo`005Goo00<007ooOol0<7oo00<07goo00000Woo00<007ooOol02Goo00<007oo
Ool07Goo00<07gooOol04Woo00<007ooOol05Goo00@07gooOol07a]oo`03001oogoo00Ioo`0501mo
ogooOol0000UOol00`0OOomoo`0<Ool00`00Oomoo`0FOol001Eoo`03001oogoo02moo`0401moogoo
0002Ool00`00Oomoo`07Ool2000QOol00`0OOomoo`0AOol00`00Oomoo`0EOol0100OOomoo`0O6goo
00<007ooOol01Goo00<07gooOol00P009goo00<07gooOol037oo00<007ooOol05Goo000EOol2000`
Ool0100OOomoo`000Woo00<007ooOol01goo00<007ooOol087oo00<07gooOol04Goo00<007ooOol0
5Goo00D07gooOomoo`0O01Yoo`03001oogoo00Eoo`0401moogoo000XOol00`0OOomoo`0:Ool01000
Oomoo`005Woo000EOol00`00Oomoo`0_Ool0100OOomoogoo0P002Woo0`0087oo00<07gooOol047oo
0P005goo00D07gooOomoo`0O01Uoo`8000Ioo`0401moogooOol3000WOol00`0OOomoo`0:Ool2000G
Ool001Eoo`03001oogoo02ioo`0301moogoo035oo`0301moogoo02Uoo`0301moogoo009oo`0301mo
ogoo01ioo`0301moogoo02]oo`0301moogoo02=oo`005Goo00<007ooOol0;Woo00<07gooOol0<Goo
00<07gooOol0:Goo00<07gooOol00Woo00<07gooOol07Goo00<07gooOol0;Goo00<07gooOol08Woo
000EOol00`00Oomoo`0^Ool00`0OOomoo`0bOol00`0OOomoo`0WOol00`0OOomoo`04Ool00`0OOomo
o`0LOol00`0OOomoo`0]Ool00`0OOomoo`0ROol001Eoo`03001oogoo02ioo`0301moogoo039oo`03
01moogoo02Moo`0301moogoo00Aoo`0301moogoo01aoo`0301moogoo02ioo`0301moogoo01Yoo`80
00Eoo`005Goo00<007ooOol0;Goo00<07gooOol0<goo00<07gooOol09goo00<07gooOol01Goo00<0
7gooOol06Woo00<07gooOol0;goo00<07gooOol06Goo00@007ooOol000Aoo`003goo1P0000<07`00
0000;@0000<07`000000<`0000<07`0000009`0000<07`0000001@0000<07`0000006P0000<07`00
0000<00000<07`0000003`002Goo00<007ooOol01Goo000EOol00`0OOomoo`09Ool00`00Oomoo`09
Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`0O001oo`0;Ool00`00Oomoo`09Ool00`00Oomoo`09
Ool00`00Oomoo`09Ool00`00Oomoo`02Ool00`0OOomoo`04Ool00`00Oomoo`09Ool00`00Oomoo`0:
Ool00`00Oomoo`07Ool00`0OOol00005Ool00`0OOomoo`03Ool00`00Oomoo`09Ool00`00Oomoo`07
Ool00`0OOol0000;Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`0001moo`09
Ool00`00Oomoo`0<Ool50004Ool001Eoo`0300007goo02aoo`0301moogoo03Eoo`0301moogoo02Io
o`0301moogoo00Ioo`0301moogoo01Qoo`0301moogoo039oo`0301moogoo01Moo`03001oogoo00Eo
o`005Goo00<0000OOol0:goo00<07gooOol0=Woo00<07gooOol09Woo00<07gooOol01Woo00<07goo
Ool067oo00<07gooOol0<Woo00<07gooOol07goo000EOol00`00Ool07`0[Ool00`0OOomoo`0fOol0
0`0OOomoo`0UOol00`0OOomoo`08Ool00`0OOomoo`0FOol00`0OOomoo`0dOol00`0OOomoo`0NOol0
01Eoo`03001oo`0O02Yoo`0301moogoo03Moo`0301moogoo02Eoo`0301moogoo00Qoo`0301moogoo
01Ioo`0301moogoo03Aoo`0301moogoo01ioo`005Goo00@007ooOol07bUoo`0301moogoo03Qoo`03
01moogoo02Aoo`0301moogoo00Uoo`0301moogoo01Eoo`0301moogoo03Eoo`0301moogoo01eoo`00
5Goo0P0000=oo`0OOol09goo00<07gooOol0>Goo00<07gooOol097oo00<07gooOol02Goo00<07goo
Ool057oo00<07gooOol0=Woo00<07gooOol07Goo000EOol01@00Oomoogoo01l09goo00<07gooOol0
>Goo00<07gooOol097oo00<07gooOol02Woo00<07gooOol04goo00<07gooOol0=goo00<07gooOol0
77oo000EOol01@00Oomoogoo01l09Woo00<07gooOol0>Woo00<07gooOol097oo00<07gooOol02Woo
00<07gooOol04Woo00<07gooOol0>7oo00<07gooOol077oo000EOol00`00Oomoo`02Ool00`0OOomo
o`0SOol00`0OOomoo`0jOol00`0OOomoo`0SOol00`0OOomoo`0<Ool00`0OOomoo`0AOol00`0OOomo
o`0iOol00`0OOomoo`0KOol001Eoo`03001oogoo009oo`0301moogoo029oo`0301moogoo03aoo`03
01moogoo029oo`0301moogoo00aoo`0301moogoo015oo`0301moogoo03Uoo`0301moogoo01]oo`00
5Goo00<007ooOol00goo00<07gooOol08Goo00<07gooOol0?7oo00<07gooOol08Woo00<07gooOol0
3Goo00<07gooOol03goo00<07gooOol0>goo00<07gooOol06Woo000EOol00`00Oomoo`03Ool00`0O
Oomoo`0POol00`0OOomoo`0mOol00`0OOomoo`0ROol00`0OOomoo`0=Ool00`0OOomoo`0?Ool00`0O
Oomoo`0kOol00`0OOomoo`0JOol001Eoo`8000Aoo`0301moogoo021oo`0301moogoo03eoo`0301mo
ogoo029oo`0301moogoo00ioo`0301moogoo00eoo`0301moogoo03eoo`0301moogoo01Uoo`005Goo
00<007ooOol017oo00<07gooOol07Woo00<07gooOol0?Woo00<07gooOol08Woo00<07gooOol03goo
00<07gooOol037oo00<07gooOol0?Goo00<07gooOol06Goo000EOol00`00Oomoo`04Ool00`0OOomo
o`0NOol00`0OOomoo`0oOol00`0OOomoo`0POol00`0OOomoo`0@Ool00`0OOomoo`0<Ool00`0OOomo
o`0nOol00`0OOomoo`0HOol001Eoo`03001oogoo00Eoo`0301moogoo01aoo`0301moogoo041oo`03
01moogoo021oo`0301moogoo015oo`0301moogoo00Yoo`0301moogoo03moo`0301moogoo01Qoo`00
5Goo00<007ooOol01Goo00<07gooOol077oo00<07gooOol0@7oo00<07gooOol087oo00<07gooOol0
4Woo00<07gooOol02Goo00<07gooOol0@7oo00<07gooOol05goo000EOol00`00Oomoo`06Ool00`0O
Oomoo`0JOol00`0OOomoo`11Ool00`0OOomoo`0POol00`0OOomoo`0COol00`0OOomoo`07Ool00`0O
Oomoo`11Ool00`0OOomoo`0GOol001Eoo`8000Moo`0301moogoo01Yoo`0301moogoo045oo`0301mo
ogoo021oo`0301moogoo01Aoo`0301moogoo00Ioo`0301moogoo049oo`0301moogoo01Ioo`005Goo
00<007ooOol01goo00<07gooOol067oo00<07gooOol0@goo00<07gooOol07goo00<07gooOol057oo
00<07gooOol01Woo00<07gooOol0@Woo00<07gooOol05Woo000EOol00`00Oomoo`07Ool00`0OOomo
o`0HOol00`0OOomoo`13Ool00`0OOomoo`0OOol00`0OOomoo`0EOol00`0OOomoo`04Ool00`0OOomo
o`14Ool00`0OOomoo`0EOol001Eoo`03001oogoo00Qoo`0301moogoo01Ioo`0301moogoo04Aoo`03
01moogoo01ioo`0301moogoo01Moo`0301moogoo00=oo`0301moogoo05aoo`005Goo00<007ooOol0
27oo00<07gooOol05Goo00<07gooOol0AGoo00<07gooOol07Woo00<07gooOol067oo00<07gooOol0
0Woo00<07gooOol0G7oo0007Ool40003Ool20005Ool00`00Oomoo`09Ool00`0OOomoo`0COol00`0O
Oomoo`17Ool00`0OOomoo`0MOol00`0OOomoo`0IOol0100OOomoo`0OGgoo0007Ool00`00Oomoo`03
Ool01000Oomoo`0017oo00<007ooOol02Goo00<07gooOol04Woo00<07gooOol0B7oo00<07gooOol0
7Goo00<07gooOol06Goo00@07gooOol07emoo`0027oo00<007ooOol00Woo00@007ooOol000Aoo`80
00]oo`0301moogoo011oo`0301moogoo04Uoo`0301moogoo01eoo`0301moogoo01Yoo`807f1oo`00
2Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo00]oo`807`moo`0301moogoo04Yo
o`0301moogoo01eoo`0301moogoo01]oo`0301moogoo05ioo`001goo00@007ooOol0009oo`04001o
ogoo0004Ool00`00Oomoo`0=Ool00`0OOomoo`0;Ool00`0OOomoo`1;Ool00`0OOomoo`0LOol00`0O
Oomoo`1mOol000Qoo`8000Aoo`8000Eoo`03001oogoo00ioo`0301moogoo00Uoo`0301moogoo04eo
o`0301moogoo01]oo`0301moogoo07eoo`005Goo00<007ooOol03goo0P0O27oo00<07gooOol0CWoo
00<07gooOol06goo00<07gooOol0OGoo000EOol00`00Oomoo`0AOol00`0OOomoo`04Ool00`0OOomo
o`1?Ool00`0OOomoo`0KOol00`0OOomoo`1mOol001Eoo`03001oogoo019oo`0301moogoo009oo`03
01moogoo051oo`0301moogoo01]oo`0301moogoo07eoo`005Goo0P0057oo0P0O00=oo`0OOol0Dgoo
00<07gooOol06Woo00<07gooOol0OGoo000EOol00`00Oomoo`0EOol00`0OOomoo`1COol00`0OOomo
o`0JOol00`0OOomoo`1mOol001Eoo`03001oogoo06]oo`0301moogoo01Uoo`0301moogoo07ioo`00
5Goo00<007ooOol0K7oo00<07gooOol067oo00<07gooOol0OWoo000EOol00`00Oomoo`1/Ool00`0O
Oomoo`0HOol00`0OOomoo`1nOol001Eoo`03001oogoo06aoo`0301moogoo01Qoo`0301moogoo07io
o`005Goo00<007ooOol0KGoo00<07gooOol05goo00<07gooOol0OWoo000EOol2001^Ool00`0OOomo
o`0GOol00`0OOomoo`1nOol001Eoo`03001oogoo06eoo`0301moogoo01Ioo`0301moogoo07moo`00
5Goo00<007ooOol0KWoo00<07gooOol05Goo00<07gooOol0Ogoo000EOol00`00Oomoo`1^Ool00`0O
Oomoo`0EOol00`0OOomoo`1oOol001Eoo`03001oogoo06ioo`0301moogoo01Eoo`0301moogoo07mo
o`005Goo00<007ooOol0Kgoo00<07gooOol057oo00<07gooOol0Ogoo000EOol00`00Oomoo`1_Ool0
0`0OOomoo`0DOol00`0OOomoo`1oOol001Eoo`80071oo`0301moogoo01=oo`0301moogoo081oo`00
5Goo00<007ooOol0L7oo00<07gooOol04Woo00<07gooOol0P7oo000EOol00`00Oomoo`1`Ool00`0O
Oomoo`0BOol00`0OOomoo`20Ool001Eoo`03001oogoo071oo`0301moogoo019oo`0301moogoo081o
o`002Goo0`000Woo0P001Goo00<007ooOol0LGoo00<07gooOol04Goo00<07gooOol0P7oo000:Ool0
1000Oomoo`000Woo00<007ooOol00Woo00<007ooOol0LGoo00<07gooOol04Goo00<07gooOol0P7oo
0007Ool500001Goo001oogoo000017oo0P00LWoo00<07gooOol04Goo00<07gooOol0P7oo0007Ool0
1000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo079oo`0301moogoo00moo`0301moogoo085o
o`0027oo00<007oo00000Woo00@007ooOol000Aoo`03001oogoo079oo`0301moogoo00moo`0301mo
ogoo085oo`002Goo0P000goo0P001Goo00<007ooOol0LWoo00<07gooOol03goo00<07gooOol0PGoo
000EOol00`00Oomoo`1cOol00`0OOomoo`0>Ool00`0OOomoo`21Ool001Eoo`03001oogoo07=oo`03
01moogoo00ioo`0301moogoo085oo`005Goo00<007ooOol0Lgoo00<07gooOol03Woo00<07gooOol0
PGoo000EOol2001eOol00`0OOomoo`0<Ool00`0OOomoo`22Ool001Eoo`03001oogoo07Aoo`0301mo
ogoo00aoo`0301moogoo089oo`005Goo00<007ooOol0M7oo00<07gooOol037oo00<07gooOol0PWoo
000EOol00`00Oomoo`1eOol00`0OOomoo`0:Ool201n4Ool001Eoo`03001oogoo07Eoo`0301moogoo
00Moo`<07hIoo`005Goo00<007ooOol0MGoo00<07gooOol00goo100ORGoo000EOol00`00Oomoo`1f
Ool00`0OOol07`0201n=Ool001Eoo`8007Moo`807i1oo`005Goo00<007ooOol0ogoo2Goo000EOol0
0`00Oomoo`3oOol9Ool001Eoo`03001oogoo0?moo`Uoo`005Goo00<007ooOol0ogoo2Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol001=oo`D00?moo`Uoo`004goo1000ogoo2Woo000FOol00`00Oomoo`3oOol8
Ool001Aoo`<00?moo`Yoo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.174205, -63.3451, \
0.0082192, 0.733668}}],

Cell[BoxData[
    InterpretationBox[\("t"\[InvisibleSpace]"         "\[InvisibleSpace]"p    \
     "\[InvisibleSpace]"u"\[InvisibleSpace]"          \
v"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]"         a"\),
      SequenceForm[ 
      "t", "         ", "p         ", "u", "          v", "", "         a"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("----------------------------------------------------"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        InterpretationBox[GridBox[{
              {"0"},
              {"0.1`"},
              {"0.2`"},
              {"0.30000000000000004`"},
              {"0.4`"},
              {"0.5`"},
              {"0.6000000000000001`"},
              {"0.7000000000000001`"},
              {"0.8`"},
              {"0.9`"},
              {"1.`"},
              {"1.1`"},
              {"1.2000000000000002`"},
              {"1.3`"},
              {"1.4000000000000001`"},
              {"1.5`"},
              {"1.6`"},
              {"1.7000000000000002`"},
              {"1.8`"},
              {"1.9000000000000001`"},
              {"2.`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0, 1.1000000000000001, 
            1.2000000000000002, 1.3, 1.4000000000000001, 1.5, 
            1.6000000000000001, 1.7000000000000002, 1.8, 1.9000000000000001, 
            2.0}]], "\[InvisibleSpace]", "\<\"     \"\>", "\[InvisibleSpace]",
         
        InterpretationBox[GridBox[{
              {"0"},
              {"4.444444444444443`"},
              {"8.88888888888889`"},
              {"13.333333333333336`"},
              {"17.77777777777778`"},
              {"18.461538461538463`"},
              {"15.384615384615383`"},
              {"12.307692307692307`"},
              {"9.230769230769232`"},
              {"6.153846153846157`"},
              {"3.07692307692308`"},
              {"0"},
              {\(-9.99999999999999`\)},
              {\(-4.999999999999994`\)},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 4.4444444444444429, 8.8888888888888893, 
            13.333333333333336, 17.777777777777779, 18.461538461538463, 
            15.384615384615383, 12.307692307692307, 9.2307692307692317, 
            6.1538461538461569, 3.0769230769230802, 
            0, -9.9999999999999893, -4.9999999999999938, 0, 0, 0, 0, 0, 0, 
            0}]], "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"0.031897545091056974`"},
              {"0.2352821170291642`"},
              {"0.6775989034933538`"},
              {"1.2930207825818543`"},
              {"1.9027275300332263`"},
              {"2.2124396023323367`"},
              {"1.9795423781037789`"},
              {"1.2453189422503437`"},
              {"0.31386531073168866`"},
              {\(-0.43381168144006044`\)},
              {\(-0.749494543243175`\)},
              {\(-0.687229323408719`\)},
              {\(-0.5881788176735225`\)},
              {\(-0.4007494927348362`\)},
              {\(-0.05332613252223195`\)},
              {"0.2904918075152122`"},
              {"0.4481896015662853`"},
              {"0.35302579069492696`"},
              {"0.07887429303875132`"},
              {\(-0.21200001841273242`\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .031897545091056974, .23528211702916421, .67759890349335383, 
            1.2930207825818543, 1.9027275300332263, 2.2124396023323367, 
            1.9795423781037789, 
            1.2453189422503437, .31386531073168866, -.43381168144006044, \
-.74949454324317499, -.68722932340871901, -.58817881767352254, \
-.40074949273483618, -.05332613252223195, .2904918075152122, \
.44818960156628529, .35302579069492696, .07887429303875132, \
-.21200001841273242}]], "\[InvisibleSpace]", "\<\"   \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"0.9569263525403239`"},
              {"3.2406064674912045`"},
              {"5.5144835161264965`"},
              {"6.570184742593338`"},
              {"5.148647815284334`"},
              {"0.6060355476083239`"},
              {\(-5.172720961069723`\)},
              {\(-9.000678524131182`\)},
              {\(-9.02156845005874`\)},
              {\(-5.5745526956559175`\)},
              {\(-0.8118616580673312`\)},
              {"1.1220029858885265`"},
              {"1.1825458685936616`"},
              {"2.7727903032808814`"},
              {"3.829742276979861`"},
              {"2.7527465591506557`"},
              {"0.31089729829010593`"},
              {\(-2.0716270630377105`\)},
              {\(-3.1332301288242457`\)},
              {\(-2.4308709701153663`\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, .95692635254032388, 3.2406064674912045, 
            5.5144835161264965, 6.5701847425933382, 
            5.1486478152843338, .6060355476083239, -5.1727209610697233, \
-9.0006785241311817, -9.0215684500587408, -5.5745526956559175, \
-.81186165806733124, 1.1220029858885265, 1.1825458685936616, 
            2.7727903032808814, 3.8297422769798608, 
            2.7527465591506557, .31089729829010593, -2.0716270630377105, \
-3.1332301288242457, -2.4308709701153663}]], 
        "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"18.941559709869203`"},
              {"25.47614285743061`"},
              {"17.270091958858778`"},
              {"0.04370246710651671`"},
              {\(-32.23938017879895`\)},
              {\(-60.525337221168286`\)},
              {\(-53.611652592781304`\)},
              {\(-18.413668952052866`\)},
              {"23.747596608129456`"},
              {"49.80962390658771`"},
              {"47.393538516818275`"},
              {\(-9.100733370178853`\)},
              {"9.699954151366708`"},
              {"20.9475584608813`"},
              {\(-1.9538582362146129`\)},
              {\(-21.709131900100775`\)},
              {\(-28.101637195375588`\)},
              {\(-18.961213499050103`\)},
              {\(-0.5779623186537036`\)},
              {"16.42129436604425`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 18.941559709869203, 25.476142857430609, 
            17.270091958858778, .043702467106516707, -32.239380178798953, \
-60.525337221168286, -53.611652592781304, -18.413668952052866, 
            23.747596608129456, 49.80962390658771, 
            47.393538516818275, -9.1007333701788529, 9.6999541513667076, 
            20.9475584608813, -1.9538582362146129, -21.709131900100775, \
-28.101637195375588, -18.961213499050103, -.57796231865370362, 
            16.421294366044251}]]}],
      SequenceForm[ 
        TableForm[ {
          0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0, 1.1000000000000001, 
          1.2000000000000002, 1.3, 1.4000000000000001, 1.5, 
          1.6000000000000001, 1.7000000000000002, 1.8, 1.9000000000000001, 
          2.0}], "     ", 
        TableForm[ {0, 4.4444444444444429, 8.8888888888888893, 
          13.333333333333336, 17.777777777777779, 18.461538461538463, 
          15.384615384615383, 12.307692307692307, 9.2307692307692317, 
          6.1538461538461569, 3.0769230769230802, 
          0, -9.9999999999999893, -4.9999999999999938, 0, 0, 0, 0, 0, 0, 0}], 
        
        TableForm[ {
          0, .031897545091056974, .23528211702916421, .67759890349335383, 
          1.2930207825818543, 1.9027275300332263, 2.2124396023323367, 
          1.9795423781037789, 
          1.2453189422503437, .31386531073168866, -.43381168144006044, \
-.74949454324317499, -.68722932340871901, -.58817881767352254, \
-.40074949273483618, -.05332613252223195, .2904918075152122, \
.44818960156628529, .35302579069492696, .07887429303875132, \
-.21200001841273242}], "   ", 
        TableForm[ {0, .95692635254032388, 3.2406064674912045, 
          5.5144835161264965, 6.5701847425933382, 
          5.1486478152843338, .6060355476083239, -5.1727209610697233, \
-9.0006785241311817, -9.0215684500587408, -5.5745526956559175, \
-.81186165806733124, 1.1220029858885265, 1.1825458685936616, 
          2.7727903032808814, 3.8297422769798608, 
          2.7527465591506557, .31089729829010593, -2.0716270630377105, \
-3.1332301288242457, -2.4308709701153663}], "  ", 
        TableForm[ {0, 18.941559709869203, 25.476142857430609, 
          17.270091958858778, .043702467106516707, -32.239380178798953, \
-60.525337221168286, -53.611652592781304, -18.413668952052866, 
          23.747596608129456, 49.80962390658771, 
          47.393538516818275, -9.1007333701788529, 9.6999541513667076, 
          20.9475584608813, -1.9538582362146129, -21.709131900100775, \
-28.101637195375588, -18.961213499050103, -.57796231865370362, 
          16.421294366044251}]],
      Editable->False]], "Print"]
}, Open  ]],

Cell["\<\
Veamos ahora el mismo caso anterior, pero en el supuesto de que el material \
no resista a tracci\[OAcute]n ( hormig\[OAcute]n ). \
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["\<\
p={{0,0},{.45,20},{1.1,0},{1.2,-10},{1.4,0}};
HilbergNoLineal[0,2,.1,0,0,12.35,.2,.274,p,  
        0.5,0.1666666667,-0.1,-15,0,posicion,velocidad,aceleracion] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]1\[InvisibleSpace]"     j = "\
\[InvisibleSpace]7\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 1, "     j = ", 7, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]2\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 2, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]3\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 3, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]4\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 4, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]5\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 5, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]6\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 6, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]7\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 7, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]8\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 8, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]9\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 9, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]10\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 10, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]11\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 11, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]12\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 12, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]13\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 13, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]14\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 14, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]15\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 15, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]16\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 16, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]17\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 17, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]18\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 18, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]19\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 19, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]20\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0\),
      SequenceForm[ 
      "i = ", 20, "     j = ", 3, "      kt = ", 0, "      fs = ", 0],
      Editable->False]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.221522 0.0206807 [
[.2619 .20902 -9 -9 ]
[.2619 .20902 9 0 ]
[.5 .20902 -3 -9 ]
[.5 .20902 3 0 ]
[.7381 .20902 -9 -9 ]
[.7381 .20902 9 0 ]
[.97619 .20902 -3 -9 ]
[.97619 .20902 3 0 ]
[1.025 .22152 0 -6.25 ]
[1.025 .22152 10 6.25 ]
[.01131 .01472 -18 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .11812 -12 -4.5 ]
[.01131 .11812 0 4.5 ]
[.01131 .32493 -6 -4.5 ]
[.01131 .32493 0 4.5 ]
[.01131 .42833 -12 -4.5 ]
[.01131 .42833 0 4.5 ]
[.01131 .53173 -12 -4.5 ]
[.01131 .53173 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .22152 m
.2619 .22777 L
s
[(0.5)] .2619 .20902 0 1 Mshowa
.5 .22152 m
.5 .22777 L
s
[(1)] .5 .20902 0 1 Mshowa
.7381 .22152 m
.7381 .22777 L
s
[(1.5)] .7381 .20902 0 1 Mshowa
.97619 .22152 m
.97619 .22777 L
s
[(2)] .97619 .20902 0 1 Mshowa
.125 Mabswid
.07143 .22152 m
.07143 .22527 L
s
.11905 .22152 m
.11905 .22527 L
s
.16667 .22152 m
.16667 .22527 L
s
.21429 .22152 m
.21429 .22527 L
s
.30952 .22152 m
.30952 .22527 L
s
.35714 .22152 m
.35714 .22527 L
s
.40476 .22152 m
.40476 .22527 L
s
.45238 .22152 m
.45238 .22527 L
s
.54762 .22152 m
.54762 .22527 L
s
.59524 .22152 m
.59524 .22527 L
s
.64286 .22152 m
.64286 .22527 L
s
.69048 .22152 m
.69048 .22527 L
s
.78571 .22152 m
.78571 .22527 L
s
.83333 .22152 m
.83333 .22527 L
s
.88095 .22152 m
.88095 .22527 L
s
.92857 .22152 m
.92857 .22527 L
s
.25 Mabswid
0 .22152 m
1 .22152 L
s
gsave
1.025 .22152 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .01472 m
.03006 .01472 L
s
[(-10)] .01131 .01472 1 0 Mshowa
.02381 .11812 m
.03006 .11812 L
s
[(-5)] .01131 .11812 1 0 Mshowa
.02381 .32493 m
.03006 .32493 L
s
[(5)] .01131 .32493 1 0 Mshowa
.02381 .42833 m
.03006 .42833 L
s
[(10)] .01131 .42833 1 0 Mshowa
.02381 .53173 m
.03006 .53173 L
s
[(15)] .01131 .53173 1 0 Mshowa
.125 Mabswid
.02381 .0354 m
.02756 .0354 L
s
.02381 .05608 m
.02756 .05608 L
s
.02381 .07676 m
.02756 .07676 L
s
.02381 .09744 m
.02756 .09744 L
s
.02381 .1388 m
.02756 .1388 L
s
.02381 .15948 m
.02756 .15948 L
s
.02381 .18016 m
.02756 .18016 L
s
.02381 .20084 m
.02756 .20084 L
s
.02381 .2422 m
.02756 .2422 L
s
.02381 .26288 m
.02756 .26288 L
s
.02381 .28356 m
.02756 .28356 L
s
.02381 .30424 m
.02756 .30424 L
s
.02381 .34561 m
.02756 .34561 L
s
.02381 .36629 m
.02756 .36629 L
s
.02381 .38697 m
.02756 .38697 L
s
.02381 .40765 m
.02756 .40765 L
s
.02381 .44901 m
.02756 .44901 L
s
.02381 .46969 m
.02756 .46969 L
s
.02381 .49037 m
.02756 .49037 L
s
.02381 .51105 m
.02756 .51105 L
s
.02381 .55241 m
.02756 .55241 L
s
.02381 .57309 m
.02756 .57309 L
s
.02381 .59377 m
.02756 .59377 L
s
.02381 .61445 m
.02756 .61445 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 0 r
.5 Mabswid
.02381 .22152 m
.07143 .31344 L
.11905 .40535 L
.16667 .49726 L
.21429 .58918 L
.2619 .60332 L
.30952 .53969 L
.35714 .47605 L
.40476 .41242 L
.45238 .34879 L
.5 .28515 L
.54762 .22152 L
.59524 .01472 L
.64286 .11812 L
.69048 .22152 L
.7381 .22152 L
.78571 .22152 L
.83333 .22152 L
.88095 .22152 L
.92857 .22152 L
.97619 .22152 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^1000`40O003h00Oogoo:goo000EOol0
0`00Oomoo`3oOolCOol000Moo`D0009oo`8000Eoo`03001oogoo0?mooa=oo`002Goo00D007ooOomo
o`00009oo`03001oogoo009oo`03001oogoo0?mooa=oo`002Goo00D007ooOomoo`00009oo`03001o
ogoo009oo`<009Eoo`030n1oogoo07Yoo`0000=oo`0000000P0017oo00D007ooOomoo`00009oo`03
001oogoo009oo`03001oogoo09Eoo`030n1oogoo07Yoo`002Goo00D007ooOomoo`00009oo`03001o
ogoo009oo`03001oogoo09Eoo`83h7]oo`0027oo0P0017oo0P001Goo00<007ooOol0U7oo00<3h7oo
0n00Ngoo000EOol00`00Oomoo`2DOol010?POomoo`?PNWoo000EOol00`00Oomoo`2DOol010?POomo
o`?PNWoo000EOol2002EOol01@?POomoogoo0n00NGoo000EOol00`00Oomoo`2COol00`?POomoo`02
Ool00`?POomoo`1gOol001Eoo`03001oogoo09=oo`030n1oogoo009oo`030n1oogoo07Moo`005Goo
00<007ooOol0Tgoo00<3h7ooOol00goo00<3h7ooOol0MWoo000EOol00`00Oomoo`2COol00`?POomo
o`03Ool00`?POomoo`1fOol001Eoo`8009=oo`030n1oogoo00Eoo`030n1oogoo07Eoo`005Goo00<0
07ooOol0TWoo00<3h7ooOol01Goo00<3h7ooOol0MGoo000EOol00`00Oomoo`2BOol00`?POomoo`06
Ool00`?POomoo`1dOol001Eoo`03001oogoo099oo`030n1oogoo00Ioo`030n1oogoo07Aoo`005Goo
00<007ooOol0TGoo00<3h7ooOol01goo00<3h7ooOol0M7oo000EOol00`00Oomoo`2AOol00`?POomo
o`08Ool00`?POomoo`1cOol001Eoo`80099oo`030n1oogoo00Qoo`030n1oogoo07=oo`005Goo00<0
07ooOol0TGoo00<3h7ooOol02Goo00<3h7ooOol0LWoo000EOol00`00Oomoo`2AOol00`?POomoo`09
Ool00`?POomoo`1bOol001Eoo`03001oogoo091oo`030n1oogoo00]oo`030n1oogoo075oo`005Goo
00<007ooOol0T7oo00<3h7ooOol02goo00<3h7ooOol0LGoo000EOol2002AOol00`?POomoo`0;Ool0
0`?POomoo`1aOol001Eoo`03001oogoo091oo`030n1oogoo00aoo`030n1oogoo071oo`005Goo00<0
07ooOol0Sgoo00<3h7ooOol03Goo00<3h7ooOol0L7oo000EOol00`00Oomoo`2?Ool00`?POomoo`0>
Ool00`?POomoo`1_Ool000ioo`8000Eoo`03001oogoo08moo`030n1oogoo00ioo`030n1oogoo06mo
o`003Goo00@007ooOol000Aoo`03001oogoo08moo`030n1oogoo00moo`030n1oogoo06ioo`0047oo
00<007ooOol00Woo0`00SWoo00<3h7ooOol047oo00<3h7ooOol0KWoo0007Ool40003Ool20005Ool0
0`00Oomoo`2>Ool00`?POomoo`0@Ool00`?POomoo`1^Ool000ioo`03001oogoo00Aoo`03001oogoo
08ioo`030n1oogoo015oo`030n1oogoo06eoo`003Woo0`0017oo00<007ooOol0SWoo00<3h7ooOol0
4Goo00<3h7ooOol0KGoo000EOol00`00Oomoo`2=Ool00`?POomoo`0COol00`?POomoo`1/Ool001Eo
o`8008ioo`030n1oogoo01=oo`030n1oogoo06aoo`005Goo00<007ooOol0SGoo00<3h7ooOol057oo
00<3h7ooOol0Jgoo000EOol00`00Oomoo`2=Ool00`?POomoo`0DOol00`?POomoo`1[Ool001Eoo`03
001oogoo08aoo`030n1oogoo01Ioo`030n1oogoo06Yoo`005Goo00<007ooOol0S7oo00<3h7ooOol0
5Woo00<3h7ooOol0JWoo000EOol00`00Oomoo`2<Ool00`?POomoo`0GOol00`?POomoo`1YOol001Eo
o`8008eoo`030n1oogoo01Moo`030n1oogoo06Uoo`005Goo00<007ooOol0S7oo00<3h7ooOol067oo
00<3h7ooOol0J7oo000EOol00`00Oomoo`2;Ool00`?POomoo`0IOol00`?POomoo`1XOol001Eoo`03
001oogoo08]oo`030n1oogoo01Yoo`030n1oogoo06Moo`005Goo00<007ooOol0Rgoo00<3h7ooOol0
6Woo00<3h7ooOol0Igoo000EOol2000fOol20004Ool20004Ool2000gOol5000<Ool00`?POomoo`0K
Ool00`?POomoo`07Ool50002Ool20004Ool2000fOol4000FOol001Eoo`03001oogoo03Aoo`04001o
ogoo0008Ool01000Oomoo`00>7oo00<007ooOol02goo00<3h7ooOol077oo00<3h7ooOol02Goo00<0
07ooOol01goo00@007ooOol003Eoo`03001oogoo01Moo`005Goo00<007ooOol0=7oo00@007ooOol0
00]oo`03001oogoo03Ioo`03001oogoo00]oo`030n1oogoo01eoo`030n1oogoo00Qoo`03001oogoo
00Yoo`03001oogoo03Aoo`03001oogoo01Ioo`005Goo00<007ooOol0=7oo00@007ooOol000Uoo`80
03Uoo`03001oogoo00]oo`030n1oogoo01eoo`030n1oogoo00Qoo`03001oogoo00Qoo`8003Qoo`03
001oogoo01Eoo`005Goo00<007ooOol0=7oo00@007ooOol000Uoo`03001oogoo03Qoo`03001oogoo
00]oo`030n1oogoo01ioo`030n1oogoo00Moo`03001oogoo00Qoo`03001oogoo03Eoo`04001oogoo
000FOol001Eoo`03001oogoo03Eoo`8000Yoo`<003Moo`8000aoo`030n1oogoo01moo`030n1oogoo
00Ioo`8000Yoo`<003Ioo`8001Moo`005Goo0P00RWoo00<3h7ooOol087oo00<3h7ooOol0Hgoo000E
Ool00`00Oomoo`29Ool00`?POomoo`0POol00`?POomoo`1SOol001Eoo`03001oogoo08Uoo`030n1o
ogoo025oo`030n1oogoo069oo`005Goo00<007ooOol0R7oo00<3h7ooOol08Woo00<3h7ooOol0HWoo
000EOol00`00Oomoo`28Ool00`?POomoo`0SOol00`?POomoo`1JOol20005Ool000moo`H000030n00
000008P000030n00000002<004d3h0H000Uoo`04001oogoo0004Ool001Eoo`030003h7oo00Yoo`03
001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03
001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Yoo`03001oogoo00Qoo`03
0n0007oo00]oo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Yoo`03001oogoo00Uoo`03
001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Yoo`03001oogoo00eoo`03
001oogoo00Eoo`005Goo00<000?POol0?7oo00<007ooOol0?Goo00<007ooOol027oo00<3h7ooOol0
<Goo00<007ooOol0?7oo00<007ooOol037oo1@0017oo000EOol00`00Ool3h026Ool00`?POomoo`21
Ool00`00Oomoo`05Ool001Eoo`03001oo`?P08Eoo`030n1oogoo08Yoo`005Goo00@007ooOol3h8=o
o`030n1oogoo08]oo`005Goo0P0000=oo`?POol0PWoo00<3h7ooOol0Rgoo000EOol01@00Oomoogoo
0n00PGoo00<3h7ooOol0S7oo000EOol01@00Oomoogoo0n00P7oo00<3h7ooOol0SGoo000EOol00`00
Oomoo`02Ool00`?POomoo`1mOol00`?POomoo`2=Ool001Eoo`03001oogoo009oo`030n1oogoo07ao
o`030n1oogoo08ioo`005Goo0P0017oo00<3h7ooOol0NWoo00<3h7ooOol0Sgoo000EOol00`00Oomo
o`03Ool00`?POomoo`1jOol00`?POomoo`2?Ool001Eoo`03001oogoo00Aoo`030n1oogoo07Qoo`03
0n1oogoo091oo`005Goo00<007ooOol017oo00<3h7ooOol0Mgoo00<3h7ooOol0TGoo000EOol00`00
Oomoo`05Ool00`?POomoo`1eOol00`?POomoo`2BOol001Eoo`03001oogoo00Eoo`030n1oogoo07Eo
o`030n1oogoo099oo`005Goo0P001goo00<3h7ooOol0Lgoo00<3h7ooOol0Tgoo000EOol00`00Oomo
o`06Ool00`?POomoo`1bOol00`?POomoo`2DOol001Eoo`03001oogoo00Moo`030n1oogoo071oo`03
0n1oogoo09Eoo`005Goo00<007ooOol01goo00<3h7ooOol0L7oo00<3h7ooOol0UGoo000EOol00`00
Oomoo`08Ool00`?POomoo`1^Ool00`?POomoo`2FOol001Eoo`8000Uoo`030n1oogoo06eoo`030n1o
ogoo09Moo`005Goo00<007ooOol02Goo00<3h7ooOol0Jgoo00<3h7ooOol0V7oo000EOol00`00Oomo
o`09Ool00`?POomoo`1[Ool00`?POomoo`2HOol001Eoo`03001oogoo00Yoo`030n1oogoo06Uoo`03
0n1oogoo09Uoo`003Woo0P001Goo00<007ooOol02goo00<3h7ooOol0Igoo00<3h7ooOol0VWoo000=
Ool01000Oomoo`0017oo00<007ooOol02goo00<3h7ooOol0IWoo00<3h7ooOol0Vgoo000@Ool00`00
Oomoo`02Ool3000<Ool00`?POomoo`1UOol00`?POomoo`2KOol000ioo`8000Eoo`03001oogoo00ao
o`030n1oogoo06Aoo`030n1oogoo09aoo`003Woo00<007ooOol017oo00<007ooOol03Goo00<3h7oo
Ool0HWoo00<3h7ooOol0WGoo000>Ool30004Ool00`00Oomoo`0=Ool00`?POomoo`1QOol00`?POomo
o`2NOol001Eoo`03001oogoo00ioo`030n1oogoo061oo`030n1oogoo09ioo`005Goo0P003goo00<3
h7ooOol0Ggoo00<3h7ooOol0Wgoo000EOol00`00Oomoo`0?Ool00`?POomoo`1MOol00`?POomoo`2P
Ool001Eoo`03001oogoo00moo`030n1oogoo05aoo`030n1oogoo0:5oo`005Goo00<007ooOol047oo
00<3h7ooOol0FWoo00<3h7ooOol0XWoo000EOol00`00Oomoo`0AOol00`?POomoo`1IOol00`?POomo
o`2ROol001Eoo`03001oogoo015oo`030n1oogoo05Qoo`030n1oogoo0:=oo`005Goo0P004goo00<3
h7ooOol0EWoo00<3h7ooOol0Y7oo000EOol00`00Oomoo`0BOol00`?POomoo`1EOol00`?POomoo`2U
Ool001Eoo`03001oogoo01=oo`030n1oogoo05Aoo`030n1oogoo0:Eoo`005Goo00<007ooOol04goo
00<3h7ooOol0Dgoo00<3h7ooOol0YWoo000EOol00`00Oomoo`0DOol00`?POomoo`1AOol00`?POomo
o`2WOol001Eoo`8001Eoo`030n1oogoo051oo`030n1oogoo0:Qoo`005Goo00<007ooOol05Goo00<3
h7ooOol0Cgoo00<3h7ooOol0Z7oo000EOol00`00Oomoo`0EOol00`?POomoo`1>Ool00`?POomoo`2Y
Ool001Eoo`03001oogoo01Ioo`030n1oogoo04aoo`030n1oogoo0:Yoo`005Goo00<007ooOol05Woo
00<3h7ooOol0Bgoo00<3h7ooOol0Zgoo000EOol00`00Oomoo`0GOol00`?POomoo`1:Ool00`?POomo
o`2[Ool001Eoo`8001Uoo`030n1oogoo04Qoo`030n1oogoo0:aoo`005Goo00<007ooOol067oo00<3
h7ooOol0Agoo00<3h7ooOol0[Goo000EOol00`00Oomoo`0IOol00`?POomoo`15Ool00`?POomoo`2^
Ool000Moo`D0009oo`8000Eoo`03001oogoo01Uoo`030n1oogoo04Eoo`030n1oogoo0:ioo`002Goo
00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo01Yoo`030n1oogoo04=oo`030n1oogoo
0:moo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`<001Yoo`030n1oogoo049oo`030n1o
ogoo0;1oo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo01]oo`030n1oogoo
041oo`030n1oogoo0;5oo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo01]o
o`030n1oogoo041oo`030n1oogoo0;5oo`0027oo0P0017oo0P001Goo00<007ooOol077oo00<3h7oo
Ool0?Woo00<3h7ooOol0/Woo000EOol00`00Oomoo`0LOol00`?POomoo`0mOol00`?POomoo`2cOol0
01Eoo`03001oogoo01eoo`030n1oogoo03aoo`030n1oogoo0;=oo`005Goo0P007Woo00<3h7ooOol0
>goo00<3h7ooOol0]7oo000EOol00`00Oomoo`0NOol00`?POomoo`0iOol00`?POomoo`2eOol001Eo
o`03001oogoo01ioo`030n1oogoo03Uoo`030n1oogoo0;Eoo`005Goo00<007ooOol07goo00<3h7oo
Ool0=goo00<3h7ooOol0]Woo000EOol00`00Oomoo`0OOol00`?POomoo`0fOol00`?POomoo`2gOol0
01Eoo`80025oo`030n1oogoo03Aoo`030n1oogoo0;Qoo`005Goo00<007ooOol087oo00<3h7ooOol0
=7oo00<3h7ooOol0^7oo000EOol00`00Oomoo`0QOol00`?POomoo`0bOol00`?POomoo`2iOol001Eo
o`03001oogoo025oo`030n1oogoo035oo`030n1oogoo0;Yoo`005Goo00<007ooOol08Woo00<3h7oo
Ool0;goo00<3h7ooOol0^goo000EOol00`00Oomoo`0ROol00`?POomoo`0_Ool00`?POomoo`2kOol0
01Eoo`8002Aoo`030n1oogoo02eoo`030n1oogoo0;aoo`005Goo00<007ooOol08goo00<3h7ooOol0
;7oo00<3h7ooOol0_Goo000EOol00`00Oomoo`0TOol00`?POomoo`0ZOol00`?POomoo`2nOol001Eo
o`03001oogoo02Aoo`030n1oogoo02Yoo`030n1oogoo0;ioo`005Goo00<007ooOol09Goo00<3h7oo
Ool0:7oo00<3h7ooOol0_goo000EOol2000VOol00`?POomoo`0WOol00`?POomoo`30Ool001Eoo`03
001oogoo02Ioo`030n1oogoo02Eoo`030n1oogoo0<5oo`005Goo00<007ooOol09Woo00<3h7ooOol0
9Goo00<3h7ooOol0`Goo000EOol00`00Oomoo`0WOol00`?POomoo`0SOol00`?POomoo`32Ool000Mo
o`D0009oo`8000Eoo`03001oogoo02Moo`030n1oogoo029oo`030n1oogoo0<=oo`002Goo00D007oo
Oomoo`00009oo`03001oogoo009oo`03001oogoo02Qoo`030n1oogoo021oo`030n1oogoo0<Aoo`00
2Goo00<007ooOol017oo00<007ooOol00Woo0`00:7oo00<3h7ooOol087oo00<3h7ooOol0a7oo0009
Ool00`00Oomoo`02Ool20005Ool00`00Oomoo`0YOol00`?POomoo`0NOol00`?POomoo`35Ool000Uo
o`03001oogoo009oo`03001oogoo00Aoo`03001oogoo02Uoo`030n1oogoo01eoo`030n1oogoo0<Io
o`0027oo0P0017oo0`0017oo00<007ooOol0:Woo00<3h7ooOol06goo00<3h7ooOol0agoo000EOol0
0`00Oomoo`0ZOol00`?POomoo`0JOol00`?POomoo`38Ool001Eoo`8002aoo`030n1oogoo01Uoo`03
0n1oogoo0<Qoo`005Goo00<007ooOol0:goo00<3h7ooOol067oo00<3h7ooOol0bGoo000EOol00`00
Oomoo`0/Ool00`?POomoo`0FOol00`?POomoo`3:Ool001Eoo`03001oogoo02aoo`030n1oogoo01Eo
o`030n1oogoo0<]oo`005Goo00<007ooOol0;Goo00<3h7ooOol04goo00<3h7ooOol0c7oo000EOol2
000^Ool00`?POomoo`0BOol00`?POomoo`3=Ool001Eoo`03001oogoo02ioo`030n1oogoo015oo`03
0n1oogoo0<eoo`005Goo00<007ooOol0;Woo00<3h7ooOol047oo00<3h7ooOol0cWoo000EOol00`00
Oomoo`0_Ool00`?POomoo`0>Ool00`?POomoo`3?Ool001Eoo`03001oogoo02moo`030n1oogoo00eo
o`030n1oogoo0=1oo`005Goo00<007ooOol0<7oo0P?P37oo00<3h7ooOol0dGoo000EOol2000cOol4
0n08Ool00`?POomoo`3AOol001Eoo`03001oogoo03Ioo`@3h0=oo`030n1oogoo0=9oo`005Goo00<0
07ooOol0>Woo0`?PeGoo000EOol00`00Oomoo`3oOolCOol001Eoo`03001oogoo0?mooa=oo`005Goo
0P00ogoo57oo000EOol00`00Oomoo`3oOolCOol00?moob]oo`00ogoo:goo003oOol[Ool00?moob]o
o`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool0019oo`<00?mooaIoo`004goo
00<007ooOol0ogoo5Goo000COol3003oOolEOol001=oo`04001oogoo003oOolDOol001=oo`04001o
ogoo003oOolDOol0019oo`@00?mooaEoo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo0000
\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.5, 0}} -> {-0.172869, -10.821, \
0.00792472, 0.182473}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.0191203 [
[.2619 .00222 -9 -9 ]
[.2619 .00222 9 0 ]
[.5 .00222 -3 -9 ]
[.5 .00222 3 0 ]
[.7381 .00222 -9 -9 ]
[.7381 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .11032 -6 -4.5 ]
[.01131 .11032 0 4.5 ]
[.01131 .20592 -12 -4.5 ]
[.01131 .20592 0 4.5 ]
[.01131 .30152 -12 -4.5 ]
[.01131 .30152 0 4.5 ]
[.01131 .39712 -12 -4.5 ]
[.01131 .39712 0 4.5 ]
[.01131 .49272 -12 -4.5 ]
[.01131 .49272 0 4.5 ]
[.01131 .58832 -12 -4.5 ]
[.01131 .58832 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(0.5)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(1)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(1.5)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(2)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .11032 m
.03006 .11032 L
s
[(5)] .01131 .11032 1 0 Mshowa
.02381 .20592 m
.03006 .20592 L
s
[(10)] .01131 .20592 1 0 Mshowa
.02381 .30152 m
.03006 .30152 L
s
[(15)] .01131 .30152 1 0 Mshowa
.02381 .39712 m
.03006 .39712 L
s
[(20)] .01131 .39712 1 0 Mshowa
.02381 .49272 m
.03006 .49272 L
s
[(25)] .01131 .49272 1 0 Mshowa
.02381 .58832 m
.03006 .58832 L
s
[(30)] .01131 .58832 1 0 Mshowa
.125 Mabswid
.02381 .03384 m
.02756 .03384 L
s
.02381 .05296 m
.02756 .05296 L
s
.02381 .07208 m
.02756 .07208 L
s
.02381 .0912 m
.02756 .0912 L
s
.02381 .12944 m
.02756 .12944 L
s
.02381 .14856 m
.02756 .14856 L
s
.02381 .16768 m
.02756 .16768 L
s
.02381 .1868 m
.02756 .1868 L
s
.02381 .22504 m
.02756 .22504 L
s
.02381 .24416 m
.02756 .24416 L
s
.02381 .26328 m
.02756 .26328 L
s
.02381 .2824 m
.02756 .2824 L
s
.02381 .32064 m
.02756 .32064 L
s
.02381 .33976 m
.02756 .33976 L
s
.02381 .35888 m
.02756 .35888 L
s
.02381 .378 m
.02756 .378 L
s
.02381 .41624 m
.02756 .41624 L
s
.02381 .43536 m
.02756 .43536 L
s
.02381 .45448 m
.02756 .45448 L
s
.02381 .4736 m
.02756 .4736 L
s
.02381 .51184 m
.02756 .51184 L
s
.02381 .53096 m
.02756 .53096 L
s
.02381 .55008 m
.02756 .55008 L
s
.02381 .5692 m
.02756 .5692 L
s
.02381 .60744 m
.02756 .60744 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.07143 .01538 L
.11905 .01996 L
.16667 .0319 L
.21429 .05423 L
.2619 .08905 L
.30952 .13537 L
.35714 .1895 L
.40476 .24771 L
.45238 .30672 L
.5 .36367 L
.54762 .41606 L
.59524 .46071 L
.64286 .49292 L
.69048 .51653 L
.7381 .53636 L
.78571 .55366 L
.83333 .56873 L
.88095 .58187 L
.92857 .59333 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^1000`40O003h00Oogoo:goo001>Ool2
0004Ool20004Ool2000cOol5000aOol50002Ool20004Ool2000cOol4000OOol004eoo`04001oogoo
0008Ool01000Oomoo`00=7oo00<007ooOol0<goo00<007ooOol01goo00@007ooOol0039oo`03001o
ogoo021oo`00CGoo00@007ooOol000]oo`03001oogoo039oo`03001oogoo03=oo`03001oogoo00Yo
o`03001oogoo035oo`03001oogoo01moo`00CGoo00@007ooOol000Uoo`8003Eoo`03001oogoo03=o
o`03001oogoo00Qoo`8003Eoo`03001oogoo01ioo`00CGoo00@007ooOol000Uoo`03001oogoo03Ao
o`03001oogoo03=oo`03001oogoo00Qoo`03001oogoo039oo`04001oogoo000OOol004ioo`8000Yo
o`<003=oo`8003Aoo`8000Yoo`<003=oo`80021oo`00ogoo:goo000HOol00`00Oomoo`3oOol@Ool0
01Qoo`03001oogoo0?mooa1oo`0067oo00<007ooOol0ogoo47oo000HOol00`00Oomoo`3nOol2000?
Ool0019oo`H0019l0>H000Qoo`04001oogoo000>Ool001Qoo`03001oogoo00Uoo`03001oogoo00=o
o`Ql00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Uoo`03001o
ogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001o
ogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001o
ogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00aoo`03001oogoo00moo`0067oo
00<007ooOol05goo0g`087oo00<007ooOol0>Goo00<007ooOol0>Goo00<007ooOol0>Goo00<007oo
Ool02goo1@003Woo000HOol00`00Oomoo`0JOol3O03POol00`00Oomoo`0?Ool001Qoo`03001oogoo
01eoo`=l0>moo`0067oo0P008Goo0g`0k7oo000HOol00`00Oomoo`0SOol2O03ZOol001Qoo`03001o
ogoo02Eoo`9l0>Qoo`0067oo00<007ooOol09goo0g`0iGoo000HOol00`00Oomoo`0ZOol2O03SOol0
01Qoo`8002eoo`9l0>5oo`0067oo00<007ooOol0;Woo0W`0ggoo000HOol00`00Oomoo`0`Ool00g`0
Oomoo`3LOol001Qoo`03001oogoo035oo`9l0=aoo`0067oo00<007ooOol0<goo00=l07ooOol0fGoo
000HOol2000eOol00g`0Oomoo`3HOol001Qoo`03001oogoo03Eoo`9l0=Qoo`0067oo00<007ooOol0
=goo00=l07ooOol0eGoo000HOol00`00Oomoo`0hOol2O03EOol001Qoo`8003]oo`03O01oogoo0=9o
o`0067oo00<007ooOol0>goo00=l07ooOol0dGoo000HOol00`00Oomoo`0lOol00g`0Oomoo`3@Ool0
015oo`8000Eoo`03001oogoo03eoo`03O01oogoo0<moo`0047oo00@007ooOol000Aoo`03001oogoo
03ioo`03O01oogoo0<ioo`004goo00<007ooOol00Woo0`00?goo00=l07ooOol0cGoo000AOol20005
Ool00`00Oomoo`10Ool00g`0Oomoo`3<Ool0015oo`03001oogoo00Aoo`03001oogoo045oo`03O01o
ogoo0<]oo`004Goo0`0017oo00<007ooOol0@Woo00=l07ooOol0bWoo000HOol00`00Oomoo`13Ool0
0g`0Oomoo`39Ool001Qoo`8004Eoo`03O01oogoo0<Qoo`0067oo00<007ooOol0AGoo00=l07ooOol0
agoo000HOol00`00Oomoo`16Ool00g`0Oomoo`36Ool001Qoo`03001oogoo04Moo`03O01oogoo0<Eo
o`0067oo00<007ooOol0B7oo00=l07ooOol0a7oo000HOol2001:Ool00g`0Oomoo`33Ool001Qoo`03
001oogoo04Yoo`03O01oogoo0<9oo`0067oo00<007ooOol0Bgoo00=l07ooOol0`Goo000HOol00`00
Oomoo`1<Ool00g`0Oomoo`30Ool001Qoo`03001oogoo04aoo`03O01oogoo0<1oo`0067oo0P00CWoo
00=l07ooOol0_goo000HOol00`00Oomoo`1>Ool00g`0Oomoo`2nOol001Qoo`03001oogoo04moo`03
O01oogoo0;eoo`0067oo00<007ooOol0D7oo00=l07ooOol0_7oo000HOol00`00Oomoo`1AOol00g`0
Oomoo`2kOol001Qoo`8005=oo`03O01oogoo0;Yoo`0067oo00<007ooOol0Dgoo00=l07ooOol0^Goo
000:Ool50002Ool20005Ool00`00Oomoo`1DOol00g`0Oomoo`2hOol000aoo`05001oogooOol00002
Ool00`00Oomoo`02Ool00`00Oomoo`1DOol00g`0Oomoo`2hOol000aoo`05001oogooOol00002Ool0
0`00Oomoo`02Ool3001EOol00g`0Oomoo`2gOol000aoo`05001oogooOol00002Ool00`00Oomoo`02
Ool00`00Oomoo`1FOol00g`0Oomoo`2fOol000aoo`05001oogooOol00002Ool00`00Oomoo`02Ool0
0`00Oomoo`1GOol00g`0Oomoo`2eOol000]oo`8000Aoo`8000Eoo`03001oogoo05Qoo`03O01oogoo
0;Aoo`0067oo00<007ooOol0F7oo00=l07ooOol0]7oo000HOol2001JOol00g`0Oomoo`2cOol001Qo
o`03001oogoo05Yoo`03O01oogoo0;9oo`0067oo00<007ooOol0Fgoo00=l07ooOol0/Goo000HOol0
0`00Oomoo`1LOol00g`0Oomoo`2`Ool001Qoo`03001oogoo05aoo`03O01oogoo0;1oo`0067oo0P00
GWoo00=l07ooOol0[goo000HOol00`00Oomoo`1NOol00g`0Oomoo`2^Ool001Qoo`03001oogoo05mo
o`03O01oogoo0:eoo`0067oo00<007ooOol0H7oo00=l07ooOol0[7oo000HOol00`00Oomoo`1POol0
0g`0Oomoo`2/Ool001Qoo`80069oo`03O01oogoo0:]oo`0067oo00<007ooOol0HWoo00=l07ooOol0
ZWoo000HOol00`00Oomoo`1SOol00g`0Oomoo`2YOol001Qoo`03001oogoo06Aoo`03O01oogoo0:Qo
o`0067oo00<007ooOol0I7oo00=l07ooOol0Z7oo000HOol2001VOol00g`0Oomoo`2WOol001Qoo`03
001oogoo06Ioo`03O01oogoo0:Ioo`0067oo00<007ooOol0Igoo00=l07ooOol0YGoo000:Ool50002
Ool20005Ool00`00Oomoo`1XOol00g`0Oomoo`2TOol000aoo`05001oogooOol00002Ool00`00Oomo
o`02Ool00`00Oomoo`1XOol00g`0Oomoo`2TOol000aoo`03001oogoo00Aoo`03001oogoo009oo`<0
06Uoo`03O01oogoo0:=oo`0037oo00<007ooOol00Woo0P001Goo00<007ooOol0JWoo00=l07ooOol0
XWoo000<Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`1[Ool00g`0Oomoo`2QOol000]o
o`8000Aoo`<000Aoo`03001oogoo06aoo`03O01oogoo0:1oo`0067oo0P00KWoo00=l07ooOol0Wgoo
000HOol00`00Oomoo`1]Ool00g`0Oomoo`2OOol001Qoo`03001oogoo06ioo`03O01oogoo09ioo`00
67oo00<007ooOol0Kgoo00=l07ooOol0WGoo000HOol00`00Oomoo`1`Ool00g`0Oomoo`2LOol001Qo
o`80079oo`03O01oogoo09]oo`0067oo00<007ooOol0LWoo00=l07ooOol0VWoo000HOol00`00Oomo
o`1cOol00g`0Oomoo`2IOol001Qoo`03001oogoo07=oo`03O01oogoo09Uoo`0067oo00<007ooOol0
M7oo00=l07ooOol0V7oo000HOol2001fOol00g`0Oomoo`2GOol001Qoo`03001oogoo07Ioo`03O01o
ogoo09Ioo`0067oo00<007ooOol0Mgoo00=l07ooOol0UGoo000HOol00`00Oomoo`1hOol00g`0Oomo
o`2DOol001Qoo`03001oogoo07Uoo`03O01oogoo09=oo`0067oo0P00NWoo00=l07ooOol0Tgoo000H
Ool00`00Oomoo`1jOol00g`0Oomoo`2BOol001Qoo`03001oogoo07]oo`03O01oogoo095oo`002Woo
10000goo0P001Goo00<007ooOol0O7oo00=l07ooOol0T7oo000:Ool00`00Oomoo`03Ool01000Oomo
o`0017oo00<007ooOol0OGoo00=l07ooOol0Sgoo000;Ool00`00Oomoo`02Ool01000Oomoo`0017oo
0`00OWoo00=l07ooOol0SWoo000<Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol0
Ogoo00=l07ooOol0SGoo000:Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo07moo`03
O01oogoo08eoo`002goo0P0017oo0P001Goo00<007ooOol0P7oo00=l07ooOol0S7oo000HOol00`00
Oomoo`21Ool00g`0Oomoo`2;Ool001Qoo`8008=oo`03O01oogoo08Yoo`0067oo00<007ooOol0Pgoo
00=l07ooOol0RGoo000HOol00`00Oomoo`24Ool00g`0Oomoo`28Ool001Qoo`03001oogoo08Eoo`03
O01oogoo08Moo`0067oo0P00Qgoo00=l07ooOol0QWoo000HOol00`00Oomoo`27Ool00g`0Oomoo`25
Ool001Qoo`03001oogoo08Qoo`9l08Eoo`0067oo00<007ooOol0RWoo00=l07ooOol0PWoo000HOol0
0`00Oomoo`2;Ool00g`0Oomoo`21Ool001Qoo`8008eoo`03O01oogoo081oo`0067oo00<007ooOol0
SGoo00=l07ooOol0Ogoo000HOol00`00Oomoo`2>Ool00g`0Oomoo`1nOol001Qoo`03001oogoo08mo
o`9l07ioo`0067oo00<007ooOol0TGoo00=l07ooOol0Ngoo000HOol2002COol2O01kOol001Qoo`03
001oogoo09Aoo`03O01oogoo07Qoo`0067oo00<007ooOol0UGoo0W`0N7oo000:Ool40003Ool20005
Ool00`00Oomoo`2GOol00g`0Oomoo`1eOol000Yoo`03001oogoo00=oo`04001oogoo0004Ool00`00
Oomoo`2HOol2O01eOol000]oo`03001oogoo00Eoo`03001oogoo009oo`<009Yoo`03O01oogoo079o
o`0037oo00<007ooOol00Woo0P001Goo00<007ooOol0Vgoo0W`0LWoo000:Ool01000Oomoo`000goo
00<007ooOol017oo00<007ooOol0WGoo0W`0L7oo000;Ool20004Ool30004Ool00`00Oomoo`2OOol2
O01^Ool001Qoo`03001oogoo0:5oo`9l06aoo`0067oo0P00Y7oo0W`0JWoo000HOol00`00Oomoo`2U
Ool3O01WOol001Qoo`03001oogoo0:Qoo`9l06Eoo`0067oo00<007ooOol0ZWoo0W`0Hgoo000HOol0
0`00Oomoo`2/Ool3O01POol001Qoo`800;1oo`9l05ioo`0067oo00<007ooOol0/Goo0g`0Fgoo000H
Ool00`00Oomoo`2dOol3O01HOol001Qoo`03001oogoo0;Moo`=l05Eoo`0067oo0P00^goo0g`0DWoo
000HOol00`00Oomoo`2mOol3O01?Ool001Qoo`03001oogoo0<1oo`=l04aoo`0067oo00<007ooOol0
`goo0g`0BGoo000HOol00`00Oomoo`36Ool3O016Ool001Qoo`800<Yoo`=l04=oo`0067oo00<007oo
Ool0c7oo0g`0@7oo000HOol00`00Oomoo`3?Ool3O00mOol000]oo`8000Aoo`8000Eoo`03001oogoo
0=9oo`=l03Yoo`002Woo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`3EOol4O00fOol0
00aoo`05001oogooOol00002Ool00`00Oomoo`02Ool3003IOol6O00`Ool000eoo`04001oogoo0002
Ool00`00Oomoo`02Ool00`00Oomoo`3OOol5O00[Ool000Yoo`04001oogoo0002Ool01000Oomoo`00
17oo00<007ooOol0i7oo17`09goo000;Ool20004Ool20005Ool00`00Oomoo`3XOol4O00SOol001Qo
o`03001oogoo0>aoo`=l021oo`0067oo0P00ogoo4Goo000HOol00`00Oomoo`3oOol@Ool001Qoo`03
001oogoo0?mooa1oo`0067oo00<007ooOol0ogoo47oo003oOol[Ool00?moob]oo`00ogoo:goo003o
Ool[Ool00?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool001Moo`@0
0?mooa1oo`005Woo00@007ooOol00?mooa5oo`005Woo00@007ooOol00?mooa5oo`005Goo0P0000=o
o`000000ogoo4Goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00001\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.5, 0}} -> {-0.206349, -2.51561, \
0.00830689, 0.206883}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.0190374 [
[.2619 .00222 -9 -9 ]
[.2619 .00222 9 0 ]
[.5 .00222 -3 -9 ]
[.5 .00222 3 0 ]
[.7381 .00222 -9 -9 ]
[.7381 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .1099 -6 -4.5 ]
[.01131 .1099 0 4.5 ]
[.01131 .20509 -12 -4.5 ]
[.01131 .20509 0 4.5 ]
[.01131 .30028 -12 -4.5 ]
[.01131 .30028 0 4.5 ]
[.01131 .39546 -12 -4.5 ]
[.01131 .39546 0 4.5 ]
[.01131 .49065 -12 -4.5 ]
[.01131 .49065 0 4.5 ]
[.01131 .58584 -12 -4.5 ]
[.01131 .58584 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01472 m
.2619 .02097 L
s
[(0.5)] .2619 .00222 0 1 Mshowa
.5 .01472 m
.5 .02097 L
s
[(1)] .5 .00222 0 1 Mshowa
.7381 .01472 m
.7381 .02097 L
s
[(1.5)] .7381 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(2)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .1099 m
.03006 .1099 L
s
[(5)] .01131 .1099 1 0 Mshowa
.02381 .20509 m
.03006 .20509 L
s
[(10)] .01131 .20509 1 0 Mshowa
.02381 .30028 m
.03006 .30028 L
s
[(15)] .01131 .30028 1 0 Mshowa
.02381 .39546 m
.03006 .39546 L
s
[(20)] .01131 .39546 1 0 Mshowa
.02381 .49065 m
.03006 .49065 L
s
[(25)] .01131 .49065 1 0 Mshowa
.02381 .58584 m
.03006 .58584 L
s
[(30)] .01131 .58584 1 0 Mshowa
.125 Mabswid
.02381 .03375 m
.02756 .03375 L
s
.02381 .05279 m
.02756 .05279 L
s
.02381 .07183 m
.02756 .07183 L
s
.02381 .09086 m
.02756 .09086 L
s
.02381 .12894 m
.02756 .12894 L
s
.02381 .14798 m
.02756 .14798 L
s
.02381 .16701 m
.02756 .16701 L
s
.02381 .18605 m
.02756 .18605 L
s
.02381 .22413 m
.02756 .22413 L
s
.02381 .24316 m
.02756 .24316 L
s
.02381 .2622 m
.02756 .2622 L
s
.02381 .28124 m
.02756 .28124 L
s
.02381 .31931 m
.02756 .31931 L
s
.02381 .33835 m
.02756 .33835 L
s
.02381 .35739 m
.02756 .35739 L
s
.02381 .37643 m
.02756 .37643 L
s
.02381 .4145 m
.02756 .4145 L
s
.02381 .43354 m
.02756 .43354 L
s
.02381 .45258 m
.02756 .45258 L
s
.02381 .47161 m
.02756 .47161 L
s
.02381 .50969 m
.02756 .50969 L
s
.02381 .52873 m
.02756 .52873 L
s
.02381 .54776 m
.02756 .54776 L
s
.02381 .5668 m
.02756 .5668 L
s
.02381 .60487 m
.02756 .60487 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 1 r
.5 Mabswid
.02381 .01472 m
.07143 .0347 L
.11905 .09153 L
.16667 .18067 L
.21429 .29796 L
.2619 .42306 L
.30952 .52147 L
.35714 .57984 L
.40476 .60332 L
.45238 .59638 L
.5 .56291 L
.54762 .50633 L
.59524 .39875 L
.64286 .2827 L
.69048 .22607 L
.7381 .19897 L
.78571 .17535 L
.83333 .15475 L
.88095 .13679 L
.92857 .12114 L
.97619 .1075 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^1000`40O003h00Oogoo:goo001>Ool2
0004Ool20004Ool2000cOol5000aOol50002Ool20004Ool2000cOol4000OOol004eoo`04001oogoo
0008Ool01000Oomoo`00=7oo00<007ooOol0<goo00<007ooOol01goo00@007ooOol0039oo`03001o
ogoo021oo`00CGoo00@007ooOol000]oo`03001oogoo039oo`03001oogoo03=oo`03001oogoo00Yo
o`03001oogoo035oo`03001oogoo01moo`00CGoo00@007ooOol000Uoo`8003Eoo`03001oogoo03=o
o`03001oogoo00Qoo`8003Eoo`03001oogoo01ioo`00CGoo00@007ooOol000Uoo`03001oogoo03Ao
o`03001oogoo03=oo`03001oogoo00Qoo`03001oogoo039oo`04001oogoo000OOol004ioo`8000Yo
o`<003=oo`8003Aoo`8000Yoo`<003=oo`80021oo`00ogoo:goo000HOol00`00Oomoo`3oOol@Ool0
01Qoo`03001oogoo0?mooa1oo`0067oo00<007ooOol0ogoo47oo000HOol00`00Oomoo`3nOol2000?
Ool0019oo`H0009l7oH000Qoo`04001oogoo000>Ool001Qoo`04001oog`OO1l8Ool00`00Oomoo`09
Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`09
Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09
Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09
Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`0<Ool00`00Oomoo`0?
Ool001Qoo`04001oogooOol2O1lgOol00`00Oomoo`0iOol00`00Oomoo`0iOol00`00Oomoo`0iOol0
0`00Oomoo`0;Ool5000>Ool001Qoo`03001oogoo00=oo`=l7oMoo`03001oogoo00moo`0067oo00<0
07ooOol01Woo0W`Oogoo27oo000HOol20009Ool2O1ooOol6Ool001Qoo`03001oogoo00Yoo`03O1mo
ogoo0?moo`=oo`0067oo00<007ooOol02goo00=l7gooOol0ogoo0Woo000HOol00`00Oomoo`0;Ool0
0g`OOomoo`3oOol2Ool001Qoo`03001oogoo00aoo`03O1moogoo0?moo`5oo`0067oo0P003Woo00=l
7gooOol0ogoo000HOol00`00Oomoo`0>Ool00g`OOomoo`3nOol001Qoo`03001oogoo00moo`03O1mo
ogoo0?eoo`0067oo00<007ooOol03goo00=l7gooOol0oGoo000HOol00`00Oomoo`0@Ool00g`OOomo
o`3lOol001Qoo`80019oo`03O1moogoo0?]oo`0067oo00<007ooOol04Woo00=l7gooOol0nWoo000H
Ool00`00Oomoo`0COol00g`OOomoo`3iOol001Qoo`03001oogoo01=oo`03O1moogoo0?Uoo`0067oo
0P005Goo00=l7gooOol0n7oo000HOol00`00Oomoo`0EOol00g`OOomoo`3gOol001Qoo`03001oogoo
01Ioo`03O1moogoo0?Ioo`004Goo0P001Goo00<007ooOol05Woo00=l7gooOol0mWoo000@Ool01000
Oomoo`0017oo00<007ooOol05goo00=l7gooOol0mGoo000COol00`00Oomoo`02Ool3000GOol00g`O
Oomoo`3COol2O1lPOol0015oo`8000Eoo`03001oogoo01Qoo`03O1moogoo0<ioo`Al7b9oo`004Goo
00<007ooOol017oo00<007ooOol067oo00=l7gooOol0bWoo17`O9Woo000AOol30004Ool00`00Oomo
o`0IOol00g`OOomoo`35Ool4O1lZOol001Qoo`03001oogoo01Uoo`03O1moogoo0<9oo`=l7bioo`00
67oo0P006goo00=l7gooOol0_Woo0g`O<Goo000HOol00`00Oomoo`0JOol00g`OOomoo`2kOol3O1ld
Ool001Qoo`03001oogoo01]oo`03O1moogoo0;Moo`=l7cMoo`0067oo00<007ooOol077oo00=l7goo
Ool0]7oo0W`O>Woo000HOol00`00Oomoo`0LOol00g`OOomoo`2bOol2O1llOol001Qoo`8001ioo`03
O1moogoo0:ioo`=l7cioo`0067oo00<007ooOol07Goo00=l7gooOol0[7oo0W`O@Goo000HOol00`00
Oomoo`0NOol00g`OOomoo`2XOol3O1m3Ool001Qoo`03001oogoo01ioo`03O1moogoo0:Ioo`9l7dIo
o`0067oo00<007ooOol07goo00=l7gooOol0Xgoo0W`OB7oo000HOol2000POol00g`OOomoo`2POol3
O1m:Ool001Qoo`03001oogoo021oo`03O1moogoo09eoo`9l7deoo`0067oo00<007ooOol087oo00=l
7gooOol0Vgoo0W`OCgoo000HOol00`00Oomoo`0QOol00g`OOomoo`2HOol2O1mAOol001Qoo`80029o
o`03O1moogoo09Ioo`9l7e=oo`0067oo00<007ooOol08Woo00=l7gooOol0Tgoo0W`OEGoo000HOol0
0`00Oomoo`0ROol00g`OOomoo`2AOol2O1mGOol000Yoo`D0009oo`8000Eoo`03001oogoo02=oo`03
O1moogoo08ioo`9l7eUoo`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo02=o
o`03O1moogoo08aoo`9l7e]oo`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`<002=oo`03
O1moogoo08Yoo`9l7eeoo`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo02Ao
o`03O1moogoo08Moo`9l7emoo`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo
02Aoo`03O1moogoo08Ioo`03O1moogoo05moo`002goo0P0017oo0P001Goo00<007ooOol09Goo00=l
7gooOol0Pgoo0W`OHWoo000HOol00`00Oomoo`0UOol00g`OOomoo`21Ool2O1mTOol001Qoo`8002Io
o`03O1moogoo07moo`9l7fIoo`0067oo00<007ooOol09Woo00=l7gooOol0OGoo00=l7gooOol0IWoo
000HOol00`00Oomoo`0VOol00g`OOomoo`1lOol00g`OOomoo`1WOol001Qoo`03001oogoo02Moo`03
O1moogoo07Yoo`03O1moogoo06Qoo`0067oo00<007ooOol09goo00=l7gooOol0NGoo00=l7gooOol0
JGoo000HOol2000XOol00g`OOomoo`1iOol00g`OOomoo`1YOol001Qoo`03001oogoo02Qoo`03O1mo
ogoo07Moo`03O1moogoo06Yoo`0067oo00<007ooOol0:7oo00=l7gooOol0MWoo00=l7gooOol0Jgoo
000HOol00`00Oomoo`0YOol00g`OOomoo`1dOol00g`OOomoo`1/Ool001Qoo`03001oogoo02Uoo`03
O1moogoo07=oo`03O1moogoo06eoo`0067oo0P00:Woo00=l7gooOol0LWoo00=l7gooOol0KWoo000H
Ool00`00Oomoo`0ZOol00g`OOomoo`1`Ool00g`OOomoo`1_Ool001Qoo`03001oogoo02Yoo`03O1mo
ogoo071oo`03O1moogoo06moo`0067oo00<007ooOol0:goo00=l7gooOol0KWoo00=l7gooOol0L7oo
000HOol00`00Oomoo`0[Ool00g`OOomoo`1]Ool00g`OOomoo`1aOol001Qoo`8002aoo`03O1moogoo
06aoo`03O1moogoo079oo`0067oo00<007ooOol0;7oo00=l7gooOol0Jgoo00=l7gooOol0LWoo000:
Ool50002Ool20005Ool00`00Oomoo`0/Ool00g`OOomoo`1ZOol00g`OOomoo`1cOol000aoo`05001o
ogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`0]Ool00g`OOomoo`1YOol00g`OOomoo`1cOol0
00aoo`03001oogoo00Aoo`03001oogoo009oo`<002eoo`03O1moogoo06Qoo`03O1moogoo07Aoo`00
37oo00<007ooOol00Woo0P001Goo00<007ooOol0;Goo00=l7gooOol0J7oo00=l7gooOol0M7oo000<
Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`0^Ool00g`OOomoo`1WOol00g`OOomoo`1d
Ool000]oo`8000Aoo`<000Aoo`03001oogoo02ioo`03O1moogoo06Ioo`03O1moogoo07Eoo`0067oo
00<007ooOol0;goo00=l7gooOol0IGoo00=l7gooOol0MGoo000HOol2000`Ool00g`OOomoo`1TOol0
0g`OOomoo`1fOol001Qoo`03001oogoo031oo`03O1moogoo06=oo`03O1moogoo07Ioo`0067oo00<0
07ooOol0<7oo00=l7gooOol0HWoo00=l7gooOol0Mgoo000HOol00`00Oomoo`0`Ool00g`OOomoo`1R
Ool00g`OOomoo`1gOol001Qoo`03001oogoo035oo`03O1moogoo065oo`03O1moogoo07Moo`0067oo
0P00<Woo00=l7gooOol0H7oo00=l7gooOol0N7oo000HOol00`00Oomoo`0bOol00g`OOomoo`1OOol0
0g`OOomoo`1hOol001Qoo`03001oogoo039oo`03O1moogoo05ioo`03O1moogoo07Uoo`0067oo00<0
07ooOol0<Woo00=l7gooOol0GWoo00=l7gooOol0NGoo000HOol00`00Oomoo`0cOol00g`OOomoo`1M
Ool00g`OOomoo`1iOol001Qoo`8003Aoo`03O1moogoo05aoo`03O1moogoo07Yoo`0067oo00<007oo
Ool0=7oo00=l7gooOol0Fgoo00=l7gooOol0NWoo000HOol00`00Oomoo`0dOol00g`OOomoo`1JOol0
0g`OOomoo`1kOol001Qoo`03001oogoo03Eoo`03O1moogoo05Uoo`03O1moogoo07]oo`0067oo00<0
07ooOol0=Goo00=l7gooOol0F7oo00=l7gooOol0O7oo000HOol2000fOol00g`OOomoo`1HOol00g`O
Oomoo`1lOol001Qoo`03001oogoo03Ioo`03O1moogoo05Moo`03O1moogoo07aoo`002Woo10000goo
0P001Goo00<007ooOol0=Woo00=l7gooOol0EWoo00=l7gooOol0OGoo000:Ool00`00Oomoo`03Ool0
1000Oomoo`0017oo00<007ooOol0=goo00=l7gooOol0EGoo00=l7gooOol0OGoo000;Ool00`00Oomo
o`02Ool01000Oomoo`0017oo0`00=goo00=l7gooOol0E7oo00=l7gooOol0OWoo000<Ool01@00Oomo
ogoo00000Woo00<007ooOol00Woo00<007ooOol0=goo00=l7gooOol0E7oo00=l7gooOol0OWoo000:
Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo03Qoo`03O1moogoo05=oo`03O1moogoo
07ioo`002goo0P0017oo0P001Goo00<007ooOol0>7oo00=l7gooOol0DWoo00=l7gooOol0Ogoo000H
Ool00`00Oomoo`0iOol00g`OOomoo`1AOol00g`OOomoo`1oOol001Qoo`8003Yoo`03O1moogoo051o
o`03O1moogoo081oo`0067oo00<007ooOol0>Woo00=l7gooOol0Cgoo00=l7gooOol0P7oo000HOol0
0`00Oomoo`0jOol00g`OOomoo`1>Ool00g`OOomoo`21Ool001Qoo`03001oogoo03Yoo`03O1moogoo
04ioo`03O1moogoo085oo`0067oo00<007ooOol0>goo00=l7gooOol0C7oo00=l7gooOol0PWoo000H
Ool2000lOol00g`OOomoo`1<Ool00g`OOomoo`22Ool001Qoo`03001oogoo03aoo`03O1moogoo04]o
o`03O1moogoo089oo`0067oo00<007ooOol0?7oo00=l7gooOol0BWoo00=l7gooOol0Pgoo000HOol0
0`00Oomoo`0mOol00g`OOomoo`19Ool00g`OOomoo`23Ool001Qoo`03001oogoo03eoo`03O1moogoo
04Qoo`03O1moogoo08Aoo`0067oo0P00?goo00=l7gooOol0Agoo00=l7gooOol0Q7oo000HOol00`00
Oomoo`0nOol00g`OOomoo`16Ool00g`OOomoo`25Ool001Qoo`03001oogoo03moo`03O1moogoo04Eo
o`03O1moogoo08Eoo`0067oo00<007ooOol0?goo00=l7gooOol0A7oo00=l7gooOol0QWoo000HOol0
0`00Oomoo`10Ool00g`OOomoo`13Ool00g`OOomoo`26Ool001Qoo`80045oo`03O1moogoo04=oo`03
O1moogoo08Ioo`0067oo00<007ooOol0@Goo00=l7gooOol0@Goo00=l7gooOol0Qgoo000:Ool40003
Ool20005Ool00`00Oomoo`11Ool00g`OOomoo`11Ool00g`OOomoo`27Ool000Yoo`03001oogoo00=o
o`04001oogoo0004Ool00`00Oomoo`12Ool00g`OOomoo`0oOol00g`OOomoo`28Ool000]oo`03001o
ogoo00Eoo`03001oogoo009oo`<0049oo`03O1moogoo03moo`03O1moogoo08Qoo`0037oo00<007oo
Ool00Woo0P001Goo00<007ooOol0@goo00=l7gooOol0?Goo00=l7gooOol0RGoo000:Ool01000Oomo
o`000goo00<007ooOol017oo00<007ooOol0@goo00=l7gooOol0?Goo00=l7gooOol0RGoo000;Ool2
0004Ool30004Ool00`00Oomoo`14Ool00g`OOomoo`0kOol00g`OOomoo`2:Ool001Qoo`03001oogoo
04Aoo`03O1moogoo03]oo`03O1moogoo08Yoo`0067oo0P00AWoo00=l7gooOol0>Goo00=l7gooOol0
Rgoo000HOol00`00Oomoo`15Ool00g`OOomoo`0hOol00g`OOomoo`2<Ool001Qoo`03001oogoo04Io
o`03O1moogoo03Moo`03O1moogoo08aoo`0067oo00<007ooOol0AWoo00=l7gooOol0=Woo00=l7goo
Ool0SGoo000HOol00`00Oomoo`17Ool00g`OOomoo`0dOol00g`OOomoo`2>Ool001Qoo`8004Uoo`03
O1moogoo039oo`03O1moogoo08moo`0067oo00<007ooOol0B7oo00=l7gooOol0<Goo00=l7gooOol0
T7oo000HOol00`00Oomoo`19Ool00g`OOomoo`0`Ool00g`OOomoo`2@Ool001Qoo`03001oogoo04Yo
o`03O1moogoo02ioo`03O1moogoo095oo`0067oo00<007ooOol0Bgoo00=l7gooOol0;7oo00=l7goo
Ool0TWoo000HOol2001=Ool00g`OOomoo`0ZOol00g`OOomoo`2COol001Qoo`03001oogoo04aoo`03
O1moogoo02Uoo`03O1moogoo09Aoo`0067oo00<007ooOol0CGoo00=l7gooOol0:7oo00=l7gooOol0
U7oo000HOol00`00Oomoo`1>Ool00g`OOomoo`0VOol00g`OOomoo`2EOol001Qoo`03001oogoo04mo
o`03O1moogoo02Aoo`03O1moogoo09Ioo`0067oo0P00DGoo00=l7gooOol08Goo0W`OVGoo000HOol0
0`00Oomoo`1@Ool00g`OOomoo`0POol00g`OOomoo`2IOol001Qoo`03001oogoo055oo`03O1moogoo
01eoo`9l7iaoo`002goo0P0017oo0P001Goo00<007ooOol0DWoo00=l7gooOol06goo00=l7gooOol0
W7oo000:Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo05=oo`9l7aUoo`9l7imoo`00
37oo00D007ooOomoo`00009oo`03001oogoo009oo`<005Eoo`9l7aIoo`03O1moogoo09moo`003Goo
00@007ooOol0009oo`03001oogoo009oo`03001oogoo05Moo`9l7a9oo`9l7j9oo`002Woo00@007oo
Ool0009oo`04001oogoo0004Ool00`00Oomoo`1IOol2O1l=Ool3O1nTOol000]oo`8000Aoo`8000Eo
o`03001oogoo05]oo`9l7`Eoo`Il7jMoo`0067oo0P00GWoo1G`O[Goo000HOol00`00Oomoo`3oOol@
Ool001Qoo`03001oogoo0?mooa1oo`0067oo00<007ooOol0ogoo47oo000HOol00`00Oomoo`3oOol@
Ool00?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00
ogoo:goo003oOol[Ool00?moob]oo`005goo0P00ogoo4Woo000GOol2003oOolBOol001Ioo`04001o
ogoo003oOolAOol001Eoo`80009oo`800?mooa1oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo
:goo0000\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.5, 0}} -> {-0.206349, -2.52656, \
0.00830689, 0.207783}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.327406 0.00402761 [
[.2619 .31491 -9 -9 ]
[.2619 .31491 9 0 ]
[.5 .31491 -3 -9 ]
[.5 .31491 3 0 ]
[.7381 .31491 -9 -9 ]
[.7381 .31491 9 0 ]
[.97619 .31491 -3 -9 ]
[.97619 .31491 3 0 ]
[1.025 .32741 0 -6.25 ]
[1.025 .32741 10 6.25 ]
[.01131 .0052 -18 -4.5 ]
[.01131 .0052 0 4.5 ]
[.01131 .08575 -18 -4.5 ]
[.01131 .08575 0 4.5 ]
[.01131 .1663 -18 -4.5 ]
[.01131 .1663 0 4.5 ]
[.01131 .24685 -18 -4.5 ]
[.01131 .24685 0 4.5 ]
[.01131 .40796 -12 -4.5 ]
[.01131 .40796 0 4.5 ]
[.01131 .48851 -12 -4.5 ]
[.01131 .48851 0 4.5 ]
[.01131 .56906 -12 -4.5 ]
[.01131 .56906 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .32741 m
.2619 .33366 L
s
[(0.5)] .2619 .31491 0 1 Mshowa
.5 .32741 m
.5 .33366 L
s
[(1)] .5 .31491 0 1 Mshowa
.7381 .32741 m
.7381 .33366 L
s
[(1.5)] .7381 .31491 0 1 Mshowa
.97619 .32741 m
.97619 .33366 L
s
[(2)] .97619 .31491 0 1 Mshowa
.125 Mabswid
.07143 .32741 m
.07143 .33116 L
s
.11905 .32741 m
.11905 .33116 L
s
.16667 .32741 m
.16667 .33116 L
s
.21429 .32741 m
.21429 .33116 L
s
.30952 .32741 m
.30952 .33116 L
s
.35714 .32741 m
.35714 .33116 L
s
.40476 .32741 m
.40476 .33116 L
s
.45238 .32741 m
.45238 .33116 L
s
.54762 .32741 m
.54762 .33116 L
s
.59524 .32741 m
.59524 .33116 L
s
.64286 .32741 m
.64286 .33116 L
s
.69048 .32741 m
.69048 .33116 L
s
.78571 .32741 m
.78571 .33116 L
s
.83333 .32741 m
.83333 .33116 L
s
.88095 .32741 m
.88095 .33116 L
s
.92857 .32741 m
.92857 .33116 L
s
.25 Mabswid
0 .32741 m
1 .32741 L
s
gsave
1.025 .32741 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .0052 m
.03006 .0052 L
s
[(-80)] .01131 .0052 1 0 Mshowa
.02381 .08575 m
.03006 .08575 L
s
[(-60)] .01131 .08575 1 0 Mshowa
.02381 .1663 m
.03006 .1663 L
s
[(-40)] .01131 .1663 1 0 Mshowa
.02381 .24685 m
.03006 .24685 L
s
[(-20)] .01131 .24685 1 0 Mshowa
.02381 .40796 m
.03006 .40796 L
s
[(20)] .01131 .40796 1 0 Mshowa
.02381 .48851 m
.03006 .48851 L
s
[(40)] .01131 .48851 1 0 Mshowa
.02381 .56906 m
.03006 .56906 L
s
[(60)] .01131 .56906 1 0 Mshowa
.125 Mabswid
.02381 .02534 m
.02756 .02534 L
s
.02381 .04547 m
.02756 .04547 L
s
.02381 .06561 m
.02756 .06561 L
s
.02381 .10589 m
.02756 .10589 L
s
.02381 .12603 m
.02756 .12603 L
s
.02381 .14616 m
.02756 .14616 L
s
.02381 .18644 m
.02756 .18644 L
s
.02381 .20658 m
.02756 .20658 L
s
.02381 .22672 m
.02756 .22672 L
s
.02381 .26699 m
.02756 .26699 L
s
.02381 .28713 m
.02756 .28713 L
s
.02381 .30727 m
.02756 .30727 L
s
.02381 .34754 m
.02756 .34754 L
s
.02381 .36768 m
.02756 .36768 L
s
.02381 .38782 m
.02756 .38782 L
s
.02381 .4281 m
.02756 .4281 L
s
.02381 .44823 m
.02756 .44823 L
s
.02381 .46837 m
.02756 .46837 L
s
.02381 .50865 m
.02756 .50865 L
s
.02381 .52879 m
.02756 .52879 L
s
.02381 .54892 m
.02756 .54892 L
s
.02381 .5892 m
.02756 .5892 L
s
.02381 .60934 m
.02756 .60934 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .32741 m
.07143 .41111 L
.11905 .48415 L
.16667 .54781 L
.21429 .60332 L
.2619 .58083 L
.30952 .49034 L
.35714 .41146 L
.40476 .34269 L
.45238 .28274 L
.5 .23048 L
.54762 .18492 L
.59524 .01472 L
.64286 .14904 L
.69048 .26615 L
.7381 .274 L
.78571 .28085 L
.83333 .28682 L
.88095 .29202 L
.92857 .29656 L
.97619 .30051 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.5},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^1000`40O003h00Oogoo:goo003oOol[
Ool000Yoo`8000Aoo`800?mooaUoo`002Goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomo
o`3oOolAOol000Uoo`04001oogoo0002Ool01000Oomoo`0017oo0`00ogoo4Goo0003Ool40003Ool2
0003Ool01000Oomoo`0017oo00<007ooOol0ogoo4Goo0009Ool01000Oomoo`000Woo00@007ooOol0
00Aoo`03001oogoo0?mooa5oo`002Woo0P0017oo0P001Goo00<007ooOol0TWoo00<07gooOol0Ngoo
000GOol00`00Oomoo`2BOol00`0OOomoo`1kOol001Moo`03001oogoo095oo`0301moo`0O07aoo`00
5goo0P00TWoo00<07goo01l0O7oo000GOol00`00Oomoo`2AOol00`0OOol07`1lOol001Moo`03001o
ogoo095oo`0401moogoo01mkOol001Moo`03001oogoo091oo`0501moogooOol07`1kOol001Moo`03
001oogoo091oo`0301moogoo009oo`0301moogoo07Qoo`005goo0P00TGoo00<07gooOol00Woo00<0
7gooOol0N7oo000GOol00`00Oomoo`2@Ool00`0OOomoo`02Ool00`0OOomoo`1hOol001Moo`03001o
ogoo08moo`0301moogoo00Aoo`0301moogoo07Moo`005goo00<007ooOol0Sgoo00<07gooOol017oo
00<07gooOol0Mgoo000GOol00`00Oomoo`2?Ool00`0OOomoo`04Ool00`0OOomoo`1gOol001Moo`80
08moo`0301moogoo00Ioo`0301moogoo07Ioo`005goo00<007ooOol0SWoo00<07gooOol01Woo00<0
7gooOol0MWoo000GOol00`00Oomoo`2>Ool00`0OOomoo`07Ool00`0OOomoo`1eOol001Moo`03001o
ogoo08ioo`0301moogoo00Moo`0301moogoo07Eoo`002Goo0`0017oo0P001Goo00<007ooOol0SGoo
00<07gooOol027oo00<07gooOol0MGoo0009Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001o
ogoo08eoo`0301moogoo00Uoo`0301moogoo07Aoo`002Goo00@007ooOol0009oo`04001oogoo0004
Ool3002=Ool00`0OOomoo`09Ool00`0OOomoo`1dOol000=oo`@0009oo`<000=oo`04001oogoo0004
Ool00`00Oomoo`2=Ool00`0OOomoo`09Ool00`0OOomoo`1dOol000Yoo`03001oogoo009oo`04001o
ogoo0004Ool00`00Oomoo`2<Ool00`0OOomoo`0;Ool00`0OOomoo`1cOol000Yoo`<000=oo`8000Eo
o`03001oogoo08aoo`0301moogoo00]oo`0301moogoo07=oo`005goo00<007ooOol0S7oo00<07goo
Ool037oo00<07gooOol0LWoo000GOol2002<Ool00`0OOomoo`0=Ool00`0OOomoo`1bOol001Moo`03
001oogoo08]oo`0301moogoo00eoo`0301moogoo079oo`005goo00<007ooOol0Rgoo00<07gooOol0
3Woo00<07gooOol0LGoo000GOol00`00Oomoo`2;Ool00`0OOomoo`0>Ool00`0OOomoo`1aOol001Mo
o`03001oogoo08Yoo`0301moogoo00moo`0301moogoo075oo`005goo0P00Rgoo00<07gooOol047oo
00<07gooOol0L7oo000GOol00`00Oomoo`2:Ool00`0OOomoo`0@Ool00`0OOomoo`1`Ool001Moo`03
001oogoo08Yoo`0301moogoo015oo`0301moogoo06moo`005goo00<007ooOol0RGoo00<07gooOol0
4Woo00<07gooOol0Kgoo000GOol00`00Oomoo`29Ool00`0OOomoo`0BOol00`0OOomoo`1_Ool001Mo
o`8008Yoo`0301moogoo01=oo`0301moogoo06ioo`005goo00<007ooOol0R7oo00<07gooOol057oo
00<07gooOol0KWoo000GOol00`00Oomoo`28Ool00`0OOomoo`0DOol00`0OOomoo`1^Ool001Moo`03
001oogoo08Qoo`0301moogoo01Eoo`0301moogoo06eoo`002goo0`000Woo0P001Goo00<007ooOol0
R7oo00<07gooOol05Goo00<07gooOol0KGoo000<Ool01000Oomoo`000Woo00<007ooOol00Woo00<0
07ooOol0Qgoo00<07gooOol05goo00<07gooOol0K7oo0009Ool500001Goo001oogoo000017oo0`00
Qgoo00<07gooOol05goo00<07gooOol0K7oo0003Ool40002Ool01000Oomoo`000Woo00@007ooOol0
00Aoo`03001oogoo08Moo`0301moogoo01Moo`0301moogoo06aoo`002Woo00<007oo00000Woo00@0
07ooOol000Aoo`03001oogoo08Moo`0301moogoo01Qoo`0301moogoo06]oo`002goo0P000goo0P00
1Goo00<007ooOol0QWoo00<07gooOol06Goo00<07gooOol0Jgoo000GOol00`00Oomoo`26Ool00`0O
Oomoo`0IOol00`0OOomoo`1[Ool001Moo`8008Ioo`0301moogoo01]oo`0301moogoo06Yoo`005goo
00<007ooOol0Q7oo00<07gooOol077oo00<07gooOol0JWoo000GOol00`00Oomoo`23Ool00`0OOomo
o`0NOol00`0OOomoo`1YOol001Moo`03001oogoo089oo`0301moogoo01moo`0301moogoo06Uoo`00
5goo00<007ooOol0PGoo00<07gooOol087oo00<07gooOol0JGoo000GOol20021Ool00`0OOomoo`0R
Ool00`0OOomoo`1XOol001Moo`03001oogoo07moo`0301moogoo02=oo`0301moogoo06Qoo`005goo
00<007ooOol0OWoo00<07gooOol09Goo00<07gooOol0Igoo000GOol00`00Oomoo`1mOol00`0OOomo
o`0VOol00`0OOomoo`1WOol001Moo`03001oogoo07aoo`0301moogoo02Moo`0301moogoo06Moo`00
5goo0P00O7oo00<07gooOol0:Goo00<07gooOol0IWoo000GOol00`00Oomoo`1jOol00`0OOomoo`0Z
Ool00`0OOomoo`1VOol001Moo`03001oogoo07Uoo`0301moogoo02aoo`0301moogoo06Eoo`005goo
00<007ooOol0N7oo00<07gooOol0;Goo00<07gooOol0IGoo0009Ool40003Ool20005Ool00`00Oomo
o`1gOol00`0OOomoo`0^Ool00`0OOomoo`1UOol000Uoo`03001oogoo00=oo`04001oogoo0004Ool0
0`00Oomoo`1fOol00`0OOomoo`0`Ool00`0OOomoo`1TOol000Yoo`03001oogoo009oo`04001oogoo
0004Ool3001eOol00`0OOomoo`0aOol00`0OOomoo`1TOol000=oo`@000Aoo`05001oogooOol00002
Ool00`00Oomoo`02Ool00`00Oomoo`1dOol00`0OOomoo`0bOol00`0OOomoo`1TOol000Uoo`04001o
ogoo0002Ool01000Oomoo`0017oo00<007ooOol0Lgoo00<07gooOol0=7oo00<07gooOol0Hgoo000:
Ool20004Ool20005Ool00`00Oomoo`1cOol00`0OOomoo`0dOol00`0OOomoo`1SOol001Moo`03001o
ogoo079oo`0301moogoo03Ioo`0301moogoo069oo`005goo0P00LWoo00<07gooOol0=goo100OHGoo
000GOol00`00Oomoo`1`Ool00`0OOomoo`0lOol601mKOol001Moo`03001oogoo06moo`0301moogoo
04=oo`T07e9oo`005goo00<007ooOol0KWoo00<07gooOol0CGoo2P0OB7oo000GOol00`00Oomoo`0d
Ool20004Ool20004Ool2000[Ool00`0OOomoo`08Ool5000cOol50002Ool20004Ool20009Ool601lV
Ool4000HOol001Moo`8003Aoo`04001oogoo0008Ool01000Oomoo`00:Goo00<07gooOol02goo00<0
07ooOol0=Goo00<007ooOol01goo00@007ooOol000ioo`T07aeoo`03001oogoo01Uoo`005goo00<0
07ooOol0<goo00@007ooOol000]oo`03001oogoo02Ioo`0301moogoo00aoo`03001oogoo03Eoo`03
001oogoo00Yoo`03001oogoo01Eoo`T07aEoo`03001oogoo01Qoo`005goo00<007ooOol0<goo00@0
07ooOol000Uoo`8002Uoo`0301moogoo00aoo`03001oogoo03Eoo`03001oogoo00Qoo`80025oo`H0
7a1oo`03001oogoo01Moo`005goo00<007ooOol0<goo00@007ooOol000Uoo`03001oogoo02Moo`03
01moogoo00eoo`03001oogoo03Eoo`03001oogoo00Qoo`03001oogoo02Ioo`X07`Aoo`04001oogoo
000HOol001Moo`03001oogoo03Aoo`8000Yoo`<002Ioo`0301moogoo00eoo`8003Ioo`8000Yoo`<0
031oo`L07aUoo`005goo0P00JGoo00<07gooOol0YGoo000GOol00`00Oomoo`1XOol00`0OOomoo`2U
Ool001Moo`03001oogoo06Moo`0301moogoo0:Ioo`005goo00<007ooOol0IWoo00<07gooOol0Ygoo
000GOol00`00Oomoo`1UOol00`0OOomoo`2OOol20007Ool001Moo`03001oogoo06Eoo`0301moogoo
09ioo`04001oogoo0006Ool0015oo`H0000301l0000006@0000301l0000009H000Uoo`03001oogoo
00Moo`005goo00<0000OOol02Woo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02Goo00<0
07ooOol02Goo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol02Woo00<007oo01l02Goo00<0
07ooOol02Woo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02Goo00<0
07ooOol02Woo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol02Goo00<0
07ooOol02Woo00<007ooOol037oo1@001Woo000GOol00`0001moo`1ROol00`0OOomoo`2QOol00`00
Oomoo`07Ool001Moo`03001oo`0O069oo`0301moogoo0:]oo`005goo00<007oo01l0HGoo00<07goo
Ool0[7oo000GOol200000goo01moo`1NOol00`0OOomoo`2]Ool001Moo`05001oogooOol07`1NOol0
0`0OOomoo`2]Ool001Moo`05001oogooOol07`1MOol00`0OOomoo`2^Ool001Moo`03001oogoo009o
o`0301moogoo05Uoo`0301moogoo0:moo`005goo00<007ooOol00goo00<07gooOol0Egoo00<07goo
Ool0/7oo000GOol20004Ool00`0OOomoo`1GOol00`0OOomoo`2`Ool001Moo`03001oogoo00Aoo`03
01moogoo05Eoo`0301moogoo0;5oo`005goo00<007ooOol017oo00<07gooOol0E7oo00<07gooOol0
/Woo000GOol00`00Oomoo`05Ool00`0OOomoo`1BOol00`0OOomoo`2cOol001Moo`03001oogoo00Io
o`0301moogoo055oo`0301moogoo0;=oo`005goo0P001goo00<07gooOol0D7oo00<07gooOol0]7oo
000GOol00`00Oomoo`07Ool00`0OOomoo`1>Ool00`0OOomoo`2eOol001Moo`03001oogoo00Qoo`03
01moogoo04eoo`0301moogoo0;Eoo`005goo00<007ooOol027oo00<07gooOol0C7oo00<07gooOol0
]Woo0009Ool40003Ool20005Ool00`00Oomoo`09Ool00`0OOomoo`1:Ool00`0OOomoo`2gOol000Uo
o`03001oogoo00=oo`04001oogoo0004Ool00`00Oomoo`09Ool00`0OOomoo`19Ool00`0OOomoo`2h
Ool000Yoo`03001oogoo009oo`04001oogoo0004Ool3000:Ool00`0OOomoo`18Ool00`0OOomoo`2h
Ool000]oo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`0;Ool00`0OOomoo`16Ool0
0`0OOomoo`2iOol000Uoo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol02goo00<07goo
Ool0AGoo00<07gooOol0^Woo000:Ool20004Ool20005Ool00`00Oomoo`0<Ool00`0OOomoo`14Ool0
0`0OOomoo`2jOol001Moo`03001oogoo00aoo`0301moogoo04=oo`0301moogoo0;]oo`005goo0P00
3Woo00<07gooOol0@Woo00<07gooOol0^goo000GOol00`00Oomoo`0>Ool00`0OOomoo`10Ool00`0O
Oomoo`2lOol001Moo`03001oogoo00ioo`0301moogoo03moo`0301moogoo0;eoo`005goo00<007oo
Ool03goo00<07gooOol0?Woo00<07gooOol0_Goo000GOol00`00Oomoo`0?Ool00`0OOomoo`0mOol0
0`0OOomoo`2nOol001Moo`80015oo`0301moogoo03aoo`0301moogoo0;ioo`005goo00<007ooOol0
4Goo00<07gooOol0>Woo00<07gooOol0_goo000GOol00`00Oomoo`0AOol00`0OOomoo`0iOol00`0O
Oomoo`30Ool001Moo`03001oogoo019oo`0301moogoo03Qoo`0301moogoo0<1oo`005goo00<007oo
Ool04Woo00<07gooOol0=goo00<07gooOol0`Goo000GOol2000DOol00`0OOomoo`0fOol00`0OOomo
o`31Ool001Moo`03001oogoo01Aoo`0301moogoo03Aoo`0301moogoo0<9oo`005goo00<007ooOol0
57oo00<07gooOol0<goo00<07gooOol0`goo000GOol00`00Oomoo`0EOol00`0OOomoo`0bOol00`0O
Oomoo`33Ool000]oo`<0009oo`8000Eoo`03001oogoo01Eoo`0301moogoo035oo`0301moogoo0<Ao
o`0037oo00@007ooOol0009oo`03001oogoo009oo`03001oogoo01Ioo`0301moogoo031oo`0301mo
ogoo0<Aoo`002Goo1@0000Eoo`00Oomoo`0000Aoo`<001Moo`0301moogoo02ioo`0301moogoo0<Eo
o`002Goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`0HOol00`0OOomoo`0/Ool00`0O
Oomoo`36Ool000Yoo`03001oo`00009oo`04001oogoo0004Ool00`00Oomoo`0HOol00`0OOomoo`0/
Ool00`0OOomoo`36Ool000]oo`8000=oo`8000Eoo`03001oogoo01Uoo`0301moogoo02Yoo`0301mo
ogoo0<Moo`005goo00<007ooOol06Woo00<07gooOol0:Goo00<07gooOol0agoo000GOol2000LOol0
0`0OOomoo`0WOol00`0OOomoo`38Ool001Moo`03001oogoo01aoo`0301moogoo02Ioo`0301moogoo
0<Qoo`005goo00<007ooOol07Goo00<07gooOol097oo00<07gooOol0bGoo000GOol00`00Oomoo`0M
Ool00`0OOomoo`0TOol00`0OOomoo`39Ool001Moo`03001oogoo01ioo`0301moogoo029oo`0301mo
ogoo0<Yoo`005goo0P0087oo00<07gooOol08Goo00<07gooOol0bWoo000GOol00`00Oomoo`0POol0
0`0OOomoo`0OOol00`0OOomoo`3;Ool001Moo`03001oogoo025oo`0301moogoo01eoo`0301moogoo
0<aoo`005goo00<007ooOol08Goo00<07gooOol07Goo00<07gooOol0c7oo000GOol00`00Oomoo`0R
Ool00`0OOomoo`0KOol00`0OOomoo`3=Ool001Moo`8002Aoo`0301moogoo01Yoo`0301moogoo0<eo
o`005goo00<007ooOol097oo00<07gooOol067oo00<07gooOol0cWoo000GOol00`00Oomoo`0UOol0
0`0OOomoo`0GOol00`0OOomoo`3>Ool001Moo`03001oogoo02Eoo`0301moogoo01Ioo`0301moogoo
0<moo`002Goo0`0017oo0P001Goo00<007ooOol09Woo00<07gooOol05Goo00<07gooOol0cgoo0009
Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo02Moo`0301moogoo01=oo`0301moogoo
0=1oo`002Goo00@007ooOol0009oo`04001oogoo0004Ool3000XOol00`0OOomoo`0BOol00`0OOomo
o`3@Ool000Uoo`<000=oo`04001oogoo0004Ool00`00Oomoo`0YOol00`0OOomoo`0@Ool00`0OOomo
o`3AOol000Yoo`03001oogoo009oo`04001oogoo0004Ool00`00Oomoo`0YOol00`0OOomoo`0@Ool0
0`0OOomoo`3AOol000Yoo`<000=oo`8000Eoo`03001oogoo02Yoo`0301moogoo00ioo`0301moogoo
0=9oo`005goo00<007ooOol0:goo00<07gooOol02goo0P0OeGoo000GOol2000]Ool00`0OOomoo`08
Ool201oGOol001Moo`03001oogoo02eoo`0301moogoo00Eoo`807mUoo`005goo00<007ooOol0;Goo
00<07gooOol00goo0P0Ofgoo000GOol00`00Oomoo`0^Ool00`0OOomoo`0201oMOol001Moo`03001o
ogoo02moo`807mmoo`005goo0P00ogoo4Woo000GOol00`00Oomoo`3oOolAOol001Moo`03001oogoo
0?mooa5oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo
:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool001Eoo`D00?mooa5oo`005Goo1000ogoo
4Woo000HOol00`00Oomoo`3oOol@Ool001Ioo`<00?mooa9oo`00ogoo:goo003oOol[Ool00?moob]o
o`00ogoo:goo0000\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.5, 0}} -> {-0.191218, -84.2803, \
0.00804479, 0.951147}}],

Cell[BoxData[
    InterpretationBox[\("t"\[InvisibleSpace]"         "\[InvisibleSpace]"p    \
     "\[InvisibleSpace]"u"\[InvisibleSpace]"          \
v"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]"         a"\),
      SequenceForm[ 
      "t", "         ", "p         ", "u", "          v", "", "         a"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("----------------------------------------------------"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        InterpretationBox[GridBox[{
              {"0"},
              {"0.1`"},
              {"0.2`"},
              {"0.30000000000000004`"},
              {"0.4`"},
              {"0.5`"},
              {"0.6000000000000001`"},
              {"0.7000000000000001`"},
              {"0.8`"},
              {"0.9`"},
              {"1.`"},
              {"1.1`"},
              {"1.2000000000000002`"},
              {"1.3`"},
              {"1.4000000000000001`"},
              {"1.5`"},
              {"1.6`"},
              {"1.7000000000000002`"},
              {"1.8`"},
              {"1.9000000000000001`"},
              {"2.`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0, 1.1000000000000001, 
            1.2000000000000002, 1.3, 1.4000000000000001, 1.5, 
            1.6000000000000001, 1.7000000000000002, 1.8, 1.9000000000000001, 
            2.0}]], "\[InvisibleSpace]", "\<\"     \"\>", "\[InvisibleSpace]",
         
        InterpretationBox[GridBox[{
              {"0"},
              {"4.444444444444443`"},
              {"8.88888888888889`"},
              {"13.333333333333336`"},
              {"17.77777777777778`"},
              {"18.461538461538463`"},
              {"15.384615384615383`"},
              {"12.307692307692307`"},
              {"9.230769230769232`"},
              {"6.153846153846157`"},
              {"3.07692307692308`"},
              {"0"},
              {\(-9.99999999999999`\)},
              {\(-4.999999999999994`\)},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 4.4444444444444429, 8.8888888888888893, 
            13.333333333333336, 17.777777777777779, 18.461538461538463, 
            15.384615384615383, 12.307692307692307, 9.2307692307692317, 
            6.1538461538461569, 3.0769230769230802, 
            0, -9.9999999999999893, -4.9999999999999938, 0, 0, 0, 0, 0, 0, 
            0}]], "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"0.0349997424127989`"},
              {"0.27413889530726476`"},
              {"0.8985680627060851`"},
              {"2.0668623407581843`"},
              {"3.8879348513329353`"},
              {"6.310084533440568`"},
              {"9.141589632283836`"},
              {"12.185980474546`"},
              {"15.271978163928937`"},
              {"18.250264692101624`"},
              {"20.990667176742722`"},
              {"23.3257093917538`"},
              {"25.01039991426931`"},
              {"26.245111399269966`"},
              {"27.282516248687944`"},
              {"28.186908028971377`"},
              {"28.975341293673313`"},
              {"29.662683910491147`"},
              {"30.261897431844268`"},
              {"30.78428151714182`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .0349997424127989, .27413889530726476, .89856806270608514, 
            2.0668623407581843, 3.8879348513329353, 6.310084533440568, 
            9.1415896322838357, 12.185980474546, 15.271978163928937, 
            18.250264692101624, 20.990667176742722, 23.325709391753801, 
            25.010399914269311, 26.245111399269966, 27.282516248687944, 
            28.186908028971377, 28.975341293673313, 29.662683910491147, 
            30.261897431844268, 30.784281517141821}]], 
        "\[InvisibleSpace]", "\<\"   \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"1.0499922721739685`"},
              {"4.035003401837517`"},
              {"8.717043728935145`"},
              {"14.878525045653603`"},
              {"21.44985974717399`"},
              {"26.618701746402486`"},
              {"29.684976696163655`"},
              {"30.918269702472475`"},
              {"30.553600443619075`"},
              {"28.7958550499986`"},
              {"25.82364974104302`"},
              {"20.17288697593037`"},
              {"14.076784481122282`"},
              {"11.102035324441198`"},
              {"9.678564253361701`"},
              {"8.437606553117856`"},
              {"7.355760883696105`"},
              {"6.4126263576630125`"},
              {"5.590417830756299`"},
              {"4.873630518810944`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 1.0499922721739685, 4.0350034018375167, 
            8.7170437289351455, 14.878525045653603, 21.449859747173988, 
            26.618701746402486, 29.684976696163655, 30.918269702472475, 
            30.553600443619075, 28.7958550499986, 25.82364974104302, 
            20.172886975930371, 14.076784481122282, 11.102035324441198, 
            9.6785642533617011, 8.4376065531178561, 7.3557608836961048, 
            6.4126263576630125, 5.5904178307562988, 4.8736305188109439}]], 
        "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"20.783732809343878`"},
              {"38.91648978392705`"},
              {"54.72431675802553`"},
              {"68.50530957634346`"},
              {"62.92138445406395`"},
              {"40.45545553050551`"},
              {"20.870043464717327`"},
              {"3.7958166614588684`"},
              {\(-11.089201838527352`\)},
              {\(-24.065706033882684`\)},
              {\(-35.37840014522894`\)},
              {\(-77.63685515702456`\)},
              {\(-44.285194739137495`\)},
              {\(-15.209788394484443`\)},
              {\(-13.259633027105531`\)},
              {\(-11.559520977771465`\)},
              {\(-10.077392410663663`\)},
              {\(-8.785298109998328`\)},
              {\(-7.65887242813613`\)},
              {\(-6.676873810770994`\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 20.783732809343878, 38.916489783927048, 
            54.72431675802553, 68.505309576343464, 62.921384454063947, 
            40.45545553050551, 20.870043464717327, 
            3.7958166614588684, -11.089201838527352, -24.065706033882684, \
-35.378400145228937, -77.636855157024556, -44.285194739137495, \
-15.209788394484443, -13.259633027105531, -11.559520977771465, \
-10.077392410663663, -8.7852981099983278, -7.6588724281361298, \
-6.676873810770994}]]}],
      SequenceForm[ 
        TableForm[ {
          0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0, 1.1000000000000001, 
          1.2000000000000002, 1.3, 1.4000000000000001, 1.5, 
          1.6000000000000001, 1.7000000000000002, 1.8, 1.9000000000000001, 
          2.0}], "     ", 
        TableForm[ {0, 4.4444444444444429, 8.8888888888888893, 
          13.333333333333336, 17.777777777777779, 18.461538461538463, 
          15.384615384615383, 12.307692307692307, 9.2307692307692317, 
          6.1538461538461569, 3.0769230769230802, 
          0, -9.9999999999999893, -4.9999999999999938, 0, 0, 0, 0, 0, 0, 0}], 
        
        TableForm[ {
          0, .0349997424127989, .27413889530726476, .89856806270608514, 
          2.0668623407581843, 3.8879348513329353, 6.310084533440568, 
          9.1415896322838357, 12.185980474546, 15.271978163928937, 
          18.250264692101624, 20.990667176742722, 23.325709391753801, 
          25.010399914269311, 26.245111399269966, 27.282516248687944, 
          28.186908028971377, 28.975341293673313, 29.662683910491147, 
          30.261897431844268, 30.784281517141821}], "   ", 
        TableForm[ {0, 1.0499922721739685, 4.0350034018375167, 
          8.7170437289351455, 14.878525045653603, 21.449859747173988, 
          26.618701746402486, 29.684976696163655, 30.918269702472475, 
          30.553600443619075, 28.7958550499986, 25.82364974104302, 
          20.172886975930371, 14.076784481122282, 11.102035324441198, 
          9.6785642533617011, 8.4376065531178561, 7.3557608836961048, 
          6.4126263576630125, 5.5904178307562988, 4.8736305188109439}], "  ", 
        
        TableForm[ {0, 20.783732809343878, 38.916489783927048, 
          54.72431675802553, 68.505309576343464, 62.921384454063947, 
          40.45545553050551, 20.870043464717327, 
          3.7958166614588684, -11.089201838527352, -24.065706033882684, \
-35.378400145228937, -77.636855157024556, -44.285194739137495, \
-15.209788394484443, -13.259633027105531, -11.559520977771465, \
-10.077392410663663, -8.7852981099983278, -7.6588724281361298, \
-6.676873810770994}]],
      Editable->False]], "Print"]
}, Open  ]],

Cell["\<\
EJEMPLO
0.2533 a( t )  + 0.1592 v( t ) + fs ( u,v ) = p( t )
u( 0 ) = 0
v( 0 ) = 0

Hallar la respuesta hasta el instante tn=1 y con un incremento de tiempo
to=0.1,para el m\[EAcute]todo de la aceleraci\[OAcute]n constante, siendo p( \
t ) la carga dada en forma discreta siguiente:

p={{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
    {.7,0},{.8,0},{.9,0},{1,0}};

y siendo el material elastopl\[AAcute]stico perfecto, en el que la \
plastificaci\[OAcute]n a tracci\[OAcute]n se alcanza paran un valor de ft = \
7.5, y a compresi\[OAcute]n para fc = -7.5,
y la rigidez el\[AAcute]stica es 10. \
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["\<\
p={{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
    {.7,0},{.8,0},{.9,0},{1,0}};
HilbergNoLineal[0,1,.1,0,0,10,.2533,.1592,p,
        0.5,0.1666666667,-0.1,-7.5,7.5,posicion,velocidad,aceleracion]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]1\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]10\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]0.3016482058535258`\),
      SequenceForm[ 
      "i = ", 1, "     j = ", 3, "      kt = ", 10, 
        "      fs = ", .30164820585352581],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]2\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]10\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]2.211173226103093`\),
      SequenceForm[ 
      "i = ", 2, "     j = ", 3, "      kt = ", 10, "      fs = ", 
        2.2111732261030932],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]3\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]10\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]6.23922422013862`\),
      SequenceForm[ 
      "i = ", 3, "     j = ", 3, "      kt = ", 10, "      fs = ", 
        6.2392242201386203],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]4\[InvisibleSpace]"     j = "\
\[InvisibleSpace]6\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]7.5`\),
      SequenceForm[ 
      "i = ", 4, "     j = ", 6, "      kt = ", 0, "      fs = ", 7.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]5\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]7.5`\),
      SequenceForm[ 
      "i = ", 5, "     j = ", 3, "      kt = ", 0, "      fs = ", 7.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]6\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]7.5`\),
      SequenceForm[ 
      "i = ", 6, "     j = ", 3, "      kt = ", 0, "      fs = ", 7.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]7\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]0\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]7.5`\),
      SequenceForm[ 
      "i = ", 7, "     j = ", 3, "      kt = ", 0, "      fs = ", 7.5],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]8\[InvisibleSpace]"     j = "\
\[InvisibleSpace]6\[InvisibleSpace]"      kt = "\[InvisibleSpace]10\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]5.912977519501532`\),
      SequenceForm[ 
      "i = ", 8, "     j = ", 6, "      kt = ", 10, "      fs = ", 
        5.9129775195015322],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]9\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]10\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]2.2674655403745025`\),
      SequenceForm[ 
      "i = ", 9, "     j = ", 3, "      kt = ", 10, "      fs = ", 
        2.2674655403745025],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]10\[InvisibleSpace]"     j = "\
\[InvisibleSpace]3\[InvisibleSpace]"      kt = "\[InvisibleSpace]10\
\[InvisibleSpace]"      fs = "\[InvisibleSpace]\(-2.0540278634761644`\)\),
      SequenceForm[ 
      "i = ", 10, "     j = ", 3, "      kt = ", 10, 
        "      fs = ", -2.0540278634761644],
      Editable->False]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.0588604 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .13244 -6 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -6 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -6 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -6 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -12 -4.5 ]
[.01131 .60332 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .13244 m
.03006 .13244 L
s
[(2)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(4)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(6)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(8)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(10)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .16187 m
.02756 .16187 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 0 r
.5 Mabswid
.02381 .01472 m
.11905 .30902 L
.21429 .52445 L
.30952 .60332 L
.40476 .52445 L
.5 .30902 L
.59524 .01472 L
.69048 .01472 L
.78571 .01472 L
.88095 .01472 L
.97619 .01472 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.563},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^1000`40O003h00Oogoo:goo0011Ool2
0004Ool20003Ool4000ROol20004Ool20005Ool3000POol20004Ool20003Ool3000ROol20004Ool2
0004Ool2000WOol5000NOol0041oo`04001oogoo0008Ool00`00Oomoo`0ROol01000Oomoo`002goo
00<007ooOol07Woo00@007ooOol000Qoo`04001oogoo000POol01000Oomoo`0027oo00@007ooOol0
02Qoo`03001oogoo01ioo`00@7oo00@007ooOol000Uoo`03001oogoo025oo`04001oogoo0008Ool5
000OOol01000Oomoo`0027oo00@007ooOol0021oo`04001oogoo0008Ool01000Oomoo`00:7oo00<0
07ooOol07Woo0010Ool01000Oomoo`002Woo00<007ooOol087oo00@007ooOol000Qoo`04001oogoo
000POol01000Oomoo`0027oo0`008Goo00@007ooOol000Uoo`8002Uoo`03001oogoo01ioo`00@7oo
00@007ooOol000Qoo`04001oogoo000QOol01000Oomoo`002Goo00<007oo000087oo00@007ooOol0
00Uoo`03001oogoo021oo`04001oogoo0008Ool01000Oomoo`00:7oo00<007ooOol07Woo0011Ool2
000:Ool2000SOol2000;Ool2000QOol2000:Ool3000QOol2000:Ool2000XOol2000POol00?moob]o
o`0067oo00<007ooOol0ogoo47oo000HOol00`00Oomoo`3oOol@Ool001Qoo`03001oogoo0?mooa1o
o`0067oo00<007ooOol0oWoo0P003goo000BOol600000`?P0000002>001Q0n060008Ool01000Oomo
o`003Woo000HOol00`?POomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool0
0`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool0
0`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`?POomoo`09Ool00`00Oomoo`09Ool0
0`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool0
0`00Oomoo`09Ool00`00Oomoo`0<Ool00`00Oomoo`0?Ool001Qoo`030003h7oo02eoo`03001oogoo
02ioo`03001oogoo02aoo`030n0007oo02ioo`03001oogoo02eoo`03001oogoo00]oo`D000ioo`00
67oo00<000?POol0SGoo00<3h7ooOol0KGoo00<007ooOol03goo000HOol00`000n1oo`2=Ool00`?P
Oomoo`1oOol001Qoo`03001oo`?P08aoo`030n1oogoo081oo`0067oo00<007oo0n00S7oo00<3h7oo
Ool0P7oo000HOol00`00Ool3h02<Ool00`?POomoo`20Ool001Qoo`800003Ool3h7oo08Uoo`030n1o
ogoo085oo`0067oo00@007ooOol3h8Yoo`030n1oogoo085oo`0067oo00@007ooOol3h8Yoo`030n1o
ogoo085oo`0067oo00D007ooOomoo`?P08Qoo`030n1oogoo089oo`0067oo00D007ooOomoo`?P08Qo
o`030n1oogoo089oo`0067oo00D007ooOomoo`?P08Qoo`030n1oogoo089oo`0067oo00D007ooOomo
o`?P08Qoo`030n1oogoo089oo`0067oo0P000goo00<3h7ooOol0Q7oo00<3h7ooOol0Pgoo000HOol0
0`00Oomoo`02Ool00`?POomoo`24Ool00`?POomoo`23Ool001Qoo`03001oogoo009oo`030n1oogoo
08Aoo`030n1oogoo08=oo`0067oo00<007ooOol00goo00<3h7ooOol0PWoo00<3h7ooOol0Q7oo000H
Ool00`00Oomoo`03Ool00`?POomoo`22Ool00`?POomoo`24Ool001Qoo`03001oogoo00=oo`030n1o
ogoo089oo`030n1oogoo08Aoo`0067oo00<007ooOol017oo00<3h7ooOol0P7oo00<3h7ooOol0QGoo
000HOol20005Ool00`?POomoo`20Ool00`?POomoo`25Ool001Qoo`03001oogoo00Aoo`030n1oogoo
081oo`030n1oogoo08Eoo`0067oo00<007ooOol01Goo00<3h7ooOol0OWoo00<3h7ooOol0QWoo000H
Ool00`00Oomoo`05Ool00`?POomoo`1nOol00`?POomoo`26Ool001Qoo`03001oogoo00Eoo`030n1o
ogoo07ioo`030n1oogoo08Ioo`0067oo00<007ooOol01Woo00<3h7ooOol0O7oo00<3h7ooOol0Qgoo
000@Ool40004Ool00`00Oomoo`06Ool00`?POomoo`1lOol00`?POomoo`27Ool0011oo`03001oogoo
00Eoo`03001oogoo00Ioo`030n1oogoo07aoo`030n1oogoo08Moo`004Goo00<007ooOol017oo0`00
1goo00<3h7ooOol0NWoo00<3h7ooOol0R7oo000BOol00`00Oomoo`03Ool00`00Oomoo`07Ool00`?P
Oomoo`1jOol00`?POomoo`28Ool0011oo`04001oogoo0004Ool00`00Oomoo`07Ool00`?POomoo`1j
Ool00`?POomoo`28Ool0015oo`8000Eoo`03001oogoo00Qoo`030n1oogoo07Qoo`030n1oogoo08Uo
o`0067oo00<007ooOol027oo00<3h7ooOol0N7oo00<3h7ooOol0RGoo000HOol00`00Oomoo`08Ool0
0`?POomoo`1hOol00`?POomoo`29Ool001Qoo`03001oogoo00Uoo`030n1oogoo07Ioo`030n1oogoo
08Yoo`0067oo0P002Woo00<3h7ooOol0MWoo00<3h7ooOol0RWoo000HOol00`00Oomoo`09Ool00`?P
Oomoo`1fOol00`?POomoo`2:Ool001Qoo`03001oogoo00Uoo`030n1oogoo07Ioo`030n1oogoo08Yo
o`0067oo00<007ooOol02Woo00<3h7ooOol0M7oo00<3h7ooOol0Rgoo000HOol00`00Oomoo`0:Ool0
0`?POomoo`1dOol00`?POomoo`2;Ool001Qoo`03001oogoo00Yoo`030n1oogoo07Aoo`030n1oogoo
08]oo`0067oo00<007ooOol02goo00<3h7ooOol0LWoo00<3h7ooOol0S7oo000HOol00`00Oomoo`0;
Ool00`?POomoo`1bOol00`?POomoo`2<Ool001Qoo`8000aoo`030n1oogoo079oo`030n1oogoo08ao
o`0067oo00<007ooOol037oo00<3h7ooOol0L7oo00<3h7ooOol0SGoo000HOol00`00Oomoo`0<Ool0
0`?POomoo`1`Ool00`?POomoo`2=Ool001Qoo`03001oogoo00aoo`030n1oogoo071oo`030n1oogoo
08eoo`0067oo00<007ooOol03Goo00<3h7ooOol0KWoo00<3h7ooOol0SWoo000HOol00`00Oomoo`0=
Ool00`?POomoo`1^Ool00`?POomoo`2>Ool001Qoo`03001oogoo00eoo`030n1oogoo06ioo`030n1o
ogoo08ioo`0067oo0P003goo00<3h7ooOol0K7oo00<3h7ooOol0Sgoo000HOol00`00Oomoo`0>Ool0
0`?POomoo`1/Ool00`?POomoo`2?Ool001Qoo`03001oogoo00ioo`030n1oogoo06aoo`030n1oogoo
08moo`0067oo00<007ooOol03goo00<3h7ooOol0JWoo00<3h7ooOol0T7oo000HOol00`00Oomoo`0?
Ool00`?POomoo`1ZOol00`?POomoo`2@Ool001Qoo`03001oogoo00moo`030n1oogoo06Yoo`030n1o
ogoo091oo`004Woo0`000goo00<007ooOol047oo00<3h7ooOol0J7oo00<3h7ooOol0TGoo000COol0
0`00Oomoo`02Ool00`00Oomoo`0@Ool00`?POomoo`1XOol00`?POomoo`2AOol0011oo`D000=oo`<0
011oo`030n1oogoo06Qoo`030n1oogoo095oo`0047oo00@007ooOol000Aoo`03001oogoo015oo`03
0n1oogoo06Ioo`030n1oogoo099oo`004Goo00<007oo000017oo00<007ooOol04Goo00<3h7ooOol0
IWoo00<3h7ooOol0TWoo000BOol20004Ool00`00Oomoo`0AOol00`?POomoo`1VOol00`?POomoo`2B
Ool001Qoo`03001oogoo015oo`030n1oogoo06Ioo`030n1oogoo099oo`0067oo00<007ooOol04Woo
00<3h7ooOol0I7oo00<3h7ooOol0Tgoo000HOol00`00Oomoo`0BOol00`?POomoo`1TOol00`?POomo
o`2COol001Qoo`8001=oo`030n1oogoo06Aoo`030n1oogoo09=oo`0067oo00<007ooOol04goo00<3
h7ooOol0HWoo00<3h7ooOol0U7oo000HOol00`00Oomoo`0COol00`?POomoo`1ROol00`?POomoo`2D
Ool001Qoo`03001oogoo01=oo`030n1oogoo069oo`030n1oogoo09Aoo`0067oo00<007ooOol057oo
00<3h7ooOol0H7oo00<3h7ooOol0UGoo000HOol00`00Oomoo`0DOol00`?POomoo`1POol00`?POomo
o`2EOol001Qoo`03001oogoo01Aoo`030n1oogoo061oo`030n1oogoo09Eoo`0067oo00<007ooOol0
5Goo00<3h7ooOol0GWoo00<3h7ooOol0UWoo000HOol2000FOol00`?POomoo`1NOol00`?POomoo`2F
Ool001Qoo`03001oogoo01Eoo`030n1oogoo05ioo`030n1oogoo09Ioo`0067oo00<007ooOol05Woo
00<3h7ooOol0G7oo00<3h7ooOol0Ugoo000HOol00`00Oomoo`0FOol00`?POomoo`1LOol00`?POomo
o`2GOol001Qoo`03001oogoo01Moo`030n1oogoo05Yoo`030n1oogoo09Qoo`0067oo00<007ooOol0
5goo00<3h7ooOol0FWoo00<3h7ooOol0V7oo000HOol00`00Oomoo`0HOol00`?POomoo`1HOol00`?P
Oomoo`2IOol001Qoo`8001Uoo`030n1oogoo05Qoo`030n1oogoo09Uoo`0067oo00<007ooOol06Goo
00<3h7ooOol0EWoo00<3h7ooOol0VWoo000HOol00`00Oomoo`0IOol00`?POomoo`1FOol00`?POomo
o`2JOol001Qoo`03001oogoo01Uoo`030n1oogoo05Ioo`030n1oogoo09Yoo`0067oo00<007ooOol0
6Woo00<3h7ooOol0E7oo00<3h7ooOol0Vgoo000@Ool30005Ool00`00Oomoo`0JOol00`?POomoo`1D
Ool00`?POomoo`2KOol0011oo`04001oogoo0004Ool00`00Oomoo`0KOol00`?POomoo`1BOol00`?P
Oomoo`2LOol0011oo`04001oogoo0004Ool3000KOol00`?POomoo`1BOol00`?POomoo`2LOol0011o
o`<000Eoo`03001oogoo01aoo`030n1oogoo051oo`030n1oogoo09eoo`004Goo00<007ooOol017oo
00<007ooOol077oo00<3h7ooOol0D7oo00<3h7ooOol0WGoo000AOol30004Ool00`00Oomoo`0MOol0
0`?POomoo`1>Ool00`?POomoo`2NOol001Qoo`03001oogoo01eoo`030n1oogoo04ioo`030n1oogoo
09ioo`0067oo00<007ooOol07Goo00<3h7ooOol0CWoo00<3h7ooOol0WWoo000HOol00`00Oomoo`0N
Ool00`?POomoo`1<Ool00`?POomoo`2OOol001Qoo`03001oogoo01ioo`030n1oogoo04aoo`030n1o
ogoo09moo`0067oo0P0087oo00<3h7ooOol0BWoo00<3h7ooOol0X7oo000HOol00`00Oomoo`0OOol0
0`?POomoo`1:Ool00`?POomoo`2POol001Qoo`03001oogoo021oo`030n1oogoo04Qoo`030n1oogoo
0:5oo`0067oo00<007ooOol087oo00<3h7ooOol0B7oo00<3h7ooOol0XGoo000HOol00`00Oomoo`0Q
Ool00`?POomoo`16Ool00`?POomoo`2ROol001Qoo`03001oogoo025oo`030n1oogoo04Ioo`030n1o
ogoo0:9oo`0067oo00<007ooOol08Goo00<3h7ooOol0AWoo00<3h7ooOol0XWoo000HOol2000SOol0
0`?POomoo`14Ool00`?POomoo`2SOol001Qoo`03001oogoo029oo`030n1oogoo04Aoo`030n1oogoo
0:=oo`0067oo00<007ooOol08goo00<3h7ooOol0@Woo00<3h7ooOol0Y7oo000HOol00`00Oomoo`0S
Ool00`?POomoo`12Ool00`?POomoo`2TOol001Qoo`03001oogoo02Aoo`030n1oogoo041oo`030n1o
ogoo0:Eoo`0067oo00<007ooOol097oo00<3h7ooOol0@7oo00<3h7ooOol0YGoo000HOol00`00Oomo
o`0UOol00`?POomoo`0nOol00`?POomoo`2VOol001Qoo`03001oogoo02Eoo`030n1oogoo03ioo`03
0n1oogoo0:Ioo`0067oo0P009Woo00<3h7ooOol0?Woo00<3h7ooOol0YWoo000HOol00`00Oomoo`0V
Ool00`?POomoo`0lOol00`?POomoo`2WOol001Qoo`03001oogoo02Ioo`030n1oogoo03aoo`030n1o
ogoo0:Moo`0067oo00<007ooOol09goo00<3h7ooOol0>Woo00<3h7ooOol0Z7oo000HOol00`00Oomo
o`0WOol00`?POomoo`0jOol00`?POomoo`2XOol0015oo`8000Eoo`03001oogoo02Qoo`030n1oogoo
03Qoo`030n1oogoo0:Uoo`0047oo00@007ooOol000Aoo`03001oogoo02Qoo`030n1oogoo03Qoo`03
0n1oogoo0:Uoo`0047oo00@007ooOol000Aoo`<002Uoo`030n1oogoo03Ioo`030n1oogoo0:Yoo`00
4Goo0P001Goo00<007ooOol0:Goo00<3h7ooOol0=Woo00<3h7ooOol0ZWoo000@Ool01000Oomoo`00
17oo00<007ooOol0:Goo00<3h7ooOol0=Woo00<3h7ooOol0ZWoo000AOol20005Ool00`00Oomoo`0Z
Ool00`?POomoo`0dOol00`?POomoo`2[Ool001Qoo`03001oogoo02Yoo`030n1oogoo03Aoo`030n1o
ogoo0:]oo`0067oo00<007ooOol0:goo00<3h7ooOol0<Woo00<3h7ooOol0[7oo000HOol00`00Oomo
o`0[Ool00`?POomoo`0bOol00`?POomoo`2/Ool001Qoo`03001oogoo02aoo`030n1oogoo031oo`03
0n1oogoo0:eoo`0067oo0P00;Goo00<3h7ooOol0<7oo00<3h7ooOol0[Goo000HOol00`00Oomoo`0]
Ool00`?POomoo`0^Ool00`?POomoo`2^Ool001Qoo`03001oogoo02eoo`030n1oogoo02ioo`030n1o
ogoo0:ioo`0067oo00<007ooOol0;Woo00<3h7ooOol0;7oo00<3h7ooOol0[goo000HOol00`00Oomo
o`0_Ool20n0[Ool00`?POomoo`2`Ool001Qoo`03001oogoo035oo`030n1oogoo02Ioo`83h;=oo`00
67oo00<007ooOol0<Woo00<3h7ooOol097oo00<3h7ooOol0/goo000HOol2000dOol00`?POomoo`0R
Ool00`?POomoo`2dOol001Qoo`03001oogoo03Aoo`83h25oo`030n1oogoo0;Eoo`0067oo00<007oo
Ool0=Woo00<3h7ooOol07Goo00<3h7ooOol0]Woo000HOol00`00Oomoo`0gOol00`?POomoo`0JOol2
0n2iOol001Qoo`03001oogoo03Qoo`030n1oogoo01Qoo`030n1oogoo0;Uoo`0067oo00<007ooOol0
>Goo0P?P5goo00<3h7ooOol0^Woo000HOol00`00Oomoo`0kOol00`?POomoo`0COol00`?POomoo`2k
Ool001Qoo`03001oogoo03aoo`030n1oogoo015oo`030n1oogoo0;aoo`0067oo0P00?Woo00<3h7oo
Ool03Woo0P?P_goo000HOol00`00Oomoo`0nOol20n0=Ool00`?POomoo`2oOol001Qoo`03001oogoo
041oo`030n1oogoo00Uoo`030n1oogoo0<1oo`0067oo00<007ooOol0@Goo00<3h7ooOol01goo00<3
h7ooOol0`Goo000HOol00`00Oomoo`12Ool00`?POomoo`05Ool00`?POomoo`32Ool000Yoo`D0009o
o`8000Eoo`03001oogoo04=oo`83h0=oo`83h<Eoo`0037oo00D007ooOomoo`00009oo`03001oogoo
009oo`03001oogoo04Eoo`030n1oo`?P0<Moo`0037oo00D007ooOomoo`00009oo`03001oogoo009o
o`<004Ioo`030n1oogoo0<Ioo`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo
0?mooa1oo`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo0?mooa1oo`002goo
0P0017oo0P001Goo00<007ooOol0ogoo47oo000HOol00`00Oomoo`3oOol@Ool00?moob]oo`00ogoo
:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo000EOol3003o
OolCOol001Ioo`03001oogoo0?mooa9oo`005Woo0`00ogoo4Woo000FOol01000Oomoo`00ogoo4Goo
000FOol01000Oomoo`00ogoo4Goo000EOol4003oOolBOol00?moob]oo`00ogoo:goo003oOol[Ool0
0?moob]oo`00\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.563, 0}} -> {-0.102934, -0.816941, \
0.00415184, 0.0671781}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.263945 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .14669 -18 -4.5 ]
[.01131 .14669 0 4.5 ]
[.01131 .27866 -6 -4.5 ]
[.01131 .27866 0 4.5 ]
[.01131 .41063 -18 -4.5 ]
[.01131 .41063 0 4.5 ]
[.01131 .5426 -6 -4.5 ]
[.01131 .5426 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .14669 m
.03006 .14669 L
s
[(0.5)] .01131 .14669 1 0 Mshowa
.02381 .27866 m
.03006 .27866 L
s
[(1)] .01131 .27866 1 0 Mshowa
.02381 .41063 m
.03006 .41063 L
s
[(1.5)] .01131 .41063 1 0 Mshowa
.02381 .5426 m
.03006 .5426 L
s
[(2)] .01131 .5426 1 0 Mshowa
.125 Mabswid
.02381 .04111 m
.02756 .04111 L
s
.02381 .0675 m
.02756 .0675 L
s
.02381 .0939 m
.02756 .0939 L
s
.02381 .12029 m
.02756 .12029 L
s
.02381 .17308 m
.02756 .17308 L
s
.02381 .19948 m
.02756 .19948 L
s
.02381 .22587 m
.02756 .22587 L
s
.02381 .25227 m
.02756 .25227 L
s
.02381 .30505 m
.02756 .30505 L
s
.02381 .33145 m
.02756 .33145 L
s
.02381 .35784 m
.02756 .35784 L
s
.02381 .38424 m
.02756 .38424 L
s
.02381 .43703 m
.02756 .43703 L
s
.02381 .46342 m
.02756 .46342 L
s
.02381 .48982 m
.02756 .48982 L
s
.02381 .51621 m
.02756 .51621 L
s
.02381 .569 m
.02756 .569 L
s
.02381 .59539 m
.02756 .59539 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.11905 .02268 L
.21429 .07308 L
.30952 .1794 L
.40476 .31961 L
.5 .46297 L
.59524 .57008 L
.69048 .60332 L
.78571 .56143 L
.88095 .46521 L
.97619 .35115 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.563},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^1000`40O003h00Oogoo:goo0014Ool2
0004Ool20003Ool4000ROol20004Ool20005Ool3000POol20004Ool20003Ool3000ROol20004Ool2
0004Ool2000WOol5000KOol004=oo`04001oogoo0008Ool00`00Oomoo`0ROol01000Oomoo`002goo
00<007ooOol07Woo00@007ooOol000Qoo`04001oogoo000POol01000Oomoo`0027oo00@007ooOol0
02Qoo`03001oogoo01]oo`00@goo00@007ooOol000Uoo`03001oogoo025oo`04001oogoo0008Ool5
000OOol01000Oomoo`0027oo00@007ooOol0021oo`04001oogoo0008Ool01000Oomoo`00:7oo00<0
07ooOol06goo0013Ool01000Oomoo`002Woo00<007ooOol087oo00@007ooOol000Qoo`04001oogoo
000POol01000Oomoo`0027oo0`008Goo00@007ooOol000Uoo`8002Uoo`03001oogoo01]oo`00@goo
00@007ooOol000Qoo`04001oogoo000QOol01000Oomoo`002Goo00<007oo000087oo00@007ooOol0
00Uoo`03001oogoo021oo`04001oogoo0008Ool01000Oomoo`00:7oo00<007ooOol06goo0014Ool2
000:Ool2000SOol2000;Ool2000QOol2000:Ool3000QOol2000:Ool2000XOol2000MOol00?moob]o
o`006goo00<007ooOol0ogoo3Goo000KOol00`00Oomoo`3oOol=Ool001]oo`03001oogoo0?moo`eo
o`006goo00<007ooOol0oWoo0P0037oo000EOol60006O03b0008Ool01000Oomoo`002goo000KOol0
0`00Oomoo`03Ool<O006Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomo
o`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomo
o`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomo
o`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomo
o`0<Ool00`00Oomoo`0<Ool001]oo`03001oogoo00moo`Ml01Moo`03001oogoo02ioo`03001oogoo
02eoo`03001oogoo02eoo`03001oogoo02eoo`03001oogoo00]oo`D000]oo`006goo00<007ooOol0
5Woo0W`0iGoo00<007ooOol037oo000KOol00`00Oomoo`0HOol2O03bOol001]oo`03001oogoo01Yo
o`9l0?1oo`006goo00<007ooOol077oo0W`0kWoo000KOol2000OOol2O03/Ool001]oo`03001oogoo
021oo`03O01oogoo0>Uoo`006goo00<007ooOol08Goo0W`0jGoo000KOol00`00Oomoo`0SOol2O03W
Ool001]oo`03001oogoo02Eoo`9l0>Eoo`006goo00<007ooOol09goo0W`0hgoo000KOol2000ZOol2
O03QOol001]oo`03001oogoo02]oo`9l0=moo`006goo00<007ooOol0;Goo00=l07ooOol0g7oo000K
Ool00`00Oomoo`0^Ool00g`0Oomoo`3KOol001]oo`03001oogoo02moo`03O01oogoo0=Yoo`006goo
00<007ooOol0<7oo00=l07ooOol0fGoo000KOol00`00Oomoo`0aOol00g`0Oomoo`3HOol001]oo`80
03=oo`03O01oogoo0=Moo`006goo00<007ooOol0<goo00=l07ooOol0eWoo000KOol00`00Oomoo`0c
Ool00g`0Oomoo`3FOol001]oo`03001oogoo03Aoo`03O01oogoo0=Eoo`006goo00<007ooOol0=Goo
00=l07ooOol0e7oo000KOol00`00Oomoo`0fOol00g`0Oomoo`3COol001]oo`03001oogoo03Moo`03
O01oogoo0=9oo`006goo0P00>Goo00=l07ooOol0dGoo000KOol00`00Oomoo`0iOol00g`0Oomoo`3@
Ool001]oo`03001oogoo03Yoo`03O01oogoo0<moo`006goo00<007ooOol0>goo00=l07ooOol0cWoo
0008Ool20004Ool20004Ool20005Ool00`00Oomoo`0lOol00g`0Oomoo`3=Ool000Moo`04001oogoo
0008Ool01000Oomoo`0017oo00<007ooOol0?Goo00=l07ooOol0c7oo0007Ool01000Oomoo`002goo
00<007ooOol00Woo0`00?Woo00=l07ooOol0bgoo0007Ool01000Oomoo`002Goo0P001Goo00<007oo
Ool0?goo00=l07ooOol0bWoo0007Ool01000Oomoo`002Goo00<007ooOol017oo00<007ooOol0@7oo
00=l07ooOol0bGoo0008Ool2000:Ool30004Ool00`00Oomoo`10Ool00g`0Oomoo`39Ool001]oo`03
001oogoo045oo`03O01oogoo0<Qoo`006goo00<007ooOol0@Woo00=l07ooOol0agoo000KOol00`00
Oomoo`13Ool00g`0Oomoo`36Ool001]oo`8004Eoo`03O01oogoo0<Eoo`006goo00<007ooOol0AGoo
00=l07ooOol0a7oo000KOol00`00Oomoo`16Ool00g`0Oomoo`33Ool001]oo`03001oogoo04Moo`03
O01oogoo0<9oo`006goo00<007ooOol0Agoo00=l07ooOol0`Woo000KOol00`00Oomoo`18Ool00g`0
Oomoo`31Ool001]oo`03001oogoo04Uoo`03O01oogoo0<1oo`006goo0P00BWoo00=l07ooOol0`7oo
000KOol00`00Oomoo`1:Ool00g`0Oomoo`2oOol001]oo`03001oogoo04]oo`03O01oogoo0;ioo`00
6goo00<007ooOol0Bgoo00=l07ooOol0_Woo000KOol00`00Oomoo`1<Ool00g`0Oomoo`2mOol001]o
o`03001oogoo04eoo`03O01oogoo0;aoo`006goo0P00Cgoo00=l07ooOol0^goo000KOol00`00Oomo
o`1>Ool00g`0Oomoo`2kOol001]oo`03001oogoo04moo`03O01oogoo0;Yoo`006goo00<007ooOol0
D7oo00=l07ooOol0^Goo000KOol00`00Oomoo`1@Ool00g`0Oomoo`2iOol001]oo`03001oogoo055o
o`03O01oogoo0;Qoo`006goo00<007ooOol0DWoo00=l07ooOol0]goo000KOol2001COol00g`0Oomo
o`2gOol001]oo`03001oogoo05=oo`03O01oogoo0;Ioo`006goo00<007ooOol0E7oo00=l07ooOol0
]Goo000KOol00`00Oomoo`1DOol00g`0Oomoo`2eOol001]oo`03001oogoo05Eoo`03O01oogoo0;Ao
o`004goo1@000goo00<007ooOol0EWoo00=l07ooOol0/goo000EOol00`00Oomoo`03Ool00`00Oomo
o`1FOol00g`0Oomoo`2cOol001Eoo`03001oogoo00=oo`<005Moo`03O01oogoo0;9oo`005Goo00<0
07ooOol00goo00<007ooOol0F7oo00=l07ooOol0/Goo000EOol00`00Oomoo`03Ool00`00Oomoo`1I
Ool00g`0Oomoo`2`Ool001Aoo`8000Eoo`03001oogoo05Uoo`03O01oogoo0;1oo`006goo00<007oo
Ool0FWoo00=l07ooOol0[goo000KOol00`00Oomoo`1KOol00g`0Oomoo`2^Ool001]oo`03001oogoo
05]oo`03O01oogoo0:ioo`006goo0P00GGoo00=l07ooOol0[Goo000KOol00`00Oomoo`1MOol00g`0
Oomoo`2/Ool001]oo`03001oogoo05eoo`03O01oogoo0:aoo`006goo00<007ooOol0GWoo00=l07oo
Ool0Zgoo000KOol00`00Oomoo`1OOol00g`0Oomoo`2ZOol001]oo`03001oogoo05moo`03O01oogoo
0:Yoo`006goo0P00HGoo00=l07ooOol0ZGoo000KOol00`00Oomoo`1QOol00g`0Oomoo`2XOol001]o
o`03001oogoo065oo`03O01oogoo0:Qoo`006goo00<007ooOol0HWoo00=l07ooOol0Ygoo000KOol0
0`00Oomoo`1SOol00g`0Oomoo`2VOol001]oo`03001oogoo06=oo`03O01oogoo08Qoo`03O01oogoo
01]oo`006goo00<007ooOol0I7oo00=l07ooOol0QWoo00=l07ooOol077oo000KOol2001VOol00g`0
Oomoo`24Ool00g`0Oomoo`0MOol001]oo`03001oogoo06Eoo`03O01oogoo08Aoo`03O01oogoo01eo
o`006goo00<007ooOol0IWoo00=l07ooOol0PWoo00=l07ooOol07Woo000KOol00`00Oomoo`1WOol0
0g`0Oomoo`20Ool00g`0Oomoo`0OOol001]oo`03001oogoo06Moo`03O01oogoo07moo`03O01oogoo
021oo`006goo00<007ooOol0J7oo00=l07ooOol0OGoo00=l07ooOol08Goo000KOol00`00Oomoo`1Y
Ool00g`0Oomoo`1kOol00g`0Oomoo`0ROol001]oo`8006Yoo`03O01oogoo07]oo`03O01oogoo029o
o`006goo00<007ooOol0JWoo00=l07ooOol0NGoo00=l07ooOol08goo000KOol00`00Oomoo`1[Ool0
0g`0Oomoo`1gOol00g`0Oomoo`0TOol001]oo`03001oogoo06]oo`03O01oogoo07Ioo`03O01oogoo
02Eoo`001goo1@000Woo0P0017oo0P001Goo00<007ooOol0K7oo00=l07ooOol0M7oo00=l07ooOol0
9Woo0009Ool00`00Oomoo`07Ool01000Oomoo`0017oo00<007ooOol0KGoo00=l07ooOol0LWoo00=l
07ooOol09goo0009Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool3001]Ool00g`0Oomoo`1bOol00g`0
Oomoo`0WOol000Uoo`03001oogoo00Qoo`8000Eoo`03001oogoo06ioo`03O01oogoo071oo`03O01o
ogoo02Qoo`002Goo00<007ooOol027oo00<007ooOol017oo00<007ooOol0Kgoo00=l07ooOol0KWoo
00=l07ooOol0:Goo0008Ool2000:Ool30004Ool00`00Oomoo`1_Ool00g`0Oomoo`1]Ool00g`0Oomo
o`0ZOol001]oo`03001oogoo071oo`03O01oogoo06]oo`03O01oogoo02]oo`006goo00<007ooOol0
LGoo00=l07ooOol0JGoo00=l07ooOol0;7oo000KOol00`00Oomoo`1aOol00g`0Oomoo`1YOol00g`0
Oomoo`0/Ool001]oo`8007=oo`03O01oogoo06Moo`03O01oogoo02eoo`006goo00<007ooOol0Lgoo
00=l07ooOol0IGoo00=l07ooOol0;Woo000KOol00`00Oomoo`1cOol00g`0Oomoo`1TOol00g`0Oomo
o`0_Ool001]oo`03001oogoo07Aoo`03O01oogoo069oo`03O01oogoo031oo`006goo00<007ooOol0
MGoo00=l07ooOol0H7oo00=l07ooOol0<Goo000KOol00`00Oomoo`1eOol00g`0Oomoo`1POol00g`0
Oomoo`0aOol001]oo`03001oogoo07Ioo`03O01oogoo05ioo`03O01oogoo039oo`006goo0P00N7oo
00=l07ooOol0G7oo00=l07ooOol0<goo000KOol00`00Oomoo`1hOol00g`0Oomoo`1JOol00g`0Oomo
o`0dOol001]oo`03001oogoo07Uoo`03O01oogoo05Qoo`03O01oogoo03Eoo`006goo00<007ooOol0
NGoo00=l07ooOol0Egoo00=l07ooOol0=Woo000KOol00`00Oomoo`1jOol00g`0Oomoo`1EOol00g`0
Oomoo`0gOol001]oo`03001oogoo07]oo`03O01oogoo05=oo`03O01oogoo03Qoo`006goo0P00OGoo
00=l07ooOol0DGoo00=l07ooOol0>Goo000KOol00`00Oomoo`1mOol00g`0Oomoo`1?Ool00g`0Oomo
o`0jOol001]oo`03001oogoo07ioo`03O01oogoo04eoo`03O01oogoo03]oo`006goo00<007ooOol0
Ogoo00=l07ooOol0Bgoo00=l07ooOol0?7oo000KOol00`00Oomoo`1oOol00g`0Oomoo`1:Ool00g`0
Oomoo`0mOol001]oo`03001oogoo081oo`03O01oogoo04Qoo`03O01oogoo03ioo`006goo00<007oo
Ool0PGoo00=l07ooOol0AWoo00=l07ooOol0?goo000KOol20023Ool00g`0Oomoo`14Ool00g`0Oomo
o`10Ool001]oo`03001oogoo08=oo`03O01oogoo049oo`03O01oogoo045oo`006goo00<007ooOol0
Q7oo00=l07ooOol0@7oo00=l07ooOol0@Woo000KOol00`00Oomoo`25Ool00g`0Oomoo`0nOol00g`0
Oomoo`13Ool001]oo`03001oogoo08Eoo`03O01oogoo03eoo`03O01oogoo04Aoo`004goo100017oo
00<007ooOol0QWoo00=l07ooOol0>goo00=l07ooOol0AGoo000COol00`00Oomoo`05Ool00`00Oomo
o`27Ool00g`0Oomoo`0iOol00g`0Oomoo`16Ool001Aoo`03001oogoo00Aoo`<008Qoo`03O01oogoo
03Moo`03O01oogoo04Moo`005Goo00<007ooOol00goo00<007ooOol0RGoo00=l07ooOol0=Goo00=l
07ooOol0B7oo000COol01000Oomoo`0017oo00<007ooOol0RWoo00=l07ooOol0<goo00=l07ooOol0
BGoo000DOol20005Ool00`00Oomoo`2;Ool00g`0Oomoo`0aOol00g`0Oomoo`1:Ool001]oo`03001o
ogoo08]oo`03O01oogoo02moo`9l04eoo`006goo00<007ooOol0S7oo00=l07ooOol0;7oo0W`0Cgoo
000KOol2002>Ool00g`0Oomoo`0YOol2O01AOol001]oo`03001oogoo08ioo`9l02Moo`9l05=oo`00
6goo00<007ooOol0T7oo0g`08Woo0W`0EGoo000KOol00`00Oomoo`2COol3O00MOol2O01GOol001]o
o`03001oogoo09Ioo`=l01Moo`=l05Uoo`006goo00<007ooOol0VGoo0g`04Woo0W`0G7oo000KOol0
0`00Oomoo`2LOol3O00=Ool2O01NOol001]oo`800:1oo`=l00Qoo`9l061oo`006goo00<007ooOol0
XWoo0g`00goo0W`0HWoo000KOol00`00Oomoo`2UOol3O01TOol001]oo`03001oogoo0?moo`eoo`00
6goo00<007ooOol0ogoo3Goo000KOol00`00Oomoo`3oOol=Ool001]oo`03001oogoo0?moo`eoo`00
ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[
Ool00?moob]oo`00ogoo:goo000JOol4003oOol=Ool001Uoo`04001oogoo003oOol>Ool001Uoo`04
001oogoo003oOol>Ool001Qoo`800003Ool000000?moo`ioo`00ogoo:goo003oOol[Ool00?moob]o
o`00ogoo:goo0000\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.563, 0}} -> {-0.11539, -0.18218, \
0.00415184, 0.0149809}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.268751 0.0596002 [
[.21429 .25625 -9 -9 ]
[.21429 .25625 9 0 ]
[.40476 .25625 -9 -9 ]
[.40476 .25625 9 0 ]
[.59524 .25625 -9 -9 ]
[.59524 .25625 9 0 ]
[.78571 .25625 -9 -9 ]
[.78571 .25625 9 0 ]
[.97619 .25625 -3 -9 ]
[.97619 .25625 3 0 ]
[1.025 .26875 0 -6.25 ]
[1.025 .26875 10 6.25 ]
[.01131 .03035 -12 -4.5 ]
[.01131 .03035 0 4.5 ]
[.01131 .14955 -12 -4.5 ]
[.01131 .14955 0 4.5 ]
[.01131 .38795 -6 -4.5 ]
[.01131 .38795 0 4.5 ]
[.01131 .50715 -6 -4.5 ]
[.01131 .50715 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .26875 m
.21429 .275 L
s
[(0.2)] .21429 .25625 0 1 Mshowa
.40476 .26875 m
.40476 .275 L
s
[(0.4)] .40476 .25625 0 1 Mshowa
.59524 .26875 m
.59524 .275 L
s
[(0.6)] .59524 .25625 0 1 Mshowa
.78571 .26875 m
.78571 .275 L
s
[(0.8)] .78571 .25625 0 1 Mshowa
.97619 .26875 m
.97619 .275 L
s
[(1)] .97619 .25625 0 1 Mshowa
.125 Mabswid
.07143 .26875 m
.07143 .2725 L
s
.11905 .26875 m
.11905 .2725 L
s
.16667 .26875 m
.16667 .2725 L
s
.2619 .26875 m
.2619 .2725 L
s
.30952 .26875 m
.30952 .2725 L
s
.35714 .26875 m
.35714 .2725 L
s
.45238 .26875 m
.45238 .2725 L
s
.5 .26875 m
.5 .2725 L
s
.54762 .26875 m
.54762 .2725 L
s
.64286 .26875 m
.64286 .2725 L
s
.69048 .26875 m
.69048 .2725 L
s
.7381 .26875 m
.7381 .2725 L
s
.83333 .26875 m
.83333 .2725 L
s
.88095 .26875 m
.88095 .2725 L
s
.92857 .26875 m
.92857 .2725 L
s
.25 Mabswid
0 .26875 m
1 .26875 L
s
gsave
1.025 .26875 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .03035 m
.03006 .03035 L
s
[(-4)] .01131 .03035 1 0 Mshowa
.02381 .14955 m
.03006 .14955 L
s
[(-2)] .01131 .14955 1 0 Mshowa
.02381 .38795 m
.03006 .38795 L
s
[(2)] .01131 .38795 1 0 Mshowa
.02381 .50715 m
.03006 .50715 L
s
[(4)] .01131 .50715 1 0 Mshowa
.125 Mabswid
.02381 .06015 m
.02756 .06015 L
s
.02381 .08995 m
.02756 .08995 L
s
.02381 .11975 m
.02756 .11975 L
s
.02381 .17935 m
.02756 .17935 L
s
.02381 .20915 m
.02756 .20915 L
s
.02381 .23895 m
.02756 .23895 L
s
.02381 .29855 m
.02756 .29855 L
s
.02381 .32835 m
.02756 .32835 L
s
.02381 .35815 m
.02756 .35815 L
s
.02381 .41775 m
.02756 .41775 L
s
.02381 .44755 m
.02756 .44755 L
s
.02381 .47735 m
.02756 .47735 L
s
.02381 .00055 m
.02756 .00055 L
s
.02381 .53695 m
.02756 .53695 L
s
.02381 .56675 m
.02756 .56675 L
s
.02381 .59655 m
.02756 .59655 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 1 r
.5 Mabswid
.02381 .26875 m
.11905 .32269 L
.21429 .44873 L
.30952 .55881 L
.40476 .60332 L
.5 .56765 L
.59524 .43537 L
.69048 .25412 L
.78571 .10202 L
.88095 .01472 L
.97619 .02283 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.563},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^1000`40O003h00O4Woo0P00ogoo5goo
000BOol00`00Oomoo`3oOolFOol0019oo`03001oogoo0?mooaIoo`004Woo00<007ooOol0ogoo5Woo
000BOol00`00Oomoo`3QOol7O1l]Ool0019oo`03001oogoo0>1oo`03O1moogoo00Eoo`al7b5oo`00
2goo0`0017oo00<007ooOol0ggoo00=l7gooOol04Woo1g`O6Woo000<Ool00`00Oomoo`03Ool00`00
Oomoo`3NOol00g`OOomoo`0dOol000Uoo`D000Aoo`800=eoo`9l7cMoo`000goo10000Woo00@007oo
Ool000Eoo`03001oogoo0=]oo`03O1moogoo03Moo`002Woo00<007oo00001Goo00<007ooOol0fWoo
00=l7gooOol0>7oo000;Ool20005Ool00`00Oomoo`3IOol00g`OOomoo`0iOol0019oo`03001oogoo
0=Qoo`03O1moogoo03Yoo`004Woo00<007ooOol0egoo00=l7gooOol0>goo000BOol00`00Oomoo`3F
Ool00g`OOomoo`0lOol0019oo`03001oogoo0=Eoo`03O1moogoo03eoo`004Woo0P00e7oo0W`O@7oo
000BOol00`00Oomoo`3BOol00g`OOomoo`10Ool0019oo`03001oogoo0=5oo`03O1moogoo045oo`00
4Woo00<007ooOol0d7oo00=l7gooOol0@Woo000BOol00`00Oomoo`3?Ool00g`OOomoo`13Ool0019o
o`03001oogoo0<ioo`03O1moogoo04Aoo`004Woo00<007ooOol0cGoo00=l7gooOol0AGoo000BOol0
0`00Oomoo`3;Ool2O1m8Ool0019oo`800<]oo`03O1moogoo04Qoo`004Woo00<007ooOol0bGoo00=l
7gooOol0BGoo000BOol00`00Oomoo`38Ool00g`OOomoo`1:Ool0019oo`03001oogoo0<Moo`03O1mo
ogoo04]oo`004Woo00<007ooOol0aWoo00=l7gooOol0C7oo000BOol00`00Oomoo`36Ool00g`OOomo
o`1<Ool0019oo`03001oogoo0<Eoo`03O1moogoo04eoo`004Woo00<007ooOol0aGoo00=l7gooOol0
CGoo000BOol20035Ool00g`OOomoo`1>Ool0019oo`03001oogoo0<=oo`03O1moogoo04moo`004Woo
00<007ooOol0`goo00=l7gooOol0Cgoo000BOol00`00Oomoo`32Ool00g`OOomoo`1@Ool0019oo`03
001oogoo0<9oo`03O1moogoo051oo`004Woo00<007ooOol0`Goo00=l7gooOol0DGoo0009Ool40005
Ool00`00Oomoo`30Ool00g`OOomoo`1BOol000Uoo`03001oogoo00Ioo`03001oogoo0<1oo`03O1mo
ogoo059oo`002Woo00<007ooOol01Goo0P00`7oo00=l7gooOol0Dgoo0003Ool40004Ool00`00Oomo
o`04Ool00`00Oomoo`2nOol00g`OOomoo`1DOol000Uoo`04001oogoo0005Ool00`00Oomoo`2nOol0
0g`OOomoo`1DOol000Yoo`8000Ioo`03001oogoo0;eoo`03O1moogoo05Eoo`004Woo00<007ooOol0
_Goo00=l7gooOol0EGoo000BOol00`00Oomoo`2lOol00g`OOomoo`1FOol0019oo`03001oogoo0;]o
o`03O1moogoo05Moo`004Woo00<007ooOol0^goo00=l7gooOol0Egoo000BOol2002kOol00g`OOomo
o`1HOol0019oo`03001oogoo0;Yoo`03O1moogoo05Qoo`004Woo00<007ooOol0^Goo00=l7gooOol0
FGoo000BOol00`00Oomoo`2hOol00g`OOomoo`1JOol0019oo`03001oogoo0;Qoo`03O1moogoo05Yo
o`004Woo00<007ooOol0]goo00=l7gooOol0Fgoo000BOol00`00Oomoo`2gOol00g`OOomoo`1KOol0
019oo`03001oogoo0;Ioo`03O1moogoo05aoo`004Woo0P00]Woo00=l7gooOol0GGoo000BOol00`00
Oomoo`2eOol00g`OOomoo`1MOol0019oo`03001oogoo0;Aoo`03O1moogoo05ioo`004Woo00<007oo
Ool0/goo00=l7gooOol0Ggoo000BOol00`00Oomoo`0XOol20004Ool20003Ool4000TOol20004Ool2
0005Ool3000SOol20004Ool20003Ool3000GOol00g`OOomoo`0:Ool20004Ool20004Ool2000ZOol5
000HOol0019oo`03001oogoo02Moo`04001oogoo0008Ool00`00Oomoo`0TOol01000Oomoo`002goo
00<007ooOol08Goo00@007ooOol000Qoo`04001oogoo000EOol00g`OOomoo`0:Ool01000Oomoo`00
27oo00@007ooOol002]oo`03001oogoo01Qoo`004Woo00<007ooOol09goo00@007ooOol000Uoo`03
001oogoo02=oo`04001oogoo0008Ool5000ROol01000Oomoo`0027oo00@007ooOol001Eoo`03O1mo
ogoo00Yoo`04001oogoo0008Ool01000Oomoo`00:goo00<007ooOol067oo000BOol00`00Oomoo`0W
Ool01000Oomoo`002Woo00<007ooOol08Woo00@007ooOol000Qoo`04001oogoo000SOol01000Oomo
o`0027oo0`005Goo00=l7gooOol02goo00@007ooOol000Uoo`8002aoo`03001oogoo01Qoo`004Woo
0P00:7oo00@007ooOol000Qoo`04001oogoo000SOol01000Oomoo`002Goo00<007oo00008goo00@0
07ooOol000Uoo`03001oogoo01=oo`03O1moogoo00aoo`04001oogoo0008Ool01000Oomoo`00:goo
00<007ooOol067oo000BOol00`00Oomoo`0XOol2000:Ool2000UOol2000;Ool2000TOol2000:Ool3
000COol00g`OOomoo`0=Ool2000:Ool2000[Ool2000JOol0019oo`03001oogoo0:moo`03O1moogoo
06=oo`004Woo00<007ooOol0[goo00=l7gooOol0Hgoo000BOol00`00Oomoo`2^Ool00g`OOomoo`1T
Ool0019oo`03001oogoo0:eoo`03O1moogoo06Eoo`004Woo00<007ooOol0[Goo00=l7gooOol0Fgoo
0P0027oo000;Ool700000g`O0000002/00000g`O0000001B0009Ool01000Oomoo`001goo000BOol0
0`00O1ml7`09Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool0
0`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool0
0`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00g`OOol0000<Ool0
0`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool0
0`00Oomoo`0=Ool00`00Oomoo`08Ool0019oo`03001oogoo009l7beoo`03001oogoo031oo`03001o
ogoo031oo`03001oogoo01=oo`03O1moogoo01Uoo`03001oogoo031oo`03001oogoo00aoo`D000Mo
o`004Woo00<007ooOol00Woo00=l7gooOol0YWoo00=l7gooOol0G7oo00<007ooOol027oo000BOol0
0`00Oomoo`03Ool2O1nUOol00g`OOomoo`1XOol0019oo`03001oogoo00Eoo`9l7j=oo`03O1moogoo
06Qoo`004Woo00<007ooOol01goo00=l7gooOol0Wgoo00=l7gooOol0JGoo000BOol00`00Oomoo`08
Ool2O1nOOol00g`OOomoo`1YOol0019oo`8000]oo`9l7iaoo`03O1moogoo06Yoo`004Woo00<007oo
Ool037oo00=l7gooOol0VGoo00=l7gooOol0JWoo000BOol00`00Oomoo`0=Ool2O1nHOol00g`OOomo
o`1[Ool0019oo`03001oogoo00moo`9l7iIoo`03O1moogoo06]oo`004Woo00<007ooOol04Goo00=l
7gooOol0TWoo00=l7gooOol0K7oo000BOol00`00Oomoo`0BOol2O1nBOol00g`OOomoo`1/Ool0019o
o`03001oogoo01Aoo`9l7hmoo`03O1moogoo06eoo`004Woo00<007ooOol05Woo00=l7gooOol0S7oo
00=l7gooOol0KGoo000BOol2000HOol00g`OOomoo`2:Ool00g`OOomoo`1^Ool0019oo`03001oogoo
01Qoo`03O1moogoo08Uoo`03O1moogoo06ioo`004Woo00<007ooOol067oo00=l7gooOol0R7oo00=l
7gooOol0Kgoo000BOol00`00Oomoo`0IOol00g`OOomoo`27Ool00g`OOomoo`1_Ool0019oo`03001o
ogoo01Yoo`03O1moogoo08Eoo`03O1moogoo071oo`004Woo00<007ooOol06goo00=l7gooOol0Pgoo
00=l7gooOol0LGoo000BOol00`00Oomoo`0KOol00g`OOomoo`23Ool00g`OOomoo`1aOol0019oo`03
001oogoo01aoo`03O1moogoo085oo`03O1moogoo079oo`004Woo0P007Woo00=l7gooOol0P7oo00=l
7gooOol0LWoo000BOol00`00Oomoo`0NOol00g`OOomoo`1nOol00g`OOomoo`1cOol0019oo`03001o
ogoo01ioo`03O1moogoo07ioo`03O1moogoo07=oo`004Woo00<007ooOol07goo00=l7gooOol0O7oo
00=l7gooOol0M7oo000BOol00`00Oomoo`0POol00g`OOomoo`1kOol00g`OOomoo`1dOol0019oo`03
001oogoo025oo`03O1moogoo07Uoo`03O1moogoo07Eoo`002Goo10001Goo00<007ooOol08Goo00=l
7gooOol0NGoo00=l7gooOol0MGoo0009Ool00`00Oomoo`06Ool00`00Oomoo`0ROol00g`OOomoo`1g
Ool00g`OOomoo`1fOol000Yoo`03001oogoo00Eoo`8002Aoo`03O1moogoo07Ioo`03O1moogoo07Io
o`002goo00<007ooOol017oo00<007ooOol097oo00=l7gooOol0M7oo00=l7gooOol0Mgoo0009Ool0
1000Oomoo`001Goo00<007ooOol097oo00=l7gooOol0M7oo00=l7gooOol0Mgoo000:Ool20006Ool0
0`00Oomoo`0UOol00g`OOomoo`1bOol00g`OOomoo`1hOol0019oo`03001oogoo02Ioo`03O1moogoo
075oo`03O1moogoo07Qoo`004Woo00<007ooOol09goo00=l7gooOol0Kgoo00=l7gooOol0NGoo000B
Ool00`00Oomoo`0WOol00g`OOomoo`1_Ool00g`OOomoo`1iOol0019oo`03001oogoo02Qoo`03O1mo
ogoo06eoo`03O1moogoo07Yoo`004Woo0P00:Woo00=l7gooOol0K7oo00=l7gooOol0NWoo000BOol0
0`00Oomoo`0ZOol00g`OOomoo`1ZOol00g`OOomoo`1kOol0019oo`03001oogoo02Yoo`03O1moogoo
06Yoo`03O1moogoo07]oo`004Woo00<007ooOol0:goo00=l7gooOol0J7oo00=l7gooOol0O7oo000B
Ool00`00Oomoo`0/Ool00g`OOomoo`1WOol00g`OOomoo`1lOol0019oo`03001oogoo02eoo`03O1mo
ogoo06Eoo`03O1moogoo07eoo`004Woo00<007ooOol0;Goo00=l7gooOol0I7oo00=l7gooOol0OWoo
000BOol00`00Oomoo`0^Ool00g`OOomoo`1SOol00g`OOomoo`1nOol0019oo`80031oo`03O1moogoo
065oo`03O1moogoo07moo`004Woo00<007ooOol0<7oo00=l7gooOol0Ggoo00=l7gooOol0P7oo000B
Ool00`00Oomoo`0aOol00g`OOomoo`1MOol00g`OOomoo`21Ool0019oo`03001oogoo039oo`03O1mo
ogoo05aoo`03O1moogoo085oo`004Woo00<007ooOol0<Woo00=l7gooOol0Fgoo00=l7gooOol0PWoo
000BOol00`00Oomoo`0cOol00g`OOomoo`1IOol00g`OOomoo`23Ool0019oo`03001oogoo03Aoo`03
O1moogoo05Moo`03O1moogoo08Aoo`004Woo00<007ooOol0=Goo00=l7gooOol0EWoo00=l7gooOol0
Q7oo000BOol2000gOol00g`OOomoo`1DOol00g`OOomoo`25Ool0019oo`03001oogoo03Moo`03O1mo
ogoo059oo`03O1moogoo08Ioo`004Woo00<007ooOol0>7oo00=l7gooOol0D7oo00=l7gooOol0Qgoo
000BOol00`00Oomoo`0iOol00g`OOomoo`1?Ool00g`OOomoo`27Ool0019oo`03001oogoo03Uoo`03
O1moogoo04ioo`03O1moogoo08Qoo`004Woo00<007ooOol0>Woo00=l7gooOol0C7oo00=l7gooOol0
RGoo000;Ool30004Ool00`00Oomoo`0kOol00g`OOomoo`1:Ool00g`OOomoo`2:Ool000aoo`03001o
ogoo00=oo`03001oogoo03aoo`03O1moogoo04Uoo`03O1moogoo08Yoo`002Goo1@0017oo0P00?Woo
00=l7gooOol0Agoo00=l7gooOol0Rgoo0009Ool01000Oomoo`001Goo00<007ooOol0?Woo00=l7goo
Ool0AGoo00=l7gooOol0S7oo000:Ool00`00Ool00005Ool00`00Oomoo`0oOol00g`OOomoo`13Ool0
0g`OOomoo`2=Ool000]oo`8000Eoo`03001oogoo03moo`03O1moogoo04=oo`03O1moogoo08eoo`00
4Woo00<007ooOol0@7oo00=l7gooOol0@Goo00=l7gooOol0SWoo000BOol00`00Oomoo`11Ool00g`O
Oomoo`0oOol00g`OOomoo`2?Ool0019oo`03001oogoo049oo`03O1moogoo03eoo`03O1moogoo091o
o`004Woo00<007ooOol0@goo00=l7gooOol0?7oo00=l7gooOol0T7oo000BOol20015Ool00g`OOomo
o`0jOol00g`OOomoo`2AOol0019oo`03001oogoo04Eoo`03O1moogoo03Qoo`03O1moogoo099oo`00
4Woo00<007ooOol0AWoo00=l7gooOol0=Woo00=l7gooOol0Tgoo000BOol00`00Oomoo`16Ool00g`O
Oomoo`0fOol00g`OOomoo`2COol0019oo`03001oogoo04Moo`03O1moogoo03Aoo`03O1moogoo09Ao
o`004Woo00<007ooOol0B7oo00=l7gooOol0<Woo00=l7gooOol0UGoo000BOol00`00Oomoo`19Ool2
O1laOol00g`OOomoo`2FOol0019oo`03001oogoo04]oo`9l7bmoo`03O1moogoo09Ioo`004Woo0P00
CWoo0W`O:goo0W`OVGoo000BOol00`00Oomoo`1?Ool2O1lVOol3O1nKOol0019oo`03001oogoo055o
o`=l7b5oo`9l7iioo`004Woo00<007ooOol0E7oo0W`O77oo0g`OX7oo000BOol00`00Oomoo`1FOol2
O1lGOol3O1nSOol0019oo`03001oogoo05Qoo`=l7a5oo`=l7jIoo`004Woo00<007ooOol0Fgoo0W`O
37oo0g`OZGoo000BOol00`00Oomoo`1MOol2O1l8Ool2O1n/Ool0019oo`80061oo`9l7`=oo`=l7jio
o`004Woo00<007ooOol0HGoo0g`O/Goo000BOol00`00Oomoo`3oOolFOol0019oo`03001oogoo0?mo
oaIoo`004Woo00<007ooOol0ogoo5Woo000BOol00`00Oomoo`3oOolFOol00?moob]oo`00ogoo:goo
003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00?mo
ob]oo`00ogoo:goo000AOol2003oOolHOol0015oo`800?mooaQoo`0047oo00@007ooOol00?mooaMo
o`003goo0P000Woo0P00ogoo5Woo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00001\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.563, 0}} -> {-0.0722512, -4.50928, \
0.00394703, 0.0630715}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.350835 0.010716 [
[.21429 .33834 -9 -9 ]
[.21429 .33834 9 0 ]
[.40476 .33834 -9 -9 ]
[.40476 .33834 9 0 ]
[.59524 .33834 -9 -9 ]
[.59524 .33834 9 0 ]
[.78571 .33834 -9 -9 ]
[.78571 .33834 9 0 ]
[.97619 .33834 -3 -9 ]
[.97619 .33834 3 0 ]
[1.025 .35084 0 -6.25 ]
[1.025 .35084 10 6.25 ]
[.01131 .02936 -18 -4.5 ]
[.01131 .02936 0 4.5 ]
[.01131 .13652 -18 -4.5 ]
[.01131 .13652 0 4.5 ]
[.01131 .24368 -18 -4.5 ]
[.01131 .24368 0 4.5 ]
[.01131 .458 -12 -4.5 ]
[.01131 .458 0 4.5 ]
[.01131 .56516 -12 -4.5 ]
[.01131 .56516 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .35084 m
.21429 .35709 L
s
[(0.2)] .21429 .33834 0 1 Mshowa
.40476 .35084 m
.40476 .35709 L
s
[(0.4)] .40476 .33834 0 1 Mshowa
.59524 .35084 m
.59524 .35709 L
s
[(0.6)] .59524 .33834 0 1 Mshowa
.78571 .35084 m
.78571 .35709 L
s
[(0.8)] .78571 .33834 0 1 Mshowa
.97619 .35084 m
.97619 .35709 L
s
[(1)] .97619 .33834 0 1 Mshowa
.125 Mabswid
.07143 .35084 m
.07143 .35459 L
s
.11905 .35084 m
.11905 .35459 L
s
.16667 .35084 m
.16667 .35459 L
s
.2619 .35084 m
.2619 .35459 L
s
.30952 .35084 m
.30952 .35459 L
s
.35714 .35084 m
.35714 .35459 L
s
.45238 .35084 m
.45238 .35459 L
s
.5 .35084 m
.5 .35459 L
s
.54762 .35084 m
.54762 .35459 L
s
.64286 .35084 m
.64286 .35459 L
s
.69048 .35084 m
.69048 .35459 L
s
.7381 .35084 m
.7381 .35459 L
s
.83333 .35084 m
.83333 .35459 L
s
.88095 .35084 m
.88095 .35459 L
s
.92857 .35084 m
.92857 .35459 L
s
.25 Mabswid
0 .35084 m
1 .35084 L
s
gsave
1.025 .35084 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .02936 m
.03006 .02936 L
s
[(-30)] .01131 .02936 1 0 Mshowa
.02381 .13652 m
.03006 .13652 L
s
[(-20)] .01131 .13652 1 0 Mshowa
.02381 .24368 m
.03006 .24368 L
s
[(-10)] .01131 .24368 1 0 Mshowa
.02381 .458 m
.03006 .458 L
s
[(10)] .01131 .458 1 0 Mshowa
.02381 .56516 m
.03006 .56516 L
s
[(20)] .01131 .56516 1 0 Mshowa
.125 Mabswid
.02381 .05079 m
.02756 .05079 L
s
.02381 .07222 m
.02756 .07222 L
s
.02381 .09365 m
.02756 .09365 L
s
.02381 .11508 m
.02756 .11508 L
s
.02381 .15795 m
.02756 .15795 L
s
.02381 .17938 m
.02756 .17938 L
s
.02381 .20081 m
.02756 .20081 L
s
.02381 .22224 m
.02756 .22224 L
s
.02381 .26511 m
.02756 .26511 L
s
.02381 .28654 m
.02756 .28654 L
s
.02381 .30797 m
.02756 .30797 L
s
.02381 .3294 m
.02756 .3294 L
s
.02381 .37227 m
.02756 .37227 L
s
.02381 .3937 m
.02756 .3937 L
s
.02381 .41513 m
.02756 .41513 L
s
.02381 .43656 m
.02756 .43656 L
s
.02381 .47943 m
.02756 .47943 L
s
.02381 .50086 m
.02756 .50086 L
s
.02381 .52229 m
.02756 .52229 L
s
.02381 .54372 m
.02756 .54372 L
s
.02381 .00792 m
.02756 .00792 L
s
.02381 .58659 m
.02756 .58659 L
s
.02381 .60802 m
.02756 .60802 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .35084 m
.11905 .54351 L
.21429 .60332 L
.30952 .47716 L
.40476 .3621 L
.5 .2113 L
.59524 .01472 L
.69048 .0352 L
.78571 .11952 L
.88095 .28362 L
.97619 .46552 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  PageWidth->Infinity,
  ImageSize->{298.625, 184.563},
  ImageMargins->{{100, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Z0000^1000`40O003h00O5Goo00<007ooOol0
ogoo4goo000EOol00`00Oomoo`3oOolCOol001Eoo`800?mooaAoo`005Goo00<007ooOol0ogoo4goo
000EOol00`00Oomoo`2EOol301mjOol001Eoo`03001oogoo09Aoo`0401moogooOol501meOol000Qo
o`8000Aoo`8000Eoo`03001oogoo09Aoo`0301moogoo00Ioo`D07g1oo`001goo00@007ooOol0009o
o`04001oogoo0004Ool00`00Oomoo`2COol00`0OOomoo`0<Ool501m[Ool000Uoo`05001oogooOol0
0002Ool00`00Oomoo`02Ool2002DOol00`0OOomoo`0AOol501mVOol00003Ool00000008000Eoo`04
001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`2BOol00`0OOomoo`0GOol301mSOol000Moo`04
001oogoo0002Ool01000Oomoo`0017oo00<007ooOol0TWoo00<07gooOol06Woo00<07gooOol0H7oo
0008Ool20004Ool20005Ool00`00Oomoo`2AOol00`0OOomoo`0LOol00`0OOomoo`1OOol001Eoo`03
001oogoo095oo`0301moogoo01eoo`0301moogoo05ioo`005Goo0P00TGoo00<07gooOol07goo00<0
7gooOol0GGoo000EOol00`00Oomoo`2@Ool00`0OOomoo`0POol00`0OOomoo`1LOol001Eoo`03001o
ogoo08moo`0301moogoo029oo`807eaoo`005Goo00<007ooOol0Sgoo00<07gooOol097oo00<07goo
Ool0FGoo000EOol00`00Oomoo`2>Ool00`0OOomoo`0VOol00`0OOomoo`1HOol001Eoo`03001oogoo
08ioo`0301moogoo02Moo`0301moogoo05Moo`005Goo0P00SWoo00<07gooOol0:Goo00<07gooOol0
EWoo000EOol00`00Oomoo`2=Ool00`0OOomoo`0ZOol00`0OOomoo`1EOol001Eoo`03001oogoo08ao
o`0301moogoo02aoo`0301moogoo05Aoo`005Goo00<007ooOol0S7oo00<07gooOol0;Goo00<07goo
Ool0Dgoo000EOol00`00Oomoo`2;Ool00`0OOomoo`0_Ool00`0OOomoo`1BOol001Eoo`03001oogoo
08]oo`0301moogoo031oo`0301moogoo055oo`005Goo0P00Rgoo00<07gooOol0<Woo00<07gooOol0
D7oo000EOol00`00Oomoo`2:Ool00`0OOomoo`0cOol201m@Ool001Eoo`03001oogoo08Uoo`0301mo
ogoo03Ioo`0301moogoo04eoo`005Goo00<007ooOol0RGoo00<07gooOol0=goo00<07gooOol0C7oo
000EOol00`00Oomoo`28Ool00`0OOomoo`0iOol00`0OOomoo`1;Ool001Eoo`03001oogoo08Qoo`03
01moogoo03Yoo`0301moogoo04Yoo`005Goo0P00R7oo00<07gooOol0?7oo00<07gooOol0BGoo000E
Ool00`00Oomoo`27Ool00`0OOomoo`0mOol00`0OOomoo`18Ool001Eoo`03001oogoo08Ioo`0301mo
ogoo03moo`0301moogoo04Moo`001goo10000goo0P001Goo00<007ooOol0QWoo00<07gooOol0?goo
00<07gooOol0Agoo0007Ool00`00Oomoo`03Ool01000Oomoo`0017oo00<007ooOol0QGoo00<07goo
Ool0@Goo00<07gooOol0AWoo0008Ool00`00Oomoo`02Ool01000Oomoo`0017oo0P00QWoo00<07goo
Ool0@Goo00<07gooOol0AWoo00000goo000000020004Ool01@00Oomoogoo00000Woo00<007ooOol0
0Woo00<007ooOol0Q7oo00<07gooOol0@goo00<07gooOol0AGoo0007Ool01000Oomoo`000Woo00@0
07ooOol000Aoo`03001oogoo08Aoo`0301moogoo04Aoo`0301moogoo04Aoo`0027oo0P0017oo0P00
1Goo00<007ooOol0Pgoo00<07gooOol0AGoo00<07gooOol0A7oo000EOol00`00Oomoo`23Ool00`0O
Oomoo`16Ool00`0OOomoo`13Ool001Eoo`03001oogoo089oo`0301moogoo04Moo`0301moogoo04=o
o`005Goo0P00Pgoo00<07gooOol0B7oo00<07gooOol0@Woo000EOol00`00Oomoo`21Ool00`0OOomo
o`1:Ool00`0OOomoo`11Ool001Eoo`03001oogoo085oo`0301moogoo04Yoo`0301moogoo045oo`00
5Goo00<007ooOol0P7oo00<07gooOol0C7oo00<07gooOol0@7oo000EOol00`00Oomoo`20Ool00`0O
Oomoo`1<Ool00`0OOomoo`10Ool001Eoo`03001oogoo07moo`0301moogoo04ioo`0301moogoo03mo
o`005Goo0P00P7oo00<07gooOol0Cgoo00<07gooOol0?Woo000EOol00`00Oomoo`1nOol00`0OOomo
o`1@Ool00`0OOomoo`0nOol001Eoo`03001oogoo07ioo`0301moogoo055oo`0301moogoo03eoo`00
5Goo00<007ooOol0OGoo00<07gooOol0DWoo00<07gooOol0?Goo000EOol00`00Oomoo`1mOol00`0O
Oomoo`1COol00`0OOomoo`0lOol001Eoo`8007eoo`0301moogoo05Eoo`0301moogoo03]oo`005Goo
00<007ooOol0O7oo00<07gooOol0EGoo00<07gooOol0>goo000EOol00`00Oomoo`1kOol00`0OOomo
o`1GOol00`0OOomoo`0jOol001Eoo`03001oogoo07]oo`0301moogoo05Qoo`0301moogoo03Uoo`00
5Goo00<007ooOol0NWoo00<07gooOol0FGoo00<07gooOol0>Goo000EOol00`00Oomoo`1jOol00`0O
Oomoo`1JOol00`0OOomoo`0hOol001Eoo`8007Yoo`0301moogoo05]oo`0301moogoo03Qoo`005Goo
00<007ooOol0N7oo00<07gooOol0GGoo00<07gooOol0=goo000EOol00`00Oomoo`1hOol00`0OOomo
o`1NOol00`0OOomoo`0fOol001Eoo`03001oogoo07Moo`0301moogoo05moo`0301moogoo03Ioo`00
1goo1@000Woo0P001Goo00<007ooOol0Mgoo00<07gooOol0H7oo00<07gooOol0=Goo0009Ool01@00
Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol0MWoo00<07gooOol0HGoo00<07gooOol0=Goo
0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo0P00MWoo00<07gooOol0Hgoo00<07gooOol0
=7oo00000goo000000020004Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol0MGoo
00<07gooOol0I7oo00<07gooOol0<goo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<0
07ooOol0M7oo00<07gooOol0IGoo00<07gooOol0<goo0008Ool20004Ool20005Ool00`00Oomoo`1c
Ool00`0OOomoo`1WOol00`0OOomoo`0bOol001Eoo`03001oogoo07=oo`0301moogoo06Moo`0301mo
ogoo039oo`005Goo0P00Lgoo00<07gooOol0JGoo00<07gooOol0<Goo000EOol00`00Oomoo`1bOol0
0`0OOomoo`1ZOol00`0OOomoo`0`Ool001Eoo`03001oogoo075oo`0301moogoo06]oo`0301moogoo
031oo`005Goo00<007ooOol0L7oo00<07gooOol0KGoo00<07gooOol0;goo000EOol00`00Oomoo`1`
Ool00`0OOomoo`1]Ool00`0OOomoo`0_Ool001Eoo`03001oogoo06moo`0301moogoo06moo`0301mo
ogoo02ioo`005Goo0P00Kgoo00<07gooOol0LGoo00<07gooOol0;Goo000EOol00`00Oomoo`1^Ool0
0`0OOomoo`1aOol00`0OOomoo`0]Ool001Eoo`03001oogoo06eoo`0301moogoo07=oo`0301moogoo
02aoo`005Goo00<007ooOol0KGoo00<07gooOol0Lgoo00<07gooOol0;7oo000EOol00`00Oomoo`1/
Ool00`0OOomoo`1eOol00`0OOomoo`0[Ool001Eoo`03001oogoo06]oo`0301moogoo07Ioo`0301mo
ogoo02]oo`005Goo0P00:Goo0P0017oo0P000goo100097oo0P0017oo0P001Goo0`0000<07gooOol0
87oo0P0017oo0P000goo0`0097oo0P0017oo0P0017oo0P005goo00<07gooOol047oo1@005Goo000E
Ool00`00Oomoo`0WOol01000Oomoo`0027oo00<007ooOol097oo00@007ooOol000]oo`0300007goo
025oo`04001oogoo0008Ool01000Oomoo`008Woo00@007ooOol000Qoo`04001oogoo000FOol00`0O
Oomoo`0BOol00`00Oomoo`0EOol001Eoo`03001oogoo02Moo`04001oogoo0009Ool00`00Oomoo`0S
Ool01000Oomoo`0027oo0`0000<07`00Ool08Goo00@007ooOol000Qoo`04001oogoo000ROol01000
Oomoo`0027oo00@007ooOol001Moo`0301moogoo015oo`03001oogoo01Eoo`005Goo00<007ooOol0
9goo00@007ooOol000Yoo`03001oogoo029oo`04001oogoo0008Ool01000Oomoo`0O8goo00@007oo
Ool000Qoo`<002=oo`04001oogoo0009Ool2000HOol00`0OOomoo`0AOol00`00Oomoo`0EOol001Eo
o`03001oogoo02Moo`04001oogoo0008Ool01000Oomoo`008goo00@007ooOol000Uoo`0300007`00
02=oo`04001oogoo0009Ool00`00Oomoo`0ROol01000Oomoo`0027oo00@007ooOol001Qoo`0301mo
ogoo011oo`03001oogoo01Eoo`005Goo00<007ooOol0:7oo0P002Woo0P009Goo0P002goo00<07`00
Ool08goo0P002Woo0`008goo0P002Woo0P006Goo00<07gooOol03goo0P005goo000EOol2001XOol0
0`0OOomoo`1nOol00`0OOomoo`0WOol001Eoo`03001oogoo06Ioo`0301moogoo07moo`0301moogoo
02Moo`005Goo00<007ooOol0IWoo00<07gooOol0P7oo00<07gooOol09Woo000EOol00`00Oomoo`1U
Ool00`0OOomoo`21Ool00`0OOomoo`0VOol001Eoo`03001oogoo06Aoo`0301moogoo08=oo`0301mo
ogoo01ioo`8000Eoo`003Woo1`0000<07`000000I00000<07`000000P`0000<07`00000050002Goo
00@007ooOol000Aoo`005Goo00<07gooOol02Goo00<007ooOol02Woo00<007ooOol02Woo00<007oo
Ool02Goo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol02Woo00<0000O
Ool02Woo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol02Goo00<007oo
Ool02Woo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02Woo00<007oo
Ool01goo00<07goo000037oo00<007ooOol03Goo00<007ooOol01Goo000EOol00`0001moo`0_Ool0
0`00Oomoo`0`Ool00`0001moo`0`Ool00`00Oomoo`0_Ool00`00Oomoo`0QOol00`0OOomoo`0<Ool0
0`00Oomoo`0<Ool50004Ool001Eoo`0300007goo069oo`0301moogoo08Moo`0301moogoo01]oo`03
001oogoo00Eoo`005Goo00<007oo01l0HGoo00<07gooOol0R7oo00<07gooOol08goo000EOol00`00
Ool07`1POol00`0OOomoo`2:Ool00`0OOomoo`0ROol001Eoo`800003Ool07goo05ioo`0301moogoo
08Yoo`0301moogoo029oo`005Goo00@007ooOol07eioo`0301moogoo08aoo`0301moogoo025oo`00
5Goo00D007ooOomoo`0O05aoo`0301moogoo08eoo`0301moogoo025oo`005Goo00D007ooOomoo`0O
05]oo`0301moogoo08moo`0301moogoo021oo`005Goo00<007ooOol00Woo00<07gooOol0Egoo00<0
7gooOol0T7oo00<07gooOol087oo000EOol00`00Oomoo`02Ool00`0OOomoo`1GOol00`0OOomoo`2A
Ool00`0OOomoo`0OOol001Eoo`8000Aoo`0301moogoo05Eoo`0301moogoo099oo`0301moogoo01mo
o`005Goo00<007ooOol00goo00<07gooOol0E7oo00<07gooOol0U7oo00<07gooOol07Woo000EOol0
0`00Oomoo`04Ool00`0OOomoo`1BOol00`0OOomoo`2EOol00`0OOomoo`0NOol001Eoo`03001oogoo
00Aoo`0301moogoo055oo`0301moogoo09Moo`0301moogoo01eoo`005Goo00<007ooOol01Goo00<0
7gooOol0D7oo00<07gooOol0Ugoo00<07gooOol07Goo000EOol20006Ool00`0OOomoo`1?Ool00`0O
Oomoo`2IOol00`0OOomoo`0LOol001Eoo`03001oogoo00Ioo`0301moogoo04eoo`0301moogoo09Yo
o`0301moogoo01aoo`005Goo00<007ooOol01Woo00<07gooOol0C7oo00<07gooOol0W7oo00<07goo
Ool06goo000EOol00`00Oomoo`07Ool00`0OOomoo`1:Ool00`0OOomoo`2MOol00`0OOomoo`0KOol0
01Eoo`03001oogoo00Moo`0301moogoo04Uoo`0301moogoo09moo`0301moogoo01Yoo`005Goo00<0
07ooOol027oo00<07gooOol0B7oo00<07gooOol0Wgoo00<07gooOol06Woo000EOol20009Ool00`0O
Oomoo`17Ool00`0OOomoo`2QOol00`0OOomoo`0IOol001Eoo`03001oogoo00Uoo`0301moogoo04Eo
o`0301moogoo0:9oo`0301moogoo01Uoo`005Goo00<007ooOol02Goo00<07gooOol0A7oo00<07goo
Ool0Y7oo00<07gooOol067oo000EOol00`00Oomoo`0:Ool00`0OOomoo`12Ool00`0OOomoo`2UOol0
0`0OOomoo`0HOol000Moo`D0009oo`8000Eoo`03001oogoo00Yoo`0301moogoo049oo`0301moogoo
0:Ioo`0301moogoo01Moo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo00Yo
o`0301moogoo045oo`0301moogoo0:Moo`0301moogoo01Moo`002Goo00D007ooOomoo`00009oo`03
001oogoo009oo`8000aoo`0301moogoo03moo`0301moogoo0:Uoo`0301moogoo01Ioo`002Goo00D0
07ooOomoo`00009oo`03001oogoo009oo`03001oogoo00]oo`0301moogoo03ioo`0301moogoo0:Yo
o`0301moogoo01Ioo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo00aoo`03
01moogoo03aoo`0301moogoo0:aoo`0301moogoo01Eoo`0027oo0P0017oo0P001Goo00<007ooOol0
37oo00<07gooOol0?7oo00<07gooOol0a7oo000EOol00`00Oomoo`0=Ool00`0OOomoo`0jOol00`0O
Oomoo`35Ool001Eoo`8000ioo`0301moogoo03Uoo`0301moogoo0<Ioo`005Goo00<007ooOol03Woo
00<07gooOol0=goo00<07gooOol0agoo000EOol00`00Oomoo`0>Ool00`0OOomoo`0fOol00`0OOomo
o`38Ool001Eoo`03001oogoo00moo`0301moogoo03Eoo`0301moogoo0<Qoo`005Goo00<007ooOol0
3goo00<07gooOol0=7oo00<07gooOol0bGoo000EOol00`00Oomoo`0@Ool00`0OOomoo`0bOol00`0O
Oomoo`3:Ool001Eoo`80015oo`0301moogoo035oo`0301moogoo0<]oo`005Goo00<007ooOol04Goo
00<07gooOol0;goo00<07gooOol0c7oo000EOol00`00Oomoo`0AOol00`0OOomoo`0_Ool00`0OOomo
o`3<Ool001Eoo`03001oogoo019oo`0301moogoo02eoo`0301moogoo0<eoo`005Goo00<007ooOol0
4Woo00<07gooOol0;7oo00<07gooOol0cWoo000EOol00`00Oomoo`0COol00`0OOomoo`0ZOol00`0O
Oomoo`3?Ool001Eoo`8001Aoo`0301moogoo02Yoo`0301moogoo0<moo`005Goo00<007ooOol057oo
00<07gooOol0:7oo00<07gooOol0d7oo000EOol00`00Oomoo`0DOol00`0OOomoo`0WOol00`0OOomo
o`3AOol001Eoo`03001oogoo01Eoo`0301moogoo02Eoo`0301moogoo0=9oo`005Goo00<007ooOol0
5Goo00<07gooOol097oo00<07gooOol0dgoo000EOol00`00Oomoo`0FOol00`0OOomoo`0SOol00`0O
Oomoo`3COol001Eoo`8001Moo`0301moogoo029oo`0301moogoo0=Aoo`005Goo00<007ooOol05goo
0P0O8Goo00<07gooOol0eGoo000EOol00`00Oomoo`0IOol201lNOol00`0OOomoo`3FOol000Moo`@0
00=oo`8000Eoo`03001oogoo01]oo`0301moogoo01Yoo`0301moogoo0=Moo`001goo00<007ooOol0
0goo00@007ooOol000Aoo`03001oogoo01aoo`807aYoo`0301moogoo0=Moo`0027oo00<007ooOol0
0Woo00@007ooOol000Aoo`8001moo`807aMoo`0301moogoo0=Qoo`002Goo00D007ooOomoo`00009o
o`03001oogoo009oo`03001oogoo021oo`0301moogoo01=oo`0301moogoo0=Uoo`001goo00@007oo
Ool0009oo`04001oogoo0004Ool00`00Oomoo`0QOol201lBOol00`0OOomoo`3JOol000Qoo`8000Ao
o`8000Eoo`03001oogoo02=oo`807a1oo`0301moogoo0=Yoo`005Goo00<007ooOol09Goo00<07goo
Ool037oo00<07gooOol0fgoo000EOol00`00Oomoo`0VOol201l;Ool00`0OOomoo`3LOol001Eoo`80
02Uoo`807`Qoo`0301moogoo0=eoo`005Goo00<007ooOol0:Woo00<07gooOol017oo00<07gooOol0
gWoo000EOol00`00Oomoo`0[Ool201l4Ool00`0OOomoo`3NOol001Eoo`03001oogoo02eoo`807`03
Ool07goo0>1oo`005Goo00<007ooOol0;goo00<07gooOol0h7oo000EOol00`00Oomoo`3oOolCOol0
01Eoo`800?mooaAoo`005Goo00<007ooOol0ogoo4goo000EOol00`00Oomoo`3oOolCOol00?moob]o
o`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00ogoo:goo003o
Ool[Ool00?moob]oo`00ogoo:goo000COol5003oOolCOol001=oo`@00?mooaAoo`005Woo00<007oo
Ool0ogoo4Woo000DOol3003oOolDOol00?moob]oo`00ogoo:goo003oOol[Ool00?moob]oo`00\
\>"],
  ImageRangeCache->{{{0, 297.625}, {183.563, 0}} -> {-0.0841875, -32.7444, \
0.00394765, 0.350846}}],

Cell[BoxData[
    InterpretationBox[\("t"\[InvisibleSpace]"         "\[InvisibleSpace]"p    \
     "\[InvisibleSpace]"u"\[InvisibleSpace]"          \
v"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]"         a"\),
      SequenceForm[ 
      "t", "         ", "p         ", "u", "          v", "", "         a"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("----------------------------------------------------"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        InterpretationBox[GridBox[{
              {"0"},
              {"0.1`"},
              {"0.2`"},
              {"0.30000000000000004`"},
              {"0.4`"},
              {"0.5`"},
              {"0.6000000000000001`"},
              {"0.7000000000000001`"},
              {"0.8`"},
              {"0.9`"},
              {"1.`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0}]], 
        "\[InvisibleSpace]", "\<\"     \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"5.`"},
              {"8.66`"},
              {"10.`"},
              {"8.66`"},
              {"5.`"},
              {"0"},
              {"0"},
              {"0"},
              {"0"},
              {"0"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 5.0, 8.6600000000000001, .1*^2, 8.6600000000000001, 
            5.0, 0, 0, 0, 0, 0}]], "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"0.03016482058535258`"},
              {"0.22111732261030934`"},
              {"0.623922422013862`"},
              {"1.1551337608261618`"},
              {"1.698288980930243`"},
              {"2.104108350012978`"},
              {"2.230025280831925`"},
              {"2.0713230327820784`"},
              {"1.7067718348693754`"},
              {"1.2746224944843088`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {
            0, .030164820585352581, .22111732261030934, .62392242201386205, 
            1.1551337608261618, 1.6982889809302431, 2.1041083500129778, 
            2.2300252808319252, 2.0713230327820784, 1.7067718348693754, 
            1.2746224944843088}]], "\[InvisibleSpace]", "\<\"   \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"0.9049446173795885`"},
              {"3.0196955750261236`"},
              {"4.866694078829522`"},
              {"5.613532724816143`"},
              {"5.01501997514504`"},
              {"2.79562505053236`"},
              {\(-0.2454311800596738`\)},
              {\(-2.7974598473184455`\)},
              {\(-4.262338328984704`\)},
              {\(-4.126163348760915`\)}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, .90494461737958853, 3.0196955750261236, 
            4.8666940788295223, 5.6135327248161433, 5.0150199751450399, 
            2.7956250505323599, -.24543118005967379, -2.7974598473184455, \
-4.2623383289847041, -4.1261633487609153}]], 
        "\[InvisibleSpace]", "\<\"  \"\>", "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {"0"},
              {"17.97980501800096`"},
              {"23.561355066532755`"},
              {"11.788385639604106`"},
              {"1.051423569716818`"},
              {\(-13.021678563138925`\)},
              {\(-31.36621992911469`\)},
              {\(-29.45490468272601`\)},
              {\(-21.585558277964605`\)},
              {\(-6.272804099487317`\)},
              {"10.702380847212403`"}
              },
            RowSpacings->1,
            ColumnSpacings->3,
            RowAlignments->Baseline,
            ColumnAlignments->{Left}],
          
          TableForm[ {0, 17.97980501800096, 23.561355066532755, 
            11.788385639604106, 
            1.0514235697168179, -13.021678563138925, -31.366219929114688, \
-29.45490468272601, -21.585558277964605, -6.2728040994873169, 
            10.702380847212403}]]}],
      SequenceForm[ 
        TableForm[ {
          0, .10000000000000001, .20000000000000001, .30000000000000004, \
.40000000000000002, .5, .60000000000000009, .70000000000000007, \
.80000000000000004, .90000000000000002, 1.0}], "     ", 
        TableForm[ {0, 5.0, 8.6600000000000001, .1*^2, 8.6600000000000001, 
          5.0, 0, 0, 0, 0, 0}], 
        TableForm[ {
          0, .030164820585352581, .22111732261030934, .62392242201386205, 
          1.1551337608261618, 1.6982889809302431, 2.1041083500129778, 
          2.2300252808319252, 2.0713230327820784, 1.7067718348693754, 
          1.2746224944843088}], "   ", 
        TableForm[ {0, .90494461737958853, 3.0196955750261236, 
          4.8666940788295223, 5.6135327248161433, 5.0150199751450399, 
          2.7956250505323599, -.24543118005967379, -2.7974598473184455, \
-4.2623383289847041, -4.1261633487609153}], "  ", 
        TableForm[ {0, 17.97980501800096, 23.561355066532755, 
          11.788385639604106, 
          1.0514235697168179, -13.021678563138925, -31.366219929114688, \
-29.45490468272601, -21.585558277964605, -6.2728040994873169, 
          10.702380847212403}]],
      Editable->False]], "Print"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{692, 500},
WindowMargins->{{4, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 274, 7, 144, "Title"],
Cell[1994, 58, 9398, 247, 449, "Subsection"],
Cell[11395, 307, 118, 3, 121, "Title"],
Cell[11516, 312, 10006, 157, 4204, "Input"],
Cell[21525, 471, 26, 0, 30, "Input"],
Cell[21554, 473, 646, 18, 272, "Subsection"],

Cell[CellGroupData[{
Cell[22225, 495, 297, 8, 82, "Input"],
Cell[22525, 505, 388, 7, 25, "Print"],
Cell[22916, 514, 388, 7, 25, "Print"],
Cell[23307, 523, 387, 7, 25, "Print"],
Cell[23697, 532, 338, 6, 25, "Print"],
Cell[24038, 540, 338, 6, 25, "Print"],
Cell[24379, 548, 338, 6, 25, "Print"],
Cell[24720, 556, 338, 6, 25, "Print"],
Cell[25061, 564, 338, 6, 25, "Print"],
Cell[25402, 572, 338, 6, 25, "Print"],
Cell[25743, 580, 391, 7, 25, "Print"],
Cell[26137, 589, 390, 7, 25, "Print"],
Cell[26530, 598, 396, 7, 25, "Print"],
Cell[26929, 607, 346, 6, 25, "Print"],
Cell[27278, 615, 346, 6, 25, "Print"],
Cell[27627, 623, 388, 7, 25, "Print"],
Cell[28018, 632, 392, 7, 25, "Print"],
Cell[28413, 641, 390, 7, 25, "Print"],
Cell[28806, 650, 391, 7, 25, "Print"],
Cell[29200, 659, 389, 7, 25, "Print"],
Cell[29592, 668, 391, 7, 25, "Print"],
Cell[29986, 677, 15305, 454, 186, 5096, 323, "GraphicsData", "PostScript", \
"Graphics"],
Cell[45294, 1133, 15455, 430, 186, 4699, 293, "GraphicsData", "PostScript", \
"Graphics"],
Cell[60752, 1565, 18557, 511, 186, 5375, 344, "GraphicsData", "PostScript", \
"Graphics"],
Cell[79312, 2078, 18109, 488, 186, 5142, 323, "GraphicsData", "PostScript", \
"Graphics"],
Cell[97424, 2568, 345, 6, 25, "Print"],
Cell[97772, 2576, 87, 1, 25, "Print"],
Cell[97862, 2579, 9488, 221, 341, "Print"]
}, Open  ]],
Cell[107365, 2803, 254, 6, 82, "Subsection"],

Cell[CellGroupData[{
Cell[107644, 2813, 314, 9, 82, "Input"],
Cell[107961, 2824, 388, 7, 25, "Print"],
Cell[108352, 2833, 388, 7, 25, "Print"],
Cell[108743, 2842, 387, 7, 25, "Print"],
Cell[109133, 2851, 385, 7, 25, "Print"],
Cell[109521, 2860, 389, 7, 25, "Print"],
Cell[109913, 2869, 387, 7, 25, "Print"],
Cell[110303, 2878, 389, 7, 25, "Print"],
Cell[110695, 2887, 389, 7, 25, "Print"],
Cell[111087, 2896, 389, 7, 25, "Print"],
Cell[111479, 2905, 396, 7, 25, "Print"],
Cell[111878, 2914, 396, 7, 25, "Print"],
Cell[112277, 2923, 396, 7, 25, "Print"],
Cell[112676, 2932, 396, 7, 25, "Print"],
Cell[113075, 2941, 396, 7, 25, "Print"],
Cell[113474, 2950, 397, 7, 25, "Print"],
Cell[113874, 2959, 391, 7, 25, "Print"],
Cell[114268, 2968, 391, 7, 25, "Print"],
Cell[114662, 2977, 390, 7, 25, "Print"],
Cell[115055, 2986, 390, 7, 25, "Print"],
Cell[115448, 2995, 393, 7, 25, "Print"],
Cell[115844, 3004, 15305, 454, 186, 5096, 323, "GraphicsData", "PostScript", \
"Graphics"],
Cell[131152, 3460, 15886, 463, 186, 5117, 326, "GraphicsData", "PostScript", \
"Graphics"],
Cell[147041, 3925, 16996, 480, 186, 5170, 329, "GraphicsData", "PostScript", \
"Graphics"],
Cell[164040, 4407, 18987, 481, 186, 4826, 302, "GraphicsData", "PostScript", \
"Graphics"],
Cell[183030, 4890, 345, 6, 25, "Print"],
Cell[183378, 4898, 87, 1, 25, "Print"],
Cell[183468, 4901, 9506, 223, 341, "Print"]
}, Open  ]],
Cell[192989, 5127, 221, 5, 82, "Subsection"],

Cell[CellGroupData[{
Cell[193235, 5136, 298, 8, 82, "Input"],
Cell[193536, 5146, 336, 6, 25, "Print"],
Cell[193875, 5154, 336, 6, 25, "Print"],
Cell[194214, 5162, 336, 6, 25, "Print"],
Cell[194553, 5170, 336, 6, 25, "Print"],
Cell[194892, 5178, 336, 6, 25, "Print"],
Cell[195231, 5186, 336, 6, 25, "Print"],
Cell[195570, 5194, 336, 6, 25, "Print"],
Cell[195909, 5202, 336, 6, 25, "Print"],
Cell[196248, 5210, 336, 6, 25, "Print"],
Cell[196587, 5218, 338, 6, 25, "Print"],
Cell[196928, 5226, 338, 6, 25, "Print"],
Cell[197269, 5234, 338, 6, 25, "Print"],
Cell[197610, 5242, 338, 6, 25, "Print"],
Cell[197951, 5250, 338, 6, 25, "Print"],
Cell[198292, 5258, 338, 6, 25, "Print"],
Cell[198633, 5266, 338, 6, 25, "Print"],
Cell[198974, 5274, 338, 6, 25, "Print"],
Cell[199315, 5282, 338, 6, 25, "Print"],
Cell[199656, 5290, 338, 6, 25, "Print"],
Cell[199997, 5298, 338, 6, 25, "Print"],
Cell[200338, 5306, 15734, 460, 193, 5096, 323, "GraphicsData", "PostScript", \
"Graphics"],
Cell[216075, 5768, 13184, 435, 193, 5235, 332, "GraphicsData", "PostScript", \
"Graphics"],
Cell[229262, 6205, 15236, 461, 193, 5237, 332, "GraphicsData", "PostScript", \
"Graphics"],
Cell[244501, 6668, 16024, 470, 193, 5288, 332, "GraphicsData", "PostScript", \
"Graphics"],
Cell[260528, 7140, 345, 6, 25, "Print"],
Cell[260876, 7148, 87, 1, 25, "Print"],
Cell[260966, 7151, 9462, 220, 341, "Print"]
}, Open  ]],
Cell[270443, 7374, 696, 19, 310, "Subsection"],

Cell[CellGroupData[{
Cell[271164, 7397, 345, 9, 100, "Input"],
Cell[271512, 7408, 382, 7, 25, "Print"],
Cell[271897, 7417, 381, 7, 25, "Print"],
Cell[272281, 7426, 380, 7, 25, "Print"],
Cell[272664, 7435, 341, 6, 25, "Print"],
Cell[273008, 7443, 341, 6, 25, "Print"],
Cell[273352, 7451, 341, 6, 25, "Print"],
Cell[273696, 7459, 341, 6, 25, "Print"],
Cell[274040, 7467, 381, 7, 25, "Print"],
Cell[274424, 7476, 382, 7, 25, "Print"],
Cell[274809, 7485, 390, 7, 25, "Print"],
Cell[275202, 7494, 15137, 423, 193, 4723, 289, "GraphicsData", "PostScript", \
"Graphics"],
Cell[290342, 7919, 13747, 409, 193, 4708, 292, "GraphicsData", "PostScript", \
"Graphics"],
Cell[304092, 8330, 14133, 408, 193, 4627, 286, "GraphicsData", "PostScript", \
"Graphics"],
Cell[318228, 8740, 16524, 460, 193, 4994, 313, "GraphicsData", "PostScript", \
"Graphics"],
Cell[334755, 9202, 345, 6, 25, "Print"],
Cell[335103, 9210, 87, 1, 25, "Print"],
Cell[335193, 9213, 5389, 137, 181, "Print"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

