(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     35911,        827]*)
(*NotebookOutlinePosition[     36552,        850]*)
(*  CellTagsIndexPosition[     36508,        846]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(M\[CapitalEAcute]TODO\ DE\ HILBERG, 
    HUGHES\ Y\ TAYLOR\ \((F . J . Palma\ Duran\ 2002 - 03)\)\)], "Input"],

Cell[BoxData[{
    RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
      StyleBox[
        RowBox[{"       ", 
          StyleBox["\t",
            "Text"]}]], 
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["Este",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[" ",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox["problema",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[" ",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox["esta",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[" ",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox["basado",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[" ",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox["en",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[" ",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox["el",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[" ",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox["m\[EAcute]todo",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[" ",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox["de",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[" ",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[\(NEWMARK . \ El\),
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[" ",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox["problema",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[" ",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox["parte",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[" ",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox["de",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[" ",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox["las",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[" ",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox["siguientes",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[" ",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[
              RowBox[{
                StyleBox["ecuaciones",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                StyleBox[":",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                StyleBox["\[IndentingNewLine]",
                  "Text"], "\[IndentingNewLine]", 
                StyleBox[\(vi + 1\),
                  "Text"]}],
              "Text"]}], 
          StyleBox["=",
            "Text"], 
          
          StyleBox[\(\((\[Gamma]\/\(\[CapitalDelta]t*\[Beta]\))\)*\((ui + 1 - 
                    ui)\) + \
\[Gamma]*\[CapitalDelta]t*\((\((1\/\[CapitalDelta]t)\)*\((1\/\[Gamma] - 
                          1\/\[Beta])\)*
                      vi + \((1\/\[Gamma] - 1\/\(2*\[Beta]\))\)*ai)\)\),
            "Text"]}], 
        StyleBox[";",
          "Text"]}]}], "\[IndentingNewLine]", 
    StyleBox[\(ai + 
            1 = \((1\/\(\[CapitalDelta]t\^2*\[Beta]\))\)*\((ui + 1 - 
                  ui)\) + \((\(-1\)\/\(\[CapitalDelta]t*\[Beta]\))\)*
              vi + \((1 - 1\/\(2*\[Beta]\))\)*ai;\),
      "Text"], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[
        StyleBox[
          RowBox[{
            StyleBox["         ",
              "Text"], "\t"}]],
        "Text"], 
      RowBox[{
        StyleBox[\(Como\ se\ sabe\ estas\ dos\ ecuaciones\ se\ cumplen\ \
siempre\),
          FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
        StyleBox[",",
          FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
        RowBox[{
          StyleBox["ya",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox[" ",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox["que",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox[" ",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox["han",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox[" ",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox["sido",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox[" ",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox["obtenidas",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox[" ",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox["mediante",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox[" ",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          RowBox[{
            StyleBox["integracion",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[".",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox["\[IndentingNewLine]",
              "Text",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox[" ",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox["Para",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]]}], 
          StyleBox[" ",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox["resolver",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox[" ",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox["el",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox[" ",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox["problema",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox[" ",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox["nos",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox[" ",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox["hace",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox[" ",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox["falta",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox[" ",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox["otra",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox[" ",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
          StyleBox["ecuacion",
            FontColor->RGBColor[0.226566, 0.644541, 0.644541]]}], 
        StyleBox[",",
          FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
        StyleBox[" ",
          FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
        StyleBox[
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["que",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                StyleBox[" ",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                StyleBox["sera",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                StyleBox[" ",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                StyleBox["la",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                StyleBox[" ",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                StyleBox["de",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                StyleBox[" ",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                StyleBox["equilibrio",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                StyleBox[" ",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                StyleBox["dinamico",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                StyleBox[" ",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                RowBox[{
                  StyleBox["modificada",
                    FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                  StyleBox[":",
                    FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                  StyleBox["\[IndentingNewLine]",
                    "Text"], 
                  
                  StyleBox[\(m*\((ai + 1)\) + 
                      c*\((vi + 1)\) + \((1 + \[Alpha])\)*
                        k*\((ui + 1)\) - \[Alpha]*k*ui\),
                    "Text"]}]}], 
              StyleBox["=",
                "Text"], 
              StyleBox[\(pi + 1\),
                "Text"]}], ";"}],
          "Text"]}], 
      StyleBox["\[IndentingNewLine]",
        "Text"]}], "\[IndentingNewLine]", 
    StyleBox[\(\(\ \ \ \ \ \ \ \ \ \)\(\((m\/\(\[CapitalDelta]t\^2*\[Beta]\) \
+ \(c*\[Gamma]\)\/\(\[CapitalDelta]t*\[Beta]\) + \((1 + \[Alpha])\)*k)\)*ui + 
            1 = \((pi + 
                1)\) + \((m\/\(\[CapitalDelta]t\^2*\[Beta]\) + \(c*\[Gamma]\)\
\/\(\[CapitalDelta]t*\[Beta]\) + \[Alpha]*k)\) 
              ui + \((m\/\(\[CapitalDelta]t*\[Beta]\) + 
                  c*\((\[Gamma]\/\[Beta] - 1)\))\)*
              vi + \ \((m*\((1\/\(2*\[Beta]\) - 1)\) 
                  c*\[CapitalDelta]t*\((\[Gamma]\/\(2*\[Beta]\) - 1)\))\) 
              ai;\)\(\[IndentingNewLine]\)\),
      "Text"], "\[IndentingNewLine]", 
    StyleBox[
      RowBox[{"\t", 
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["Llamando",
                FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
              StyleBox[":",
                FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
              StyleBox["\[IndentingNewLine]",
                "Text",
                FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
              StyleBox["\[IndentingNewLine]",
                "Text"], 
              StyleBox["  ",
                "Text"], 
              StyleBox["A1",
                "Text"]}], 
            StyleBox["=",
              "Text"], 
            
            StyleBox[\((m\/\(\[CapitalDelta]t\^2*\[Beta]\) + \(c*\[Gamma]\)\/\
\(\[CapitalDelta]t*\[Beta]\) + \((1 + \[Alpha])\)*k)\),
              "Text"]}], ";"}]}],
      "Text"], "\[IndentingNewLine]", 
    StyleBox[\(\(\ \ \ \ \ \ \ \ \ \)\(B1 = \((m\/\(\[CapitalDelta]t\^2*\
\[Beta]\) + \(c*\[Gamma]\)\/\(\[CapitalDelta]t*\[Beta]\) + \[Alpha]*k)\);\)\),
      
      "Text"], "\[IndentingNewLine]", 
    StyleBox[\(\(\ \ \ \ \ \ \ \ \ \)\(C1 = \
\((m\/\(\[CapitalDelta]t*\[Beta]\) + c*\((\[Gamma]\/\[Beta] - 1)\))\);\)\),
      "Text"], "\[IndentingNewLine]", 
    StyleBox[\(\(\ \ \ \ \ \ \ \ \ \)\(D1 = \((m*\((1\/\(2*\[Beta]\) - 1)\) 
              c*\[CapitalDelta]t*\((\[Gamma]\/\(2*\[Beta]\) - 1)\))\);\)\),
      "Text"], "\[IndentingNewLine]", 
    StyleBox[\(B2 = \((\[Gamma]\/\(\[CapitalDelta]t*\[Beta]\))\);\),
      "Text"], "\[IndentingNewLine]", 
    StyleBox[\(C2 = \((1\/\[CapitalDelta]t)\)*\((1\/\[Gamma] - 
                1\/\[Beta])\);\),
      "Text"], "\[IndentingNewLine]", 
    StyleBox[\(D2 = \((1\/\[Gamma] - 1\/\(2*\[Beta]\))\);\),
      "Text"], "\[IndentingNewLine]", 
    StyleBox[\(B3 = \((1\/\(\[CapitalDelta]t\^2*\[Beta]\))\);\),
      "Text"], "\[IndentingNewLine]", 
    StyleBox[\(C3 = \((\(-1\)\/\(\[CapitalDelta]t*\[Beta]\))\);\),
      "Text"], "\[IndentingNewLine]", 
    StyleBox[\(\(D3 = \((1 - 1\/\(2*\[Beta]\))\);\)\(\[IndentingNewLine]\)\),
      "Text"], "\[IndentingNewLine]", 
    StyleBox[
      RowBox[{"\t", 
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox[\(podemos\ despejar\ ui\),
                FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
              StyleBox["+",
                FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
              RowBox[{
                StyleBox["1",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                StyleBox[" ",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                RowBox[{
                  StyleBox["quedando",
                    FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                  StyleBox[":",
                    FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                  StyleBox["\[IndentingNewLine]",
                    "Text",
                    FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                  StyleBox["\[IndentingNewLine]",
                    "Text"], 
                  StyleBox[\(ui + 1\),
                    "Text"]}]}]}], 
            StyleBox["=",
              "Text"], 
            StyleBox[\(\(\((pi + 1)\) + B*ui + C*vi + D*ai\)\/A\),
              "Text"]}], ";"}], "\[IndentingNewLine]", "\t"}],
      "Text"], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[
        RowBox[{
          StyleBox["\t",
            "Text"], "\t"}]], 
      StyleBox[\(A\ partir\ de\ aqui\ iteramos\ para\ obtener\ los\ valores\ \
de\ la\ aceleracion, \ \(velocidad\ y\ posicion\ en\ cada\ nodo . \
\[IndentingNewLine]Todo\ el\ algoritmo\ ha\ sido\ introducido\ en\ una\ \
funcion\ Block\ para\ que\ su\ ejecucion\ sea\ solo\ darle\ valores\ a\ la\ \
funcion . \[IndentingNewLine]\[IndentingNewLine]Variables\ del\ \(modelo : \
\[IndentingNewLine]ti\) = instante\ inicial;\)\),
        "Text",
        FontColor->RGBColor[0.226566, 0.644541, 
        0.644541]]}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[
        RowBox[{
          StyleBox["\t\t",
            "Text"], "\t"}]], 
      StyleBox[\(tn = 
            tiempo\ hasta\ el\ que\ se\ desea\ conocer\ la\ respuesta;\),
        "Text",
        FontColor->RGBColor[0.226566, 0.644541, 
        0.644541]]}], "\[IndentingNewLine]", 
    RowBox[{"\t\t\t", 
      StyleBox[\(to = incremento\ de\ tiempo;\),
        "Text",
        FontColor->RGBColor[0.226566, 0.644541, 
        0.644541]]}], "\[IndentingNewLine]", 
    RowBox[{"\t\t\t", 
      StyleBox[\(tfc = tiempo\ en\ que\ finaliza\ la\ carga;\),
        "Text",
        FontColor->RGBColor[0.226566, 0.644541, 
        0.644541]]}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[
        RowBox[{
          StyleBox["\t\t",
            "Text"], "\t"}]], 
      StyleBox[\(u0 = posicion\ inicial;\),
        "Text",
        FontColor->RGBColor[0.226566, 0.644541, 
        0.644541]]}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[
        RowBox[{
          StyleBox["\t\t",
            "Text"], "\t"}]], 
      StyleBox[\(v0 = velocidad\ inicial;\),
        "Text",
        FontColor->RGBColor[0.226566, 0.644541, 
        0.644541]]}], "\[IndentingNewLine]", 
    RowBox[{"\t\t\t", 
      StyleBox[\(k = rigidez\ ;\),
        "Text",
        FontColor->RGBColor[0.226566, 0.644541, 
        0.644541]]}], "\[IndentingNewLine]", 
    StyleBox[\(m = \ masa\ en\ kg;\),
      "Text",
      FontColor->RGBColor[0.226566, 0.644541, 
      0.644541]], "\[IndentingNewLine]", 
    StyleBox[
      RowBox[{
        StyleBox[
          RowBox[{
            StyleBox["\t\t",
              "Text"], "\t"}]], \(c = amortiguamiento;\)}],
      "Text",
      FontColor->RGBColor[0.226566, 0.644541, 
      0.644541]], "\[IndentingNewLine]", 
    RowBox[{"\t\t\t", 
      StyleBox[\(p = carga;\),
        "Text",
        FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
      StyleBox[
        RowBox[{
          StyleBox["\t\t",
            "Text"], "\t"}]]}], "\[IndentingNewLine]", 
    RowBox[{"\t\t\t", 
      StyleBox[\(\[Beta] = 0.25;\),
        "Text",
        FontColor->RGBColor[0.226566, 0.644541, 
        0.644541]]}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[
        RowBox[{
          StyleBox["\t\t",
            "Text"], "\t"}]], 
      StyleBox[\(\[Gamma] = 0.5;\),
        "Text",
        FontColor->RGBColor[0.226566, 0.644541, 
        0.644541]]}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[
        RowBox[{
          StyleBox["\t\t",
            "Text"], "\t"}]], 
      StyleBox[\(\[Alpha] = 
            valor\ comprendido\ entre\  - 0.333333333\ y\ 0;\),
        "Text",
        FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
      "\[IndentingNewLine]", 
      StyleBox[
        RowBox[{
          StyleBox["\t\t",
            "Text"], "\t"}]], 
      StyleBox["\[IndentingNewLine]",
        "Text",
        FontColor->RGBColor[0.226566, 0.644541, 
        0.644541]]}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox["\t",
        "Text",
        FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
      RowBox[{
        StyleBox[\(Por\ \[UAcute]ltimo\ debemos\ comentar\ que\ cada\ vez\ \
que\ se\ ejecute\ la\ funcion\ Hilberg\ debe\ ser\ cargado\ el\ Block\),
          "Text",
          FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
        StyleBox[",",
          "Text",
          FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
        "\[IndentingNewLine]", 
        StyleBox[" ",
          "Text",
          FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
        StyleBox[\(de\ este\ modo\ no\ se\ confudiran\ las\ \
\(\(constantes\)\(.\)\)\),
          "Text",
          FontColor->RGBColor[0.226566, 0.644541, 0.644541]]}]}]}], "Input"],

Cell[BoxData[{
    RowBox[{
      "\[IndentingNewLine]", \(Clear["\<Global`*\>"];\)}], "\
\[IndentingNewLine]", \(posicion;\), "\[IndentingNewLine]", \(velocidad;\), "\
\[IndentingNewLine]", \(aceleracion;\), "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{\(Hilberg[ti_, tf_, \[CapitalDelta]t_, u0_, v0_, k_, m_, c_, 
          funcioncarga_, \[Beta]_, \[Gamma]_, \[Alpha]_, posicion_, 
          velocidad_, aceleracion_]\), ":=", 
        RowBox[{"Block", "[", 
          
          RowBox[{\({nointervalos, nointervalos1, nopuntos, carga, 
              cargainterpolada, \ centinela, i, tini, A1, B1, C1, D1, B2, C2, 
              D2, B3, C3, D3, u, v, a, posicion1, velocidad1, aceleracion1, 
              posicion2, velocidad2, aceleracion2}\), ",", 
            "\[IndentingNewLine]", 
            
            RowBox[{\(tfc = tf\), ";", 
              "\[IndentingNewLine]", \(If[Head[funcioncarga] \[Equal] List, 
                tipocarga = disc]\), ";", 
              "\[IndentingNewLine]", \(If[Head[funcioncarga] \[Equal] Symbol, 
                tipocarga = cont]\), ";", 
              "\[IndentingNewLine]", \(If[
                tf \[LessEqual] tfc, \[IndentingNewLine]\t
                centinela = 0; \[IndentingNewLine]\t
                If[tipocarga \[Equal] disc, \[IndentingNewLine]\t
                  cargainterpolada = 
                    Interpolation[funcioncarga, 
                      InterpolationOrder \[Rule] 1]; \[IndentingNewLine]\t
                  tipocarga = cont; \[IndentingNewLine]\t
                  centinela = 1;\[IndentingNewLine]\t]; \[IndentingNewLine]\t
                If[tipocarga \[Equal] cont, \[IndentingNewLine]\t
                  If[centinela \[Equal] 0, 
                    cargainterpolada = funcioncarga]; \[IndentingNewLine]\t
                  nointervalos = 
                    Floor[\((tf - 
                            ti)\)/\[CapitalDelta]t]; \[IndentingNewLine]\t
                  nopuntos = nointervalos + 1; \[IndentingNewLine]\t
                  carga = 
                    Table[0, {i, 1, nopuntos}, {j, 1, 
                        2}]; \[IndentingNewLine]\t
                  tini = ti; \[IndentingNewLine]\t
                  For[i = 1, 
                    i \[LessEqual] nopuntos, \(i++\), \[IndentingNewLine]\t
                    carga[\([i, 1]\)] = tini; \[IndentingNewLine]\t
                    tini = tini + \[CapitalDelta]t;\[IndentingNewLine]\t]; \
\[IndentingNewLine]\ttini = ti; \[IndentingNewLine]\t
                  For[i = 1, 
                    i \[LessEqual] nopuntos, \(i++\), \[IndentingNewLine]\t
                    carga[\([i, 2]\)] = 
                      cargainterpolada[tini]; \[IndentingNewLine]\t
                    tini = tini + \[CapitalDelta]t;\[IndentingNewLine]\t];\
\[IndentingNewLine]\t];\[IndentingNewLine]\t]\), ";", 
              "\[IndentingNewLine]", \(If[tf > tfc, \[IndentingNewLine]\t
                centinela = 0; \[IndentingNewLine]\t
                If[tipocarga \[Equal] disc, \[IndentingNewLine]\t
                  cargainterpolada = 
                    Interpolation[funcioncarga, 
                      InterpolationOrder \[Rule] 1]; \[IndentingNewLine]\t
                  tipocarga = cont; \[IndentingNewLine]\t
                  centinela = 1;\[IndentingNewLine]\t]; \[IndentingNewLine]\t
                If[tipocarga \[Equal] cont, \[IndentingNewLine]\t
                  If[centinela \[Equal] 0, 
                    cargainterpolada = funcioncarga]; \[IndentingNewLine]\t
                  nointervalos = 
                    Floor[\((tfc - 
                            ti)\)/\[CapitalDelta]t]; \[IndentingNewLine]\t
                  nointervalos1 = nointervalos + 1; \[IndentingNewLine]\t
                  nopuntos = nointervalos + 3; \[IndentingNewLine]\t
                  carga = 
                    Table[0, {i, 1, nopuntos}, {j, 1, 
                        2}]; \[IndentingNewLine]\t
                  tini = ti; \[IndentingNewLine]\t
                  For[i = 1, 
                    i \[LessEqual] 
                      nointervalos1, \(i++\), \[IndentingNewLine]\t
                    carga[\([i, 1]\)] = tini; \[IndentingNewLine]\t
                    tini = tini + \[CapitalDelta]t;\[IndentingNewLine]\t]; \
\[IndentingNewLine]\ttini = ti; \[IndentingNewLine]\t
                  For[i = 1, 
                    i \[LessEqual] 
                      nointervalos1, \(i++\), \[IndentingNewLine]\t
                    carga[\([i, 2]\)] = 
                      cargainterpolada[tini]; \[IndentingNewLine]\t
                    tini = tini + \[CapitalDelta]t;\[IndentingNewLine]\t]; \
\[IndentingNewLine]\t
                  carga[\([nointervalos + 2, 1]\)] = 
                    tini + 0.000000000000001; \[IndentingNewLine]\t
                  carga[\([nointervalos + 3, 1]\)] = tf; \[IndentingNewLine]\t
                  cargainterpolada = 
                    Interpolation[carga, \ 
                      InterpolationOrder \[Rule] 1]; \[IndentingNewLine]\t
                  nointervalos = 
                    Floor[\((tf - 
                            ti)\)/\[CapitalDelta]t]; \[IndentingNewLine]\t
                  nopuntos = nointervalos + 1; \[IndentingNewLine]\t
                  carga = 
                    Table[0, {i, 1, nopuntos}, {j, 1, 
                        2}]; \[IndentingNewLine]\t
                  tini = ti; \[IndentingNewLine]\t
                  For[i = 1, 
                    i \[LessEqual] nopuntos, \(i++\), \[IndentingNewLine]\t
                    carga[\([i, 1]\)] = tini; \[IndentingNewLine]\t
                    tini = tini + \[CapitalDelta]t;\[IndentingNewLine]\t]; \
\[IndentingNewLine]\ttini = ti; \[IndentingNewLine]\t
                  For[i = 1, 
                    i \[LessEqual] nopuntos, \(i++\), \[IndentingNewLine]\t
                    carga[\([i, 2]\)] = 
                      cargainterpolada[tini]; \[IndentingNewLine]\t
                    tini = tini + \[CapitalDelta]t;\[IndentingNewLine]\t];\
\[IndentingNewLine]\t];\[IndentingNewLine]\t\[IndentingNewLine]]\), ";", 
              "\[IndentingNewLine]", \(Print[
                ListPlot[carga, PlotStyle \[Rule] RGBColor[0, 1, 0], 
                  AxesLabel \[Rule] {t, "\<p\>"}]]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(A1 = \((m\/\(\[CapitalDelta]t\^2*\
\[Beta]\) + \(c*\[Gamma]\)\/\(\[CapitalDelta]t*\[Beta]\) + \((1 + \[Alpha])\)*
                      k)\)\), ";", 
              "\[IndentingNewLine]", \(B1 = \((m\/\(\[CapitalDelta]t\^2*\
\[Beta]\) + \(c*\[Gamma]\)\/\(\[CapitalDelta]t*\[Beta]\) + \((\[Alpha])\)*
                      k)\)\), ";", 
              "\[IndentingNewLine]", \(C1 = \
\((m\/\(\[CapitalDelta]t*\[Beta]\) + c*\((\[Gamma]\/\[Beta] - 1)\))\)\), ";", 
              "\[IndentingNewLine]", \(D1 = \((m*\((1\/\(2*\[Beta]\) - 1)\) 
                    c*\[CapitalDelta]t*\((\[Gamma]\/\(2*\[Beta]\) - 1)\))\)\),
               ";", "\[IndentingNewLine]", \(B2 = \((\[Gamma]\/\(\
\[CapitalDelta]t*\[Beta]\))\)\), ";", 
              "\[IndentingNewLine]", \(C2 = \((1\/\[CapitalDelta]t)\)*\((1\/\
\[Gamma] - 1\/\[Beta])\)\), ";", 
              "\[IndentingNewLine]", \(D2 = \((1\/\[Gamma] - 
                    1\/\(2*\[Beta]\))\)\), ";", 
              "\[IndentingNewLine]", \(B3 = \((1\/\(\[CapitalDelta]t\^2*\
\[Beta]\))\)\), ";", 
              "\[IndentingNewLine]", \(C3 = \((\(-1\)\/\(\[CapitalDelta]t*\
\[Beta]\))\)\), ";", 
              "\[IndentingNewLine]", \(D3 = \((1 - 1\/\(2*\[Beta]\))\)\), ";",
               "\[IndentingNewLine]", \(u = Table[0, {i, 1, nopuntos}]\), ";",
               "\[IndentingNewLine]", \(v = Table[0, {i, 1, nopuntos}]\), ";",
               "\[IndentingNewLine]", \(a = Table[0, {i, 1, nopuntos}]\), ";",
               "\[IndentingNewLine]", \(u[\([1]\)] = u0\), ";", 
              "\[IndentingNewLine]", \(v[\([1]\)] = v0\), ";", 
              "\[IndentingNewLine]", \(a[\([1]\)] = \((carga[\([1, 2]\)] - 
                      c*v[\([1]\)] - k*u[\([1]\)])\)/m\), ";", 
              "\[IndentingNewLine]", 
              RowBox[{"For", "[", 
                
                RowBox[{\(i = 2\), ",", \(i \[LessEqual] nopuntos\), 
                  ",", \(i++\), ",", "\[IndentingNewLine]", "\t", 
                  
                  RowBox[{\(u[\([i]\)] = \((\(1\/A1\) \((carga[\([i, 2]\)] + 
                              B1*u[\([i - 1]\)] + C1*v[\([i - 1]\)] + 
                              D1*a[\([i - 1]\)])\))\)\), ";", 
                    "\[IndentingNewLine]", "\t ", 
                    RowBox[{\(v[\([i]\)]\), "=", 
                      RowBox[{
                        RowBox[{"B2", 
                          StyleBox["*",
                            "Text"], 
                          StyleBox[\((u[\([i]\)] - u[\([i - 1]\)])\),
                            "Text"]}], 
                        StyleBox["+",
                          "Text"], 
                        
                        StyleBox[\(\[Gamma]*\[CapitalDelta]t*\((C2*
                                  v[\([i - 1]\)] + D2*a[\([i - 1]\)])\)\),
                          "Text"]}]}], 
                    StyleBox[";",
                      "Text"], "\[IndentingNewLine]", "\t", 
                    
                    StyleBox[\(a[\([i]\)] = 
                        B3*\((u[\([i]\)] - u[\([i - 1]\)])\) + 
                          C3*v[\([i - 1]\)] + D3*a[\([i - 1]\)]\),
                      "Text"], 
                    StyleBox[";",
                      "Text"]}]}], "\[IndentingNewLine]", "  ", "]"}], ";", 
              "\[IndentingNewLine]", \(posicion1 = 
                Table[0, {i, 1, nopuntos}, {j, 1, 2}]\), ";", 
              "\[IndentingNewLine]", \(velocidad1 = 
                Table[0, {i, 1, nopuntos}, {j, 1, 2}]\), ";", 
              "\[IndentingNewLine]", \(aceleracion1 = 
                Table[0, {i, 1, nopuntos}, {j, 1, 2}]\), ";", 
              "\[IndentingNewLine]", \(tini = ti\), ";", 
              "\[IndentingNewLine]", \(For[i = 1, 
                i \[LessEqual] nopuntos, \(i++\), \[IndentingNewLine]\t
                posicion1[\([i, 1]\)] = tini; \[IndentingNewLine]\t
                velocidad1[\([i, 1]\)] = tini; \[IndentingNewLine]\t
                aceleracion1[\([i, 1]\)] = tini; \[IndentingNewLine]\t
                tini = tini + \[CapitalDelta]t;\[IndentingNewLine]]\), ";", 
              "\[IndentingNewLine]", \(For[i = 1, 
                i \[LessEqual] nopuntos, \(i++\), \[IndentingNewLine]\t
                posicion1[\([i, 2]\)] = u[\([i]\)]; \[IndentingNewLine]\t
                velocidad1[\([i, 2]\)] = v[\([i]\)]; \[IndentingNewLine]\t
                aceleracion1[\([i, 2]\)] = a[\([i]\)];\[IndentingNewLine]]\), 
              ";", "\[IndentingNewLine]", \(posicion = posicion1\), ";", 
              "\[IndentingNewLine]", \(velocidad = velocidad1\), ";", 
              "\[IndentingNewLine]", \(aceleracion = aceleracion1\), ";", 
              "\[IndentingNewLine]", \(posicion2 = 
                Interpolation[posicion1, InterpolationOrder \[Rule] 1]\), ";",
               "\[IndentingNewLine]", \(Print[
                Plot[posicion2[t], {t, 0, tf}, 
                  AxesLabel \[Rule] {t, "\<u\>"}]]\), ";", 
              "\[IndentingNewLine]", \(velocidad2 = 
                Interpolation[velocidad1, InterpolationOrder \[Rule] 1]\), 
              ";", "\[IndentingNewLine]", \(Print[
                Plot[velocidad2[t], {t, 0, tf}, 
                  AxesLabel \[Rule] {t, "\<v\>"}]]\), ";", 
              "\[IndentingNewLine]", \(aceleracion2 = 
                Interpolation[aceleracion1, InterpolationOrder \[Rule] 1]\), 
              ";", "\[IndentingNewLine]", \(Print[
                Plot[aceleracion2[t], {t, 0, tf}, 
                  AxesLabel \[Rule] {t, "\<a\>"}]]\), ";", 
              "\[IndentingNewLine]", \(Print["\<t           u\>", "\<         \
 \>", "\<t           v\>", "\<           \>", "\<t          a\>"]\), ";", 
              "\[IndentingNewLine]", \
\(Print["\<-------------------------------------------------------------------\
-----\>"]\), ";", 
              "\[IndentingNewLine]", \(Print[
                ColumnForm[posicion1], "\<     \>", 
                ColumnForm[velocidad1], "\<       \>", 
                ColumnForm[aceleracion1]]\), ";"}]}], "\[IndentingNewLine]", 
          "]"}]}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell["\<\
EJEMPLO
a(t)+25 u(t)=50 t
u(0)=0
v(0)=0
Hallar la respuesta hasta el instante tn=1 y con un incremento de tiempo \
to=0.1.La soluci\[OAcute]n exacta es
u(t)=2\[CenterDot]t-2\[CenterDot]Sin (5 t)/5\
\>", "Subsection"],

Cell[BoxData[{
    \(\[IndentingNewLine]\(p[t_] := 50\ t;\)\), "\[IndentingNewLine]", 
    \(Hilberg[0, 1, 0.01, 0, 0, 25, 1, 0, p, 0.5, 0.1666666667, \(-0.1\), 
      posicion, velocidad, aceleracion]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Representaci\[OAcute]n de la soluci\[OAcute]n exacta (negra),con la \
aproximada (roja).\
\>", "Subsection"],

Cell[BoxData[{
    \(\[IndentingNewLine]\(exacta = 
        Plot[2\ t - 2\ Sin[5\ t]/5, {t, 0, 1}, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(a = 
        Interpolation[posicion, 
          InterpolationOrder \[Rule] 1];\)\), "\[IndentingNewLine]", 
    \(\(gu = 
        Plot[a[t], {t, 0, 1}, 
          PlotStyle \[Rule] RGBColor[1, 0, 0]];\)\)}], "Input"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(Show[gu, exacta];\)\)\)], "Input"]
}, Open  ]],

Cell["\<\
EJEMPLO:0.2533\[CenterDot]a(t)+0.1589\[CenterDot]v(t)+10\[CenterDot]u(t)=p(t)
u(0)=0
v(0)=0
p(t)={{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},{.7,0},{.8,0},{.\
9,0},{1,0}}
queremos la respuesta hasta el instante tn=1,con un incremento de tiempo de \
to=0.1.\
\>", "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Este es un caso donde la carga me la dan discretizada,y as\[IAcute] conocemos \
la carga para unos instantes determinados de tiempo.\
\>", "Subsection"],

Cell[BoxData[{
    \(\[IndentingNewLine]\(p = {{0, 0}, { .1, 5}, { .2, 8.66}, { .3, 
            10}, { .4, 8.66}, { .5, 5}, { .6, 0}, { .7, 0}, { .8, 0}, { .9, 
            0}, {1, 0}};\)\), "\[IndentingNewLine]", 
    \(Hilberg[0, 1, 0.01, 0, 0, 10, 0.2533, 0.1589, p, 0.5, 
      0.1666666667, \(-0.1\), posicion, velocidad, aceleracion]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
La soluci\[OAcute]n exacta del desplazamiento \
es:uexac={0.,0.0328,0.2332,0.6487,1.1605,1.5241,1.4814,0.9245,0.0593,-0.7751,-\
1.2718};
La representaci\[OAcute]n de ambas funciones se muestra a \
continuaci\[OAcute]n.\
\>", "Subsection"],

Cell[BoxData[{
    \(\[IndentingNewLine]\(uexac = {0. , 0.0328, 0.2332, 0.6487, 1.1605, 
          1.5241, 1.4814, 0.9245, 
          0.0593, \(-0.7751\), \(-1.2718\)};\)\), "\[IndentingNewLine]", 
    \(\(tm = {0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 
          1};\)\)}], "Input"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\[IndentingNewLine]\)\(For[i = 1, 
        i \[LessEqual] Length[uexac], \(i++\), 
        uexac[\([i]\)] = {tm[\([i]\)], Chop[uexac[\([i]\)]]}];\)\)\)], "Input"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(guexac = 
        Graphics[
          ListPlot[Table[uexac[\([i]\)], {i, 11}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            AxesLabel \[Rule] {t, "\<p\>"}]];\)\)\)], "Input"],

Cell[BoxData[{
    \(\[IndentingNewLine]\(a = 
        Interpolation[posicion, 
          InterpolationOrder \[Rule] 1];\)\), "\[IndentingNewLine]", 
    \(\(gu = 
        Plot[a[t], {t, 0, 1}, 
          PlotStyle \[Rule] RGBColor[1, 0, 0]];\)\)}], "Input"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(Show[gu, guexac];\)\)\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"4.0 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{1016, 651},
WindowMargins->{{51, Automatic}, {-36, Automatic}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 130, 2, 28, "Input"],
Cell[1850, 53, 18252, 444, 1117, "Input"],
Cell[20105, 499, 12425, 220, 2310, "Input"],

Cell[CellGroupData[{
Cell[32555, 723, 226, 8, 142, "Subsection"],
Cell[32784, 733, 215, 3, 70, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33036, 741, 118, 3, 47, "Subsection"],
Cell[33157, 746, 398, 9, 90, "Input"],
Cell[33558, 757, 81, 1, 50, "Input"]
}, Open  ]],
Cell[33654, 761, 298, 8, 123, "Subsection"],

Cell[CellGroupData[{
Cell[33977, 773, 162, 3, 47, "Subsection"],
Cell[34142, 778, 354, 5, 70, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34533, 788, 248, 6, 66, "Subsection"],
Cell[34784, 796, 290, 5, 70, "Input"],
Cell[35077, 803, 209, 3, 70, "Input"],
Cell[35289, 808, 261, 5, 50, "Input"],
Cell[35553, 815, 258, 6, 70, "Input"],
Cell[35814, 823, 81, 1, 50, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

