(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17663,        536]*)
(*NotebookOutlinePosition[     18531,        566]*)
(*  CellTagsIndexPosition[     18487,        562]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["M\[CapitalEAcute]TODO DEL DESARROLLO DE LA CARGA EN SERIE DE FOURIER", \
"Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Vineta BT",
  FontWeight->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
    Cuando la carga aplicada no es arm\[OAcute]nica pero si es \
peri\[OAcute]dica, para hallar la soluci\[OAcute]n de la ecuaci\[OAcute]n del \
movimiento, la carga puede desarrollarse en serie de Fourier, que nos \
proporciona esta como suma de dos t\[EAcute]minos armonicos m\[AAcute]s uno \
constante.
     La soluci\[OAcute]n se obtiene as\[IAcute] por superposici\[OAcute]n de \
las respuestas a cada uno de los t\[EAcute]rminos de la serie,que si que son \
conocidas.
     El problema de este m\[EAcute]todo es que para hallar los \
t\[EAcute]rminos de la serie hay que realizar integrales,que dependiendo del \
tipo de carga pueden llegar a ser muy complicadas.
     Surge as\[IAcute] la necesidad de resolver las integrales \
num\[EAcute]ricamente.Aqu\[IAcute] se ha utilizado el m\[EAcute]todo del \
trapecio. 
     La respuesta aqu\[IAcute] hallada es la permanente, o sea el \
r\[EAcute]gimen transitorio no se ha tenido en cuenta. \
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Explicaci\[OAcute]n del programa", "Subtitle",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Vineta BT",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[1]],

Cell["\<\
Las variables que hay que introducir son las siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo que se utilizar\[AAcute] en la f\[OAcute]rmula del \
trapecio para hallar las integrales.
k=rigidez.
m=masa.
c=coeficiente de amortiguamiento.
t0=periodo de la carga
j=n\[UAcute]mero de t\[EAcute]rminos de la serie que se van a calcular.Se \
recomienda que  t0/to> 8\[CenterDot]j,para no cometer un error excesivo en el \
c\[AAcute]lculo de las integrales.
p=carga..Si la carga se da de forma discreta, hay que dar una lista \
{{t1,p1},{t2,p2},.....,{tn.pn}}, en la que cada pareja de valores es la carga \
 p ,  que hay en el instante  t .
La respuesta aqu\[IAcute] hallada es la permanente, o sea el r\[EAcute]gimen \
transitorio no se ha tenido en cuenta. 
El programa da una tabla con los valores del desplazamiento, velocidad y \
aceleraci\[OAcute]n,en cada 
instante de tiempo junto con su representaci\[OAcute]n gr\[AAcute]fica.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\

Si la carga es conocida de forma discreta, o sea , que conocemos la carga de \
forma exacta en unos instantes de tiempo determinados, se interpola para \
poder tener la carga como una funci\[OAcute]n.
El siguiente programa comprueba si la carga no es una funci\[OAcute]n \
continua, en cuyo caso antes de realizar la interpolaci\[OAcute]n, comprueba \
que la lista tenga valores de carga para instantes de tiempo superiores o \
iguales al instante en que se quiere obtener la respuesta.Si esto no es as\
\[IAcute], o sea se pide la respuesta en un instante \"tn\" que es superior \
al \[UAcute]ltimo instante de tiempo donde se conoce la carga, se supone que \
la carga ha dejado de actuar, y se le asigna el valor cero, para poder \
realizar as\[IAcute] la interpolaci\[OAcute]n.  \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
f=p;
If[Head[p]==List,pa2=p;nn=Length[pa2];
    If[pa2[[nn,1]]+to/1000<tn,
        AppendTo[pa2,{pa1[[nn,1]]+to/1000,0.}];
        AppendTo[pa2,{tn,0.}],
          If[tn>pa2[[nn,1]],AppendTo[pa2,{tn,0.}]]];
          f=Interpolation[pa2,InterpolationOrder->1]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
N\[UAcute]mero de partes en que se divide el periodo de la funci\[OAcute]n \
para realizar
las integrales.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["n1=Floor[t0/to];       ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se hace una tabla con los valores de las frecuencias que tendr\[AAcute]n los \
t\[EAcute]rminos de la serie de Fourier.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["w=Table[2 Pi/t0 i,{i,j}];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Aplicando la f\[OAcute]rmula del trapecio se calculan los terminos de la \
serie de Fourier.
C\[AAcute]lculo del t\[EAcute]rmino constante de la serie. \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
p0=N[(1/n1)(1/2(f[ti]+f[t0])+Sum[f[x],{x,t0/n1,
                                 t0-t0/n1,t0/n1}])];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se calculan los t\[EAcute]rminos que van con el seno y el coseno aplicando el \
trapecio.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
ps=Table[0,{i,j}];
pc=Table[0,{i,j}];
   For[i=1,i<=j,k++,
     ps[[i]]=N[2/n1 (.5(f[ti] Sin[w[[i]] ti]+
                      f[t0] Sin[w[[i]] t0])+
         Sum[f[x] Sin[w[[i]] x],{x,t0/n1,t0-t0/n1,
                                    t0/n1}])];
     pc[[i]]=N[2/n1 (.5(f[ti] Cos[w[[i]] ti]+
                      f[t0] Cos[w[[i]] t0])+
         Sum[f[x] Cos[w[[i]] x],{x,t0/n1,t0-t0/n1,
                                    t0/n1}])]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
C\[AAcute]lculo del desplazamiento \"u1\", que es la combinaci\[OAcute]n de \
las respuestas a cada uno de los t\[EAcute]rminos hallados anteriormente.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
wn=Sqrt[k/m];
s=c/(2 Sqrt[k m]);
s1=2 s/wn;
u1[t_]:=N[p0/k+Sum[(1/ (k((1-(w[[i]]/wn)^2)^2+
       (s1 w[[i]])^2))) ((pc[[i]] s1 w[[i]]+
        ps[[i]] (1-(w[[i]]/wn)^2)) Sin[w[[i]] t]+
       (pc[[i]] (1-(w[[i]]/wn)^2)- 
        ps[[i]] s1 w[[i]]) Cos[w[[i]] t]),{i,1,j,1}]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
La velocidad \"v1\" y aceleraci\[OAcute]n \"a1\" se obtienen por simple \
derivaci\[OAcute]n. \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
v1[t_]:=N[u1'[t]];
a1[t_]:=N[v1'[t]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["La respuesta se va a dar de forma discreta en \"n\" puntos.", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["n=Floor[(tn-ti)/to+1.];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Discretizaci\[OAcute]n del tiempo. ", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["tm=Table[ti+(i-1) to,{i,n}];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Discretizaci\[OAcute]n de \"u\", \"v\", \"a\".", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
u=Table[0.,{i,1,n}];
v=Table[0.,{i,1,n}];
a=Table[0.,{i,1,n}];
  For[i=1,i<=n,i++,
          u[[i]]=N[u1[tm[[i]]]];
          v[[i]]=N[v1[tm[[i]]]];
          a[[i]]=N[a1[tm[[i]]]]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Para \"u\", \"v\"  y  \"a\", se construye una matriz en la que en la fila \"i\
\" aparece el instante de tiempo \"ti\" y la respuesta \"ui\",\"vi\" y \"ai\" \
respectivamente asociada a ese instante. \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Se representan gr\[AAcute]ficamente \"u\", \"v\"  y  \"a\".", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
gu=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
ga=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se realiza una tabla en la que para para cada instante de tiempo aparecen los \
valores de \"u\", \"v\" y \"a\" asociados a este instante.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"]; 
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
El programa anterior se introduce dentro de la orden Block quedando :\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["MetodoFourier", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
posicion;
velocidad;
aceleracion;
MetodoFourier[ti_,tn_,to_,k_,m_,c_,t0_,j_,p_,posicion_,velocidad_,aceleracion_\
]:=
  Block[{f,pa2,nn,n1,w,p0,ps,pc,i,wn,s,s1,u1,
         v1,a1,n,tm,u,v,a,gu,gv,ga},
(*Las variables que hay que introducir son las 
  siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo que se utilizar\[AAcute] en la 
   f\[OAcute]rmula del trapecio para hallar las integrales.
k=rigidez.
m=masa.
c=coeficiente de amortiguamiento.
t0=periodo de la carga
j=n\[UAcute]mero de t\[EAcute]rminos de la serie que se van a 
  calcular.Se recomienda que  t0/to> 8\[CenterDot]j,para no cometer 
  un error excesivo en el c\[AAcute]lculo de las integrales.
p=carga.Si la carga se da de forma discreta, hay que
dar una lista {{t1,p1},{t2,p2},.....,{tn.pn}}, en la
que cada pareja de valores es la carga  p ,  que hay
en el instante  t .
La respuesta aqu\[IAcute] hallada es la permanente, o sea el 
r\[EAcute]gimen transitorio no se ha tenido en cuenta. 
El programa da una tabla con los valores del 
desplazamiento, velocidad y aceleraci\[OAcute]n,en cada instante 
de tiempo junto con su representaci\[OAcute]n gr\[AAcute]fica.*)
f=p;
If[Head[p]==List,pa2=p;nn=Length[pa2];
    If[pa2[[nn,1]]+to/1000<tn,
        AppendTo[pa2,{pa1[[nn,1]]+to/1000,0.}];
        AppendTo[pa2,{tn,0.}],
          If[tn>pa2[[nn,1]],AppendTo[pa2,{tn,0.}]]];
          f=Interpolation[pa2,InterpolationOrder->1]];
n1=Floor[t0/to];       
w=Table[2 Pi/t0 i,{i,j}];
p0=N[(1/n1)(1/2 (f[ti]+f[t0])+Sum[f[x],{x,t0/n1,
                                 t0-t0/n1,t0/n1}])];
ps=Table[0,{i,j}];
pc=Table[0,{i,j}];
   For[i=1,i<=j,i++,
     ps[[i]]=N[2/n1 (.5(f[ti] Sin[w[[i]] ti]+
                      f[t0] Sin[w[[i]] t0])+
         Sum[f[x] Sin[w[[i]] x],{x,t0/n1,t0-t0/n1,
                                    t0/n1}])];
     pc[[i]]=N[2/n1 (.5(f[ti] Cos[w[[i]] ti]+
                      f[t0] Cos[w[[i]] t0])+
         Sum[f[x] Cos[w[[i]] x],{x,t0/n1,t0-t0/n1,
                                    t0/n1}])]];
wn=Sqrt[k/m];
s=c/(2 Sqrt[k m]);
s1=2 s/wn;
u1[t_]:=N[p0/k+Sum[(1/ (k((1-(w[[i]]/wn)^2)^2+
       (s1 w[[i]])^2))) ((pc[[i]] s1 w[[i]]+
        ps[[i]] (1-(w[[i]]/wn)^2)) Sin[w[[i]] t]+
       (pc[[i]] (1-(w[[i]]/wn)^2)- 
        ps[[i]] s1 w[[i]]) Cos[w[[i]] t]),{i,1,j,1}]];
v1[t_]:=N[u1'[t]];
a1[t_]:=N[v1'[t]];
n=Floor[(tn-ti)/to+1.];
tm=Table[ti+(i-1) to,{i,n}];
u=Table[0.,{i,1,n}];
v=Table[0.,{i,1,n}];
a=Table[0.,{i,1,n}];
  For[i=1,i<=n,i++,
          u[[i]]=N[u1[tm[[i]]]];
          v[[i]]=N[v1[tm[[i]]]];
          a[[i]]=N[a1[tm[[i]]]]];
    For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];
posicion=u;
velocidad=v;
aceleracion=a;
gu=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
ga=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"]; 
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO

4 a( t ) + 10 u( t ) = Sin( t )
y queremos la respuesta hasta el instante tn=2, con un incremento de tiempo \
de to=.2, cojiendo solo el primer  t\[EAcute]rmino de la serie.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["p[t_]:=Sin[t]; ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
MetodoFourier[0,2,.2,10,4,0,N[2 Pi],1,p,posicion,velocidad,aceleracion] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
La soluci\[OAcute]n exacta es 
u( t ) =( 1/6 ) Sin( t ) 
y la comparaci\[OAcute]n entre la respuesta exacta ( negra ) y la aproximada \
( roja ),
se muestra a continuaci\[OAcute]n. \
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
exacta=Plot[(1/6) Sin[t],{t,0,2},
             DisplayFunction->Identity]; \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["Show[gu,exacta]; ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{793, 599},
WindowMargins->{{-3, Automatic}, {Automatic, 23}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 269, 7, 276, "Title"],
Cell[1989, 58, 1035, 19, 215, "Subsection"],
Cell[3027, 79, 220, 6, 85, "Subtitle"],
Cell[3250, 87, 1113, 25, 296, "Text"],
Cell[4366, 114, 940, 17, 163, "Text"],
Cell[5309, 133, 399, 12, 154, "Input"],
Cell[5711, 147, 263, 8, 68, "Text"],
Cell[5977, 157, 153, 4, 46, "Input"],
Cell[6133, 163, 276, 7, 49, "Text"],
Cell[6412, 172, 155, 4, 46, "Input"],
Cell[6570, 178, 309, 8, 68, "Text"],
Cell[6882, 188, 238, 7, 64, "Input"],
Cell[7123, 197, 246, 7, 49, "Text"],
Cell[7372, 206, 575, 16, 226, "Input"],
Cell[7950, 224, 308, 7, 49, "Text"],
Cell[8261, 233, 414, 13, 172, "Input"],
Cell[8678, 248, 251, 7, 49, "Text"],
Cell[8932, 257, 175, 7, 64, "Input"],
Cell[9110, 266, 208, 4, 49, "Text"],
Cell[9321, 272, 153, 4, 46, "Input"],
Cell[9477, 278, 184, 4, 49, "Text"],
Cell[9664, 284, 158, 4, 46, "Input"],
Cell[9825, 290, 195, 4, 49, "Text"],
Cell[10023, 296, 320, 12, 154, "Input"],
Cell[10346, 310, 357, 8, 68, "Text"],
Cell[10706, 320, 270, 9, 100, "Input"],
Cell[10979, 331, 208, 4, 49, "Text"],
Cell[11190, 337, 653, 17, 244, "Input"],
Cell[11846, 356, 295, 7, 49, "Text"],
Cell[12144, 365, 399, 11, 136, "Input"],
Cell[12546, 378, 226, 6, 49, "Text"],
Cell[12775, 386, 116, 3, 121, "Title"],
Cell[12894, 391, 3658, 100, 1720, "Input"],
Cell[16555, 493, 273, 8, 139, "Subsection"],
Cell[16831, 503, 88, 2, 30, "Input"],
Cell[16922, 507, 210, 6, 46, "Input"],
Cell[17135, 515, 272, 8, 120, "Subsection"],
Cell[17410, 525, 156, 5, 48, "Input"],
Cell[17569, 532, 90, 2, 30, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

