(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     23701,        785]*)
(*NotebookOutlinePosition[     24567,        815]*)
(*  CellTagsIndexPosition[     24523,        811]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["INTEGRAL DE DUHAMEL", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Vineta BT",
  FontSize->28,
  FontWeight->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
    La integral de Duhamel me da la soluci\[OAcute]n como la integral entre 0 \
y t del producto 
       
p(tau)\[CenterDot]h(t-tau)
      
donde tau es una variable que recorre t.
 
h(t-tau)=(1/(m\[CenterDot]wd))\[CenterDot]Exp[-s\[CenterDot]wn\[CenterDot](t-\
tau)]\[CenterDot]Sin(wd\[CenterDot](t-tau))
 s=c/(2\[CenterDot]Sqrt[m\[CenterDot]k])
 p(tau) es la carga evaluada en el instante tau.

La velocidad puede hallarse por simple derivaci\[OAcute]n de la integral de \
Duhamel, y la aceleraci\[OAcute]n a trav\[EAcute]s de la ecuaci\[OAcute]n del \
movimiento.

    La integral de Duhamel me da la soluci\[OAcute]n cuando tenemos \
condiciones iniciales nulas.
    En general es dif\[IAcute]cil calcular la integral,por lo que recurrimos \
ha hacerla num\[EAcute]ricamente.Aqu\[IAcute] se han aplicado los \
m\[EAcute]todos de Simpson y el del trapecio.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Explicaci\[OAcute]n del programa", "Subtitle",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Vineta BT",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[1]],

Cell["\<\
Las variables que hay que introducir son las siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo.
k=rigidez.
m=masa.
c=coeficiente de amortiguamiento.
p=carga..Si la carga se da de forma discreta, hay que dar una lista \
{{t1,p1},{t2,p2},.....,{tn.pn}}, en la que cada pareja de valores es la carga \
 p ,  que hay en el instante  t .
El programa da una tabla con los valores del desplazamiento, velocidad y \
aceleraci\[OAcute]n,en cada 
instante de tiempo junto con su representaci\[OAcute]n gr\[AAcute]fica.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
C\[AAcute]lculo del n\[UAcute]mero de puntos en los que se va a obtener la \
respuesta\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["n=Floor[(tn-ti)/to+1.];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
 Como la soluci\[OAcute]n se va hallando paso a paso  para cada instante de \
tiempo, hemos de discretizar la carga \"p\",  para tener los valores de ella \
en cada instante en el que va a ser calculada la respuesta.
Cuando la carga venga dada como una funci\[OAcute]n contin\[UAcute]a,  la \
discretizaci\[OAcute]n consiste simplemente en evaluar la funci\[OAcute]n \
para los instantes de tiempo en que vamos a obtener la respuesta.
Si la carga es conocida de forma discreta, o sea , que conocemos la carga de \
forma exacta en unos instantes de tiempo determinados, construiremos una \
funci\[OAcute]n \"pa1\", que ser\[AAcute] la que discretizaremos.
El siguiente programa comprueba si la carga no es una funci\[OAcute]n \
continua, en cuyo caso antes de realizar la interpolaci\[OAcute]n, comprueba \
que la lista tenga valores de carga para instantes de tiempo superiores o \
iguales al instante en que se quiere obtener la respuesta.Si esto no es as\
\[IAcute], o sea se pide la respuesta en un instante \"tn\" que es superior \
al \[UAcute]ltimo instante de tiempo donde se conoce la carga, se supone que \
la carga ha dejado de actuar, y se le asigna el valor cero, para poder \
realizar as\[IAcute] la interpolaci\[OAcute]n.  \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
pa=p;
If[Head[pa]==List,nn=Length[pa];
    If[pa[[nn,1]]+to/1000<tn,
        AppendTo[pa,{pa[[nn,1]]+to/1000,0.}];
        AppendTo[pa,{tn,0.}],
        If[tn>pa[[nn,1]],AppendTo[pa,{tn,0.}]]];
    pa=Interpolation[pa,InterpolationOrder->1]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se inicializan los vectores de desplazamiento  \"u\", velocidad  \"v\"  y \
aceleraci\[OAcute]n \"a\".\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
wn=N[Sqrt[k/m]];
s=N[c/(2 Sqrt[m k])];
wd=N[wn Sqrt[1-s^2]];
u=Table[0.,{i,1.,n}];
v=Table[0.,{i,1.,n}];
a=Table[0.,{i,1.,n}];
b=d=0.;\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se aplica el m\[EAcute]todo de Simpson, para el c\[AAcute]lculo de la \
integral.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
For[i=1.,i<n,i=i+1.,
    t1=N[ti+(i-1) to];
    t3=N[t1+to];
    t2=N[(t1+t3)/2];
    e3=N[Exp[s wn t3]];
    e2=N[Exp[s wn t2]];
    e1=N[Exp[s wn t1]];
    f3=N[pa[t3] e3];
    f2=N[pa[t2] e2];
    f1=N[pa[t1] e1];
    cos3=N[Cos[wd t3]];
    cos2=N[Cos[wd t2]];
    cos1=N[Cos[wd t1]];
    sin3=N[Sin[wd t3]];
    sin2=N[Sin[wd t2]];
    sin1=N[Sin[wd t1]];
      b=N[b+(to/6.) (f1 cos1+f3 cos3+4. f2 cos2)];
      d=N[d+(to/6.) (f1 sin1+f3 sin3+4. f2 sin2)];
      u[[i+1]]=N[(1/(m wd e3))*(Sin[wd t3]*b-
                                Cos[wd t3]*d)];
      v[[i+1]]=N[(1/(m wd e3)) ((wd Cos[wd t3]-
       s wn Sin[wd t3]) b+(s wn Cos[wd t3]+
       wd Sin[wd t3]) d)];
       a[[i+1]]=N[(pa[t2]-c v[[i+1]]-k u[[i+1]])/m]]; \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Discretizaci\[OAcute]n del tiempo en los instantes en que quiero la \
respuesta.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["tm=Table[ti+(i-1) to,{i,n}];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Para \"u\", \"v\"  y  \"a\", se construye una matriz en la que en la fila \"i\
\" aparece el instante de tiempo \"ti\" y la respuesta \"ui\",\"vi\" y \"ai\" \
respectivamente asociada a ese instante. \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Se representan gr\[AAcute]ficamente \"u\", \"v\"  y  \"a\".", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
gu=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
ga=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se realiza una tabla en la que para para cada instante de tiempo aparecen los \
valores de \"u\", \"v\" y \"a\" asociados a este instante.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"]; 
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
El programa anterior se introduce dentro de la orden Block quedando :\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["DuhamelSimpson", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
posicion;
velocidad;
aceleracion;
DuhamelSimpson[ti_,tn_,to_,k_,m_,c_,p_,posicion_,velocidad_,aceleracion_]:=
  Block[{pa,nn,n,wn,s,wd,u,v,a,b,d,i,t1,t2,
         t3,e2,e3,e1,f3,f2,f1,cos1,cos2,cos3,
         sin1,sin2,sin3,tm,gu,gv,ga},
(*Las variables que hay que introducir son las 
 siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo.
k=rigidez.
m=masa.
c=coeficiente de amortiguamiento.
p=carga.Si la carga se da de forma discreta, hay 
que dar una lista {{t1,p1},{t2,p2},.....,{tn.pn}},
en la que cada pareja de valores es la carga  p , 
que hay en el instante  t .
El programa da una tabla con los valores del 
desplazamiento, velocidad y aceleraci\[OAcute]n,en cada instante 
de tiempo junto con su representaci\[OAcute]n gr\[AAcute]fica.*)
pa=p;
If[Head[pa]==List,nn=Length[pa];
    If[pa[[nn,1]]+to/1000<tn,
        AppendTo[pa,{pa[[nn,1]]+to/1000,0.}];
        AppendTo[pa,{tn,0.}],
        If[tn>pa[[nn,1]],AppendTo[pa,{tn,0.}]]];
    pa=Interpolation[pa,InterpolationOrder->1]];
n=Floor[(tn-ti)/to+1.];
wn=N[Sqrt[k/m]];
s=N[c/(2 Sqrt[m k])];
wd=N[wn Sqrt[1-s^2]];
u=Table[0.,{i,1.,n}];
v=Table[0.,{i,1.,n}];
a=Table[0.,{i,1.,n}];
b=d=0.;
For[i=1.,i<n,i=i+1.,
    t1=N[ti+(i-1) to];
    t3=N[t1+to];
    t2=N[(t1+t3)/2];
    e3=N[Exp[s wn t3]];
    e2=N[Exp[s wn t2]];
    e1=N[Exp[s wn t1]];
    f3=N[pa[t3] e3];
    f2=N[pa[t2] e2];
    f1=N[pa[t1] e1];
    cos3=N[Cos[wd t3]];
    cos2=N[Cos[wd t2]];
    cos1=N[Cos[wd t1]];
    sin3=N[Sin[wd t3]];
    sin2=N[Sin[wd t2]];
    sin1=N[Sin[wd t1]];
      b=N[b+(to/6.) (f1 cos1+f3 cos3+4. f2 cos2)];
      d=N[d+(to/6.) (f1 sin1+f3 sin3+4. f2 sin2)];
      u[[i+1]]=N[(1/(m wd e3))*(Sin[wd t3]*b-
                                Cos[wd t3]*d)];
      v[[i+1]]=N[(1/(m wd e3)) ((wd Cos[wd t3]-
       s wn Sin[wd t3]) b+(s wn Cos[wd t3]+
       wd Sin[wd t3]) d)];
       a[[i+1]]=N[(pa[t2]-c v[[i+1]]-k u[[i+1]])/m]]; 
tm=Table[ti+(i-1) to,{i,n}];
For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];
posicion=u;
velocidad=v;
aceleracion=a;
gu=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
gv=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"]; 
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["DuhamelTrapecio", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
posicion;
velocidad;
aceleracion;
DuhamelTrapecio[ti_,tn_,to_,k_,m_,c_,p_,posicion_,velocidad_,aceleracion_]:=
  Block[{pa,nn,n,wn,s,wd,u,v,a,b,d,i,t1,t2,e1,
         e2,f1,f2,cos1,cos2,sin1,sin2,fc1,fc2,
         fs1,fs2,s1,b1,d1,e3,tm,gu1,gv1,ga1},  
(*Las variables que hay que introducir son las 
   siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo.
k=rigidez.
m=masa.
c=coeficiente de amortiguamiento.
p=carga.Si la carga se da de forma discreta, hay que 
dar una lista {{t1,p1},{t2,p2},.....,{tn.pn}}, en la 
que cada pareja de valores es la carga  p ,  que hay 
en el instante  t .
El programa da una tabla con los valores del 
desplazamiento, velocidad y aceleraci\[OAcute]n,en cada instante 
de tiempo junto con su representaci\[OAcute]n gr\[AAcute]fica.*)
pa=p;
If[Head[pa]==List,nn=Length[pa];
    If[pa[[nn,1]]+to/1000<tn,
        AppendTo[pa,{pa[[nn,1]]+to/1000,0.}];
        AppendTo[pa,{tn,0.}],
        If[tn>pa[[nn,1]],AppendTo[pa,{tn,0.}]]];
    pa=Interpolation[pa,InterpolationOrder->1]];
n=Floor[(tn-ti)/to+1.];
wn=N[Sqrt[k/m]];
s=N[c/(2 Sqrt[m k])];
wd=N[wn Sqrt[1-s^2]];
u=Table[0.,{i,1.,n}];
v=Table[0.,{i,1,n}];
a=Table[0.,{i,1,n}];
b=d=0.;
For[i=1,i<n,i++,
   t1=N[ti+(i-1) to];
   t2=N[t1+to];
   e2=N[Exp[s wn t2]];
   e1=N[Exp[s wn t1]];
   f2=N[pa[t2] e2];
   f1=N[pa[t1] e1];
   cos2=N[Cos[wd t2]];
   cos1=N[Cos[wd t1]];
   sin2=N[Sin[wd t2]];
   sin1=N[Sin[wd t1]];
   fc2=N[f2 cos2];
   fc1=N[f1 cos1];
   fs2=N[f2 sin2];
   fs1=N[f1 sin1];
   s1=N[s wn];
   b1=N[b sin2];
   d1=N[d cos2];
   e3=N[m wd e2];
     b=N[b+(to/2) (fc2+fc1)];
     d=N[d+(to/2) (fs2+fs1)];
     u[[i+1]]=N[(1/e3) (sin2 b-cos2 d)];
     v[[i+1]]=N[(1/e3) (wd cos2 b-s1 b1+
                        wd sin2 d+s1 d1)];
     a[[i+1]]=N[(pa[t2]-c v[[i+1]]-k u[[i+1]])/m]]; 
tm=Table[ti+(i-1) to,{i,n}];
For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];
posicion=u:
velocidad=v;
aceleracion=a;
gu1=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv1=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
ga1=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"]; 
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO

a( t )  +25  u( t ) = 50 t
u( 0 ) = 0
v( 0 ) = 0

Hallar la respuesta hasta el instante tn=1 y con un incremento de tiempo \
to=0.1.
La soluci\[OAcute]n exacta es
 
u( t ) = 2\[CenterDot]t - 2\[CenterDot]Sin (5  t )/5\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Primero resolvemos por el trapecio.", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Clear[\"Global`*\"] ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["p[t_]:=50 t; ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
DuhamelTrapecio[0,1,.1,25,1,0,p,posicion,velocidad,aceleracion] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Representaci\[OAcute]n de la soluci\[OAcute]n exacta ( negra ),
con la aproximada ( roja ).\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
exacta=Plot[2 t-2 Sin[5 t]/5,{t,0,1},
              DisplayFunction->Identity];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["Show[gu1,exacta];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Ahora aplicamos el m\[EAcute]todo de Simpson", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]]
}, Open  ]],

Cell["\<\
DuhamelSimpson[0,1,.1,25,1,0,p,posicion,velocidad,aceleracion]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
A continuaci\[OAcute]n se representa la soluci\[OAcute]n exacta y la dada por \
Simpson, pudi\[EAcute]ndose comprobar que Simpson ofrece una mejor aproximaci\
\[OAcute]n que el Trapecio.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Show[gu,exacta];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO:

0.2533\[CenterDot]a( t ) +0.1589\[CenterDot] v( t ) +10\[CenterDot] u( t ) = \
p( t )  
u( 0 )=0
v( 0 )=0
p( t ) = {{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
              {.7,0},{.8,0},{.9,0},{1,0}}

queremos la respuesta hasta el instante tn=1, con un incremento de tiempo de \
to=0.1, utilizando el m\[EAcute]todo del trapecio.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
Este es un caso donde la carga me la dan discretizada,y as\[IAcute] conocemos \
la carga para unos instantes determinados de tiempo.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
p={{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
    {.7,0},{.8,0},{.9,0},{1,0}}; \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
DuhamelTrapecio[0,1,.1,10,.2533,.1589,p,posicion,velocidad,aceleracion] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\

La soluci\[OAcute]n exacta del desplazamiento es:

uexac = { 0.,0.0328,0.2332,0.6487,1.1605,1.5241,1.4814,
       0.9245,0.0593,-0.7751,-1.2718 }; 

La representaci\[OAcute]n de ambas funciones se muestra a \
continuaci\[OAcute]n.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
uexac = { 0.,0.0328,0.2332,0.6487,1.1605,1.5241,1.4814, 
           0.9245,0.0593,-0.7751,-1.2718 }; \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
For[i=1,i<=n,i++,
       uexac[[i]]={tm[[i]],Chop[uexac[[i]]]}];  \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
guexac=Graphics[ListPlot[ Table[uexac[[i]],{i,n}],                 
           PlotJoined->True,
           DisplayFunction->Identity,
           AxesLabel->{t,\"p\"}]];  \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Show[gu1,guexac];  ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO:

0.2533\[CenterDot]a( t ) +0.1589\[CenterDot] v( t ) +10\[CenterDot] u( t ) = \
p( t )  
u( 0 )=0
v( 0 )=0
p( t ) = {{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
              {.7,0},{.8,0},{.9,0},{1,0}}

queremos la respuesta hasta el instante tn=1, con un incremento de tiempo de \
to=0.1, utilizando el m\[EAcute]todo de Simpson.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
Este es un caso donde la carga me la dan discretizada,y as\[IAcute] conocemos \
la carga para unos instantes determinados de tiempo.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
p={{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
    {.7,0},{.8,0},{.9,0},{1,0}};  \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
DuhamelSimpson[0,1,.1,10,.2533,.1589,p,posicion,velocidad,aceleracion]  \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\

La soluci\[OAcute]n exacta del desplazamiento es:

uexac = { 0.,0.0328,0.2332,0.6487,1.1605,1.5241,1.4814,
       0.9245,0.0593,-0.7751,-1.2718 }; 

La representaci\[OAcute]n de ambas funciones se muestra a \
continuaci\[OAcute]n.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
uexac = { 0.,0.0328,0.2332,0.6487,1.1605,1.5241,1.4814, 
           0.9245,0.0593,-0.7751,-1.2718 };  \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
For[i=1,i<=n,i++,
       uexac[[i]]={tm[[i]],Chop[uexac[[i]]]}];   \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
guexac=Graphics[ListPlot[ Table[uexac[[i]],{i,n}],                 
           PlotJoined->True,
           DisplayFunction->Identity,
           AxesLabel->{t,\"p\"}]];   \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Show[gu,guexac];   ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{952, 599},
WindowMargins->{{Automatic, 9}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 234, 7, 116, "Title"],
Cell[1954, 58, 950, 24, 329, "Subsection"],
Cell[2907, 84, 220, 6, 85, "Subtitle"],
Cell[3130, 92, 691, 18, 220, "Text"],
Cell[3824, 112, 243, 7, 49, "Text"],
Cell[4070, 121, 153, 4, 46, "Input"],
Cell[4226, 127, 1393, 22, 182, "Text"],
Cell[5622, 151, 380, 12, 154, "Input"],
Cell[6005, 165, 259, 7, 49, "Text"],
Cell[6267, 174, 272, 12, 154, "Input"],
Cell[6542, 188, 238, 7, 49, "Text"],
Cell[6783, 197, 868, 29, 460, "Input"],
Cell[7654, 228, 237, 7, 49, "Text"],
Cell[7894, 237, 158, 4, 46, "Input"],
Cell[8055, 243, 357, 8, 49, "Text"],
Cell[8415, 253, 270, 9, 100, "Input"],
Cell[8688, 264, 208, 4, 49, "Text"],
Cell[8899, 270, 653, 17, 244, "Input"],
Cell[9555, 289, 295, 7, 49, "Text"],
Cell[9853, 298, 399, 11, 136, "Input"],
Cell[10255, 311, 226, 6, 49, "Text"],
Cell[10484, 319, 117, 3, 121, "Title"],
Cell[10604, 324, 3026, 92, 1594, "Input"],
Cell[13633, 418, 118, 3, 121, "Title"],
Cell[13754, 423, 2929, 93, 1612, "Input"],
Cell[16686, 518, 317, 14, 234, "Subsection"],
Cell[17006, 534, 118, 2, 63, "Subsection"],
Cell[17127, 538, 150, 4, 46, "Input"],
Cell[17280, 544, 143, 4, 46, "Input"],
Cell[17426, 550, 202, 6, 46, "Input"],
Cell[17631, 558, 182, 5, 82, "Subsection"],
Cell[17816, 565, 217, 7, 64, "Input"],

Cell[CellGroupData[{
Cell[18058, 576, 147, 4, 46, "Input"],
Cell[18208, 582, 127, 2, 63, "Subsection"]
}, Open  ]],
Cell[18350, 587, 200, 6, 46, "Input"],
Cell[18553, 595, 277, 6, 82, "Subsection"],
Cell[18833, 603, 146, 4, 46, "Input"],
Cell[18982, 609, 445, 14, 215, "Subsection"],
Cell[19430, 625, 223, 5, 63, "Subsection"],
Cell[19656, 632, 230, 7, 64, "Input"],
Cell[19889, 641, 210, 6, 46, "Input"],
Cell[20102, 649, 322, 11, 177, "Subsection"],
Cell[20427, 662, 239, 7, 64, "Input"],
Cell[20669, 671, 204, 7, 64, "Input"],
Cell[20876, 680, 309, 9, 100, "Input"],
Cell[21188, 691, 149, 4, 46, "Input"],
Cell[21340, 697, 443, 14, 215, "Subsection"],
Cell[21786, 713, 223, 5, 63, "Subsection"],
Cell[22012, 720, 231, 7, 64, "Input"],
Cell[22246, 729, 210, 6, 46, "Input"],
Cell[22459, 737, 322, 11, 177, "Subsection"],
Cell[22784, 750, 240, 7, 64, "Input"],
Cell[23027, 759, 205, 7, 64, "Input"],
Cell[23235, 768, 310, 9, 100, "Input"],
Cell[23548, 779, 149, 4, 46, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

