(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     18583,        608]*)
(*NotebookOutlinePosition[     19451,        638]*)
(*  CellTagsIndexPosition[     19407,        634]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["M\[CapitalEAcute]TODO DE LAS DlFERENCIAS CENTRALES", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Vineta BT",
  FontWeight->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
Los m\[EAcute]todos diferenciales son los que se basan en aproximar la ecuaci\
\[OAcute]n diferencial por diferencias finitas,es decir aproximar la derivada \
por incrementos.
      El m\[EAcute]todo de las diferencias centrales utiliza las
siguientes expresiones:

vi=(ui+1 - ui-1)/(2\[CenterDot](ti+1 - ti)) 
ai=(ui+1 - 2\[CenterDot]ui + ui-1)/((ti+1 - ti)^2)

      Sustituyendo estas expresiones en la ecuaci\[OAcute]n 
del movimiento 

m\[CenterDot]ai  +  c\[CenterDot]vi  +  k\[CenterDot]ui  =  pi

se obtiene la soluci\[OAcute]n:

ui+1 = (pi  -  a1\[CenterDot]ui-1  -  b1\[CenterDot]ui)/k1   siendo
a1 = m/(to^2) - (c/(2 to))
b1 = k - 2 m/(to^2)
k1 = m/(to^2) + c/(2 to)\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Explicaci\[OAcute]n del programa", "Subtitle",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Vineta BT",
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[1]],

Cell["\<\
Las variables que hay que introducir son las siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo.
u0=desplazamiento en el instante ti.
v0=velocidad en el instante ti.
k=rigidez.
m=masa.
c=coeficiente de amortiguamiento.
p=carga..Si la carga se da de forma discreta, hay que dar una lista \
{{t1,p1},{t2,p2},.....,{tn.pn}}, en la que cada pareja de valores es la carga \
 p ,  que hay en el instante  t .
El programa da una tabla con los valores del desplazamiento, velocidad y \
aceleraci\[OAcute]n,en cada 
instante de tiempo junto con su representaci\[OAcute]n gr\[AAcute]fica.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
C\[AAcute]lculo del n\[UAcute]mero de puntos en los que se va a obtener la \
respuesta\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["n=Floor[(tn-ti)/to+1.];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
 Como la soluci\[OAcute]n se va hallando paso a paso  para cada instante de \
tiempo, hemos de discretizar la carga \"p\",  para tener los valores de ella \
en cada instante en el que va a ser calculada la respuesta.
Cuando la carga venga dada como una funci\[OAcute]n contin\[UAcute]a,  la \
discretizaci\[OAcute]n consiste simplemente en evaluar la funci\[OAcute]n \
para los instantes de tiempo en que vamos a obtener la respuesta.
Si la carga es conocida de forma discreta, o sea , que conocemos la carga de \
forma exacta en unos instantes de tiempo determinados, construiremos una \
funci\[OAcute]n \"pa1\", que ser\[AAcute] la que discretizaremos.
El siguiente programa comprueba si la carga no es una funci\[OAcute]n \
continua, en cuyo caso antes de realizar la interpolaci\[OAcute]n, comprueba \
que la lista tenga valores de carga para instantes de tiempo superiores o \
iguales al instante en que se quiere obtener la respuesta.Si esto no es as\
\[IAcute], o sea se pide la respuesta en un instante \"tn\" que es superior \
al \[UAcute]ltimo instante de tiempo donde se conoce la carga, se supone que \
la carga ha dejado de actuar, y se le asigna el valor cero, para poder \
realizar as\[IAcute] la interpolaci\[OAcute]n.  \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
pa1=p;
If[Head[p]==List,pa2=p;nn=Length[pa2];
    If[pa2[[nn,1]]+to/1000<tn,
        AppendTo[pa2,{pa1[[nn,1]]+to/1000,0.}];
        AppendTo[pa2,{tn,0.}],
          If[tn>pa2[[nn,1]],AppendTo[pa2,{tn,0.}]]];
          pa1=Interpolation[pa2,InterpolationOrder->1]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Discretizaci\[OAcute]n de la carga.", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
pa=Table[0,{i,1,n}];
For[i=1,i<=n,i++,
     pa[[i]]=N[pa1[(ti+(i-1)to)]]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se inicializan los vectores de desplazamiento  \"u\", velocidad  \"v\"  y \
aceleraci\[OAcute]n \"a\".\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
u=Table[u0,{i,1,n}];
v=Table[v0,{i,1,n}];
a=Table[0.,{i,1,n}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
 A trav\[EAcute]s de la ecuaci\[OAcute]n del movimiento se calcula la \
aceleraci\[OAcute]n para el instante inicial \"ti\".\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["a[[1]]=(pa[[1]]-k u[[1]]-c v[[1]])/m;", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["C\[AAcute]lculo del desplazamiento anterior al inicial.", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["uo=N[u[[1]]-v0 to];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
A continuaci\[OAcute]n se calculan una serie de t\[EAcute]rminos que ser\
\[AAcute] necesarios para obtener la soluci\[OAcute]n.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
a1=m/(to^2)-(c/(2 to));
b1=k-2 m/(to^2);
k1=m/(to^2)+c/(2 to);\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["C\[AAcute]lculo del desplazamiento posterior al inicial.", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
u[[2]]=N[(pa[[1]]-a1 uo-
          b1 u[[1]])/(m/(to^2)+c/(2 to))];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Discretizaci\[OAcute]n del tiempo en los instantes en que quiero la \
respuesta.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["tm=Table[ti+(i-1) to,{i,n}];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["C\[AAcute]lculo de \"u\", \"v\"  y  \"a\".", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
For[i=3,i<=n,i++,
         u[[i]]=N[(pa[[i-1]]-a1 u[[i-2]]-
                   b1 u[[i-1]])/k1];
         v[[i-1]]=N[(u[[i]]-u[[i-2]])/(2 to)];
         a[[i-1]]=N[(pa[[i-1]]-c v[[i-1]]-k u[[i-1]])/m]];
v[[n]]=N[(u[[n]]-u[[n-1]])/to];
a[[n]]=N[(pa[[n]]-c v[[n]]-k u[[n]])/m];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Para \"u\", \"v\"  y  \"a\", se construye una matriz en la que en la fila \"i\
\" aparece el instante de tiempo \"ti\" y la respuesta \"ui\",\"vi\" y \"ai\" \
respectivamente asociada a ese instante. \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Se representan gr\[AAcute]ficamente \"u\", \"v\"  y  \"a\".", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
gu=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
ga=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se realiza una tabla en la que para para cada instante de tiempo aparecen los \
valores de \"u\", \"v\" y \"a\" asociados a este instante.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"]; 
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
El programa anterior se introduce dentro de la orden Block quedando :\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Times New Roman",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["DiferenciaCentral", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
posicion;
velocidad;
aceleracion;
DiferenciaCentral[ti_,tn_,to_,u0_,v0_,k_,m_,c_,p_,posicion_,velocidad_,\
aceleracion_]:=
  Block[{n,pa1,pa2,nn,pa,i,u,v,a,uo,a1,b1,
         k1,tm,gu,gv,ga},
(*Las variables que hay que introducir son 
las siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo.
u0=desplazamiento en el instante ti.
v0=velocidad en el instante ti.
k=rigidez.
m=masa.
c=coeficiente de amortiguamiento.
p=carga.Si la carga se da de forma discreta, hay 
que dar una lista {{t1,p1},{t2,p2},.....,{tn.pn}}, 
en la que cada pareja de valores es la carga  p ,  
que hay en el instante  t .
El programa da una tabla con los valores del 
desplazamiento, velocidad y aceleraci\[OAcute]n,en cada 
instante de tiempo junto con su representaci\[OAcute]n
gr\[AAcute]fica *)
n=Floor[(tn-ti)/to+1.];
pa1=p;
If[Head[p]==List,pa2=p;nn=Length[pa2];
    If[pa2[[nn,1]]+to/1000<tn,
        AppendTo[pa2,{pa1[[nn,1]]+to/1000,0.}];
        AppendTo[pa2,{tn,0.}],
          If[tn>pa2[[nn,1]],AppendTo[pa2,{tn,0.}]]];
          pa1=Interpolation[pa2,InterpolationOrder->1]];
pa=Table[0,{i,1,n}];
For[i=1,i<=n,i++,
     pa[[i]]=N[pa1[(ti+(i-1)to)]]];
u=Table[u0,{i,1,n}];
v=Table[v0,{i,1,n}];
a=Table[0.,{i,1,n}];
a[[1]]=N[(pa[[1]]-k u0-c v0)/m];
uo=N[u[[1]]-v0 to];
a1=m/(to^2)-(c/(2 to));
b1=k-2 m/(to^2);
k1=m/(to^2)+c/(2 to);
u[[2]]=N[(pa[[1]]-(m/(to^2)-(c/(2 to)))uo-
        (k-2 m/(to^2)) u[[1]])/(m/(to^2)+c/(2 to))];
tm=Table[ti+(i-1) to,{i,n}];
  For[i=3,i<=n,i++,
         u[[i]]=N[(pa[[i-1]]-a1 u[[i-2]]-
                   b1 u[[i-1]])/k1];
         v[[i-1]]=N[(u[[i]]-u[[i-2]])/(2 to)];
         a[[i-1]]=N[(pa[[i-1]]-c v[[i-1]]-k u[[i-1]])/m]];
v[[n]]=N[(u[[n]]-u[[n-1]])/to];
a[[n]]=N[(pa[[n]]-c v[[n]]-k u[[n]])/m];
     For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];
posicion=u;
velocidad=v;
aceleracion=a;
gu=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
ga=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"]; 
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO

a( t )  +25  u( t ) = 50 t
u( 0 ) = 0
v( 0 ) = 0

Hallar la respuesta hasta el instante tn=1 y con un incremento de tiempo \
to=0.1.
La soluci\[OAcute]n exacta es
 
u( t ) = 2\[CenterDot]t - 2\[CenterDot]Sin (5  t )/5\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Clear[\"Global`*\"] ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["p[t_]:=50 t;", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
DiferenciaCentral[0,1,0.1,0,0,25,1,0,p,posicion,velocidad,aceleracion]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Representaci\[OAcute]n de la soluci\[OAcute]n exacta ( negra ),
con la aproximada ( roja ).\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
exacta=Plot[2 t-2 Sin[5 t]/5,{t,0,1},
              DisplayFunction->Identity];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Show[gu,exacta];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO:

0.2533\[CenterDot]a( t ) +0.1589\[CenterDot] v( t ) +10\[CenterDot] u( t ) = \
p( t )  
u( 0 )=0
v( 0 )=0
p( t ) = {{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
              {.7,0},{.8,0},{.9,0},{1,0}}

queremos la respuesta hasta el instante tn=1, con un incremento de tiempo de \
to=0.1.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
Este es un caso donde la carga me la dan discretizada,y as\[IAcute] conocemos \
la carga para unos instantes determinados de tiempo.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
p={{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
    {.7,0},{.8,0},{.9,0},{1,0}};   \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
DiferenciaCentral[0,1,0.1,0,0,10,0.2533,0.1589,p,poscion,velocidad,\
aceleracion] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\

La soluci\[OAcute]n exacta del desplazamiento es:

uexac = { 0.,0.0328,0.2332,0.6487,1.1605,1.5241,1.4814,
       0.9245,0.0593,-0.7751,-1.2718 }; 

La representaci\[OAcute]n de ambas funciones se muestra a \
continuaci\[OAcute]n.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
uexac = { 0.,0.0328,0.2332,0.6487,1.1605,1.5241,1.4814, 
           0.9245,0.0593,-0.7751,-1.2718 };   \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
For[i=1,i<=n,i++,
       uexac[[i]]={tm[[i]],Chop[uexac[[i]]]}];    \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
guexac=Graphics[ListPlot[ Table[uexac[[i]],{i,n}],                 
           PlotJoined->True, 
           DisplayFunction->Identity,
           AxesLabel->{t,\"p\"}]];   \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Show[gu,guexac];    ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{928, 654},
WindowMargins->{{-2, Automatic}, {-1, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 249, 6, 176, "Title"],
Cell[1969, 57, 768, 23, 405, "Subsection"],
Cell[2740, 82, 220, 6, 85, "Subtitle"],
Cell[2963, 90, 760, 20, 258, "Text"],
Cell[3726, 112, 243, 7, 49, "Text"],
Cell[3972, 121, 153, 4, 46, "Input"],
Cell[4128, 127, 1393, 22, 182, "Text"],
Cell[5524, 151, 403, 12, 154, "Input"],
Cell[5930, 165, 184, 4, 49, "Text"],
Cell[6117, 171, 212, 8, 82, "Input"],
Cell[6332, 181, 259, 7, 49, "Text"],
Cell[6594, 190, 200, 8, 82, "Input"],
Cell[6797, 200, 281, 7, 49, "Text"],
Cell[7081, 209, 167, 4, 46, "Input"],
Cell[7251, 215, 204, 4, 49, "Text"],
Cell[7458, 221, 149, 4, 46, "Input"],
Cell[7610, 227, 285, 7, 49, "Text"],
Cell[7898, 236, 143, 6, 66, "Input"],
Cell[8044, 244, 205, 4, 49, "Text"],
Cell[8252, 250, 205, 7, 64, "Input"],
Cell[8460, 259, 237, 7, 49, "Text"],
Cell[8700, 268, 158, 4, 46, "Input"],
Cell[8861, 274, 191, 4, 49, "Text"],
Cell[9055, 280, 413, 12, 154, "Input"],
Cell[9471, 294, 357, 8, 49, "Text"],
Cell[9831, 304, 270, 9, 100, "Input"],
Cell[10104, 315, 208, 4, 49, "Text"],
Cell[10315, 321, 653, 17, 244, "Input"],
Cell[10971, 340, 295, 7, 49, "Text"],
Cell[11269, 349, 399, 11, 136, "Input"],
Cell[11671, 362, 226, 6, 49, "Text"],
Cell[11900, 370, 120, 3, 121, "Title"],
Cell[12023, 375, 2839, 84, 1432, "Input"],
Cell[14865, 461, 317, 14, 234, "Subsection"],
Cell[15185, 477, 150, 4, 46, "Input"],
Cell[15338, 483, 142, 4, 46, "Input"],
Cell[15483, 489, 208, 6, 46, "Input"],
Cell[15694, 497, 182, 5, 82, "Subsection"],
Cell[15879, 504, 217, 7, 64, "Input"],
Cell[16099, 513, 146, 4, 46, "Input"],
Cell[16248, 519, 402, 14, 215, "Subsection"],
Cell[16653, 535, 223, 5, 63, "Subsection"],
Cell[16879, 542, 232, 7, 64, "Input"],
Cell[17114, 551, 220, 7, 46, "Input"],
Cell[17337, 560, 322, 11, 177, "Subsection"],
Cell[17662, 573, 241, 7, 64, "Input"],
Cell[17906, 582, 206, 7, 64, "Input"],
Cell[18115, 591, 311, 9, 100, "Input"],
Cell[18429, 602, 150, 4, 46, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

