(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21389,        728]*)
(*NotebookOutlinePosition[     22256,        758]*)
(*  CellTagsIndexPosition[     22212,        754]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
M\[CapitalEAcute]TODO BASADO EN LA INTERPOLACI\[CapitalOAcute]N DE LA CARGA
con variaci\[OAcute]n cuadr\[AAcute]tica.\
\>", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontWeight->"Plain",
  FontColor->RGBColor[0.500008, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
     En este m\[EAcute]todo para hallar la soluci\[OAcute]n en el instante \
i+1,partimos de la soluci\[OAcute]n en el instante i,que ya es conocida. \
Hacemos la suposici\[OAcute]n
de que la carga var\[IAcute]a de forma PARAB\[CapitalOAcute]LICA entre los \
instantes i, I+1 e i+2. As\[IAcute] la ecuaci\[OAcute]n del movimiento es f\
\[AAcute]cil de resolver pues estar\[IAcute]a sometida a una 
carga CUADR\[CapitalAAcute]TICA:
         
   m\[CenterDot]a( t ) + c\[CenterDot]v( t ) + k\[CenterDot]u( t ) = pi + (2 \
pi+1 -3/2 pi-1/2pi+2 )( t - ti )/( ti+1 - ti ) + (pi+2 -2pi+1 +pi)(t-ti)^2 / \
(ti+1-ti)
        
donde ti<t<ti+1.
     Para resolver la ecuaci\[OAcute]n se hace el cambio de variable \
tau=t-ti. La respuesta ser\[AAcute] la suma de la debida a la carga constante \
pi, mas la 
correspondiente a la carga lineal (2 pi+1 -3/2 pi-1/2pi+2 )tau/( ti+1 - ti ), \
m\[AAcute]s la correspondiente a carga parab\[OAcute]lica (pi+2 -2pi+1 \
+pi)tau^2 / (ti+1-ti) .
     Particularizando para tau = ti+1 - ti, se obtiene la soluci\[OAcute]n \
para el instante i+1, en funci\[OAcute]n de lo ocurrido en el instante i.La \
aceleraci\[OAcute]n la 
obtenemos con la ecuaci\[OAcute]n del movimiento: 

ui+1 = a2\[CenterDot]ui + b\[CenterDot]vi + c2\[CenterDot]pi + \
d\[CenterDot]pi+1
vi+1 = a1\[CenterDot]ui + b1\[CenterDot]vi + c1\[CenterDot]pi + \
d1\[CenterDot]pi+1
ai+1 = ( pi+1 - k\[CenterDot]ui+1 - c\[CenterDot]vi+1 )/m

Vamos a considerar en este programa s\[OAcute]lo el caso sin amortiguamiento \
(c=0).

\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Explicaci\[OAcute]n del programa", "Subtitle",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  FontWeight->"Plain",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[1]],

Cell["\<\
Las variables que hay que introducir son las siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo.
u0=desplazamiento en el instante ti.
v0=velocidad en el instante ti.
k=rigidez.
m=masa.
p=carga..Si la carga se da de forma discreta, hay que dar una lista \
{{t1,p1},{t2,p2},.....,{tn.pn}}, en la que cada pareja de valores es la carga \
 p ,  que hay en el instante  t .\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
El programa da una tabla con los valores del desplazamiento, velocidad y \
aceleraci\[OAcute]n,en cada instante de tiempo junto con su representaci\
\[OAcute]n gr\[AAcute]fica\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\

 C\[AAcute]lculo del n\[UAcute]mero de puntos en los que se va a obtener la \
respuesta\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["n=Floor[(tn-ti)/to+1.];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
 Como la soluci\[OAcute]n se va hallando paso a paso  para cada instante de \
tiempo, hemos de discretizar la carga \"p\",  para tener los valores de ella \
en cada instante en el que va a ser calculada la respuesta.
Cuando la carga venga dada como una funci\[OAcute]n contin\[UAcute]a,  la \
discretizaci\[OAcute]n consiste simplemente en evaluar la funci\[OAcute]n \
para los instantes de tiempo en que vamos a obtener la respuesta.
Si la carga es conocida de forma discreta, o sea , que conocemos la carga de \
forma exacta en unos instantes de tiempo determinados, construiremos una \
funci\[OAcute]n \"pa1\", que ser\[AAcute] la que discretizaremos.
El siguiente programa comprueba si la carga no es una funci\[OAcute]n \
continua, en cuyo caso antes de realizar la interpolaci\[OAcute]n, comprueba \
que la lista tenga valores de carga para instantes de tiempo superiores o \
iguales al instante en que se quiere obtener la respuesta.Si esto no es as\
\[IAcute], o sea se pide la respuesta en un instante \"tn\" que es superior \
al \[UAcute]ltimo instante de tiempo donde se conoce la carga, se supone que \
la carga ha dejado de actuar, y se le asigna el valor cero, para poder \
realizar as\[IAcute] la interpolaci\[OAcute]n.  \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
pa1=p;
If[Head[p]==List,pa2=p;nn=Length[pa2];
    If[pa2[[nn,1]]+to/1000<tn,
        AppendTo[pa2,{pa1[[nn,1]]+to/1000,0.}];
        AppendTo[pa2,{tn,0.}],
          If[tn>pa2[[nn,1]],AppendTo[pa2,{tn,0.}]]];
          pa1=Interpolation[pa2,InterpolationOrder->1]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Discretizaci\[OAcute]n de la carga. Se toma un artificio en el \[UAcute]ltimo \
nodo. Para seguir el algoritmo se extrapola pn+1 a lo que dar\[IAcute]a si \
sigui\[EAcute]semos la tangente (derivada) en pn. Es mejor realizar este \
artificio al final que al principio, pues en este segundo caso se \
ir\[IAcute]a arrastrando el error cometido.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
pa=Table[0,{i,1,n+1}];
For[i=1,i<=n,i++,
     pa[[i]]=N[pa1[(ti+(i-1)to)]]];

pa[[n+1]]=N[pa[[n]]+(pa[[n]]-pa[[n-1]])];

\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
A continuaci\[OAcute]n se calculan una serie de t\[EAcute]rminos que ser\
\[AAcute] necesarios para obtener la soluci\[OAcute]n,
cuya deducci\[OAcute]n se adjunta en formato papel.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
s=0;
wn=Sqrt[k/m];
wd=wn;
Si=Sin[wd to];
Co=Cos[wd to];
a2=N[Co];
b=N[Si/wd];
c2=N[(-1*Co+1.5*Si/(wd to)
\t-1/((wd to)^2)+ Co/((wd to)^2)\t)/k];
d=N[(1 -2*Si/(wd to)+2/((wd to)^2)
\t\t-2*Co/((wd to)^2) )/k];
e=N[(Si/(2*wd*to) -1/((wd to)^2)
\t\t+Co/((wd to)^2)     )/k];
a1=N[-wd*Si];
b1=N[Co];
c1=N[(wd*Si -1/(2*to)+3*Co/(2*to)-Si/(wd*to^2)
\t\t)/k];
d1=N[(-2*Co/to +2Si/(wd*to^2)\t)/k ];
e1=N[(1/(2*to)+Co/(2*to)-Si/(wd*to^2))/k];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se inicializan los vectores de desplazamiento  \"u\", velocidad  \"v\"  y \
aceleraci\[OAcute]n \"a\".\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
u=Table[u0,{i,1,n}];
v=Table[v0,{i,1,n}];
a=Table[0.,{i,1,n}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
 A trav\[EAcute]s de la ecuaci\[OAcute]n del movimiento se calcula la \
aceleraci\[OAcute]n para el instante inicial \"ti\".\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["a[[1]]=(pa[[1]]-k u[[1]]-c v[[1]])/m;", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Discretizaci\[OAcute]n del tiempo en los instantes en que quiero la \
respuesta.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["tm=Table[ti+(i-1) to,{i,n}];", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["C\[AAcute]lculo de \"u\", \"v\"  y  \"a\".", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
 For[i=1,i<n,i++,
          u[[i+1]]=N[a2 u[[i]]+b v[[i]]+
                     c2 pa[[i]]+d pa[[i+1]]]
\t\t\t+e pa[[i+2]];
          v[[i+1]]=N[a1 u[[i]]+b1 v[[i]]+
                     c1 pa[[i]]+d1 pa[[i+1]]]
\t\t\t+ e1 pa[[i+2]];
          a[[i+1]]=N[(pa[[i+1]]-k u[[i+1]]-
                      c v[[i+1]])/m]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Para \"u\", \"v\"  y  \"a\", se construye una matriz en la que en la fila \"i\
\" aparece el instante de tiempo \"ti\" y la respuesta \"ui\",\"vi\" y \"ai\" \
respectivamente asociada a ese instante. \
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Se representan gr\[AAcute]ficamente \"u\", \"v\"  y  \"a\".", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
gu=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
ga=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Se realiza una tabla en la que para para cada instante de tiempo aparecen los \
valores de \"u\", \"v\" y \"a\" asociados a este instante.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["\<\
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"]; 
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\


Clear[\"Global`*\"]
\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
El programa anterior se introduce dentro de la orden Block quedando :\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}},
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell["InterpolacionCarga", "Title",
  TextAlignment->Center,
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
Clear[\"Global`*\"];
posicion;
velocidad;
aceleracion;
InterpolacionCuadraticaCarga[ti_,tn_,to_,u0_,v0_,k_,m_,p_,posicion_,velocidad_\
,aceleracion_]:=
  Block[{n,pa1,pa2,nn,pa,i,s,wn,wd,a2,b,c2,d,a1,
         b1,c1,d1,u,v,a,tm,gu,gv,ga},
(*Las variables que hay que introducir son 
  las siguientes:
ti=instante inicial.
tn=instante final.
to=incremento de tiempo.
u0=desplazamiento en el instante ti.
v0=velocidad en el instante ti.
k=rigidez.
m=masa.
p=carga.Si la carga se da de forma discreta, hay 
que dar una lista {{t1,p1},{t2,p2},.....,{tn.pn}},
en la que cada pareja de valores es la carga  p ,
que hay en el instante  t .
El programa da una tabla con los valores del 
desplazamiento, velocidad y aceleraci\[OAcute]n,en cada instante
de tiempo junto con su representaci\[OAcute]n gr\[AAcute]fica *)
n=Floor[(tn-ti)/to+1.];
pa1=p;
If[Head[p]==List,pa2=p;nn=Length[pa2];
    If[pa2[[nn,1]]+to/1000<tn,
        AppendTo[pa2,{pa1[[nn,1]]+to/1000,0.}];
        AppendTo[pa2,{tn,0.}],
          If[tn>pa2[[nn,1]],AppendTo[pa2,{tn,0.}]]];
          pa1=Interpolation[pa2,InterpolationOrder->1]];
pa=Table[0,{i,1,n+1}];
For[i=1,i<=n,i++,
     pa[[i]]=N[pa1[(ti+(i-1)to)]]];
pa[[n+1]]=N[pa[[n]]+(pa[[n]]-pa[[n-1]])];

s=0;
wn=Sqrt[k/m];
wd=wn;
Si=Sin[wd to];
Co=Cos[wd to];
a2=N[Co];
b=N[Si/wd];
c2=N[(-1*Co+1.5*Si/(wd to)
\t-1/((wd to)^2)+ Co/((wd to)^2)\t)/k];
d=N[(1 -2*Si/(wd to)+2/((wd to)^2)
\t\t-2*Co/((wd to)^2) )/k];
e=N[(Si/(2*wd*to) -1/((wd to)^2)
\t\t+Co/((wd to)^2)     )/k];
a1=N[-wd*Si];
b1=N[Co];
c1=N[(wd*Si -1/(2*to)+3*Co/(2*to)-Si/(wd*to^2)
\t\t)/k];
d1=N[(-2*Co/to +2Si/(wd*to^2)\t)/k ];
e1=N[(1/(2*to)+Co/(2*to)-Si/(wd*to^2))/k];

c=0;
u=Table[u0,{i,1,n}];
v=Table[v0,{i,1,n}];
a=Table[0.,{i,1,n}];
a[[1]]=(pa[[1]]-k u[[1]]-c v[[1]])/m;
tm=Table[ti+(i-1) to,{i,n}];
  
 For[i=1,i<n,i++,
          u[[i+1]]=N[a2 u[[i]]+b v[[i]]+
                     c2 pa[[i]]+d pa[[i+1]]]
\t\t\t+e pa[[i+2]];
          v[[i+1]]=N[a1 u[[i]]+b1 v[[i]]+
                     c1 pa[[i]]+d1 pa[[i+1]]]
\t\t\t+ e1 pa[[i+2]];
          a[[i+1]]=N[(pa[[i+1]]-k u[[i+1]]
                      )/m]];


                      
    For[i=1,i<=n,i++,
       u[[i]]={tm[[i]],Chop[u[[i]]]};
       v[[i]]={tm[[i]],Chop[v[[i]]]};
       a[[i]]={tm[[i]],Chop[a[[i]]]}];
posicion=u;
velocidad=v;
aceleracion=a;
gu=ListPlot[ Table[u[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,0]},
           PlotJoined->True,
           AxesLabel->{t,\"u\"}];
gv=ListPlot[ Table[v[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[1,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"v\"}];
ga=ListPlot[ Table[a[[i]],{i,n}],                 
           PlotStyle->{PointSize[0.023],RGBColor[0,0,1]},
           PlotJoined->True,
           AxesLabel->{t,\"a\"}];
Print[\"t\" ,  \"      \", \"   u\" ,
\"          v\",\"\", \"         a\"]; 
Print[\"------------------------------------\"];
Print[TableForm[tm],\"     \",TableForm[Transpose[u][[2]]],
\"   \",TableForm[Transpose[v][[2]]],\"  \",
TableForm[Transpose[a][[2]]]]]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\

(*Ejemplo*)
p[t_]:=Which[t<0,0,t<=4,225*t/4,t>4,225]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\

InterpolacionCuadraticaCarga[0,8,0.1,0,0,1436,45,p,posicion,velocidad,\
aceleracion]\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
EJEMPLO

a( t ) + u( t ) = Sin( t )
u(0)=0
v(0)=0

y queremos la respuesta hasta el instante tn=50, con un incremento de tiempo \
de to=0.2.
\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
   Este es un caso de resonancia sin amortiguamiento,por lo que la soluci\
\[OAcute]n real crecer\[AAcute] oscilando indefinidamente,quedando acotada \
por 
los valores de las rectas 1/2 t   y  -1/2 t.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["Clear[\"Global`*\"] ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["p[x_]:=Sin[x]; ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
InterpolacionCuadraticaCarga[0,50,.2,0,0,1,1,p,posicion,velocidad,aceleracion]\
 \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO

a + u = 0
u(0)=10
v(0)=0

y queremos la respuesta hasta el instante tn=10, con un incremento de tiempo \
de to=0.25.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
Este es un sencillo caso de vibraciones libres sin amortiguamiento para el \
que la soluci\[OAcute]n exacta es :
u( t ) = 10 Cos( t ).\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["p[x_]:=0;  ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
InterpolacionCuadraticaCarga[0,10,.25,10,0,1,1,p,posicion,velocidad,\
aceleracion]  \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
Para ver el grado de aproximaci\[OAcute]n dibujamos la aproximaci\[OAcute]n y \
la soluci\[OAcute]n exacta conjuntamente.La aproximaci\[OAcute]n est\[AAcute] \
pintada en rojo y en negro la 
soluci\[OAcute]n real. \
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
exacta=Plot[10 Cos[t],{t,0,10},
              DisplayFunction->Identity];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
a=Interpolation[posicion,InterpolationOrder\[Rule]1];
gu=Plot[a[t],{t,0,10},PlotStyle\[Rule]RGBColor[1,0,0]];\
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Show[gu,exacta]", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
EJEMPLO:

0.2533\[CenterDot]a( t )  +10\[CenterDot] u( t ) = p( t )  
u( 0 )=0
v( 0 )=0
p( t ) = {{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
              {.7,0},{.8,0},{.9,0},{1,0}}

queremos la respuesta hasta el instante tn=1, con un incremento de tiempo de \
to=0.1.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
Este es un caso donde la carga me la dan discretizada,y as\[IAcute] conocemos \
la carga para unos instantes determinados de tiempo.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["\<\
p={{0,0},{.1,5},{.2,8.66},{.3,10},{.4,8.66},{.5,5},{.6,0},
    {.7,0},{.8,0},{.9,0},{1,0}};    \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
InterpolacionCuadraticaCarga[0,1,0.1,0,0,10,0.2533,p,posicion,velocidad,\
aceleracion] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
For[i=1,i<=n,i++,
       uexac[[i]]={tm[[i]],Chop[uexac[[i]]]}];      \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
guexac=Graphics[ListPlot[ Table[uexac[[i]],{i,11}],                 
           PlotJoined->True, 
           DisplayFunction->Identity,
           AxesLabel->{t,\"p\"}]];     \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["Show[gu,guexac];      ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
EJEMPLO

a +10 u =10
u(0)=0
v(0)=0

y queremos la respuesta hasta el instante tn=10, con un incremento de tiempo \
de to=0.123\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[1]],

Cell["p[x_]:=10; ", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]],

Cell["\<\
InterpolacionCuadraticaCarga[0,10,0.123,0,0,10,1,p,posicion,velocidad,\
aceleracion] \
\>", "Input",
  PageWidth->Infinity,
  ImageRegion->{{0, 1}, {0, 1}},
  FontFamily->"Courier New",
  Background->GrayLevel[1]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 297, 8, 205, "Title"],
Cell[2017, 59, 1611, 37, 424, "Subsection"],
Cell[3631, 98, 193, 5, 80, "Subtitle"],
Cell[3827, 105, 517, 15, 201, "Text"],
Cell[4347, 122, 299, 7, 49, "Text"],
Cell[4649, 131, 212, 7, 68, "Text"],
Cell[4864, 140, 153, 4, 46, "Input"],
Cell[5020, 146, 1360, 21, 144, "Text"],
Cell[6383, 169, 403, 12, 154, "Input"],
Cell[6789, 183, 467, 9, 68, "Text"],
Cell[7259, 194, 259, 12, 154, "Input"],
Cell[7521, 208, 304, 7, 68, "Text"],
Cell[7828, 217, 570, 24, 370, "Input"],
Cell[8401, 243, 226, 6, 49, "Text"],
Cell[8630, 251, 200, 8, 82, "Input"],
Cell[8833, 261, 248, 6, 49, "Text"],
Cell[9084, 269, 167, 4, 46, "Input"],
Cell[9254, 275, 204, 6, 49, "Text"],
Cell[9461, 283, 158, 4, 46, "Input"],
Cell[9622, 289, 158, 3, 49, "Text"],
Cell[9783, 294, 454, 14, 190, "Input"],
Cell[10240, 310, 324, 7, 49, "Text"],
Cell[10567, 319, 270, 9, 100, "Input"],
Cell[10840, 330, 175, 3, 49, "Text"],
Cell[11018, 335, 653, 17, 244, "Input"],
Cell[11674, 354, 262, 6, 49, "Text"],
Cell[11939, 362, 399, 11, 136, "Input"],
Cell[12341, 375, 103, 7, 84, "Input"],
Cell[12447, 384, 193, 5, 49, "Text"],
Cell[12643, 391, 121, 3, 121, "Title"],
Cell[12767, 396, 3215, 106, 1828, "Input"],
Cell[15985, 504, 134, 6, 66, "Input"],
Cell[16122, 512, 166, 6, 48, "Input"],
Cell[16291, 520, 204, 11, 180, "Subsection"],
Cell[16498, 533, 292, 7, 82, "Subsection"],
Cell[16793, 542, 150, 4, 46, "Input"],
Cell[16946, 548, 88, 2, 30, "Input"],
Cell[17037, 552, 219, 7, 46, "Input"],
Cell[17259, 561, 216, 11, 177, "Subsection"],
Cell[17478, 574, 225, 6, 82, "Subsection"],
Cell[17706, 582, 141, 4, 46, "Input"],
Cell[17850, 588, 222, 7, 46, "Input"],
Cell[18075, 597, 305, 7, 82, "Subsection"],
Cell[18383, 606, 211, 7, 64, "Input"],
Cell[18597, 615, 190, 5, 48, "Input"],

Cell[CellGroupData[{
Cell[18812, 624, 88, 2, 30, "Input"],
Cell[18903, 628, 130, 3, 29, "Output"]
}, Open  ]],
Cell[19048, 634, 374, 13, 215, "Subsection"],
Cell[19425, 649, 223, 5, 63, "Subsection"],
Cell[19651, 656, 233, 7, 64, "Input"],
Cell[19887, 665, 225, 7, 46, "Input"],
Cell[20115, 674, 208, 7, 64, "Input"],
Cell[20326, 683, 314, 9, 100, "Input"],
Cell[20643, 694, 152, 4, 46, "Input"],
Cell[20798, 700, 217, 11, 177, "Subsection"],
Cell[21018, 713, 141, 4, 46, "Input"],
Cell[21162, 719, 223, 7, 46, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

