(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    367948,       9192]*)
(*NotebookOutlinePosition[    368600,       9215]*)
(*  CellTagsIndexPosition[    368556,       9211]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      StyleBox[\(M\[CapitalEAcute]TODO\ DE\ HILBERG, HUGHES\ Y\ TAYLOR\),
        FontSize->18,
        FontColor->RGBColor[1, 0, 0]], 
      StyleBox[" ",
        FontSize->18,
        FontColor->RGBColor[1, 0, 0]]}], "\[IndentingNewLine]", 
    StyleBox[\(para\ el\ caso\ no - lineal\),
      FontSize->18,
      FontColor->RGBColor[1, 0, 0]], "\[IndentingNewLine]", 
    StyleBox[\((Alejandro\ Ruiz\ Padillo, \ 2003)\),
      FontSize->14]}], "Input"],

Cell[BoxData[{
    RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
      StyleBox[
        RowBox[{"       ", 
          StyleBox["\t",
            "Text"]}]], 
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["Este",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["m\[EAcute]todo",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["  ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["est\[AAcute]",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["basado",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["en",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["el",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["modelo",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["de",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[\(NEWMARK . \ El\),
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["problema",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["parte",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["de",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["las",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["siguientes",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[" ",
              FontColor->RGBColor[0, 0, 1]], 
            RowBox[{
              StyleBox["ecuaciones",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox[":",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox["\[IndentingNewLine]",
                "Text"], 
              StyleBox["\[IndentingNewLine]",
                "Text"], 
              StyleBox[\(vi + 1\),
                "Text"]}]}], 
          StyleBox["=",
            "Text"], 
          
          StyleBox[\(\((\[Gamma]\/\(\[CapitalDelta]t*\[Beta]\))\)*\((ui + 1 - 
                    ui)\) + \
\[Gamma]*\[CapitalDelta]t*\((\((1\/\[CapitalDelta]t)\)*\((1\/\[Gamma] - 
                          1\/\[Beta])\)*
                      vi + \((1\/\[Gamma] - 1\/\(2*\[Beta]\))\)*ai)\)\),
            "Text"]}], 
        StyleBox[";",
          "Text"]}]}], "\[IndentingNewLine]", 
    StyleBox[\(ai + 
            1 = \((1\/\(\[CapitalDelta]t\^2*\[Beta]\))\)*\((ui + 1 - 
                  ui)\) + \((\(-1\)\/\(\[CapitalDelta]t*\[Beta]\))\)*
              vi + \((1 - 1\/\(2*\[Beta]\))\)*ai;\),
      "Text"], "\[IndentingNewLine]", 
    RowBox[{"\t", 
      RowBox[{
        StyleBox[\(Como\ se\ sabe\ estas\ dos\ ecuaciones\ se\ cumplen\ \
siempre\),
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[",",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[\(ya\ que\ han\ sido\ obtenidas\ mediante\ integracion . \ 
              Para\ resolver\ el\ problema\ nos\ hace\ falta\ otra\ \
ecuacion\),
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[",",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["que",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox["sera",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox["la",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox["de",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox["equilibrio",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox["dinamico",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
              RowBox[{
                StyleBox["modificada",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox[":",
                  FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
                
                StyleBox[\(m*\((ai + 1)\) + 
                    c*\((vi + 1)\) + \((1 + \[Alpha])\)*
                      k*\((ui + 1)\) - \[Alpha]*k*ui\),
                  "Text"]}]}], 
            StyleBox["=",
              "Text"], 
            StyleBox[\(pi + 1\),
              "Text"]}], 
          StyleBox[";",
            "Text"]}]}], 
      StyleBox["\[IndentingNewLine]",
        "Text"]}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox["         ",
        "Text"], 
      StyleBox[\(\((m\/\(\[CapitalDelta]t\^2*\[Beta]\) + \(c*\[Gamma]\)\/\(\
\[CapitalDelta]t*\[Beta]\) + \((1 + \[Alpha])\)*k)\)*ui + 
              1 = \((pi + 
                  1)\) + \((m\/\(\[CapitalDelta]t\^2*\[Beta]\) + \(c*\[Gamma]\
\)\/\(\[CapitalDelta]t*\[Beta]\) + \[Alpha]*k)\) 
                ui + \((m\/\(\[CapitalDelta]t*\[Beta]\) + 
                    c*\((\[Gamma]\/\[Beta] - 1)\))\)*
                vi + \ \((m*\((1\/\(2*\[Beta]\) - 1)\) 
                    c*\[CapitalDelta]t*\((\[Gamma]\/\(2*\[Beta]\) - 1)\))\) 
                ai;\),
        "Text"], 
      StyleBox["\[IndentingNewLine]",
        "Text"]}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox["\t",
        "Text"], 
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["Llamando",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[":",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["\[IndentingNewLine]",
              "Text",
              FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
            StyleBox["\[IndentingNewLine]",
              "Text"], 
            StyleBox["  ",
              "Text"], 
            StyleBox["A1",
              "Text"]}], 
          StyleBox["=",
            "Text"], 
          
          StyleBox[\((m\/\(\[CapitalDelta]t\^2*\[Beta]\) + \(c*\[Gamma]\)\/\(\
\[CapitalDelta]t*\[Beta]\) + \((1 + \[Alpha])\)*k)\),
            "Text"]}], 
        StyleBox[";",
          "Text"]}]}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox["         ",
        "Text"], 
      StyleBox[\(B1 = \((m\/\(\[CapitalDelta]t\^2*\[Beta]\) + \
\(c*\[Gamma]\)\/\(\[CapitalDelta]t*\[Beta]\) + \[Alpha]*k)\);\),
        "Text"]}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox["         ",
        "Text"], 
      StyleBox[\(C1 = \((m\/\(\[CapitalDelta]t*\[Beta]\) + 
                c*\((\[Gamma]\/\[Beta] - 1)\))\);\),
        "Text"]}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox["         ",
        "Text"], 
      StyleBox[\(D1 = \((m*\((1\/\(2*\[Beta]\) - 1)\) 
                c*\[CapitalDelta]t*\((\[Gamma]\/\(2*\[Beta]\) - 1)\))\);\),
        "Text"]}], "\[IndentingNewLine]", 
    StyleBox[\(B2 = \((\[Gamma]\/\(\[CapitalDelta]t*\[Beta]\))\);\),
      "Text"], "\[IndentingNewLine]", 
    StyleBox[\(C2 = \((1\/\[CapitalDelta]t)\)*\((1\/\[Gamma] - 
                1\/\[Beta])\);\),
      "Text"], "\[IndentingNewLine]", 
    StyleBox[\(D2 = \((1\/\[Gamma] - 1\/\(2*\[Beta]\))\);\),
      "Text"], "\[IndentingNewLine]", 
    StyleBox[\(B3 = \((1\/\(\[CapitalDelta]t\^2*\[Beta]\))\);\),
      "Text"], "\[IndentingNewLine]", 
    StyleBox[\(C3 = \((\(-1\)\/\(\[CapitalDelta]t*\[Beta]\))\);\),
      "Text"], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[\(D3 = \((1 - 1\/\(2*\[Beta]\))\);\),
        "Text"], 
      StyleBox["\[IndentingNewLine]",
        "Text"]}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox["\t",
        "Text"], 
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox[\(podemos\ despejar\ ui\),
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["+",
              FontColor->RGBColor[0, 0, 1]], 
            RowBox[{
              StyleBox["1",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox[" ",
                FontColor->RGBColor[0, 0, 1]], 
              RowBox[{
                StyleBox["quedando",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox[":",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["\[IndentingNewLine]",
                  "Text",
                  FontColor->RGBColor[0.226566, 0.644541, 0.644541]], 
                StyleBox["\[IndentingNewLine]",
                  "Text"], 
                StyleBox[\(ui + 1\),
                  "Text"]}]}]}], 
          StyleBox["=",
            "Text"], 
          StyleBox[\(\(\((pi + 1)\) + B*ui + C*vi + D*ai\)\/A\),
            "Text"]}], 
        StyleBox[";",
          "Text"]}], 
      StyleBox["\[IndentingNewLine]",
        "Text"], 
      StyleBox["\t",
        "Text"]}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[
        RowBox[{
          StyleBox["\t",
            "Text"], "\t"}]], 
      RowBox[{
        StyleBox[\(A\ partir\ de\ aqui\ iteramos\ para\ obtener\ los\ valores\
\ de\ la\ aceleracion\),
          "Text",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[",",
          "Text",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          "Text",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[\(velocidad\ y\ posicion\ en\ cada\ nodo . \
\[IndentingNewLine]Pero\ para\ hallar\ los\ coeficientes\ anteriores\ se\ \
necesita\ la\ rigidez\),
          "Text",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[",",
          "Text",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          "Text",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[\(que\ en\ este\ caso\ no - 
            lineal\ deber\[AAcute]\ ser\ la\ rigidez\ tangente\ \((kt\ en\ \
lugar\ de\ k)\)\ en\ cada\ punto . \ 
                Por\ ello\ se\ introduce\ en\ el\ algoritmo\ que\ calcula\ \
cada\ punto\ otro\ que\ define\ el\ valor\ de\ la\ rigidez\ tangente\),
          "Text",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[",",
          "Text",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          "Text",
          FontColor->RGBColor[0, 0, 1]], 
        RowBox[{
          
          StyleBox[\(dentro\ del\ caso\ elastopl\[AAcute]stico\ \ perfecto . \
\[IndentingNewLine]Todo\ el\ algoritmo\ ha\ sido\ introducido\ en\ una\ \
funcion\ Block\ para\ que\ su\ ejecucion\ sea\ solo\ darle\ valores\ a\ la\ \
funcion . \[IndentingNewLine]\[IndentingNewLine]Variables\ del\ \(modelo : \
\[IndentingNewLine]\t\tti\) = instante\ inicial\),
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[";",
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[
            StyleBox[
              RowBox[{
                StyleBox["\t\t",
                  "Text"], "\t"}]],
            FontColor->RGBColor[0, 0, 1]], 
          
          StyleBox[\(tn = 
              tiempo\ hasta\ el\ que\ se\ desea\ conocer\ la\ respuesta\),
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[";",
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\t\t\t",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(to = incremento\ de\ tiempo\),
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[";",
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\t\t\t",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(tfc = tiempo\ en\ que\ finaliza\ la\ carga\),
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[";",
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[
            StyleBox[
              RowBox[{
                StyleBox["\t\t",
                  "Text"], "\t"}]],
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(u0 = posicion\ inicial\),
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[";",
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[
            StyleBox[
              RowBox[{
                StyleBox["\t\t",
                  "Text"], "\t"}]],
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(v0 = velocidad\ inicial\),
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[";",
            "Text",
            FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", "\t\t\t", 
          StyleBox[\(k = rigidez\ del\ tramo\ elastico\),
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[";",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\t\t\t",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(m = \ masa\ en\ kg\),
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[";",
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[
            StyleBox[
              RowBox[{
                StyleBox["\t\t",
                  "Text"], "\t"}]],
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(c = amortiguamiento\),
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[";",
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[
            StyleBox[
              RowBox[{
                StyleBox["\t\t",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["\t",
                  FontColor->RGBColor[1, 0, 0]]}]],
            FontColor->RGBColor[0, 0, 1]], 
          RowBox[{
            StyleBox["fc",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox["=",
              FontColor->RGBColor[0, 0, 1]], 
            RowBox[{
              RowBox[{
                StyleBox["valor",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox[" ",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["que",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox[" ",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["provoca",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox[" ",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["la",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox[" ",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["plastificacion",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox[" ",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["a",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox[" ",
                  FontColor->RGBColor[0, 0, 1]], 
                RowBox[{
                  StyleBox["compresion",
                    FontColor->RGBColor[0, 0, 1]], 
                  StyleBox[".",
                    FontColor->RGBColor[0, 0, 1]], 
                  StyleBox["\[IndentingNewLine]",
                    FontColor->RGBColor[1, 0, 0]], "\t\t", 
                  StyleBox["ft",
                    FontColor->RGBColor[0, 0, 1]]}]}], 
              StyleBox["=",
                FontColor->RGBColor[0, 0, 1]], 
              RowBox[{
                RowBox[{
                  StyleBox["valor",
                    FontColor->RGBColor[0, 0, 1]], 
                  StyleBox[" ",
                    FontColor->RGBColor[0, 0, 1]], 
                  StyleBox["que",
                    FontColor->RGBColor[0, 0, 1]], 
                  StyleBox[" ",
                    FontColor->RGBColor[0, 0, 1]], 
                  StyleBox["provoca",
                    FontColor->RGBColor[0, 0, 1]], 
                  StyleBox[" ",
                    FontColor->RGBColor[0, 0, 1]], 
                  StyleBox["la",
                    FontColor->RGBColor[0, 0, 1]], 
                  StyleBox[" ",
                    FontColor->RGBColor[0, 0, 1]], 
                  StyleBox["plastificacion",
                    FontColor->RGBColor[0, 0, 1]], 
                  StyleBox[" ",
                    FontColor->RGBColor[0, 0, 1]], 
                  StyleBox["a",
                    FontColor->RGBColor[0, 0, 1]], 
                  StyleBox[" ",
                    FontColor->RGBColor[0, 0, 1]], 
                  RowBox[{
                    StyleBox["traccion",
                      FontColor->RGBColor[0, 0, 1]], 
                    StyleBox[".",
                      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
                    "\t\t", 
                    StyleBox["p",
                      "Text",
                      FontColor->RGBColor[0, 0, 1]]}]}], 
                StyleBox["=",
                  "Text",
                  FontColor->RGBColor[0, 0, 1]], 
                StyleBox["carga",
                  "Text",
                  FontColor->RGBColor[0, 0, 1]]}]}]}], 
          StyleBox[";",
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[
            StyleBox[
              RowBox[{
                StyleBox["\t\t",
                  "Text"], "\t"}]],
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\t\t\t",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(\[Beta] = 0.25\),
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[";",
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[
            StyleBox[
              RowBox[{
                StyleBox["\t\t",
                  "Text"], "\t"}]],
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(\[Gamma] = 0.5\),
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[";",
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[
            StyleBox[
              RowBox[{
                StyleBox["\t\t",
                  "Text"], "\t"}]],
            FontColor->RGBColor[0, 0, 1]], 
          
          StyleBox[\(\[Alpha] = 
              valor\ comprendido\ entre\  - 0.333333333\ y\ 0\),
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[";",
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[
            StyleBox[
              RowBox[{
                StyleBox["\t\t",
                  "Text"], "\t"}]],
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\[IndentingNewLine]",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["\t",
            "Text",
            FontColor->RGBColor[0, 0, 1]], 
          
          StyleBox[\(Por\ \[UAcute]ltimo\ debemos\ comentar\ que\ cada\ vez\ \
que\ se\ ejecute\ la\ funcion\ Hilberg\ debe\ ser\ cargado\ el\ Block\),
            "Text",
            FontColor->RGBColor[0, 0, 1]]}], 
        StyleBox[",",
          "Text",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["\[IndentingNewLine]",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          "Text",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[\(de\ este\ modo\ no\ se\ confudir\[AAcute]n\ las\ \
\(\(constantes\)\(.\)\)\),
          "Text",
          FontColor->RGBColor[0, 0, 1]]}]}]}], "Input"],

Cell[BoxData[{
    RowBox[{
      "\[IndentingNewLine]", \(Clear["\<Global`*\>"];\)}], "\
\[IndentingNewLine]", \(posicion;\), "\[IndentingNewLine]", \(velocidad;\), "\
\[IndentingNewLine]", \(aceleracion;\), "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{\(HilbergNoLineal[ti_, tf_, \[CapitalDelta]t_, u0_, v0_, k_, 
          m_, c_, fc_, ft_, funcioncarga_, \[Beta]_, \[Gamma]_, \[Alpha]_, 
          posicion_, velocidad_, aceleracion_]\), ":=", 
        RowBox[{"Block", "[", 
          
          RowBox[{\({nointervalos, nointervalos1, nopuntos, carga, 
              cargainterpolada, \ centinela, i, tini, kt, fs, kt1, fs1, fss, 
              A1, B1, C1, D1, B2, C2, D2, B3, C3, D3, u, v, a, posicion1, 
              velocidad1, tfc, tipocarga, aceleracion1, posicion2, 
              velocidad2, aceleracion2, fs2}\), ",", "\[IndentingNewLine]", 
            
            RowBox[{\(tfc = tf\), ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              
              StyleBox[\( (*Comenzamos\ con\ la\ discretizaci\[OAcute]n\ de\ \
la\ carga, \ que\ al\ final\ representamos*) \),
                FontColor->RGBColor[1, 0, 1]], 
              "\[IndentingNewLine]", \(If[Head[funcioncarga] \[Equal] List, 
                tipocarga = disc]\), ";", 
              "\[IndentingNewLine]", \(If[Head[funcioncarga] \[Equal] Symbol, 
                tipocarga = cont]\), ";", 
              "\[IndentingNewLine]", \(If[
                tf \[LessEqual] tfc, \[IndentingNewLine]\t
                centinela = 0; \[IndentingNewLine]\t
                If[tipocarga \[Equal] disc, \[IndentingNewLine]\t
                  cargainterpolada = 
                    Interpolation[funcioncarga, 
                      InterpolationOrder \[Rule] 1]; \[IndentingNewLine]\t
                  tipocarga = cont; \[IndentingNewLine]\t
                  centinela = 1;\[IndentingNewLine]\t]; \[IndentingNewLine]\t
                If[tipocarga \[Equal] cont, \[IndentingNewLine]\t
                  If[centinela \[Equal] 0, 
                    cargainterpolada = funcioncarga]; \[IndentingNewLine]\t
                  nointervalos = 
                    Floor[\((tf - 
                            ti)\)/\[CapitalDelta]t]; \[IndentingNewLine]\t
                  nopuntos = nointervalos + 1; \[IndentingNewLine]\t
                  carga = 
                    Table[0, {i, 1, nopuntos}, {j, 1, 
                        2}]; \[IndentingNewLine]\t
                  tini = ti; \[IndentingNewLine]\t
                  For[i = 1, 
                    i \[LessEqual] nopuntos, \(i++\), \[IndentingNewLine]\t
                    carga[\([i, 1]\)] = tini; \[IndentingNewLine]\t
                    tini = tini + \[CapitalDelta]t;\[IndentingNewLine]\t]; \
\[IndentingNewLine]\ttini = ti; \[IndentingNewLine]\t
                  For[i = 1, 
                    i \[LessEqual] nopuntos, \(i++\), \[IndentingNewLine]\t
                    carga[\([i, 2]\)] = 
                      cargainterpolada[tini]; \[IndentingNewLine]\t
                    tini = tini + \[CapitalDelta]t;\[IndentingNewLine]\t];\
\[IndentingNewLine]\t];\[IndentingNewLine]\t]\), ";", 
              "\[IndentingNewLine]", \(If[tf > tfc, \[IndentingNewLine]\t
                centinela = 0; \[IndentingNewLine]\t
                If[tipocarga \[Equal] disc, \[IndentingNewLine]\t
                  cargainterpolada = 
                    Interpolation[funcioncarga, 
                      InterpolationOrder \[Rule] 1]; \[IndentingNewLine]\t
                  tipocarga = cont; \[IndentingNewLine]\t
                  centinela = 1;\[IndentingNewLine]\t]; \[IndentingNewLine]\t
                If[tipocarga \[Equal] cont, \[IndentingNewLine]\t
                  If[centinela \[Equal] 0, 
                    cargainterpolada = funcioncarga]; \[IndentingNewLine]\t
                  nointervalos = 
                    Floor[\((tfc - 
                            ti)\)/\[CapitalDelta]t]; \[IndentingNewLine]\t
                  nointervalos1 = nointervalos + 1; \[IndentingNewLine]\t
                  nopuntos = nointervalos + 3; \[IndentingNewLine]\t
                  carga = 
                    Table[0, {i, 1, nopuntos}, {j, 1, 
                        2}]; \[IndentingNewLine]\t
                  tini = ti; \[IndentingNewLine]\t
                  For[i = 1, 
                    i \[LessEqual] 
                      nointervalos1, \(i++\), \[IndentingNewLine]\t
                    carga[\([i, 1]\)] = tini; \[IndentingNewLine]\t
                    tini = tini + \[CapitalDelta]t;\[IndentingNewLine]\t]; \
\[IndentingNewLine]\ttini = ti; \[IndentingNewLine]\t
                  For[i = 1, 
                    i \[LessEqual] 
                      nointervalos1, \(i++\), \[IndentingNewLine]\t
                    carga[\([i, 2]\)] = 
                      cargainterpolada[tini]; \[IndentingNewLine]\t
                    tini = tini + \[CapitalDelta]t;\[IndentingNewLine]\t]; \
\[IndentingNewLine]\t
                  carga[\([nointervalos + 2, 1]\)] = 
                    tini + 0.000000000000001; \[IndentingNewLine]\t
                  carga[\([nointervalos + 3, 1]\)] = tf; \[IndentingNewLine]\t
                  cargainterpolada = 
                    Interpolation[carga, \ 
                      InterpolationOrder \[Rule] 1]; \[IndentingNewLine]\t
                  nointervalos = 
                    Floor[\((tf - 
                            ti)\)/\[CapitalDelta]t]; \[IndentingNewLine]\t
                  nopuntos = nointervalos + 1; \[IndentingNewLine]\t
                  carga = 
                    Table[0, {i, 1, nopuntos}, {j, 1, 
                        2}]; \[IndentingNewLine]\t
                  tini = ti; \[IndentingNewLine]\t
                  For[i = 1, 
                    i \[LessEqual] nopuntos, \(i++\), \[IndentingNewLine]\t
                    carga[\([i, 1]\)] = tini; \[IndentingNewLine]\t
                    tini = tini + \[CapitalDelta]t;\[IndentingNewLine]\t]; \
\[IndentingNewLine]\ttini = ti; \[IndentingNewLine]\t
                  For[i = 1, 
                    i \[LessEqual] nopuntos, \(i++\), \[IndentingNewLine]\t
                    carga[\([i, 2]\)] = 
                      cargainterpolada[tini]; \[IndentingNewLine]\t
                    tini = tini + \[CapitalDelta]t;\[IndentingNewLine]\t];\
\[IndentingNewLine]\t];\[IndentingNewLine]\t\[IndentingNewLine]]\), ";", 
              "\[IndentingNewLine]", \(Print[
                ListPlot[carga, PlotJoined \[Rule] True, 
                  PlotRange \[Rule] All, PlotStyle \[Rule] RGBColor[1, 0, 1], 
                  AxesLabel \[Rule] {t, "\<p\>"}]]\), ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              
              StyleBox[\( (*Ahora\ inicializamos\ las\ variables\ del\ modelo*) \
\),
                FontColor->RGBColor[1, 0, 1]], 
              "\[IndentingNewLine]", \(u = Table[0, {i, 1, nopuntos}]\), ";", 
              "\[IndentingNewLine]", \(v = Table[0, {i, 1, nopuntos}]\), ";", 
              "\[IndentingNewLine]", \(a = Table[0, {i, 1, nopuntos}]\), ";", 
              "\[IndentingNewLine]", \(kt = Table[0, {i, 1, nopuntos}]\), ";",
               "\[IndentingNewLine]", \(fs = Table[0, {i, 1, nopuntos}]\), 
              ";", "\[IndentingNewLine]", \(u[\([1]\)] = u0\), ";", 
              "\[IndentingNewLine]", \(v[\([1]\)] = v0\), ";", 
              "\[IndentingNewLine]", \(a[\([1]\)] = \((carga[\([1, 2]\)] - 
                      c*v[\([1]\)] - k*u[\([1]\)])\)/m\), ";", 
              "\[IndentingNewLine]", \(kt[\([1]\)] = k\), ";", 
              "\[IndentingNewLine]", \(fs[\([1]\)] = k*u0\), ";", 
              "\[IndentingNewLine]", \(A1 = \((m\/\(\[CapitalDelta]t\^2*\
\[Beta]\) + \(c*\[Gamma]\)\/\(\[CapitalDelta]t*\[Beta]\) + \((1 + \[Alpha])\)*
                      k)\)\), ";", 
              "\[IndentingNewLine]", \(B1 = \((m\/\(\[CapitalDelta]t\^2*\
\[Beta]\) + \(c*\[Gamma]\)\/\(\[CapitalDelta]t*\[Beta]\) + \((\[Alpha])\)*
                      k)\)\), ";", 
              "\[IndentingNewLine]", \(C1 = \
\((m\/\(\[CapitalDelta]t*\[Beta]\) + c*\((\[Gamma]\/\[Beta] - 1)\))\)\), ";", 
              "\[IndentingNewLine]", \(D1 = \((m*\((1\/\(2*\[Beta]\) - 1)\) 
                    c*\[CapitalDelta]t*\((\[Gamma]\/\(2*\[Beta]\) - 1)\))\)\),
               ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              
              StyleBox[\( (*A\ continuaci\[OAcute]n\ aparece\ el\ bucle\ que\ \
va\ calculando\ en\ primer\ lugar\ la\ rigidez\ tangente\ y\ luego\ halla\ \
los\ valores\ de\ la\ posici\[OAcute]n, \ 
                  velocidad\ y\ aceleraci\[OAcute]n\ en\ cada\ paso*) \),
                FontColor->RGBColor[1, 0, 1]], "\[IndentingNewLine]", 
              RowBox[{"For", "[", 
                
                RowBox[{\(i = 1\), ",", \(i < nopuntos\), ",", \(i++\), ",", 
                  "\[IndentingNewLine]", "        ", 
                  
                  RowBox[{\(u[\([i + 
                            1]\)] = \(1\/A1\) \((carga[\([i + 1, 2]\)] + 
                            B1*u[\([i]\)]\[IndentingNewLine]\ \ \ \ \  + 
                            C1*v[\([i]\)] + D1*a[\([i]\)])\)\), ";", 
                    "\[IndentingNewLine]", 
                    "        ", \(If[
                      Abs[u[\([i + 1]\)]] - Abs[u[\([i]\)]] > 
                        0, \ \ \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \
If[fc < fs[\([i]\)] < 
                          ft, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ fs[\([i + 1]\)] = 
                          fs[\([i]\)] + 
                            k\ \((u[\([i + 1]\)] - 
                                  u[\([i]\)])\); \[IndentingNewLine]\ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ If[
                          fc < fs[\([i + 1]\)] < 
                            ft, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ kt[\([i + 1]\)] = 
                            k, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ If[fs[\([i + 1]\)] > 0, fs[\([i + 1]\)] = ft, 
                            fs[\([i + 1]\)] = 
                              fc]; \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ kt[\([i + 1]\)] = 
                            0\[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ ], \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
If[fs[\([i]\)] > 0, fs[\([i + 1]\)] = ft, 
                          fs[\([i + 1]\)] = 
                            fc]; \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ kt[\([i + 1]\)] = 
                          0\[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
], \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ fs[\([i + 1]\)] = 
                        fs[\([i]\)] + 
                          k\ \((u[\([i + 1]\)] - 
                                u[\([i]\)])\); \[IndentingNewLine]\ \ \ \ \ \ \
\ \ \ \ \ \ \ \ If[fc < fs[\([i + 1]\)] < 
                          ft, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ kt[\([i + 1]\)] = 
                          k, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ If[fs[\([i + 1]\)] > 0, fs[\([i + 1]\)] = ft, 
                          fs[\([i + 1]\)] = 
                            fc]; \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ kt[\([i + 1]\)] = 
                          0\[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ ]\[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ ]\), ";", "\[IndentingNewLine]", 
                    "        ", \(A1 = \((m\/\(\[CapitalDelta]t\^2*\[Beta]\) \
+ \(c*\[Gamma]\)\/\(\[CapitalDelta]t*\[Beta]\) + \((1 + \[Alpha])\)*
                            kt[\([i + 1]\)])\)\), ";", "\[IndentingNewLine]", 
                    "        ", \(B1 = \((m\/\(\[CapitalDelta]t\^2*\[Beta]\) \
+ \(c*\[Gamma]\)\/\(\[CapitalDelta]t*\[Beta]\) + \((\[Alpha])\)*
                            kt[\([i + 1]\)])\)\), ";", "\[IndentingNewLine]", 
                    "        ", \(C1 = \((m\/\(\[CapitalDelta]t*\[Beta]\) + 
                          c*\((\[Gamma]\/\[Beta] - 1)\))\)\), ";", 
                    "\[IndentingNewLine]", 
                    "        ", \(D1 = \((m*\((1\/\(2*\[Beta]\) - 1)\) 
                          c*\[CapitalDelta]t*\((\[Gamma]\/\(2*\[Beta]\) - 
                              1)\))\)\), ";", "\[IndentingNewLine]", 
                    "        ", \(B2 = \
\((\[Gamma]\/\(\[CapitalDelta]t*\[Beta]\))\)\), ";", "\[IndentingNewLine]", 
                    "        ", \(C2 = \((1\/\[CapitalDelta]t)\)*\((1\/\
\[Gamma] - 1\/\[Beta])\)\), ";", "\[IndentingNewLine]", 
                    "        ", \(D2 = \((1\/\[Gamma] - 1\/\(2*\[Beta]\))\)\),
                     ";", "\[IndentingNewLine]", 
                    "        ", \(B3 = \((1\/\(\[CapitalDelta]t\^2*\[Beta]\))\
\)\), ";", "\[IndentingNewLine]", 
                    "        ", \(C3 = \
\((\(-1\)\/\(\[CapitalDelta]t*\[Beta]\))\)\), ";", "\[IndentingNewLine]", 
                    "        ", \(D3 = \((1 - 1\/\(2*\[Beta]\))\)\), ";", 
                    "\[IndentingNewLine]", 
                    "        ", \(u[\([i + 
                            1]\)] = \((\(1\/A1\) \((carga[\([i + 1, 2]\)] + 
                              B1*u[\([i]\)] + C1*v[\([i]\)] + 
                              D1*a[\([i]\)])\))\)\), ";", 
                    "\[IndentingNewLine]", "        ", 
                    RowBox[{\(v[\([i + 1]\)]\), "=", 
                      RowBox[{
                        RowBox[{"B2", 
                          StyleBox["*",
                            "Text"], 
                          StyleBox[\((u[\([i + 1]\)] - u[\([i]\)])\),
                            "Text"]}], 
                        StyleBox["+",
                          "Text"], 
                        
                        StyleBox[\(\[Gamma]*\[CapitalDelta]t*\((C2*
                                  v[\([i]\)] + D2*a[\([i]\)])\)\),
                          "Text"]}]}], 
                    StyleBox[";",
                      "Text"], "\[IndentingNewLine]", 
                    "        ", \(If[
                      fc < fs[\([i + 1]\)] < 
                        ft, \[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
fs[\([i + 1]\)] = fs[\([i]\)] + 
                          k\ \((u[\([i + 1]\)] - 
                                u[\([i]\)])\), \[IndentingNewLine]\ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ If[fs[\([i + 1]\)] > 0, fs[\([i + 1]\)] = ft, 
                        fs[\([i + 1]\)] = 
                          fc]\[IndentingNewLine]\ \ \ \ \ \ \ \ \ \ ]\), ";", 
                    "\[IndentingNewLine]", "        ", 
                    
                    StyleBox[\(a[\([i + 1]\)] = 
                          B3*\((u[\([i + 1]\)] - u[\([i]\)])\) + 
                            C3*v[\([i]\)] + D3*a[\([i]\)];\),
                      "Text"]}]}], "\[IndentingNewLine]", "  ", "]"}], ";", 
              "\[IndentingNewLine]", 
              
              StyleBox[\( (*Una\ vez\ terminado\ el\ bucle\ tenemos\ todos\ \
los\ valores\ y\ pasamos\ a\ prepararlos\ para\ la\ representaci\[OAcute]n\ y\
\ salida\ de\ datos*) \),
                FontColor->RGBColor[1, 0, 1]], 
              "\[IndentingNewLine]", \(posicion1 = 
                Table[0, {i, 1, nopuntos}, {j, 1, 2}]\), ";", 
              "\[IndentingNewLine]", \(velocidad1 = 
                Table[0, {i, 1, nopuntos}, {j, 1, 2}]\), ";", 
              "\[IndentingNewLine]", \(aceleracion1 = 
                Table[0, {i, 1, nopuntos}, {j, 1, 2}]\), ";", 
              "\[IndentingNewLine]", \(fs1 = 
                Table[0, {i, 1, nopuntos}, {j, 1, 2}]\), ";", 
              "\[IndentingNewLine]", \(kt1 = 
                Table[0, {i, 1, nopuntos}, {j, 1, 2}]\), ";", 
              "\[IndentingNewLine]", \(tini = ti\), ";", 
              "\[IndentingNewLine]", \(For[i = 1, 
                i \[LessEqual] nopuntos, \(i++\), \[IndentingNewLine]\t
                posicion1[\([i, 1]\)] = tini; \[IndentingNewLine]\t
                velocidad1[\([i, 1]\)] = tini; \[IndentingNewLine]\t
                aceleracion1[\([i, 1]\)] = 
                  tini; \[IndentingNewLine]\ \ \ \ \ \ \ \ \ fs1[\([i, 
                      1]\)] = 
                  tini; \[IndentingNewLine]\ \ \ \ \ \ \ \ \ kt1[\([i, 
                      1]\)] = tini; \[IndentingNewLine]\t
                tini = tini + \[CapitalDelta]t;\[IndentingNewLine]]\), ";", 
              "\[IndentingNewLine]", \(For[i = 1, 
                i \[LessEqual] nopuntos, \(i++\), \[IndentingNewLine]\t
                posicion1[\([i, 2]\)] = u[\([i]\)]; \[IndentingNewLine]\t
                velocidad1[\([i, 2]\)] = v[\([i]\)]; \[IndentingNewLine]\t
                aceleracion1[\([i, 2]\)] = 
                  a[\([i]\)]; \[IndentingNewLine]\ \ \ \ \ \ \ \ \ fs1[\([i, 
                      2]\)] = 
                  fs[\([i]\)]; \[IndentingNewLine]\ \ \ \ \ \ \ \ \ kt1[\([i, 
                      2]\)] = kt[\([i]\)]\[IndentingNewLine]]\), ";", 
              "\[IndentingNewLine]", \(posicion = posicion1\), ";", 
              "\[IndentingNewLine]", \(velocidad = velocidad1\), ";", 
              "\[IndentingNewLine]", \(aceleracion = aceleracion1\), ";", 
              "\[IndentingNewLine]", \(posicion2 = 
                Interpolation[posicion1, InterpolationOrder \[Rule] 1]\), ";",
               "\[IndentingNewLine]", \(Print[
                Plot[posicion2[t], {t, ti, tf}, 
                  PlotStyle \[Rule] RGBColor[1, 0, 0], 
                  AxesLabel \[Rule] {t, "\<u\>"}]]\), ";", 
              "\[IndentingNewLine]", \(velocidad2 = 
                Interpolation[velocidad1, InterpolationOrder \[Rule] 1]\), 
              ";", "\[IndentingNewLine]", \(Print[
                Plot[velocidad2[t], {t, ti, tf}, 
                  PlotStyle \[Rule] RGBColor[0, 1, 0], 
                  AxesLabel \[Rule] {t, "\<v\>"}]]\), ";", 
              "\[IndentingNewLine]", \(aceleracion2 = 
                Interpolation[aceleracion1, InterpolationOrder \[Rule] 1]\), 
              ";", "\[IndentingNewLine]", \(Print[
                Plot[aceleracion2[t], {t, ti, tf}, 
                  PlotStyle \[Rule] RGBColor[0, 0, 1], 
                  AxesLabel \[Rule] {t, "\<a\>"}]]\), ";", 
              "\[IndentingNewLine]", \(fs2 = 
                Interpolation[fs1, InterpolationOrder \[Rule] 1]\), ";", 
              "\[IndentingNewLine]", \(Print[
                Plot[fs2[t], {t, ti, tf}, AxesLabel \[Rule] {t, "\<fs\>"}]]\),
               ";", "\[IndentingNewLine]", \(Print["\<t      p\>", "\<        \
\>", "\<t        u\>", "\<              \>", "\<t        v\>", "\<          \
\>", "\<t       a\>", \ "\<         \>", \ "\<t      kt\>"]\), ";", 
              "\[IndentingNewLine]", \
\(Print["\<-------------------------------------------------------------------\
----------------------------\>"]\), ";", 
              "\[IndentingNewLine]", \(Print[ColumnForm[carga], "\<  \>", 
                ColumnForm[posicion1], "\<  \>", 
                ColumnForm[velocidad1], "\<  \>", 
                ColumnForm[aceleracion1], "\<  \>", ColumnForm[kt1]]\)}]}], 
          "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell["\<\
EJEMPLO
Resolver mediante el m\[EAcute]todo de Hilberg, Hughes y Taylor no-lineal el \
siguiente problema de un material elasto-pl\[AAcute]stico perfecto:
a(t)+fs(u,v)=50 t
u(0)=0
v(0)=0
Hallar la respuesta hasta el instante tn=1 y con un incremento de tiempo \
to=0.01. La rigidez del tramo el\[AAcute]stico es 25, la m\[AAcute]xima \
tracci\[OAcute]n es 15 y la m\[AAcute]xima compresi\[OAcute]n es -15.\
\>", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\[IndentingNewLine]\(p[t_] := 50\ t;\)\), "\[IndentingNewLine]", 
    \(HilbergNoLineal[0, 1, 0.01, 0, 0, 25, 1, 0, \(-15\), 15, p, 0.5, 
      0.1666666667, \(-0.1\), posicion, velocidad, aceleracion]\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.0117721 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .13244 -12 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -12 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -12 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -12 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -12 -4.5 ]
[.01131 .60332 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .13244 m
.03006 .13244 L
s
[(10)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(20)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(30)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(40)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(50)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03826 m
.02756 .03826 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .08535 m
.02756 .08535 L
s
.02381 .10889 m
.02756 .10889 L
s
.02381 .15598 m
.02756 .15598 L
s
.02381 .17952 m
.02756 .17952 L
s
.02381 .20307 m
.02756 .20307 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .2737 m
.02756 .2737 L
s
.02381 .29724 m
.02756 .29724 L
s
.02381 .32079 m
.02756 .32079 L
s
.02381 .34433 m
.02756 .34433 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .41497 m
.02756 .41497 L
s
.02381 .43851 m
.02756 .43851 L
s
.02381 .46205 m
.02756 .46205 L
s
.02381 .50914 m
.02756 .50914 L
s
.02381 .53269 m
.02756 .53269 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57977 m
.02756 .57977 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
1 0 1 r
.5 Mabswid
.02381 .01472 m
.03333 .0206 L
.04286 .02649 L
.05238 .03237 L
.0619 .03826 L
.07143 .04415 L
.08095 .05003 L
.09048 .05592 L
.1 .0618 L
.10952 .06769 L
.11905 .07358 L
.12857 .07946 L
.1381 .08535 L
.14762 .09123 L
.15714 .09712 L
.16667 .10301 L
.17619 .10889 L
.18571 .11478 L
.19524 .12066 L
.20476 .12655 L
.21429 .13244 L
.22381 .13832 L
.23333 .14421 L
.24286 .15009 L
.25238 .15598 L
.2619 .16187 L
.27143 .16775 L
.28095 .17364 L
.29048 .17952 L
.3 .18541 L
.30952 .1913 L
.31905 .19718 L
.32857 .20307 L
.3381 .20895 L
.34762 .21484 L
.35714 .22073 L
.36667 .22661 L
.37619 .2325 L
.38571 .23838 L
.39524 .24427 L
.40476 .25016 L
.41429 .25604 L
.42381 .26193 L
.43333 .26781 L
.44286 .2737 L
.45238 .27959 L
.4619 .28547 L
.47143 .29136 L
.48095 .29724 L
.49048 .30313 L
Mistroke
.5 .30902 L
.50952 .3149 L
.51905 .32079 L
.52857 .32668 L
.5381 .33256 L
.54762 .33845 L
.55714 .34433 L
.56667 .35022 L
.57619 .35611 L
.58571 .36199 L
.59524 .36788 L
.60476 .37376 L
.61429 .37965 L
.62381 .38554 L
.63333 .39142 L
.64286 .39731 L
.65238 .40319 L
.6619 .40908 L
.67143 .41497 L
.68095 .42085 L
.69048 .42674 L
.7 .43262 L
.70952 .43851 L
.71905 .4444 L
.72857 .45028 L
.7381 .45617 L
.74762 .46205 L
.75714 .46794 L
.76667 .47383 L
.77619 .47971 L
.78571 .4856 L
.79524 .49148 L
.80476 .49737 L
.81429 .50326 L
.82381 .50914 L
.83333 .51503 L
.84286 .52091 L
.85238 .5268 L
.8619 .53269 L
.87143 .53857 L
.88095 .54446 L
.89048 .55034 L
.9 .55623 L
.90952 .56212 L
.91905 .568 L
.92857 .57389 L
.9381 .57977 L
.94762 .58566 L
.95714 .59155 L
.96667 .59743 L
Mistroke
.97619 .60332 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo000oOol2
0004Ool20003Ool4000OOol20004Ool20005Ool3000OOol20004Ool20003Ool3000POol20004Ool2
0004Ool2000UOol5000NOol003ioo`04001oogoo0008Ool00`00Oomoo`0OOol01000Oomoo`002goo
00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`0027oo00@007ooOol0
02Ioo`03001oogoo01ioo`00?Woo00@007ooOol000Uoo`03001oogoo01ioo`04001oogoo0008Ool5
000NOol01000Oomoo`0027oo00@007ooOol001ioo`04001oogoo0008Ool01000Oomoo`009Woo00<0
07ooOol07Woo000nOol01000Oomoo`002Woo00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo
000OOol01000Oomoo`0027oo0`007goo00@007ooOol000Uoo`8002Moo`03001oogoo01ioo`00?Woo
00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`002Goo00<007oo00007goo00@007ooOol0
00Uoo`03001oogoo01ioo`04001oogoo0008Ool01000Oomoo`009Woo00<007ooOol07Woo000oOol2
000:Ool2000POol2000;Ool2000POol2000:Ool3000OOol2000:Ool2000VOol2000POol00?moob5o
o`0067oo00<007ooOol0ogoo1Woo000HOol00`00Oomoo`3oOol6Ool001Qoo`03001oogoo0?Aoo`80
00moo`0067oo00<007ooOol0lgoo00@007ooOol000ioo`004Woo1P000W`Ok00027oo00<007ooOol0
3goo000HOol01000Ooml7g`O27oo00<007ooOol027oo00<007ooOol02Goo00<007ooOol027oo00<0
07ooOol02Goo00<007ooOol027oo00<007ooOol02Goo00<007ooOol027oo00<007ooOol02Goo00<0
07ooOol02Goo00<007ooOol027oo00<007ooOol02Goo00<007ooOol027oo00<007ooOol02Goo00<0
07ooOol027oo00<007ooOol02Goo00<007ooOol027oo00<007ooOol02Goo00<007ooOol02Goo00<0
07ooOol027oo00<007ooOol02goo1@003Woo000HOol01000Oomoogoo0W`Ol7oo00<007ooOol03goo
000HOol00`00Oomoo`03Ool00g`OOomoo`3oOol001Qoo`03001oogoo00Aoo`9l7omoo`0067oo0P00
1goo00=l7gooOol0o7oo000HOol00`00Oomoo`07Ool2O1olOol001Qoo`03001oogoo00Uoo`9l7oYo
o`0067oo00<007ooOol02goo00=l7gooOol0mgoo000HOol00`00Oomoo`0<Ool00g`OOomoo`3fOol0
01Qoo`03001oogoo00eoo`9l7oIoo`0067oo0P0047oo0g`Olgoo000HOol00`00Oomoo`0BOol00g`O
Oomoo`3`Ool001Qoo`03001oogoo01=oo`03O1moogoo0>moo`0067oo00<007ooOol057oo0W`Okgoo
000HOol00`00Oomoo`0FOol2O1o]Ool001Qoo`03001oogoo01Qoo`03O1moogoo0>Yoo`0067oo0P00
6Woo0W`OjWoo000HOol00`00Oomoo`0KOol00g`OOomoo`3WOol001Qoo`03001oogoo01aoo`03O1mo
ogoo0>Ioo`0067oo00<007ooOol07Goo0W`OiWoo000HOol00`00Oomoo`0OOol3O1oSOol001Qoo`80
02=oo`03O1moogoo0>1oo`0067oo00<007ooOol08goo00=l7gooOol0ggoo000HOol00`00Oomoo`0T
Ool2O1oOOol001Qoo`03001oogoo02Ioo`9l7meoo`002Woo1@000Woo0P001Goo00<007ooOol0:7oo
00=l7gooOol0fWoo000<Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol0:Goo0W`O
fWoo000<Ool01@00Oomoogoo00000Woo00<007ooOol00Woo0`00:goo00=l7gooOol0egoo000<Ool0
1@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol0;7oo0W`Oegoo000<Ool01@00Oomoogoo
00000Woo00<007ooOol00Woo00<007ooOol0;Woo0W`OeGoo000;Ool20004Ool20005Ool00`00Oomo
o`0`Ool2O1oCOol001Qoo`03001oogoo039oo`03O1moogoo0=1oo`0067oo00<007ooOol0<goo0W`O
d7oo000HOol2000fOol2O1o>Ool001Qoo`03001oogoo03Moo`03O1moogoo0<]oo`0067oo00<007oo
Ool0>7oo00=l7gooOol0bWoo000HOol00`00Oomoo`0iOol2O1o:Ool001Qoo`03001oogoo03]oo`03
O1moogoo0<Moo`0067oo00<007ooOol0?7oo0W`Oagoo000HOol2000oOol2O1o5Ool001Qoo`03001o
ogoo041oo`9l7l=oo`0067oo00<007ooOol0@Woo00=l7gooOol0`7oo000HOol00`00Oomoo`13Ool2
O1o0Ool001Qoo`03001oogoo04Eoo`9l7kioo`0067oo0P00B7oo00=l7gooOol0^goo000HOol00`00
Oomoo`18Ool00g`OOomoo`2jOol001Qoo`03001oogoo04Uoo`9l7kYoo`0067oo00<007ooOol0Bgoo
0W`O^7oo000HOol00`00Oomoo`1=Ool00g`OOomoo`2eOol001Qoo`03001oogoo04ioo`9l7kEoo`00
67oo0P00DGoo0W`O/goo000HOol00`00Oomoo`1BOol2O1naOol001Qoo`03001oogoo05Aoo`03O1mo
ogoo0:ioo`0067oo00<007ooOol0EGoo0W`O[Woo000:Ool40003Ool20005Ool00`00Oomoo`1GOol0
0g`OOomoo`2[Ool000Yoo`03001oogoo00=oo`04001oogoo0004Ool00`00Oomoo`1HOol00g`OOomo
o`2ZOol000]oo`03001oogoo009oo`04001oogoo0004Ool3001IOol2O1nZOol000aoo`05001oogoo
Ool00002Ool00`00Oomoo`02Ool00`00Oomoo`1KOol2O1nXOol000Yoo`04001oogoo0002Ool01000
Oomoo`0017oo00<007ooOol0GGoo00=l7gooOol0YGoo000;Ool20004Ool20005Ool00`00Oomoo`1N
Ool2O1nUOol001Qoo`03001oogoo061oo`9l7j=oo`0067oo0P00Hgoo0W`OXGoo000HOol00`00Oomo
o`1TOol00g`OOomoo`2NOol001Qoo`03001oogoo06Eoo`9l7iioo`0067oo00<007ooOol0Igoo00=l
7gooOol0Vgoo000HOol00`00Oomoo`1XOol2O1nKOol001Qoo`03001oogoo06Yoo`9l7iUoo`0067oo
0P00KGoo00=l7gooOol0UWoo000HOol00`00Oomoo`1]Ool00g`OOomoo`2EOol001Qoo`03001oogoo
06ioo`9l7iEoo`0067oo00<007ooOol0L7oo0g`OTWoo000HOol00`00Oomoo`1cOol00g`OOomoo`2?
Ool001Qoo`03001oogoo07Aoo`03O1moogoo08ioo`0067oo0P00MWoo0W`OSWoo000HOol00`00Oomo
o`1gOol2O1n<Ool001Qoo`03001oogoo07Uoo`03O1moogoo08Uoo`0067oo00<007ooOol0NWoo0W`O
RGoo000HOol00`00Oomoo`1lOol00g`OOomoo`26Ool001Qoo`03001oogoo07eoo`03O1moogoo08Eo
o`0067oo0P00Ogoo0W`OQGoo000HOol00`00Oomoo`20Ool3O1n2Ool001Qoo`03001oogoo08=oo`03
O1moogoo07moo`002goo0P0017oo0P001Goo00<007ooOol0Q7oo00=l7gooOol0OWoo000:Ool01000
Oomoo`000Woo00@007ooOol000Aoo`03001oogoo08Eoo`9l7gioo`0037oo00D007ooOomoo`00009o
o`03001oogoo009oo`<008Moo`9l7gaoo`003Goo00@007ooOol0009oo`03001oogoo009oo`03001o
ogoo08Uoo`03O1moogoo07Uoo`002Woo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`2:
Ool2O1miOol000]oo`8000Aoo`8000Eoo`03001oogoo08aoo`03O1moogoo07Ioo`0067oo00<007oo
Ool0SGoo0W`OMWoo000HOol00`00Oomoo`2?Ool2O1mdOol001Qoo`80099oo`9l7g9oo`0067oo00<0
07ooOol0Tgoo00=l7gooOol0Kgoo000HOol00`00Oomoo`2DOol2O1m_Ool001Qoo`03001oogoo09Io
o`9l7feoo`0067oo00<007ooOol0V7oo00=l7gooOol0JWoo000HOol00`00Oomoo`2IOol00g`OOomo
o`1YOol001Qoo`8009]oo`9l7fUoo`0067oo00<007ooOol0W7oo00=l7gooOol0IWoo000HOol00`00
Oomoo`2MOol2O1mVOol001Qoo`03001oogoo09moo`9l7fAoo`0067oo00<007ooOol0XGoo0W`OHWoo
000HOol2002TOol00g`OOomoo`1OOol001Qoo`03001oogoo0:Aoo`9l7emoo`0067oo00<007ooOol0
YWoo0W`OGGoo000HOol00`00Oomoo`2XOol00g`OOomoo`1JOol001Qoo`03001oogoo0:Uoo`03O1mo
ogoo05Uoo`0067oo00<007ooOol0ZWoo0W`OFGoo000HOol2002]Ool2O1mGOol001Qoo`03001oogoo
0:ioo`03O1moogoo05Aoo`0067oo00<007ooOol0[goo0W`OE7oo000HOol00`00Oomoo`2aOol2O1mB
Ool000aoo`<0009oo`8000Eoo`03001oogoo0;=oo`9l7e1oo`003Goo00@007ooOol0009oo`03001o
ogoo009oo`03001oogoo0;Eoo`03O1moogoo04eoo`002Woo1@0000Eoo`00Oomoo`0000Aoo`<00;Io
o`9l7deoo`002Woo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`2hOol00g`OOomoo`1:
Ool000]oo`03001oo`00009oo`04001oogoo0004Ool00`00Oomoo`2iOol2O1m:Ool000aoo`8000=o
o`8000Eoo`03001oogoo0;]oo`9l7dQoo`0067oo00<007ooOol0_Goo00=l7gooOol0AGoo000HOol0
0`00Oomoo`2nOol00g`OOomoo`14Ool001Qoo`800<1oo`9l7dAoo`0067oo00<007ooOol0`Goo0W`O
@Woo000HOol00`00Oomoo`33Ool2O1m0Ool001Qoo`03001oogoo0<Eoo`03O1moogoo03eoo`0067oo
00<007ooOol0aWoo0W`O?Goo000HOol20039Ool00g`OOomoo`0jOol001Qoo`03001oogoo0<Uoo`9l
7cYoo`0067oo00<007ooOol0bgoo0W`O>7oo000HOol00`00Oomoo`3=Ool00g`OOomoo`0eOol001Qo
o`03001oogoo0<ioo`03O1moogoo03Aoo`0067oo00<007ooOol0cgoo0W`O=7oo000HOol2003BOol3
O1laOol001Qoo`03001oogoo0=Aoo`03O1moogoo02ioo`0067oo00<007ooOol0eGoo00=l7gooOol0
;Goo000HOol00`00Oomoo`3FOol2O1l]Ool001Qoo`03001oogoo0=Qoo`9l7b]oo`0067oo00<007oo
Ool0fWoo00=l7gooOol0:7oo000HOol2003LOol2O1lXOol001Qoo`03001oogoo0=eoo`03O1moogoo
02Eoo`0067oo00<007ooOol0gWoo00=l7gooOol097oo000;Ool20004Ool20005Ool00`00Oomoo`3O
Ool2O1lTOol000Yoo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol0hGoo0g`O8Goo000=
Ool01000Oomoo`000Woo00<007ooOol00Woo0`00i7oo00=l7gooOol07Woo000;Ool20003Ool01000
Oomoo`0017oo00<007ooOol0ogoo1Woo000;Ool00`00Oomoo`02Ool01000Oomoo`0017oo00<007oo
Ool0ogoo1Woo000;Ool30003Ool20005Ool00`00Oomoo`3oOol6Ool001Qoo`03001oogoo0?moo`Io
o`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol001Eoo`<00?moo`Uoo`005Woo00<007ooOol0ogoo27oo000FOol3003oOol8Ool001Ioo`04
001oogoo003oOol7Ool001Ioo`04001oogoo003oOol7Ool001Eoo`@00?moo`Qoo`00ogoo8Goo003o
OolQOol00?moob5oo`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.106448, -4.21354, \
0.0043288, 0.350206}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.156707 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .09307 -18 -4.5 ]
[.01131 .09307 0 4.5 ]
[.01131 .17142 -6 -4.5 ]
[.01131 .17142 0 4.5 ]
[.01131 .24978 -18 -4.5 ]
[.01131 .24978 0 4.5 ]
[.01131 .32813 -6 -4.5 ]
[.01131 .32813 0 4.5 ]
[.01131 .40648 -18 -4.5 ]
[.01131 .40648 0 4.5 ]
[.01131 .48484 -6 -4.5 ]
[.01131 .48484 0 4.5 ]
[.01131 .56319 -18 -4.5 ]
[.01131 .56319 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .09307 m
.03006 .09307 L
s
[(0.5)] .01131 .09307 1 0 Mshowa
.02381 .17142 m
.03006 .17142 L
s
[(1)] .01131 .17142 1 0 Mshowa
.02381 .24978 m
.03006 .24978 L
s
[(1.5)] .01131 .24978 1 0 Mshowa
.02381 .32813 m
.03006 .32813 L
s
[(2)] .01131 .32813 1 0 Mshowa
.02381 .40648 m
.03006 .40648 L
s
[(2.5)] .01131 .40648 1 0 Mshowa
.02381 .48484 m
.03006 .48484 L
s
[(3)] .01131 .48484 1 0 Mshowa
.02381 .56319 m
.03006 .56319 L
s
[(3.5)] .01131 .56319 1 0 Mshowa
.125 Mabswid
.02381 .03039 m
.02756 .03039 L
s
.02381 .04606 m
.02756 .04606 L
s
.02381 .06173 m
.02756 .06173 L
s
.02381 .0774 m
.02756 .0774 L
s
.02381 .10874 m
.02756 .10874 L
s
.02381 .12441 m
.02756 .12441 L
s
.02381 .14008 m
.02756 .14008 L
s
.02381 .15575 m
.02756 .15575 L
s
.02381 .18709 m
.02756 .18709 L
s
.02381 .20276 m
.02756 .20276 L
s
.02381 .21843 m
.02756 .21843 L
s
.02381 .23411 m
.02756 .23411 L
s
.02381 .26545 m
.02756 .26545 L
s
.02381 .28112 m
.02756 .28112 L
s
.02381 .29679 m
.02756 .29679 L
s
.02381 .31246 m
.02756 .31246 L
s
.02381 .3438 m
.02756 .3438 L
s
.02381 .35947 m
.02756 .35947 L
s
.02381 .37514 m
.02756 .37514 L
s
.02381 .39081 m
.02756 .39081 L
s
.02381 .42215 m
.02756 .42215 L
s
.02381 .43782 m
.02756 .43782 L
s
.02381 .45349 m
.02756 .45349 L
s
.02381 .46917 m
.02756 .46917 L
s
.02381 .50051 m
.02756 .50051 L
s
.02381 .51618 m
.02756 .51618 L
s
.02381 .53185 m
.02756 .53185 L
s
.02381 .54752 m
.02756 .54752 L
s
.02381 .57886 m
.02756 .57886 L
s
.02381 .59453 m
.02756 .59453 L
s
.02381 .6102 m
.02756 .6102 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.02846 .01472 L
.03068 .01472 L
.03178 .01472 L
.03279 .01472 L
.03398 .01472 L
.03527 .01472 L
.03754 .01472 L
.04016 .01473 L
.04144 .01473 L
.04262 .01473 L
.04375 .01473 L
.04482 .01473 L
.0472 .01474 L
.04981 .01474 L
.05109 .01475 L
.05224 .01475 L
.05346 .01476 L
.0546 .01476 L
.05712 .01477 L
.05966 .01478 L
.061 .01479 L
.06244 .0148 L
.0651 .01482 L
.06757 .01484 L
.07299 .01488 L
.08269 .015 L
.08857 .01509 L
.09414 .0152 L
.10458 .01545 L
.11423 .01575 L
.12449 .01614 L
.14291 .01708 L
.16238 .01844 L
.18066 .02011 L
.21935 .02506 L
.23939 .02847 L
.26049 .03273 L
.2986 .04232 L
.33916 .05527 L
.3782 .07046 L
.4197 .08943 L
.45968 .11031 L
.49815 .13441 L
.53907 .16694 L
.57847 .20565 L
.61636 .25016 L
.6567 .30603 L
.69552 .36855 L
.7368 .44501 L
Mistroke
.77656 .52904 L
Mfstroke
.77656 .52904 m
.81396 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo0012Ool2
0004Ool20003Ool4000OOol20004Ool20005Ool3000OOol20004Ool20003Ool3000POol20004Ool2
0004Ool2000UOol5000KOol0045oo`04001oogoo0008Ool00`00Oomoo`0OOol01000Oomoo`002goo
00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`0027oo00@007ooOol0
02Ioo`03001oogoo01]oo`00@Goo00@007ooOol000Uoo`03001oogoo01ioo`04001oogoo0008Ool5
000NOol01000Oomoo`0027oo00@007ooOol001ioo`04001oogoo0008Ool01000Oomoo`009Woo00<0
07ooOol06goo0011Ool01000Oomoo`002Woo00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo
000OOol01000Oomoo`0027oo0`007goo00@007ooOol000Uoo`8002Moo`03001oogoo01]oo`00@Goo
00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`002Goo00<007oo00007goo00@007ooOol0
00Uoo`03001oogoo01ioo`04001oogoo0008Ool01000Oomoo`009Woo00<007ooOol06goo0012Ool2
000:Ool2000POol2000;Ool2000POol2000:Ool3000OOol2000:Ool2000VOol2000MOol00?moob5o
o`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo0?Aoo`80
00aoo`006goo00<007ooOol0lgoo00@007ooOol000]oo`005Goo1P009G`0b@0027oo00<007ooOol0
37oo000KOol00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Ooml0006O002Ool0
0`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool0
0`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool0
0`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09Ool0
0`00Oomoo`08Ool00`00Oomoo`0;Ool5000;Ool001]oo`03001oogoo02Uoo`Ml0<=oo`03001oogoo
00aoo`006goo0P00<Goo1G`0cGoo000KOol00`00Oomoo`0eOol5O038Ool001]oo`03001oogoo03Yo
o`Al0<Aoo`006goo00<007ooOol0?Woo17`0`7oo000KOol20013Ool4O02lOol001]oo`03001oogoo
04Ioo`=l0;Uoo`006goo00<007ooOol0BGoo0g`0]Woo000KOol00`00Oomoo`1<Ool2O02dOol001]o
o`8004moo`9l0;9oo`006goo00<007ooOol0D7oo0W`0/7oo000KOol00`00Oomoo`1BOol3O02]Ool0
01]oo`03001oogoo05Eoo`9l0:]oo`006goo0P00F7oo0W`0ZGoo000KOol00`00Oomoo`1IOol2O02W
Ool000Qoo`8000Aoo`8000Aoo`8000Eoo`03001oogoo05]oo`9l0:Eoo`001goo00@007ooOol000Qo
o`04001oogoo0004Ool00`00Oomoo`1MOol2O02SOol000Moo`04001oogoo000;Ool00`00Oomoo`02
Ool3001OOol2O02QOol000Moo`04001oogoo0009Ool20005Ool00`00Oomoo`1QOol2O02OOol000Mo
o`04001oogoo0009Ool00`00Oomoo`04Ool00`00Oomoo`1SOol2O02MOol000Qoo`8000Yoo`<000Ao
o`8006Ioo`9l09]oo`006goo00<007ooOol0Igoo00=l07ooOol0V7oo000KOol00`00Oomoo`1XOol2
O02HOol001]oo`03001oogoo06Yoo`03O01oogoo09Eoo`006goo0P00K7oo0W`0UGoo000KOol00`00
Oomoo`1]Ool00g`0Oomoo`2BOol001]oo`03001oogoo06ioo`9l099oo`006goo00<007ooOol0L7oo
00=l07ooOol0Sgoo000KOol2001bOol00g`0Oomoo`2>Ool001]oo`03001oogoo079oo`9l08ioo`00
6goo00<007ooOol0M7oo00=l07ooOol0Rgoo000KOol00`00Oomoo`1eOol00g`0Oomoo`2:Ool001]o
o`8007Moo`03O01oogoo08Uoo`006goo00<007ooOol0Mgoo0W`0RGoo000COol50003Ool00`00Oomo
o`1iOol00g`0Oomoo`26Ool001Eoo`03001oogoo00=oo`03001oogoo07Yoo`03O01oogoo08Eoo`00
5Goo00<007ooOol00goo0`00Ngoo00=l07ooOol0Q7oo000EOol00`00Oomoo`03Ool00`00Oomoo`1l
Ool00g`0Oomoo`23Ool001Eoo`03001oogoo00=oo`03001oogoo07eoo`03O01oogoo089oo`0057oo
0P001Goo0P00Ogoo00=l07ooOol0PGoo000KOol00`00Oomoo`1oOol2O021Ool001]oo`03001oogoo
085oo`03O01oogoo07ioo`006goo00<007ooOol0PWoo00=l07ooOol0OGoo000KOol20024Ool00g`0
Oomoo`1lOol001]oo`03001oogoo08Aoo`03O01oogoo07]oo`006goo00<007ooOol0QGoo00=l07oo
Ool0NWoo000KOol00`00Oomoo`26Ool00g`0Oomoo`1iOol001]oo`8008Moo`03O01oogoo07Uoo`00
6goo00<007ooOol0Qgoo00=l07ooOol0N7oo000KOol00`00Oomoo`28Ool00g`0Oomoo`1gOol001]o
o`03001oogoo08Uoo`03O01oogoo07Ioo`006goo0P00Rgoo00=l07ooOol0MGoo000KOol00`00Oomo
o`2;Ool00g`0Oomoo`1dOol000Moo`D0009oo`8000Aoo`8000Eoo`03001oogoo08]oo`03O01oogoo
07Aoo`002Goo00<007ooOol01goo00@007ooOol000Aoo`03001oogoo08aoo`03O01oogoo07=oo`00
2Goo00<007ooOol02Woo00<007ooOol00Woo0`00SGoo00=l07ooOol0LWoo0009Ool00`00Oomoo`08
Ool20005Ool00`00Oomoo`2>Ool00g`0Oomoo`1aOol000Uoo`03001oogoo00Qoo`03001oogoo00Ao
o`03001oogoo08moo`03O01oogoo071oo`0027oo0P002Woo0`0017oo0P00T7oo00=l07ooOol0L7oo
000KOol00`00Oomoo`2@Ool00g`0Oomoo`1_Ool001]oo`03001oogoo095oo`03O01oogoo06ioo`00
6goo00<007ooOol0TWoo00=l07ooOol0KGoo000KOol2002COol00g`0Oomoo`1]Ool001]oo`03001o
ogoo09=oo`03O01oogoo06aoo`006goo00<007ooOol0U7oo00=l07ooOol0Jgoo000KOol00`00Oomo
o`2EOol00g`0Oomoo`1ZOol001]oo`8009Ioo`03O01oogoo06Yoo`006goo00<007ooOol0UWoo00=l
07ooOol0JGoo000KOol00`00Oomoo`2GOol00g`0Oomoo`1XOol001]oo`03001oogoo09Qoo`03O01o
ogoo06Moo`006goo0P00VGoo00=l07ooOol0Igoo000KOol00`00Oomoo`2IOol00g`0Oomoo`1VOol0
01=oo`@000Aoo`03001oogoo09Uoo`03O01oogoo06Ioo`004goo00<007ooOol01Goo00<007ooOol0
VWoo00=l07ooOol0IGoo000DOol00`00Oomoo`04Ool3002KOol00g`0Oomoo`1TOol001Eoo`03001o
ogoo00=oo`03001oogoo09]oo`03O01oogoo06Aoo`004goo00@007ooOol000Aoo`03001oogoo09ao
o`03O01oogoo06=oo`0057oo0P001Goo0P00WGoo00=l07ooOol0Hgoo000KOol00`00Oomoo`2MOol0
0g`0Oomoo`1ROol001]oo`03001oogoo09ioo`03O01oogoo065oo`006goo00<007ooOol0WWoo00=l
07ooOol0HGoo000KOol2002POol00g`0Oomoo`1POol001]oo`03001oogoo09moo`03O01oogoo061o
o`006goo00<007ooOol0X7oo00=l07ooOol0Ggoo000KOol00`00Oomoo`2QOol00g`0Oomoo`1NOol0
01]oo`800:9oo`03O01oogoo05ioo`006goo00<007ooOol0XWoo00=l07ooOol0GGoo000KOol00`00
Oomoo`2ROol00g`0Oomoo`1MOol001]oo`03001oogoo0:=oo`03O01oogoo05aoo`006goo0P00Y7oo
00=l07ooOol0G7oo000KOol00`00Oomoo`2TOol00g`0Oomoo`1KOol000Moo`@000=oo`8000Aoo`80
00Eoo`03001oogoo0:Aoo`03O01oogoo05]oo`001goo00<007ooOol02Goo00@007ooOol000Aoo`03
001oogoo0:Eoo`03O01oogoo05Yoo`0027oo00<007ooOol02goo00<007ooOol00Woo0`00YGoo00=l
07ooOol0FWoo0009Ool00`00Oomoo`08Ool20005Ool00`00Oomoo`2VOol00g`0Oomoo`1IOol000Mo
o`04001oogoo0009Ool00`00Oomoo`04Ool00`00Oomoo`2VOol00g`0Oomoo`1IOol000Qoo`8000Yo
o`<000Aoo`800:Qoo`03O01oogoo05Qoo`006goo00<007ooOol0Ygoo00=l07ooOol0F7oo000KOol0
0`00Oomoo`2XOol00g`0Oomoo`1GOol001]oo`03001oogoo0:Qoo`03O01oogoo05Moo`006goo0P00
ZWoo00=l07ooOol0EWoo000KOol00`00Oomoo`2YOol00g`0Oomoo`1FOol001]oo`03001oogoo0:Yo
o`03O01oogoo05Eoo`006goo00<007ooOol0Zgoo00=l07ooOol0E7oo000KOol2002/Ool00g`0Oomo
o`1DOol001]oo`03001oogoo0:aoo`03O01oogoo05=oo`006goo00<007ooOol0[7oo00=l07ooOol0
Dgoo000KOol00`00Oomoo`2]Ool00g`0Oomoo`1BOol001]oo`800:ioo`03O01oogoo059oo`006goo
00<007ooOol0[Woo00=l07ooOol0DGoo000DOol20005Ool00`00Oomoo`2^Ool00g`0Oomoo`1AOol0
01=oo`04001oogoo0004Ool00`00Oomoo`2_Ool00g`0Oomoo`1@Ool001Eoo`03001oogoo00=oo`<0
0:moo`03O01oogoo051oo`005Woo00<007ooOol00Woo00<007ooOol0/7oo00=l07ooOol0Cgoo000C
Ool01000Oomoo`0017oo00<007ooOol0/7oo00=l07ooOol0Cgoo000DOol20005Ool2002bOol00g`0
Oomoo`1>Ool001]oo`03001oogoo0;5oo`03O01oogoo04ioo`006goo00<007ooOol0/Woo00=l07oo
Ool0CGoo000KOol00`00Oomoo`2bOol00g`0Oomoo`1=Ool001]oo`800;Aoo`03O01oogoo04aoo`00
6goo00<007ooOol0/goo00=l07ooOol0C7oo000KOol00`00Oomoo`2dOol00g`0Oomoo`1;Ool001]o
o`03001oogoo0;Aoo`03O01oogoo04]oo`006goo0P00]Goo00=l07ooOol0Bgoo000KOol00`00Oomo
o`2eOol00g`0Oomoo`1:Ool001]oo`03001oogoo0;Eoo`03O01oogoo04Yoo`006goo00<007ooOol0
]Woo00=l07ooOol0BGoo000KOol2002gOol00g`0Oomoo`19Ool001]oo`03001oogoo0;Ioo`03O01o
ogoo04Uoo`0027oo0P0017oo0P0017oo0P001Goo00<007ooOol0]goo00=l07ooOol0B7oo0007Ool0
1000Oomoo`0027oo00@007ooOol000Aoo`03001oogoo0;Moo`03O01oogoo04Qoo`002Goo00<007oo
Ool02Woo00<007ooOol00Woo0`00^7oo00=l07ooOol0Agoo000:Ool00`00Oomoo`07Ool20005Ool0
0`00Oomoo`2hOol00g`0Oomoo`17Ool000Moo`04001oogoo0009Ool00`00Oomoo`04Ool00`00Oomo
o`2hOol00g`0Oomoo`17Ool000Qoo`8000Yoo`<000Aoo`800;Yoo`03O01oogoo04Ioo`006goo00<0
07ooOol0^Goo00=l07ooOol0AWoo000KOol00`00Oomoo`2jOol00g`0Oomoo`15Ool001]oo`03001o
ogoo0;Yoo`03O01oogoo04Eoo`006goo0P00_7oo00=l07ooOol0A7oo000KOol00`00Oomoo`2kOol0
0g`0Oomoo`14Ool001]oo`03001oogoo0;]oo`03O01oogoo04Aoo`006goo00<007ooOol0_7oo00=l
07ooOol0@goo000KOol2002mOol00g`0Oomoo`13Ool001]oo`03001oogoo0;eoo`03O01oogoo049o
o`006goo00<007ooOol0_Goo00=l07ooOol0@Woo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol001Yoo`@00?mo
o`=oo`006Goo00@007ooOol00?moo`Aoo`006Goo00@007ooOol00?moo`Aoo`0067oo0P0000=oo`00
0000ogoo17oo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.119435, -0.316529, \
0.0043288, 0.0263081}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.0255919 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .14267 -6 -4.5 ]
[.01131 .14267 0 4.5 ]
[.01131 .27063 -12 -4.5 ]
[.01131 .27063 0 4.5 ]
[.01131 .39859 -12 -4.5 ]
[.01131 .39859 0 4.5 ]
[.01131 .52655 -12 -4.5 ]
[.01131 .52655 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .14267 m
.03006 .14267 L
s
[(5)] .01131 .14267 1 0 Mshowa
.02381 .27063 m
.03006 .27063 L
s
[(10)] .01131 .27063 1 0 Mshowa
.02381 .39859 m
.03006 .39859 L
s
[(15)] .01131 .39859 1 0 Mshowa
.02381 .52655 m
.03006 .52655 L
s
[(20)] .01131 .52655 1 0 Mshowa
.125 Mabswid
.02381 .04031 m
.02756 .04031 L
s
.02381 .0659 m
.02756 .0659 L
s
.02381 .09149 m
.02756 .09149 L
s
.02381 .11708 m
.02756 .11708 L
s
.02381 .16827 m
.02756 .16827 L
s
.02381 .19386 m
.02756 .19386 L
s
.02381 .21945 m
.02756 .21945 L
s
.02381 .24504 m
.02756 .24504 L
s
.02381 .29623 m
.02756 .29623 L
s
.02381 .32182 m
.02756 .32182 L
s
.02381 .34741 m
.02756 .34741 L
s
.02381 .373 m
.02756 .373 L
s
.02381 .42419 m
.02756 .42419 L
s
.02381 .44978 m
.02756 .44978 L
s
.02381 .47537 m
.02756 .47537 L
s
.02381 .50096 m
.02756 .50096 L
s
.02381 .55215 m
.02756 .55215 L
s
.02381 .57774 m
.02756 .57774 L
s
.02381 .60333 m
.02756 .60333 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 0 r
.5 Mabswid
.02381 .01472 m
.02846 .01473 L
.03068 .01473 L
.03178 .01473 L
.03279 .01474 L
.03398 .01475 L
.03527 .01477 L
.03754 .0148 L
.04016 .01484 L
.04144 .01486 L
.04262 .01488 L
.04375 .01491 L
.04482 .01494 L
.0472 .01501 L
.04981 .01509 L
.05109 .01512 L
.05224 .01516 L
.05346 .01521 L
.0546 .01526 L
.05712 .01536 L
.06244 .0156 L
.07299 .0162 L
.08269 .01689 L
.10458 .01892 L
.1234 .02115 L
.14407 .02412 L
.18449 .03131 L
.2234 .03974 L
.26476 .04994 L
.30461 .06051 L
.34294 .07096 L
.38372 .08189 L
.42298 .09178 L
.44268 .09637 L
.4513 .09828 L
.45619 .0996 L
.45853 .10025 L
.46074 .10088 L
.46188 .1012 L
.46312 .10196 L
.46529 .10331 L
.47016 .10633 L
.48008 .1126 L
.50094 .12624 L
.54186 .15479 L
.58126 .1845 L
.61915 .21514 L
.65949 .24998 L
.69831 .28569 L
.73959 .32598 L
Mistroke
.77935 .36707 L
.81759 .4087 L
.85829 .45526 L
.89747 .50229 L
.93911 .55464 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo000oOol2
0004Ool20003Ool4000OOol20004Ool20005Ool3000OOol20004Ool20003Ool3000POol20004Ool2
0004Ool2000UOol5000NOol003ioo`04001oogoo0008Ool00`00Oomoo`0OOol01000Oomoo`002goo
00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`0027oo00@007ooOol0
02Ioo`03001oogoo01ioo`00?Woo00@007ooOol000Uoo`03001oogoo01ioo`04001oogoo0008Ool5
000NOol01000Oomoo`0027oo00@007ooOol001ioo`04001oogoo0008Ool01000Oomoo`009Woo00<0
07ooOol07Woo000nOol01000Oomoo`002Woo00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo
000OOol01000Oomoo`0027oo0`007goo00@007ooOol000Uoo`8002Moo`03001oogoo01ioo`00?Woo
00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`002Goo00<007oo00007goo00@007ooOol0
00Uoo`03001oogoo01ioo`04001oogoo0008Ool01000Oomoo`009Woo00<007ooOol07Woo000oOol2
000:Ool2000POol2000;Ool2000POol2000:Ool3000OOol2000:Ool2000VOol2000POol00?moob5o
o`0067oo00<007ooOol0ogoo1Woo000HOol00`00Oomoo`3oOol6Ool001Qoo`03001oogoo0?Aoo`80
00moo`0067oo00<007ooOol0lgoo00@007ooOol000ioo`004Woo1P004P?Pg00027oo00<007ooOol0
3goo000HOol00`00Oomoo`09Ool00`00Oomoo`03Ool90n08Ool00`00Oomoo`08Ool00`00Oomoo`09
Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09
Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08
Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`08
Ool00`00Oomoo`0;Ool5000>Ool001Qoo`03001oogoo01Qoo`D3h=Ioo`03001oogoo00moo`0067oo
00<007ooOol07Goo1@?Phgoo000HOol00`00Oomoo`0ROol50n3NOol001Qoo`03001oogoo02Moo`D3
h=Uoo`0067oo0P00;Goo1@?Pe7oo000HOol00`00Oomoo`0aOol50n3?Ool001Qoo`03001oogoo03Io
o`@3h<]oo`0067oo00<007ooOol0>Woo0`?Pb7oo000HOol00`00Oomoo`0mOol30n35Ool001Qoo`03
001oogoo041oo`@3h<5oo`0067oo0P00AGoo1@?P_7oo000HOol00`00Oomoo`19Ool40n2hOol001Qo
o`03001oogoo04eoo`<3h;Eoo`0067oo00<007ooOol0D7oo0`?P/Woo000HOol00`00Oomoo`1COol4
0n2^Ool001Qoo`03001oogoo05Moo`D3h:Uoo`0067oo0P00GGoo1@?PY7oo000HOol00`00Oomoo`1Q
Ool40n2POol001Qoo`03001oogoo06Eoo`<3h9eoo`0067oo00<007ooOol0Igoo0P?PW7oo000HOol0
0`00Oomoo`1YOol20n2JOol001Qoo`03001oogoo06]oo`83h9Qoo`0067oo0P00KWoo00<3h7ooOol0
UGoo000HOol00`00Oomoo`1^Ool20n2EOol001Qoo`03001oogoo071oo`030n1oogoo099oo`0067oo
00<007ooOol0LGoo00<3h7ooOol0TGoo000HOol00`00Oomoo`1bOol20n2AOol0015oo`8000Eoo`03
001oogoo07Aoo`030n1oogoo08ioo`0047oo00@007ooOol000Aoo`03001oogoo07Eoo`030n1oogoo
08eoo`004goo00<007ooOol00Woo0`00MWoo0P?PSGoo000AOol20005Ool00`00Oomoo`1hOol00`?P
Oomoo`2:Ool0015oo`03001oogoo00Aoo`03001oogoo07Uoo`83h8Yoo`004Goo0`0017oo00<007oo
Ool0Ngoo00<3h7ooOol0Qgoo000HOol00`00Oomoo`1lOol00`?POomoo`26Ool001Qoo`03001oogoo
07eoo`83h8Ioo`0067oo0P00P7oo00<3h7ooOol0Pgoo000HOol00`00Oomoo`20Ool00`?POomoo`22
Ool001Qoo`03001oogoo085oo`83h89oo`0067oo00<007ooOol0Pgoo00<3h7ooOol0Ogoo000HOol0
0`00Oomoo`24Ool00`?POomoo`1nOol001Qoo`03001oogoo08Eoo`030n1oogoo07eoo`0067oo0P00
Qgoo0P?POGoo000HOol00`00Oomoo`28Ool00`?POomoo`1jOol001Qoo`03001oogoo08Uoo`030n1o
ogoo07Uoo`0067oo00<007ooOol0RWoo0P?PNGoo000HOol00`00Oomoo`2<Ool00`?POomoo`1fOol0
01Qoo`03001oogoo08eoo`030n1oogoo07Eoo`0067oo0P00Sgoo00<3h7ooOol0M7oo000HOol00`00
Oomoo`2?Ool00`?POomoo`1cOol001Qoo`03001oogoo091oo`030n1oogoo079oo`0067oo00<007oo
Ool0TGoo00<3h7ooOol0LGoo000HOol00`00Oomoo`2BOol20n1aOol001Qoo`03001oogoo09Aoo`03
0n1oogoo06ioo`0067oo0P00UWoo00<3h7ooOol0KGoo000HOol00`00Oomoo`2FOol00`?POomoo`1/
Ool001Qoo`03001oogoo09Moo`030n1oogoo06]oo`0067oo00<007ooOol0V7oo00<3h7ooOol0JWoo
000HOol00`00Oomoo`2IOol20n1ZOol000Yoo`D0009oo`8000Eoo`03001oogoo09]oo`030n1oogoo
06Moo`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo09aoo`030n1oogoo06Io
o`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`<009eoo`030n1oogoo06Eoo`0037oo00D0
07ooOomoo`00009oo`03001oogoo009oo`03001oogoo09ioo`83h6Eoo`0037oo00D007ooOomoo`00
009oo`03001oogoo009oo`03001oogoo0:1oo`030n1oogoo069oo`002goo0P0017oo0P001Goo00<0
07ooOol0XGoo00<3h7ooOol0HGoo000HOol00`00Oomoo`2ROol00`?POomoo`1POol001Qoo`03001o
ogoo0:=oo`030n1oogoo05moo`0067oo0P00YGoo00<3h7ooOol0GWoo000HOol00`00Oomoo`2UOol0
0`?POomoo`1MOol001Qoo`03001oogoo0:Ioo`030n1oogoo05aoo`0067oo00<007ooOol0Ygoo00<3
h7ooOol0Fgoo000HOol00`00Oomoo`2XOol00`?POomoo`1JOol001Qoo`03001oogoo0:Uoo`030n1o
ogoo05Uoo`0067oo0P00Zgoo00<3h7ooOol0F7oo000HOol00`00Oomoo`2[Ool00`?POomoo`1GOol0
01Qoo`03001oogoo0:aoo`030n1oogoo05Ioo`0067oo00<007ooOol0[Goo00<3h7ooOol0EGoo000H
Ool00`00Oomoo`2^Ool00`?POomoo`1DOol001Qoo`03001oogoo0:moo`030n1oogoo05=oo`0067oo
0P00/7oo00<3h7ooOol0Dgoo000HOol00`00Oomoo`2`Ool00`?POomoo`1BOol001Qoo`03001oogoo
0;5oo`030n1oogoo055oo`0067oo00<007ooOol0/Woo00<3h7ooOol0D7oo000HOol00`00Oomoo`2c
Ool00`?POomoo`1?Ool001Qoo`03001oogoo0;Aoo`030n1oogoo04ioo`0067oo0P00]Woo00<3h7oo
Ool0CGoo000HOol00`00Oomoo`2fOol00`?POomoo`1<Ool001Qoo`03001oogoo0;Moo`030n1oogoo
04]oo`0067oo00<007ooOol0^7oo00<3h7ooOol0BWoo000HOol00`00Oomoo`2iOol00`?POomoo`19
Ool000Yoo`D0009oo`8000Eoo`03001oogoo0;Yoo`030n1oogoo04Qoo`0037oo00D007ooOomoo`00
009oo`03001oogoo009oo`03001oogoo0;]oo`030n1oogoo04Moo`0037oo00<007ooOol017oo00<0
07ooOol00Woo0`00_7oo00<3h7ooOol0AWoo000<Ool00`00Oomoo`02Ool20005Ool00`00Oomoo`2m
Ool00`?POomoo`15Ool000aoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo0;ioo`030n1o
ogoo04Aoo`002goo0P0017oo0`0017oo00<007ooOol0_goo00<3h7ooOol0@goo000HOol00`00Oomo
o`30Ool00`?POomoo`12Ool001Qoo`03001oogoo0<5oo`030n1oogoo045oo`0067oo0P00`goo00<3
h7ooOol0@7oo000HOol00`00Oomoo`33Ool00`?POomoo`0oOol001Qoo`03001oogoo0<=oo`030n1o
ogoo03moo`0067oo00<007ooOol0a7oo00<3h7ooOol0?Woo000HOol00`00Oomoo`35Ool00`?POomo
o`0mOol001Qoo`03001oogoo0<Ioo`030n1oogoo03aoo`0067oo0P00b7oo00<3h7ooOol0>goo000H
Ool00`00Oomoo`38Ool00`?POomoo`0jOol001Qoo`03001oogoo0<Uoo`030n1oogoo03Uoo`0067oo
00<007ooOol0bWoo00<3h7ooOol0>7oo000HOol00`00Oomoo`3:Ool00`?POomoo`0hOol001Qoo`03
001oogoo0<]oo`030n1oogoo03Moo`0067oo0P00cGoo00<3h7ooOol0=Woo000HOol00`00Oomoo`3=
Ool00`?POomoo`0eOol001Qoo`03001oogoo0<eoo`030n1oogoo03Eoo`0067oo00<007ooOol0cWoo
00<3h7ooOol0=7oo000HOol00`00Oomoo`3?Ool00`?POomoo`0cOol001Qoo`03001oogoo0=1oo`03
0n1oogoo039oo`0067oo00<007ooOol0d7oo00<3h7ooOol0<Woo000HOol2003BOol00`?POomoo`0a
Ool001Qoo`03001oogoo0=9oo`030n1oogoo031oo`0067oo00<007ooOol0dgoo00<3h7ooOol0;goo
000HOol00`00Oomoo`3COol00`?POomoo`0_Ool000Yoo`@000=oo`8000Eoo`03001oogoo0=Aoo`03
0n1oogoo02ioo`002Woo00<007ooOol00goo00@007ooOol000Aoo`03001oogoo0=Eoo`030n1oogoo
02eoo`002goo00<007ooOol00Woo00@007ooOol000Aoo`<00=Ioo`030n1oogoo02aoo`0037oo00D0
07ooOomoo`00009oo`03001oogoo009oo`03001oogoo0=Ioo`030n1oogoo02aoo`002Woo00@007oo
Ool0009oo`04001oogoo0004Ool00`00Oomoo`3GOol00`?POomoo`0[Ool000]oo`8000Aoo`8000Eo
o`03001oogoo0=Qoo`030n1oogoo02Yoo`0067oo00<007ooOol0fGoo00<3h7ooOol0:Goo000HOol0
0`00Oomoo`3IOol00`?POomoo`0YOol001Qoo`800=]oo`030n1oogoo02Qoo`0067oo00<007ooOol0
fgoo00<3h7ooOol09goo000HOol00`00Oomoo`3LOol00`?POomoo`0VOol001Qoo`03001oogoo0=eo
o`030n1oogoo02Eoo`0067oo00<007ooOol0gGoo00<3h7ooOol09Goo000HOol00`00Oomoo`3NOol0
0`?POomoo`0TOol001Qoo`800>1oo`030n1oogoo02=oo`0067oo00<007ooOol0h7oo00<3h7ooOol0
8Woo000HOol00`00Oomoo`3QOol00`?POomoo`0QOol001Qoo`03001oogoo0>9oo`030n1oogoo021o
o`0067oo00<007ooOol0hWoo00<3h7ooOol087oo000HOol00`00Oomoo`3SOol00`?POomoo`0OOol0
01Qoo`800>Eoo`030n1oogoo01ioo`0067oo00<007ooOol0ogoo1Woo000HOol00`00Oomoo`3oOol6
Ool001Qoo`03001oogoo0?moo`Ioo`0067oo00<007ooOol0ogoo1Woo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQ
Ool001Moo`800?moo`Qoo`005goo0P00ogoo27oo000FOol01000Oomoo`00ogoo1goo000EOol20002
Ool2003oOol6Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.106448, -1.9382, \
0.0043288, 0.161092}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.0117721 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .13244 -12 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -12 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -12 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -12 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -12 -4.5 ]
[.01131 .60332 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .13244 m
.03006 .13244 L
s
[(10)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(20)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(30)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(40)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(50)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03826 m
.02756 .03826 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .08535 m
.02756 .08535 L
s
.02381 .10889 m
.02756 .10889 L
s
.02381 .15598 m
.02756 .15598 L
s
.02381 .17952 m
.02756 .17952 L
s
.02381 .20307 m
.02756 .20307 L
s
.02381 .22661 m
.02756 .22661 L
s
.02381 .2737 m
.02756 .2737 L
s
.02381 .29724 m
.02756 .29724 L
s
.02381 .32079 m
.02756 .32079 L
s
.02381 .34433 m
.02756 .34433 L
s
.02381 .39142 m
.02756 .39142 L
s
.02381 .41497 m
.02756 .41497 L
s
.02381 .43851 m
.02756 .43851 L
s
.02381 .46205 m
.02756 .46205 L
s
.02381 .50914 m
.02756 .50914 L
s
.02381 .53269 m
.02756 .53269 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .57977 m
.02756 .57977 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .01472 m
.06244 .03845 L
.10458 .06329 L
.14415 .08461 L
.18221 .10236 L
.22272 .11752 L
.24141 .123 L
.26171 .1278 L
.27279 .12987 L
.28302 .13144 L
.29279 .13263 L
.2982 .13316 L
.30316 .13355 L
.30765 .13386 L
.31257 .13409 L
.31526 .13419 L
.31657 .13424 L
.31776 .13428 L
.31899 .13433 L
.32014 .13433 L
.32269 .13435 L
.32492 .13436 L
.32613 .13436 L
.32727 .13437 L
.32824 .13437 L
.32928 .13436 L
.33043 .13433 L
.33148 .1343 L
.336 .13418 L
.33724 .13415 L
.33794 .13413 L
.33857 .1341 L
.34099 .13396 L
.3458 .13368 L
.3509 .13328 L
.36008 .13238 L
.37019 .13106 L
.38084 .12931 L
.40058 .12513 L
.41894 .12017 L
.42947 .11688 L
.4394 .11348 L
.44373 .11193 L
.44832 .1102 L
.45072 .10929 L
.45137 .10904 L
.45208 .10878 L
.45335 .12667 L
.45799 .21278 L
.46054 .26005 L
Mistroke
.46127 .27366 L
.46196 .28551 L
.46325 .2863 L
.46812 .28931 L
.47916 .29614 L
.49927 .30856 L
.53787 .33242 L
.57892 .35779 L
.61846 .38223 L
.65649 .40573 L
.69696 .43075 L
.73593 .45483 L
.77734 .48042 L
.81724 .50508 L
.85562 .5288 L
.89645 .55404 L
.93577 .57834 L
.97357 .6017 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo000oOol2
0004Ool20003Ool4000OOol20004Ool20005Ool3000OOol20004Ool20003Ool3000POol20004Ool2
0004Ool2000UOol5000NOol003ioo`04001oogoo0008Ool00`00Oomoo`0OOol01000Oomoo`002goo
00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`0027oo00@007ooOol0
02Ioo`03001oogoo01ioo`00?Woo00@007ooOol000Uoo`03001oogoo01ioo`04001oogoo0008Ool5
000NOol01000Oomoo`0027oo00@007ooOol001ioo`04001oogoo0008Ool01000Oomoo`009Woo00<0
07ooOol07Woo000nOol01000Oomoo`002Woo00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo
000OOol01000Oomoo`0027oo0`007goo00@007ooOol000Uoo`8002Moo`03001oogoo01ioo`00?Woo
00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`002Goo00<007oo00007goo00@007ooOol0
00Uoo`03001oogoo01ioo`04001oogoo0008Ool01000Oomoo`009Woo00<007ooOol07Woo000oOol2
000:Ool2000POol2000;Ool2000POol2000:Ool3000OOol2000:Ool2000VOol2000POol00?moob5o
o`0067oo00<007ooOol0ogoo1Woo000HOol00`00Oomoo`3oOol6Ool001Qoo`03001oogoo0?Aoo`80
00moo`0067oo00<007ooOol0lgoo00@007ooOol000ioo`004Woo1P0000<07`000000j`0027oo00<0
07ooOol03goo000HOol00`0001l07`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08
Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09
Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09
Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09
Ool00`00Oomoo`08Ool00`00Oomoo`0;Ool5000>Ool001Qoo`03001oogoo00807o5oo`03001oogoo
00moo`0067oo00<007ooOol00Woo0P0Oogoo0Woo000HOol00`00Oomoo`04Ool201ooOol001Qoo`80
00Moo`0301moogoo0?aoo`0067oo00<007ooOol01goo0P0Oo7oo000HOol00`00Oomoo`09Ool201oj
Ool001Qoo`03001oogoo00]oo`807oQoo`0067oo00<007ooOol03Goo0P0OmWoo000HOol00`00Oomo
o`0?Ool201odOol001Qoo`80019oo`0301moogoo0?5oo`0067oo00<007ooOol04Woo0P0OlGoo000H
Ool00`00Oomoo`0DOol00`0OOomoo`3^Ool001Qoo`03001oogoo01Eoo`807nioo`0067oo00<007oo
Ool05goo00<07gooOol0jgoo000HOol00`00Oomoo`0HOol201o[Ool001Qoo`8001]oo`807nUoo`00
67oo00<007ooOol077oo0P0Oigoo000HOol00`00Oomoo`0NOol301oTOol001Qoo`03001oogoo025o
o`807n9oo`0067oo00<007ooOol08goo0`0Oggoo000HOol2000WOol201lmOol00`0OOomoo`2MOol0
01Qoo`03001oogoo02Qoo`807cUoo`<07imoo`0067oo00<007ooOol0:Woo0P0O<Woo1@0O0Woo00<0
7gooOol0WGoo000HOol00`00Oomoo`0/Ool401l[Ool301l7Ool00`0OOomoo`2MOol000Yoo`D0009o
o`8000Eoo`03001oogoo031oo`D07b5oo`D07`Yoo`0301moogoo09eoo`0037oo00D007ooOomoo`00
009oo`03001oogoo009oo`03001oogoo03Eoo`@07aYoo`<07`moo`0301moogoo09eoo`0037oo00D0
07ooOomoo`00009oo`03001oogoo009oo`<003Uoo`X07`Qoo`P07a9oo`0301moogoo09eoo`0037oo
00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo04=oo`P07aYoo`0301moogoo09eoo`00
37oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo06Eoo`0301moogoo09eoo`002goo
0P0017oo0P001Goo00<007ooOol0IGoo00<07gooOol0WGoo000HOol00`00Oomoo`1UOol00`0OOomo
o`2MOol001Qoo`03001oogoo06Eoo`0301moogoo09eoo`0067oo0P00IWoo00<07gooOol0WGoo000H
Ool00`00Oomoo`1UOol00`0OOomoo`2MOol001Qoo`03001oogoo06Eoo`0301moogoo09eoo`0067oo
00<007ooOol0IGoo00<07gooOol0WGoo000HOol00`00Oomoo`1VOol00`0OOomoo`2LOol001Qoo`03
001oogoo06Ioo`0301moogoo09aoo`0067oo0P00Igoo00<07gooOol0W7oo000HOol00`00Oomoo`1V
Ool00`0OOomoo`2LOol001Qoo`03001oogoo06Ioo`0301moogoo09aoo`0067oo00<007ooOol0IWoo
00<07gooOol0W7oo000HOol00`00Oomoo`1VOol00`0OOomoo`2LOol001Qoo`8006Moo`0301moogoo
09aoo`0067oo00<007ooOol0IWoo00<07gooOol0W7oo000HOol00`00Oomoo`1VOol00`0OOomoo`2L
Ool001Qoo`03001oogoo06Ioo`0301moogoo09aoo`0067oo00<007ooOol0IWoo00<07gooOol0W7oo
000HOol00`00Oomoo`1VOol00`0OOomoo`2LOol001Qoo`8006Moo`0301moogoo09aoo`0067oo00<0
07ooOol0IWoo00<07gooOol0W7oo000HOol00`00Oomoo`1VOol00`0OOomoo`2LOol001Qoo`03001o
ogoo06Moo`0301moogoo09]oo`002Woo10000goo0P001Goo00<007ooOol0Igoo00<07gooOol0Vgoo
000:Ool00`00Oomoo`03Ool01000Oomoo`0017oo00<007ooOol0Igoo00<07gooOol0Vgoo000;Ool0
0`00Oomoo`02Ool01000Oomoo`0017oo0`00Igoo00<07gooOol0Vgoo000<Ool01@00Oomoogoo0000
0Woo00<007ooOol00Woo00<007ooOol0Igoo00<07gooOol0Vgoo000:Ool01000Oomoo`000Woo00@0
07ooOol000Aoo`03001oogoo06Moo`0301moogoo09]oo`002goo0P0017oo0P001Goo00<007ooOol0
Igoo00<07gooOol0Vgoo000HOol00`00Oomoo`1WOol00`0OOomoo`2KOol001Qoo`8006Qoo`0301mo
ogoo09]oo`0067oo00<007ooOol0Igoo00<07gooOol0Vgoo000HOol00`00Oomoo`1WOol00`0OOomo
o`2KOol001Qoo`03001oogoo06Moo`807iaoo`0067oo00<007ooOol0JGoo00<07gooOol0VGoo000H
Ool00`00Oomoo`1ZOol201nIOol001Qoo`8006eoo`0301moogoo09Ioo`0067oo00<007ooOol0KGoo
0P0OUWoo000HOol00`00Oomoo`1_Ool00`0OOomoo`2COol001Qoo`03001oogoo071oo`0301moogoo
099oo`0067oo00<007ooOol0LGoo0P0OTWoo000HOol00`00Oomoo`1cOol201n@Ool001Qoo`8007Io
o`0301moogoo08eoo`0067oo00<007ooOol0MWoo0P0OSGoo000HOol00`00Oomoo`1hOol201n;Ool0
01Qoo`03001oogoo07Yoo`0301moogoo08Qoo`0067oo00<007ooOol0Ngoo0P0OR7oo000HOol00`00
Oomoo`1mOol201n6Ool001Qoo`80081oo`0301moogoo08=oo`0067oo00<007ooOol0P7oo0P0OPgoo
000HOol00`00Oomoo`22Ool201n1Ool000]oo`8000Aoo`8000Eoo`03001oogoo08Aoo`0301moogoo
07ioo`002Woo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`25Ool201mnOol000aoo`05
001oogooOol00002Ool00`00Oomoo`02Ool30027Ool00`0OOomoo`1kOol000eoo`04001oogoo0002
Ool00`00Oomoo`02Ool00`00Oomoo`28Ool201mkOol000Yoo`04001oogoo0002Ool01000Oomoo`00
17oo00<007ooOol0RWoo00<07gooOol0N7oo000;Ool20004Ool20005Ool00`00Oomoo`2;Ool201mh
Ool001Qoo`03001oogoo08eoo`807gIoo`0067oo00<007ooOol0Sgoo0P0OM7oo000HOol2002BOol2
01mbOol001Qoo`03001oogoo09=oo`807g1oo`0067oo00<007ooOol0UGoo0P0OKWoo000HOol00`00
Oomoo`2GOol00`0OOomoo`1[Ool001Qoo`03001oogoo09Qoo`0301moogoo06Yoo`0067oo00<007oo
Ool0VGoo0P0OJWoo000HOol2002LOol00`0OOomoo`1WOol001Qoo`03001oogoo09aoo`0301moogoo
06Ioo`0067oo00<007ooOol0WGoo0P0OIWoo000HOol00`00Oomoo`2OOol00`0OOomoo`1SOol001Qo
o`03001oogoo0:1oo`807f=oo`0067oo0P00Xgoo0P0OHGoo000HOol00`00Oomoo`2TOol201mOOol0
01Qoo`03001oogoo0:Ioo`807eeoo`0067oo00<007ooOol0Z7oo0P0OFgoo000HOol00`00Oomoo`2Z
Ool00`0OOomoo`1HOol001Qoo`03001oogoo0:]oo`807eQoo`0067oo0P00[Woo00<07gooOol0EGoo
000HOol00`00Oomoo`2^Ool00`0OOomoo`1DOol001Qoo`03001oogoo0:moo`807eAoo`0067oo00<0
07ooOol0/Goo00<07gooOol0DGoo000<Ool30002Ool20005Ool00`00Oomoo`2bOol201mAOol000eo
o`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`2dOol00`0OOomoo`1>Ool000Yoo`D00005
Ool007ooOol00004Ool3002eOol201m>Ool000Yoo`04001oogoo0002Ool01000Oomoo`0017oo00<0
07ooOol0]goo0P0OC7oo000;Ool00`00Ool00002Ool01000Oomoo`0017oo00<007ooOol0^Goo00<0
7gooOol0BGoo000<Ool20003Ool20005Ool00`00Oomoo`2jOol201m9Ool001Qoo`03001oogoo0;ao
o`807dMoo`0067oo00<007ooOol0_Woo00<07gooOol0A7oo000HOol20030Ool201m4Ool001Qoo`03
001oogoo0<5oo`807d9oo`0067oo00<007ooOol0`goo0P0O@7oo000HOol00`00Oomoo`35Ool201ln
Ool001Qoo`03001oogoo0<Moo`0301moogoo03]oo`0067oo0P00bGoo0P0O>goo000HOol00`00Oomo
o`3:Ool201liOol001Qoo`03001oogoo0<aoo`0301moogoo03Ioo`0067oo00<007ooOol0cGoo0P0O
=Woo000HOol00`00Oomoo`3?Ool201ldOol001Qoo`03001oogoo0=5oo`0301moogoo035oo`0067oo
0P00dgoo0P0O<Goo000HOol00`00Oomoo`3DOol00`0OOomoo`0^Ool001Qoo`03001oogoo0=Eoo`80
7bioo`0067oo00<007ooOol0egoo00<07gooOol0:goo000HOol00`00Oomoo`3HOol201l[Ool001Qo
o`03001oogoo0=Yoo`0301moogoo02Qoo`0067oo0P00g7oo0P0O:7oo000HOol00`00Oomoo`3MOol0
0`0OOomoo`0UOol001Qoo`03001oogoo0=ioo`807bEoo`002goo0P0017oo0P001Goo00<007ooOol0
h7oo00<07gooOol08Woo000:Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo0>5oo`80
7b9oo`003Goo00@007ooOol0009oo`03001oogoo009oo`<00>=oo`807b1oo`002goo0P000goo00@0
07ooOol000Aoo`03001oogoo0?moo`Ioo`002goo00<007ooOol00Woo00@007ooOol000Aoo`03001o
ogoo0?moo`Ioo`002goo0`000goo0P001Goo00<007ooOol0ogoo1Woo000HOol00`00Oomoo`3oOol6
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`005Woo1@00ogoo1Woo000FOol4003oOol7Ool001Uoo`03001o
ogoo0?moo`Eoo`005goo0`00ogoo1goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00001
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.106448, -4.21354, \
0.0043288, 0.350206}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0147151 0.0392403 [
[.21429 .00222 -9 -9 ]
[.21429 .00222 9 0 ]
[.40476 .00222 -9 -9 ]
[.40476 .00222 9 0 ]
[.59524 .00222 -9 -9 ]
[.59524 .00222 9 0 ]
[.78571 .00222 -9 -9 ]
[.78571 .00222 9 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[1.025 .01472 0 -6.25 ]
[1.025 .01472 10 6.25 ]
[.01131 .0932 -6 -4.5 ]
[.01131 .0932 0 4.5 ]
[.01131 .17168 -6 -4.5 ]
[.01131 .17168 0 4.5 ]
[.01131 .25016 -6 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .32864 -6 -4.5 ]
[.01131 .32864 0 4.5 ]
[.01131 .40712 -12 -4.5 ]
[.01131 .40712 0 4.5 ]
[.01131 .4856 -12 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .56408 -12 -4.5 ]
[.01131 .56408 0 4.5 ]
[.02381 .64303 -8 0 ]
[.02381 .64303 8 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(0.2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(0.4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(0.6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(0.8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(1)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
gsave
1.025 .01472 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .0932 m
.03006 .0932 L
s
[(2)] .01131 .0932 1 0 Mshowa
.02381 .17168 m
.03006 .17168 L
s
[(4)] .01131 .17168 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(6)] .01131 .25016 1 0 Mshowa
.02381 .32864 m
.03006 .32864 L
s
[(8)] .01131 .32864 1 0 Mshowa
.02381 .40712 m
.03006 .40712 L
s
[(10)] .01131 .40712 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(12)] .01131 .4856 1 0 Mshowa
.02381 .56408 m
.03006 .56408 L
s
[(14)] .01131 .56408 1 0 Mshowa
.125 Mabswid
.02381 .03434 m
.02756 .03434 L
s
.02381 .05396 m
.02756 .05396 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .11282 m
.02756 .11282 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .15206 m
.02756 .15206 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .21092 m
.02756 .21092 L
s
.02381 .23054 m
.02756 .23054 L
s
.02381 .26978 m
.02756 .26978 L
s
.02381 .2894 m
.02756 .2894 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .34826 m
.02756 .34826 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .3875 m
.02756 .3875 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .44636 m
.02756 .44636 L
s
.02381 .46598 m
.02756 .46598 L
s
.02381 .50522 m
.02756 .50522 L
s
.02381 .52484 m
.02756 .52484 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .5837 m
.02756 .5837 L
s
.02381 .60332 m
.02756 .60332 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(fs) show
75.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.02846 .01473 L
.03068 .01473 L
.03178 .01474 L
.03279 .01474 L
.03398 .01474 L
.03527 .01475 L
.03754 .01476 L
.04016 .01478 L
.04144 .01479 L
.04262 .0148 L
.04375 .01481 L
.04482 .01483 L
.0472 .01486 L
.04981 .0149 L
.05109 .01492 L
.05224 .01493 L
.05346 .01497 L
.0546 .015 L
.05712 .01507 L
.05966 .01514 L
.061 .01518 L
.06244 .01523 L
.0651 .01535 L
.06757 .01547 L
.07299 .01576 L
.08269 .0165 L
.08857 .01708 L
.09414 .01776 L
.10458 .01933 L
.11423 .0212 L
.12449 .02366 L
.14291 .02954 L
.16238 .03804 L
.18066 .04846 L
.21935 .07945 L
.23939 .1008 L
.26049 .1275 L
.2986 .1875 L
.33916 .26861 L
.3782 .3637 L
.4197 .48241 L
.4405 .54828 L
.44964 .57849 L
.45092 .58276 L
.45214 .58682 L
.45281 .58834 L
.45354 .58954 L
.45483 .59166 L
.45737 .59586 L
Mistroke
.45968 .59966 L
.46084 .60157 L
.4621 .60332 L
.46329 .60332 L
.46438 .60332 L
.46938 .60332 L
.47837 .60332 L
.49815 .60332 L
.53769 .60332 L
.57571 .60332 L
.61619 .60332 L
.65515 .60332 L
.69656 .60332 L
.73646 .60332 L
.77484 .60332 L
.81568 .60332 L
.85499 .60332 L
.8928 .60332 L
.93305 .60332 L
.97179 .60332 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo000oOol2
0004Ool20003Ool4000OOol20004Ool20005Ool3000OOol20004Ool20003Ool3000POol20004Ool2
0004Ool2000UOol5000NOol003ioo`04001oogoo0008Ool00`00Oomoo`0OOol01000Oomoo`002goo
00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`0027oo00@007ooOol0
02Ioo`03001oogoo01ioo`00?Woo00@007ooOol000Uoo`03001oogoo01ioo`04001oogoo0008Ool5
000NOol01000Oomoo`0027oo00@007ooOol001ioo`04001oogoo0008Ool01000Oomoo`009Woo00<0
07ooOol07Woo000nOol01000Oomoo`002Woo00<007ooOol07Goo00@007ooOol000Qoo`04001oogoo
000OOol01000Oomoo`0027oo0`007goo00@007ooOol000Uoo`8002Moo`03001oogoo01ioo`00?Woo
00@007ooOol000Qoo`04001oogoo000NOol01000Oomoo`002Goo00<007oo00007goo00@007ooOol0
00Uoo`03001oogoo01ioo`04001oogoo0008Ool01000Oomoo`009Woo00<007ooOol07Woo000oOol2
000:Ool2000POol2000;Ool2000POol2000:Ool3000OOol2000:Ool2000VOol2000POol00?moob5o
o`0067oo00<007ooOol0ogoo1Woo000HOol00`00Oomoo`3oOol6Ool001Qoo`03001oogoo0?Aoo`80
00moo`0067oo00<007ooOol0lgoo00@007ooOol000ioo`004Woom00027oo00<007ooOol03goo000H
Ool00`00Oomoo`09Ool00`00Oomoo`04Ool5000;Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00
Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00
Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00
Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00
Oomoo`0;Ool5000>Ool001Qoo`03001oogoo01Eoo`@00=Yoo`03001oogoo00moo`0067oo00<007oo
Ool06Goo0`00jGoo000HOol2000MOol2003WOol001Qoo`03001oogoo01ioo`800>Eoo`0067oo00<0
07ooOol087oo0P00hgoo000HOol00`00Oomoo`0ROol00`00Oomoo`3POol001Qoo`03001oogoo02=o
o`03001oogoo0=moo`0067oo0P009Goo0P00ggoo000HOol00`00Oomoo`0VOol00`00Oomoo`3LOol0
01Qoo`03001oogoo02Moo`03001oogoo0=]oo`0067oo00<007ooOol0:7oo0P00fgoo000HOol00`00
Oomoo`0ZOol00`00Oomoo`3HOol001Qoo`8002aoo`800=Qoo`0067oo00<007ooOol0;Goo00<007oo
Ool0eGoo000HOol00`00Oomoo`0^Ool00`00Oomoo`3DOol0011oo`@000Aoo`03001oogoo02moo`03
001oogoo0==oo`0047oo00<007ooOol01Goo00<007ooOol0;goo00<007ooOol0dgoo000AOol00`00
Oomoo`04Ool3000`Ool00`00Oomoo`3BOol0019oo`03001oogoo00=oo`03001oogoo035oo`03001o
ogoo0=5oo`0047oo00@007ooOol000Aoo`03001oogoo039oo`03001oogoo0=1oo`004Goo0P001Goo
00<007ooOol0<goo00<007ooOol0cgoo000HOol2000eOol00`00Oomoo`3>Ool001Qoo`03001oogoo
03Aoo`03001oogoo0<ioo`0067oo00<007ooOol0=Goo00<007ooOol0cGoo000HOol00`00Oomoo`0f
Ool00`00Oomoo`3<Ool001Qoo`03001oogoo03Moo`03001oogoo0<]oo`0067oo0P00>Goo00<007oo
Ool0bWoo000HOol00`00Oomoo`0hOol00`00Oomoo`3:Ool001Qoo`03001oogoo03Uoo`03001oogoo
0<Uoo`0067oo00<007ooOol0>Goo00<007ooOol0bGoo000HOol00`00Oomoo`0jOol00`00Oomoo`38
Ool001Qoo`8003aoo`03001oogoo0<Moo`0067oo00<007ooOol0>goo00<007ooOol0agoo000HOol0
0`00Oomoo`0lOol00`00Oomoo`36Ool0019oo`<000=oo`03001oogoo03aoo`03001oogoo0<Ioo`00
4goo00<007ooOol00Woo00<007ooOol0?Goo00<007ooOol0aGoo000@Ool50003Ool3000nOol00`00
Oomoo`34Ool0011oo`04001oogoo0004Ool00`00Oomoo`0nOol00`00Oomoo`34Ool0015oo`03001o
o`0000Aoo`03001oogoo03moo`03001oogoo0<=oo`004Woo0P0017oo00<007ooOol0?goo00<007oo
Ool0`goo000HOol20011Ool00`00Oomoo`32Ool001Qoo`03001oogoo045oo`03001oogoo0<5oo`00
67oo00<007ooOol0@Goo00<007ooOol0`Goo000HOol00`00Oomoo`12Ool00`00Oomoo`30Ool001Qo
o`03001oogoo049oo`03001oogoo0<1oo`0067oo0P00A7oo00<007ooOol0_goo000HOol00`00Oomo
o`13Ool00`00Oomoo`2oOol001Qoo`03001oogoo04Aoo`03001oogoo0;ioo`0067oo00<007ooOol0
A7oo00<007ooOol0_Woo000HOol00`00Oomoo`15Ool00`00Oomoo`2mOol001Qoo`8004Ioo`03001o
ogoo0;eoo`0067oo00<007ooOol0AWoo00<007ooOol0_7oo000HOol00`00Oomoo`16Ool00`00Oomo
o`2lOol0011oo`<000Eoo`03001oogoo04Moo`03001oogoo0;]oo`0047oo00@007ooOol000Aoo`03
001oogoo04Moo`03001oogoo0;]oo`0047oo00@007ooOol000Aoo`<004Qoo`03001oogoo0;Yoo`00
47oo0`001Goo00<007ooOol0B7oo00<007ooOol0^Woo000AOol00`00Oomoo`04Ool00`00Oomoo`19
Ool00`00Oomoo`2iOol0015oo`<000Aoo`03001oogoo04Uoo`03001oogoo0;Uoo`0067oo0P00Bgoo
00<007ooOol0^7oo000HOol00`00Oomoo`1:Ool00`00Oomoo`2hOol001Qoo`03001oogoo04]oo`03
001oogoo0;Moo`0067oo00<007ooOol0Bgoo00<007ooOol0]goo000HOol00`00Oomoo`1<Ool00`00
Oomoo`2fOol001Qoo`8004eoo`03001oogoo0;Ioo`0067oo00<007ooOol0C7oo00<007ooOol0]Woo
000HOol00`00Oomoo`1=Ool00`00Oomoo`2eOol001Qoo`03001oogoo04eoo`03001oogoo0;Eoo`00
67oo00<007ooOol0CWoo00<007ooOol0]7oo000HOol2001?Ool00`00Oomoo`2dOol001Qoo`03001o
ogoo04ioo`03001oogoo0;Aoo`0067oo00<007ooOol0Cgoo00<007ooOol0/goo000AOol20005Ool0
0`00Oomoo`1?Ool00`00Oomoo`2cOol0011oo`04001oogoo0004Ool00`00Oomoo`1?Ool00`00Oomo
o`2cOol0011oo`04001oogoo0004Ool3001@Ool00`00Oomoo`2bOol0015oo`8000Eoo`03001oogoo
051oo`03001oogoo0;9oo`0047oo00@007ooOol000Aoo`03001oogoo055oo`03001oogoo0;5oo`00
4Goo0P001Goo00<007ooOol0DGoo00<007ooOol0/Goo000HOol2001BOol00`00Oomoo`2aOol001Qo
o`03001oogoo059oo`03001oogoo0;1oo`0067oo00<007ooOol0DWoo00<007ooOol0/7oo000HOol0
0`00Oomoo`1COol00`00Oomoo`2_Ool001Qoo`03001oogoo05=oo`03001oogoo0:moo`0067oo0P00
E7oo00<007ooOol0[goo000HOol00`00Oomoo`1DOol00`00Oomoo`2^Ool001Qoo`03001oogoo05Ao
o`03001oogoo0:ioo`0067oo00<007ooOol0E7oo00<007ooOol0[Woo000HOol00`00Oomoo`1EOol0
0`00Oomoo`2]Ool001Qoo`8005Ioo`03001oogoo0:eoo`0067oo00<007ooOol0EGoo00<007ooOol0
[Goo000HOol00`00Oomoo`1FOol00`00Oomoo`2/Ool000Yoo`D0009oo`8000Eoo`03001oogoo05Io
o`03001oogoo0:aoo`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo05Ioo`03
001oogoo0:aoo`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`<005Moo`03001oogoo0:]o
o`0037oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo05Moo`03001oogoo0:]oo`00
37oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo05Moo`03001oogoo0:]oo`002goo
0P0017oo0P001Goo00<007ooOol0F7oo00<007ooOol0ZWoo000HOol00`00Oomoo`1HOol00`00Oomo
o`2ZOol001Qoo`8005Yoo`03001oogoo0:Uoo`0067oo00<007ooOol0FGoo00<007ooOol0ZGoo000H
Ool00`00Oomoo`1IOol00`00Oomoo`2YOol001Qoo`03001oogoo05Yoo`03001oogoo0:Qoo`0067oo
0P00Fgoo00<007ooOol0Z7oo000HOol00`00Oomoo`1JOol00`00Oomoo`2XOol001Qoo`03001oogoo
05]oo`03001oogoo0:Moo`0067oo00<007ooOol0Fgoo00<007ooOol0Ygoo000HOol00`00Oomoo`1K
Ool00`00Oomoo`2WOol001Qoo`8005eoo`03001oogoo0:Ioo`0067oo00<007ooOol0G7oo00<007oo
Ool0YWoo000HOol00`00Oomoo`1LOol00`00Oomoo`2VOol000Yoo`D00003Ool00000008000Aoo`03
001oogoo05eoo`03001oogoo0:Eoo`0037oo00D007ooOomoo`0000Moo`03001oogoo05eoo`03001o
ogoo0:Eoo`0037oo00<007ooOol00Woo00<007ooOol017oo0`00GGoo00<007ooOol0YGoo000<Ool0
0`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`1NOol00`00Oomoo`2TOol000aoo`05001oogoo
Ool00002Ool00`00Oomoo`02Ool00`00Oomoo`1NOol00`00Oomoo`2TOol000]oo`8000Aoo`8000Eo
o`03001oogoo05ioo`03001oogoo0:Aoo`0067oo00<007ooOol0Ggoo00<007ooOol0Xgoo000HOol2
001POol00`00Oomoo`2SOol001Qoo`03001oogoo05moo`03001oogoo0:=oo`0067oo00<007ooOol0
H7oo00<007ooOol0XWoo000HOol00`00Oomoo`1POol00`00Oomoo`2ROol001Qoo`80065oo`03001o
ogoo0:9oo`0067oo00<007ooOol0H7oo00<007ooOol0XWoo000HOol00`00Oomoo`1QOol00`00Oomo
o`2QOol001Qoo`03001oogoo065oo`03001oogoo0:5oo`0067oo00<007ooOol0HGoo00<007ooOol0
XGoo000HOol2001SOol00`00Oomoo`2POol001Qoo`03001oogoo069oo`03001oogoo0:1oo`0067oo
00<007ooOol0HWoo00<007ooOol0X7oo000:Ool50003Ool30003Ool00`00Oomoo`1SOol00`00Oomo
o`2OOol000aoo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo06=oo`03001oogoo09moo`00
37oo00@007ooOomoo`D000=oo`<006=oo`03001oogoo09moo`0037oo00D007ooOomoo`00009oo`03
001oogoo009oo`03001oogoo06=oo`03001oogoo09moo`0037oo00<007ooOol00Woo00<007oo0000
17oo00<007ooOol0ogoo1Woo000;Ool20005Ool20004Ool00`00Oomoo`1TOol00`00Oomoo`2NOol0
01Qoo`03001oogoo06Eoo`03001oogoo09eoo`0067oo0P00IWoo00<007ooOol0WGoo000HOol00`00
Oomoo`1UOol00`00Oomoo`2MOol001Qoo`03001oogoo06Ioo`03001oogoo09aoo`0067oo00<007oo
Ool0IWoo0P00WGoo000HOol2001XOomn000POol001Qoo`03001oogoo0?moo`Ioo`0067oo00<007oo
Ool0ogoo1Woo000HOol00`00Oomoo`3oOol6Ool001Qoo`03001oogoo0?moo`Ioo`00ogoo8Goo003o
OolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5o
o`00ogoo8Goo000COol40002Ool3003oOol5Ool001Aoo`03001oogoo00Eoo`03001oogoo0?moo`9o
o`0057oo00<007ooOol00Woo0`00ogoo1Goo000COol40002Ool4003oOol4Ool001Aoo`03001oogoo
0?moo`Yoo`005Goo0P00ogoo2Woo003oOolQOol00?moob5oo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.106448, -1.26406, \
0.0043288, 0.105062}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("t      p"\[InvisibleSpace]"        \
"\[InvisibleSpace]"t        u"\[InvisibleSpace]"              "\
\[InvisibleSpace]"t        v"\[InvisibleSpace]"          "\[InvisibleSpace]"t \
      a"\[InvisibleSpace]"         "\[InvisibleSpace]"t      kt"\),
      SequenceForm[ 
      "t      p", "        ", "t        u", "              ", "t        v", 
        "          ", "t       a", "         ", "t      kt"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("-----------------------------------------------------------------------\
------------------------"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        InterpretationBox[GridBox[{
              {\({0, 0}\)},
              {\({0.01`, 0.5`}\)},
              {\({0.02`, 1.`}\)},
              {\({0.03`, 1.5`}\)},
              {\({0.04`, 2.`}\)},
              {\({0.05`, 2.5`}\)},
              {\({0.060000000000000005`, 3.0000000000000004`}\)},
              {\({0.07`, 3.5000000000000004`}\)},
              {\({0.08`, 4.`}\)},
              {\({0.09`, 4.5`}\)},
              {\({0.09999999999999999`, 5.`}\)},
              {\({0.10999999999999999`, 5.499999999999999`}\)},
              {\({0.11999999999999998`, 5.999999999999999`}\)},
              {\({0.12999999999999998`, 6.499999999999999`}\)},
              {\({0.13999999999999999`, 6.999999999999999`}\)},
              {\({0.15`, 7.5`}\)},
              {\({0.16`, 8.`}\)},
              {\({0.17`, 8.5`}\)},
              {\({0.18000000000000002`, 9.000000000000002`}\)},
              {\({0.19000000000000003`, 9.500000000000002`}\)},
              {\({0.20000000000000004`, 10.000000000000002`}\)},
              {\({0.21000000000000005`, 10.500000000000002`}\)},
              {\({0.22000000000000006`, 11.000000000000004`}\)},
              {\({0.23000000000000007`, 11.500000000000004`}\)},
              {\({0.24000000000000007`, 12.000000000000004`}\)},
              {\({0.25000000000000006`, 12.500000000000004`}\)},
              {\({0.26000000000000006`, 13.000000000000004`}\)},
              {\({0.2700000000000001`, 13.500000000000004`}\)},
              {\({0.2800000000000001`, 14.000000000000004`}\)},
              {\({0.2900000000000001`, 14.500000000000005`}\)},
              {\({0.3000000000000001`, 15.000000000000005`}\)},
              {\({0.3100000000000001`, 15.500000000000005`}\)},
              {\({0.3200000000000001`, 16.000000000000007`}\)},
              {\({0.3300000000000001`, 16.500000000000007`}\)},
              {\({0.34000000000000014`, 17.000000000000007`}\)},
              {\({0.35000000000000014`, 17.500000000000007`}\)},
              {\({0.36000000000000015`, 18.000000000000007`}\)},
              {\({0.37000000000000016`, 18.500000000000007`}\)},
              {\({0.38000000000000017`, 19.000000000000007`}\)},
              {\({0.3900000000000002`, 19.50000000000001`}\)},
              {\({0.4000000000000002`, 20.00000000000001`}\)},
              {\({0.4100000000000002`, 20.50000000000001`}\)},
              {\({0.4200000000000002`, 21.00000000000001`}\)},
              {\({0.4300000000000002`, 21.50000000000001`}\)},
              {\({0.4400000000000002`, 22.00000000000001`}\)},
              {\({0.45000000000000023`, 22.50000000000001`}\)},
              {\({0.46000000000000024`, 23.00000000000001`}\)},
              {\({0.47000000000000025`, 23.500000000000014`}\)},
              {\({0.48000000000000026`, 24.000000000000014`}\)},
              {\({0.49000000000000027`, 24.500000000000014`}\)},
              {\({0.5000000000000002`, 25.00000000000001`}\)},
              {\({0.5100000000000002`, 25.50000000000001`}\)},
              {\({0.5200000000000002`, 26.00000000000001`}\)},
              {\({0.5300000000000002`, 26.500000000000014`}\)},
              {\({0.5400000000000003`, 27.000000000000014`}\)},
              {\({0.5500000000000003`, 27.500000000000014`}\)},
              {\({0.5600000000000003`, 28.000000000000014`}\)},
              {\({0.5700000000000003`, 28.500000000000014`}\)},
              {\({0.5800000000000003`, 29.000000000000014`}\)},
              {\({0.5900000000000003`, 29.500000000000014`}\)},
              {\({0.6000000000000003`, 30.000000000000014`}\)},
              {\({0.6100000000000003`, 30.500000000000014`}\)},
              {\({0.6200000000000003`, 31.000000000000018`}\)},
              {\({0.6300000000000003`, 31.500000000000018`}\)},
              {\({0.6400000000000003`, 32.000000000000014`}\)},
              {\({0.6500000000000004`, 32.500000000000014`}\)},
              {\({0.6600000000000004`, 33.00000000000002`}\)},
              {\({0.6700000000000004`, 33.50000000000002`}\)},
              {\({0.6800000000000004`, 34.00000000000002`}\)},
              {\({0.6900000000000004`, 34.50000000000002`}\)},
              {\({0.7000000000000004`, 35.00000000000002`}\)},
              {\({0.7100000000000004`, 35.50000000000002`}\)},
              {\({0.7200000000000004`, 36.00000000000002`}\)},
              {\({0.7300000000000004`, 36.50000000000002`}\)},
              {\({0.7400000000000004`, 37.00000000000002`}\)},
              {\({0.7500000000000004`, 37.50000000000002`}\)},
              {\({0.7600000000000005`, 38.00000000000002`}\)},
              {\({0.7700000000000005`, 38.50000000000002`}\)},
              {\({0.7800000000000005`, 39.00000000000002`}\)},
              {\({0.7900000000000005`, 39.50000000000002`}\)},
              {\({0.8000000000000005`, 40.00000000000002`}\)},
              {\({0.8100000000000005`, 40.50000000000003`}\)},
              {\({0.8200000000000005`, 41.00000000000003`}\)},
              {\({0.8300000000000005`, 41.50000000000003`}\)},
              {\({0.8400000000000005`, 42.00000000000003`}\)},
              {\({0.8500000000000005`, 42.50000000000003`}\)},
              {\({0.8600000000000005`, 43.00000000000003`}\)},
              {\({0.8700000000000006`, 43.50000000000003`}\)},
              {\({0.8800000000000006`, 44.00000000000003`}\)},
              {\({0.8900000000000006`, 44.50000000000003`}\)},
              {\({0.9000000000000006`, 45.00000000000003`}\)},
              {\({0.9100000000000006`, 45.50000000000003`}\)},
              {\({0.9200000000000006`, 46.00000000000003`}\)},
              {\({0.9300000000000006`, 46.50000000000003`}\)},
              {\({0.9400000000000006`, 47.00000000000003`}\)},
              {\({0.9500000000000006`, 47.50000000000003`}\)},
              {\({0.9600000000000006`, 48.00000000000003`}\)},
              {\({0.9700000000000006`, 48.50000000000003`}\)},
              {\({0.9800000000000006`, 49.000000000000036`}\)},
              {\({0.9900000000000007`, 49.500000000000036`}\)},
              {\({1.0000000000000007`, 50.000000000000036`}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 0}, {.01, .5}, {.02, 1.0}, {.029999999999999999, 
            1.5}, {.040000000000000001, 2.0}, {.050000000000000003, 
            2.5}, {.060000000000000005, 
            3.0000000000000004}, {.070000000000000007, 
            3.5000000000000004}, {.080000000000000002, 
            4.0}, {.089999999999999997, 4.5}, {.099999999999999992, 
            5.0}, {.10999999999999999, 
            5.4999999999999991}, {.11999999999999998, 
            5.9999999999999991}, {.12999999999999998, 
            6.4999999999999991}, {.13999999999999999, 
            6.9999999999999991}, {.14999999999999999, 7.5}, {.16, 
            8.0}, {.17000000000000001, 8.5}, {.18000000000000002, 
            9.0000000000000018}, {.19000000000000003, 
            9.5000000000000018}, {.20000000000000004, 
            10.000000000000002}, {.21000000000000005, 
            10.500000000000002}, {.22000000000000006, 
            11.000000000000004}, {.23000000000000007, 
            11.500000000000004}, {.24000000000000007, 
            12.000000000000004}, {.25000000000000006, 
            12.500000000000004}, {.26000000000000006, 
            13.000000000000004}, {.27000000000000007, 
            13.500000000000004}, {.28000000000000008, 
            14.000000000000004}, {.29000000000000009, 
            14.500000000000005}, {.3000000000000001, 
            15.000000000000005}, {.31000000000000011, 
            15.500000000000005}, {.32000000000000012, 
            16.000000000000007}, {.33000000000000013, 
            16.500000000000007}, {.34000000000000014, 
            17.000000000000007}, {.35000000000000014, 
            17.500000000000007}, {.36000000000000015, 
            18.000000000000007}, {.37000000000000016, 
            18.500000000000007}, {.38000000000000017, 
            19.000000000000007}, {.39000000000000018, 
            19.500000000000011}, {.40000000000000019, 
            20.000000000000011}, {.4100000000000002, 
            20.500000000000011}, {.42000000000000021, 
            21.000000000000011}, {.43000000000000022, 
            21.500000000000011}, {.44000000000000022, 
            22.000000000000011}, {.45000000000000023, 
            22.500000000000011}, {.46000000000000024, 
            23.000000000000011}, {.47000000000000025, 
            23.500000000000014}, {.48000000000000026, 
            24.000000000000014}, {.49000000000000027, 
            24.500000000000014}, {.50000000000000022, 
            25.000000000000011}, {.51000000000000023, 
            25.500000000000011}, {.52000000000000024, 
            26.000000000000011}, {.53000000000000025, 
            26.500000000000014}, {.54000000000000026, 
            27.000000000000014}, {.55000000000000027, 
            27.500000000000014}, {.56000000000000028, 
            28.000000000000014}, {.57000000000000028, 
            28.500000000000014}, {.58000000000000029, 
            29.000000000000014}, {.5900000000000003, 
            29.500000000000014}, {.60000000000000031, 
            30.000000000000014}, {.61000000000000032, 
            30.500000000000014}, {.62000000000000033, 
            31.000000000000018}, {.63000000000000034, 
            31.500000000000018}, {.64000000000000035, 
            32.000000000000014}, {.65000000000000036, 
            32.500000000000014}, {.66000000000000036, 
            33.000000000000021}, {.67000000000000037, 
            33.500000000000021}, {.68000000000000038, 
            34.000000000000021}, {.69000000000000039, 
            34.500000000000021}, {.7000000000000004, 
            35.000000000000021}, {.71000000000000041, 
            35.500000000000021}, {.72000000000000042, 
            36.000000000000021}, {.73000000000000043, 
            36.500000000000021}, {.74000000000000044, 
            37.000000000000021}, {.75000000000000044, 
            37.500000000000021}, {.76000000000000045, 
            38.000000000000021}, {.77000000000000046, 
            38.500000000000021}, {.78000000000000047, 
            39.000000000000021}, {.79000000000000048, 
            39.500000000000021}, {.80000000000000049, 
            40.000000000000021}, {.8100000000000005, 
            40.500000000000028}, {.82000000000000051, 
            41.000000000000028}, {.83000000000000052, 
            41.500000000000028}, {.84000000000000052, 
            42.000000000000028}, {.85000000000000053, 
            42.500000000000028}, {.86000000000000054, 
            43.000000000000028}, {.87000000000000055, 
            43.500000000000028}, {.88000000000000056, 
            44.000000000000028}, {.89000000000000057, 
            44.500000000000028}, {.90000000000000058, 
            45.000000000000028}, {.91000000000000059, 
            45.500000000000028}, {.9200000000000006, 
            46.000000000000028}, {.9300000000000006, 
            46.500000000000028}, {.94000000000000061, 
            47.000000000000028}, {.95000000000000062, 
            47.500000000000028}, {.96000000000000063, 
            48.000000000000028}, {.97000000000000064, 
            48.500000000000028}, {.98000000000000065, 
            49.000000000000036}, {.99000000000000066, 49.500000000000036}, {
            1.0000000000000007, 50.000000000000036}}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {\({0, 0}\)},
              {\({0.01`, 0.000024971906605069296`}\)},
              {\({0.02`, 0.00008319915493746024`}\)},
              {\({0.03`, 0.0002245144160259859`}\)},
              {\({0.04`, 0.0004985881526546412`}\)},
              {\({0.05`, 0.0009548130873377704`}\)},
              {\({0.060000000000000005`, 0.001642180582769655`}\)},
              {\({0.07`, 0.002609157892458416`}\)},
              {\({0.08`, 0.00390356658715035`}\)},
              {\({0.09`, 0.005572462461845839`}\)},
              {\({0.09999999999999999`, 0.007662017224840658`}\)},
              {\({0.10999999999999999`, 0.010217402266103336`}\)},
              {\({0.11999999999999998`, 0.013282674797429285`}\)},
              {\({0.12999999999999998`, 0.01690066665120716`}\)},
              {\({0.13999999999999999`, 0.021112876018305315`}\)},
              {\({0.15`, 0.02595936239855165`}\)},
              {\({0.16`, 0.03147864502955497`}\)},
              {\({0.17`, 0.03770760505121913`}\)},
              {\({0.18000000000000002`, 0.04468139165425278`}\)},
              {\({0.19000000000000003`, 0.052433332451299115`}\)},
              {\({0.20000000000000004`, 0.06099484829902594`}\)},
              {\({0.21000000000000005`, 0.07039537278865017`}\)},
              {\({0.22000000000000006`, 0.08066227661095109`}\)},
              {\({0.23000000000000007`, 0.0918207969898791`}\)},
              {\({0.24000000000000007`, 0.10389397236642203`}\)},
              {\({0.25000000000000006`, 0.11690258250147964`}\)},
              {\({0.26000000000000006`, 0.13086509415314956`}\)},
              {\({0.2700000000000001`, 0.1457976124700787`}\)},
              {\({0.2800000000000001`, 0.16171383822841617`}\)},
              {\({0.2900000000000001`, 0.17862503102545232`}\)},
              {\({0.3000000000000001`, 0.19653997852827815`}\)},
              {\({0.3100000000000001`, 0.21546497186078936`}\)},
              {\({0.3200000000000001`, 0.23540378719712346`}\)},
              {\({0.3300000000000001`, 0.25635767361419576`}\)},
              {\({0.34000000000000014`, 0.2783253472404322`}\)},
              {\({0.35000000000000014`, 0.3013029917221148`}\)},
              {\({0.36000000000000015`, 0.3252842650130084`}\)},
              {\({0.37000000000000016`, 0.35026031247715406`}\)},
              {\({0.38000000000000017`, 0.37621978627894326`}\)},
              {\({0.3900000000000002`, 0.40314887101886077`}\)},
              {\({0.4000000000000002`, 0.4310313155576462`}\)},
              {\({0.4100000000000002`, 0.4598484709561119`}\)},
              {\({0.4200000000000002`, 0.48957933444250695`}\)},
              {\({0.4300000000000002`, 0.520200599304173`}\)},
              {\({0.4400000000000002`, 0.551686710585336`}\)},
              {\({0.45000000000000023`, 0.5840099264582529`}\)},
              {\({0.46000000000000024`, 0.6179076692946921`}\)},
              {\({0.47000000000000025`, 0.6528787921210334`}\)},
              {\({0.48000000000000026`, 0.6901832482807098`}\)},
              {\({0.49000000000000027`, 0.7298710377737211`}\)},
              {\({0.5000000000000002`, 0.7719921606000676`}\)},
              {\({0.5100000000000002`, 0.8165966167597489`}\)},
              {\({0.5200000000000002`, 0.8637344062527654`}\)},
              {\({0.5300000000000002`, 0.913455529079117`}\)},
              {\({0.5400000000000003`, 0.9658099852388033`}\)},
              {\({0.5500000000000003`, 1.020847774731825`}\)},
              {\({0.5600000000000003`, 1.0786188975581814`}\)},
              {\({0.5700000000000003`, 1.139173353717873`}\)},
              {\({0.5800000000000003`, 1.2025611432108996`}\)},
              {\({0.5900000000000003`, 1.268832266037261`}\)},
              {\({0.6000000000000003`, 1.3380367221969578`}\)},
              {\({0.6100000000000003`, 1.4102245116899896`}\)},
              {\({0.6200000000000003`, 1.4854456345163565`}\)},
              {\({0.6300000000000003`, 1.5637500906760584`}\)},
              {\({0.6400000000000003`, 1.6451878801690953`}\)},
              {\({0.6500000000000004`, 1.7298090029954671`}\)},
              {\({0.6600000000000004`, 1.817663459155174`}\)},
              {\({0.6700000000000004`, 1.9088012486482155`}\)},
              {\({0.6800000000000004`, 2.003272371474592`}\)},
              {\({0.6900000000000004`, 2.101126827634303`}\)},
              {\({0.7000000000000004`, 2.202414617127349`}\)},
              {\({0.7100000000000004`, 2.30718573995373`}\)},
              {\({0.7200000000000004`, 2.415490196113445`}\)},
              {\({0.7300000000000004`, 2.5273779856064964`}\)},
              {\({0.7400000000000004`, 2.642899108432882`}\)},
              {\({0.7500000000000004`, 2.7621035645926035`}\)},
              {\({0.7600000000000005`, 2.8850413540856605`}\)},
              {\({0.7700000000000005`, 3.011762476912053`}\)},
              {\({0.7800000000000005`, 3.1423169330717813`}\)},
              {\({0.7900000000000005`, 3.276754722564845`}\)},
              {\({0.8000000000000005`, 3.4151258453912443`}\)},
              {\({0.8100000000000005`, 3.557480301550979`}\)},
              {\({0.8200000000000005`, 3.703868091044049`}\)},
              {\({0.8300000000000005`, 3.854339213870454`}\)},
              {\({0.8400000000000005`, 4.008943670030194`}\)},
              {\({0.8500000000000005`, 4.16773145952327`}\)},
              {\({0.8600000000000005`, 4.33075258234968`}\)},
              {\({0.8700000000000006`, 4.498057038509425`}\)},
              {\({0.8800000000000006`, 4.6696948280025055`}\)},
              {\({0.8900000000000006`, 4.845715950828921`}\)},
              {\({0.9000000000000006`, 5.026170406988671`}\)},
              {\({0.9100000000000006`, 5.211108196481756`}\)},
              {\({0.9200000000000006`, 5.400579319308176`}\)},
              {\({0.9300000000000006`, 5.594633775467932`}\)},
              {\({0.9400000000000006`, 5.793321564961022`}\)},
              {\({0.9500000000000006`, 5.996692687787448`}\)},
              {\({0.9600000000000006`, 6.204797143947209`}\)},
              {\({0.9700000000000006`, 6.417684933440305`}\)},
              {\({0.9800000000000006`, 6.6354060562667385`}\)},
              {\({0.9900000000000007`, 6.858010512426506`}\)},
              {\({1.0000000000000007`, 7.085548301919611`}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 
            0}, {.01, .000024971906605069296}, {.02, .000083199154937460242}, \
{.029999999999999999, .00022451441602598589}, {.040000000000000001, \
.00049858815265464121}, {.050000000000000003, .00095481308733777037}, \
{.060000000000000005, .001642180582769655}, {.070000000000000007, \
.0026091578924584162}, {.080000000000000002, .0039035665871503498}, \
{.089999999999999997, .0055724624618458387}, {.099999999999999992, \
.0076620172248406584}, {.10999999999999999, .010217402266103336}, \
{.11999999999999998, .013282674797429285}, {.12999999999999998, \
.016900666651207159}, {.13999999999999999, .021112876018305315}, \
{.14999999999999999, .02595936239855165}, {.16, .031478645029554969}, \
{.17000000000000001, .037707605051219131}, {.18000000000000002, \
.044681391654252778}, {.19000000000000003, .052433332451299115}, \
{.20000000000000004, .06099484829902594}, {.21000000000000005, \
.070395372788650171}, {.22000000000000006, .080662276610951086}, \
{.23000000000000007, .091820796989879105}, {.24000000000000007, \
.10389397236642203}, {.25000000000000006, .11690258250147964}, \
{.26000000000000006, .13086509415314956}, {.27000000000000007, \
.14579761247007869}, {.28000000000000008, .16171383822841617}, \
{.29000000000000009, .17862503102545232}, {.3000000000000001, \
.19653997852827815}, {.31000000000000011, .21546497186078936}, \
{.32000000000000012, .23540378719712346}, {.33000000000000013, \
.25635767361419576}, {.34000000000000014, .27832534724043217}, \
{.35000000000000014, .30130299172211478}, {.36000000000000015, \
.32528426501300839}, {.37000000000000016, .35026031247715406}, \
{.38000000000000017, .37621978627894326}, {.39000000000000018, \
.40314887101886077}, {.40000000000000019, .43103131555764618}, \
{.4100000000000002, .45984847095611192}, {.42000000000000021, \
.48957933444250695}, {.43000000000000022, .52020059930417295}, \
{.44000000000000022, .55168671058533603}, {.45000000000000023, \
.58400992645825289}, {.46000000000000024, .6179076692946921}, \
{.47000000000000025, .65287879212103339}, {.48000000000000026, \
.69018324828070976}, {.49000000000000027, .72987103777372109}, \
{.50000000000000022, .77199216060006759}, {.51000000000000023, \
.81659661675974893}, {.52000000000000024, .86373440625276543}, \
{.53000000000000025, .91345552907911698}, {.54000000000000026, \
.96580998523880335}, {.55000000000000027, 
            1.020847774731825}, {.56000000000000028, 
            1.0786188975581814}, {.57000000000000028, 
            1.139173353717873}, {.58000000000000029, 
            1.2025611432108996}, {.5900000000000003, 
            1.2688322660372611}, {.60000000000000031, 
            1.3380367221969578}, {.61000000000000032, 
            1.4102245116899896}, {.62000000000000033, 
            1.4854456345163565}, {.63000000000000034, 
            1.5637500906760584}, {.64000000000000035, 
            1.6451878801690953}, {.65000000000000036, 
            1.7298090029954671}, {.66000000000000036, 
            1.8176634591551739}, {.67000000000000037, 
            1.9088012486482155}, {.68000000000000038, 
            2.0032723714745919}, {.69000000000000039, 
            2.1011268276343031}, {.7000000000000004, 
            2.2024146171273489}, {.71000000000000041, 
            2.3071857399537299}, {.72000000000000042, 
            2.4154901961134452}, {.73000000000000043, 
            2.5273779856064964}, {.74000000000000044, 
            2.6428991084328821}, {.75000000000000044, 
            2.7621035645926035}, {.76000000000000045, 
            2.8850413540856605}, {.77000000000000046, 
            3.011762476912053}, {.78000000000000047, 
            3.1423169330717813}, {.79000000000000048, 
            3.2767547225648448}, {.80000000000000049, 
            3.4151258453912443}, {.8100000000000005, 
            3.5574803015509788}, {.82000000000000051, 
            3.7038680910440491}, {.83000000000000052, 
            3.8543392138704542}, {.84000000000000052, 
            4.0089436700301944}, {.85000000000000053, 
            4.16773145952327}, {.86000000000000054, 
            4.33075258234968}, {.87000000000000055, 
            4.4980570385094252}, {.88000000000000056, 
            4.6696948280025055}, {.89000000000000057, 
            4.8457159508289207}, {.90000000000000058, 
            5.0261704069886708}, {.91000000000000059, 
            5.2111081964817556}, {.9200000000000006, 
            5.4005793193081759}, {.9300000000000006, 
            5.5946337754679316}, {.94000000000000061, 
            5.7933215649610217}, {.95000000000000062, 
            5.9966926877874478}, {.96000000000000063, 
            6.2047971439472089}, {.97000000000000064, 
            6.417684933440305}, {.98000000000000065, 
            6.6354060562667385}, {.99000000000000066, 6.8580105124265058}, {
            1.0000000000000007, 7.0855483019196113}}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {\({0, 0}\)},
              {\({0.01`, 0.0008323968870021225`}\)},
              {\({0.02`, 0.006657823970092205`}\)},
              {\({0.03`, 0.017466271260239502`}\)},
              {\({0.04`, 0.03323614229254661`}\)},
              {\({0.05`, 0.05393343002234178`}\)},
              {\({0.060000000000000005`, 0.07951178848906232`}\)},
              {\({0.07`, 0.10991263518390357`}\)},
              {\({0.08`, 0.14506528407884597`}\)},
              {\({0.09`, 0.1848871090180497`}\)},
              {\({0.09999999999999999`, 0.22928373709651495`}\)},
              {\({0.10999999999999999`, 0.27814927157563213`}\)},
              {\({0.11999999999999998`, 0.33136654381101593`}\)},
              {\({0.12999999999999998`, 0.3888073935950148`}\)},
              {\({0.13999999999999999`, 0.4503329772446996`}\)},
              {\({0.15`, 0.5157941026961389`}\)},
              {\({0.16`, 0.5850315907975476`}\)},
              {\({0.17`, 0.6578766619276077`}\)},
              {\({0.18000000000000002`, 0.7341513470010834`}\)},
              {\({0.19000000000000003`, 0.8136689218619642`}\)},
              {\({0.20000000000000004`, 0.8962343640048835`}\)},
              {\({0.21000000000000005`, 0.9816448305086831`}\)},
              {\({0.22000000000000006`, 1.0696901560118002`}\)},
              {\({0.23000000000000007`, 1.1601533695078892`}\)},
              {\({0.24000000000000007`, 1.2528112286917599`}\)},
              {\({0.25000000000000006`, 1.3474347705404919`}\)},
              {\({0.26000000000000006`, 1.4437898767727115`}\)},
              {\({0.2700000000000001`, 1.5416378527903223`}\)},
              {\({0.2800000000000001`, 1.6407360186718347`}\)},
              {\({0.2900000000000001`, 1.740838310754831`}\)},
              {\({0.3000000000000001`, 1.841695892317067`}\)},
              {\({0.3100000000000001`, 1.9430577718413469`}\)},
              {\({0.3200000000000001`, 2.044671427328793`}\)},
              {\({0.3300000000000001`, 2.1462834351083697`}\)},
              {\({0.34000000000000014`, 2.247640101577506`}\)},
              {\({0.35000000000000014`, 2.348488096299853`}\)},
              {\({0.36000000000000015`, 2.448575084880914`}\)},
              {\({0.37000000000000016`, 2.5476503600412705`}\)},
              {\({0.38000000000000017`, 2.6454654693098596`}\)},
              {\({0.3900000000000002`, 2.7417748377665156`}\)},
              {\({0.4000000000000002`, 2.8363363842736113`}\)},
              {\({0.4100000000000002`, 2.928912129651235`}\)},
              {\({0.4200000000000002`, 3.0192687952688493`}\)},
              {\({0.4300000000000002`, 3.1071783905484587`}\)},
              {\({0.4400000000000002`, 3.192418787900564`}\)},
              {\({0.45000000000000023`, 3.2747742836439175`}\)},
              {\({0.46000000000000024`, 3.3796122826341293`}\)},
              {\({0.47000000000000025`, 3.6104456159676337`}\)},
              {\({0.48000000000000026`, 3.846278949301135`}\)},
              {\({0.49000000000000027`, 4.0871122826346395`}\)},
              {\({0.5000000000000002`, 4.332945615968139`}\)},
              {\({0.5100000000000002`, 4.583778949301656`}\)},
              {\({0.5200000000000002`, 4.839612282635144`}\)},
              {\({0.5300000000000002`, 5.100445615968639`}\)},
              {\({0.5400000000000003`, 5.366278949302155`}\)},
              {\({0.5500000000000003`, 5.637112282635652`}\)},
              {\({0.5600000000000003`, 5.912945615969161`}\)},
              {\({0.5700000000000003`, 6.193778949302647`}\)},
              {\({0.5800000000000003`, 6.479612282636145`}\)},
              {\({0.5900000000000003`, 6.770445615969667`}\)},
              {\({0.6000000000000003`, 7.066278949303176`}\)},
              {\({0.6100000000000003`, 7.367112282636688`}\)},
              {\({0.6200000000000003`, 7.672945615970198`}\)},
              {\({0.6300000000000003`, 7.983778949303688`}\)},
              {\({0.6400000000000003`, 8.299612282637183`}\)},
              {\({0.6500000000000004`, 8.620445615970688`}\)},
              {\({0.6600000000000004`, 8.94627894930418`}\)},
              {\({0.6700000000000004`, 9.277112282637656`}\)},
              {\({0.6800000000000004`, 9.612945615971123`}\)},
              {\({0.6900000000000004`, 9.953778949304589`}\)},
              {\({0.7000000000000004`, 10.299612282638082`}\)},
              {\({0.7100000000000004`, 10.650445615971561`}\)},
              {\({0.7200000000000004`, 11.006278949305083`}\)},
              {\({0.7300000000000004`, 11.367112282638542`}\)},
              {\({0.7400000000000004`, 11.732945615972117`}\)},
              {\({0.7500000000000004`, 12.10377894930567`}\)},
              {\({0.7600000000000005`, 12.47961228263922`}\)},
              {\({0.7700000000000005`, 12.860445615972779`}\)},
              {\({0.7800000000000005`, 13.24627894930634`}\)},
              {\({0.7900000000000005`, 13.637112282639922`}\)},
              {\({0.8000000000000005`, 14.032945615973452`}\)},
              {\({0.8100000000000005`, 14.433778949307001`}\)},
              {\({0.8200000000000005`, 14.83961228264051`}\)},
              {\({0.8300000000000005`, 15.250445615974055`}\)},
              {\({0.8400000000000005`, 15.666278949307538`}\)},
              {\({0.8500000000000005`, 16.087112282640984`}\)},
              {\({0.8600000000000005`, 16.51294561597453`}\)},
              {\({0.8700000000000006`, 16.943778949308058`}\)},
              {\({0.8800000000000006`, 17.379612282641528`}\)},
              {\({0.8900000000000006`, 17.820445615974975`}\)},
              {\({0.9000000000000006`, 18.26627894930848`}\)},
              {\({0.9100000000000006`, 18.717112282642034`}\)},
              {\({0.9200000000000006`, 19.17294561597554`}\)},
              {\({0.9300000000000006`, 19.633778949309043`}\)},
              {\({0.9400000000000006`, 20.099612282642582`}\)},
              {\({0.9500000000000006`, 20.57044561597603`}\)},
              {\({0.9600000000000006`, 21.046278949309606`}\)},
              {\({0.9700000000000006`, 21.52711228264324`}\)},
              {\({0.9800000000000006`, 22.012945615976776`}\)},
              {\({0.9900000000000007`, 22.503778949310437`}\)},
              {\({1.0000000000000007`, 22.999612282643895`}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 
            0}, {.01, .00083239688700212247}, {.02, .0066578239700922047}, \
{.029999999999999999, .017466271260239502}, {.040000000000000001, \
.033236142292546608}, {.050000000000000003, .053933430022341779}, \
{.060000000000000005, .079511788489062318}, {.070000000000000007, \
.10991263518390357}, {.080000000000000002, .14506528407884597}, \
{.089999999999999997, .18488710901804969}, {.099999999999999992, \
.22928373709651495}, {.10999999999999999, .27814927157563213}, \
{.11999999999999998, .33136654381101593}, {.12999999999999998, \
.38880739359501482}, {.13999999999999999, .45033297724469962}, \
{.14999999999999999, .5157941026961389}, {.16, .58503159079754763}, \
{.17000000000000001, .65787666192760774}, {.18000000000000002, \
.73415134700108342}, {.19000000000000003, .81366892186196416}, \
{.20000000000000004, .89623436400488354}, {.21000000000000005, \
.98164483050868312}, {.22000000000000006, 
            1.0696901560118002}, {.23000000000000007, 
            1.1601533695078892}, {.24000000000000007, 
            1.2528112286917599}, {.25000000000000006, 
            1.3474347705404919}, {.26000000000000006, 
            1.4437898767727115}, {.27000000000000007, 
            1.5416378527903223}, {.28000000000000008, 
            1.6407360186718347}, {.29000000000000009, 
            1.7408383107548311}, {.3000000000000001, 
            1.841695892317067}, {.31000000000000011, 
            1.9430577718413469}, {.32000000000000012, 
            2.0446714273287929}, {.33000000000000013, 
            2.1462834351083697}, {.34000000000000014, 
            2.247640101577506}, {.35000000000000014, 
            2.3484880962998531}, {.36000000000000015, 
            2.4485750848809138}, {.37000000000000016, 
            2.5476503600412705}, {.38000000000000017, 
            2.6454654693098596}, {.39000000000000018, 
            2.7417748377665156}, {.40000000000000019, 
            2.8363363842736113}, {.4100000000000002, 
            2.928912129651235}, {.42000000000000021, 
            3.0192687952688493}, {.43000000000000022, 
            3.1071783905484587}, {.44000000000000022, 
            3.1924187879005639}, {.45000000000000023, 
            3.2747742836439175}, {.46000000000000024, 
            3.3796122826341293}, {.47000000000000025, 
            3.6104456159676337}, {.48000000000000026, 
            3.8462789493011349}, {.49000000000000027, 
            4.0871122826346395}, {.50000000000000022, 
            4.3329456159681392}, {.51000000000000023, 
            4.5837789493016556}, {.52000000000000024, 
            4.8396122826351444}, {.53000000000000025, 
            5.1004456159686393}, {.54000000000000026, 
            5.3662789493021554}, {.55000000000000027, 
            5.6371122826356519}, {.56000000000000028, 
            5.9129456159691607}, {.57000000000000028, 
            6.1937789493026472}, {.58000000000000029, 
            6.4796122826361451}, {.5900000000000003, 
            6.7704456159696669}, {.60000000000000031, 
            7.0662789493031761}, {.61000000000000032, 
            7.3671122826366879}, {.62000000000000033, 
            7.6729456159701979}, {.63000000000000034, 
            7.9837789493036881}, {.64000000000000035, 
            8.2996122826371828}, {.65000000000000036, 
            8.6204456159706879}, {.66000000000000036, 
            8.9462789493041797}, {.67000000000000037, 
            9.2771122826376562}, {.68000000000000038, 
            9.6129456159711228}, {.69000000000000039, 
            9.9537789493045885}, {.7000000000000004, 
            10.299612282638082}, {.71000000000000041, 
            10.650445615971561}, {.72000000000000042, 
            11.006278949305083}, {.73000000000000043, 
            11.367112282638542}, {.74000000000000044, 
            11.732945615972117}, {.75000000000000044, 
            12.103778949305671}, {.76000000000000045, 
            12.47961228263922}, {.77000000000000046, 
            12.860445615972779}, {.78000000000000047, 
            13.24627894930634}, {.79000000000000048, 
            13.637112282639922}, {.80000000000000049, 
            14.032945615973452}, {.8100000000000005, 
            14.433778949307001}, {.82000000000000051, 
            14.839612282640511}, {.83000000000000052, 
            15.250445615974055}, {.84000000000000052, 
            15.666278949307538}, {.85000000000000053, 
            16.087112282640984}, {.86000000000000054, 
            16.51294561597453}, {.87000000000000055, 
            16.943778949308058}, {.88000000000000056, 
            17.379612282641528}, {.89000000000000057, 
            17.820445615974975}, {.90000000000000058, 
            18.266278949308479}, {.91000000000000059, 
            18.717112282642034}, {.9200000000000006, 
            19.172945615975539}, {.9300000000000006, 
            19.633778949309043}, {.94000000000000061, 
            20.099612282642582}, {.95000000000000062, 
            20.57044561597603}, {.96000000000000063, 
            21.046278949309606}, {.97000000000000064, 
            21.527112282643241}, {.98000000000000065, 
            22.012945615976776}, {.99000000000000066, 22.503778949310437}, {
            1.0000000000000007, 22.999612282643895}}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {\({0, 0}\)},
              {\({0.01`, 0.49943813210138593`}\)},
              {\({0.02`, 0.9980655892473944`}\)},
              {\({0.03`, 1.4947404277520722`}\)},
              {\({0.04`, 1.9882204805252064`}\)},
              {\({0.05`, 2.477270235153261`}\)},
              {\({0.060000000000000005`, 2.960663904169337`}\)},
              {\({0.07`, 3.4371884959627597`}\)},
              {\({0.08`, 3.9056468570579597`}\)},
              {\({0.09`, 4.364860678140584`}\)},
              {\({0.09999999999999999`, 4.813673456286459`}\)},
              {\({0.10999999999999999`, 5.250953405950561`}\)},
              {\({0.11999999999999998`, 5.675596311392567`}\)},
              {\({0.12999999999999998`, 6.086528313354293`}\)},
              {\({0.13999999999999999`, 6.482708622960146`}\)},
              {\({0.15`, 6.863132155986776`}\)},
              {\({0.16`, 7.226832080838619`}\)},
              {\({0.17`, 7.572882273773715`}\)},
              {\({0.18000000000000002`, 7.9003996751513625`}\)},
              {\({0.19000000000000003`, 8.208546540710074`}\)},
              {\({0.20000000000000004`, 8.496532582143686`}\)},
              {\({0.21000000000000005`, 8.763616991507888`}\)},
              {\({0.22000000000000006`, 9.00911034428168`}\)},
              {\({0.23000000000000007`, 9.232376376200335`}\)},
              {\({0.24000000000000007`, 9.432833629280708`}\)},
              {\({0.25000000000000006`, 9.609956962800197`}\)},
              {\({0.26000000000000006`, 9.763278925300085`}\)},
              {\({0.2700000000000001`, 9.892390984040276`}\)},
              {\({0.2800000000000001`, 9.996944608685169`}\)},
              {\({0.2900000000000001`, 10.076652206356073`}\)},
              {\({0.3000000000000001`, 10.13128790555021`}\)},
              {\({0.3100000000000001`, 10.160688186810887`}\)},
              {\({0.3200000000000001`, 10.164752358412613`}\)},
              {\({0.3300000000000001`, 10.143442875687356`}\)},
              {\({0.34000000000000014`, 10.096785503054377`}\)},
              {\({0.35000000000000014`, 10.024869318150877`}\)},
              {\({0.36000000000000015`, 9.927846557901603`}\)},
              {\({0.37000000000000016`, 9.805932306730597`}\)},
              {\({0.38000000000000017`, 9.659404027529945`}\)},
              {\({0.3900000000000002`, 9.488600936378248`}\)},
              {\({0.4000000000000002`, 9.293923222405056`}\)},
              {\({0.4100000000000002`, 9.075831114592575`}\)},
              {\({0.4200000000000002`, 8.834843797653662`}\)},
              {\({0.4300000000000002`, 8.571538179550089`}\)},
              {\({0.4400000000000002`, 8.286547513569758`}\)},
              {\({0.45000000000000023`, 7.98055987822454`}\)},
              {\({0.46000000000000024`, 23.00000000000057`}\)},
              {\({0.47000000000000025`, 23.5`}\)},
              {\({0.48000000000000026`, 24.000000000000682`}\)},
              {\({0.49000000000000027`, 24.499999999999545`}\)},
              {\({0.5000000000000002`, 25.00000000000216`}\)},
              {\({0.5100000000000002`, 25.499999999998863`}\)},
              {\({0.5200000000000002`, 25.999999999998977`}\)},
              {\({0.5300000000000002`, 26.500000000002046`}\)},
              {\({0.5400000000000003`, 26.99999999999943`}\)},
              {\({0.5500000000000003`, 27.500000000001364`}\)},
              {\({0.5600000000000003`, 27.99999999999841`}\)},
              {\({0.5700000000000003`, 28.499999999999318`}\)},
              {\({0.5800000000000003`, 29.0000000000025`}\)},
              {\({0.5900000000000003`, 29.50000000000091`}\)},
              {\({0.6000000000000003`, 30.000000000001137`}\)},
              {\({0.6100000000000003`, 30.500000000001364`}\)},
              {\({0.6200000000000003`, 30.99999999999909`}\)},
              {\({0.6300000000000003`, 31.499999999999318`}\)},
              {\({0.6400000000000003`, 32.00000000000091`}\)},
              {\({0.6500000000000004`, 32.499999999999545`}\)},
              {\({0.6600000000000004`, 32.999999999997954`}\)},
              {\({0.6700000000000004`, 33.49999999999682`}\)},
              {\({0.6800000000000004`, 33.999999999996135`}\)},
              {\({0.6900000000000004`, 34.49999999999977`}\)},
              {\({0.7000000000000004`, 34.99999999999682`}\)},
              {\({0.7100000000000004`, 35.50000000000409`}\)},
              {\({0.7200000000000004`, 35.99999999999363`}\)},
              {\({0.7300000000000004`, 36.50000000000773`}\)},
              {\({0.7400000000000004`, 37.00000000000546`}\)},
              {\({0.7500000000000004`, 37.500000000005`}\)},
              {\({0.7600000000000005`, 38.00000000000591`}\)},
              {\({0.7700000000000005`, 38.50000000000546`}\)},
              {\({0.7800000000000005`, 39.00000000000955`}\)},
              {\({0.7900000000000005`, 39.500000000002274`}\)},
              {\({0.8000000000000005`, 40.00000000000591`}\)},
              {\({0.8100000000000005`, 40.5`}\)},
              {\({0.8200000000000005`, 41.00000000000546`}\)},
              {\({0.8300000000000005`, 41.499999999999545`}\)},
              {\({0.8400000000000005`, 41.999999999992724`}\)},
              {\({0.8500000000000005`, 42.50000000000455`}\)},
              {\({0.8600000000000005`, 43.00000000000364`}\)},
              {\({0.8700000000000006`, 43.499999999997726`}\)},
              {\({0.8800000000000006`, 43.99999999999409`}\)},
              {\({0.8900000000000006`, 44.49999999999909`}\)},
              {\({0.9000000000000006`, 45.00000000000682`}\)},
              {\({0.9100000000000006`, 45.50000000000091`}\)},
              {\({0.9200000000000006`, 45.999999999999545`}\)},
              {\({0.9300000000000006`, 46.50000000000637`}\)},
              {\({0.9400000000000006`, 46.999999999992724`}\)},
              {\({0.9500000000000006`, 47.50000000000591`}\)},
              {\({0.9600000000000006`, 48.00000000001637`}\)},
              {\({0.9700000000000006`, 48.5`}\)},
              {\({0.9800000000000006`, 49.00000000002183`}\)},
              {\({0.9900000000000007`, 49.499999999990905`}\)},
              {\({1.0000000000000007`, 50.00000000002183`}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 
            0}, {.01, .49943813210138593}, {.02, .99806558924739441}, \
{.029999999999999999, 1.4947404277520722}, {.040000000000000001, 
            1.9882204805252064}, {.050000000000000003, 
            2.4772702351532612}, {.060000000000000005, 
            2.960663904169337}, {.070000000000000007, 
            3.4371884959627597}, {.080000000000000002, 
            3.9056468570579597}, {.089999999999999997, 
            4.3648606781405839}, {.099999999999999992, 
            4.8136734562864589}, {.10999999999999999, 
            5.2509534059505611}, {.11999999999999998, 
            5.6755963113925674}, {.12999999999999998, 
            6.0865283133542931}, {.13999999999999999, 
            6.4827086229601463}, {.14999999999999999, 
            6.8631321559867757}, {.16, 
            7.2268320808386193}, {.17000000000000001, 
            7.5728822737737147}, {.18000000000000002, 
            7.9003996751513625}, {.19000000000000003, 
            8.2085465407100742}, {.20000000000000004, 
            8.4965325821436863}, {.21000000000000005, 
            8.7636169915078881}, {.22000000000000006, 
            9.0091103442816802}, {.23000000000000007, 
            9.2323763762003352}, {.24000000000000007, 
            9.432833629280708}, {.25000000000000006, 
            9.6099569628001973}, {.26000000000000006, 
            9.7632789253000851}, {.27000000000000007, 
            9.8923909840402757}, {.28000000000000008, 
            9.996944608685169}, {.29000000000000009, 
            10.076652206356073}, {.3000000000000001, 
            10.131287905550209}, {.31000000000000011, 
            10.160688186810887}, {.32000000000000012, 
            10.164752358412613}, {.33000000000000013, 
            10.143442875687356}, {.34000000000000014, 
            10.096785503054377}, {.35000000000000014, 
            10.024869318150877}, {.36000000000000015, 
            9.9278465579016029}, {.37000000000000016, 
            9.8059323067305968}, {.38000000000000017, 
            9.6594040275299449}, {.39000000000000018, 
            9.4886009363782478}, {.40000000000000019, 
            9.2939232224050556}, {.4100000000000002, 
            9.0758311145925745}, {.42000000000000021, 
            8.8348437976536616}, {.43000000000000022, 
            8.5715381795500889}, {.44000000000000022, 
            8.2865475135697579}, {.45000000000000023, 
            7.9805598782245397}, {.46000000000000024, 
            23.000000000000568}, {.47000000000000025, 
            23.5}, {.48000000000000026, 
            24.000000000000682}, {.49000000000000027, 
            24.499999999999545}, {.50000000000000022, 
            25.00000000000216}, {.51000000000000023, 
            25.499999999998863}, {.52000000000000024, 
            25.999999999998977}, {.53000000000000025, 
            26.500000000002046}, {.54000000000000026, 
            26.999999999999432}, {.55000000000000027, 
            27.500000000001364}, {.56000000000000028, 
            27.999999999998408}, {.57000000000000028, 
            28.499999999999318}, {.58000000000000029, 
            29.000000000002501}, {.5900000000000003, 
            29.500000000000909}, {.60000000000000031, 
            30.000000000001137}, {.61000000000000032, 
            30.500000000001364}, {.62000000000000033, 
            30.999999999999091}, {.63000000000000034, 
            31.499999999999318}, {.64000000000000035, 
            32.000000000000909}, {.65000000000000036, 
            32.499999999999545}, {.66000000000000036, 
            32.999999999997954}, {.67000000000000037, 
            33.499999999996817}, {.68000000000000038, 
            33.999999999996135}, {.69000000000000039, 
            34.499999999999773}, {.7000000000000004, 
            34.999999999996817}, {.71000000000000041, 
            35.500000000004093}, {.72000000000000042, 
            35.999999999993634}, {.73000000000000043, 
            36.500000000007731}, {.74000000000000044, 
            37.000000000005457}, {.75000000000000044, 
            37.500000000005002}, {.76000000000000045, 
            38.000000000005912}, {.77000000000000046, 
            38.500000000005457}, {.78000000000000047, 
            39.00000000000955}, {.79000000000000048, 
            39.500000000002274}, {.80000000000000049, 
            40.000000000005912}, {.8100000000000005, 
            40.5}, {.82000000000000051, 
            41.000000000005457}, {.83000000000000052, 
            41.499999999999545}, {.84000000000000052, 
            41.999999999992724}, {.85000000000000053, 
            42.500000000004547}, {.86000000000000054, 
            43.000000000003638}, {.87000000000000055, 
            43.499999999997726}, {.88000000000000056, 
            43.999999999994088}, {.89000000000000057, 
            44.499999999999091}, {.90000000000000058, 
            45.000000000006821}, {.91000000000000059, 
            45.500000000000909}, {.9200000000000006, 
            45.999999999999545}, {.9300000000000006, 
            46.500000000006366}, {.94000000000000061, 
            46.999999999992724}, {.95000000000000062, 
            47.500000000005912}, {.96000000000000063, 
            48.000000000016371}, {.97000000000000064, 
            48.5}, {.98000000000000065, 
            49.000000000021828}, {.99000000000000066, 49.499999999990905}, {
            1.0000000000000007, 50.000000000021828}}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {\({0, 25}\)},
              {\({0.01`, 25}\)},
              {\({0.02`, 25}\)},
              {\({0.03`, 25}\)},
              {\({0.04`, 25}\)},
              {\({0.05`, 25}\)},
              {\({0.060000000000000005`, 25}\)},
              {\({0.07`, 25}\)},
              {\({0.08`, 25}\)},
              {\({0.09`, 25}\)},
              {\({0.09999999999999999`, 25}\)},
              {\({0.10999999999999999`, 25}\)},
              {\({0.11999999999999998`, 25}\)},
              {\({0.12999999999999998`, 25}\)},
              {\({0.13999999999999999`, 25}\)},
              {\({0.15`, 25}\)},
              {\({0.16`, 25}\)},
              {\({0.17`, 25}\)},
              {\({0.18000000000000002`, 25}\)},
              {\({0.19000000000000003`, 25}\)},
              {\({0.20000000000000004`, 25}\)},
              {\({0.21000000000000005`, 25}\)},
              {\({0.22000000000000006`, 25}\)},
              {\({0.23000000000000007`, 25}\)},
              {\({0.24000000000000007`, 25}\)},
              {\({0.25000000000000006`, 25}\)},
              {\({0.26000000000000006`, 25}\)},
              {\({0.2700000000000001`, 25}\)},
              {\({0.2800000000000001`, 25}\)},
              {\({0.2900000000000001`, 25}\)},
              {\({0.3000000000000001`, 25}\)},
              {\({0.3100000000000001`, 25}\)},
              {\({0.3200000000000001`, 25}\)},
              {\({0.3300000000000001`, 25}\)},
              {\({0.34000000000000014`, 25}\)},
              {\({0.35000000000000014`, 25}\)},
              {\({0.36000000000000015`, 25}\)},
              {\({0.37000000000000016`, 25}\)},
              {\({0.38000000000000017`, 25}\)},
              {\({0.3900000000000002`, 25}\)},
              {\({0.4000000000000002`, 25}\)},
              {\({0.4100000000000002`, 25}\)},
              {\({0.4200000000000002`, 25}\)},
              {\({0.4300000000000002`, 25}\)},
              {\({0.4400000000000002`, 25}\)},
              {\({0.45000000000000023`, 25}\)},
              {\({0.46000000000000024`, 0}\)},
              {\({0.47000000000000025`, 0}\)},
              {\({0.48000000000000026`, 0}\)},
              {\({0.49000000000000027`, 0}\)},
              {\({0.5000000000000002`, 0}\)},
              {\({0.5100000000000002`, 0}\)},
              {\({0.5200000000000002`, 0}\)},
              {\({0.5300000000000002`, 0}\)},
              {\({0.5400000000000003`, 0}\)},
              {\({0.5500000000000003`, 0}\)},
              {\({0.5600000000000003`, 0}\)},
              {\({0.5700000000000003`, 0}\)},
              {\({0.5800000000000003`, 0}\)},
              {\({0.5900000000000003`, 0}\)},
              {\({0.6000000000000003`, 0}\)},
              {\({0.6100000000000003`, 0}\)},
              {\({0.6200000000000003`, 0}\)},
              {\({0.6300000000000003`, 0}\)},
              {\({0.6400000000000003`, 0}\)},
              {\({0.6500000000000004`, 0}\)},
              {\({0.6600000000000004`, 0}\)},
              {\({0.6700000000000004`, 0}\)},
              {\({0.6800000000000004`, 0}\)},
              {\({0.6900000000000004`, 0}\)},
              {\({0.7000000000000004`, 0}\)},
              {\({0.7100000000000004`, 0}\)},
              {\({0.7200000000000004`, 0}\)},
              {\({0.7300000000000004`, 0}\)},
              {\({0.7400000000000004`, 0}\)},
              {\({0.7500000000000004`, 0}\)},
              {\({0.7600000000000005`, 0}\)},
              {\({0.7700000000000005`, 0}\)},
              {\({0.7800000000000005`, 0}\)},
              {\({0.7900000000000005`, 0}\)},
              {\({0.8000000000000005`, 0}\)},
              {\({0.8100000000000005`, 0}\)},
              {\({0.8200000000000005`, 0}\)},
              {\({0.8300000000000005`, 0}\)},
              {\({0.8400000000000005`, 0}\)},
              {\({0.8500000000000005`, 0}\)},
              {\({0.8600000000000005`, 0}\)},
              {\({0.8700000000000006`, 0}\)},
              {\({0.8800000000000006`, 0}\)},
              {\({0.8900000000000006`, 0}\)},
              {\({0.9000000000000006`, 0}\)},
              {\({0.9100000000000006`, 0}\)},
              {\({0.9200000000000006`, 0}\)},
              {\({0.9300000000000006`, 0}\)},
              {\({0.9400000000000006`, 0}\)},
              {\({0.9500000000000006`, 0}\)},
              {\({0.9600000000000006`, 0}\)},
              {\({0.9700000000000006`, 0}\)},
              {\({0.9800000000000006`, 0}\)},
              {\({0.9900000000000007`, 0}\)},
              {\({1.0000000000000007`, 0}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 25}, {.01, 25}, {.02, 25}, {.029999999999999999, 
            25}, {.040000000000000001, 25}, {.050000000000000003, 
            25}, {.060000000000000005, 25}, {.070000000000000007, 
            25}, {.080000000000000002, 25}, {.089999999999999997, 
            25}, {.099999999999999992, 25}, {.10999999999999999, 
            25}, {.11999999999999998, 25}, {.12999999999999998, 
            25}, {.13999999999999999, 25}, {.14999999999999999, 25}, {.16, 
            25}, {.17000000000000001, 25}, {.18000000000000002, 
            25}, {.19000000000000003, 25}, {.20000000000000004, 
            25}, {.21000000000000005, 25}, {.22000000000000006, 
            25}, {.23000000000000007, 25}, {.24000000000000007, 
            25}, {.25000000000000006, 25}, {.26000000000000006, 
            25}, {.27000000000000007, 25}, {.28000000000000008, 
            25}, {.29000000000000009, 25}, {.3000000000000001, 
            25}, {.31000000000000011, 25}, {.32000000000000012, 
            25}, {.33000000000000013, 25}, {.34000000000000014, 
            25}, {.35000000000000014, 25}, {.36000000000000015, 
            25}, {.37000000000000016, 25}, {.38000000000000017, 
            25}, {.39000000000000018, 25}, {.40000000000000019, 
            25}, {.4100000000000002, 25}, {.42000000000000021, 
            25}, {.43000000000000022, 25}, {.44000000000000022, 
            25}, {.45000000000000023, 25}, {.46000000000000024, 
            0}, {.47000000000000025, 0}, {.48000000000000026, 
            0}, {.49000000000000027, 0}, {.50000000000000022, 
            0}, {.51000000000000023, 0}, {.52000000000000024, 
            0}, {.53000000000000025, 0}, {.54000000000000026, 
            0}, {.55000000000000027, 0}, {.56000000000000028, 
            0}, {.57000000000000028, 0}, {.58000000000000029, 
            0}, {.5900000000000003, 0}, {.60000000000000031, 
            0}, {.61000000000000032, 0}, {.62000000000000033, 
            0}, {.63000000000000034, 0}, {.64000000000000035, 
            0}, {.65000000000000036, 0}, {.66000000000000036, 
            0}, {.67000000000000037, 0}, {.68000000000000038, 
            0}, {.69000000000000039, 0}, {.7000000000000004, 
            0}, {.71000000000000041, 0}, {.72000000000000042, 
            0}, {.73000000000000043, 0}, {.74000000000000044, 
            0}, {.75000000000000044, 0}, {.76000000000000045, 
            0}, {.77000000000000046, 0}, {.78000000000000047, 
            0}, {.79000000000000048, 0}, {.80000000000000049, 
            0}, {.8100000000000005, 0}, {.82000000000000051, 
            0}, {.83000000000000052, 0}, {.84000000000000052, 
            0}, {.85000000000000053, 0}, {.86000000000000054, 
            0}, {.87000000000000055, 0}, {.88000000000000056, 
            0}, {.89000000000000057, 0}, {.90000000000000058, 
            0}, {.91000000000000059, 0}, {.9200000000000006, 
            0}, {.9300000000000006, 0}, {.94000000000000061, 
            0}, {.95000000000000062, 0}, {.96000000000000063, 
            0}, {.97000000000000064, 0}, {.98000000000000065, 
            0}, {.99000000000000066, 0}, {1.0000000000000007, 0}}],
          Editable->False]}],
      SequenceForm[ 
        ColumnForm[ {{0, 0}, {.01, .5}, {.02, 1.0}, {.029999999999999999, 
          1.5}, {.040000000000000001, 2.0}, {.050000000000000003, 
          2.5}, {.060000000000000005, 
          3.0000000000000004}, {.070000000000000007, 
          3.5000000000000004}, {.080000000000000002, 
          4.0}, {.089999999999999997, 4.5}, {.099999999999999992, 
          5.0}, {.10999999999999999, 5.4999999999999991}, {.11999999999999998,
           5.9999999999999991}, {.12999999999999998, 
          6.4999999999999991}, {.13999999999999999, 
          6.9999999999999991}, {.14999999999999999, 7.5}, {.16, 
          8.0}, {.17000000000000001, 8.5}, {.18000000000000002, 
          9.0000000000000018}, {.19000000000000003, 
          9.5000000000000018}, {.20000000000000004, 
          10.000000000000002}, {.21000000000000005, 
          10.500000000000002}, {.22000000000000006, 
          11.000000000000004}, {.23000000000000007, 
          11.500000000000004}, {.24000000000000007, 
          12.000000000000004}, {.25000000000000006, 
          12.500000000000004}, {.26000000000000006, 
          13.000000000000004}, {.27000000000000007, 
          13.500000000000004}, {.28000000000000008, 
          14.000000000000004}, {.29000000000000009, 
          14.500000000000005}, {.3000000000000001, 
          15.000000000000005}, {.31000000000000011, 
          15.500000000000005}, {.32000000000000012, 
          16.000000000000007}, {.33000000000000013, 
          16.500000000000007}, {.34000000000000014, 
          17.000000000000007}, {.35000000000000014, 
          17.500000000000007}, {.36000000000000015, 
          18.000000000000007}, {.37000000000000016, 
          18.500000000000007}, {.38000000000000017, 
          19.000000000000007}, {.39000000000000018, 
          19.500000000000011}, {.40000000000000019, 
          20.000000000000011}, {.4100000000000002, 
          20.500000000000011}, {.42000000000000021, 
          21.000000000000011}, {.43000000000000022, 
          21.500000000000011}, {.44000000000000022, 
          22.000000000000011}, {.45000000000000023, 
          22.500000000000011}, {.46000000000000024, 
          23.000000000000011}, {.47000000000000025, 
          23.500000000000014}, {.48000000000000026, 
          24.000000000000014}, {.49000000000000027, 
          24.500000000000014}, {.50000000000000022, 
          25.000000000000011}, {.51000000000000023, 
          25.500000000000011}, {.52000000000000024, 
          26.000000000000011}, {.53000000000000025, 
          26.500000000000014}, {.54000000000000026, 
          27.000000000000014}, {.55000000000000027, 
          27.500000000000014}, {.56000000000000028, 
          28.000000000000014}, {.57000000000000028, 
          28.500000000000014}, {.58000000000000029, 
          29.000000000000014}, {.5900000000000003, 
          29.500000000000014}, {.60000000000000031, 
          30.000000000000014}, {.61000000000000032, 
          30.500000000000014}, {.62000000000000033, 
          31.000000000000018}, {.63000000000000034, 
          31.500000000000018}, {.64000000000000035, 
          32.000000000000014}, {.65000000000000036, 
          32.500000000000014}, {.66000000000000036, 
          33.000000000000021}, {.67000000000000037, 
          33.500000000000021}, {.68000000000000038, 
          34.000000000000021}, {.69000000000000039, 
          34.500000000000021}, {.7000000000000004, 
          35.000000000000021}, {.71000000000000041, 
          35.500000000000021}, {.72000000000000042, 
          36.000000000000021}, {.73000000000000043, 
          36.500000000000021}, {.74000000000000044, 
          37.000000000000021}, {.75000000000000044, 
          37.500000000000021}, {.76000000000000045, 
          38.000000000000021}, {.77000000000000046, 
          38.500000000000021}, {.78000000000000047, 
          39.000000000000021}, {.79000000000000048, 
          39.500000000000021}, {.80000000000000049, 
          40.000000000000021}, {.8100000000000005, 
          40.500000000000028}, {.82000000000000051, 
          41.000000000000028}, {.83000000000000052, 
          41.500000000000028}, {.84000000000000052, 
          42.000000000000028}, {.85000000000000053, 
          42.500000000000028}, {.86000000000000054, 
          43.000000000000028}, {.87000000000000055, 
          43.500000000000028}, {.88000000000000056, 
          44.000000000000028}, {.89000000000000057, 
          44.500000000000028}, {.90000000000000058, 
          45.000000000000028}, {.91000000000000059, 
          45.500000000000028}, {.9200000000000006, 
          46.000000000000028}, {.9300000000000006, 
          46.500000000000028}, {.94000000000000061, 
          47.000000000000028}, {.95000000000000062, 
          47.500000000000028}, {.96000000000000063, 
          48.000000000000028}, {.97000000000000064, 
          48.500000000000028}, {.98000000000000065, 
          49.000000000000036}, {.99000000000000066, 49.500000000000036}, {
          1.0000000000000007, 50.000000000000036}}], "  ", 
        ColumnForm[ {{0, 
          0}, {.01, .000024971906605069296}, {.02, .000083199154937460242}, \
{.029999999999999999, .00022451441602598589}, {.040000000000000001, \
.00049858815265464121}, {.050000000000000003, .00095481308733777037}, \
{.060000000000000005, .001642180582769655}, {.070000000000000007, \
.0026091578924584162}, {.080000000000000002, .0039035665871503498}, \
{.089999999999999997, .0055724624618458387}, {.099999999999999992, \
.0076620172248406584}, {.10999999999999999, .010217402266103336}, \
{.11999999999999998, .013282674797429285}, {.12999999999999998, \
.016900666651207159}, {.13999999999999999, .021112876018305315}, \
{.14999999999999999, .02595936239855165}, {.16, .031478645029554969}, \
{.17000000000000001, .037707605051219131}, {.18000000000000002, \
.044681391654252778}, {.19000000000000003, .052433332451299115}, \
{.20000000000000004, .06099484829902594}, {.21000000000000005, \
.070395372788650171}, {.22000000000000006, .080662276610951086}, \
{.23000000000000007, .091820796989879105}, {.24000000000000007, \
.10389397236642203}, {.25000000000000006, .11690258250147964}, \
{.26000000000000006, .13086509415314956}, {.27000000000000007, \
.14579761247007869}, {.28000000000000008, .16171383822841617}, \
{.29000000000000009, .17862503102545232}, {.3000000000000001, \
.19653997852827815}, {.31000000000000011, .21546497186078936}, \
{.32000000000000012, .23540378719712346}, {.33000000000000013, \
.25635767361419576}, {.34000000000000014, .27832534724043217}, \
{.35000000000000014, .30130299172211478}, {.36000000000000015, \
.32528426501300839}, {.37000000000000016, .35026031247715406}, \
{.38000000000000017, .37621978627894326}, {.39000000000000018, \
.40314887101886077}, {.40000000000000019, .43103131555764618}, \
{.4100000000000002, .45984847095611192}, {.42000000000000021, \
.48957933444250695}, {.43000000000000022, .52020059930417295}, \
{.44000000000000022, .55168671058533603}, {.45000000000000023, \
.58400992645825289}, {.46000000000000024, .6179076692946921}, \
{.47000000000000025, .65287879212103339}, {.48000000000000026, \
.69018324828070976}, {.49000000000000027, .72987103777372109}, \
{.50000000000000022, .77199216060006759}, {.51000000000000023, \
.81659661675974893}, {.52000000000000024, .86373440625276543}, \
{.53000000000000025, .91345552907911698}, {.54000000000000026, \
.96580998523880335}, {.55000000000000027, 
          1.020847774731825}, {.56000000000000028, 
          1.0786188975581814}, {.57000000000000028, 
          1.139173353717873}, {.58000000000000029, 
          1.2025611432108996}, {.5900000000000003, 
          1.2688322660372611}, {.60000000000000031, 
          1.3380367221969578}, {.61000000000000032, 
          1.4102245116899896}, {.62000000000000033, 
          1.4854456345163565}, {.63000000000000034, 
          1.5637500906760584}, {.64000000000000035, 
          1.6451878801690953}, {.65000000000000036, 
          1.7298090029954671}, {.66000000000000036, 
          1.8176634591551739}, {.67000000000000037, 
          1.9088012486482155}, {.68000000000000038, 
          2.0032723714745919}, {.69000000000000039, 
          2.1011268276343031}, {.7000000000000004, 
          2.2024146171273489}, {.71000000000000041, 
          2.3071857399537299}, {.72000000000000042, 
          2.4154901961134452}, {.73000000000000043, 
          2.5273779856064964}, {.74000000000000044, 
          2.6428991084328821}, {.75000000000000044, 
          2.7621035645926035}, {.76000000000000045, 
          2.8850413540856605}, {.77000000000000046, 
          3.011762476912053}, {.78000000000000047, 
          3.1423169330717813}, {.79000000000000048, 
          3.2767547225648448}, {.80000000000000049, 
          3.4151258453912443}, {.8100000000000005, 
          3.5574803015509788}, {.82000000000000051, 
          3.7038680910440491}, {.83000000000000052, 
          3.8543392138704542}, {.84000000000000052, 
          4.0089436700301944}, {.85000000000000053, 
          4.16773145952327}, {.86000000000000054, 
          4.33075258234968}, {.87000000000000055, 
          4.4980570385094252}, {.88000000000000056, 
          4.6696948280025055}, {.89000000000000057, 
          4.8457159508289207}, {.90000000000000058, 
          5.0261704069886708}, {.91000000000000059, 
          5.2111081964817556}, {.9200000000000006, 
          5.4005793193081759}, {.9300000000000006, 
          5.5946337754679316}, {.94000000000000061, 
          5.7933215649610217}, {.95000000000000062, 
          5.9966926877874478}, {.96000000000000063, 
          6.2047971439472089}, {.97000000000000064, 
          6.417684933440305}, {.98000000000000065, 
          6.6354060562667385}, {.99000000000000066, 6.8580105124265058}, {
          1.0000000000000007, 7.0855483019196113}}], "  ", 
        ColumnForm[ {{0, 
          0}, {.01, .00083239688700212247}, {.02, .0066578239700922047}, \
{.029999999999999999, .017466271260239502}, {.040000000000000001, \
.033236142292546608}, {.050000000000000003, .053933430022341779}, \
{.060000000000000005, .079511788489062318}, {.070000000000000007, \
.10991263518390357}, {.080000000000000002, .14506528407884597}, \
{.089999999999999997, .18488710901804969}, {.099999999999999992, \
.22928373709651495}, {.10999999999999999, .27814927157563213}, \
{.11999999999999998, .33136654381101593}, {.12999999999999998, \
.38880739359501482}, {.13999999999999999, .45033297724469962}, \
{.14999999999999999, .5157941026961389}, {.16, .58503159079754763}, \
{.17000000000000001, .65787666192760774}, {.18000000000000002, \
.73415134700108342}, {.19000000000000003, .81366892186196416}, \
{.20000000000000004, .89623436400488354}, {.21000000000000005, \
.98164483050868312}, {.22000000000000006, 
          1.0696901560118002}, {.23000000000000007, 
          1.1601533695078892}, {.24000000000000007, 
          1.2528112286917599}, {.25000000000000006, 
          1.3474347705404919}, {.26000000000000006, 
          1.4437898767727115}, {.27000000000000007, 
          1.5416378527903223}, {.28000000000000008, 
          1.6407360186718347}, {.29000000000000009, 
          1.7408383107548311}, {.3000000000000001, 
          1.841695892317067}, {.31000000000000011, 
          1.9430577718413469}, {.32000000000000012, 
          2.0446714273287929}, {.33000000000000013, 
          2.1462834351083697}, {.34000000000000014, 
          2.247640101577506}, {.35000000000000014, 
          2.3484880962998531}, {.36000000000000015, 
          2.4485750848809138}, {.37000000000000016, 
          2.5476503600412705}, {.38000000000000017, 
          2.6454654693098596}, {.39000000000000018, 
          2.7417748377665156}, {.40000000000000019, 
          2.8363363842736113}, {.4100000000000002, 
          2.928912129651235}, {.42000000000000021, 
          3.0192687952688493}, {.43000000000000022, 
          3.1071783905484587}, {.44000000000000022, 
          3.1924187879005639}, {.45000000000000023, 
          3.2747742836439175}, {.46000000000000024, 
          3.3796122826341293}, {.47000000000000025, 
          3.6104456159676337}, {.48000000000000026, 
          3.8462789493011349}, {.49000000000000027, 
          4.0871122826346395}, {.50000000000000022, 
          4.3329456159681392}, {.51000000000000023, 
          4.5837789493016556}, {.52000000000000024, 
          4.8396122826351444}, {.53000000000000025, 
          5.1004456159686393}, {.54000000000000026, 
          5.3662789493021554}, {.55000000000000027, 
          5.6371122826356519}, {.56000000000000028, 
          5.9129456159691607}, {.57000000000000028, 
          6.1937789493026472}, {.58000000000000029, 
          6.4796122826361451}, {.5900000000000003, 
          6.7704456159696669}, {.60000000000000031, 
          7.0662789493031761}, {.61000000000000032, 
          7.3671122826366879}, {.62000000000000033, 
          7.6729456159701979}, {.63000000000000034, 
          7.9837789493036881}, {.64000000000000035, 
          8.2996122826371828}, {.65000000000000036, 
          8.6204456159706879}, {.66000000000000036, 
          8.9462789493041797}, {.67000000000000037, 
          9.2771122826376562}, {.68000000000000038, 
          9.6129456159711228}, {.69000000000000039, 
          9.9537789493045885}, {.7000000000000004, 
          10.299612282638082}, {.71000000000000041, 
          10.650445615971561}, {.72000000000000042, 
          11.006278949305083}, {.73000000000000043, 
          11.367112282638542}, {.74000000000000044, 
          11.732945615972117}, {.75000000000000044, 
          12.103778949305671}, {.76000000000000045, 
          12.47961228263922}, {.77000000000000046, 
          12.860445615972779}, {.78000000000000047, 
          13.24627894930634}, {.79000000000000048, 
          13.637112282639922}, {.80000000000000049, 
          14.032945615973452}, {.8100000000000005, 
          14.433778949307001}, {.82000000000000051, 
          14.839612282640511}, {.83000000000000052, 
          15.250445615974055}, {.84000000000000052, 
          15.666278949307538}, {.85000000000000053, 
          16.087112282640984}, {.86000000000000054, 
          16.51294561597453}, {.87000000000000055, 
          16.943778949308058}, {.88000000000000056, 
          17.379612282641528}, {.89000000000000057, 
          17.820445615974975}, {.90000000000000058, 
          18.266278949308479}, {.91000000000000059, 
          18.717112282642034}, {.9200000000000006, 
          19.172945615975539}, {.9300000000000006, 
          19.633778949309043}, {.94000000000000061, 
          20.099612282642582}, {.95000000000000062, 
          20.57044561597603}, {.96000000000000063, 
          21.046278949309606}, {.97000000000000064, 
          21.527112282643241}, {.98000000000000065, 
          22.012945615976776}, {.99000000000000066, 22.503778949310437}, {
          1.0000000000000007, 22.999612282643895}}], "  ", 
        ColumnForm[ {{0, 
          0}, {.01, .49943813210138593}, {.02, .99806558924739441}, \
{.029999999999999999, 1.4947404277520722}, {.040000000000000001, 
          1.9882204805252064}, {.050000000000000003, 
          2.4772702351532612}, {.060000000000000005, 
          2.960663904169337}, {.070000000000000007, 
          3.4371884959627597}, {.080000000000000002, 
          3.9056468570579597}, {.089999999999999997, 
          4.3648606781405839}, {.099999999999999992, 
          4.8136734562864589}, {.10999999999999999, 
          5.2509534059505611}, {.11999999999999998, 
          5.6755963113925674}, {.12999999999999998, 
          6.0865283133542931}, {.13999999999999999, 
          6.4827086229601463}, {.14999999999999999, 6.8631321559867757}, {.16,
           7.2268320808386193}, {.17000000000000001, 
          7.5728822737737147}, {.18000000000000002, 
          7.9003996751513625}, {.19000000000000003, 
          8.2085465407100742}, {.20000000000000004, 
          8.4965325821436863}, {.21000000000000005, 
          8.7636169915078881}, {.22000000000000006, 
          9.0091103442816802}, {.23000000000000007, 
          9.2323763762003352}, {.24000000000000007, 
          9.432833629280708}, {.25000000000000006, 
          9.6099569628001973}, {.26000000000000006, 
          9.7632789253000851}, {.27000000000000007, 
          9.8923909840402757}, {.28000000000000008, 
          9.996944608685169}, {.29000000000000009, 
          10.076652206356073}, {.3000000000000001, 
          10.131287905550209}, {.31000000000000011, 
          10.160688186810887}, {.32000000000000012, 
          10.164752358412613}, {.33000000000000013, 
          10.143442875687356}, {.34000000000000014, 
          10.096785503054377}, {.35000000000000014, 
          10.024869318150877}, {.36000000000000015, 
          9.9278465579016029}, {.37000000000000016, 
          9.8059323067305968}, {.38000000000000017, 
          9.6594040275299449}, {.39000000000000018, 
          9.4886009363782478}, {.40000000000000019, 
          9.2939232224050556}, {.4100000000000002, 
          9.0758311145925745}, {.42000000000000021, 
          8.8348437976536616}, {.43000000000000022, 
          8.5715381795500889}, {.44000000000000022, 
          8.2865475135697579}, {.45000000000000023, 
          7.9805598782245397}, {.46000000000000024, 
          23.000000000000568}, {.47000000000000025, 
          23.5}, {.48000000000000026, 
          24.000000000000682}, {.49000000000000027, 
          24.499999999999545}, {.50000000000000022, 
          25.00000000000216}, {.51000000000000023, 
          25.499999999998863}, {.52000000000000024, 
          25.999999999998977}, {.53000000000000025, 
          26.500000000002046}, {.54000000000000026, 
          26.999999999999432}, {.55000000000000027, 
          27.500000000001364}, {.56000000000000028, 
          27.999999999998408}, {.57000000000000028, 
          28.499999999999318}, {.58000000000000029, 
          29.000000000002501}, {.5900000000000003, 
          29.500000000000909}, {.60000000000000031, 
          30.000000000001137}, {.61000000000000032, 
          30.500000000001364}, {.62000000000000033, 
          30.999999999999091}, {.63000000000000034, 
          31.499999999999318}, {.64000000000000035, 
          32.000000000000909}, {.65000000000000036, 
          32.499999999999545}, {.66000000000000036, 
          32.999999999997954}, {.67000000000000037, 
          33.499999999996817}, {.68000000000000038, 
          33.999999999996135}, {.69000000000000039, 
          34.499999999999773}, {.7000000000000004, 
          34.999999999996817}, {.71000000000000041, 
          35.500000000004093}, {.72000000000000042, 
          35.999999999993634}, {.73000000000000043, 
          36.500000000007731}, {.74000000000000044, 
          37.000000000005457}, {.75000000000000044, 
          37.500000000005002}, {.76000000000000045, 
          38.000000000005912}, {.77000000000000046, 
          38.500000000005457}, {.78000000000000047, 
          39.00000000000955}, {.79000000000000048, 
          39.500000000002274}, {.80000000000000049, 
          40.000000000005912}, {.8100000000000005, 40.5}, {.82000000000000051,
           41.000000000005457}, {.83000000000000052, 
          41.499999999999545}, {.84000000000000052, 
          41.999999999992724}, {.85000000000000053, 
          42.500000000004547}, {.86000000000000054, 
          43.000000000003638}, {.87000000000000055, 
          43.499999999997726}, {.88000000000000056, 
          43.999999999994088}, {.89000000000000057, 
          44.499999999999091}, {.90000000000000058, 
          45.000000000006821}, {.91000000000000059, 
          45.500000000000909}, {.9200000000000006, 
          45.999999999999545}, {.9300000000000006, 
          46.500000000006366}, {.94000000000000061, 
          46.999999999992724}, {.95000000000000062, 
          47.500000000005912}, {.96000000000000063, 
          48.000000000016371}, {.97000000000000064, 
          48.5}, {.98000000000000065, 
          49.000000000021828}, {.99000000000000066, 49.499999999990905}, {
          1.0000000000000007, 50.000000000021828}}], "  ", 
        ColumnForm[ {{0, 25}, {.01, 25}, {.02, 25}, {.029999999999999999, 
          25}, {.040000000000000001, 25}, {.050000000000000003, 
          25}, {.060000000000000005, 25}, {.070000000000000007, 
          25}, {.080000000000000002, 25}, {.089999999999999997, 
          25}, {.099999999999999992, 25}, {.10999999999999999, 
          25}, {.11999999999999998, 25}, {.12999999999999998, 
          25}, {.13999999999999999, 25}, {.14999999999999999, 25}, {.16, 
          25}, {.17000000000000001, 25}, {.18000000000000002, 
          25}, {.19000000000000003, 25}, {.20000000000000004, 
          25}, {.21000000000000005, 25}, {.22000000000000006, 
          25}, {.23000000000000007, 25}, {.24000000000000007, 
          25}, {.25000000000000006, 25}, {.26000000000000006, 
          25}, {.27000000000000007, 25}, {.28000000000000008, 
          25}, {.29000000000000009, 25}, {.3000000000000001, 
          25}, {.31000000000000011, 25}, {.32000000000000012, 
          25}, {.33000000000000013, 25}, {.34000000000000014, 
          25}, {.35000000000000014, 25}, {.36000000000000015, 
          25}, {.37000000000000016, 25}, {.38000000000000017, 
          25}, {.39000000000000018, 25}, {.40000000000000019, 
          25}, {.4100000000000002, 25}, {.42000000000000021, 
          25}, {.43000000000000022, 25}, {.44000000000000022, 
          25}, {.45000000000000023, 25}, {.46000000000000024, 
          0}, {.47000000000000025, 0}, {.48000000000000026, 
          0}, {.49000000000000027, 0}, {.50000000000000022, 
          0}, {.51000000000000023, 0}, {.52000000000000024, 
          0}, {.53000000000000025, 0}, {.54000000000000026, 
          0}, {.55000000000000027, 0}, {.56000000000000028, 
          0}, {.57000000000000028, 0}, {.58000000000000029, 
          0}, {.5900000000000003, 0}, {.60000000000000031, 
          0}, {.61000000000000032, 0}, {.62000000000000033, 
          0}, {.63000000000000034, 0}, {.64000000000000035, 
          0}, {.65000000000000036, 0}, {.66000000000000036, 
          0}, {.67000000000000037, 0}, {.68000000000000038, 
          0}, {.69000000000000039, 0}, {.7000000000000004, 
          0}, {.71000000000000041, 0}, {.72000000000000042, 
          0}, {.73000000000000043, 0}, {.74000000000000044, 
          0}, {.75000000000000044, 0}, {.76000000000000045, 
          0}, {.77000000000000046, 0}, {.78000000000000047, 
          0}, {.79000000000000048, 0}, {.80000000000000049, 
          0}, {.8100000000000005, 0}, {.82000000000000051, 
          0}, {.83000000000000052, 0}, {.84000000000000052, 
          0}, {.85000000000000053, 0}, {.86000000000000054, 
          0}, {.87000000000000055, 0}, {.88000000000000056, 
          0}, {.89000000000000057, 0}, {.90000000000000058, 
          0}, {.91000000000000059, 0}, {.9200000000000006, 
          0}, {.9300000000000006, 0}, {.94000000000000061, 
          0}, {.95000000000000062, 0}, {.96000000000000063, 
          0}, {.97000000000000064, 0}, {.98000000000000065, 
          0}, {.99000000000000066, 0}, {1.0000000000000007, 0}}]],
      Editable->False]], "Print"]
}, Open  ]]
}, Open  ]],

Cell["\<\
EJEMPLO:
Resolver mediante el m\[EAcute]todo de Hilberg, Hughes y Taylor no-lineal el \
siguiente problema de un material elasto-pl\[AAcute]stico perfecto:
0.2533\[CenterDot]a(t)+0.1589\[CenterDot]v(t)+fs(u,v)=p(t)
u(0)=0
v(0)=0
p(t)={{0,0},{.1,5},{.2,10},{.3,15},{.4,10},{.5,
        5},{.6,-5},{.7,-10},{.8,-15},{.9,-20},{1,-25},{1.1,-25},{1.2,-25}};
queremos la respuesta hasta el instante tn=1.2,con un incremento de tiempo de \
to=0.01. La rigidez del tramo el\[AAcute]stico es 10, la m\[AAcute]xima \
tracci\[OAcute]n es 15 y la m\[AAcute]xima compresi\[OAcute]n es -15.\
\>", "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Este es un caso donde la carga me la dan discretizada,y as\[IAcute] conocemos \
la carga para unos instantes determinados de tiempo.\
\>", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\[IndentingNewLine]\(p = {{0, 0}, { .1, 5}, { .2, 10}, { .3, 15}, { .4, 
            10}, { .5, 
            5}, { .6, \(-5\)}, { .7, \(-10\)}, { .8, \(-15\)}, { .9, \
\(-20\)}, {1, \(-25\)}, {1.1, \(-25\)}, {1.2, \(-25\)}};\)\), "\
\[IndentingNewLine]", 
    \(HilbergNoLineal[0, 1.2, 0.01, 0, 0, 10, 0.2533, 0.1589, \(-15\), 15, p, 
      0.5, 0.1666666667, \(-0.1\), posicion, velocidad, 
      aceleracion]\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.793651 0.382592 0.0147151 [
[.18254 .37009 -9 -9 ]
[.18254 .37009 9 0 ]
[.34127 .37009 -9 -9 ]
[.34127 .37009 9 0 ]
[.5 .37009 -9 -9 ]
[.5 .37009 9 0 ]
[.65873 .37009 -9 -9 ]
[.65873 .37009 9 0 ]
[.81746 .37009 -3 -9 ]
[.81746 .37009 3 0 ]
[.97619 .37009 -9 -9 ]
[.97619 .37009 9 0 ]
[1.025 .38259 0 -6.25 ]
[1.025 .38259 10 6.25 ]
[.01131 .08829 -18 -4.5 ]
[.01131 .08829 0 4.5 ]
[.01131 .23544 -18 -4.5 ]
[.01131 .23544 0 4.5 ]
[.01131 .52974 -12 -4.5 ]
[.01131 .52974 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .38259 m
.18254 .38884 L
s
[(0.2)] .18254 .37009 0 1 Mshowa
.34127 .38259 m
.34127 .38884 L
s
[(0.4)] .34127 .37009 0 1 Mshowa
.5 .38259 m
.5 .38884 L
s
[(0.6)] .5 .37009 0 1 Mshowa
.65873 .38259 m
.65873 .38884 L
s
[(0.8)] .65873 .37009 0 1 Mshowa
.81746 .38259 m
.81746 .38884 L
s
[(1)] .81746 .37009 0 1 Mshowa
.97619 .38259 m
.97619 .38884 L
s
[(1.2)] .97619 .37009 0 1 Mshowa
.125 Mabswid
.06349 .38259 m
.06349 .38634 L
s
.10317 .38259 m
.10317 .38634 L
s
.14286 .38259 m
.14286 .38634 L
s
.22222 .38259 m
.22222 .38634 L
s
.2619 .38259 m
.2619 .38634 L
s
.30159 .38259 m
.30159 .38634 L
s
.38095 .38259 m
.38095 .38634 L
s
.42063 .38259 m
.42063 .38634 L
s
.46032 .38259 m
.46032 .38634 L
s
.53968 .38259 m
.53968 .38634 L
s
.57937 .38259 m
.57937 .38634 L
s
.61905 .38259 m
.61905 .38634 L
s
.69841 .38259 m
.69841 .38634 L
s
.7381 .38259 m
.7381 .38634 L
s
.77778 .38259 m
.77778 .38634 L
s
.85714 .38259 m
.85714 .38634 L
s
.89683 .38259 m
.89683 .38634 L
s
.93651 .38259 m
.93651 .38634 L
s
.25 Mabswid
0 .38259 m
1 .38259 L
s
gsave
1.025 .38259 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .08829 m
.03006 .08829 L
s
[(-20)] .01131 .08829 1 0 Mshowa
.02381 .23544 m
.03006 .23544 L
s
[(-10)] .01131 .23544 1 0 Mshowa
.02381 .52974 m
.03006 .52974 L
s
[(10)] .01131 .52974 1 0 Mshowa
.125 Mabswid
.02381 .11772 m
.02756 .11772 L
s
.02381 .14715 m
.02756 .14715 L
s
.02381 .17658 m
.02756 .17658 L
s
.02381 .20601 m
.02756 .20601 L
s
.02381 .26487 m
.02756 .26487 L
s
.02381 .2943 m
.02756 .2943 L
s
.02381 .32373 m
.02756 .32373 L
s
.02381 .35316 m
.02756 .35316 L
s
.02381 .41202 m
.02756 .41202 L
s
.02381 .44145 m
.02756 .44145 L
s
.02381 .47088 m
.02756 .47088 L
s
.02381 .50031 m
.02756 .50031 L
s
.02381 .05886 m
.02756 .05886 L
s
.02381 .02943 m
.02756 .02943 L
s
.02381 .55917 m
.02756 .55917 L
s
.02381 .5886 m
.02756 .5886 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
1 0 1 r
.5 Mabswid
.02381 .38259 m
.03175 .38995 L
.03968 .39731 L
.04762 .40467 L
.05556 .41202 L
.06349 .41938 L
.07143 .42674 L
.07937 .4341 L
.0873 .44145 L
.09524 .44881 L
.10317 .45617 L
.11111 .46353 L
.11905 .47088 L
.12698 .47824 L
.13492 .4856 L
.14286 .49296 L
.15079 .50031 L
.15873 .50767 L
.16667 .51503 L
.1746 .52239 L
.18254 .52974 L
.19048 .5371 L
.19841 .54446 L
.20635 .55182 L
.21429 .55917 L
.22222 .56653 L
.23016 .57389 L
.2381 .58125 L
.24603 .5886 L
.25397 .59596 L
.2619 .60332 L
.26984 .59596 L
.27778 .5886 L
.28571 .58125 L
.29365 .57389 L
.30159 .56653 L
.30952 .55917 L
.31746 .55182 L
.3254 .54446 L
.33333 .5371 L
.34127 .52974 L
.34921 .52239 L
.35714 .51503 L
.36508 .50767 L
.37302 .50031 L
.38095 .49296 L
.38889 .4856 L
.39683 .47824 L
.40476 .47088 L
.4127 .46353 L
Mistroke
.42063 .45617 L
.42857 .44145 L
.43651 .42674 L
.44444 .41202 L
.45238 .39731 L
.46032 .38259 L
.46825 .36788 L
.47619 .35316 L
.48413 .33845 L
.49206 .32373 L
.5 .30902 L
.50794 .30166 L
.51587 .2943 L
.52381 .28694 L
.53175 .27959 L
.53968 .27223 L
.54762 .26487 L
.55556 .25751 L
.56349 .25016 L
.57143 .2428 L
.57937 .23544 L
.5873 .22808 L
.59524 .22073 L
.60317 .21337 L
.61111 .20601 L
.61905 .19865 L
.62698 .1913 L
.63492 .18394 L
.64286 .17658 L
.65079 .16922 L
.65873 .16187 L
.66667 .15451 L
.6746 .14715 L
.68254 .13979 L
.69048 .13244 L
.69841 .12508 L
.70635 .11772 L
.71429 .11036 L
.72222 .10301 L
.73016 .09565 L
.7381 .08829 L
.74603 .08093 L
.75397 .07358 L
.7619 .06622 L
.76984 .05886 L
.77778 .0515 L
.78571 .04415 L
.79365 .03679 L
.80159 .02943 L
.80952 .02207 L
Mistroke
.81746 .01472 L
.8254 .01472 L
.83333 .01472 L
.84127 .01472 L
.84921 .01472 L
.85714 .01472 L
.86508 .01472 L
.87302 .01472 L
.88095 .01472 L
.88889 .01472 L
.89683 .01472 L
.90476 .01472 L
.9127 .01472 L
.92063 .01472 L
.92857 .01472 L
.93651 .01472 L
.94444 .01472 L
.95238 .01472 L
.96032 .01472 L
.96825 .01472 L
.97619 .01472 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00O5Goo00<007ooOol0
ogoo2Goo000EOol00`00Oomoo`3oOol9Ool001Eoo`03001oogoo0?moo`Uoo`005Goo00<007ooOol0
agoo:W`O5goo000EOol00`00Oomoo`36Ool00g`OOomoo`0oOol001Eoo`03001oogoo0<Eoo`03O1mo
ogoo041oo`005Goo00<007ooOol0a7oo00=l7gooOol0@Goo000EOol20034Ool00g`OOomoo`12Ool0
01Eoo`03001oogoo0<9oo`03O1moogoo04=oo`005Goo00<007ooOol0`Goo00=l7gooOol0A7oo000E
Ool00`00Oomoo`30Ool00g`OOomoo`15Ool001Eoo`03001oogoo0;moo`03O1moogoo04Ioo`005Goo
00<007ooOol0_Woo00=l7gooOol0Agoo000EOol00`00Oomoo`2mOol00g`OOomoo`18Ool001Eoo`03
001oogoo0;aoo`03O1moogoo04Uoo`005Goo0P00_7oo00=l7gooOol0BWoo000EOol00`00Oomoo`2j
Ool00g`OOomoo`1;Ool001Eoo`03001oogoo0;Qoo`9l7dioo`005Goo00<007ooOol0]goo00=l7goo
Ool0CWoo000EOol00`00Oomoo`2fOol00g`OOomoo`1?Ool000Moo`@000=oo`8000Eoo`03001oogoo
0;Eoo`03O1moogoo051oo`001goo00<007ooOol00goo00@007ooOol000Aoo`03001oogoo0;Aoo`03
O1moogoo055oo`0027oo00<007ooOol00Woo00@007ooOol000Aoo`800;Aoo`03O1moogoo059oo`00
00=oo`0000000P0017oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo0;9oo`03O1mo
ogoo05=oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`2aOol00g`OOomoo`1D
Ool000Qoo`8000Aoo`8000Eoo`03001oogoo0;1oo`03O1moogoo05Eoo`005Goo00<007ooOol0[goo
00=l7gooOol0EWoo000EOol00`00Oomoo`2^Ool00g`OOomoo`1GOol001Eoo`03001oogoo0:eoo`03
O1moogoo05Qoo`005Goo00<007ooOol0[7oo00=l7gooOol0FGoo000EOol2002/Ool00g`OOomoo`1J
Ool001Eoo`03001oogoo0:Yoo`03O1moogoo05]oo`005Goo00<007ooOol0Z7oo0W`OGWoo000EOol0
0`00Oomoo`2WOol00g`OOomoo`1NOol001Eoo`03001oogoo0:Ioo`03O1moogoo05moo`005Goo00<0
07ooOol0YGoo00=l7gooOol0H7oo000EOol00`00Oomoo`2TOol00g`OOomoo`1QOol001Eoo`800:Ao
o`03O1moogoo069oo`005Goo00<007ooOol0XWoo00=l7gooOol0Hgoo000EOol00`00Oomoo`2QOol0
0g`OOomoo`1TOol001Eoo`03001oogoo0:1oo`03O1moogoo06Eoo`005Goo00<007ooOol0Wgoo00=l
7gooOol0IWoo000EOol00`00Oomoo`2NOol00g`OOomoo`1WOol001Eoo`03001oogoo09eoo`03O1mo
ogoo06Qoo`005Goo00<007ooOol0W7oo00=l7gooOol0JGoo000EOol2002LOol00g`OOomoo`1ZOol0
01Eoo`03001oogoo09Yoo`03O1moogoo06]oo`005Goo00<007ooOol0VGoo00=l7gooOol0K7oo000E
Ool00`00Oomoo`2HOol00g`OOomoo`1]Ool001Eoo`03001oogoo09Ioo`9l7g1oo`005Goo00<007oo
Ool0UGoo00=l7gooOol0L7oo000EOol00`00Oomoo`2DOol00g`OOomoo`1aOol001Eoo`8009Aoo`03
O1moogoo079oo`005Goo00<007ooOol0TWoo00=l7gooOol0Lgoo000EOol00`00Oomoo`2AOol00g`O
Oomoo`1dOol001Eoo`03001oogoo091oo`03O1moogoo07Eoo`005Goo00<007ooOol0Sgoo00=l7goo
Ool0MWoo000EOol00`00Oomoo`2>Ool00g`OOomoo`1gOol000Moo`D0009oo`8000Eoo`03001oogoo
08eoo`03O1moogoo07Qoo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo08ao
o`03O1moogoo07Uoo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`8008aoo`03O1moogoo
07Yoo`0000=oo`0000000P0017oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo08Yo
o`03O1moogoo07]oo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo08Uoo`03
O1moogoo07aoo`0027oo0P0017oo0P001Goo00<007ooOol0R7oo00=l7gooOol0OGoo000EOol00`00
Oomoo`26Ool2O1n0Ool001Eoo`03001oogoo08Eoo`03O1moogoo081oo`005Goo00<007ooOol0Q7oo
00=l7gooOol0PGoo000EOol20024Ool00g`OOomoo`22Ool001Eoo`03001oogoo089oo`03O1moogoo
08=oo`005Goo00<007ooOol0PGoo00=l7gooOol0Q7oo000EOol00`00Oomoo`1oOol2O1n7Ool001Eo
o`03001oogoo07ioo`03O1moogoo08Moo`005Goo00<007ooOol0OGoo00=l7gooOol0R7oo000EOol0
0`00Oomoo`1lOol00g`OOomoo`29Ool001Eoo`03001oogoo07]oo`03O1moogoo08Yoo`005Goo0P00
Ngoo00=l7gooOol0Rgoo000EOol00`00Oomoo`1iOol00g`OOomoo`2<Ool001Eoo`03001oogoo07Qo
o`03O1moogoo08eoo`005Goo00<007ooOol0Mgoo00=l7gooOol0SWoo000EOol00`00Oomoo`1fOol0
0g`OOomoo`2?Ool001Eoo`03001oogoo07Eoo`03O1moogoo091oo`005Goo00<007ooOol0MGoo00=l
7gooOol0T7oo000EOol2001eOol00g`OOomoo`2AOol001Eoo`03001oogoo07Aoo`03O1moogoo095o
o`005Goo00<007ooOol0Lgoo00=l7gooOol0TWoo000EOol00`00Oomoo`1cOol00g`OOomoo`2BOol0
01Eoo`03001oogoo01ioo`8000Aoo`8000=oo`@001Yoo`8000Aoo`8000Eoo`<001Qoo`800004Ooml
7gooOol20003Ool3000KOol20004Ool20004Ool2000OOol5000NOol50002Ool20003Ool4000@Ool0
01Eoo`03001oogoo01eoo`04001oogoo0008Ool00`00Oomoo`0JOol01000Oomoo`002goo00<007oo
Ool05Woo00D007ooOol007`O00Moo`04001oogoo000IOol01000Oomoo`0027oo00@007ooOol0021o
o`03001oogoo021oo`03001oogoo00Moo`03001oogoo015oo`005Goo00<007ooOol07Goo00@007oo
Ool000Uoo`03001oogoo01Uoo`04001oogoo0008Ool5000GOol01000Oomoog`O27oo00@007ooOol0
01Uoo`04001oogoo0008Ool01000Oomoo`0087oo00<007ooOol087oo00<007ooOol027oo00<007oo
Ool047oo000EOol00`00Oomoo`0MOol01000Oomoo`002Woo00<007ooOol067oo00@007ooOol000Qo
o`04001oogoo000HOol01000Oomoog`O27oo0`006Woo00@007ooOol000Uoo`80025oo`03001oogoo
021oo`03001oogoo00Uoo`03001oogoo00moo`005Goo0P007Woo00@007ooOol000Qoo`04001oogoo
000IOol01000Oomoo`002Goo00<007oo000067oo00@007ooO1l000Uoo`03001oogoo01Uoo`04001o
ogoo0008Ool01000Oomoo`0087oo00<007ooOol087oo00<007ooOol01goo00@007ooOol0011oo`00
5Goo00<007ooOol07Woo0P002Woo0P006goo0P002goo0P006Goo00<007`OOol02Goo0`006Woo0P00
2Woo0P0087oo0P008Goo0P002Woo0P004Goo000EOol00`00Oomoo`1_Ool00g`OOomoo`2FOol001Eo
o`03001oogoo06moo`03O1moogoo09Ioo`005Goo00<007ooOol0KWoo00=l7gooOol0Ugoo000EOol0
0`00Oomoo`1]Ool00g`OOomoo`2HOol001Eoo`03001oogoo06eoo`03O1moogoo095oo`8000Eoo`00
3goo1P0000=l7`000000K00000=l7`000000R0002Goo00@007ooOol000Aoo`005Goo00<007`OOol0
1goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol0
27oo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol0
1goo00=l7gooOol01goo00<007ooOol027oo00<007ooOol01goo00<007ooOol01goo00<007ooOol0
1goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol0
27oo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol03Goo00<007ooOol0
1Goo000EOol00`00Ooml7`0UOol00`00Oomoo`0VOol00`00Oomoo`0JOol00g`OOomoo`08Ool00`00
Oomoo`0VOol00`00Oomoo`0UOol00`00Oomoo`0VOol00`00Oomoo`0<Ool50004Ool001Eoo`04001o
ogooO1mZOol00g`OOomoo`2BOol00`00Oomoo`05Ool001Eoo`05001oogooOoml7`1XOol00g`OOomo
o`2KOol001Eoo`03001oogoo009oo`03O1moogoo06Eoo`03O1moogoo09]oo`005Goo00<007ooOol0
0goo00=l7gooOol0Hgoo00=l7gooOol0W7oo000EOol00`00Oomoo`04Ool00g`OOomoo`1ROol00g`O
Oomoo`2LOol001Eoo`8000Ioo`03O1moogoo061oo`03O1moogoo09eoo`005Goo00<007ooOol01Woo
00=l7gooOol0Ggoo00=l7gooOol0WGoo000EOol00`00Oomoo`07Ool00g`OOomoo`1MOol00g`OOomo
o`2NOol001Eoo`03001oogoo00Qoo`03O1moogoo05aoo`03O1moogoo09ioo`005Goo00<007ooOol0
2Goo00=l7gooOol0FWoo00=l7gooOol0Wgoo000EOol00`00Oomoo`0:Ool00g`OOomoo`1HOol00g`O
Oomoo`2POol001Eoo`03001oogoo00]oo`9l7eQoo`03O1moogoo0:1oo`005Goo0P003Woo00=l7goo
Ool0E7oo00=l7gooOol0XGoo000EOol00`00Oomoo`0>Ool00g`OOomoo`1COol00g`OOomoo`2QOol0
01Eoo`03001oogoo00moo`03O1moogoo055oo`03O1moogoo0:9oo`005Goo00<007ooOol047oo00=l
7gooOol0D7oo00=l7gooOol0XWoo000EOol00`00Oomoo`0AOol00g`OOomoo`1>Ool00g`OOomoo`2S
Ool001Eoo`03001oogoo019oo`03O1moogoo04aoo`03O1moogoo0:Aoo`005Goo00<007ooOol04goo
00=l7gooOol0BWoo00=l7gooOol0YGoo000EOol00`00Oomoo`0DOol00g`OOomoo`18Ool00g`OOomo
o`2VOol001Eoo`8001Ioo`03O1moogoo04Ioo`03O1moogoo0:Moo`005Goo00<007ooOol05Woo00=l
7gooOol0A7oo00=l7gooOol0Z7oo000EOol00`00Oomoo`0GOol00g`OOomoo`12Ool00g`OOomoo`2Y
Ool001Eoo`03001oogoo01Qoo`03O1moogoo041oo`03O1moogoo0:Yoo`005Goo00<007ooOol06Goo
00=l7gooOol0?Woo00=l7gooOol0Zgoo000EOol00`00Oomoo`0JOol00g`OOomoo`0lOol00g`OOomo
o`2/Ool001Eoo`03001oogoo01]oo`9l7cYoo`9l7jmoo`005Goo0P007Woo00=l7gooOol0=Woo00=l
7gooOol0[goo000EOol00`00Oomoo`0NOol00g`OOomoo`0dOol00g`OOomoo`2`Ool001Eoo`03001o
ogoo01moo`03O1moogoo039oo`03O1moogoo0;5oo`005Goo00<007ooOol087oo00=l7gooOol0<7oo
00=l7gooOol0/Woo000EOol00`00Oomoo`0QOol00g`OOomoo`0^Ool00g`OOomoo`2cOol001Eoo`03
001oogoo029oo`03O1moogoo02aoo`03O1moogoo0;Aoo`001goo1@000Woo0P001Goo00<007ooOol0
8goo00=l7gooOol0:Woo00=l7gooOol0]Goo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo
00<007ooOol097oo00=l7gooOol0:7oo00=l7gooOol0]Woo0009Ool01@00Oomoogoo00000Woo00<0
07ooOol00Woo0P009Woo00=l7gooOol09Woo00=l7gooOol0]goo0009Ool01@00Oomoogoo00000Woo
00<007ooOol00Woo00<007ooOol09Woo00=l7gooOol097oo00=l7gooOol0^7oo0009Ool01@00Oomo
ogoo00000Woo00<007ooOol00Woo00<007ooOol09goo00=l7gooOol08Woo00=l7gooOol0^Goo0008
Ool20004Ool20005Ool00`00Oomoo`0XOol00g`OOomoo`0POol00g`OOomoo`2jOol001Eoo`03001o
ogoo02Uoo`03O1moogoo01ioo`03O1moogoo0;]oo`005Goo00<007ooOol0:Woo00=l7gooOol077oo
00=l7gooOol0_7oo000EOol00`00Oomoo`0[Ool00g`OOomoo`0JOol00g`OOomoo`2mOol001Eoo`03
001oogoo02aoo`03O1moogoo01Qoo`03O1moogoo0;ioo`005Goo0P00;Woo0W`O5Woo0W`O`Goo000E
Ool00`00Oomoo`0_Ool00g`OOomoo`0BOol00g`OOomoo`31Ool001Eoo`03001oogoo031oo`03O1mo
ogoo011oo`03O1moogoo0<9oo`005Goo00<007ooOol0<Goo00=l7gooOol03Woo00=l7gooOol0`goo
000EOol00`00Oomoo`0bOol00g`OOomoo`0<Ool00g`OOomoo`34Ool001Eoo`03001oogoo03=oo`03
O1moogoo00Yoo`03O1moogoo0<Eoo`005Goo00<007ooOol0=7oo00=l7gooOol027oo00=l7gooOol0
aWoo000EOol2000fOol00g`OOomoo`06Ool00g`OOomoo`37Ool001Eoo`03001oogoo03Ioo`9l7`Eo
o`03O1moogoo0<Qoo`005Goo00<007ooOol0>7oo00El7gooOomoog`O0<]oo`005Goo00<007ooOol0
>Goo00=l7gooO1l0c7oo000EOol00`00Oomoo`0jOol00g`OOomoo`3;Ool001Eoo`03001oogoo0?mo
o`Uoo`005Goo00<007ooOol0ogoo2Goo000EOol00`00Oomoo`3oOol9Ool001Eoo`03001oogoo0?mo
o`Uoo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo
003oOolQOol0019oo`<00?moo`aoo`004goo00<007ooOol0ogoo2goo000COol3003oOol;Ool001=o
o`04001oogoo003oOol:Ool001=oo`04001oogoo003oOol:Ool0019oo`@00?moo`]oo`00ogoo8Goo
003oOolQOol00?moob5oo`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.104523, -26.0191, \
0.00493151, 0.265978}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.793651 0.417681 0.0484548 [
[.18254 .40518 -9 -9 ]
[.18254 .40518 9 0 ]
[.34127 .40518 -9 -9 ]
[.34127 .40518 9 0 ]
[.5 .40518 -9 -9 ]
[.5 .40518 9 0 ]
[.65873 .40518 -9 -9 ]
[.65873 .40518 9 0 ]
[.81746 .40518 -3 -9 ]
[.81746 .40518 3 0 ]
[.97619 .40518 -9 -9 ]
[.97619 .40518 9 0 ]
[1.025 .41768 0 -6.25 ]
[1.025 .41768 10 6.25 ]
[.01131 .03004 -12 -4.5 ]
[.01131 .03004 0 4.5 ]
[.01131 .12695 -12 -4.5 ]
[.01131 .12695 0 4.5 ]
[.01131 .22386 -12 -4.5 ]
[.01131 .22386 0 4.5 ]
[.01131 .32077 -12 -4.5 ]
[.01131 .32077 0 4.5 ]
[.01131 .51459 -6 -4.5 ]
[.01131 .51459 0 4.5 ]
[.01131 .6115 -6 -4.5 ]
[.01131 .6115 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .41768 m
.18254 .42393 L
s
[(0.2)] .18254 .40518 0 1 Mshowa
.34127 .41768 m
.34127 .42393 L
s
[(0.4)] .34127 .40518 0 1 Mshowa
.5 .41768 m
.5 .42393 L
s
[(0.6)] .5 .40518 0 1 Mshowa
.65873 .41768 m
.65873 .42393 L
s
[(0.8)] .65873 .40518 0 1 Mshowa
.81746 .41768 m
.81746 .42393 L
s
[(1)] .81746 .40518 0 1 Mshowa
.97619 .41768 m
.97619 .42393 L
s
[(1.2)] .97619 .40518 0 1 Mshowa
.125 Mabswid
.06349 .41768 m
.06349 .42143 L
s
.10317 .41768 m
.10317 .42143 L
s
.14286 .41768 m
.14286 .42143 L
s
.22222 .41768 m
.22222 .42143 L
s
.2619 .41768 m
.2619 .42143 L
s
.30159 .41768 m
.30159 .42143 L
s
.38095 .41768 m
.38095 .42143 L
s
.42063 .41768 m
.42063 .42143 L
s
.46032 .41768 m
.46032 .42143 L
s
.53968 .41768 m
.53968 .42143 L
s
.57937 .41768 m
.57937 .42143 L
s
.61905 .41768 m
.61905 .42143 L
s
.69841 .41768 m
.69841 .42143 L
s
.7381 .41768 m
.7381 .42143 L
s
.77778 .41768 m
.77778 .42143 L
s
.85714 .41768 m
.85714 .42143 L
s
.89683 .41768 m
.89683 .42143 L
s
.93651 .41768 m
.93651 .42143 L
s
.25 Mabswid
0 .41768 m
1 .41768 L
s
gsave
1.025 .41768 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .03004 m
.03006 .03004 L
s
[(-8)] .01131 .03004 1 0 Mshowa
.02381 .12695 m
.03006 .12695 L
s
[(-6)] .01131 .12695 1 0 Mshowa
.02381 .22386 m
.03006 .22386 L
s
[(-4)] .01131 .22386 1 0 Mshowa
.02381 .32077 m
.03006 .32077 L
s
[(-2)] .01131 .32077 1 0 Mshowa
.02381 .51459 m
.03006 .51459 L
s
[(2)] .01131 .51459 1 0 Mshowa
.02381 .6115 m
.03006 .6115 L
s
[(4)] .01131 .6115 1 0 Mshowa
.125 Mabswid
.02381 .05427 m
.02756 .05427 L
s
.02381 .0785 m
.02756 .0785 L
s
.02381 .10273 m
.02756 .10273 L
s
.02381 .15118 m
.02756 .15118 L
s
.02381 .17541 m
.02756 .17541 L
s
.02381 .19963 m
.02756 .19963 L
s
.02381 .24809 m
.02756 .24809 L
s
.02381 .27232 m
.02756 .27232 L
s
.02381 .29654 m
.02756 .29654 L
s
.02381 .345 m
.02756 .345 L
s
.02381 .36923 m
.02756 .36923 L
s
.02381 .39345 m
.02756 .39345 L
s
.02381 .44191 m
.02756 .44191 L
s
.02381 .46614 m
.02756 .46614 L
s
.02381 .49036 m
.02756 .49036 L
s
.02381 .53882 m
.02756 .53882 L
s
.02381 .56305 m
.02756 .56305 L
s
.02381 .58727 m
.02756 .58727 L
s
.02381 .00582 m
.02756 .00582 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .41768 m
.02846 .41768 L
.02952 .41768 L
.03068 .41769 L
.03178 .41769 L
.03279 .41769 L
.03527 .41769 L
.03754 .41769 L
.03881 .4177 L
.04 .4177 L
.04125 .4177 L
.04262 .41771 L
.04517 .41772 L
.04644 .41772 L
.04761 .41772 L
.04866 .41773 L
.04979 .41774 L
.05217 .41775 L
.05756 .4178 L
.06244 .41785 L
.06787 .41793 L
.07287 .41803 L
.07835 .41815 L
.08414 .41832 L
.09388 .41868 L
.10458 .41921 L
.11478 .41986 L
.12409 .42059 L
.145 .42276 L
.16409 .42547 L
.18485 .42926 L
.22563 .43949 L
.2649 .45289 L
.30265 .46848 L
.34285 .48565 L
.38154 .50176 L
.42268 .52157 L
.4623 .54226 L
.50041 .56163 L
.54097 .57947 L
.58002 .59267 L
.59026 .59534 L
.60136 .59785 L
.61096 .59968 L
.62152 .60124 L
.62647 .60186 L
.63178 .60237 L
.63638 .60274 L
.64139 .60304 L
.64212 .60308 L
Mistroke
.64281 .60312 L
.6436 .60315 L
.64432 .60317 L
.64703 .60323 L
.64828 .60327 L
.64961 .6033 L
.6503 .60332 L
.65106 .60332 L
.65174 .60328 L
.65239 .60324 L
.65492 .6031 L
.65631 .60303 L
.65761 .60296 L
.65871 .60289 L
.6599 .60277 L
.66243 .6025 L
.66488 .60224 L
.66553 .60217 L
.66622 .6021 L
.66746 .60187 L
.66882 .60155 L
.6703 .6012 L
.67291 .60059 L
.67811 .59892 L
.68283 .59718 L
.69238 .59226 L
.70139 .58634 L
.72145 .5688 L
.73991 .54734 L
.77937 .48679 L
.81731 .41388 L
.8577 .32605 L
.89658 .23255 L
.93791 .12377 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00O4Woo00<007ooOol0
ogoo37oo000BOol2003oOol=Ool0019oo`03001oogoo0?moo`aoo`004Woo00<007ooOol0l7oo00=l
07ooOol067oo000BOol00`00Oomoo`3`Ool00g`0Oomoo`0HOol000Yoo`8000Ioo`03001oogoo0>mo
o`03O01oogoo01Uoo`002Goo00@007ooOol000Eoo`03001oogoo0>moo`03O01oogoo01Uoo`002Goo
00@007ooOol000Eoo`800?1oo`03O01oogoo01Uoo`000goo10000goo0P001Woo00<007ooOol0kWoo
00=l07ooOol06Woo0009Ool01000Oomoo`001Goo00<007ooOol0kWoo00=l07ooOol06Woo000:Ool2
0006Ool00`00Oomoo`3^Ool00g`0Oomoo`0JOol0019oo`03001oogoo0>eoo`03O01oogoo01]oo`00
4Woo00<007ooOol0kGoo00=l07ooOol06goo000BOol2003]Ool00g`0Oomoo`0LOol0019oo`03001o
ogoo0>aoo`03O01oogoo01aoo`004Woo00<007ooOol0k7oo00=l07ooOol077oo000BOol00`00Oomo
o`3[Ool00g`0Oomoo`0MOol0019oo`03001oogoo0>]oo`03O01oogoo01eoo`004Woo00<007ooOol0
jgoo00=l07ooOol07Goo000BOol00`00Oomoo`3ZOol00g`0Oomoo`0NOol0019oo`800>]oo`03O01o
ogoo01ioo`004Woo00<007ooOol0jWoo00=l07ooOol07Woo000BOol00`00Oomoo`3YOol00g`0Oomo
o`0OOol0019oo`03001oogoo0>Uoo`03O01oogoo01moo`004Woo00<007ooOol0jGoo00=l07ooOol0
7goo000BOol00`00Oomoo`3XOol00g`0Oomoo`0POol0019oo`800>Uoo`03O01oogoo021oo`004Woo
00<007ooOol0igoo00=l07ooOol08Goo000BOol00`00Oomoo`3WOol00g`0Oomoo`0QOol0019oo`03
001oogoo0>Moo`03O01oogoo025oo`002Goo0`001Woo00<007ooOol0iWoo00=l07ooOol08Woo0009
Ool01000Oomoo`001Goo00<007ooOol0iWoo00=l07ooOol08Woo0009Ool01000Oomoo`001Goo0P00
igoo00=l07ooOol08Woo0003Ool40002Ool30006Ool00`00Oomoo`3UOol00g`0Oomoo`0SOol000Yo
o`03001oogoo00Eoo`03001oogoo0>Eoo`03O01oogoo02=oo`002Woo0`001Goo00<007ooOol0iGoo
00=l07ooOol08goo000BOol00`00Oomoo`3TOol00g`0Oomoo`0TOol0019oo`03001oogoo0>Aoo`03
O01oogoo02Aoo`004Woo0P00iGoo00=l07ooOol097oo000BOol00`00Oomoo`3SOol00g`0Oomoo`0U
Ool0019oo`03001oogoo0>=oo`03O01oogoo02Eoo`004Woo00<007ooOol0hWoo00=l07ooOol09Woo
000BOol00`00Oomoo`3ROol00g`0Oomoo`0VOol0019oo`03001oogoo0>9oo`03O01oogoo02Ioo`00
4Woo0P00hWoo00=l07ooOol09goo000BOol00`00Oomoo`3QOol00g`0Oomoo`0WOol0019oo`03001o
ogoo0>5oo`03O01oogoo02Moo`004Woo00<007ooOol0h7oo00=l07ooOol0:7oo000BOol00`00Oomo
o`3POol00g`0Oomoo`0XOol0019oo`03001oogoo0>1oo`03O01oogoo02Qoo`004Woo00<007ooOol0
ggoo00=l07ooOol0:Goo000BOol2003POol00g`0Oomoo`0YOol0019oo`03001oogoo0=moo`03O01o
ogoo02Uoo`004Woo00<007ooOol0gWoo00=l07ooOol0:Woo000BOol00`00Oomoo`3NOol00g`0Oomo
o`0ZOol000]oo`<000Aoo`03001oogoo0=eoo`03O01oogoo02]oo`0037oo00<007ooOol00goo00<0
07ooOol0gGoo00=l07ooOol0:goo0009Ool50004Ool2003NOol00g`0Oomoo`0[Ool000=oo`@0009o
o`04001oogoo0005Ool00`00Oomoo`3LOol00g`0Oomoo`0/Ool000Yoo`03001oo`0000Eoo`03001o
ogoo0=aoo`03O01oogoo02aoo`002goo0P001Goo00<007ooOol0g7oo00=l07ooOol0;7oo000BOol0
0`00Oomoo`3KOol00g`0Oomoo`0]Ool0019oo`03001oogoo0=]oo`03O01oogoo02eoo`004Woo0P00
fgoo00=l07ooOol0;Woo000BOol00`00Oomoo`3JOol00g`0Oomoo`0^Ool0019oo`03001oogoo0=Yo
o`03O01oogoo02ioo`004Woo00<007ooOol0fGoo00=l07ooOol0;goo000BOol00`00Oomoo`3IOol0
0g`0Oomoo`0_Ool0019oo`03001oogoo0=Qoo`03O01oogoo031oo`004Woo0P00fGoo00=l07ooOol0
<7oo000BOol00`00Oomoo`3GOol00g`0Oomoo`0aOol0019oo`03001oogoo0=Moo`03O01oogoo035o
o`004Woo00<007ooOol0egoo00=l07ooOol0<Goo000BOol00`00Oomoo`3FOol00g`0Oomoo`0bOol0
019oo`03001oogoo0=Ioo`03O01oogoo039oo`004Woo0P00eWoo00=l07ooOol0<goo000BOol00`00
Oomoo`3EOol00g`0Oomoo`0cOol0019oo`03001oogoo0=Eoo`03O01oogoo03=oo`004Woo00<007oo
Ool0e7oo00=l07ooOol0=7oo000BOol00`00Oomoo`3DOol00g`0Oomoo`0dOol000Uoo`@000Eoo`03
001oogoo0==oo`03O01oogoo03Eoo`002Goo00<007ooOol01Woo00<007ooOol0dgoo00=l07ooOol0
=Goo000:Ool00`00Oomoo`05Ool2003COol00g`0Oomoo`0fOol000=oo`@000Aoo`03001oogoo00Ao
o`03001oogoo0=9oo`03O01oogoo03Ioo`002Goo00@007ooOol000Eoo`03001oogoo0=9oo`03O01o
ogoo03Ioo`002Woo0P001Woo00<007ooOol0dGoo00=l07ooOol0=goo000BOol00`00Oomoo`3AOol0
0g`0Oomoo`0gOol0019oo`03001oogoo0=1oo`03O01oogoo03Qoo`004Woo0P00dGoo00=l07ooOol0
>7oo000BOol00`00Oomoo`3?Ool00g`0Oomoo`0iOol0019oo`03001oogoo0<moo`03O01oogoo03Uo
o`004Woo00<007ooOol0cWoo00=l07ooOol0>Woo000BOol00`00Oomoo`3>Ool00g`0Oomoo`0jOol0
019oo`03001oogoo0<eoo`03O01oogoo03]oo`004Woo0P00cWoo00=l07ooOol0>goo000BOol00`00
Oomoo`0NOol20004Ool20003Ool4000JOol20004Ool20005Ool3000HOol20004Ool20003Ool3000K
Ool20004Ool20004Ool2000POol50002Ool00g`0Oomoo`0HOol50002Ool20003Ool4000COol0019o
o`03001oogoo01eoo`04001oogoo0008Ool00`00Oomoo`0JOol01000Oomoo`002goo00<007ooOol0
5Woo00@007ooOol000Qoo`04001oogoo000IOol01000Oomoo`0027oo00@007ooOol0025oo`05001o
ogooOoml000MOol00`00Oomoo`07Ool00`00Oomoo`0DOol0019oo`03001oogoo01eoo`04001oogoo
0009Ool00`00Oomoo`0IOol01000Oomoo`0027oo1@005goo00@007ooOol000Qoo`04001oogoo000I
Ool01000Oomoo`0027oo00@007ooOol0025oo`05001oogooOoml000MOol00`00Oomoo`08Ool00`00
Oomoo`0COol0019oo`03001oogoo01eoo`04001oogoo000:Ool00`00Oomoo`0HOol01000Oomoo`00
27oo00@007ooOol001Qoo`04001oogoo0008Ool3000JOol01000Oomoo`002Goo0P008Woo00@007oo
Ooml01ioo`03001oogoo00Uoo`03001oogoo019oo`004Woo00<007ooOol07Goo00@007ooOol000Qo
o`04001oogoo000IOol01000Oomoo`002Goo00<007oo000067oo00@007ooOol000Uoo`03001oogoo
01Uoo`04001oogoo0008Ool01000Oomoo`008Goo00@007ooOoml01ioo`03001oogoo00Moo`04001o
ogoo000COol0019oo`8001moo`8000Yoo`8001]oo`8000]oo`8001Uoo`8000Yoo`<001Yoo`8000Yo
o`80025oo`800003Ooml07oo01eoo`8000Yoo`8001Aoo`004Woo00<007ooOol0bWoo00=l07ooOol0
?Woo000BOol00`00Oomoo`39Ool00g`0Oomoo`0oOol0019oo`03001oogoo0<Uoo`03O01oogoo03mo
o`004Woo00<007ooOol0b7oo00=l07ooOol0@7oo000BOol00`00Oomoo`38Ool00g`0Oomoo`0fOol2
0008Ool000]oo`L000ml0;/00003O000000002d000Uoo`04001oogoo0007Ool0019oo`03001oogoo
00Moo`03001oogoo009oo`il0003Ool007oo00Qoo`03001oogoo00Moo`03001oogoo00Moo`03001o
ogoo00Qoo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001o
ogoo00Moo`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001o
ogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03O00007oo00Qoo`03001o
ogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00eoo`03001oogoo00Qoo`004Woo
00<007ooOol06Woo2W`000=oo`00Ool09goo00<007ooOol09Goo00<007ooOol09Woo00<007ooOol0
97oo00=l07oo00009goo00<007ooOol037oo1@001goo000BOol00`00Oomoo`0TOol4O02NOol00g`0
Oomoo`0gOol00`00Oomoo`08Ool0019oo`03001oogoo02Qoo`Al09Uoo`03O01oogoo04=oo`004Woo
00<007ooOol0;7oo0g`0UWoo00=l07ooOol0@goo000BOol00`00Oomoo`0_Ool3O02BOol00g`0Oomo
o`14Ool0019oo`8003=oo`Al08ioo`03O01oogoo04Aoo`004Woo00<007ooOol0=Woo0g`0RWoo00=l
07ooOol0AGoo000BOol00`00Oomoo`0iOol3O027Ool00g`0Oomoo`15Ool0019oo`03001oogoo03ao
o`9l08Aoo`03O01oogoo04Ioo`004Woo00<007ooOol0?Woo0g`0PGoo00=l07ooOol0AWoo000BOol0
0`00Oomoo`11Ool2O01nOol00g`0Oomoo`17Ool0019oo`8004Aoo`=l07]oo`03O01oogoo04Moo`00
4Woo00<007ooOol0AWoo0W`0N7oo00=l07ooOol0B7oo000BOol00`00Oomoo`18Ool2O01fOol00g`0
Oomoo`18Ool0019oo`03001oogoo04Yoo`9l07=oo`03O01oogoo04Uoo`004Woo00<007ooOol0C7oo
0W`0LGoo00=l07ooOol0BGoo000BOol00`00Oomoo`1>Ool2O01^Ool00g`0Oomoo`1:Ool0019oo`80
055oo`9l06]oo`03O01oogoo04]oo`004Woo00<007ooOol0DWoo0g`0J7oo00=l07ooOol0Bgoo000B
Ool00`00Oomoo`1EOol2O01UOol00g`0Oomoo`1<Ool0019oo`03001oogoo05Moo`=l069oo`03O01o
ogoo04aoo`002Goo10001Goo00<007ooOol0FWoo0W`0Ggoo00=l07ooOol0CGoo0009Ool00`00Oomo
o`06Ool00`00Oomoo`1LOol2O01LOol00g`0Oomoo`1>Ool000Yoo`03001oogoo00Eoo`8005moo`9l
05Yoo`03O01oogoo04ioo`002goo00<007ooOol017oo00<007ooOol0H7oo0W`0Egoo00=l07ooOol0
Cgoo0009Ool01000Oomoo`001Goo00<007ooOol0HWoo0g`0Dgoo00=l07ooOol0D7oo000:Ool20006
Ool00`00Oomoo`1UOol2O01AOol00g`0Oomoo`1@Ool0019oo`03001oogoo06Moo`9l04ioo`03O01o
ogoo055oo`004Woo00<007ooOol0JGoo0W`0C7oo00=l07ooOol0DGoo000BOol2001/Ool2O019Ool0
0g`0Oomoo`1BOol0019oo`03001oogoo06eoo`03O01oogoo04Eoo`03O01oogoo05=oo`004Woo00<0
07ooOol0KWoo0W`0AGoo00=l07ooOol0Dgoo000BOol00`00Oomoo`1`Ool2O012Ool00g`0Oomoo`1D
Ool0019oo`03001oogoo079oo`9l03moo`03O01oogoo05Eoo`004Woo00<007ooOol0M7oo0W`0?7oo
00=l07ooOol0EWoo000BOol00`00Oomoo`1fOol2O00iOol00g`0Oomoo`1GOol0019oo`8007Uoo`9l
03Ioo`03O01oogoo05Qoo`004Woo00<007ooOol0NWoo0W`0<goo00=l07ooOol0FGoo000BOol00`00
Oomoo`1lOol2O00`Ool00g`0Oomoo`1JOol0019oo`03001oogoo07ioo`9l02eoo`03O01oogoo05]o
o`004Woo00<007ooOol0P7oo0g`0:Goo00=l07ooOol0G7oo000BOol00`00Oomoo`23Ool4O00TOol0
0g`0Oomoo`1MOol0019oo`8008Qoo`=l01moo`9l061oo`004Woo00<007ooOol0RWoo0g`06Woo0W`0
HWoo000BOol00`00Oomoo`2=Ool5O00COol2O01TOol0019oo`03001oogoo099oo`Il00Uoo`Al06Io
o`002goo0`0017oo00<007ooOol0V7oo2W`0JGoo000<Ool00`00Oomoo`03Ool00`00Oomoo`3oOol<
Ool000Uoo`D000Aoo`800?moo`eoo`002Goo00@007ooOol000Eoo`03001oogoo0?moo`aoo`002Woo
00<007oo00001Goo00<007ooOol0ogoo37oo000;Ool2003oOolDOol00?moob5oo`00ogoo8Goo003o
OolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol0015oo`@0
0?moo`aoo`0047oo00@007ooOol00?moo`eoo`0047oo00@007ooOol00?moo`eoo`003goo0P0000=o
o`000000ogoo3Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0891134, -8.62008, \
0.00492726, 0.0807045}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.793651 0.365954 0.0274467 [
[.18254 .35345 -9 -9 ]
[.18254 .35345 9 0 ]
[.34127 .35345 -9 -9 ]
[.34127 .35345 9 0 ]
[.5 .35345 -9 -9 ]
[.5 .35345 9 0 ]
[.65873 .35345 -9 -9 ]
[.65873 .35345 9 0 ]
[.81746 .35345 -3 -9 ]
[.81746 .35345 3 0 ]
[.97619 .35345 -9 -9 ]
[.97619 .35345 9 0 ]
[1.025 .36595 0 -6.25 ]
[1.025 .36595 10 6.25 ]
[.01131 .09149 -18 -4.5 ]
[.01131 .09149 0 4.5 ]
[.01131 .22872 -12 -4.5 ]
[.01131 .22872 0 4.5 ]
[.01131 .50319 -6 -4.5 ]
[.01131 .50319 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .36595 m
.18254 .3722 L
s
[(0.2)] .18254 .35345 0 1 Mshowa
.34127 .36595 m
.34127 .3722 L
s
[(0.4)] .34127 .35345 0 1 Mshowa
.5 .36595 m
.5 .3722 L
s
[(0.6)] .5 .35345 0 1 Mshowa
.65873 .36595 m
.65873 .3722 L
s
[(0.8)] .65873 .35345 0 1 Mshowa
.81746 .36595 m
.81746 .3722 L
s
[(1)] .81746 .35345 0 1 Mshowa
.97619 .36595 m
.97619 .3722 L
s
[(1.2)] .97619 .35345 0 1 Mshowa
.125 Mabswid
.06349 .36595 m
.06349 .3697 L
s
.10317 .36595 m
.10317 .3697 L
s
.14286 .36595 m
.14286 .3697 L
s
.22222 .36595 m
.22222 .3697 L
s
.2619 .36595 m
.2619 .3697 L
s
.30159 .36595 m
.30159 .3697 L
s
.38095 .36595 m
.38095 .3697 L
s
.42063 .36595 m
.42063 .3697 L
s
.46032 .36595 m
.46032 .3697 L
s
.53968 .36595 m
.53968 .3697 L
s
.57937 .36595 m
.57937 .3697 L
s
.61905 .36595 m
.61905 .3697 L
s
.69841 .36595 m
.69841 .3697 L
s
.7381 .36595 m
.7381 .3697 L
s
.77778 .36595 m
.77778 .3697 L
s
.85714 .36595 m
.85714 .3697 L
s
.89683 .36595 m
.89683 .3697 L
s
.93651 .36595 m
.93651 .3697 L
s
.25 Mabswid
0 .36595 m
1 .36595 L
s
gsave
1.025 .36595 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .09149 m
.03006 .09149 L
s
[(-10)] .01131 .09149 1 0 Mshowa
.02381 .22872 m
.03006 .22872 L
s
[(-5)] .01131 .22872 1 0 Mshowa
.02381 .50319 m
.03006 .50319 L
s
[(5)] .01131 .50319 1 0 Mshowa
.125 Mabswid
.02381 .11893 m
.02756 .11893 L
s
.02381 .14638 m
.02756 .14638 L
s
.02381 .17383 m
.02756 .17383 L
s
.02381 .20127 m
.02756 .20127 L
s
.02381 .25617 m
.02756 .25617 L
s
.02381 .28361 m
.02756 .28361 L
s
.02381 .31106 m
.02756 .31106 L
s
.02381 .33851 m
.02756 .33851 L
s
.02381 .3934 m
.02756 .3934 L
s
.02381 .42085 m
.02756 .42085 L
s
.02381 .44829 m
.02756 .44829 L
s
.02381 .47574 m
.02756 .47574 L
s
.02381 .06404 m
.02756 .06404 L
s
.02381 .03659 m
.02756 .03659 L
s
.02381 .00915 m
.02756 .00915 L
s
.02381 .53063 m
.02756 .53063 L
s
.02381 .55808 m
.02756 .55808 L
s
.02381 .58553 m
.02756 .58553 L
s
.02381 .61297 m
.02756 .61297 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 1 0 r
.5 Mabswid
.02381 .36595 m
.02605 .36598 L
.02846 .36601 L
.02962 .36602 L
.03072 .36603 L
.03171 .36604 L
.03279 .36613 L
.03746 .3665 L
.03875 .3666 L
.03945 .36666 L
.04012 .36674 L
.04143 .36693 L
.04262 .36711 L
.04521 .36749 L
.04648 .36767 L
.04762 .36784 L
.04885 .3681 L
.05016 .36838 L
.05293 .36898 L
.06244 .37146 L
.07287 .37507 L
.08414 .37994 L
.10458 .3911 L
.14558 .42157 L
.18507 .45827 L
.22304 .49691 L
.24419 .51854 L
.26347 .53764 L
.27304 .54613 L
.28345 .55332 L
.28821 .55584 L
.29083 .55702 L
.29211 .5576 L
.29328 .55812 L
.29429 .55847 L
.29536 .55878 L
.2976 .55942 L
.29989 .56007 L
.3011 .56041 L
.30238 .56064 L
.30301 .56072 L
.30371 .5608 L
.30495 .56095 L
.30738 .56123 L
.30851 .56137 L
.30972 .56148 L
.31087 .56142 L
.31192 .56137 L
.31442 .56125 L
.31574 .56118 L
Mistroke
.31647 .56115 L
.31715 .56112 L
.3178 .56103 L
.3185 .56088 L
.31973 .56062 L
.32212 .5601 L
.32328 .55986 L
.32453 .55959 L
.3257 .55929 L
.32677 .55888 L
.32912 .558 L
.33169 .55703 L
.34048 .55255 L
.34976 .5463 L
.35444 .54391 L
.35573 .54326 L
.3564 .54292 L
.35711 .54256 L
.35841 .5439 L
.35961 .54518 L
.3704 .55643 L
.38038 .56593 L
.40039 .58202 L
.41854 .59349 L
.4234 .59601 L
.42866 .59853 L
.43362 .60022 L
.43583 .60098 L
.43819 .60155 L
.4407 .60206 L
.44305 .60253 L
.44373 .60267 L
.44448 .60282 L
.44518 .60286 L
.44584 .60291 L
.44838 .60307 L
.45086 .60323 L
.45154 .60327 L
.45228 .60332 L
.45297 .60328 L
.4536 .60324 L
.45651 .60302 L
.45778 .60293 L
.45915 .60283 L
.46042 .60272 L
.46159 .60248 L
.46388 .60199 L
.46629 .60149 L
.46894 .60084 L
.47337 .59931 L
Mistroke
.47806 .59743 L
.48874 .59168 L
.49875 .58463 L
.53754 .54662 L
.57878 .49337 L
.61851 .42996 L
.63856 .39354 L
.64729 .3768 L
.65188 .36686 L
.65672 .35294 L
.65794 .34945 L
.65924 .34345 L
.65999 .33802 L
.66067 .33306 L
.66201 .32337 L
.66686 .28806 L
.67641 .21854 L
.69739 .06786 L
Mfstroke
.69739 .06786 m
.70756 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00O5Goo00<007ooOol0
Zgoo00<3h7ooOol0FWoo000EOol00`00Oomoo`2[Ool00`?POomoo`1JOol001Eoo`800:aoo`030n1o
ogoo05Yoo`005Goo00<007ooOol0Zgoo00<3h7ooOol0FWoo000EOol00`00Oomoo`2[Ool00`?POomo
o`1JOol001Eoo`03001oogoo0:Yoo`030n1oogoo05]oo`005Goo00<007ooOol0ZWoo00<3h7ooOol0
Fgoo000EOol00`00Oomoo`2ZOol00`?POomoo`1KOol001Eoo`03001oogoo0:Yoo`030n1oogoo05]o
o`005Goo0P00Zgoo00<3h7ooOol0Fgoo000EOol00`00Oomoo`2ZOol00`?POomoo`1KOol001Eoo`03
001oogoo0:Yoo`030n1oogoo05]oo`005Goo00<007ooOol0ZWoo00<3h7ooOol0Fgoo000EOol00`00
Oomoo`2YOol00`?POomoo`1LOol001Eoo`03001oogoo0:Uoo`030n1oogoo05aoo`005Goo00<007oo
Ool0ZGoo00<3h7ooOol0G7oo000EOol2002ZOol00`?POomoo`1LOol001Eoo`03001oogoo0:Uoo`03
0n1oogoo05aoo`005Goo00<007ooOol0ZGoo00<3h7ooOol0G7oo000EOol00`00Oomoo`2YOol00`?P
Oomoo`1LOol001Eoo`03001oogoo0:Uoo`030n1oogoo05aoo`001goo1@000Woo0P001Goo00<007oo
Ool0Z7oo00<3h7ooOol0GGoo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol0
Z7oo00<3h7ooOol0GGoo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo0P00ZGoo00<3h7oo
Ool0GGoo00000goo000000020004Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol0
Z7oo00<3h7ooOol0GGoo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol0Z7oo
00<3h7ooOol0GGoo0008Ool20004Ool20005Ool00`00Oomoo`2XOol00`?POomoo`1MOol001Eoo`03
001oogoo0:Moo`030n1oogoo05ioo`005Goo00<007ooOol0Ygoo00<3h7ooOol0GWoo000EOol00`00
Oomoo`2WOol00`?POomoo`1NOol001Eoo`800:Qoo`030n1oogoo05ioo`005Goo00<007ooOol0Ygoo
00<3h7ooOol0GWoo000EOol00`00Oomoo`2WOol00`?POomoo`1NOol001Eoo`03001oogoo0:Ioo`03
0n1oogoo05moo`005Goo00<007ooOol0YWoo00<3h7ooOol0Ggoo000EOol00`00Oomoo`2VOol00`?P
Oomoo`1OOol001Eoo`03001oogoo0:Ioo`030n1oogoo05moo`005Goo0P00Ygoo00<3h7ooOol0Ggoo
000EOol00`00Oomoo`2VOol00`?POomoo`1OOol001Eoo`03001oogoo0:Ioo`030n1oogoo05moo`00
5Goo00<007ooOol0YGoo00<3h7ooOol0H7oo000EOol00`00Oomoo`2UOol00`?POomoo`1POol001Eo
o`03001oogoo0:Eoo`030n1oogoo061oo`005Goo00<007ooOol0YGoo00<3h7ooOol0H7oo000EOol2
002VOol00`?POomoo`1POol001Eoo`03001oogoo0:Eoo`030n1oogoo061oo`005Goo00<007ooOol0
Y7oo00<3h7ooOol0HGoo000EOol00`00Oomoo`2TOol00`?POomoo`1QOol001Eoo`03001oogoo0:Ao
o`030n1oogoo065oo`005Goo00<007ooOol0Y7oo00<3h7ooOol0HGoo000EOol00`00Oomoo`2TOol0
0`?POomoo`1QOol001Eoo`800:Eoo`030n1oogoo065oo`005Goo00<007ooOol0Xgoo00<3h7ooOol0
HWoo000EOol00`00Oomoo`2SOol00`?POomoo`1ROol001Eoo`03001oogoo0:=oo`030n1oogoo069o
o`005Goo00<007ooOol0Xgoo00<3h7ooOol0HWoo000>Ool20005Ool00`00Oomoo`2SOol00`?POomo
o`1ROol000eoo`04001oogoo0004Ool00`00Oomoo`2SOol00`?POomoo`1ROol0011oo`03001oogoo
009oo`800:Aoo`030n1oogoo069oo`001goo10000goo0P001Goo00<007ooOol0Xgoo00<3h7ooOol0
HWoo000>Ool00`00Oomoo`04Ool00`00Oomoo`2ROol00`?POomoo`1SOol000ioo`<000Aoo`03001o
ogoo0:9oo`030n1oogoo06=oo`005Goo00<007ooOol0XWoo00<3h7ooOol0Hgoo000EOol00`00Oomo
o`2ROol00`?POomoo`1SOol001Eoo`03001oogoo0:9oo`030n1oogoo06=oo`005Goo0P00Xgoo00<3
h7ooOol0Hgoo000EOol00`00Oomoo`2ROol00`?POomoo`1SOol001Eoo`03001oogoo0:9oo`030n1o
ogoo06=oo`005Goo00<007ooOol0XWoo00<3h7ooOol0Hgoo000EOol00`00Oomoo`2QOol00`?POomo
o`1TOol001Eoo`03001oogoo0:5oo`030n1oogoo06Aoo`005Goo00<007ooOol0XGoo00<3h7ooOol0
I7oo000EOol2002ROol00`?POomoo`1TOol001Eoo`03001oogoo0:5oo`030n1oogoo06Aoo`005Goo
00<007ooOol0XGoo00<3h7ooOol0I7oo000EOol00`00Oomoo`2QOol00`?POomoo`1TOol001Eoo`03
001oogoo0:5oo`030n1oogoo06Aoo`005Goo00<007ooOol0XGoo00<3h7ooOol0I7oo000EOol00`00
Oomoo`2POol00`?POomoo`1UOol001Eoo`800:5oo`030n1oogoo06Eoo`005Goo00<007ooOol0X7oo
00<3h7ooOol0IGoo000EOol00`00Oomoo`2POol00`?POomoo`1UOol001Eoo`03001oogoo01ioo`80
00Aoo`8000=oo`@001Yoo`8000Aoo`8000Eoo`<001Qoo`8000Aoo`8000=oo`<001]oo`8000Aoo`80
00040n1oogooOol2000OOol5000NOol50002Ool20003Ool4000@Ool001Eoo`03001oogoo01eoo`04
001oogoo0008Ool00`00Oomoo`0JOol01000Oomoo`002goo00<007ooOol05Woo00@007ooOol000Qo
o`04001oogoo000IOol01000Oomoo`001Goo00@3h7ooOol0009oo`03001oogoo01ioo`03001oogoo
021oo`03001oogoo00Moo`03001oogoo015oo`005Goo00<007ooOol07Goo00@007ooOol000Uoo`03
001oogoo01Uoo`04001oogoo0008Ool5000GOol01000Oomoo`0027oo00@007ooOol001Uoo`04001o
ogoo0004Ool01@?POomoogoo00000Woo00<007ooOol07Woo00<007ooOol087oo00<007ooOol027oo
00<007ooOol047oo000EOol00`00Oomoo`0MOol01000Oomoo`002Woo00<007ooOol067oo00@007oo
Ool000Qoo`04001oogoo000HOol01000Oomoo`0027oo0`006Woo00@007ooOol000Aoo`030n1oogoo
009oo`80025oo`03001oogoo021oo`03001oogoo00Uoo`03001oogoo00moo`005Goo0P007Woo00@0
07ooOol000Qoo`04001oogoo000IOol01000Oomoo`002Goo00<007oo000067oo00@007ooOol000Uo
o`03001oogoo01Uoo`04001oogoo0004Ool01@?POomoogoo00000Woo00<007ooOol07Woo00<007oo
Ool087oo00<007ooOol01goo00@007ooOol0011oo`005Goo00<007ooOol07Woo0P002Woo0P006goo
0P002goo0P006Goo0P002Woo0`006Woo0P001Goo00<3h7ooOol00Woo0P0087oo0P008Goo0P002Woo
0P004Goo000EOol00`00Oomoo`2OOol00`?POomoo`1VOol001Eoo`03001oogoo09moo`030n1oogoo
06Ioo`005Goo00<007ooOol0WWoo00<3h7ooOol0Igoo000EOol00`00Oomoo`2NOol00`?POomoo`1W
Ool001Eoo`03001oogoo09eoo`030n1oogoo065oo`8000Eoo`003goo1P001P?PVP0000<3h0000000
E`002Goo00@007ooOol000Aoo`005Goo00<007ooOol00Woo10?P00=oo`00Ool027oo00<007ooOol0
1goo00<007ooOol01goo00<007ooOol01goo00<007ooOol027oo00<007ooOol01goo00<007ooOol0
1goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol0
27oo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Goo00<3h7oo00002Goo00<007ooOol0
1goo00<007ooOol01goo00<007ooOol01goo00<007ooOol027oo00<007ooOol01goo00<007ooOol0
1goo00<007ooOol01goo00<007ooOol03Goo00<007ooOol01Goo000EOol00`00Oomoo`06Ool40n0K
Ool00`00Oomoo`0VOol00`00Oomoo`0UOol00`00Oomoo`0SOol010?POomoo`009goo00<007ooOol0
9Woo00<007ooOol037oo1@0017oo000EOol00`00Oomoo`0:Ool20n2@Ool00`?POomoo`1QOol00`00
Oomoo`05Ool001Eoo`03001oogoo00aoo`030n1oogoo08eoo`030n1oogoo06Uoo`005Goo00<007oo
Ool03Goo0P?PS7oo00<3h7ooOol0JWoo000EOol00`00Oomoo`0?Ool20n2:Ool00`?POomoo`1ZOol0
01Eoo`80019oo`030n1oogoo08Ioo`030n1oogoo06]oo`005Goo00<007ooOol04Woo0P?PQGoo00<3
h7ooOol0K7oo000EOol00`00Oomoo`0DOol00`?POomoo`22Ool00`?POomoo`1/Ool001Eoo`03001o
ogoo01Eoo`83h85oo`030n1oogoo06eoo`005Goo00<007ooOol05goo0P?POgoo00<3h7ooOol0KGoo
000EOol00`00Oomoo`0IOol00`?POomoo`1kOol00`?POomoo`1^Ool001Eoo`03001oogoo01Yoo`83
h7]oo`030n1oogoo06ioo`005Goo0P007Goo00<3h7ooOol0Mgoo00<3h7ooOol0Kgoo000EOol00`00
Oomoo`0MOol00`?POomoo`1fOol00`?POomoo`1_Ool001Eoo`03001oogoo01ioo`030n1oogoo07Ao
o`030n1oogoo071oo`005Goo00<007ooOol07goo00<3h7ooOol0LWoo00<3h7ooOol0LGoo000EOol0
0`00Oomoo`0POol00`?POomoo`1aOol00`?POomoo`1aOol001Eoo`03001oogoo025oo`030n1oogoo
06moo`030n1oogoo079oo`005Goo00<007ooOol08Woo00<3h7ooOol0KGoo00<3h7ooOol0Lgoo000E
Ool2000TOol00`?POomoo`1/Ool00`?POomoo`1cOol001Eoo`03001oogoo02Aoo`030n1oogoo06Yo
o`030n1oogoo07Aoo`005Goo00<007ooOol09Goo00<3h7ooOol0J7oo00<3h7ooOol0MGoo000EOol0
0`00Oomoo`0VOol00`?POomoo`1WOol00`?POomoo`1eOol001Eoo`03001oogoo02Moo`030n1oogoo
06Eoo`030n1oogoo07Ioo`005Goo00<007ooOol0:7oo00<3h7ooOol0I7oo00<3h7ooOol0MWoo000E
Ool00`00Oomoo`0YOol00`?POomoo`1ROol00`?POomoo`1gOol001Eoo`8002]oo`030n1oogoo061o
o`030n1oogoo07Qoo`005Goo00<007ooOol0:goo00<3h7ooOol0Ggoo00<3h7ooOol0N7oo000EOol0
0`00Oomoo`0/Ool00`?POomoo`1MOol00`?POomoo`1iOol001Eoo`03001oogoo02eoo`030n1oogoo
05]oo`030n1oogoo07Yoo`005Goo00<007ooOol0;Woo00<3h7ooOol0FWoo00<3h7ooOol0NWoo000>
Ool20005Ool00`00Oomoo`0_Ool00`?POomoo`1HOol00`?POomoo`1kOol000eoo`04001oogoo0004
Ool00`00Oomoo`0`Ool00`?POomoo`1FOol00`?POomoo`1lOol0011oo`03001oogoo009oo`80039o
o`030n1oogoo05Aoo`030n1oogoo07eoo`003Woo0P001Goo00<007ooOol0<Woo00<3h7ooOol0Dgoo
00<3h7ooOol0OGoo000>Ool00`00Oomoo`04Ool00`00Oomoo`0cOol00`?POomoo`1AOol00`?POomo
o`1nOol000ioo`<000Aoo`03001oogoo03Aoo`030n1oogoo04moo`030n1oogoo07moo`005Goo00<0
07ooOol0=Goo00<3h7ooOol0CGoo00<3h7ooOol0P7oo000EOol00`00Oomoo`0fOol00`?POomoo`1<
Ool00`?POomoo`20Ool001Eoo`03001oogoo03Moo`030n1oogoo04Yoo`030n1oogoo085oo`005Goo
0P00>Goo00<3h7ooOol0B7oo00<3h7ooOol0PWoo000EOol00`00Oomoo`0iOol00`?POomoo`16Ool0
0`?POomoo`23Ool001Eoo`03001oogoo03Yoo`030n1oogoo04Eoo`030n1oogoo08=oo`005Goo00<0
07ooOol0>goo00<3h7ooOol057oo00<3h7ooOol0;7oo00<3h7ooOol0Q7oo000EOol00`00Oomoo`0l
Ool00`?POomoo`0AOol30n0]Ool00`?POomoo`25Ool001Eoo`03001oogoo03eoo`83h11oo`050n1o
ogooOol3h00[Ool00`?POomoo`26Ool001Eoo`03001oogoo03moo`030n1oogoo00]oo`83h0Eoo`03
0n1oogoo02Moo`030n1oogoo08Moo`005Goo0P00@Goo0`?P1goo0`?P27oo00<3h7ooOol09Goo00<3
h7ooOol0R7oo000EOol00`00Oomoo`13Ool80n0;Ool20n0TOol00`?POomoo`29Ool001Eoo`03001o
ogoo05Qoo`030n1oogoo021oo`030n1oogoo08Yoo`005Goo00<007ooOol0FGoo00<3h7ooOol07Woo
00<3h7ooOol0Rgoo000EOol00`00Oomoo`1JOol20n0MOol00`?POomoo`2<Ool001Eoo`03001oogoo
05aoo`030n1oogoo01Uoo`030n1oogoo08eoo`005Goo00<007ooOol0GGoo00<3h7ooOol05goo00<3
h7ooOol0SWoo000EOol2001OOol20n0FOol00`?POomoo`2?Ool001Eoo`03001oogoo061oo`83h19o
o`83h99oo`005Goo00<007ooOol0HWoo00<3h7ooOol03Goo0P?PU7oo000EOol00`00Oomoo`1SOol0
0`?POomoo`0;Ool00`?POomoo`2DOol001Eoo`03001oogoo06Aoo`@3h0Eoo`@3h9Moo`005Goo00<0
07ooOol0J7oo1P?PVWoo000EOol00`00Oomoo`3oOol9Ool001Eoo`800?moo`Yoo`005Goo00<007oo
Ool0ogoo2Goo000EOol00`00Oomoo`3oOol9Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`0057oo0P00ogoo
2goo000DOol2003oOol;Ool001=oo`04001oogoo003oOol:Ool0019oo`80009oo`800?moo`Uoo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.104523, -13.3435, \
0.00493151, 0.1426}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.793651 0.527542 0.00243314 [
[.18254 .51504 -9 -9 ]
[.18254 .51504 9 0 ]
[.34127 .51504 -9 -9 ]
[.34127 .51504 9 0 ]
[.5 .51504 -9 -9 ]
[.5 .51504 9 0 ]
[.65873 .51504 -9 -9 ]
[.65873 .51504 9 0 ]
[.81746 .51504 -3 -9 ]
[.81746 .51504 3 0 ]
[.97619 .51504 -9 -9 ]
[.97619 .51504 9 0 ]
[1.025 .52754 0 -6.25 ]
[1.025 .52754 10 6.25 ]
[.01131 .04091 -24 -4.5 ]
[.01131 .04091 0 4.5 ]
[.01131 .16257 -24 -4.5 ]
[.01131 .16257 0 4.5 ]
[.01131 .28423 -24 -4.5 ]
[.01131 .28423 0 4.5 ]
[.01131 .40589 -18 -4.5 ]
[.01131 .40589 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .52754 m
.18254 .53379 L
s
[(0.2)] .18254 .51504 0 1 Mshowa
.34127 .52754 m
.34127 .53379 L
s
[(0.4)] .34127 .51504 0 1 Mshowa
.5 .52754 m
.5 .53379 L
s
[(0.6)] .5 .51504 0 1 Mshowa
.65873 .52754 m
.65873 .53379 L
s
[(0.8)] .65873 .51504 0 1 Mshowa
.81746 .52754 m
.81746 .53379 L
s
[(1)] .81746 .51504 0 1 Mshowa
.97619 .52754 m
.97619 .53379 L
s
[(1.2)] .97619 .51504 0 1 Mshowa
.125 Mabswid
.06349 .52754 m
.06349 .53129 L
s
.10317 .52754 m
.10317 .53129 L
s
.14286 .52754 m
.14286 .53129 L
s
.22222 .52754 m
.22222 .53129 L
s
.2619 .52754 m
.2619 .53129 L
s
.30159 .52754 m
.30159 .53129 L
s
.38095 .52754 m
.38095 .53129 L
s
.42063 .52754 m
.42063 .53129 L
s
.46032 .52754 m
.46032 .53129 L
s
.53968 .52754 m
.53968 .53129 L
s
.57937 .52754 m
.57937 .53129 L
s
.61905 .52754 m
.61905 .53129 L
s
.69841 .52754 m
.69841 .53129 L
s
.7381 .52754 m
.7381 .53129 L
s
.77778 .52754 m
.77778 .53129 L
s
.85714 .52754 m
.85714 .53129 L
s
.89683 .52754 m
.89683 .53129 L
s
.93651 .52754 m
.93651 .53129 L
s
.25 Mabswid
0 .52754 m
1 .52754 L
s
gsave
1.025 .52754 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .04091 m
.03006 .04091 L
s
[(-200)] .01131 .04091 1 0 Mshowa
.02381 .16257 m
.03006 .16257 L
s
[(-150)] .01131 .16257 1 0 Mshowa
.02381 .28423 m
.03006 .28423 L
s
[(-100)] .01131 .28423 1 0 Mshowa
.02381 .40589 m
.03006 .40589 L
s
[(-50)] .01131 .40589 1 0 Mshowa
.125 Mabswid
.02381 .06525 m
.02756 .06525 L
s
.02381 .08958 m
.02756 .08958 L
s
.02381 .11391 m
.02756 .11391 L
s
.02381 .13824 m
.02756 .13824 L
s
.02381 .1869 m
.02756 .1869 L
s
.02381 .21123 m
.02756 .21123 L
s
.02381 .23557 m
.02756 .23557 L
s
.02381 .2599 m
.02756 .2599 L
s
.02381 .30856 m
.02756 .30856 L
s
.02381 .33289 m
.02756 .33289 L
s
.02381 .35722 m
.02756 .35722 L
s
.02381 .38155 m
.02756 .38155 L
s
.02381 .43022 m
.02756 .43022 L
s
.02381 .45455 m
.02756 .45455 L
s
.02381 .47888 m
.02756 .47888 L
s
.02381 .50321 m
.02756 .50321 L
s
.02381 .01658 m
.02756 .01658 L
s
.02381 .55187 m
.02756 .55187 L
s
.02381 .5762 m
.02756 .5762 L
s
.02381 .60054 m
.02756 .60054 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a) show
69.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.5 Mabswid
.02381 .52754 m
.06244 .55039 L
.10458 .57229 L
.12507 .5811 L
.14415 .58796 L
.16254 .59318 L
.17277 .59549 L
.18221 .59721 L
.19242 .59859 L
.19781 .59916 L
.20052 .59936 L
.20351 .59957 L
.20474 .59965 L
.20539 .5997 L
.20608 .59974 L
.20735 .59979 L
.20852 .59983 L
.21134 .59992 L
.21268 .59997 L
.21391 .60001 L
.21518 .60001 L
.21584 .60001 L
.21654 .60001 L
.21902 .6 L
.22009 .59999 L
.22123 .59999 L
.22248 .59997 L
.22365 .59993 L
.22859 .59973 L
.22979 .59968 L
.23108 .5996 L
.2325 .59949 L
.23383 .59939 L
.23958 .5989 L
.24489 .59831 L
.25001 .5976 L
.25539 .59677 L
.25761 .59637 L
.25999 .59594 L
.26069 .59581 L
.26135 .59569 L
.26259 .59462 L
.26375 .59297 L
.26501 .59118 L
.30593 .53137 L
.32629 .50157 L
.33624 .48734 L
.34096 .48068 L
.34534 .47462 L
.34751 .47162 L
Mistroke
.34872 .46995 L
.34982 .47967 L
.35103 .5002 L
.35234 .52237 L
.35471 .56255 L
.35587 .58234 L
.35696 .6008 L
.3581 .60332 L
.35934 .6026 L
.3636 .60015 L
.38322 .58729 L
.4019 .57511 L
.41174 .56876 L
.41713 .56531 L
.41842 .56448 L
.41977 .56362 L
.42092 .56271 L
.42218 .56114 L
.42472 .558 L
.42745 .55462 L
.43325 .54744 L
.44346 .53487 L
.4636 .5104 L
.48489 .48494 L
.49495 .47307 L
.49708 .47057 L
.49936 .46789 L
.50067 .46676 L
.50187 .46609 L
.50421 .46477 L
.50891 .46213 L
.51387 .45937 L
.52433 .45358 L
.54331 .44321 L
.58312 .42195 L
.62142 .40213 L
.6316 .39696 L
.64117 .39214 L
.64597 .38973 L
.64728 .38908 L
.64867 .38838 L
.64985 .38779 L
.65115 .37084 L
.65189 .33614 L
.65259 .30335 L
.6539 .24197 L
.65685 .10417 L
.65809 .04635 L
.6594 .01635 L
.66009 .01618 L
Mistroke
.66084 .01599 L
.66217 .01567 L
.66466 .01506 L
.66534 .01489 L
.66606 .01472 L
.66737 .01474 L
.66801 .01489 L
.66871 .01505 L
.66996 .01535 L
.67231 .01591 L
.67353 .0162 L
.67467 .01648 L
.67585 .01707 L
.67715 .01771 L
.68159 .0199 L
.68687 .02358 L
.69167 .02744 L
.70248 .03911 L
.72158 .06788 L
.74234 .11097 L
.78314 .22505 L
.7879 .24045 L
.79049 .24904 L
.79175 .25322 L
.7929 .25702 L
.79417 .26504 L
.79486 .27251 L
.79552 .27956 L
.79838 .3103 L
.79956 .32288 L
.8008 .33619 L
.80145 .34314 L
.80216 .34443 L
.80341 .34393 L
.80815 .34201 L
.81324 .33975 L
.81442 .33921 L
.8157 .33862 L
.81692 .33806 L
.81804 .33789 L
.81916 .33806 L
.82017 .33821 L
.82243 .33854 L
.8602 .34413 L
.90034 .3499 L
.93896 .35528 L
.97619 .36031 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool001]oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3
Ool001]oo`03001oogoo09aoo`<07f=oo`006goo0P00W7oo0P0O00Aoo`0O01l07f5oo`006goo00<0
07ooOol0Vgoo00<07gooOol00goo0P0OGgoo000KOol00`00Oomoo`2KOol00`0OOomoo`05Ool00`0O
Oomoo`1LOol001]oo`03001oogoo09]oo`0301moogoo00Ioo`0301moogoo05]oo`001goo10000goo
0P0017oo0P001Goo00<007ooOol0Vgoo00<07gooOol01goo00<07gooOol0FWoo0007Ool00`00Oomo
o`03Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo09]oo`0301moogoo00Qoo`0301mo
ogoo05Uoo`0027oo00<007ooOol00Woo00@007ooOol0009oo`04001oogoo0004Ool2002LOol00`0O
Oomoo`09Ool00`0OOomoo`1HOol00003Ool00000008000Aoo`05001oogooOol00002Ool01000Oomo
o`000Woo00<007ooOol00Woo00<007ooOol0Vgoo00<07gooOol02Goo00<07gooOol0F7oo0007Ool0
1000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`2KOol00`0OOomoo`0:
Ool00`0OOomoo`1GOol000Qoo`8000Aoo`8000Aoo`8000Eoo`03001oogoo09]oo`0301moogoo00]o
o`0301moogoo05Ioo`006goo00<007ooOol0Vgoo00<07gooOol037oo00<07gooOol0EGoo000KOol0
0`00Oomoo`2KOol00`0OOomoo`0<Ool00`0OOomoo`1EOol001]oo`8009aoo`0301moogoo00eoo`03
01moogoo05Aoo`006goo00<007ooOol0Vgoo00<07gooOol03Goo00<07gooOol0E7oo000KOol00`00
Oomoo`2KOol00`0OOomoo`0>Ool00`0OOomoo`1COol001]oo`03001oogoo09]oo`0301moogoo00io
o`0301moogoo05=oo`006goo00<007ooOol0Vgoo00<07gooOol03goo00<07gooOol0DWoo000KOol0
0`00Oomoo`2KOol00`0OOomoo`0?Ool00`0OOomoo`1BOol001]oo`8009aoo`0301moogoo011oo`03
01moogoo055oo`006goo00<007ooOol0Vgoo00<07gooOol047oo00<07gooOol0DGoo000KOol00`00
Oomoo`2KOol00`0OOomoo`0AOol00`0OOomoo`1@Ool001]oo`03001oogoo09]oo`0301moogoo015o
o`0301moogoo051oo`006goo00<007ooOol0Vgoo00<07gooOol04Woo00<07gooOol0Cgoo000KOol0
0`00Oomoo`2KOol00`0OOomoo`0BOol00`0OOomoo`1?Ool001]oo`8009aoo`0301moogoo019oo`03
01moogoo04moo`006goo00<007ooOol0Vgoo00<07gooOol04goo00<07gooOol0CWoo000KOol00`00
Oomoo`2KOol00`0OOomoo`0COol00`0OOomoo`1>Ool001]oo`03001oogoo09]oo`0301moogoo01=o
o`0301moogoo04ioo`006goo00<007ooOol0Vgoo00<07gooOol057oo00<07gooOol0CGoo000KOol0
0`00Oomoo`2KOol00`0OOomoo`0DOol00`0OOomoo`1=Ool001]oo`8009aoo`0301moogoo01Aoo`03
01moogoo04eoo`006goo00<007ooOol0Vgoo00<07gooOol05Goo00<07gooOol0C7oo000KOol00`00
Oomoo`2KOol00`0OOomoo`0EOol00`0OOomoo`1<Ool001]oo`03001oogoo09]oo`0301moogoo01Eo
o`0301moogoo04aoo`001goo1@000Woo0P0017oo0P001Goo00<007ooOol0Vgoo00<07gooOol05Woo
00<07gooOol0Bgoo0009Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo009oo`03
001oogoo09]oo`0301moogoo01Ioo`0301moogoo04]oo`002Goo00<007ooOol017oo00@007ooOol0
009oo`03001oogoo009oo`8009aoo`0301moogoo01Ioo`0301moogoo04]oo`0000=oo`0000000P00
17oo00<007ooOol00Woo0P000goo00@007ooOol000Aoo`03001oogoo09]oo`0301moogoo01Moo`03
01moogoo04Yoo`002Goo00<007ooOol00Woo00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo
09]oo`0301moogoo01Moo`0301moogoo04Yoo`0027oo0P0017oo0`000goo0P001Goo00<007ooOol0
Vgoo00<07gooOol067oo00<07gooOol0BGoo000KOol00`00Oomoo`2JOol00`0OOomoo`0IOol00`0O
Oomoo`19Ool001]oo`03001oogoo09Yoo`0301moogoo01Uoo`0301moogoo04Uoo`006goo0P00Vgoo
00<07gooOol06Woo00<07gooOol0B7oo000KOol00`00Oomoo`2JOol00`0OOomoo`0JOol00`0OOomo
o`18Ool001]oo`03001oogoo09Yoo`0301moogoo01Yoo`0301moogoo04Qoo`006goo00<007ooOol0
VWoo00<07gooOol06goo00<07gooOol0Agoo000KOol00`00Oomoo`2JOol00`0OOomoo`0KOol00`0O
Oomoo`17Ool001]oo`03001oogoo09Yoo`0301moogoo01]oo`0301moogoo04Moo`006goo0P00Vgoo
00<07gooOol077oo00<07gooOol0AWoo000KOol00`00Oomoo`2JOol00`0OOomoo`0LOol00`0OOomo
o`16Ool001]oo`03001oogoo09Yoo`0301moogoo01aoo`0301moogoo04Ioo`006goo00<007ooOol0
VWoo00<07gooOol07Goo00<07gooOol0AGoo000KOol00`00Oomoo`2JOol00`0OOomoo`0MOol00`0O
Oomoo`15Ool001]oo`03001oogoo09Yoo`0301moogoo01eoo`0301moogoo04Eoo`006goo0P00Vgoo
00<07gooOol07Woo00<07gooOol0A7oo000KOol00`00Oomoo`2JOol00`0OOomoo`0NOol00`0OOomo
o`14Ool001]oo`03001oogoo09Yoo`0301moogoo01ioo`0301moogoo04Aoo`006goo00<007ooOol0
VWoo00<07gooOol07goo00<07gooOol0@goo000KOol00`00Oomoo`2JOol00`0OOomoo`0OOol00`0O
Oomoo`13Ool001]oo`03001oogoo09Yoo`0301moogoo01moo`0301moogoo04=oo`006goo0P00Vgoo
00<07gooOol087oo00<07gooOol0@Woo000KOol00`00Oomoo`2JOol00`0OOomoo`0POol00`0OOomo
o`12Ool001]oo`03001oogoo09Yoo`0301moogoo021oo`0301moogoo049oo`006goo00<007ooOol0
VWoo00<07gooOol087oo00<07gooOol0@Woo0007Ool50002Ool20004Ool20005Ool00`00Oomoo`2J
Ool00`0OOomoo`0POol00`0OOomoo`12Ool000Uoo`05001oogooOol00002Ool01000Oomoo`000Woo
00<007ooOol00Woo00<007ooOol0VWoo00<07gooOol087oo00<07gooOol0@Woo0009Ool01@00Oomo
ogoo00000Woo00@007ooOol0009oo`03001oogoo009oo`8009]oo`0301moogoo021oo`0301moogoo
049oo`0000=oo`0000000P0017oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`02
Ool00`00Oomoo`2JOol00`0OOomoo`0POol00`0OOomoo`12Ool000Uoo`05001oogooOol00002Ool0
1000Oomoo`000Woo00<007ooOol00Woo00<007ooOol0VWoo00<07gooOol087oo00<07gooOol0@Woo
0008Ool20004Ool20004Ool20005Ool00`00Oomoo`2JOol00`0OOomoo`0QOol00`0OOomoo`11Ool0
01]oo`03001oogoo09Yoo`0301moogoo025oo`0301moogoo045oo`006goo00<007ooOol0VWoo00<0
7gooOol08Goo00<07gooOol0@Goo000KOol00`00Oomoo`2JOol00`0OOomoo`0QOol00`0OOomoo`11
Ool001]oo`8009]oo`0301moogoo025oo`0301moogoo045oo`006goo00<007ooOol0VWoo00<07goo
Ool08Goo00<07gooOol0@Goo000KOol00`00Oomoo`2JOol00`0OOomoo`0QOol00`0OOomoo`11Ool0
01]oo`03001oogoo09Uoo`0301moogoo029oo`0301moogoo045oo`006goo00<007ooOol0VGoo00<0
7gooOol08Woo00<07gooOol0@Goo000KOol00`00Oomoo`2IOol00`0OOomoo`0SOol00`0OOomoo`10
Ool001]oo`8009Yoo`0301moogoo02=oo`0301moogoo041oo`006goo00<007ooOol0VGoo00<07goo
Ool08goo00<07goo01l01`0O>Goo000KOol00`00Oomoo`2IOol00`0OOomoo`0SOol201l8Ool701lb
Ool001]oo`03001oogoo09Uoo`0301moogoo03Aoo`D07beoo`006goo00<007ooOol0VGoo00<07goo
Ool0>Goo200O9Goo000KOol00`00Oomoo`2IOol00`0OOomoo`11Ool901lLOol001]oo`8009Yoo`03
01moogoo04Yoo`D07aMoo`006goo00<007ooOol0VGoo00<07gooOol0IWoo000KOol00`00Oomoo`2I
Ool00`0OOomoo`1VOol001]oo`03001oogoo09Uoo`0301moogoo06Ioo`006goo00<007ooOol0VGoo
00<07gooOol0IWoo000KOol00`00Oomoo`2IOol00`0OOomoo`1VOol001]oo`8009Yoo`0301moogoo
06Ioo`006goo00<007ooOol0VGoo00<07gooOol0IWoo000KOol00`00Oomoo`2GOol201mYOol001]o
o`03001oogoo09Eoo`807f]oo`003Woo0P0017oo0P001Goo00<007ooOol0Tgoo0P0OKGoo000=Ool0
1000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo095oo`807fmoo`0047oo00@007ooOol0009o
o`03001oogoo009oo`80091oo`807g5oo`001goo10000goo0P000goo00@007ooOol000Aoo`03001o
ogoo08eoo`807g=oo`003Woo00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo08]oo`807gEo
o`003Woo0`000goo0P001Goo00<007ooOol0RGoo0P0OMgoo000KOol00`00Oomoo`27Ool201miOol0
01]oo`03001oogoo08Eoo`807g]oo`006goo0P00Q7oo0P0OOGoo000KOol00`00Oomoo`21Ool201mo
Ool001]oo`03001oogoo07moo`807h5oo`006goo00<007ooOol0OWoo00<07gooOol0PGoo000KOol0
0`00Oomoo`1mOol00`0OOomoo`22Ool001]oo`03001oogoo07]oo`807hEoo`006goo0P00NWoo0P0O
Qgoo000KOol00`00Oomoo`1gOol201n9Ool001]oo`03001oogoo07Ioo`0301moogoo08Uoo`006goo
00<007ooOol0Lgoo0`0OS7oo000KOol00`00Oomoo`1=Ool201lTOol00`0OOomoo`2<Ool001]oo`03
001oogoo04eoo`807b=oo`0301moogoo08eoo`006goo0P00CWoo0P0O8Woo00<07gooOol0SWoo000K
Ool00`00Oomoo`0MOol20004Ool20003Ool4000IOol20004Ool0100001moo`0O0goo0`005goo0P00
0goo00<07`0000000goo0`006Woo0P0017oo0P0017oo0P007goo1@0077oo1@000Woo0P000goo1000
47oo000KOol00`00Oomoo`0LOol01000Oomoo`0027oo00<007ooOol06Goo00@007ooOol000=oo`04
01moogoo01l4Ool00`00Oomoo`0EOol01P00Oomoo`00Ool07`Ioo`04001oogoo000HOol01000Oomo
o`0027oo00@007ooOol0021oo`03001oogoo01ioo`03001oogoo00Moo`03001oogoo015oo`006goo
00<007ooOol077oo00@007ooOol000Uoo`03001oogoo01Qoo`04001oogoo0002Ool01P0OOomoogoo
01moo`D001Ioo`05001oogoo00007`07Ool01000Oomoo`0067oo00@007ooOol000Qoo`04001oogoo
000POol00`00Oomoo`0NOol00`00Oomoo`08Ool00`00Oomoo`0@Ool001]oo`03001oogoo01aoo`04
001oogoo000:Ool00`00Oomoo`0GOol01000Oomoo`000Woo00L07gooOomoo`0OOol00002Ool00`00
Oomoo`0EOol01000Oomoo`0O27oo0`006Goo00@007ooOol000Uoo`80025oo`03001oogoo01ioo`03
001oogoo00Uoo`03001oogoo00moo`006goo00<007ooOol077oo00@007ooOol000Qoo`04001oogoo
000HOol01P00Oomoo`00Ool07`Aoo`0601moogoo001oo`005goo00@007oo01l000Uoo`03001oogoo
01Qoo`04001oogoo0008Ool01000Oomoo`0087oo00<007ooOol07Woo00<007ooOol01goo00@007oo
Ool0011oo`006goo0P007Woo0P002Woo0P006Woo0P0000=oo`0OOol017oo00@07gooOomoo`8001Qo
o`0301l007oo00Uoo`<001Uoo`8000Yoo`80021oo`8001moo`8000Yoo`80015oo`006goo00<007oo
Ool0Agoo00<07gooOol017oo00<07gooOol06Woo00<07gooOol0U7oo000KOol00`00Oomoo`17Ool0
0`0OOomoo`04Ool00`0OOomoo`0IOol00`0OOomoo`2EOol001]oo`03001oogoo04Ioo`0301moogoo
00Ioo`0301moogoo01Moo`0301moogoo09Ioo`006goo00<007ooOol0AGoo00<07gooOol01goo00<0
7gooOol05Woo00<07gooOol0Ugoo000KOol00`00Oomoo`14Ool00`0OOomoo`08Ool00`0OOomoo`0F
Ool00`0OOomoo`2@Ool20005Ool001Eoo`H0000301l0000004@0000301l0000000P0000301l00000
01D0000301l0000008L000Uoo`04001oogoo0004Ool001]oo`0300007`0O00Moo`03001oogoo00Io
o`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Mo
o`0300007goo00Moo`04001oogoo01l6Ool00`00Oomoo`07Ool00`00Oomoo`03Ool01@0OOomoogoo
000027oo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007oo
Ool01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007oo
Ool01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol03Goo00<007ooOol01Goo000KOol0
1000Oomoo`0O8goo00<007ooOol06goo00<07gooOol01goo00@007ooOol07aEoo`0301moogoo00]o
o`03001oogoo02Eoo`03001oogoo02Eoo`03001oogoo02Aoo`03001oogoo00aoo`D000Aoo`006goo
00@007ooOomoo`807cmoo`0301moogoo00Yoo`0301moogoo019oo`0301moogoo09=oo`03001oogoo
00Eoo`006goo00<007ooOol00goo00<07gooOol0>goo00<07gooOol02goo00<07gooOol04Woo00<0
7gooOol0Vgoo000KOol00`00Oomoo`04Ool201ljOol00`0OOomoo`0<Ool00`0OOomoo`0AOol00`0O
Oomoo`2LOol001]oo`8000Moo`807cQoo`0301moogoo00aoo`0301moogoo011oo`0301moogoo09eo
o`006goo00<007ooOol027oo0P0O=Goo00<07gooOol03Goo00<07gooOol03goo00<07gooOol0WWoo
000KOol00`00Oomoo`0:Ool201lbOol00`0OOomoo`0>Ool00`0OOomoo`0?Ool00`0OOomoo`2NOol0
01]oo`03001oogoo00aoo`807c1oo`0301moogoo00ioo`0301moogoo00eoo`807j5oo`006goo00<0
07ooOol03Woo0P0O;Goo00<07gooOol03goo00<07gooOol02goo0`0OXWoo000KOol00`00Oomoo`0@
Ool201lZOol00`0OOomoo`0@Ool00`0OOomoo`0:Ool00`0OOomoo`2SOol001]oo`8001=oo`807bQo
o`0301moogoo011oo`0301moogoo00Uoo`0301moogoo0:Aoo`006goo00<007ooOol057oo0P0O9Goo
00<07gooOol04Goo00<07gooOol01goo0P0OYgoo000KOol00`00Oomoo`0FOol301lQOol00`0OOomo
o`0BOol00`0OOomoo`05Ool201nYOol001]oo`03001oogoo01Uoo`@07aeoo`0301moogoo019oo`03
01moogoo00Aoo`0301moogoo0:Uoo`006goo00<007ooOol07Goo0P0O6Woo00<07gooOol057oo00@0
7gooOomoo`807jaoo`006goo00<007ooOol07goo1@0O4Woo100O5Woo00@07goo01l07jioo`006goo
0P009Goo4P0O6Woo0P0O/7oo000KOol00`00Oomoo`1@Ool00`0OOomoo`2_Ool001]oo`03001oogoo
0?moo`=oo`006goo00<007ooOol0ogoo0goo000KOol00`00Oomoo`3oOol3Ool001]oo`03001oogoo
0?moo`=oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo
8Goo003oOolQOol00?moob5oo`00ogoo8Goo000IOol5003oOol3Ool001Uoo`@00?moo`Aoo`0077oo
00<007ooOol0ogoo0Woo000JOol3003oOol4Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.136919, -220.067, \
0.00504847, 1.64673}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.793651 0.309017 0.0196201 [
[.18254 .29652 -9 -9 ]
[.18254 .29652 9 0 ]
[.34127 .29652 -9 -9 ]
[.34127 .29652 9 0 ]
[.5 .29652 -9 -9 ]
[.5 .29652 9 0 ]
[.65873 .29652 -9 -9 ]
[.65873 .29652 9 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -9 -9 ]
[.97619 .29652 9 0 ]
[1.025 .30902 0 -6.25 ]
[1.025 .30902 10 6.25 ]
[.01131 .01472 -18 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .11282 -18 -4.5 ]
[.01131 .11282 0 4.5 ]
[.01131 .21092 -12 -4.5 ]
[.01131 .21092 0 4.5 ]
[.01131 .40712 -6 -4.5 ]
[.01131 .40712 0 4.5 ]
[.01131 .50522 -12 -4.5 ]
[.01131 .50522 0 4.5 ]
[.01131 .60332 -12 -4.5 ]
[.01131 .60332 0 4.5 ]
[.02381 .64303 -8 0 ]
[.02381 .64303 8 12.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18254 .30902 m
.18254 .31527 L
s
[(0.2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(0.4)] .34127 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(0.6)] .5 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(0.8)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(1)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1.2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.06349 .30902 m
.06349 .31277 L
s
.10317 .30902 m
.10317 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.22222 .30902 m
.22222 .31277 L
s
.2619 .30902 m
.2619 .31277 L
s
.30159 .30902 m
.30159 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.42063 .30902 m
.42063 .31277 L
s
.46032 .30902 m
.46032 .31277 L
s
.53968 .30902 m
.53968 .31277 L
s
.57937 .30902 m
.57937 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.69841 .30902 m
.69841 .31277 L
s
.7381 .30902 m
.7381 .31277 L
s
.77778 .30902 m
.77778 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.89683 .30902 m
.89683 .31277 L
s
.93651 .30902 m
.93651 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -10.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
1.000 setlinewidth
grestore
.02381 .01472 m
.03006 .01472 L
s
[(-15)] .01131 .01472 1 0 Mshowa
.02381 .11282 m
.03006 .11282 L
s
[(-10)] .01131 .11282 1 0 Mshowa
.02381 .21092 m
.03006 .21092 L
s
[(-5)] .01131 .21092 1 0 Mshowa
.02381 .40712 m
.03006 .40712 L
s
[(5)] .01131 .40712 1 0 Mshowa
.02381 .50522 m
.03006 .50522 L
s
[(10)] .01131 .50522 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(15)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .03434 m
.02756 .03434 L
s
.02381 .05396 m
.02756 .05396 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .0932 m
.02756 .0932 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .15206 m
.02756 .15206 L
s
.02381 .17168 m
.02756 .17168 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .23054 m
.02756 .23054 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .26978 m
.02756 .26978 L
s
.02381 .2894 m
.02756 .2894 L
s
.02381 .32864 m
.02756 .32864 L
s
.02381 .34826 m
.02756 .34826 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .3875 m
.02756 .3875 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .44636 m
.02756 .44636 L
s
.02381 .46598 m
.02756 .46598 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .52484 m
.02756 .52484 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .56408 m
.02756 .56408 L
s
.02381 .5837 m
.02756 .5837 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5 translate 1 -1 scale
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(fs) show
75.000 12.750 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.02846 .30903 L
.02952 .30903 L
.03068 .30903 L
.03178 .30904 L
.03279 .30904 L
.03527 .30906 L
.03754 .30907 L
.03881 .30908 L
.04 .30909 L
.04125 .3091 L
.04262 .30912 L
.04517 .30916 L
.04644 .30917 L
.04761 .30919 L
.04866 .30922 L
.04979 .30925 L
.05217 .30931 L
.05756 .30949 L
.06244 .30971 L
.06787 .31004 L
.07287 .31041 L
.07835 .31092 L
.08414 .31161 L
.09388 .31306 L
.10458 .3152 L
.11478 .31785 L
.12409 .3208 L
.145 .3296 L
.16409 .34054 L
.18485 .35589 L
.22563 .39732 L
.2649 .45159 L
.30265 .51471 L
.32362 .55143 L
.33281 .5673 L
.34285 .58424 L
.34757 .59202 L
.35261 .59841 L
.35506 .60106 L
.35626 .60237 L
.35737 .60332 L
.35838 .60332 L
.35945 .60332 L
.3617 .60332 L
.38154 .60332 L
.41943 .60332 L
.45977 .60332 L
.49859 .60332 L
.53987 .60332 L
Mistroke
.57963 .60332 L
.61787 .60332 L
.63758 .60332 L
.64326 .60332 L
.64604 .60332 L
.64726 .60332 L
.6486 .60332 L
.6498 .60332 L
.65093 .60329 L
.65212 .60302 L
.65339 .60274 L
.65585 .60219 L
.65726 .60187 L
.65857 .60158 L
.65981 .60108 L
.66114 .60051 L
.66387 .59934 L
.66512 .5988 L
.66643 .59824 L
.66755 .5973 L
.66877 .59614 L
.67153 .59352 L
.67413 .59106 L
.67557 .58919 L
.67713 .5869 L
.67985 .58291 L
.69029 .5636 L
.69998 .53874 L
.7199 .46967 L
.74095 .37106 L
.77889 .13484 L
.78368 .10025 L
.7889 .06162 L
.79128 .04365 L
.79259 .0338 L
.79382 .02559 L
.79486 .02413 L
.79599 .02255 L
.79838 .0192 L
.79982 .01719 L
.80052 .01621 L
.80116 .01532 L
.80183 .01472 L
.80255 .01472 L
.80408 .01472 L
.80931 .01472 L
.81929 .01472 L
.85924 .01472 L
.89767 .01472 L
.93856 .01472 L
Mistroke
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00O5Goo00<007ooOol0
ogoo2Goo000EOol00`00Oomoo`3oOol9Ool000Moo`D0009oo`8000Eoo`03001oogoo0?moo`Uoo`00
2Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo0?moo`Uoo`002Goo00<007ooOol0
17oo00<007ooOol00Woo0`00`goo;P005goo00000goo000000020004Ool00`00Oomoo`02Ool20005
Ool00`00Oomoo`32Ool20014Ool000Uoo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo0<5o
o`8004Eoo`0027oo0P0017oo0`0017oo00<007ooOol0`Goo00<007ooOol0A7oo000EOol00`00Oomo
o`31Ool00`00Oomoo`14Ool001Eoo`800<9oo`03001oogoo04Aoo`005Goo00<007ooOol0`Goo00<0
07ooOol0A7oo000EOol00`00Oomoo`31Ool00`00Oomoo`14Ool001Eoo`03001oogoo0<5oo`03001o
ogoo04Aoo`005Goo00<007ooOol0`Goo00<007ooOol0A7oo000EOol20031Ool00`00Oomoo`15Ool0
01Eoo`03001oogoo0<1oo`03001oogoo04Eoo`005Goo00<007ooOol0`7oo00<007ooOol0AGoo000E
Ool00`00Oomoo`30Ool00`00Oomoo`15Ool001Eoo`03001oogoo0<1oo`03001oogoo04Eoo`005Goo
0P00`Goo00<007ooOol0AGoo000EOol00`00Oomoo`30Ool00`00Oomoo`15Ool001Eoo`03001oogoo
0<1oo`03001oogoo04Eoo`005Goo00<007ooOol0_goo00<007ooOol0AWoo000EOol00`00Oomoo`2o
Ool00`00Oomoo`16Ool001Eoo`800<1oo`03001oogoo04Ioo`005Goo00<007ooOol0_goo00<007oo
Ool0AWoo000EOol00`00Oomoo`2oOol00`00Oomoo`16Ool000Moo`D0009oo`8000Eoo`03001oogoo
0;moo`03001oogoo04Ioo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo0;mo
o`03001oogoo04Ioo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`<00;ioo`03001oogoo
04Moo`0000=oo`0000000P0017oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo0;io
o`03001oogoo04Moo`002Goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo0;ioo`03
001oogoo04Moo`0027oo0P0017oo0P001Goo00<007ooOol0_Woo00<007ooOol0Agoo000EOol00`00
Oomoo`2mOol00`00Oomoo`18Ool001Eoo`800;ioo`03001oogoo04Qoo`005Goo00<007ooOol0_Goo
00<007ooOol0B7oo000EOol00`00Oomoo`2mOol00`00Oomoo`18Ool001Eoo`03001oogoo0;eoo`03
001oogoo04Qoo`005Goo00<007ooOol0_Goo00<007ooOol0B7oo000EOol2002mOol00`00Oomoo`19
Ool001Eoo`03001oogoo0;aoo`03001oogoo04Uoo`005Goo00<007ooOol0_7oo00<007ooOol0BGoo
000EOol00`00Oomoo`2lOol00`00Oomoo`19Ool001Eoo`03001oogoo0;aoo`03001oogoo04Uoo`00
5Goo0P00_Goo00<007ooOol0BGoo000EOol00`00Oomoo`2lOol00`00Oomoo`19Ool001Eoo`03001o
ogoo0;]oo`03001oogoo04Yoo`005Goo00<007ooOol0^goo00<007ooOol0BWoo000EOol00`00Oomo
o`2kOol00`00Oomoo`1:Ool001Eoo`800;aoo`03001oogoo04Yoo`005Goo00<007ooOol0^goo00<0
07ooOol0BWoo000EOol00`00Oomoo`2kOol00`00Oomoo`1:Ool000ioo`8000Eoo`03001oogoo0;Yo
o`03001oogoo04]oo`003Goo00@007ooOol000Aoo`03001oogoo0;Yoo`03001oogoo04]oo`0047oo
00<007ooOol00Woo0`00^Woo00<007ooOol0Bgoo0007Ool40003Ool20005Ool00`00Oomoo`2jOol0
0`00Oomoo`1;Ool000ioo`03001oogoo00Aoo`03001oogoo0;Yoo`03001oogoo04]oo`003Woo0`00
17oo00<007ooOol0^Woo00<007ooOol0Bgoo000EOol00`00Oomoo`2jOol00`00Oomoo`1;Ool001Eo
o`800;Yoo`03001oogoo04aoo`005Goo00<007ooOol0^Goo00<007ooOol0C7oo000EOol00`00Oomo
o`2iOol00`00Oomoo`1<Ool001Eoo`03001oogoo0;Uoo`03001oogoo04aoo`005Goo00<007ooOol0
^Goo00<007ooOol0C7oo000EOol2002jOol00`00Oomoo`1<Ool001Eoo`03001oogoo0;Uoo`03001o
ogoo04aoo`005Goo00<007ooOol0^7oo00<007ooOol0CGoo000EOol00`00Oomoo`2hOol00`00Oomo
o`1=Ool001Eoo`03001oogoo01moo`8000Aoo`8000=oo`@001Uoo`8000Aoo`8000Eoo`<001Qoo`80
00Aoo`8000=oo`<001]oo`8000Aoo`8000Aoo`80019oo`03001oogoo00Yoo`D001ioo`D0009oo`80
00=oo`@0011oo`005Goo0P007goo00@007ooOol000Qoo`03001oogoo01Uoo`04001oogoo000;Ool0
0`00Oomoo`0FOol01000Oomoo`0027oo00@007ooOol001Uoo`04001oogoo0008Ool01000Oomoo`00
4Goo00<007ooOol037oo00<007ooOol087oo00<007ooOol01goo00<007ooOol04Goo000EOol00`00
Oomoo`0NOol01000Oomoo`002Goo00<007ooOol067oo00@007ooOol000Qoo`D001Moo`04001oogoo
0008Ool01000Oomoo`006Goo00@007ooOol000Qoo`04001oogoo000AOol00`00Oomoo`0<Ool00`00
Oomoo`0POol00`00Oomoo`08Ool00`00Oomoo`0@Ool001Eoo`03001oogoo01ioo`04001oogoo000:
Ool00`00Oomoo`0GOol01000Oomoo`0027oo00@007ooOol001Qoo`04001oogoo0008Ool3000JOol0
1000Oomoo`002Goo0P004Woo00<007ooOol037oo00<007ooOol087oo00<007ooOol02Goo00<007oo
Ool03goo000EOol00`00Oomoo`0NOol01000Oomoo`0027oo00@007ooOol001Qoo`04001oogoo0009
Ool00`00Ool0000HOol01000Oomoo`002Goo00<007ooOol06Goo00@007ooOol000Qoo`04001oogoo
000@Ool00`00Oomoo`0=Ool00`00Oomoo`0POol00`00Oomoo`07Ool01000Oomoo`0047oo000EOol0
0`00Oomoo`0OOol2000:Ool2000JOol2000;Ool2000IOol2000:Ool3000JOol2000:Ool2000AOol0
0`00Oomoo`0<Ool2000QOol2000:Ool2000AOol001Eoo`800;Qoo`03001oogoo04ioo`005Goo00<0
07ooOol0]goo00<007ooOol0CWoo000EOol00`00Oomoo`2gOol00`00Oomoo`1>Ool001Eoo`03001o
ogoo0;Moo`03001oogoo04Ioo`8000Ioo`005Goo00<007ooOol0]goo00<007ooOol0AGoo00@007oo
Ool000Eoo`003gooo`000@0027oo00<007ooOol01Woo000EOol00`00Oomoo`07Ool00`00Oomoo`03
Ool50009Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool01000Oomoo`001Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<0
07ooOol01goo00<007ooOol027oo00<007ooOol02goo1@001Goo000EOol00`00Oomoo`0AOol5000@
Ool00`00Oomoo`0UOol00`00Oomoo`0UOol00`00Oomoo`0VOol00`00Oomoo`0DOol00`00Oomoo`0>
Ool00`00Oomoo`0VOol00`00Oomoo`0<Ool00`00Oomoo`06Ool001Eoo`03001oogoo01Ioo`<009eo
o`03001oogoo04moo`005Goo00<007ooOol06Goo0P00Vgoo00<007ooOol0Cgoo000EOol2000LOol2
002IOol00`00Oomoo`1?Ool001Eoo`03001oogoo01eoo`8009Moo`03001oogoo04moo`005Goo00<0
07ooOol07goo0P00U7oo00<007ooOol0D7oo000EOol00`00Oomoo`0QOol00`00Oomoo`2AOol00`00
Oomoo`1@Ool001Eoo`03001oogoo029oo`03001oogoo091oo`03001oogoo051oo`005Goo0P0097oo
0P00T7oo00<007ooOol0D7oo000EOol00`00Oomoo`0UOol00`00Oomoo`2=Ool00`00Oomoo`1@Ool0
01Eoo`03001oogoo02Ioo`03001oogoo08aoo`03001oogoo051oo`005Goo00<007ooOol09goo00<0
07ooOol0RWoo00<007ooOol0DGoo000EOol00`00Oomoo`0XOol00`00Oomoo`29Ool00`00Oomoo`1A
Ool001Eoo`8002Yoo`03001oogoo08Qoo`03001oogoo055oo`005Goo00<007ooOol0:Woo00<007oo
Ool0Qgoo00<007ooOol0DGoo000EOol00`00Oomoo`0[Ool20027Ool00`00Oomoo`1AOol001Eoo`03
001oogoo02eoo`03001oogoo08Aoo`03001oogoo055oo`005Goo00<007ooOol0;Woo00<007ooOol0
PWoo00<007ooOol0DWoo000EOol2000`Ool00`00Oomoo`21Ool00`00Oomoo`1BOol001Eoo`03001o
ogoo031oo`03001oogoo081oo`03001oogoo059oo`005Goo00<007ooOol0<Goo00<007ooOol0Ogoo
00<007ooOol0DWoo000>Ool20005Ool00`00Oomoo`0bOol00`00Oomoo`1mOol00`00Oomoo`1COol0
00eoo`04001oogoo0004Ool00`00Oomoo`0bOol00`00Oomoo`1mOol00`00Oomoo`1COol0011oo`03
001oogoo009oo`<003=oo`03001oogoo07aoo`03001oogoo05=oo`003Woo0P001Goo00<007ooOol0
=7oo00<007ooOol0Ngoo00<007ooOol0Dgoo000>Ool00`00Oomoo`04Ool00`00Oomoo`0eOol00`00
Oomoo`1iOol00`00Oomoo`1DOol000ioo`<000Aoo`03001oogoo03Eoo`03001oogoo07Uoo`03001o
ogoo05Aoo`005Goo00<007ooOol0=Woo00<007ooOol0N7oo00<007ooOol0E7oo000EOol2000hOol0
0`00Oomoo`1gOol00`00Oomoo`1DOol001Eoo`03001oogoo03Moo`03001oogoo07Ioo`03001oogoo
05Eoo`005Goo00<007ooOol0>7oo00<007ooOol0MGoo00<007ooOol0EGoo000EOol00`00Oomoo`0i
Ool00`00Oomoo`1dOol00`00Oomoo`1EOol001Eoo`03001oogoo03Yoo`03001oogoo07=oo`03001o
ogoo05Eoo`005Goo0P00>goo00<007ooOol0LWoo00<007ooOol0EWoo000EOol00`00Oomoo`0kOol0
0`00Oomoo`1aOol00`00Oomoo`1FOol001Eoo`03001oogoo03aoo`03001oogoo071oo`03001oogoo
05Ioo`005Goo00<007ooOol0?7oo00<007ooOol0L7oo00<007ooOol0EWoo000EOol00`00Oomoo`0m
Ool00`00Oomoo`1^Ool00`00Oomoo`1GOol001Eoo`8003ioo`03001oogoo06ioo`03001oogoo05Mo
o`005Goo00<007ooOol0?Woo00<007ooOol0KGoo00<007ooOol0Egoo000EOol00`00Oomoo`0nOol0
0`00Oomoo`1]Ool00`00Oomoo`1GOol001Eoo`03001oogoo03moo`03001oogoo06]oo`03001oogoo
05Qoo`005Goo00<007ooOol0@7oo00<007ooOol0JWoo00<007ooOol0F7oo000EOol20011Ool00`00
Oomoo`1ZOol00`00Oomoo`1HOol001Eoo`03001oogoo045oo`03001oogoo06Uoo`03001oogoo05Qo
o`005Goo00<007ooOol0@Goo00<007ooOol0J7oo00<007ooOol0FGoo0007Ool50002Ool20005Ool0
0`00Oomoo`12Ool00`00Oomoo`1WOol00`00Oomoo`1IOol000Uoo`05001oogooOol00002Ool00`00
Oomoo`02Ool00`00Oomoo`12Ool00`00Oomoo`1WOol00`00Oomoo`1IOol000Uoo`05001oogooOol0
0002Ool00`00Oomoo`02Ool30013Ool00`00Oomoo`1UOol00`00Oomoo`1JOol000Uoo`05001oogoo
Ool00002Ool00`00Oomoo`02Ool00`00Oomoo`13Ool00`00Oomoo`1UOol00`00Oomoo`1JOol000Uo
o`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`14Ool00`00Oomoo`1TOol00`00Oomo
o`1JOol000Qoo`8000Aoo`8000Eoo`03001oogoo04Eoo`03001oogoo069oo`03001oogoo05]oo`00
5Goo00<007ooOol0AGoo00<007ooOol0HWoo00<007ooOol0Fgoo000EOol20017Ool00`00Oomoo`1Q
Ool00`00Oomoo`1KOol001Eoo`03001oogoo04Ioo`03001oogoo065oo`03001oogoo05]oo`005Goo
00<007ooOol0Agoo00<007ooOol0Ggoo00<007ooOol0G7oo000EOol00`00Oomoo`17Ool00`00Oomo
o`1OOol00`00Oomoo`1LOol001Eoo`03001oogoo04Qoo`03001oogoo05ioo`03001oogoo05aoo`00
5Goo0P00BGoo00<007ooOol0GGoo00<007ooOol0GGoo000EOol00`00Oomoo`19Ool00`00Oomoo`1L
Ool00`00Oomoo`1MOol001Eoo`03001oogoo04Uoo`03001oogoo05aoo`03001oogoo05eoo`005Goo
00<007ooOol0BWoo00<007ooOol0Fgoo00<007ooOol0GGoo000EOol00`00Oomoo`1;Ool00`00Oomo
o`1IOol00`00Oomoo`1NOol001Eoo`8004aoo`03001oogoo05Uoo`03001oogoo05ioo`005Goo00<0
07ooOol0C7oo00<007ooOol0Egoo00<007ooOol0Ggoo000EOol00`00Oomoo`1=Ool00`00Oomoo`1F
Ool00`00Oomoo`1OOol001Eoo`03001oogoo04eoo`03001oogoo05Eoo`03001oogoo061oo`005Goo
00<007ooOol0CWoo00<007ooOol0E7oo00<007ooOol0H7oo000EOol2001?Ool00`00Oomoo`1COol0
0`00Oomoo`1QOol001Eoo`03001oogoo04moo`03001oogoo055oo`03001oogoo069oo`005Goo00<0
07ooOol0D7oo00<007ooOol0Cgoo0P00I7oo0007Ool50002Ool20005Ool00`00Oomoo`1AOol00`00
Oomoo`1=Ool00`00Oomoo`1TOol000Uoo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomo
o`1AOol00`00Oomoo`1;Ool3001VOol000Uoo`03001oogoo00Aoo`03001oogoo009oo`<0059oodd0
06Uoo`002Goo00<007ooOol00Woo0P001Goo00<007ooOol0ogoo2Goo0009Ool00`00Oomoo`02Ool0
0`00Oomoo`04Ool00`00Oomoo`3oOol9Ool000Qoo`8000Aoo`<000Aoo`03001oogoo0?moo`Uoo`00
5Goo00<007ooOol0ogoo2Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol0011oo`@0009oo`<00?moo`Qoo`00
4Goo00<007ooOol01Goo00<007ooOol0ogoo1Goo000AOol00`00Oomoo`02Ool3003oOol8Ool0011o
o`@0009oo`@00?moo`Moo`004Goo00<007ooOol0ogoo3Goo000BOol2003oOol=Ool00?moob5oo`00
ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.107238, -15.901, \
0.00494992, 0.200229}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("t      p"\[InvisibleSpace]"        \
"\[InvisibleSpace]"t        u"\[InvisibleSpace]"              "\
\[InvisibleSpace]"t        v"\[InvisibleSpace]"          "\[InvisibleSpace]"t \
      a"\[InvisibleSpace]"         "\[InvisibleSpace]"t      kt"\),
      SequenceForm[ 
      "t      p", "        ", "t        u", "              ", "t        v", 
        "          ", "t       a", "         ", "t      kt"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("-----------------------------------------------------------------------\
------------------------"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        InterpretationBox[GridBox[{
              {\({0, 0.`}\)},
              {\({0.01`, 0.4999999999999991`}\)},
              {\({0.02`, 1.`}\)},
              {\({0.03`, 1.4999999999999996`}\)},
              {\({0.04`, 1.9999999999999996`}\)},
              {\({0.05`, 2.5`}\)},
              {\({0.060000000000000005`, 3.`}\)},
              {\({0.07`, 3.5`}\)},
              {\({0.08`, 4.`}\)},
              {\({0.09`, 4.5`}\)},
              {\({0.09999999999999999`, 4.999999999999999`}\)},
              {\({0.10999999999999999`, 5.499999999999999`}\)},
              {\({0.11999999999999998`, 5.999999999999998`}\)},
              {\({0.12999999999999998`, 6.499999999999998`}\)},
              {\({0.13999999999999999`, 6.999999999999998`}\)},
              {\({0.15`, 7.499999999999999`}\)},
              {\({0.16`, 8.`}\)},
              {\({0.17`, 8.5`}\)},
              {\({0.18000000000000002`, 9.`}\)},
              {\({0.19000000000000003`, 9.500000000000002`}\)},
              {\({0.20000000000000004`, 10.`}\)},
              {\({0.21000000000000005`, 10.500000000000002`}\)},
              {\({0.22000000000000006`, 11.000000000000002`}\)},
              {\({0.23000000000000007`, 11.500000000000004`}\)},
              {\({0.24000000000000007`, 12.000000000000004`}\)},
              {\({0.25000000000000006`, 12.500000000000004`}\)},
              {\({0.26000000000000006`, 13.000000000000004`}\)},
              {\({0.2700000000000001`, 13.500000000000004`}\)},
              {\({0.2800000000000001`, 14.000000000000004`}\)},
              {\({0.2900000000000001`, 14.500000000000005`}\)},
              {\({0.3000000000000001`, 14.999999999999995`}\)},
              {\({0.3100000000000001`, 14.499999999999995`}\)},
              {\({0.3200000000000001`, 13.999999999999993`}\)},
              {\({0.3300000000000001`, 13.499999999999993`}\)},
              {\({0.34000000000000014`, 12.999999999999993`}\)},
              {\({0.35000000000000014`, 12.499999999999993`}\)},
              {\({0.36000000000000015`, 11.999999999999993`}\)},
              {\({0.37000000000000016`, 11.499999999999993`}\)},
              {\({0.38000000000000017`, 10.999999999999993`}\)},
              {\({0.3900000000000002`, 10.499999999999993`}\)},
              {\({0.4000000000000002`, 9.999999999999993`}\)},
              {\({0.4100000000000002`, 9.499999999999991`}\)},
              {\({0.4200000000000002`, 8.999999999999991`}\)},
              {\({0.4300000000000002`, 8.49999999999999`}\)},
              {\({0.4400000000000002`, 7.999999999999989`}\)},
              {\({0.45000000000000023`, 7.499999999999989`}\)},
              {\({0.46000000000000024`, 6.9999999999999885`}\)},
              {\({0.47000000000000025`, 6.499999999999988`}\)},
              {\({0.48000000000000026`, 5.999999999999988`}\)},
              {\({0.49000000000000027`, 5.499999999999987`}\)},
              {\({0.5000000000000002`, 4.999999999999979`}\)},
              {\({0.5100000000000002`, 3.999999999999977`}\)},
              {\({0.5200000000000002`, 2.999999999999976`}\)},
              {\({0.5300000000000002`, 1.9999999999999751`}\)},
              {\({0.5400000000000003`, 0.9999999999999734`}\)},
              {\({0.5500000000000003`, \(-2.7533531010703882`*^-14\)}\)},
              {\({0.5600000000000003`, \(-1.0000000000000284`\)}\)},
              {\({0.5700000000000003`, \(-2.0000000000000298`\)}\)},
              {\({0.5800000000000003`, \(-3.000000000000031`\)}\)},
              {\({0.5900000000000003`, \(-4.000000000000032`\)}\)},
              {\({0.6000000000000003`, \(-5.000000000000017`\)}\)},
              {\({0.6100000000000003`, \(-5.500000000000017`\)}\)},
              {\({0.6200000000000003`, \(-6.000000000000018`\)}\)},
              {\({0.6300000000000003`, \(-6.500000000000019`\)}\)},
              {\({0.6400000000000003`, \(-7.0000000000000195`\)}\)},
              {\({0.6500000000000004`, \(-7.5000000000000195`\)}\)},
              {\({0.6600000000000004`, \(-8.00000000000002`\)}\)},
              {\({0.6700000000000004`, \(-8.500000000000021`\)}\)},
              {\({0.6800000000000004`, \(-9.000000000000021`\)}\)},
              {\({0.6900000000000004`, \(-9.500000000000021`\)}\)},
              {\({0.7000000000000004`, \(-10.000000000000021`\)}\)},
              {\({0.7100000000000004`, \(-10.500000000000021`\)}\)},
              {\({0.7200000000000004`, \(-11.000000000000021`\)}\)},
              {\({0.7300000000000004`, \(-11.500000000000021`\)}\)},
              {\({0.7400000000000004`, \(-12.000000000000021`\)}\)},
              {\({0.7500000000000004`, \(-12.500000000000021`\)}\)},
              {\({0.7600000000000005`, \(-13.000000000000021`\)}\)},
              {\({0.7700000000000005`, \(-13.500000000000021`\)}\)},
              {\({0.7800000000000005`, \(-14.000000000000021`\)}\)},
              {\({0.7900000000000005`, \(-14.500000000000021`\)}\)},
              {\({0.8000000000000005`, \(-15.000000000000021`\)}\)},
              {\({0.8100000000000005`, \(-15.500000000000021`\)}\)},
              {\({0.8200000000000005`, \(-16.00000000000002`\)}\)},
              {\({0.8300000000000005`, \(-16.500000000000025`\)}\)},
              {\({0.8400000000000005`, \(-17.000000000000025`\)}\)},
              {\({0.8500000000000005`, \(-17.500000000000025`\)}\)},
              {\({0.8600000000000005`, \(-18.000000000000025`\)}\)},
              {\({0.8700000000000006`, \(-18.500000000000025`\)}\)},
              {\({0.8800000000000006`, \(-19.000000000000025`\)}\)},
              {\({0.8900000000000006`, \(-19.50000000000003`\)}\)},
              {\({0.9000000000000006`, \(-20.00000000000003`\)}\)},
              {\({0.9100000000000006`, \(-20.50000000000003`\)}\)},
              {\({0.9200000000000006`, \(-21.00000000000003`\)}\)},
              {\({0.9300000000000006`, \(-21.50000000000003`\)}\)},
              {\({0.9400000000000006`, \(-22.00000000000003`\)}\)},
              {\({0.9500000000000006`, \(-22.500000000000032`\)}\)},
              {\({0.9600000000000006`, \(-23.000000000000032`\)}\)},
              {\({0.9700000000000006`, \(-23.500000000000032`\)}\)},
              {\({0.9800000000000006`, \(-24.000000000000032`\)}\)},
              {\({0.9900000000000007`, \(-24.500000000000032`\)}\)},
              {\({1.0000000000000007`, \(-25.`\)}\)},
              {\({1.0100000000000007`, \(-25.`\)}\)},
              {\({1.0200000000000007`, \(-25.`\)}\)},
              {\({1.0300000000000007`, \(-25.`\)}\)},
              {\({1.0400000000000007`, \(-25.`\)}\)},
              {\({1.0500000000000007`, \(-25.`\)}\)},
              {\({1.0600000000000007`, \(-25.`\)}\)},
              {\({1.0700000000000007`, \(-25.`\)}\)},
              {\({1.0800000000000007`, \(-25.`\)}\)},
              {\({1.0900000000000007`, \(-25.`\)}\)},
              {\({1.1000000000000008`, \(-25.`\)}\)},
              {\({1.1100000000000008`, \(-25.`\)}\)},
              {\({1.1200000000000008`, \(-25.`\)}\)},
              {\({1.1300000000000008`, \(-25.`\)}\)},
              {\({1.1400000000000008`, \(-25.`\)}\)},
              {\({1.1500000000000008`, \(-25.`\)}\)},
              {\({1.1600000000000008`, \(-25.`\)}\)},
              {\({1.1700000000000008`, \(-25.`\)}\)},
              {\({1.1800000000000008`, \(-25.`\)}\)},
              {\({1.1900000000000008`, \(-25.`\)}\)},
              {\({1.2000000000000008`, \(-25.`\)}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 0.0}, {.01, .49999999999999911}, {.02, 
            1.0}, {.029999999999999999, 
            1.4999999999999996}, {.040000000000000001, 
            1.9999999999999996}, {.050000000000000003, 
            2.5}, {.060000000000000005, 3.0}, {.070000000000000007, 
            3.5}, {.080000000000000002, 4.0}, {.089999999999999997, 
            4.5}, {.099999999999999992, 
            4.9999999999999991}, {.10999999999999999, 
            5.4999999999999991}, {.11999999999999998, 
            5.9999999999999982}, {.12999999999999998, 
            6.4999999999999982}, {.13999999999999999, 
            6.9999999999999982}, {.14999999999999999, 
            7.4999999999999991}, {.16, 8.0}, {.17000000000000001, 
            8.5}, {.18000000000000002, 9.0}, {.19000000000000003, 
            9.5000000000000018}, {.20000000000000004, .1*^2}, \
{.21000000000000005, 10.500000000000002}, {.22000000000000006, 
            11.000000000000002}, {.23000000000000007, 
            11.500000000000004}, {.24000000000000007, 
            12.000000000000004}, {.25000000000000006, 
            12.500000000000004}, {.26000000000000006, 
            13.000000000000004}, {.27000000000000007, 
            13.500000000000004}, {.28000000000000008, 
            14.000000000000004}, {.29000000000000009, 
            14.500000000000005}, {.3000000000000001, 
            14.999999999999995}, {.31000000000000011, 
            14.499999999999995}, {.32000000000000012, 
            13.999999999999993}, {.33000000000000013, 
            13.499999999999993}, {.34000000000000014, 
            12.999999999999993}, {.35000000000000014, 
            12.499999999999993}, {.36000000000000015, 
            11.999999999999993}, {.37000000000000016, 
            11.499999999999993}, {.38000000000000017, 
            10.999999999999993}, {.39000000000000018, 
            10.499999999999993}, {.40000000000000019, 
            9.9999999999999929}, {.4100000000000002, 
            9.4999999999999911}, {.42000000000000021, 
            8.9999999999999911}, {.43000000000000022, 
            8.4999999999999893}, {.44000000000000022, 
            7.9999999999999893}, {.45000000000000023, 
            7.4999999999999893}, {.46000000000000024, 
            6.9999999999999885}, {.47000000000000025, 
            6.4999999999999876}, {.48000000000000026, 
            5.9999999999999876}, {.49000000000000027, 
            5.4999999999999867}, {.50000000000000022, 
            4.9999999999999787}, {.51000000000000023, 
            3.9999999999999769}, {.52000000000000024, 
            2.999999999999976}, {.53000000000000025, 
            1.9999999999999751}, {.54000000000000026, .99999999999997335}, \
{.55000000000000027, -.27533531010703882*^-13}, {.56000000000000028, \
-1.0000000000000284}, {.57000000000000028, -2.0000000000000298}, \
{.58000000000000029, -3.0000000000000311}, {.5900000000000003, \
-4.000000000000032}, {.60000000000000031, -5.0000000000000169}, \
{.61000000000000032, -5.5000000000000169}, {.62000000000000033, \
-6.0000000000000178}, {.63000000000000034, -6.5000000000000187}, \
{.64000000000000035, -7.0000000000000195}, {.65000000000000036, \
-7.5000000000000195}, {.66000000000000036, -8.0000000000000195}, \
{.67000000000000037, -8.5000000000000213}, {.68000000000000038, \
-9.0000000000000213}, {.69000000000000039, -9.5000000000000213}, \
{.7000000000000004, -10.000000000000021}, {.71000000000000041, \
-10.500000000000021}, {.72000000000000042, -11.000000000000021}, \
{.73000000000000043, -11.500000000000021}, {.74000000000000044, \
-12.000000000000021}, {.75000000000000044, -12.500000000000021}, \
{.76000000000000045, -13.000000000000021}, {.77000000000000046, \
-13.500000000000021}, {.78000000000000047, -14.000000000000021}, \
{.79000000000000048, -14.500000000000021}, {.80000000000000049, \
-15.000000000000021}, {.8100000000000005, -15.500000000000021}, \
{.82000000000000051, -16.000000000000021}, {.83000000000000052, \
-16.500000000000025}, {.84000000000000052, -17.000000000000025}, \
{.85000000000000053, -17.500000000000025}, {.86000000000000054, \
-18.000000000000025}, {.87000000000000055, -18.500000000000025}, \
{.88000000000000056, -19.000000000000025}, {.89000000000000057, \
-19.500000000000028}, {.90000000000000058, -20.000000000000028}, \
{.91000000000000059, -20.500000000000028}, {.9200000000000006, \
-21.000000000000028}, {.9300000000000006, -21.500000000000028}, \
{.94000000000000061, -22.000000000000028}, {.95000000000000062, \
-22.500000000000032}, {.96000000000000063, -23.000000000000032}, \
{.97000000000000064, -23.500000000000032}, {.98000000000000065, \
-24.000000000000032}, {.99000000000000066, -24.500000000000032}, {
            1.0000000000000007, -25.0}, {1.0100000000000007, -25.0}, {
            1.0200000000000007, -25.0}, {1.0300000000000007, -25.0}, {
            1.0400000000000007, -25.0}, {1.0500000000000007, -25.0}, {
            1.0600000000000007, -25.0}, {1.0700000000000007, -25.0}, {
            1.0800000000000007, -25.0}, {1.0900000000000007, -25.0}, {
            1.1000000000000008, -25.0}, {1.1100000000000008, -25.0}, {
            1.1200000000000008, -25.0}, {1.1300000000000008, -25.0}, {
            1.1400000000000008, -25.0}, {1.1500000000000008, -25.0}, {
            1.1600000000000008, -25.0}, {1.1700000000000008, -25.0}, {
            1.1800000000000008, -25.0}, {1.1900000000000008, -25.0}, {
            1.2000000000000008, -25.0}}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {\({0, 0}\)},
              {\({0.01`, 0.00009841944925786384`}\)},
              {\({0.02`, 0.0003277103736414803`}\)},
              {\({0.03`, 0.0008833721153662083`}\)},
              {\({0.04`, 0.001959526190239075`}\)},
              {\({0.05`, 0.0037473551449471016`}\)},
              {\({0.060000000000000005`, 0.006434355658959007`}\)},
              {\({0.07`, 0.010203613532449233`}\)},
              {\({0.08`, 0.01523309944430229`}\)},
              {\({0.09`, 0.0216949881526949`}\)},
              {\({0.09999999999999999`, 0.02975500372481256`}\)},
              {\({0.10999999999999999`, 0.0395717932675985`}\)},
              {\({0.11999999999999998`, 0.05129633150742461`}\)},
              {\({0.12999999999999998`, 0.0650713584338408`}\)},
              {\({0.13999999999999999`, 0.08103085208166684`}\)},
              {\({0.15`, 0.09929953837723346`}\)},
              {\({0.16`, 0.11999243981917967`}\)},
              {\({0.17`, 0.1432144646025158`}\)},
              {\({0.18000000000000002`, 0.16906003762733765`}\)},
              {\({0.19000000000000003`, 0.19761277466131053`}\)},
              {\({0.20000000000000004`, 0.22894520074854033`}\)},
              {\({0.21000000000000005`, 0.2631185137774274`}\)},
              {\({0.22000000000000006`, 0.30018239393728596`}\)},
              {\({0.23000000000000007`, 0.34017485960864596`}\)},
              {\({0.24000000000000007`, 0.38312217004597193`}\)},
              {\({0.25000000000000006`, 0.4290387750247807`}\)},
              {\({0.26000000000000006`, 0.47792731143855727`}\)},
              {\({0.2700000000000001`, 0.5297786466451913`}\)},
              {\({0.2800000000000001`, 0.5845719681786191`}\)},
              {\({0.2900000000000001`, 0.6422749192596755`}\)},
              {\({0.3000000000000001`, 0.7028437793615468`}\)},
              {\({0.3100000000000001`, 0.7660268500118446`}\)},
              {\({0.3200000000000001`, 0.8316934962837421`}\)},
              {\({0.3300000000000001`, 0.8993764268523751`}\)},
              {\({0.34000000000000014`, 0.9686008941914245`}\)},
              {\({0.35000000000000014`, 1.0388882055766904`}\)},
              {\({0.36000000000000015`, 1.1097576426929958`}\)},
              {\({0.37000000000000016`, 1.1807283727081548`}\)},
              {\({0.38000000000000017`, 1.2513213510614583`}\)},
              {\({0.3900000000000002`, 1.3210612085147246`}\)},
              {\({0.4000000000000002`, 1.3894781150722144`}\)},
              {\({0.4100000000000002`, 1.4561096135006877`}\)},
              {\({0.4200000000000002`, 1.523487969591211`}\)},
              {\({0.4300000000000002`, 1.589299544417474`}\)},
              {\({0.4400000000000002`, 1.6581084489000264`}\)},
              {\({0.45000000000000023`, 1.7297225463271644`}\)},
              {\({0.46000000000000024`, 1.8039260659553722`}\)},
              {\({0.47000000000000025`, 1.8805044657774297`}\)},
              {\({0.48000000000000026`, 1.95924455466075`}\)},
              {\({0.49000000000000027`, 2.0399344845197622`}\)},
              {\({0.5000000000000002`, 2.1223637418586403`}\)},
              {\({0.5100000000000002`, 2.2062245452500715`}\)},
              {\({0.5200000000000002`, 2.291276263479084`}\)},
              {\({0.5300000000000002`, 2.377115800429521`}\)},
              {\({0.5400000000000003`, 2.4633417376197633`}\)},
              {\({0.5500000000000003`, 2.5495551808749988`}\)},
              {\({0.5600000000000003`, 2.63535974892979`}\)},
              {\({0.5700000000000003`, 2.720361557621052`}\)},
              {\({0.5800000000000003`, 2.804169204157057`}\)},
              {\({0.5900000000000003`, 2.8863937514854183`}\)},
              {\({0.6000000000000003`, 2.9666487127595547`}\)},
              {\({0.6100000000000003`, 3.044648630016673`}\)},
              {\({0.6200000000000003`, 3.1200446323408895`}\)},
              {\({0.6300000000000003`, 3.1926540274329596`}\)},
              {\({0.6400000000000003`, 3.2622961356790783`}\)},
              {\({0.6500000000000004`, 3.3287914202305227`}\)},
              {\({0.6600000000000004`, 3.3919614752994507`}\)},
              {\({0.6700000000000004`, 3.451629019009829`}\)},
              {\({0.6800000000000004`, 3.5076178863169427`}\)},
              {\({0.6900000000000004`, 3.5597530219716402`}\)},
              {\({0.7000000000000004`, 3.6078604735288997`}\)},
              {\({0.7100000000000004`, 3.65176738440044`}\)},
              {\({0.7200000000000004`, 3.691301986951094`}\)},
              {\({0.7300000000000004`, 3.7262935956386847`}\)},
              {\({0.7400000000000004`, 3.7565726001971047`}\)},
              {\({0.7500000000000004`, 3.781970458862349`}\)},
              {\({0.7600000000000005`, 3.802319691641221`}\)},
              {\({0.7700000000000005`, 3.8174538736224424`}\)},
              {\({0.7800000000000005`, 3.827207628329901`}\)},
              {\({0.7900000000000005`, 3.8314166211177727`}\)},
              {\({0.8000000000000005`, 3.822378490007648`}\)},
              {\({0.8100000000000005`, 3.80499750833701`}\)},
              {\({0.8200000000000005`, 3.7666390261099503`}\)},
              {\({0.8300000000000005`, 3.707290933740354`}\)},
              {\({0.8400000000000005`, 3.627085467833224`}\)},
              {\({0.8500000000000005`, 3.52623707933275`}\)},
              {\({0.8600000000000005`, 3.4050409117269753`}\)},
              {\({0.8700000000000006`, 3.2638712645805734`}\)},
              {\({0.8800000000000006`, 3.10317975236637`}\)},
              {\({0.8900000000000006`, 2.9234931658133982`}\)},
              {\({0.9000000000000006`, 2.7254110455795613`}\)},
              {\({0.9100000000000006`, 2.5096029791575503`}\)},
              {\({0.9200000000000006`, 2.276805632967952`}\)},
              {\({0.9300000000000006`, 2.0278195325867334`}\)},
              {\({0.9400000000000006`, 1.7635056049917606`}\)},
              {\({0.9500000000000006`, 1.484781497591303`}\)},
              {\({0.9600000000000006`, 1.192617689613366`}\)},
              {\({0.9700000000000006`, 0.888033412185217`}\)},
              {\({0.9800000000000006`, 0.5732827928149852`}\)},
              {\({0.9900000000000007`, 0.24803361036777977`}\)},
              {\({1.0000000000000007`, \(-0.08482867127903808`\)}\)},
              {\({1.0100000000000007`, \(-0.4253398691990282`\)}\)},
              {\({1.0200000000000007`, \(-0.7736165609400045`\)}\)},
              {\({1.0300000000000007`, \(-1.129610691724739`\)}\)},
              {\({1.0400000000000007`, \(-1.4932736481748992`\)}\)},
              {\({1.0500000000000007`, \(-1.8645571186376564`\)}\)},
              {\({1.0600000000000007`, \(-2.24341309578768`\)}\)},
              {\({1.0700000000000007`, \(-2.6297938747336134`\)}\)},
              {\({1.0800000000000007`, \(-3.0236520511129403`\)}\)},
              {\({1.0900000000000007`, \(-3.4249405191987297`\)}\)},
              {\({1.1000000000000008`, \(-3.8336124700183065`\)}\)},
              {\({1.1100000000000008`, \(-4.249621389483773`\)}\)},
              {\({1.1200000000000008`, \(-4.67292105653431`\)}\)},
              {\({1.1300000000000008`, \(-5.103465541290181`\)}\)},
              {\({1.1400000000000008`, \(-5.541209203218361`\)}\)},
              {\({1.1500000000000008`, \(-5.986106689309728`\)}\)},
              {\({1.1600000000000008`, \(-6.438112932267733`\)}\)},
              {\({1.1700000000000008`, \(-6.897183148708483`\)}\)},
              {\({1.1800000000000008`, \(-7.363272837372162`\)}\)},
              {\({1.1900000000000008`, \(-7.836337777345723`\)}\)},
              {\({1.2000000000000008`, \(-8.316334026296767`\)}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 
            0}, {.01, .000098419449257863842}, {.02, .00032771037364148032}, \
{.029999999999999999, .00088337211536620834}, {.040000000000000001, \
.001959526190239075}, {.050000000000000003, .0037473551449471016}, \
{.060000000000000005, .0064343556589590073}, {.070000000000000007, \
.010203613532449233}, {.080000000000000002, .015233099444302289}, \
{.089999999999999997, .0216949881526949}, {.099999999999999992, \
.029755003724812559}, {.10999999999999999, .0395717932675985}, \
{.11999999999999998, .05129633150742461}, {.12999999999999998, \
.065071358433840806}, {.13999999999999999, .08103085208166684}, \
{.14999999999999999, .099299538377233459}, {.16, .11999243981917967}, \
{.17000000000000001, .1432144646025158}, {.18000000000000002, \
.16906003762733765}, {.19000000000000003, .19761277466131053}, \
{.20000000000000004, .22894520074854033}, {.21000000000000005, \
.2631185137774274}, {.22000000000000006, .30018239393728596}, \
{.23000000000000007, .34017485960864596}, {.24000000000000007, \
.38312217004597193}, {.25000000000000006, .42903877502478072}, \
{.26000000000000006, .47792731143855727}, {.27000000000000007, \
.52977864664519125}, {.28000000000000008, .58457196817861912}, \
{.29000000000000009, .6422749192596755}, {.3000000000000001, \
.70284377936154685}, {.31000000000000011, .76602685001184456}, \
{.32000000000000012, .83169349628374212}, {.33000000000000013, \
.89937642685237507}, {.34000000000000014, .96860089419142448}, \
{.35000000000000014, 1.0388882055766904}, {.36000000000000015, 
            1.1097576426929958}, {.37000000000000016, 
            1.1807283727081548}, {.38000000000000017, 
            1.2513213510614583}, {.39000000000000018, 
            1.3210612085147246}, {.40000000000000019, 
            1.3894781150722144}, {.4100000000000002, 
            1.4561096135006877}, {.42000000000000021, 
            1.5234879695912109}, {.43000000000000022, 
            1.589299544417474}, {.44000000000000022, 
            1.6581084489000264}, {.45000000000000023, 
            1.7297225463271644}, {.46000000000000024, 
            1.8039260659553722}, {.47000000000000025, 
            1.8805044657774297}, {.48000000000000026, 
            1.95924455466075}, {.49000000000000027, 
            2.0399344845197622}, {.50000000000000022, 
            2.1223637418586403}, {.51000000000000023, 
            2.2062245452500715}, {.52000000000000024, 
            2.2912762634790842}, {.53000000000000025, 
            2.3771158004295212}, {.54000000000000026, 
            2.4633417376197633}, {.55000000000000027, 
            2.5495551808749988}, {.56000000000000028, 
            2.63535974892979}, {.57000000000000028, 
            2.720361557621052}, {.58000000000000029, 
            2.8041692041570569}, {.5900000000000003, 
            2.8863937514854183}, {.60000000000000031, 
            2.9666487127595547}, {.61000000000000032, 
            3.0446486300166731}, {.62000000000000033, 
            3.1200446323408895}, {.63000000000000034, 
            3.1926540274329596}, {.64000000000000035, 
            3.2622961356790783}, {.65000000000000036, 
            3.3287914202305227}, {.66000000000000036, 
            3.3919614752994507}, {.67000000000000037, 
            3.4516290190098289}, {.68000000000000038, 
            3.5076178863169427}, {.69000000000000039, 
            3.5597530219716402}, {.7000000000000004, 
            3.6078604735288997}, {.71000000000000041, 
            3.6517673844004399}, {.72000000000000042, 
            3.6913019869510939}, {.73000000000000043, 
            3.7262935956386847}, {.74000000000000044, 
            3.7565726001971047}, {.75000000000000044, 
            3.7819704588623488}, {.76000000000000045, 
            3.802319691641221}, {.77000000000000046, 
            3.8174538736224424}, {.78000000000000047, 
            3.827207628329901}, {.79000000000000048, 
            3.8314166211177727}, {.80000000000000049, 
            3.8223784900076478}, {.8100000000000005, 
            3.80499750833701}, {.82000000000000051, 
            3.7666390261099503}, {.83000000000000052, 
            3.7072909337403539}, {.84000000000000052, 
            3.6270854678332238}, {.85000000000000053, 
            3.5262370793327502}, {.86000000000000054, 
            3.4050409117269753}, {.87000000000000055, 
            3.2638712645805734}, {.88000000000000056, 
            3.10317975236637}, {.89000000000000057, 
            2.9234931658133982}, {.90000000000000058, 
            2.7254110455795613}, {.91000000000000059, 
            2.5096029791575503}, {.9200000000000006, 
            2.2768056329679518}, {.9300000000000006, 
            2.0278195325867334}, {.94000000000000061, 
            1.7635056049917606}, {.95000000000000062, 
            1.484781497591303}, {.96000000000000063, 
            1.192617689613366}, {.97000000000000064, .88803341218521703}, \
{.98000000000000065, .57328279281498518}, {.99000000000000066, \
.24803361036777977}, {1.0000000000000007, -.084828671279038079}, {
            1.0100000000000007, -.42533986919902822}, {
            1.0200000000000007, -.77361656094000453}, {
            1.0300000000000007, -1.129610691724739}, {
            1.0400000000000007, -1.4932736481748992}, {
            1.0500000000000007, -1.8645571186376564}, {
            1.0600000000000007, -2.2434130957876799}, {
            1.0700000000000007, -2.6297938747336134}, {
            1.0800000000000007, -3.0236520511129403}, {
            1.0900000000000007, -3.4249405191987297}, {
            1.1000000000000008, -3.8336124700183065}, {
            1.1100000000000008, -4.2496213894837727}, {
            1.1200000000000008, -4.6729210565343102}, {
            1.1300000000000008, -5.1034655412901806}, {
            1.1400000000000008, -5.5412092032183606}, {
            1.1500000000000008, -5.9861066893097279}, {
            1.1600000000000008, -6.4381129322677326}, {
            1.1700000000000008, -6.8971831487084829}, {
            1.1800000000000008, -7.3632728373721621}, {
            1.1900000000000008, -7.8363377773457232}, {
            1.2000000000000008, -8.3163340262967669}}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {\({0, 0}\)},
              {\({0.01`, 0.0032806483092515906`}\)},
              {\({0.02`, 0.026233371229252685`}\)},
              {\({0.03`, 0.06875837909282176`}\)},
              {\({0.04`, 0.13059872679697854`}\)},
              {\({0.05`, 0.21142183034631656`}\)},
              {\({0.060000000000000005`, 0.31082151848825434`}\)},
              {\({0.07`, 0.42831997653388887`}\)},
              {\({0.08`, 0.5633699628528765`}\)},
              {\({0.09`, 0.7153572899345787`}\)},
              {\({0.09999999999999999`, 0.8836035590048037`}\)},
              {\({0.10999999999999999`, 1.0673691362252078`}\)},
              {\({0.11999999999999998`, 1.2658563576011266`}\)},
              {\({0.12999999999999998`, 1.4782129488774005`}\)},
              {\({0.13999999999999999`, 1.703535645913696`}\)},
              {\({0.15`, 1.9408740003037295`}\)},
              {\({0.16`, 2.1892343543393085`}\)},
              {\({0.17`, 2.4475839688225336`}\)},
              {\({0.18000000000000002`, 2.7148552866998585`}\)},
              {\({0.19000000000000003`, 2.9899503150319835`}\)},
              {\({0.20000000000000004`, 3.271745107424889`}\)},
              {\({0.21000000000000005`, 3.55909432873131`}\)},
              {\({0.22000000000000006`, 3.8508358835893026`}\)},
              {\({0.23000000000000007`, 4.145795590195853`}\)},
              {\({0.24000000000000007`, 4.442791880619298`}\)},
              {\({0.25000000000000006`, 4.740640508934393`}\)},
              {\({0.26000000000000006`, 5.03815924851807`}\)},
              {\({0.2700000000000001`, 5.334172559971867`}\)},
              {\({0.2800000000000001`, 5.627516211337599`}\)},
              {\({0.2900000000000001`, 5.917041832544987`}\)},
              {\({0.3000000000000001`, 6.20162138637224`}\)},
              {\({0.3100000000000001`, 6.4735902419934535`}\)},
              {\({0.3200000000000001`, 6.699091168153198`}\)},
              {\({0.3300000000000001`, 6.8772824397154775`}\)},
              {\({0.34000000000000014`, 7.007673685627189`}\)},
              {\({0.35000000000000014`, 7.089966660241155`}\)},
              {\({0.36000000000000015`, 7.124054765535012`}\)},
              {\({0.37000000000000016`, 7.11002259650936`}\)},
              {\({0.38000000000000017`, 7.048144736082914`}\)},
              {\({0.3900000000000002`, 6.938883803864236`}\)},
              {\({0.4000000000000002`, 6.782887769897154`}\)},
              {\({0.4100000000000002`, 6.580986547353612`}\)},
              {\({0.4200000000000002`, 6.433706356188575`}\)},
              {\({0.4300000000000002`, 6.744271834498377`}\)},
              {\({0.4400000000000002`, 7.035563249812835`}\)},
              {\({0.45000000000000023`, 7.305209770373876`}\)},
              {\({0.46000000000000024`, 7.553334656023736`}\)},
              {\({0.47000000000000025`, 7.78007341882854`}\)},
              {\({0.48000000000000026`, 7.985560785632353`}\)},
              {\({0.49000000000000027`, 8.169930634893758`}\)},
              {\({0.5000000000000002`, 8.333316001672529`}\)},
              {\({0.5100000000000002`, 8.472562612484793`}\)},
              {\({0.5200000000000002`, 8.571372911739926`}\)},
              {\({0.5300000000000002`, 8.629915190200641`}\)},
              {\({0.5400000000000003`, 8.648442671980126`}\)},
              {\({0.5500000000000003`, 8.627207437865891`}\)},
              {\({0.5600000000000003`, 8.566459982974695`}\)},
              {\({0.5700000000000003`, 8.466449224379279`}\)},
              {\({0.5800000000000003`, 8.327422511037572`}\)},
              {\({0.5900000000000003`, 8.149625633671162`}\)},
              {\({0.6000000000000003`, 7.933302834581649`}\)},
              {\({0.6100000000000003`, 7.681983287861888`}\)},
              {\({0.6200000000000003`, 7.412337087931521`}\)},
              {\({0.6300000000000003`, 7.12456613595567`}\)},
              {\({0.6400000000000003`, 6.8187850676329544`}\)},
              {\({0.6500000000000004`, 6.495107344563193`}\)},
              {\({0.6600000000000004`, 6.153645711191611`}\)},
              {\({0.6700000000000004`, 5.794512201689113`}\)},
              {\({0.6800000000000004`, 5.417818144439632`}\)},
              {\({0.6900000000000004`, 5.023674166486211`}\)},
              {\({0.7000000000000004`, 4.612190197949081`}\)},
              {\({0.7100000000000004`, 4.183475476416384`}\)},
              {\({0.7200000000000004`, 3.737638551307053`}\)},
              {\({0.7300000000000004`, 3.2747872882055225`}\)},
              {\({0.7400000000000004`, 2.7950288731704953`}\)},
              {\({0.7500000000000004`, 2.298469817015379`}\)},
              {\({0.7600000000000005`, 1.785215959561966`}\)},
              {\({0.7700000000000005`, 1.2553724738678644`}\)},
              {\({0.7800000000000005`, 0.709043870426942`}\)},
              {\({0.7900000000000005`, 0.1463340013431418`}\)},
              {\({0.8000000000000005`, \(-0.6839560222258243`\)}\)},
              {\({0.8100000000000005`, \(-2.7855819244314564`\)}\)},
              {\({0.8200000000000005`, \(-4.8925742652526365`\)}\)},
              {\({0.8300000000000005`, \(-6.990429752945297`\)}\)},
              {\({0.8400000000000005`, \(-9.070860318378726`\)}\)},
              {\({0.8500000000000005`, \(-11.12571455854671`\)}\)},
              {\({0.8600000000000005`, \(-13.146979512003359`\)}\)},
              {\({0.8700000000000006`, \(-15.126811582932007`\)}\)},
              {\({0.8800000000000006`, \(-17.057566800154326`\)}\)},
              {\({0.8900000000000006`, \(-18.931830149347082`\)}\)},
              {\({0.9000000000000006`, \(-20.742443865928387`\)}\)},
              {\({0.9100000000000006`, \(-22.482534581411116`\)}\)},
              {\({0.9200000000000006`, \(-24.145539221045805`\)}\)},
              {\({0.9300000000000006`, \(-25.72522955598276`\)}\)},
              {\({0.9400000000000006`, \(-27.215735318944525`\)}\)},
              {\({0.9500000000000006`, \(-28.61156579849918`\)}\)},
              {\({0.9600000000000006`, \(-29.907629833429286`\)}\)},
              {\({0.9700000000000006`, \(-31.099254135378416`\)}\)},
              {\({0.9800000000000006`, \(-32.14251991822436`\)}\)},
              {\({0.9900000000000007`, \(-32.89633236313147`\)}\)},
              {\({1.0000000000000007`, \(-33.66362817447572`\)}\)},
              {\({1.0100000000000007`, \(-34.44261838290051`\)}\)},
              {\({1.0200000000000007`, \(-35.216788009171545`\)}\)},
              {\({1.0300000000000007`, \(-35.98608101760055`\)}\)},
              {\({1.0400000000000007`, \(-36.750527675575384`\)}\)},
              {\({1.0500000000000007`, \(-37.51015851150112`\)}\)},
              {\({1.0600000000000007`, \(-38.26500386383526`\)}\)},
              {\({1.0700000000000007`, \(-39.015093879923185`\)}\)},
              {\({1.0800000000000007`, \(-39.760458517189676`\)}\)},
              {\({1.0900000000000007`, \(-40.50112754433513`\)}\)},
              {\({1.1000000000000008`, \(-41.23713054252458`\)}\)},
              {\({1.1100000000000008`, \(-41.96849690656937`\)}\)},
              {\({1.1200000000000008`, \(-42.695255846100736`\)}\)},
              {\({1.1300000000000008`, \(-43.417436386736654`\)}\)},
              {\({1.1400000000000008`, \(-44.13506737124079`\)}\)},
              {\({1.1500000000000008`, \(-44.84817746067487`\)}\)},
              {\({1.1600000000000008`, \(-45.55679513554315`\)}\)},
              {\({1.1700000000000008`, \(-46.26094869692963`\)}\)},
              {\({1.1800000000000008`, \(-46.96066626762872`\)}\)},
              {\({1.1900000000000008`, \(-47.655975793268176`\)}\)},
              {\({1.2000000000000008`, \(-48.34690504342575`\)}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 
            0}, {.01, .0032806483092515906}, {.02, .026233371229252685}, \
{.029999999999999999, .068758379092821759}, {.040000000000000001, \
.13059872679697854}, {.050000000000000003, .21142183034631656}, \
{.060000000000000005, .31082151848825434}, {.070000000000000007, \
.42831997653388887}, {.080000000000000002, .56336996285287655}, \
{.089999999999999997, .7153572899345787}, {.099999999999999992, \
.8836035590048037}, {.10999999999999999, 
            1.0673691362252078}, {.11999999999999998, 
            1.2658563576011266}, {.12999999999999998, 
            1.4782129488774005}, {.13999999999999999, 
            1.7035356459136961}, {.14999999999999999, 
            1.9408740003037295}, {.16, 
            2.1892343543393085}, {.17000000000000001, 
            2.4475839688225336}, {.18000000000000002, 
            2.7148552866998585}, {.19000000000000003, 
            2.9899503150319835}, {.20000000000000004, 
            3.2717451074248891}, {.21000000000000005, 
            3.5590943287313102}, {.22000000000000006, 
            3.8508358835893026}, {.23000000000000007, 
            4.1457955901958528}, {.24000000000000007, 
            4.4427918806192981}, {.25000000000000006, 
            4.7406405089343933}, {.26000000000000006, 
            5.0381592485180704}, {.27000000000000007, 
            5.3341725599718668}, {.28000000000000008, 
            5.6275162113375989}, {.29000000000000009, 
            5.9170418325449869}, {.3000000000000001, 
            6.2016213863722403}, {.31000000000000011, 
            6.4735902419934535}, {.32000000000000012, 
            6.6990911681531982}, {.33000000000000013, 
            6.8772824397154775}, {.34000000000000014, 
            7.0076736856271893}, {.35000000000000014, 
            7.0899666602411546}, {.36000000000000015, 
            7.1240547655350124}, {.37000000000000016, 
            7.11002259650936}, {.38000000000000017, 
            7.0481447360829144}, {.39000000000000018, 
            6.9388838038642362}, {.40000000000000019, 
            6.7828877698971537}, {.4100000000000002, 
            6.5809865473536124}, {.42000000000000021, 
            6.4337063561885746}, {.43000000000000022, 
            6.7442718344983774}, {.44000000000000022, 
            7.0355632498128351}, {.45000000000000023, 
            7.3052097703738763}, {.46000000000000024, 
            7.5533346560237362}, {.47000000000000025, 
            7.7800734188285396}, {.48000000000000026, 
            7.9855607856323534}, {.49000000000000027, 
            8.1699306348937579}, {.50000000000000022, 
            8.3333160016725287}, {.51000000000000023, 
            8.4725626124847935}, {.52000000000000024, 
            8.5713729117399264}, {.53000000000000025, 
            8.6299151902006415}, {.54000000000000026, 
            8.648442671980126}, {.55000000000000027, 
            8.6272074378658914}, {.56000000000000028, 
            8.5664599829746955}, {.57000000000000028, 
            8.4664492243792786}, {.58000000000000029, 
            8.3274225110375717}, {.5900000000000003, 
            8.1496256336711621}, {.60000000000000031, 
            7.9333028345816494}, {.61000000000000032, 
            7.6819832878618879}, {.62000000000000033, 
            7.4123370879315207}, {.63000000000000034, 
            7.1245661359556696}, {.64000000000000035, 
            6.8187850676329544}, {.65000000000000036, 
            6.4951073445631931}, {.66000000000000036, 
            6.1536457111916114}, {.67000000000000037, 
            5.7945122016891126}, {.68000000000000038, 
            5.4178181444396323}, {.69000000000000039, 
            5.0236741664862112}, {.7000000000000004, 
            4.6121901979490811}, {.71000000000000041, 
            4.1834754764163842}, {.72000000000000042, 
            3.7376385513070529}, {.73000000000000043, 
            3.2747872882055225}, {.74000000000000044, 
            2.7950288731704953}, {.75000000000000044, 
            2.2984698170153788}, {.76000000000000045, 
            1.7852159595619661}, {.77000000000000046, 
            1.2553724738678644}, {.78000000000000047, .70904387042694195}, \
{.79000000000000048, .14633400134314181}, {.80000000000000049, \
-.6839560222258243}, {.8100000000000005, -2.7855819244314564}, \
{.82000000000000051, -4.8925742652526365}, {.83000000000000052, \
-6.990429752945297}, {.84000000000000052, -9.0708603183787258}, \
{.85000000000000053, -11.12571455854671}, {.86000000000000054, \
-13.146979512003359}, {.87000000000000055, -15.126811582932007}, \
{.88000000000000056, -17.057566800154326}, {.89000000000000057, \
-18.931830149347082}, {.90000000000000058, -20.742443865928387}, \
{.91000000000000059, -22.482534581411116}, {.9200000000000006, \
-24.145539221045805}, {.9300000000000006, -25.725229555982761}, \
{.94000000000000061, -27.215735318944525}, {.95000000000000062, \
-28.611565798499178}, {.96000000000000063, -29.907629833429286}, \
{.97000000000000064, -31.099254135378416}, {.98000000000000065, \
-32.142519918224359}, {.99000000000000066, -32.896332363131471}, {
            1.0000000000000007, -33.663628174475718}, {
            1.0100000000000007, -34.442618382900513}, {
            1.0200000000000007, -35.216788009171545}, {
            1.0300000000000007, -35.986081017600547}, {
            1.0400000000000007, -36.750527675575384}, {
            1.0500000000000007, -37.510158511501118}, {
            1.0600000000000007, -38.265003863835261}, {
            1.0700000000000007, -39.015093879923185}, {
            1.0800000000000007, -39.760458517189676}, {
            1.0900000000000007, -40.501127544335127}, {
            1.1000000000000008, -41.237130542524582}, {
            1.1100000000000008, -41.968496906569371}, {
            1.1200000000000008, -42.695255846100736}, {
            1.1300000000000008, -43.417436386736654}, {
            1.1400000000000008, -44.135067371240787}, {
            1.1500000000000008, -44.848177460674869}, {
            1.1600000000000008, -45.556795135543148}, {
            1.1700000000000008, -46.260948696929631}, {
            1.1800000000000008, -46.960666267628717}, {
            1.1900000000000008, -47.655975793268176}, {
            1.2000000000000008, -48.34690504342575}}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {\({0, 0.`}\)},
              {\({0.01`, 1.968388985157277`}\)},
              {\({0.02`, 3.929688825822011`}\)},
              {\({0.03`, 5.866560588644024`}\)},
              {\({0.04`, 7.771405678892982`}\)},
              {\({0.05`, 9.63683373476482`}\)},
              {\({0.060000000000000005`, 11.455644210974803`}\)},
              {\({0.07`, 13.220853772153646`}\)},
              {\({0.08`, 14.925722930283357`}\)},
              {\({0.09`, 16.563781597276915`}\)},
              {\({0.09999999999999999`, 18.12885345543745`}\)},
              {\({0.10999999999999999`, 19.61507905475807`}\)},
              {\({0.11999999999999998`, 21.016937551480652`}\)},
              {\({0.12999999999999998`, 22.32926700809864`}\)},
              {\({0.13999999999999999`, 23.547283181040598`}\)},
              {\({0.15`, 24.666596728593163`}\)},
              {\({0.16`, 25.68322877817843`}\)},
              {\({0.17`, 26.593624798860844`}\)},
              {\({0.18000000000000002`, 27.39466673193033`}\)},
              {\({0.19000000000000003`, 28.083683339485788`}\)},
              {\({0.20000000000000004`, 28.658458738199442`}\)},
              {\({0.21000000000000005`, 29.11723909276361`}\)},
              {\({0.22000000000000006`, 29.45873745090921`}\)},
              {\({0.23000000000000007`, 29.68213670933949`}\)},
              {\({0.24000000000000007`, 29.78709070734874`}\)},
              {\({0.25000000000000006`, 29.773723452316062`}\)},
              {\({0.26000000000000006`, 29.642626488652354`}\)},
              {\({0.2700000000000001`, 29.394854429065617`}\)},
              {\({0.2800000000000001`, 29.031918674184`}\)},
              {\({0.2900000000000001`, 28.55577935360793`}\)},
              {\({0.3000000000000001`, 27.96883552842951`}\)},
              {\({0.3100000000000001`, 23.337135731506123`}\)},
              {\({0.3200000000000001`, 18.61487703926059`}\)},
              {\({0.3300000000000001`, 13.8403777420192`}\)},
              {\({0.34000000000000014`, 9.032858837892718`}\)},
              {\({0.35000000000000014`, 4.2114905798798645`}\)},
              {\({0.36000000000000015`, \(-0.6045897221220002`\)}\)},
              {\({0.37000000000000016`, \(-5.396352803822992`\)}\)},
              {\({0.38000000000000017`, \(-10.144952235802748`\)}\)},
              {\({0.3900000000000002`, \(-14.83179815125527`\)}\)},
              {\({0.4000000000000002`, \(-19.43862962305161`\)}\)},
              {\({0.4100000000000002`, \(-23.94758540996554`\)}\)},
              {\({0.4200000000000002`, 31.36981233974211`}\)},
              {\({0.4300000000000002`, 29.49022528754699`}\)},
              {\({0.4400000000000002`, 27.323722751372543`}\)},
              {\({0.45000000000000023`, 25.169298580192617`}\)},
              {\({0.46000000000000024`, 23.02843848938096`}\)},
              {\({0.47000000000000025`, 20.9010652364027`}\)},
              {\({0.48000000000000026`, 18.787093900697755`}\)},
              {\({0.49000000000000027`, 16.68644005377405`}\)},
              {\({0.5000000000000002`, 14.599019798809877`}\)},
              {\({0.5100000000000002`, 10.552867494118345`}\)},
              {\({0.5200000000000002`, 6.5218420832950414`}\)},
              {\({0.5300000000000002`, 2.5161566607548593`}\)},
              {\({0.5400000000000003`, \(-1.464294235286843`\)}\)},
              {\({0.5500000000000003`, \(-5.419669291315358`\)}\)},
              {\({0.5600000000000003`, \(-9.350126477354252`\)}\)},
              {\({0.5700000000000003`, \(-13.255822769697943`\)}\)},
              {\({0.5800000000000003`, \(-17.136914155757495`\)}\)},
              {\({0.5900000000000003`, \(-20.993555640287013`\)}\)},
              {\({0.6000000000000003`, \(-24.825901251505684`\)}\)},
              {\({0.6100000000000003`, \(-26.66222177396162`\)}\)},
              {\({0.6200000000000003`, \(-28.476611088049594`\)}\)},
              {\({0.6300000000000003`, \(-30.279515744902255`\)}\)},
              {\({0.6400000000000003`, \(-32.07106226875953`\)}\)},
              {\({0.6500000000000004`, \(-33.85132249770345`\)}\)},
              {\({0.6600000000000004`, \(-35.620367534077786`\)}\)},
              {\({0.6700000000000004`, \(-37.37826803075859`\)}\)},
              {\({0.6800000000000004`, \(-39.1250941955459`\)}\)},
              {\({0.6900000000000004`, \(-40.86091579397612`\)}\)},
              {\({0.7000000000000004`, \(-42.585802152052565`\)}\)},
              {\({0.7100000000000004`, \(-44.29982215901225`\)}\)},
              {\({0.7200000000000004`, \(-46.00304427019694`\)}\)},
              {\({0.7300000000000004`, \(-47.69553650959517`\)}\)},
              {\({0.7400000000000004`, \(-49.3773664727039`\)}\)},
              {\({0.7500000000000004`, \(-51.04860132921647`\)}\)},
              {\({0.7600000000000005`, \(-52.709307825633175`\)}\)},
              {\({0.7700000000000005`, \(-54.35955228796513`\)}\)},
              {\({0.7800000000000005`, \(-55.99940062439987`\)}\)},
              {\({0.7900000000000005`, \(-57.62891832795481`\)}\)},
              {\({0.8000000000000005`, \(-210.02942247112554`\)}\)},
              {\({0.8100000000000005`, \(-210.82842896759195`\)}\)},
              {\({0.8200000000000005`, \(-210.0532596549034`\)}\)},
              {\({0.8300000000000005`, \(-208.4469943414001`\)}\)},
              {\({0.8400000000000005`, \(-206.0233675535419`\)}\)},
              {\({0.8500000000000005`, \(-202.79570633372714`\)}\)},
              {\({0.8600000000000005`, \(-198.78044040615578`\)}\)},
              {\({0.8700000000000006`, \(-193.99704052736615`\)}\)},
              {\({0.8800000000000006`, \(-188.4679276976667`\)}\)},
              {\({0.8900000000000006`, \(-182.2183710285699`\)}\)},
              {\({0.9000000000000006`, \(-175.27637480732346`\)}\)},
              {\({0.9100000000000006`, \(-167.6725552545431`\)}\)},
              {\({0.9200000000000006`, \(-159.44000750974647`\)}\)},
              {\({0.9300000000000006`, \(-150.61416341520635`\)}\)},
              {\({0.9400000000000006`, \(-141.23264070290497`\)}\)},
              {\({0.9500000000000006`, \(-131.33508422024715`\)}\)},
              {\({0.9600000000000006`, \(-120.96299985890346`\)}\)},
              {\({0.9700000000000006`, \(-110.15958187712204`\)}\)},
              {\({0.9800000000000006`, \(-75.16156032895378`\)}\)},
              {\({0.9900000000000007`, \(-76.47966529923724`\)}\)},
              {\({1.0000000000000007`, \(-77.97916031006298`\)}\)},
              {\({1.0100000000000007`, \(-77.49832350465931`\)}\)},
              {\({1.0200000000000007`, \(-77.01015823942362`\)}\)},
              {\({1.0300000000000007`, \(-76.52501386038148`\)}\)},
              {\({1.0400000000000007`, \(-76.04292548309331`\)}\)},
              {\({1.0500000000000007`, \(-75.56387414006713`\)}\)},
              {\({1.0600000000000007`, \(-75.08784070024649`\)}\)},
              {\({1.0700000000000007`, \(-74.6148061516169`\)}\)},
              {\({1.0800000000000007`, \(-74.1447516019025`\)}\)},
              {\({1.0900000000000007`, \(-73.67765827785115`\)}\)},
              {\({1.1000000000000008`, \(-73.21350752451144`\)}\)},
              {\({1.1100000000000008`, \(-72.75228080440684`\)}\)},
              {\({1.1200000000000008`, \(-72.29395969687721`\)}\)},
              {\({1.1300000000000008`, \(-71.83852589725939`\)}\)},
              {\({1.1400000000000008`, \(-71.38596121627052`\)}\)},
              {\({1.1500000000000008`, \(-70.9362475791877`\)}\)},
              {\({1.1600000000000008`, \(-70.48936702512037`\)}\)},
              {\({1.1700000000000008`, \(-70.04530170637736`\)}\)},
              {\({1.1800000000000008`, \(-69.60403388765735`\)}\)},
              {\({1.1900000000000008`, \(-69.16554594547779`\)}\)},
              {\({1.2000000000000008`, \(-68.72982036723624`\)}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 0.0}, {.01, 1.9683889851572769}, {.02, 
            3.9296888258220108}, {.029999999999999999, 
            5.866560588644024}, {.040000000000000001, 
            7.7714056788929824}, {.050000000000000003, 
            9.6368337347648207}, {.060000000000000005, 
            11.455644210974803}, {.070000000000000007, 
            13.220853772153646}, {.080000000000000002, 
            14.925722930283357}, {.089999999999999997, 
            16.563781597276915}, {.099999999999999992, 
            18.128853455437451}, {.10999999999999999, 
            19.61507905475807}, {.11999999999999998, 
            21.016937551480652}, {.12999999999999998, 
            22.32926700809864}, {.13999999999999999, 
            23.547283181040598}, {.14999999999999999, 
            24.666596728593163}, {.16, 
            25.683228778178432}, {.17000000000000001, 
            26.593624798860844}, {.18000000000000002, 
            27.394666731930329}, {.19000000000000003, 
            28.083683339485788}, {.20000000000000004, 
            28.658458738199442}, {.21000000000000005, 
            29.117239092763612}, {.22000000000000006, 
            29.458737450909211}, {.23000000000000007, 
            29.682136709339488}, {.24000000000000007, 
            29.787090707348739}, {.25000000000000006, 
            29.773723452316062}, {.26000000000000006, 
            29.642626488652354}, {.27000000000000007, 
            29.394854429065617}, {.28000000000000008, 
            29.031918674183999}, {.29000000000000009, 
            28.555779353607932}, {.3000000000000001, 
            27.968835528429508}, {.31000000000000011, 
            23.337135731506123}, {.32000000000000012, 
            18.614877039260591}, {.33000000000000013, 
            13.8403777420192}, {.34000000000000014, 
            9.0328588378927179}, {.35000000000000014, 
            4.2114905798798645}, {.36000000000000015, -.60458972212200024}, \
{.37000000000000016, -5.3963528038229924}, {.38000000000000017, \
-10.144952235802748}, {.39000000000000018, -14.831798151255271}, \
{.40000000000000019, -19.438629623051611}, {.4100000000000002, \
-23.947585409965541}, {.42000000000000021, 
            31.369812339742111}, {.43000000000000022, 
            29.490225287546991}, {.44000000000000022, 
            27.323722751372543}, {.45000000000000023, 
            25.169298580192617}, {.46000000000000024, 
            23.02843848938096}, {.47000000000000025, 
            20.901065236402701}, {.48000000000000026, 
            18.787093900697755}, {.49000000000000027, 
            16.686440053774049}, {.50000000000000022, 
            14.599019798809877}, {.51000000000000023, 
            10.552867494118345}, {.52000000000000024, 
            6.5218420832950414}, {.53000000000000025, 
            
            2.5161566607548593}, {.54000000000000026, -1.4642942352868431}, \
{.55000000000000027, -5.4196692913153584}, {.56000000000000028, \
-9.3501264773542516}, {.57000000000000028, -13.255822769697943}, \
{.58000000000000029, -17.136914155757495}, {.5900000000000003, \
-20.993555640287013}, {.60000000000000031, -24.825901251505684}, \
{.61000000000000032, -26.662221773961619}, {.62000000000000033, \
-28.476611088049594}, {.63000000000000034, -30.279515744902255}, \
{.64000000000000035, -32.071062268759533}, {.65000000000000036, \
-33.85132249770345}, {.66000000000000036, -35.620367534077786}, \
{.67000000000000037, -37.378268030758591}, {.68000000000000038, \
-39.125094195545898}, {.69000000000000039, -40.860915793976119}, \
{.7000000000000004, -42.585802152052565}, {.71000000000000041, \
-44.299822159012251}, {.72000000000000042, -46.003044270196938}, \
{.73000000000000043, -47.695536509595172}, {.74000000000000044, \
-49.377366472703898}, {.75000000000000044, -51.048601329216467}, \
{.76000000000000045, -52.709307825633175}, {.77000000000000046, \
-54.35955228796513}, {.78000000000000047, -55.999400624399868}, \
{.79000000000000048, -57.628918327954807}, {.80000000000000049, \
-210.02942247112554}, {.8100000000000005, -210.82842896759195}, \
{.82000000000000051, -210.0532596549034}, {.83000000000000052, \
-208.44699434140011}, {.84000000000000052, -206.0233675535419}, \
{.85000000000000053, -202.79570633372714}, {.86000000000000054, \
-198.78044040615578}, {.87000000000000055, -193.99704052736615}, \
{.88000000000000056, -188.46792769766671}, {.89000000000000057, \
-182.21837102856989}, {.90000000000000058, -175.27637480732346}, \
{.91000000000000059, -167.67255525454311}, {.9200000000000006, \
-159.44000750974647}, {.9300000000000006, -150.61416341520635}, \
{.94000000000000061, -141.23264070290497}, {.95000000000000062, \
-131.33508422024715}, {.96000000000000063, -120.96299985890346}, \
{.97000000000000064, -110.15958187712204}, {.98000000000000065, \
-75.161560328953783}, {.99000000000000066, -76.47966529923724}, {
            1.0000000000000007, -77.97916031006298}, {
            1.0100000000000007, -77.498323504659311}, {
            1.0200000000000007, -77.010158239423617}, {
            1.0300000000000007, -76.525013860381478}, {
            1.0400000000000007, -76.042925483093313}, {
            1.0500000000000007, -75.563874140067128}, {
            1.0600000000000007, -75.087840700246488}, {
            1.0700000000000007, -74.614806151616904}, {
            1.0800000000000007, -74.144751601902499}, {
            1.0900000000000007, -73.677658277851151}, {
            1.1000000000000008, -73.213507524511442}, {
            1.1100000000000008, -72.752280804406837}, {
            1.1200000000000008, -72.293959696877209}, {
            1.1300000000000008, -71.838525897259387}, {
            1.1400000000000008, -71.385961216270516}, {
            1.1500000000000008, -70.936247579187693}, {
            1.1600000000000008, -70.489367025120373}, {
            1.1700000000000008, -70.045301706377359}, {
            1.1800000000000008, -69.604033887657351}, {
            1.1900000000000008, -69.165545945477788}, {
            1.2000000000000008, -68.729820367236243}}],
          Editable->False], "\[InvisibleSpace]", "\<\"  \"\>", 
        "\[InvisibleSpace]", 
        InterpretationBox[GridBox[{
              {\({0, 10}\)},
              {\({0.01`, 10}\)},
              {\({0.02`, 10}\)},
              {\({0.03`, 10}\)},
              {\({0.04`, 10}\)},
              {\({0.05`, 10}\)},
              {\({0.060000000000000005`, 10}\)},
              {\({0.07`, 10}\)},
              {\({0.08`, 10}\)},
              {\({0.09`, 10}\)},
              {\({0.09999999999999999`, 10}\)},
              {\({0.10999999999999999`, 10}\)},
              {\({0.11999999999999998`, 10}\)},
              {\({0.12999999999999998`, 10}\)},
              {\({0.13999999999999999`, 10}\)},
              {\({0.15`, 10}\)},
              {\({0.16`, 10}\)},
              {\({0.17`, 10}\)},
              {\({0.18000000000000002`, 10}\)},
              {\({0.19000000000000003`, 10}\)},
              {\({0.20000000000000004`, 10}\)},
              {\({0.21000000000000005`, 10}\)},
              {\({0.22000000000000006`, 10}\)},
              {\({0.23000000000000007`, 10}\)},
              {\({0.24000000000000007`, 10}\)},
              {\({0.25000000000000006`, 10}\)},
              {\({0.26000000000000006`, 10}\)},
              {\({0.2700000000000001`, 10}\)},
              {\({0.2800000000000001`, 10}\)},
              {\({0.2900000000000001`, 10}\)},
              {\({0.3000000000000001`, 10}\)},
              {\({0.3100000000000001`, 10}\)},
              {\({0.3200000000000001`, 10}\)},
              {\({0.3300000000000001`, 10}\)},
              {\({0.34000000000000014`, 10}\)},
              {\({0.35000000000000014`, 10}\)},
              {\({0.36000000000000015`, 10}\)},
              {\({0.37000000000000016`, 10}\)},
              {\({0.38000000000000017`, 10}\)},
              {\({0.3900000000000002`, 10}\)},
              {\({0.4000000000000002`, 10}\)},
              {\({0.4100000000000002`, 10}\)},
              {\({0.4200000000000002`, 0}\)},
              {\({0.4300000000000002`, 0}\)},
              {\({0.4400000000000002`, 0}\)},
              {\({0.45000000000000023`, 0}\)},
              {\({0.46000000000000024`, 0}\)},
              {\({0.47000000000000025`, 0}\)},
              {\({0.48000000000000026`, 0}\)},
              {\({0.49000000000000027`, 0}\)},
              {\({0.5000000000000002`, 0}\)},
              {\({0.5100000000000002`, 0}\)},
              {\({0.5200000000000002`, 0}\)},
              {\({0.5300000000000002`, 0}\)},
              {\({0.5400000000000003`, 0}\)},
              {\({0.5500000000000003`, 0}\)},
              {\({0.5600000000000003`, 0}\)},
              {\({0.5700000000000003`, 0}\)},
              {\({0.5800000000000003`, 0}\)},
              {\({0.5900000000000003`, 0}\)},
              {\({0.6000000000000003`, 0}\)},
              {\({0.6100000000000003`, 0}\)},
              {\({0.6200000000000003`, 0}\)},
              {\({0.6300000000000003`, 0}\)},
              {\({0.6400000000000003`, 0}\)},
              {\({0.6500000000000004`, 0}\)},
              {\({0.6600000000000004`, 0}\)},
              {\({0.6700000000000004`, 0}\)},
              {\({0.6800000000000004`, 0}\)},
              {\({0.6900000000000004`, 0}\)},
              {\({0.7000000000000004`, 0}\)},
              {\({0.7100000000000004`, 0}\)},
              {\({0.7200000000000004`, 0}\)},
              {\({0.7300000000000004`, 0}\)},
              {\({0.7400000000000004`, 0}\)},
              {\({0.7500000000000004`, 0}\)},
              {\({0.7600000000000005`, 0}\)},
              {\({0.7700000000000005`, 0}\)},
              {\({0.7800000000000005`, 0}\)},
              {\({0.7900000000000005`, 0}\)},
              {\({0.8000000000000005`, 10}\)},
              {\({0.8100000000000005`, 10}\)},
              {\({0.8200000000000005`, 10}\)},
              {\({0.8300000000000005`, 10}\)},
              {\({0.8400000000000005`, 10}\)},
              {\({0.8500000000000005`, 10}\)},
              {\({0.8600000000000005`, 10}\)},
              {\({0.8700000000000006`, 10}\)},
              {\({0.8800000000000006`, 10}\)},
              {\({0.8900000000000006`, 10}\)},
              {\({0.9000000000000006`, 10}\)},
              {\({0.9100000000000006`, 10}\)},
              {\({0.9200000000000006`, 10}\)},
              {\({0.9300000000000006`, 10}\)},
              {\({0.9400000000000006`, 10}\)},
              {\({0.9500000000000006`, 10}\)},
              {\({0.9600000000000006`, 10}\)},
              {\({0.9700000000000006`, 10}\)},
              {\({0.9800000000000006`, 0}\)},
              {\({0.9900000000000007`, 0}\)},
              {\({1.0000000000000007`, 0}\)},
              {\({1.0100000000000007`, 0}\)},
              {\({1.0200000000000007`, 0}\)},
              {\({1.0300000000000007`, 0}\)},
              {\({1.0400000000000007`, 0}\)},
              {\({1.0500000000000007`, 0}\)},
              {\({1.0600000000000007`, 0}\)},
              {\({1.0700000000000007`, 0}\)},
              {\({1.0800000000000007`, 0}\)},
              {\({1.0900000000000007`, 0}\)},
              {\({1.1000000000000008`, 0}\)},
              {\({1.1100000000000008`, 0}\)},
              {\({1.1200000000000008`, 0}\)},
              {\({1.1300000000000008`, 0}\)},
              {\({1.1400000000000008`, 0}\)},
              {\({1.1500000000000008`, 0}\)},
              {\({1.1600000000000008`, 0}\)},
              {\({1.1700000000000008`, 0}\)},
              {\({1.1800000000000008`, 0}\)},
              {\({1.1900000000000008`, 0}\)},
              {\({1.2000000000000008`, 0}\)}
              },
            GridBaseline->{Baseline, {1, 1}},
            ColumnAlignments->{Left}],
          
          ColumnForm[ {{0, 10}, {.01, 10}, {.02, 10}, {.029999999999999999, 
            10}, {.040000000000000001, 10}, {.050000000000000003, 
            10}, {.060000000000000005, 10}, {.070000000000000007, 
            10}, {.080000000000000002, 10}, {.089999999999999997, 
            10}, {.099999999999999992, 10}, {.10999999999999999, 
            10}, {.11999999999999998, 10}, {.12999999999999998, 
            10}, {.13999999999999999, 10}, {.14999999999999999, 10}, {.16, 
            10}, {.17000000000000001, 10}, {.18000000000000002, 
            10}, {.19000000000000003, 10}, {.20000000000000004, 
            10}, {.21000000000000005, 10}, {.22000000000000006, 
            10}, {.23000000000000007, 10}, {.24000000000000007, 
            10}, {.25000000000000006, 10}, {.26000000000000006, 
            10}, {.27000000000000007, 10}, {.28000000000000008, 
            10}, {.29000000000000009, 10}, {.3000000000000001, 
            10}, {.31000000000000011, 10}, {.32000000000000012, 
            10}, {.33000000000000013, 10}, {.34000000000000014, 
            10}, {.35000000000000014, 10}, {.36000000000000015, 
            10}, {.37000000000000016, 10}, {.38000000000000017, 
            10}, {.39000000000000018, 10}, {.40000000000000019, 
            10}, {.4100000000000002, 10}, {.42000000000000021, 
            0}, {.43000000000000022, 0}, {.44000000000000022, 
            0}, {.45000000000000023, 0}, {.46000000000000024, 
            0}, {.47000000000000025, 0}, {.48000000000000026, 
            0}, {.49000000000000027, 0}, {.50000000000000022, 
            0}, {.51000000000000023, 0}, {.52000000000000024, 
            0}, {.53000000000000025, 0}, {.54000000000000026, 
            0}, {.55000000000000027, 0}, {.56000000000000028, 
            0}, {.57000000000000028, 0}, {.58000000000000029, 
            0}, {.5900000000000003, 0}, {.60000000000000031, 
            0}, {.61000000000000032, 0}, {.62000000000000033, 
            0}, {.63000000000000034, 0}, {.64000000000000035, 
            0}, {.65000000000000036, 0}, {.66000000000000036, 
            0}, {.67000000000000037, 0}, {.68000000000000038, 
            0}, {.69000000000000039, 0}, {.7000000000000004, 
            0}, {.71000000000000041, 0}, {.72000000000000042, 
            0}, {.73000000000000043, 0}, {.74000000000000044, 
            0}, {.75000000000000044, 0}, {.76000000000000045, 
            0}, {.77000000000000046, 0}, {.78000000000000047, 
            0}, {.79000000000000048, 0}, {.80000000000000049, 
            10}, {.8100000000000005, 10}, {.82000000000000051, 
            10}, {.83000000000000052, 10}, {.84000000000000052, 
            10}, {.85000000000000053, 10}, {.86000000000000054, 
            10}, {.87000000000000055, 10}, {.88000000000000056, 
            10}, {.89000000000000057, 10}, {.90000000000000058, 
            10}, {.91000000000000059, 10}, {.9200000000000006, 
            10}, {.9300000000000006, 10}, {.94000000000000061, 
            10}, {.95000000000000062, 10}, {.96000000000000063, 
            10}, {.97000000000000064, 10}, {.98000000000000065, 
            0}, {.99000000000000066, 0}, {1.0000000000000007, 0}, {
            1.0100000000000007, 0}, {1.0200000000000007, 0}, {
            1.0300000000000007, 0}, {1.0400000000000007, 0}, {
            1.0500000000000007, 0}, {1.0600000000000007, 0}, {
            1.0700000000000007, 0}, {1.0800000000000007, 0}, {
            1.0900000000000007, 0}, {1.1000000000000008, 0}, {
            1.1100000000000008, 0}, {1.1200000000000008, 0}, {
            1.1300000000000008, 0}, {1.1400000000000008, 0}, {
            1.1500000000000008, 0}, {1.1600000000000008, 0}, {
            1.1700000000000008, 0}, {1.1800000000000008, 0}, {
            1.1900000000000008, 0}, {1.2000000000000008, 0}}],
          Editable->False]}],
      SequenceForm[ 
        ColumnForm[ {{0, 0.0}, {.01, .49999999999999911}, {.02, 
          1.0}, {.029999999999999999, 
          1.4999999999999996}, {.040000000000000001, 
          1.9999999999999996}, {.050000000000000003, 
          2.5}, {.060000000000000005, 3.0}, {.070000000000000007, 
          3.5}, {.080000000000000002, 4.0}, {.089999999999999997, 
          4.5}, {.099999999999999992, 
          4.9999999999999991}, {.10999999999999999, 
          5.4999999999999991}, {.11999999999999998, 
          5.9999999999999982}, {.12999999999999998, 
          6.4999999999999982}, {.13999999999999999, 
          6.9999999999999982}, {.14999999999999999, 7.4999999999999991}, {.16,
           8.0}, {.17000000000000001, 8.5}, {.18000000000000002, 
          9.0}, {.19000000000000003, 
          9.5000000000000018}, {.20000000000000004, .1*^2}, \
{.21000000000000005, 10.500000000000002}, {.22000000000000006, 
          11.000000000000002}, {.23000000000000007, 
          11.500000000000004}, {.24000000000000007, 
          12.000000000000004}, {.25000000000000006, 
          12.500000000000004}, {.26000000000000006, 
          13.000000000000004}, {.27000000000000007, 
          13.500000000000004}, {.28000000000000008, 
          14.000000000000004}, {.29000000000000009, 
          14.500000000000005}, {.3000000000000001, 
          14.999999999999995}, {.31000000000000011, 
          14.499999999999995}, {.32000000000000012, 
          13.999999999999993}, {.33000000000000013, 
          13.499999999999993}, {.34000000000000014, 
          12.999999999999993}, {.35000000000000014, 
          12.499999999999993}, {.36000000000000015, 
          11.999999999999993}, {.37000000000000016, 
          11.499999999999993}, {.38000000000000017, 
          10.999999999999993}, {.39000000000000018, 
          10.499999999999993}, {.40000000000000019, 
          9.9999999999999929}, {.4100000000000002, 
          9.4999999999999911}, {.42000000000000021, 
          8.9999999999999911}, {.43000000000000022, 
          8.4999999999999893}, {.44000000000000022, 
          7.9999999999999893}, {.45000000000000023, 
          7.4999999999999893}, {.46000000000000024, 
          6.9999999999999885}, {.47000000000000025, 
          6.4999999999999876}, {.48000000000000026, 
          5.9999999999999876}, {.49000000000000027, 
          5.4999999999999867}, {.50000000000000022, 
          4.9999999999999787}, {.51000000000000023, 
          3.9999999999999769}, {.52000000000000024, 
          2.999999999999976}, {.53000000000000025, 
          1.9999999999999751}, {.54000000000000026, .99999999999997335}, \
{.55000000000000027, -.27533531010703882*^-13}, {.56000000000000028, \
-1.0000000000000284}, {.57000000000000028, -2.0000000000000298}, \
{.58000000000000029, -3.0000000000000311}, {.5900000000000003, \
-4.000000000000032}, {.60000000000000031, -5.0000000000000169}, \
{.61000000000000032, -5.5000000000000169}, {.62000000000000033, \
-6.0000000000000178}, {.63000000000000034, -6.5000000000000187}, \
{.64000000000000035, -7.0000000000000195}, {.65000000000000036, \
-7.5000000000000195}, {.66000000000000036, -8.0000000000000195}, \
{.67000000000000037, -8.5000000000000213}, {.68000000000000038, \
-9.0000000000000213}, {.69000000000000039, -9.5000000000000213}, \
{.7000000000000004, -10.000000000000021}, {.71000000000000041, \
-10.500000000000021}, {.72000000000000042, -11.000000000000021}, \
{.73000000000000043, -11.500000000000021}, {.74000000000000044, \
-12.000000000000021}, {.75000000000000044, -12.500000000000021}, \
{.76000000000000045, -13.000000000000021}, {.77000000000000046, \
-13.500000000000021}, {.78000000000000047, -14.000000000000021}, \
{.79000000000000048, -14.500000000000021}, {.80000000000000049, \
-15.000000000000021}, {.8100000000000005, -15.500000000000021}, \
{.82000000000000051, -16.000000000000021}, {.83000000000000052, \
-16.500000000000025}, {.84000000000000052, -17.000000000000025}, \
{.85000000000000053, -17.500000000000025}, {.86000000000000054, \
-18.000000000000025}, {.87000000000000055, -18.500000000000025}, \
{.88000000000000056, -19.000000000000025}, {.89000000000000057, \
-19.500000000000028}, {.90000000000000058, -20.000000000000028}, \
{.91000000000000059, -20.500000000000028}, {.9200000000000006, \
-21.000000000000028}, {.9300000000000006, -21.500000000000028}, \
{.94000000000000061, -22.000000000000028}, {.95000000000000062, \
-22.500000000000032}, {.96000000000000063, -23.000000000000032}, \
{.97000000000000064, -23.500000000000032}, {.98000000000000065, \
-24.000000000000032}, {.99000000000000066, -24.500000000000032}, {
          1.0000000000000007, -25.0}, {1.0100000000000007, -25.0}, {
          1.0200000000000007, -25.0}, {1.0300000000000007, -25.0}, {
          1.0400000000000007, -25.0}, {1.0500000000000007, -25.0}, {
          1.0600000000000007, -25.0}, {1.0700000000000007, -25.0}, {
          1.0800000000000007, -25.0}, {1.0900000000000007, -25.0}, {
          1.1000000000000008, -25.0}, {1.1100000000000008, -25.0}, {
          1.1200000000000008, -25.0}, {1.1300000000000008, -25.0}, {
          1.1400000000000008, -25.0}, {1.1500000000000008, -25.0}, {
          1.1600000000000008, -25.0}, {1.1700000000000008, -25.0}, {
          1.1800000000000008, -25.0}, {1.1900000000000008, -25.0}, {
          1.2000000000000008, -25.0}}], "  ", 
        ColumnForm[ {{0, 
          0}, {.01, .000098419449257863842}, {.02, .00032771037364148032}, \
{.029999999999999999, .00088337211536620834}, {.040000000000000001, \
.001959526190239075}, {.050000000000000003, .0037473551449471016}, \
{.060000000000000005, .0064343556589590073}, {.070000000000000007, \
.010203613532449233}, {.080000000000000002, .015233099444302289}, \
{.089999999999999997, .0216949881526949}, {.099999999999999992, \
.029755003724812559}, {.10999999999999999, .0395717932675985}, \
{.11999999999999998, .05129633150742461}, {.12999999999999998, \
.065071358433840806}, {.13999999999999999, .08103085208166684}, \
{.14999999999999999, .099299538377233459}, {.16, .11999243981917967}, \
{.17000000000000001, .1432144646025158}, {.18000000000000002, \
.16906003762733765}, {.19000000000000003, .19761277466131053}, \
{.20000000000000004, .22894520074854033}, {.21000000000000005, \
.2631185137774274}, {.22000000000000006, .30018239393728596}, \
{.23000000000000007, .34017485960864596}, {.24000000000000007, \
.38312217004597193}, {.25000000000000006, .42903877502478072}, \
{.26000000000000006, .47792731143855727}, {.27000000000000007, \
.52977864664519125}, {.28000000000000008, .58457196817861912}, \
{.29000000000000009, .6422749192596755}, {.3000000000000001, \
.70284377936154685}, {.31000000000000011, .76602685001184456}, \
{.32000000000000012, .83169349628374212}, {.33000000000000013, \
.89937642685237507}, {.34000000000000014, .96860089419142448}, \
{.35000000000000014, 1.0388882055766904}, {.36000000000000015, 
          1.1097576426929958}, {.37000000000000016, 
          1.1807283727081548}, {.38000000000000017, 
          1.2513213510614583}, {.39000000000000018, 
          1.3210612085147246}, {.40000000000000019, 
          1.3894781150722144}, {.4100000000000002, 
          1.4561096135006877}, {.42000000000000021, 
          1.5234879695912109}, {.43000000000000022, 
          1.589299544417474}, {.44000000000000022, 
          1.6581084489000264}, {.45000000000000023, 
          1.7297225463271644}, {.46000000000000024, 
          1.8039260659553722}, {.47000000000000025, 
          1.8805044657774297}, {.48000000000000026, 
          1.95924455466075}, {.49000000000000027, 
          2.0399344845197622}, {.50000000000000022, 
          2.1223637418586403}, {.51000000000000023, 
          2.2062245452500715}, {.52000000000000024, 
          2.2912762634790842}, {.53000000000000025, 
          2.3771158004295212}, {.54000000000000026, 
          2.4633417376197633}, {.55000000000000027, 
          2.5495551808749988}, {.56000000000000028, 
          2.63535974892979}, {.57000000000000028, 
          2.720361557621052}, {.58000000000000029, 
          2.8041692041570569}, {.5900000000000003, 
          2.8863937514854183}, {.60000000000000031, 
          2.9666487127595547}, {.61000000000000032, 
          3.0446486300166731}, {.62000000000000033, 
          3.1200446323408895}, {.63000000000000034, 
          3.1926540274329596}, {.64000000000000035, 
          3.2622961356790783}, {.65000000000000036, 
          3.3287914202305227}, {.66000000000000036, 
          3.3919614752994507}, {.67000000000000037, 
          3.4516290190098289}, {.68000000000000038, 
          3.5076178863169427}, {.69000000000000039, 
          3.5597530219716402}, {.7000000000000004, 
          3.6078604735288997}, {.71000000000000041, 
          3.6517673844004399}, {.72000000000000042, 
          3.6913019869510939}, {.73000000000000043, 
          3.7262935956386847}, {.74000000000000044, 
          3.7565726001971047}, {.75000000000000044, 
          3.7819704588623488}, {.76000000000000045, 
          3.802319691641221}, {.77000000000000046, 
          3.8174538736224424}, {.78000000000000047, 
          3.827207628329901}, {.79000000000000048, 
          3.8314166211177727}, {.80000000000000049, 
          3.8223784900076478}, {.8100000000000005, 
          3.80499750833701}, {.82000000000000051, 
          3.7666390261099503}, {.83000000000000052, 
          3.7072909337403539}, {.84000000000000052, 
          3.6270854678332238}, {.85000000000000053, 
          3.5262370793327502}, {.86000000000000054, 
          3.4050409117269753}, {.87000000000000055, 
          3.2638712645805734}, {.88000000000000056, 
          3.10317975236637}, {.89000000000000057, 
          2.9234931658133982}, {.90000000000000058, 
          2.7254110455795613}, {.91000000000000059, 
          2.5096029791575503}, {.9200000000000006, 
          2.2768056329679518}, {.9300000000000006, 
          2.0278195325867334}, {.94000000000000061, 
          1.7635056049917606}, {.95000000000000062, 
          1.484781497591303}, {.96000000000000063, 
          1.192617689613366}, {.97000000000000064, .88803341218521703}, \
{.98000000000000065, .57328279281498518}, {.99000000000000066, \
.24803361036777977}, {1.0000000000000007, -.084828671279038079}, {
          1.0100000000000007, -.42533986919902822}, {
          1.0200000000000007, -.77361656094000453}, {
          1.0300000000000007, -1.129610691724739}, {
          1.0400000000000007, -1.4932736481748992}, {
          1.0500000000000007, -1.8645571186376564}, {
          1.0600000000000007, -2.2434130957876799}, {
          1.0700000000000007, -2.6297938747336134}, {
          1.0800000000000007, -3.0236520511129403}, {
          1.0900000000000007, -3.4249405191987297}, {
          1.1000000000000008, -3.8336124700183065}, {
          1.1100000000000008, -4.2496213894837727}, {
          1.1200000000000008, -4.6729210565343102}, {
          1.1300000000000008, -5.1034655412901806}, {
          1.1400000000000008, -5.5412092032183606}, {
          1.1500000000000008, -5.9861066893097279}, {
          1.1600000000000008, -6.4381129322677326}, {
          1.1700000000000008, -6.8971831487084829}, {
          1.1800000000000008, -7.3632728373721621}, {
          1.1900000000000008, -7.8363377773457232}, {
          1.2000000000000008, -8.3163340262967669}}], "  ", 
        ColumnForm[ {{0, 
          0}, {.01, .0032806483092515906}, {.02, .026233371229252685}, \
{.029999999999999999, .068758379092821759}, {.040000000000000001, \
.13059872679697854}, {.050000000000000003, .21142183034631656}, \
{.060000000000000005, .31082151848825434}, {.070000000000000007, \
.42831997653388887}, {.080000000000000002, .56336996285287655}, \
{.089999999999999997, .7153572899345787}, {.099999999999999992, \
.8836035590048037}, {.10999999999999999, 
          1.0673691362252078}, {.11999999999999998, 
          1.2658563576011266}, {.12999999999999998, 
          1.4782129488774005}, {.13999999999999999, 
          1.7035356459136961}, {.14999999999999999, 1.9408740003037295}, {.16,
           2.1892343543393085}, {.17000000000000001, 
          2.4475839688225336}, {.18000000000000002, 
          2.7148552866998585}, {.19000000000000003, 
          2.9899503150319835}, {.20000000000000004, 
          3.2717451074248891}, {.21000000000000005, 
          3.5590943287313102}, {.22000000000000006, 
          3.8508358835893026}, {.23000000000000007, 
          4.1457955901958528}, {.24000000000000007, 
          4.4427918806192981}, {.25000000000000006, 
          4.7406405089343933}, {.26000000000000006, 
          5.0381592485180704}, {.27000000000000007, 
          5.3341725599718668}, {.28000000000000008, 
          5.6275162113375989}, {.29000000000000009, 
          5.9170418325449869}, {.3000000000000001, 
          6.2016213863722403}, {.31000000000000011, 
          6.4735902419934535}, {.32000000000000012, 
          6.6990911681531982}, {.33000000000000013, 
          6.8772824397154775}, {.34000000000000014, 
          7.0076736856271893}, {.35000000000000014, 
          7.0899666602411546}, {.36000000000000015, 
          7.1240547655350124}, {.37000000000000016, 
          7.11002259650936}, {.38000000000000017, 
          7.0481447360829144}, {.39000000000000018, 
          6.9388838038642362}, {.40000000000000019, 
          6.7828877698971537}, {.4100000000000002, 
          6.5809865473536124}, {.42000000000000021, 
          6.4337063561885746}, {.43000000000000022, 
          6.7442718344983774}, {.44000000000000022, 
          7.0355632498128351}, {.45000000000000023, 
          7.3052097703738763}, {.46000000000000024, 
          7.5533346560237362}, {.47000000000000025, 
          7.7800734188285396}, {.48000000000000026, 
          7.9855607856323534}, {.49000000000000027, 
          8.1699306348937579}, {.50000000000000022, 
          8.3333160016725287}, {.51000000000000023, 
          8.4725626124847935}, {.52000000000000024, 
          8.5713729117399264}, {.53000000000000025, 
          8.6299151902006415}, {.54000000000000026, 
          8.648442671980126}, {.55000000000000027, 
          8.6272074378658914}, {.56000000000000028, 
          8.5664599829746955}, {.57000000000000028, 
          8.4664492243792786}, {.58000000000000029, 
          8.3274225110375717}, {.5900000000000003, 
          8.1496256336711621}, {.60000000000000031, 
          7.9333028345816494}, {.61000000000000032, 
          7.6819832878618879}, {.62000000000000033, 
          7.4123370879315207}, {.63000000000000034, 
          7.1245661359556696}, {.64000000000000035, 
          6.8187850676329544}, {.65000000000000036, 
          6.4951073445631931}, {.66000000000000036, 
          6.1536457111916114}, {.67000000000000037, 
          5.7945122016891126}, {.68000000000000038, 
          5.4178181444396323}, {.69000000000000039, 
          5.0236741664862112}, {.7000000000000004, 
          4.6121901979490811}, {.71000000000000041, 
          4.1834754764163842}, {.72000000000000042, 
          3.7376385513070529}, {.73000000000000043, 
          3.2747872882055225}, {.74000000000000044, 
          2.7950288731704953}, {.75000000000000044, 
          2.2984698170153788}, {.76000000000000045, 
          1.7852159595619661}, {.77000000000000046, 
          1.2553724738678644}, {.78000000000000047, .70904387042694195}, \
{.79000000000000048, .14633400134314181}, {.80000000000000049, \
-.6839560222258243}, {.8100000000000005, -2.7855819244314564}, \
{.82000000000000051, -4.8925742652526365}, {.83000000000000052, \
-6.990429752945297}, {.84000000000000052, -9.0708603183787258}, \
{.85000000000000053, -11.12571455854671}, {.86000000000000054, \
-13.146979512003359}, {.87000000000000055, -15.126811582932007}, \
{.88000000000000056, -17.057566800154326}, {.89000000000000057, \
-18.931830149347082}, {.90000000000000058, -20.742443865928387}, \
{.91000000000000059, -22.482534581411116}, {.9200000000000006, \
-24.145539221045805}, {.9300000000000006, -25.725229555982761}, \
{.94000000000000061, -27.215735318944525}, {.95000000000000062, \
-28.611565798499178}, {.96000000000000063, -29.907629833429286}, \
{.97000000000000064, -31.099254135378416}, {.98000000000000065, \
-32.142519918224359}, {.99000000000000066, -32.896332363131471}, {
          1.0000000000000007, -33.663628174475718}, {
          1.0100000000000007, -34.442618382900513}, {
          1.0200000000000007, -35.216788009171545}, {
          1.0300000000000007, -35.986081017600547}, {
          1.0400000000000007, -36.750527675575384}, {
          1.0500000000000007, -37.510158511501118}, {
          1.0600000000000007, -38.265003863835261}, {
          1.0700000000000007, -39.015093879923185}, {
          1.0800000000000007, -39.760458517189676}, {
          1.0900000000000007, -40.501127544335127}, {
          1.1000000000000008, -41.237130542524582}, {
          1.1100000000000008, -41.968496906569371}, {
          1.1200000000000008, -42.695255846100736}, {
          1.1300000000000008, -43.417436386736654}, {
          1.1400000000000008, -44.135067371240787}, {
          1.1500000000000008, -44.848177460674869}, {
          1.1600000000000008, -45.556795135543148}, {
          1.1700000000000008, -46.260948696929631}, {
          1.1800000000000008, -46.960666267628717}, {
          1.1900000000000008, -47.655975793268176}, {
          1.2000000000000008, -48.34690504342575}}], "  ", 
        ColumnForm[ {{0, 0.0}, {.01, 1.9683889851572769}, {.02, 
          3.9296888258220108}, {.029999999999999999, 
          5.866560588644024}, {.040000000000000001, 
          7.7714056788929824}, {.050000000000000003, 
          9.6368337347648207}, {.060000000000000005, 
          11.455644210974803}, {.070000000000000007, 
          13.220853772153646}, {.080000000000000002, 
          14.925722930283357}, {.089999999999999997, 
          16.563781597276915}, {.099999999999999992, 
          18.128853455437451}, {.10999999999999999, 
          19.61507905475807}, {.11999999999999998, 
          21.016937551480652}, {.12999999999999998, 
          22.32926700809864}, {.13999999999999999, 
          23.547283181040598}, {.14999999999999999, 24.666596728593163}, {.16,
           25.683228778178432}, {.17000000000000001, 
          26.593624798860844}, {.18000000000000002, 
          27.394666731930329}, {.19000000000000003, 
          28.083683339485788}, {.20000000000000004, 
          28.658458738199442}, {.21000000000000005, 
          29.117239092763612}, {.22000000000000006, 
          29.458737450909211}, {.23000000000000007, 
          29.682136709339488}, {.24000000000000007, 
          29.787090707348739}, {.25000000000000006, 
          29.773723452316062}, {.26000000000000006, 
          29.642626488652354}, {.27000000000000007, 
          29.394854429065617}, {.28000000000000008, 
          29.031918674183999}, {.29000000000000009, 
          28.555779353607932}, {.3000000000000001, 
          27.968835528429508}, {.31000000000000011, 
          23.337135731506123}, {.32000000000000012, 
          18.614877039260591}, {.33000000000000013, 
          13.8403777420192}, {.34000000000000014, 
          9.0328588378927179}, {.35000000000000014, 
          4.2114905798798645}, {.36000000000000015, -.60458972212200024}, \
{.37000000000000016, -5.3963528038229924}, {.38000000000000017, \
-10.144952235802748}, {.39000000000000018, -14.831798151255271}, \
{.40000000000000019, -19.438629623051611}, {.4100000000000002, \
-23.947585409965541}, {.42000000000000021, 
          31.369812339742111}, {.43000000000000022, 
          29.490225287546991}, {.44000000000000022, 
          27.323722751372543}, {.45000000000000023, 
          25.169298580192617}, {.46000000000000024, 
          23.02843848938096}, {.47000000000000025, 
          20.901065236402701}, {.48000000000000026, 
          18.787093900697755}, {.49000000000000027, 
          16.686440053774049}, {.50000000000000022, 
          14.599019798809877}, {.51000000000000023, 
          10.552867494118345}, {.52000000000000024, 
          6.5218420832950414}, {.53000000000000025, 
          2.5161566607548593}, {.54000000000000026, -1.4642942352868431}, \
{.55000000000000027, -5.4196692913153584}, {.56000000000000028, \
-9.3501264773542516}, {.57000000000000028, -13.255822769697943}, \
{.58000000000000029, -17.136914155757495}, {.5900000000000003, \
-20.993555640287013}, {.60000000000000031, -24.825901251505684}, \
{.61000000000000032, -26.662221773961619}, {.62000000000000033, \
-28.476611088049594}, {.63000000000000034, -30.279515744902255}, \
{.64000000000000035, -32.071062268759533}, {.65000000000000036, \
-33.85132249770345}, {.66000000000000036, -35.620367534077786}, \
{.67000000000000037, -37.378268030758591}, {.68000000000000038, \
-39.125094195545898}, {.69000000000000039, -40.860915793976119}, \
{.7000000000000004, -42.585802152052565}, {.71000000000000041, \
-44.299822159012251}, {.72000000000000042, -46.003044270196938}, \
{.73000000000000043, -47.695536509595172}, {.74000000000000044, \
-49.377366472703898}, {.75000000000000044, -51.048601329216467}, \
{.76000000000000045, -52.709307825633175}, {.77000000000000046, \
-54.35955228796513}, {.78000000000000047, -55.999400624399868}, \
{.79000000000000048, -57.628918327954807}, {.80000000000000049, \
-210.02942247112554}, {.8100000000000005, -210.82842896759195}, \
{.82000000000000051, -210.0532596549034}, {.83000000000000052, \
-208.44699434140011}, {.84000000000000052, -206.0233675535419}, \
{.85000000000000053, -202.79570633372714}, {.86000000000000054, \
-198.78044040615578}, {.87000000000000055, -193.99704052736615}, \
{.88000000000000056, -188.46792769766671}, {.89000000000000057, \
-182.21837102856989}, {.90000000000000058, -175.27637480732346}, \
{.91000000000000059, -167.67255525454311}, {.9200000000000006, \
-159.44000750974647}, {.9300000000000006, -150.61416341520635}, \
{.94000000000000061, -141.23264070290497}, {.95000000000000062, \
-131.33508422024715}, {.96000000000000063, -120.96299985890346}, \
{.97000000000000064, -110.15958187712204}, {.98000000000000065, \
-75.161560328953783}, {.99000000000000066, -76.47966529923724}, {
          1.0000000000000007, -77.97916031006298}, {
          1.0100000000000007, -77.498323504659311}, {
          1.0200000000000007, -77.010158239423617}, {
          1.0300000000000007, -76.525013860381478}, {
          1.0400000000000007, -76.042925483093313}, {
          1.0500000000000007, -75.563874140067128}, {
          1.0600000000000007, -75.087840700246488}, {
          1.0700000000000007, -74.614806151616904}, {
          1.0800000000000007, -74.144751601902499}, {
          1.0900000000000007, -73.677658277851151}, {
          1.1000000000000008, -73.213507524511442}, {
          1.1100000000000008, -72.752280804406837}, {
          1.1200000000000008, -72.293959696877209}, {
          1.1300000000000008, -71.838525897259387}, {
          1.1400000000000008, -71.385961216270516}, {
          1.1500000000000008, -70.936247579187693}, {
          1.1600000000000008, -70.489367025120373}, {
          1.1700000000000008, -70.045301706377359}, {
          1.1800000000000008, -69.604033887657351}, {
          1.1900000000000008, -69.165545945477788}, {
          1.2000000000000008, -68.729820367236243}}], "  ", 
        ColumnForm[ {{0, 10}, {.01, 10}, {.02, 10}, {.029999999999999999, 
          10}, {.040000000000000001, 10}, {.050000000000000003, 
          10}, {.060000000000000005, 10}, {.070000000000000007, 
          10}, {.080000000000000002, 10}, {.089999999999999997, 
          10}, {.099999999999999992, 10}, {.10999999999999999, 
          10}, {.11999999999999998, 10}, {.12999999999999998, 
          10}, {.13999999999999999, 10}, {.14999999999999999, 10}, {.16, 
          10}, {.17000000000000001, 10}, {.18000000000000002, 
          10}, {.19000000000000003, 10}, {.20000000000000004, 
          10}, {.21000000000000005, 10}, {.22000000000000006, 
          10}, {.23000000000000007, 10}, {.24000000000000007, 
          10}, {.25000000000000006, 10}, {.26000000000000006, 
          10}, {.27000000000000007, 10}, {.28000000000000008, 
          10}, {.29000000000000009, 10}, {.3000000000000001, 
          10}, {.31000000000000011, 10}, {.32000000000000012, 
          10}, {.33000000000000013, 10}, {.34000000000000014, 
          10}, {.35000000000000014, 10}, {.36000000000000015, 
          10}, {.37000000000000016, 10}, {.38000000000000017, 
          10}, {.39000000000000018, 10}, {.40000000000000019, 
          10}, {.4100000000000002, 10}, {.42000000000000021, 
          0}, {.43000000000000022, 0}, {.44000000000000022, 
          0}, {.45000000000000023, 0}, {.46000000000000024, 
          0}, {.47000000000000025, 0}, {.48000000000000026, 
          0}, {.49000000000000027, 0}, {.50000000000000022, 
          0}, {.51000000000000023, 0}, {.52000000000000024, 
          0}, {.53000000000000025, 0}, {.54000000000000026, 
          0}, {.55000000000000027, 0}, {.56000000000000028, 
          0}, {.57000000000000028, 0}, {.58000000000000029, 
          0}, {.5900000000000003, 0}, {.60000000000000031, 
          0}, {.61000000000000032, 0}, {.62000000000000033, 
          0}, {.63000000000000034, 0}, {.64000000000000035, 
          0}, {.65000000000000036, 0}, {.66000000000000036, 
          0}, {.67000000000000037, 0}, {.68000000000000038, 
          0}, {.69000000000000039, 0}, {.7000000000000004, 
          0}, {.71000000000000041, 0}, {.72000000000000042, 
          0}, {.73000000000000043, 0}, {.74000000000000044, 
          0}, {.75000000000000044, 0}, {.76000000000000045, 
          0}, {.77000000000000046, 0}, {.78000000000000047, 
          0}, {.79000000000000048, 0}, {.80000000000000049, 
          10}, {.8100000000000005, 10}, {.82000000000000051, 
          10}, {.83000000000000052, 10}, {.84000000000000052, 
          10}, {.85000000000000053, 10}, {.86000000000000054, 
          10}, {.87000000000000055, 10}, {.88000000000000056, 
          10}, {.89000000000000057, 10}, {.90000000000000058, 
          10}, {.91000000000000059, 10}, {.9200000000000006, 
          10}, {.9300000000000006, 10}, {.94000000000000061, 
          10}, {.95000000000000062, 10}, {.96000000000000063, 
          10}, {.97000000000000064, 10}, {.98000000000000065, 
          0}, {.99000000000000066, 0}, {1.0000000000000007, 0}, {
          1.0100000000000007, 0}, {1.0200000000000007, 0}, {
          1.0300000000000007, 0}, {1.0400000000000007, 0}, {
          1.0500000000000007, 0}, {1.0600000000000007, 0}, {
          1.0700000000000007, 0}, {1.0800000000000007, 0}, {
          1.0900000000000007, 0}, {1.1000000000000008, 0}, {
          1.1100000000000008, 0}, {1.1200000000000008, 0}, {
          1.1300000000000008, 0}, {1.1400000000000008, 0}, {
          1.1500000000000008, 0}, {1.1600000000000008, 0}, {
          1.1700000000000008, 0}, {1.1800000000000008, 0}, {
          1.1900000000000008, 0}, {1.2000000000000008, 0}}]],
      Editable->False]], "Print"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{791, 504},
WindowMargins->{{Automatic, 0}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 482, 12, 73, "Input"],
Cell[2202, 63, 21440, 585, 1548, "Input"],
Cell[23645, 650, 19258, 332, 3906, "Input"],

Cell[CellGroupData[{
Cell[42928, 986, 435, 10, 180, "Subsection"],

Cell[CellGroupData[{
Cell[43388, 1000, 236, 3, 90, "Input"],
Cell[43627, 1005, 13891, 494, 186, 6327, 396, "GraphicsData", "PostScript", \
"Graphics"],
Cell[57521, 1501, 129, 3, 25, "Print"],
Cell[57653, 1506, 14182, 496, 186, 6183, 393, "GraphicsData", "PostScript", \
"Graphics"],
Cell[71838, 2004, 129, 3, 25, "Print"],
Cell[71970, 2009, 13150, 440, 186, 5478, 341, "GraphicsData", "PostScript", \
"Graphics"],
Cell[85123, 2451, 129, 3, 25, "Print"],
Cell[85255, 2456, 13607, 464, 186, 5832, 363, "GraphicsData", "PostScript", \
"Graphics"],
Cell[98865, 2922, 129, 3, 25, "Print"],
Cell[98997, 2927, 14236, 489, 186, 6166, 385, "GraphicsData", "PostScript", \
"Graphics"],
Cell[113236, 3418, 129, 3, 25, "Print"],
Cell[113368, 3423, 482, 8, 25, "Print"],
Cell[113853, 3433, 132, 2, 25, "Print"],
Cell[113988, 3437, 77773, 1374, 1624, "Print"]
}, Open  ]]
}, Open  ]],
Cell[191788, 4815, 606, 12, 218, "Subsection"],

Cell[CellGroupData[{
Cell[192419, 4831, 162, 3, 66, "Subsection"],

Cell[CellGroupData[{
Cell[192606, 4838, 445, 8, 110, "Input"],
Cell[193054, 4848, 15772, 526, 186, 6502, 407, "GraphicsData", "PostScript", \
"Graphics"],
Cell[208829, 5376, 129, 3, 25, "Print"],
Cell[208961, 5381, 15089, 509, 186, 6356, 397, "GraphicsData", "PostScript", \
"Graphics"],
Cell[224053, 5892, 129, 3, 25, "Print"],
Cell[224185, 5897, 15841, 535, 186, 6565, 416, "GraphicsData", "PostScript", \
"Graphics"],
Cell[240029, 6434, 129, 3, 25, "Print"],
Cell[240161, 6439, 18049, 590, 186, 7168, 451, "GraphicsData", "PostScript", \
"Graphics"],
Cell[258213, 7031, 129, 3, 25, "Print"],
Cell[258345, 7036, 16680, 555, 186, 6787, 428, "GraphicsData", "PostScript", \
"Graphics"],
Cell[275028, 7593, 129, 3, 25, "Print"],
Cell[275160, 7598, 482, 8, 25, "Print"],
Cell[275645, 7608, 132, 2, 25, "Print"],
Cell[275780, 7612, 92140, 1576, 1947, "Print"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

