(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    115937,       3359]*)
(*NotebookOutlinePosition[    117293,       3397]*)
(*  CellTagsIndexPosition[    117249,       3393]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Transformada de Fourier Discreta", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Definici\[OAcute]n y propiedades b\[AAcute]sicas", \
"Section"]], "Section"],

Cell[TextData[{
  "La Transformada de Fourier Discreta (DFT) de un vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " es el vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Y",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{"\[ScriptCapitalF]", "(", 
              StyleBox["y",
                FontWeight->"Bold"], 
              StyleBox[")",
                FontWeight->"Bold"]}], 
            StyleBox["=",
              FontWeight->"Plain"], \((Y\_0, 
              Y\_1, \(\(...\) \(Y\_\(N - 1\)\)\))\)}]}], TraditionalForm]]],
  " (ambos vectores se consideran en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^N\)]],
  ") cuyas componentes vienen dadas por"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          StyleBox[
            
            FormBox[\(Y\_n = \(1\/N\) \(\[Sum]\+\(k = 0\)\%\(N - \
1\)\(\(y\_k\) \(\[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \[Pi]\ n\ k/
                              N\)\)\(\ \ \ \ \ \ \ \ \ \ \ \ \)\((n = 0, 1, 
                        2,  ... , N - 1)\)\(\ \)\)\)\),
              "TraditionalForm"],
            FontWeight->"Bold"], "                    "}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "Los  ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  " son llamados los ",
  StyleBox["coeficientes espectrales",
    FontSlant->"Italic"],
  " de la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          FontWeight->"Bold"], TraditionalForm]]],
  ". Como las igualdades (1) tienen perfecto sentido para cualquier entero ",
  Cell[BoxData[
      \(TraditionalForm\`n \[Element] \[DoubleStruckCapitalZ]\)]],
  " y, en virtud de la periodicidad de la exponencial compleja, se verifica \
que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(n + N\) = Y\_n\)]],
  ", en la teor\[IAcute]a de la DFT se interpreta siempre la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["Y",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{"\[ScriptCapitalF]", "(", 
              StyleBox["y",
                FontWeight->"Bold"], 
              StyleBox[")",
                FontWeight->"Bold"]}], 
            StyleBox["=",
              FontWeight->"Plain"], \((Y\_0, 
              Y\_1, \(\(...\) \(Y\_\(N - 1\)\)\))\)}]}], TraditionalForm]]],
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["como una se\[NTilde]al discreta en el espacio de la frecuencia y \
peri\[OAcute]dica con per\[IAcute]odo ",
    FontWeight->"Bold"],
  StyleBox["N",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", esto es, ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(k + N\) = Y\_k\)],
    FontWeight->"Bold"],
  StyleBox[" para todo ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`k \[Element] \[DoubleStruckCapitalZ]\)],
    FontWeight->"Bold"],
  ". El n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`1/N\)]],
  " es la",
  StyleBox[" frecuencia fundamental",
    FontWeight->"Bold"],
  " en (1)."
}], "Text"],

Cell["\<\
A su vez la se\[NTilde]al original se puede expresar en la forma\
\>", "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          StyleBox[
            
            FormBox[\(y\_n = \[Sum]\+\(k = 0\)\%\(N - 1\)\(\(Y\_k\) \(\
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\ k/
                            N\)\)\(\
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\((n = 0, 1, 2,  ... , 
                      N - 1)\)\(\ \)\)\),
              "TraditionalForm"],
            FontWeight->"Bold"], "                     "}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "Como las igualdades (2) tienen perfecto sentido para cualquier entero ",
  Cell[BoxData[
      \(TraditionalForm\`n \[Element] \[DoubleStruckCapitalZ]\)]],
  " y se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(n + N\) = y\_n\)]],
  ", en la teor\[IAcute]a de la DFT se interpreta siempre la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["como una se\[NTilde]al discreta en el tiempo y peri\[OAcute]dica \
con per\[IAcute]odo ",
    FontWeight->"Bold"],
  StyleBox["N",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", esto es, ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`y\_\(k + N\) = y\_k\)],
    FontWeight->"Bold"],
  StyleBox[" para todo ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`k \[Element] \[DoubleStruckCapitalZ]\)],
    FontWeight->"Bold"],
  ". "
}], "Text"],

Cell[TextData[{
  "Consecuencia inmediata de las igualdades (1) y (2) es que la DFT es una \
biyecci\[OAcute]n lineal de  ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^N\)]],
  " sobre  ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^N\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Es f\[AAcute]cil definir un comando que calcule simb\[OAcute]licamente \
dicha transformada. Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`N\ Y\_\(\(n\)\(\ \)\)\)]],
  "se obtiene haciendo el producto escalar en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^N\)]],
  "del vector  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " por el vector "
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["\[Omega]",
                FontWeight->"Bold"], "n"], "=", 
            
            RowBox[{\((1, \[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n/N\), \
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\ 2/N\),  ... , \
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\ \((N - 1)\)/N\))\), "=", 
              
              RowBox[{\((1, \[Omega]\^n, \[Omega]\^\(2\ n\),  ... , \
\[Omega]\^\(\((N - 1)\) n\))\), "    ", 
                
                FormBox[\(\((0 \[LessEqual] \ n\  \[LessEqual] \ 
                      N - 1)\)\(\ \)\),
                  "TraditionalForm"], "donde", 
                
                FormBox[\(\[Omega] = \[ExponentialE]\^\(2  \[ImaginaryI]\ \
\[Pi]/N\)\),
                  "TraditionalForm"]}]}]}], ",", \(esto\ \(\(es\)\(:\)\)\)}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          FormBox[
            RowBox[{\(Y\_n\), "=", 
              RowBox[{\(1\/N\), 
                RowBox[{"(", 
                  RowBox[{
                    StyleBox["y",
                      FontWeight->"Bold"], 
                    StyleBox["|",
                      FontWeight->"Plain"], 
                    SubscriptBox[
                      StyleBox["\[Omega]",
                        FontWeight->"Bold"], "n"]}], ")"}]}]}],
            "TraditionalForm"], "                   ", 
          
          FormBox[\(\((n = 0, 1, 2,  ... , 
              N - 1)\)\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\),
            "TraditionalForm"]}]], TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "Definamos los vectores ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Omega]",
            FontWeight->"Bold"], "n"], TraditionalForm]],
    TextAlignment->Center],
  " (en este cuaderno se ha usado ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5, puede que algunos comandos no funcionen igual con versiones anteriores \
de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ")."
}], "Text"],

Cell[BoxData[
    RowBox[{\(\[Omega][n_, N_] := 
        Exp[2  \[ImaginaryI]\ \[Pi]\ n\ Range[0, N - 1]/N]\), " ", 
      RowBox[{"(*", " ", 
        RowBox[{
          RowBox[{"los", " ", "vectores", " ", 
            FormBox[
              SubscriptBox[
                StyleBox["\[Omega]",
                  FontWeight->"Bold"], "n"],
              "TraditionalForm"]}], ",", 
          " ", \(0 \[LessEqual] n \[LessEqual] N - 1\), ",", 
          " ", \(en\ \[DoubleStruckC]\^N\)}], " ", "*)"}], ";"}]], "Input"],

Cell[TextData[{
  "Comprobemos, para N=6, que los vectores ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Omega]",
            FontWeight->"Bold"], "n"], TraditionalForm]]],
  " forman una base ortogonal."
}], "Text"],

Cell[BoxData[{
    \(\(A = Table[\[Omega][n, 6], {n, 0, 5}];\)\), "\[IndentingNewLine]", 
    \(MatrixForm[A]\ \ \[IndentingNewLine] (*\ 
      comprobamos\ que\ son\ ortogonales\ y\ su\ norma\ igual\ a\ \@6\ *) \), \
"\[IndentingNewLine]", 
    \(\(A . Conjugate[A]\  // MatrixForm\)\  // 
      Simplify\), "\[IndentingNewLine]", 
    \(Clear[A]\)}], "Input"],

Cell[TextData[{
  "Como consecuencia de la ortogonalidad de los ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Omega]",
            FontWeight->"Bold"], "n"], TraditionalForm]]],
  ", las igualdades (3) nos dicen que ",
  Cell[BoxData[
      \(TraditionalForm\`\((Y\_0, Y\_1, \(\(...\) \(Y\_\(N - 1\)\)\))\)\)]],
  " ",
  StyleBox["son las componentes del vector",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  StyleBox[" en la base",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            SubscriptBox[
              StyleBox["\[Omega]",
                FontWeight->"Bold"], "n"], 
            ":", \(0 \[LessEqual] n \[LessEqual] N - 1\)}], "}"}], 
        TraditionalForm]]],
  ". "
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{"     ", 
          StyleBox[
            FormBox[
              RowBox[{"y", "=", 
                RowBox[{\(\[Sum]\+\(k = 0\)\%\(N - 1\)\), 
                  RowBox[{
                    StyleBox[\(Y\_k\),
                      FontWeight->"Plain"], 
                    SubscriptBox["\[Omega]", 
                      StyleBox["k",
                        FontWeight->"Plain"]], " "}]}]}],
              "TraditionalForm"],
            FontWeight->"Bold"], "          "}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["En otras palabras, la DFT no es m\[AAcute]s que un cambio de base \
ortogonal en ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^N\)],
    FontWeight->"Bold"],
  ". ",
  "Definamos un  comando que calcula la DFT seg\[UAcute]n las igualdades (1). \
"
}], "Text"],

Cell[BoxData[
    \(DFT[
        muestra_] := \(Table[\(1\/Length[muestra]\) \((\ 
                muestra . \[Omega][\(-n\), Length[muestra]])\), {n, 0, 
              Length[muestra] - 1}] // Simplify\) // Chop\)], "Input"],

Cell[TextData[{
  "Por supuesto, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tiene su propia Transformada de Fourier Discreta que despu\[EAcute]s \
veremos y que solamente trabaja num\[EAcute]ricamente. La que acabamos de \
definir de forma elemental en la celda anterior no sirve para hacer \
c\[AAcute]lculos largos pero tiene la ventaja de que puede trabajar simb\
\[OAcute]licamente lo que, como veremos m\[AAcute]s adelante, permite \
comprobar simb\[OAcute]licamente algunas de las propiedades de la DFT."
}], "Text"],

Cell[TextData[{
  "El ",
  StyleBox["espectro",
    FontWeight->"Bold"],
  " de la se\[NTilde]al ",
  StyleBox["y",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/N, Y\_n)\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  ". El ",
  StyleBox["espectro de amplitudes",
    FontWeight->"Bold"],
  " es el conjunto  ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/N, Abs[Y\_n])\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  " y el ",
  StyleBox["espectro de fases",
    FontWeight->"Bold"],
  " es el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/N, Arg[Y\_n])\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  ". Dichos conjuntos suelen representarse por segmentos de l\[IAcute]nea que \
unen los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((n/N, 0)\)\)]],
  " con los puntos del espectro correspondiente. Debido a la periodicidad de \
los ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  " es suficiente representar dichos espectros para ",
  StyleBox["N ",
    FontSlant->"Italic"],
  "valores consecutivos de ",
  StyleBox["n",
    FontSlant->"Italic"],
  ". ",
  StyleBox["En todo lo que sigue hay que considerar que N  es un \
n\[UAcute]mero par",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[". ",
    FontWeight->"Bold"]
}], "Text"],

Cell[CellGroupData[{

Cell["Comparaci\[OAcute]n de coeficientes", "Subsection"],

Cell[TextData[{
  "En la siguiente tabla comparamos los coeficientes de Fourier, c[n], de la \
funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f[t] = t\ Sin[t]\)]],
  " calculados en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\(\([0, 2\ \[Pi]]\)\(\ \)\)\)]],
  " con los coeficientes ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  " de la DFT de una muestra de ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " valores (",
  Cell[BoxData[
      \(TraditionalForm\`N = 100, \ N = 400\)]],
  ") de dicha funci\[OAcute]n tomados en puntos igualmente espaciados del \
intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([0, 2\ \[Pi]]\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(\(f[t_] := t*Sin[t]\[IndentingNewLine]
    \(c[n_] := \((1/\((2*Pi)\))\)*
          NIntegrate[
            f[t]*Exp[\(-\ I\)\ n\ t], {t, 0, 2  Pi}];\)\[IndentingNewLine]
    \(y[q_] := 
        Table[f[t], {t, 0.0, 2  N[Pi] - 2  N[Pi]/q, 
            2  N[Pi]/q}];\)\[IndentingNewLine]
    \(\(Y[n_, N_] := \((1/N)\)*
          y[N] . \[Omega][\(-n\), N];\)\(\[IndentingNewLine]\)
    \)\[IndentingNewLine]
    \(\(comparacoef[p_]\  := \ 
      Prepend[Chop[
            Table[{n, c[n], N[Y[n, p]]}, {n, 0, 
                14}]], {"\<n\>", "\<c[n]\>", "\<Y[n,\>" <> 
              ToString[TraditionalForm[p]] <> "\<]\>"}] // 
        TableForm\)\(\[IndentingNewLine]\)
    \)\[IndentingNewLine]
    \(Print["\<Tabla para N=100\>"];\)\[IndentingNewLine]
    \(\(comparacoef[100]\)\(\[IndentingNewLine]\)
    \)\[IndentingNewLine]
    \(Print["\<Tabla para N=400\>"];\)\[IndentingNewLine]
    comparacoef[400]\)\(\ \)\)\)], "Input"],

Cell[TextData[{
  "Es importante no olvidar que ",
  StyleBox["la segunda mitad de la DFT",
    FontWeight->"Bold"],
  ", es decir, los coeficientes ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_k\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`N/2 + 1 \[LessEqual] k \[LessEqual] N - 1\)]],
  ", ",
  StyleBox["corresponde a frecuencias negativas",
    FontWeight->"Bold"],
  " que se combinan con las positivas para reconstruir la se\[NTilde]al \
original. En otras palabras, estos coeficientes no aportan frecuencias \
nuevas. Esto es f\[AAcute]cil de comprobar a partir de las igualdades (2) \
teniendo en cuenta la periodicidad de los ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_k\)]],
  " y de la exponencial compleja."
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            
            FormBox[\(y\_n = \(\(\[Sum]\+\(k = 0\)\%\(N - 1\)\(Y\_k\) \
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\ k/N\)\)\(=\)\)\),
              
              "TraditionalForm"], \(\[Sum]\+\(k = 0\)\%\(N/2\)\(Y\_k\) \
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\ k/N\)\)}], 
          "+", \(\[Sum]\+\(k = N/2 + 1\)\%\(N - 1\)\(Y\_\(k - 
                    N\)\) \[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\ \((k \
- N)\)/N\)\)}], "=", " ", 
        RowBox[{\(\[Sum]\+\(k = 0\)\%\(N/2\)\(Y\_k\) \[ExponentialE]\^\(2\ \
\[ImaginaryI]\ \[Pi]\ n\ k/N\)\), "+", 
          RowBox[{\(\[Sum]\+\(k = \(-N\)/2 + 1\)\%\(-1\)\), 
            
            RowBox[{\(Y\_k\), \(\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\
\ k/N\)\), 
              FormBox[
                RowBox[{"=", 
                  
                  RowBox[{\(Y\_0\), "+", \(\(\((\(-1\))\)\^n\) Y\_\(N/2\)\), 
                    "+", 
                    
                    FormBox[\(\[Sum]\+\(k = 1\)\%\(N/2 - 1\)\((\
\[NegativeThinSpace]\(Y\_k\) \[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ n\ \
k/N\) + \(Y\_\(-k\)\) \[ExponentialE]\^\(\(-2\) \[ImaginaryI]\ \[Pi]\ n\ \
k/N\)\[NegativeThinSpace])\)\),
                      "TraditionalForm"]}]}],
                "TraditionalForm"]}]}]}]}], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Left]
}, Open  ]],

Cell[CellGroupData[{

Cell["Polinomio interpolador", "Subsection"],

Cell[TextData[{
  "Deducimos de (5) que ",
  StyleBox["el polinomio trigonom\[EAcute]trico de periodo ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\(T\)\(,\)\)\)],
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "dado por"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[\(\(\ \)\(P(
            t) = \ \(\[Sum]\+\(k = \(-N\)/2\)\%\(N/2 - 1\)Y\_k\ \
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ t\ k/T\)\  = 
            Y\_0 + \(Y\_\(N/
                      2\)\) \[ExponentialE]\^\(\(-2\)\ \[ImaginaryI]\ \[Pi]\ \
t\ N\ /2  T\) + \(\(\[Sum]\+\(k = 1\)\%\(N/2 - 
                      1\)\)\((\[NegativeThinSpace]\(Y\_k\) \
\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ t\ k/T\) + \(Y\_\(-k\)\) \
\[ExponentialE]\^\(\(-2\) \[ImaginaryI]\ \[Pi]\ t\ k/T\)\[NegativeThinSpace])\
\)\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\)\)\)\)], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`P(n\ T/N) = 
        y\_n\ \ \ \ \ \ \((n = 0, 1, 2,  ... , N - 1)\)\)]],
  ". ",
  StyleBox["Dicho polinomio est\[AAcute] determinado de manera \[UAcute]nica \
por la DFT.",
    FontWeight->"Bold"],
  " El siguiente comando calcula este polinomio. Usaremos con frecuencia este \
comando m\[AAcute]s adelante."
}], "Text"],

Cell[BoxData[{
    \(\(\(interpol[muestra_ /; EvenQ[Length[muestra]]]\)[period_]\)[
        t_] := \[IndentingNewLine]\(\(Dot[
              RotateRight[DFT[muestra], Length[muestra]/2], 
              Exp[2  \[ImaginaryI]\ \[Pi]\ Range[\(-Length[muestra]\)/2, 
                    Length[muestra]/2\  - 1]\ t/period]] // ComplexExpand\) // 
          Simplify\) // Chop\), "\[IndentingNewLine]", 
    \(\(\(interpol[muestra_ /; EvenQ[Length[muestra]] \[Equal] False]\)[
          period_]\)[
        t_] := "\<La muestra debe tener un n\[UAcute]mero par de elementos\>"\
\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DFT de una se\[NTilde]al real", "Subsection"],

Cell[TextData[{
  "En la pr\[AAcute]ctica los n\[UAcute]meros ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(y\_k\)\(\ \)\)\)]],
  "son n\[UAcute]meros reales. Para se\[NTilde]ales reales, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(y\_k\),
            "TraditionalForm"], "\[Element]", "\[DoubleStruckCapitalR]"}], 
        TraditionalForm]]],
  ", se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(-n\) = Y\&__\_n\)]],
  " donde la barra indica complejo conjugado. Como, en virtud de la \
periodicidad es ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(-n\) = Y\_\(N - n\)\)]],
  ", haciendo ",
  Cell[BoxData[
      \(TraditionalForm\`n = N/2 - k\)]],
  " obtenemos que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(N/2 + k\) = Y\&__\_\(N/2 - k\)\)]],
  " y por tanto ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(Y\_\(N/2 + 
                k\)\)\(|\)\) = \(\(\(|\)\(Y\&__\_\(N/2 - 
                  k\)\)\(|\)\) = \(\(|\)\(Y\_\(N/2 - k\)\)\(|\)\)\)\)]],
  ", esto es ",
  StyleBox["el espectro de amplitudes es sim\[EAcute]trico respecto a ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`N/2\)],
    FontWeight->"Bold"],
  ". Tambi\[EAcute]n deducimos que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"Arg", "(", 
            FormBox[\(Y\_\(N/2 + k\)\),
              "TraditionalForm"], ")"}], 
          FormBox[
            RowBox[{"=", 
              RowBox[{"Arg", 
                FormBox[
                  RowBox[{\((Y\&__\_\(N/2 - k\))\), "=", 
                    RowBox[{"-", 
                      RowBox[{"Arg", "(", 
                        FormBox[\(Y\_\(N/2 - k\)\),
                          "TraditionalForm"], ")"}]}]}],
                  "TraditionalForm"]}]}],
            "TraditionalForm"]}], TraditionalForm]]],
  ", es decir, ",
  StyleBox["el espectro de fases es antisim\[EAcute]trico respecto a ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`N/2\)],
    FontWeight->"Bold"],
  ". Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_0\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(N/2\)\)]],
  " han de ser reales."
}], "Text"],

Cell[TextData[{
  "Para se\[NTilde]ales reales, ",
  StyleBox["supuesto que",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Y\_\(N/2\) = 0\)\(,\)\)\)],
    FontWeight->"Bold"],
  " y poniendo ",
  Cell[BoxData[
      \(TraditionalForm\`A\_0 = Y\_0\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`2  Y\_k = \(A\_k\)(
          cos(\[Phi]\_k) + i\ \(sen(\[Phi]\_k)\))\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] k \[LessEqual] N/2 - 1\)]],
  ", podemos escribir el polinomio ",
  Cell[BoxData[
      \(TraditionalForm\`P(t)\)]],
  " dado por (6) en la forma siguiente."
}], "Text"],

Cell[BoxData[{
    FormBox[
      RowBox[{\(P \((t)\)\), "=", 
        RowBox[{\(Y\_0 + \[Sum]\+\(k = 1\)\%\(N/2 - \
1\)\((\[NegativeThinSpace]\(Y\_k\) \[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\
\ t\ k/T\) + \(Y\_\(-k\)\) \[ExponentialE]\^\(\(-2\) \[ImaginaryI]\ \[Pi]\ t\ \
k/T\)\[NegativeThinSpace])\)\), "=", 
          
          RowBox[{\(Y\_0 + \[Sum]\+\(k = 1\)\%\(N/2 - 1\)\((\
\[NegativeThinSpace]\(Y\_k\) \[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ t\ \
k/T\) + \(Y\&__\_k\) \[ExponentialE]\^\(\(-2\) \[ImaginaryI]\ \[Pi]\ t\ k/T\)\
\[NegativeThinSpace])\)\), "=", 
            RowBox[{\(Y\_0\), "+", 
              
              FormBox[\(\(\[Sum]\+\(k = 1\)\%\(N/2 - 1\)2  
                      Re\ \((\ \[NegativeThinSpace]\(Y\_k\) \[ExponentialE]\^\
\(2\ \[ImaginaryI]\ \[Pi]\ t\ k/T\)\[NegativeThinSpace])\)\)\(\ \)\(=\)\),
                "TraditionalForm"]}]}]}]}], 
      TraditionalForm], "\[IndentingNewLine]", 
    FormBox[
      RowBox[{\(A\_0\), 
        FormBox[\(\(+\(\[Sum]\+\(k = 1\)\%\(N/2 - 1\)\((A\_k\ \
\(cos(\[Phi]\_k)\) \(cos(
                        2  k\ \[Pi]\ t/
                            T)\) - \(A\_k\) \(sen(\[Phi]\_k)\) \(sen(
                        2\ k\ \[Pi]\ t/T)\))\)\)\)\(\ \ \)\(=\)\),
          "TraditionalForm"], 
        FormBox[
          RowBox[{\(A\_0\), "+", 
            FormBox[\(\[Sum]\+\(k = 1\)\%\(N/2 - 1\)\),
              "TraditionalForm"]}],
          
          "TraditionalForm"], \(A\_k\), \(cos \((2  
                k\ \[Pi]\ t/T + \[Phi]\_k)\)\)}], 
      TraditionalForm]}], "NumberedEquation"],

Cell[TextData[{
  "Los n\[UAcute]meros ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(A\_k\)\(\[GreaterEqual]\)\(0\)\(\ \)\)\)]],
  " son las ",
  StyleBox["amplitudes",
    FontWeight->"Bold"],
  " y los n\[UAcute]meros ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Phi]\_k\)\(\[Element]\)\)\)]],
  "]",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\), \[Pi]\)]],
  "] son las ",
  StyleBox["fases",
    FontWeight->"Bold"],
  " de los respectivos arm\[OAcute]nicos",
  StyleBox[".",
    FontWeight->"Bold"],
  " Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`A\_k = 2 | Y\_k | \)],
    FontWeight->"Bold"],
  StyleBox[", ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\[Phi]\_k = arg(Y\_k)\)],
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["Se dice que una se\[NTilde]a",
    FontWeight->"Bold"],
  "l ",
  StyleBox["y",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " ",
  StyleBox["es",
    FontWeight->"Bold"],
  " ",
  StyleBox["par",
    FontWeight->"Bold"],
  " si ",
  Cell[BoxData[
      \(TraditionalForm\`y\_k = \(y\_\(-k\) = y\_\(N - k\)\)\)]],
  ", equivalentemente ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(N/2 - k\) = y\_\(N/2 + k\)\)],
    FontWeight->"Bold"],
  ". ",
  "Es f\[AAcute]cil comprobar que ",
  StyleBox["la DFT de una se\[NTilde]al par y real es tambi\[EAcute]n una se\
\[NTilde]al par y real.",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Comparaci\[OAcute]n de espectros", "Subsection"],

Cell[TextData[{
  "Recuerda que el espectro de una se\[NTilde]al peri\[OAcute]dica cuya serie \
de Fourier compleja es ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Sum]\+\(k \[Element] \[DoubleStruckCapitalZ]\)c\_k\ \
e\^\(2  \[ImaginaryI]\ \[Pi]\ k\ t/T\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se define como el conjunto de puntos ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/T, c\_n)\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  ". An\[AAcute]logamente, el espectro de una se\[NTilde]al peri\[OAcute]dica \
",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " es el conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/N, Y\_n)\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  ". Vamos a comparar el espectro ",
  Cell[BoxData[
      \(TraditionalForm\`{\((n/T, c\_n)\) : 
          n \[Element] \[DoubleStruckZ]}\)]],
  " de una se\[NTilde]al peri\[OAcute]dica ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " y el espectro de una muestra de dicha se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`y\_k = f(k\ T/N)\)]],
  ". Ejecuta las celdas que siguen y procura entender lo que se hace."
}], "Text"],

Cell[BoxData[
    \(\(\( (*\ 
      funci\[OAcute]n\ pulso\ rectangular\ *) \)\(\[IndentingNewLine]\)\(\
\[CapitalPi][t_] := 1\  /; Abs[t] < 1/2\[IndentingNewLine]
    \[CapitalPi][t_] := 
      0\  /; \ Abs[t] \[GreaterEqual] 1/2\[IndentingNewLine]
    \(periodiza[func_, a_, b_]\)[x_] := 
      func[a + \((b - a)\)*Mod[\((x - a)\)/\((b - a)\), 1]]\n
    \(P[t_] = \(periodiza[\[CapitalPi], \(-2.5\), 2.5]\)[t];\)\n (*\ 
      periodizaci\[OAcute]n\ con\ per\[IAcute]odo\ T = 
        5\ de\ la\ funci\[OAcute]n\ \[CapitalPi][t]\ *) \ \[IndentingNewLine]
    \(Plot[P[t], {t, 7.5, \(-7.5\)}, Ticks \[Rule] {{\(-5\), 0, 5}, None}, 
        AspectRatio \[Rule] 1/3];\)\)\)\)], "Input"],

Cell[BoxData[
    \(\(\(c[
        n_]\)\(:=\)\(Simplify[\((1/5)\)*
          Integrate[Exp[\(-2\)\ \[Pi]\ I\ n\ t/5], {t, \(-1\)/2, 1/2}], 
        n \[Element] Integers]\)\( (*\ 
        coeficientes\ de\ Fourier\ de\ P[t]\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Como la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`P[t]\)]],
  " es real y par sus coeficientes de Fourier son reales (y pares ",
  Cell[BoxData[
      \(TraditionalForm\`c[\(-k\)] = c[k]\)]],
  ") por lo que podemos representar el espectro de ",
  Cell[BoxData[
      \(TraditionalForm\`P[t]\)]],
  " f\[AAcute]cilmente como sigue."
}], "Text"],

Cell[BoxData[{
    \(\(puntos = 
        Transpose[{\(1\/5\) Range[\(-15\), 15], 
            Table[c[n], {n, \(-15\), 15, 1}] // 
              N}];\)\), "\[IndentingNewLine]", 
    \(\(ListPlot[puntos, PlotStyle \[Rule] {PointSize[0.02], Hue[0]}, 
        Epilog \[Rule] 
          Line[puntos /. {x_, y_} \[Rule] 
                Sequence[{x, 0}, {x, y}, {x, 
                    0}]]];\)\), "\[IndentingNewLine]", 
    \( (*\ 
      hemos\ representado\ los\ primeros\ 31\ coeficientes\ *) \)}], "Input"],

Cell["\<\
Tomamos ahora una muestra de la funci\[OAcute]n formada por 32 valores \
igualmente espaciados a lo largo de un per\[IAcute]odo y representamos el \
espectro de la DFT correspondiente.\
\>", "Text"],

Cell[BoxData[{
    \(\(\(sample = P /@ Range[0.0, 5 - 5/32, 5/32];\)\(\[IndentingNewLine]\)
    \) (*\ 
      es\ par\ y\ real\ por\ lo\ que\ los\ Y\_n\ ser\[AAcute]n\ reales\ e\ \
Y\_\(-n\) = Y\_n\ *) \ \), "\[IndentingNewLine]", 
    \(\(puntos = Transpose[{\(1\/5\) Range[0, 31], DFT[sample]}];\)\), "\n", 
    \(\(ListPlot[puntos, PlotStyle \[Rule] {PointSize[0.02], Hue[0]}, 
        Epilog \[Rule] 
          Line[puntos /. {x_, y_} \[Rule] 
                Sequence[{x, 0}, {x, y}, {x, 0}]]];\)\), "\n", 
    \( (*\ representamos\ el\ espectro\ de\ la\ muestra\ *) \)}], "Input"],

Cell[TextData[{
  "Aparentemente el resultado obtenido es muy distinto del anterior. Lo que \
ocurre es que en la transformada de Fourier discreta los coeficientes \
correspondientes a los valores ",
  Cell[BoxData[
      \(TraditionalForm\`k = N/2 + 1,  ... , N - 1\)]],
  " representan frecuencias negativas correspondientes a ",
  Cell[BoxData[
      \(TraditionalForm\`k = \(-N\)/2 + 1,  ... , \(-2\), \(-1\)\)]],
  " que se combinan con las frecuencias correspondientes a la primera mitad \
de la transformada para reconstruir la se\[NTilde]al. Para recuperar la \
primera gr\[AAcute]fica lo \[UAcute]nico que hay que hacer es \"doblar por la \
mitad\" la transformada de Fourier discreta. Esto puede hacerse con el \
comando RotateRight[ ]."
}], "Text"],

Cell[BoxData[{
    \(\(trans = DFT[sample];\)\), "\[IndentingNewLine]", 
    \(\(puntos = 
        Transpose[{\(1\/5\) Range[\(-15\), 16], 
            RotateRight[trans, 15]}];\)\), "\[IndentingNewLine]", 
    \(\(ListPlot[puntos, PlotStyle \[Rule] {PointSize[0.02], Hue[0]}, 
        Epilog \[Rule] 
          Line[puntos /. {x_, y_} \[Rule] 
                Sequence[{x, 0}, {x, y}, {x, 
                    0}]]];\)\), "\[IndentingNewLine]", 
    \(Clear[sample, puntos, trans]\)}], "Input"],

Cell["\<\
Como puede verse, los espectros respectivos son muy parecidos. Por estas \
causas, para evitar interpretaciones incorrectas, es frecuente representar \
solamente la primera mitad de la transformada de Fourier discreta. Por \
supuesto, lo usual es representar el espectro de amplitudes pues, en general, \
la transformadad de Fourier discreta tiene valores complejos.\
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ideas b\[AAcute]sicas de muestreo", "Section"],

Cell[TextData[{
  "Muestrear una se\[NTilde]al es, simplemente, tomar valores de dicha se\
\[NTilde]al en intervalos de tiempo igualmente espaciados. El n\[UAcute]mero \
de valores (muestras) que se toman por unidad de tiempo es lo que se conoce \
como ",
  StyleBox["raz\[OAcute]n de muestreo",
    FontSlant->"Italic"],
  ". Equivalentemente, el tiempo entre cada dos muestras consecutivas es la \
inversa de la raz\[OAcute]n de muestreo. El siguiente comando muestrea una se\
\[NTilde]al en tiempo continuo dada por una funci\[OAcute]n, \"func\", con \
una raz\[OAcute]n de muestreo igual a \"razonmuestreo\", durante un intervalo \
de tiempo de duraci\[OAcute]n igual a \"tiempo\" (podemos suponer que medimos \
el tiempo en segundos)."
}], "Text"],

Cell[BoxData[
    \(muestra[func_, razonmuestreo_, tiempo_] := 
      Module[{nummuestras}, nummuestras = Floor[tiempo*razonmuestreo]; 
        Map[func, \((Range[nummuestras] - 1)\)/razonmuestreo] // 
          N]\)], "Input"],

Cell[TextData[{
  StyleBox["En la pr\[AAcute]ctica las se\[NTilde]ales no tienen por qu\
\[EAcute] ser peri\[OAcute]dicas y se sigue el convenio de considerarlas como \
peri\[OAcute]dicas con per\[IAcute]odo igual al tiempo durante el cual se \
realiza el muestreo.",
    FontWeight->"Bold"],
  " ",
  StyleBox["Con este convenio, si representamos por ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`F\_s\)],
    FontWeight->"Bold"],
  StyleBox[" la raz\[OAcute]n de muestreo y es ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`N\)],
    FontWeight->"Bold"],
  StyleBox[" el n\[UAcute]mero total de muestras tomadas, consideramos que el \
periodo fundamental de la se\[NTilde]al es ",
    FontWeight->"Bold"],
  StyleBox["T=",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`N/F\_s\)],
    FontWeight->"Bold"],
  StyleBox[". El coeficiente ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)],
    FontWeight->"Bold"],
  StyleBox[" de la DFT de la muestra de la se\[NTilde]al representa la \
componente arm\[OAcute]nica de dicha se\[NTilde]al de frecuencia ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{\(f\_\(\(n\)\(\ \)\(=\)\)\), 
          StyleBox[\(n/T\),
            FontWeight->"Bold"]}], TraditionalForm]],
    FontWeight->"Bold"],
  " ",
  StyleBox["y ocupa en la DFT el lugar ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`n + 1 = \(f\_n\) T + 1\)],
    FontWeight->"Bold"],
  ". "
}], "Text"],

Cell["\<\
El siguiente comando representa el espectro de amplitudes de la DFT de una \
muestra de una se\[NTilde]al. \
\>", "Text"],

Cell[BoxData[
    \(plotamplitudesDFT[func_, razonmuestreo_, tiempo_, 
        grosorpunto_:  0.016, {opts___}] := 
      Module[{puntos, muestra, nummuestras, transformada, marcas}, 
        nummuestras = 
          Floor[tiempo*razonmuestreo]; \[IndentingNewLine]muestra = 
          Map[func, \((Range[nummuestras] - 1)\)/razonmuestreo] // 
            N; \ \[IndentingNewLine]transformada = 
          Abs[DFT[muestra]]; \[IndentingNewLine]puntos = 
          Transpose[{\((Range[nummuestras] - 1)\)/razonmuestreo, 
              transformada}]; \[IndentingNewLine]marcas := {Drop[
              Union[Table[
                  If[transformada[\([k]\)] > 0 || 
                      k == nummuestras/2 + 1, {\((k - 1)\)/razonmuestreo, 
                      k - 1}, {}], {k, 1, nummuestras}]], 1], 
            Automatic}; \[IndentingNewLine]ListPlot[puntos, 
          PlotStyle -> {PointSize\ [grosorpunto], Hue[0]}, 
          Epilog \[Rule] 
            Map[Line, puntos /. {x_, y_} \[Rule] {{x, 0}, {x, y}}], 
          Axes \[Rule] True, 
          AxesLabel -> {"\<\[Nu]\>", \*"\"\<|\!\(Y\_n\)|\>\""}, 
          PlotRange -> All, 
          Ticks \[Rule] If[MemberQ[{opts}, etiquetas], marcas, Automatic], 
          Complement[{opts}, {etiquetas}]];]\)], "Input"],

Cell[CellGroupData[{

Cell["An\[AAcute]lisis frecuencial de una muestra", "Subsection"],

Cell["\<\
En el siguiente ejemplo comprobamos c\[OAcute]mo la transformada de Fourier \
discreta detecta las frecuencias presentes en una muestra. Consideramos una \
se\[NTilde]al peri\[OAcute]dica con per\[IAcute]odo principal 1 y frecuencia \
fundamental 1, obtenida por superposici\[OAcute]n de sinusoides de \
frecuencias 1, 3, 4, 6, 12 y 15.\
\>", "Text"],

Cell[BoxData[{
    \(\(\(f[t_] = 
        Sin[2  \[Pi]\ t] +  .5  Sin[3*2  \[Pi]\ t] + 
          Cos[4*2  \[Pi]\ t] +  .5  Cos[6*2  \[Pi]\ t] + 
          2  Cos[12*2  \[Pi]\ t] +  .75 
             Sin[15*2  \[Pi]\ t];\)\(\[IndentingNewLine]\)
    \) (*\ 
      representamos\ un\ periodo\ de\ la\ se\[NTilde]al\ *) \), "\
\[IndentingNewLine]", 
    \(\(Plot[f[t], {t, 0, 1}, PlotStyle \[Rule] {Hue[ .6], Thickness[ .004]}, 
        ImageSize \[Rule]  .8*{450, 277.875}];\)\)}], "Input"],

Cell["\<\
Muestreamos la se\[NTilde]al durante un segundo con una frecuencia de \
muestreo de 32 muestras por segundo. Obtenemos as\[IAcute] una muestra de \
N=32 elementos.\
\>", "Text"],

Cell[BoxData[{
    RowBox[{\(muestra32 = f[Range[0.0, 1 - 1/32, 1/32]];\), " ", 
      StyleBox[\( (*\ estos\ n\[UAcute]meros\ son\ los\ y\_n\ *) \),
        FontColor->RGBColor[1, 0, 0]]}], "\[IndentingNewLine]", \(Plot[
        f[t], {t, 0, 1}, PlotStyle \[Rule] {Hue[ .6], Thickness[ .004]}, 
        Epilog \[Rule] {Hue[0], PointSize[ .015], 
            Point /@ Transpose[{Range[0, 31]/32, muestra32}]}, 
        ImageSize \[Rule]  .8*{450, 277.875}];\), "\[IndentingNewLine]", 
  "muestra32"}], "Input"],

Cell[TextData[{
  "En la muestra obtenida hay algunos valores que se repiten pero, a simple \
vista, no hay nada que indique en estos valores que proceden de una se\
\[NTilde]al compuesta por arm\[OAcute]nicos de frecuencias 1, 3, 4, 6, 12 y \
15. Veamos si la DFT de esta muestra detecta estas frecuencias. Como la \
muestra tiene 32 elementos y se ha muestreado a una raz\[OAcute]n de 32 \
muestras por segundo, debemos interpretar que la muestra procede de una se\
\[NTilde]al co periodo fundamental ",
  Cell[BoxData[
      \(TraditionalForm\`32/32 = 1\)]],
  ". Por tanto el coeficiente ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  " de la DFT de la muestra representa la componente arm\[OAcute]nica de \
dicha muestra de frecuencia n (Herzios). Vamos a representar el espectro de \
amplitudes de la DFT de la muestra."
}], "Text"],

Cell[BoxData[{
    RowBox[{\(transformada = DFT[muestra32]\), 
      StyleBox[\( (*\ estos\ son\ los\ Y\_n\ *) \),
        FontColor->RGBColor[1, 0, 0]]}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{"puntos", "=", 
        RowBox[{"Transpose", "[", 
          RowBox[{"{", 
            RowBox[{\(Range[0, 31]/32\), ",", 
              RowBox[{"Abs", "[", 
                StyleBox["transformada",
                  FontColor->RGBColor[1, 0, 0]], "]"}]}], "}"}], "]"}]}], 
      ";"}], "\[IndentingNewLine]", \(ListPlot[puntos, 
        PlotStyle -> {PointSize\ [0.016], Hue[0]}, 
        Epilog \[Rule] 
          Map[Line, puntos /. {x_, y_} \[Rule] {{x, 0}, {x, y}}], 
        Axes \[Rule] True, 
        AxesLabel -> {"\<\[Nu]\>", \*"\"\<|\!\(Y\_n\)|\>\""}, 
        Ticks \[Rule] {Transpose[{Range[0, 31]/32, 
                Table[j - 1, {j, 1, 32}]}], Automatic}, PlotRange -> All, 
        ImageSize \[Rule] {532, 328.5}];\), "\[IndentingNewLine]", \(Clear[
      puntos, transformada]\), "\[IndentingNewLine]", \(Clera[
      muestra32]\)}], "Input"],

Cell[TextData[{
  "Efectivamente, vemos que en la DFT los \[UAcute]nicos coeficientes no \
nulos son ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_1, \ Y\_3, \ Y\_4, \ Y\_6, \ Y\_12\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Y\_15\)\(\ \)\)\)]],
  "(y sus sim\[EAcute]tricos respecto al coeficiente ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Y\_16\)\(\ \)\)\)]],
  ") lo que se corresponde con las frecuencias, 1, 3, 4, 6, 12 y 15, \
presentes en la se\[NTilde]al de partida. Observa que los m\[OAcute]dulos de \
los coeficientes de la segunda mitad de la transformada (del 17 al 31 que \
corresponden a frecuencias negativas) repiten los de la primera mitad (del 1 \
al 15) , es decir, hay simetr\[IAcute]a respecto del punto correspondiente a \
la frecuencia ",
  Cell[BoxData[
      \(TraditionalForm\`N/2 = 16\)]],
  " \[DownExclamation]no hay que olvidar que dicho punto ocupa el lugar 17 en \
la DFT! Observa tambi\[EAcute]n que el m\[OAcute]dulo de los ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  " es la mitad de las amplitudes correspondientes a cada frecuencia en la se\
\[NTilde]al original."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Aliasing (enmascaramiento)", "Subsection"],

Cell["\<\
Veamos lo que ocurre si la raz\[OAcute]n de muestreo es m\[AAcute]s baja. Por \
ejemplo, vamos a muestrear la se\[NTilde]al anterior con una raz\[OAcute]n de \
muestreo igual a 30 muestras por segundo durante un intervalo de tiempo de 1 \
segundo. \
\>", "Text"],

Cell[BoxData[
    \(plotamplitudesDFT[f, 30, 
      1, {ImageSize \[Rule] {532, 328.5}, etiquetas}]\)], "Input"],

Cell[TextData[{
  "Como puedes ver, ahora el t\[EAcute]rmino correspondiente ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_15\)]],
  " es nulo. El estudio de la DFT de la muestra nos dir\[AAcute] cu\[AAcute]l \
es la se\[NTilde]al que ahora recuperamos. ",
  "Calculemos las amplitudes y fases de la se\[NTilde]al recuperada."
}], "Text"],

Cell[BoxData[{
    \(\(muestra30 = muestra[f, 30, 1];\)\), "\[IndentingNewLine]", 
    \(\(trans = DFT[muestra30];\)\), "\[IndentingNewLine]", 
    \(\(Table[
        If[trans[\([k + 1]\)] \[NotEqual] 0, 
          Print["\<{A[\>", k, \ "\<],\[Phi][\>", k, \ "\<]} = {\>", 
            2  Abs[trans[\([k + 1]\)]], \ "\<,\>", 
            Arg[trans[\([k + 1]\)]], \ "\<}\>"\ ]], {k, 0, 
          15}];\)\)}], "Input"],

Cell["La se\[NTilde]al recuperada es la siguiente", "Text"],

Cell[BoxData[
    \(\(Sum[
          If[trans[\([k + 1]\)] \[NotEqual] 0, 
            2  Abs[trans[\([k + 1]\)]] 
              Cos[2\ k\ \[Pi]\ t\  + \ Arg[trans[\([k + 1]\)]]], 0.0], {k, 1, 
            14}] // Simplify\) // Chop\)], "Input"],

Cell["\<\
Podemos comprobarlo usando el polinomio interpolador anteriormente \
definido.\
\>", "Text"],

Cell[BoxData[{
    \(aliasf[t_] = \(\(interpol[muestra30]\)[1]\)[
        t]\), "\[IndentingNewLine]", 
    \(Clear[muestra30]\)}], "Input"],

Cell["\<\
Observa que la se\[NTilde]al recuperada es igual a la de partida suprimiendo \
la frecuencia 15. Ambas se\[NTilde]ales deben coincidir en los puntos de la \
muestra anterior (la obtenida muestreando a razon de 30 muestra por segundo). \
Veamos que efectivamente as\[IAcute] ocurre.\
\>", "Text"],

Cell[BoxData[{
    \(\(Plot[{f[t], aliasf[t]}, {t, 0, 1}, 
        PlotStyle \[Rule] {RGBColor[1, 0, 0], RGBColor[0, 0, 1]}, 
        Epilog \[Rule] {PointSize[0.015], Hue[1], 
            Point /@ Transpose[{Range[0, 29]/30, f[Range[0, 29]/30]}]}, 
        ImageSize \[Rule]  .8*{536, 331}];\)\), "\[IndentingNewLine]", 
    \(Clear[aliasf]\)}], "Input"],

Cell["\<\
En la gr\[AAcute]fica anterior se puede apreciar c\[OAcute]mo la \
se\[NTilde]al recuperada muestreando a razon de 30 muestra por segundo (en \
azul) y la se\[NTilde]al original (en verde) coinciden en los puntos de la \
muestra. Por ello la se\[NTilde]al recuperada enmascara la se\[NTilde]al \
original: es un \"alias\" de ella. \
\>", "Text"],

Cell[TextData[{
  "Esto es lo que, en ingl\[EAcute]s, se conoce como ",
  StyleBox["aliasing",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " y consiste en que cuando se muestrea con una raz\[OAcute]n de muestreo \
baja una se\[NTilde]al de alta frecuencia puede ocurrir que dicha \
se\[NTilde]al adopte un ",
  StyleBox["alias",
    FontSlant->"Italic"],
  " y se enmascare como una se\[NTilde]al de frecuencia m\[AAcute]s baja y, \
por tanto, el muestreo que hemos hecho no nos sirve para recuperar dicha se\
\[NTilde]al."
}], "Text"],

Cell[TextData[{
  "Un resultado b\[AAcute]sico en muestreo, el ",
  StyleBox["teorema de Shannon-Whittaker",
    FontWeight->"Bold"],
  ", afirma que ",
  StyleBox["se puede recuperar una se\[NTilde]al tomando en un \
per\[IAcute]odo un n\[UAcute]mero de muestras mayor que el doble de la m\
\[AAcute]xima frecuencia presente en dicha se\[NTilde]al",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". En la se\[NTilde]al que estamos considerando la m\[AAcute]xima \
frecuencia es 15 y hemos visto que con una raz\[OAcute]n de muestreo de 32 \
muestras por segundo se recupera la se\[NTilde]al pero con una raz\[OAcute]n \
de muestreo de 30 muestras por segundo no se recupera dicha se\[NTilde]al \
sino otra en la que se ha perdido la frecuencia 15. "
}], "Text"],

Cell["\<\
Naturalmente, cuanto m\[AAcute]s baja sea la raz\[OAcute]n de muestreo la se\
\[NTilde]al que se recupera tiene frecuencia m\[AAcute]s baja. Muestreando \
con una raz\[OAcute]n de 20 muestras por segundo durante un segndo resulta lo \
que sigue.\
\>", "Text"],

Cell[BoxData[
    \(plotamplitudesDFT[f, 20, 
      1, {ImageSize \[Rule] {532, 328.5}, etiquetas}]\)], "Input"],

Cell["\<\
Ahora la frecuencia m\[AAcute]s alta es 8. Vamos a calcular las amplitudes y \
fases correspondientes a esta DFT.\
\>", "Text"],

Cell[BoxData[{
    \(\(muestra20 = muestra[f, 20, 1];\)\), "\[IndentingNewLine]", 
    \(\(trans = DFT[muestra20];\)\), "\[IndentingNewLine]", 
    \(\(Table[
        If[trans[\([k + 1]\)] \[NotEqual] 0, 
          Print["\<{A[\>", k, \ "\<],\[Phi][\>", k, \ "\<]} = {\>", 
            2  Abs[trans[\([k + 1]\)]], \ "\<,\>", 
            Arg[trans[\([k + 1]\)]], \ "\<}\>"\ ]], {k, 0, 9}];\)\)}], "Input"],

Cell[TextData[{
  "Ahora la se\[NTilde]al recuperada tiene frecuencias 1, 3, 4, 5, 6, 8 con \
amplitudes respectivas 1, 0.5, 1, 0.75, 0.5, 2 y fases ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\)/2, \(-\[Pi]\), 0, \[Pi]/2, 0, 0\)]],
  ". Es decir es el polinomio trigonom\[EAcute]trico siguiente."
}], "Text"],

Cell[BoxData[
    \(\(Sum[
          If[trans[\([k + 1]\)] \[NotEqual] 0, 
            2  Abs[trans[\([k + 1]\)]] 
              Cos[2\ k\ \[Pi]\ t\  + \ Arg[trans[\([k + 1]\)]]], 0.0], {k, 1, 
            9}] // Simplify\) // Chop\)], "Input"],

Cell["\<\
Podemos comprobarlo usando el polinomio interpolador anteriormente \
definido.\
\>", "Text"],

Cell[BoxData[
    \(aliasf[t_] = \(\(interpol[muestra20]\)[1]\)[t]\)], "Input"],

Cell["\<\
Observa que ahora la se\[NTilde]al recuperada tiene frecuencias que no est\
\[AAcute]n en la original. Comprobamos ya que se trata de un \"alias\" de la \
se\[NTilde]al original.\
\>", "Text"],

Cell[BoxData[{
    \(\(Plot[{f[t], aliasf[t]}, {t, 0, 1}, 
        PlotStyle \[Rule] {RGBColor[1, 0, 0], RGBColor[0, 0, 1]}, 
        Epilog \[Rule] {PointSize[0.015], Hue[1], 
            Point /@ Transpose[{Range[0, 19]/20, f[Range[0, 19]/20]}]}, 
        ImageSize \[Rule]  .8*{536, 331}];\)\), "\[IndentingNewLine]", 
    \(Clear[aliasf, muestra20, trans]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ajuste del periodo", "Subsection"],

Cell["\<\
Finalmente, veamos lo que ocurre si tomamos muestras igualmente espaciadas a \
lo largo de dos per\[IAcute]odos.\
\>", "Text"],

Cell[BoxData[
    \(plotamplitudesDFT[f, 32, 
      2,  .01, {ImageSize \[Rule] {532, 328.5}, etiquetas}]\)], "Input"],

Cell[TextData[{
  "En esta DFT los \[UAcute]nicos coeficientes no nulos son ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_2, \ Y\_6, \ Y\_8, \ Y\_12\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_24\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Y\_30\)\(\ \)\)\)]],
  "(y sus sim\[EAcute]tricos respecto al coeficiente ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Y\_32\)\(\ \)\)\)]],
  ") esto es, los \[IAcute]ndices de los coeficientes ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  " no nulos se han multiplicado por dos con respecto a la DFT anterior.  Lo \
que ha ocurrido es lo siguiente; ahora hemos muestreado con igual \
raz\[OAcute]n de muestreo que antes, 32 muestras/segundo, pero tomando \
muestras a lo largo de dos segundos (dos periodos de la se\[NTilde]al), con \
lo cual el tama\[NTilde]o de la muestra obtenida es ",
  Cell[BoxData[
      \(TraditionalForm\`N = 64\)]],
  " y lo que hemos hecho ha sido duplicar la muestra anterior. Ahora debemos \
interpretar que la muestra obtenida corresponde a una se\[NTilde]al de \
periodo fundamental ",
  Cell[BoxData[
      \(TraditionalForm\`T = \(N/N\_s = \(64/32 = 2\)\)\)]],
  " y, en consecuencia, frecuencia fundamental ",
  Cell[BoxData[
      \(TraditionalForm\`1/2\)]],
  ". Por tanto, el coeficiente ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Y\_n\)\(\ \)\)\)]],
  "de la DFT de esta muestra representa el componente arm\[OAcute]nico de \
amplitud ",
  Cell[BoxData[
      \(TraditionalForm\`n/T = n/2\)]],
  ". Naturalmente, las frecuencias que detecta la DFT son las mismas que \
antes, por lo que los \[IAcute]ndices ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " de los coeficientes ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  " no nulos en esta DFT son los de antes multiplicados por dos. "
}], "Text"],

Cell["\<\
Para recuperar la se\[NTilde]al original a partir de esta muestra hay que \
ajustar el per\[IAcute]odo y hacerlo igual a 2 segundos.\
\>", "Text"],

Cell[BoxData[
    \(\(\(\(\(interpol[muestra[f, 32, 2]]\)[2]\)[t]\)\( (*\ 
      recuperamos\ la\ se\[NTilde]al\ original\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Si tratamos de recuperar la se\[NTilde]al usando esta muestra ",
  StyleBox["sin ajustar el per\[IAcute]odo",
    FontSlant->"Italic"],
  ", es decir manteniendo el periodo igual a 1 segundo, obtenemos otra se\
\[NTilde]al con frecuencias dobles de la original. Esto es as\[IAcute]  \
porque estamos procediendo como si los 64 valores muestrales se hubieran \
tomado en un per\[IAcute]odo cuando realmente se han tomado en dos."
}], "Text"],

Cell[BoxData[
    \(\(\(\(\(interpol[muestra[f, 32, 2]]\)[1]\)[t]\)\( (*\ 
      recuperamos\ una\ se\[NTilde]al\ con\ frecuencias\ dobles\ *) \)\)\)], \
"Input"],

Cell["\<\
Ya puedes suponer lo que pasa si, manteniendo la raz\[OAcute]n de muestreo  \
igual a 32 muestras/segundo, tomamos muestras a lo largo de tres segundos \
(tres periodos de la se\[NTilde]al). Aqu\[IAcute] puedes verlo.\
\>", "Text"],

Cell[BoxData[
    \(\(\(plotamplitudesDFT[f, 32, 
      3,  .006, {ImageSize \[Rule] {532, 328.5}, etiquetas}]\)\( (*\ 
      triplicamos\ la\ muestra\ *) \)\)\)], "Input"],

Cell[TextData[{
  "El tama\[NTilde]o de la muestra obtenida es ahora ",
  Cell[BoxData[
      \(TraditionalForm\`N = 96\)]],
  " y los coeficientes ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Y\_n\)\(\ \)\)\)]],
  " no nulos de la correspondiente DFT son ahora ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_3, \ Y\_9, \ Y\_12, \ Y\_18, \ Y\_36, \ 
      Y\_45\)]],
  " cuyos \[IAcute]ndices son el triple de los correspondientes a los \
coeficientes no nulos en la primera DFT. Esto nos recuerda que ",
  StyleBox["el lugar que ocupa",
    FontSlant->"Italic"],
  " el coeficiente asociado al arm\[OAcute]nico n-\[EAcute]simo (aqu\[EAcute] \
cuyal frecuencia es n veces la frecuencia fundamental)",
  StyleBox[" en la DFT es relativo al tama\[NTilde]o de la muestra",
    FontWeight->"Bold"],
  ". Veamos algunos ejemplos m\[AAcute]s."
}], "Text"],

Cell[BoxData[{
    \(\(\(signal[t_] = 
        1.8\ Cos[2  \[Pi]\ t/8] + 1.6\ Cos[2  \[Pi]\ t/2] + 
          1.4  Cos[2  \[Pi]\ t] + 1.2  Cos[3*2  \[Pi]\ t] + 
          1.4  Cos[6*2  \[Pi]\ t] + 
          1.4  Cos[12*2  \[Pi]\ t];\)\(\[IndentingNewLine]\)
    \) (*\ periodo\ fundamental\ igual\ a\ 8, \ 
      frecuencia\ fundamental\ 1/8; \ frecuencias\ presentes\ 1/8, 
      1/2 = 4*1/8, 1 = 8*1/8, 3 = 24*1/8, 6 = 48*1/8, 
      12 = 96*1/8\ *) \), "\[IndentingNewLine]", 
    \(samples = muestra[signal, 26, 8];  (*\ 
      muestreamos\ con\ F\_s = \(26\ muestras\ por\ segundo\ durante\ un\ \
periodo\ de\ 8\ segundos . \ 
              La\ muestra\ resultante\ es\ de\ tama\[NTilde]o\ N = \(26\
\[Times]8 = 208\)\)\ *) \[IndentingNewLine]\(\(recov[
        t]\)\(=\)\(\(\(interpol[samples]\)[8]\)[t]\)\(\ \)\( (*\ 
        recuperamos\ la\ se\[NTilde]al\ por\ medio\ de\ su\ DFT\ *) \)\)\)}], \
"Input"],

Cell[BoxData[
    \(\(\(\(dftsamples = DFT[samples];\)\[IndentingNewLine]
    Position[dftsamples, _?\((# \[NotEqual] 0 &)\)] - 1\)\(\ \)\( (*\ 
      hay\ que\ restar\ 1\ por\ el\ convenio\ de\ que\ los\ \[IAcute]ndices\ \
empiezan\ en\ k = 0\ *) \)\( (*\ 
      Como\ la\ frecuencia\ fundamental\ es\ 1/
          8\ hay\ que\ interpretar\ que\ el\ coeficiente\ Y\_k\ de\ la\ DFT\ \
corresponde\ a\ la\ frecuencia\ k/
          8\ \((0 \[LessEqual] k \[LessEqual] 207)\) . \ Observa\ que, \ 
      efectivamente, \ 
      los\ lugares\ que\ corresponden\ a\ coeficientes\ no\ nulos\ en\ la\ \
DFT\ se\ obtienen\ para\ k = 1, 4, \ 8, \ 24, \ 48, \ 
      96\ y\ sus\ sim\[EAcute]tricos\ respecto\ al\ lugar\ k = 
        104\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Tomemos ahora muestras a lo largo de tres periodos y comprobamos que si \
ajustamos el periodo de la forma indicada haci\[EAcute]ndolo igual a ",
  Cell[BoxData[
      \(TraditionalForm\`N/F\_s\)]],
  " seguimos recuperando la misma se\[NTilde]al."
}], "Text"],

Cell[BoxData[
    \(\(\(\(\(newsamples = muestra[signal, 26, 24];\)\(\[IndentingNewLine]\)
    \) (*\ 
      muestreamos\ con\ F\_s = \(26\ muestras\ por\ segundo\ durante\ 3\ \
periodos\ de\ 8\ segundos . \ 
              La\ muestra\ resultante\ es\ de\ tama\[NTilde]o\ N\_1 = \(3\
\[Times]N = \(624. \ Nuevo\ periodo\ N\_1/26 = 
              24\)\)\)\ *) \[IndentingNewLine]
    newrecov[t] = \(\(interpol[newsamples]\)[24]\)[t]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(\(dftnewsamples = DFT[newsamples];\)\[IndentingNewLine]
    Position[dftnewsamples, _?\((# \[NotEqual] 0 &)\)] - 
      1\)\(\ \)\)\)], "Input"],

Cell[TextData[{
  "Estas observaciones son importantes para el dise\[NTilde]o de filtros, \
pues suele ser conveniente aumentar el tama\[NTilde]o ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " de la muestra inicial para lograr mayor eficacia en el c\[AAcute]lculo de \
la DFT (y tambi\[EAcute]n ",
  StyleBox["mayor resoluci\[OAcute]n en frecuencia",
    FontSlant->"Italic"],
  "). Si el tama\[NTilde]o de la muestra  final (obtenida con frecuencia a\
\[NTilde]adiendo ceros, es decir ",
  StyleBox["silencio",
    FontSlant->"Italic"],
  " si la se\[NTilde]al es un sonido) es ",
  Cell[BoxData[
      \(TraditionalForm\`N\_1\)]],
  " y la raz\[OAcute]n de muestreo (que se supone constante) es ",
  Cell[BoxData[
      \(TraditionalForm\`F\_s\)]],
  ", debemos interpretar que la muestra final corresponde a una se\[NTilde]al \
de periodo ",
  Cell[BoxData[
      \(TraditionalForm\`T\_1 = N\_1/F\_s\)]],
  ". En la nueva muestra el lugar que corresponde al coeficiente ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  " ser\[AAcute] igual a ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\_n\) T\_1 + 1\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Clear[samples, newsamples, signal, dftsamples, newrecov, 
      recov]\)], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operaciones simb\[OAcute]licas con la DFT", "Section"],

Cell[CellGroupData[{

Cell["C\[AAcute]lculo de la inversa", "Subsubsection"],

Cell["\<\
En principio, podemos calcular la inversa de la DFT como sigue.\
\>", "Text"],

Cell[BoxData[
    \(inversaDFT[
        lista_] := \(Table[
            lista . \[Omega][n, Length[lista]], {n, 0, Length[lista] - 1}] // 
          Simplify\) // Chop\)], "Input"],

Cell["\<\
Podemos comprobar simb\[OAcute]licamente que, efectivamente, es la inversa de \
la DFT.\
\>", "Text"],

Cell[BoxData[{
    \(DFT[inversaDFT[{a, b, c, d}]]\), "\[IndentingNewLine]", 
    \(inversaDFT[DFT[{a, b, c, d}]]\)}], "Input"],

Cell["\<\
Pero tambi\[EAcute]n podemos calcular la inversa de otra forma que quiz\
\[AAcute]s es m\[AAcute]s instructiva sobre c\[OAcute]mo trabaja la DFT. La \
gran simetr\[IAcute]a que hay entre las igualdades (1) y (2) nos sugiere \
aplicar dos veces la DFT a una misma muestra. Aqu\[IAcute] podemos ver lo que \
pasa.\
\>", "Text"],

Cell[BoxData[
    \(DFT[DFT[{a, b, c, d, e, f}]]\)], "Input"],

Cell["Ahora ya es claro lo que hay que hacer.", "Text"],

Cell[BoxData[{
    \(Reverse[%]\), "\[IndentingNewLine]", 
    \(6  RotateRight[%]\)}], "Input"],

Cell["\<\
Para calcular la inversa de la DFT, y tambi\[EAcute]n para lo que sigue despu\
\[EAcute]s, es conveniente definir el siguiente comando.\
\>", "Text"],

Cell[BoxData[
    \(\(revertida[list_] := RotateRight[Reverse[list]];\)\)], "Input"],

Cell[TextData[{
  "Este comando deja fijo el primer elemento (que corresponde a ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_0\)]],
  ") y el elemento que ocupa el lugar ",
  Cell[BoxData[
      \(TraditionalForm\`N/2 + 1\)]],
  " (que corresponde a ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(n/2\)\)]],
  "), intercambia las partes de la se\[NTilde]al comprendidas entre dichos \
elementos e invierte sus \[OAcute]rdenes relativos."
}], "Text"],

Cell[BoxData[{
    \(revertida[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 
        12}]\), "\[IndentingNewLine]", 
    \( (*\ N = 12; \ 
      quedan\ fijos\ el\ 1\ y\ el\ 7 = 
        N/2 + 1\ se\ intercambian\ entre\ s\[IAcute]\ {2, 3, 4, 5, 6}\ y\ {8, 
              9, 10, 11, 
              12}\ y\ se\ invierten\ sus\ \[OAcute]rdenes\ relativos*) \)}], \
"Input"],

Cell["\<\
Ahora es f\[AAcute]cil calcular la inversa de la DFT con la ayuda del comando \
anterior.\
\>", "Text"],

Cell[BoxData[{
    \(invDFT[muestra_] := 
      Length[muestra]*revertida[DFT[muestra]]\), "\[IndentingNewLine]", 
    \(DFT[invDFT[{1, 2, 3, 4, 5, 6}]]\), "\n", 
    \(invDFT[DFT[{1, 2, 3, 4, 5, 6}]]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Propiedades de simetr\[IAcute]a", "Subsubsection"],

Cell[TextData[{
  "Decimos que la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " es ",
  StyleBox["par",
    FontWeight->"Bold"],
  " si es sim\[EAcute]trica respecto de ",
  Cell[BoxData[
      \(TraditionalForm\`N/2\)]],
  " (suponemos que ",
  StyleBox["N",
    FontSlant->"Italic"],
  " es par), es decir, si ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(N/2 - k\) = y\_\(N/2 + k\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1,  ... , \ N/2 - 1\)]],
  ". Decimos que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " es ",
  StyleBox["impar",
    FontWeight->"Bold"],
  " si es antisim\[EAcute]trica respecto de ",
  Cell[BoxData[
      \(TraditionalForm\`N/2\)]],
  ", es decir, si ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(N/2 - k\) = \(-y\_\(N/2 + k\)\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1,  ... , \ N/2 - 1\)]],
  ". En t\[EAcute]rminos del comando \"revertida[se\[NTilde]al]\" antes \
definido, una se\[NTilde]al es par si, y s\[OAcute]lo si, coincide con su \
revertida y una se\[NTilde]al, cuyo primer coeficiente es nulo, es impar si, \
y solo si, es igual a la opuesta de su revertida.\nVamos a definir comandos \
\"par[se\[NTilde]al]\"  (\"impar[se\[NTilde]al]\") que transformen una se\
\[NTilde]al dada con un n\[UAcute]mero par de elementos en otra se\[NTilde]al \
par (impar) de forma que se verifique la igualdad se\[NTilde]al = par[se\
\[NTilde]al] + impar[se\[NTilde]al]. Adem\[AAcute]s, si la se\[NTilde]al es \
par entonces  se\[NTilde]al = par[se\[NTilde]al]."
}], "Text"],

Cell[BoxData[{
    \(par[list_] := \((list + revertida[list])\)/2\), "\[IndentingNewLine]", 
    \(impar[list_] := \((list - revertida[list])\)/2\)}], "Input"],

Cell[BoxData[{
    \(val = Table[k*Random[], {k, 1, 16}]\), "\[IndentingNewLine]", 
    \(par[val]\), "\n", 
    \(impar[val]\), "\n", 
    \(% + %% \[Equal] val\), "\[IndentingNewLine]", 
    \(par[val] \[Equal] revertida[par[val]]\), "\[IndentingNewLine]", 
    \(impar[
        val] \[Equal] \(-revertida[impar[val]]\)\), "\[IndentingNewLine]", 
    \(Clear[val]\)}], "Input"],

Cell[TextData[{
  "Lo que sigue es una comprobaci\[OAcute]n simb\[OAcute]lica de que la DFT \
de una se\[NTilde]al real de tama\[NTilde]o ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " es hemisim\[EAcute]trica, esto es, se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(-n\) = Y\&__\_n\)]],
  " donde la barra indica complejo conjugado o, lo que es igual, como ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(-n\) = Y\_\(N - n\)\)]],
  ", haciendo ",
  Cell[BoxData[
      \(TraditionalForm\`n = N/2 - k\)]],
  " obtenemos que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_\(N/2 + k\) = Y\&__\_\(N/2 - k\)\)]],
  ". Recuerda que ComplexExpand[ ] informa a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que las variables que siguen a dicho comando son reales."
}], "Text"],

Cell[BoxData[
    \(ComplexExpand[revertida[DFT[{a, b, c, d, e, f}]]] == 
      ComplexExpand[Conjugate[DFT[{a, b, c, d, e, f}]]]\)], "Input"],

Cell["\<\
Tambi\[EAcute]n podemos comprobar simb\[OAcute]licamente que la DFT de una se\
\[NTilde]al par es par y, si adem\[AAcute]s la se\[NTilde]al es real, la DFT \
es par y real. \
\>", "Text"],

Cell[BoxData[{
    \(\(trans = DFT[par[{x, y, z, u, v, w}]];\)\), "\[IndentingNewLine]", 
    \(par[trans] \[Equal] trans\), "\[IndentingNewLine]", 
    \(Simplify[
      ComplexExpand[Re[trans]] \[Equal] trans]\), "\[IndentingNewLine]", 
    \(Clear[trans]\)}], "Input"],

Cell["\<\
Igualmente, la DFT de una se\[NTilde]al impar es impar y, si adem\[AAcute]s \
la se\[NTilde]al es real, la DFT es impar e imaginaria pura. \
\>", "Text"],

Cell[BoxData[{
    \(\(trans = DFT[impar[{x, y, z, u, v, w}]];\)\), "\[IndentingNewLine]", 
    \(impar[trans] \[Equal] trans\), "\[IndentingNewLine]", 
    \(Simplify[
      ComplexExpand[Re[trans]] \[Equal] 0]\), "\[IndentingNewLine]", 
    \(Clear[trans]\)}], "Input"],

Cell["\<\
Port supuesto, podemos hacer estas comprobaciones num\[EAcute]ricamente con \
listas de n\[UAcute]meros generadas aleatoriamente.\
\>", "Text"],

Cell[BoxData[{
    \(rdmlist[n_] := Table[Random[], {n}]\), "\[IndentingNewLine]", 
    \(\(a = rdmlist[32];\)\), "\[IndentingNewLine]", 
    \(\(b = rdmlist[32];\)\), "\[IndentingNewLine]", 
    \(\(\(c = a + I\ b;\)\(\[IndentingNewLine]\)
    \) (*\ 
      comprobamos\ que\ la\ DFT\ de\ una\ se\[NTilde]al\ par\ es\ una\ se\
\[NTilde]al\ par\ *) \), "\[IndentingNewLine]", 
    \(\(\(DFT[par[c]] \[Equal] par[DFT[par[c]]]\)\(\[IndentingNewLine]\)
    \) (*\ 
      comprobamos\ que\ la\ DFT\ de\ una\ se\[NTilde]al\ impar\ es\ una\ se\
\[NTilde]al\ impar\ *) \), "\n", 
    \(\(\(DFT[impar[c]] \[Equal] 
      impar[DFT[impar[c]]]\)\(\[IndentingNewLine]\)
    \) (*\ 
      comprobamos\ que\ la\ DFT\ de\ una\ se\[NTilde]al\ real\ es\ una\ se\
\[NTilde]al\ hemisim\[EAcute]trica\ *) \), "\[IndentingNewLine]", 
    \(\(\(revertida[DFT[a]] == Conjugate[DFT[a]]\)\(\[IndentingNewLine]\)
    \) (*\ 
      comprobamos\ que\ la\ DFT\ de\ una\ se\[NTilde]al\ par\ y\ real\ es\ \
una\ se\[NTilde]al\ par\ y\ real\ *) \), "\[IndentingNewLine]", 
    \(\(\(DFT[par[a]] \[Equal] par[DFT[par[a]]] \[Equal] 
      Re[DFT[par[a]]]\)\(\[IndentingNewLine]\)
    \) (*\ 
      comprobamos\ que\ la\ DFT\ de\ una\ se\[NTilde]al\ impar\ y\ real\ es\ \
una\ se\[NTilde]al\ par\ puramente\ imaginaria\ *) \), "\[IndentingNewLine]", \

    \(DFT[impar[a]] \[Equal] impar[DFT[impar[a]]] \[Equal] 
      I*Im[DFT[impar[a]]]\), "\[IndentingNewLine]", 
    \(Clear[a, b, c]\)}], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "DFT en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tiene un comando \"Fourier[lista]\" para calcular la DFT que usa el \
algoritmo de la Transformada R\[AAcute]pida de Fourier. Pero ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " define la DFT en la forma siguiente:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"\t", 
        FormBox[\(Y\_n = \(1\/\@N\) \(\[Sum]\+\(k = 1\)\%N\(\( 
                      y\_k\) \(\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ \
\((n - 1)\) \((\ k - 1)\)/N\)\)\(\ \ \ \ \ \ \ \ \ \ \ \ \)\((n = 1, 
                    2,  ... , N)\)\(\ \)\)\)\),
          "TraditionalForm"]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "es decir, divide por ",
  Cell[BoxData[
      \(TraditionalForm\`\@N\)]],
  "en vez de por ",
  StyleBox["N",
    FontSlant->"Italic"],
  " y conjuga las exponenciales. Para que el comando \"Fourier[lista]\" \
proporcione la DFT que hemos definido nosotros hay que ajustar unos par\
\[AAcute]metros (consulta la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "). Ejecuta las siguientes celdas para entender la relaci\[OAcute]n entre \
nuestro comando DFT[ ] y Fourier[ ]."
}], "Text"],

Cell[BoxData[{
    \(DFT[{1.  + 1.  I, 2. , 3. , 4. , 5. }]\), "\[IndentingNewLine]", 
    \(1/Sqrt[5. ] 
      RotateLeft[
        Reverse[Fourier[{1.  + I, 2. , 3. , 4. , 5. }]], \(-1\)]\), "\n", 
    \(Fourier[{1.  + 1.  I, 2. , 3. , 4. , 5. }, 
      FourierParameters \[Rule] {\(-1\), \(-1\)}]\)}], "Input"],

Cell["\<\
No te debe caber duda de cu\[AAcute]l es el que hay que usar para hacer c\
\[AAcute]lculos.\
\>", "Text"],

Cell[BoxData[
    \(\(\(Clear[lista, azarlista]\[IndentingNewLine]
    \(azarlista = Table[Random[], {1024}];\)\[IndentingNewLine]
    \(Timing[
        Fourier[azarlista, 
          FourierParameters \[Rule] {\(-1\), \(-1\)}]]\)[\([1]\)]\)\(\ \)\( \
(*\ visto\ y\ no\ visto\ *) \)\)\)], "Input"],

Cell[BoxData[{
    \(\(Timing[DFT[azarlista]]\)[\([1]\)] (*\ espera\ un\ poco, \ 
      ten\ paciencia; \ 
      hay\ que\ hacer\ m\[AAcute]s\ de\ un\ mill\[OAcute]n\ de\ operaciones\ *) \
\), "\[IndentingNewLine]", 
    \(Clear[azarlista]\)}], "Input"],

Cell[TextData[{
  "Ahora puedes apreciar el ahorro que proporciona el algoritmo de la \
transformada r\[AAcute]pida de Fourier. Pongamos a prueba el algoritmo con \
una muestra grande de ",
  Cell[BoxData[
      \(TraditionalForm\`2\^15 = 32678\)]],
  " datos. Solamente pretender almacenar la matriz de los \[Omega][n,N] para \
N=32678 ya ser\[IAcute]a un problema. "
}], "Text"],

Cell[BoxData[{
    \(\(azarlista = Table[Random[], {32678}];\)\), "\[IndentingNewLine]", 
    \(\(Timing[
        Fourier[azarlista, 
          FourierParameters \[Rule] {\(-1\), \(-1\)}]]\)[\([1]\)]\), "\
\[IndentingNewLine]", 
    \(Clear[azarlista]\)}], "Input"],

Cell["No est\[AAcute] mal \[DownQuestion]verdad?.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transformada de Fourier Discreta y convoluci\[OAcute]n \
c\[IAcute]clica", "Section"],

Cell[TextData[{
  "Estudiemos ahora la relaci\[OAcute]n entre DFT y la convoluci\[OAcute]n c\
\[IAcute]clica. Dados dos vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          "=", \((x\_0, x\_\(\(1\)\(,\)\) ... , x\_\(N - 1\))\)}], 
        TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], 
          "=", \((y\_0, y\_\(\(1\)\(,\)\) ... , y\_\(N - 1\))\)}], 
        TraditionalForm]]],
  ", se define su convoluci\[OAcute]n circular o c\[IAcute]clica como el \
vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["z",
            FontWeight->"Bold"], "=", 
          StyleBox[
            RowBox[{"x", 
              FormBox[\(\(\ \)\(\[CircleDot]\)\),
                "TraditionalForm"], " ", "y"}],
            FontWeight->"Bold"]}], TraditionalForm]]],
  " dado por el producto matricial siguiente\n\n\t\t\t",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"(", GridBox[{
                {\(z\_0\)},
                {\(z\_1\)},
                {\(z\_2\)},
                {"..."},
                {\(z\_\(N - 1\)\)}
                }], ")"}], "  "}], TraditionalForm]]],
  "=  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", GridBox[{
              {\(y\_0\), \(y\_\(N - 1\)\), \(y\_\(N - 2\)\), \(y\_\(N - 3\)\),
                 "...", "...", "...", "...", \(y\_1\)},
              {\(y\_1\), \(y\_0\), \(y\_\(N - 1\)\), \(y\_\(N - 2\)\), "...", 
                "...", "...", "...", \(y\_2\)},
              {\(y\_2\), \(y\_1\), \(y\_0\), \(y\_\(N - 1\)\), "...", "...", "...",
                 "...", \(y\_3\)},
              {"...", "...", "...", "...", "...", "...", "...", "...", 
                "..."},
              {\(y\_\(N - 1\)\), \(y\_\(N - 2\)\), \(y\_\(N - 
                      3\)\), \(y\_\(N - 4\)\), "...", "...", "...", 
                "...", \(y\_0\)}
              }], ")"}], TraditionalForm]]],
  Cell[BoxData[
      FormBox[
        RowBox[{"(", GridBox[{
              {\(x\_0\)},
              {\(x\_1\)},
              {\(x\_2\)},
              {"..."},
              {\(x\_\(N - 1\)\)}
              }], ")"}], TraditionalForm]]],
  "\n\t\t\t"
}], "Text"],

Cell[TextData[{
  "Las matrices como la anterior se llaman ",
  StyleBox["matrices circulantes",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " proporciona comandos que permiten obtener f\[AAcute]cilmente una matriz \
circulante cuya primera columna es una lista dada. Basta para ello observar \
que cada columna en una matriz circulante se obtiene rotando hacia la derecha \
un lugar la columna precedente. El siguiente comando hace este trabajo."
}], "Text"],

Cell[BoxData[{
    \(CirculantMatrix[lista_] := 
      Transpose[
        NestList[RotateRight, lista, 
          Length[lista] - 1]]\), "\[IndentingNewLine]", 
    \(CirculantMatrix[Range[8]] // MatrixForm\)}], "Input"],

Cell["\<\
Con ayuda de este comando podemos definir otro que calcule la convoluci\
\[OAcute]n c\[IAcute]clica de dos vectores.\
\>", "Text"],

Cell[BoxData[
    \(CiclicConvolve[x_, y_] := CirculantMatrix[y] . x\)], "Input"],

Cell["\<\
Podemos comprobar simb\[OAcute]licamente la propiedad conmutativa de la \
convoluci\[OAcute]n.\
\>", "Text"],

Cell[BoxData[
    \(CiclicConvolve[{a, b, c, d}, {x, y, z, u}] \[Equal] 
      CiclicConvolve[{x, y, z, u}, {a, b, c, d}]\)], "Input"],

Cell["\<\
Una importante propiedad de la DFT es que la DFT de una convoluci\[OAcute]n c\
\[IAcute]clica de dos se\[NTilde]ales es igual al producto punto a punto de \
las DFT de cada se\[NTilde]al multiplicado por la longitud com\[UAcute]n de \
las se\[NTilde]ales. Esto es, se verifica la igualdad.\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      FrameBox[
        FormBox[
          RowBox[{
            RowBox[{"\[ScriptCapitalF]", " ", 
              RowBox[{"(", 
                RowBox[{
                  StyleBox["x",
                    FontWeight->"Bold"], 
                  FormBox[\(\(\ \)\(\[CircleDot]\)\),
                    "TraditionalForm"], " ", 
                  StyleBox["y",
                    FontWeight->"Bold"]}], 
                StyleBox[")",
                  FontWeight->"Bold"]}]}], 
            StyleBox["=",
              FontWeight->"Bold"], 
            RowBox[{
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["N",
                      FontWeight->"Bold"], "\[ScriptCapitalF]"}]], "(", 
                StyleBox["x",
                  FontWeight->"Bold"], ")"}], 
              RowBox[{"\[ScriptCapitalF]", "(", 
                StyleBox["y",
                  FontWeight->"Bold"], ")"}]}]}],
          "TraditionalForm"]], TraditionalForm]]]], "NumberedEquation",
  TextAlignment->Center],

Cell["Podemos tambi\[EAcute]n comprobar simb\[OAcute]licamente dicha \
igualdad.", "Text"],

Cell[BoxData[
    \(Simplify[
      DFT[CiclicConvolve[{a, b, c, d}, {x, y, z, u}]] == \[IndentingNewLine]4 
           DFT[{a, b, c, d}] DFT[{x, y, z, u}]]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de un comando \"ListConvolve[n\[UAcute]cleo,lista]\" que, con un \
ajuste de par\[AAcute]metros, permite calcular convoluciones \
c\[IAcute]clicas."
}], "Text"],

Cell[BoxData[
    \(Simplify[
      ListConvolve[{a, b, c, d}, {x, y, z, u}, 1] == 
        CiclicConvolve[{a, b, c, d}, {x, y, z, u}]]\)], "Input"],

Cell["\<\
El comando ListConvolve[ ] es much\[IAcute]simo m\[AAcute]s general y uno de \
los m\[AAcute]s \[UAcute]tiles para tratamiento digital de se\[NTilde]ales.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dise\[NTilde]o de filtros en el dominio de la frecuencia", "Section"],

Cell[TextData[{
  "Sabemos que los filtros (sistemas lineales invariantes en el tiempo y \
continuos)  act\[UAcute]an por convoluci\[OAcute]n. Te lo recuerdo \
brevemente. Si ",
  Cell[BoxData[
      \(TraditionalForm\`L\)]],
  " es un filtro y \[Delta] es la funci\[OAcute]n impulso unidad discreta, \
esto es, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta](n) = 0\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`n \[NotEqual] \ 0\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta](0) = 1\)]],
  "; se llama ",
  StyleBox["respuesta impulsiva",
    FontWeight->"Bold"],
  " del filtro a la se\[NTilde]al, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["h",
            FontWeight->"Bold"], "=", \(L(\[Delta])\)}], TraditionalForm]]],
  ", esto es ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["h",
              FontWeight->"Bold"], "(", "n", ")"}], 
          "=", \(\(L(\[Delta])\) \((n)\)\)}], TraditionalForm]]],
  " para todo entero ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ". ",
  "P",
  "ara cada entero ",
  StyleBox["k ",
    FontSlant->"Italic"],
  "definimos el operador de desplazamiento o traslaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[Tau]\_k\)]],
  " como el operador que convierte cada se\[NTilde]al discreta ",
  StyleBox["z",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en una nueva se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Tau]\_k\), "\[SmallCircle]", 
          StyleBox["z",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], TraditionalForm]]],
  " dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"(", 
              RowBox[{\(\[Tau]\_k\), "\[SmallCircle]", 
                StyleBox["z",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}], 
              StyleBox[")",
                FontWeight->"Bold",
                FontSlant->"Italic"]}], 
            RowBox[{"(", 
              StyleBox["n",
                FontWeight->"Plain",
                FontSlant->"Italic"], 
              StyleBox[")",
                FontWeight->"Plain",
                FontSlant->"Plain"]}]}], 
          StyleBox["=",
            FontWeight->"Plain",
            FontSlant->"Plain"], 
          RowBox[{
            StyleBox["z",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["(",
              FontWeight->"Plain",
              FontSlant->"Plain"], 
            StyleBox[\(n - k\),
              FontWeight->"Plain",
              FontSlant->"Italic"], 
            StyleBox[")",
              FontWeight->"Plain",
              FontSlant->"Plain"]}], " "}], TraditionalForm]]],
  "para todo entero ",
  StyleBox["n.",
    FontSlant->"Italic"],
  " ",
  "Si ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], "=", \(x(n)\)}], TraditionalForm]]],
  " es una se\[NTilde]al cualquiera tenemos que:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"L", "(", 
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox[")",
            FontWeight->"Plain"]}], 
        StyleBox["=",
          FontWeight->"Plain"], 
        RowBox[{
          RowBox[{
            StyleBox["L",
              FontWeight->"Plain"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            RowBox[{\(\[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\), 
              RowBox[{
                RowBox[{
                  StyleBox["x",
                    FontWeight->"Bold"], "(", "k", 
                  ")"}], \(\[Tau]\_k\[SmallCircle]\[Delta]\)}]}], ")"}], "=", 
          
          RowBox[{
            RowBox[{\(\[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\), 
              RowBox[{
                RowBox[{
                  StyleBox["x",
                    FontWeight->"Bold"], "(", "k", 
                  ")"}], \(L(\[Tau]\_k\[SmallCircle]\[Delta])\)}]}], "=", 
            RowBox[{
              RowBox[{\(\[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\), 
                RowBox[{
                  RowBox[{
                    StyleBox["x",
                      FontWeight->"Bold"], "(", "k", 
                    ")"}], \(\[Tau]\_k\[SmallCircle]\(L(\[Delta])\)\)}]}], 
              "=", 
              RowBox[{\(\[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\), 
                RowBox[{
                  RowBox[{
                    StyleBox["x",
                      FontWeight->"Bold"], "(", "k", ")"}], 
                  RowBox[{\(\[Tau]\_k\), "\[SmallCircle]", 
                    StyleBox["h",
                      FontWeight->"Bold"]}]}]}]}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Donde hemos usado la invariancia por traslaciones, la linealidad y la \
continuidad del filtro. Es decir, para todo entero ",
  StyleBox["n",
    FontSlant->"Italic"],
  " se tiene que"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          RowBox[{
            RowBox[{"L", "(", 
              StyleBox["x",
                FontWeight->"Bold"], 
              StyleBox[")",
                FontWeight->"Plain"]}], 
            StyleBox[\((n)\),
              FontWeight->"Plain"]}], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{\(\[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\), 
              RowBox[{
                RowBox[{
                  StyleBox["x",
                    FontWeight->"Bold"], "(", "k", ")"}], 
                RowBox[{"(", 
                  RowBox[{\(\[Tau]\_k\), "\[SmallCircle]", 
                    StyleBox["h",
                      FontWeight->"Bold"]}], ")"}], \((n)\)}]}], "=", 
            RowBox[{\(\[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\), 
              RowBox[{
                RowBox[{
                  StyleBox["x",
                    FontWeight->"Bold"], "(", "k", ")"}], 
                RowBox[{
                  StyleBox["h",
                    FontWeight->"Bold"], "(", \(n - k\), ")"}]}]}]}]}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "La convoluci\[OAcute]n de dos se\[NTilde]ales discretas ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x, \ y\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se define como la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\[Star]y\),
          FontWeight->"Bold"], TraditionalForm]]],
  " dada para todo ",
  Cell[BoxData[
      \(TraditionalForm\`n \[Element] \[DoubleStruckZ]\)]],
  " por "
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], 
            StyleBox["\[Star]",
              FontWeight->"Bold"], 
            RowBox[{
              StyleBox["y",
                FontWeight->"Bold"], "(", "n", ")"}]}], "=", 
          RowBox[{\(\[Sum]\+\(k = \(-\[Infinity]\)\)\%\[Infinity]\), 
            RowBox[{
              RowBox[{
                StyleBox["x",
                  FontWeight->"Bold"], "(", "k", ")"}], 
              RowBox[{
                StyleBox["y",
                  FontWeight->"Bold"], "(", \(n - k\), ")"}]}]}]}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "Por tanto, la respuesta de un filtro a una se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox["n",
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}]}], TraditionalForm]]],
  " se obtiene por convoluci\[OAcute]n de dicha se\[NTilde]al con la \
respuesta impulsiva del filtro ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["h",
            FontWeight->"Bold"], "=", 
          RowBox[{
            StyleBox["h",
              FontWeight->"Bold"], "(", "n", ")"}]}], TraditionalForm]]],
  ". Si, adem\[AAcute]s el filtro es ",
  StyleBox["causal",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", es decir, la salida del sistema en cualquier instante ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " (esto es, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "(", "n", ")"}], TraditionalForm]]],
  ") depende s\[OAcute]lo de las entradas presentes y pasadas (es decir, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], "(", "n", ")"}], ",", " ", 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], "(", \(n - 1\), ")"}], ",", " ", 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], "(", \(n - 2\), ")"}], ",", "..."}], 
        TraditionalForm]]],
  "), entonces debe ocurrir que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["h",
              FontWeight->"Bold"], "(", "n", ")"}], "=", "0", " "}], 
        TraditionalForm]]],
  "para todo ",
  Cell[BoxData[
      \(TraditionalForm\`n < 0\)]],
  ". Si, adem\[AAcute]s, la funci\[OAcute]n respuesta impulsiva del filtro es \
de duraci\[OAcute]n finita, esto es, si ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["h",
              FontWeight->"Bold"], "(", "n", ")"}], "=", "0"}], 
        TraditionalForm]]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`n \[GreaterEqual] M\)]],
  " entonces tenemos lo que se llama un ",
  StyleBox["filtro de respuesta impulsiva finita",
    FontWeight->"Bold"],
  " (FIR) causal. La acci\[OAcute]n de dicho filtro viene dada por"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          RowBox[{
            StyleBox["y",
              FontWeight->"Bold"], "(", "n", ")"}], "=", 
          RowBox[{\(\[Sum]\+\(k = 0\)\%\(M - 1\)\), 
            RowBox[{
              RowBox[{
                StyleBox["h",
                  FontWeight->"Bold"], "(", "k", ")"}], 
              RowBox[{
                StyleBox["x",
                  FontWeight->"Bold"], "(", \(n - k\), ")"}], " "}]}]}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "Llegados a este punto, una hip\[OAcute]tesis usual en tratamiento digital \
de se\[NTilde]ales es que la se\[NTilde]al de entrada ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], "=", 
            RowBox[{
              StyleBox["x",
                FontWeight->"Bold"], "(", "n", ")"}]}]}], TraditionalForm]]],
  " tiene igual duraci\[OAcute]n finita que la respuesta impulsiva y que \
ambas se\[NTilde]ales son peri\[OAcute]dicas con per\[IAcute]odo ",
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  ", esto es ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox[\(k + M\),
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox["k",
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["h",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox[\(k + M\),
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox["h",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox["k",
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}]}], TraditionalForm]]],
  " para todo entero ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  ". En estas hip\[OAcute]tesis (que comentaremos en la secci\[OAcute]n \
siguiente) la convoluci\[OAcute]n dada por (11) es de hecho ",
  StyleBox["una convoluci\[OAcute]n c\[IAcute]clica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " de los vectores ",
  Cell[BoxData[
      \(TraditionalForm\`\((x(0), x(1), x(2),  ... , x(M - 1))\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\((h(0), h(1), h(2),  ... , h(M - 1))\)\)]],
  ". Podemos por ello representar la acci\[OAcute]n del filtro en la forma ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(y = x\[CircleDot]\ h\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". Tomando transformadas de Fourier discretas, como las que usa ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " por defecto, obtenemos, notando las correspondiente transformadas con \
letras may\[UAcute]sculas, ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(Y = \@M\ X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  " donde el producto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se entiende coordenada a coordenada. La se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox["H",
          FontWeight->"Bold"], TraditionalForm]]],
  " se llama ",
  StyleBox["funci\[OAcute]n de transferencia",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " del filtro y es la DFT de la funci\[OAcute]n respuesta impulsiva. "
}], "Text"],

Cell[TextData[{
  "El dise\[NTilde]o de filtros en el dominio de la frecuencia consiste en \
definir una funci\[OAcute]n de transferencia que haga el trabajo deseado. Si, \
por ejemplo, queremos dejar pasar unas determinadas frecuencias sin alterar y \
eliminar las frecuencias restantes, nuestra funci\[OAcute]n de transferencia \
tendr\[AAcute] un 1 en los lugares correspondientes a las frecuencias que \
queremos dejar inalteradas y un 0 en los dem\[AAcute]s lugares; de esta forma \
el producto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  " dejar\[AAcute] iguales los lugares (las componentes) de ",
  Cell[BoxData[
      FormBox[
        StyleBox["X",
          FontWeight->"Bold"], TraditionalForm]]],
  " correspondientes a las frecuencias que queremos dejar pasar inalteradas y \
en los dem\[AAcute]s lugares aparecer\[AAcute] un 0 eliminando de esa forma \
las frecuencias no deseadas. \nUna vez construida la funci\[OAcute]n de \
transferencia, la respuesta del filtro a una se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          FontWeight->"Bold"], TraditionalForm]]],
  " en el dominio del tiempo se obtiene calculando la DFT inversa de ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\@M\ X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  "; de hecho ",
  Cell[BoxData[
      FormBox[
        SqrtBox[
          StyleBox["M",
            FontWeight->"Bold"]], TraditionalForm]]],
  " es un factor de escala que suele ignorarse en la pr\[AAcute]ctica. \
Alternativamente, una vez obtenida ",
  Cell[BoxData[
      FormBox[
        StyleBox["H",
          FontWeight->"Bold"], TraditionalForm]]],
  " se puede obtener, por DFT inversa, la funci\[OAcute]n respuesta impulsiva \
",
  Cell[BoxData[
      FormBox[
        StyleBox["h",
          FontWeight->"Bold"], TraditionalForm]]],
  " y puede obtenerse la respuesta del filtro a una se\[NTilde]al de entrada \
",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          FontWeight->"Bold"], TraditionalForm]]],
  " por medio de la convoluci\[OAcute]n c\[IAcute]clica ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\[CircleDot]\ h\),
          FontWeight->"Bold"], TraditionalForm]]],
  "; pero este m\[EAcute]todo es menos eficiente que el basado en la DFT que \
consiste en calcular ",
  Cell[BoxData[
      FormBox[
        StyleBox["X",
          FontWeight->"Bold"], TraditionalForm]]],
  ", multiplicar por ",
  Cell[BoxData[
      FormBox[
        StyleBox["H",
          FontWeight->"Bold"], TraditionalForm]]],
  " y por ",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\@M\),
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "y tomar DFT inversa",
  StyleBox[". \n",
    FontWeight->"Bold"],
  "En la pr\[AAcute]ctica se ignora",
  StyleBox[" ",
    FontWeight->"Bold"],
  "el factor de escala ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\@M\),
          FontWeight->"Bold"], TraditionalForm]]],
  "; por ejemplo, si la se\[NTilde]al representa un sonido, multiplicarla por \
un n\[UAcute]mero positivo es algo que no se puede apreciar cuando se \
reproduce; adem\[AAcute]s la mayor\[IAcute]a de los formatos de sonido \
ajustan los valores a un intervalo prefijado.",
  StyleBox[" ",
    FontWeight->"Bold"]
}], "Text"],

Cell["Ejemplo", "Example"],

Cell["\<\
Consideremos la siguiente se\[NTilde]al formada por varias sinusoides de \
distintas frecuencias y amplitudes.\
\>", "Text"],

Cell[BoxData[{
    \(Clear[f]\), "\[IndentingNewLine]", 
    \(\(f[t_] = 
        0.3\ Cos[400\ 2  Pi\ t] + 0.6\ Sin[1200\ 2\ Pi\ t] + 
          0.3\ Cos[1600\ 2\ Pi\ t] + 0.3\ Cos[3600\ 2\ Pi\ t] - 
          0.5  Sin[2400\ 2  \[Pi]\ t];\)\)}], "Input"],

Cell["\<\
El periodo fundamental de esta se\[NTilde]al es T=1/400 y la frecuencia m\
\[AAcute]s alta es 3600 Herzios. Para detectar todas las frecuencias \
presentes en esta se\[NTilde]al ser\[AAcute] suficiente tomar 8000 muestras \
en el tiempo de 1/400 segundos, lo que nos da un total de 20 muestras.\
\>", "Text"],

Cell[BoxData[
    \(samples = muestra[f, 8000, 1/400]\)], "Input"],

Cell[TextData[{
  "Queremos dise\[NTilde]ar un filtro que al actuar sobre esta muestra anule \
las frecuencias m\[AAcute]s altas 2400 y 3600 y deje las dem\[AAcute]s como \
est\[AAcute]n. Para ello definimos la funci\[OAcute]n de transferencia del \
filtro que tendr\[AAcute], igual que la muestra, 20 elementos, a la que \
llamaremos H, de forma que el producto H*DFT[samples] tenga los mismos \
elementos que DFT[samples] excepto los que corresponden a las frecuencias \
2400 y 3600 que deben ser cero. \nEl coeficiente ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  " de DFT[samples] representa la frecuencia ",
  Cell[BoxData[
      \(TraditionalForm\`n/T = 400  n\)]],
  ", por tanto los elementos de H deben ser todos iguales a 1 excepto los que \
ocupan los lugares correspondientes a ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Y\_6\)\(\ \)\)\)]],
  "y a ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_9\)]],
  " que son los lugares 7 y 10 (\[DownExclamation]no olvidemos que ",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n\)]],
  " empieza con ",
  Cell[BoxData[
      \(TraditionalForm\`n = 0\)]],
  "!). Adem\[AAcute]s H debe ser igual a la DFT de la respuesta impulsiva del \
filtro, que es una se\[NTilde]al real, por tanto H debe ser \
hemisim\[EAcute]trica y, como H es real, eso quiere decir que H debe ser par. \
Con estos datos ya podemos definir H. Para no equivocarnos, es preferible \
definir la primera mitad de H y despu\[EAcute]s completar el resto por simetr\
\[IAcute]a."
}], "Text"],

Cell[BoxData[{
    \(\(mitad = 
        Table[If[n \[NotEqual] 7 && n \[NotEqual] 10, 1.0, 0.0], {n, 1, 
            11}];\)\), "\[IndentingNewLine]", 
    \(H = Join[mitad, Reverse[Most[Rest[mitad]]]]\)}], "Input"],

Cell[TextData[{
  "La acci\[OAcute]n de este filtro sobre una muestra ",
  StyleBox["en el dominio de la frecuencia",
    FontWeight->"Bold"],
  " viene dada por el producto H*DFT[muestra]."
}], "Text"],

Cell[BoxData[
    \(salida = H*Fourier[samples] // Chop\)], "Input"],

Cell[TextData[{
  "La acci\[OAcute]n de este filtro sobre una muestra ",
  StyleBox["en el dominio del tiempo",
    FontWeight->"Bold"],
  " viene dada por la convoluci\[OAcute]n c\[IAcute]clica ",
  StyleBox["h",
    FontWeight->"Bold"],
  "\[CircleDot]muestra donde ",
  StyleBox["h ",
    FontWeight->"Bold"],
  "es la respuesta impulsiva."
}], "Text"],

Cell[BoxData[{
    \(h = InverseFourier[H] // Chop\), "\[IndentingNewLine]", 
    \(output = ListConvolve[h, samples, 1] // Chop\)}], "Input"],

Cell["\<\
F\[IAcute]jate en que la acci\[OAcute]n del filtro en el dominio del tiempo \
es mucho m\[AAcute]s complicada que su acci\[OAcute]n en el espacio de la \
frecuencia. Podemos comprobar los resultados anteriores.\
\>", "Text"],

Cell[BoxData[
    \(\((Fourier[output] // Chop)\) == \@20*salida\)], "Input"],

Cell[TextData[{
  "Calculemos, usando el polinomio interpolador, la se\[NTilde]al \
correspondiente a la salida obtenida. Como hemos usado el comando de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " y nuestro polinomio interpolador est\[AAcute] definido usando nuestra \
DFT, debemos ajustar la salida multiplicando por ",
  Cell[BoxData[
      \(TraditionalForm\`1/\@20\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(\(interpol[output/\@20. ]\)[1/400]\)[t]\)], "Input"],

Cell["\<\
Efectivamente, es la misma se\[NTilde]al en la que han desaparecido las dos \
frecuencias m\[AAcute]s altas. Finalmente, comprobemos que la muestra tomada \
detecta todas las frecuencias presentes y permite recuperar la se\[NTilde]al \
de partida.\
\>", "Text"],

Cell[BoxData[
    \(\(\(interpol[samples]\)[1/400]\)[t]\)], "Input"],

Cell["\<\
Podemos escuchar la funci\[OAcute]n con el comado Play[ ] que tiene una opci\
\[OAcute]n \"SampleRate\" que permite especificar la raz\[OAcute]n de \
muestreo (n\[UAcute]mero de muestras tomadas por segundo). Para que se oiga \
algo hay que usar una raz\[OAcute]n de muestreo suficientemente alta.\
\>", "Text"],

Cell[BoxData[
    \(\(Play[f[t], {t, 0, 1}, SampleRate \[Rule] 24000];\)\)], "Input"],

Cell[TextData[{
  "Lo que hemos escuchado es el sonido correspondiente a una muestra de 24000 \
valores de la se\[NTilde]al tomados con una raz\[OAcute]n de muestreo ",
  Cell[BoxData[
      \(TraditionalForm\`N\_s = 24000\)]],
  " muestras por segundo. Podemos hacer ahora igual que antes y eliminar en \
dicha muestra las frecuencias mayores. La muestra ahora tiene ",
  Cell[BoxData[
      \(TraditionalForm\`N = 24000\)]],
  " elementos. Con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " podemos oir listas de n\[UAcute]meros con el comando ListPlay[ ]."
}], "Text"],

Cell[BoxData[{
    \(\(valores = muestra[f, 24000, 1];\)\), "\[IndentingNewLine]", 
    \(\(ListPlay[valores, PlayRange \[Rule] All, 
        SampleRate \[Rule] 24000];\)\), "\[IndentingNewLine]", 
    \( (*\ es\ el\ mismo\ sonido\ anterior\ *) \)}], "Input"],

Cell[TextData[{
  "Ahora debemos considerar que la muestra obtenida corresponde a una se\
\[NTilde]al con periodo ",
  Cell[BoxData[
      \(TraditionalForm\`T = \(N/N\_s = 1\)\)]],
  ". El coeficiente ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Y\_n\)\(\ \)\)\)]],
  "de la DFT de la muestra obtenida representa la frecuencia ",
  Cell[BoxData[
      \(TraditionalForm\`n/T = n\)]],
  ". Para anular las frecuencias 2400 y 3600 debemos anular los ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(Y\_n\)\(\ \)\)\)]],
  "para n=2400 y n=3600, es decir, los lugares 24001 y 3601 de la DFT de la \
muestra. Con esto ya podemos dise\[NTilde]ar la funci\[OAcute]n de \
transferencia."
}], "Text"],

Cell[BoxData[{
    \(\(Clear[H, mitad];\)\), "\[IndentingNewLine]", 
    \(\(mitad = 
        Table[If[n \[NotEqual] 2401 && n \[NotEqual] 3601, 1.0, 0.0], {n, 1, 
            12001}];\)\), "\n", 
    \(\(H = Join[mitad, Reverse[Most[Rest[mitad]]]];\)\)}], "Input"],

Cell["La acci\[OAcute]n de este filtro viene dada por.", "Text"],

Cell[BoxData[{
    \(\(dftvalores = Fourier[valores] // Chop;\)\), "\[IndentingNewLine]", 
    \(\(output = InverseFourier[H*dftvalores] // Chop;\)\)}], "Input"],

Cell["\<\
Observa que, como es de esperar, en Fourier[valores] casi todos los elementos \
son nulos.\
\>", "Text"],

Cell[BoxData[
    \(Count[dftvalores, 0]\)], "Input"],

Cell["\<\
Los elementos no nulos se corresponden con las frecuencias presentes en la \
muestra.\
\>", "Text"],

Cell[BoxData[
    \(\(\(Position[
        dftvalores, _?\((# \[NotEqual] 0 &)\)]\)\(-\)\(1\)\(\ \)\)\)], "Input"],

Cell["\<\
Podemos escuchar la salida obtenida con el comando ListPlay[ ].\
\>", "Text"],

Cell[BoxData[
    \(\(ListPlay[output, PlayRange \[Rule] All, 
        SampleRate \[Rule] 24000];\)\)], "Input"],

Cell["\<\
Si comparas con el sonido anterior ver\[AAcute]s que \[EAcute]ste \
\[UAcute]ltimo, al haberse suprimido las frecuencias m\[AAcute]s altas, es m\
\[AAcute]s grave. Finalmente, veamos la se\[NTilde]al que se recupera a \
partir de la salida obtenida. Como hay muchos datos, vamos a modificar el \
comando que calcula el polinomio interpolador de forma apropiada.\
\>", "Text"],

Cell[BoxData[{
    \(\(\(fastinterpol[muestra_ /; EvenQ[Length[muestra]]]\)[period_]\)[
        t_] := \[IndentingNewLine]\(\(Dot[
              RotateRight[
                Fourier[muestra, FourierParameters \[Rule] {\(-1\), \(-1\)}], 
                Length[muestra]/2], 
              Exp[2  \[ImaginaryI]\ \[Pi]\ Range[\(-Length[muestra]\)/2, 
                    Length[muestra]/2\  - 1]\ t/period]] // ComplexExpand\) // 
          Simplify\) // Chop\), "\[IndentingNewLine]", 
    \(\(\(fastinterpol[muestra_ /; EvenQ[Length[muestra]] \[Equal] False]\)[
          period_]\)[
        t_] := "\<La muestra debe tener un n\[UAcute]mero par de elementos\>"\
\)}], "Input"],

Cell[TextData[{
  "Para recuperar la se\[NTilde]al correspondiente a la muestra \"output\" \
basta tomar en consideraci\[OAcute]n los valores correspondientes a un \
periodo. De hecho, \"output\" (al igual que valores) es peri\[OAcute]dica con \
periodo ",
  Cell[BoxData[
      \(TraditionalForm\`24000/400 = 60\)]],
  " (n\[UAcute]mero de muestras por periodo)."
}], "Text"],

Cell[BoxData[{
    \(Simplify[\((Take[valores, 60] - Take[valores, {61, 120}] // 
            Chop)\) \[Equal] 0]\), "\[IndentingNewLine]", 
    \(Take[output, 60] \[Equal] Take[output, {61, 120}]\)}], "Input"],

Cell[BoxData[
    \(\(\(fastinterpol[Take[output, 24000/400]]\)[1/400]\)[t]\)], "Input"],

Cell["\<\
Efectivamente, es la se\[NTilde]al de partida en la que se han suprimido las \
dos frecuencias m\[AAcute]s altas.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filtrado lineal", "Section"],

Cell["\<\
En la secci\[OAcute]n anterior, al llegar a la igualdad de \
convoluci\[OAcute]n (convoluci\[OAcute]n que  a veces se llama \"lineal\" \
para distinguirla de la convoluci\[OAcute]n circular)\
\>", "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          RowBox[{
            StyleBox["y",
              FontWeight->"Bold"], "(", "n", ")"}], "=", 
          RowBox[{
            RowBox[{
              RowBox[{"(", 
                StyleBox[\(x*h\),
                  FontWeight->"Bold"], 
                StyleBox[")",
                  FontWeight->"Bold"]}], \((n)\)}], "=", 
            RowBox[{\(\[Sum]\+\(k = 0\)\%\(M - 1\)\), 
              RowBox[{
                RowBox[{
                  StyleBox["h",
                    FontWeight->"Bold"], "(", "k", ")"}], 
                RowBox[{
                  StyleBox["x",
                    FontWeight->"Bold"], "(", \(n - k\), ")"}], " "}]}]}]}]], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "se supuso que la se\[NTilde]al de entrada ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], "=", 
            RowBox[{
              StyleBox["x",
                FontWeight->"Bold"], "(", "n", ")"}]}]}], TraditionalForm]]],
  " tiene igual duraci\[OAcute]n finita, ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(M\)\(,\)\)\)]],
  " que la respuesta impulsiva y que ambas se\[NTilde]ales son \
peri\[OAcute]dicas con per\[IAcute]odo ",
  Cell[BoxData[
      \(TraditionalForm\`M\)]],
  ". En estas hip\[OAcute]tesis, la convoluci\[OAcute]n (12) es de hecho una \
convoluci\[OAcute]n c\[IAcute]clica. Prescindamos de la hip\[OAcute]tesis de \
periodicidad y supongamos que la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox["n",
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}]}], TraditionalForm]]],
  " tiene longitud ",
  Cell[BoxData[
      \(TraditionalForm\`Q\)]],
  ", es decir, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], "(", "n", ")"}], "=", "0"}], 
        TraditionalForm]]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`n < 0\)]],
  " y para ",
  Cell[BoxData[
      \(TraditionalForm\`n \[GreaterEqual] Q\)]],
  ". Entonces la duraci\[OAcute]n de la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox["y",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox["n",
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}]}], TraditionalForm]]],
  " dada por la igualdad (12) es ",
  Cell[BoxData[
      \(TraditionalForm\`Q + M - 1\)]],
  ". Pues podemos escribir"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "(", "n", ")"}], "=", 
        RowBox[{
          RowBox[{\(\[Sum]\+\(k = 0\)\%\(M - 1\)\), 
            RowBox[{
              RowBox[{
                StyleBox["h",
                  FontWeight->"Bold"], "(", "k", ")"}], 
              RowBox[{
                StyleBox["x",
                  FontWeight->"Bold"], "(", \(n - k\), ")"}]}]}], "=", 
          
          RowBox[{\(\[Sum]\+\(\(k + j = 
                  n\)\(,\)\(\ \)\((k + j \[LessEqual] M + Q - 2)\)\(\ \)\)\), 
            
            RowBox[{
              RowBox[{
                StyleBox["h",
                  FontWeight->"Bold"], "(", "k", ")"}], 
              RowBox[{
                StyleBox["x",
                  FontWeight->"Bold"], "(", "j", ")"}], "  "}]}]}]}], 
      TraditionalForm]], "NumberedEquation",
  TextAlignment->Center],

Cell[TextData[{
  "y por tanto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "(", "n", ")"}], TraditionalForm]]],
  " es igual al coeficiente de ",
  Cell[BoxData[
      \(TraditionalForm\`x\^n\)]],
  " en el producto de los polinomios de grados ",
  Cell[BoxData[
      \(TraditionalForm\`M - 1\)]],
  " y  ",
  Cell[BoxData[
      \(TraditionalForm\`Q - 1\)]],
  ":"
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\((\(h(0) + \(h(1)\) x + \(h(2)\) x\^2 + \(h(3)\) 
                x\^3 +  ... \) + \(h(M - 1)\) 
            x\^\(M - 1\))\) \((\(x(0) + \(x(1)\) x + \(x(2)\) 
                x\^2 +  ... \) + \(x(Q - 1)\) x\^\(Q - 1\))\)\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "El resultado del producto es un polinomio de grado ",
  Cell[BoxData[
      \(TraditionalForm\`M + Q - 2\)]],
  " que tiene ",
  Cell[BoxData[
      \(TraditionalForm\`M + Q - 1\)]],
  " coeficientes que ser\[AAcute] la longitud de la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox["y",
          FontWeight->"Bold"], TraditionalForm]]],
  ".",
  StyleBox[" Mathematica",
    FontSlant->"Italic"],
  " tiene un comando bastante r\[AAcute]pido y eficaz que calcula los \
coeficientes de un producto de polinomios (el comando \"ListConvolve[ ] no se \
adapta para este c\[AAcute]lculo)."
}], "Text"],

Cell[BoxData[
    \(\(\( (*\ vamos\ a\ considerar\ que\ x \((0)\) = 1, \ 
      x \((1)\) = \(-2\), \ x \((2)\) = 1, \ x \((3)\) = \(-1\), \ 
      son\ los\ valores\ no\ nulos\ de\ la\ se\[NTilde]al\ x, \ 
      h \((0)\) = 2, \ h \((2)\) = \(-1\), \ 
      h \((7)\) = \(\(-1\)\ son\ los\ valores\ no\ nulos\ de\ la\ \
se\[NTilde]al\ h . \ Tenemos\ que\ M = 8\), \ 
      Q = 4\ *) \)\(\[IndentingNewLine]\)\(CoefficientList[\((1 - 2  z + 
            z\^2 - z\^3)\)*\((2 - z\^2 - z\^7)\), z]\)\( (*\ 
      una\ forma\ de\ calcular\ x\[Star]h\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Con esta interpretaci\[OAcute]n, es evidente que si a\[NTilde]adimos \
valores nulos a las se\[NTilde]ales ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          FontWeight->"Bold"], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        StyleBox["h",
          FontWeight->"Bold"], TraditionalForm]]],
  "  y los hacemos intervenir en los c\[AAcute]lculos, la convoluci\[OAcute]n \
resultante es la misma que la anterior con ceros a\[NTilde]adidos al final."
}], "Text"],

Cell[BoxData[
    \(CoefficientList[\((1 - 2  z + z\^2 - z\^3 + 0. \ z\^4 + 0.  z\^5 + 
            0.  z\^6 + 0.  z\^7)\)*\((2 - z\^2 - z\^7)\), z]\)], "Input"],

Cell[TextData[{
  "Lo anterior tiene por objetivo ver que la convoluci\[OAcute]n (12) podemos \
expresarla siempre como una convoluci\[OAcute]n c\[IAcute]clica. Para ello lo \
que hacemos es calcular la convoluci\[OAcute]n c\[IAcute]clica de las se\
\[NTilde]ales de igual longitud ",
  Cell[BoxData[
      \(TraditionalForm\`M + Q - 1\)]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], "(", "k", ")"}], ",", " ", 
          RowBox[{
            StyleBox["h",
              FontWeight->"Bold"], "(", "k", ")"}], ",", 
          " ", \(0 \[LessEqual] k \[LessEqual] M + Q - 1\)}], 
        TraditionalForm]]],
  " obtenidas a\[NTilde]adiendo ceros al final de cada una de las \
se\[NTilde]ales iniciales. Se verifica que la convoluci\[OAcute]n \
c\[IAcute]clica correspondiente es justamente ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\[Star]h\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". En el caso que nos ocupa formamos se\[NTilde]ales de longitud ",
  Cell[BoxData[
      \(TraditionalForm\`8 + 4 - 1 = 11\)]],
  " a\[NTilde]adiendo ceros al final a las se\[NTilde]ales originales y \
calculamos la convoluci\[OAcute]n c\[IAcute]clica de las nuevas \
se\[NTilde]ales."
}], "Text"],

Cell[BoxData[
    \(ListConvolve[{1, \(-2\), 1, \(-1\), 0, 0, 0, 0, 0, 0, 0}, {2, 
        0, \(-1\), 0, 0, 0, 0, \(-1\), 0, 0, 0}, 1]\)], "Input"],

Cell["\<\
Este resultado es igual a la convoluci\[OAcute]n lineal dada por (12). \
Podemos comprobar el resultado con la DFT.\
\>", "Text"],

Cell[BoxData[
    \(Fourier[{2, \(-4\), 1, 0, \(-1\), 1, 0, \(-1\), 2, \(-1\), 1}] - \@11*
          Fourier[{1, \(-2\), 1, \(-1\), 0, 0, 0, 0, 0, 0, 0}]*
          Fourier[{2, 0, \(-1\), 0, 0, 0, 0, \(-1\), 0, 0, 0}] // 
      Chop\)], "Input"],

Cell[TextData[{
  "Con lo anterior hemos justificado que todo filtro en las condiciones \
consideradas, sin m\[AAcute]s que a\[NTilde]adir ceros en la forma que se ha \
indicado, act\[UAcute]a por convoluci\[OAcute]n c\[IAcute]clica. Podemos por \
ello representar la acci\[OAcute]n del filtro en la forma ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(y = x\[CircleDot]\ h\),
          FontWeight->"Bold"], TraditionalForm]]],
  "; donde ahora ",
  Cell[BoxData[
      FormBox[
        StyleBox["x",
          FontWeight->"Bold"], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        StyleBox["h",
          FontWeight->"Bold"], TraditionalForm]]],
  " son vectores de longitud ",
  Cell[BoxData[
      \(TraditionalForm\`N = M + Q - 1\)]],
  " obtenidos completando con ceros (",
  StyleBox["\"zero padding\"",
    FontSlant->"Italic"],
  ") la se\[NTilde]al original y la respuesta impulsiva. Tomando \
transformadas de Fourier discretas como las que usa ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " por defecto obtenemos, notando las correspondiente transformadas con \
letras may\[UAcute]sculas, ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(Y = \@N\ X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  " donde el producto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(X\ H\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se entiende coordenada a coordenada. La se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        StyleBox["H",
          FontWeight->"Bold"], TraditionalForm]]],
  " se llama funci\[OAcute]n de transferencia del filtro y es la DFT de la \
funci\[OAcute]n respuesta impulsiva (de longitud ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  "). Este procedimiento se conoce como ",
  StyleBox["filtrado lineal. ",
    FontSlant->"Italic"],
  "Hay que advertir que los dos m\[EAcute]todos no son equivalentes. Ve\
\[AAcute]moslo con un ejemplo."
}], "Text"],

Cell[CellGroupData[{

Cell["Comparaci\[OAcute]n de los m\[EAcute]todos de filtrado lineal y peri\
\[OAcute]dico", "Subsection"],

Cell[TextData[{
  "Consideremos un filtro cuya ",
  StyleBox["respuesta impulsiva",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " venga dada como sigue."
}], "Text"],

Cell[BoxData[{
    \(\(funpulso = 
        Table[Exp[\(-0.01\)\ t], {t, 0, 511}]/\((Plus @@ 
              Table[Exp[\(-0.01\)\ t], {t, 0, 511}])\);\)\), "\n", 
    \(\(ListPlot[funpulso];\)\)}], "Input"],

Cell["Consideremos una se\[NTilde]al que vamos a generar aleatoriamente.", \
"Text"],

Cell[BoxData[
    \(\(\(\(signal = 
        NestList[#1\ If[Random[] < 0.01, \(-1.0\), 1.0] &, 1, 511];\)\n
    \(\(\(ListPlot[signal]\)\(\ \)\);\)\)\( (*\ 
      cada\ vez\ que\ ejecutes\ el\ comando\ saldr\[AAcute]\ una\ \
se\[NTilde]al\ distinta . \ 
          Trata\ de\ obtener\ una\ que\ te\ guste\ *) \)\)\)], "Input",
  AspectRatioFixed->True],

Cell["Observa que \"signal\" y \"funpulso\" tiene igual longitud 512. ", \
"Text"],

Cell["\<\
La respuesta de este filtro a \"signal\" se puede obtener interpretando que \
hay periodicidad por convoluci\[OAcute]n c\[IAcute]clica de \"signal\" con la \
respuesta impulsiva. En tal caso la respuesta viene dada por:\
\>", "Text"],

Cell[BoxData[{
    \(\(respuesta2 = 
        Chop[ListConvolve[signal, funpulso, 1]] // 
          Chop;\)\), "\[IndentingNewLine]", 
    \( (*\ 
      Tambi\[EAcute]n\ puede\ calcularse\ v\[IAcute]a\ DFT\ por\ respuesta = 
        Chop[Sqrt[512] 
            InverseFourier[
              Fourier[signal]*\ Fourier[funpulso]]]\ *) \)}], "Input"],

Cell["\<\
Obtengamos ahora la respuesta mediante \"filtrado lineal\", es decir, a trav\
\[EAcute]s de la convoluci\[OAcute]n c\[IAcute]clica de las se\[NTilde]ales \
modificadas a\[NTilde]adiendo ceros de la forma se\[NTilde]alada \
anteriormente.\
\>", "Text"],

Cell[BoxData[{
    \(\(nuevasignal = 
        Join[signal, Table[0, {511}]];\)\), "\[IndentingNewLine]", 
    \(\(nuevafunpulso = 
        Join[funpulso, Table[0, {511}]];\)\), "\[IndentingNewLine]", 
    \(\(nuevarespuesta = 
        Chop[\(\@1023\) 
            InverseFourier[
              Fourier[nuevasignal]*Fourier[nuevafunpulso]]];\)\)}], "Input"],

Cell["Comparemos los resultados obtenidos.", "Text"],

Cell[BoxData[
    \(\(\(g1 = ListPlot[respuesta];\)\( (*\ 
      observa\ c\[OAcute]mo\ la\ convoluci\[OAcute]n\ suaviza\ la\ \
se\[NTilde]al\ de\ entrada\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[nuevarespuesta];\)\)], "Input"],

Cell["\<\
Como puedes ver son muy diferentes. Pero es que la se\[NTilde]al \
\"nuevarespuesta\" tiene longitud 512+511. Para comparar mejor tomemos los \
primeros 512 elementos de \"nuevarespuesta\".\
\>", "Text"],

Cell[BoxData[
    \(\(g2 = ListPlot[Take[nuevarespuesta, 512]];\)\)], "Input"],

Cell["Superpongamos las gr\[AAcute]ficas.", "Text"],

Cell[BoxData[
    \(\(Show[g1, g2];\)\)], "Input"],

Cell["\<\
Bueno, no son \"demasiado\" diferentes y las diferencias mayores se producen \
al principio. En conclusi\[OAcute]n, podemos usar el procedimiento de \
filtrado lineal a\[NTilde]adiendo ceros y despu\[EAcute]s quedarnos con la \
parte de la respuesta obtenida que corresponde a la duraci\[OAcute]n de la se\
\[NTilde]al de entrada. A\[NTilde]adir ceros tiene la ventaja de que permite \
controlar el tama\[NTilde]o de la muestra y mejora la resoluci\[OAcute]n en \
frecuencia de la DFT.\
\>", "Text"],

Cell["", "Author",
  FontSize->12]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {0, Automatic}},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Transformada de Fourier Discreta"], "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Transformada de Fourier Discreta"], "Header"]}},
ShowSelection->True,
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 49, 0, 99, "Title"],
Cell[1806, 53, 148, 4, 123, "Author"],

Cell[CellGroupData[{
Cell[1979, 61, 100, 1, 93, "Section"],
Cell[2082, 64, 1015, 31, 67, "Text"],
Cell[3100, 97, 528, 13, 84, "NumberedEquation"],
Cell[3631, 112, 1988, 63, 120, "Text"],
Cell[5622, 177, 88, 2, 41, "Text"],
Cell[5713, 181, 533, 14, 84, "NumberedEquation"],
Cell[6249, 197, 1076, 33, 94, "Text"],
Cell[7328, 232, 302, 9, 41, "Text"],
Cell[7633, 243, 546, 16, 67, "Text"],
Cell[8182, 261, 976, 24, 40, "Text"],
Cell[9161, 287, 782, 21, 64, "NumberedEquation"],
Cell[9946, 310, 460, 16, 67, "Text"],
Cell[10409, 328, 518, 12, 98, "Input"],
Cell[10930, 342, 248, 8, 41, "Text"],
Cell[11181, 352, 361, 7, 183, "Input"],
Cell[11545, 361, 957, 33, 67, "Text"],
Cell[12505, 396, 607, 17, 84, "NumberedEquation"],
Cell[13115, 415, 335, 10, 67, "Text"],
Cell[13453, 427, 225, 4, 158, "Input"],
Cell[13681, 433, 538, 10, 119, "Text"],
Cell[14222, 445, 1369, 47, 121, "Text"],

Cell[CellGroupData[{
Cell[15616, 496, 57, 0, 78, "Subsection"],
Cell[15676, 498, 698, 22, 93, "Text"],
Cell[16377, 522, 955, 22, 410, "Input"],
Cell[17335, 546, 751, 20, 119, "Text"],
Cell[18089, 568, 1432, 33, 170, "NumberedEquation"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19558, 606, 44, 0, 78, "Subsection"],
Cell[19605, 608, 280, 10, 41, "Text"],
Cell[19888, 620, 673, 13, 88, "NumberedEquation"],
Cell[20564, 635, 398, 11, 67, "Text"],
Cell[20965, 648, 586, 10, 202, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21588, 663, 51, 0, 78, "Subsection"],
Cell[21642, 665, 2202, 66, 145, "Text"],
Cell[23847, 733, 642, 22, 67, "Text"],
Cell[24492, 757, 1574, 34, 223, "NumberedEquation"],
Cell[26069, 793, 778, 29, 67, "Text"],
Cell[26850, 824, 685, 26, 69, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27572, 855, 54, 0, 78, "Subsection"],
Cell[27629, 857, 1499, 42, 124, "Text"],
Cell[29131, 901, 685, 12, 228, "Input"],
Cell[29819, 915, 246, 5, 98, "Input"],
Cell[30068, 922, 381, 11, 67, "Text"],
Cell[30452, 935, 508, 11, 176, "Input"],
Cell[30963, 948, 208, 4, 67, "Text"],
Cell[31174, 954, 586, 10, 231, "Input"],
Cell[31763, 966, 759, 14, 145, "Text"],
Cell[32525, 982, 495, 10, 205, "Input"],
Cell[33023, 994, 390, 6, 93, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[33462, 1006, 52, 0, 93, "Section"],
Cell[33517, 1008, 752, 13, 145, "Text"],
Cell[34272, 1023, 227, 4, 124, "Input"],
Cell[34502, 1029, 1564, 47, 146, "Text"],
Cell[36069, 1078, 131, 3, 41, "Text"],
Cell[36203, 1083, 1275, 23, 462, "Input"],

Cell[CellGroupData[{
Cell[37503, 1110, 65, 0, 78, "Subsection"],
Cell[37571, 1112, 360, 6, 93, "Text"],
Cell[37934, 1120, 489, 10, 176, "Input"],
Cell[38426, 1132, 187, 4, 67, "Text"],
Cell[38616, 1138, 510, 8, 202, "Input"],
Cell[39129, 1148, 847, 16, 171, "Text"],
Cell[39979, 1166, 1066, 22, 280, "Input"],
Cell[41048, 1190, 1149, 25, 171, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[42234, 1220, 48, 0, 78, "Subsection"],
Cell[42285, 1222, 272, 5, 67, "Text"],
Cell[42560, 1229, 112, 2, 72, "Input"],
Cell[42675, 1233, 339, 7, 67, "Text"],
Cell[43017, 1242, 417, 8, 176, "Input"],
Cell[43437, 1252, 59, 0, 41, "Text"],
Cell[43499, 1254, 245, 5, 98, "Input"],
Cell[43747, 1261, 102, 3, 41, "Text"],
Cell[43852, 1266, 140, 3, 98, "Input"],
Cell[43995, 1271, 305, 5, 93, "Text"],
Cell[44303, 1278, 355, 6, 202, "Input"],
Cell[44661, 1286, 355, 6, 93, "Text"],
Cell[45019, 1294, 543, 13, 94, "Text"],
Cell[45565, 1309, 768, 15, 147, "Text"],
Cell[46336, 1326, 269, 5, 67, "Text"],
Cell[46608, 1333, 112, 2, 72, "Input"],
Cell[46723, 1337, 137, 3, 41, "Text"],
Cell[46863, 1342, 405, 7, 176, "Input"],
Cell[47271, 1351, 317, 6, 67, "Text"],
Cell[47591, 1359, 244, 5, 98, "Input"],
Cell[47838, 1366, 102, 3, 41, "Text"],
Cell[47943, 1371, 79, 1, 72, "Input"],
Cell[48025, 1374, 202, 4, 67, "Text"],
Cell[48230, 1380, 373, 6, 202, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48640, 1391, 40, 0, 78, "Subsection"],
Cell[48683, 1393, 136, 3, 41, "Text"],
Cell[48822, 1398, 118, 2, 72, "Input"],
Cell[48943, 1402, 1840, 46, 223, "Text"],
Cell[50786, 1450, 156, 3, 41, "Text"],
Cell[50945, 1455, 143, 2, 72, "Input"],
Cell[51091, 1459, 459, 8, 93, "Text"],
Cell[51553, 1469, 162, 3, 98, "Input"],
Cell[51718, 1474, 241, 4, 67, "Text"],
Cell[51962, 1480, 172, 3, 98, "Input"],
Cell[52137, 1485, 852, 20, 119, "Text"],
Cell[52992, 1507, 914, 17, 332, "Input"],
Cell[53909, 1526, 747, 13, 280, "Input"],
Cell[54659, 1541, 279, 6, 67, "Text"],
Cell[54941, 1549, 455, 8, 176, "Input"],
Cell[55399, 1559, 168, 3, 98, "Input"],
Cell[55570, 1564, 1144, 30, 145, "Text"],
Cell[56717, 1596, 103, 2, 72, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[56869, 1604, 60, 0, 93, "Section"],

Cell[CellGroupData[{
Cell[56954, 1608, 54, 0, 67, "Subsubsection"],
Cell[57011, 1610, 87, 2, 41, "Text"],
Cell[57101, 1614, 180, 4, 98, "Input"],
Cell[57284, 1620, 111, 3, 41, "Text"],
Cell[57398, 1625, 127, 2, 98, "Input"],
Cell[57528, 1629, 335, 6, 93, "Text"],
Cell[57866, 1637, 61, 1, 72, "Input"],
Cell[57930, 1640, 55, 0, 41, "Text"],
Cell[57988, 1642, 96, 2, 98, "Input"],
Cell[58087, 1646, 159, 3, 41, "Text"],
Cell[58249, 1651, 84, 1, 72, "Input"],
Cell[58336, 1654, 453, 12, 67, "Text"],
Cell[58792, 1668, 362, 8, 150, "Input"],
Cell[59157, 1678, 113, 3, 41, "Text"],
Cell[59273, 1683, 214, 4, 124, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[59524, 1692, 56, 0, 67, "Subsubsection"],
Cell[59583, 1694, 1850, 51, 235, "Text"],
Cell[61436, 1747, 159, 2, 98, "Input"],
Cell[61598, 1751, 379, 8, 228, "Input"],
Cell[61980, 1761, 809, 21, 119, "Text"],
Cell[62792, 1784, 142, 2, 98, "Input"],
Cell[62937, 1788, 197, 4, 67, "Text"],
Cell[63137, 1794, 271, 5, 150, "Input"],
Cell[63411, 1801, 163, 3, 41, "Text"],
Cell[63577, 1806, 271, 5, 150, "Input"],
Cell[63851, 1813, 153, 3, 41, "Text"],
Cell[64007, 1818, 1466, 29, 488, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[65522, 1853, 94, 4, 93, "Section"],
Cell[65619, 1859, 311, 8, 67, "Text"],
Cell[65933, 1869, 390, 8, 77, "Text"],
Cell[66326, 1879, 522, 14, 93, "Text"],
Cell[66851, 1895, 312, 6, 124, "Input"],
Cell[67166, 1903, 115, 3, 41, "Text"],
Cell[67284, 1908, 296, 6, 150, "Input"],
Cell[67583, 1916, 253, 5, 124, "Input"],
Cell[67839, 1923, 380, 8, 93, "Text"],
Cell[68222, 1933, 265, 6, 124, "Input"],
Cell[68490, 1941, 59, 0, 41, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[68586, 1946, 91, 1, 93, "Section"],
Cell[68680, 1949, 2299, 67, 286, "Text"],
Cell[70982, 2018, 527, 12, 94, "Text"],
Cell[71512, 2032, 220, 5, 124, "Input"],
Cell[71735, 2039, 140, 3, 41, "Text"],
Cell[71878, 2044, 81, 1, 72, "Input"],
Cell[71962, 2047, 118, 3, 41, "Text"],
Cell[72083, 2052, 134, 2, 98, "Input"],
Cell[72220, 2056, 313, 5, 67, "Text"],
Cell[72536, 2063, 1085, 30, 39, "NumberedEquation"],
Cell[73624, 2095, 90, 1, 41, "Text"],
Cell[73717, 2098, 169, 3, 98, "Input"],
Cell[73889, 2103, 240, 6, 67, "Text"],
Cell[74132, 2111, 148, 3, 98, "Input"],
Cell[74283, 2116, 178, 3, 41, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[74498, 2124, 75, 0, 93, "Section"],
Cell[74576, 2126, 3085, 102, 146, "Text"],
Cell[77664, 2230, 1758, 47, 75, "Text"],
Cell[79425, 2279, 216, 6, 41, "Text"],
Cell[79644, 2287, 1209, 33, 80, "NumberedEquation"],
Cell[80856, 2322, 461, 15, 41, "Text"],
Cell[81320, 2339, 713, 21, 80, "NumberedEquation"],
Cell[82036, 2362, 2623, 82, 146, "Text"],
Cell[84662, 2446, 544, 16, 84, "NumberedEquation"],
Cell[85209, 2464, 3549, 107, 227, "Text"],
Cell[88761, 2573, 3418, 96, 379, "Text"],
Cell[92182, 2671, 26, 0, 51, "Example"],
Cell[92211, 2673, 134, 3, 41, "Text"],
Cell[92348, 2678, 255, 5, 124, "Input"],
Cell[92606, 2685, 318, 5, 67, "Text"],
Cell[92927, 2692, 66, 1, 72, "Input"],
Cell[92996, 2695, 1523, 32, 261, "Text"],
Cell[94522, 2729, 215, 4, 98, "Input"],
Cell[94740, 2735, 202, 5, 41, "Text"],
Cell[94945, 2742, 68, 1, 72, "Input"],
Cell[95016, 2745, 355, 11, 67, "Text"],
Cell[95374, 2758, 142, 2, 98, "Input"],
Cell[95519, 2762, 234, 4, 67, "Text"],
Cell[95756, 2768, 77, 1, 77, "Input"],
Cell[95836, 2771, 406, 10, 93, "Text"],
Cell[96245, 2783, 74, 1, 79, "Input"],
Cell[96322, 2786, 271, 5, 67, "Text"],
Cell[96596, 2793, 68, 1, 72, "Input"],
Cell[96667, 2796, 321, 5, 93, "Text"],
Cell[96991, 2803, 85, 1, 72, "Input"],
Cell[97079, 2806, 583, 13, 119, "Text"],
Cell[97665, 2821, 259, 4, 124, "Input"],
Cell[97927, 2827, 694, 17, 119, "Text"],
Cell[98624, 2846, 265, 5, 124, "Input"],
Cell[98892, 2853, 64, 0, 41, "Text"],
Cell[98959, 2855, 161, 2, 98, "Input"],
Cell[99123, 2859, 114, 3, 41, "Text"],
Cell[99240, 2864, 53, 1, 72, "Input"],
Cell[99296, 2867, 109, 3, 41, "Text"],
Cell[99408, 2872, 113, 2, 72, "Input"],
Cell[99524, 2876, 87, 2, 41, "Text"],
Cell[99614, 2880, 112, 2, 72, "Input"],
Cell[99729, 2884, 385, 6, 93, "Text"],
Cell[100117, 2892, 676, 12, 228, "Input"],
Cell[100796, 2906, 376, 8, 67, "Text"],
Cell[101175, 2916, 210, 3, 98, "Input"],
Cell[101388, 2921, 88, 1, 72, "Input"],
Cell[101479, 2924, 137, 3, 41, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[101653, 2932, 34, 0, 93, "Section"],
Cell[101690, 2934, 214, 4, 67, "Text"],
Cell[101907, 2940, 792, 23, 84, "NumberedEquation"],
Cell[102702, 2965, 2320, 75, 119, "Text"],
Cell[105025, 3042, 933, 27, 77, "NumberedEquation"],
Cell[105961, 3071, 442, 17, 41, "Text"],
Cell[106406, 3090, 312, 5, 36, "Text"],
Cell[106721, 3097, 634, 18, 93, "Text"],
Cell[107358, 3117, 567, 9, 150, "Input"],
Cell[107928, 3128, 514, 14, 67, "Text"],
Cell[108445, 3144, 161, 2, 99, "Input"],
Cell[108609, 3148, 1298, 32, 145, "Text"],
Cell[109910, 3182, 147, 2, 98, "Input"],
Cell[110060, 3186, 139, 3, 41, "Text"],
Cell[110202, 3191, 245, 4, 131, "Input"],
Cell[110450, 3197, 1950, 54, 224, "Text"],

Cell[CellGroupData[{
Cell[112425, 3255, 105, 1, 78, "Subsection"],
Cell[112533, 3258, 173, 6, 42, "Text"],
Cell[112709, 3266, 204, 4, 124, "Input"],
Cell[112916, 3272, 84, 1, 41, "Text"],
Cell[113003, 3275, 351, 7, 124, "Input"],
Cell[113357, 3284, 82, 1, 41, "Text"],
Cell[113442, 3287, 243, 4, 67, "Text"],
Cell[113688, 3293, 346, 8, 124, "Input"],
Cell[114037, 3303, 261, 5, 67, "Text"],
Cell[114301, 3310, 356, 8, 158, "Input"],
Cell[114660, 3320, 52, 0, 41, "Text"],
Cell[114715, 3322, 176, 3, 98, "Input"],
Cell[114894, 3327, 62, 1, 72, "Input"],
Cell[114959, 3330, 213, 4, 67, "Text"],
Cell[115175, 3336, 78, 1, 72, "Input"],
Cell[115256, 3339, 51, 0, 41, "Text"],
Cell[115310, 3341, 50, 1, 72, "Input"],
Cell[115363, 3344, 509, 8, 119, "Text"],
Cell[115875, 3354, 34, 1, 46, "Author"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

