(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13889,        315]*)
(*NotebookOutlinePosition[     14589,        339]*)
(*  CellTagsIndexPosition[     14545,        335]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
Pr\[AAcute]ctica 5. Transformada de Fourier Discreta y se\[NTilde]ales de \
audio\
\>", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author"],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell[TextData[{
  "En esta pr\[AAcute]ctica te propongo dos ejercicios. En el primero deber\
\[AAcute]s decodificar un archivo de sonido previamente codificado, y en el \
segundo deber\[AAcute]s dise\[NTilde]ar un filtro de paso banda. Para hacer \
esta pr\[AAcute]ctica es indispansable que leas antes con atenci\[OAcute]n \
los cuadernos ",
  StyleBox["Tranformada de Fourier Discreta",
    FontSlant->"Italic"],
  " y ",
  StyleBox["Audio&",
    FontSlant->"Italic"],
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que habr\[AAcute]s bajado junto con este. En ellos est\[AAcute] todo lo \
que se precisa saber para realizar los ejercicios que se proponen a \
continuaci\[OAcute]n."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 1. Decodificaci\[OAcute]n de un archivo de sonido", "Exercise"],

Cell[TextData[{
  "Con esta pr\[AAcute]ctica has bajado el archivo \"codificado.wav\" que, \
como su nombre indica, es un archivo de sonido (voz humana) que se ha \
codificado. Voy a decirte los pasos que he seguido para codificarlo y tu \
trabajo va a consistir en invertir el proceso para recuperar el archivo \
original. \n1. He le\[IAcute]do el arhivo original usando el comando \
ReadSoundFile[ ], el mismo que t\[UAcute] debes usar para leer el archivo \
codificado.\n2. He revertido el archivo original.\n3. Haciendo uso de la \
transformada de Fourier discreta (Fourier[ ]) he mezclado como sigue las \
frecuencias del archivo revertido. He considerado cuatro partes ",
  StyleBox["a, b, c y d",
    FontWeight->"Bold"],
  ", de la transformada  correspondientes cada una de ellas a un cuarto de \
las frecuencias presentes en la transformada. Es decir si, por ejemplo, es H \
la m\[AAcute]xima frecuencia que puede detectar la transformada de Fourier, \
entonces ",
  StyleBox["a",
    FontWeight->"Bold"],
  " corresponde a los coeficientes asociados al rango de frecuencias [1, \
H/4], ",
  StyleBox["b",
    FontWeight->"Bold"],
  " corresponde a los ceficientes asociados al rango de frecuencias [H/4+1, \
H/8] y an\[AAcute]logamente ",
  StyleBox["c",
    FontWeight->"Bold"],
  " y ",
  StyleBox["d",
    FontWeight->"Bold"],
  ".\n4. He formado una nueva lista \"scramble\" mezclando las frecuencias en \
la secuencia ",
  StyleBox["d,c,b,a",
    FontWeight->"Bold"],
  ". \n5. He tomado transformada de Fourier inversa para obtener la lista \
\"invdftscramble\".\n6. Finalmente, con el siguiente comando, he creado el \
archivo codificado."
}], "Text"],

Cell[BoxData[{\(m = Max[Abs[invdftscramble]];\), "\[IndentingNewLine]", 
    TagBox[
      FrameBox[\(Export["\<codificado.wav\>", 
          Sound[SampledSoundList[invdftscramble/m, 12000]]]\),
        BoxFrame->False,
        BoxMargins->False],
      Short]}], "Input"],

Cell[TextData[{
  StyleBox["Sugerencias",
    FontWeight->"Bold"],
  ". No te he dicho todos los detalles del proceso porque tu trabajo consiste \
en \[EAcute]so, en completar los detalles que omito. Ten en cuenta lo \
siguiente. Debes dar los mismos (los \"sim\[EAcute]tricos\") pasos que yo \
pero en orden inverso. Ten muy presente que la segunda mitad de la \
transformada de Fourier no aporta nuevas frecuencias, las frecuencias est\
\[AAcute]n en la primera mitad de la transformada (si tiras a la basura una \
parte - casi la mitad - de la transformada no pierdes informaci\[OAcute]n). \
Hay dos coeficientes que requieren un trato especial (hay que dejarlos en su \
sitio). Ten en cuenta que cuando apliques transformada inversa debes obtener \
una se\[NTilde]al real, por lo que al reconstruir las frecuencias a sus \
lugares de origen debes construir una lista que sea hemisim\[EAcute]trica. Un \
\[UAcute]ltimo detalle, ya casi te lo digo todo, ",
  StyleBox["b, c",
    FontWeight->"Bold"],
  " y ",
  StyleBox["d",
    FontWeight->"Bold"],
  " tienen igual n\[UAcute]mero de elementos, ",
  StyleBox["a",
    FontWeight->"Bold"],
  " tiene uno menos que ellos. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2. Dise\[NTilde]o de un filtro de paso banda", "Exercise"],

Cell[TextData[{
  "En este ejercicio te propongo que dise\[NTilde]es un filtro de paso banda. \
Se trata de definir una funci\[OAcute]n \"filtropasobanda[sound_,fmin_,fmax_]\
\" donde se entiende que \"sound\" es la se\[NTilde]al de entrada, \
[fmin,fmax] es el intervalo de frecuencias que se van a dejar pasar \
inalteradas y las dem\[AAcute]s frecuencias se van a eliminar. Es importante \
en la se\[NTilde]al de entrada conocer la raz\[OAcute]n de muestreo (el n\
\[UAcute]mero de muestras por segundo) pues ello afecta de forma notable a la \
DFT; ya sabes que los lugares que corresponden a las distintas frecuencias en \
la DFT son relativos al tama\[NTilde]o de la muestra.\nEn vista de lo dicho, \
parece apropiado que \"sound\" sea de la forma sound=SoundSampledList[ ] pues \
as\[IAcute] tenemos todo junto: la lista de datos, que ser\[AAcute] \
sound[[1]], y la raz\[OAcute]n de muestreo, que ser\[AAcute] sound[[2]]. Adem\
\[AAcute]s es f\[AAcute]cil generar objetos de la forma \"SoundSampledList[ ]\
\" a los que podremos aplicar nuestro filtro.\nAparte de este detalle, hay \
otro aspecto t\[EAcute]cnico derivado del hecho de que la DFT (el algoritmo \
de la transformada r\[AAcute]pida de Fourier) trabaja mucho m\[AAcute]s r\
\[AAcute]pido con muestras cuyo tama\[NTilde]o es producto de n\[UAcute]meros \
primos peque\[NTilde]os (2, 3, 5). Por eso es conveniente poder ajustar el \
tama\[NTilde]o de la muestra a\[NTilde]adiendo ceros hasta lograr que tenga \
un tama\[NTilde]o \[OAcute]ptimo. \na) Define una lista ordenada de menor a \
mayor con todos los n\[UAcute]meros ",
  StyleBox["pares",
    FontSlant->"Italic"],
  " de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`2\^i\ \(3\^j\) 5\^k\)]],
  "que sean menor o igual que ",
  Cell[BoxData[
      \(TraditionalForm\`32768 = 2\^15\)]],
  ". Llama a esa lista \"sizes\".\nb) Define una funci\[OAcute]n \
\"eligesize[z_]\" cuyo argumento es un n\[UAcute]mero (que ser\[AAcute] la \
longitud de la lista sound[[1]]) que haga lo siguiente:\nSi ",
  Cell[BoxData[
      \(TraditionalForm\`z \[LessEqual] p = Max[sizes]\)]],
  ", entonces \"eligesize[z]\" proporciona el primer elemento de la lista \
\"sizes\" que es mayor o igual que ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ".\nSi ",
  Cell[BoxData[
      \(TraditionalForm\`z > p\)]],
  ", se calcula el entero positivo ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " m\[AAcute]s peque\[NTilde]o tal que ",
  Cell[BoxData[
      \(TraditionalForm\`z/2\^q \[LessEqual] p\)]],
  " y \"eligesize[z]\" es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`2\^q\)]],
  " multiplicado por el primer elemento de \"sizes\" que es mayor o igual que \
",
  Cell[BoxData[
      \(TraditionalForm\`z/2\^q\)]],
  ".\nSugerencias: Esta funci\[OAcute]n es bien f\[AAcute]cil de definir. Los \
comandos \"Ceiling[ ]\", \"First[ ]\", \"Select[ ]\" pueden ser \
\[UAcute]tiles.\nc) Define la funci\[OAcute]n \
\"filtropasobanda[sound_SampledSoundList,fmin_,fmax_]\" que debe \
proporcionarte como salida otro objeto \"SampledSoundList[ ]\". Sigue los \
siguientes pasos:\nc1) Define variables locales: \"muestras=sound[[1]]\", \
\"srate=sound[[2]]\", \"newsize\", \"transfer\", \"newfmin\", \
\"newfmax\",\"origsize=Length[sound[[1]]]\", n.\nc2) Optimiza el \
tama\[NTilde]o de la lista \"muestras\" con \"newsize=2*eligesize[ ]\" (No es \
imprescindible multiplicar por 2 pero el resultado del filtro me ha parecido \
mejor as\[IAcute]).\nc3) Agrega ceros al final de la lista \"muestras\" hasta \
que la longitud sea igual a \"newsize\". A la nueva lista obtenida le sigues \
llamando \"muestras\".\nc4) Define \"newfmin\" y \"newfmax\" teniendo en \
cuenta los valores \"fmin\" y \"fmax\" el tama\[NTilde]o \"newsize\" y \
\"srate\".\nc5) Define la funci\[OAcute]n de transferencia \"transfer\" que \
debe ser una lista de longitud \"newsize\" con elementos igual a 1 en los \
lugares ",
  Cell[BoxData[
      \(TraditionalForm\`newfmin \[LessEqual] \ n \[LessEqual] newfmax\)]],
  " y 0 en los restantes. Ten en cuenta que la funci\[OAcute]n de \
transferencia debe ser \"par\" para que pueda actuar de forma apropiada sobre \
la DFT de \"muestras\". Ten en cuenta que la mayor frecuencia presente es \
\"newsize/2+1\" (recuerda que \"newsize\" siempre es par). La idea es definir \
\"transfer\" para valores de ",
  Cell[BoxData[
      \(TraditionalForm\`n \[LessEqual] \ newsize/2 + 1\)]],
  " y simetrizar de forma adecuada. Pueden ser de utilidad los comandos \
\"Join[ ]\" (usado con cuidado), \"Take[ ]\", \"Reverse[ ]\". \nc6) El \
trabajo que queda lo har\[AAcute] el algoritmo de la transformadad \
r\[AAcute]pida de Fourier. Se trata de obtener en el dominio del tiempo la se\
\[NTilde]al que devuelve el filtro. Esta se\[NTilde]al vamos a llamarla tambi\
\[EAcute]n \"muestras\" y viene dada como ya debes saber. Hay un detalle y es \
que debes tomar de la se\[NTilde]al resultante los primeros \"origsize\" \
elementos. Y otro detalle: usa \"Chop[ ]\" y toma parte real \"Re[ ]\" para \
evitar errores de redondeo.\nc7) Un \[UAcute]ltimo detalle: asegurarnos de \
que los datos devueltos est\[AAcute]n comprendidos entre -1 y 1 \
(podr\[IAcute]a haber sucedido algo raro debido a errores de redondeo). Para \
ello basta poner \"muestras /= Max[Abs[muestras]]\".\nc8) El \[UAcute]ltimo \
paso es construir el objeto \"SampledSoundList[ ]\" que devuelve nuestra \
funci\[OAcute]n. Te lo digo yo. Basta escribir \
Return[SampledSoundList[muestras,srate]]. \nEso es todo. Es much\[IAcute]simo \
m\[AAcute]s largo y m\[AAcute]s dif\[IAcute]cil explicarlo que hacerlo."
}], "Text"],

Cell["Prueba el filtro que has definido con la siguiente muestra.", "Text"],

Cell[BoxData[
    \(\(senos = 
        SampledSoundList[
          Table[N[0.3\ \((Sin[2\ Pi\ 400. \ x] + Sin[2\ Pi\ 1600. \ x] + 
                    Sin[2\ Pi\ 3600. \ x])\)], {x, 0, 1 - 1/22500.0, 
              1/22500.0}], 22500];\)\)], "Input"],

Cell["\<\
Filtra primero dejando pasar solamente la frecuencia m\[AAcute]s baja, despu\
\[EAcute]s dejando pasar s\[OAcute]lo la frecuencia media y finalmente \
dejando pasar solamente la m\[AAcute]s alta. \
\>", "Text"],

Cell["\<\
Ahora prueba con el archivo \"pavrti.wav. Lo importas y le pones de nombre \
\"pavrti\". Despu\[EAcute]s puedes hacer lo que te sugiero para ver \
c\[OAcute]mo el filtro selecciona frecuencias.\
\>", "Text"],

Cell[BoxData[{
    \(\(pavrtibajo = filtropasobanda[pavrti[\([1]\)], 0, 1000];\)\), "\n", 
    \(\(Show[Sound[pavrtibajo]];\)\), "\n", 
    \(\(pavrtimedio = 
        filtropasobanda[pavrti[\([1]\)], 1000, 2000];\)\), "\n", 
    \(\(Show[Sound[pavrtimedio]];\)\), "\n", 
    \(\(pavrtialto = 
        filtropasobanda[pavrti[\([1]\)], 2000, 8000];\)\), "\n", 
    \(\(Show[Sound[pavrtialto]];\)\)}], "Input"],

Cell["\<\
Esto casi se aprecia mejor en archivos de voz. Con esta pr\[AAcute]ctica habr\
\[AAcute]s bajado un archivo \"papa.wav\" que contiene la voz de un ni\
\[NTilde]o, hijo de un compa\[NTilde]ero mio, que dice muy alegre \"Pap\
\[AAcute], me gusta el ordenador...\" (quiz\[AAcute]s as\[IAcute] empezaste t\
\[UAcute] y mira d\[OAcute]nde est\[AAcute]s ahora...). Importa el archivo y \
ponle nombre, por ejemplo, \"ninio\" y p\[AAcute]sale el filtro para \
seleccionar frecuencias bajas entre 0 y 1000 hercios, frecuencias medias \
entre 1000 y 2000 hercios y frecuencias altas entre 2000 y 4000 hercios. Ver\
\[AAcute]s que los cambios en la voz son muy notables.\
\>", "Text"],

Cell["\<\
Ya te habr\[AAcute]s dado cuenta que el filtro que hemos construido sirve \
tambi\[EAcute]n como filtro paso bajo y como filtro paso alto: basta para \
ello elegir el rango de frecuencias apropiado. \
\>", "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 106, 3, 174, "Title"],
Cell[1863, 56, 148, 4, 123, "Author"],

Cell[CellGroupData[{
Cell[2036, 64, 39, 0, 93, "Section"],
Cell[2078, 66, 705, 16, 119, "Text"],

Cell[CellGroupData[{
Cell[2808, 86, 79, 0, 68, "Exercise"],
Cell[2890, 88, 1669, 36, 425, "Text"],
Cell[4562, 126, 272, 6, 98, "Input"],
Cell[4837, 134, 1187, 24, 197, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6061, 163, 74, 0, 68, "Exercise"],
Cell[6138, 165, 5626, 97, 1311, "Text"],
Cell[11767, 264, 75, 0, 41, "Text"],
Cell[11845, 266, 250, 5, 124, "Input"],
Cell[12098, 273, 220, 4, 67, "Text"],
Cell[12321, 279, 217, 4, 67, "Text"],
Cell[12541, 285, 407, 8, 202, "Input"],
Cell[12951, 295, 684, 10, 145, "Text"],
Cell[13638, 307, 223, 4, 67, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

