(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     18262,        501]*)
(*NotebookOutlinePosition[     19078,        531]*)
(*  CellTagsIndexPosition[     19005,        525]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Trabajar con sonidos en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " "
}], "Title"],

Cell["\<\
Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author",
  FontSize->12],

Cell[CellGroupData[{

Cell[TextData[{
  "Con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puedes o\[IAcute]r las funciones"
}], "Section"],

Cell[TextData[{
  "En esta secci\[OAcute]n te voy a presentar algunos comandos y herramientas \
de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que son \[UAcute]tiles para trabajar con se\[NTilde]ales de sonido. \
Comprobar\[AAcute]s que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trata el sonido de forma parecida a las representaciones \
gr\[AAcute]ficas. "
}], "Text"],

Cell["El comando ListPlay[ ]", "Definition"],

Cell["\<\
La sintaxis de este comando es (igual que ListPlot[ ])  \
ListPlay[lista,opciones] donde \"lista\" puede ser cualquier lista de n\
\[UAcute]meros reales. Al ejecutar el comando los valores de la lista son \
convertidos en voltajes que se aplican al altavoz para producir el sonido. \
Una opci\[OAcute]n importante es \"SampleRate\", por defecto igual a 8192 \
(aunque puede variar de un ordenador a otro),  que indica el n\[UAcute]mero \
de valores que ser\[AAcute]n convertidos por segundo para reproducir el \
sonido. Otra opci\[OAcute]n es \"PlayRange\" que debe ajustarse dependiendo \
de la magnitud de los datos (la cual depende de la codificaci\[OAcute]n que \
se haya hecho de los mismos: 8 bits o 16 bits son las ususales). Aqu\[IAcute] \
tienes algunos ejemplos. Para reproducir el sonido en una celda Output de \
sonido la seleccionas con el rat\[OAcute]n y pulsas Alt+c+p (si haces doble \
click el sonido se reproduce continuamente).\
\>", "Text"],

Cell[BoxData[
    \(\(\(ListPlay[First[RealDigits[N[1\/97, 10000]]]]\)\( (*\ 
      o\[IAcute]mos\ los\ primeros\ 10000\ d\[IAcute]gitos\ de\ la\ \
representaci\[OAcute]n\ decimal\ 1/
          97. \ Como\ se\ trata\ de\ un\ n\[UAcute]mero\ racional\ la\ lista\ \
tiene\ un\ per\[IAcute]odo\ que\ se\ repite\ y\ esa\ regularidad\ se\ refleja\
\ en\ el\ sonido\ que\ se\ oye\ que\ parece\ un\ tono\ mantenido\ *) \)\)\)], \
"Input"],

Cell[BoxData[
    \(\(\(ListPlay[First[RealDigits[N[\[Pi], 10000]]]]\)\( (*\ 
      el\ n\[UAcute]mero\ \[Pi]\ no\ es\ racional\ y\ la\ sucesi\[OAcute]n\ \
de\ sus\ d\[IAcute]gitos\ decimales\ no\ tiene\ ninguna\ regularidad\ lo\ que\
\ se\ refleja\ en\ el\ sonido\ que\ se\ oye\ que\ se\ asemeja\ a\ un\ ruido\ *) \
\)\)\)], "Input"],

Cell["\<\
Ahora puedes escuchar la aplicaci\[OAcute]n log\[IAcute]stica que usamos en \
la pr\[AAcute]ctica de iteraci\[OAcute]n y caos. Observa c\[OAcute]mo el \
sonido al principio es claro y n\[IAcute]tido y despu\[EAcute]s degenera en \
un ruido.\
\>", "Text"],

Cell[BoxData[{
    \(\(logistic[n_Integer] := 
        Module[{f, t, x}, \[IndentingNewLine]f = 
            Compile[{x, t}, Evaluate[\((3 + t\/n)\)\ x\ \((1 - x)\)]]; 
          FoldList[f, 0.223, Range[n]]];\)\), "\[IndentingNewLine]", 
    \(\(ListPlay[logistic[8000], SampleRate \[Rule] 2000];\)\)}], "Input"],

Cell["Ahora puedes escuchar el do central de un piano.", "Text"],

Cell[BoxData[
    \(ListPlay[Table[Sin[2\ \[Pi]\ 260. \ t], {t, 0, 1, 1/8000}]]\)], "Input"],

Cell["El comando Play[ ]", "Definition"],

Cell["\<\
La sintaxis de este comando es (igual que la de Plot[ ]) \
Play[funci\[OAcute]n,{t,min,max},opciones] y reproduce un sonido cuya \
amplitud est\[AAcute] dada por la funci\[OAcute]n en el tiempo en segundos \
comprendido entre \"min\" y \"max\". Adem\[AAcute]s de las opciones antes se\
\[NTilde]aladas para ListPlay[ ], v\[AAcute]lidas tambi\[EAcute]n para Play[ \
], hay otra opci\[OAcute]n interesante que es \"SampleDepth\", por defecto \
igual a 8, que indica el n\[UAcute]mero de bits que deben usarse para \
codificar los datos. Play[{funcion1,funcion2},{t,min,max},opciones] reproduce \
en est\[EAcute]reo. Ten en cuenta que el convertidor \
digital-anal\[OAcute]gico de la tarjeta de sonido de tu ordenador puede no \
soportar bien algunas tasas de muestreo lo que puede producir disonancias.\
\>", "Text"],

Cell["\<\
En la m\[UAcute]sica Occidental, una octava est\[AAcute] dividida en 12 notas \
igualmente espaciadas seg\[UAcute]n una escala logar\[IAcute]tmica. Puedes \
escuchar las notas de la octava que empieza en 220 Hz evaluando la siguiente \
celda. \
\>", "Text"],

Cell[BoxData[{
    \(Do[Play[Cos[2  \[Pi]\ 220\ 2^\((n/12)\)\ t], {t, 0,  .5}], {n, 0, 
        12}]\), "\n", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(\(FrontEndTokenExecute["\<OpenCloseGroup\>"];\)\)}], "Input"],

Cell["\<\
Observa la p\[EAcute]rdida de calidad en el sonido cuando se codifica con \
pocos bits.\
\>", "Text"],

Cell[BoxData[{
    \(Play[Sin[2\ \[Pi]\ 440\ t], {t, 0, 1}]\), "\[IndentingNewLine]", 
    \(Play[Sin[2\ \[Pi]\ 440\ t], {t, 0, 1}, 
      SampleDepth \[Rule] 4]\)}], "Input"],

Cell["\<\
La raz\[OAcute]n de muestreo por defecto es muy baja para reproducir bien la \
siguiente funci\[OAcute]n cuya frecuencia es muy alta y queda enmascarada por \
otra de m\[AAcute]s baja frecuencia.\
\>", "Text"],

Cell[BoxData[
    \(\(Play[Sin[2\ \[Pi]\ 6000\ t], {t, 0, 1}];\)\)], "Input"],

Cell["\<\
Usando una raz\[OAcute]n de muestreo mayor que el doble de la frecuencia el \
sonido que obtenemos es m\[AAcute]s agudo.\
\>", "Text"],

Cell[BoxData[
    \(Play[Sin[2\ \[Pi]\ 6000\ t], {t, 0, 1}, 
      SampleRate \[Rule] 12400]\)], "Input"],

Cell["\<\
Finalmente, aqu\[IAcute] tienes un sonido estereof\[OAcute]nico (si dispones \
de altavoces apropiados).\
\>", "Text"],

Cell[BoxData[
    \(Play[{Sin[2\ \[Pi]\ 440\ t], Sin[2\ \[Pi]\ 822\ t]}, {t, 0, 
        1}]\)], "Input"],

Cell["\<\
Primitivas de sonido SampledSoundList[ ] y SampledSoundFunction[ ]\
\>", "Definition"],

Cell["\<\
De la misma manera que ListPlot[ ] y Plot[ ] dan como salida un objeto \
\"Graphics\", habr\[AAcute]s observado que la salida de los comandos \
PlayList[ ] y Play[ ] es un objeto \"Sound\".  An\[AAcute]logamente a \
\"Graphics\", un objeto \"Sound\" contiene una lista de primitivas de sonido \
que pueden reproducirse con Show[ ]. \
\>", "Text"],

Cell[BoxData[
    \(InputForm[ListPlay[Table[Tan[n], {n, 1, 25}]]]\)], "Input"],

Cell["\<\
Como puedes ver lo que hace el comando ListPlay[ ] es convertir los datos de \
la lista a n\[UAcute]meros reales comprendidos entre -1 y 1, pasar estos \
datos a la primitiva de sonido \"SampledSoundList\" y reproducirla con \
Show[Sound[SampledSoundList[ ]] ] ]. El objeto \"SampledSoundList\" es de la \
forma  \"SampledSoundList[lista,srate]\" su primer argumento es una lista de \
n\[UAcute]meros reales comprendidos entre -1 y 1 y su segundo argumento es la \
raz\[OAcute]n de muestreo, el n\[UAcute]mero de muestras que se convierten \
cada segundo para producir el sonido. \
\>", "Text"],

Cell["\<\
El objeto \"Sound\" que devuelve Play[ ] contiene como \[UAcute]nico elemento \
una primitiva de sonido que es \"SampledSoundFunction\" la cual se encarga de \
hacer, cada vez que se reproduce el sonido, la lista correspondiente de datos \
por medio de una funci\[OAcute]n compilada. Puedes comprobarlo ejecutando la \
siguiente celda.\
\>", "Text"],

Cell[BoxData[
    \(InputForm[Play[Sin[2\ \[Pi]\ 440\ \ x], {x, 0,  .5}]]\)], "Input"],

Cell[TextData[{
  "El objeto \"SampledSoundFunction\" es de la forma  \
\"SampledSoundFunction[funcioncompilada,n\.bademuestras,srate]\" su primer \
argumento es una funci\[OAcute]n compilada que crea el programa,  su segundo \
argumento es el n\[UAcute]mero de muestras que se obtendr\[AAcute]n y su \
tercer argumento es la raz\[OAcute]n de muestreo. Es m\[AAcute]s \
c\[OAcute]moda para trabajar la primitiva \"SampledSoundList\" que, aunque \
ocupa m\[AAcute]s memoria, contiene la lista de datos como parte de ella lo \
que permite usar los comandos propios de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para trabajar con listas. Por ejemplo, es inmediato revertir un sonido \
con el comando \"Reverse[ ]\" o extraer parte de \[EAcute]l o realizar un \
filtrado como veremos a continuaci\[OAcute]n."
}], "Text"],

Cell["\<\
El siguiente comando convierte un objeto \"SampledSoundFunction\" en \
\"SampledSoundList\". \
\>", "Text"],

Cell[BoxData[
    \(\(\(FunctionToList[
        sound_SampledSoundFunction]\)\(:=\)\(\[IndentingNewLine]\)\(Module[{\
samps}, \[IndentingNewLine]samps = 
          Array[sound[\([1]\)], sound[\([2]\)]];  (*\ 
          produce\ las\ muestras\ *) \[IndentingNewLine]samps /= \((Max[
                Abs[samps]] + 0.00001)\);  (*\ 
          las\ normaliza\ en\ el\ rango\ [\(-1\), 
              1]\ *) \[IndentingNewLine]Return[
          SampledSoundList[samps, sound[\([3]\)]]]]\)\( (*\ 
        las\ devuelve\ junto\ con\ la\ raz\[OAcute]n\ de\ muestreo\ *) \
\)\)\)], "Input"],

Cell[BoxData[
    \(\(sinfunc = 
        Play[Sin[2\ \[Pi]\ 1000\ t], {t, 0,  .05}, 
          SampleRate \[Rule] 22050];\)\)], "Input"],

Cell[BoxData[{
    \(\(sinlist = 
        FunctionToList[sinfunc[\([1]\)]];\)\), "\[IndentingNewLine]", 
    \(\(Show[Sound[sinlist]];\)\), "\[IndentingNewLine]", 
    \(Clear[sinfunc, sinlist]\)}], "Input"],

Cell["\<\
El siguiente comando se debe a Theodore Gray y reproduce una sucesi\[OAcute]n \
de sonidos sin interrupci\[OAcute]n entre ellos.\
\>", "Text"],

Cell[BoxData[{
    \(\(Attributes[
          CombinedSoundShow] = {HoldFirst};\)\), "\[IndentingNewLine]", 
    \(CombinedSoundShow[list_] := 
      Block[{tmplist}, \[IndentingNewLine]Block[{$DisplayFunction = 
              Identity, \ $SoundDisplayFunction = 
              Identity}, \[IndentingNewLine]\(tmplist = 
              list;\)]; \[IndentingNewLine]Show[
          Sound[Map[First, tmplist]]]]\)}], "Input"],

Cell[BoxData[
    \(CombinedSoundShow[{Play[Sin[2\ \[Pi]\ 440\ t], {t, 0, 0.25}], 
        Play[Sin[2\ \[Pi]\ 550\ t], {t, 0, 0.5}], 
        Play[Sin[2\ \[Pi]\ 880\ t], {t, 0,  .25}]}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trabajar con archivos de sonido", "Section"],

Cell[TextData[{
  "Puedes importar archivos de sonido con el comando \
Import[\"C:/archivo.ext\"] (debes dar la ruta completa del archivo o bien \
decir a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que trabaje en la carpeta donde est\[AAcute] el archivo lo que se hace \
con SetDirectory[ ]). Con esta cuaderno habr\[AAcute]s bajado el archivo \
pavrti.wav. Antes de seguir establece el directorio de trabajo."
}], "Text"],

Cell[BoxData[
    \(\(SetDirectory["\<D:/Trabajo/02_Docencia \
Informatica/Ingenieria_Informatica/Curso2006_2007/Calculo \
Avanzado/practicas/05_sonido/ \>"];\)\)], "Input"],

Cell[BoxData[
    \(\(\( (*\ 
      especifica\ aqu\[IAcute]\ la\ ruta\ al\ directorio\ que\ contiene\ el\ \
archivo\ pavrti . wav . \ 
          Por\ ejemplo\ \
*) \)\(\[IndentingNewLine]\)\(SetDirectory["\<C:/calculo_avanzado/Practicas\>\
"]\)\)\)], "Input"],

Cell[BoxData[
    \(\(\(\(\(turandot = 
          Import["\<pavrti.wav\>"]\) \);\)\( (*\ \[DownExclamation]no\ quites\
\ el\ ; ! \ *) \)\)\)], "Input"],

Cell[TextData[{
  "Puedes ver la forma en que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " representa el archivo importado como un objeto de sonido \"Sound\" que \
consta de una \[UAcute]nica primitiva \"SampledSoundList\"."
}], "Text"],

Cell[BoxData[
    \(\(\(Short[InputForm[turandot]]\)\( (*\ 
      observa\ que\ la\ tasa\ de\ muestreo\ es\ 8000\ *) \)\)\)], "Input"],

Cell["\<\
La lista de datos es el primer argumento de \"SampledSoundList\", es decir \
turandot[[1,1]]. Es demasiado grande para sacarlo en pantalla.\
\>", "Text"],

Cell[BoxData[
    \(Length[turandot[\([1, 1]\)]]\)], "Input"],

Cell["Pero podemos representarlo gr\[AAcute]ficamente con ListPlot[ ].", \
"Text"],

Cell[BoxData[
    \(\(ListPlot[turandot[\([1, 1]\)], PlotRange \[Rule] All];\)\)], "Input"],

Cell["\<\
Como ves son datos comprendidos entre -1 y 1 y su aspecto resulta familiar; \
recuerda las im\[AAcute]genes que salen en la grabadora de sonidos de \
Windows. Podemos reproducir el archivo.\
\>", "Text"],

Cell[BoxData[
    \(\(ListPlay[turandot[\([1, 1]\)]];\)\)], "Input"],

Cell["Tambi\[EAcute]n pdemos hacerlo directamente.", "Text"],

Cell[BoxData[
    \(\(Show[turandot];\)\)], "Input"],

Cell["\[DownQuestion]Tienes curiosidad por escucharlo de atr\[AAcute]s \
adelante?", "Text"],

Cell[BoxData[
    \(\(ListPlay[Reverse[turandot[\([1, 1]\)]]];\)\)], "Input"],

Cell["\[DownQuestion]C\[OAcute]mo sonar\[AAcute] el cuadrado?", "Text"],

Cell[BoxData[
    \(\(ListPlay[turandot[\([1, 1]\)]^2];\)\)], "Input"],

Cell["\<\
Pues suena bastante mal. Pero lo ya visto muestra las muchas posibilidades \
para trabajar con archivos de sonido. \
\>", "Text"],

Cell[TextData[{
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "tiene un paquete que es bastante \[UAcute]til para obtener informaci\
\[OAcute]n adicional de un archivo de sonido (al menos a partir de la versi\
\[OAcute]n 5, no s\[EAcute] si antes estaba  disponible). "
}], "Text"],

Cell["<< Miscellaneous`Audio`", "Input",
  CellTags->"S5.51.1"],

Cell[TextData[{
  "Este paquete carga, entre otros, el comando \
\"ReadSoundFile[\"archivo.ext\", PrintHeader",
  Cell[BoxData[
      \(TraditionalForm\` -> \)]],
  "True]\" que lee el archivo de sonido especificado y lo convierte en una \
lista de enteros comprendidos entre -32768 y +32767 (codificaci\[OAcute]n de \
16 bits). Adem\[AAcute]s, y esto es lo interesante, proporciona la informaci\
\[OAcute]n contenida en la cabecera del archivo."
}], "Text"],

Cell[BoxData[
    \(\(\(\(\(tosca = 
          ReadSoundFile["\<tosca.wav\>", 
            PrintHeader \[Rule] 
              True]\) \);\)\( (*\ \[DownExclamation]no\ quites\ el\ ; ! \ *) \
\)\)\)], "Input"],

Cell[TextData[{
  "El archivo importado lo representa ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " simplemente como una lista sin m\[AAcute]s informaci\[OAcute]n \
adicional."
}], "Text"],

Cell[BoxData[{
    \(Head[tosca]\), "\[IndentingNewLine]", 
    \(Short[InputForm[tosca]] (*\ 
      observa\ que\ no\ aparece\ la\ tasa\ de\ muestreo\ *) \)}], "Input"],

Cell["Podemos representar gr\[AAcute]ficamente la lista \"tosca\".", "Text"],

Cell[BoxData[
    \(\(ListPlot[tosca, PlotRange \[Rule] All];\)\)], "Input"],

Cell["\<\
Podemos escuchar la lista \"tosca\" especificando la raz\[OAcute]n de \
muestreo apropiada.\
\>", "Text"],

Cell[BoxData[
    \(\(ListPlay[tosca, SampleRate \[Rule] 16000];\)\)], "Input"],

Cell[TextData[{
  "Podemos exportar archivos de sonido en varios formatos con el comando \
\"Export[\"archivo.ext\",expr]\". Este comando est\[AAcute] disponible a \
partir de la versi\[OAcute]n 4 de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Dependiendo del tipo de conversi\[OAcute]n de datos que se haga se puede \
perder bastante calidad en el sonido. La forma apropiada de exportar un \
archivo de sonido depende tambi\[EAcute]n de la manera en que se import\
\[OAcute]. Un archivo importado con el comando Import[ ] puede exportarse en \
el mismo formato que se import\[OAcute] conservando la raz\[OAcute]n de \
muestreo y no se pierde calidad."
}], "Text"],

Cell[BoxData[
    \(\(Export["\<exporturandot.wav\>", turandot];\)\)], "Input"],

Cell["Podemos expotar una parte del archivo como sigue.", "Text"],

Cell[BoxData[
    RowBox[{
      TagBox[
        FrameBox[\(Export["\<shorturandot.wav\>", \[IndentingNewLine]Sound[
              SampledSoundList[Take[turandot[\([1, 1]\)], 32000], 8000]]]\),
          BoxFrame->False,
          BoxMargins->False],
        Short], ";"}]], "Input"],

Cell[BoxData[
    \(\(Show[Import["\<shorturandot.wav\>"]];\)\)], "Input"],

Cell["\<\
Para exportar un archivo de sonido formado por una lista de n\[UAcute]meros, \
obtenida con el comando ReadSoundFile[ ] o de otra forma, debemos especificar \
la raz\[OAcute]n de muestreo y normalizar los datos (por ejemplo, dividiendo \
por 32768) para situarlos en el intervalo [-1,1] pues si no hacemos esto se \
pierde mucha calidad de sonido.\
\>", "Text"],

Cell[BoxData[
    TagBox[
      FrameBox[\(Export["\<dolcibaci.wav\>", \[IndentingNewLine]Sound[
            SampledSoundList[N[Take[turandot, 64000]/32768], 16000]]]\),
        BoxFrame->False,
        BoxMargins->False],
      Short]], "Input"]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.51.1"->{
    Cell[14958, 406, 63, 1, 71, "Input",
      CellTags->"S5.51.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.51.1", 18910, 518}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 116, 5, 100, "Title"],
Cell[1873, 58, 154, 5, 102, "Author"],

Cell[CellGroupData[{
Cell[2052, 67, 130, 5, 93, "Section"],
Cell[2185, 74, 401, 11, 67, "Text"],
Cell[2589, 87, 44, 0, 71, "Definition"],
Cell[2636, 89, 970, 14, 197, "Text"],
Cell[3609, 105, 431, 7, 202, "Input"],
Cell[4043, 114, 334, 5, 150, "Input"],
Cell[4380, 121, 264, 5, 67, "Text"],
Cell[4647, 128, 313, 5, 154, "Input"],
Cell[4963, 135, 64, 0, 41, "Text"],
Cell[5030, 137, 92, 1, 72, "Input"],
Cell[5125, 140, 40, 0, 71, "Definition"],
Cell[5168, 142, 824, 12, 171, "Text"],
Cell[5995, 156, 267, 5, 67, "Text"],
Cell[6265, 163, 255, 4, 124, "Input"],
Cell[6523, 169, 111, 3, 41, "Text"],
Cell[6637, 174, 175, 3, 98, "Input"],
Cell[6815, 179, 219, 4, 67, "Text"],
Cell[7037, 185, 77, 1, 72, "Input"],
Cell[7117, 188, 144, 3, 41, "Text"],
Cell[7264, 193, 105, 2, 72, "Input"],
Cell[7372, 197, 128, 3, 41, "Text"],
Cell[7503, 202, 105, 2, 72, "Input"],
Cell[7611, 206, 96, 2, 71, "Definition"],
Cell[7710, 210, 356, 6, 93, "Text"],
Cell[8069, 218, 79, 1, 72, "Input"],
Cell[8151, 221, 604, 9, 145, "Text"],
Cell[8758, 232, 359, 6, 93, "Text"],
Cell[9120, 240, 86, 1, 72, "Input"],
Cell[9209, 243, 832, 14, 171, "Text"],
Cell[10044, 259, 117, 3, 41, "Text"],
Cell[10164, 264, 580, 11, 202, "Input"],
Cell[10747, 277, 136, 3, 72, "Input"],
Cell[10886, 282, 207, 4, 124, "Input"],
Cell[11096, 288, 152, 3, 41, "Text"],
Cell[11251, 293, 421, 8, 176, "Input"],
Cell[11675, 303, 198, 3, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11910, 311, 50, 0, 93, "Section"],
Cell[11963, 313, 438, 9, 93, "Text"],
Cell[12404, 324, 173, 3, 124, "Input"],
Cell[12580, 329, 260, 6, 124, "Input"],
Cell[12843, 337, 151, 3, 72, "Input"],
Cell[12997, 342, 250, 6, 67, "Text"],
Cell[13250, 350, 134, 2, 72, "Input"],
Cell[13387, 354, 163, 3, 67, "Text"],
Cell[13553, 359, 61, 1, 72, "Input"],
Cell[13617, 362, 82, 1, 41, "Text"],
Cell[13702, 365, 91, 1, 72, "Input"],
Cell[13796, 368, 213, 4, 67, "Text"],
Cell[14012, 374, 68, 1, 72, "Input"],
Cell[14083, 377, 60, 0, 41, "Text"],
Cell[14146, 379, 52, 1, 72, "Input"],
Cell[14201, 382, 92, 1, 41, "Text"],
Cell[14296, 385, 77, 1, 72, "Input"],
Cell[14376, 388, 71, 0, 41, "Text"],
Cell[14450, 390, 70, 1, 72, "Input"],
Cell[14523, 393, 139, 3, 41, "Text"],
Cell[14665, 398, 290, 6, 67, "Text"],
Cell[14958, 406, 63, 1, 71, "Input",
  CellTags->"S5.51.1"],
Cell[15024, 409, 458, 9, 93, "Text"],
Cell[15485, 420, 208, 5, 98, "Input"],
Cell[15696, 427, 201, 6, 41, "Text"],
Cell[15900, 435, 169, 3, 98, "Input"],
Cell[16072, 440, 76, 0, 41, "Text"],
Cell[16151, 442, 76, 1, 72, "Input"],
Cell[16230, 445, 115, 3, 41, "Text"],
Cell[16348, 450, 79, 1, 72, "Input"],
Cell[16430, 453, 680, 12, 145, "Text"],
Cell[17113, 467, 79, 1, 72, "Input"],
Cell[17195, 470, 65, 0, 41, "Text"],
Cell[17263, 472, 283, 7, 98, "Input"],
Cell[17549, 481, 74, 1, 72, "Input"],
Cell[17626, 484, 371, 6, 93, "Text"],
Cell[18000, 492, 246, 6, 98, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

