#!/usr/bin/env python
 
#        +-----------------------------------------------------------------------------+
#        | GPL                                                                         |
#        +-----------------------------------------------------------------------------+
#        | Copyright (c) Arturo Gonzalez Ferrer <arturogf@ugr.es>                      |
#        |                                                                             |
#        | This program is free software; you can redistribute it and/or               |
#        | modify it under the terms of the GNU General Public License                 |
#        | as published by the Free Software Foundation; either version 2              |
#        | of the License, or (at your option) any later version.                      |
#        |                                                                             |
#        | This program is distributed in the hope that it will be useful,             |
#        | but WITHOUT ANY WARRANTY; without even the implied warranty of              |
#        | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               |
#        | GNU General Public License for more details.                                |
#        |                                                                             |
#        | You should have received a copy of the GNU General Public License           |
#        | along with this program; if not, write to the Free Software                 |
#        | Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. |
#        +-----------------------------------------------------------------------------+

import sys
import pygtk
pygtk.require('2.0')
import gtk
import gtk.glade
import gnome.applet
import gnome.ui
import os.path
import re
import copy
import gobject
import pango
import pycentrino_globals as pglobals

class pycentrinoApplet(gnome.applet.Applet):
        
    def cleanup(self,event):
        del self.applet

    # add to history
    def add_to_history(self,element):
        if len(self.history) < self.history_max:
            self.history.append(list(element))
        else:
            self.history.pop()
            self.history.append(list(element))

    # function to compare only the values shown at the moment (checks[])
    def comp_history(self,actual):
        for i in range(len(actual)):
            if self.checks[i]:
                if actual[i] != self.history[len(self.history)-1][i]:
                    return True
        return False
                
                
    # function to see if any info has changed since last time in self.history queue
    def info_has_changed(self,actual):
        
        if self.comp_history(actual):
            return True
        else:
            return False
        
    # font definition
    def define_font(self):
        fd = pango.FontDescription()
        fd.set_family("Helvetica")
        fd.set_style(pango.STYLE_ITALIC)
        fd.set_weight(pango.WEIGHT_BOLD)
        fd.set_size(10 * pango.SCALE)
        return fd
        
    # this callback is for update the applet from system info every 1 second
    def timeout_callback(self,event):
        self.add_to_history(self.info)
        self.read_proc_info()
        
        if self.info_has_changed(self.info):

            # when we delete the children, they run out of references,
            # so the garbage collector must delete them totally
            for i in (self.box.get_children()):
                self.box.remove(i)

            cont = -1
            separate = 0
            # create the applet with little hboxes containing each info checked in the preferences
            for i in range(len(self.checks)):
                if self.checks[i]:
                    cont = cont + 1

                    self.box.pack_start(gtk.EventBox())

                    # add un hbox para meter contenido
                    self.box.get_children()[cont].add(gtk.HBox())

                    # metemos una etiqueta con un espacio
                    tmp = gtk.Label(" ")
                    self.box.get_children()[cont].get_children()[0].pack_start(tmp)

                    cont = cont + 1
                    self.box.pack_start(gtk.EventBox())

                    # add un hbox para meter contenido
                    self.box.get_children()[cont].add(gtk.HBox())
                    tooltip = gtk.Tooltips()
                    if i == 3:
                        tmp = gtk.Image()
                        if self.info[i] == "":
                            tooltip.set_tip(self.box.get_children()[cont], "no tiene soporte para cpufreq")
                            tmp.set_from_file(os.path.join(pglobals.image_dir,'warning.png'))
                            self.box.get_children()[cont].get_children()[0].pack_start(tmp)
                        if self.info[i] == "powersave":
                            tooltip.set_tip(self.box.get_children()[cont], "ahorro de energia")
                            tmp.set_from_file(os.path.join(pglobals.image_dir,'powersave.png'))
                            self.box.get_children()[cont].get_children()[0].pack_start(tmp)
                        elif self.info[i] == "performance":
                            tooltip.set_tip(self.box.get_children()[cont], "energia al maximo")
                            tmp.set_from_file(os.path.join(pglobals.image_dir,'performance.png'))
                            self.box.get_children()[cont].get_children()[0].pack_start(tmp)
                        elif self.info[i] == "userspace":
                            tooltip.set_tip(self.box.get_children()[cont], "Usando modo usuario")
                            tmp.set_from_file(os.path.join(pglobals.image_dir,'userspace.png'))
                            self.box.get_children()[cont].get_children()[0].pack_start(tmp)
                        else:
                            pass
                    # si metemos la informacion de que procesador es, metemos imagen correspondiente
                    elif i == 4:
                        tmp = gtk.Image()
                        if self.info[i] == "centrino":
                            tooltip.set_tip(self.box.get_children()[cont], "Centrino detectado")
                            tmp.set_from_file(os.path.join(pglobals.image_dir,'centrino_46.png'))
                            self.box.get_children()[cont].get_children()[0].pack_start(tmp)
                    else:
                        fd = self.define_font()
                        tmp = gtk.Label(self.info[i])
                        tmp.modify_font(fd)
                        self.box.get_children()[cont].get_children()[0].pack_start(tmp)
        
        self.applet.show_all()
        return 1

    # this callback is for the entry signal at the event boxes, to update the tooltip value
    def update_info(self,widget,event):
        self.read_proc_info()

    def change_orientation(self,arg1,data):
        self.orientation = self.applet.get_orient()

        if self.orientation == gnome.applet.ORIENT_UP or self.orientation == gnome.applet.ORIENT_DOWN:
            tmpbox = gtk.HBox()
        else:
            tmpbox = gtk.VBox()
        
        # reparent all the hboxes to the new tmpbox
        for i in (self.box.get_children()):
            i.reparent(tmpbox)

        # now remove the link between big_evbox and the box
        self.big_evbox.remove(self.big_evbox.get_children()[0])
        self.box = tmpbox
        self.big_evbox.add(self.box)
        self.applet.show_all()

    def on_okbutton2_clicked(self,widget):
        self.preferences.hide()

     # this callback is to create the context menu
    def button_clicked(self,widget,event):
        if event.type == gtk.gdk.BUTTON_PRESS and event.button == 1:
            pass
            #self.orientation = gnome.applet.ORIENT_LEFT
            #self.change_orientation()
    # this callback is to create the context menu
    def button_press(self,widget,event):
        if event.type == gtk.gdk.BUTTON_PRESS and event.button == 3:
            self.create_menu()
           
    
    # and this one to show the about box   
    def about_info(self,event,data=None):
        about = gnome.ui.About("CPU performance stats applet",pglobals.version,"GPL",\
                               "GNOME Applet to check throttling CPU states",["Arturo Gonzalez <arturogf@ugr.es>,Lorenzo Gil <lgs@sicem.biz>"],\
                               ["Arturo Gonzalez <arturogf@ugr.es>"],"Arturo Gonzalez <arturogf@ugr.es>",self.logo_pixbuf)
        about.show()

    # the preferences one
    def properties(self,event,data=None):
        self.preferences.show()
    
    # this function update the info extracted from /proc/acpi
    def read_proc_info(self):

        # cpu power in mhz

        if (os.path.isfile("/proc/cpuinfo")):
            f_proc = open("/proc/cpuinfo")
            for line in f_proc:
                try:
                    line.index("cpu MHz")
                    self.info[5] = line.strip().replace(" ","").split(":")[1]
                except ValueError:
                    pass
        else:
            self.checks
        
        # throttling support
        if (os.path.isfile("/proc/acpi/processor/CPU0/throttling")):
            f_throt = open("/proc/acpi/processor/CPU0/throttling","r")
            cont = 1

            for line in f_throt:
                if cont == 1:
                    tmp = re.split('\W+',line)
                    self.throttling_states = int(tmp[2])
                else:
                    # search for * and print self.info
                    try:
                        line.index("*")
                        tmp = line.strip().replace(" ","").replace("*","").split(":")
                        self.info[0] = tmp[0]
                        self.info[1] = str(100 - int(tmp[1][:-1])) + "%"
                        
                        #print self.info
                        break
                    except ValueError:
                        pass
                    
                cont = cont + 1
            f_throt.close()
        else:
            self.info[0] = ""
            self.info[1] = ""

        # power support
        if (os.path.isfile("/proc/acpi/processor/CPU0/power")):
            f_per = open("/proc/acpi/processor/CPU0/power","r")
            cont = 1

            for line in f_per:
                if cont == 1:
                    tmp = re.split('\W+',line)
                    self.active_cpu_state = tmp[2][1]
                else:
                    try:
                        line.index("*")
                        self.info[2] = line.strip().replace(" ","").replace("*","").split(":")[0]
                        #print self.info
                        break
                    except ValueError:
                        pass
                    
                cont = cont + 1
            f_per.close()
        else:
            self.info[2] = ""

        # 2.6 sys filesystem
        if (os.path.isfile("/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors")):
            f_sys = open("/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors")
            for line in f_sys:
                self.governors = re.split(" ", line)
            f_sys.close()
        else:
            self.governors = ""

            

        if (os.path.isfile("/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor")):
            f_sys = open("/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor")
            for line in f_sys:
                self.info[3] = line.strip()

            f_sys.close()
        else:
            self.info[3] = ""

        if (os.path.isfile("/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver")):
            f_sys = open("/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver")
            for line in f_sys:
                self.info[4] = line.strip()

            f_sys.close()
        else:
            self.info[4] = ""

    # this callback is to create a context menu with the second button
    def create_menu(self):
        self.applet.setup_menu(self.propxml,self.verbs,None)


    # preferences window callbacks 
    def on_properties_delete_event(self,widget,event):
        widget.hide()
        return gtk.TRUE

    # callbacks for the togglebuttons on the preferences window.

    def on_checkbutton1_toggled(self,widget):
        self.checks[0] = widget.get_active()

    def on_checkbutton2_toggled(self,widget):
        self.checks[1] = widget.get_active()

    def on_checkbutton3_toggled(self,widget):
        self.checks[2] = widget.get_active()

    def on_checkbutton4_toggled(self,widget):
        self.checks[3] = widget.get_active()

    def on_checkbutton5_toggled(self,widget):
        self.checks[4] = widget.get_active()

    def on_checkbutton6_toggled(self,widget):
        self.checks[5] = widget.get_active()


    # the __init__ method
    def __init__(self,applet,iid):

        # do it a gobject. Look at Lorenzo Gil tutorial about sub-classing gobject in Python
        self.__gobject_init__()

        # instance variable section
        self.info = ["T0","0%","C1","powersave","centrino",""]
        # history is a queue and will be managed with append() and pop()
        self.history_max = 20
        self.history = []
        self.history.append(list(self.info))
        self.timeout_interval = 1000        
        self.throttling_states = 0
        self.tooltip_text = ""
        self.checks = [0,1,0,1,1,1]
        self.orientation = gnome.applet.ORIENT_DOWN
        self.logo_pixbuf = None

        self.propxml="""
        <popup name="button3">
        <menuitem name="Item 1" verb="Props" label="_Preferences..." pixtype="stock" pixname="gtk-properties"/>
        <menuitem name="Item 2" verb="About" label="_About..." pixtype="stock" pixname="gnome-stock-about"/>
        </popup>
	"""
        
        self.verbs = [ ( "Props", self.properties ),
                       ( "About", self.about_info )  
	             ]
        self.logo_pixbuf 
        # initialize gnome application and set up all the gnome internals
        gnome.init(pglobals.name, pglobals.version)

        # create the logo from file centrino.gif
        self.logo_pixbuf = gtk.gdk.pixbuf_new_from_file(os.path.join(pglobals.image_dir,'centrino.gif'))

        # create the applet and the widgets
        self.applet = applet
        self.big_evbox = gtk.EventBox()
        self.big_evbox.connect("button-press-event",self.button_press)
        self.orientation = self.applet.get_orient()

        self.box = None
        # if we have an horizontal panel 
        if self.orientation == gnome.applet.ORIENT_UP or self.orientation == gnome.applet.ORIENT_DOWN:
            self.box = gtk.HBox()
        # if it's a vertical one
        else:
            self.box = gtk.VBox()

        self.big_evbox.add(self.box)
        # TODO: read preferences from gconf

        cont = -1
        # create the applet with little hboxes containing each info checked in the preferences
        for i in range(len(self.checks)):
            
            if self.checks[i]:
                cont = cont + 1
                self.box.pack_start(gtk.EventBox())
                
                # add un hbox para meter contenido
                self.box.get_children()[cont].add(gtk.HBox())
                # metemos una etiqueta con un espacio
                self.box.get_children()[cont].get_children()[0].pack_start(gtk.Label(" "))

                cont = cont +1
                self.box.pack_start(gtk.EventBox())
                tooltip = gtk.Tooltips()
                
                # add un hbox para meter contenido
                self.box.get_children()[cont].add(gtk.HBox())
                if i == 3:
                    tmp = gtk.Image()
                    if self.info[i] == "":
                        tooltip.set_tip(self.box.get_children()[cont], "no tiene soporte para scaling_governor")
                        tmp.set_from_file(os.path.join(pglobals.image_dir,'warning.png'))
                        self.box.get_children()[cont].get_children()[0].pack_start(tmp)
                    elif self.info[i] == "powersave":
                        tooltip.set_tip(self.box.get_children()[cont], "ahorro de energia")
                        tmp.set_from_file(os.path.join(pglobals.image_dir,'powersave.png'))
                        self.box.get_children()[cont].get_children()[0].pack_start(tmp)
                    elif self.info[i] == "performance":
                        tooltip.set_tip(self.box.get_children()[cont], "energia al maximo")
                        tmp.set_from_file(os.path.join(pglobals.image_dir,'performance.png'))
                        self.box.get_children()[cont].get_children()[0].pack_start(tmp)
                    elif self.info[i] == "userspace":
                        tooltip.set_tip(self.box.get_children()[cont], "Usando modo usuario")
                        tmp.set_from_file(os.path.join(pglobals.image_dir,'userspace.png'))
                        self.box.get_children()[cont].get_children()[0].pack_start(tmp)
                    else:
                        pass
                # si metemos la informacion de que procesador es, metemos imagen correspondiente
                elif i == 4:
                    tmp = gtk.Image()
                    if self.info[i] == "centrino":
                        tooltip.set_tip(self.box.get_children()[cont], "Centrino detectado")
                        tmp.set_from_file(os.path.join(pglobals.image_dir,'centrino_46.png'))
                        self.box.get_children()[cont].get_children()[0].pack_start(tmp)
                    elif self.info[i] == "speedstep":
                        tooltip.set_tip(self.box.get_children()[cont], "Speedstep detectado")
                        tmp.set_from_file(os.path.join(pglobals.image_dir,'speedstep_46.png'))
                        self.box.get_children()[cont].get_children()[0].pack_start(tmp)
                    else:
                        tooltip.set_tip(self.box.get_children()[cont], "Centrino/Speedstep not found")
                        tmp.set_from_file(os.path.join(pglobals.image_dir,'warning.png'))
                        self.box.get_children()[cont].get_children()[0].pack_start(tmp)
                else:
                    fd = self.define_font()
                    tmp = gtk.Label(self.info[i])
                    tmp.modify_font(fd)
                    self.box.get_children()[cont].get_children()[0].pack_start(tmp)

        self.box.show()
        self.applet.add(self.big_evbox)        

        # update info from filesystem
        gtk.timeout_add(self.timeout_interval,self.timeout_callback, self)
        
        # connect some signals to the applet
        self.applet.connect("button-press-event",self.button_clicked)
        self.applet.connect("change-orient",self.change_orientation)
        self.applet.connect("delete-event",self.cleanup)
        self.applet.show_all()

        # read the .glade file to construct the properties window
        wT = gtk.glade.XML(os.path.join(pglobals.glade_dir, "pycentrino.glade"))
        preferencesDialog = wT.get_widget('properties')
        self.preferences = preferencesDialog
        wT.signal_autoconnect(self)

gobject.type_register(pycentrinoApplet)

# bonobo factory of pycentrinoApplets
def pycentrino_applet_factory(applet, iid):
    pycentrinoApplet(applet,iid)
    return gtk.TRUE

# run it in a gtk window
if len(sys.argv) > 1 and sys.argv[1] == "run-in-window":
    main_window = gtk.Window(gtk.WINDOW_TOPLEVEL)
    main_window.set_title("Pycentrino Applet")
    main_window.connect("destroy", gtk.mainquit) 
    app = gnome.applet.Applet()
    pycentrino_applet_factory(app, None)
    app.reparent(main_window)
    main_window.show_all()
    gtk.main()
    sys.exit()

if __name__ == '__main__':
    gnome.applet.bonobo_factory("OAFIID:GNOME_PycentrinoApplet_Factory",
                                pycentrinoApplet.__gtype__, 
                                "hello", "0", pycentrino_applet_factory)

    
