#!/usr/bin/env python

#        +-----------------------------------------------------------------------------+
#        | GPL                                                                         |
#        +-----------------------------------------------------------------------------+
#        | Copyright (c) Arturo Gonzalez Ferrer <arturogf@ugr.es>                      |
#        |                                                                             |
#        | This program is free software; you can redistribute it and/or               |
#        | modify it under the terms of the GNU General Public License                 |
#        | as published by the Free Software Foundation; either version 2              |
#        | of the License, or (at your option) any later version.                      |
#        |                                                                             |
#        | This program is distributed in the hope that it will be useful,             |
#        | but WITHOUT ANY WARRANTY; without even the implied warranty of              |
#        | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               |
#        | GNU General Public License for more details.                                |
#        |                                                                             |
#        | You should have received a copy of the GNU General Public License           |
#        | along with this program; if not, write to the Free Software                 |
#        | Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. |
#        +-----------------------------------------------------------------------------+

import sys
import pygtk
pygtk.require('2.0')
import gtk
import gtk.glade
import gnome.applet
import gnome.ui
import os.path
import re
import gobject
import pycentrino_globals as pglobals

# the class inherits from gnome.applet.Applet and we'll create it as a gobject (see __init__())
class pycentrinoApplet(gnome.applet.Applet):
        
    def cleanup(self,event):
        del self.applet
    
    # this callback is for update the applet from system info every 1 second
    def timeout_callback(self,event):
        return 0

    # this callback is for the entry signal at the event boxes, to update the tooltip value
    def update_info(self,widget,event):
        info = self.read_proc_info();
        self.tooltips.set_tip(self.box, info[0] + " " + info[1]);

    def change_orientation(self,arg1,data):
        self.orientation = self.applet.get_orient()
        # first remove the children of the current box
        for i in range(len(self.numbers)):
            self.box.remove(self.numbers[i])

        # now remove the box itself
        self.big_evbox.remove(self.box)

        # time to create the new box
        if self.orientation == gnome.applet.ORIENT_UP or self.orientation == gnome.applet.ORIENT_DOWN:
            self.box = gtk.HBox()
        else:
            self.box = gtk.VBox()

        # and now fill it with the numbers
        for i in range(len(self.numbers)):
            self.box.pack_start(self.numbers[i])

        # final steps
        self.big_evbox.add(self.box)
        self.box.show()

    # this callback is to create the context menu
    def button_press(self,widget,event):
        if event.type == gtk.gdk.BUTTON_PRESS and event.button == 3:
            self.create_menu()
            
    
    # and this one to show the about box   
    def about_info(self,event,data=None):
        about = gnome.ui.About("CPU performance stats applet","0.2","GPL","GNOME Applet to check throttling CPU states",["Arturo Gonzalez <arturogf@ugr.es>"],\
                               ["Arturo Gonzalez <arturogf@ugr.es>"],"Arturo Gonzalez <arturogf@ugr.es>",self.logo_pixbuf)
        about.show()

    # the preferences one
    def properties(self,event,data=None):
        self.preferences.show()
    
    # this function update the info extracted from /proc/acpi
    def read_proc_info(self):

        # throttling support
        if (os.path.isfile("/proc/acpi/processor/CPU0/throttling")):
            f_throt = open("/proc/acpi/processor/CPU0/throttling","r");
            cont = 1;

            for line in f_throt:
                if cont == 1:
                    tmp = re.split('\W+',line)
                    self.throttling_states = int(tmp[2])
                else:
                    if cont == 2:
                        tmp = re.split('\W+', line)
                        self.active_t_state = int(tmp[2][1])
                    else:
                        break
                cont = cont + 1
                    
            f_throt.close()
        else:
            self.lack_t_acpi = 1

        # power support
        if (os.path.isfile("/proc/acpi/processor/CPU0/power")):
            f_per = open("/proc/acpi/processor/CPU0/power","r");
            cont = 1;

            for line in f_per:
                if cont == 1:
                    tmp = re.split('\W+',line)
                    self.active_cpu_state = tmp[2][1]
                else:
                    if cont == 3:
                        tmp = re.split('\W+', line)
                        self.bus_activity = tmp[3]
                    else:
                        if cont != 2:
                            break

                cont = cont + 1
                    
            f_per.close()
        else:
            self.lack_p_acpi = 1

        # we return a tuple. In case there is no support, return a error string to be shown
        if self.lack_t_acpi and self.lack_p_acpi:
            return ("lack of throttling acpi support","lack of power acpi support")
        else:
            if self.lack_t_acpi:
                return ("lack of throttling acpi support","")
            else:
                if self.lack_p_acpi:
                   return("","lack of power acpi support")
                else:
                    return("","")


    # this callback is to create a context menu with the second button
    def create_menu(self):
        self.applet.setup_menu(self.propxml,self.verbs,None)


    # preferences window callbacks 
    def on_properties_delete_event(self,widget,event):
        widget.hide()
        return gtk.TRUE

    # callbacks for the togglebuttons on the preferences window. It just prints out the info of the checks vector
    def on_checkbutton1_toggled(self,widget):
        self.checks[0] = widget.get_active()
        print self.checks
    def on_checkbutton2_toggled(self,widget):
        self.checks[1] = widget.get_active()
        print self.checks
    def on_checkbutton3_toggled(self,widget):
        self.checks[2] = widget.get_active()
        print self.checks
    def on_checkbutton4_toggled(self,widget):
        self.checks[3] = widget.get_active()
        print self.checks
    def on_checkbutton5_toggled(self,widget):
        self.checks[4] = widget.get_active()
        print self.checks

    # the __init__ method
    def __init__(self,applet,iid):

        # do it a gobject. Look at Lorenzo Gil tutorial about sub-classing gobject in Python
        self.__gobject_init__()

        # instance variable section
        self.timeout_interval = 1000        
        self.throttling_states = 0
        self.active_t_state = "T0"
        self.bus_activity = ""
        self.actual_cpu_state = "C1"
        self.lack_t_acpi = 0
        self.lack_p_acpi = 0
        self.prueba = {}
        self.tooltip_text = ""
        self.checks = [0,0,0,0,0]
        self.orientation = gnome.applet.ORIENT_UP
        self.numbers = []

        self.propxml="""
        <popup name="button3">
        <menuitem name="Item 1" verb="Props" label="_Preferences..." pixtype="stock" pixname="gtk-properties"/>
        <menuitem name="Item 2" verb="About" label="_About..." pixtype="stock" pixname="gnome-stock-about"/>
        </popup>
	"""
        
        self.verbs = [ ( "Props", self.properties ),
                       ( "About", self.about_info )  
	             ]

        # initialize gnome application and set up all the gnome internals
        gnome.init(pglobals.name, pglobals.version)

        # create the logo from file centrino.gif
        self.logo = gtk.Image()
        self.logo.set_from_file(os.path.join(pglobals.image_dir,'centrino.gif'))
        self.logo_pixbuf = self.logo.get_pixbuf()

        # fill the numbers vector with images of numbers
        for i in range(10):
            self.numbers.append(gtk.Image())
            self.numbers[i].set_from_file(os.path.join(pglobals.image_dir,'green_led_%d.gif' % i))

        # create the applet and the widgets
        self.applet = applet
        self.tooltips = gtk.Tooltips()
        self.big_evbox = gtk.EventBox()
        self.big_evbox.connect("button-press-event",self.button_press)
        self.big_evbox.connect("enter-notify-event", self.update_info)
        self.box = None

        self.orientation = applet.get_orient()

        # if we have an horizontal panel if self.orientation ==
        if self.orientation == gnome.applet.ORIENT_UP or self.orientation == gnome.applet.ORIENT_DOWN:
            self.box = gtk.HBox()
        # if it's a vertical one
        else:
            self.box = gtk.VBox()

        # now add the numbers to the box
        for i in range(len(self.numbers)):
            self.box.pack_start(self.numbers[i])

        self.big_evbox.add(self.box)

        self.applet.add(self.big_evbox)        

        # update info from filesystem
        gtk.timeout_add(self.timeout_interval,self.timeout_callback, self)
        
        # connect some signals to the applet
        self.applet.connect("change-orient",self.change_orientation)
        self.applet.connect("destroy",self.cleanup)
        self.applet.show_all()

        # read the .glade file to construct the properties window
        wT = gtk.glade.XML(os.path.join(pglobals.glade_dir, "pycentrino.glade"))
        preferencesDialog = wT.get_widget('properties')
        self.preferences = preferencesDialog
        wT.signal_autoconnect(self)

gobject.type_register(pycentrinoApplet)

# bonobo factory of pycentrinoApplets
def pycentrino_applet_factory(applet, iid):
    pycentrinoApplet(applet,iid)
    return gtk.TRUE

# run it in a gtk window
if len(sys.argv) > 1 and sys.argv[1] == "run-in-window":
    main_window = gtk.Window(gtk.WINDOW_TOPLEVEL)
    main_window.set_title("Pycentrino Applet")
    main_window.connect("destroy", gtk.mainquit) 
    app = gnome.applet.Applet()
    pycentrino_applet_factory(app, None)
    app.reparent(main_window)
    main_window.show_all()
    gtk.main()
    sys.exit()

if __name__ == '__main__':
    gnome.applet.bonobo_factory("OAFIID:GNOME_PycentrinoApplet_Factory",
                                pycentrinoApplet.__gtype__, 
                                "hello", "0", pycentrino_applet_factory)

    
